/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.terminologies;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r4.formats.JsonParser;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.terminologies.ValueSetExpander;
import org.hl7.fhir.r4.terminologies.ValueSetExpanderFactory;
import org.hl7.fhir.r4.terminologies.ValueSetExpanderSimple;
import org.hl7.fhir.r4.utils.ToolingExtensions;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;

public class ValueSetExpansionCache
implements ValueSetExpanderFactory {
    private static final String VS_ID_EXT = "http://tools/cache";
    private final Map<String, ValueSetExpander.ValueSetExpansionOutcome> expansions = new HashMap<String, ValueSetExpander.ValueSetExpansionOutcome>();
    private final Map<String, MetadataResource> canonicals = new HashMap<String, MetadataResource>();
    private final IWorkerContext context;
    private final String cacheFolder;
    private Object lock;

    public ValueSetExpansionCache(IWorkerContext context, Object lock) {
        this.cacheFolder = null;
        this.lock = lock;
        this.context = context;
    }

    public ValueSetExpansionCache(IWorkerContext context, String cacheFolder, Object lock) throws FHIRFormatError, IOException {
        this.context = context;
        this.cacheFolder = cacheFolder;
        this.lock = lock;
        if (this.cacheFolder != null) {
            this.loadCache();
        }
    }

    private String makeFileName(String url) {
        return url.replace("$", "").replace(":", "").replace("|", ".").replace("//", "/").replace("/", "_") + ".xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCache() throws FHIRFormatError, IOException {
        File[] files;
        for (File f : files = new File(this.cacheFolder).listFiles()) {
            if (!f.getName().endsWith(".xml")) continue;
            FileInputStream is = new FileInputStream(f);
            try {
                Resource r = this.context.newXmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).parse(is);
                if (r instanceof OperationOutcome) {
                    OperationOutcome oo = (OperationOutcome)r;
                    this.expansions.put(ToolingExtensions.getExtension(oo, VS_ID_EXT).getValue().toString(), new ValueSetExpander.ValueSetExpansionOutcome(new XhtmlComposer(true, false).composePlainText(oo.getText().getDiv()), ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN));
                    continue;
                }
                if (r instanceof ValueSet) {
                    ValueSet vs = (ValueSet)r;
                    if (vs.hasExpansion()) {
                        this.expansions.put(vs.getUrl(), new ValueSetExpander.ValueSetExpansionOutcome(vs));
                        continue;
                    }
                    this.canonicals.put(vs.getUrl(), vs);
                    if (!vs.hasVersion()) continue;
                    this.canonicals.put(vs.getUrl() + "|" + vs.getVersion(), vs);
                    continue;
                }
                if (!(r instanceof MetadataResource)) continue;
                MetadataResource md = (MetadataResource)r;
                this.canonicals.put(md.getUrl(), md);
                if (!md.hasVersion()) continue;
                this.canonicals.put(md.getUrl() + "|" + md.getVersion(), md);
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        }
    }

    @Override
    public ValueSetExpander getExpander() {
        return new CacheAwareExpander();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataResource getStoredResource(String canonicalUri) {
        Object object = this.lock;
        synchronized (object) {
            return this.canonicals.get(canonicalUri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeResource(MetadataResource md) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.canonicals.put(md.getUrl(), md);
            if (md.hasVersion()) {
                this.canonicals.put(md.getUrl() + "|" + md.getVersion(), md);
            }
        }
        if (this.cacheFolder != null) {
            FileOutputStream s2 = new FileOutputStream(Utilities.path(this.cacheFolder, this.makeFileName(md.getUrl() + "|" + md.getVersion())));
            this.context.newXmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s2, md);
            s2.close();
        }
    }

    public class CacheAwareExpander
    implements ValueSetExpander {
        @Override
        public ValueSetExpander.ValueSetExpansionOutcome expand(ValueSet source, Parameters expParams) throws ValueSetExpander.ETooCostly, IOException {
            String cacheKey = this.makeCacheKey(source, expParams);
            if (ValueSetExpansionCache.this.expansions.containsKey(cacheKey)) {
                return (ValueSetExpander.ValueSetExpansionOutcome)ValueSetExpansionCache.this.expansions.get(cacheKey);
            }
            ValueSetExpanderSimple vse = new ValueSetExpanderSimple(ValueSetExpansionCache.this.context);
            ValueSetExpander.ValueSetExpansionOutcome vso = vse.expand(source, expParams);
            if (vso.getError() != null) {
                vso = ValueSetExpansionCache.this.context.expandVS(source, false, expParams == null || !expParams.getParameterBool("excludeNested"));
                if (ValueSetExpansionCache.this.cacheFolder != null) {
                    FileOutputStream s2 = new FileOutputStream(Utilities.path(ValueSetExpansionCache.this.cacheFolder, ValueSetExpansionCache.this.makeFileName(source.getUrl())));
                    ValueSetExpansionCache.this.context.newXmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s2, vso.getValueset());
                    s2.close();
                }
            }
            if (vso.getValueset() != null) {
                ValueSetExpansionCache.this.expansions.put(cacheKey, vso);
            }
            return vso;
        }

        private String makeCacheKey(ValueSet source, Parameters expParams) throws IOException {
            if (expParams == null) {
                return source.getUrl();
            }
            JsonParser p = new JsonParser();
            String r = p.composeString(expParams);
            return source.getUrl() + " " + r.hashCode();
        }
    }
}

