/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.EventResourceTypes;

public class EventResourceTypesEnumFactory
implements EnumFactory<EventResourceTypes> {
    @Override
    public EventResourceTypes fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("ChargeItem".equals(codeString)) {
            return EventResourceTypes.CHARGEITEM;
        }
        if ("ClaimResponse".equals(codeString)) {
            return EventResourceTypes.CLAIMRESPONSE;
        }
        if ("ClinicalImpression".equals(codeString)) {
            return EventResourceTypes.CLINICALIMPRESSION;
        }
        if ("Communication".equals(codeString)) {
            return EventResourceTypes.COMMUNICATION;
        }
        if ("Composition".equals(codeString)) {
            return EventResourceTypes.COMPOSITION;
        }
        if ("Condition".equals(codeString)) {
            return EventResourceTypes.CONDITION;
        }
        if ("Consent".equals(codeString)) {
            return EventResourceTypes.CONSENT;
        }
        if ("Coverage".equals(codeString)) {
            return EventResourceTypes.COVERAGE;
        }
        if ("DeviceUseStatement".equals(codeString)) {
            return EventResourceTypes.DEVICEUSESTATEMENT;
        }
        if ("DiagnosticReport".equals(codeString)) {
            return EventResourceTypes.DIAGNOSTICREPORT;
        }
        if ("DocumentManifest".equals(codeString)) {
            return EventResourceTypes.DOCUMENTMANIFEST;
        }
        if ("DocumentReference".equals(codeString)) {
            return EventResourceTypes.DOCUMENTREFERENCE;
        }
        if ("Encounter".equals(codeString)) {
            return EventResourceTypes.ENCOUNTER;
        }
        if ("EnrollmentResponse".equals(codeString)) {
            return EventResourceTypes.ENROLLMENTRESPONSE;
        }
        if ("EpisodeOfCare".equals(codeString)) {
            return EventResourceTypes.EPISODEOFCARE;
        }
        if ("ExplanationOfBenefit".equals(codeString)) {
            return EventResourceTypes.EXPLANATIONOFBENEFIT;
        }
        if ("FamilyMemberHistory".equals(codeString)) {
            return EventResourceTypes.FAMILYMEMBERHISTORY;
        }
        if ("GuidanceResponse".equals(codeString)) {
            return EventResourceTypes.GUIDANCERESPONSE;
        }
        if ("ImagingStudy".equals(codeString)) {
            return EventResourceTypes.IMAGINGSTUDY;
        }
        if ("Immunization".equals(codeString)) {
            return EventResourceTypes.IMMUNIZATION;
        }
        if ("MeasureReport".equals(codeString)) {
            return EventResourceTypes.MEASUREREPORT;
        }
        if ("Media".equals(codeString)) {
            return EventResourceTypes.MEDIA;
        }
        if ("MedicationAdministration".equals(codeString)) {
            return EventResourceTypes.MEDICATIONADMINISTRATION;
        }
        if ("MedicationDispense".equals(codeString)) {
            return EventResourceTypes.MEDICATIONDISPENSE;
        }
        if ("MedicationStatement".equals(codeString)) {
            return EventResourceTypes.MEDICATIONSTATEMENT;
        }
        if ("Observation".equals(codeString)) {
            return EventResourceTypes.OBSERVATION;
        }
        if ("PaymentNotice".equals(codeString)) {
            return EventResourceTypes.PAYMENTNOTICE;
        }
        if ("PaymentReconciliation".equals(codeString)) {
            return EventResourceTypes.PAYMENTRECONCILIATION;
        }
        if ("Procedure".equals(codeString)) {
            return EventResourceTypes.PROCEDURE;
        }
        if ("ProcessResponse".equals(codeString)) {
            return EventResourceTypes.PROCESSRESPONSE;
        }
        if ("QuestionnaireResponse".equals(codeString)) {
            return EventResourceTypes.QUESTIONNAIRERESPONSE;
        }
        if ("RiskAssessment".equals(codeString)) {
            return EventResourceTypes.RISKASSESSMENT;
        }
        if ("SupplyDelivery".equals(codeString)) {
            return EventResourceTypes.SUPPLYDELIVERY;
        }
        if ("Task".equals(codeString)) {
            return EventResourceTypes.TASK;
        }
        throw new IllegalArgumentException("Unknown EventResourceTypes code '" + codeString + "'");
    }

    @Override
    public String toCode(EventResourceTypes code) {
        if (code == EventResourceTypes.CHARGEITEM) {
            return "ChargeItem";
        }
        if (code == EventResourceTypes.CLAIMRESPONSE) {
            return "ClaimResponse";
        }
        if (code == EventResourceTypes.CLINICALIMPRESSION) {
            return "ClinicalImpression";
        }
        if (code == EventResourceTypes.COMMUNICATION) {
            return "Communication";
        }
        if (code == EventResourceTypes.COMPOSITION) {
            return "Composition";
        }
        if (code == EventResourceTypes.CONDITION) {
            return "Condition";
        }
        if (code == EventResourceTypes.CONSENT) {
            return "Consent";
        }
        if (code == EventResourceTypes.COVERAGE) {
            return "Coverage";
        }
        if (code == EventResourceTypes.DEVICEUSESTATEMENT) {
            return "DeviceUseStatement";
        }
        if (code == EventResourceTypes.DIAGNOSTICREPORT) {
            return "DiagnosticReport";
        }
        if (code == EventResourceTypes.DOCUMENTMANIFEST) {
            return "DocumentManifest";
        }
        if (code == EventResourceTypes.DOCUMENTREFERENCE) {
            return "DocumentReference";
        }
        if (code == EventResourceTypes.ENCOUNTER) {
            return "Encounter";
        }
        if (code == EventResourceTypes.ENROLLMENTRESPONSE) {
            return "EnrollmentResponse";
        }
        if (code == EventResourceTypes.EPISODEOFCARE) {
            return "EpisodeOfCare";
        }
        if (code == EventResourceTypes.EXPLANATIONOFBENEFIT) {
            return "ExplanationOfBenefit";
        }
        if (code == EventResourceTypes.FAMILYMEMBERHISTORY) {
            return "FamilyMemberHistory";
        }
        if (code == EventResourceTypes.GUIDANCERESPONSE) {
            return "GuidanceResponse";
        }
        if (code == EventResourceTypes.IMAGINGSTUDY) {
            return "ImagingStudy";
        }
        if (code == EventResourceTypes.IMMUNIZATION) {
            return "Immunization";
        }
        if (code == EventResourceTypes.MEASUREREPORT) {
            return "MeasureReport";
        }
        if (code == EventResourceTypes.MEDIA) {
            return "Media";
        }
        if (code == EventResourceTypes.MEDICATIONADMINISTRATION) {
            return "MedicationAdministration";
        }
        if (code == EventResourceTypes.MEDICATIONDISPENSE) {
            return "MedicationDispense";
        }
        if (code == EventResourceTypes.MEDICATIONSTATEMENT) {
            return "MedicationStatement";
        }
        if (code == EventResourceTypes.OBSERVATION) {
            return "Observation";
        }
        if (code == EventResourceTypes.PAYMENTNOTICE) {
            return "PaymentNotice";
        }
        if (code == EventResourceTypes.PAYMENTRECONCILIATION) {
            return "PaymentReconciliation";
        }
        if (code == EventResourceTypes.PROCEDURE) {
            return "Procedure";
        }
        if (code == EventResourceTypes.PROCESSRESPONSE) {
            return "ProcessResponse";
        }
        if (code == EventResourceTypes.QUESTIONNAIRERESPONSE) {
            return "QuestionnaireResponse";
        }
        if (code == EventResourceTypes.RISKASSESSMENT) {
            return "RiskAssessment";
        }
        if (code == EventResourceTypes.SUPPLYDELIVERY) {
            return "SupplyDelivery";
        }
        if (code == EventResourceTypes.TASK) {
            return "Task";
        }
        return "?";
    }

    @Override
    public String toSystem(EventResourceTypes code) {
        return code.getSystem();
    }
}

