/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CareTeam;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DiagnosticReport;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.EpisodeOfCare;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Provenance;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.Signature;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Substance;
import org.hl7.fhir.r4.model.TimeType;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Contract", profile="http://hl7.org/fhir/StructureDefinition/Contract")
public class Contract
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contract number", formalDefinition="Unique identifier for this Contract or a derivative that references a Source Contract.")
    protected List<Identifier> identifier;
    @Child(name="url", type={UriType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Basal definition", formalDefinition="Canonical identifier for this contract, represented as a URI (globally unique).")
    protected UriType url;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business edition", formalDefinition="An edition identifier used for business purposes to label business significant variants.")
    protected StringType version;
    @Child(name="status", type={CodeType.class}, order=3, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="amended | appended | cancelled | disputed | entered-in-error | executable | executed | negotiable | offered | policy | rejected | renewed | revoked | resolved | terminated", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-status")
    protected Enumeration<ContractStatus> status;
    @Child(name="legalState", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Negotiation status", formalDefinition="Legal states of the formation of a legal instrument, which is a formally executed written document that can be formally attributed to its author, records and formally expresses a legally enforceable act, process, or contractual duty, obligation, or right, and therefore evidences that act, process, or agreement.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-legalstate")
    protected CodeableConcept legalState;
    @Child(name="instantiatesCanonical", type={Contract.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Source Contract Definition", formalDefinition="The URL pointing to a FHIR-defined Contract Definition that is adhered to in whole or part by this Contract.")
    protected Reference instantiatesCanonical;
    protected Contract instantiatesCanonicalTarget;
    @Child(name="instantiatesUri", type={UriType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="External Contract Definition", formalDefinition="The URL pointing to an externally maintained definition that is adhered to in whole or in part by this Contract.")
    protected UriType instantiatesUri;
    @Child(name="contentDerivative", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Content derived from the basal information", formalDefinition="The minimal content derived from the basal information source at a specific stage in its lifecycle.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-content-derivative")
    protected CodeableConcept contentDerivative;
    @Child(name="issued", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When this Contract was issued", formalDefinition="When this  Contract was issued.")
    protected DateTimeType issued;
    @Child(name="applies", type={Period.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Effective time", formalDefinition="Relevant time or time-period when this Contract is applicable.")
    protected Period applies;
    @Child(name="expirationType", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Contract cessation cause", formalDefinition="Event resulting in discontinuation or termination of this Contract instance by one or more parties to the contract.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-expiration-type")
    protected CodeableConcept expirationType;
    @Child(name="subject", type={Reference.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contract Target Entity", formalDefinition="The target entity impacted by or of interest to parties to the agreement.")
    protected List<Reference> subject;
    protected List<Resource> subjectTarget;
    @Child(name="authority", type={Organization.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Authority under which this Contract has standing", formalDefinition="A formally or informally recognized grouping of people, principals, organizations, or jurisdictions formed for the purpose of achieving some form of collective action such as the promulgation, administration and enforcement of contracts and policies.")
    protected List<Reference> authority;
    protected List<Organization> authorityTarget;
    @Child(name="domain", type={Location.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A sphere of control governed by an authoritative jurisdiction, organization, or person", formalDefinition="Recognized governance framework or system operating with a circumscribed scope in accordance with specified principles, policies, processes or procedures for managing rights, actions, or behaviors of parties or principals relative to resources.")
    protected List<Reference> domain;
    protected List<Location> domainTarget;
    @Child(name="site", type={Location.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Specific Location", formalDefinition="Sites in which the contract is complied with,  exercised, or in force.")
    protected List<Reference> site;
    protected List<Location> siteTarget;
    @Child(name="name", type={StringType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Computer friendly designation", formalDefinition="A natural language name identifying this Contract definition, derivative, or instance in any legal state. Provides additional information about its content. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human Friendly name", formalDefinition="A short, descriptive, user-friendly title for this Contract definition, derivative, or instance in any legal state.t giving additional information about its content.")
    protected StringType title;
    @Child(name="subtitle", type={StringType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Subordinate Friendly name", formalDefinition="An explanatory or alternate user-friendly title for this Contract definition, derivative, or instance in any legal state.t giving additional information about its content.")
    protected StringType subtitle;
    @Child(name="alias", type={StringType.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Acronym or short name", formalDefinition="Alternative representation of the title for this Contract definition, derivative, or instance in any legal state., e.g., a domain specific contract number related to legislation.")
    protected List<StringType> alias;
    @Child(name="author", type={Patient.class, Practitioner.class, PractitionerRole.class, Organization.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Source of Contract", formalDefinition="The individual or organization that authored the Contract definition, derivative, or instance in any legal state.")
    protected Reference author;
    protected Resource authorTarget;
    @Child(name="scope", type={CodeableConcept.class}, order=20, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Range of Legal Concerns", formalDefinition="A selector of legal concerns for this Contract definition, derivative, or instance in any legal state.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-scope")
    protected CodeableConcept scope;
    @Child(name="topic", type={CodeableConcept.class, Reference.class}, order=21, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Focus of contract interest", formalDefinition="Narrows the range of legal concerns to focus on the achievement of specific contractual objectives.")
    protected Type topic;
    @Child(name="type", type={CodeableConcept.class}, order=22, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Legal instrument category", formalDefinition="A high-level category for the legal instrument, whether constructed as a Contract definition, derivative, or instance in any legal state.  Provides additional information about its content within the context of the Contract's scope to distinguish the kinds of systems that would be interested in the contract.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-type")
    protected CodeableConcept type;
    @Child(name="subType", type={CodeableConcept.class}, order=23, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Subtype within the context of type", formalDefinition="Sub-category for the Contract that distinguishes the kinds of systems that would be interested in the Contract within the context of the Contract's scope.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-subtype")
    protected List<CodeableConcept> subType;
    @Child(name="contentDefinition", type={}, order=24, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Contract precursor content", formalDefinition="Precusory content developed with a focus and intent of supporting the formation a Contract instance, which may be associated with and transformable into a Contract.")
    protected ContentDefinitionComponent contentDefinition;
    @Child(name="term", type={}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract Term List", formalDefinition="One or more Contract Provisions, which may be related and conveyed as a group, and may contain nested groups.")
    protected List<TermComponent> term;
    @Child(name="supportingInfo", type={Reference.class}, order=26, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Extra Information", formalDefinition="Information that may be needed by/relevant to the performer in their execution of this term action.")
    protected List<Reference> supportingInfo;
    protected List<Resource> supportingInfoTarget;
    @Child(name="relevantHistory", type={Provenance.class}, order=27, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Key event in Contract History", formalDefinition="Links to Provenance records for past versions of this Contract definition, derivative, or instance, which identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the Contract.  The Provence.entity indicates the target that was changed in the update. http://build.fhir.org/provenance-definitions.html#Provenance.entity.")
    protected List<Reference> relevantHistory;
    protected List<Provenance> relevantHistoryTarget;
    @Child(name="signer", type={}, order=28, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract Signatory", formalDefinition="Parties with legal standing in the Contract, including the principal parties, the grantor(s) and grantee(s), which are any person or organization bound by the contract, and any ancillary parties, which facilitate the execution of the contract such as a notary or witness.")
    protected List<SignatoryComponent> signer;
    @Child(name="friendly", type={}, order=29, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract Friendly Language", formalDefinition="The \"patient friendly language\" versionof the Contract in whole or in parts. \"Patient friendly language\" means the representation of the Contract and Contract Provisions in a manner that is readily accessible and understandable by a layperson in accordance with best practices for communication styles that ensure that those agreeing to or signing the Contract understand the roles, actions, obligations, responsibilities, and implication of the agreement.")
    protected List<FriendlyLanguageComponent> friendly;
    @Child(name="legal", type={}, order=30, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract Legal Language", formalDefinition="List of Legal expressions or representations of this Contract.")
    protected List<LegalLanguageComponent> legal;
    @Child(name="rule", type={}, order=31, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Computable Contract Language", formalDefinition="List of Computable Policy Rule Language Representations of this Contract.")
    protected List<ComputableLanguageComponent> rule;
    @Child(name="legallyBinding", type={Attachment.class, Composition.class, DocumentReference.class, QuestionnaireResponse.class, Contract.class}, order=32, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Binding Contract", formalDefinition="Legally binding Contract: This is the signed and legally recognized representation of the Contract, which is considered the \"source of truth\" and which would be the basis for legal action related to enforcement of this Contract.")
    protected Type legallyBinding;
    private static final long serialVersionUID = -1388892487L;
    @SearchParamDefinition(name="identifier", path="Contract.identifier", description="The identity of the contract", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="instantiates", path="Contract.instantiatesUri", description="A source definition of the contract", type="uri")
    public static final String SP_INSTANTIATES = "instantiates";
    public static final UriClientParam INSTANTIATES = new UriClientParam("instantiates");
    @SearchParamDefinition(name="patient", path="Contract.subject.where(resolve() is Patient)", description="The identity of the subject of the contract (if a patient)", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Contract:patient").toLocked();
    @SearchParamDefinition(name="subject", path="Contract.subject", description="The identity of the subject of the contract", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Contract:subject").toLocked();
    @SearchParamDefinition(name="authority", path="Contract.authority", description="The authority of the contract", type="reference", target={Organization.class})
    public static final String SP_AUTHORITY = "authority";
    public static final ReferenceClientParam AUTHORITY = new ReferenceClientParam("authority");
    public static final Include INCLUDE_AUTHORITY = new Include("Contract:authority").toLocked();
    @SearchParamDefinition(name="domain", path="Contract.domain", description="The domain of the contract", type="reference", target={Location.class})
    public static final String SP_DOMAIN = "domain";
    public static final ReferenceClientParam DOMAIN = new ReferenceClientParam("domain");
    public static final Include INCLUDE_DOMAIN = new Include("Contract:domain").toLocked();
    @SearchParamDefinition(name="issued", path="Contract.issued", description="The date/time the contract was issued", type="date")
    public static final String SP_ISSUED = "issued";
    public static final DateClientParam ISSUED = new DateClientParam("issued");
    @SearchParamDefinition(name="url", path="Contract.url", description="The basal contract definition", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="signer", path="Contract.signer.party", description="Contract Signatory Party", type="reference", target={Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_SIGNER = "signer";
    public static final ReferenceClientParam SIGNER = new ReferenceClientParam("signer");
    public static final Include INCLUDE_SIGNER = new Include("Contract:signer").toLocked();
    @SearchParamDefinition(name="status", path="Contract.status", description="The status of the contract", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Contract setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Contract addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public Contract setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public Contract setUrl(String value) {
        if (Utilities.noString(value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public Contract setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public Contract setVersion(String value) {
        if (Utilities.noString(value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public Enumeration<ContractStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ContractStatus>(new ContractStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Contract setStatusElement(Enumeration<ContractStatus> value) {
        this.status = value;
        return this;
    }

    public ContractStatus getStatus() {
        return this.status == null ? null : (ContractStatus)((Object)this.status.getValue());
    }

    public Contract setStatus(ContractStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<ContractStatus>(new ContractStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getLegalState() {
        if (this.legalState == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.legalState");
            }
            if (Configuration.doAutoCreate()) {
                this.legalState = new CodeableConcept();
            }
        }
        return this.legalState;
    }

    public boolean hasLegalState() {
        return this.legalState != null && !this.legalState.isEmpty();
    }

    public Contract setLegalState(CodeableConcept value) {
        this.legalState = value;
        return this;
    }

    public Reference getInstantiatesCanonical() {
        if (this.instantiatesCanonical == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.instantiatesCanonical");
            }
            if (Configuration.doAutoCreate()) {
                this.instantiatesCanonical = new Reference();
            }
        }
        return this.instantiatesCanonical;
    }

    public boolean hasInstantiatesCanonical() {
        return this.instantiatesCanonical != null && !this.instantiatesCanonical.isEmpty();
    }

    public Contract setInstantiatesCanonical(Reference value) {
        this.instantiatesCanonical = value;
        return this;
    }

    public Contract getInstantiatesCanonicalTarget() {
        if (this.instantiatesCanonicalTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.instantiatesCanonical");
            }
            if (Configuration.doAutoCreate()) {
                this.instantiatesCanonicalTarget = new Contract();
            }
        }
        return this.instantiatesCanonicalTarget;
    }

    public Contract setInstantiatesCanonicalTarget(Contract value) {
        this.instantiatesCanonicalTarget = value;
        return this;
    }

    public UriType getInstantiatesUriElement() {
        if (this.instantiatesUri == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.instantiatesUri");
            }
            if (Configuration.doAutoCreate()) {
                this.instantiatesUri = new UriType();
            }
        }
        return this.instantiatesUri;
    }

    public boolean hasInstantiatesUriElement() {
        return this.instantiatesUri != null && !this.instantiatesUri.isEmpty();
    }

    public boolean hasInstantiatesUri() {
        return this.instantiatesUri != null && !this.instantiatesUri.isEmpty();
    }

    public Contract setInstantiatesUriElement(UriType value) {
        this.instantiatesUri = value;
        return this;
    }

    public String getInstantiatesUri() {
        return this.instantiatesUri == null ? null : (String)this.instantiatesUri.getValue();
    }

    public Contract setInstantiatesUri(String value) {
        if (Utilities.noString(value)) {
            this.instantiatesUri = null;
        } else {
            if (this.instantiatesUri == null) {
                this.instantiatesUri = new UriType();
            }
            this.instantiatesUri.setValue(value);
        }
        return this;
    }

    public CodeableConcept getContentDerivative() {
        if (this.contentDerivative == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.contentDerivative");
            }
            if (Configuration.doAutoCreate()) {
                this.contentDerivative = new CodeableConcept();
            }
        }
        return this.contentDerivative;
    }

    public boolean hasContentDerivative() {
        return this.contentDerivative != null && !this.contentDerivative.isEmpty();
    }

    public Contract setContentDerivative(CodeableConcept value) {
        this.contentDerivative = value;
        return this;
    }

    public DateTimeType getIssuedElement() {
        if (this.issued == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.issued");
            }
            if (Configuration.doAutoCreate()) {
                this.issued = new DateTimeType();
            }
        }
        return this.issued;
    }

    public boolean hasIssuedElement() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public boolean hasIssued() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public Contract setIssuedElement(DateTimeType value) {
        this.issued = value;
        return this;
    }

    public Date getIssued() {
        return this.issued == null ? null : (Date)this.issued.getValue();
    }

    public Contract setIssued(Date value) {
        if (value == null) {
            this.issued = null;
        } else {
            if (this.issued == null) {
                this.issued = new DateTimeType();
            }
            this.issued.setValue(value);
        }
        return this;
    }

    public Period getApplies() {
        if (this.applies == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.applies");
            }
            if (Configuration.doAutoCreate()) {
                this.applies = new Period();
            }
        }
        return this.applies;
    }

    public boolean hasApplies() {
        return this.applies != null && !this.applies.isEmpty();
    }

    public Contract setApplies(Period value) {
        this.applies = value;
        return this;
    }

    public CodeableConcept getExpirationType() {
        if (this.expirationType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.expirationType");
            }
            if (Configuration.doAutoCreate()) {
                this.expirationType = new CodeableConcept();
            }
        }
        return this.expirationType;
    }

    public boolean hasExpirationType() {
        return this.expirationType != null && !this.expirationType.isEmpty();
    }

    public Contract setExpirationType(CodeableConcept value) {
        this.expirationType = value;
        return this;
    }

    public List<Reference> getSubject() {
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        return this.subject;
    }

    public Contract setSubject(List<Reference> theSubject) {
        this.subject = theSubject;
        return this;
    }

    public boolean hasSubject() {
        if (this.subject == null) {
            return false;
        }
        for (Reference item : this.subject) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSubject() {
        Reference t = new Reference();
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return t;
    }

    public Contract addSubject(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return this;
    }

    public Reference getSubjectFirstRep() {
        if (this.getSubject().isEmpty()) {
            this.addSubject();
        }
        return this.getSubject().get(0);
    }

    @Deprecated
    public List<Resource> getSubjectTarget() {
        if (this.subjectTarget == null) {
            this.subjectTarget = new ArrayList<Resource>();
        }
        return this.subjectTarget;
    }

    public List<Reference> getAuthority() {
        if (this.authority == null) {
            this.authority = new ArrayList<Reference>();
        }
        return this.authority;
    }

    public Contract setAuthority(List<Reference> theAuthority) {
        this.authority = theAuthority;
        return this;
    }

    public boolean hasAuthority() {
        if (this.authority == null) {
            return false;
        }
        for (Reference item : this.authority) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAuthority() {
        Reference t = new Reference();
        if (this.authority == null) {
            this.authority = new ArrayList<Reference>();
        }
        this.authority.add(t);
        return t;
    }

    public Contract addAuthority(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.authority == null) {
            this.authority = new ArrayList<Reference>();
        }
        this.authority.add(t);
        return this;
    }

    public Reference getAuthorityFirstRep() {
        if (this.getAuthority().isEmpty()) {
            this.addAuthority();
        }
        return this.getAuthority().get(0);
    }

    @Deprecated
    public List<Organization> getAuthorityTarget() {
        if (this.authorityTarget == null) {
            this.authorityTarget = new ArrayList<Organization>();
        }
        return this.authorityTarget;
    }

    @Deprecated
    public Organization addAuthorityTarget() {
        Organization r = new Organization();
        if (this.authorityTarget == null) {
            this.authorityTarget = new ArrayList<Organization>();
        }
        this.authorityTarget.add(r);
        return r;
    }

    public List<Reference> getDomain() {
        if (this.domain == null) {
            this.domain = new ArrayList<Reference>();
        }
        return this.domain;
    }

    public Contract setDomain(List<Reference> theDomain) {
        this.domain = theDomain;
        return this;
    }

    public boolean hasDomain() {
        if (this.domain == null) {
            return false;
        }
        for (Reference item : this.domain) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDomain() {
        Reference t = new Reference();
        if (this.domain == null) {
            this.domain = new ArrayList<Reference>();
        }
        this.domain.add(t);
        return t;
    }

    public Contract addDomain(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.domain == null) {
            this.domain = new ArrayList<Reference>();
        }
        this.domain.add(t);
        return this;
    }

    public Reference getDomainFirstRep() {
        if (this.getDomain().isEmpty()) {
            this.addDomain();
        }
        return this.getDomain().get(0);
    }

    @Deprecated
    public List<Location> getDomainTarget() {
        if (this.domainTarget == null) {
            this.domainTarget = new ArrayList<Location>();
        }
        return this.domainTarget;
    }

    @Deprecated
    public Location addDomainTarget() {
        Location r = new Location();
        if (this.domainTarget == null) {
            this.domainTarget = new ArrayList<Location>();
        }
        this.domainTarget.add(r);
        return r;
    }

    public List<Reference> getSite() {
        if (this.site == null) {
            this.site = new ArrayList<Reference>();
        }
        return this.site;
    }

    public Contract setSite(List<Reference> theSite) {
        this.site = theSite;
        return this;
    }

    public boolean hasSite() {
        if (this.site == null) {
            return false;
        }
        for (Reference item : this.site) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSite() {
        Reference t = new Reference();
        if (this.site == null) {
            this.site = new ArrayList<Reference>();
        }
        this.site.add(t);
        return t;
    }

    public Contract addSite(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.site == null) {
            this.site = new ArrayList<Reference>();
        }
        this.site.add(t);
        return this;
    }

    public Reference getSiteFirstRep() {
        if (this.getSite().isEmpty()) {
            this.addSite();
        }
        return this.getSite().get(0);
    }

    @Deprecated
    public List<Location> getSiteTarget() {
        if (this.siteTarget == null) {
            this.siteTarget = new ArrayList<Location>();
        }
        return this.siteTarget;
    }

    @Deprecated
    public Location addSiteTarget() {
        Location r = new Location();
        if (this.siteTarget == null) {
            this.siteTarget = new ArrayList<Location>();
        }
        this.siteTarget.add(r);
        return r;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public Contract setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public Contract setName(String value) {
        if (Utilities.noString(value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public Contract setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public Contract setTitle(String value) {
        if (Utilities.noString(value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public StringType getSubtitleElement() {
        if (this.subtitle == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.subtitle");
            }
            if (Configuration.doAutoCreate()) {
                this.subtitle = new StringType();
            }
        }
        return this.subtitle;
    }

    public boolean hasSubtitleElement() {
        return this.subtitle != null && !this.subtitle.isEmpty();
    }

    public boolean hasSubtitle() {
        return this.subtitle != null && !this.subtitle.isEmpty();
    }

    public Contract setSubtitleElement(StringType value) {
        this.subtitle = value;
        return this;
    }

    public String getSubtitle() {
        return this.subtitle == null ? null : (String)this.subtitle.getValue();
    }

    public Contract setSubtitle(String value) {
        if (Utilities.noString(value)) {
            this.subtitle = null;
        } else {
            if (this.subtitle == null) {
                this.subtitle = new StringType();
            }
            this.subtitle.setValue(value);
        }
        return this;
    }

    public List<StringType> getAlias() {
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        return this.alias;
    }

    public Contract setAlias(List<StringType> theAlias) {
        this.alias = theAlias;
        return this;
    }

    public boolean hasAlias() {
        if (this.alias == null) {
            return false;
        }
        for (StringType item : this.alias) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addAliasElement() {
        StringType t = new StringType();
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        this.alias.add(t);
        return t;
    }

    public Contract addAlias(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        this.alias.add(t);
        return this;
    }

    public boolean hasAlias(String value) {
        if (this.alias == null) {
            return false;
        }
        for (StringType v : this.alias) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public Contract setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public Resource getAuthorTarget() {
        return this.authorTarget;
    }

    public Contract setAuthorTarget(Resource value) {
        this.authorTarget = value;
        return this;
    }

    public CodeableConcept getScope() {
        if (this.scope == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.scope");
            }
            if (Configuration.doAutoCreate()) {
                this.scope = new CodeableConcept();
            }
        }
        return this.scope;
    }

    public boolean hasScope() {
        return this.scope != null && !this.scope.isEmpty();
    }

    public Contract setScope(CodeableConcept value) {
        this.scope = value;
        return this;
    }

    public Type getTopic() {
        return this.topic;
    }

    public CodeableConcept getTopicCodeableConcept() throws FHIRException {
        if (this.topic == null) {
            this.topic = new CodeableConcept();
        }
        if (!(this.topic instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.topic.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.topic;
    }

    public boolean hasTopicCodeableConcept() {
        return this != null && this.topic instanceof CodeableConcept;
    }

    public Reference getTopicReference() throws FHIRException {
        if (this.topic == null) {
            this.topic = new Reference();
        }
        if (!(this.topic instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.topic.getClass().getName() + " was encountered");
        }
        return (Reference)this.topic;
    }

    public boolean hasTopicReference() {
        return this != null && this.topic instanceof Reference;
    }

    public boolean hasTopic() {
        return this.topic != null && !this.topic.isEmpty();
    }

    public Contract setTopic(Type value) {
        if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
            throw new Error("Not the right type for Contract.topic[x]: " + value.fhirType());
        }
        this.topic = value;
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Contract setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public List<CodeableConcept> getSubType() {
        if (this.subType == null) {
            this.subType = new ArrayList<CodeableConcept>();
        }
        return this.subType;
    }

    public Contract setSubType(List<CodeableConcept> theSubType) {
        this.subType = theSubType;
        return this;
    }

    public boolean hasSubType() {
        if (this.subType == null) {
            return false;
        }
        for (CodeableConcept item : this.subType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSubType() {
        CodeableConcept t = new CodeableConcept();
        if (this.subType == null) {
            this.subType = new ArrayList<CodeableConcept>();
        }
        this.subType.add(t);
        return t;
    }

    public Contract addSubType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.subType == null) {
            this.subType = new ArrayList<CodeableConcept>();
        }
        this.subType.add(t);
        return this;
    }

    public CodeableConcept getSubTypeFirstRep() {
        if (this.getSubType().isEmpty()) {
            this.addSubType();
        }
        return this.getSubType().get(0);
    }

    public ContentDefinitionComponent getContentDefinition() {
        if (this.contentDefinition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.contentDefinition");
            }
            if (Configuration.doAutoCreate()) {
                this.contentDefinition = new ContentDefinitionComponent();
            }
        }
        return this.contentDefinition;
    }

    public boolean hasContentDefinition() {
        return this.contentDefinition != null && !this.contentDefinition.isEmpty();
    }

    public Contract setContentDefinition(ContentDefinitionComponent value) {
        this.contentDefinition = value;
        return this;
    }

    public List<TermComponent> getTerm() {
        if (this.term == null) {
            this.term = new ArrayList<TermComponent>();
        }
        return this.term;
    }

    public Contract setTerm(List<TermComponent> theTerm) {
        this.term = theTerm;
        return this;
    }

    public boolean hasTerm() {
        if (this.term == null) {
            return false;
        }
        for (TermComponent item : this.term) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TermComponent addTerm() {
        TermComponent t = new TermComponent();
        if (this.term == null) {
            this.term = new ArrayList<TermComponent>();
        }
        this.term.add(t);
        return t;
    }

    public Contract addTerm(TermComponent t) {
        if (t == null) {
            return this;
        }
        if (this.term == null) {
            this.term = new ArrayList<TermComponent>();
        }
        this.term.add(t);
        return this;
    }

    public TermComponent getTermFirstRep() {
        if (this.getTerm().isEmpty()) {
            this.addTerm();
        }
        return this.getTerm().get(0);
    }

    public List<Reference> getSupportingInfo() {
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        return this.supportingInfo;
    }

    public Contract setSupportingInfo(List<Reference> theSupportingInfo) {
        this.supportingInfo = theSupportingInfo;
        return this;
    }

    public boolean hasSupportingInfo() {
        if (this.supportingInfo == null) {
            return false;
        }
        for (Reference item : this.supportingInfo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInfo() {
        Reference t = new Reference();
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        this.supportingInfo.add(t);
        return t;
    }

    public Contract addSupportingInfo(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        this.supportingInfo.add(t);
        return this;
    }

    public Reference getSupportingInfoFirstRep() {
        if (this.getSupportingInfo().isEmpty()) {
            this.addSupportingInfo();
        }
        return this.getSupportingInfo().get(0);
    }

    @Deprecated
    public List<Resource> getSupportingInfoTarget() {
        if (this.supportingInfoTarget == null) {
            this.supportingInfoTarget = new ArrayList<Resource>();
        }
        return this.supportingInfoTarget;
    }

    public List<Reference> getRelevantHistory() {
        if (this.relevantHistory == null) {
            this.relevantHistory = new ArrayList<Reference>();
        }
        return this.relevantHistory;
    }

    public Contract setRelevantHistory(List<Reference> theRelevantHistory) {
        this.relevantHistory = theRelevantHistory;
        return this;
    }

    public boolean hasRelevantHistory() {
        if (this.relevantHistory == null) {
            return false;
        }
        for (Reference item : this.relevantHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRelevantHistory() {
        Reference t = new Reference();
        if (this.relevantHistory == null) {
            this.relevantHistory = new ArrayList<Reference>();
        }
        this.relevantHistory.add(t);
        return t;
    }

    public Contract addRelevantHistory(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.relevantHistory == null) {
            this.relevantHistory = new ArrayList<Reference>();
        }
        this.relevantHistory.add(t);
        return this;
    }

    public Reference getRelevantHistoryFirstRep() {
        if (this.getRelevantHistory().isEmpty()) {
            this.addRelevantHistory();
        }
        return this.getRelevantHistory().get(0);
    }

    @Deprecated
    public List<Provenance> getRelevantHistoryTarget() {
        if (this.relevantHistoryTarget == null) {
            this.relevantHistoryTarget = new ArrayList<Provenance>();
        }
        return this.relevantHistoryTarget;
    }

    @Deprecated
    public Provenance addRelevantHistoryTarget() {
        Provenance r = new Provenance();
        if (this.relevantHistoryTarget == null) {
            this.relevantHistoryTarget = new ArrayList<Provenance>();
        }
        this.relevantHistoryTarget.add(r);
        return r;
    }

    public List<SignatoryComponent> getSigner() {
        if (this.signer == null) {
            this.signer = new ArrayList<SignatoryComponent>();
        }
        return this.signer;
    }

    public Contract setSigner(List<SignatoryComponent> theSigner) {
        this.signer = theSigner;
        return this;
    }

    public boolean hasSigner() {
        if (this.signer == null) {
            return false;
        }
        for (SignatoryComponent item : this.signer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SignatoryComponent addSigner() {
        SignatoryComponent t = new SignatoryComponent();
        if (this.signer == null) {
            this.signer = new ArrayList<SignatoryComponent>();
        }
        this.signer.add(t);
        return t;
    }

    public Contract addSigner(SignatoryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.signer == null) {
            this.signer = new ArrayList<SignatoryComponent>();
        }
        this.signer.add(t);
        return this;
    }

    public SignatoryComponent getSignerFirstRep() {
        if (this.getSigner().isEmpty()) {
            this.addSigner();
        }
        return this.getSigner().get(0);
    }

    public List<FriendlyLanguageComponent> getFriendly() {
        if (this.friendly == null) {
            this.friendly = new ArrayList<FriendlyLanguageComponent>();
        }
        return this.friendly;
    }

    public Contract setFriendly(List<FriendlyLanguageComponent> theFriendly) {
        this.friendly = theFriendly;
        return this;
    }

    public boolean hasFriendly() {
        if (this.friendly == null) {
            return false;
        }
        for (FriendlyLanguageComponent item : this.friendly) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public FriendlyLanguageComponent addFriendly() {
        FriendlyLanguageComponent t = new FriendlyLanguageComponent();
        if (this.friendly == null) {
            this.friendly = new ArrayList<FriendlyLanguageComponent>();
        }
        this.friendly.add(t);
        return t;
    }

    public Contract addFriendly(FriendlyLanguageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.friendly == null) {
            this.friendly = new ArrayList<FriendlyLanguageComponent>();
        }
        this.friendly.add(t);
        return this;
    }

    public FriendlyLanguageComponent getFriendlyFirstRep() {
        if (this.getFriendly().isEmpty()) {
            this.addFriendly();
        }
        return this.getFriendly().get(0);
    }

    public List<LegalLanguageComponent> getLegal() {
        if (this.legal == null) {
            this.legal = new ArrayList<LegalLanguageComponent>();
        }
        return this.legal;
    }

    public Contract setLegal(List<LegalLanguageComponent> theLegal) {
        this.legal = theLegal;
        return this;
    }

    public boolean hasLegal() {
        if (this.legal == null) {
            return false;
        }
        for (LegalLanguageComponent item : this.legal) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public LegalLanguageComponent addLegal() {
        LegalLanguageComponent t = new LegalLanguageComponent();
        if (this.legal == null) {
            this.legal = new ArrayList<LegalLanguageComponent>();
        }
        this.legal.add(t);
        return t;
    }

    public Contract addLegal(LegalLanguageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.legal == null) {
            this.legal = new ArrayList<LegalLanguageComponent>();
        }
        this.legal.add(t);
        return this;
    }

    public LegalLanguageComponent getLegalFirstRep() {
        if (this.getLegal().isEmpty()) {
            this.addLegal();
        }
        return this.getLegal().get(0);
    }

    public List<ComputableLanguageComponent> getRule() {
        if (this.rule == null) {
            this.rule = new ArrayList<ComputableLanguageComponent>();
        }
        return this.rule;
    }

    public Contract setRule(List<ComputableLanguageComponent> theRule) {
        this.rule = theRule;
        return this;
    }

    public boolean hasRule() {
        if (this.rule == null) {
            return false;
        }
        for (ComputableLanguageComponent item : this.rule) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ComputableLanguageComponent addRule() {
        ComputableLanguageComponent t = new ComputableLanguageComponent();
        if (this.rule == null) {
            this.rule = new ArrayList<ComputableLanguageComponent>();
        }
        this.rule.add(t);
        return t;
    }

    public Contract addRule(ComputableLanguageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.rule == null) {
            this.rule = new ArrayList<ComputableLanguageComponent>();
        }
        this.rule.add(t);
        return this;
    }

    public ComputableLanguageComponent getRuleFirstRep() {
        if (this.getRule().isEmpty()) {
            this.addRule();
        }
        return this.getRule().get(0);
    }

    public Type getLegallyBinding() {
        return this.legallyBinding;
    }

    public Attachment getLegallyBindingAttachment() throws FHIRException {
        if (this.legallyBinding == null) {
            this.legallyBinding = new Attachment();
        }
        if (!(this.legallyBinding instanceof Attachment)) {
            throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.legallyBinding.getClass().getName() + " was encountered");
        }
        return (Attachment)this.legallyBinding;
    }

    public boolean hasLegallyBindingAttachment() {
        return this != null && this.legallyBinding instanceof Attachment;
    }

    public Reference getLegallyBindingReference() throws FHIRException {
        if (this.legallyBinding == null) {
            this.legallyBinding = new Reference();
        }
        if (!(this.legallyBinding instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.legallyBinding.getClass().getName() + " was encountered");
        }
        return (Reference)this.legallyBinding;
    }

    public boolean hasLegallyBindingReference() {
        return this != null && this.legallyBinding instanceof Reference;
    }

    public boolean hasLegallyBinding() {
        return this.legallyBinding != null && !this.legallyBinding.isEmpty();
    }

    public Contract setLegallyBinding(Type value) {
        if (value != null && !(value instanceof Attachment) && !(value instanceof Reference)) {
            throw new Error("Not the right type for Contract.legallyBinding[x]: " + value.fhirType());
        }
        this.legallyBinding = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique identifier for this Contract or a derivative that references a Source Contract.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_URL, "uri", "Canonical identifier for this contract, represented as a URI (globally unique).", 0, 1, this.url));
        children.add(new Property("version", "string", "An edition identifier used for business purposes to label business significant variants.", 0, 1, this.version));
        children.add(new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property("legalState", "CodeableConcept", "Legal states of the formation of a legal instrument, which is a formally executed written document that can be formally attributed to its author, records and formally expresses a legally enforceable act, process, or contractual duty, obligation, or right, and therefore evidences that act, process, or agreement.", 0, 1, this.legalState));
        children.add(new Property("instantiatesCanonical", "Reference(Contract)", "The URL pointing to a FHIR-defined Contract Definition that is adhered to in whole or part by this Contract.", 0, 1, this.instantiatesCanonical));
        children.add(new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained definition that is adhered to in whole or in part by this Contract.", 0, 1, this.instantiatesUri));
        children.add(new Property("contentDerivative", "CodeableConcept", "The minimal content derived from the basal information source at a specific stage in its lifecycle.", 0, 1, this.contentDerivative));
        children.add(new Property(SP_ISSUED, "dateTime", "When this  Contract was issued.", 0, 1, this.issued));
        children.add(new Property("applies", "Period", "Relevant time or time-period when this Contract is applicable.", 0, 1, this.applies));
        children.add(new Property("expirationType", "CodeableConcept", "Event resulting in discontinuation or termination of this Contract instance by one or more parties to the contract.", 0, 1, this.expirationType));
        children.add(new Property(SP_SUBJECT, "Reference(Any)", "The target entity impacted by or of interest to parties to the agreement.", 0, Integer.MAX_VALUE, this.subject));
        children.add(new Property(SP_AUTHORITY, "Reference(Organization)", "A formally or informally recognized grouping of people, principals, organizations, or jurisdictions formed for the purpose of achieving some form of collective action such as the promulgation, administration and enforcement of contracts and policies.", 0, Integer.MAX_VALUE, this.authority));
        children.add(new Property(SP_DOMAIN, "Reference(Location)", "Recognized governance framework or system operating with a circumscribed scope in accordance with specified principles, policies, processes or procedures for managing rights, actions, or behaviors of parties or principals relative to resources.", 0, Integer.MAX_VALUE, this.domain));
        children.add(new Property("site", "Reference(Location)", "Sites in which the contract is complied with,  exercised, or in force.", 0, Integer.MAX_VALUE, this.site));
        children.add(new Property("name", "string", "A natural language name identifying this Contract definition, derivative, or instance in any legal state. Provides additional information about its content. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property("title", "string", "A short, descriptive, user-friendly title for this Contract definition, derivative, or instance in any legal state.t giving additional information about its content.", 0, 1, this.title));
        children.add(new Property("subtitle", "string", "An explanatory or alternate user-friendly title for this Contract definition, derivative, or instance in any legal state.t giving additional information about its content.", 0, 1, this.subtitle));
        children.add(new Property("alias", "string", "Alternative representation of the title for this Contract definition, derivative, or instance in any legal state., e.g., a domain specific contract number related to legislation.", 0, Integer.MAX_VALUE, this.alias));
        children.add(new Property("author", "Reference(Patient|Practitioner|PractitionerRole|Organization)", "The individual or organization that authored the Contract definition, derivative, or instance in any legal state.", 0, 1, this.author));
        children.add(new Property("scope", "CodeableConcept", "A selector of legal concerns for this Contract definition, derivative, or instance in any legal state.", 0, 1, this.scope));
        children.add(new Property("topic[x]", "CodeableConcept|Reference(Any)", "Narrows the range of legal concerns to focus on the achievement of specific contractual objectives.", 0, 1, this.topic));
        children.add(new Property("type", "CodeableConcept", "A high-level category for the legal instrument, whether constructed as a Contract definition, derivative, or instance in any legal state.  Provides additional information about its content within the context of the Contract's scope to distinguish the kinds of systems that would be interested in the contract.", 0, 1, this.type));
        children.add(new Property("subType", "CodeableConcept", "Sub-category for the Contract that distinguishes the kinds of systems that would be interested in the Contract within the context of the Contract's scope.", 0, Integer.MAX_VALUE, this.subType));
        children.add(new Property("contentDefinition", "", "Precusory content developed with a focus and intent of supporting the formation a Contract instance, which may be associated with and transformable into a Contract.", 0, 1, this.contentDefinition));
        children.add(new Property("term", "", "One or more Contract Provisions, which may be related and conveyed as a group, and may contain nested groups.", 0, Integer.MAX_VALUE, this.term));
        children.add(new Property("supportingInfo", "Reference(Any)", "Information that may be needed by/relevant to the performer in their execution of this term action.", 0, Integer.MAX_VALUE, this.supportingInfo));
        children.add(new Property("relevantHistory", "Reference(Provenance)", "Links to Provenance records for past versions of this Contract definition, derivative, or instance, which identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the Contract.  The Provence.entity indicates the target that was changed in the update. http://build.fhir.org/provenance-definitions.html#Provenance.entity.", 0, Integer.MAX_VALUE, this.relevantHistory));
        children.add(new Property(SP_SIGNER, "", "Parties with legal standing in the Contract, including the principal parties, the grantor(s) and grantee(s), which are any person or organization bound by the contract, and any ancillary parties, which facilitate the execution of the contract such as a notary or witness.", 0, Integer.MAX_VALUE, this.signer));
        children.add(new Property("friendly", "", "The \"patient friendly language\" versionof the Contract in whole or in parts. \"Patient friendly language\" means the representation of the Contract and Contract Provisions in a manner that is readily accessible and understandable by a layperson in accordance with best practices for communication styles that ensure that those agreeing to or signing the Contract understand the roles, actions, obligations, responsibilities, and implication of the agreement.", 0, Integer.MAX_VALUE, this.friendly));
        children.add(new Property("legal", "", "List of Legal expressions or representations of this Contract.", 0, Integer.MAX_VALUE, this.legal));
        children.add(new Property("rule", "", "List of Computable Policy Rule Language Representations of this Contract.", 0, Integer.MAX_VALUE, this.rule));
        children.add(new Property("legallyBinding[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse|Contract)", "Legally binding Contract: This is the signed and legally recognized representation of the Contract, which is considered the \"source of truth\" and which would be the basis for legal action related to enforcement of this Contract.", 0, 1, this.legallyBinding));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique identifier for this Contract or a derivative that references a Source Contract.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 116079: {
                return new Property(SP_URL, "uri", "Canonical identifier for this contract, represented as a URI (globally unique).", 0, 1, this.url);
            }
            case 351608024: {
                return new Property("version", "string", "An edition identifier used for business purposes to label business significant variants.", 0, 1, this.version);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case 568606040: {
                return new Property("legalState", "CodeableConcept", "Legal states of the formation of a legal instrument, which is a formally executed written document that can be formally attributed to its author, records and formally expresses a legally enforceable act, process, or contractual duty, obligation, or right, and therefore evidences that act, process, or agreement.", 0, 1, this.legalState);
            }
            case 8911915: {
                return new Property("instantiatesCanonical", "Reference(Contract)", "The URL pointing to a FHIR-defined Contract Definition that is adhered to in whole or part by this Contract.", 0, 1, this.instantiatesCanonical);
            }
            case -1926393373: {
                return new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained definition that is adhered to in whole or in part by this Contract.", 0, 1, this.instantiatesUri);
            }
            case -92412192: {
                return new Property("contentDerivative", "CodeableConcept", "The minimal content derived from the basal information source at a specific stage in its lifecycle.", 0, 1, this.contentDerivative);
            }
            case -1179159893: {
                return new Property(SP_ISSUED, "dateTime", "When this  Contract was issued.", 0, 1, this.issued);
            }
            case -793235316: {
                return new Property("applies", "Period", "Relevant time or time-period when this Contract is applicable.", 0, 1, this.applies);
            }
            case -668311927: {
                return new Property("expirationType", "CodeableConcept", "Event resulting in discontinuation or termination of this Contract instance by one or more parties to the contract.", 0, 1, this.expirationType);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Any)", "The target entity impacted by or of interest to parties to the agreement.", 0, Integer.MAX_VALUE, this.subject);
            }
            case 1475610435: {
                return new Property(SP_AUTHORITY, "Reference(Organization)", "A formally or informally recognized grouping of people, principals, organizations, or jurisdictions formed for the purpose of achieving some form of collective action such as the promulgation, administration and enforcement of contracts and policies.", 0, Integer.MAX_VALUE, this.authority);
            }
            case -1326197564: {
                return new Property(SP_DOMAIN, "Reference(Location)", "Recognized governance framework or system operating with a circumscribed scope in accordance with specified principles, policies, processes or procedures for managing rights, actions, or behaviors of parties or principals relative to resources.", 0, Integer.MAX_VALUE, this.domain);
            }
            case 3530567: {
                return new Property("site", "Reference(Location)", "Sites in which the contract is complied with,  exercised, or in force.", 0, Integer.MAX_VALUE, this.site);
            }
            case 3373707: {
                return new Property("name", "string", "A natural language name identifying this Contract definition, derivative, or instance in any legal state. Provides additional information about its content. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property("title", "string", "A short, descriptive, user-friendly title for this Contract definition, derivative, or instance in any legal state.t giving additional information about its content.", 0, 1, this.title);
            }
            case -2060497896: {
                return new Property("subtitle", "string", "An explanatory or alternate user-friendly title for this Contract definition, derivative, or instance in any legal state.t giving additional information about its content.", 0, 1, this.subtitle);
            }
            case 92902992: {
                return new Property("alias", "string", "Alternative representation of the title for this Contract definition, derivative, or instance in any legal state., e.g., a domain specific contract number related to legislation.", 0, Integer.MAX_VALUE, this.alias);
            }
            case -1406328437: {
                return new Property("author", "Reference(Patient|Practitioner|PractitionerRole|Organization)", "The individual or organization that authored the Contract definition, derivative, or instance in any legal state.", 0, 1, this.author);
            }
            case 109264468: {
                return new Property("scope", "CodeableConcept", "A selector of legal concerns for this Contract definition, derivative, or instance in any legal state.", 0, 1, this.scope);
            }
            case -957295375: {
                return new Property("topic[x]", "CodeableConcept|Reference(Any)", "Narrows the range of legal concerns to focus on the achievement of specific contractual objectives.", 0, 1, this.topic);
            }
            case 110546223: {
                return new Property("topic[x]", "CodeableConcept|Reference(Any)", "Narrows the range of legal concerns to focus on the achievement of specific contractual objectives.", 0, 1, this.topic);
            }
            case 777778802: {
                return new Property("topic[x]", "CodeableConcept|Reference(Any)", "Narrows the range of legal concerns to focus on the achievement of specific contractual objectives.", 0, 1, this.topic);
            }
            case -343345444: {
                return new Property("topic[x]", "CodeableConcept|Reference(Any)", "Narrows the range of legal concerns to focus on the achievement of specific contractual objectives.", 0, 1, this.topic);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "A high-level category for the legal instrument, whether constructed as a Contract definition, derivative, or instance in any legal state.  Provides additional information about its content within the context of the Contract's scope to distinguish the kinds of systems that would be interested in the contract.", 0, 1, this.type);
            }
            case -1868521062: {
                return new Property("subType", "CodeableConcept", "Sub-category for the Contract that distinguishes the kinds of systems that would be interested in the Contract within the context of the Contract's scope.", 0, Integer.MAX_VALUE, this.subType);
            }
            case 247055020: {
                return new Property("contentDefinition", "", "Precusory content developed with a focus and intent of supporting the formation a Contract instance, which may be associated with and transformable into a Contract.", 0, 1, this.contentDefinition);
            }
            case 3556460: {
                return new Property("term", "", "One or more Contract Provisions, which may be related and conveyed as a group, and may contain nested groups.", 0, Integer.MAX_VALUE, this.term);
            }
            case 1922406657: {
                return new Property("supportingInfo", "Reference(Any)", "Information that may be needed by/relevant to the performer in their execution of this term action.", 0, Integer.MAX_VALUE, this.supportingInfo);
            }
            case 1538891575: {
                return new Property("relevantHistory", "Reference(Provenance)", "Links to Provenance records for past versions of this Contract definition, derivative, or instance, which identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the Contract.  The Provence.entity indicates the target that was changed in the update. http://build.fhir.org/provenance-definitions.html#Provenance.entity.", 0, Integer.MAX_VALUE, this.relevantHistory);
            }
            case -902467798: {
                return new Property(SP_SIGNER, "", "Parties with legal standing in the Contract, including the principal parties, the grantor(s) and grantee(s), which are any person or organization bound by the contract, and any ancillary parties, which facilitate the execution of the contract such as a notary or witness.", 0, Integer.MAX_VALUE, this.signer);
            }
            case -1423054677: {
                return new Property("friendly", "", "The \"patient friendly language\" versionof the Contract in whole or in parts. \"Patient friendly language\" means the representation of the Contract and Contract Provisions in a manner that is readily accessible and understandable by a layperson in accordance with best practices for communication styles that ensure that those agreeing to or signing the Contract understand the roles, actions, obligations, responsibilities, and implication of the agreement.", 0, Integer.MAX_VALUE, this.friendly);
            }
            case 102851257: {
                return new Property("legal", "", "List of Legal expressions or representations of this Contract.", 0, Integer.MAX_VALUE, this.legal);
            }
            case 3512060: {
                return new Property("rule", "", "List of Computable Policy Rule Language Representations of this Contract.", 0, Integer.MAX_VALUE, this.rule);
            }
            case -772497791: {
                return new Property("legallyBinding[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse|Contract)", "Legally binding Contract: This is the signed and legally recognized representation of the Contract, which is considered the \"source of truth\" and which would be the basis for legal action related to enforcement of this Contract.", 0, 1, this.legallyBinding);
            }
            case -126751329: {
                return new Property("legallyBinding[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse|Contract)", "Legally binding Contract: This is the signed and legally recognized representation of the Contract, which is considered the \"source of truth\" and which would be the basis for legal action related to enforcement of this Contract.", 0, 1, this.legallyBinding);
            }
            case 344057890: {
                return new Property("legallyBinding[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse|Contract)", "Legally binding Contract: This is the signed and legally recognized representation of the Contract, which is considered the \"source of truth\" and which would be the basis for legal action related to enforcement of this Contract.", 0, 1, this.legallyBinding);
            }
            case -296528788: {
                return new Property("legallyBinding[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse|Contract)", "Legally binding Contract: This is the signed and legally recognized representation of the Contract, which is considered the \"source of truth\" and which would be the basis for legal action related to enforcement of this Contract.", 0, 1, this.legallyBinding);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case 568606040: {
                Base[] baseArray;
                if (this.legalState == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.legalState;
                }
                return baseArray;
            }
            case 8911915: {
                Base[] baseArray;
                if (this.instantiatesCanonical == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.instantiatesCanonical;
                }
                return baseArray;
            }
            case -1926393373: {
                Base[] baseArray;
                if (this.instantiatesUri == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.instantiatesUri;
                }
                return baseArray;
            }
            case -92412192: {
                Base[] baseArray;
                if (this.contentDerivative == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.contentDerivative;
                }
                return baseArray;
            }
            case -1179159893: {
                Base[] baseArray;
                if (this.issued == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.issued;
                }
                return baseArray;
            }
            case -793235316: {
                Base[] baseArray;
                if (this.applies == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.applies;
                }
                return baseArray;
            }
            case -668311927: {
                Base[] baseArray;
                if (this.expirationType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.expirationType;
                }
                return baseArray;
            }
            case -1867885268: {
                return this.subject == null ? new Base[]{} : this.subject.toArray(new Base[this.subject.size()]);
            }
            case 1475610435: {
                return this.authority == null ? new Base[]{} : this.authority.toArray(new Base[this.authority.size()]);
            }
            case -1326197564: {
                return this.domain == null ? new Base[]{} : this.domain.toArray(new Base[this.domain.size()]);
            }
            case 3530567: {
                return this.site == null ? new Base[]{} : this.site.toArray(new Base[this.site.size()]);
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.title;
                }
                return baseArray;
            }
            case -2060497896: {
                Base[] baseArray;
                if (this.subtitle == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.subtitle;
                }
                return baseArray;
            }
            case 92902992: {
                return this.alias == null ? new Base[]{} : this.alias.toArray(new Base[this.alias.size()]);
            }
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.author;
                }
                return baseArray;
            }
            case 109264468: {
                Base[] baseArray;
                if (this.scope == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.scope;
                }
                return baseArray;
            }
            case 110546223: {
                Base[] baseArray;
                if (this.topic == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.topic;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.type;
                }
                return baseArray;
            }
            case -1868521062: {
                return this.subType == null ? new Base[]{} : this.subType.toArray(new Base[this.subType.size()]);
            }
            case 247055020: {
                Base[] baseArray;
                if (this.contentDefinition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.contentDefinition;
                }
                return baseArray;
            }
            case 3556460: {
                return this.term == null ? new Base[]{} : this.term.toArray(new Base[this.term.size()]);
            }
            case 1922406657: {
                return this.supportingInfo == null ? new Base[]{} : this.supportingInfo.toArray(new Base[this.supportingInfo.size()]);
            }
            case 1538891575: {
                return this.relevantHistory == null ? new Base[]{} : this.relevantHistory.toArray(new Base[this.relevantHistory.size()]);
            }
            case -902467798: {
                return this.signer == null ? new Base[]{} : this.signer.toArray(new Base[this.signer.size()]);
            }
            case -1423054677: {
                return this.friendly == null ? new Base[]{} : this.friendly.toArray(new Base[this.friendly.size()]);
            }
            case 102851257: {
                return this.legal == null ? new Base[]{} : this.legal.toArray(new Base[this.legal.size()]);
            }
            case 3512060: {
                return this.rule == null ? new Base[]{} : this.rule.toArray(new Base[this.rule.size()]);
            }
            case -126751329: {
                Base[] baseArray;
                if (this.legallyBinding == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.legallyBinding;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case -892481550: {
                value = new ContractStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 568606040: {
                this.legalState = this.castToCodeableConcept(value);
                return value;
            }
            case 8911915: {
                this.instantiatesCanonical = this.castToReference(value);
                return value;
            }
            case -1926393373: {
                this.instantiatesUri = this.castToUri(value);
                return value;
            }
            case -92412192: {
                this.contentDerivative = this.castToCodeableConcept(value);
                return value;
            }
            case -1179159893: {
                this.issued = this.castToDateTime(value);
                return value;
            }
            case -793235316: {
                this.applies = this.castToPeriod(value);
                return value;
            }
            case -668311927: {
                this.expirationType = this.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.getSubject().add(this.castToReference(value));
                return value;
            }
            case 1475610435: {
                this.getAuthority().add(this.castToReference(value));
                return value;
            }
            case -1326197564: {
                this.getDomain().add(this.castToReference(value));
                return value;
            }
            case 3530567: {
                this.getSite().add(this.castToReference(value));
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case -2060497896: {
                this.subtitle = this.castToString(value);
                return value;
            }
            case 92902992: {
                this.getAlias().add(this.castToString(value));
                return value;
            }
            case -1406328437: {
                this.author = this.castToReference(value);
                return value;
            }
            case 109264468: {
                this.scope = this.castToCodeableConcept(value);
                return value;
            }
            case 110546223: {
                this.topic = this.castToType(value);
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case -1868521062: {
                this.getSubType().add(this.castToCodeableConcept(value));
                return value;
            }
            case 247055020: {
                this.contentDefinition = (ContentDefinitionComponent)((Object)value);
                return value;
            }
            case 3556460: {
                this.getTerm().add((TermComponent)((Object)value));
                return value;
            }
            case 1922406657: {
                this.getSupportingInfo().add(this.castToReference(value));
                return value;
            }
            case 1538891575: {
                this.getRelevantHistory().add(this.castToReference(value));
                return value;
            }
            case -902467798: {
                this.getSigner().add((SignatoryComponent)((Object)value));
                return value;
            }
            case -1423054677: {
                this.getFriendly().add((FriendlyLanguageComponent)((Object)value));
                return value;
            }
            case 102851257: {
                this.getLegal().add((LegalLanguageComponent)((Object)value));
                return value;
            }
            case 3512060: {
                this.getRule().add((ComputableLanguageComponent)((Object)value));
                return value;
            }
            case -126751329: {
                this.legallyBinding = this.castToType(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals("version")) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new ContractStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("legalState")) {
            this.legalState = this.castToCodeableConcept(value);
        } else if (name.equals("instantiatesCanonical")) {
            this.instantiatesCanonical = this.castToReference(value);
        } else if (name.equals("instantiatesUri")) {
            this.instantiatesUri = this.castToUri(value);
        } else if (name.equals("contentDerivative")) {
            this.contentDerivative = this.castToCodeableConcept(value);
        } else if (name.equals(SP_ISSUED)) {
            this.issued = this.castToDateTime(value);
        } else if (name.equals("applies")) {
            this.applies = this.castToPeriod(value);
        } else if (name.equals("expirationType")) {
            this.expirationType = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.getSubject().add(this.castToReference(value));
        } else if (name.equals(SP_AUTHORITY)) {
            this.getAuthority().add(this.castToReference(value));
        } else if (name.equals(SP_DOMAIN)) {
            this.getDomain().add(this.castToReference(value));
        } else if (name.equals("site")) {
            this.getSite().add(this.castToReference(value));
        } else if (name.equals("name")) {
            this.name = this.castToString(value);
        } else if (name.equals("title")) {
            this.title = this.castToString(value);
        } else if (name.equals("subtitle")) {
            this.subtitle = this.castToString(value);
        } else if (name.equals("alias")) {
            this.getAlias().add(this.castToString(value));
        } else if (name.equals("author")) {
            this.author = this.castToReference(value);
        } else if (name.equals("scope")) {
            this.scope = this.castToCodeableConcept(value);
        } else if (name.equals("topic[x]")) {
            this.topic = this.castToType(value);
        } else if (name.equals("type")) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("subType")) {
            this.getSubType().add(this.castToCodeableConcept(value));
        } else if (name.equals("contentDefinition")) {
            this.contentDefinition = (ContentDefinitionComponent)((Object)value);
        } else if (name.equals("term")) {
            this.getTerm().add((TermComponent)((Object)value));
        } else if (name.equals("supportingInfo")) {
            this.getSupportingInfo().add(this.castToReference(value));
        } else if (name.equals("relevantHistory")) {
            this.getRelevantHistory().add(this.castToReference(value));
        } else if (name.equals(SP_SIGNER)) {
            this.getSigner().add((SignatoryComponent)((Object)value));
        } else if (name.equals("friendly")) {
            this.getFriendly().add((FriendlyLanguageComponent)((Object)value));
        } else if (name.equals("legal")) {
            this.getLegal().add((LegalLanguageComponent)((Object)value));
        } else if (name.equals("rule")) {
            this.getRule().add((ComputableLanguageComponent)((Object)value));
        } else if (name.equals("legallyBinding[x]")) {
            this.legallyBinding = this.castToType(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 116079: {
                return this.getUrlElement();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 568606040: {
                return this.getLegalState();
            }
            case 8911915: {
                return this.getInstantiatesCanonical();
            }
            case -1926393373: {
                return this.getInstantiatesUriElement();
            }
            case -92412192: {
                return this.getContentDerivative();
            }
            case -1179159893: {
                return this.getIssuedElement();
            }
            case -793235316: {
                return this.getApplies();
            }
            case -668311927: {
                return this.getExpirationType();
            }
            case -1867885268: {
                return this.addSubject();
            }
            case 1475610435: {
                return this.addAuthority();
            }
            case -1326197564: {
                return this.addDomain();
            }
            case 3530567: {
                return this.addSite();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -2060497896: {
                return this.getSubtitleElement();
            }
            case 92902992: {
                return this.addAliasElement();
            }
            case -1406328437: {
                return this.getAuthor();
            }
            case 109264468: {
                return this.getScope();
            }
            case -957295375: {
                return this.getTopic();
            }
            case 110546223: {
                return this.getTopic();
            }
            case 3575610: {
                return this.getType();
            }
            case -1868521062: {
                return this.addSubType();
            }
            case 247055020: {
                return this.getContentDefinition();
            }
            case 3556460: {
                return this.addTerm();
            }
            case 1922406657: {
                return this.addSupportingInfo();
            }
            case 1538891575: {
                return this.addRelevantHistory();
            }
            case -902467798: {
                return this.addSigner();
            }
            case -1423054677: {
                return this.addFriendly();
            }
            case 102851257: {
                return this.addLegal();
            }
            case 3512060: {
                return this.addRule();
            }
            case -772497791: {
                return this.getLegallyBinding();
            }
            case -126751329: {
                return this.getLegallyBinding();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 116079: {
                return new String[]{"uri"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 568606040: {
                return new String[]{"CodeableConcept"};
            }
            case 8911915: {
                return new String[]{"Reference"};
            }
            case -1926393373: {
                return new String[]{"uri"};
            }
            case -92412192: {
                return new String[]{"CodeableConcept"};
            }
            case -1179159893: {
                return new String[]{"dateTime"};
            }
            case -793235316: {
                return new String[]{"Period"};
            }
            case -668311927: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1475610435: {
                return new String[]{"Reference"};
            }
            case -1326197564: {
                return new String[]{"Reference"};
            }
            case 3530567: {
                return new String[]{"Reference"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -2060497896: {
                return new String[]{"string"};
            }
            case 92902992: {
                return new String[]{"string"};
            }
            case -1406328437: {
                return new String[]{"Reference"};
            }
            case 109264468: {
                return new String[]{"CodeableConcept"};
            }
            case 110546223: {
                return new String[]{"CodeableConcept", "Reference"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1868521062: {
                return new String[]{"CodeableConcept"};
            }
            case 247055020: {
                return new String[0];
            }
            case 3556460: {
                return new String[0];
            }
            case 1922406657: {
                return new String[]{"Reference"};
            }
            case 1538891575: {
                return new String[]{"Reference"};
            }
            case -902467798: {
                return new String[0];
            }
            case -1423054677: {
                return new String[0];
            }
            case 102851257: {
                return new String[0];
            }
            case 3512060: {
                return new String[0];
            }
            case -126751329: {
                return new String[]{"Attachment", "Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type Contract.url");
        }
        if (name.equals("version")) {
            throw new FHIRException("Cannot call addChild on a primitive type Contract.version");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Contract.status");
        }
        if (name.equals("legalState")) {
            this.legalState = new CodeableConcept();
            return this.legalState;
        }
        if (name.equals("instantiatesCanonical")) {
            this.instantiatesCanonical = new Reference();
            return this.instantiatesCanonical;
        }
        if (name.equals("instantiatesUri")) {
            throw new FHIRException("Cannot call addChild on a primitive type Contract.instantiatesUri");
        }
        if (name.equals("contentDerivative")) {
            this.contentDerivative = new CodeableConcept();
            return this.contentDerivative;
        }
        if (name.equals(SP_ISSUED)) {
            throw new FHIRException("Cannot call addChild on a primitive type Contract.issued");
        }
        if (name.equals("applies")) {
            this.applies = new Period();
            return this.applies;
        }
        if (name.equals("expirationType")) {
            this.expirationType = new CodeableConcept();
            return this.expirationType;
        }
        if (name.equals(SP_SUBJECT)) {
            return this.addSubject();
        }
        if (name.equals(SP_AUTHORITY)) {
            return this.addAuthority();
        }
        if (name.equals(SP_DOMAIN)) {
            return this.addDomain();
        }
        if (name.equals("site")) {
            return this.addSite();
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a primitive type Contract.name");
        }
        if (name.equals("title")) {
            throw new FHIRException("Cannot call addChild on a primitive type Contract.title");
        }
        if (name.equals("subtitle")) {
            throw new FHIRException("Cannot call addChild on a primitive type Contract.subtitle");
        }
        if (name.equals("alias")) {
            throw new FHIRException("Cannot call addChild on a primitive type Contract.alias");
        }
        if (name.equals("author")) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals("scope")) {
            this.scope = new CodeableConcept();
            return this.scope;
        }
        if (name.equals("topicCodeableConcept")) {
            this.topic = new CodeableConcept();
            return this.topic;
        }
        if (name.equals("topicReference")) {
            this.topic = new Reference();
            return this.topic;
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("subType")) {
            return this.addSubType();
        }
        if (name.equals("contentDefinition")) {
            this.contentDefinition = new ContentDefinitionComponent();
            return this.contentDefinition;
        }
        if (name.equals("term")) {
            return this.addTerm();
        }
        if (name.equals("supportingInfo")) {
            return this.addSupportingInfo();
        }
        if (name.equals("relevantHistory")) {
            return this.addRelevantHistory();
        }
        if (name.equals(SP_SIGNER)) {
            return this.addSigner();
        }
        if (name.equals("friendly")) {
            return this.addFriendly();
        }
        if (name.equals("legal")) {
            return this.addLegal();
        }
        if (name.equals("rule")) {
            return this.addRule();
        }
        if (name.equals("legallyBindingAttachment")) {
            this.legallyBinding = new Attachment();
            return this.legallyBinding;
        }
        if (name.equals("legallyBindingReference")) {
            this.legallyBinding = new Reference();
            return this.legallyBinding;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Contract";
    }

    @Override
    public Contract copy() {
        Contract dst = new Contract();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Contract dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.url = this.url == null ? null : this.url.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.legalState = this.legalState == null ? null : this.legalState.copy();
        dst.instantiatesCanonical = this.instantiatesCanonical == null ? null : this.instantiatesCanonical.copy();
        dst.instantiatesUri = this.instantiatesUri == null ? null : this.instantiatesUri.copy();
        dst.contentDerivative = this.contentDerivative == null ? null : this.contentDerivative.copy();
        dst.issued = this.issued == null ? null : this.issued.copy();
        dst.applies = this.applies == null ? null : this.applies.copy();
        CodeableConcept codeableConcept = dst.expirationType = this.expirationType == null ? null : this.expirationType.copy();
        if (this.subject != null) {
            dst.subject = new ArrayList<Reference>();
            for (Reference reference : this.subject) {
                dst.subject.add(reference.copy());
            }
        }
        if (this.authority != null) {
            dst.authority = new ArrayList<Reference>();
            for (Reference reference : this.authority) {
                dst.authority.add(reference.copy());
            }
        }
        if (this.domain != null) {
            dst.domain = new ArrayList<Reference>();
            for (Reference reference : this.domain) {
                dst.domain.add(reference.copy());
            }
        }
        if (this.site != null) {
            dst.site = new ArrayList<Reference>();
            for (Reference reference : this.site) {
                dst.site.add(reference.copy());
            }
        }
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        StringType stringType = dst.subtitle = this.subtitle == null ? null : this.subtitle.copy();
        if (this.alias != null) {
            dst.alias = new ArrayList<StringType>();
            for (StringType stringType2 : this.alias) {
                dst.alias.add(stringType2.copy());
            }
        }
        dst.author = this.author == null ? null : this.author.copy();
        dst.scope = this.scope == null ? null : this.scope.copy();
        dst.topic = this.topic == null ? null : this.topic.copy();
        CodeableConcept codeableConcept2 = dst.type = this.type == null ? null : this.type.copy();
        if (this.subType != null) {
            dst.subType = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.subType) {
                dst.subType.add(codeableConcept3.copy());
            }
        }
        ContentDefinitionComponent contentDefinitionComponent = dst.contentDefinition = this.contentDefinition == null ? null : this.contentDefinition.copy();
        if (this.term != null) {
            dst.term = new ArrayList<TermComponent>();
            for (TermComponent termComponent : this.term) {
                dst.term.add(termComponent.copy());
            }
        }
        if (this.supportingInfo != null) {
            dst.supportingInfo = new ArrayList<Reference>();
            for (Reference reference : this.supportingInfo) {
                dst.supportingInfo.add(reference.copy());
            }
        }
        if (this.relevantHistory != null) {
            dst.relevantHistory = new ArrayList<Reference>();
            for (Reference reference : this.relevantHistory) {
                dst.relevantHistory.add(reference.copy());
            }
        }
        if (this.signer != null) {
            dst.signer = new ArrayList<SignatoryComponent>();
            for (SignatoryComponent signatoryComponent : this.signer) {
                dst.signer.add(signatoryComponent.copy());
            }
        }
        if (this.friendly != null) {
            dst.friendly = new ArrayList<FriendlyLanguageComponent>();
            for (FriendlyLanguageComponent friendlyLanguageComponent : this.friendly) {
                dst.friendly.add(friendlyLanguageComponent.copy());
            }
        }
        if (this.legal != null) {
            dst.legal = new ArrayList<LegalLanguageComponent>();
            for (LegalLanguageComponent legalLanguageComponent : this.legal) {
                dst.legal.add(legalLanguageComponent.copy());
            }
        }
        if (this.rule != null) {
            dst.rule = new ArrayList<ComputableLanguageComponent>();
            for (ComputableLanguageComponent computableLanguageComponent : this.rule) {
                dst.rule.add(computableLanguageComponent.copy());
            }
        }
        dst.legallyBinding = this.legallyBinding == null ? null : this.legallyBinding.copy();
    }

    protected Contract typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Contract)) {
            return false;
        }
        Contract o = (Contract)other_;
        return Contract.compareDeep(this.identifier, o.identifier, true) && Contract.compareDeep(this.url, o.url, true) && Contract.compareDeep(this.version, o.version, true) && Contract.compareDeep(this.status, o.status, true) && Contract.compareDeep(this.legalState, o.legalState, true) && Contract.compareDeep(this.instantiatesCanonical, o.instantiatesCanonical, true) && Contract.compareDeep(this.instantiatesUri, o.instantiatesUri, true) && Contract.compareDeep(this.contentDerivative, o.contentDerivative, true) && Contract.compareDeep(this.issued, o.issued, true) && Contract.compareDeep(this.applies, o.applies, true) && Contract.compareDeep(this.expirationType, o.expirationType, true) && Contract.compareDeep(this.subject, o.subject, true) && Contract.compareDeep(this.authority, o.authority, true) && Contract.compareDeep(this.domain, o.domain, true) && Contract.compareDeep(this.site, o.site, true) && Contract.compareDeep(this.name, o.name, true) && Contract.compareDeep(this.title, o.title, true) && Contract.compareDeep(this.subtitle, o.subtitle, true) && Contract.compareDeep(this.alias, o.alias, true) && Contract.compareDeep(this.author, o.author, true) && Contract.compareDeep(this.scope, o.scope, true) && Contract.compareDeep(this.topic, o.topic, true) && Contract.compareDeep(this.type, o.type, true) && Contract.compareDeep(this.subType, o.subType, true) && Contract.compareDeep(this.contentDefinition, o.contentDefinition, true) && Contract.compareDeep(this.term, o.term, true) && Contract.compareDeep(this.supportingInfo, o.supportingInfo, true) && Contract.compareDeep(this.relevantHistory, o.relevantHistory, true) && Contract.compareDeep(this.signer, o.signer, true) && Contract.compareDeep(this.friendly, o.friendly, true) && Contract.compareDeep(this.legal, o.legal, true) && Contract.compareDeep(this.rule, o.rule, true) && Contract.compareDeep(this.legallyBinding, o.legallyBinding, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Contract)) {
            return false;
        }
        Contract o = (Contract)other_;
        return Contract.compareValues(this.url, o.url, true) && Contract.compareValues(this.version, o.version, true) && Contract.compareValues(this.status, o.status, true) && Contract.compareValues(this.instantiatesUri, o.instantiatesUri, true) && Contract.compareValues(this.issued, o.issued, true) && Contract.compareValues(this.name, o.name, true) && Contract.compareValues(this.title, o.title, true) && Contract.compareValues(this.subtitle, o.subtitle, true) && Contract.compareValues(this.alias, o.alias, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.url, this.version, this.status, this.legalState, this.instantiatesCanonical, this.instantiatesUri, this.contentDerivative, this.issued, this.applies, this.expirationType, this.subject, this.authority, this.domain, this.site, this.name, this.title, this.subtitle, this.alias, this.author, this.scope, this.topic, this.type, this.subType, this.contentDefinition, this.term, this.supportingInfo, this.relevantHistory, this.signer, this.friendly, this.legal, this.rule, this.legallyBinding);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Contract;
    }

    @Block
    public static class ComputableLanguageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="content", type={Attachment.class, DocumentReference.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Computable Contract Rules", formalDefinition="Computable Contract conveyed using a policy rule language (e.g. XACML, DKAL, SecPal).")
        protected Type content;
        private static final long serialVersionUID = -1763459053L;

        public ComputableLanguageComponent() {
        }

        public ComputableLanguageComponent(Type content) {
            this.content = content;
        }

        public Type getContent() {
            return this.content;
        }

        public Attachment getContentAttachment() throws FHIRException {
            if (this.content == null) {
                this.content = new Attachment();
            }
            if (!(this.content instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Attachment)this.content;
        }

        public boolean hasContentAttachment() {
            return this != null && this.content instanceof Attachment;
        }

        public Reference getContentReference() throws FHIRException {
            if (this.content == null) {
                this.content = new Reference();
            }
            if (!(this.content instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Reference)this.content;
        }

        public boolean hasContentReference() {
            return this != null && this.content instanceof Reference;
        }

        public boolean hasContent() {
            return this.content != null && !this.content.isEmpty();
        }

        public ComputableLanguageComponent setContent(Type value) {
            if (value != null && !(value instanceof Attachment) && !(value instanceof Reference)) {
                throw new Error("Not the right type for Contract.rule.content[x]: " + value.fhirType());
            }
            this.content = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("content[x]", "Attachment|Reference(DocumentReference)", "Computable Contract conveyed using a policy rule language (e.g. XACML, DKAL, SecPal).", 0, 1, this.content));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 264548711: {
                    return new Property("content[x]", "Attachment|Reference(DocumentReference)", "Computable Contract conveyed using a policy rule language (e.g. XACML, DKAL, SecPal).", 0, 1, this.content);
                }
                case 951530617: {
                    return new Property("content[x]", "Attachment|Reference(DocumentReference)", "Computable Contract conveyed using a policy rule language (e.g. XACML, DKAL, SecPal).", 0, 1, this.content);
                }
                case -702028164: {
                    return new Property("content[x]", "Attachment|Reference(DocumentReference)", "Computable Contract conveyed using a policy rule language (e.g. XACML, DKAL, SecPal).", 0, 1, this.content);
                }
                case 1193747154: {
                    return new Property("content[x]", "Attachment|Reference(DocumentReference)", "Computable Contract conveyed using a policy rule language (e.g. XACML, DKAL, SecPal).", 0, 1, this.content);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    Base[] baseArray;
                    if (this.content == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.content;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    this.content = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("content[x]")) {
                return super.setProperty(name, value);
            }
            this.content = this.castToType(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 264548711: {
                    return this.getContent();
                }
                case 951530617: {
                    return this.getContent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    return new String[]{"Attachment", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("contentAttachment")) {
                this.content = new Attachment();
                return this.content;
            }
            if (name.equals("contentReference")) {
                this.content = new Reference();
                return this.content;
            }
            return super.addChild(name);
        }

        @Override
        public ComputableLanguageComponent copy() {
            ComputableLanguageComponent dst = new ComputableLanguageComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ComputableLanguageComponent dst) {
            super.copyValues(dst);
            dst.content = this.content == null ? null : this.content.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ComputableLanguageComponent)) {
                return false;
            }
            ComputableLanguageComponent o = (ComputableLanguageComponent)other_;
            return ComputableLanguageComponent.compareDeep(this.content, o.content, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ComputableLanguageComponent)) {
                return false;
            }
            ComputableLanguageComponent o = (ComputableLanguageComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.content);
        }

        @Override
        public String fhirType() {
            return "Contract.rule";
        }
    }

    @Block
    public static class LegalLanguageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="content", type={Attachment.class, Composition.class, DocumentReference.class, QuestionnaireResponse.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Legal Text", formalDefinition="Contract legal text in human renderable form.")
        protected Type content;
        private static final long serialVersionUID = -1763459053L;

        public LegalLanguageComponent() {
        }

        public LegalLanguageComponent(Type content) {
            this.content = content;
        }

        public Type getContent() {
            return this.content;
        }

        public Attachment getContentAttachment() throws FHIRException {
            if (this.content == null) {
                this.content = new Attachment();
            }
            if (!(this.content instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Attachment)this.content;
        }

        public boolean hasContentAttachment() {
            return this != null && this.content instanceof Attachment;
        }

        public Reference getContentReference() throws FHIRException {
            if (this.content == null) {
                this.content = new Reference();
            }
            if (!(this.content instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Reference)this.content;
        }

        public boolean hasContentReference() {
            return this != null && this.content instanceof Reference;
        }

        public boolean hasContent() {
            return this.content != null && !this.content.isEmpty();
        }

        public LegalLanguageComponent setContent(Type value) {
            if (value != null && !(value instanceof Attachment) && !(value instanceof Reference)) {
                throw new Error("Not the right type for Contract.legal.content[x]: " + value.fhirType());
            }
            this.content = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Contract legal text in human renderable form.", 0, 1, this.content));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 264548711: {
                    return new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Contract legal text in human renderable form.", 0, 1, this.content);
                }
                case 951530617: {
                    return new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Contract legal text in human renderable form.", 0, 1, this.content);
                }
                case -702028164: {
                    return new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Contract legal text in human renderable form.", 0, 1, this.content);
                }
                case 1193747154: {
                    return new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Contract legal text in human renderable form.", 0, 1, this.content);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    Base[] baseArray;
                    if (this.content == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.content;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    this.content = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("content[x]")) {
                return super.setProperty(name, value);
            }
            this.content = this.castToType(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 264548711: {
                    return this.getContent();
                }
                case 951530617: {
                    return this.getContent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    return new String[]{"Attachment", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("contentAttachment")) {
                this.content = new Attachment();
                return this.content;
            }
            if (name.equals("contentReference")) {
                this.content = new Reference();
                return this.content;
            }
            return super.addChild(name);
        }

        @Override
        public LegalLanguageComponent copy() {
            LegalLanguageComponent dst = new LegalLanguageComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(LegalLanguageComponent dst) {
            super.copyValues(dst);
            dst.content = this.content == null ? null : this.content.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof LegalLanguageComponent)) {
                return false;
            }
            LegalLanguageComponent o = (LegalLanguageComponent)other_;
            return LegalLanguageComponent.compareDeep(this.content, o.content, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof LegalLanguageComponent)) {
                return false;
            }
            LegalLanguageComponent o = (LegalLanguageComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.content);
        }

        @Override
        public String fhirType() {
            return "Contract.legal";
        }
    }

    @Block
    public static class FriendlyLanguageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="content", type={Attachment.class, Composition.class, DocumentReference.class, QuestionnaireResponse.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Easily comprehended representation of this Contract", formalDefinition="Human readable rendering of this Contract in a format and representation intended to enhance comprehension and ensure understandability.")
        protected Type content;
        private static final long serialVersionUID = -1763459053L;

        public FriendlyLanguageComponent() {
        }

        public FriendlyLanguageComponent(Type content) {
            this.content = content;
        }

        public Type getContent() {
            return this.content;
        }

        public Attachment getContentAttachment() throws FHIRException {
            if (this.content == null) {
                this.content = new Attachment();
            }
            if (!(this.content instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Attachment)this.content;
        }

        public boolean hasContentAttachment() {
            return this != null && this.content instanceof Attachment;
        }

        public Reference getContentReference() throws FHIRException {
            if (this.content == null) {
                this.content = new Reference();
            }
            if (!(this.content instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Reference)this.content;
        }

        public boolean hasContentReference() {
            return this != null && this.content instanceof Reference;
        }

        public boolean hasContent() {
            return this.content != null && !this.content.isEmpty();
        }

        public FriendlyLanguageComponent setContent(Type value) {
            if (value != null && !(value instanceof Attachment) && !(value instanceof Reference)) {
                throw new Error("Not the right type for Contract.friendly.content[x]: " + value.fhirType());
            }
            this.content = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Human readable rendering of this Contract in a format and representation intended to enhance comprehension and ensure understandability.", 0, 1, this.content));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 264548711: {
                    return new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Human readable rendering of this Contract in a format and representation intended to enhance comprehension and ensure understandability.", 0, 1, this.content);
                }
                case 951530617: {
                    return new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Human readable rendering of this Contract in a format and representation intended to enhance comprehension and ensure understandability.", 0, 1, this.content);
                }
                case -702028164: {
                    return new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Human readable rendering of this Contract in a format and representation intended to enhance comprehension and ensure understandability.", 0, 1, this.content);
                }
                case 1193747154: {
                    return new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Human readable rendering of this Contract in a format and representation intended to enhance comprehension and ensure understandability.", 0, 1, this.content);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    Base[] baseArray;
                    if (this.content == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.content;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    this.content = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("content[x]")) {
                return super.setProperty(name, value);
            }
            this.content = this.castToType(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 264548711: {
                    return this.getContent();
                }
                case 951530617: {
                    return this.getContent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    return new String[]{"Attachment", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("contentAttachment")) {
                this.content = new Attachment();
                return this.content;
            }
            if (name.equals("contentReference")) {
                this.content = new Reference();
                return this.content;
            }
            return super.addChild(name);
        }

        @Override
        public FriendlyLanguageComponent copy() {
            FriendlyLanguageComponent dst = new FriendlyLanguageComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(FriendlyLanguageComponent dst) {
            super.copyValues(dst);
            dst.content = this.content == null ? null : this.content.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof FriendlyLanguageComponent)) {
                return false;
            }
            FriendlyLanguageComponent o = (FriendlyLanguageComponent)other_;
            return FriendlyLanguageComponent.compareDeep(this.content, o.content, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof FriendlyLanguageComponent)) {
                return false;
            }
            FriendlyLanguageComponent o = (FriendlyLanguageComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.content);
        }

        @Override
        public String fhirType() {
            return "Contract.friendly";
        }
    }

    @Block
    public static class SignatoryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Signatory Role", formalDefinition="Role of this Contract signer, e.g. notary, grantee.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-signer-type")
        protected Coding type;
        @Child(name="party", type={Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Signatory Party", formalDefinition="Party which is a signator to this Contract.")
        protected Reference party;
        protected Resource partyTarget;
        @Child(name="signature", type={Signature.class}, order=3, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Documentation Signature", formalDefinition="Legally binding Contract DSIG signature contents in Base64.")
        protected List<Signature> signature;
        private static final long serialVersionUID = 1948139228L;

        public SignatoryComponent() {
        }

        public SignatoryComponent(Coding type, Reference party) {
            this.type = type;
            this.party = party;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SignatoryComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SignatoryComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Reference getParty() {
            if (this.party == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SignatoryComponent.party");
                }
                if (Configuration.doAutoCreate()) {
                    this.party = new Reference();
                }
            }
            return this.party;
        }

        public boolean hasParty() {
            return this.party != null && !this.party.isEmpty();
        }

        public SignatoryComponent setParty(Reference value) {
            this.party = value;
            return this;
        }

        public Resource getPartyTarget() {
            return this.partyTarget;
        }

        public SignatoryComponent setPartyTarget(Resource value) {
            this.partyTarget = value;
            return this;
        }

        public List<Signature> getSignature() {
            if (this.signature == null) {
                this.signature = new ArrayList<Signature>();
            }
            return this.signature;
        }

        public SignatoryComponent setSignature(List<Signature> theSignature) {
            this.signature = theSignature;
            return this;
        }

        public boolean hasSignature() {
            if (this.signature == null) {
                return false;
            }
            for (Signature item : this.signature) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Signature addSignature() {
            Signature t = new Signature();
            if (this.signature == null) {
                this.signature = new ArrayList<Signature>();
            }
            this.signature.add(t);
            return t;
        }

        public SignatoryComponent addSignature(Signature t) {
            if (t == null) {
                return this;
            }
            if (this.signature == null) {
                this.signature = new ArrayList<Signature>();
            }
            this.signature.add(t);
            return this;
        }

        public Signature getSignatureFirstRep() {
            if (this.getSignature().isEmpty()) {
                this.addSignature();
            }
            return this.getSignature().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "Coding", "Role of this Contract signer, e.g. notary, grantee.", 0, 1, this.type));
            children.add(new Property("party", "Reference(Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "Party which is a signator to this Contract.", 0, 1, this.party));
            children.add(new Property("signature", "Signature", "Legally binding Contract DSIG signature contents in Base64.", 0, Integer.MAX_VALUE, this.signature));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "Coding", "Role of this Contract signer, e.g. notary, grantee.", 0, 1, this.type);
                }
                case 106437350: {
                    return new Property("party", "Reference(Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "Party which is a signator to this Contract.", 0, 1, this.party);
                }
                case 1073584312: {
                    return new Property("signature", "Signature", "Legally binding Contract DSIG signature contents in Base64.", 0, Integer.MAX_VALUE, this.signature);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 106437350: {
                    Base[] baseArray;
                    if (this.party == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.party;
                    }
                    return baseArray;
                }
                case 1073584312: {
                    return this.signature == null ? new Base[]{} : this.signature.toArray(new Base[this.signature.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCoding(value);
                    return value;
                }
                case 106437350: {
                    this.party = this.castToReference(value);
                    return value;
                }
                case 1073584312: {
                    this.getSignature().add(this.castToSignature(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("party")) {
                this.party = this.castToReference(value);
            } else if (name.equals("signature")) {
                this.getSignature().add(this.castToSignature(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 106437350: {
                    return this.getParty();
                }
                case 1073584312: {
                    return this.addSignature();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"Coding"};
                }
                case 106437350: {
                    return new String[]{"Reference"};
                }
                case 1073584312: {
                    return new String[]{"Signature"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("party")) {
                this.party = new Reference();
                return this.party;
            }
            if (name.equals("signature")) {
                return this.addSignature();
            }
            return super.addChild(name);
        }

        @Override
        public SignatoryComponent copy() {
            SignatoryComponent dst = new SignatoryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SignatoryComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            Reference reference = dst.party = this.party == null ? null : this.party.copy();
            if (this.signature != null) {
                dst.signature = new ArrayList<Signature>();
                for (Signature i : this.signature) {
                    dst.signature.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SignatoryComponent)) {
                return false;
            }
            SignatoryComponent o = (SignatoryComponent)other_;
            return SignatoryComponent.compareDeep(this.type, o.type, true) && SignatoryComponent.compareDeep(this.party, o.party, true) && SignatoryComponent.compareDeep(this.signature, o.signature, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SignatoryComponent)) {
                return false;
            }
            SignatoryComponent o = (SignatoryComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.party, this.signature);
        }

        @Override
        public String fhirType() {
            return "Contract.signer";
        }
    }

    @Block
    public static class ActionSubjectComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="reference", type={Patient.class, RelatedPerson.class, Practitioner.class, PractitionerRole.class, Device.class, Group.class, Organization.class}, order=1, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Entity of the action", formalDefinition="The entity the action is performed or not performed on or for.")
        protected List<Reference> reference;
        protected List<Resource> referenceTarget;
        @Child(name="role", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Role type of the agent", formalDefinition="Role type of agent assigned roles in this Contract.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-actorrole")
        protected CodeableConcept role;
        private static final long serialVersionUID = 128949255L;

        public List<Reference> getReference() {
            if (this.reference == null) {
                this.reference = new ArrayList<Reference>();
            }
            return this.reference;
        }

        public ActionSubjectComponent setReference(List<Reference> theReference) {
            this.reference = theReference;
            return this;
        }

        public boolean hasReference() {
            if (this.reference == null) {
                return false;
            }
            for (Reference item : this.reference) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addReference() {
            Reference t = new Reference();
            if (this.reference == null) {
                this.reference = new ArrayList<Reference>();
            }
            this.reference.add(t);
            return t;
        }

        public ActionSubjectComponent addReference(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.reference == null) {
                this.reference = new ArrayList<Reference>();
            }
            this.reference.add(t);
            return this;
        }

        public Reference getReferenceFirstRep() {
            if (this.getReference().isEmpty()) {
                this.addReference();
            }
            return this.getReference().get(0);
        }

        @Deprecated
        public List<Resource> getReferenceTarget() {
            if (this.referenceTarget == null) {
                this.referenceTarget = new ArrayList<Resource>();
            }
            return this.referenceTarget;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActionSubjectComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public ActionSubjectComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("reference", "Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Device|Group|Organization)", "The entity the action is performed or not performed on or for.", 0, Integer.MAX_VALUE, this.reference));
            children.add(new Property("role", "CodeableConcept", "Role type of agent assigned roles in this Contract.", 0, 1, this.role));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -925155509: {
                    return new Property("reference", "Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Device|Group|Organization)", "The entity the action is performed or not performed on or for.", 0, Integer.MAX_VALUE, this.reference);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "Role type of agent assigned roles in this Contract.", 0, 1, this.role);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    return this.reference == null ? new Base[]{} : this.reference.toArray(new Base[this.reference.size()]);
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    this.getReference().add(this.castToReference(value));
                    return value;
                }
                case 3506294: {
                    this.role = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("reference")) {
                this.getReference().add(this.castToReference(value));
            } else if (name.equals("role")) {
                this.role = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    return this.addReference();
                }
                case 3506294: {
                    return this.getRole();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    return new String[]{"Reference"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("reference")) {
                return this.addReference();
            }
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            return super.addChild(name);
        }

        @Override
        public ActionSubjectComponent copy() {
            ActionSubjectComponent dst = new ActionSubjectComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ActionSubjectComponent dst) {
            super.copyValues(dst);
            if (this.reference != null) {
                dst.reference = new ArrayList<Reference>();
                for (Reference i : this.reference) {
                    dst.reference.add(i.copy());
                }
            }
            dst.role = this.role == null ? null : this.role.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ActionSubjectComponent)) {
                return false;
            }
            ActionSubjectComponent o = (ActionSubjectComponent)other_;
            return ActionSubjectComponent.compareDeep(this.reference, o.reference, true) && ActionSubjectComponent.compareDeep(this.role, o.role, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ActionSubjectComponent)) {
                return false;
            }
            ActionSubjectComponent o = (ActionSubjectComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.reference, this.role);
        }

        @Override
        public String fhirType() {
            return "Contract.term.action.subject";
        }
    }

    @Block
    public static class ActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="doNotPerform", type={BooleanType.class}, order=1, min=0, max=1, modifier=true, summary=false)
        @Description(shortDefinition="True if the term prohibits the  action", formalDefinition="True if the term prohibits the  action.")
        protected BooleanType doNotPerform;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type or form of the action", formalDefinition="Activity or service obligation to be done or not done, performed or not performed, effectuated or not by this Contract term.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-action")
        protected CodeableConcept type;
        @Child(name="subject", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Entity of the action", formalDefinition="Entity of the action.")
        protected List<ActionSubjectComponent> subject;
        @Child(name="intent", type={CodeableConcept.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Purpose for the Contract Term Action", formalDefinition="Reason or purpose for the action stipulated by this Contract Provision.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-PurposeOfUse")
        protected CodeableConcept intent;
        @Child(name="linkId", type={StringType.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Pointer to specific item", formalDefinition="Id [identifier??] of the clause or question text related to this action in the referenced form or QuestionnaireResponse.")
        protected List<StringType> linkId;
        @Child(name="status", type={CodeableConcept.class}, order=6, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="State of the action", formalDefinition="Current state of the term action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-actionstatus")
        protected CodeableConcept status;
        @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Episode associated with action", formalDefinition="Encounter or Episode with primary association to specified term activity.")
        protected Reference context;
        protected Resource contextTarget;
        @Child(name="contextLinkId", type={StringType.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Pointer to specific item", formalDefinition="Id [identifier??] of the clause or question text related to the requester of this action in the referenced form or QuestionnaireResponse.")
        protected List<StringType> contextLinkId;
        @Child(name="occurrence", type={DateTimeType.class, Period.class, Timing.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When action happens", formalDefinition="When action happens.")
        protected Type occurrence;
        @Child(name="requester", type={Patient.class, RelatedPerson.class, Practitioner.class, PractitionerRole.class, Device.class, Group.class, Organization.class}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Who asked for action", formalDefinition="Who or what initiated the action and has responsibility for its activation.")
        protected List<Reference> requester;
        protected List<Resource> requesterTarget;
        @Child(name="requesterLinkId", type={StringType.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Pointer to specific item", formalDefinition="Id [identifier??] of the clause or question text related to the requester of this action in the referenced form or QuestionnaireResponse.")
        protected List<StringType> requesterLinkId;
        @Child(name="performerType", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Kind of service performer", formalDefinition="The type of individual that is desired or required to perform or not perform the action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/provenance-agent-type")
        protected List<CodeableConcept> performerType;
        @Child(name="performerRole", type={CodeableConcept.class}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Competency of the performer", formalDefinition="The type of role or competency of an individual desired or required to perform or not perform the action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/provenance-agent-role")
        protected CodeableConcept performerRole;
        @Child(name="performer", type={RelatedPerson.class, Patient.class, Practitioner.class, PractitionerRole.class, CareTeam.class, Device.class, Substance.class, Organization.class, Location.class}, order=14, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Actor that wil execute (or not) the action", formalDefinition="Indicates who or what is being asked to perform (or not perform) the ction.")
        protected Reference performer;
        protected Resource performerTarget;
        @Child(name="performerLinkId", type={StringType.class}, order=15, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Pointer to specific item", formalDefinition="Id [identifier??] of the clause or question text related to the reason type or reference of this  action in the referenced form or QuestionnaireResponse.")
        protected List<StringType> performerLinkId;
        @Child(name="reasonCode", type={CodeableConcept.class}, order=16, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Why is action (not) needed?", formalDefinition="Rationale for the action to be performed or not performed. Describes why the action is permitted or prohibited.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-PurposeOfUse")
        protected List<CodeableConcept> reasonCode;
        @Child(name="reasonReference", type={Condition.class, Observation.class, DiagnosticReport.class, DocumentReference.class, Questionnaire.class, QuestionnaireResponse.class}, order=17, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Why is action (not) needed?", formalDefinition="Indicates another resource whose existence justifies permitting or not permitting this action.")
        protected List<Reference> reasonReference;
        protected List<Resource> reasonReferenceTarget;
        @Child(name="reason", type={StringType.class}, order=18, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Why action is to be performed", formalDefinition="Describes why the action is to be performed or not performed in textual form.")
        protected List<StringType> reason;
        @Child(name="reasonLinkId", type={StringType.class}, order=19, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Pointer to specific item", formalDefinition="Id [identifier??] of the clause or question text related to the reason type or reference of this  action in the referenced form or QuestionnaireResponse.")
        protected List<StringType> reasonLinkId;
        @Child(name="note", type={Annotation.class}, order=20, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Comments about the action", formalDefinition="Comments made about the term action made by the requester, performer, subject or other participants.")
        protected List<Annotation> note;
        @Child(name="securityLabelNumber", type={UnsignedIntType.class}, order=21, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Action restriction numbers", formalDefinition="Security labels that protects the action.")
        protected List<UnsignedIntType> securityLabelNumber;
        private static final long serialVersionUID = -178728180L;

        public ActionComponent() {
        }

        public ActionComponent(CodeableConcept type, CodeableConcept intent, CodeableConcept status) {
            this.type = type;
            this.intent = intent;
            this.status = status;
        }

        public BooleanType getDoNotPerformElement() {
            if (this.doNotPerform == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActionComponent.doNotPerform");
                }
                if (Configuration.doAutoCreate()) {
                    this.doNotPerform = new BooleanType();
                }
            }
            return this.doNotPerform;
        }

        public boolean hasDoNotPerformElement() {
            return this.doNotPerform != null && !this.doNotPerform.isEmpty();
        }

        public boolean hasDoNotPerform() {
            return this.doNotPerform != null && !this.doNotPerform.isEmpty();
        }

        public ActionComponent setDoNotPerformElement(BooleanType value) {
            this.doNotPerform = value;
            return this;
        }

        public boolean getDoNotPerform() {
            return this.doNotPerform == null || this.doNotPerform.isEmpty() ? false : (Boolean)this.doNotPerform.getValue();
        }

        public ActionComponent setDoNotPerform(boolean value) {
            if (this.doNotPerform == null) {
                this.doNotPerform = new BooleanType();
            }
            this.doNotPerform.setValue((Object)value);
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ActionComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<ActionSubjectComponent> getSubject() {
            if (this.subject == null) {
                this.subject = new ArrayList<ActionSubjectComponent>();
            }
            return this.subject;
        }

        public ActionComponent setSubject(List<ActionSubjectComponent> theSubject) {
            this.subject = theSubject;
            return this;
        }

        public boolean hasSubject() {
            if (this.subject == null) {
                return false;
            }
            for (ActionSubjectComponent item : this.subject) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ActionSubjectComponent addSubject() {
            ActionSubjectComponent t = new ActionSubjectComponent();
            if (this.subject == null) {
                this.subject = new ArrayList<ActionSubjectComponent>();
            }
            this.subject.add(t);
            return t;
        }

        public ActionComponent addSubject(ActionSubjectComponent t) {
            if (t == null) {
                return this;
            }
            if (this.subject == null) {
                this.subject = new ArrayList<ActionSubjectComponent>();
            }
            this.subject.add(t);
            return this;
        }

        public ActionSubjectComponent getSubjectFirstRep() {
            if (this.getSubject().isEmpty()) {
                this.addSubject();
            }
            return this.getSubject().get(0);
        }

        public CodeableConcept getIntent() {
            if (this.intent == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActionComponent.intent");
                }
                if (Configuration.doAutoCreate()) {
                    this.intent = new CodeableConcept();
                }
            }
            return this.intent;
        }

        public boolean hasIntent() {
            return this.intent != null && !this.intent.isEmpty();
        }

        public ActionComponent setIntent(CodeableConcept value) {
            this.intent = value;
            return this;
        }

        public List<StringType> getLinkId() {
            if (this.linkId == null) {
                this.linkId = new ArrayList<StringType>();
            }
            return this.linkId;
        }

        public ActionComponent setLinkId(List<StringType> theLinkId) {
            this.linkId = theLinkId;
            return this;
        }

        public boolean hasLinkId() {
            if (this.linkId == null) {
                return false;
            }
            for (StringType item : this.linkId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addLinkIdElement() {
            StringType t = new StringType();
            if (this.linkId == null) {
                this.linkId = new ArrayList<StringType>();
            }
            this.linkId.add(t);
            return t;
        }

        public ActionComponent addLinkId(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.linkId == null) {
                this.linkId = new ArrayList<StringType>();
            }
            this.linkId.add(t);
            return this;
        }

        public boolean hasLinkId(String value) {
            if (this.linkId == null) {
                return false;
            }
            for (StringType v : this.linkId) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept getStatus() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActionComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new CodeableConcept();
                }
            }
            return this.status;
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public ActionComponent setStatus(CodeableConcept value) {
            this.status = value;
            return this;
        }

        public Reference getContext() {
            if (this.context == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActionComponent.context");
                }
                if (Configuration.doAutoCreate()) {
                    this.context = new Reference();
                }
            }
            return this.context;
        }

        public boolean hasContext() {
            return this.context != null && !this.context.isEmpty();
        }

        public ActionComponent setContext(Reference value) {
            this.context = value;
            return this;
        }

        public Resource getContextTarget() {
            return this.contextTarget;
        }

        public ActionComponent setContextTarget(Resource value) {
            this.contextTarget = value;
            return this;
        }

        public List<StringType> getContextLinkId() {
            if (this.contextLinkId == null) {
                this.contextLinkId = new ArrayList<StringType>();
            }
            return this.contextLinkId;
        }

        public ActionComponent setContextLinkId(List<StringType> theContextLinkId) {
            this.contextLinkId = theContextLinkId;
            return this;
        }

        public boolean hasContextLinkId() {
            if (this.contextLinkId == null) {
                return false;
            }
            for (StringType item : this.contextLinkId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addContextLinkIdElement() {
            StringType t = new StringType();
            if (this.contextLinkId == null) {
                this.contextLinkId = new ArrayList<StringType>();
            }
            this.contextLinkId.add(t);
            return t;
        }

        public ActionComponent addContextLinkId(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.contextLinkId == null) {
                this.contextLinkId = new ArrayList<StringType>();
            }
            this.contextLinkId.add(t);
            return this;
        }

        public boolean hasContextLinkId(String value) {
            if (this.contextLinkId == null) {
                return false;
            }
            for (StringType v : this.contextLinkId) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public Type getOccurrence() {
            return this.occurrence;
        }

        public DateTimeType getOccurrenceDateTimeType() throws FHIRException {
            if (this.occurrence == null) {
                this.occurrence = new DateTimeType();
            }
            if (!(this.occurrence instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurrence.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.occurrence;
        }

        public boolean hasOccurrenceDateTimeType() {
            return this != null && this.occurrence instanceof DateTimeType;
        }

        public Period getOccurrencePeriod() throws FHIRException {
            if (this.occurrence == null) {
                this.occurrence = new Period();
            }
            if (!(this.occurrence instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.occurrence.getClass().getName() + " was encountered");
            }
            return (Period)this.occurrence;
        }

        public boolean hasOccurrencePeriod() {
            return this != null && this.occurrence instanceof Period;
        }

        public Timing getOccurrenceTiming() throws FHIRException {
            if (this.occurrence == null) {
                this.occurrence = new Timing();
            }
            if (!(this.occurrence instanceof Timing)) {
                throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.occurrence.getClass().getName() + " was encountered");
            }
            return (Timing)this.occurrence;
        }

        public boolean hasOccurrenceTiming() {
            return this != null && this.occurrence instanceof Timing;
        }

        public boolean hasOccurrence() {
            return this.occurrence != null && !this.occurrence.isEmpty();
        }

        public ActionComponent setOccurrence(Type value) {
            if (!(value == null || value instanceof DateTimeType || value instanceof Period || value instanceof Timing)) {
                throw new Error("Not the right type for Contract.term.action.occurrence[x]: " + value.fhirType());
            }
            this.occurrence = value;
            return this;
        }

        public List<Reference> getRequester() {
            if (this.requester == null) {
                this.requester = new ArrayList<Reference>();
            }
            return this.requester;
        }

        public ActionComponent setRequester(List<Reference> theRequester) {
            this.requester = theRequester;
            return this;
        }

        public boolean hasRequester() {
            if (this.requester == null) {
                return false;
            }
            for (Reference item : this.requester) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addRequester() {
            Reference t = new Reference();
            if (this.requester == null) {
                this.requester = new ArrayList<Reference>();
            }
            this.requester.add(t);
            return t;
        }

        public ActionComponent addRequester(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.requester == null) {
                this.requester = new ArrayList<Reference>();
            }
            this.requester.add(t);
            return this;
        }

        public Reference getRequesterFirstRep() {
            if (this.getRequester().isEmpty()) {
                this.addRequester();
            }
            return this.getRequester().get(0);
        }

        @Deprecated
        public List<Resource> getRequesterTarget() {
            if (this.requesterTarget == null) {
                this.requesterTarget = new ArrayList<Resource>();
            }
            return this.requesterTarget;
        }

        public List<StringType> getRequesterLinkId() {
            if (this.requesterLinkId == null) {
                this.requesterLinkId = new ArrayList<StringType>();
            }
            return this.requesterLinkId;
        }

        public ActionComponent setRequesterLinkId(List<StringType> theRequesterLinkId) {
            this.requesterLinkId = theRequesterLinkId;
            return this;
        }

        public boolean hasRequesterLinkId() {
            if (this.requesterLinkId == null) {
                return false;
            }
            for (StringType item : this.requesterLinkId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addRequesterLinkIdElement() {
            StringType t = new StringType();
            if (this.requesterLinkId == null) {
                this.requesterLinkId = new ArrayList<StringType>();
            }
            this.requesterLinkId.add(t);
            return t;
        }

        public ActionComponent addRequesterLinkId(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.requesterLinkId == null) {
                this.requesterLinkId = new ArrayList<StringType>();
            }
            this.requesterLinkId.add(t);
            return this;
        }

        public boolean hasRequesterLinkId(String value) {
            if (this.requesterLinkId == null) {
                return false;
            }
            for (StringType v : this.requesterLinkId) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<CodeableConcept> getPerformerType() {
            if (this.performerType == null) {
                this.performerType = new ArrayList<CodeableConcept>();
            }
            return this.performerType;
        }

        public ActionComponent setPerformerType(List<CodeableConcept> thePerformerType) {
            this.performerType = thePerformerType;
            return this;
        }

        public boolean hasPerformerType() {
            if (this.performerType == null) {
                return false;
            }
            for (CodeableConcept item : this.performerType) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addPerformerType() {
            CodeableConcept t = new CodeableConcept();
            if (this.performerType == null) {
                this.performerType = new ArrayList<CodeableConcept>();
            }
            this.performerType.add(t);
            return t;
        }

        public ActionComponent addPerformerType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.performerType == null) {
                this.performerType = new ArrayList<CodeableConcept>();
            }
            this.performerType.add(t);
            return this;
        }

        public CodeableConcept getPerformerTypeFirstRep() {
            if (this.getPerformerType().isEmpty()) {
                this.addPerformerType();
            }
            return this.getPerformerType().get(0);
        }

        public CodeableConcept getPerformerRole() {
            if (this.performerRole == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActionComponent.performerRole");
                }
                if (Configuration.doAutoCreate()) {
                    this.performerRole = new CodeableConcept();
                }
            }
            return this.performerRole;
        }

        public boolean hasPerformerRole() {
            return this.performerRole != null && !this.performerRole.isEmpty();
        }

        public ActionComponent setPerformerRole(CodeableConcept value) {
            this.performerRole = value;
            return this;
        }

        public Reference getPerformer() {
            if (this.performer == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActionComponent.performer");
                }
                if (Configuration.doAutoCreate()) {
                    this.performer = new Reference();
                }
            }
            return this.performer;
        }

        public boolean hasPerformer() {
            return this.performer != null && !this.performer.isEmpty();
        }

        public ActionComponent setPerformer(Reference value) {
            this.performer = value;
            return this;
        }

        public Resource getPerformerTarget() {
            return this.performerTarget;
        }

        public ActionComponent setPerformerTarget(Resource value) {
            this.performerTarget = value;
            return this;
        }

        public List<StringType> getPerformerLinkId() {
            if (this.performerLinkId == null) {
                this.performerLinkId = new ArrayList<StringType>();
            }
            return this.performerLinkId;
        }

        public ActionComponent setPerformerLinkId(List<StringType> thePerformerLinkId) {
            this.performerLinkId = thePerformerLinkId;
            return this;
        }

        public boolean hasPerformerLinkId() {
            if (this.performerLinkId == null) {
                return false;
            }
            for (StringType item : this.performerLinkId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addPerformerLinkIdElement() {
            StringType t = new StringType();
            if (this.performerLinkId == null) {
                this.performerLinkId = new ArrayList<StringType>();
            }
            this.performerLinkId.add(t);
            return t;
        }

        public ActionComponent addPerformerLinkId(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.performerLinkId == null) {
                this.performerLinkId = new ArrayList<StringType>();
            }
            this.performerLinkId.add(t);
            return this;
        }

        public boolean hasPerformerLinkId(String value) {
            if (this.performerLinkId == null) {
                return false;
            }
            for (StringType v : this.performerLinkId) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<CodeableConcept> getReasonCode() {
            if (this.reasonCode == null) {
                this.reasonCode = new ArrayList<CodeableConcept>();
            }
            return this.reasonCode;
        }

        public ActionComponent setReasonCode(List<CodeableConcept> theReasonCode) {
            this.reasonCode = theReasonCode;
            return this;
        }

        public boolean hasReasonCode() {
            if (this.reasonCode == null) {
                return false;
            }
            for (CodeableConcept item : this.reasonCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addReasonCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.reasonCode == null) {
                this.reasonCode = new ArrayList<CodeableConcept>();
            }
            this.reasonCode.add(t);
            return t;
        }

        public ActionComponent addReasonCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.reasonCode == null) {
                this.reasonCode = new ArrayList<CodeableConcept>();
            }
            this.reasonCode.add(t);
            return this;
        }

        public CodeableConcept getReasonCodeFirstRep() {
            if (this.getReasonCode().isEmpty()) {
                this.addReasonCode();
            }
            return this.getReasonCode().get(0);
        }

        public List<Reference> getReasonReference() {
            if (this.reasonReference == null) {
                this.reasonReference = new ArrayList<Reference>();
            }
            return this.reasonReference;
        }

        public ActionComponent setReasonReference(List<Reference> theReasonReference) {
            this.reasonReference = theReasonReference;
            return this;
        }

        public boolean hasReasonReference() {
            if (this.reasonReference == null) {
                return false;
            }
            for (Reference item : this.reasonReference) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addReasonReference() {
            Reference t = new Reference();
            if (this.reasonReference == null) {
                this.reasonReference = new ArrayList<Reference>();
            }
            this.reasonReference.add(t);
            return t;
        }

        public ActionComponent addReasonReference(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.reasonReference == null) {
                this.reasonReference = new ArrayList<Reference>();
            }
            this.reasonReference.add(t);
            return this;
        }

        public Reference getReasonReferenceFirstRep() {
            if (this.getReasonReference().isEmpty()) {
                this.addReasonReference();
            }
            return this.getReasonReference().get(0);
        }

        @Deprecated
        public List<Resource> getReasonReferenceTarget() {
            if (this.reasonReferenceTarget == null) {
                this.reasonReferenceTarget = new ArrayList<Resource>();
            }
            return this.reasonReferenceTarget;
        }

        public List<StringType> getReason() {
            if (this.reason == null) {
                this.reason = new ArrayList<StringType>();
            }
            return this.reason;
        }

        public ActionComponent setReason(List<StringType> theReason) {
            this.reason = theReason;
            return this;
        }

        public boolean hasReason() {
            if (this.reason == null) {
                return false;
            }
            for (StringType item : this.reason) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addReasonElement() {
            StringType t = new StringType();
            if (this.reason == null) {
                this.reason = new ArrayList<StringType>();
            }
            this.reason.add(t);
            return t;
        }

        public ActionComponent addReason(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.reason == null) {
                this.reason = new ArrayList<StringType>();
            }
            this.reason.add(t);
            return this;
        }

        public boolean hasReason(String value) {
            if (this.reason == null) {
                return false;
            }
            for (StringType v : this.reason) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<StringType> getReasonLinkId() {
            if (this.reasonLinkId == null) {
                this.reasonLinkId = new ArrayList<StringType>();
            }
            return this.reasonLinkId;
        }

        public ActionComponent setReasonLinkId(List<StringType> theReasonLinkId) {
            this.reasonLinkId = theReasonLinkId;
            return this;
        }

        public boolean hasReasonLinkId() {
            if (this.reasonLinkId == null) {
                return false;
            }
            for (StringType item : this.reasonLinkId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addReasonLinkIdElement() {
            StringType t = new StringType();
            if (this.reasonLinkId == null) {
                this.reasonLinkId = new ArrayList<StringType>();
            }
            this.reasonLinkId.add(t);
            return t;
        }

        public ActionComponent addReasonLinkId(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.reasonLinkId == null) {
                this.reasonLinkId = new ArrayList<StringType>();
            }
            this.reasonLinkId.add(t);
            return this;
        }

        public boolean hasReasonLinkId(String value) {
            if (this.reasonLinkId == null) {
                return false;
            }
            for (StringType v : this.reasonLinkId) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public ActionComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public ActionComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        public List<UnsignedIntType> getSecurityLabelNumber() {
            if (this.securityLabelNumber == null) {
                this.securityLabelNumber = new ArrayList<UnsignedIntType>();
            }
            return this.securityLabelNumber;
        }

        public ActionComponent setSecurityLabelNumber(List<UnsignedIntType> theSecurityLabelNumber) {
            this.securityLabelNumber = theSecurityLabelNumber;
            return this;
        }

        public boolean hasSecurityLabelNumber() {
            if (this.securityLabelNumber == null) {
                return false;
            }
            for (UnsignedIntType item : this.securityLabelNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UnsignedIntType addSecurityLabelNumberElement() {
            UnsignedIntType t = new UnsignedIntType();
            if (this.securityLabelNumber == null) {
                this.securityLabelNumber = new ArrayList<UnsignedIntType>();
            }
            this.securityLabelNumber.add(t);
            return t;
        }

        public ActionComponent addSecurityLabelNumber(int value) {
            UnsignedIntType t = new UnsignedIntType();
            t.setValue((Object)value);
            if (this.securityLabelNumber == null) {
                this.securityLabelNumber = new ArrayList<UnsignedIntType>();
            }
            this.securityLabelNumber.add(t);
            return this;
        }

        public boolean hasSecurityLabelNumber(int value) {
            if (this.securityLabelNumber == null) {
                return false;
            }
            for (UnsignedIntType v : this.securityLabelNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("doNotPerform", "boolean", "True if the term prohibits the  action.", 0, 1, this.doNotPerform));
            children.add(new Property("type", "CodeableConcept", "Activity or service obligation to be done or not done, performed or not performed, effectuated or not by this Contract term.", 0, 1, this.type));
            children.add(new Property(Contract.SP_SUBJECT, "", "Entity of the action.", 0, Integer.MAX_VALUE, this.subject));
            children.add(new Property("intent", "CodeableConcept", "Reason or purpose for the action stipulated by this Contract Provision.", 0, 1, this.intent));
            children.add(new Property("linkId", "string", "Id [identifier??] of the clause or question text related to this action in the referenced form or QuestionnaireResponse.", 0, Integer.MAX_VALUE, this.linkId));
            children.add(new Property(Contract.SP_STATUS, "CodeableConcept", "Current state of the term action.", 0, 1, this.status));
            children.add(new Property("context", "Reference(Encounter|EpisodeOfCare)", "Encounter or Episode with primary association to specified term activity.", 0, 1, this.context));
            children.add(new Property("contextLinkId", "string", "Id [identifier??] of the clause or question text related to the requester of this action in the referenced form or QuestionnaireResponse.", 0, Integer.MAX_VALUE, this.contextLinkId));
            children.add(new Property("occurrence[x]", "dateTime|Period|Timing", "When action happens.", 0, 1, this.occurrence));
            children.add(new Property("requester", "Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Device|Group|Organization)", "Who or what initiated the action and has responsibility for its activation.", 0, Integer.MAX_VALUE, this.requester));
            children.add(new Property("requesterLinkId", "string", "Id [identifier??] of the clause or question text related to the requester of this action in the referenced form or QuestionnaireResponse.", 0, Integer.MAX_VALUE, this.requesterLinkId));
            children.add(new Property("performerType", "CodeableConcept", "The type of individual that is desired or required to perform or not perform the action.", 0, Integer.MAX_VALUE, this.performerType));
            children.add(new Property("performerRole", "CodeableConcept", "The type of role or competency of an individual desired or required to perform or not perform the action.", 0, 1, this.performerRole));
            children.add(new Property("performer", "Reference(RelatedPerson|Patient|Practitioner|PractitionerRole|CareTeam|Device|Substance|Organization|Location)", "Indicates who or what is being asked to perform (or not perform) the ction.", 0, 1, this.performer));
            children.add(new Property("performerLinkId", "string", "Id [identifier??] of the clause or question text related to the reason type or reference of this  action in the referenced form or QuestionnaireResponse.", 0, Integer.MAX_VALUE, this.performerLinkId));
            children.add(new Property("reasonCode", "CodeableConcept", "Rationale for the action to be performed or not performed. Describes why the action is permitted or prohibited.", 0, Integer.MAX_VALUE, this.reasonCode));
            children.add(new Property("reasonReference", "Reference(Condition|Observation|DiagnosticReport|DocumentReference|Questionnaire|QuestionnaireResponse)", "Indicates another resource whose existence justifies permitting or not permitting this action.", 0, Integer.MAX_VALUE, this.reasonReference));
            children.add(new Property("reason", "string", "Describes why the action is to be performed or not performed in textual form.", 0, Integer.MAX_VALUE, this.reason));
            children.add(new Property("reasonLinkId", "string", "Id [identifier??] of the clause or question text related to the reason type or reference of this  action in the referenced form or QuestionnaireResponse.", 0, Integer.MAX_VALUE, this.reasonLinkId));
            children.add(new Property("note", "Annotation", "Comments made about the term action made by the requester, performer, subject or other participants.", 0, Integer.MAX_VALUE, this.note));
            children.add(new Property("securityLabelNumber", "unsignedInt", "Security labels that protects the action.", 0, Integer.MAX_VALUE, this.securityLabelNumber));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1788508167: {
                    return new Property("doNotPerform", "boolean", "True if the term prohibits the  action.", 0, 1, this.doNotPerform);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Activity or service obligation to be done or not done, performed or not performed, effectuated or not by this Contract term.", 0, 1, this.type);
                }
                case -1867885268: {
                    return new Property(Contract.SP_SUBJECT, "", "Entity of the action.", 0, Integer.MAX_VALUE, this.subject);
                }
                case -1183762788: {
                    return new Property("intent", "CodeableConcept", "Reason or purpose for the action stipulated by this Contract Provision.", 0, 1, this.intent);
                }
                case -1102667083: {
                    return new Property("linkId", "string", "Id [identifier??] of the clause or question text related to this action in the referenced form or QuestionnaireResponse.", 0, Integer.MAX_VALUE, this.linkId);
                }
                case -892481550: {
                    return new Property(Contract.SP_STATUS, "CodeableConcept", "Current state of the term action.", 0, 1, this.status);
                }
                case 951530927: {
                    return new Property("context", "Reference(Encounter|EpisodeOfCare)", "Encounter or Episode with primary association to specified term activity.", 0, 1, this.context);
                }
                case -288783036: {
                    return new Property("contextLinkId", "string", "Id [identifier??] of the clause or question text related to the requester of this action in the referenced form or QuestionnaireResponse.", 0, Integer.MAX_VALUE, this.contextLinkId);
                }
                case -2022646513: {
                    return new Property("occurrence[x]", "dateTime|Period|Timing", "When action happens.", 0, 1, this.occurrence);
                }
                case 1687874001: {
                    return new Property("occurrence[x]", "dateTime|Period|Timing", "When action happens.", 0, 1, this.occurrence);
                }
                case -298443636: {
                    return new Property("occurrence[x]", "dateTime|Period|Timing", "When action happens.", 0, 1, this.occurrence);
                }
                case 1397156594: {
                    return new Property("occurrence[x]", "dateTime|Period|Timing", "When action happens.", 0, 1, this.occurrence);
                }
                case 1515218299: {
                    return new Property("occurrence[x]", "dateTime|Period|Timing", "When action happens.", 0, 1, this.occurrence);
                }
                case 693933948: {
                    return new Property("requester", "Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Device|Group|Organization)", "Who or what initiated the action and has responsibility for its activation.", 0, Integer.MAX_VALUE, this.requester);
                }
                case -1468032687: {
                    return new Property("requesterLinkId", "string", "Id [identifier??] of the clause or question text related to the requester of this action in the referenced form or QuestionnaireResponse.", 0, Integer.MAX_VALUE, this.requesterLinkId);
                }
                case -901444568: {
                    return new Property("performerType", "CodeableConcept", "The type of individual that is desired or required to perform or not perform the action.", 0, Integer.MAX_VALUE, this.performerType);
                }
                case -901513884: {
                    return new Property("performerRole", "CodeableConcept", "The type of role or competency of an individual desired or required to perform or not perform the action.", 0, 1, this.performerRole);
                }
                case 481140686: {
                    return new Property("performer", "Reference(RelatedPerson|Patient|Practitioner|PractitionerRole|CareTeam|Device|Substance|Organization|Location)", "Indicates who or what is being asked to perform (or not perform) the ction.", 0, 1, this.performer);
                }
                case 1051302947: {
                    return new Property("performerLinkId", "string", "Id [identifier??] of the clause or question text related to the reason type or reference of this  action in the referenced form or QuestionnaireResponse.", 0, Integer.MAX_VALUE, this.performerLinkId);
                }
                case 722137681: {
                    return new Property("reasonCode", "CodeableConcept", "Rationale for the action to be performed or not performed. Describes why the action is permitted or prohibited.", 0, Integer.MAX_VALUE, this.reasonCode);
                }
                case -1146218137: {
                    return new Property("reasonReference", "Reference(Condition|Observation|DiagnosticReport|DocumentReference|Questionnaire|QuestionnaireResponse)", "Indicates another resource whose existence justifies permitting or not permitting this action.", 0, Integer.MAX_VALUE, this.reasonReference);
                }
                case -934964668: {
                    return new Property("reason", "string", "Describes why the action is to be performed or not performed in textual form.", 0, Integer.MAX_VALUE, this.reason);
                }
                case -1557963239: {
                    return new Property("reasonLinkId", "string", "Id [identifier??] of the clause or question text related to the reason type or reference of this  action in the referenced form or QuestionnaireResponse.", 0, Integer.MAX_VALUE, this.reasonLinkId);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Comments made about the term action made by the requester, performer, subject or other participants.", 0, Integer.MAX_VALUE, this.note);
                }
                case -149460995: {
                    return new Property("securityLabelNumber", "unsignedInt", "Security labels that protects the action.", 0, Integer.MAX_VALUE, this.securityLabelNumber);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1788508167: {
                    Base[] baseArray;
                    if (this.doNotPerform == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.doNotPerform;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -1867885268: {
                    return this.subject == null ? new Base[]{} : this.subject.toArray(new Base[this.subject.size()]);
                }
                case -1183762788: {
                    Base[] baseArray;
                    if (this.intent == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.intent;
                    }
                    return baseArray;
                }
                case -1102667083: {
                    return this.linkId == null ? new Base[]{} : this.linkId.toArray(new Base[this.linkId.size()]);
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.status;
                    }
                    return baseArray;
                }
                case 951530927: {
                    Base[] baseArray;
                    if (this.context == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.context;
                    }
                    return baseArray;
                }
                case -288783036: {
                    return this.contextLinkId == null ? new Base[]{} : this.contextLinkId.toArray(new Base[this.contextLinkId.size()]);
                }
                case 1687874001: {
                    Base[] baseArray;
                    if (this.occurrence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.occurrence;
                    }
                    return baseArray;
                }
                case 693933948: {
                    return this.requester == null ? new Base[]{} : this.requester.toArray(new Base[this.requester.size()]);
                }
                case -1468032687: {
                    return this.requesterLinkId == null ? new Base[]{} : this.requesterLinkId.toArray(new Base[this.requesterLinkId.size()]);
                }
                case -901444568: {
                    return this.performerType == null ? new Base[]{} : this.performerType.toArray(new Base[this.performerType.size()]);
                }
                case -901513884: {
                    Base[] baseArray;
                    if (this.performerRole == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.performerRole;
                    }
                    return baseArray;
                }
                case 481140686: {
                    Base[] baseArray;
                    if (this.performer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.performer;
                    }
                    return baseArray;
                }
                case 1051302947: {
                    return this.performerLinkId == null ? new Base[]{} : this.performerLinkId.toArray(new Base[this.performerLinkId.size()]);
                }
                case 722137681: {
                    return this.reasonCode == null ? new Base[]{} : this.reasonCode.toArray(new Base[this.reasonCode.size()]);
                }
                case -1146218137: {
                    return this.reasonReference == null ? new Base[]{} : this.reasonReference.toArray(new Base[this.reasonReference.size()]);
                }
                case -934964668: {
                    return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
                }
                case -1557963239: {
                    return this.reasonLinkId == null ? new Base[]{} : this.reasonLinkId.toArray(new Base[this.reasonLinkId.size()]);
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
                case -149460995: {
                    return this.securityLabelNumber == null ? new Base[]{} : this.securityLabelNumber.toArray(new Base[this.securityLabelNumber.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1788508167: {
                    this.doNotPerform = this.castToBoolean(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1867885268: {
                    this.getSubject().add((ActionSubjectComponent)value);
                    return value;
                }
                case -1183762788: {
                    this.intent = this.castToCodeableConcept(value);
                    return value;
                }
                case -1102667083: {
                    this.getLinkId().add(this.castToString(value));
                    return value;
                }
                case -892481550: {
                    this.status = this.castToCodeableConcept(value);
                    return value;
                }
                case 951530927: {
                    this.context = this.castToReference(value);
                    return value;
                }
                case -288783036: {
                    this.getContextLinkId().add(this.castToString(value));
                    return value;
                }
                case 1687874001: {
                    this.occurrence = this.castToType(value);
                    return value;
                }
                case 693933948: {
                    this.getRequester().add(this.castToReference(value));
                    return value;
                }
                case -1468032687: {
                    this.getRequesterLinkId().add(this.castToString(value));
                    return value;
                }
                case -901444568: {
                    this.getPerformerType().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -901513884: {
                    this.performerRole = this.castToCodeableConcept(value);
                    return value;
                }
                case 481140686: {
                    this.performer = this.castToReference(value);
                    return value;
                }
                case 1051302947: {
                    this.getPerformerLinkId().add(this.castToString(value));
                    return value;
                }
                case 722137681: {
                    this.getReasonCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1146218137: {
                    this.getReasonReference().add(this.castToReference(value));
                    return value;
                }
                case -934964668: {
                    this.getReason().add(this.castToString(value));
                    return value;
                }
                case -1557963239: {
                    this.getReasonLinkId().add(this.castToString(value));
                    return value;
                }
                case 3387378: {
                    this.getNote().add(this.castToAnnotation(value));
                    return value;
                }
                case -149460995: {
                    this.getSecurityLabelNumber().add(this.castToUnsignedInt(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("doNotPerform")) {
                this.doNotPerform = this.castToBoolean(value);
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals(Contract.SP_SUBJECT)) {
                this.getSubject().add((ActionSubjectComponent)value);
            } else if (name.equals("intent")) {
                this.intent = this.castToCodeableConcept(value);
            } else if (name.equals("linkId")) {
                this.getLinkId().add(this.castToString(value));
            } else if (name.equals(Contract.SP_STATUS)) {
                this.status = this.castToCodeableConcept(value);
            } else if (name.equals("context")) {
                this.context = this.castToReference(value);
            } else if (name.equals("contextLinkId")) {
                this.getContextLinkId().add(this.castToString(value));
            } else if (name.equals("occurrence[x]")) {
                this.occurrence = this.castToType(value);
            } else if (name.equals("requester")) {
                this.getRequester().add(this.castToReference(value));
            } else if (name.equals("requesterLinkId")) {
                this.getRequesterLinkId().add(this.castToString(value));
            } else if (name.equals("performerType")) {
                this.getPerformerType().add(this.castToCodeableConcept(value));
            } else if (name.equals("performerRole")) {
                this.performerRole = this.castToCodeableConcept(value);
            } else if (name.equals("performer")) {
                this.performer = this.castToReference(value);
            } else if (name.equals("performerLinkId")) {
                this.getPerformerLinkId().add(this.castToString(value));
            } else if (name.equals("reasonCode")) {
                this.getReasonCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("reasonReference")) {
                this.getReasonReference().add(this.castToReference(value));
            } else if (name.equals("reason")) {
                this.getReason().add(this.castToString(value));
            } else if (name.equals("reasonLinkId")) {
                this.getReasonLinkId().add(this.castToString(value));
            } else if (name.equals("note")) {
                this.getNote().add(this.castToAnnotation(value));
            } else if (name.equals("securityLabelNumber")) {
                this.getSecurityLabelNumber().add(this.castToUnsignedInt(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1788508167: {
                    return this.getDoNotPerformElement();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1867885268: {
                    return this.addSubject();
                }
                case -1183762788: {
                    return this.getIntent();
                }
                case -1102667083: {
                    return this.addLinkIdElement();
                }
                case -892481550: {
                    return this.getStatus();
                }
                case 951530927: {
                    return this.getContext();
                }
                case -288783036: {
                    return this.addContextLinkIdElement();
                }
                case -2022646513: {
                    return this.getOccurrence();
                }
                case 1687874001: {
                    return this.getOccurrence();
                }
                case 693933948: {
                    return this.addRequester();
                }
                case -1468032687: {
                    return this.addRequesterLinkIdElement();
                }
                case -901444568: {
                    return this.addPerformerType();
                }
                case -901513884: {
                    return this.getPerformerRole();
                }
                case 481140686: {
                    return this.getPerformer();
                }
                case 1051302947: {
                    return this.addPerformerLinkIdElement();
                }
                case 722137681: {
                    return this.addReasonCode();
                }
                case -1146218137: {
                    return this.addReasonReference();
                }
                case -934964668: {
                    return this.addReasonElement();
                }
                case -1557963239: {
                    return this.addReasonLinkIdElement();
                }
                case 3387378: {
                    return this.addNote();
                }
                case -149460995: {
                    return this.addSecurityLabelNumberElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1788508167: {
                    return new String[]{"boolean"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1867885268: {
                    return new String[0];
                }
                case -1183762788: {
                    return new String[]{"CodeableConcept"};
                }
                case -1102667083: {
                    return new String[]{"string"};
                }
                case -892481550: {
                    return new String[]{"CodeableConcept"};
                }
                case 951530927: {
                    return new String[]{"Reference"};
                }
                case -288783036: {
                    return new String[]{"string"};
                }
                case 1687874001: {
                    return new String[]{"dateTime", "Period", "Timing"};
                }
                case 693933948: {
                    return new String[]{"Reference"};
                }
                case -1468032687: {
                    return new String[]{"string"};
                }
                case -901444568: {
                    return new String[]{"CodeableConcept"};
                }
                case -901513884: {
                    return new String[]{"CodeableConcept"};
                }
                case 481140686: {
                    return new String[]{"Reference"};
                }
                case 1051302947: {
                    return new String[]{"string"};
                }
                case 722137681: {
                    return new String[]{"CodeableConcept"};
                }
                case -1146218137: {
                    return new String[]{"Reference"};
                }
                case -934964668: {
                    return new String[]{"string"};
                }
                case -1557963239: {
                    return new String[]{"string"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case -149460995: {
                    return new String[]{"unsignedInt"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("doNotPerform")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.doNotPerform");
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals(Contract.SP_SUBJECT)) {
                return this.addSubject();
            }
            if (name.equals("intent")) {
                this.intent = new CodeableConcept();
                return this.intent;
            }
            if (name.equals("linkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.linkId");
            }
            if (name.equals(Contract.SP_STATUS)) {
                this.status = new CodeableConcept();
                return this.status;
            }
            if (name.equals("context")) {
                this.context = new Reference();
                return this.context;
            }
            if (name.equals("contextLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.contextLinkId");
            }
            if (name.equals("occurrenceDateTime")) {
                this.occurrence = new DateTimeType();
                return this.occurrence;
            }
            if (name.equals("occurrencePeriod")) {
                this.occurrence = new Period();
                return this.occurrence;
            }
            if (name.equals("occurrenceTiming")) {
                this.occurrence = new Timing();
                return this.occurrence;
            }
            if (name.equals("requester")) {
                return this.addRequester();
            }
            if (name.equals("requesterLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.requesterLinkId");
            }
            if (name.equals("performerType")) {
                return this.addPerformerType();
            }
            if (name.equals("performerRole")) {
                this.performerRole = new CodeableConcept();
                return this.performerRole;
            }
            if (name.equals("performer")) {
                this.performer = new Reference();
                return this.performer;
            }
            if (name.equals("performerLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.performerLinkId");
            }
            if (name.equals("reasonCode")) {
                return this.addReasonCode();
            }
            if (name.equals("reasonReference")) {
                return this.addReasonReference();
            }
            if (name.equals("reason")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.reason");
            }
            if (name.equals("reasonLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.reasonLinkId");
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            if (name.equals("securityLabelNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.securityLabelNumber");
            }
            return super.addChild(name);
        }

        @Override
        public ActionComponent copy() {
            ActionComponent dst = new ActionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ActionComponent dst) {
            super.copyValues(dst);
            dst.doNotPerform = this.doNotPerform == null ? null : this.doNotPerform.copy();
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.subject != null) {
                dst.subject = new ArrayList<ActionSubjectComponent>();
                for (ActionSubjectComponent actionSubjectComponent : this.subject) {
                    dst.subject.add(actionSubjectComponent.copy());
                }
            }
            CodeableConcept codeableConcept2 = dst.intent = this.intent == null ? null : this.intent.copy();
            if (this.linkId != null) {
                dst.linkId = new ArrayList<StringType>();
                for (StringType stringType : this.linkId) {
                    dst.linkId.add(stringType.copy());
                }
            }
            dst.status = this.status == null ? null : this.status.copy();
            Reference reference = dst.context = this.context == null ? null : this.context.copy();
            if (this.contextLinkId != null) {
                dst.contextLinkId = new ArrayList<StringType>();
                for (StringType stringType : this.contextLinkId) {
                    dst.contextLinkId.add(stringType.copy());
                }
            }
            Type type = dst.occurrence = this.occurrence == null ? null : this.occurrence.copy();
            if (this.requester != null) {
                dst.requester = new ArrayList<Reference>();
                for (Reference reference2 : this.requester) {
                    dst.requester.add(reference2.copy());
                }
            }
            if (this.requesterLinkId != null) {
                dst.requesterLinkId = new ArrayList<StringType>();
                for (StringType stringType : this.requesterLinkId) {
                    dst.requesterLinkId.add(stringType.copy());
                }
            }
            if (this.performerType != null) {
                dst.performerType = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept3 : this.performerType) {
                    dst.performerType.add(codeableConcept3.copy());
                }
            }
            dst.performerRole = this.performerRole == null ? null : this.performerRole.copy();
            Reference reference3 = dst.performer = this.performer == null ? null : this.performer.copy();
            if (this.performerLinkId != null) {
                dst.performerLinkId = new ArrayList<StringType>();
                for (StringType stringType : this.performerLinkId) {
                    dst.performerLinkId.add(stringType.copy());
                }
            }
            if (this.reasonCode != null) {
                dst.reasonCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept4 : this.reasonCode) {
                    dst.reasonCode.add(codeableConcept4.copy());
                }
            }
            if (this.reasonReference != null) {
                dst.reasonReference = new ArrayList<Reference>();
                for (Reference reference4 : this.reasonReference) {
                    dst.reasonReference.add(reference4.copy());
                }
            }
            if (this.reason != null) {
                dst.reason = new ArrayList<StringType>();
                for (StringType stringType : this.reason) {
                    dst.reason.add(stringType.copy());
                }
            }
            if (this.reasonLinkId != null) {
                dst.reasonLinkId = new ArrayList<StringType>();
                for (StringType stringType : this.reasonLinkId) {
                    dst.reasonLinkId.add(stringType.copy());
                }
            }
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation annotation : this.note) {
                    dst.note.add(annotation.copy());
                }
            }
            if (this.securityLabelNumber != null) {
                dst.securityLabelNumber = new ArrayList<UnsignedIntType>();
                for (UnsignedIntType unsignedIntType : this.securityLabelNumber) {
                    dst.securityLabelNumber.add(unsignedIntType.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ActionComponent)) {
                return false;
            }
            ActionComponent o = (ActionComponent)other_;
            return ActionComponent.compareDeep(this.doNotPerform, o.doNotPerform, true) && ActionComponent.compareDeep(this.type, o.type, true) && ActionComponent.compareDeep(this.subject, o.subject, true) && ActionComponent.compareDeep(this.intent, o.intent, true) && ActionComponent.compareDeep(this.linkId, o.linkId, true) && ActionComponent.compareDeep(this.status, o.status, true) && ActionComponent.compareDeep(this.context, o.context, true) && ActionComponent.compareDeep(this.contextLinkId, o.contextLinkId, true) && ActionComponent.compareDeep(this.occurrence, o.occurrence, true) && ActionComponent.compareDeep(this.requester, o.requester, true) && ActionComponent.compareDeep(this.requesterLinkId, o.requesterLinkId, true) && ActionComponent.compareDeep(this.performerType, o.performerType, true) && ActionComponent.compareDeep(this.performerRole, o.performerRole, true) && ActionComponent.compareDeep(this.performer, o.performer, true) && ActionComponent.compareDeep(this.performerLinkId, o.performerLinkId, true) && ActionComponent.compareDeep(this.reasonCode, o.reasonCode, true) && ActionComponent.compareDeep(this.reasonReference, o.reasonReference, true) && ActionComponent.compareDeep(this.reason, o.reason, true) && ActionComponent.compareDeep(this.reasonLinkId, o.reasonLinkId, true) && ActionComponent.compareDeep(this.note, o.note, true) && ActionComponent.compareDeep(this.securityLabelNumber, o.securityLabelNumber, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ActionComponent)) {
                return false;
            }
            ActionComponent o = (ActionComponent)other_;
            return ActionComponent.compareValues(this.doNotPerform, o.doNotPerform, true) && ActionComponent.compareValues(this.linkId, o.linkId, true) && ActionComponent.compareValues(this.contextLinkId, o.contextLinkId, true) && ActionComponent.compareValues(this.requesterLinkId, o.requesterLinkId, true) && ActionComponent.compareValues(this.performerLinkId, o.performerLinkId, true) && ActionComponent.compareValues(this.reason, o.reason, true) && ActionComponent.compareValues(this.reasonLinkId, o.reasonLinkId, true) && ActionComponent.compareValues(this.securityLabelNumber, o.securityLabelNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.doNotPerform, this.type, this.subject, this.intent, this.linkId, this.status, this.context, this.contextLinkId, this.occurrence, this.requester, this.requesterLinkId, this.performerType, this.performerRole, this.performer, this.performerLinkId, this.reasonCode, this.reasonReference, this.reason, this.reasonLinkId, this.note, this.securityLabelNumber);
        }

        @Override
        public String fhirType() {
            return "Contract.term.action";
        }
    }

    @Block
    public static class ValuedItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="entity", type={CodeableConcept.class, Reference.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Valued Item Type", formalDefinition="Specific type of Contract Valued Item that may be priced.")
        protected Type entity;
        @Child(name="identifier", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Valued Item Number", formalDefinition="Identifies a Contract Valued Item instance.")
        protected Identifier identifier;
        @Child(name="effectiveTime", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Valued Item Effective Tiem", formalDefinition="Indicates the time during which this Contract ValuedItem information is effective.")
        protected DateTimeType effectiveTime;
        @Child(name="quantity", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of Contract Valued Items", formalDefinition="Specifies the units by which the Contract Valued Item is measured or counted, and quantifies the countable or measurable Contract Valued Item instances.")
        protected Quantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Valued Item fee, charge, or cost", formalDefinition="A Contract Valued Item unit valuation measure.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Valued Item Price Scaling Factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of the Contract Valued Item delivered. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="points", type={DecimalType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Valued Item Difficulty Scaling Factor", formalDefinition="An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the Contract Valued Item delivered. The concept of Points allows for assignment of point values for a Contract Valued Item, such that a monetary amount can be assigned to each point.")
        protected DecimalType points;
        @Child(name="net", type={Money.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total Contract Valued Item Value", formalDefinition="Expresses the product of the Contract Valued Item unitQuantity and the unitPriceAmt. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        @Child(name="payment", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Terms of valuation", formalDefinition="Terms of valuation.")
        protected StringType payment;
        @Child(name="paymentDate", type={DateTimeType.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When payment is due", formalDefinition="When payment is due.")
        protected DateTimeType paymentDate;
        @Child(name="responsible", type={Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who will make payment", formalDefinition="Who will make payment.")
        protected Reference responsible;
        protected Resource responsibleTarget;
        @Child(name="recipient", type={Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who will receive payment", formalDefinition="Who will receive payment.")
        protected Reference recipient;
        protected Resource recipientTarget;
        @Child(name="linkId", type={StringType.class}, order=13, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Pointer to specific item", formalDefinition="Id  of the clause or question text related to the context of this valuedItem in the referenced form or QuestionnaireResponse.")
        protected List<StringType> linkId;
        @Child(name="securityLabelNumber", type={UnsignedIntType.class}, order=14, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Security Labels that define affected terms", formalDefinition="A set of security labels that define which terms are controlled by this condition.")
        protected List<UnsignedIntType> securityLabelNumber;
        private static final long serialVersionUID = 1894951601L;

        public Type getEntity() {
            return this.entity;
        }

        public CodeableConcept getEntityCodeableConcept() throws FHIRException {
            if (this.entity == null) {
                this.entity = new CodeableConcept();
            }
            if (!(this.entity instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.entity.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.entity;
        }

        public boolean hasEntityCodeableConcept() {
            return this != null && this.entity instanceof CodeableConcept;
        }

        public Reference getEntityReference() throws FHIRException {
            if (this.entity == null) {
                this.entity = new Reference();
            }
            if (!(this.entity instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.entity.getClass().getName() + " was encountered");
            }
            return (Reference)this.entity;
        }

        public boolean hasEntityReference() {
            return this != null && this.entity instanceof Reference;
        }

        public boolean hasEntity() {
            return this.entity != null && !this.entity.isEmpty();
        }

        public ValuedItemComponent setEntity(Type value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for Contract.term.asset.valuedItem.entity[x]: " + value.fhirType());
            }
            this.entity = value;
            return this;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public ValuedItemComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public DateTimeType getEffectiveTimeElement() {
            if (this.effectiveTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.effectiveTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.effectiveTime = new DateTimeType();
                }
            }
            return this.effectiveTime;
        }

        public boolean hasEffectiveTimeElement() {
            return this.effectiveTime != null && !this.effectiveTime.isEmpty();
        }

        public boolean hasEffectiveTime() {
            return this.effectiveTime != null && !this.effectiveTime.isEmpty();
        }

        public ValuedItemComponent setEffectiveTimeElement(DateTimeType value) {
            this.effectiveTime = value;
            return this;
        }

        public Date getEffectiveTime() {
            return this.effectiveTime == null ? null : (Date)this.effectiveTime.getValue();
        }

        public ValuedItemComponent setEffectiveTime(Date value) {
            if (value == null) {
                this.effectiveTime = null;
            } else {
                if (this.effectiveTime == null) {
                    this.effectiveTime = new DateTimeType();
                }
                this.effectiveTime.setValue(value);
            }
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public ValuedItemComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public ValuedItemComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public ValuedItemComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public ValuedItemComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public ValuedItemComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public ValuedItemComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public DecimalType getPointsElement() {
            if (this.points == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.points");
                }
                if (Configuration.doAutoCreate()) {
                    this.points = new DecimalType();
                }
            }
            return this.points;
        }

        public boolean hasPointsElement() {
            return this.points != null && !this.points.isEmpty();
        }

        public boolean hasPoints() {
            return this.points != null && !this.points.isEmpty();
        }

        public ValuedItemComponent setPointsElement(DecimalType value) {
            this.points = value;
            return this;
        }

        public BigDecimal getPoints() {
            return this.points == null ? null : (BigDecimal)this.points.getValue();
        }

        public ValuedItemComponent setPoints(BigDecimal value) {
            if (value == null) {
                this.points = null;
            } else {
                if (this.points == null) {
                    this.points = new DecimalType();
                }
                this.points.setValue(value);
            }
            return this;
        }

        public ValuedItemComponent setPoints(long value) {
            this.points = new DecimalType();
            this.points.setValue(value);
            return this;
        }

        public ValuedItemComponent setPoints(double value) {
            this.points = new DecimalType();
            this.points.setValue(value);
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public ValuedItemComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public StringType getPaymentElement() {
            if (this.payment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.payment");
                }
                if (Configuration.doAutoCreate()) {
                    this.payment = new StringType();
                }
            }
            return this.payment;
        }

        public boolean hasPaymentElement() {
            return this.payment != null && !this.payment.isEmpty();
        }

        public boolean hasPayment() {
            return this.payment != null && !this.payment.isEmpty();
        }

        public ValuedItemComponent setPaymentElement(StringType value) {
            this.payment = value;
            return this;
        }

        public String getPayment() {
            return this.payment == null ? null : (String)this.payment.getValue();
        }

        public ValuedItemComponent setPayment(String value) {
            if (Utilities.noString(value)) {
                this.payment = null;
            } else {
                if (this.payment == null) {
                    this.payment = new StringType();
                }
                this.payment.setValue(value);
            }
            return this;
        }

        public DateTimeType getPaymentDateElement() {
            if (this.paymentDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.paymentDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.paymentDate = new DateTimeType();
                }
            }
            return this.paymentDate;
        }

        public boolean hasPaymentDateElement() {
            return this.paymentDate != null && !this.paymentDate.isEmpty();
        }

        public boolean hasPaymentDate() {
            return this.paymentDate != null && !this.paymentDate.isEmpty();
        }

        public ValuedItemComponent setPaymentDateElement(DateTimeType value) {
            this.paymentDate = value;
            return this;
        }

        public Date getPaymentDate() {
            return this.paymentDate == null ? null : (Date)this.paymentDate.getValue();
        }

        public ValuedItemComponent setPaymentDate(Date value) {
            if (value == null) {
                this.paymentDate = null;
            } else {
                if (this.paymentDate == null) {
                    this.paymentDate = new DateTimeType();
                }
                this.paymentDate.setValue(value);
            }
            return this;
        }

        public Reference getResponsible() {
            if (this.responsible == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.responsible");
                }
                if (Configuration.doAutoCreate()) {
                    this.responsible = new Reference();
                }
            }
            return this.responsible;
        }

        public boolean hasResponsible() {
            return this.responsible != null && !this.responsible.isEmpty();
        }

        public ValuedItemComponent setResponsible(Reference value) {
            this.responsible = value;
            return this;
        }

        public Resource getResponsibleTarget() {
            return this.responsibleTarget;
        }

        public ValuedItemComponent setResponsibleTarget(Resource value) {
            this.responsibleTarget = value;
            return this;
        }

        public Reference getRecipient() {
            if (this.recipient == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.recipient");
                }
                if (Configuration.doAutoCreate()) {
                    this.recipient = new Reference();
                }
            }
            return this.recipient;
        }

        public boolean hasRecipient() {
            return this.recipient != null && !this.recipient.isEmpty();
        }

        public ValuedItemComponent setRecipient(Reference value) {
            this.recipient = value;
            return this;
        }

        public Resource getRecipientTarget() {
            return this.recipientTarget;
        }

        public ValuedItemComponent setRecipientTarget(Resource value) {
            this.recipientTarget = value;
            return this;
        }

        public List<StringType> getLinkId() {
            if (this.linkId == null) {
                this.linkId = new ArrayList<StringType>();
            }
            return this.linkId;
        }

        public ValuedItemComponent setLinkId(List<StringType> theLinkId) {
            this.linkId = theLinkId;
            return this;
        }

        public boolean hasLinkId() {
            if (this.linkId == null) {
                return false;
            }
            for (StringType item : this.linkId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addLinkIdElement() {
            StringType t = new StringType();
            if (this.linkId == null) {
                this.linkId = new ArrayList<StringType>();
            }
            this.linkId.add(t);
            return t;
        }

        public ValuedItemComponent addLinkId(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.linkId == null) {
                this.linkId = new ArrayList<StringType>();
            }
            this.linkId.add(t);
            return this;
        }

        public boolean hasLinkId(String value) {
            if (this.linkId == null) {
                return false;
            }
            for (StringType v : this.linkId) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<UnsignedIntType> getSecurityLabelNumber() {
            if (this.securityLabelNumber == null) {
                this.securityLabelNumber = new ArrayList<UnsignedIntType>();
            }
            return this.securityLabelNumber;
        }

        public ValuedItemComponent setSecurityLabelNumber(List<UnsignedIntType> theSecurityLabelNumber) {
            this.securityLabelNumber = theSecurityLabelNumber;
            return this;
        }

        public boolean hasSecurityLabelNumber() {
            if (this.securityLabelNumber == null) {
                return false;
            }
            for (UnsignedIntType item : this.securityLabelNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UnsignedIntType addSecurityLabelNumberElement() {
            UnsignedIntType t = new UnsignedIntType();
            if (this.securityLabelNumber == null) {
                this.securityLabelNumber = new ArrayList<UnsignedIntType>();
            }
            this.securityLabelNumber.add(t);
            return t;
        }

        public ValuedItemComponent addSecurityLabelNumber(int value) {
            UnsignedIntType t = new UnsignedIntType();
            t.setValue((Object)value);
            if (this.securityLabelNumber == null) {
                this.securityLabelNumber = new ArrayList<UnsignedIntType>();
            }
            this.securityLabelNumber.add(t);
            return this;
        }

        public boolean hasSecurityLabelNumber(int value) {
            if (this.securityLabelNumber == null) {
                return false;
            }
            for (UnsignedIntType v : this.securityLabelNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("entity[x]", "CodeableConcept|Reference(Any)", "Specific type of Contract Valued Item that may be priced.", 0, 1, this.entity));
            children.add(new Property(Contract.SP_IDENTIFIER, "Identifier", "Identifies a Contract Valued Item instance.", 0, 1, this.identifier));
            children.add(new Property("effectiveTime", "dateTime", "Indicates the time during which this Contract ValuedItem information is effective.", 0, 1, this.effectiveTime));
            children.add(new Property("quantity", "SimpleQuantity", "Specifies the units by which the Contract Valued Item is measured or counted, and quantifies the countable or measurable Contract Valued Item instances.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "A Contract Valued Item unit valuation measure.", 0, 1, this.unitPrice));
            children.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of the Contract Valued Item delivered. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor));
            children.add(new Property("points", "decimal", "An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the Contract Valued Item delivered. The concept of Points allows for assignment of point values for a Contract Valued Item, such that a monetary amount can be assigned to each point.", 0, 1, this.points));
            children.add(new Property("net", "Money", "Expresses the product of the Contract Valued Item unitQuantity and the unitPriceAmt. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net));
            children.add(new Property("payment", "string", "Terms of valuation.", 0, 1, this.payment));
            children.add(new Property("paymentDate", "dateTime", "When payment is due.", 0, 1, this.paymentDate));
            children.add(new Property("responsible", "Reference(Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "Who will make payment.", 0, 1, this.responsible));
            children.add(new Property("recipient", "Reference(Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "Who will receive payment.", 0, 1, this.recipient));
            children.add(new Property("linkId", "string", "Id  of the clause or question text related to the context of this valuedItem in the referenced form or QuestionnaireResponse.", 0, Integer.MAX_VALUE, this.linkId));
            children.add(new Property("securityLabelNumber", "unsignedInt", "A set of security labels that define which terms are controlled by this condition.", 0, Integer.MAX_VALUE, this.securityLabelNumber));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -740568643: {
                    return new Property("entity[x]", "CodeableConcept|Reference(Any)", "Specific type of Contract Valued Item that may be priced.", 0, 1, this.entity);
                }
                case -1298275357: {
                    return new Property("entity[x]", "CodeableConcept|Reference(Any)", "Specific type of Contract Valued Item that may be priced.", 0, 1, this.entity);
                }
                case 924197182: {
                    return new Property("entity[x]", "CodeableConcept|Reference(Any)", "Specific type of Contract Valued Item that may be priced.", 0, 1, this.entity);
                }
                case -356635992: {
                    return new Property("entity[x]", "CodeableConcept|Reference(Any)", "Specific type of Contract Valued Item that may be priced.", 0, 1, this.entity);
                }
                case -1618432855: {
                    return new Property(Contract.SP_IDENTIFIER, "Identifier", "Identifies a Contract Valued Item instance.", 0, 1, this.identifier);
                }
                case -929905388: {
                    return new Property("effectiveTime", "dateTime", "Indicates the time during which this Contract ValuedItem information is effective.", 0, 1, this.effectiveTime);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "Specifies the units by which the Contract Valued Item is measured or counted, and quantifies the countable or measurable Contract Valued Item instances.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "A Contract Valued Item unit valuation measure.", 0, 1, this.unitPrice);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of the Contract Valued Item delivered. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor);
                }
                case -982754077: {
                    return new Property("points", "decimal", "An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the Contract Valued Item delivered. The concept of Points allows for assignment of point values for a Contract Valued Item, such that a monetary amount can be assigned to each point.", 0, 1, this.points);
                }
                case 108957: {
                    return new Property("net", "Money", "Expresses the product of the Contract Valued Item unitQuantity and the unitPriceAmt. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net);
                }
                case -786681338: {
                    return new Property("payment", "string", "Terms of valuation.", 0, 1, this.payment);
                }
                case -1540873516: {
                    return new Property("paymentDate", "dateTime", "When payment is due.", 0, 1, this.paymentDate);
                }
                case 1847674614: {
                    return new Property("responsible", "Reference(Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "Who will make payment.", 0, 1, this.responsible);
                }
                case 820081177: {
                    return new Property("recipient", "Reference(Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "Who will receive payment.", 0, 1, this.recipient);
                }
                case -1102667083: {
                    return new Property("linkId", "string", "Id  of the clause or question text related to the context of this valuedItem in the referenced form or QuestionnaireResponse.", 0, Integer.MAX_VALUE, this.linkId);
                }
                case -149460995: {
                    return new Property("securityLabelNumber", "unsignedInt", "A set of security labels that define which terms are controlled by this condition.", 0, Integer.MAX_VALUE, this.securityLabelNumber);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1298275357: {
                    Base[] baseArray;
                    if (this.entity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.entity;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.identifier;
                    }
                    return baseArray;
                }
                case -929905388: {
                    Base[] baseArray;
                    if (this.effectiveTime == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.effectiveTime;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.factor;
                    }
                    return baseArray;
                }
                case -982754077: {
                    Base[] baseArray;
                    if (this.points == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.points;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.net;
                    }
                    return baseArray;
                }
                case -786681338: {
                    Base[] baseArray;
                    if (this.payment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.payment;
                    }
                    return baseArray;
                }
                case -1540873516: {
                    Base[] baseArray;
                    if (this.paymentDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.paymentDate;
                    }
                    return baseArray;
                }
                case 1847674614: {
                    Base[] baseArray;
                    if (this.responsible == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.responsible;
                    }
                    return baseArray;
                }
                case 820081177: {
                    Base[] baseArray;
                    if (this.recipient == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray13 = new Base[1];
                        baseArray = baseArray13;
                        baseArray13[0] = this.recipient;
                    }
                    return baseArray;
                }
                case -1102667083: {
                    return this.linkId == null ? new Base[]{} : this.linkId.toArray(new Base[this.linkId.size()]);
                }
                case -149460995: {
                    return this.securityLabelNumber == null ? new Base[]{} : this.securityLabelNumber.toArray(new Base[this.securityLabelNumber.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1298275357: {
                    this.entity = this.castToType(value);
                    return value;
                }
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
                case -929905388: {
                    this.effectiveTime = this.castToDateTime(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    return value;
                }
                case -982754077: {
                    this.points = this.castToDecimal(value);
                    return value;
                }
                case 108957: {
                    this.net = this.castToMoney(value);
                    return value;
                }
                case -786681338: {
                    this.payment = this.castToString(value);
                    return value;
                }
                case -1540873516: {
                    this.paymentDate = this.castToDateTime(value);
                    return value;
                }
                case 1847674614: {
                    this.responsible = this.castToReference(value);
                    return value;
                }
                case 820081177: {
                    this.recipient = this.castToReference(value);
                    return value;
                }
                case -1102667083: {
                    this.getLinkId().add(this.castToString(value));
                    return value;
                }
                case -149460995: {
                    this.getSecurityLabelNumber().add(this.castToUnsignedInt(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("entity[x]")) {
                this.entity = this.castToType(value);
            } else if (name.equals(Contract.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("effectiveTime")) {
                this.effectiveTime = this.castToDateTime(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("points")) {
                this.points = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("payment")) {
                this.payment = this.castToString(value);
            } else if (name.equals("paymentDate")) {
                this.paymentDate = this.castToDateTime(value);
            } else if (name.equals("responsible")) {
                this.responsible = this.castToReference(value);
            } else if (name.equals("recipient")) {
                this.recipient = this.castToReference(value);
            } else if (name.equals("linkId")) {
                this.getLinkId().add(this.castToString(value));
            } else if (name.equals("securityLabelNumber")) {
                this.getSecurityLabelNumber().add(this.castToUnsignedInt(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -740568643: {
                    return this.getEntity();
                }
                case -1298275357: {
                    return this.getEntity();
                }
                case -1618432855: {
                    return this.getIdentifier();
                }
                case -929905388: {
                    return this.getEffectiveTimeElement();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case -982754077: {
                    return this.getPointsElement();
                }
                case 108957: {
                    return this.getNet();
                }
                case -786681338: {
                    return this.getPaymentElement();
                }
                case -1540873516: {
                    return this.getPaymentDateElement();
                }
                case 1847674614: {
                    return this.getResponsible();
                }
                case 820081177: {
                    return this.getRecipient();
                }
                case -1102667083: {
                    return this.addLinkIdElement();
                }
                case -149460995: {
                    return this.addSecurityLabelNumberElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1298275357: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case -929905388: {
                    return new String[]{"dateTime"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case -982754077: {
                    return new String[]{"decimal"};
                }
                case 108957: {
                    return new String[]{"Money"};
                }
                case -786681338: {
                    return new String[]{"string"};
                }
                case -1540873516: {
                    return new String[]{"dateTime"};
                }
                case 1847674614: {
                    return new String[]{"Reference"};
                }
                case 820081177: {
                    return new String[]{"Reference"};
                }
                case -1102667083: {
                    return new String[]{"string"};
                }
                case -149460995: {
                    return new String[]{"unsignedInt"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("entityCodeableConcept")) {
                this.entity = new CodeableConcept();
                return this.entity;
            }
            if (name.equals("entityReference")) {
                this.entity = new Reference();
                return this.entity;
            }
            if (name.equals(Contract.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("effectiveTime")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.effectiveTime");
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.factor");
            }
            if (name.equals("points")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.points");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("payment")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.payment");
            }
            if (name.equals("paymentDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.paymentDate");
            }
            if (name.equals("responsible")) {
                this.responsible = new Reference();
                return this.responsible;
            }
            if (name.equals("recipient")) {
                this.recipient = new Reference();
                return this.recipient;
            }
            if (name.equals("linkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.linkId");
            }
            if (name.equals("securityLabelNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.securityLabelNumber");
            }
            return super.addChild(name);
        }

        @Override
        public ValuedItemComponent copy() {
            ValuedItemComponent dst = new ValuedItemComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ValuedItemComponent dst) {
            super.copyValues(dst);
            dst.entity = this.entity == null ? null : this.entity.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.effectiveTime = this.effectiveTime == null ? null : this.effectiveTime.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            dst.points = this.points == null ? null : this.points.copy();
            dst.net = this.net == null ? null : this.net.copy();
            dst.payment = this.payment == null ? null : this.payment.copy();
            dst.paymentDate = this.paymentDate == null ? null : this.paymentDate.copy();
            dst.responsible = this.responsible == null ? null : this.responsible.copy();
            Reference reference = dst.recipient = this.recipient == null ? null : this.recipient.copy();
            if (this.linkId != null) {
                dst.linkId = new ArrayList<StringType>();
                for (StringType stringType : this.linkId) {
                    dst.linkId.add(stringType.copy());
                }
            }
            if (this.securityLabelNumber != null) {
                dst.securityLabelNumber = new ArrayList<UnsignedIntType>();
                for (UnsignedIntType unsignedIntType : this.securityLabelNumber) {
                    dst.securityLabelNumber.add(unsignedIntType.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ValuedItemComponent)) {
                return false;
            }
            ValuedItemComponent o = (ValuedItemComponent)other_;
            return ValuedItemComponent.compareDeep(this.entity, o.entity, true) && ValuedItemComponent.compareDeep(this.identifier, o.identifier, true) && ValuedItemComponent.compareDeep(this.effectiveTime, o.effectiveTime, true) && ValuedItemComponent.compareDeep(this.quantity, o.quantity, true) && ValuedItemComponent.compareDeep(this.unitPrice, o.unitPrice, true) && ValuedItemComponent.compareDeep(this.factor, o.factor, true) && ValuedItemComponent.compareDeep(this.points, o.points, true) && ValuedItemComponent.compareDeep(this.net, o.net, true) && ValuedItemComponent.compareDeep(this.payment, o.payment, true) && ValuedItemComponent.compareDeep(this.paymentDate, o.paymentDate, true) && ValuedItemComponent.compareDeep(this.responsible, o.responsible, true) && ValuedItemComponent.compareDeep(this.recipient, o.recipient, true) && ValuedItemComponent.compareDeep(this.linkId, o.linkId, true) && ValuedItemComponent.compareDeep(this.securityLabelNumber, o.securityLabelNumber, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ValuedItemComponent)) {
                return false;
            }
            ValuedItemComponent o = (ValuedItemComponent)other_;
            return ValuedItemComponent.compareValues(this.effectiveTime, o.effectiveTime, true) && ValuedItemComponent.compareValues(this.factor, o.factor, true) && ValuedItemComponent.compareValues(this.points, o.points, true) && ValuedItemComponent.compareValues(this.payment, o.payment, true) && ValuedItemComponent.compareValues(this.paymentDate, o.paymentDate, true) && ValuedItemComponent.compareValues(this.linkId, o.linkId, true) && ValuedItemComponent.compareValues(this.securityLabelNumber, o.securityLabelNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.entity, this.identifier, this.effectiveTime, this.quantity, this.unitPrice, this.factor, this.points, this.net, this.payment, this.paymentDate, this.responsible, this.recipient, this.linkId, this.securityLabelNumber);
        }

        @Override
        public String fhirType() {
            return "Contract.term.asset.valuedItem";
        }
    }

    @Block
    public static class AssetContextComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="reference", type={Reference.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Creator,custodian or owner", formalDefinition="Asset context reference may include the creator, custodian, or owning Person or Organization (e.g., bank, repository),  location held, e.g., building,  jurisdiction.")
        protected Reference reference;
        protected Resource referenceTarget;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Codeable asset context", formalDefinition="Coded representation of the context generally or of the Referenced entity, such as the asset holder type or location.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-assetcontext")
        protected List<CodeableConcept> code;
        @Child(name="text", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Context description", formalDefinition="Context description.")
        protected StringType text;
        private static final long serialVersionUID = -634115628L;

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AssetContextComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public AssetContextComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        public Resource getReferenceTarget() {
            return this.referenceTarget;
        }

        public AssetContextComponent setReferenceTarget(Resource value) {
            this.referenceTarget = value;
            return this;
        }

        public List<CodeableConcept> getCode() {
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            return this.code;
        }

        public AssetContextComponent setCode(List<CodeableConcept> theCode) {
            this.code = theCode;
            return this;
        }

        public boolean hasCode() {
            if (this.code == null) {
                return false;
            }
            for (CodeableConcept item : this.code) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return t;
        }

        public AssetContextComponent addCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return this;
        }

        public CodeableConcept getCodeFirstRep() {
            if (this.getCode().isEmpty()) {
                this.addCode();
            }
            return this.getCode().get(0);
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AssetContextComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public AssetContextComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public AssetContextComponent setText(String value) {
            if (Utilities.noString(value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("reference", "Reference(Any)", "Asset context reference may include the creator, custodian, or owning Person or Organization (e.g., bank, repository),  location held, e.g., building,  jurisdiction.", 0, 1, this.reference));
            children.add(new Property("code", "CodeableConcept", "Coded representation of the context generally or of the Referenced entity, such as the asset holder type or location.", 0, Integer.MAX_VALUE, this.code));
            children.add(new Property("text", "string", "Context description.", 0, 1, this.text));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -925155509: {
                    return new Property("reference", "Reference(Any)", "Asset context reference may include the creator, custodian, or owning Person or Organization (e.g., bank, repository),  location held, e.g., building,  jurisdiction.", 0, 1, this.reference);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Coded representation of the context generally or of the Referenced entity, such as the asset holder type or location.", 0, Integer.MAX_VALUE, this.code);
                }
                case 3556653: {
                    return new Property("text", "string", "Context description.", 0, 1, this.text);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.reference;
                    }
                    return baseArray;
                }
                case 3059181: {
                    return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.text;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    this.reference = this.castToReference(value);
                    return value;
                }
                case 3059181: {
                    this.getCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 3556653: {
                    this.text = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("reference")) {
                this.reference = this.castToReference(value);
            } else if (name.equals("code")) {
                this.getCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    return this.getReference();
                }
                case 3059181: {
                    return this.addCode();
                }
                case 3556653: {
                    return this.getTextElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    return new String[]{"Reference"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 3556653: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            if (name.equals("code")) {
                return this.addCode();
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.text");
            }
            return super.addChild(name);
        }

        @Override
        public AssetContextComponent copy() {
            AssetContextComponent dst = new AssetContextComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AssetContextComponent dst) {
            super.copyValues(dst);
            Reference reference = dst.reference = this.reference == null ? null : this.reference.copy();
            if (this.code != null) {
                dst.code = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.code) {
                    dst.code.add(i.copy());
                }
            }
            dst.text = this.text == null ? null : this.text.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AssetContextComponent)) {
                return false;
            }
            AssetContextComponent o = (AssetContextComponent)other_;
            return AssetContextComponent.compareDeep(this.reference, o.reference, true) && AssetContextComponent.compareDeep(this.code, o.code, true) && AssetContextComponent.compareDeep(this.text, o.text, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AssetContextComponent)) {
                return false;
            }
            AssetContextComponent o = (AssetContextComponent)other_;
            return AssetContextComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.reference, this.code, this.text);
        }

        @Override
        public String fhirType() {
            return "Contract.term.asset.context";
        }
    }

    @Block
    public static class ContractAssetComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="scope", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Range of asset", formalDefinition="Differentiates the kind of the asset .")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-assetscope")
        protected CodeableConcept scope;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Asset category", formalDefinition="Target entity type about which the term may be concerned.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-assettype")
        protected List<CodeableConcept> type;
        @Child(name="typeReference", type={Reference.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Associated entities", formalDefinition="Associated entities.")
        protected List<Reference> typeReference;
        protected List<Resource> typeReferenceTarget;
        @Child(name="subtype", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Asset sub-category", formalDefinition="May be a subtype or part of an offered asset.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-assetsubtype")
        protected List<CodeableConcept> subtype;
        @Child(name="relationship", type={Coding.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Kinship of the asset", formalDefinition="Specifies the applicability of the term to an asset resource instance, and instances it refers to orinstances that refer to it, and/or are owned by the offeree.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-content-class")
        protected Coding relationship;
        @Child(name="context", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Circumstance of the asset", formalDefinition="Circumstance of the asset.")
        protected List<AssetContextComponent> context;
        @Child(name="condition", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Quality desctiption of asset", formalDefinition="Description of the quality and completeness of the asset that imay be a factor in its valuation.")
        protected StringType condition;
        @Child(name="periodType", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Asset availability types", formalDefinition="Type of Asset availability for use or ownership.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/asset-availability")
        protected List<CodeableConcept> periodType;
        @Child(name="period", type={Period.class}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Time period of the asset", formalDefinition="Asset relevant contractual time period.")
        protected List<Period> period;
        @Child(name="usePeriod", type={Period.class}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Time period", formalDefinition="Time period of asset use.")
        protected List<Period> usePeriod;
        @Child(name="text", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Asset clause or question text", formalDefinition="Clause or question text (Prose Object) concerning the asset in a linked form, such as a QuestionnaireResponse used in the formation of the contract.")
        protected StringType text;
        @Child(name="linkId", type={StringType.class}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Pointer to asset text", formalDefinition="Id [identifier??] of the clause or question text about the asset in the referenced form or QuestionnaireResponse.")
        protected List<StringType> linkId;
        @Child(name="answer", type={AnswerComponent.class}, order=13, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Response to assets", formalDefinition="Response to assets.")
        protected List<AnswerComponent> answer;
        @Child(name="securityLabelNumber", type={UnsignedIntType.class}, order=14, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Asset restriction numbers", formalDefinition="Security labels that protects the asset.")
        protected List<UnsignedIntType> securityLabelNumber;
        @Child(name="valuedItem", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Valued Item List", formalDefinition="Contract Valued Item List.")
        protected List<ValuedItemComponent> valuedItem;
        private static final long serialVersionUID = -1080398792L;

        public CodeableConcept getScope() {
            if (this.scope == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContractAssetComponent.scope");
                }
                if (Configuration.doAutoCreate()) {
                    this.scope = new CodeableConcept();
                }
            }
            return this.scope;
        }

        public boolean hasScope() {
            return this.scope != null && !this.scope.isEmpty();
        }

        public ContractAssetComponent setScope(CodeableConcept value) {
            this.scope = value;
            return this;
        }

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public ContractAssetComponent setType(List<CodeableConcept> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public ContractAssetComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public CodeableConcept getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public List<Reference> getTypeReference() {
            if (this.typeReference == null) {
                this.typeReference = new ArrayList<Reference>();
            }
            return this.typeReference;
        }

        public ContractAssetComponent setTypeReference(List<Reference> theTypeReference) {
            this.typeReference = theTypeReference;
            return this;
        }

        public boolean hasTypeReference() {
            if (this.typeReference == null) {
                return false;
            }
            for (Reference item : this.typeReference) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addTypeReference() {
            Reference t = new Reference();
            if (this.typeReference == null) {
                this.typeReference = new ArrayList<Reference>();
            }
            this.typeReference.add(t);
            return t;
        }

        public ContractAssetComponent addTypeReference(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.typeReference == null) {
                this.typeReference = new ArrayList<Reference>();
            }
            this.typeReference.add(t);
            return this;
        }

        public Reference getTypeReferenceFirstRep() {
            if (this.getTypeReference().isEmpty()) {
                this.addTypeReference();
            }
            return this.getTypeReference().get(0);
        }

        @Deprecated
        public List<Resource> getTypeReferenceTarget() {
            if (this.typeReferenceTarget == null) {
                this.typeReferenceTarget = new ArrayList<Resource>();
            }
            return this.typeReferenceTarget;
        }

        public List<CodeableConcept> getSubtype() {
            if (this.subtype == null) {
                this.subtype = new ArrayList<CodeableConcept>();
            }
            return this.subtype;
        }

        public ContractAssetComponent setSubtype(List<CodeableConcept> theSubtype) {
            this.subtype = theSubtype;
            return this;
        }

        public boolean hasSubtype() {
            if (this.subtype == null) {
                return false;
            }
            for (CodeableConcept item : this.subtype) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addSubtype() {
            CodeableConcept t = new CodeableConcept();
            if (this.subtype == null) {
                this.subtype = new ArrayList<CodeableConcept>();
            }
            this.subtype.add(t);
            return t;
        }

        public ContractAssetComponent addSubtype(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.subtype == null) {
                this.subtype = new ArrayList<CodeableConcept>();
            }
            this.subtype.add(t);
            return this;
        }

        public CodeableConcept getSubtypeFirstRep() {
            if (this.getSubtype().isEmpty()) {
                this.addSubtype();
            }
            return this.getSubtype().get(0);
        }

        public Coding getRelationship() {
            if (this.relationship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContractAssetComponent.relationship");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationship = new Coding();
                }
            }
            return this.relationship;
        }

        public boolean hasRelationship() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public ContractAssetComponent setRelationship(Coding value) {
            this.relationship = value;
            return this;
        }

        public List<AssetContextComponent> getContext() {
            if (this.context == null) {
                this.context = new ArrayList<AssetContextComponent>();
            }
            return this.context;
        }

        public ContractAssetComponent setContext(List<AssetContextComponent> theContext) {
            this.context = theContext;
            return this;
        }

        public boolean hasContext() {
            if (this.context == null) {
                return false;
            }
            for (AssetContextComponent item : this.context) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AssetContextComponent addContext() {
            AssetContextComponent t = new AssetContextComponent();
            if (this.context == null) {
                this.context = new ArrayList<AssetContextComponent>();
            }
            this.context.add(t);
            return t;
        }

        public ContractAssetComponent addContext(AssetContextComponent t) {
            if (t == null) {
                return this;
            }
            if (this.context == null) {
                this.context = new ArrayList<AssetContextComponent>();
            }
            this.context.add(t);
            return this;
        }

        public AssetContextComponent getContextFirstRep() {
            if (this.getContext().isEmpty()) {
                this.addContext();
            }
            return this.getContext().get(0);
        }

        public StringType getConditionElement() {
            if (this.condition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContractAssetComponent.condition");
                }
                if (Configuration.doAutoCreate()) {
                    this.condition = new StringType();
                }
            }
            return this.condition;
        }

        public boolean hasConditionElement() {
            return this.condition != null && !this.condition.isEmpty();
        }

        public boolean hasCondition() {
            return this.condition != null && !this.condition.isEmpty();
        }

        public ContractAssetComponent setConditionElement(StringType value) {
            this.condition = value;
            return this;
        }

        public String getCondition() {
            return this.condition == null ? null : (String)this.condition.getValue();
        }

        public ContractAssetComponent setCondition(String value) {
            if (Utilities.noString(value)) {
                this.condition = null;
            } else {
                if (this.condition == null) {
                    this.condition = new StringType();
                }
                this.condition.setValue(value);
            }
            return this;
        }

        public List<CodeableConcept> getPeriodType() {
            if (this.periodType == null) {
                this.periodType = new ArrayList<CodeableConcept>();
            }
            return this.periodType;
        }

        public ContractAssetComponent setPeriodType(List<CodeableConcept> thePeriodType) {
            this.periodType = thePeriodType;
            return this;
        }

        public boolean hasPeriodType() {
            if (this.periodType == null) {
                return false;
            }
            for (CodeableConcept item : this.periodType) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addPeriodType() {
            CodeableConcept t = new CodeableConcept();
            if (this.periodType == null) {
                this.periodType = new ArrayList<CodeableConcept>();
            }
            this.periodType.add(t);
            return t;
        }

        public ContractAssetComponent addPeriodType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.periodType == null) {
                this.periodType = new ArrayList<CodeableConcept>();
            }
            this.periodType.add(t);
            return this;
        }

        public CodeableConcept getPeriodTypeFirstRep() {
            if (this.getPeriodType().isEmpty()) {
                this.addPeriodType();
            }
            return this.getPeriodType().get(0);
        }

        public List<Period> getPeriod() {
            if (this.period == null) {
                this.period = new ArrayList<Period>();
            }
            return this.period;
        }

        public ContractAssetComponent setPeriod(List<Period> thePeriod) {
            this.period = thePeriod;
            return this;
        }

        public boolean hasPeriod() {
            if (this.period == null) {
                return false;
            }
            for (Period item : this.period) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Period addPeriod() {
            Period t = new Period();
            if (this.period == null) {
                this.period = new ArrayList<Period>();
            }
            this.period.add(t);
            return t;
        }

        public ContractAssetComponent addPeriod(Period t) {
            if (t == null) {
                return this;
            }
            if (this.period == null) {
                this.period = new ArrayList<Period>();
            }
            this.period.add(t);
            return this;
        }

        public Period getPeriodFirstRep() {
            if (this.getPeriod().isEmpty()) {
                this.addPeriod();
            }
            return this.getPeriod().get(0);
        }

        public List<Period> getUsePeriod() {
            if (this.usePeriod == null) {
                this.usePeriod = new ArrayList<Period>();
            }
            return this.usePeriod;
        }

        public ContractAssetComponent setUsePeriod(List<Period> theUsePeriod) {
            this.usePeriod = theUsePeriod;
            return this;
        }

        public boolean hasUsePeriod() {
            if (this.usePeriod == null) {
                return false;
            }
            for (Period item : this.usePeriod) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Period addUsePeriod() {
            Period t = new Period();
            if (this.usePeriod == null) {
                this.usePeriod = new ArrayList<Period>();
            }
            this.usePeriod.add(t);
            return t;
        }

        public ContractAssetComponent addUsePeriod(Period t) {
            if (t == null) {
                return this;
            }
            if (this.usePeriod == null) {
                this.usePeriod = new ArrayList<Period>();
            }
            this.usePeriod.add(t);
            return this;
        }

        public Period getUsePeriodFirstRep() {
            if (this.getUsePeriod().isEmpty()) {
                this.addUsePeriod();
            }
            return this.getUsePeriod().get(0);
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContractAssetComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public ContractAssetComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public ContractAssetComponent setText(String value) {
            if (Utilities.noString(value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public List<StringType> getLinkId() {
            if (this.linkId == null) {
                this.linkId = new ArrayList<StringType>();
            }
            return this.linkId;
        }

        public ContractAssetComponent setLinkId(List<StringType> theLinkId) {
            this.linkId = theLinkId;
            return this;
        }

        public boolean hasLinkId() {
            if (this.linkId == null) {
                return false;
            }
            for (StringType item : this.linkId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addLinkIdElement() {
            StringType t = new StringType();
            if (this.linkId == null) {
                this.linkId = new ArrayList<StringType>();
            }
            this.linkId.add(t);
            return t;
        }

        public ContractAssetComponent addLinkId(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.linkId == null) {
                this.linkId = new ArrayList<StringType>();
            }
            this.linkId.add(t);
            return this;
        }

        public boolean hasLinkId(String value) {
            if (this.linkId == null) {
                return false;
            }
            for (StringType v : this.linkId) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<AnswerComponent> getAnswer() {
            if (this.answer == null) {
                this.answer = new ArrayList<AnswerComponent>();
            }
            return this.answer;
        }

        public ContractAssetComponent setAnswer(List<AnswerComponent> theAnswer) {
            this.answer = theAnswer;
            return this;
        }

        public boolean hasAnswer() {
            if (this.answer == null) {
                return false;
            }
            for (AnswerComponent item : this.answer) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AnswerComponent addAnswer() {
            AnswerComponent t = new AnswerComponent();
            if (this.answer == null) {
                this.answer = new ArrayList<AnswerComponent>();
            }
            this.answer.add(t);
            return t;
        }

        public ContractAssetComponent addAnswer(AnswerComponent t) {
            if (t == null) {
                return this;
            }
            if (this.answer == null) {
                this.answer = new ArrayList<AnswerComponent>();
            }
            this.answer.add(t);
            return this;
        }

        public AnswerComponent getAnswerFirstRep() {
            if (this.getAnswer().isEmpty()) {
                this.addAnswer();
            }
            return this.getAnswer().get(0);
        }

        public List<UnsignedIntType> getSecurityLabelNumber() {
            if (this.securityLabelNumber == null) {
                this.securityLabelNumber = new ArrayList<UnsignedIntType>();
            }
            return this.securityLabelNumber;
        }

        public ContractAssetComponent setSecurityLabelNumber(List<UnsignedIntType> theSecurityLabelNumber) {
            this.securityLabelNumber = theSecurityLabelNumber;
            return this;
        }

        public boolean hasSecurityLabelNumber() {
            if (this.securityLabelNumber == null) {
                return false;
            }
            for (UnsignedIntType item : this.securityLabelNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UnsignedIntType addSecurityLabelNumberElement() {
            UnsignedIntType t = new UnsignedIntType();
            if (this.securityLabelNumber == null) {
                this.securityLabelNumber = new ArrayList<UnsignedIntType>();
            }
            this.securityLabelNumber.add(t);
            return t;
        }

        public ContractAssetComponent addSecurityLabelNumber(int value) {
            UnsignedIntType t = new UnsignedIntType();
            t.setValue((Object)value);
            if (this.securityLabelNumber == null) {
                this.securityLabelNumber = new ArrayList<UnsignedIntType>();
            }
            this.securityLabelNumber.add(t);
            return this;
        }

        public boolean hasSecurityLabelNumber(int value) {
            if (this.securityLabelNumber == null) {
                return false;
            }
            for (UnsignedIntType v : this.securityLabelNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<ValuedItemComponent> getValuedItem() {
            if (this.valuedItem == null) {
                this.valuedItem = new ArrayList<ValuedItemComponent>();
            }
            return this.valuedItem;
        }

        public ContractAssetComponent setValuedItem(List<ValuedItemComponent> theValuedItem) {
            this.valuedItem = theValuedItem;
            return this;
        }

        public boolean hasValuedItem() {
            if (this.valuedItem == null) {
                return false;
            }
            for (ValuedItemComponent item : this.valuedItem) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ValuedItemComponent addValuedItem() {
            ValuedItemComponent t = new ValuedItemComponent();
            if (this.valuedItem == null) {
                this.valuedItem = new ArrayList<ValuedItemComponent>();
            }
            this.valuedItem.add(t);
            return t;
        }

        public ContractAssetComponent addValuedItem(ValuedItemComponent t) {
            if (t == null) {
                return this;
            }
            if (this.valuedItem == null) {
                this.valuedItem = new ArrayList<ValuedItemComponent>();
            }
            this.valuedItem.add(t);
            return this;
        }

        public ValuedItemComponent getValuedItemFirstRep() {
            if (this.getValuedItem().isEmpty()) {
                this.addValuedItem();
            }
            return this.getValuedItem().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("scope", "CodeableConcept", "Differentiates the kind of the asset .", 0, 1, this.scope));
            children.add(new Property("type", "CodeableConcept", "Target entity type about which the term may be concerned.", 0, Integer.MAX_VALUE, this.type));
            children.add(new Property("typeReference", "Reference(Any)", "Associated entities.", 0, Integer.MAX_VALUE, this.typeReference));
            children.add(new Property("subtype", "CodeableConcept", "May be a subtype or part of an offered asset.", 0, Integer.MAX_VALUE, this.subtype));
            children.add(new Property("relationship", "Coding", "Specifies the applicability of the term to an asset resource instance, and instances it refers to orinstances that refer to it, and/or are owned by the offeree.", 0, 1, this.relationship));
            children.add(new Property("context", "", "Circumstance of the asset.", 0, Integer.MAX_VALUE, this.context));
            children.add(new Property("condition", "string", "Description of the quality and completeness of the asset that imay be a factor in its valuation.", 0, 1, this.condition));
            children.add(new Property("periodType", "CodeableConcept", "Type of Asset availability for use or ownership.", 0, Integer.MAX_VALUE, this.periodType));
            children.add(new Property("period", "Period", "Asset relevant contractual time period.", 0, Integer.MAX_VALUE, this.period));
            children.add(new Property("usePeriod", "Period", "Time period of asset use.", 0, Integer.MAX_VALUE, this.usePeriod));
            children.add(new Property("text", "string", "Clause or question text (Prose Object) concerning the asset in a linked form, such as a QuestionnaireResponse used in the formation of the contract.", 0, 1, this.text));
            children.add(new Property("linkId", "string", "Id [identifier??] of the clause or question text about the asset in the referenced form or QuestionnaireResponse.", 0, Integer.MAX_VALUE, this.linkId));
            children.add(new Property("answer", "@Contract.term.offer.answer", "Response to assets.", 0, Integer.MAX_VALUE, this.answer));
            children.add(new Property("securityLabelNumber", "unsignedInt", "Security labels that protects the asset.", 0, Integer.MAX_VALUE, this.securityLabelNumber));
            children.add(new Property("valuedItem", "", "Contract Valued Item List.", 0, Integer.MAX_VALUE, this.valuedItem));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 109264468: {
                    return new Property("scope", "CodeableConcept", "Differentiates the kind of the asset .", 0, 1, this.scope);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Target entity type about which the term may be concerned.", 0, Integer.MAX_VALUE, this.type);
                }
                case 2074825009: {
                    return new Property("typeReference", "Reference(Any)", "Associated entities.", 0, Integer.MAX_VALUE, this.typeReference);
                }
                case -1867567750: {
                    return new Property("subtype", "CodeableConcept", "May be a subtype or part of an offered asset.", 0, Integer.MAX_VALUE, this.subtype);
                }
                case -261851592: {
                    return new Property("relationship", "Coding", "Specifies the applicability of the term to an asset resource instance, and instances it refers to orinstances that refer to it, and/or are owned by the offeree.", 0, 1, this.relationship);
                }
                case 951530927: {
                    return new Property("context", "", "Circumstance of the asset.", 0, Integer.MAX_VALUE, this.context);
                }
                case -861311717: {
                    return new Property("condition", "string", "Description of the quality and completeness of the asset that imay be a factor in its valuation.", 0, 1, this.condition);
                }
                case 384348315: {
                    return new Property("periodType", "CodeableConcept", "Type of Asset availability for use or ownership.", 0, Integer.MAX_VALUE, this.periodType);
                }
                case -991726143: {
                    return new Property("period", "Period", "Asset relevant contractual time period.", 0, Integer.MAX_VALUE, this.period);
                }
                case -628382168: {
                    return new Property("usePeriod", "Period", "Time period of asset use.", 0, Integer.MAX_VALUE, this.usePeriod);
                }
                case 3556653: {
                    return new Property("text", "string", "Clause or question text (Prose Object) concerning the asset in a linked form, such as a QuestionnaireResponse used in the formation of the contract.", 0, 1, this.text);
                }
                case -1102667083: {
                    return new Property("linkId", "string", "Id [identifier??] of the clause or question text about the asset in the referenced form or QuestionnaireResponse.", 0, Integer.MAX_VALUE, this.linkId);
                }
                case -1412808770: {
                    return new Property("answer", "@Contract.term.offer.answer", "Response to assets.", 0, Integer.MAX_VALUE, this.answer);
                }
                case -149460995: {
                    return new Property("securityLabelNumber", "unsignedInt", "Security labels that protects the asset.", 0, Integer.MAX_VALUE, this.securityLabelNumber);
                }
                case 2046675654: {
                    return new Property("valuedItem", "", "Contract Valued Item List.", 0, Integer.MAX_VALUE, this.valuedItem);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 109264468: {
                    Base[] baseArray;
                    if (this.scope == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.scope;
                    }
                    return baseArray;
                }
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case 2074825009: {
                    return this.typeReference == null ? new Base[]{} : this.typeReference.toArray(new Base[this.typeReference.size()]);
                }
                case -1867567750: {
                    return this.subtype == null ? new Base[]{} : this.subtype.toArray(new Base[this.subtype.size()]);
                }
                case -261851592: {
                    Base[] baseArray;
                    if (this.relationship == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.relationship;
                    }
                    return baseArray;
                }
                case 951530927: {
                    return this.context == null ? new Base[]{} : this.context.toArray(new Base[this.context.size()]);
                }
                case -861311717: {
                    Base[] baseArray;
                    if (this.condition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.condition;
                    }
                    return baseArray;
                }
                case 384348315: {
                    return this.periodType == null ? new Base[]{} : this.periodType.toArray(new Base[this.periodType.size()]);
                }
                case -991726143: {
                    return this.period == null ? new Base[]{} : this.period.toArray(new Base[this.period.size()]);
                }
                case -628382168: {
                    return this.usePeriod == null ? new Base[]{} : this.usePeriod.toArray(new Base[this.usePeriod.size()]);
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.text;
                    }
                    return baseArray;
                }
                case -1102667083: {
                    return this.linkId == null ? new Base[]{} : this.linkId.toArray(new Base[this.linkId.size()]);
                }
                case -1412808770: {
                    return this.answer == null ? new Base[]{} : this.answer.toArray(new Base[this.answer.size()]);
                }
                case -149460995: {
                    return this.securityLabelNumber == null ? new Base[]{} : this.securityLabelNumber.toArray(new Base[this.securityLabelNumber.size()]);
                }
                case 2046675654: {
                    return this.valuedItem == null ? new Base[]{} : this.valuedItem.toArray(new Base[this.valuedItem.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 109264468: {
                    this.scope = this.castToCodeableConcept(value);
                    return value;
                }
                case 3575610: {
                    this.getType().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 2074825009: {
                    this.getTypeReference().add(this.castToReference(value));
                    return value;
                }
                case -1867567750: {
                    this.getSubtype().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -261851592: {
                    this.relationship = this.castToCoding(value);
                    return value;
                }
                case 951530927: {
                    this.getContext().add((AssetContextComponent)value);
                    return value;
                }
                case -861311717: {
                    this.condition = this.castToString(value);
                    return value;
                }
                case 384348315: {
                    this.getPeriodType().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -991726143: {
                    this.getPeriod().add(this.castToPeriod(value));
                    return value;
                }
                case -628382168: {
                    this.getUsePeriod().add(this.castToPeriod(value));
                    return value;
                }
                case 3556653: {
                    this.text = this.castToString(value);
                    return value;
                }
                case -1102667083: {
                    this.getLinkId().add(this.castToString(value));
                    return value;
                }
                case -1412808770: {
                    this.getAnswer().add((AnswerComponent)value);
                    return value;
                }
                case -149460995: {
                    this.getSecurityLabelNumber().add(this.castToUnsignedInt(value));
                    return value;
                }
                case 2046675654: {
                    this.getValuedItem().add((ValuedItemComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("scope")) {
                this.scope = this.castToCodeableConcept(value);
            } else if (name.equals("type")) {
                this.getType().add(this.castToCodeableConcept(value));
            } else if (name.equals("typeReference")) {
                this.getTypeReference().add(this.castToReference(value));
            } else if (name.equals("subtype")) {
                this.getSubtype().add(this.castToCodeableConcept(value));
            } else if (name.equals("relationship")) {
                this.relationship = this.castToCoding(value);
            } else if (name.equals("context")) {
                this.getContext().add((AssetContextComponent)value);
            } else if (name.equals("condition")) {
                this.condition = this.castToString(value);
            } else if (name.equals("periodType")) {
                this.getPeriodType().add(this.castToCodeableConcept(value));
            } else if (name.equals("period")) {
                this.getPeriod().add(this.castToPeriod(value));
            } else if (name.equals("usePeriod")) {
                this.getUsePeriod().add(this.castToPeriod(value));
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else if (name.equals("linkId")) {
                this.getLinkId().add(this.castToString(value));
            } else if (name.equals("answer")) {
                this.getAnswer().add((AnswerComponent)value);
            } else if (name.equals("securityLabelNumber")) {
                this.getSecurityLabelNumber().add(this.castToUnsignedInt(value));
            } else if (name.equals("valuedItem")) {
                this.getValuedItem().add((ValuedItemComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 109264468: {
                    return this.getScope();
                }
                case 3575610: {
                    return this.addType();
                }
                case 2074825009: {
                    return this.addTypeReference();
                }
                case -1867567750: {
                    return this.addSubtype();
                }
                case -261851592: {
                    return this.getRelationship();
                }
                case 951530927: {
                    return this.addContext();
                }
                case -861311717: {
                    return this.getConditionElement();
                }
                case 384348315: {
                    return this.addPeriodType();
                }
                case -991726143: {
                    return this.addPeriod();
                }
                case -628382168: {
                    return this.addUsePeriod();
                }
                case 3556653: {
                    return this.getTextElement();
                }
                case -1102667083: {
                    return this.addLinkIdElement();
                }
                case -1412808770: {
                    return this.addAnswer();
                }
                case -149460995: {
                    return this.addSecurityLabelNumberElement();
                }
                case 2046675654: {
                    return this.addValuedItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 109264468: {
                    return new String[]{"CodeableConcept"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 2074825009: {
                    return new String[]{"Reference"};
                }
                case -1867567750: {
                    return new String[]{"CodeableConcept"};
                }
                case -261851592: {
                    return new String[]{"Coding"};
                }
                case 951530927: {
                    return new String[0];
                }
                case -861311717: {
                    return new String[]{"string"};
                }
                case 384348315: {
                    return new String[]{"CodeableConcept"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
                case -628382168: {
                    return new String[]{"Period"};
                }
                case 3556653: {
                    return new String[]{"string"};
                }
                case -1102667083: {
                    return new String[]{"string"};
                }
                case -1412808770: {
                    return new String[]{"@Contract.term.offer.answer"};
                }
                case -149460995: {
                    return new String[]{"unsignedInt"};
                }
                case 2046675654: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("scope")) {
                this.scope = new CodeableConcept();
                return this.scope;
            }
            if (name.equals("type")) {
                return this.addType();
            }
            if (name.equals("typeReference")) {
                return this.addTypeReference();
            }
            if (name.equals("subtype")) {
                return this.addSubtype();
            }
            if (name.equals("relationship")) {
                this.relationship = new Coding();
                return this.relationship;
            }
            if (name.equals("context")) {
                return this.addContext();
            }
            if (name.equals("condition")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.condition");
            }
            if (name.equals("periodType")) {
                return this.addPeriodType();
            }
            if (name.equals("period")) {
                return this.addPeriod();
            }
            if (name.equals("usePeriod")) {
                return this.addUsePeriod();
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.text");
            }
            if (name.equals("linkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.linkId");
            }
            if (name.equals("answer")) {
                return this.addAnswer();
            }
            if (name.equals("securityLabelNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.securityLabelNumber");
            }
            if (name.equals("valuedItem")) {
                return this.addValuedItem();
            }
            return super.addChild(name);
        }

        @Override
        public ContractAssetComponent copy() {
            ContractAssetComponent dst = new ContractAssetComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ContractAssetComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.scope = this.scope == null ? null : this.scope.copy();
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.type) {
                    dst.type.add(codeableConcept2.copy());
                }
            }
            if (this.typeReference != null) {
                dst.typeReference = new ArrayList<Reference>();
                for (Reference reference : this.typeReference) {
                    dst.typeReference.add(reference.copy());
                }
            }
            if (this.subtype != null) {
                dst.subtype = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept3 : this.subtype) {
                    dst.subtype.add(codeableConcept3.copy());
                }
            }
            Coding coding = dst.relationship = this.relationship == null ? null : this.relationship.copy();
            if (this.context != null) {
                dst.context = new ArrayList<AssetContextComponent>();
                for (AssetContextComponent assetContextComponent : this.context) {
                    dst.context.add(assetContextComponent.copy());
                }
            }
            StringType stringType = dst.condition = this.condition == null ? null : this.condition.copy();
            if (this.periodType != null) {
                dst.periodType = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept4 : this.periodType) {
                    dst.periodType.add(codeableConcept4.copy());
                }
            }
            if (this.period != null) {
                dst.period = new ArrayList<Period>();
                for (Period period : this.period) {
                    dst.period.add(period.copy());
                }
            }
            if (this.usePeriod != null) {
                dst.usePeriod = new ArrayList<Period>();
                for (Period period : this.usePeriod) {
                    dst.usePeriod.add(period.copy());
                }
            }
            StringType stringType2 = dst.text = this.text == null ? null : this.text.copy();
            if (this.linkId != null) {
                dst.linkId = new ArrayList<StringType>();
                for (StringType stringType3 : this.linkId) {
                    dst.linkId.add(stringType3.copy());
                }
            }
            if (this.answer != null) {
                dst.answer = new ArrayList<AnswerComponent>();
                for (AnswerComponent answerComponent : this.answer) {
                    dst.answer.add(answerComponent.copy());
                }
            }
            if (this.securityLabelNumber != null) {
                dst.securityLabelNumber = new ArrayList<UnsignedIntType>();
                for (UnsignedIntType unsignedIntType : this.securityLabelNumber) {
                    dst.securityLabelNumber.add(unsignedIntType.copy());
                }
            }
            if (this.valuedItem != null) {
                dst.valuedItem = new ArrayList<ValuedItemComponent>();
                for (ValuedItemComponent valuedItemComponent : this.valuedItem) {
                    dst.valuedItem.add(valuedItemComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ContractAssetComponent)) {
                return false;
            }
            ContractAssetComponent o = (ContractAssetComponent)other_;
            return ContractAssetComponent.compareDeep(this.scope, o.scope, true) && ContractAssetComponent.compareDeep(this.type, o.type, true) && ContractAssetComponent.compareDeep(this.typeReference, o.typeReference, true) && ContractAssetComponent.compareDeep(this.subtype, o.subtype, true) && ContractAssetComponent.compareDeep(this.relationship, o.relationship, true) && ContractAssetComponent.compareDeep(this.context, o.context, true) && ContractAssetComponent.compareDeep(this.condition, o.condition, true) && ContractAssetComponent.compareDeep(this.periodType, o.periodType, true) && ContractAssetComponent.compareDeep(this.period, o.period, true) && ContractAssetComponent.compareDeep(this.usePeriod, o.usePeriod, true) && ContractAssetComponent.compareDeep(this.text, o.text, true) && ContractAssetComponent.compareDeep(this.linkId, o.linkId, true) && ContractAssetComponent.compareDeep(this.answer, o.answer, true) && ContractAssetComponent.compareDeep(this.securityLabelNumber, o.securityLabelNumber, true) && ContractAssetComponent.compareDeep(this.valuedItem, o.valuedItem, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ContractAssetComponent)) {
                return false;
            }
            ContractAssetComponent o = (ContractAssetComponent)other_;
            return ContractAssetComponent.compareValues(this.condition, o.condition, true) && ContractAssetComponent.compareValues(this.text, o.text, true) && ContractAssetComponent.compareValues(this.linkId, o.linkId, true) && ContractAssetComponent.compareValues(this.securityLabelNumber, o.securityLabelNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.scope, this.type, this.typeReference, this.subtype, this.relationship, this.context, this.condition, this.periodType, this.period, this.usePeriod, this.text, this.linkId, this.answer, this.securityLabelNumber, this.valuedItem);
        }

        @Override
        public String fhirType() {
            return "Contract.term.asset";
        }
    }

    @Block
    public static class AnswerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="value", type={BooleanType.class, DecimalType.class, IntegerType.class, DateType.class, DateTimeType.class, TimeType.class, StringType.class, UriType.class, Attachment.class, Coding.class, Quantity.class, Reference.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The actual answer response", formalDefinition="Response to an offer clause or question text,  which enables selection of values to be agreed to, e.g., the period of participation, the date of occupancy of a rental, warrently duration, or whether biospecimen may be used for further research.")
        protected Type value;
        private static final long serialVersionUID = -732981989L;

        public AnswerComponent() {
        }

        public AnswerComponent(Type value) {
            this.value = value;
        }

        public Type getValue() {
            return this.value;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (this.value == null) {
                this.value = new DecimalType();
            }
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this != null && this.value instanceof DecimalType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public DateType getValueDateType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateType();
            }
            if (!(this.value instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateType)this.value;
        }

        public boolean hasValueDateType() {
            return this != null && this.value instanceof DateType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this != null && this.value instanceof DateTimeType;
        }

        public TimeType getValueTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new TimeType();
            }
            if (!(this.value instanceof TimeType)) {
                throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (TimeType)this.value;
        }

        public boolean hasValueTimeType() {
            return this != null && this.value instanceof TimeType;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public UriType getValueUriType() throws FHIRException {
            if (this.value == null) {
                this.value = new UriType();
            }
            if (!(this.value instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UriType)this.value;
        }

        public boolean hasValueUriType() {
            return this != null && this.value instanceof UriType;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public Coding getValueCoding() throws FHIRException {
            if (this.value == null) {
                this.value = new Coding();
            }
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this != null && this.value instanceof Coding;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Reference getValueReference() throws FHIRException {
            if (this.value == null) {
                this.value = new Reference();
            }
            if (!(this.value instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Reference)this.value;
        }

        public boolean hasValueReference() {
            return this != null && this.value instanceof Reference;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public AnswerComponent setValue(Type value) {
            if (!(value == null || value instanceof BooleanType || value instanceof DecimalType || value instanceof IntegerType || value instanceof DateType || value instanceof DateTimeType || value instanceof TimeType || value instanceof StringType || value instanceof UriType || value instanceof Attachment || value instanceof Coding || value instanceof Quantity || value instanceof Reference)) {
                throw new Error("Not the right type for Contract.term.offer.answer.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("value[x]", "boolean|decimal|integer|date|dateTime|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "Response to an offer clause or question text,  which enables selection of values to be agreed to, e.g., the period of participation, the date of occupancy of a rental, warrently duration, or whether biospecimen may be used for further research.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1410166417: {
                    return new Property("value[x]", "boolean|decimal|integer|date|dateTime|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "Response to an offer clause or question text,  which enables selection of values to be agreed to, e.g., the period of participation, the date of occupancy of a rental, warrently duration, or whether biospecimen may be used for further research.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "boolean|decimal|integer|date|dateTime|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "Response to an offer clause or question text,  which enables selection of values to be agreed to, e.g., the period of participation, the date of occupancy of a rental, warrently duration, or whether biospecimen may be used for further research.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean|decimal|integer|date|dateTime|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "Response to an offer clause or question text,  which enables selection of values to be agreed to, e.g., the period of participation, the date of occupancy of a rental, warrently duration, or whether biospecimen may be used for further research.", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "boolean|decimal|integer|date|dateTime|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "Response to an offer clause or question text,  which enables selection of values to be agreed to, e.g., the period of participation, the date of occupancy of a rental, warrently duration, or whether biospecimen may be used for further research.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "boolean|decimal|integer|date|dateTime|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "Response to an offer clause or question text,  which enables selection of values to be agreed to, e.g., the period of participation, the date of occupancy of a rental, warrently duration, or whether biospecimen may be used for further research.", 0, 1, this.value);
                }
                case -766192449: {
                    return new Property("value[x]", "boolean|decimal|integer|date|dateTime|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "Response to an offer clause or question text,  which enables selection of values to be agreed to, e.g., the period of participation, the date of occupancy of a rental, warrently duration, or whether biospecimen may be used for further research.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "boolean|decimal|integer|date|dateTime|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "Response to an offer clause or question text,  which enables selection of values to be agreed to, e.g., the period of participation, the date of occupancy of a rental, warrently duration, or whether biospecimen may be used for further research.", 0, 1, this.value);
                }
                case -765708322: {
                    return new Property("value[x]", "boolean|decimal|integer|date|dateTime|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "Response to an offer clause or question text,  which enables selection of values to be agreed to, e.g., the period of participation, the date of occupancy of a rental, warrently duration, or whether biospecimen may be used for further research.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "boolean|decimal|integer|date|dateTime|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "Response to an offer clause or question text,  which enables selection of values to be agreed to, e.g., the period of participation, the date of occupancy of a rental, warrently duration, or whether biospecimen may be used for further research.", 0, 1, this.value);
                }
                case -1410172357: {
                    return new Property("value[x]", "boolean|decimal|integer|date|dateTime|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "Response to an offer clause or question text,  which enables selection of values to be agreed to, e.g., the period of participation, the date of occupancy of a rental, warrently duration, or whether biospecimen may be used for further research.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "boolean|decimal|integer|date|dateTime|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "Response to an offer clause or question text,  which enables selection of values to be agreed to, e.g., the period of participation, the date of occupancy of a rental, warrently duration, or whether biospecimen may be used for further research.", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "boolean|decimal|integer|date|dateTime|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "Response to an offer clause or question text,  which enables selection of values to be agreed to, e.g., the period of participation, the date of occupancy of a rental, warrently duration, or whether biospecimen may be used for further research.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "boolean|decimal|integer|date|dateTime|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "Response to an offer clause or question text,  which enables selection of values to be agreed to, e.g., the period of participation, the date of occupancy of a rental, warrently duration, or whether biospecimen may be used for further research.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "boolean|decimal|integer|date|dateTime|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "Response to an offer clause or question text,  which enables selection of values to be agreed to, e.g., the period of participation, the date of occupancy of a rental, warrently duration, or whether biospecimen may be used for further research.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    this.value = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("value[x]")) {
                return super.setProperty(name, value);
            }
            this.value = this.castToType(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    return new String[]{"boolean", "decimal", "integer", "date", "dateTime", "time", "string", "uri", "Attachment", "Coding", "Quantity", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public AnswerComponent copy() {
            AnswerComponent dst = new AnswerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AnswerComponent dst) {
            super.copyValues(dst);
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AnswerComponent)) {
                return false;
            }
            AnswerComponent o = (AnswerComponent)other_;
            return AnswerComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AnswerComponent)) {
                return false;
            }
            AnswerComponent o = (AnswerComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.value);
        }

        @Override
        public String fhirType() {
            return "Contract.term.offer.answer";
        }
    }

    @Block
    public static class ContractPartyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="reference", type={Patient.class, RelatedPerson.class, Practitioner.class, PractitionerRole.class, Device.class, Group.class, Organization.class}, order=1, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Referenced entity", formalDefinition="Participant in the offer.")
        protected List<Reference> reference;
        protected List<Resource> referenceTarget;
        @Child(name="role", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Participant engagement type", formalDefinition="How the party participates in the offer.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-party-role")
        protected CodeableConcept role;
        private static final long serialVersionUID = 128949255L;

        public ContractPartyComponent() {
        }

        public ContractPartyComponent(CodeableConcept role) {
            this.role = role;
        }

        public List<Reference> getReference() {
            if (this.reference == null) {
                this.reference = new ArrayList<Reference>();
            }
            return this.reference;
        }

        public ContractPartyComponent setReference(List<Reference> theReference) {
            this.reference = theReference;
            return this;
        }

        public boolean hasReference() {
            if (this.reference == null) {
                return false;
            }
            for (Reference item : this.reference) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addReference() {
            Reference t = new Reference();
            if (this.reference == null) {
                this.reference = new ArrayList<Reference>();
            }
            this.reference.add(t);
            return t;
        }

        public ContractPartyComponent addReference(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.reference == null) {
                this.reference = new ArrayList<Reference>();
            }
            this.reference.add(t);
            return this;
        }

        public Reference getReferenceFirstRep() {
            if (this.getReference().isEmpty()) {
                this.addReference();
            }
            return this.getReference().get(0);
        }

        @Deprecated
        public List<Resource> getReferenceTarget() {
            if (this.referenceTarget == null) {
                this.referenceTarget = new ArrayList<Resource>();
            }
            return this.referenceTarget;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContractPartyComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public ContractPartyComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("reference", "Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Device|Group|Organization)", "Participant in the offer.", 0, Integer.MAX_VALUE, this.reference));
            children.add(new Property("role", "CodeableConcept", "How the party participates in the offer.", 0, 1, this.role));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -925155509: {
                    return new Property("reference", "Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Device|Group|Organization)", "Participant in the offer.", 0, Integer.MAX_VALUE, this.reference);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "How the party participates in the offer.", 0, 1, this.role);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    return this.reference == null ? new Base[]{} : this.reference.toArray(new Base[this.reference.size()]);
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    this.getReference().add(this.castToReference(value));
                    return value;
                }
                case 3506294: {
                    this.role = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("reference")) {
                this.getReference().add(this.castToReference(value));
            } else if (name.equals("role")) {
                this.role = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    return this.addReference();
                }
                case 3506294: {
                    return this.getRole();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    return new String[]{"Reference"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("reference")) {
                return this.addReference();
            }
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            return super.addChild(name);
        }

        @Override
        public ContractPartyComponent copy() {
            ContractPartyComponent dst = new ContractPartyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ContractPartyComponent dst) {
            super.copyValues(dst);
            if (this.reference != null) {
                dst.reference = new ArrayList<Reference>();
                for (Reference i : this.reference) {
                    dst.reference.add(i.copy());
                }
            }
            dst.role = this.role == null ? null : this.role.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ContractPartyComponent)) {
                return false;
            }
            ContractPartyComponent o = (ContractPartyComponent)other_;
            return ContractPartyComponent.compareDeep(this.reference, o.reference, true) && ContractPartyComponent.compareDeep(this.role, o.role, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ContractPartyComponent)) {
                return false;
            }
            ContractPartyComponent o = (ContractPartyComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.reference, this.role);
        }

        @Override
        public String fhirType() {
            return "Contract.term.offer.party";
        }
    }

    @Block
    public static class ContractOfferComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Offer business ID", formalDefinition="Unique identifier for this particular Contract Provision.")
        protected List<Identifier> identifier;
        @Child(name="party", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Offer Recipient", formalDefinition="Offer Recipient.")
        protected List<ContractPartyComponent> party;
        @Child(name="topic", type={Reference.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Negotiable offer asset", formalDefinition="The owner of an asset has the residual control rights over the asset: the right to decide all usages of the asset in any way not inconsistent with a prior contract, custom, or law (Hart, 1995, p. 30).")
        protected Reference topic;
        protected Resource topicTarget;
        @Child(name="type", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Offer Type or Form", formalDefinition="Type of Contract Provision such as specific requirements, purposes for actions, obligations, prohibitions, e.g. life time maximum benefit.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-term-type")
        protected CodeableConcept type;
        @Child(name="decision", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Accepting party choice", formalDefinition="Type of choice made by accepting party with respect to an offer made by an offeror/ grantee.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-ActConsentDirective")
        protected CodeableConcept decision;
        @Child(name="decisionMode", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="How decision is conveyed", formalDefinition="How the decision about a Contract was conveyed.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-decision-mode")
        protected List<CodeableConcept> decisionMode;
        @Child(name="answer", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Response to offer text", formalDefinition="Response to offer text.")
        protected List<AnswerComponent> answer;
        @Child(name="text", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human readable offer text", formalDefinition="Human readable form of this Contract Offer.")
        protected StringType text;
        @Child(name="linkId", type={StringType.class}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Pointer to text", formalDefinition="The id of the clause or question text of the offer in the referenced questionnaire/response.")
        protected List<StringType> linkId;
        @Child(name="securityLabelNumber", type={UnsignedIntType.class}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Offer restriction numbers", formalDefinition="Security labels that protects the offer.")
        protected List<UnsignedIntType> securityLabelNumber;
        private static final long serialVersionUID = -395674449L;

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public ContractOfferComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public ContractOfferComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public List<ContractPartyComponent> getParty() {
            if (this.party == null) {
                this.party = new ArrayList<ContractPartyComponent>();
            }
            return this.party;
        }

        public ContractOfferComponent setParty(List<ContractPartyComponent> theParty) {
            this.party = theParty;
            return this;
        }

        public boolean hasParty() {
            if (this.party == null) {
                return false;
            }
            for (ContractPartyComponent item : this.party) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContractPartyComponent addParty() {
            ContractPartyComponent t = new ContractPartyComponent();
            if (this.party == null) {
                this.party = new ArrayList<ContractPartyComponent>();
            }
            this.party.add(t);
            return t;
        }

        public ContractOfferComponent addParty(ContractPartyComponent t) {
            if (t == null) {
                return this;
            }
            if (this.party == null) {
                this.party = new ArrayList<ContractPartyComponent>();
            }
            this.party.add(t);
            return this;
        }

        public ContractPartyComponent getPartyFirstRep() {
            if (this.getParty().isEmpty()) {
                this.addParty();
            }
            return this.getParty().get(0);
        }

        public Reference getTopic() {
            if (this.topic == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContractOfferComponent.topic");
                }
                if (Configuration.doAutoCreate()) {
                    this.topic = new Reference();
                }
            }
            return this.topic;
        }

        public boolean hasTopic() {
            return this.topic != null && !this.topic.isEmpty();
        }

        public ContractOfferComponent setTopic(Reference value) {
            this.topic = value;
            return this;
        }

        public Resource getTopicTarget() {
            return this.topicTarget;
        }

        public ContractOfferComponent setTopicTarget(Resource value) {
            this.topicTarget = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContractOfferComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ContractOfferComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getDecision() {
            if (this.decision == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContractOfferComponent.decision");
                }
                if (Configuration.doAutoCreate()) {
                    this.decision = new CodeableConcept();
                }
            }
            return this.decision;
        }

        public boolean hasDecision() {
            return this.decision != null && !this.decision.isEmpty();
        }

        public ContractOfferComponent setDecision(CodeableConcept value) {
            this.decision = value;
            return this;
        }

        public List<CodeableConcept> getDecisionMode() {
            if (this.decisionMode == null) {
                this.decisionMode = new ArrayList<CodeableConcept>();
            }
            return this.decisionMode;
        }

        public ContractOfferComponent setDecisionMode(List<CodeableConcept> theDecisionMode) {
            this.decisionMode = theDecisionMode;
            return this;
        }

        public boolean hasDecisionMode() {
            if (this.decisionMode == null) {
                return false;
            }
            for (CodeableConcept item : this.decisionMode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addDecisionMode() {
            CodeableConcept t = new CodeableConcept();
            if (this.decisionMode == null) {
                this.decisionMode = new ArrayList<CodeableConcept>();
            }
            this.decisionMode.add(t);
            return t;
        }

        public ContractOfferComponent addDecisionMode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.decisionMode == null) {
                this.decisionMode = new ArrayList<CodeableConcept>();
            }
            this.decisionMode.add(t);
            return this;
        }

        public CodeableConcept getDecisionModeFirstRep() {
            if (this.getDecisionMode().isEmpty()) {
                this.addDecisionMode();
            }
            return this.getDecisionMode().get(0);
        }

        public List<AnswerComponent> getAnswer() {
            if (this.answer == null) {
                this.answer = new ArrayList<AnswerComponent>();
            }
            return this.answer;
        }

        public ContractOfferComponent setAnswer(List<AnswerComponent> theAnswer) {
            this.answer = theAnswer;
            return this;
        }

        public boolean hasAnswer() {
            if (this.answer == null) {
                return false;
            }
            for (AnswerComponent item : this.answer) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AnswerComponent addAnswer() {
            AnswerComponent t = new AnswerComponent();
            if (this.answer == null) {
                this.answer = new ArrayList<AnswerComponent>();
            }
            this.answer.add(t);
            return t;
        }

        public ContractOfferComponent addAnswer(AnswerComponent t) {
            if (t == null) {
                return this;
            }
            if (this.answer == null) {
                this.answer = new ArrayList<AnswerComponent>();
            }
            this.answer.add(t);
            return this;
        }

        public AnswerComponent getAnswerFirstRep() {
            if (this.getAnswer().isEmpty()) {
                this.addAnswer();
            }
            return this.getAnswer().get(0);
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContractOfferComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public ContractOfferComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public ContractOfferComponent setText(String value) {
            if (Utilities.noString(value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public List<StringType> getLinkId() {
            if (this.linkId == null) {
                this.linkId = new ArrayList<StringType>();
            }
            return this.linkId;
        }

        public ContractOfferComponent setLinkId(List<StringType> theLinkId) {
            this.linkId = theLinkId;
            return this;
        }

        public boolean hasLinkId() {
            if (this.linkId == null) {
                return false;
            }
            for (StringType item : this.linkId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addLinkIdElement() {
            StringType t = new StringType();
            if (this.linkId == null) {
                this.linkId = new ArrayList<StringType>();
            }
            this.linkId.add(t);
            return t;
        }

        public ContractOfferComponent addLinkId(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.linkId == null) {
                this.linkId = new ArrayList<StringType>();
            }
            this.linkId.add(t);
            return this;
        }

        public boolean hasLinkId(String value) {
            if (this.linkId == null) {
                return false;
            }
            for (StringType v : this.linkId) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<UnsignedIntType> getSecurityLabelNumber() {
            if (this.securityLabelNumber == null) {
                this.securityLabelNumber = new ArrayList<UnsignedIntType>();
            }
            return this.securityLabelNumber;
        }

        public ContractOfferComponent setSecurityLabelNumber(List<UnsignedIntType> theSecurityLabelNumber) {
            this.securityLabelNumber = theSecurityLabelNumber;
            return this;
        }

        public boolean hasSecurityLabelNumber() {
            if (this.securityLabelNumber == null) {
                return false;
            }
            for (UnsignedIntType item : this.securityLabelNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UnsignedIntType addSecurityLabelNumberElement() {
            UnsignedIntType t = new UnsignedIntType();
            if (this.securityLabelNumber == null) {
                this.securityLabelNumber = new ArrayList<UnsignedIntType>();
            }
            this.securityLabelNumber.add(t);
            return t;
        }

        public ContractOfferComponent addSecurityLabelNumber(int value) {
            UnsignedIntType t = new UnsignedIntType();
            t.setValue((Object)value);
            if (this.securityLabelNumber == null) {
                this.securityLabelNumber = new ArrayList<UnsignedIntType>();
            }
            this.securityLabelNumber.add(t);
            return this;
        }

        public boolean hasSecurityLabelNumber(int value) {
            if (this.securityLabelNumber == null) {
                return false;
            }
            for (UnsignedIntType v : this.securityLabelNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Contract.SP_IDENTIFIER, "Identifier", "Unique identifier for this particular Contract Provision.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property("party", "", "Offer Recipient.", 0, Integer.MAX_VALUE, this.party));
            children.add(new Property("topic", "Reference(Any)", "The owner of an asset has the residual control rights over the asset: the right to decide all usages of the asset in any way not inconsistent with a prior contract, custom, or law (Hart, 1995, p. 30).", 0, 1, this.topic));
            children.add(new Property("type", "CodeableConcept", "Type of Contract Provision such as specific requirements, purposes for actions, obligations, prohibitions, e.g. life time maximum benefit.", 0, 1, this.type));
            children.add(new Property("decision", "CodeableConcept", "Type of choice made by accepting party with respect to an offer made by an offeror/ grantee.", 0, 1, this.decision));
            children.add(new Property("decisionMode", "CodeableConcept", "How the decision about a Contract was conveyed.", 0, Integer.MAX_VALUE, this.decisionMode));
            children.add(new Property("answer", "", "Response to offer text.", 0, Integer.MAX_VALUE, this.answer));
            children.add(new Property("text", "string", "Human readable form of this Contract Offer.", 0, 1, this.text));
            children.add(new Property("linkId", "string", "The id of the clause or question text of the offer in the referenced questionnaire/response.", 0, Integer.MAX_VALUE, this.linkId));
            children.add(new Property("securityLabelNumber", "unsignedInt", "Security labels that protects the offer.", 0, Integer.MAX_VALUE, this.securityLabelNumber));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(Contract.SP_IDENTIFIER, "Identifier", "Unique identifier for this particular Contract Provision.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case 106437350: {
                    return new Property("party", "", "Offer Recipient.", 0, Integer.MAX_VALUE, this.party);
                }
                case 110546223: {
                    return new Property("topic", "Reference(Any)", "The owner of an asset has the residual control rights over the asset: the right to decide all usages of the asset in any way not inconsistent with a prior contract, custom, or law (Hart, 1995, p. 30).", 0, 1, this.topic);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Type of Contract Provision such as specific requirements, purposes for actions, obligations, prohibitions, e.g. life time maximum benefit.", 0, 1, this.type);
                }
                case 565719004: {
                    return new Property("decision", "CodeableConcept", "Type of choice made by accepting party with respect to an offer made by an offeror/ grantee.", 0, 1, this.decision);
                }
                case 675909535: {
                    return new Property("decisionMode", "CodeableConcept", "How the decision about a Contract was conveyed.", 0, Integer.MAX_VALUE, this.decisionMode);
                }
                case -1412808770: {
                    return new Property("answer", "", "Response to offer text.", 0, Integer.MAX_VALUE, this.answer);
                }
                case 3556653: {
                    return new Property("text", "string", "Human readable form of this Contract Offer.", 0, 1, this.text);
                }
                case -1102667083: {
                    return new Property("linkId", "string", "The id of the clause or question text of the offer in the referenced questionnaire/response.", 0, Integer.MAX_VALUE, this.linkId);
                }
                case -149460995: {
                    return new Property("securityLabelNumber", "unsignedInt", "Security labels that protects the offer.", 0, Integer.MAX_VALUE, this.securityLabelNumber);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case 106437350: {
                    return this.party == null ? new Base[]{} : this.party.toArray(new Base[this.party.size()]);
                }
                case 110546223: {
                    Base[] baseArray;
                    if (this.topic == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.topic;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 565719004: {
                    Base[] baseArray;
                    if (this.decision == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.decision;
                    }
                    return baseArray;
                }
                case 675909535: {
                    return this.decisionMode == null ? new Base[]{} : this.decisionMode.toArray(new Base[this.decisionMode.size()]);
                }
                case -1412808770: {
                    return this.answer == null ? new Base[]{} : this.answer.toArray(new Base[this.answer.size()]);
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.text;
                    }
                    return baseArray;
                }
                case -1102667083: {
                    return this.linkId == null ? new Base[]{} : this.linkId.toArray(new Base[this.linkId.size()]);
                }
                case -149460995: {
                    return this.securityLabelNumber == null ? new Base[]{} : this.securityLabelNumber.toArray(new Base[this.securityLabelNumber.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.getIdentifier().add(this.castToIdentifier(value));
                    return value;
                }
                case 106437350: {
                    this.getParty().add((ContractPartyComponent)value);
                    return value;
                }
                case 110546223: {
                    this.topic = this.castToReference(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 565719004: {
                    this.decision = this.castToCodeableConcept(value);
                    return value;
                }
                case 675909535: {
                    this.getDecisionMode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1412808770: {
                    this.getAnswer().add((AnswerComponent)value);
                    return value;
                }
                case 3556653: {
                    this.text = this.castToString(value);
                    return value;
                }
                case -1102667083: {
                    this.getLinkId().add(this.castToString(value));
                    return value;
                }
                case -149460995: {
                    this.getSecurityLabelNumber().add(this.castToUnsignedInt(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Contract.SP_IDENTIFIER)) {
                this.getIdentifier().add(this.castToIdentifier(value));
            } else if (name.equals("party")) {
                this.getParty().add((ContractPartyComponent)value);
            } else if (name.equals("topic")) {
                this.topic = this.castToReference(value);
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("decision")) {
                this.decision = this.castToCodeableConcept(value);
            } else if (name.equals("decisionMode")) {
                this.getDecisionMode().add(this.castToCodeableConcept(value));
            } else if (name.equals("answer")) {
                this.getAnswer().add((AnswerComponent)value);
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else if (name.equals("linkId")) {
                this.getLinkId().add(this.castToString(value));
            } else if (name.equals("securityLabelNumber")) {
                this.getSecurityLabelNumber().add(this.castToUnsignedInt(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.addIdentifier();
                }
                case 106437350: {
                    return this.addParty();
                }
                case 110546223: {
                    return this.getTopic();
                }
                case 3575610: {
                    return this.getType();
                }
                case 565719004: {
                    return this.getDecision();
                }
                case 675909535: {
                    return this.addDecisionMode();
                }
                case -1412808770: {
                    return this.addAnswer();
                }
                case 3556653: {
                    return this.getTextElement();
                }
                case -1102667083: {
                    return this.addLinkIdElement();
                }
                case -149460995: {
                    return this.addSecurityLabelNumberElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 106437350: {
                    return new String[0];
                }
                case 110546223: {
                    return new String[]{"Reference"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 565719004: {
                    return new String[]{"CodeableConcept"};
                }
                case 675909535: {
                    return new String[]{"CodeableConcept"};
                }
                case -1412808770: {
                    return new String[0];
                }
                case 3556653: {
                    return new String[]{"string"};
                }
                case -1102667083: {
                    return new String[]{"string"};
                }
                case -149460995: {
                    return new String[]{"unsignedInt"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Contract.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals("party")) {
                return this.addParty();
            }
            if (name.equals("topic")) {
                this.topic = new Reference();
                return this.topic;
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("decision")) {
                this.decision = new CodeableConcept();
                return this.decision;
            }
            if (name.equals("decisionMode")) {
                return this.addDecisionMode();
            }
            if (name.equals("answer")) {
                return this.addAnswer();
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.text");
            }
            if (name.equals("linkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.linkId");
            }
            if (name.equals("securityLabelNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.securityLabelNumber");
            }
            return super.addChild(name);
        }

        @Override
        public ContractOfferComponent copy() {
            ContractOfferComponent dst = new ContractOfferComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ContractOfferComponent dst) {
            super.copyValues(dst);
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier identifier : this.identifier) {
                    dst.identifier.add(identifier.copy());
                }
            }
            if (this.party != null) {
                dst.party = new ArrayList<ContractPartyComponent>();
                for (ContractPartyComponent contractPartyComponent : this.party) {
                    dst.party.add(contractPartyComponent.copy());
                }
            }
            dst.topic = this.topic == null ? null : this.topic.copy();
            dst.type = this.type == null ? null : this.type.copy();
            CodeableConcept codeableConcept = dst.decision = this.decision == null ? null : this.decision.copy();
            if (this.decisionMode != null) {
                dst.decisionMode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.decisionMode) {
                    dst.decisionMode.add(codeableConcept2.copy());
                }
            }
            if (this.answer != null) {
                dst.answer = new ArrayList<AnswerComponent>();
                for (AnswerComponent answerComponent : this.answer) {
                    dst.answer.add(answerComponent.copy());
                }
            }
            StringType stringType = dst.text = this.text == null ? null : this.text.copy();
            if (this.linkId != null) {
                dst.linkId = new ArrayList<StringType>();
                for (StringType stringType2 : this.linkId) {
                    dst.linkId.add(stringType2.copy());
                }
            }
            if (this.securityLabelNumber != null) {
                dst.securityLabelNumber = new ArrayList<UnsignedIntType>();
                for (UnsignedIntType unsignedIntType : this.securityLabelNumber) {
                    dst.securityLabelNumber.add(unsignedIntType.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ContractOfferComponent)) {
                return false;
            }
            ContractOfferComponent o = (ContractOfferComponent)other_;
            return ContractOfferComponent.compareDeep(this.identifier, o.identifier, true) && ContractOfferComponent.compareDeep(this.party, o.party, true) && ContractOfferComponent.compareDeep(this.topic, o.topic, true) && ContractOfferComponent.compareDeep(this.type, o.type, true) && ContractOfferComponent.compareDeep(this.decision, o.decision, true) && ContractOfferComponent.compareDeep(this.decisionMode, o.decisionMode, true) && ContractOfferComponent.compareDeep(this.answer, o.answer, true) && ContractOfferComponent.compareDeep(this.text, o.text, true) && ContractOfferComponent.compareDeep(this.linkId, o.linkId, true) && ContractOfferComponent.compareDeep(this.securityLabelNumber, o.securityLabelNumber, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ContractOfferComponent)) {
                return false;
            }
            ContractOfferComponent o = (ContractOfferComponent)other_;
            return ContractOfferComponent.compareValues(this.text, o.text, true) && ContractOfferComponent.compareValues(this.linkId, o.linkId, true) && ContractOfferComponent.compareValues(this.securityLabelNumber, o.securityLabelNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.party, this.topic, this.type, this.decision, this.decisionMode, this.answer, this.text, this.linkId, this.securityLabelNumber);
        }

        @Override
        public String fhirType() {
            return "Contract.term.offer";
        }
    }

    @Block
    public static class SecurityLabelComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="number", type={UnsignedIntType.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Link to Security Labels", formalDefinition="Number used to link this term or term element to the applicable Security Label.")
        protected List<UnsignedIntType> number;
        @Child(name="classification", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Confidentiality Protection", formalDefinition="Security label privacy tag that species the level of confidentiality protection required for this term and/or term elements.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-security-classification")
        protected Coding classification;
        @Child(name="category", type={Coding.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable Policy", formalDefinition="Security label privacy tag that species the applicable privacy and security policies governing this term and/or term elements.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-security-category")
        protected List<Coding> category;
        @Child(name="control", type={Coding.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Handling Instructions", formalDefinition="Security label privacy tag that species the manner in which term and/or term elements are to be protected.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-security-control")
        protected List<Coding> control;
        private static final long serialVersionUID = 788281758L;

        public SecurityLabelComponent() {
        }

        public SecurityLabelComponent(Coding classification) {
            this.classification = classification;
        }

        public List<UnsignedIntType> getNumber() {
            if (this.number == null) {
                this.number = new ArrayList<UnsignedIntType>();
            }
            return this.number;
        }

        public SecurityLabelComponent setNumber(List<UnsignedIntType> theNumber) {
            this.number = theNumber;
            return this;
        }

        public boolean hasNumber() {
            if (this.number == null) {
                return false;
            }
            for (UnsignedIntType item : this.number) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UnsignedIntType addNumberElement() {
            UnsignedIntType t = new UnsignedIntType();
            if (this.number == null) {
                this.number = new ArrayList<UnsignedIntType>();
            }
            this.number.add(t);
            return t;
        }

        public SecurityLabelComponent addNumber(int value) {
            UnsignedIntType t = new UnsignedIntType();
            t.setValue((Object)value);
            if (this.number == null) {
                this.number = new ArrayList<UnsignedIntType>();
            }
            this.number.add(t);
            return this;
        }

        public boolean hasNumber(int value) {
            if (this.number == null) {
                return false;
            }
            for (UnsignedIntType v : this.number) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public Coding getClassification() {
            if (this.classification == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SecurityLabelComponent.classification");
                }
                if (Configuration.doAutoCreate()) {
                    this.classification = new Coding();
                }
            }
            return this.classification;
        }

        public boolean hasClassification() {
            return this.classification != null && !this.classification.isEmpty();
        }

        public SecurityLabelComponent setClassification(Coding value) {
            this.classification = value;
            return this;
        }

        public List<Coding> getCategory() {
            if (this.category == null) {
                this.category = new ArrayList<Coding>();
            }
            return this.category;
        }

        public SecurityLabelComponent setCategory(List<Coding> theCategory) {
            this.category = theCategory;
            return this;
        }

        public boolean hasCategory() {
            if (this.category == null) {
                return false;
            }
            for (Coding item : this.category) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addCategory() {
            Coding t = new Coding();
            if (this.category == null) {
                this.category = new ArrayList<Coding>();
            }
            this.category.add(t);
            return t;
        }

        public SecurityLabelComponent addCategory(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.category == null) {
                this.category = new ArrayList<Coding>();
            }
            this.category.add(t);
            return this;
        }

        public Coding getCategoryFirstRep() {
            if (this.getCategory().isEmpty()) {
                this.addCategory();
            }
            return this.getCategory().get(0);
        }

        public List<Coding> getControl() {
            if (this.control == null) {
                this.control = new ArrayList<Coding>();
            }
            return this.control;
        }

        public SecurityLabelComponent setControl(List<Coding> theControl) {
            this.control = theControl;
            return this;
        }

        public boolean hasControl() {
            if (this.control == null) {
                return false;
            }
            for (Coding item : this.control) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addControl() {
            Coding t = new Coding();
            if (this.control == null) {
                this.control = new ArrayList<Coding>();
            }
            this.control.add(t);
            return t;
        }

        public SecurityLabelComponent addControl(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.control == null) {
                this.control = new ArrayList<Coding>();
            }
            this.control.add(t);
            return this;
        }

        public Coding getControlFirstRep() {
            if (this.getControl().isEmpty()) {
                this.addControl();
            }
            return this.getControl().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("number", "unsignedInt", "Number used to link this term or term element to the applicable Security Label.", 0, Integer.MAX_VALUE, this.number));
            children.add(new Property("classification", "Coding", "Security label privacy tag that species the level of confidentiality protection required for this term and/or term elements.", 0, 1, this.classification));
            children.add(new Property("category", "Coding", "Security label privacy tag that species the applicable privacy and security policies governing this term and/or term elements.", 0, Integer.MAX_VALUE, this.category));
            children.add(new Property("control", "Coding", "Security label privacy tag that species the manner in which term and/or term elements are to be protected.", 0, Integer.MAX_VALUE, this.control));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1034364087: {
                    return new Property("number", "unsignedInt", "Number used to link this term or term element to the applicable Security Label.", 0, Integer.MAX_VALUE, this.number);
                }
                case 382350310: {
                    return new Property("classification", "Coding", "Security label privacy tag that species the level of confidentiality protection required for this term and/or term elements.", 0, 1, this.classification);
                }
                case 50511102: {
                    return new Property("category", "Coding", "Security label privacy tag that species the applicable privacy and security policies governing this term and/or term elements.", 0, Integer.MAX_VALUE, this.category);
                }
                case 951543133: {
                    return new Property("control", "Coding", "Security label privacy tag that species the manner in which term and/or term elements are to be protected.", 0, Integer.MAX_VALUE, this.control);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    return this.number == null ? new Base[]{} : this.number.toArray(new Base[this.number.size()]);
                }
                case 382350310: {
                    Base[] baseArray;
                    if (this.classification == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.classification;
                    }
                    return baseArray;
                }
                case 50511102: {
                    return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
                }
                case 951543133: {
                    return this.control == null ? new Base[]{} : this.control.toArray(new Base[this.control.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    this.getNumber().add(this.castToUnsignedInt(value));
                    return value;
                }
                case 382350310: {
                    this.classification = this.castToCoding(value);
                    return value;
                }
                case 50511102: {
                    this.getCategory().add(this.castToCoding(value));
                    return value;
                }
                case 951543133: {
                    this.getControl().add(this.castToCoding(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("number")) {
                this.getNumber().add(this.castToUnsignedInt(value));
            } else if (name.equals("classification")) {
                this.classification = this.castToCoding(value);
            } else if (name.equals("category")) {
                this.getCategory().add(this.castToCoding(value));
            } else if (name.equals("control")) {
                this.getControl().add(this.castToCoding(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    return this.addNumberElement();
                }
                case 382350310: {
                    return this.getClassification();
                }
                case 50511102: {
                    return this.addCategory();
                }
                case 951543133: {
                    return this.addControl();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    return new String[]{"unsignedInt"};
                }
                case 382350310: {
                    return new String[]{"Coding"};
                }
                case 50511102: {
                    return new String[]{"Coding"};
                }
                case 951543133: {
                    return new String[]{"Coding"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("number")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.number");
            }
            if (name.equals("classification")) {
                this.classification = new Coding();
                return this.classification;
            }
            if (name.equals("category")) {
                return this.addCategory();
            }
            if (name.equals("control")) {
                return this.addControl();
            }
            return super.addChild(name);
        }

        @Override
        public SecurityLabelComponent copy() {
            SecurityLabelComponent dst = new SecurityLabelComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SecurityLabelComponent dst) {
            super.copyValues(dst);
            if (this.number != null) {
                dst.number = new ArrayList<UnsignedIntType>();
                for (UnsignedIntType unsignedIntType : this.number) {
                    dst.number.add(unsignedIntType.copy());
                }
            }
            Coding coding = dst.classification = this.classification == null ? null : this.classification.copy();
            if (this.category != null) {
                dst.category = new ArrayList<Coding>();
                for (Coding coding2 : this.category) {
                    dst.category.add(coding2.copy());
                }
            }
            if (this.control != null) {
                dst.control = new ArrayList<Coding>();
                for (Coding coding3 : this.control) {
                    dst.control.add(coding3.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SecurityLabelComponent)) {
                return false;
            }
            SecurityLabelComponent o = (SecurityLabelComponent)other_;
            return SecurityLabelComponent.compareDeep(this.number, o.number, true) && SecurityLabelComponent.compareDeep(this.classification, o.classification, true) && SecurityLabelComponent.compareDeep(this.category, o.category, true) && SecurityLabelComponent.compareDeep(this.control, o.control, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SecurityLabelComponent)) {
                return false;
            }
            SecurityLabelComponent o = (SecurityLabelComponent)other_;
            return SecurityLabelComponent.compareValues(this.number, o.number, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.number, this.classification, this.category, this.control);
        }

        @Override
        public String fhirType() {
            return "Contract.term.securityLabel";
        }
    }

    @Block
    public static class TermComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Contract Term Number", formalDefinition="Unique identifier for this particular Contract Provision.")
        protected Identifier identifier;
        @Child(name="issued", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Contract Term Issue Date Time", formalDefinition="When this Contract Provision was issued.")
        protected DateTimeType issued;
        @Child(name="applies", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Contract Term Effective Time", formalDefinition="Relevant time or time-period when this Contract Provision is applicable.")
        protected Period applies;
        @Child(name="topic", type={CodeableConcept.class, Reference.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Term Concern", formalDefinition="The entity that the term applies to.")
        protected Type topic;
        @Child(name="type", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Type or Form", formalDefinition="A legal clause or condition contained within a contract that requires one or both parties to perform a particular requirement by some specified time or prevents one or both parties from performing a particular requirement by some specified time.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-term-type")
        protected CodeableConcept type;
        @Child(name="subType", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Type specific classification", formalDefinition="A specialized legal clause or condition based on overarching contract type.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-term-subtype")
        protected CodeableConcept subType;
        @Child(name="text", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Term Statement", formalDefinition="Statement of a provision in a policy or a contract.")
        protected StringType text;
        @Child(name="securityLabel", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Protection for the Term", formalDefinition="Security labels that protect the handling of information about the term and its elements, which may be specifically identified..")
        protected List<SecurityLabelComponent> securityLabel;
        @Child(name="offer", type={}, order=9, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Context of the Contract term", formalDefinition="The matter of concern in the context of this provision of the agrement.")
        protected ContractOfferComponent offer;
        @Child(name="asset", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Asset List", formalDefinition="Contract Term Asset List.")
        protected List<ContractAssetComponent> asset;
        @Child(name="action", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Entity being ascribed responsibility", formalDefinition="An actor taking a role in an activity for which it can be assigned some degree of responsibility for the activity taking place.")
        protected List<ActionComponent> action;
        @Child(name="group", type={TermComponent.class}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested Contract Term Group", formalDefinition="Nested group of Contract Provisions.")
        protected List<TermComponent> group;
        private static final long serialVersionUID = -460907186L;

        public TermComponent() {
        }

        public TermComponent(ContractOfferComponent offer) {
            this.offer = offer;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public TermComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public DateTimeType getIssuedElement() {
            if (this.issued == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermComponent.issued");
                }
                if (Configuration.doAutoCreate()) {
                    this.issued = new DateTimeType();
                }
            }
            return this.issued;
        }

        public boolean hasIssuedElement() {
            return this.issued != null && !this.issued.isEmpty();
        }

        public boolean hasIssued() {
            return this.issued != null && !this.issued.isEmpty();
        }

        public TermComponent setIssuedElement(DateTimeType value) {
            this.issued = value;
            return this;
        }

        public Date getIssued() {
            return this.issued == null ? null : (Date)this.issued.getValue();
        }

        public TermComponent setIssued(Date value) {
            if (value == null) {
                this.issued = null;
            } else {
                if (this.issued == null) {
                    this.issued = new DateTimeType();
                }
                this.issued.setValue(value);
            }
            return this;
        }

        public Period getApplies() {
            if (this.applies == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermComponent.applies");
                }
                if (Configuration.doAutoCreate()) {
                    this.applies = new Period();
                }
            }
            return this.applies;
        }

        public boolean hasApplies() {
            return this.applies != null && !this.applies.isEmpty();
        }

        public TermComponent setApplies(Period value) {
            this.applies = value;
            return this;
        }

        public Type getTopic() {
            return this.topic;
        }

        public CodeableConcept getTopicCodeableConcept() throws FHIRException {
            if (this.topic == null) {
                this.topic = new CodeableConcept();
            }
            if (!(this.topic instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.topic.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.topic;
        }

        public boolean hasTopicCodeableConcept() {
            return this != null && this.topic instanceof CodeableConcept;
        }

        public Reference getTopicReference() throws FHIRException {
            if (this.topic == null) {
                this.topic = new Reference();
            }
            if (!(this.topic instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.topic.getClass().getName() + " was encountered");
            }
            return (Reference)this.topic;
        }

        public boolean hasTopicReference() {
            return this != null && this.topic instanceof Reference;
        }

        public boolean hasTopic() {
            return this.topic != null && !this.topic.isEmpty();
        }

        public TermComponent setTopic(Type value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for Contract.term.topic[x]: " + value.fhirType());
            }
            this.topic = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public TermComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getSubType() {
            if (this.subType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermComponent.subType");
                }
                if (Configuration.doAutoCreate()) {
                    this.subType = new CodeableConcept();
                }
            }
            return this.subType;
        }

        public boolean hasSubType() {
            return this.subType != null && !this.subType.isEmpty();
        }

        public TermComponent setSubType(CodeableConcept value) {
            this.subType = value;
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public TermComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public TermComponent setText(String value) {
            if (Utilities.noString(value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public List<SecurityLabelComponent> getSecurityLabel() {
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<SecurityLabelComponent>();
            }
            return this.securityLabel;
        }

        public TermComponent setSecurityLabel(List<SecurityLabelComponent> theSecurityLabel) {
            this.securityLabel = theSecurityLabel;
            return this;
        }

        public boolean hasSecurityLabel() {
            if (this.securityLabel == null) {
                return false;
            }
            for (SecurityLabelComponent item : this.securityLabel) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SecurityLabelComponent addSecurityLabel() {
            SecurityLabelComponent t = new SecurityLabelComponent();
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<SecurityLabelComponent>();
            }
            this.securityLabel.add(t);
            return t;
        }

        public TermComponent addSecurityLabel(SecurityLabelComponent t) {
            if (t == null) {
                return this;
            }
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<SecurityLabelComponent>();
            }
            this.securityLabel.add(t);
            return this;
        }

        public SecurityLabelComponent getSecurityLabelFirstRep() {
            if (this.getSecurityLabel().isEmpty()) {
                this.addSecurityLabel();
            }
            return this.getSecurityLabel().get(0);
        }

        public ContractOfferComponent getOffer() {
            if (this.offer == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermComponent.offer");
                }
                if (Configuration.doAutoCreate()) {
                    this.offer = new ContractOfferComponent();
                }
            }
            return this.offer;
        }

        public boolean hasOffer() {
            return this.offer != null && !this.offer.isEmpty();
        }

        public TermComponent setOffer(ContractOfferComponent value) {
            this.offer = value;
            return this;
        }

        public List<ContractAssetComponent> getAsset() {
            if (this.asset == null) {
                this.asset = new ArrayList<ContractAssetComponent>();
            }
            return this.asset;
        }

        public TermComponent setAsset(List<ContractAssetComponent> theAsset) {
            this.asset = theAsset;
            return this;
        }

        public boolean hasAsset() {
            if (this.asset == null) {
                return false;
            }
            for (ContractAssetComponent item : this.asset) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContractAssetComponent addAsset() {
            ContractAssetComponent t = new ContractAssetComponent();
            if (this.asset == null) {
                this.asset = new ArrayList<ContractAssetComponent>();
            }
            this.asset.add(t);
            return t;
        }

        public TermComponent addAsset(ContractAssetComponent t) {
            if (t == null) {
                return this;
            }
            if (this.asset == null) {
                this.asset = new ArrayList<ContractAssetComponent>();
            }
            this.asset.add(t);
            return this;
        }

        public ContractAssetComponent getAssetFirstRep() {
            if (this.getAsset().isEmpty()) {
                this.addAsset();
            }
            return this.getAsset().get(0);
        }

        public List<ActionComponent> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<ActionComponent>();
            }
            return this.action;
        }

        public TermComponent setAction(List<ActionComponent> theAction) {
            this.action = theAction;
            return this;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (ActionComponent item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ActionComponent addAction() {
            ActionComponent t = new ActionComponent();
            if (this.action == null) {
                this.action = new ArrayList<ActionComponent>();
            }
            this.action.add(t);
            return t;
        }

        public TermComponent addAction(ActionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<ActionComponent>();
            }
            this.action.add(t);
            return this;
        }

        public ActionComponent getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                this.addAction();
            }
            return this.getAction().get(0);
        }

        public List<TermComponent> getGroup() {
            if (this.group == null) {
                this.group = new ArrayList<TermComponent>();
            }
            return this.group;
        }

        public TermComponent setGroup(List<TermComponent> theGroup) {
            this.group = theGroup;
            return this;
        }

        public boolean hasGroup() {
            if (this.group == null) {
                return false;
            }
            for (TermComponent item : this.group) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TermComponent addGroup() {
            TermComponent t = new TermComponent();
            if (this.group == null) {
                this.group = new ArrayList<TermComponent>();
            }
            this.group.add(t);
            return t;
        }

        public TermComponent addGroup(TermComponent t) {
            if (t == null) {
                return this;
            }
            if (this.group == null) {
                this.group = new ArrayList<TermComponent>();
            }
            this.group.add(t);
            return this;
        }

        public TermComponent getGroupFirstRep() {
            if (this.getGroup().isEmpty()) {
                this.addGroup();
            }
            return this.getGroup().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Contract.SP_IDENTIFIER, "Identifier", "Unique identifier for this particular Contract Provision.", 0, 1, this.identifier));
            children.add(new Property(Contract.SP_ISSUED, "dateTime", "When this Contract Provision was issued.", 0, 1, this.issued));
            children.add(new Property("applies", "Period", "Relevant time or time-period when this Contract Provision is applicable.", 0, 1, this.applies));
            children.add(new Property("topic[x]", "CodeableConcept|Reference(Any)", "The entity that the term applies to.", 0, 1, this.topic));
            children.add(new Property("type", "CodeableConcept", "A legal clause or condition contained within a contract that requires one or both parties to perform a particular requirement by some specified time or prevents one or both parties from performing a particular requirement by some specified time.", 0, 1, this.type));
            children.add(new Property("subType", "CodeableConcept", "A specialized legal clause or condition based on overarching contract type.", 0, 1, this.subType));
            children.add(new Property("text", "string", "Statement of a provision in a policy or a contract.", 0, 1, this.text));
            children.add(new Property("securityLabel", "", "Security labels that protect the handling of information about the term and its elements, which may be specifically identified..", 0, Integer.MAX_VALUE, this.securityLabel));
            children.add(new Property("offer", "", "The matter of concern in the context of this provision of the agrement.", 0, 1, this.offer));
            children.add(new Property("asset", "", "Contract Term Asset List.", 0, Integer.MAX_VALUE, this.asset));
            children.add(new Property("action", "", "An actor taking a role in an activity for which it can be assigned some degree of responsibility for the activity taking place.", 0, Integer.MAX_VALUE, this.action));
            children.add(new Property("group", "@Contract.term", "Nested group of Contract Provisions.", 0, Integer.MAX_VALUE, this.group));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(Contract.SP_IDENTIFIER, "Identifier", "Unique identifier for this particular Contract Provision.", 0, 1, this.identifier);
                }
                case -1179159893: {
                    return new Property(Contract.SP_ISSUED, "dateTime", "When this Contract Provision was issued.", 0, 1, this.issued);
                }
                case -793235316: {
                    return new Property("applies", "Period", "Relevant time or time-period when this Contract Provision is applicable.", 0, 1, this.applies);
                }
                case -957295375: {
                    return new Property("topic[x]", "CodeableConcept|Reference(Any)", "The entity that the term applies to.", 0, 1, this.topic);
                }
                case 110546223: {
                    return new Property("topic[x]", "CodeableConcept|Reference(Any)", "The entity that the term applies to.", 0, 1, this.topic);
                }
                case 777778802: {
                    return new Property("topic[x]", "CodeableConcept|Reference(Any)", "The entity that the term applies to.", 0, 1, this.topic);
                }
                case -343345444: {
                    return new Property("topic[x]", "CodeableConcept|Reference(Any)", "The entity that the term applies to.", 0, 1, this.topic);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "A legal clause or condition contained within a contract that requires one or both parties to perform a particular requirement by some specified time or prevents one or both parties from performing a particular requirement by some specified time.", 0, 1, this.type);
                }
                case -1868521062: {
                    return new Property("subType", "CodeableConcept", "A specialized legal clause or condition based on overarching contract type.", 0, 1, this.subType);
                }
                case 3556653: {
                    return new Property("text", "string", "Statement of a provision in a policy or a contract.", 0, 1, this.text);
                }
                case -722296940: {
                    return new Property("securityLabel", "", "Security labels that protect the handling of information about the term and its elements, which may be specifically identified..", 0, Integer.MAX_VALUE, this.securityLabel);
                }
                case 105650780: {
                    return new Property("offer", "", "The matter of concern in the context of this provision of the agrement.", 0, 1, this.offer);
                }
                case 93121264: {
                    return new Property("asset", "", "Contract Term Asset List.", 0, Integer.MAX_VALUE, this.asset);
                }
                case -1422950858: {
                    return new Property("action", "", "An actor taking a role in an activity for which it can be assigned some degree of responsibility for the activity taking place.", 0, Integer.MAX_VALUE, this.action);
                }
                case 98629247: {
                    return new Property("group", "@Contract.term", "Nested group of Contract Provisions.", 0, Integer.MAX_VALUE, this.group);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case -1179159893: {
                    Base[] baseArray;
                    if (this.issued == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.issued;
                    }
                    return baseArray;
                }
                case -793235316: {
                    Base[] baseArray;
                    if (this.applies == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.applies;
                    }
                    return baseArray;
                }
                case 110546223: {
                    Base[] baseArray;
                    if (this.topic == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.topic;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.type;
                    }
                    return baseArray;
                }
                case -1868521062: {
                    Base[] baseArray;
                    if (this.subType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.subType;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.text;
                    }
                    return baseArray;
                }
                case -722296940: {
                    return this.securityLabel == null ? new Base[]{} : this.securityLabel.toArray(new Base[this.securityLabel.size()]);
                }
                case 105650780: {
                    Base[] baseArray;
                    if (this.offer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.offer;
                    }
                    return baseArray;
                }
                case 93121264: {
                    return this.asset == null ? new Base[]{} : this.asset.toArray(new Base[this.asset.size()]);
                }
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
                case 98629247: {
                    return this.group == null ? new Base[]{} : this.group.toArray(new Base[this.group.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
                case -1179159893: {
                    this.issued = this.castToDateTime(value);
                    return value;
                }
                case -793235316: {
                    this.applies = this.castToPeriod(value);
                    return value;
                }
                case 110546223: {
                    this.topic = this.castToType(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1868521062: {
                    this.subType = this.castToCodeableConcept(value);
                    return value;
                }
                case 3556653: {
                    this.text = this.castToString(value);
                    return value;
                }
                case -722296940: {
                    this.getSecurityLabel().add((SecurityLabelComponent)value);
                    return value;
                }
                case 105650780: {
                    this.offer = (ContractOfferComponent)value;
                    return value;
                }
                case 93121264: {
                    this.getAsset().add((ContractAssetComponent)value);
                    return value;
                }
                case -1422950858: {
                    this.getAction().add((ActionComponent)value);
                    return value;
                }
                case 98629247: {
                    this.getGroup().add((TermComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Contract.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals(Contract.SP_ISSUED)) {
                this.issued = this.castToDateTime(value);
            } else if (name.equals("applies")) {
                this.applies = this.castToPeriod(value);
            } else if (name.equals("topic[x]")) {
                this.topic = this.castToType(value);
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("subType")) {
                this.subType = this.castToCodeableConcept(value);
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else if (name.equals("securityLabel")) {
                this.getSecurityLabel().add((SecurityLabelComponent)value);
            } else if (name.equals("offer")) {
                this.offer = (ContractOfferComponent)value;
            } else if (name.equals("asset")) {
                this.getAsset().add((ContractAssetComponent)value);
            } else if (name.equals("action")) {
                this.getAction().add((ActionComponent)value);
            } else if (name.equals("group")) {
                this.getGroup().add((TermComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case -1179159893: {
                    return this.getIssuedElement();
                }
                case -793235316: {
                    return this.getApplies();
                }
                case -957295375: {
                    return this.getTopic();
                }
                case 110546223: {
                    return this.getTopic();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1868521062: {
                    return this.getSubType();
                }
                case 3556653: {
                    return this.getTextElement();
                }
                case -722296940: {
                    return this.addSecurityLabel();
                }
                case 105650780: {
                    return this.getOffer();
                }
                case 93121264: {
                    return this.addAsset();
                }
                case -1422950858: {
                    return this.addAction();
                }
                case 98629247: {
                    return this.addGroup();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case -1179159893: {
                    return new String[]{"dateTime"};
                }
                case -793235316: {
                    return new String[]{"Period"};
                }
                case 110546223: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1868521062: {
                    return new String[]{"CodeableConcept"};
                }
                case 3556653: {
                    return new String[]{"string"};
                }
                case -722296940: {
                    return new String[0];
                }
                case 105650780: {
                    return new String[0];
                }
                case 93121264: {
                    return new String[0];
                }
                case -1422950858: {
                    return new String[0];
                }
                case 98629247: {
                    return new String[]{"@Contract.term"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Contract.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals(Contract.SP_ISSUED)) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.issued");
            }
            if (name.equals("applies")) {
                this.applies = new Period();
                return this.applies;
            }
            if (name.equals("topicCodeableConcept")) {
                this.topic = new CodeableConcept();
                return this.topic;
            }
            if (name.equals("topicReference")) {
                this.topic = new Reference();
                return this.topic;
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("subType")) {
                this.subType = new CodeableConcept();
                return this.subType;
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.text");
            }
            if (name.equals("securityLabel")) {
                return this.addSecurityLabel();
            }
            if (name.equals("offer")) {
                this.offer = new ContractOfferComponent();
                return this.offer;
            }
            if (name.equals("asset")) {
                return this.addAsset();
            }
            if (name.equals("action")) {
                return this.addAction();
            }
            if (name.equals("group")) {
                return this.addGroup();
            }
            return super.addChild(name);
        }

        @Override
        public TermComponent copy() {
            TermComponent dst = new TermComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TermComponent dst) {
            super.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.issued = this.issued == null ? null : this.issued.copy();
            dst.applies = this.applies == null ? null : this.applies.copy();
            dst.topic = this.topic == null ? null : this.topic.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.subType = this.subType == null ? null : this.subType.copy();
            StringType stringType = dst.text = this.text == null ? null : this.text.copy();
            if (this.securityLabel != null) {
                dst.securityLabel = new ArrayList<SecurityLabelComponent>();
                for (SecurityLabelComponent securityLabelComponent : this.securityLabel) {
                    dst.securityLabel.add(securityLabelComponent.copy());
                }
            }
            ContractOfferComponent contractOfferComponent = dst.offer = this.offer == null ? null : this.offer.copy();
            if (this.asset != null) {
                dst.asset = new ArrayList<ContractAssetComponent>();
                for (ContractAssetComponent contractAssetComponent : this.asset) {
                    dst.asset.add(contractAssetComponent.copy());
                }
            }
            if (this.action != null) {
                dst.action = new ArrayList<ActionComponent>();
                for (ActionComponent actionComponent : this.action) {
                    dst.action.add(actionComponent.copy());
                }
            }
            if (this.group != null) {
                dst.group = new ArrayList<TermComponent>();
                for (TermComponent termComponent : this.group) {
                    dst.group.add(termComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TermComponent)) {
                return false;
            }
            TermComponent o = (TermComponent)other_;
            return TermComponent.compareDeep(this.identifier, o.identifier, true) && TermComponent.compareDeep(this.issued, o.issued, true) && TermComponent.compareDeep(this.applies, o.applies, true) && TermComponent.compareDeep(this.topic, o.topic, true) && TermComponent.compareDeep(this.type, o.type, true) && TermComponent.compareDeep(this.subType, o.subType, true) && TermComponent.compareDeep(this.text, o.text, true) && TermComponent.compareDeep(this.securityLabel, o.securityLabel, true) && TermComponent.compareDeep(this.offer, o.offer, true) && TermComponent.compareDeep(this.asset, o.asset, true) && TermComponent.compareDeep(this.action, o.action, true) && TermComponent.compareDeep(this.group, o.group, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TermComponent)) {
                return false;
            }
            TermComponent o = (TermComponent)other_;
            return TermComponent.compareValues(this.issued, o.issued, true) && TermComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.issued, this.applies, this.topic, this.type, this.subType, this.text, this.securityLabel, this.offer, this.asset, this.action, this.group);
        }

        @Override
        public String fhirType() {
            return "Contract.term";
        }
    }

    @Block
    public static class ContentDefinitionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Content structure and use", formalDefinition="Precusory content structure and use, i.e., a boilerplate, template, application for a contract such as an insurance policy or benefits under a program, e.g., workers compensation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-definition-type")
        protected CodeableConcept type;
        @Child(name="subType", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Detailed Content Type Definition", formalDefinition="Detailed Precusory content type.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-definition-subtype")
        protected CodeableConcept subType;
        @Child(name="publisher", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Publisher Entity", formalDefinition="The  individual or organization that published the Contract precursor content.")
        protected Reference publisher;
        protected Resource publisherTarget;
        @Child(name="publicationDate", type={DateTimeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When published", formalDefinition="The date (and optionally time) when the contract was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the contract changes.")
        protected DateTimeType publicationDate;
        @Child(name="publicationStatus", type={CodeType.class}, order=5, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="amended | appended | cancelled | disputed | entered-in-error | executable | executed | negotiable | offered | policy | rejected | renewed | revoked | resolved | terminated", formalDefinition="amended | appended | cancelled | disputed | entered-in-error | executable | executed | negotiable | offered | policy | rejected | renewed | revoked | resolved | terminated.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-publicationstatus")
        protected Enumeration<ContractPublicationStatus> publicationStatus;
        @Child(name="copyright", type={MarkdownType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Publication Ownership", formalDefinition="A copyright statement relating to Contract precursor content. Copyright statements are generally legal restrictions on the use and publishing of the Contract precursor content.")
        protected MarkdownType copyright;
        private static final long serialVersionUID = -699592864L;

        public ContentDefinitionComponent() {
        }

        public ContentDefinitionComponent(CodeableConcept type, Enumeration<ContractPublicationStatus> publicationStatus) {
            this.type = type;
            this.publicationStatus = publicationStatus;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContentDefinitionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ContentDefinitionComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getSubType() {
            if (this.subType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContentDefinitionComponent.subType");
                }
                if (Configuration.doAutoCreate()) {
                    this.subType = new CodeableConcept();
                }
            }
            return this.subType;
        }

        public boolean hasSubType() {
            return this.subType != null && !this.subType.isEmpty();
        }

        public ContentDefinitionComponent setSubType(CodeableConcept value) {
            this.subType = value;
            return this;
        }

        public Reference getPublisher() {
            if (this.publisher == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContentDefinitionComponent.publisher");
                }
                if (Configuration.doAutoCreate()) {
                    this.publisher = new Reference();
                }
            }
            return this.publisher;
        }

        public boolean hasPublisher() {
            return this.publisher != null && !this.publisher.isEmpty();
        }

        public ContentDefinitionComponent setPublisher(Reference value) {
            this.publisher = value;
            return this;
        }

        public Resource getPublisherTarget() {
            return this.publisherTarget;
        }

        public ContentDefinitionComponent setPublisherTarget(Resource value) {
            this.publisherTarget = value;
            return this;
        }

        public DateTimeType getPublicationDateElement() {
            if (this.publicationDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContentDefinitionComponent.publicationDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.publicationDate = new DateTimeType();
                }
            }
            return this.publicationDate;
        }

        public boolean hasPublicationDateElement() {
            return this.publicationDate != null && !this.publicationDate.isEmpty();
        }

        public boolean hasPublicationDate() {
            return this.publicationDate != null && !this.publicationDate.isEmpty();
        }

        public ContentDefinitionComponent setPublicationDateElement(DateTimeType value) {
            this.publicationDate = value;
            return this;
        }

        public Date getPublicationDate() {
            return this.publicationDate == null ? null : (Date)this.publicationDate.getValue();
        }

        public ContentDefinitionComponent setPublicationDate(Date value) {
            if (value == null) {
                this.publicationDate = null;
            } else {
                if (this.publicationDate == null) {
                    this.publicationDate = new DateTimeType();
                }
                this.publicationDate.setValue(value);
            }
            return this;
        }

        public Enumeration<ContractPublicationStatus> getPublicationStatusElement() {
            if (this.publicationStatus == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContentDefinitionComponent.publicationStatus");
                }
                if (Configuration.doAutoCreate()) {
                    this.publicationStatus = new Enumeration<ContractPublicationStatus>(new ContractPublicationStatusEnumFactory());
                }
            }
            return this.publicationStatus;
        }

        public boolean hasPublicationStatusElement() {
            return this.publicationStatus != null && !this.publicationStatus.isEmpty();
        }

        public boolean hasPublicationStatus() {
            return this.publicationStatus != null && !this.publicationStatus.isEmpty();
        }

        public ContentDefinitionComponent setPublicationStatusElement(Enumeration<ContractPublicationStatus> value) {
            this.publicationStatus = value;
            return this;
        }

        public ContractPublicationStatus getPublicationStatus() {
            return this.publicationStatus == null ? null : (ContractPublicationStatus)((Object)this.publicationStatus.getValue());
        }

        public ContentDefinitionComponent setPublicationStatus(ContractPublicationStatus value) {
            if (this.publicationStatus == null) {
                this.publicationStatus = new Enumeration<ContractPublicationStatus>(new ContractPublicationStatusEnumFactory());
            }
            this.publicationStatus.setValue((Object)value);
            return this;
        }

        public MarkdownType getCopyrightElement() {
            if (this.copyright == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContentDefinitionComponent.copyright");
                }
                if (Configuration.doAutoCreate()) {
                    this.copyright = new MarkdownType();
                }
            }
            return this.copyright;
        }

        public boolean hasCopyrightElement() {
            return this.copyright != null && !this.copyright.isEmpty();
        }

        public boolean hasCopyright() {
            return this.copyright != null && !this.copyright.isEmpty();
        }

        public ContentDefinitionComponent setCopyrightElement(MarkdownType value) {
            this.copyright = value;
            return this;
        }

        public String getCopyright() {
            return this.copyright == null ? null : (String)this.copyright.getValue();
        }

        public ContentDefinitionComponent setCopyright(String value) {
            if (value == null) {
                this.copyright = null;
            } else {
                if (this.copyright == null) {
                    this.copyright = new MarkdownType();
                }
                this.copyright.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Precusory content structure and use, i.e., a boilerplate, template, application for a contract such as an insurance policy or benefits under a program, e.g., workers compensation.", 0, 1, this.type));
            children.add(new Property("subType", "CodeableConcept", "Detailed Precusory content type.", 0, 1, this.subType));
            children.add(new Property("publisher", "Reference(Practitioner|PractitionerRole|Organization)", "The  individual or organization that published the Contract precursor content.", 0, 1, this.publisher));
            children.add(new Property("publicationDate", "dateTime", "The date (and optionally time) when the contract was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the contract changes.", 0, 1, this.publicationDate));
            children.add(new Property("publicationStatus", "code", "amended | appended | cancelled | disputed | entered-in-error | executable | executed | negotiable | offered | policy | rejected | renewed | revoked | resolved | terminated.", 0, 1, this.publicationStatus));
            children.add(new Property("copyright", "markdown", "A copyright statement relating to Contract precursor content. Copyright statements are generally legal restrictions on the use and publishing of the Contract precursor content.", 0, 1, this.copyright));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Precusory content structure and use, i.e., a boilerplate, template, application for a contract such as an insurance policy or benefits under a program, e.g., workers compensation.", 0, 1, this.type);
                }
                case -1868521062: {
                    return new Property("subType", "CodeableConcept", "Detailed Precusory content type.", 0, 1, this.subType);
                }
                case 1447404028: {
                    return new Property("publisher", "Reference(Practitioner|PractitionerRole|Organization)", "The  individual or organization that published the Contract precursor content.", 0, 1, this.publisher);
                }
                case 1470566394: {
                    return new Property("publicationDate", "dateTime", "The date (and optionally time) when the contract was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the contract changes.", 0, 1, this.publicationDate);
                }
                case 616500542: {
                    return new Property("publicationStatus", "code", "amended | appended | cancelled | disputed | entered-in-error | executable | executed | negotiable | offered | policy | rejected | renewed | revoked | resolved | terminated.", 0, 1, this.publicationStatus);
                }
                case 1522889671: {
                    return new Property("copyright", "markdown", "A copyright statement relating to Contract precursor content. Copyright statements are generally legal restrictions on the use and publishing of the Contract precursor content.", 0, 1, this.copyright);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1868521062: {
                    Base[] baseArray;
                    if (this.subType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.subType;
                    }
                    return baseArray;
                }
                case 1447404028: {
                    Base[] baseArray;
                    if (this.publisher == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.publisher;
                    }
                    return baseArray;
                }
                case 1470566394: {
                    Base[] baseArray;
                    if (this.publicationDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.publicationDate;
                    }
                    return baseArray;
                }
                case 616500542: {
                    Base[] baseArray;
                    if (this.publicationStatus == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.publicationStatus;
                    }
                    return baseArray;
                }
                case 1522889671: {
                    Base[] baseArray;
                    if (this.copyright == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.copyright;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1868521062: {
                    this.subType = this.castToCodeableConcept(value);
                    return value;
                }
                case 1447404028: {
                    this.publisher = this.castToReference(value);
                    return value;
                }
                case 1470566394: {
                    this.publicationDate = this.castToDateTime(value);
                    return value;
                }
                case 616500542: {
                    value = new ContractPublicationStatusEnumFactory().fromType(this.castToCode(value));
                    this.publicationStatus = value;
                    return value;
                }
                case 1522889671: {
                    this.copyright = this.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("subType")) {
                this.subType = this.castToCodeableConcept(value);
            } else if (name.equals("publisher")) {
                this.publisher = this.castToReference(value);
            } else if (name.equals("publicationDate")) {
                this.publicationDate = this.castToDateTime(value);
            } else if (name.equals("publicationStatus")) {
                value = new ContractPublicationStatusEnumFactory().fromType(this.castToCode(value));
                this.publicationStatus = value;
            } else if (name.equals("copyright")) {
                this.copyright = this.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1868521062: {
                    return this.getSubType();
                }
                case 1447404028: {
                    return this.getPublisher();
                }
                case 1470566394: {
                    return this.getPublicationDateElement();
                }
                case 616500542: {
                    return this.getPublicationStatusElement();
                }
                case 1522889671: {
                    return this.getCopyrightElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1868521062: {
                    return new String[]{"CodeableConcept"};
                }
                case 1447404028: {
                    return new String[]{"Reference"};
                }
                case 1470566394: {
                    return new String[]{"dateTime"};
                }
                case 616500542: {
                    return new String[]{"code"};
                }
                case 1522889671: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("subType")) {
                this.subType = new CodeableConcept();
                return this.subType;
            }
            if (name.equals("publisher")) {
                this.publisher = new Reference();
                return this.publisher;
            }
            if (name.equals("publicationDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.publicationDate");
            }
            if (name.equals("publicationStatus")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.publicationStatus");
            }
            if (name.equals("copyright")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.copyright");
            }
            return super.addChild(name);
        }

        @Override
        public ContentDefinitionComponent copy() {
            ContentDefinitionComponent dst = new ContentDefinitionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ContentDefinitionComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.subType = this.subType == null ? null : this.subType.copy();
            dst.publisher = this.publisher == null ? null : this.publisher.copy();
            dst.publicationDate = this.publicationDate == null ? null : this.publicationDate.copy();
            dst.publicationStatus = this.publicationStatus == null ? null : this.publicationStatus.copy();
            dst.copyright = this.copyright == null ? null : this.copyright.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ContentDefinitionComponent)) {
                return false;
            }
            ContentDefinitionComponent o = (ContentDefinitionComponent)other_;
            return ContentDefinitionComponent.compareDeep(this.type, o.type, true) && ContentDefinitionComponent.compareDeep(this.subType, o.subType, true) && ContentDefinitionComponent.compareDeep(this.publisher, o.publisher, true) && ContentDefinitionComponent.compareDeep(this.publicationDate, o.publicationDate, true) && ContentDefinitionComponent.compareDeep(this.publicationStatus, o.publicationStatus, true) && ContentDefinitionComponent.compareDeep(this.copyright, o.copyright, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ContentDefinitionComponent)) {
                return false;
            }
            ContentDefinitionComponent o = (ContentDefinitionComponent)other_;
            return ContentDefinitionComponent.compareValues(this.publicationDate, o.publicationDate, true) && ContentDefinitionComponent.compareValues(this.publicationStatus, o.publicationStatus, true) && ContentDefinitionComponent.compareValues(this.copyright, o.copyright, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.subType, this.publisher, this.publicationDate, this.publicationStatus, this.copyright);
        }

        @Override
        public String fhirType() {
            return "Contract.contentDefinition";
        }
    }

    public static class ContractPublicationStatusEnumFactory
    implements EnumFactory<ContractPublicationStatus> {
        @Override
        public ContractPublicationStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("amended".equals(codeString)) {
                return ContractPublicationStatus.AMENDED;
            }
            if ("appended".equals(codeString)) {
                return ContractPublicationStatus.APPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return ContractPublicationStatus.CANCELLED;
            }
            if ("disputed".equals(codeString)) {
                return ContractPublicationStatus.DISPUTED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ContractPublicationStatus.ENTEREDINERROR;
            }
            if ("executable".equals(codeString)) {
                return ContractPublicationStatus.EXECUTABLE;
            }
            if ("executed".equals(codeString)) {
                return ContractPublicationStatus.EXECUTED;
            }
            if ("negotiable".equals(codeString)) {
                return ContractPublicationStatus.NEGOTIABLE;
            }
            if ("offered".equals(codeString)) {
                return ContractPublicationStatus.OFFERED;
            }
            if ("policy".equals(codeString)) {
                return ContractPublicationStatus.POLICY;
            }
            if ("rejected".equals(codeString)) {
                return ContractPublicationStatus.REJECTED;
            }
            if ("renewed".equals(codeString)) {
                return ContractPublicationStatus.RENEWED;
            }
            if ("revoked".equals(codeString)) {
                return ContractPublicationStatus.REVOKED;
            }
            if ("resolved".equals(codeString)) {
                return ContractPublicationStatus.RESOLVED;
            }
            if ("terminated".equals(codeString)) {
                return ContractPublicationStatus.TERMINATED;
            }
            throw new IllegalArgumentException("Unknown ContractPublicationStatus code '" + codeString + "'");
        }

        public Enumeration<ContractPublicationStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ContractPublicationStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("amended".equals(codeString)) {
                return new Enumeration<ContractPublicationStatus>(this, ContractPublicationStatus.AMENDED);
            }
            if ("appended".equals(codeString)) {
                return new Enumeration<ContractPublicationStatus>(this, ContractPublicationStatus.APPENDED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<ContractPublicationStatus>(this, ContractPublicationStatus.CANCELLED);
            }
            if ("disputed".equals(codeString)) {
                return new Enumeration<ContractPublicationStatus>(this, ContractPublicationStatus.DISPUTED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ContractPublicationStatus>(this, ContractPublicationStatus.ENTEREDINERROR);
            }
            if ("executable".equals(codeString)) {
                return new Enumeration<ContractPublicationStatus>(this, ContractPublicationStatus.EXECUTABLE);
            }
            if ("executed".equals(codeString)) {
                return new Enumeration<ContractPublicationStatus>(this, ContractPublicationStatus.EXECUTED);
            }
            if ("negotiable".equals(codeString)) {
                return new Enumeration<ContractPublicationStatus>(this, ContractPublicationStatus.NEGOTIABLE);
            }
            if ("offered".equals(codeString)) {
                return new Enumeration<ContractPublicationStatus>(this, ContractPublicationStatus.OFFERED);
            }
            if ("policy".equals(codeString)) {
                return new Enumeration<ContractPublicationStatus>(this, ContractPublicationStatus.POLICY);
            }
            if ("rejected".equals(codeString)) {
                return new Enumeration<ContractPublicationStatus>(this, ContractPublicationStatus.REJECTED);
            }
            if ("renewed".equals(codeString)) {
                return new Enumeration<ContractPublicationStatus>(this, ContractPublicationStatus.RENEWED);
            }
            if ("revoked".equals(codeString)) {
                return new Enumeration<ContractPublicationStatus>(this, ContractPublicationStatus.REVOKED);
            }
            if ("resolved".equals(codeString)) {
                return new Enumeration<ContractPublicationStatus>(this, ContractPublicationStatus.RESOLVED);
            }
            if ("terminated".equals(codeString)) {
                return new Enumeration<ContractPublicationStatus>(this, ContractPublicationStatus.TERMINATED);
            }
            throw new FHIRException("Unknown ContractPublicationStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ContractPublicationStatus code) {
            if (code == ContractPublicationStatus.AMENDED) {
                return "amended";
            }
            if (code == ContractPublicationStatus.APPENDED) {
                return "appended";
            }
            if (code == ContractPublicationStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == ContractPublicationStatus.DISPUTED) {
                return "disputed";
            }
            if (code == ContractPublicationStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == ContractPublicationStatus.EXECUTABLE) {
                return "executable";
            }
            if (code == ContractPublicationStatus.EXECUTED) {
                return "executed";
            }
            if (code == ContractPublicationStatus.NEGOTIABLE) {
                return "negotiable";
            }
            if (code == ContractPublicationStatus.OFFERED) {
                return "offered";
            }
            if (code == ContractPublicationStatus.POLICY) {
                return "policy";
            }
            if (code == ContractPublicationStatus.REJECTED) {
                return "rejected";
            }
            if (code == ContractPublicationStatus.RENEWED) {
                return "renewed";
            }
            if (code == ContractPublicationStatus.REVOKED) {
                return "revoked";
            }
            if (code == ContractPublicationStatus.RESOLVED) {
                return "resolved";
            }
            if (code == ContractPublicationStatus.TERMINATED) {
                return "terminated";
            }
            return "?";
        }

        @Override
        public String toSystem(ContractPublicationStatus code) {
            return code.getSystem();
        }
    }

    public static enum ContractPublicationStatus {
        AMENDED,
        APPENDED,
        CANCELLED,
        DISPUTED,
        ENTEREDINERROR,
        EXECUTABLE,
        EXECUTED,
        NEGOTIABLE,
        OFFERED,
        POLICY,
        REJECTED,
        RENEWED,
        REVOKED,
        RESOLVED,
        TERMINATED,
        NULL;


        public static ContractPublicationStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("amended".equals(codeString)) {
                return AMENDED;
            }
            if ("appended".equals(codeString)) {
                return APPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("disputed".equals(codeString)) {
                return DISPUTED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("executable".equals(codeString)) {
                return EXECUTABLE;
            }
            if ("executed".equals(codeString)) {
                return EXECUTED;
            }
            if ("negotiable".equals(codeString)) {
                return NEGOTIABLE;
            }
            if ("offered".equals(codeString)) {
                return OFFERED;
            }
            if ("policy".equals(codeString)) {
                return POLICY;
            }
            if ("rejected".equals(codeString)) {
                return REJECTED;
            }
            if ("renewed".equals(codeString)) {
                return RENEWED;
            }
            if ("revoked".equals(codeString)) {
                return REVOKED;
            }
            if ("resolved".equals(codeString)) {
                return RESOLVED;
            }
            if ("terminated".equals(codeString)) {
                return TERMINATED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ContractPublicationStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case AMENDED: {
                    return "amended";
                }
                case APPENDED: {
                    return "appended";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case DISPUTED: {
                    return "disputed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case EXECUTABLE: {
                    return "executable";
                }
                case EXECUTED: {
                    return "executed";
                }
                case NEGOTIABLE: {
                    return "negotiable";
                }
                case OFFERED: {
                    return "offered";
                }
                case POLICY: {
                    return "policy";
                }
                case REJECTED: {
                    return "rejected";
                }
                case RENEWED: {
                    return "renewed";
                }
                case REVOKED: {
                    return "revoked";
                }
                case RESOLVED: {
                    return "resolved";
                }
                case TERMINATED: {
                    return "terminated";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case AMENDED: {
                    return "http://hl7.org/fhir/contract-publicationstatus";
                }
                case APPENDED: {
                    return "http://hl7.org/fhir/contract-publicationstatus";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/contract-publicationstatus";
                }
                case DISPUTED: {
                    return "http://hl7.org/fhir/contract-publicationstatus";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/contract-publicationstatus";
                }
                case EXECUTABLE: {
                    return "http://hl7.org/fhir/contract-publicationstatus";
                }
                case EXECUTED: {
                    return "http://hl7.org/fhir/contract-publicationstatus";
                }
                case NEGOTIABLE: {
                    return "http://hl7.org/fhir/contract-publicationstatus";
                }
                case OFFERED: {
                    return "http://hl7.org/fhir/contract-publicationstatus";
                }
                case POLICY: {
                    return "http://hl7.org/fhir/contract-publicationstatus";
                }
                case REJECTED: {
                    return "http://hl7.org/fhir/contract-publicationstatus";
                }
                case RENEWED: {
                    return "http://hl7.org/fhir/contract-publicationstatus";
                }
                case REVOKED: {
                    return "http://hl7.org/fhir/contract-publicationstatus";
                }
                case RESOLVED: {
                    return "http://hl7.org/fhir/contract-publicationstatus";
                }
                case TERMINATED: {
                    return "http://hl7.org/fhir/contract-publicationstatus";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case AMENDED: {
                    return "Contract is augmented with additional information to correct errors in a predecessor or to updated values in a predecessor. Usage: Contract altered within effective time. Precedence Order = 9. Comparable FHIR and v.3 status codes: revised; replaced.";
                }
                case APPENDED: {
                    return "Contract is augmented with additional information that was missing from a predecessor Contract. Usage: Contract altered within effective time. Precedence Order = 9. Comparable FHIR and v.3 status codes: updated, replaced.";
                }
                case CANCELLED: {
                    return "Contract is terminated due to failure of the Grantor and/or the Grantee to fulfil one or more contract provisions. Usage: Abnormal contract termination. Precedence Order = 10. Comparable FHIR and v.3 status codes: stopped; failed; aborted.";
                }
                case DISPUTED: {
                    return "Contract is pended to rectify failure of the Grantor or the Grantee to fulfil contract provision(s). E.g., Grantee complaint about Grantor's failure to comply with contract provisions. Usage: Contract pended. Precedence Order = 7. Comparable FHIR and v.3 status codes: on hold; pended; suspended.";
                }
                case ENTEREDINERROR: {
                    return "Contract was created in error. No Precedence Order.  Status may be applied to a Contract with any status.";
                }
                case EXECUTABLE: {
                    return "Contract execution pending; may be executed when either the Grantor or the Grantee accepts the contract provisions by signing. I.e., where either the Grantor or the Grantee has signed, but not both. E.g., when an insurance applicant signs the insurers application, which references the policy.\u00a0Usage: Optional first step of contract execution activity.  May be skipped and contracting activity moves directly to executed state. Precedence Order = 3. Comparable FHIR and v.3 status codes: draft; preliminary; planned; intended; active.";
                }
                case EXECUTED: {
                    return "Contract is activated for period stipulated when both the Grantor and Grantee have signed it. Usage: Required state for normal completion of contracting activity.  Precedence Order = 6. Comparable FHIR and v.3 status codes: accepted; completed.";
                }
                case NEGOTIABLE: {
                    return "Contract execution is suspended while either or both the Grantor and Grantee propose and consider new or revised contract provisions. I.e., where the party which has not signed proposes changes to the terms.  E .g., a life insurer declines to agree to the signed application because the life insurer has evidence that the applicant, who asserted to being younger or a non-smoker to get a lower premium rate - but offers instead to agree to a higher premium based on the applicants actual age or smoking status. Usage: Optional contract activity between executable and executed state. Precedence Order = 4. Comparable FHIR and v.3 status codes: in progress; review; held.";
                }
                case OFFERED: {
                    return "Contract is a proposal by either the Grantor or the Grantee. Aka - A Contract hard copy or electronic 'template', 'form' or 'application'. E.g., health insurance application; consent directive form. Usage: Beginning of contract negotiation, which may have been completed as a precondition because used for 0..* contracts. Precedence Order = 2. Comparable FHIR and v.3 status codes: requested; new.";
                }
                case POLICY: {
                    return "Contract template is available as the basis for an application or offer by the Grantor or Grantee. E.g., health insurance policy; consent directive policy.  Usage: Required initial contract activity, which may have been completed as a precondition because used for 0..* contracts. Precedence Order = 1. Comparable FHIR and v.3 status codes: proposed; intended.";
                }
                case REJECTED: {
                    return " Execution of the Contract is not completed because either or both the Grantor and Grantee decline to accept some or all of the contract provisions. Usage: Optional contract activity between executable and abnormal termination. Precedence Order = 5. Comparable FHIR and v.3 status codes:  stopped; cancelled.";
                }
                case RENEWED: {
                    return "Beginning of a successor Contract at the termination of predecessor Contract lifecycle. Usage: Follows termination of a preceding Contract that has reached its expiry date. Precedence Order = 13. Comparable FHIR and v.3 status codes: superseded.";
                }
                case REVOKED: {
                    return "A Contract that is rescinded.  May be required prior to replacing with an updated Contract. Comparable FHIR and v.3 status codes: nullified.";
                }
                case RESOLVED: {
                    return "Contract is reactivated after being pended because of faulty execution. *E.g., competency of the signer(s), or where the policy is substantially different from and did not accompany the application/form so that the applicant could not compare them. Aka - ''reactivated''. Usage: Optional stage where a pended contract is reactivated. Precedence Order = 8. Comparable FHIR and v.3 status codes: reactivated.";
                }
                case TERMINATED: {
                    return "Contract reaches its expiry date.\u00a0It might or might not be renewed or renegotiated. Usage: Normal end of contract period. Precedence Order = 12. Comparable FHIR and v.3 status codes: Obsoleted.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case AMENDED: {
                    return "Amended";
                }
                case APPENDED: {
                    return "Appended";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case DISPUTED: {
                    return "Disputed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case EXECUTABLE: {
                    return "Executable";
                }
                case EXECUTED: {
                    return "Executed";
                }
                case NEGOTIABLE: {
                    return "Negotiable";
                }
                case OFFERED: {
                    return "Offered";
                }
                case POLICY: {
                    return "Policy";
                }
                case REJECTED: {
                    return "Rejected";
                }
                case RENEWED: {
                    return "Renewed";
                }
                case REVOKED: {
                    return "Revoked";
                }
                case RESOLVED: {
                    return "Resolved";
                }
                case TERMINATED: {
                    return "Terminated";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ContractStatusEnumFactory
    implements EnumFactory<ContractStatus> {
        @Override
        public ContractStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("amended".equals(codeString)) {
                return ContractStatus.AMENDED;
            }
            if ("appended".equals(codeString)) {
                return ContractStatus.APPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return ContractStatus.CANCELLED;
            }
            if ("disputed".equals(codeString)) {
                return ContractStatus.DISPUTED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ContractStatus.ENTEREDINERROR;
            }
            if ("executable".equals(codeString)) {
                return ContractStatus.EXECUTABLE;
            }
            if ("executed".equals(codeString)) {
                return ContractStatus.EXECUTED;
            }
            if ("negotiable".equals(codeString)) {
                return ContractStatus.NEGOTIABLE;
            }
            if ("offered".equals(codeString)) {
                return ContractStatus.OFFERED;
            }
            if ("policy".equals(codeString)) {
                return ContractStatus.POLICY;
            }
            if ("rejected".equals(codeString)) {
                return ContractStatus.REJECTED;
            }
            if ("renewed".equals(codeString)) {
                return ContractStatus.RENEWED;
            }
            if ("revoked".equals(codeString)) {
                return ContractStatus.REVOKED;
            }
            if ("resolved".equals(codeString)) {
                return ContractStatus.RESOLVED;
            }
            if ("terminated".equals(codeString)) {
                return ContractStatus.TERMINATED;
            }
            throw new IllegalArgumentException("Unknown ContractStatus code '" + codeString + "'");
        }

        public Enumeration<ContractStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ContractStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("amended".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.AMENDED);
            }
            if ("appended".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.APPENDED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.CANCELLED);
            }
            if ("disputed".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.DISPUTED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.ENTEREDINERROR);
            }
            if ("executable".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.EXECUTABLE);
            }
            if ("executed".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.EXECUTED);
            }
            if ("negotiable".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.NEGOTIABLE);
            }
            if ("offered".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.OFFERED);
            }
            if ("policy".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.POLICY);
            }
            if ("rejected".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.REJECTED);
            }
            if ("renewed".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.RENEWED);
            }
            if ("revoked".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.REVOKED);
            }
            if ("resolved".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.RESOLVED);
            }
            if ("terminated".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.TERMINATED);
            }
            throw new FHIRException("Unknown ContractStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ContractStatus code) {
            if (code == ContractStatus.AMENDED) {
                return "amended";
            }
            if (code == ContractStatus.APPENDED) {
                return "appended";
            }
            if (code == ContractStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == ContractStatus.DISPUTED) {
                return "disputed";
            }
            if (code == ContractStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == ContractStatus.EXECUTABLE) {
                return "executable";
            }
            if (code == ContractStatus.EXECUTED) {
                return "executed";
            }
            if (code == ContractStatus.NEGOTIABLE) {
                return "negotiable";
            }
            if (code == ContractStatus.OFFERED) {
                return "offered";
            }
            if (code == ContractStatus.POLICY) {
                return "policy";
            }
            if (code == ContractStatus.REJECTED) {
                return "rejected";
            }
            if (code == ContractStatus.RENEWED) {
                return "renewed";
            }
            if (code == ContractStatus.REVOKED) {
                return "revoked";
            }
            if (code == ContractStatus.RESOLVED) {
                return "resolved";
            }
            if (code == ContractStatus.TERMINATED) {
                return "terminated";
            }
            return "?";
        }

        @Override
        public String toSystem(ContractStatus code) {
            return code.getSystem();
        }
    }

    public static enum ContractStatus {
        AMENDED,
        APPENDED,
        CANCELLED,
        DISPUTED,
        ENTEREDINERROR,
        EXECUTABLE,
        EXECUTED,
        NEGOTIABLE,
        OFFERED,
        POLICY,
        REJECTED,
        RENEWED,
        REVOKED,
        RESOLVED,
        TERMINATED,
        NULL;


        public static ContractStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("amended".equals(codeString)) {
                return AMENDED;
            }
            if ("appended".equals(codeString)) {
                return APPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("disputed".equals(codeString)) {
                return DISPUTED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("executable".equals(codeString)) {
                return EXECUTABLE;
            }
            if ("executed".equals(codeString)) {
                return EXECUTED;
            }
            if ("negotiable".equals(codeString)) {
                return NEGOTIABLE;
            }
            if ("offered".equals(codeString)) {
                return OFFERED;
            }
            if ("policy".equals(codeString)) {
                return POLICY;
            }
            if ("rejected".equals(codeString)) {
                return REJECTED;
            }
            if ("renewed".equals(codeString)) {
                return RENEWED;
            }
            if ("revoked".equals(codeString)) {
                return REVOKED;
            }
            if ("resolved".equals(codeString)) {
                return RESOLVED;
            }
            if ("terminated".equals(codeString)) {
                return TERMINATED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ContractStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case AMENDED: {
                    return "amended";
                }
                case APPENDED: {
                    return "appended";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case DISPUTED: {
                    return "disputed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case EXECUTABLE: {
                    return "executable";
                }
                case EXECUTED: {
                    return "executed";
                }
                case NEGOTIABLE: {
                    return "negotiable";
                }
                case OFFERED: {
                    return "offered";
                }
                case POLICY: {
                    return "policy";
                }
                case REJECTED: {
                    return "rejected";
                }
                case RENEWED: {
                    return "renewed";
                }
                case REVOKED: {
                    return "revoked";
                }
                case RESOLVED: {
                    return "resolved";
                }
                case TERMINATED: {
                    return "terminated";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case AMENDED: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case APPENDED: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case DISPUTED: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case EXECUTABLE: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case EXECUTED: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case NEGOTIABLE: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case OFFERED: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case POLICY: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case REJECTED: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case RENEWED: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case REVOKED: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case RESOLVED: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case TERMINATED: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case AMENDED: {
                    return "Contract is augmented with additional information to correct errors in a predecessor or to updated values in a predecessor. Usage: Contract altered within effective time. Precedence Order = 9. Comparable FHIR and v.3 status codes: revised; replaced.";
                }
                case APPENDED: {
                    return "Contract is augmented with additional information that was missing from a predecessor Contract. Usage: Contract altered within effective time. Precedence Order = 9. Comparable FHIR and v.3 status codes: updated, replaced.";
                }
                case CANCELLED: {
                    return "Contract is terminated due to failure of the Grantor and/or the Grantee to fulfil one or more contract provisions. Usage: Abnormal contract termination. Precedence Order = 10. Comparable FHIR and v.3 status codes: stopped; failed; aborted.";
                }
                case DISPUTED: {
                    return "Contract is pended to rectify failure of the Grantor or the Grantee to fulfil contract provision(s). E.g., Grantee complaint about Grantor's failure to comply with contract provisions. Usage: Contract pended. Precedence Order = 7. Comparable FHIR and v.3 status codes: on hold; pended; suspended.";
                }
                case ENTEREDINERROR: {
                    return "Contract was created in error. No Precedence Order.  Status may be applied to a Contract with any status.";
                }
                case EXECUTABLE: {
                    return "Contract execution pending; may be executed when either the Grantor or the Grantee accepts the contract provisions by signing. I.e., where either the Grantor or the Grantee has signed, but not both. E.g., when an insurance applicant signs the insurers application, which references the policy.\u00a0Usage: Optional first step of contract execution activity.  May be skipped and contracting activity moves directly to executed state. Precedence Order = 3. Comparable FHIR and v.3 status codes: draft; preliminary; planned; intended; active.";
                }
                case EXECUTED: {
                    return "Contract is activated for period stipulated when both the Grantor and Grantee have signed it. Usage: Required state for normal completion of contracting activity.  Precedence Order = 6. Comparable FHIR and v.3 status codes: accepted; completed.";
                }
                case NEGOTIABLE: {
                    return "Contract execution is suspended while either or both the Grantor and Grantee propose and consider new or revised contract provisions. I.e., where the party which has not signed proposes changes to the terms.  E .g., a life insurer declines to agree to the signed application because the life insurer has evidence that the applicant, who asserted to being younger or a non-smoker to get a lower premium rate - but offers instead to agree to a higher premium based on the applicants actual age or smoking status. Usage: Optional contract activity between executable and executed state. Precedence Order = 4. Comparable FHIR and v.3 status codes: in progress; review; held.";
                }
                case OFFERED: {
                    return "Contract is a proposal by either the Grantor or the Grantee. Aka - A Contract hard copy or electronic 'template', 'form' or 'application'. E.g., health insurance application; consent directive form. Usage: Beginning of contract negotiation, which may have been completed as a precondition because used for 0..* contracts. Precedence Order = 2. Comparable FHIR and v.3 status codes: requested; new.";
                }
                case POLICY: {
                    return "Contract template is available as the basis for an application or offer by the Grantor or Grantee. E.g., health insurance policy; consent directive policy.  Usage: Required initial contract activity, which may have been completed as a precondition because used for 0..* contracts. Precedence Order = 1. Comparable FHIR and v.3 status codes: proposed; intended.";
                }
                case REJECTED: {
                    return " Execution of the Contract is not completed because either or both the Grantor and Grantee decline to accept some or all of the contract provisions. Usage: Optional contract activity between executable and abnormal termination. Precedence Order = 5. Comparable FHIR and v.3 status codes:  stopped; cancelled.";
                }
                case RENEWED: {
                    return "Beginning of a successor Contract at the termination of predecessor Contract lifecycle. Usage: Follows termination of a preceding Contract that has reached its expiry date. Precedence Order = 13. Comparable FHIR and v.3 status codes: superseded.";
                }
                case REVOKED: {
                    return "A Contract that is rescinded.  May be required prior to replacing with an updated Contract. Comparable FHIR and v.3 status codes: nullified.";
                }
                case RESOLVED: {
                    return "Contract is reactivated after being pended because of faulty execution. *E.g., competency of the signer(s), or where the policy is substantially different from and did not accompany the application/form so that the applicant could not compare them. Aka - ''reactivated''. Usage: Optional stage where a pended contract is reactivated. Precedence Order = 8. Comparable FHIR and v.3 status codes: reactivated.";
                }
                case TERMINATED: {
                    return "Contract reaches its expiry date.\u00a0It might or might not be renewed or renegotiated. Usage: Normal end of contract period. Precedence Order = 12. Comparable FHIR and v.3 status codes: Obsoleted.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case AMENDED: {
                    return "Amended";
                }
                case APPENDED: {
                    return "Appended";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case DISPUTED: {
                    return "Disputed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case EXECUTABLE: {
                    return "Executable";
                }
                case EXECUTED: {
                    return "Executed";
                }
                case NEGOTIABLE: {
                    return "Negotiable";
                }
                case OFFERED: {
                    return "Offered";
                }
                case POLICY: {
                    return "Policy";
                }
                case REJECTED: {
                    return "Rejected";
                }
                case RENEWED: {
                    return "Renewed";
                }
                case REVOKED: {
                    return "Revoked";
                }
                case RESOLVED: {
                    return "Resolved";
                }
                case TERMINATED: {
                    return "Terminated";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

