/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.TerserUtil;
import ca.uhn.fhir.validation.IValidationContext;
import ca.uhn.fhir.validation.IValidatorModule;
import ca.uhn.fhir.validation.SchemaBaseValidator;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationContext;
import ca.uhn.fhir.validation.ValidationOptions;
import ca.uhn.fhir.validation.ValidationResult;
import ca.uhn.fhir.validation.schematron.SchematronProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FhirValidator {
    private static final Logger ourLog = LoggerFactory.getLogger(FhirValidator.class);
    private static final String I18N_KEY_NO_PH_ERROR = FhirValidator.class.getName() + ".noPhError";
    private static volatile Boolean ourPhPresentOnClasspath;
    private final FhirContext myContext;
    private List<IValidatorModule> myValidators = new ArrayList<IValidatorModule>();
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    private boolean myConcurrentBundleValidation;
    private boolean mySkipContainedReferenceValidation;
    private ExecutorService myExecutorService;

    public FhirValidator(FhirContext theFhirContext) {
        this.myContext = theFhirContext;
        if (ourPhPresentOnClasspath == null) {
            ourPhPresentOnClasspath = SchematronProvider.isSchematronAvailable(theFhirContext);
        }
    }

    private void addOrRemoveValidator(boolean theValidateAgainstStandardSchema, Class<? extends IValidatorModule> type, IValidatorModule theInstance) {
        if (theValidateAgainstStandardSchema) {
            boolean found = this.haveValidatorOfType(type);
            if (!found) {
                this.registerValidatorModule(theInstance);
            }
        } else {
            for (IValidatorModule next : this.myValidators) {
                if (!next.getClass().equals(type)) continue;
                this.unregisterValidatorModule(next);
            }
        }
    }

    private boolean haveValidatorOfType(Class<? extends IValidatorModule> type) {
        boolean found = false;
        for (IValidatorModule next : this.myValidators) {
            if (!next.getClass().equals(type)) continue;
            found = true;
            break;
        }
        return found;
    }

    public synchronized boolean isValidateAgainstStandardSchema() {
        return this.haveValidatorOfType(SchemaBaseValidator.class);
    }

    public synchronized FhirValidator setValidateAgainstStandardSchema(boolean theValidateAgainstStandardSchema) {
        this.addOrRemoveValidator(theValidateAgainstStandardSchema, SchemaBaseValidator.class, new SchemaBaseValidator(this.myContext));
        return this;
    }

    public synchronized boolean isValidateAgainstStandardSchematron() {
        if (!ourPhPresentOnClasspath.booleanValue()) {
            return false;
        }
        Class<? extends IValidatorModule> cls = SchematronProvider.getSchematronValidatorClass();
        return this.haveValidatorOfType(cls);
    }

    public synchronized FhirValidator setValidateAgainstStandardSchematron(boolean theValidateAgainstStandardSchematron) {
        if (theValidateAgainstStandardSchematron && !ourPhPresentOnClasspath.booleanValue()) {
            throw new IllegalArgumentException(Msg.code(1970) + this.myContext.getLocalizer().getMessage(I18N_KEY_NO_PH_ERROR, new Object[0]));
        }
        if (!theValidateAgainstStandardSchematron && !ourPhPresentOnClasspath.booleanValue()) {
            return this;
        }
        Class<? extends IValidatorModule> cls = SchematronProvider.getSchematronValidatorClass();
        IValidatorModule instance = SchematronProvider.getSchematronValidatorInstance(this.myContext);
        this.addOrRemoveValidator(theValidateAgainstStandardSchematron, cls, instance);
        return this;
    }

    public synchronized FhirValidator registerValidatorModule(IValidatorModule theValidator) {
        Validate.notNull(theValidator, "theValidator must not be null", new Object[0]);
        ArrayList<IValidatorModule> newValidators = new ArrayList<IValidatorModule>(this.myValidators.size() + 1);
        newValidators.addAll(this.myValidators);
        newValidators.add(theValidator);
        this.myValidators = newValidators;
        return this;
    }

    public synchronized void unregisterValidatorModule(IValidatorModule theValidator) {
        Validate.notNull(theValidator, "theValidator must not be null", new Object[0]);
        ArrayList<IValidatorModule> newValidators = new ArrayList<IValidatorModule>(this.myValidators.size() + 1);
        newValidators.addAll(this.myValidators);
        newValidators.remove(theValidator);
        this.myValidators = newValidators;
    }

    private void applyDefaultValidators() {
        if (this.myValidators.isEmpty()) {
            this.setValidateAgainstStandardSchema(true);
            if (ourPhPresentOnClasspath.booleanValue()) {
                this.setValidateAgainstStandardSchematron(true);
            }
        }
    }

    public ValidationResult validateWithResult(IBaseResource theResource) {
        return this.validateWithResult(theResource, null);
    }

    public ValidationResult validateWithResult(String theResource) {
        return this.validateWithResult(theResource, null);
    }

    public ValidationResult validateWithResult(String theResource, ValidationOptions theOptions) {
        Validate.notNull(theResource, "theResource must not be null", new Object[0]);
        IValidationContext<IBaseResource> validationContext = ValidationContext.forText(this.myContext, theResource, theOptions);
        Function<ValidationResult, ValidationResult> callback = result -> this.invokeValidationCompletedHooks(null, theResource, (ValidationResult)result);
        return this.doValidate(validationContext, theOptions, callback);
    }

    public ValidationResult validateWithResult(IBaseResource theResource, ValidationOptions theOptions) {
        Validate.notNull(theResource, "theResource must not be null", new Object[0]);
        IValidationContext<IBaseResource> validationContext = ValidationContext.forResource(this.myContext, theResource, theOptions);
        Function<ValidationResult, ValidationResult> callback = result -> this.invokeValidationCompletedHooks(theResource, null, (ValidationResult)result);
        return this.doValidate(validationContext, theOptions, callback);
    }

    private ValidationResult doValidate(IValidationContext<IBaseResource> theValidationContext, ValidationOptions theOptions, Function<ValidationResult, ValidationResult> theValidationCompletionCallback) {
        this.applyDefaultValidators();
        ValidationResult result = this.myConcurrentBundleValidation && theValidationContext.getResource() instanceof IBaseBundle && this.myExecutorService != null ? this.validateBundleEntriesConcurrently(theValidationContext, theOptions) : this.validateResource(theValidationContext);
        return theValidationCompletionCallback.apply(result);
    }

    private ValidationResult validateBundleEntriesConcurrently(IValidationContext<IBaseResource> theValidationContext, ValidationOptions theOptions) {
        List<IBaseResource> entries = BundleUtil.toListOfResources(this.myContext, (IBaseBundle)theValidationContext.getResource());
        List<ConcurrentValidationTask> validationTasks = IntStream.range(0, entries.size()).mapToObj(index -> {
            IBaseResource entry = (IBaseResource)entries.get(index);
            IBaseResource resourceToValidate = this.mySkipContainedReferenceValidation ? this.withoutContainedResources(entry) : entry;
            String entryPathPrefix = String.format("Bundle.entry[%d].resource.ofType(%s)", index, resourceToValidate.fhirType());
            Future<ValidationResult> future = this.myExecutorService.submit(() -> {
                IValidationContext<IBaseResource> entryValidationContext = ValidationContext.forResource(theValidationContext.getFhirContext(), resourceToValidate, theOptions);
                return this.validateResource(entryValidationContext);
            });
            return new ConcurrentValidationTask(entryPathPrefix, future);
        }).collect(Collectors.toList());
        List<SingleValidationMessage> validationMessages = FhirValidator.buildValidationMessages(validationTasks);
        return new ValidationResult(this.myContext, validationMessages);
    }

    IBaseResource withoutContainedResources(IBaseResource theEntry) {
        if (TerserUtil.hasValues(this.myContext, theEntry, "contained")) {
            IBaseResource deepCopy = TerserUtil.clone(this.myContext, theEntry);
            TerserUtil.clearField(this.myContext, deepCopy, "contained");
            return deepCopy;
        }
        return theEntry;
    }

    static List<SingleValidationMessage> buildValidationMessages(List<ConcurrentValidationTask> validationTasks) {
        ArrayList<SingleValidationMessage> retval = new ArrayList<SingleValidationMessage>();
        try {
            for (ConcurrentValidationTask validationTask : validationTasks) {
                ValidationResult result = validationTask.getFuture().get();
                String bundleEntryPathPrefix = validationTask.getResourcePathPrefix();
                List messages = result.getMessages().stream().map(message -> {
                    String locationString = StringUtils.defaultIfEmpty(message.getLocationString(), "");
                    int dotIndex = locationString.indexOf(46);
                    String currentPath = dotIndex >= 0 ? locationString.substring(dotIndex) : (StringUtils.isBlank(bundleEntryPathPrefix) || StringUtils.isBlank(locationString) ? locationString : "." + locationString);
                    message.setLocationString(bundleEntryPathPrefix + currentPath);
                    return message;
                }).collect(Collectors.toList());
                retval.addAll(messages);
            }
        }
        catch (InterruptedException | ExecutionException exp) {
            throw new InternalErrorException(Msg.code(1975) + exp);
        }
        return retval;
    }

    private ValidationResult validateResource(IValidationContext<IBaseResource> theValidationContext) {
        for (IValidatorModule next : this.myValidators) {
            next.validateResource(theValidationContext);
        }
        return theValidationContext.toResult();
    }

    private ValidationResult invokeValidationCompletedHooks(IBaseResource theResourceParsed, String theResourceRaw, ValidationResult theValidationResult) {
        HookParams params;
        Object newResult;
        if (this.myInterceptorBroadcaster != null && this.myInterceptorBroadcaster.hasHooks(Pointcut.VALIDATION_COMPLETED) && (newResult = this.myInterceptorBroadcaster.callHooksAndReturnObject(Pointcut.VALIDATION_COMPLETED, params = new HookParams().add(IBaseResource.class, theResourceParsed).add(String.class, theResourceRaw).add(ValidationResult.class, theValidationResult))) != null) {
            theValidationResult = (ValidationResult)newResult;
        }
        return theValidationResult;
    }

    public void setInterceptorBroadcaster(IInterceptorBroadcaster theInterceptorBraodcaster) {
        this.myInterceptorBroadcaster = theInterceptorBraodcaster;
    }

    public FhirValidator setExecutorService(ExecutorService theExecutorService) {
        this.myExecutorService = theExecutorService;
        return this;
    }

    public boolean isConcurrentBundleValidation() {
        return this.myConcurrentBundleValidation;
    }

    public FhirValidator setConcurrentBundleValidation(boolean theConcurrentBundleValidation) {
        this.myConcurrentBundleValidation = theConcurrentBundleValidation;
        return this;
    }

    public boolean isSkipContainedReferenceValidation() {
        return this.mySkipContainedReferenceValidation;
    }

    public FhirValidator setSkipContainedReferenceValidation(boolean theSkipContainedReferenceValidation) {
        this.mySkipContainedReferenceValidation = theSkipContainedReferenceValidation;
        return this;
    }

    static class ConcurrentValidationTask {
        private final String myResourcePathPrefix;
        private final Future<ValidationResult> myFuture;

        ConcurrentValidationTask(String theResourcePathPrefix, Future<ValidationResult> theFuture) {
            this.myResourcePathPrefix = theResourcePathPrefix;
            this.myFuture = theFuture;
        }

        public String getResourcePathPrefix() {
            return this.myResourcePathPrefix;
        }

        public Future<ValidationResult> getFuture() {
            return this.myFuture;
        }
    }
}

