/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.param.BaseParam;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.param.UriParamQualifierEnum;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class UriParam
extends BaseParam
implements IQueryParameterType {
    private UriParamQualifierEnum myQualifier;
    private String myValue;

    public UriParam() {
    }

    public UriParam(String theValue) {
        this.setValue(theValue);
    }

    @Override
    String doGetQueryParameterQualifier() {
        return this.myQualifier != null ? this.myQualifier.getValue() : null;
    }

    @Override
    String doGetValueAsQueryToken(FhirContext theContext) {
        return ParameterUtil.escape(this.myValue);
    }

    @Override
    void doSetValueAsQueryToken(FhirContext theContext, String theParamName, String theQualifier, String theValue) {
        this.myQualifier = UriParamQualifierEnum.forValue(theQualifier);
        this.myValue = ParameterUtil.unescape(theValue);
    }

    public UriParamQualifierEnum getQualifier() {
        return this.myQualifier;
    }

    public String getValue() {
        return this.myValue;
    }

    public StringDt getValueAsStringDt() {
        return new StringDt(this.myValue);
    }

    public UriDt getValueAsUriDt() {
        return new UriDt(this.myValue);
    }

    public String getValueNotNull() {
        return StringUtils.defaultString(this.myValue);
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty(this.myValue);
    }

    public UriParam setQualifier(UriParamQualifierEnum theQualifier) {
        this.myQualifier = theQualifier;
        return this;
    }

    public UriParam setValue(String theValue) {
        this.myValue = theValue;
        return this;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("value", this.getValue());
        return builder.toString();
    }
}

