/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context.phonetic;

import ca.uhn.fhir.context.phonetic.IPhoneticEncoder;
import java.util.StringJoiner;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheEncoder
implements IPhoneticEncoder {
    private static final Logger ourLog = LoggerFactory.getLogger(ApacheEncoder.class);
    private final String myName;
    private final StringEncoder myStringEncoder;

    public ApacheEncoder(String theName, StringEncoder theStringEncoder) {
        this.myName = theName;
        this.myStringEncoder = theStringEncoder;
    }

    @Override
    public String name() {
        return this.myName;
    }

    @Override
    public String encode(String theString) {
        try {
            if (theString.contains(" ")) {
                return this.encodeStringWithSpaces(theString);
            }
            return this.myStringEncoder.encode(theString);
        }
        catch (EncoderException e) {
            ourLog.error("Failed to encode string " + theString, (Throwable)e);
            return theString;
        }
    }

    private String encodeStringWithSpaces(String theString) throws EncoderException {
        StringJoiner joiner = new StringJoiner(" ");
        StringJoiner alphaJoiner = new StringJoiner(" ");
        for (String part : theString.split("[\\s\\W]+")) {
            if (StringUtils.isAlpha(part)) {
                alphaJoiner.add(part);
                continue;
            }
            alphaJoiner = this.encodeAlphaParts(joiner, alphaJoiner);
            joiner.add(part);
        }
        this.encodeAlphaParts(joiner, alphaJoiner);
        return joiner.toString();
    }

    private StringJoiner encodeAlphaParts(StringJoiner theJoiner, StringJoiner theAlphaJoiner) throws EncoderException {
        if (theAlphaJoiner.length() > 0) {
            theJoiner.add(this.myStringEncoder.encode(theAlphaJoiner.toString()));
            theAlphaJoiner = new StringJoiner(" ");
        }
        return theAlphaJoiner;
    }
}

