# -*- coding: utf-8 -*-
# Generated by Django 1.11.1 on 2018-04-10 11:38
from __future__ import unicode_literals

from django.conf import settings
import django.core.files.storage
from django.db import migrations, models
import django.db.models.deletion
import smart_selects.db_fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='ApplicationOption',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=180, unique=True, verbose_name=b'\xe9\x80\x89\xe9\xa1\xb9')),
                ('order_by', models.IntegerField(verbose_name=b'\xe9\xa1\xba\xe5\xba\x8f')),
            ],
            options={
                'ordering': ['order_by'],
                'db_table': 'bee_django_crm_application_options',
            },
        ),
        migrations.CreateModel(
            name='ApplicationQuestion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=180, unique=True, verbose_name=b'\xe9\x97\xae\xe9\xa2\x98')),
                ('order_by', models.IntegerField(verbose_name=b'\xe9\xa1\xba\xe5\xba\x8f')),
                ('input_type', models.IntegerField(choices=[(1, b'\xe8\xbe\x93\xe5\x85\xa5\xe6\xa1\x86'), (2, b'\xe5\x8d\x95\xe9\x80\x89\xef\xbc\x88\xe5\x9c\x86\xe9\x92\xae\xef\xbc\x89'), (3, b'\xe5\x8d\x95\xe9\x80\x89\xef\xbc\x88\xe4\xb8\x8b\xe6\x8b\x89\xef\xbc\x89'), (4, b'\xe5\xa4\x9a\xe9\x80\x89\xef\xbc\x88\xe6\x96\xb9\xe9\x92\xae\xef\xbc\x89')], verbose_name=b'\xe7\xb1\xbb\xe5\x9e\x8b')),
            ],
            options={
                'ordering': ['order_by'],
                'db_table': 'bee_django_crm_application_question',
            },
        ),
        migrations.CreateModel(
            name='City',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=180, null=True)),
            ],
            options={
                'db_table': 'bee_django_crm_city',
            },
        ),
        migrations.CreateModel(
            name='Contract',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=180, unique=True, verbose_name=b'\xe5\x90\x88\xe5\x90\x8c\xe5\x90\x8d\xe7\xa7\xb0')),
                ('period', models.IntegerField(verbose_name=b'\xe5\x91\xa8\xe6\x9c\x9f')),
                ('duration', models.IntegerField(verbose_name=b'\xe6\x97\xb6\xe9\x95\xbf')),
                ('price', models.FloatField(verbose_name=b'\xe9\x87\x91\xe9\xa2\x9d')),
            ],
            options={
                'ordering': ['-id'],
                'db_table': 'bee_django_crm_contract',
            },
        ),
        migrations.CreateModel(
            name='District',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=180, null=True)),
                ('city', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bee_django_crm.City')),
            ],
            options={
                'db_table': 'bee_django_crm_district',
            },
        ),
        migrations.CreateModel(
            name='Poster',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_show', models.BooleanField(default=False, verbose_name=b'\xe6\x98\xaf\xe5\x90\xa6\xe6\x98\xbe\xe7\xa4\xba')),
                ('qrcode_width', models.IntegerField(default=0, null=True, verbose_name=b'\xe4\xba\x8c\xe7\xbb\xb4\xe7\xa0\x81\xe5\xae\xbd\xe5\xba\xa6')),
                ('qrcode_height', models.IntegerField(default=0, null=True, verbose_name=b'\xe4\xba\x8c\xe7\xbb\xb4\xe7\xa0\x81\xe9\xab\x98\xe5\xba\xa6')),
                ('qrcode_pos_x', models.IntegerField(default=0, null=True, verbose_name=b'\xe4\xba\x8c\xe7\xbb\xb4\xe7\xa0\x81x\xe8\xbd\xb4\xe5\x9d\x90\xe6\xa0\x87')),
                ('qrcode_pos_y', models.IntegerField(default=0, null=True, verbose_name=b'\xe4\xba\x8c\xe7\xbb\xb4\xe7\xa0\x81y\xe8\xbd\xb4\xe5\x9d\x90\xe6\xa0\x87')),
                ('qrcode_color', models.CharField(default=b'#000000', max_length=8, null=True, verbose_name=b'\xe4\xba\x8c\xe7\xbb\xb4\xe7\xa0\x81\xe9\xa2\x9c\xe8\x89\xb2')),
                ('photo', models.ImageField(null=True, storage=django.core.files.storage.FileSystemStorage(b'media/crm/poster_photo'), upload_to=b'')),
            ],
            options={
                'db_table': 'bee_django_crm_poster',
            },
        ),
        migrations.CreateModel(
            name='PreUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('nickname', models.CharField(blank=True, max_length=180, null=True, verbose_name=b'\xe6\x98\xb5\xe7\xa7\xb0')),
                ('name', models.CharField(max_length=20, verbose_name=b'\xe5\xa7\x93\xe5\x90\x8d')),
                ('mobile', models.CharField(max_length=15, unique=True, verbose_name=b'\xe7\x94\xb5\xe8\xaf\x9d')),
                ('gender', models.IntegerField(blank=True, default=0, null=True, verbose_name=b'\xe6\x80\xa7\xe5\x88\xab')),
                ('wx', models.CharField(blank=True, max_length=180, null=True, verbose_name=b'\xe5\xbe\xae\xe4\xbf\xa1')),
                ('birthday', models.DateField(blank=True, null=True, verbose_name=b'\xe5\x87\xba\xe7\x94\x9f\xe6\x97\xa5\xe6\x9c\x9f')),
                ('level', models.IntegerField(default=1, verbose_name=b'\xe7\xba\xa7\xe5\x88\xab')),
                ('grade', models.IntegerField(blank=True, null=True, verbose_name=b'\xe6\x84\x8f\xe5\x90\x91')),
                ('address', models.TextField(blank=True, null=True, verbose_name=b'\xe5\x9c\xb0\xe5\x9d\x80')),
                ('job', models.CharField(blank=True, max_length=180, null=True, verbose_name=b'\xe5\xb7\xa5\xe4\xbd\x9c')),
                ('email', models.CharField(blank=True, max_length=180, null=True, verbose_name=b'\xe9\x82\xae\xe7\xae\xb1')),
                ('hobby', models.TextField(blank=True, null=True, verbose_name=b'\xe7\x88\xb1\xe5\xa5\xbd')),
                ('married', models.CharField(blank=True, max_length=180, null=True, verbose_name=b'\xe5\xa9\x9a\xe5\xa7\xbb\xe7\x8a\xb6\xe5\x86\xb5')),
                ('children', models.CharField(blank=True, max_length=180, null=True, verbose_name=b'\xe5\xad\xa9\xe5\xad\x90\xe7\x8a\xb6\xe5\x86\xb5')),
                ('job_info', models.TextField(blank=True, null=True, verbose_name=b'\xe5\xb7\xa5\xe4\xbd\x9c\xe8\xaf\xa6\xe6\x83\x85')),
                ('family', models.TextField(blank=True, null=True, verbose_name=b'\xe5\xae\xb6\xe5\xba\xad\xe8\xaf\xa6\xe6\x83\x85')),
                ('contract_id', models.IntegerField(blank=True, null=True, verbose_name=b'\xe5\x90\x88\xe5\x90\x8c')),
                ('fee', models.FloatField(blank=True, null=True, verbose_name=b'\xe7\xbc\xb4\xe8\xb4\xb9\xe9\x87\x91\xe9\xa2\x9d')),
                ('info', models.TextField(blank=True, null=True, verbose_name=b'\xe5\xa4\x87\xe6\xb3\xa8')),
                ('is_add_coin', models.IntegerField(blank=True, default=0, null=True, verbose_name=b'\xe5\x8a\xa0\xe7\xbc\xa6\xe5\xb8\x81')),
                ('attended_date', models.DateField(blank=True, null=True, verbose_name=b'\xe5\x85\xa5\xe5\xad\xa6\xe6\x97\xa5\xe6\x9c\x9f')),
                ('pay_datetime', models.DateField(blank=True, null=True, verbose_name=b'\xe7\xbc\xb4\xe8\xb4\xb9\xe6\x97\xa5\xe6\x9c\x9f')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('applied_at', models.DateTimeField(null=True)),
                ('paid_at', models.DateTimeField(null=True)),
                ('city', smart_selects.db_fields.ChainedForeignKey(auto_choose=True, blank=True, chained_field=b'province', chained_model_field=b'province', null=True, on_delete=django.db.models.deletion.CASCADE, to='bee_django_crm.City', verbose_name=b'\xe5\xb8\x82')),
            ],
            options={
                'ordering': ['-created_at'],
                'db_table': 'bee_django_crm_preuser',
            },
        ),
        migrations.CreateModel(
            name='PreUserApplication',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('answer', models.TextField()),
                ('preuser', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='bee_crm_user_applications', to='bee_django_crm.PreUser')),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bee_django_crm.ApplicationQuestion')),
            ],
            options={
                'db_table': 'bee_django_crm_preuser_application',
            },
        ),
        migrations.CreateModel(
            name='PreUserContract',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('price', models.FloatField(verbose_name=b'\xe5\xae\x9e\xe6\x94\xb6\xe9\x87\x91\xe9\xa2\x9d')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('paid_at', models.DateTimeField(verbose_name=b'\xe7\xbc\xb4\xe8\xb4\xb9\xe6\x97\xa5\xe6\x9c\x9f')),
                ('study_at', models.DateTimeField(blank=True, null=True, verbose_name=b'\xe5\xbc\x80\xe8\xaf\xbe\xe6\x97\xa5\xe6\x9c\x9f')),
                ('info', models.TextField(blank=True, null=True, verbose_name=b'\xe5\xa4\x87\xe6\xb3\xa8')),
                ('is_checked', models.BooleanField(default=False, verbose_name=b'\xe5\xae\xa1\xe6\xa0\xb8')),
                ('checked_at', models.DateTimeField(null=True)),
                ('after_checked_at', models.DateTimeField(null=True)),
                ('checked_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('contract', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bee_django_crm.Contract', verbose_name=b'\xe5\x90\x88\xe5\x90\x8c')),
                ('preuser', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bee_django_crm.PreUser')),
            ],
            options={
                'ordering': ['-paid_at', '-created_at'],
                'db_table': 'bee_django_crm_preuser_contract',
            },
        ),
        migrations.CreateModel(
            name='PreUserTrack',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('tracked_at', models.DateTimeField(verbose_name=b'\xe8\x81\x94\xe7\xbb\x9c\xe6\x97\xb6\xe9\x97\xb4')),
                ('info', models.TextField(verbose_name=b'\xe8\xaf\xa6\xe6\x83\x85')),
                ('created_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='bee_crm_created_by_user', to=settings.AUTH_USER_MODEL)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='bee_crm_track_user', to='bee_django_crm.PreUser')),
            ],
            options={
                'db_table': 'bee_django_crm_preuser_track',
            },
        ),
        migrations.CreateModel(
            name='Province',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=180, null=True)),
            ],
            options={
                'db_table': 'bee_django_crm_province',
            },
        ),
        migrations.CreateModel(
            name='Source',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=60, verbose_name=b'\xe6\x9d\xa5\xe6\xba\x90\xe5\x90\x8d\xe7\xa7\xb0')),
                ('reg_name', models.CharField(blank=True, max_length=60, null=True, verbose_name=b'\xe6\xb3\xa8\xe5\x86\x8c\xe9\xa1\xb5\xe6\x98\xbe\xe7\xa4\xba\xe5\x90\x8d\xe7\xa7\xb0')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('is_poster', models.BooleanField(default=False, verbose_name=b'\xe6\x98\xaf\xe5\x90\xa6\xe6\xb5\xb7\xe6\x8a\xa5\xe7\xb1\xbb\xe5\x9e\x8b')),
                ('is_show', models.BooleanField(default=False, verbose_name=b'\xe7\xbc\x96\xe8\xbe\x91\xe6\x97\xb6\xe6\x98\xaf\xe5\x90\xa6\xe6\x98\xbe\xe7\xa4\xba')),
            ],
            options={
                'ordering': ['-created_at'],
                'db_table': 'bee_django_crm_source',
            },
        ),
        migrations.AddField(
            model_name='preuser',
            name='province',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='bee_django_crm.Province', verbose_name=b'\xe7\x9c\x81'),
        ),
        migrations.AddField(
            model_name='preuser',
            name='referral_user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='bee_crm_referral_user', to=settings.AUTH_USER_MODEL, verbose_name=b'\xe8\xbd\xac\xe4\xbb\x8b\xe4\xba\xba'),
        ),
        migrations.AddField(
            model_name='preuser',
            name='source',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='bee_django_crm.Source', verbose_name=b'\xe6\x9d\xa5\xe6\xba\x90'),
        ),
        migrations.AddField(
            model_name='poster',
            name='source',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bee_django_crm.Source'),
        ),
        migrations.AddField(
            model_name='city',
            name='province',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bee_django_crm.Province'),
        ),
        migrations.AddField(
            model_name='applicationoption',
            name='question',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bee_django_crm.ApplicationQuestion', verbose_name=b'\xe9\x97\xae\xe9\xa2\x98'),
        ),
    ]
