# DA4RDM_Vis_Processbased

## Description
The DA4RDM_Vis_Processbased is a python based package that can be used to evaluate fitness scores based on process mining alignment algorithm applied on different RDLC phase models.     The package provides a vizualizations of the evaluated scores for the different RDLC phases as obtained for a given Project Id and other related arguments such as start and end timestamps.


## Installation
The package is built using Python as a programming language and utilizes basic python packages. The package also uses the pm4py process mining package for fitness evaluations. Noteworthy, it uses few visualization packages like plotly express and kaleido to get the vizualizations. Please make sure the necessary packages are installed before execution. Few other packages include scipy, json etc. The test package can be installed using the pip command provided below.

**pip install DA4RDM_Vis_Processbased**

## Importing the Modules 
The package has one important module **Vizualize**. This modules invokes the necessary functions from other modules that perform the tasks of data extraction, model creation, fitness evaluation and plotting. The module can be imported using the below command:

```python
from DA4RDM_Vis_Processbased import Vizualize
```

## Usage
As mentioned earlier, the package can be used to extract fitness values and plot them for a reference ProjectId. The fitness values corresponding to the different RDLC phase data models is evaluated for a model created for the reference ProjectId. Finally, a vizualization of the same can be generated and the path of the vizualization image file is returned. To use the package for generating the vizualization, the function **process_vis** within the module **Vizualize** should be used. The function body along with parameter information is as shown below:

```python
def process_vis(dataset_user_interactions, project_id, earliest_timestamp, last_timestamp):
 """
  :param dataset_user_interactions: filepath to the csv file, a string is expected
  :param project_id: the project for which fitness are to be evaluated
  :param earliest_timestamp: the earliest timestamp to consider for filtering records 
  :param last_timestamp: the earliest timestamp to consider for filtering records
 """
```

## Example
Example Usage:<br />
Below is an execution of the function with the parameters provided.
```python
from DA4RDM_Vis_ProcessBased import Visualize
path = Visualize.process_vis('17-02-2023.csv', "f5c043a1-82bc-4c61-bce6-0acbc0062948", '2023-02-14 08:57:44.315', '2021-05-03 02:31:54.652')
print(path)
```

## Output
All the above executions invokes the function **process_vis** with the passed parameter values.The fitness values are calculated and returned by the function. Finally, the results received is vizualized and a path is returned for the saved image.

```python
 
```
The generated files are saved onto the local repository of the program using the package.
