import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserSshkeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The expiration date of the SSH key in ISO 8601 format (YYYY-MM-DDTHH:MM:SSZ)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/user_sshkey#expires_at UserSshkey#expires_at}
    */
    readonly expiresAt?: string;
    /**
    * The ssh key. The SSH key `comment` (trailing part) is optional and ignored for diffing, because GitLab overrides it with the username and GitLab hostname.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/user_sshkey#key UserSshkey#key}
    */
    readonly key: string;
    /**
    * The title of the ssh key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/user_sshkey#title UserSshkey#title}
    */
    readonly title: string;
    /**
    * The ID of the user to add the ssh key to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/user_sshkey#user_id UserSshkey#user_id}
    */
    readonly userId: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/user_sshkey gitlab_user_sshkey}
*/
export declare class UserSshkey extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_user_sshkey";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/user_sshkey gitlab_user_sshkey} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserSshkeyConfig
    */
    constructor(scope: Construct, id: string, config: UserSshkeyConfig);
    get createdAt(): string;
    private _expiresAt?;
    get expiresAt(): string;
    set expiresAt(value: string);
    resetExpiresAt(): void;
    get expiresAtInput(): string | undefined;
    get id(): string;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    get keyId(): number;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _userId?;
    get userId(): number;
    set userId(value: number);
    get userIdInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=user-sshkey.d.ts.map