import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectRunnerEnablementConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID or URL-encoded path of the project owned by the authenticated user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_runner_enablement#project ProjectRunnerEnablement#project}
    */
    readonly project: string;
    /**
    * The ID of a runner to enable for the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_runner_enablement#runner_id ProjectRunnerEnablement#runner_id}
    */
    readonly runnerId: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project_runner_enablement gitlab_project_runner_enablement}
*/
export declare class ProjectRunnerEnablement extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_project_runner_enablement";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project_runner_enablement gitlab_project_runner_enablement} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectRunnerEnablementConfig
    */
    constructor(scope: Construct, id: string, config: ProjectRunnerEnablementConfig);
    get id(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _runnerId?;
    get runnerId(): number;
    set runnerId(value: number);
    get runnerIdInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=project-runner-enablement.d.ts.map