import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PipelineTriggerConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description of the pipeline trigger.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/pipeline_trigger#description PipelineTrigger#description}
    */
    readonly description: string;
    /**
    * The name or id of the project to add the trigger to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/pipeline_trigger#project PipelineTrigger#project}
    */
    readonly project: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/pipeline_trigger gitlab_pipeline_trigger}
*/
export declare class PipelineTrigger extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_pipeline_trigger";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/pipeline_trigger gitlab_pipeline_trigger} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PipelineTriggerConfig
    */
    constructor(scope: Construct, id: string, config: PipelineTriggerConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    get id(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    get token(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=pipeline-trigger.d.ts.map