import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * The full path of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group#full_path DataGitlabGroup#full_path}
    */
    readonly fullPath?: string;
    /**
    * The ID of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group#group_id DataGitlabGroup#group_id}
    */
    readonly groupId?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/group gitlab_group}
*/
export declare class DataGitlabGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/group gitlab_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabGroupConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGitlabGroupConfig);
    get defaultBranchProtection(): number;
    get description(): string;
    get fullName(): string;
    private _fullPath?;
    get fullPath(): string;
    set fullPath(value: string);
    resetFullPath(): void;
    get fullPathInput(): string | undefined;
    private _groupId?;
    get groupId(): number;
    set groupId(value: number);
    resetGroupId(): void;
    get groupIdInput(): number | undefined;
    get id(): string;
    get lfsEnabled(): cdktf.IResolvable;
    get name(): string;
    get parentId(): number;
    get path(): string;
    get preventForkingOutsideGroup(): cdktf.IResolvable;
    get requestAccessEnabled(): cdktf.IResolvable;
    get runnersToken(): string;
    get visibilityLevel(): string;
    get webUrl(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-gitlab-group.d.ts.map