"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BranchProtection = exports.branchProtectionAllowedToUnprotectToTerraform = exports.branchProtectionAllowedToPushToTerraform = exports.branchProtectionAllowedToMergeToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function branchProtectionAllowedToMergeToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        group_id: cdktf.numberToTerraform(struct.groupId),
        user_id: cdktf.numberToTerraform(struct.userId),
    };
}
exports.branchProtectionAllowedToMergeToTerraform = branchProtectionAllowedToMergeToTerraform;
function branchProtectionAllowedToPushToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        group_id: cdktf.numberToTerraform(struct.groupId),
        user_id: cdktf.numberToTerraform(struct.userId),
    };
}
exports.branchProtectionAllowedToPushToTerraform = branchProtectionAllowedToPushToTerraform;
function branchProtectionAllowedToUnprotectToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        group_id: cdktf.numberToTerraform(struct.groupId),
        user_id: cdktf.numberToTerraform(struct.userId),
    };
}
exports.branchProtectionAllowedToUnprotectToTerraform = branchProtectionAllowedToUnprotectToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection gitlab_branch_protection}
*/
class BranchProtection extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection gitlab_branch_protection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BranchProtectionConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'gitlab_branch_protection',
            terraformGeneratorMetadata: {
                providerName: 'gitlab',
                providerVersion: '3.14.0',
                providerVersionConstraint: '~> 3.14.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._allowForcePush = config.allowForcePush;
        this._branch = config.branch;
        this._codeOwnerApprovalRequired = config.codeOwnerApprovalRequired;
        this._mergeAccessLevel = config.mergeAccessLevel;
        this._project = config.project;
        this._pushAccessLevel = config.pushAccessLevel;
        this._unprotectAccessLevel = config.unprotectAccessLevel;
        this._allowedToMerge = config.allowedToMerge;
        this._allowedToPush = config.allowedToPush;
        this._allowedToUnprotect = config.allowedToUnprotect;
    }
    get allowForcePush() {
        return this.getBooleanAttribute('allow_force_push');
    }
    set allowForcePush(value) {
        this._allowForcePush = value;
    }
    resetAllowForcePush() {
        this._allowForcePush = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowForcePushInput() {
        return this._allowForcePush;
    }
    get branch() {
        return this.getStringAttribute('branch');
    }
    set branch(value) {
        this._branch = value;
    }
    // Temporarily expose input value. Use with caution.
    get branchInput() {
        return this._branch;
    }
    // branch_protection_id - computed: true, optional: false, required: false
    get branchProtectionId() {
        return this.getNumberAttribute('branch_protection_id');
    }
    get codeOwnerApprovalRequired() {
        return this.getBooleanAttribute('code_owner_approval_required');
    }
    set codeOwnerApprovalRequired(value) {
        this._codeOwnerApprovalRequired = value;
    }
    resetCodeOwnerApprovalRequired() {
        this._codeOwnerApprovalRequired = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get codeOwnerApprovalRequiredInput() {
        return this._codeOwnerApprovalRequired;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get mergeAccessLevel() {
        return this.getStringAttribute('merge_access_level');
    }
    set mergeAccessLevel(value) {
        this._mergeAccessLevel = value;
    }
    resetMergeAccessLevel() {
        this._mergeAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeAccessLevelInput() {
        return this._mergeAccessLevel;
    }
    get project() {
        return this.getStringAttribute('project');
    }
    set project(value) {
        this._project = value;
    }
    // Temporarily expose input value. Use with caution.
    get projectInput() {
        return this._project;
    }
    get pushAccessLevel() {
        return this.getStringAttribute('push_access_level');
    }
    set pushAccessLevel(value) {
        this._pushAccessLevel = value;
    }
    resetPushAccessLevel() {
        this._pushAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pushAccessLevelInput() {
        return this._pushAccessLevel;
    }
    get unprotectAccessLevel() {
        return this.getStringAttribute('unprotect_access_level');
    }
    set unprotectAccessLevel(value) {
        this._unprotectAccessLevel = value;
    }
    resetUnprotectAccessLevel() {
        this._unprotectAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get unprotectAccessLevelInput() {
        return this._unprotectAccessLevel;
    }
    get allowedToMerge() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('allowed_to_merge')));
    }
    set allowedToMerge(value) {
        this._allowedToMerge = value;
    }
    resetAllowedToMerge() {
        this._allowedToMerge = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedToMergeInput() {
        return this._allowedToMerge;
    }
    get allowedToPush() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('allowed_to_push')));
    }
    set allowedToPush(value) {
        this._allowedToPush = value;
    }
    resetAllowedToPush() {
        this._allowedToPush = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedToPushInput() {
        return this._allowedToPush;
    }
    get allowedToUnprotect() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('allowed_to_unprotect')));
    }
    set allowedToUnprotect(value) {
        this._allowedToUnprotect = value;
    }
    resetAllowedToUnprotect() {
        this._allowedToUnprotect = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedToUnprotectInput() {
        return this._allowedToUnprotect;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_force_push: cdktf.booleanToTerraform(this._allowForcePush),
            branch: cdktf.stringToTerraform(this._branch),
            code_owner_approval_required: cdktf.booleanToTerraform(this._codeOwnerApprovalRequired),
            merge_access_level: cdktf.stringToTerraform(this._mergeAccessLevel),
            project: cdktf.stringToTerraform(this._project),
            push_access_level: cdktf.stringToTerraform(this._pushAccessLevel),
            unprotect_access_level: cdktf.stringToTerraform(this._unprotectAccessLevel),
            allowed_to_merge: cdktf.listMapper(branchProtectionAllowedToMergeToTerraform)(this._allowedToMerge),
            allowed_to_push: cdktf.listMapper(branchProtectionAllowedToPushToTerraform)(this._allowedToPush),
            allowed_to_unprotect: cdktf.listMapper(branchProtectionAllowedToUnprotectToTerraform)(this._allowedToUnprotect),
        };
    }
}
exports.BranchProtection = BranchProtection;
_a = JSII_RTTI_SYMBOL_1;
BranchProtection[_a] = { fqn: "@cdktf/provider-gitlab.BranchProtection", version: "0.0.13" };
// =================
// STATIC PROPERTIES
// =================
BranchProtection.tfResourceType = "gitlab_branch_protection";
//# sourceMappingURL=data:application/json;base64,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