import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BranchProtectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Can be set to true to allow users with push access to force push.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#allow_force_push BranchProtection#allow_force_push}
    */
    readonly allowForcePush?: boolean | cdktf.IResolvable;
    /**
    * Name of the branch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#branch BranchProtection#branch}
    */
    readonly branch: string;
    /**
    * Can be set to true to require code owner approval before merging.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#code_owner_approval_required BranchProtection#code_owner_approval_required}
    */
    readonly codeOwnerApprovalRequired?: boolean | cdktf.IResolvable;
    /**
    * Access levels allowed to merge. Valid values are: `no one`, `developer`, `maintainer`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#merge_access_level BranchProtection#merge_access_level}
    */
    readonly mergeAccessLevel?: string;
    /**
    * The id of the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#project BranchProtection#project}
    */
    readonly project: string;
    /**
    * Access levels allowed to push. Valid values are: `no one`, `developer`, `maintainer`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#push_access_level BranchProtection#push_access_level}
    */
    readonly pushAccessLevel?: string;
    /**
    * Access levels allowed to unprotect. Valid values are: `developer`, `maintainer`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#unprotect_access_level BranchProtection#unprotect_access_level}
    */
    readonly unprotectAccessLevel?: string;
    /**
    * allowed_to_merge block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#allowed_to_merge BranchProtection#allowed_to_merge}
    */
    readonly allowedToMerge?: BranchProtectionAllowedToMerge[] | cdktf.IResolvable;
    /**
    * allowed_to_push block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#allowed_to_push BranchProtection#allowed_to_push}
    */
    readonly allowedToPush?: BranchProtectionAllowedToPush[] | cdktf.IResolvable;
    /**
    * allowed_to_unprotect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#allowed_to_unprotect BranchProtection#allowed_to_unprotect}
    */
    readonly allowedToUnprotect?: BranchProtectionAllowedToUnprotect[] | cdktf.IResolvable;
}
export interface BranchProtectionAllowedToMerge {
    /**
    * The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#group_id BranchProtection#group_id}
    */
    readonly groupId?: number;
    /**
    * The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#user_id BranchProtection#user_id}
    */
    readonly userId?: number;
}
export declare function branchProtectionAllowedToMergeToTerraform(struct?: BranchProtectionAllowedToMerge | cdktf.IResolvable): any;
export interface BranchProtectionAllowedToPush {
    /**
    * The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#group_id BranchProtection#group_id}
    */
    readonly groupId?: number;
    /**
    * The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#user_id BranchProtection#user_id}
    */
    readonly userId?: number;
}
export declare function branchProtectionAllowedToPushToTerraform(struct?: BranchProtectionAllowedToPush | cdktf.IResolvable): any;
export interface BranchProtectionAllowedToUnprotect {
    /**
    * The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#group_id BranchProtection#group_id}
    */
    readonly groupId?: number;
    /**
    * The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#user_id BranchProtection#user_id}
    */
    readonly userId?: number;
}
export declare function branchProtectionAllowedToUnprotectToTerraform(struct?: BranchProtectionAllowedToUnprotect | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection gitlab_branch_protection}
*/
export declare class BranchProtection extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_branch_protection";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection gitlab_branch_protection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BranchProtectionConfig
    */
    constructor(scope: Construct, id: string, config: BranchProtectionConfig);
    private _allowForcePush?;
    get allowForcePush(): boolean | cdktf.IResolvable;
    set allowForcePush(value: boolean | cdktf.IResolvable);
    resetAllowForcePush(): void;
    get allowForcePushInput(): boolean | cdktf.IResolvable | undefined;
    private _branch?;
    get branch(): string;
    set branch(value: string);
    get branchInput(): string | undefined;
    get branchProtectionId(): number;
    private _codeOwnerApprovalRequired?;
    get codeOwnerApprovalRequired(): boolean | cdktf.IResolvable;
    set codeOwnerApprovalRequired(value: boolean | cdktf.IResolvable);
    resetCodeOwnerApprovalRequired(): void;
    get codeOwnerApprovalRequiredInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _mergeAccessLevel?;
    get mergeAccessLevel(): string;
    set mergeAccessLevel(value: string);
    resetMergeAccessLevel(): void;
    get mergeAccessLevelInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _pushAccessLevel?;
    get pushAccessLevel(): string;
    set pushAccessLevel(value: string);
    resetPushAccessLevel(): void;
    get pushAccessLevelInput(): string | undefined;
    private _unprotectAccessLevel?;
    get unprotectAccessLevel(): string;
    set unprotectAccessLevel(value: string);
    resetUnprotectAccessLevel(): void;
    get unprotectAccessLevelInput(): string | undefined;
    private _allowedToMerge?;
    get allowedToMerge(): BranchProtectionAllowedToMerge[] | cdktf.IResolvable;
    set allowedToMerge(value: BranchProtectionAllowedToMerge[] | cdktf.IResolvable);
    resetAllowedToMerge(): void;
    get allowedToMergeInput(): cdktf.IResolvable | BranchProtectionAllowedToMerge[] | undefined;
    private _allowedToPush?;
    get allowedToPush(): BranchProtectionAllowedToPush[] | cdktf.IResolvable;
    set allowedToPush(value: BranchProtectionAllowedToPush[] | cdktf.IResolvable);
    resetAllowedToPush(): void;
    get allowedToPushInput(): cdktf.IResolvable | BranchProtectionAllowedToPush[] | undefined;
    private _allowedToUnprotect?;
    get allowedToUnprotect(): BranchProtectionAllowedToUnprotect[] | cdktf.IResolvable;
    set allowedToUnprotect(value: BranchProtectionAllowedToUnprotect[] | cdktf.IResolvable);
    resetAllowedToUnprotect(): void;
    get allowedToUnprotectInput(): cdktf.IResolvable | BranchProtectionAllowedToUnprotect[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=branch-protection.d.ts.map