"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenSearchAccessPolicy = void 0;
const iam = require("@aws-cdk/aws-iam");
const cr = require("@aws-cdk/custom-resources");
/**
 * Creates LogGroup resource policies.
 */
class OpenSearchAccessPolicy extends cr.AwsCustomResource {
    constructor(scope, id, props) {
        const policyDocument = new iam.PolicyDocument({
            statements: props.accessPolicies,
        });
        super(scope, id, {
            resourceType: 'Custom::OpenSearchAccessPolicy',
            onUpdate: {
                action: 'updateDomainConfig',
                service: 'OpenSearch',
                parameters: {
                    DomainName: props.domainName,
                    AccessPolicies: JSON.stringify(policyDocument.toJSON()),
                },
                // this is needed to limit the response body, otherwise it exceeds the CFN 4k limit
                outputPaths: ['DomainConfig.AccessPolicies'],
                physicalResourceId: cr.PhysicalResourceId.of(`${props.domainName}AccessPolicy`),
            },
            policy: cr.AwsCustomResourcePolicy.fromStatements([new iam.PolicyStatement({ actions: ['es:UpdateDomainConfig'], resources: [props.domainArn] })]),
        });
    }
}
exports.OpenSearchAccessPolicy = OpenSearchAccessPolicy;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib3BlbnNlYXJjaC1hY2Nlc3MtcG9saWN5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsib3BlbnNlYXJjaC1hY2Nlc3MtcG9saWN5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHdDQUF3QztBQUN4QyxnREFBZ0Q7QUEwQmhEOztHQUVHO0FBQ0gsTUFBYSxzQkFBdUIsU0FBUSxFQUFFLENBQUMsaUJBQWlCO0lBQzlELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBa0M7UUFDMUUsTUFBTSxjQUFjLEdBQUcsSUFBSSxHQUFHLENBQUMsY0FBYyxDQUFDO1lBQzVDLFVBQVUsRUFBRSxLQUFLLENBQUMsY0FBYztTQUNqQyxDQUFDLENBQUM7UUFFSCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLFlBQVksRUFBRSxnQ0FBZ0M7WUFDOUMsUUFBUSxFQUFFO2dCQUNSLE1BQU0sRUFBRSxvQkFBb0I7Z0JBQzVCLE9BQU8sRUFBRSxZQUFZO2dCQUNyQixVQUFVLEVBQUU7b0JBQ1YsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVO29CQUM1QixjQUFjLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxjQUFjLENBQUMsTUFBTSxFQUFFLENBQUM7aUJBQ3hEO2dCQUNELG1GQUFtRjtnQkFDbkYsV0FBVyxFQUFFLENBQUMsNkJBQTZCLENBQUM7Z0JBQzVDLGtCQUFrQixFQUFFLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxFQUFFLENBQUMsR0FBRyxLQUFLLENBQUMsVUFBVSxjQUFjLENBQUM7YUFDaEY7WUFDRCxNQUFNLEVBQUUsRUFBRSxDQUFDLHVCQUF1QixDQUFDLGNBQWMsQ0FBQyxDQUFDLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQyxFQUFFLE9BQU8sRUFBRSxDQUFDLHVCQUF1QixDQUFDLEVBQUUsU0FBUyxFQUFFLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO1NBQ25KLENBQUMsQ0FBQztJQUNMLENBQUM7Q0FDRjtBQXRCRCx3REFzQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpYW0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBjciBmcm9tICdAYXdzLWNkay9jdXN0b20tcmVzb3VyY2VzJztcblxuLy8ga2VlcCB0aGlzIGltcG9ydCBzZXBhcmF0ZSBmcm9tIG90aGVyIGltcG9ydHMgdG8gcmVkdWNlIGNoYW5jZSBmb3IgbWVyZ2UgY29uZmxpY3RzIHdpdGggdjItbWFpblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLWR1cGxpY2F0ZS1pbXBvcnRzLCBpbXBvcnQvb3JkZXJcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG4vKipcbiAqIENvbnN0cnVjdGlvbiBwcm9wZXJ0aWVzIGZvciBPcGVuU2VhcmNoQWNjZXNzUG9saWN5XG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgT3BlblNlYXJjaEFjY2Vzc1BvbGljeVByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBPcGVuU2VhcmNoIERvbWFpbiBuYW1lXG4gICAqL1xuICByZWFkb25seSBkb21haW5OYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBPcGVuU2VhcmNoIERvbWFpbiBBUk5cbiAgICovXG4gIHJlYWRvbmx5IGRvbWFpbkFybjogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgYWNjZXNzIHBvbGljeSBzdGF0ZW1lbnRzIGZvciB0aGUgT3BlblNlYXJjaCBjbHVzdGVyXG4gICAqL1xuICByZWFkb25seSBhY2Nlc3NQb2xpY2llczogaWFtLlBvbGljeVN0YXRlbWVudFtdO1xufVxuXG4vKipcbiAqIENyZWF0ZXMgTG9nR3JvdXAgcmVzb3VyY2UgcG9saWNpZXMuXG4gKi9cbmV4cG9ydCBjbGFzcyBPcGVuU2VhcmNoQWNjZXNzUG9saWN5IGV4dGVuZHMgY3IuQXdzQ3VzdG9tUmVzb3VyY2Uge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogT3BlblNlYXJjaEFjY2Vzc1BvbGljeVByb3BzKSB7XG4gICAgY29uc3QgcG9saWN5RG9jdW1lbnQgPSBuZXcgaWFtLlBvbGljeURvY3VtZW50KHtcbiAgICAgIHN0YXRlbWVudHM6IHByb3BzLmFjY2Vzc1BvbGljaWVzLFxuICAgIH0pO1xuXG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICByZXNvdXJjZVR5cGU6ICdDdXN0b206Ok9wZW5TZWFyY2hBY2Nlc3NQb2xpY3knLFxuICAgICAgb25VcGRhdGU6IHtcbiAgICAgICAgYWN0aW9uOiAndXBkYXRlRG9tYWluQ29uZmlnJyxcbiAgICAgICAgc2VydmljZTogJ09wZW5TZWFyY2gnLFxuICAgICAgICBwYXJhbWV0ZXJzOiB7XG4gICAgICAgICAgRG9tYWluTmFtZTogcHJvcHMuZG9tYWluTmFtZSxcbiAgICAgICAgICBBY2Nlc3NQb2xpY2llczogSlNPTi5zdHJpbmdpZnkocG9saWN5RG9jdW1lbnQudG9KU09OKCkpLFxuICAgICAgICB9LFxuICAgICAgICAvLyB0aGlzIGlzIG5lZWRlZCB0byBsaW1pdCB0aGUgcmVzcG9uc2UgYm9keSwgb3RoZXJ3aXNlIGl0IGV4Y2VlZHMgdGhlIENGTiA0ayBsaW1pdFxuICAgICAgICBvdXRwdXRQYXRoczogWydEb21haW5Db25maWcuQWNjZXNzUG9saWNpZXMnXSxcbiAgICAgICAgcGh5c2ljYWxSZXNvdXJjZUlkOiBjci5QaHlzaWNhbFJlc291cmNlSWQub2YoYCR7cHJvcHMuZG9tYWluTmFtZX1BY2Nlc3NQb2xpY3lgKSxcbiAgICAgIH0sXG4gICAgICBwb2xpY3k6IGNyLkF3c0N1c3RvbVJlc291cmNlUG9saWN5LmZyb21TdGF0ZW1lbnRzKFtuZXcgaWFtLlBvbGljeVN0YXRlbWVudCh7IGFjdGlvbnM6IFsnZXM6VXBkYXRlRG9tYWluQ29uZmlnJ10sIHJlc291cmNlczogW3Byb3BzLmRvbWFpbkFybl0gfSldKSxcbiAgICB9KTtcbiAgfVxufVxuIl19