"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DomainZone = void 0;
const route53 = require("aws-cdk-lib/aws-route53");
class DomainZone {
    static define(scope, props) {
        if (DomainZone.isZone(props.zone)) {
            return props.zone;
        }
        return route53.PublicHostedZone.fromLookup(scope, 'Zone', {
            domainName: props.zone,
        });
    }
    static isZone(value) {
        return (typeof value !== 'undefined'
            && 'hostedZoneId' in value
            && 'zoneName' in value
            && 'hostedZoneArn' in value);
    }
}
exports.DomainZone = DomainZone;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvem9uZS9pbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxtREFBbUQ7QUFPbkQsTUFBc0IsVUFBVTtJQUV2QixNQUFNLENBQUMsTUFBTSxDQUFDLEtBQWdCLEVBQUUsS0FBc0I7UUFDM0QsSUFBSSxVQUFVLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsRUFBRTtZQUNqQyxPQUFPLEtBQUssQ0FBQyxJQUFJLENBQUM7U0FDbkI7UUFDRCxPQUFPLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxVQUFVLENBQUMsS0FBSyxFQUFFLE1BQU0sRUFBRTtZQUN4RCxVQUFVLEVBQUUsS0FBSyxDQUFDLElBQUk7U0FDdkIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVPLE1BQU0sQ0FBQyxNQUFNLENBQUMsS0FBVTtRQUM5QixPQUFPLENBQ0wsT0FBTyxLQUFLLEtBQUssV0FBVztlQUN6QixjQUFjLElBQUksS0FBSztlQUN2QixVQUFVLElBQUksS0FBSztlQUNuQixlQUFlLElBQUksS0FBSyxDQUM1QixDQUFDO0lBQ0osQ0FBQztDQUVGO0FBcEJELGdDQW9CQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHJvdXRlNTMgZnJvbSAnYXdzLWNkay1saWIvYXdzLXJvdXRlNTMnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgRG9tYWluWm9uZVByb3BzIHtcbiAgem9uZTogc3RyaW5nIHwgcm91dGU1My5JSG9zdGVkWm9uZTtcbn1cblxuZXhwb3J0IGFic3RyYWN0IGNsYXNzIERvbWFpblpvbmUge1xuXG4gIHB1YmxpYyBzdGF0aWMgZGVmaW5lKHNjb3BlOiBDb25zdHJ1Y3QsIHByb3BzOiBEb21haW5ab25lUHJvcHMpOiByb3V0ZTUzLklIb3N0ZWRab25lIHtcbiAgICBpZiAoRG9tYWluWm9uZS5pc1pvbmUocHJvcHMuem9uZSkpIHtcbiAgICAgIHJldHVybiBwcm9wcy56b25lO1xuICAgIH1cbiAgICByZXR1cm4gcm91dGU1My5QdWJsaWNIb3N0ZWRab25lLmZyb21Mb29rdXAoc2NvcGUsICdab25lJywge1xuICAgICAgZG9tYWluTmFtZTogcHJvcHMuem9uZSxcbiAgICB9KTtcbiAgfVxuXG4gIHByaXZhdGUgc3RhdGljIGlzWm9uZSh2YWx1ZTogYW55KTogdmFsdWUgaXMgcm91dGU1My5JSG9zdGVkWm9uZSB7XG4gICAgcmV0dXJuIChcbiAgICAgIHR5cGVvZiB2YWx1ZSAhPT0gJ3VuZGVmaW5lZCdcbiAgICAgICYmICdob3N0ZWRab25lSWQnIGluIHZhbHVlXG4gICAgICAmJiAnem9uZU5hbWUnIGluIHZhbHVlXG4gICAgICAmJiAnaG9zdGVkWm9uZUFybicgaW4gdmFsdWVcbiAgICApO1xuICB9XG5cbn1cbiJdfQ==