"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DomainCertificate = void 0;
const acm = require("aws-cdk-lib/aws-certificatemanager");
const constructs_1 = require("constructs");
class DomainCertificate extends constructs_1.Construct {
    static define(scope, props) {
        if (DomainCertificate.isCertificate(props.certificate)) {
            return props.certificate;
        }
        return new acm.DnsValidatedCertificate(scope, 'Certificate', {
            region: props.region,
            hostedZone: props.zone,
            domainName: props.fqdn,
        });
    }
    static isCertificate(value) {
        return (typeof value !== 'undefined'
            && 'certificateArn' in value);
    }
}
exports.DomainCertificate = DomainCertificate;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvY2VydGlmaWNhdGUvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsMERBQTBEO0FBRTFELDJDQUF1QztBQVN2QyxNQUFzQixpQkFBa0IsU0FBUSxzQkFBUztJQUVoRCxNQUFNLENBQUMsTUFBTSxDQUFDLEtBQWdCLEVBQUUsS0FBNkI7UUFDbEUsSUFBSSxpQkFBaUIsQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQyxFQUFFO1lBQ3RELE9BQU8sS0FBSyxDQUFDLFdBQVcsQ0FBQztTQUMxQjtRQUNELE9BQU8sSUFBSSxHQUFHLENBQUMsdUJBQXVCLENBQUMsS0FBSyxFQUFFLGFBQWEsRUFBRTtZQUMzRCxNQUFNLEVBQUUsS0FBSyxDQUFDLE1BQU07WUFDcEIsVUFBVSxFQUFFLEtBQUssQ0FBQyxJQUFJO1lBQ3RCLFVBQVUsRUFBRSxLQUFLLENBQUMsSUFBSTtTQUN2QixDQUFDLENBQUM7SUFDTCxDQUFDO0lBRU8sTUFBTSxDQUFDLGFBQWEsQ0FBQyxLQUFVO1FBQ3JDLE9BQU8sQ0FDTCxPQUFPLEtBQUssS0FBSyxXQUFXO2VBQ3pCLGdCQUFnQixJQUFJLEtBQUssQ0FDN0IsQ0FBQztJQUNKLENBQUM7Q0FFRjtBQXBCRCw4Q0FvQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBhY20gZnJvbSAnYXdzLWNkay1saWIvYXdzLWNlcnRpZmljYXRlbWFuYWdlcic7XG5pbXBvcnQgKiBhcyByb3V0ZTUzIGZyb20gJ2F3cy1jZGstbGliL2F3cy1yb3V0ZTUzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG5leHBvcnQgaW50ZXJmYWNlIERvbWFpbkNlcnRpZmljYXRlUHJvcHMge1xuICBjZXJ0aWZpY2F0ZT86IGFjbS5JQ2VydGlmaWNhdGU7XG4gIHpvbmU6IHJvdXRlNTMuSUhvc3RlZFpvbmU7XG4gIHJlZ2lvbjogc3RyaW5nO1xuICBmcWRuOiBzdHJpbmc7XG59XG5cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBEb21haW5DZXJ0aWZpY2F0ZSBleHRlbmRzIENvbnN0cnVjdCB7XG5cbiAgcHVibGljIHN0YXRpYyBkZWZpbmUoc2NvcGU6IENvbnN0cnVjdCwgcHJvcHM6IERvbWFpbkNlcnRpZmljYXRlUHJvcHMpOiBhY20uSUNlcnRpZmljYXRlIHtcbiAgICBpZiAoRG9tYWluQ2VydGlmaWNhdGUuaXNDZXJ0aWZpY2F0ZShwcm9wcy5jZXJ0aWZpY2F0ZSkpIHtcbiAgICAgIHJldHVybiBwcm9wcy5jZXJ0aWZpY2F0ZTtcbiAgICB9XG4gICAgcmV0dXJuIG5ldyBhY20uRG5zVmFsaWRhdGVkQ2VydGlmaWNhdGUoc2NvcGUsICdDZXJ0aWZpY2F0ZScsIHtcbiAgICAgIHJlZ2lvbjogcHJvcHMucmVnaW9uLFxuICAgICAgaG9zdGVkWm9uZTogcHJvcHMuem9uZSxcbiAgICAgIGRvbWFpbk5hbWU6IHByb3BzLmZxZG4sXG4gICAgfSk7XG4gIH1cblxuICBwcml2YXRlIHN0YXRpYyBpc0NlcnRpZmljYXRlKHZhbHVlOiBhbnkpOiB2YWx1ZSBpcyBhY20uSUNlcnRpZmljYXRlIHtcbiAgICByZXR1cm4gKFxuICAgICAgdHlwZW9mIHZhbHVlICE9PSAndW5kZWZpbmVkJ1xuICAgICAgJiYgJ2NlcnRpZmljYXRlQXJuJyBpbiB2YWx1ZVxuICAgICk7XG4gIH1cblxufVxuIl19