[![DOI](https://joss.theoj.org/papers/10.21105/joss.02076/status.svg)](https://doi.org/10.21105/joss.02076)
[![Build Status](https://travis-ci.com/CountESS-Project/fqfa.svg?branch=main)](https://travis-ci.com/CountESS-Project/fqfa)
[![Coverage Status](https://coveralls.io/repos/github/CountESS-Project/fqfa/badge.svg?branch=main)](https://coveralls.io/github/CountESS-Project/fqfa?branch=main)
[![Documentation Status](https://readthedocs.org/projects/fqfa/badge/?version=latest)](https://fqfa.readthedocs.io/en/latest/?badge=latest)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

# fqfa

A pure Python library for handling [FASTQ](https://www.ncbi.nlm.nih.gov/sra/docs/submitformats/#fastq-files) and 
[FASTA]( https://www.ncbi.nlm.nih.gov/BLAST/fasta.shtml) files.

Install fqfa from PyPI using pip:

    pip3 install fqfa

Building the documentation requires the following additional packages:

    pip3 install sphinx
    pip3 install sphinx-rtd-theme

Online documentation including usage examples is available on 
[Read the Docs](https://fqfa.readthedocs.io/en/latest/index.html).

To report a problem or request a new feature, please use the GitHub issue tracker.

To cite this package please refer to ["fqfa: A pure Python package for genomic sequence files"](https://doi.org/10.21105/joss.02076).

Contributions via pull request are welcome. 
Contributed code should have full unit test coverage, 
[NumPy-style docstrings](https://numpydoc.readthedocs.io/en/latest/format.html#docstring-standard),
[black formatting](https://github.com/psf/black),
and [type hints](https://docs.python.org/3/library/typing.html).
