

CREATE TABLE agriculture (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	plant_growth_med VARCHAR(30), 
	soil_horizon VARCHAR(10), 
	photosynt_activ TEXT, 
	photosynt_activ_meth TEXT, 
	samp_collect_method TEXT, 
	enrichment_protocol TEXT, 
	library_prep_kit TEXT, 
	sequencing_location TEXT, 
	"soil_pH" FLOAT, 
	soil_conductivity TEXT, 
	rel_location TEXT, 
	soil_cover TEXT, 
	porosity TEXT, 
	texture TEXT, 
	texture_meth TEXT, 
	host_symbiont TEXT, 
	pres_animal_insect TEXT, 
	plant_water_method TEXT, 
	anim_water_method TEXT, 
	farm_water_source VARCHAR(19), 
	water_source_shared VARCHAR(27), 
	"water_pH" FLOAT, 
	season TEXT, 
	solar_irradiance TEXT, 
	crop_yield TEXT, 
	season_humidity TEXT, 
	humidity TEXT, 
	adjacent_environment TEXT, 
	chem_administration TEXT NOT NULL, 
	food_prod TEXT, 
	lot_number TEXT, 
	fertilizer_admin TEXT, 
	samp_stor_temp TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	farm_equip_san TEXT, 
	farm_equip TEXT, 
	farm_equip_shared TEXT, 
	food_harvest_proc TEXT, 
	plant_struc TEXT, 
	host_dry_mass TEXT, 
	ances_data TEXT, 
	genetic_mod TEXT, 
	"Food_Product_type" TEXT, 
	"Food_source" TEXT NOT NULL, 
	spikein_strain TEXT, 
	organism_count VARCHAR(5), 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	cult_isol_date DATE, 
	samp_pooling TEXT, 
	root_med_macronutr TEXT, 
	root_med_carbon TEXT, 
	root_med_ph FLOAT, 
	water_temp_regm TEXT, 
	watering_regm TEXT, 
	standing_water_regm TEXT, 
	gaseous_environment TEXT, 
	fungicide_regm TEXT, 
	climate_environment TEXT, 
	herbicide_regm TEXT, 
	non_mineral_nutr_regm TEXT, 
	pesticide_regm TEXT, 
	ph_regm TEXT, 
	salt_regm TEXT, 
	season_environment TEXT, 
	perturbation TEXT, 
	samp_store_dur TEXT NOT NULL, 
	samp_store_loc TEXT NOT NULL, 
	samp_collect_device TEXT NOT NULL, 
	host_age TEXT NOT NULL, 
	host_common_name TEXT NOT NULL, 
	host_genotype TEXT NOT NULL, 
	host_height TEXT NOT NULL, 
	host_subspecf_genlin TEXT, 
	host_length TEXT NOT NULL, 
	host_life_stage TEXT NOT NULL, 
	host_phenotype TEXT NOT NULL, 
	host_taxid TEXT NOT NULL, 
	host_tot_mass TEXT NOT NULL, 
	plant_product TEXT, 
	oxy_stat_samp VARCHAR(9), 
	assembly_quality TEXT, 
	url TEXT, 
	fao_class VARCHAR(13), 
	local_class TEXT, 
	local_class_meth TEXT, 
	soil_type TEXT NOT NULL, 
	soil_type_meth TEXT NOT NULL, 
	horizon VARCHAR(10), 
	horizon_meth TEXT, 
	link_class_info TEXT, 
	previous_land_use TEXT, 
	previous_land_use_meth TEXT, 
	crop_rotation TEXT, 
	agrochem_addition TEXT, 
	tillage VARCHAR(13), 
	fire DATE, 
	flooding DATE, 
	extreme_event DATE, 
	link_climate_info TEXT, 
	annual_temp TEXT, 
	season_temp TEXT, 
	annual_precpt TEXT, 
	season_precpt TEXT, 
	cur_land_use VARCHAR(93), 
	slope_gradient TEXT, 
	slope_aspect TEXT, 
	profile_position VARCHAR(9), 
	drainage_class VARCHAR(19), 
	store_cond TEXT NOT NULL, 
	ph_meth TEXT, 
	cur_vegetation TEXT, 
	cur_vegetation_meth TEXT, 
	tot_org_carb TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro TEXT, 
	tot_n_meth TEXT, 
	microbial_biomass TEXT NOT NULL, 
	microbial_biomass_meth TEXT NOT NULL, 
	heavy_metals_meth TEXT, 
	tot_car TEXT, 
	tot_phos TEXT, 
	sieving TEXT NOT NULL, 
	pool_dna_extracts TEXT NOT NULL, 
	misc_param TEXT, 
	host_disease_stat TEXT, 
	specific_host TEXT NOT NULL, 
	pathogenicity TEXT NOT NULL, 
	biotic_relationship VARCHAR(11), 
	isol_growth_condt TEXT, 
	samp_mat_process TEXT NOT NULL, 
	host_spec_range INTEGER NOT NULL, 
	trophic_level VARCHAR(22), 
	samp_size TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT NOT NULL, 
	pcr_primers TEXT NOT NULL, 
	nucl_acid_ext TEXT NOT NULL, 
	nucl_acid_amp TEXT NOT NULL, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER NOT NULL, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT NOT NULL, 
	lib_screen TEXT NOT NULL, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT NOT NULL, 
	mid TEXT NOT NULL, 
	adapters TEXT NOT NULL, 
	pcr_cond TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT NOT NULL, 
	assembly_name TEXT NOT NULL, 
	assembly_software TEXT, 
	annot TEXT, 
	sop TEXT, 
	source_mat_id TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, plant_growth_med, soil_horizon, photosynt_activ, photosynt_activ_meth, samp_collect_method, enrichment_protocol, library_prep_kit, sequencing_location, "soil_pH", soil_conductivity, rel_location, soil_cover, porosity, texture, texture_meth, host_symbiont, pres_animal_insect, plant_water_method, anim_water_method, farm_water_source, water_source_shared, "water_pH", season, solar_irradiance, crop_yield, season_humidity, humidity, adjacent_environment, chem_administration, food_prod, lot_number, fertilizer_admin, samp_stor_temp, food_trav_mode, food_trav_vehic, farm_equip_san, farm_equip, farm_equip_shared, food_harvest_proc, plant_struc, host_dry_mass, ances_data, genetic_mod, "Food_Product_type", "Food_source", spikein_strain, organism_count, size_frac_low, size_frac_up, cult_isol_date, samp_pooling, root_med_macronutr, root_med_carbon, root_med_ph, water_temp_regm, watering_regm, standing_water_regm, gaseous_environment, fungicide_regm, climate_environment, herbicide_regm, non_mineral_nutr_regm, pesticide_regm, ph_regm, salt_regm, season_environment, perturbation, samp_store_dur, samp_store_loc, samp_collect_device, host_age, host_common_name, host_genotype, host_height, host_subspecf_genlin, host_length, host_life_stage, host_phenotype, host_taxid, host_tot_mass, plant_product, oxy_stat_samp, assembly_quality, url, fao_class, local_class, local_class_meth, soil_type, soil_type_meth, horizon, horizon_meth, link_class_info, previous_land_use, previous_land_use_meth, crop_rotation, agrochem_addition, tillage, fire, flooding, extreme_event, link_climate_info, annual_temp, season_temp, annual_precpt, season_precpt, cur_land_use, slope_gradient, slope_aspect, profile_position, drainage_class, store_cond, ph_meth, cur_vegetation, cur_vegetation_meth, tot_org_carb, tot_org_c_meth, tot_nitro, tot_n_meth, microbial_biomass, microbial_biomass_meth, heavy_metals_meth, tot_car, tot_phos, sieving, pool_dna_extracts, misc_param, host_disease_stat, specific_host, pathogenicity, biotic_relationship, isol_growth_condt, samp_mat_process, host_spec_range, trophic_level, samp_size, seq_meth, samp_vol_we_dna_ext, pcr_primers, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, mid, adapters, pcr_cond, seq_quality_check, chimera_check, assembly_name, assembly_software, annot, sop, source_mat_id)
);

CREATE TABLE "agriculture_MIGS_bacteria" (
	lat_lon TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	plant_growth_med VARCHAR(30), 
	soil_horizon VARCHAR(10), 
	photosynt_activ TEXT, 
	photosynt_activ_meth TEXT, 
	samp_collect_method TEXT, 
	enrichment_protocol TEXT, 
	library_prep_kit TEXT, 
	sequencing_location TEXT, 
	"temp" TEXT, 
	"soil_pH" FLOAT, 
	soil_conductivity TEXT, 
	rel_location TEXT, 
	soil_cover TEXT, 
	porosity TEXT, 
	texture TEXT, 
	texture_meth TEXT, 
	host_symbiont TEXT, 
	pres_animal_insect TEXT, 
	plant_water_method TEXT, 
	anim_water_method TEXT, 
	farm_water_source VARCHAR(19), 
	water_source_shared VARCHAR(27), 
	"water_pH" FLOAT, 
	season TEXT, 
	solar_irradiance TEXT, 
	crop_yield TEXT, 
	season_humidity TEXT, 
	humidity TEXT, 
	adjacent_environment TEXT, 
	chem_administration TEXT NOT NULL, 
	food_prod TEXT, 
	lot_number TEXT, 
	fertilizer_admin TEXT, 
	samp_stor_temp TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	farm_equip_san TEXT, 
	farm_equip TEXT, 
	farm_equip_shared TEXT, 
	food_harvest_proc TEXT, 
	plant_struc TEXT, 
	host_dry_mass TEXT, 
	ances_data TEXT, 
	genetic_mod TEXT, 
	"Food_Product_type" TEXT, 
	"Food_source" TEXT NOT NULL, 
	spikein_strain TEXT, 
	organism_count VARCHAR(5), 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	cult_isol_date DATE, 
	samp_pooling TEXT, 
	root_med_macronutr TEXT, 
	root_med_carbon TEXT, 
	root_med_ph FLOAT, 
	depth TEXT NOT NULL, 
	water_temp_regm TEXT, 
	watering_regm TEXT, 
	standing_water_regm TEXT, 
	gaseous_environment TEXT, 
	fungicide_regm TEXT, 
	climate_environment TEXT, 
	herbicide_regm TEXT, 
	non_mineral_nutr_regm TEXT, 
	pesticide_regm TEXT, 
	ph_regm TEXT, 
	salt_regm TEXT, 
	season_environment TEXT, 
	perturbation TEXT, 
	samp_store_dur TEXT NOT NULL, 
	samp_store_loc TEXT NOT NULL, 
	samp_collect_device TEXT NOT NULL, 
	host_age TEXT NOT NULL, 
	host_common_name TEXT NOT NULL, 
	host_genotype TEXT NOT NULL, 
	host_height TEXT NOT NULL, 
	host_subspecf_genlin TEXT, 
	host_length TEXT NOT NULL, 
	host_life_stage TEXT NOT NULL, 
	host_phenotype TEXT NOT NULL, 
	host_taxid TEXT NOT NULL, 
	host_tot_mass TEXT NOT NULL, 
	plant_product TEXT, 
	oxy_stat_samp VARCHAR(9), 
	assembly_quality TEXT, 
	url TEXT, 
	fao_class VARCHAR(13), 
	local_class TEXT, 
	local_class_meth TEXT, 
	soil_type TEXT NOT NULL, 
	soil_type_meth TEXT NOT NULL, 
	horizon VARCHAR(10), 
	horizon_meth TEXT, 
	link_class_info TEXT, 
	previous_land_use TEXT, 
	previous_land_use_meth TEXT, 
	crop_rotation TEXT, 
	agrochem_addition TEXT, 
	tillage VARCHAR(13), 
	fire DATE, 
	flooding DATE, 
	extreme_event DATE, 
	link_climate_info TEXT, 
	annual_temp TEXT, 
	season_temp TEXT, 
	annual_precpt TEXT, 
	season_precpt TEXT, 
	cur_land_use VARCHAR(93), 
	slope_gradient TEXT, 
	slope_aspect TEXT, 
	profile_position VARCHAR(9), 
	drainage_class VARCHAR(19), 
	store_cond TEXT NOT NULL, 
	ph_meth TEXT, 
	cur_vegetation TEXT, 
	cur_vegetation_meth TEXT, 
	tot_org_carb TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro TEXT, 
	tot_n_meth TEXT, 
	microbial_biomass TEXT NOT NULL, 
	microbial_biomass_meth TEXT NOT NULL, 
	heavy_metals_meth TEXT, 
	tot_car TEXT, 
	tot_phos TEXT, 
	sieving TEXT NOT NULL, 
	pool_dna_extracts TEXT NOT NULL, 
	misc_param TEXT, 
	host_disease_stat TEXT, 
	specific_host TEXT NOT NULL, 
	pathogenicity TEXT NOT NULL, 
	biotic_relationship VARCHAR(11), 
	isol_growth_condt TEXT, 
	samp_mat_process TEXT NOT NULL, 
	host_spec_range INTEGER NOT NULL, 
	trophic_level VARCHAR(22), 
	samp_size TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT NOT NULL, 
	pcr_primers TEXT NOT NULL, 
	nucl_acid_ext TEXT NOT NULL, 
	nucl_acid_amp TEXT NOT NULL, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER NOT NULL, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT NOT NULL, 
	lib_screen TEXT NOT NULL, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT NOT NULL, 
	mid TEXT NOT NULL, 
	adapters TEXT NOT NULL, 
	pcr_cond TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT NOT NULL, 
	assembly_name TEXT NOT NULL, 
	assembly_software TEXT, 
	annot TEXT, 
	sop TEXT, 
	source_mat_id TEXT, 
	samp_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER NOT NULL, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT NOT NULL, 
	encoded_traits TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	PRIMARY KEY (lat_lon, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, plant_growth_med, soil_horizon, photosynt_activ, photosynt_activ_meth, samp_collect_method, enrichment_protocol, library_prep_kit, sequencing_location, "temp", "soil_pH", soil_conductivity, rel_location, soil_cover, porosity, texture, texture_meth, host_symbiont, pres_animal_insect, plant_water_method, anim_water_method, farm_water_source, water_source_shared, "water_pH", season, solar_irradiance, crop_yield, season_humidity, humidity, adjacent_environment, chem_administration, food_prod, lot_number, fertilizer_admin, samp_stor_temp, food_trav_mode, food_trav_vehic, farm_equip_san, farm_equip, farm_equip_shared, food_harvest_proc, plant_struc, host_dry_mass, ances_data, genetic_mod, "Food_Product_type", "Food_source", spikein_strain, organism_count, size_frac_low, size_frac_up, cult_isol_date, samp_pooling, root_med_macronutr, root_med_carbon, root_med_ph, depth, water_temp_regm, watering_regm, standing_water_regm, gaseous_environment, fungicide_regm, climate_environment, herbicide_regm, non_mineral_nutr_regm, pesticide_regm, ph_regm, salt_regm, season_environment, perturbation, samp_store_dur, samp_store_loc, samp_collect_device, host_age, host_common_name, host_genotype, host_height, host_subspecf_genlin, host_length, host_life_stage, host_phenotype, host_taxid, host_tot_mass, plant_product, oxy_stat_samp, assembly_quality, url, fao_class, local_class, local_class_meth, soil_type, soil_type_meth, horizon, horizon_meth, link_class_info, previous_land_use, previous_land_use_meth, crop_rotation, agrochem_addition, tillage, fire, flooding, extreme_event, link_climate_info, annual_temp, season_temp, annual_precpt, season_precpt, cur_land_use, slope_gradient, slope_aspect, profile_position, drainage_class, store_cond, ph_meth, cur_vegetation, cur_vegetation_meth, tot_org_carb, tot_org_c_meth, tot_nitro, tot_n_meth, microbial_biomass, microbial_biomass_meth, heavy_metals_meth, tot_car, tot_phos, sieving, pool_dna_extracts, misc_param, host_disease_stat, specific_host, pathogenicity, biotic_relationship, isol_growth_condt, samp_mat_process, host_spec_range, trophic_level, samp_size, seq_meth, samp_vol_we_dna_ext, pcr_primers, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, mid, adapters, pcr_cond, seq_quality_check, chimera_check, assembly_name, assembly_software, annot, sop, source_mat_id, samp_name, samp_taxon_id, project_name, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, encoded_traits, rel_to_oxygen, samp_collec_device, samp_collec_method, tax_ident, assembly_qual, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource)
);

CREATE TABLE "agriculture_MIGS_eukaryote" (
	lat_lon TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	plant_growth_med VARCHAR(30), 
	soil_horizon VARCHAR(10), 
	photosynt_activ TEXT, 
	photosynt_activ_meth TEXT, 
	samp_collect_method TEXT, 
	enrichment_protocol TEXT, 
	library_prep_kit TEXT, 
	sequencing_location TEXT, 
	"temp" TEXT, 
	"soil_pH" FLOAT, 
	soil_conductivity TEXT, 
	rel_location TEXT, 
	soil_cover TEXT, 
	porosity TEXT, 
	texture TEXT, 
	texture_meth TEXT, 
	host_symbiont TEXT, 
	pres_animal_insect TEXT, 
	plant_water_method TEXT, 
	anim_water_method TEXT, 
	farm_water_source VARCHAR(19), 
	water_source_shared VARCHAR(27), 
	"water_pH" FLOAT, 
	season TEXT, 
	solar_irradiance TEXT, 
	crop_yield TEXT, 
	season_humidity TEXT, 
	humidity TEXT, 
	adjacent_environment TEXT, 
	chem_administration TEXT NOT NULL, 
	food_prod TEXT, 
	lot_number TEXT, 
	fertilizer_admin TEXT, 
	samp_stor_temp TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	farm_equip_san TEXT, 
	farm_equip TEXT, 
	farm_equip_shared TEXT, 
	food_harvest_proc TEXT, 
	plant_struc TEXT, 
	host_dry_mass TEXT, 
	ances_data TEXT, 
	genetic_mod TEXT, 
	"Food_Product_type" TEXT, 
	"Food_source" TEXT NOT NULL, 
	spikein_strain TEXT, 
	organism_count VARCHAR(5), 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	cult_isol_date DATE, 
	samp_pooling TEXT, 
	root_med_macronutr TEXT, 
	root_med_carbon TEXT, 
	root_med_ph FLOAT, 
	depth TEXT NOT NULL, 
	water_temp_regm TEXT, 
	watering_regm TEXT, 
	standing_water_regm TEXT, 
	gaseous_environment TEXT, 
	fungicide_regm TEXT, 
	climate_environment TEXT, 
	herbicide_regm TEXT, 
	non_mineral_nutr_regm TEXT, 
	pesticide_regm TEXT, 
	ph_regm TEXT, 
	salt_regm TEXT, 
	season_environment TEXT, 
	perturbation TEXT, 
	samp_store_dur TEXT NOT NULL, 
	samp_store_loc TEXT NOT NULL, 
	samp_collect_device TEXT NOT NULL, 
	host_age TEXT NOT NULL, 
	host_common_name TEXT NOT NULL, 
	host_genotype TEXT NOT NULL, 
	host_height TEXT NOT NULL, 
	host_subspecf_genlin TEXT, 
	host_length TEXT NOT NULL, 
	host_life_stage TEXT NOT NULL, 
	host_phenotype TEXT NOT NULL, 
	host_taxid TEXT NOT NULL, 
	host_tot_mass TEXT NOT NULL, 
	plant_product TEXT, 
	oxy_stat_samp VARCHAR(9), 
	assembly_quality TEXT, 
	url TEXT, 
	fao_class VARCHAR(13), 
	local_class TEXT, 
	local_class_meth TEXT, 
	soil_type TEXT NOT NULL, 
	soil_type_meth TEXT NOT NULL, 
	horizon VARCHAR(10), 
	horizon_meth TEXT, 
	link_class_info TEXT, 
	previous_land_use TEXT, 
	previous_land_use_meth TEXT, 
	crop_rotation TEXT, 
	agrochem_addition TEXT, 
	tillage VARCHAR(13), 
	fire DATE, 
	flooding DATE, 
	extreme_event DATE, 
	link_climate_info TEXT, 
	annual_temp TEXT, 
	season_temp TEXT, 
	annual_precpt TEXT, 
	season_precpt TEXT, 
	cur_land_use VARCHAR(93), 
	slope_gradient TEXT, 
	slope_aspect TEXT, 
	profile_position VARCHAR(9), 
	drainage_class VARCHAR(19), 
	store_cond TEXT NOT NULL, 
	ph_meth TEXT, 
	cur_vegetation TEXT, 
	cur_vegetation_meth TEXT, 
	tot_org_carb TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro TEXT, 
	tot_n_meth TEXT, 
	microbial_biomass TEXT NOT NULL, 
	microbial_biomass_meth TEXT NOT NULL, 
	heavy_metals_meth TEXT, 
	tot_car TEXT, 
	tot_phos TEXT, 
	sieving TEXT NOT NULL, 
	pool_dna_extracts TEXT NOT NULL, 
	misc_param TEXT, 
	host_disease_stat TEXT, 
	specific_host TEXT NOT NULL, 
	pathogenicity TEXT NOT NULL, 
	biotic_relationship VARCHAR(11), 
	isol_growth_condt TEXT, 
	samp_mat_process TEXT NOT NULL, 
	host_spec_range INTEGER NOT NULL, 
	trophic_level VARCHAR(22), 
	samp_size TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT NOT NULL, 
	pcr_primers TEXT NOT NULL, 
	nucl_acid_ext TEXT NOT NULL, 
	nucl_acid_amp TEXT NOT NULL, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER NOT NULL, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT NOT NULL, 
	lib_screen TEXT NOT NULL, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT NOT NULL, 
	mid TEXT NOT NULL, 
	adapters TEXT NOT NULL, 
	pcr_cond TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT NOT NULL, 
	assembly_name TEXT NOT NULL, 
	assembly_software TEXT, 
	annot TEXT, 
	sop TEXT, 
	source_mat_id TEXT, 
	samp_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	ploidy TEXT, 
	num_replicons INTEGER, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	propagation TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	PRIMARY KEY (lat_lon, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, plant_growth_med, soil_horizon, photosynt_activ, photosynt_activ_meth, samp_collect_method, enrichment_protocol, library_prep_kit, sequencing_location, "temp", "soil_pH", soil_conductivity, rel_location, soil_cover, porosity, texture, texture_meth, host_symbiont, pres_animal_insect, plant_water_method, anim_water_method, farm_water_source, water_source_shared, "water_pH", season, solar_irradiance, crop_yield, season_humidity, humidity, adjacent_environment, chem_administration, food_prod, lot_number, fertilizer_admin, samp_stor_temp, food_trav_mode, food_trav_vehic, farm_equip_san, farm_equip, farm_equip_shared, food_harvest_proc, plant_struc, host_dry_mass, ances_data, genetic_mod, "Food_Product_type", "Food_source", spikein_strain, organism_count, size_frac_low, size_frac_up, cult_isol_date, samp_pooling, root_med_macronutr, root_med_carbon, root_med_ph, depth, water_temp_regm, watering_regm, standing_water_regm, gaseous_environment, fungicide_regm, climate_environment, herbicide_regm, non_mineral_nutr_regm, pesticide_regm, ph_regm, salt_regm, season_environment, perturbation, samp_store_dur, samp_store_loc, samp_collect_device, host_age, host_common_name, host_genotype, host_height, host_subspecf_genlin, host_length, host_life_stage, host_phenotype, host_taxid, host_tot_mass, plant_product, oxy_stat_samp, assembly_quality, url, fao_class, local_class, local_class_meth, soil_type, soil_type_meth, horizon, horizon_meth, link_class_info, previous_land_use, previous_land_use_meth, crop_rotation, agrochem_addition, tillage, fire, flooding, extreme_event, link_climate_info, annual_temp, season_temp, annual_precpt, season_precpt, cur_land_use, slope_gradient, slope_aspect, profile_position, drainage_class, store_cond, ph_meth, cur_vegetation, cur_vegetation_meth, tot_org_carb, tot_org_c_meth, tot_nitro, tot_n_meth, microbial_biomass, microbial_biomass_meth, heavy_metals_meth, tot_car, tot_phos, sieving, pool_dna_extracts, misc_param, host_disease_stat, specific_host, pathogenicity, biotic_relationship, isol_growth_condt, samp_mat_process, host_spec_range, trophic_level, samp_size, seq_meth, samp_vol_we_dna_ext, pcr_primers, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, mid, adapters, pcr_cond, seq_quality_check, chimera_check, assembly_name, assembly_software, annot, sop, source_mat_id, samp_name, samp_taxon_id, project_name, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, ploidy, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, propagation, samp_collec_device, samp_collec_method, tax_ident, assembly_qual, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource)
);

CREATE TABLE "agriculture_MIGS_org" (
	lat_lon TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	plant_growth_med VARCHAR(30), 
	soil_horizon VARCHAR(10), 
	photosynt_activ TEXT, 
	photosynt_activ_meth TEXT, 
	samp_collect_method TEXT, 
	enrichment_protocol TEXT, 
	library_prep_kit TEXT, 
	sequencing_location TEXT, 
	"temp" TEXT, 
	"soil_pH" FLOAT, 
	soil_conductivity TEXT, 
	rel_location TEXT, 
	soil_cover TEXT, 
	porosity TEXT, 
	texture TEXT, 
	texture_meth TEXT, 
	host_symbiont TEXT, 
	pres_animal_insect TEXT, 
	plant_water_method TEXT, 
	anim_water_method TEXT, 
	farm_water_source VARCHAR(19), 
	water_source_shared VARCHAR(27), 
	"water_pH" FLOAT, 
	season TEXT, 
	solar_irradiance TEXT, 
	crop_yield TEXT, 
	season_humidity TEXT, 
	humidity TEXT, 
	adjacent_environment TEXT, 
	chem_administration TEXT NOT NULL, 
	food_prod TEXT, 
	lot_number TEXT, 
	fertilizer_admin TEXT, 
	samp_stor_temp TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	farm_equip_san TEXT, 
	farm_equip TEXT, 
	farm_equip_shared TEXT, 
	food_harvest_proc TEXT, 
	plant_struc TEXT, 
	host_dry_mass TEXT, 
	ances_data TEXT, 
	genetic_mod TEXT, 
	"Food_Product_type" TEXT, 
	"Food_source" TEXT NOT NULL, 
	spikein_strain TEXT, 
	organism_count VARCHAR(5), 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	cult_isol_date DATE, 
	samp_pooling TEXT, 
	root_med_macronutr TEXT, 
	root_med_carbon TEXT, 
	root_med_ph FLOAT, 
	depth TEXT NOT NULL, 
	water_temp_regm TEXT, 
	watering_regm TEXT, 
	standing_water_regm TEXT, 
	gaseous_environment TEXT, 
	fungicide_regm TEXT, 
	climate_environment TEXT, 
	herbicide_regm TEXT, 
	non_mineral_nutr_regm TEXT, 
	pesticide_regm TEXT, 
	ph_regm TEXT, 
	salt_regm TEXT, 
	season_environment TEXT, 
	perturbation TEXT, 
	samp_store_dur TEXT NOT NULL, 
	samp_store_loc TEXT NOT NULL, 
	samp_collect_device TEXT NOT NULL, 
	host_age TEXT NOT NULL, 
	host_common_name TEXT NOT NULL, 
	host_genotype TEXT NOT NULL, 
	host_height TEXT NOT NULL, 
	host_subspecf_genlin TEXT, 
	host_length TEXT NOT NULL, 
	host_life_stage TEXT NOT NULL, 
	host_phenotype TEXT NOT NULL, 
	host_taxid TEXT NOT NULL, 
	host_tot_mass TEXT NOT NULL, 
	plant_product TEXT, 
	oxy_stat_samp VARCHAR(9), 
	assembly_quality TEXT, 
	url TEXT, 
	fao_class VARCHAR(13), 
	local_class TEXT, 
	local_class_meth TEXT, 
	soil_type TEXT NOT NULL, 
	soil_type_meth TEXT NOT NULL, 
	horizon VARCHAR(10), 
	horizon_meth TEXT, 
	link_class_info TEXT, 
	previous_land_use TEXT, 
	previous_land_use_meth TEXT, 
	crop_rotation TEXT, 
	agrochem_addition TEXT, 
	tillage VARCHAR(13), 
	fire DATE, 
	flooding DATE, 
	extreme_event DATE, 
	link_climate_info TEXT, 
	annual_temp TEXT, 
	season_temp TEXT, 
	annual_precpt TEXT, 
	season_precpt TEXT, 
	cur_land_use VARCHAR(93), 
	slope_gradient TEXT, 
	slope_aspect TEXT, 
	profile_position VARCHAR(9), 
	drainage_class VARCHAR(19), 
	store_cond TEXT NOT NULL, 
	ph_meth TEXT, 
	cur_vegetation TEXT, 
	cur_vegetation_meth TEXT, 
	tot_org_carb TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro TEXT, 
	tot_n_meth TEXT, 
	microbial_biomass TEXT NOT NULL, 
	microbial_biomass_meth TEXT NOT NULL, 
	heavy_metals_meth TEXT, 
	tot_car TEXT, 
	tot_phos TEXT, 
	sieving TEXT NOT NULL, 
	pool_dna_extracts TEXT NOT NULL, 
	misc_param TEXT, 
	host_disease_stat TEXT, 
	specific_host TEXT NOT NULL, 
	pathogenicity TEXT NOT NULL, 
	biotic_relationship VARCHAR(11), 
	isol_growth_condt TEXT, 
	samp_mat_process TEXT NOT NULL, 
	host_spec_range INTEGER NOT NULL, 
	trophic_level VARCHAR(22), 
	samp_size TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT NOT NULL, 
	pcr_primers TEXT NOT NULL, 
	nucl_acid_ext TEXT NOT NULL, 
	nucl_acid_amp TEXT NOT NULL, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER NOT NULL, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT NOT NULL, 
	lib_screen TEXT NOT NULL, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT NOT NULL, 
	mid TEXT NOT NULL, 
	adapters TEXT NOT NULL, 
	pcr_cond TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT NOT NULL, 
	assembly_name TEXT NOT NULL, 
	assembly_software TEXT, 
	annot TEXT, 
	sop TEXT, 
	source_mat_id TEXT, 
	samp_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	PRIMARY KEY (lat_lon, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, plant_growth_med, soil_horizon, photosynt_activ, photosynt_activ_meth, samp_collect_method, enrichment_protocol, library_prep_kit, sequencing_location, "temp", "soil_pH", soil_conductivity, rel_location, soil_cover, porosity, texture, texture_meth, host_symbiont, pres_animal_insect, plant_water_method, anim_water_method, farm_water_source, water_source_shared, "water_pH", season, solar_irradiance, crop_yield, season_humidity, humidity, adjacent_environment, chem_administration, food_prod, lot_number, fertilizer_admin, samp_stor_temp, food_trav_mode, food_trav_vehic, farm_equip_san, farm_equip, farm_equip_shared, food_harvest_proc, plant_struc, host_dry_mass, ances_data, genetic_mod, "Food_Product_type", "Food_source", spikein_strain, organism_count, size_frac_low, size_frac_up, cult_isol_date, samp_pooling, root_med_macronutr, root_med_carbon, root_med_ph, depth, water_temp_regm, watering_regm, standing_water_regm, gaseous_environment, fungicide_regm, climate_environment, herbicide_regm, non_mineral_nutr_regm, pesticide_regm, ph_regm, salt_regm, season_environment, perturbation, samp_store_dur, samp_store_loc, samp_collect_device, host_age, host_common_name, host_genotype, host_height, host_subspecf_genlin, host_length, host_life_stage, host_phenotype, host_taxid, host_tot_mass, plant_product, oxy_stat_samp, assembly_quality, url, fao_class, local_class, local_class_meth, soil_type, soil_type_meth, horizon, horizon_meth, link_class_info, previous_land_use, previous_land_use_meth, crop_rotation, agrochem_addition, tillage, fire, flooding, extreme_event, link_climate_info, annual_temp, season_temp, annual_precpt, season_precpt, cur_land_use, slope_gradient, slope_aspect, profile_position, drainage_class, store_cond, ph_meth, cur_vegetation, cur_vegetation_meth, tot_org_carb, tot_org_c_meth, tot_nitro, tot_n_meth, microbial_biomass, microbial_biomass_meth, heavy_metals_meth, tot_car, tot_phos, sieving, pool_dna_extracts, misc_param, host_disease_stat, specific_host, pathogenicity, biotic_relationship, isol_growth_condt, samp_mat_process, host_spec_range, trophic_level, samp_size, seq_meth, samp_vol_we_dna_ext, pcr_primers, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, mid, adapters, pcr_cond, seq_quality_check, chimera_check, assembly_name, assembly_software, annot, sop, source_mat_id, samp_name, samp_taxon_id, project_name, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, estimated_size, ref_biomaterial, samp_collec_device, samp_collec_method, tax_ident, assembly_qual, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource)
);

CREATE TABLE "agriculture_MIGS_plant" (
	lat_lon TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	plant_growth_med VARCHAR(30), 
	soil_horizon VARCHAR(10), 
	photosynt_activ TEXT, 
	photosynt_activ_meth TEXT, 
	samp_collect_method TEXT, 
	enrichment_protocol TEXT, 
	library_prep_kit TEXT, 
	sequencing_location TEXT, 
	"temp" TEXT, 
	"soil_pH" FLOAT, 
	soil_conductivity TEXT, 
	rel_location TEXT, 
	soil_cover TEXT, 
	porosity TEXT, 
	texture TEXT, 
	texture_meth TEXT, 
	host_symbiont TEXT, 
	pres_animal_insect TEXT, 
	plant_water_method TEXT, 
	anim_water_method TEXT, 
	farm_water_source VARCHAR(19), 
	water_source_shared VARCHAR(27), 
	"water_pH" FLOAT, 
	season TEXT, 
	solar_irradiance TEXT, 
	crop_yield TEXT, 
	season_humidity TEXT, 
	humidity TEXT, 
	adjacent_environment TEXT, 
	chem_administration TEXT NOT NULL, 
	food_prod TEXT, 
	lot_number TEXT, 
	fertilizer_admin TEXT, 
	samp_stor_temp TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	farm_equip_san TEXT, 
	farm_equip TEXT, 
	farm_equip_shared TEXT, 
	food_harvest_proc TEXT, 
	plant_struc TEXT, 
	host_dry_mass TEXT, 
	ances_data TEXT, 
	genetic_mod TEXT, 
	"Food_Product_type" TEXT, 
	"Food_source" TEXT NOT NULL, 
	spikein_strain TEXT, 
	organism_count VARCHAR(5), 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	cult_isol_date DATE, 
	samp_pooling TEXT, 
	root_med_macronutr TEXT, 
	root_med_carbon TEXT, 
	root_med_ph FLOAT, 
	depth TEXT NOT NULL, 
	water_temp_regm TEXT, 
	watering_regm TEXT, 
	standing_water_regm TEXT, 
	gaseous_environment TEXT, 
	fungicide_regm TEXT, 
	climate_environment TEXT, 
	herbicide_regm TEXT, 
	non_mineral_nutr_regm TEXT, 
	pesticide_regm TEXT, 
	ph_regm TEXT, 
	salt_regm TEXT, 
	season_environment TEXT, 
	perturbation TEXT, 
	samp_store_dur TEXT NOT NULL, 
	samp_store_loc TEXT NOT NULL, 
	samp_collect_device TEXT NOT NULL, 
	host_age TEXT NOT NULL, 
	host_common_name TEXT NOT NULL, 
	host_genotype TEXT NOT NULL, 
	host_height TEXT NOT NULL, 
	host_subspecf_genlin TEXT, 
	host_length TEXT NOT NULL, 
	host_life_stage TEXT NOT NULL, 
	host_phenotype TEXT NOT NULL, 
	host_taxid TEXT NOT NULL, 
	host_tot_mass TEXT NOT NULL, 
	plant_product TEXT, 
	oxy_stat_samp VARCHAR(9), 
	assembly_quality TEXT, 
	url TEXT, 
	fao_class VARCHAR(13), 
	local_class TEXT, 
	local_class_meth TEXT, 
	soil_type TEXT NOT NULL, 
	soil_type_meth TEXT NOT NULL, 
	horizon VARCHAR(10), 
	horizon_meth TEXT, 
	link_class_info TEXT, 
	previous_land_use TEXT, 
	previous_land_use_meth TEXT, 
	crop_rotation TEXT, 
	agrochem_addition TEXT, 
	tillage VARCHAR(13), 
	fire DATE, 
	flooding DATE, 
	extreme_event DATE, 
	link_climate_info TEXT, 
	annual_temp TEXT, 
	season_temp TEXT, 
	annual_precpt TEXT, 
	season_precpt TEXT, 
	cur_land_use VARCHAR(93), 
	slope_gradient TEXT, 
	slope_aspect TEXT, 
	profile_position VARCHAR(9), 
	drainage_class VARCHAR(19), 
	store_cond TEXT NOT NULL, 
	ph_meth TEXT, 
	cur_vegetation TEXT, 
	cur_vegetation_meth TEXT, 
	tot_org_carb TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro TEXT, 
	tot_n_meth TEXT, 
	microbial_biomass TEXT NOT NULL, 
	microbial_biomass_meth TEXT NOT NULL, 
	heavy_metals_meth TEXT, 
	tot_car TEXT, 
	tot_phos TEXT, 
	sieving TEXT NOT NULL, 
	pool_dna_extracts TEXT NOT NULL, 
	misc_param TEXT, 
	host_disease_stat TEXT, 
	specific_host TEXT NOT NULL, 
	pathogenicity TEXT NOT NULL, 
	biotic_relationship VARCHAR(11), 
	isol_growth_condt TEXT, 
	samp_mat_process TEXT NOT NULL, 
	host_spec_range INTEGER NOT NULL, 
	trophic_level VARCHAR(22), 
	samp_size TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT NOT NULL, 
	pcr_primers TEXT NOT NULL, 
	nucl_acid_ext TEXT NOT NULL, 
	nucl_acid_amp TEXT NOT NULL, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER NOT NULL, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT NOT NULL, 
	lib_screen TEXT NOT NULL, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT NOT NULL, 
	mid TEXT NOT NULL, 
	adapters TEXT NOT NULL, 
	pcr_cond TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT NOT NULL, 
	assembly_name TEXT NOT NULL, 
	assembly_software TEXT, 
	annot TEXT, 
	sop TEXT, 
	source_mat_id TEXT, 
	samp_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	PRIMARY KEY (lat_lon, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, plant_growth_med, soil_horizon, photosynt_activ, photosynt_activ_meth, samp_collect_method, enrichment_protocol, library_prep_kit, sequencing_location, "temp", "soil_pH", soil_conductivity, rel_location, soil_cover, porosity, texture, texture_meth, host_symbiont, pres_animal_insect, plant_water_method, anim_water_method, farm_water_source, water_source_shared, "water_pH", season, solar_irradiance, crop_yield, season_humidity, humidity, adjacent_environment, chem_administration, food_prod, lot_number, fertilizer_admin, samp_stor_temp, food_trav_mode, food_trav_vehic, farm_equip_san, farm_equip, farm_equip_shared, food_harvest_proc, plant_struc, host_dry_mass, ances_data, genetic_mod, "Food_Product_type", "Food_source", spikein_strain, organism_count, size_frac_low, size_frac_up, cult_isol_date, samp_pooling, root_med_macronutr, root_med_carbon, root_med_ph, depth, water_temp_regm, watering_regm, standing_water_regm, gaseous_environment, fungicide_regm, climate_environment, herbicide_regm, non_mineral_nutr_regm, pesticide_regm, ph_regm, salt_regm, season_environment, perturbation, samp_store_dur, samp_store_loc, samp_collect_device, host_age, host_common_name, host_genotype, host_height, host_subspecf_genlin, host_length, host_life_stage, host_phenotype, host_taxid, host_tot_mass, plant_product, oxy_stat_samp, assembly_quality, url, fao_class, local_class, local_class_meth, soil_type, soil_type_meth, horizon, horizon_meth, link_class_info, previous_land_use, previous_land_use_meth, crop_rotation, agrochem_addition, tillage, fire, flooding, extreme_event, link_climate_info, annual_temp, season_temp, annual_precpt, season_precpt, cur_land_use, slope_gradient, slope_aspect, profile_position, drainage_class, store_cond, ph_meth, cur_vegetation, cur_vegetation_meth, tot_org_carb, tot_org_c_meth, tot_nitro, tot_n_meth, microbial_biomass, microbial_biomass_meth, heavy_metals_meth, tot_car, tot_phos, sieving, pool_dna_extracts, misc_param, host_disease_stat, specific_host, pathogenicity, biotic_relationship, isol_growth_condt, samp_mat_process, host_spec_range, trophic_level, samp_size, seq_meth, samp_vol_we_dna_ext, pcr_primers, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, mid, adapters, pcr_cond, seq_quality_check, chimera_check, assembly_name, assembly_software, annot, sop, source_mat_id, samp_name, samp_taxon_id, project_name, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, estimated_size, ref_biomaterial, propagation, encoded_traits, samp_collec_device, samp_collec_method, tax_ident, assembly_qual, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource)
);

CREATE TABLE "agriculture_MIGS_virus" (
	lat_lon TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	plant_growth_med VARCHAR(30), 
	soil_horizon VARCHAR(10), 
	photosynt_activ TEXT, 
	photosynt_activ_meth TEXT, 
	samp_collect_method TEXT, 
	enrichment_protocol TEXT, 
	library_prep_kit TEXT, 
	sequencing_location TEXT, 
	"temp" TEXT, 
	"soil_pH" FLOAT, 
	soil_conductivity TEXT, 
	rel_location TEXT, 
	soil_cover TEXT, 
	porosity TEXT, 
	texture TEXT, 
	texture_meth TEXT, 
	host_symbiont TEXT, 
	pres_animal_insect TEXT, 
	plant_water_method TEXT, 
	anim_water_method TEXT, 
	farm_water_source VARCHAR(19), 
	water_source_shared VARCHAR(27), 
	"water_pH" FLOAT, 
	season TEXT, 
	solar_irradiance TEXT, 
	crop_yield TEXT, 
	season_humidity TEXT, 
	humidity TEXT, 
	adjacent_environment TEXT, 
	chem_administration TEXT NOT NULL, 
	food_prod TEXT, 
	lot_number TEXT, 
	fertilizer_admin TEXT, 
	samp_stor_temp TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	farm_equip_san TEXT, 
	farm_equip TEXT, 
	farm_equip_shared TEXT, 
	food_harvest_proc TEXT, 
	plant_struc TEXT, 
	host_dry_mass TEXT, 
	ances_data TEXT, 
	genetic_mod TEXT, 
	"Food_Product_type" TEXT, 
	"Food_source" TEXT NOT NULL, 
	spikein_strain TEXT, 
	organism_count VARCHAR(5), 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	cult_isol_date DATE, 
	samp_pooling TEXT, 
	root_med_macronutr TEXT, 
	root_med_carbon TEXT, 
	root_med_ph FLOAT, 
	depth TEXT NOT NULL, 
	water_temp_regm TEXT, 
	watering_regm TEXT, 
	standing_water_regm TEXT, 
	gaseous_environment TEXT, 
	fungicide_regm TEXT, 
	climate_environment TEXT, 
	herbicide_regm TEXT, 
	non_mineral_nutr_regm TEXT, 
	pesticide_regm TEXT, 
	ph_regm TEXT, 
	salt_regm TEXT, 
	season_environment TEXT, 
	perturbation TEXT, 
	samp_store_dur TEXT NOT NULL, 
	samp_store_loc TEXT NOT NULL, 
	samp_collect_device TEXT NOT NULL, 
	host_age TEXT NOT NULL, 
	host_common_name TEXT NOT NULL, 
	host_genotype TEXT NOT NULL, 
	host_height TEXT NOT NULL, 
	host_subspecf_genlin TEXT, 
	host_length TEXT NOT NULL, 
	host_life_stage TEXT NOT NULL, 
	host_phenotype TEXT NOT NULL, 
	host_taxid TEXT NOT NULL, 
	host_tot_mass TEXT NOT NULL, 
	plant_product TEXT, 
	oxy_stat_samp VARCHAR(9), 
	assembly_quality TEXT, 
	url TEXT, 
	fao_class VARCHAR(13), 
	local_class TEXT, 
	local_class_meth TEXT, 
	soil_type TEXT NOT NULL, 
	soil_type_meth TEXT NOT NULL, 
	horizon VARCHAR(10), 
	horizon_meth TEXT, 
	link_class_info TEXT, 
	previous_land_use TEXT, 
	previous_land_use_meth TEXT, 
	crop_rotation TEXT, 
	agrochem_addition TEXT, 
	tillage VARCHAR(13), 
	fire DATE, 
	flooding DATE, 
	extreme_event DATE, 
	link_climate_info TEXT, 
	annual_temp TEXT, 
	season_temp TEXT, 
	annual_precpt TEXT, 
	season_precpt TEXT, 
	cur_land_use VARCHAR(93), 
	slope_gradient TEXT, 
	slope_aspect TEXT, 
	profile_position VARCHAR(9), 
	drainage_class VARCHAR(19), 
	store_cond TEXT NOT NULL, 
	ph_meth TEXT, 
	cur_vegetation TEXT, 
	cur_vegetation_meth TEXT, 
	tot_org_carb TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro TEXT, 
	tot_n_meth TEXT, 
	microbial_biomass TEXT NOT NULL, 
	microbial_biomass_meth TEXT NOT NULL, 
	heavy_metals_meth TEXT, 
	tot_car TEXT, 
	tot_phos TEXT, 
	sieving TEXT NOT NULL, 
	pool_dna_extracts TEXT NOT NULL, 
	misc_param TEXT, 
	host_disease_stat TEXT, 
	specific_host TEXT NOT NULL, 
	pathogenicity TEXT NOT NULL, 
	biotic_relationship VARCHAR(11), 
	isol_growth_condt TEXT, 
	samp_mat_process TEXT NOT NULL, 
	host_spec_range INTEGER NOT NULL, 
	trophic_level VARCHAR(22), 
	samp_size TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT NOT NULL, 
	pcr_primers TEXT NOT NULL, 
	nucl_acid_ext TEXT NOT NULL, 
	nucl_acid_amp TEXT NOT NULL, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER NOT NULL, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT NOT NULL, 
	lib_screen TEXT NOT NULL, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT NOT NULL, 
	mid TEXT NOT NULL, 
	adapters TEXT NOT NULL, 
	pcr_cond TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT NOT NULL, 
	assembly_name TEXT NOT NULL, 
	assembly_software TEXT, 
	annot TEXT, 
	sop TEXT, 
	source_mat_id TEXT, 
	samp_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	virus_enrich_appr VARCHAR(25), 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	PRIMARY KEY (lat_lon, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, plant_growth_med, soil_horizon, photosynt_activ, photosynt_activ_meth, samp_collect_method, enrichment_protocol, library_prep_kit, sequencing_location, "temp", "soil_pH", soil_conductivity, rel_location, soil_cover, porosity, texture, texture_meth, host_symbiont, pres_animal_insect, plant_water_method, anim_water_method, farm_water_source, water_source_shared, "water_pH", season, solar_irradiance, crop_yield, season_humidity, humidity, adjacent_environment, chem_administration, food_prod, lot_number, fertilizer_admin, samp_stor_temp, food_trav_mode, food_trav_vehic, farm_equip_san, farm_equip, farm_equip_shared, food_harvest_proc, plant_struc, host_dry_mass, ances_data, genetic_mod, "Food_Product_type", "Food_source", spikein_strain, organism_count, size_frac_low, size_frac_up, cult_isol_date, samp_pooling, root_med_macronutr, root_med_carbon, root_med_ph, depth, water_temp_regm, watering_regm, standing_water_regm, gaseous_environment, fungicide_regm, climate_environment, herbicide_regm, non_mineral_nutr_regm, pesticide_regm, ph_regm, salt_regm, season_environment, perturbation, samp_store_dur, samp_store_loc, samp_collect_device, host_age, host_common_name, host_genotype, host_height, host_subspecf_genlin, host_length, host_life_stage, host_phenotype, host_taxid, host_tot_mass, plant_product, oxy_stat_samp, assembly_quality, url, fao_class, local_class, local_class_meth, soil_type, soil_type_meth, horizon, horizon_meth, link_class_info, previous_land_use, previous_land_use_meth, crop_rotation, agrochem_addition, tillage, fire, flooding, extreme_event, link_climate_info, annual_temp, season_temp, annual_precpt, season_precpt, cur_land_use, slope_gradient, slope_aspect, profile_position, drainage_class, store_cond, ph_meth, cur_vegetation, cur_vegetation_meth, tot_org_carb, tot_org_c_meth, tot_nitro, tot_n_meth, microbial_biomass, microbial_biomass_meth, heavy_metals_meth, tot_car, tot_phos, sieving, pool_dna_extracts, misc_param, host_disease_stat, specific_host, pathogenicity, biotic_relationship, isol_growth_condt, samp_mat_process, host_spec_range, trophic_level, samp_size, seq_meth, samp_vol_we_dna_ext, pcr_primers, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, mid, adapters, pcr_cond, seq_quality_check, chimera_check, assembly_name, assembly_software, annot, sop, source_mat_id, samp_name, samp_taxon_id, project_name, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, estimated_size, ref_biomaterial, propagation, encoded_traits, samp_collec_device, samp_collec_method, virus_enrich_appr, tax_ident, assembly_qual, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource)
);

CREATE TABLE "agriculture_MIMAG" (
	lat_lon TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	plant_growth_med VARCHAR(30), 
	soil_horizon VARCHAR(10), 
	photosynt_activ TEXT, 
	photosynt_activ_meth TEXT, 
	samp_collect_method TEXT, 
	enrichment_protocol TEXT, 
	library_prep_kit TEXT, 
	sequencing_location TEXT, 
	"temp" TEXT, 
	"soil_pH" FLOAT, 
	soil_conductivity TEXT, 
	rel_location TEXT, 
	soil_cover TEXT, 
	porosity TEXT, 
	texture TEXT, 
	texture_meth TEXT, 
	host_symbiont TEXT, 
	pres_animal_insect TEXT, 
	plant_water_method TEXT, 
	anim_water_method TEXT, 
	farm_water_source VARCHAR(19), 
	water_source_shared VARCHAR(27), 
	"water_pH" FLOAT, 
	season TEXT, 
	solar_irradiance TEXT, 
	crop_yield TEXT, 
	season_humidity TEXT, 
	humidity TEXT, 
	adjacent_environment TEXT, 
	chem_administration TEXT NOT NULL, 
	food_prod TEXT, 
	lot_number TEXT, 
	fertilizer_admin TEXT, 
	samp_stor_temp TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	farm_equip_san TEXT, 
	farm_equip TEXT, 
	farm_equip_shared TEXT, 
	food_harvest_proc TEXT, 
	plant_struc TEXT, 
	host_dry_mass TEXT, 
	ances_data TEXT, 
	genetic_mod TEXT, 
	"Food_Product_type" TEXT, 
	"Food_source" TEXT NOT NULL, 
	spikein_strain TEXT, 
	organism_count VARCHAR(5), 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	cult_isol_date DATE, 
	samp_pooling TEXT, 
	root_med_macronutr TEXT, 
	root_med_carbon TEXT, 
	root_med_ph FLOAT, 
	depth TEXT NOT NULL, 
	water_temp_regm TEXT, 
	watering_regm TEXT, 
	standing_water_regm TEXT, 
	gaseous_environment TEXT, 
	fungicide_regm TEXT, 
	climate_environment TEXT, 
	herbicide_regm TEXT, 
	non_mineral_nutr_regm TEXT, 
	pesticide_regm TEXT, 
	ph_regm TEXT, 
	salt_regm TEXT, 
	season_environment TEXT, 
	perturbation TEXT, 
	samp_store_dur TEXT NOT NULL, 
	samp_store_loc TEXT NOT NULL, 
	samp_collect_device TEXT NOT NULL, 
	host_age TEXT NOT NULL, 
	host_common_name TEXT NOT NULL, 
	host_genotype TEXT NOT NULL, 
	host_height TEXT NOT NULL, 
	host_subspecf_genlin TEXT, 
	host_length TEXT NOT NULL, 
	host_life_stage TEXT NOT NULL, 
	host_phenotype TEXT NOT NULL, 
	host_taxid TEXT NOT NULL, 
	host_tot_mass TEXT NOT NULL, 
	plant_product TEXT, 
	oxy_stat_samp VARCHAR(9), 
	assembly_quality TEXT, 
	url TEXT, 
	fao_class VARCHAR(13), 
	local_class TEXT, 
	local_class_meth TEXT, 
	soil_type TEXT NOT NULL, 
	soil_type_meth TEXT NOT NULL, 
	horizon VARCHAR(10), 
	horizon_meth TEXT, 
	link_class_info TEXT, 
	previous_land_use TEXT, 
	previous_land_use_meth TEXT, 
	crop_rotation TEXT, 
	agrochem_addition TEXT, 
	tillage VARCHAR(13), 
	fire DATE, 
	flooding DATE, 
	extreme_event DATE, 
	link_climate_info TEXT, 
	annual_temp TEXT, 
	season_temp TEXT, 
	annual_precpt TEXT, 
	season_precpt TEXT, 
	cur_land_use VARCHAR(93), 
	slope_gradient TEXT, 
	slope_aspect TEXT, 
	profile_position VARCHAR(9), 
	drainage_class VARCHAR(19), 
	store_cond TEXT NOT NULL, 
	ph_meth TEXT, 
	cur_vegetation TEXT, 
	cur_vegetation_meth TEXT, 
	tot_org_carb TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro TEXT, 
	tot_n_meth TEXT, 
	microbial_biomass TEXT NOT NULL, 
	microbial_biomass_meth TEXT NOT NULL, 
	heavy_metals_meth TEXT, 
	tot_car TEXT, 
	tot_phos TEXT, 
	sieving TEXT NOT NULL, 
	pool_dna_extracts TEXT NOT NULL, 
	misc_param TEXT, 
	host_disease_stat TEXT, 
	specific_host TEXT NOT NULL, 
	pathogenicity TEXT NOT NULL, 
	biotic_relationship VARCHAR(11), 
	isol_growth_condt TEXT, 
	samp_mat_process TEXT NOT NULL, 
	host_spec_range INTEGER NOT NULL, 
	trophic_level VARCHAR(22), 
	samp_size TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT NOT NULL, 
	pcr_primers TEXT NOT NULL, 
	nucl_acid_ext TEXT NOT NULL, 
	nucl_acid_amp TEXT NOT NULL, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER NOT NULL, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT NOT NULL, 
	lib_screen TEXT NOT NULL, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT NOT NULL, 
	mid TEXT NOT NULL, 
	adapters TEXT NOT NULL, 
	pcr_cond TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT NOT NULL, 
	assembly_name TEXT NOT NULL, 
	assembly_software TEXT, 
	annot TEXT, 
	sop TEXT, 
	source_mat_id TEXT, 
	samp_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	size_frac TEXT, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	bin_param VARCHAR(15) NOT NULL, 
	bin_software TEXT NOT NULL, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	associated_resource TEXT, 
	PRIMARY KEY (lat_lon, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, plant_growth_med, soil_horizon, photosynt_activ, photosynt_activ_meth, samp_collect_method, enrichment_protocol, library_prep_kit, sequencing_location, "temp", "soil_pH", soil_conductivity, rel_location, soil_cover, porosity, texture, texture_meth, host_symbiont, pres_animal_insect, plant_water_method, anim_water_method, farm_water_source, water_source_shared, "water_pH", season, solar_irradiance, crop_yield, season_humidity, humidity, adjacent_environment, chem_administration, food_prod, lot_number, fertilizer_admin, samp_stor_temp, food_trav_mode, food_trav_vehic, farm_equip_san, farm_equip, farm_equip_shared, food_harvest_proc, plant_struc, host_dry_mass, ances_data, genetic_mod, "Food_Product_type", "Food_source", spikein_strain, organism_count, size_frac_low, size_frac_up, cult_isol_date, samp_pooling, root_med_macronutr, root_med_carbon, root_med_ph, depth, water_temp_regm, watering_regm, standing_water_regm, gaseous_environment, fungicide_regm, climate_environment, herbicide_regm, non_mineral_nutr_regm, pesticide_regm, ph_regm, salt_regm, season_environment, perturbation, samp_store_dur, samp_store_loc, samp_collect_device, host_age, host_common_name, host_genotype, host_height, host_subspecf_genlin, host_length, host_life_stage, host_phenotype, host_taxid, host_tot_mass, plant_product, oxy_stat_samp, assembly_quality, url, fao_class, local_class, local_class_meth, soil_type, soil_type_meth, horizon, horizon_meth, link_class_info, previous_land_use, previous_land_use_meth, crop_rotation, agrochem_addition, tillage, fire, flooding, extreme_event, link_climate_info, annual_temp, season_temp, annual_precpt, season_precpt, cur_land_use, slope_gradient, slope_aspect, profile_position, drainage_class, store_cond, ph_meth, cur_vegetation, cur_vegetation_meth, tot_org_carb, tot_org_c_meth, tot_nitro, tot_n_meth, microbial_biomass, microbial_biomass_meth, heavy_metals_meth, tot_car, tot_phos, sieving, pool_dna_extracts, misc_param, host_disease_stat, specific_host, pathogenicity, biotic_relationship, isol_growth_condt, samp_mat_process, host_spec_range, trophic_level, samp_size, seq_meth, samp_vol_we_dna_ext, pcr_primers, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, mid, adapters, pcr_cond, seq_quality_check, chimera_check, assembly_name, assembly_software, annot, sop, source_mat_id, samp_name, samp_taxon_id, project_name, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, rel_to_oxygen, samp_collec_device, samp_collec_method, size_frac, tax_ident, assembly_qual, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, bin_param, bin_software, reassembly_bin, mag_cov_software, associated_resource)
);

CREATE TABLE "agriculture_MIMARKS_specimen" (
	lat_lon TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	plant_growth_med VARCHAR(30), 
	soil_horizon VARCHAR(10), 
	photosynt_activ TEXT, 
	photosynt_activ_meth TEXT, 
	samp_collect_method TEXT, 
	enrichment_protocol TEXT, 
	library_prep_kit TEXT, 
	sequencing_location TEXT, 
	"temp" TEXT, 
	"soil_pH" FLOAT, 
	soil_conductivity TEXT, 
	rel_location TEXT, 
	soil_cover TEXT, 
	porosity TEXT, 
	texture TEXT, 
	texture_meth TEXT, 
	host_symbiont TEXT, 
	pres_animal_insect TEXT, 
	plant_water_method TEXT, 
	anim_water_method TEXT, 
	farm_water_source VARCHAR(19), 
	water_source_shared VARCHAR(27), 
	"water_pH" FLOAT, 
	season TEXT, 
	solar_irradiance TEXT, 
	crop_yield TEXT, 
	season_humidity TEXT, 
	humidity TEXT, 
	adjacent_environment TEXT, 
	chem_administration TEXT NOT NULL, 
	food_prod TEXT, 
	lot_number TEXT, 
	fertilizer_admin TEXT, 
	samp_stor_temp TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	farm_equip_san TEXT, 
	farm_equip TEXT, 
	farm_equip_shared TEXT, 
	food_harvest_proc TEXT, 
	plant_struc TEXT, 
	host_dry_mass TEXT, 
	ances_data TEXT, 
	genetic_mod TEXT, 
	"Food_Product_type" TEXT, 
	"Food_source" TEXT NOT NULL, 
	spikein_strain TEXT, 
	organism_count VARCHAR(5), 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	cult_isol_date DATE, 
	samp_pooling TEXT, 
	root_med_macronutr TEXT, 
	root_med_carbon TEXT, 
	root_med_ph FLOAT, 
	depth TEXT NOT NULL, 
	water_temp_regm TEXT, 
	watering_regm TEXT, 
	standing_water_regm TEXT, 
	gaseous_environment TEXT, 
	fungicide_regm TEXT, 
	climate_environment TEXT, 
	herbicide_regm TEXT, 
	non_mineral_nutr_regm TEXT, 
	pesticide_regm TEXT, 
	ph_regm TEXT, 
	salt_regm TEXT, 
	season_environment TEXT, 
	perturbation TEXT, 
	samp_store_dur TEXT NOT NULL, 
	samp_store_loc TEXT NOT NULL, 
	samp_collect_device TEXT NOT NULL, 
	host_age TEXT NOT NULL, 
	host_common_name TEXT NOT NULL, 
	host_genotype TEXT NOT NULL, 
	host_height TEXT NOT NULL, 
	host_subspecf_genlin TEXT, 
	host_length TEXT NOT NULL, 
	host_life_stage TEXT NOT NULL, 
	host_phenotype TEXT NOT NULL, 
	host_taxid TEXT NOT NULL, 
	host_tot_mass TEXT NOT NULL, 
	plant_product TEXT, 
	oxy_stat_samp VARCHAR(9), 
	assembly_quality TEXT, 
	url TEXT, 
	fao_class VARCHAR(13), 
	local_class TEXT, 
	local_class_meth TEXT, 
	soil_type TEXT NOT NULL, 
	soil_type_meth TEXT NOT NULL, 
	horizon VARCHAR(10), 
	horizon_meth TEXT, 
	link_class_info TEXT, 
	previous_land_use TEXT, 
	previous_land_use_meth TEXT, 
	crop_rotation TEXT, 
	agrochem_addition TEXT, 
	tillage VARCHAR(13), 
	fire DATE, 
	flooding DATE, 
	extreme_event DATE, 
	link_climate_info TEXT, 
	annual_temp TEXT, 
	season_temp TEXT, 
	annual_precpt TEXT, 
	season_precpt TEXT, 
	cur_land_use VARCHAR(93), 
	slope_gradient TEXT, 
	slope_aspect TEXT, 
	profile_position VARCHAR(9), 
	drainage_class VARCHAR(19), 
	store_cond TEXT NOT NULL, 
	ph_meth TEXT, 
	cur_vegetation TEXT, 
	cur_vegetation_meth TEXT, 
	tot_org_carb TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro TEXT, 
	tot_n_meth TEXT, 
	microbial_biomass TEXT NOT NULL, 
	microbial_biomass_meth TEXT NOT NULL, 
	heavy_metals_meth TEXT, 
	tot_car TEXT, 
	tot_phos TEXT, 
	sieving TEXT NOT NULL, 
	pool_dna_extracts TEXT NOT NULL, 
	misc_param TEXT, 
	host_disease_stat TEXT, 
	specific_host TEXT NOT NULL, 
	pathogenicity TEXT NOT NULL, 
	biotic_relationship VARCHAR(11), 
	isol_growth_condt TEXT, 
	samp_mat_process TEXT NOT NULL, 
	host_spec_range INTEGER NOT NULL, 
	trophic_level VARCHAR(22), 
	samp_size TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT NOT NULL, 
	pcr_primers TEXT NOT NULL, 
	nucl_acid_ext TEXT NOT NULL, 
	nucl_acid_amp TEXT NOT NULL, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER NOT NULL, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT NOT NULL, 
	lib_screen TEXT NOT NULL, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT NOT NULL, 
	mid TEXT NOT NULL, 
	adapters TEXT NOT NULL, 
	pcr_cond TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT NOT NULL, 
	assembly_name TEXT NOT NULL, 
	assembly_software TEXT, 
	annot TEXT, 
	sop TEXT, 
	source_mat_id TEXT, 
	samp_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	size_frac TEXT, 
	associated_resource TEXT, 
	PRIMARY KEY (lat_lon, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, plant_growth_med, soil_horizon, photosynt_activ, photosynt_activ_meth, samp_collect_method, enrichment_protocol, library_prep_kit, sequencing_location, "temp", "soil_pH", soil_conductivity, rel_location, soil_cover, porosity, texture, texture_meth, host_symbiont, pres_animal_insect, plant_water_method, anim_water_method, farm_water_source, water_source_shared, "water_pH", season, solar_irradiance, crop_yield, season_humidity, humidity, adjacent_environment, chem_administration, food_prod, lot_number, fertilizer_admin, samp_stor_temp, food_trav_mode, food_trav_vehic, farm_equip_san, farm_equip, farm_equip_shared, food_harvest_proc, plant_struc, host_dry_mass, ances_data, genetic_mod, "Food_Product_type", "Food_source", spikein_strain, organism_count, size_frac_low, size_frac_up, cult_isol_date, samp_pooling, root_med_macronutr, root_med_carbon, root_med_ph, depth, water_temp_regm, watering_regm, standing_water_regm, gaseous_environment, fungicide_regm, climate_environment, herbicide_regm, non_mineral_nutr_regm, pesticide_regm, ph_regm, salt_regm, season_environment, perturbation, samp_store_dur, samp_store_loc, samp_collect_device, host_age, host_common_name, host_genotype, host_height, host_subspecf_genlin, host_length, host_life_stage, host_phenotype, host_taxid, host_tot_mass, plant_product, oxy_stat_samp, assembly_quality, url, fao_class, local_class, local_class_meth, soil_type, soil_type_meth, horizon, horizon_meth, link_class_info, previous_land_use, previous_land_use_meth, crop_rotation, agrochem_addition, tillage, fire, flooding, extreme_event, link_climate_info, annual_temp, season_temp, annual_precpt, season_precpt, cur_land_use, slope_gradient, slope_aspect, profile_position, drainage_class, store_cond, ph_meth, cur_vegetation, cur_vegetation_meth, tot_org_carb, tot_org_c_meth, tot_nitro, tot_n_meth, microbial_biomass, microbial_biomass_meth, heavy_metals_meth, tot_car, tot_phos, sieving, pool_dna_extracts, misc_param, host_disease_stat, specific_host, pathogenicity, biotic_relationship, isol_growth_condt, samp_mat_process, host_spec_range, trophic_level, samp_size, seq_meth, samp_vol_we_dna_ext, pcr_primers, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, mid, adapters, pcr_cond, seq_quality_check, chimera_check, assembly_name, assembly_software, annot, sop, source_mat_id, samp_name, samp_taxon_id, project_name, experimental_factor, neg_cont_type, pos_cont_type, rel_to_oxygen, samp_collec_device, samp_collec_method, size_frac, associated_resource)
);

CREATE TABLE "agriculture_MIMARKS_survey" (
	lat_lon TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	plant_growth_med VARCHAR(30), 
	soil_horizon VARCHAR(10), 
	photosynt_activ TEXT, 
	photosynt_activ_meth TEXT, 
	samp_collect_method TEXT, 
	enrichment_protocol TEXT, 
	library_prep_kit TEXT, 
	sequencing_location TEXT, 
	"temp" TEXT, 
	"soil_pH" FLOAT, 
	soil_conductivity TEXT, 
	rel_location TEXT, 
	soil_cover TEXT, 
	porosity TEXT, 
	texture TEXT, 
	texture_meth TEXT, 
	host_symbiont TEXT, 
	pres_animal_insect TEXT, 
	plant_water_method TEXT, 
	anim_water_method TEXT, 
	farm_water_source VARCHAR(19), 
	water_source_shared VARCHAR(27), 
	"water_pH" FLOAT, 
	season TEXT, 
	solar_irradiance TEXT, 
	crop_yield TEXT, 
	season_humidity TEXT, 
	humidity TEXT, 
	adjacent_environment TEXT, 
	chem_administration TEXT NOT NULL, 
	food_prod TEXT, 
	lot_number TEXT, 
	fertilizer_admin TEXT, 
	samp_stor_temp TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	farm_equip_san TEXT, 
	farm_equip TEXT, 
	farm_equip_shared TEXT, 
	food_harvest_proc TEXT, 
	plant_struc TEXT, 
	host_dry_mass TEXT, 
	ances_data TEXT, 
	genetic_mod TEXT, 
	"Food_Product_type" TEXT, 
	"Food_source" TEXT NOT NULL, 
	spikein_strain TEXT, 
	organism_count VARCHAR(5), 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	cult_isol_date DATE, 
	samp_pooling TEXT, 
	root_med_macronutr TEXT, 
	root_med_carbon TEXT, 
	root_med_ph FLOAT, 
	depth TEXT NOT NULL, 
	water_temp_regm TEXT, 
	watering_regm TEXT, 
	standing_water_regm TEXT, 
	gaseous_environment TEXT, 
	fungicide_regm TEXT, 
	climate_environment TEXT, 
	herbicide_regm TEXT, 
	non_mineral_nutr_regm TEXT, 
	pesticide_regm TEXT, 
	ph_regm TEXT, 
	salt_regm TEXT, 
	season_environment TEXT, 
	perturbation TEXT, 
	samp_store_dur TEXT NOT NULL, 
	samp_store_loc TEXT NOT NULL, 
	samp_collect_device TEXT NOT NULL, 
	host_age TEXT NOT NULL, 
	host_common_name TEXT NOT NULL, 
	host_genotype TEXT NOT NULL, 
	host_height TEXT NOT NULL, 
	host_subspecf_genlin TEXT, 
	host_length TEXT NOT NULL, 
	host_life_stage TEXT NOT NULL, 
	host_phenotype TEXT NOT NULL, 
	host_taxid TEXT NOT NULL, 
	host_tot_mass TEXT NOT NULL, 
	plant_product TEXT, 
	oxy_stat_samp VARCHAR(9), 
	assembly_quality TEXT, 
	url TEXT, 
	fao_class VARCHAR(13), 
	local_class TEXT, 
	local_class_meth TEXT, 
	soil_type TEXT NOT NULL, 
	soil_type_meth TEXT NOT NULL, 
	horizon VARCHAR(10), 
	horizon_meth TEXT, 
	link_class_info TEXT, 
	previous_land_use TEXT, 
	previous_land_use_meth TEXT, 
	crop_rotation TEXT, 
	agrochem_addition TEXT, 
	tillage VARCHAR(13), 
	fire DATE, 
	flooding DATE, 
	extreme_event DATE, 
	link_climate_info TEXT, 
	annual_temp TEXT, 
	season_temp TEXT, 
	annual_precpt TEXT, 
	season_precpt TEXT, 
	cur_land_use VARCHAR(93), 
	slope_gradient TEXT, 
	slope_aspect TEXT, 
	profile_position VARCHAR(9), 
	drainage_class VARCHAR(19), 
	store_cond TEXT NOT NULL, 
	ph_meth TEXT, 
	cur_vegetation TEXT, 
	cur_vegetation_meth TEXT, 
	tot_org_carb TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro TEXT, 
	tot_n_meth TEXT, 
	microbial_biomass TEXT NOT NULL, 
	microbial_biomass_meth TEXT NOT NULL, 
	heavy_metals_meth TEXT, 
	tot_car TEXT, 
	tot_phos TEXT, 
	sieving TEXT NOT NULL, 
	pool_dna_extracts TEXT NOT NULL, 
	misc_param TEXT, 
	host_disease_stat TEXT, 
	specific_host TEXT NOT NULL, 
	pathogenicity TEXT NOT NULL, 
	biotic_relationship VARCHAR(11), 
	isol_growth_condt TEXT, 
	samp_mat_process TEXT NOT NULL, 
	host_spec_range INTEGER NOT NULL, 
	trophic_level VARCHAR(22), 
	samp_size TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT NOT NULL, 
	pcr_primers TEXT NOT NULL, 
	nucl_acid_ext TEXT NOT NULL, 
	nucl_acid_amp TEXT NOT NULL, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER NOT NULL, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT NOT NULL, 
	lib_screen TEXT NOT NULL, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT NOT NULL, 
	mid TEXT NOT NULL, 
	adapters TEXT NOT NULL, 
	pcr_cond TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT NOT NULL, 
	assembly_name TEXT NOT NULL, 
	assembly_software TEXT, 
	annot TEXT, 
	sop TEXT, 
	source_mat_id TEXT, 
	samp_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	associated_resource TEXT, 
	PRIMARY KEY (lat_lon, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, plant_growth_med, soil_horizon, photosynt_activ, photosynt_activ_meth, samp_collect_method, enrichment_protocol, library_prep_kit, sequencing_location, "temp", "soil_pH", soil_conductivity, rel_location, soil_cover, porosity, texture, texture_meth, host_symbiont, pres_animal_insect, plant_water_method, anim_water_method, farm_water_source, water_source_shared, "water_pH", season, solar_irradiance, crop_yield, season_humidity, humidity, adjacent_environment, chem_administration, food_prod, lot_number, fertilizer_admin, samp_stor_temp, food_trav_mode, food_trav_vehic, farm_equip_san, farm_equip, farm_equip_shared, food_harvest_proc, plant_struc, host_dry_mass, ances_data, genetic_mod, "Food_Product_type", "Food_source", spikein_strain, organism_count, size_frac_low, size_frac_up, cult_isol_date, samp_pooling, root_med_macronutr, root_med_carbon, root_med_ph, depth, water_temp_regm, watering_regm, standing_water_regm, gaseous_environment, fungicide_regm, climate_environment, herbicide_regm, non_mineral_nutr_regm, pesticide_regm, ph_regm, salt_regm, season_environment, perturbation, samp_store_dur, samp_store_loc, samp_collect_device, host_age, host_common_name, host_genotype, host_height, host_subspecf_genlin, host_length, host_life_stage, host_phenotype, host_taxid, host_tot_mass, plant_product, oxy_stat_samp, assembly_quality, url, fao_class, local_class, local_class_meth, soil_type, soil_type_meth, horizon, horizon_meth, link_class_info, previous_land_use, previous_land_use_meth, crop_rotation, agrochem_addition, tillage, fire, flooding, extreme_event, link_climate_info, annual_temp, season_temp, annual_precpt, season_precpt, cur_land_use, slope_gradient, slope_aspect, profile_position, drainage_class, store_cond, ph_meth, cur_vegetation, cur_vegetation_meth, tot_org_carb, tot_org_c_meth, tot_nitro, tot_n_meth, microbial_biomass, microbial_biomass_meth, heavy_metals_meth, tot_car, tot_phos, sieving, pool_dna_extracts, misc_param, host_disease_stat, specific_host, pathogenicity, biotic_relationship, isol_growth_condt, samp_mat_process, host_spec_range, trophic_level, samp_size, seq_meth, samp_vol_we_dna_ext, pcr_primers, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, mid, adapters, pcr_cond, seq_quality_check, chimera_check, assembly_name, assembly_software, annot, sop, source_mat_id, samp_name, samp_taxon_id, project_name, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, rel_to_oxygen, samp_collec_device, samp_collec_method, associated_resource)
);

CREATE TABLE "agriculture_MIMS" (
	lat_lon TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	plant_growth_med VARCHAR(30), 
	soil_horizon VARCHAR(10), 
	photosynt_activ TEXT, 
	photosynt_activ_meth TEXT, 
	samp_collect_method TEXT, 
	enrichment_protocol TEXT, 
	library_prep_kit TEXT, 
	sequencing_location TEXT, 
	"temp" TEXT, 
	"soil_pH" FLOAT, 
	soil_conductivity TEXT, 
	rel_location TEXT, 
	soil_cover TEXT, 
	porosity TEXT, 
	texture TEXT, 
	texture_meth TEXT, 
	host_symbiont TEXT, 
	pres_animal_insect TEXT, 
	plant_water_method TEXT, 
	anim_water_method TEXT, 
	farm_water_source VARCHAR(19), 
	water_source_shared VARCHAR(27), 
	"water_pH" FLOAT, 
	season TEXT, 
	solar_irradiance TEXT, 
	crop_yield TEXT, 
	season_humidity TEXT, 
	humidity TEXT, 
	adjacent_environment TEXT, 
	chem_administration TEXT NOT NULL, 
	food_prod TEXT, 
	lot_number TEXT, 
	fertilizer_admin TEXT, 
	samp_stor_temp TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	farm_equip_san TEXT, 
	farm_equip TEXT, 
	farm_equip_shared TEXT, 
	food_harvest_proc TEXT, 
	plant_struc TEXT, 
	host_dry_mass TEXT, 
	ances_data TEXT, 
	genetic_mod TEXT, 
	"Food_Product_type" TEXT, 
	"Food_source" TEXT NOT NULL, 
	spikein_strain TEXT, 
	organism_count VARCHAR(5), 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	cult_isol_date DATE, 
	samp_pooling TEXT, 
	root_med_macronutr TEXT, 
	root_med_carbon TEXT, 
	root_med_ph FLOAT, 
	depth TEXT NOT NULL, 
	water_temp_regm TEXT, 
	watering_regm TEXT, 
	standing_water_regm TEXT, 
	gaseous_environment TEXT, 
	fungicide_regm TEXT, 
	climate_environment TEXT, 
	herbicide_regm TEXT, 
	non_mineral_nutr_regm TEXT, 
	pesticide_regm TEXT, 
	ph_regm TEXT, 
	salt_regm TEXT, 
	season_environment TEXT, 
	perturbation TEXT, 
	samp_store_dur TEXT NOT NULL, 
	samp_store_loc TEXT NOT NULL, 
	samp_collect_device TEXT NOT NULL, 
	host_age TEXT NOT NULL, 
	host_common_name TEXT NOT NULL, 
	host_genotype TEXT NOT NULL, 
	host_height TEXT NOT NULL, 
	host_subspecf_genlin TEXT, 
	host_length TEXT NOT NULL, 
	host_life_stage TEXT NOT NULL, 
	host_phenotype TEXT NOT NULL, 
	host_taxid TEXT NOT NULL, 
	host_tot_mass TEXT NOT NULL, 
	plant_product TEXT, 
	oxy_stat_samp VARCHAR(9), 
	assembly_quality TEXT, 
	url TEXT, 
	fao_class VARCHAR(13), 
	local_class TEXT, 
	local_class_meth TEXT, 
	soil_type TEXT NOT NULL, 
	soil_type_meth TEXT NOT NULL, 
	horizon VARCHAR(10), 
	horizon_meth TEXT, 
	link_class_info TEXT, 
	previous_land_use TEXT, 
	previous_land_use_meth TEXT, 
	crop_rotation TEXT, 
	agrochem_addition TEXT, 
	tillage VARCHAR(13), 
	fire DATE, 
	flooding DATE, 
	extreme_event DATE, 
	link_climate_info TEXT, 
	annual_temp TEXT, 
	season_temp TEXT, 
	annual_precpt TEXT, 
	season_precpt TEXT, 
	cur_land_use VARCHAR(93), 
	slope_gradient TEXT, 
	slope_aspect TEXT, 
	profile_position VARCHAR(9), 
	drainage_class VARCHAR(19), 
	store_cond TEXT NOT NULL, 
	ph_meth TEXT, 
	cur_vegetation TEXT, 
	cur_vegetation_meth TEXT, 
	tot_org_carb TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro TEXT, 
	tot_n_meth TEXT, 
	microbial_biomass TEXT NOT NULL, 
	microbial_biomass_meth TEXT NOT NULL, 
	heavy_metals_meth TEXT, 
	tot_car TEXT, 
	tot_phos TEXT, 
	sieving TEXT NOT NULL, 
	pool_dna_extracts TEXT NOT NULL, 
	misc_param TEXT, 
	host_disease_stat TEXT, 
	specific_host TEXT NOT NULL, 
	pathogenicity TEXT NOT NULL, 
	biotic_relationship VARCHAR(11), 
	isol_growth_condt TEXT, 
	samp_mat_process TEXT NOT NULL, 
	host_spec_range INTEGER NOT NULL, 
	trophic_level VARCHAR(22), 
	samp_size TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT NOT NULL, 
	pcr_primers TEXT NOT NULL, 
	nucl_acid_ext TEXT NOT NULL, 
	nucl_acid_amp TEXT NOT NULL, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER NOT NULL, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT NOT NULL, 
	lib_screen TEXT NOT NULL, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT NOT NULL, 
	mid TEXT NOT NULL, 
	adapters TEXT NOT NULL, 
	pcr_cond TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT NOT NULL, 
	assembly_name TEXT NOT NULL, 
	assembly_software TEXT, 
	annot TEXT, 
	sop TEXT, 
	source_mat_id TEXT, 
	samp_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	size_frac TEXT, 
	assembly_qual VARCHAR(27), 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	associated_resource TEXT, 
	PRIMARY KEY (lat_lon, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, plant_growth_med, soil_horizon, photosynt_activ, photosynt_activ_meth, samp_collect_method, enrichment_protocol, library_prep_kit, sequencing_location, "temp", "soil_pH", soil_conductivity, rel_location, soil_cover, porosity, texture, texture_meth, host_symbiont, pres_animal_insect, plant_water_method, anim_water_method, farm_water_source, water_source_shared, "water_pH", season, solar_irradiance, crop_yield, season_humidity, humidity, adjacent_environment, chem_administration, food_prod, lot_number, fertilizer_admin, samp_stor_temp, food_trav_mode, food_trav_vehic, farm_equip_san, farm_equip, farm_equip_shared, food_harvest_proc, plant_struc, host_dry_mass, ances_data, genetic_mod, "Food_Product_type", "Food_source", spikein_strain, organism_count, size_frac_low, size_frac_up, cult_isol_date, samp_pooling, root_med_macronutr, root_med_carbon, root_med_ph, depth, water_temp_regm, watering_regm, standing_water_regm, gaseous_environment, fungicide_regm, climate_environment, herbicide_regm, non_mineral_nutr_regm, pesticide_regm, ph_regm, salt_regm, season_environment, perturbation, samp_store_dur, samp_store_loc, samp_collect_device, host_age, host_common_name, host_genotype, host_height, host_subspecf_genlin, host_length, host_life_stage, host_phenotype, host_taxid, host_tot_mass, plant_product, oxy_stat_samp, assembly_quality, url, fao_class, local_class, local_class_meth, soil_type, soil_type_meth, horizon, horizon_meth, link_class_info, previous_land_use, previous_land_use_meth, crop_rotation, agrochem_addition, tillage, fire, flooding, extreme_event, link_climate_info, annual_temp, season_temp, annual_precpt, season_precpt, cur_land_use, slope_gradient, slope_aspect, profile_position, drainage_class, store_cond, ph_meth, cur_vegetation, cur_vegetation_meth, tot_org_carb, tot_org_c_meth, tot_nitro, tot_n_meth, microbial_biomass, microbial_biomass_meth, heavy_metals_meth, tot_car, tot_phos, sieving, pool_dna_extracts, misc_param, host_disease_stat, specific_host, pathogenicity, biotic_relationship, isol_growth_condt, samp_mat_process, host_spec_range, trophic_level, samp_size, seq_meth, samp_vol_we_dna_ext, pcr_primers, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, mid, adapters, pcr_cond, seq_quality_check, chimera_check, assembly_name, assembly_software, annot, sop, source_mat_id, samp_name, samp_taxon_id, project_name, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, rel_to_oxygen, samp_collec_device, samp_collec_method, size_frac, assembly_qual, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, associated_resource)
);

CREATE TABLE "agriculture_MISAG" (
	lat_lon TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	plant_growth_med VARCHAR(30), 
	soil_horizon VARCHAR(10), 
	photosynt_activ TEXT, 
	photosynt_activ_meth TEXT, 
	samp_collect_method TEXT, 
	enrichment_protocol TEXT, 
	library_prep_kit TEXT, 
	sequencing_location TEXT, 
	"temp" TEXT, 
	"soil_pH" FLOAT, 
	soil_conductivity TEXT, 
	rel_location TEXT, 
	soil_cover TEXT, 
	porosity TEXT, 
	texture TEXT, 
	texture_meth TEXT, 
	host_symbiont TEXT, 
	pres_animal_insect TEXT, 
	plant_water_method TEXT, 
	anim_water_method TEXT, 
	farm_water_source VARCHAR(19), 
	water_source_shared VARCHAR(27), 
	"water_pH" FLOAT, 
	season TEXT, 
	solar_irradiance TEXT, 
	crop_yield TEXT, 
	season_humidity TEXT, 
	humidity TEXT, 
	adjacent_environment TEXT, 
	chem_administration TEXT NOT NULL, 
	food_prod TEXT, 
	lot_number TEXT, 
	fertilizer_admin TEXT, 
	samp_stor_temp TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	farm_equip_san TEXT, 
	farm_equip TEXT, 
	farm_equip_shared TEXT, 
	food_harvest_proc TEXT, 
	plant_struc TEXT, 
	host_dry_mass TEXT, 
	ances_data TEXT, 
	genetic_mod TEXT, 
	"Food_Product_type" TEXT, 
	"Food_source" TEXT NOT NULL, 
	spikein_strain TEXT, 
	organism_count VARCHAR(5), 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	cult_isol_date DATE, 
	samp_pooling TEXT, 
	root_med_macronutr TEXT, 
	root_med_carbon TEXT, 
	root_med_ph FLOAT, 
	depth TEXT NOT NULL, 
	water_temp_regm TEXT, 
	watering_regm TEXT, 
	standing_water_regm TEXT, 
	gaseous_environment TEXT, 
	fungicide_regm TEXT, 
	climate_environment TEXT, 
	herbicide_regm TEXT, 
	non_mineral_nutr_regm TEXT, 
	pesticide_regm TEXT, 
	ph_regm TEXT, 
	salt_regm TEXT, 
	season_environment TEXT, 
	perturbation TEXT, 
	samp_store_dur TEXT NOT NULL, 
	samp_store_loc TEXT NOT NULL, 
	samp_collect_device TEXT NOT NULL, 
	host_age TEXT NOT NULL, 
	host_common_name TEXT NOT NULL, 
	host_genotype TEXT NOT NULL, 
	host_height TEXT NOT NULL, 
	host_subspecf_genlin TEXT, 
	host_length TEXT NOT NULL, 
	host_life_stage TEXT NOT NULL, 
	host_phenotype TEXT NOT NULL, 
	host_taxid TEXT NOT NULL, 
	host_tot_mass TEXT NOT NULL, 
	plant_product TEXT, 
	oxy_stat_samp VARCHAR(9), 
	assembly_quality TEXT, 
	url TEXT, 
	fao_class VARCHAR(13), 
	local_class TEXT, 
	local_class_meth TEXT, 
	soil_type TEXT NOT NULL, 
	soil_type_meth TEXT NOT NULL, 
	horizon VARCHAR(10), 
	horizon_meth TEXT, 
	link_class_info TEXT, 
	previous_land_use TEXT, 
	previous_land_use_meth TEXT, 
	crop_rotation TEXT, 
	agrochem_addition TEXT, 
	tillage VARCHAR(13), 
	fire DATE, 
	flooding DATE, 
	extreme_event DATE, 
	link_climate_info TEXT, 
	annual_temp TEXT, 
	season_temp TEXT, 
	annual_precpt TEXT, 
	season_precpt TEXT, 
	cur_land_use VARCHAR(93), 
	slope_gradient TEXT, 
	slope_aspect TEXT, 
	profile_position VARCHAR(9), 
	drainage_class VARCHAR(19), 
	store_cond TEXT NOT NULL, 
	ph_meth TEXT, 
	cur_vegetation TEXT, 
	cur_vegetation_meth TEXT, 
	tot_org_carb TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro TEXT, 
	tot_n_meth TEXT, 
	microbial_biomass TEXT NOT NULL, 
	microbial_biomass_meth TEXT NOT NULL, 
	heavy_metals_meth TEXT, 
	tot_car TEXT, 
	tot_phos TEXT, 
	sieving TEXT NOT NULL, 
	pool_dna_extracts TEXT NOT NULL, 
	misc_param TEXT, 
	host_disease_stat TEXT, 
	specific_host TEXT NOT NULL, 
	pathogenicity TEXT NOT NULL, 
	biotic_relationship VARCHAR(11), 
	isol_growth_condt TEXT, 
	samp_mat_process TEXT NOT NULL, 
	host_spec_range INTEGER NOT NULL, 
	trophic_level VARCHAR(22), 
	samp_size TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT NOT NULL, 
	pcr_primers TEXT NOT NULL, 
	nucl_acid_ext TEXT NOT NULL, 
	nucl_acid_amp TEXT NOT NULL, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER NOT NULL, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT NOT NULL, 
	lib_screen TEXT NOT NULL, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT NOT NULL, 
	mid TEXT NOT NULL, 
	adapters TEXT NOT NULL, 
	pcr_cond TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT NOT NULL, 
	assembly_name TEXT NOT NULL, 
	assembly_software TEXT, 
	annot TEXT, 
	sop TEXT, 
	source_mat_id TEXT, 
	samp_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	size_frac TEXT, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	sort_tech VARCHAR(28) NOT NULL, 
	single_cell_lysis_appr VARCHAR(11) NOT NULL, 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT NOT NULL, 
	wga_amp_kit TEXT, 
	associated_resource TEXT, 
	PRIMARY KEY (lat_lon, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, plant_growth_med, soil_horizon, photosynt_activ, photosynt_activ_meth, samp_collect_method, enrichment_protocol, library_prep_kit, sequencing_location, "temp", "soil_pH", soil_conductivity, rel_location, soil_cover, porosity, texture, texture_meth, host_symbiont, pres_animal_insect, plant_water_method, anim_water_method, farm_water_source, water_source_shared, "water_pH", season, solar_irradiance, crop_yield, season_humidity, humidity, adjacent_environment, chem_administration, food_prod, lot_number, fertilizer_admin, samp_stor_temp, food_trav_mode, food_trav_vehic, farm_equip_san, farm_equip, farm_equip_shared, food_harvest_proc, plant_struc, host_dry_mass, ances_data, genetic_mod, "Food_Product_type", "Food_source", spikein_strain, organism_count, size_frac_low, size_frac_up, cult_isol_date, samp_pooling, root_med_macronutr, root_med_carbon, root_med_ph, depth, water_temp_regm, watering_regm, standing_water_regm, gaseous_environment, fungicide_regm, climate_environment, herbicide_regm, non_mineral_nutr_regm, pesticide_regm, ph_regm, salt_regm, season_environment, perturbation, samp_store_dur, samp_store_loc, samp_collect_device, host_age, host_common_name, host_genotype, host_height, host_subspecf_genlin, host_length, host_life_stage, host_phenotype, host_taxid, host_tot_mass, plant_product, oxy_stat_samp, assembly_quality, url, fao_class, local_class, local_class_meth, soil_type, soil_type_meth, horizon, horizon_meth, link_class_info, previous_land_use, previous_land_use_meth, crop_rotation, agrochem_addition, tillage, fire, flooding, extreme_event, link_climate_info, annual_temp, season_temp, annual_precpt, season_precpt, cur_land_use, slope_gradient, slope_aspect, profile_position, drainage_class, store_cond, ph_meth, cur_vegetation, cur_vegetation_meth, tot_org_carb, tot_org_c_meth, tot_nitro, tot_n_meth, microbial_biomass, microbial_biomass_meth, heavy_metals_meth, tot_car, tot_phos, sieving, pool_dna_extracts, misc_param, host_disease_stat, specific_host, pathogenicity, biotic_relationship, isol_growth_condt, samp_mat_process, host_spec_range, trophic_level, samp_size, seq_meth, samp_vol_we_dna_ext, pcr_primers, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, mid, adapters, pcr_cond, seq_quality_check, chimera_check, assembly_name, assembly_software, annot, sop, source_mat_id, samp_name, samp_taxon_id, project_name, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, rel_to_oxygen, samp_collec_device, samp_collec_method, size_frac, tax_ident, assembly_qual, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, associated_resource)
);

CREATE TABLE "agriculture_MIUVIG" (
	lat_lon TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	plant_growth_med VARCHAR(30), 
	soil_horizon VARCHAR(10), 
	photosynt_activ TEXT, 
	photosynt_activ_meth TEXT, 
	samp_collect_method TEXT, 
	enrichment_protocol TEXT, 
	library_prep_kit TEXT, 
	sequencing_location TEXT, 
	"temp" TEXT, 
	"soil_pH" FLOAT, 
	soil_conductivity TEXT, 
	rel_location TEXT, 
	soil_cover TEXT, 
	porosity TEXT, 
	texture TEXT, 
	texture_meth TEXT, 
	host_symbiont TEXT, 
	pres_animal_insect TEXT, 
	plant_water_method TEXT, 
	anim_water_method TEXT, 
	farm_water_source VARCHAR(19), 
	water_source_shared VARCHAR(27), 
	"water_pH" FLOAT, 
	season TEXT, 
	solar_irradiance TEXT, 
	crop_yield TEXT, 
	season_humidity TEXT, 
	humidity TEXT, 
	adjacent_environment TEXT, 
	chem_administration TEXT NOT NULL, 
	food_prod TEXT, 
	lot_number TEXT, 
	fertilizer_admin TEXT, 
	samp_stor_temp TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	farm_equip_san TEXT, 
	farm_equip TEXT, 
	farm_equip_shared TEXT, 
	food_harvest_proc TEXT, 
	plant_struc TEXT, 
	host_dry_mass TEXT, 
	ances_data TEXT, 
	genetic_mod TEXT, 
	"Food_Product_type" TEXT, 
	"Food_source" TEXT NOT NULL, 
	spikein_strain TEXT, 
	organism_count VARCHAR(5), 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	cult_isol_date DATE, 
	samp_pooling TEXT, 
	root_med_macronutr TEXT, 
	root_med_carbon TEXT, 
	root_med_ph FLOAT, 
	depth TEXT NOT NULL, 
	water_temp_regm TEXT, 
	watering_regm TEXT, 
	standing_water_regm TEXT, 
	gaseous_environment TEXT, 
	fungicide_regm TEXT, 
	climate_environment TEXT, 
	herbicide_regm TEXT, 
	non_mineral_nutr_regm TEXT, 
	pesticide_regm TEXT, 
	ph_regm TEXT, 
	salt_regm TEXT, 
	season_environment TEXT, 
	perturbation TEXT, 
	samp_store_dur TEXT NOT NULL, 
	samp_store_loc TEXT NOT NULL, 
	samp_collect_device TEXT NOT NULL, 
	host_age TEXT NOT NULL, 
	host_common_name TEXT NOT NULL, 
	host_genotype TEXT NOT NULL, 
	host_height TEXT NOT NULL, 
	host_subspecf_genlin TEXT, 
	host_length TEXT NOT NULL, 
	host_life_stage TEXT NOT NULL, 
	host_phenotype TEXT NOT NULL, 
	host_taxid TEXT NOT NULL, 
	host_tot_mass TEXT NOT NULL, 
	plant_product TEXT, 
	oxy_stat_samp VARCHAR(9), 
	assembly_quality TEXT, 
	url TEXT, 
	fao_class VARCHAR(13), 
	local_class TEXT, 
	local_class_meth TEXT, 
	soil_type TEXT NOT NULL, 
	soil_type_meth TEXT NOT NULL, 
	horizon VARCHAR(10), 
	horizon_meth TEXT, 
	link_class_info TEXT, 
	previous_land_use TEXT, 
	previous_land_use_meth TEXT, 
	crop_rotation TEXT, 
	agrochem_addition TEXT, 
	tillage VARCHAR(13), 
	fire DATE, 
	flooding DATE, 
	extreme_event DATE, 
	link_climate_info TEXT, 
	annual_temp TEXT, 
	season_temp TEXT, 
	annual_precpt TEXT, 
	season_precpt TEXT, 
	cur_land_use VARCHAR(93), 
	slope_gradient TEXT, 
	slope_aspect TEXT, 
	profile_position VARCHAR(9), 
	drainage_class VARCHAR(19), 
	store_cond TEXT NOT NULL, 
	ph_meth TEXT, 
	cur_vegetation TEXT, 
	cur_vegetation_meth TEXT, 
	tot_org_carb TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro TEXT, 
	tot_n_meth TEXT, 
	microbial_biomass TEXT NOT NULL, 
	microbial_biomass_meth TEXT NOT NULL, 
	heavy_metals_meth TEXT, 
	tot_car TEXT, 
	tot_phos TEXT, 
	sieving TEXT NOT NULL, 
	pool_dna_extracts TEXT NOT NULL, 
	misc_param TEXT, 
	host_disease_stat TEXT, 
	specific_host TEXT NOT NULL, 
	pathogenicity TEXT NOT NULL, 
	biotic_relationship VARCHAR(11), 
	isol_growth_condt TEXT, 
	samp_mat_process TEXT NOT NULL, 
	host_spec_range INTEGER NOT NULL, 
	trophic_level VARCHAR(22), 
	samp_size TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT NOT NULL, 
	pcr_primers TEXT NOT NULL, 
	nucl_acid_ext TEXT NOT NULL, 
	nucl_acid_amp TEXT NOT NULL, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER NOT NULL, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT NOT NULL, 
	lib_screen TEXT NOT NULL, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT NOT NULL, 
	mid TEXT NOT NULL, 
	adapters TEXT NOT NULL, 
	pcr_cond TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT NOT NULL, 
	assembly_name TEXT NOT NULL, 
	assembly_software TEXT, 
	annot TEXT, 
	sop TEXT, 
	source_mat_id TEXT, 
	samp_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	size_frac TEXT, 
	source_uvig VARCHAR(42) NOT NULL, 
	virus_enrich_appr VARCHAR(25) NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	compl_appr VARCHAR(15), 
	sort_tech VARCHAR(28), 
	single_cell_lysis_appr VARCHAR(11), 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT, 
	wga_amp_kit TEXT, 
	bin_param VARCHAR(15), 
	bin_software TEXT, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	vir_ident_software TEXT NOT NULL, 
	pred_genome_type VARCHAR(15) NOT NULL, 
	pred_genome_struc VARCHAR(13) NOT NULL, 
	detec_type TEXT NOT NULL, 
	otu_class_appr TEXT, 
	otu_seq_comp_appr TEXT, 
	otu_db TEXT, 
	host_pred_appr VARCHAR(24), 
	host_pred_est_acc TEXT, 
	associated_resource TEXT, 
	PRIMARY KEY (lat_lon, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, plant_growth_med, soil_horizon, photosynt_activ, photosynt_activ_meth, samp_collect_method, enrichment_protocol, library_prep_kit, sequencing_location, "temp", "soil_pH", soil_conductivity, rel_location, soil_cover, porosity, texture, texture_meth, host_symbiont, pres_animal_insect, plant_water_method, anim_water_method, farm_water_source, water_source_shared, "water_pH", season, solar_irradiance, crop_yield, season_humidity, humidity, adjacent_environment, chem_administration, food_prod, lot_number, fertilizer_admin, samp_stor_temp, food_trav_mode, food_trav_vehic, farm_equip_san, farm_equip, farm_equip_shared, food_harvest_proc, plant_struc, host_dry_mass, ances_data, genetic_mod, "Food_Product_type", "Food_source", spikein_strain, organism_count, size_frac_low, size_frac_up, cult_isol_date, samp_pooling, root_med_macronutr, root_med_carbon, root_med_ph, depth, water_temp_regm, watering_regm, standing_water_regm, gaseous_environment, fungicide_regm, climate_environment, herbicide_regm, non_mineral_nutr_regm, pesticide_regm, ph_regm, salt_regm, season_environment, perturbation, samp_store_dur, samp_store_loc, samp_collect_device, host_age, host_common_name, host_genotype, host_height, host_subspecf_genlin, host_length, host_life_stage, host_phenotype, host_taxid, host_tot_mass, plant_product, oxy_stat_samp, assembly_quality, url, fao_class, local_class, local_class_meth, soil_type, soil_type_meth, horizon, horizon_meth, link_class_info, previous_land_use, previous_land_use_meth, crop_rotation, agrochem_addition, tillage, fire, flooding, extreme_event, link_climate_info, annual_temp, season_temp, annual_precpt, season_precpt, cur_land_use, slope_gradient, slope_aspect, profile_position, drainage_class, store_cond, ph_meth, cur_vegetation, cur_vegetation_meth, tot_org_carb, tot_org_c_meth, tot_nitro, tot_n_meth, microbial_biomass, microbial_biomass_meth, heavy_metals_meth, tot_car, tot_phos, sieving, pool_dna_extracts, misc_param, host_disease_stat, specific_host, pathogenicity, biotic_relationship, isol_growth_condt, samp_mat_process, host_spec_range, trophic_level, samp_size, seq_meth, samp_vol_we_dna_ext, pcr_primers, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, mid, adapters, pcr_cond, seq_quality_check, chimera_check, assembly_name, assembly_software, annot, sop, source_mat_id, samp_name, samp_taxon_id, project_name, experimental_factor, neg_cont_type, pos_cont_type, estimated_size, ref_biomaterial, samp_collec_device, samp_collec_method, size_frac, source_uvig, virus_enrich_appr, tax_ident, assembly_qual, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, trnas, trna_ext_software, compl_score, compl_software, compl_appr, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, bin_param, bin_software, reassembly_bin, mag_cov_software, vir_ident_software, pred_genome_type, pred_genome_struc, detec_type, otu_class_appr, otu_seq_comp_appr, otu_db, host_pred_appr, host_pred_est_acc, associated_resource)
);

CREATE TABLE air (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT NOT NULL, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	barometric_press TEXT, 
	carb_dioxide TEXT, 
	carb_monoxide TEXT, 
	chem_administration TEXT, 
	humidity TEXT, 
	methane TEXT, 
	organism_count VARCHAR(5), 
	oxygen TEXT, 
	oxy_stat_samp VARCHAR(9), 
	perturbation TEXT, 
	pollutants TEXT, 
	air_particulate_matter_concentration TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	ventilation_type TEXT, 
	volatile_org_comp TEXT, 
	wind_direction TEXT, 
	wind_speed TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, barometric_press, carb_dioxide, carb_monoxide, chem_administration, humidity, methane, organism_count, oxygen, oxy_stat_samp, perturbation, pollutants, air_particulate_matter_concentration, salinity, samp_store_dur, samp_store_loc, samp_store_temp, solar_irradiance, ventilation_rate, ventilation_type, volatile_org_comp, wind_direction, wind_speed, misc_param, samp_name, project_name, samp_vol_we_dna_ext)
);

CREATE TABLE "air_MIGS_bacteria" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT NOT NULL, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	barometric_press TEXT, 
	carb_dioxide TEXT, 
	carb_monoxide TEXT, 
	chem_administration TEXT, 
	humidity TEXT, 
	methane TEXT, 
	organism_count VARCHAR(5), 
	oxygen TEXT, 
	oxy_stat_samp VARCHAR(9), 
	perturbation TEXT, 
	pollutants TEXT, 
	air_particulate_matter_concentration TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	ventilation_type TEXT, 
	volatile_org_comp TEXT, 
	wind_direction TEXT, 
	wind_speed TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER NOT NULL, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT NOT NULL, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	trophic_level VARCHAR(22), 
	encoded_traits TEXT, 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, barometric_press, carb_dioxide, carb_monoxide, chem_administration, humidity, methane, organism_count, oxygen, oxy_stat_samp, perturbation, pollutants, air_particulate_matter_concentration, salinity, samp_store_dur, samp_store_loc, samp_store_temp, solar_irradiance, ventilation_rate, ventilation_type, volatile_org_comp, wind_direction, wind_speed, misc_param, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, trophic_level, encoded_traits, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "air_MIGS_eukaryote" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT NOT NULL, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	barometric_press TEXT, 
	carb_dioxide TEXT, 
	carb_monoxide TEXT, 
	chem_administration TEXT, 
	humidity TEXT, 
	methane TEXT, 
	organism_count VARCHAR(5), 
	oxygen TEXT, 
	oxy_stat_samp VARCHAR(9), 
	perturbation TEXT, 
	pollutants TEXT, 
	air_particulate_matter_concentration TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	ventilation_type TEXT, 
	volatile_org_comp TEXT, 
	wind_direction TEXT, 
	wind_speed TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	ploidy TEXT, 
	num_replicons INTEGER, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	trophic_level VARCHAR(22), 
	propagation TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, barometric_press, carb_dioxide, carb_monoxide, chem_administration, humidity, methane, organism_count, oxygen, oxy_stat_samp, perturbation, pollutants, air_particulate_matter_concentration, salinity, samp_store_dur, samp_store_loc, samp_store_temp, solar_irradiance, ventilation_rate, ventilation_type, volatile_org_comp, wind_direction, wind_speed, misc_param, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, ploidy, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, trophic_level, propagation, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "air_MIGS_org" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT NOT NULL, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	barometric_press TEXT, 
	carb_dioxide TEXT, 
	carb_monoxide TEXT, 
	chem_administration TEXT, 
	humidity TEXT, 
	methane TEXT, 
	organism_count VARCHAR(5), 
	oxygen TEXT, 
	oxy_stat_samp VARCHAR(9), 
	perturbation TEXT, 
	pollutants TEXT, 
	air_particulate_matter_concentration TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	ventilation_type TEXT, 
	volatile_org_comp TEXT, 
	wind_direction TEXT, 
	wind_speed TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, barometric_press, carb_dioxide, carb_monoxide, chem_administration, humidity, methane, organism_count, oxygen, oxy_stat_samp, perturbation, pollutants, air_particulate_matter_concentration, salinity, samp_store_dur, samp_store_loc, samp_store_temp, solar_irradiance, ventilation_rate, ventilation_type, volatile_org_comp, wind_direction, wind_speed, misc_param, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "air_MIGS_plant" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT NOT NULL, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	barometric_press TEXT, 
	carb_dioxide TEXT, 
	carb_monoxide TEXT, 
	chem_administration TEXT, 
	humidity TEXT, 
	methane TEXT, 
	organism_count VARCHAR(5), 
	oxygen TEXT, 
	oxy_stat_samp VARCHAR(9), 
	perturbation TEXT, 
	pollutants TEXT, 
	air_particulate_matter_concentration TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	ventilation_type TEXT, 
	volatile_org_comp TEXT, 
	wind_direction TEXT, 
	wind_speed TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, barometric_press, carb_dioxide, carb_monoxide, chem_administration, humidity, methane, organism_count, oxygen, oxy_stat_samp, perturbation, pollutants, air_particulate_matter_concentration, salinity, samp_store_dur, samp_store_loc, samp_store_temp, solar_irradiance, ventilation_rate, ventilation_type, volatile_org_comp, wind_direction, wind_speed, misc_param, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, estimated_size, ref_biomaterial, source_mat_id, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "air_MIGS_virus" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT NOT NULL, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	barometric_press TEXT, 
	carb_dioxide TEXT, 
	carb_monoxide TEXT, 
	chem_administration TEXT, 
	humidity TEXT, 
	methane TEXT, 
	organism_count VARCHAR(5), 
	oxygen TEXT, 
	oxy_stat_samp VARCHAR(9), 
	perturbation TEXT, 
	pollutants TEXT, 
	air_particulate_matter_concentration TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	ventilation_type TEXT, 
	volatile_org_comp TEXT, 
	wind_direction TEXT, 
	wind_speed TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	virus_enrich_appr VARCHAR(25), 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, barometric_press, carb_dioxide, carb_monoxide, chem_administration, humidity, methane, organism_count, oxygen, oxy_stat_samp, perturbation, pollutants, air_particulate_matter_concentration, salinity, samp_store_dur, samp_store_loc, samp_store_temp, solar_irradiance, ventilation_rate, ventilation_type, volatile_org_comp, wind_direction, wind_speed, misc_param, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "air_MIMAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT NOT NULL, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	barometric_press TEXT, 
	carb_dioxide TEXT, 
	carb_monoxide TEXT, 
	chem_administration TEXT, 
	humidity TEXT, 
	methane TEXT, 
	organism_count VARCHAR(5), 
	oxygen TEXT, 
	oxy_stat_samp VARCHAR(9), 
	perturbation TEXT, 
	pollutants TEXT, 
	air_particulate_matter_concentration TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	ventilation_type TEXT, 
	volatile_org_comp TEXT, 
	wind_direction TEXT, 
	wind_speed TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	bin_param VARCHAR(15) NOT NULL, 
	bin_software TEXT NOT NULL, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, barometric_press, carb_dioxide, carb_monoxide, chem_administration, humidity, methane, organism_count, oxygen, oxy_stat_samp, perturbation, pollutants, air_particulate_matter_concentration, salinity, samp_store_dur, samp_store_loc, samp_store_temp, solar_irradiance, ventilation_rate, ventilation_type, volatile_org_comp, wind_direction, wind_speed, misc_param, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, bin_param, bin_software, reassembly_bin, mag_cov_software, associated_resource, sop)
);

CREATE TABLE "air_MIMARKS_specimen" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT NOT NULL, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	barometric_press TEXT, 
	carb_dioxide TEXT, 
	carb_monoxide TEXT, 
	chem_administration TEXT, 
	humidity TEXT, 
	methane TEXT, 
	organism_count VARCHAR(5), 
	oxygen TEXT, 
	oxy_stat_samp VARCHAR(9), 
	perturbation TEXT, 
	pollutants TEXT, 
	air_particulate_matter_concentration TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	ventilation_type TEXT, 
	volatile_org_comp TEXT, 
	wind_direction TEXT, 
	wind_speed TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	mid TEXT, 
	adapters TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	assembly_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, barometric_press, carb_dioxide, carb_monoxide, chem_administration, humidity, methane, organism_count, oxygen, oxy_stat_samp, perturbation, pollutants, air_particulate_matter_concentration, salinity, samp_store_dur, samp_store_loc, samp_store_temp, solar_irradiance, ventilation_rate, ventilation_type, volatile_org_comp, wind_direction, wind_speed, misc_param, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, pcr_primers, mid, adapters, pcr_cond, seq_meth, seq_quality_check, chimera_check, assembly_software, associated_resource, sop)
);

CREATE TABLE "air_MIMARKS_survey" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT NOT NULL, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	barometric_press TEXT, 
	carb_dioxide TEXT, 
	carb_monoxide TEXT, 
	chem_administration TEXT, 
	humidity TEXT, 
	methane TEXT, 
	organism_count VARCHAR(5), 
	oxygen TEXT, 
	oxy_stat_samp VARCHAR(9), 
	perturbation TEXT, 
	pollutants TEXT, 
	air_particulate_matter_concentration TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	ventilation_type TEXT, 
	volatile_org_comp TEXT, 
	wind_direction TEXT, 
	wind_speed TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	source_mat_id TEXT, 
	biotic_relationship VARCHAR(11), 
	trophic_level VARCHAR(22), 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, barometric_press, carb_dioxide, carb_monoxide, chem_administration, humidity, methane, organism_count, oxygen, oxy_stat_samp, perturbation, pollutants, air_particulate_matter_concentration, salinity, samp_store_dur, samp_store_loc, samp_store_temp, solar_irradiance, ventilation_rate, ventilation_type, volatile_org_comp, wind_direction, wind_speed, misc_param, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, source_mat_id, biotic_relationship, trophic_level, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, target_gene, target_subfragment, pcr_primers, pcr_cond, seq_meth, seq_quality_check, chimera_check, associated_resource, sop)
);

CREATE TABLE "air_MIMS" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT NOT NULL, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	barometric_press TEXT, 
	carb_dioxide TEXT, 
	carb_monoxide TEXT, 
	chem_administration TEXT, 
	humidity TEXT, 
	methane TEXT, 
	organism_count VARCHAR(5), 
	oxygen TEXT, 
	oxy_stat_samp VARCHAR(9), 
	perturbation TEXT, 
	pollutants TEXT, 
	air_particulate_matter_concentration TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	ventilation_type TEXT, 
	volatile_org_comp TEXT, 
	wind_direction TEXT, 
	wind_speed TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, barometric_press, carb_dioxide, carb_monoxide, chem_administration, humidity, methane, organism_count, oxygen, oxy_stat_samp, perturbation, pollutants, air_particulate_matter_concentration, salinity, samp_store_dur, samp_store_loc, samp_store_temp, solar_irradiance, ventilation_rate, ventilation_type, volatile_org_comp, wind_direction, wind_speed, misc_param, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, associated_resource, sop)
);

CREATE TABLE "air_MISAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT NOT NULL, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	barometric_press TEXT, 
	carb_dioxide TEXT, 
	carb_monoxide TEXT, 
	chem_administration TEXT, 
	humidity TEXT, 
	methane TEXT, 
	organism_count VARCHAR(5), 
	oxygen TEXT, 
	oxy_stat_samp VARCHAR(9), 
	perturbation TEXT, 
	pollutants TEXT, 
	air_particulate_matter_concentration TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	ventilation_type TEXT, 
	volatile_org_comp TEXT, 
	wind_direction TEXT, 
	wind_speed TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	sort_tech VARCHAR(28) NOT NULL, 
	single_cell_lysis_appr VARCHAR(11) NOT NULL, 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT NOT NULL, 
	wga_amp_kit TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, barometric_press, carb_dioxide, carb_monoxide, chem_administration, humidity, methane, organism_count, oxygen, oxy_stat_samp, perturbation, pollutants, air_particulate_matter_concentration, salinity, samp_store_dur, samp_store_loc, samp_store_temp, solar_irradiance, ventilation_rate, ventilation_type, volatile_org_comp, wind_direction, wind_speed, misc_param, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, associated_resource, sop)
);

CREATE TABLE "air_MIUVIG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT NOT NULL, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	barometric_press TEXT, 
	carb_dioxide TEXT, 
	carb_monoxide TEXT, 
	chem_administration TEXT, 
	humidity TEXT, 
	methane TEXT, 
	organism_count VARCHAR(5), 
	oxygen TEXT, 
	oxy_stat_samp VARCHAR(9), 
	perturbation TEXT, 
	pollutants TEXT, 
	air_particulate_matter_concentration TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	ventilation_type TEXT, 
	volatile_org_comp TEXT, 
	wind_direction TEXT, 
	wind_speed TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	source_uvig VARCHAR(42) NOT NULL, 
	virus_enrich_appr VARCHAR(25) NOT NULL, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	compl_appr VARCHAR(15), 
	sort_tech VARCHAR(28), 
	single_cell_lysis_appr VARCHAR(11), 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT, 
	wga_amp_kit TEXT, 
	bin_param VARCHAR(15), 
	bin_software TEXT, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	vir_ident_software TEXT NOT NULL, 
	pred_genome_type VARCHAR(15) NOT NULL, 
	pred_genome_struc VARCHAR(13) NOT NULL, 
	detec_type TEXT NOT NULL, 
	otu_class_appr TEXT, 
	otu_seq_comp_appr TEXT, 
	otu_db TEXT, 
	host_pred_appr VARCHAR(24), 
	host_pred_est_acc TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, barometric_press, carb_dioxide, carb_monoxide, chem_administration, humidity, methane, organism_count, oxygen, oxy_stat_samp, perturbation, pollutants, air_particulate_matter_concentration, salinity, samp_store_dur, samp_store_loc, samp_store_temp, solar_irradiance, ventilation_rate, ventilation_type, volatile_org_comp, wind_direction, wind_speed, misc_param, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, source_uvig, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, trnas, trna_ext_software, compl_score, compl_software, compl_appr, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, bin_param, bin_software, reassembly_bin, mag_cov_software, vir_ident_software, pred_genome_type, pred_genome_struc, detec_type, otu_class_appr, otu_seq_comp_appr, otu_db, host_pred_appr, host_pred_est_acc, associated_resource, sop)
);

CREATE TABLE built_environment (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	surf_material VARCHAR(15), 
	surf_air_cont VARCHAR(26), 
	rel_air_humidity TEXT NOT NULL, 
	abs_air_humidity TEXT NOT NULL, 
	surf_humidity TEXT, 
	surf_temp TEXT, 
	surf_moisture_ph FLOAT, 
	build_occup_type VARCHAR(14) NOT NULL, 
	surf_moisture TEXT, 
	dew_point TEXT, 
	carb_dioxide TEXT NOT NULL, 
	ventilation_type TEXT NOT NULL, 
	organism_count VARCHAR(5) NOT NULL, 
	indoor_space VARCHAR(11) NOT NULL, 
	indoor_surf VARCHAR(11), 
	filter_type VARCHAR(39) NOT NULL, 
	heat_cool_type VARCHAR(17) NOT NULL, 
	substructure_type VARCHAR(13), 
	building_setting VARCHAR(8) NOT NULL, 
	light_type VARCHAR(18) NOT NULL, 
	samp_sort_meth TEXT, 
	space_typ_state TEXT NOT NULL, 
	typ_occup_density FLOAT NOT NULL, 
	occup_samp INTEGER NOT NULL, 
	occup_density_samp FLOAT NOT NULL, 
	address TEXT, 
	adj_room TEXT, 
	aero_struc TEXT, 
	amount_light TEXT, 
	arch_struc VARCHAR(8), 
	avg_occup FLOAT, 
	avg_dew_point TEXT, 
	avg_temp TEXT, 
	bathroom_count INTEGER, 
	bedroom_count INTEGER, 
	built_struc_age TEXT, 
	built_struc_set TEXT, 
	built_struc_type TEXT, 
	ceil_area TEXT, 
	ceil_cond VARCHAR(12), 
	ceil_finish_mat VARCHAR(29), 
	ceil_water_mold TEXT, 
	ceil_struc TEXT, 
	ceil_texture VARCHAR(16), 
	ceil_thermal_mass TEXT, 
	ceil_type VARCHAR(13), 
	cool_syst_id INTEGER, 
	date_last_rain DATE, 
	build_docs VARCHAR(28), 
	door_size TEXT, 
	door_cond VARCHAR(12), 
	door_direct VARCHAR(8), 
	door_loc VARCHAR(5), 
	door_mat VARCHAR(22), 
	door_move VARCHAR(15), 
	door_water_mold TEXT, 
	door_type VARCHAR(9), 
	door_comp_type VARCHAR(13), 
	door_type_metal VARCHAR(16), 
	door_type_wood VARCHAR(24), 
	drawings VARCHAR(23), 
	elevator INTEGER, 
	escalator INTEGER, 
	exp_duct TEXT, 
	exp_pipe INTEGER, 
	ext_door INTEGER, 
	fireplace_type TEXT, 
	floor_age TEXT, 
	floor_area TEXT, 
	floor_cond VARCHAR(12), 
	floor_count INTEGER, 
	floor_finish_mat VARCHAR(22), 
	floor_water_mold VARCHAR(26), 
	floor_struc VARCHAR(14), 
	floor_thermal_mass TEXT, 
	freq_clean VARCHAR(9), 
	freq_cook INTEGER, 
	furniture VARCHAR(7), 
	gender_restroom VARCHAR(15), 
	hall_count INTEGER, 
	handidness VARCHAR(16), 
	heat_deliv_loc VARCHAR(5), 
	heat_sys_deliv_meth TEXT, 
	heat_system_id INTEGER, 
	height_carper_fiber TEXT, 
	inside_lux TEXT, 
	int_wall_cond VARCHAR(12), 
	last_clean DATE, 
	max_occup INTEGER, 
	mech_struc VARCHAR(9), 
	number_plants INTEGER, 
	number_pets INTEGER, 
	number_resident INTEGER, 
	occup_document VARCHAR(15), 
	ext_wall_orient VARCHAR(9), 
	ext_window_orient VARCHAR(9), 
	rel_humidity_out TEXT, 
	pres_animal_insect TEXT, 
	quad_pos VARCHAR(10), 
	rel_samp_loc VARCHAR(13), 
	room_air_exch_rate TEXT, 
	room_architec_elem TEXT, 
	room_condt VARCHAR(28), 
	room_count INTEGER, 
	room_dim TEXT, 
	room_door_dist TEXT, 
	room_loc VARCHAR(13), 
	room_moist_dam_hist INTEGER, 
	room_net_area TEXT, 
	room_occup INTEGER, 
	room_samp_pos VARCHAR(16), 
	room_type VARCHAR(29), 
	room_vol TEXT, 
	room_window_count INTEGER, 
	room_connected VARCHAR(15), 
	room_hallway TEXT, 
	room_door_share TEXT, 
	room_wall_share TEXT, 
	samp_weather VARCHAR(9), 
	samp_floor VARCHAR(9), 
	samp_room_id INTEGER, 
	samp_time_out FLOAT, 
	season TEXT, 
	season_use VARCHAR(6), 
	shading_device_cond VARCHAR(12), 
	shading_device_loc TEXT, 
	shading_device_mat TEXT, 
	shad_dev_water_mold TEXT, 
	shading_device_type VARCHAR(21), 
	specific_humidity TEXT, 
	specific VARCHAR(12), 
	temp_out TEXT, 
	train_line VARCHAR(6), 
	train_stat_loc VARCHAR(26), 
	train_stop_loc VARCHAR(8), 
	vis_media VARCHAR(63), 
	wall_area TEXT, 
	wall_const_type VARCHAR(23), 
	wall_finish_mat VARCHAR(20), 
	wall_height TEXT, 
	wall_loc VARCHAR(5), 
	wall_water_mold TEXT, 
	wall_surf_treatment VARCHAR(12), 
	wall_texture VARCHAR(16), 
	wall_thermal_mass TEXT, 
	water_feat_size TEXT, 
	water_feat_type VARCHAR(16), 
	weekday VARCHAR(9), 
	window_size TEXT, 
	window_cond VARCHAR(12), 
	window_cover VARCHAR(8), 
	window_horiz_pos VARCHAR(6), 
	window_loc VARCHAR(5), 
	window_mat VARCHAR(10), 
	window_open_freq INTEGER, 
	window_water_mold TEXT, 
	window_status TEXT, 
	window_type VARCHAR(23), 
	window_vert_pos VARCHAR(6), 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, surf_material, surf_air_cont, rel_air_humidity, abs_air_humidity, surf_humidity, surf_temp, surf_moisture_ph, build_occup_type, surf_moisture, dew_point, carb_dioxide, ventilation_type, organism_count, indoor_space, indoor_surf, filter_type, heat_cool_type, substructure_type, building_setting, light_type, samp_sort_meth, space_typ_state, typ_occup_density, occup_samp, occup_density_samp, address, adj_room, aero_struc, amount_light, arch_struc, avg_occup, avg_dew_point, avg_temp, bathroom_count, bedroom_count, built_struc_age, built_struc_set, built_struc_type, ceil_area, ceil_cond, ceil_finish_mat, ceil_water_mold, ceil_struc, ceil_texture, ceil_thermal_mass, ceil_type, cool_syst_id, date_last_rain, build_docs, door_size, door_cond, door_direct, door_loc, door_mat, door_move, door_water_mold, door_type, door_comp_type, door_type_metal, door_type_wood, drawings, elevator, escalator, exp_duct, exp_pipe, ext_door, fireplace_type, floor_age, floor_area, floor_cond, floor_count, floor_finish_mat, floor_water_mold, floor_struc, floor_thermal_mass, freq_clean, freq_cook, furniture, gender_restroom, hall_count, handidness, heat_deliv_loc, heat_sys_deliv_meth, heat_system_id, height_carper_fiber, inside_lux, int_wall_cond, last_clean, max_occup, mech_struc, number_plants, number_pets, number_resident, occup_document, ext_wall_orient, ext_window_orient, rel_humidity_out, pres_animal_insect, quad_pos, rel_samp_loc, room_air_exch_rate, room_architec_elem, room_condt, room_count, room_dim, room_door_dist, room_loc, room_moist_dam_hist, room_net_area, room_occup, room_samp_pos, room_type, room_vol, room_window_count, room_connected, room_hallway, room_door_share, room_wall_share, samp_weather, samp_floor, samp_room_id, samp_time_out, season, season_use, shading_device_cond, shading_device_loc, shading_device_mat, shad_dev_water_mold, shading_device_type, specific_humidity, specific, temp_out, train_line, train_stat_loc, train_stop_loc, vis_media, wall_area, wall_const_type, wall_finish_mat, wall_height, wall_loc, wall_water_mold, wall_surf_treatment, wall_texture, wall_thermal_mass, water_feat_size, water_feat_type, weekday, window_size, window_cond, window_cover, window_horiz_pos, window_loc, window_mat, window_open_freq, window_water_mold, window_status, window_type, window_vert_pos, samp_name, project_name)
);

CREATE TABLE "built_environment_MIGS_bacteria" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	surf_material VARCHAR(15), 
	surf_air_cont VARCHAR(26), 
	rel_air_humidity TEXT NOT NULL, 
	abs_air_humidity TEXT NOT NULL, 
	surf_humidity TEXT, 
	"temp" TEXT NOT NULL, 
	surf_temp TEXT, 
	surf_moisture_ph FLOAT, 
	build_occup_type VARCHAR(14) NOT NULL, 
	surf_moisture TEXT, 
	dew_point TEXT, 
	carb_dioxide TEXT NOT NULL, 
	ventilation_type TEXT NOT NULL, 
	organism_count VARCHAR(5) NOT NULL, 
	indoor_space VARCHAR(11) NOT NULL, 
	indoor_surf VARCHAR(11), 
	filter_type VARCHAR(39) NOT NULL, 
	heat_cool_type VARCHAR(17) NOT NULL, 
	substructure_type VARCHAR(13), 
	building_setting VARCHAR(8) NOT NULL, 
	light_type VARCHAR(18) NOT NULL, 
	samp_sort_meth TEXT, 
	space_typ_state TEXT NOT NULL, 
	typ_occup_density FLOAT NOT NULL, 
	occup_samp INTEGER NOT NULL, 
	occup_density_samp FLOAT NOT NULL, 
	address TEXT, 
	adj_room TEXT, 
	aero_struc TEXT, 
	amount_light TEXT, 
	arch_struc VARCHAR(8), 
	avg_occup FLOAT, 
	avg_dew_point TEXT, 
	avg_temp TEXT, 
	bathroom_count INTEGER, 
	bedroom_count INTEGER, 
	built_struc_age TEXT, 
	built_struc_set TEXT, 
	built_struc_type TEXT, 
	ceil_area TEXT, 
	ceil_cond VARCHAR(12), 
	ceil_finish_mat VARCHAR(29), 
	ceil_water_mold TEXT, 
	ceil_struc TEXT, 
	ceil_texture VARCHAR(16), 
	ceil_thermal_mass TEXT, 
	ceil_type VARCHAR(13), 
	cool_syst_id INTEGER, 
	date_last_rain DATE, 
	build_docs VARCHAR(28), 
	door_size TEXT, 
	door_cond VARCHAR(12), 
	door_direct VARCHAR(8), 
	door_loc VARCHAR(5), 
	door_mat VARCHAR(22), 
	door_move VARCHAR(15), 
	door_water_mold TEXT, 
	door_type VARCHAR(9), 
	door_comp_type VARCHAR(13), 
	door_type_metal VARCHAR(16), 
	door_type_wood VARCHAR(24), 
	drawings VARCHAR(23), 
	elevator INTEGER, 
	escalator INTEGER, 
	exp_duct TEXT, 
	exp_pipe INTEGER, 
	ext_door INTEGER, 
	fireplace_type TEXT, 
	floor_age TEXT, 
	floor_area TEXT, 
	floor_cond VARCHAR(12), 
	floor_count INTEGER, 
	floor_finish_mat VARCHAR(22), 
	floor_water_mold VARCHAR(26), 
	floor_struc VARCHAR(14), 
	floor_thermal_mass TEXT, 
	freq_clean VARCHAR(9), 
	freq_cook INTEGER, 
	furniture VARCHAR(7), 
	gender_restroom VARCHAR(15), 
	hall_count INTEGER, 
	handidness VARCHAR(16), 
	heat_deliv_loc VARCHAR(5), 
	heat_sys_deliv_meth TEXT, 
	heat_system_id INTEGER, 
	height_carper_fiber TEXT, 
	inside_lux TEXT, 
	int_wall_cond VARCHAR(12), 
	last_clean DATE, 
	max_occup INTEGER, 
	mech_struc VARCHAR(9), 
	number_plants INTEGER, 
	number_pets INTEGER, 
	number_resident INTEGER, 
	occup_document VARCHAR(15), 
	ext_wall_orient VARCHAR(9), 
	ext_window_orient VARCHAR(9), 
	rel_humidity_out TEXT, 
	pres_animal_insect TEXT, 
	quad_pos VARCHAR(10), 
	rel_samp_loc VARCHAR(13), 
	room_air_exch_rate TEXT, 
	room_architec_elem TEXT, 
	room_condt VARCHAR(28), 
	room_count INTEGER, 
	room_dim TEXT, 
	room_door_dist TEXT, 
	room_loc VARCHAR(13), 
	room_moist_dam_hist INTEGER, 
	room_net_area TEXT, 
	room_occup INTEGER, 
	room_samp_pos VARCHAR(16), 
	room_type VARCHAR(29), 
	room_vol TEXT, 
	room_window_count INTEGER, 
	room_connected VARCHAR(15), 
	room_hallway TEXT, 
	room_door_share TEXT, 
	room_wall_share TEXT, 
	samp_weather VARCHAR(9), 
	samp_floor VARCHAR(9), 
	samp_room_id INTEGER, 
	samp_time_out FLOAT, 
	season TEXT, 
	season_use VARCHAR(6), 
	shading_device_cond VARCHAR(12), 
	shading_device_loc TEXT, 
	shading_device_mat TEXT, 
	shad_dev_water_mold TEXT, 
	shading_device_type VARCHAR(21), 
	specific_humidity TEXT, 
	specific VARCHAR(12), 
	temp_out TEXT, 
	train_line VARCHAR(6), 
	train_stat_loc VARCHAR(26), 
	train_stop_loc VARCHAR(8), 
	vis_media VARCHAR(63), 
	wall_area TEXT, 
	wall_const_type VARCHAR(23), 
	wall_finish_mat VARCHAR(20), 
	wall_height TEXT, 
	wall_loc VARCHAR(5), 
	wall_water_mold TEXT, 
	wall_surf_treatment VARCHAR(12), 
	wall_texture VARCHAR(16), 
	wall_thermal_mass TEXT, 
	water_feat_size TEXT, 
	water_feat_type VARCHAR(16), 
	weekday VARCHAR(9), 
	window_size TEXT, 
	window_cond VARCHAR(12), 
	window_cover VARCHAR(8), 
	window_horiz_pos VARCHAR(6), 
	window_loc VARCHAR(5), 
	window_mat VARCHAR(10), 
	window_open_freq INTEGER, 
	window_water_mold TEXT, 
	window_status TEXT, 
	window_type VARCHAR(23), 
	window_vert_pos VARCHAR(6), 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER NOT NULL, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT NOT NULL, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	trophic_level VARCHAR(22), 
	encoded_traits TEXT, 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	samp_vol_we_dna_ext TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, surf_material, surf_air_cont, rel_air_humidity, abs_air_humidity, surf_humidity, "temp", surf_temp, surf_moisture_ph, build_occup_type, surf_moisture, dew_point, carb_dioxide, ventilation_type, organism_count, indoor_space, indoor_surf, filter_type, heat_cool_type, substructure_type, building_setting, light_type, samp_sort_meth, space_typ_state, typ_occup_density, occup_samp, occup_density_samp, address, adj_room, aero_struc, amount_light, arch_struc, avg_occup, avg_dew_point, avg_temp, bathroom_count, bedroom_count, built_struc_age, built_struc_set, built_struc_type, ceil_area, ceil_cond, ceil_finish_mat, ceil_water_mold, ceil_struc, ceil_texture, ceil_thermal_mass, ceil_type, cool_syst_id, date_last_rain, build_docs, door_size, door_cond, door_direct, door_loc, door_mat, door_move, door_water_mold, door_type, door_comp_type, door_type_metal, door_type_wood, drawings, elevator, escalator, exp_duct, exp_pipe, ext_door, fireplace_type, floor_age, floor_area, floor_cond, floor_count, floor_finish_mat, floor_water_mold, floor_struc, floor_thermal_mass, freq_clean, freq_cook, furniture, gender_restroom, hall_count, handidness, heat_deliv_loc, heat_sys_deliv_meth, heat_system_id, height_carper_fiber, inside_lux, int_wall_cond, last_clean, max_occup, mech_struc, number_plants, number_pets, number_resident, occup_document, ext_wall_orient, ext_window_orient, rel_humidity_out, pres_animal_insect, quad_pos, rel_samp_loc, room_air_exch_rate, room_architec_elem, room_condt, room_count, room_dim, room_door_dist, room_loc, room_moist_dam_hist, room_net_area, room_occup, room_samp_pos, room_type, room_vol, room_window_count, room_connected, room_hallway, room_door_share, room_wall_share, samp_weather, samp_floor, samp_room_id, samp_time_out, season, season_use, shading_device_cond, shading_device_loc, shading_device_mat, shad_dev_water_mold, shading_device_type, specific_humidity, specific, temp_out, train_line, train_stat_loc, train_stop_loc, vis_media, wall_area, wall_const_type, wall_finish_mat, wall_height, wall_loc, wall_water_mold, wall_surf_treatment, wall_texture, wall_thermal_mass, water_feat_size, water_feat_type, weekday, window_size, window_cond, window_cover, window_horiz_pos, window_loc, window_mat, window_open_freq, window_water_mold, window_status, window_type, window_vert_pos, samp_name, project_name, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, trophic_level, encoded_traits, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, samp_vol_we_dna_ext, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "built_environment_MIGS_eukaryote" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	surf_material VARCHAR(15), 
	surf_air_cont VARCHAR(26), 
	rel_air_humidity TEXT NOT NULL, 
	abs_air_humidity TEXT NOT NULL, 
	surf_humidity TEXT, 
	"temp" TEXT NOT NULL, 
	surf_temp TEXT, 
	surf_moisture_ph FLOAT, 
	build_occup_type VARCHAR(14) NOT NULL, 
	surf_moisture TEXT, 
	dew_point TEXT, 
	carb_dioxide TEXT NOT NULL, 
	ventilation_type TEXT NOT NULL, 
	organism_count VARCHAR(5) NOT NULL, 
	indoor_space VARCHAR(11) NOT NULL, 
	indoor_surf VARCHAR(11), 
	filter_type VARCHAR(39) NOT NULL, 
	heat_cool_type VARCHAR(17) NOT NULL, 
	substructure_type VARCHAR(13), 
	building_setting VARCHAR(8) NOT NULL, 
	light_type VARCHAR(18) NOT NULL, 
	samp_sort_meth TEXT, 
	space_typ_state TEXT NOT NULL, 
	typ_occup_density FLOAT NOT NULL, 
	occup_samp INTEGER NOT NULL, 
	occup_density_samp FLOAT NOT NULL, 
	address TEXT, 
	adj_room TEXT, 
	aero_struc TEXT, 
	amount_light TEXT, 
	arch_struc VARCHAR(8), 
	avg_occup FLOAT, 
	avg_dew_point TEXT, 
	avg_temp TEXT, 
	bathroom_count INTEGER, 
	bedroom_count INTEGER, 
	built_struc_age TEXT, 
	built_struc_set TEXT, 
	built_struc_type TEXT, 
	ceil_area TEXT, 
	ceil_cond VARCHAR(12), 
	ceil_finish_mat VARCHAR(29), 
	ceil_water_mold TEXT, 
	ceil_struc TEXT, 
	ceil_texture VARCHAR(16), 
	ceil_thermal_mass TEXT, 
	ceil_type VARCHAR(13), 
	cool_syst_id INTEGER, 
	date_last_rain DATE, 
	build_docs VARCHAR(28), 
	door_size TEXT, 
	door_cond VARCHAR(12), 
	door_direct VARCHAR(8), 
	door_loc VARCHAR(5), 
	door_mat VARCHAR(22), 
	door_move VARCHAR(15), 
	door_water_mold TEXT, 
	door_type VARCHAR(9), 
	door_comp_type VARCHAR(13), 
	door_type_metal VARCHAR(16), 
	door_type_wood VARCHAR(24), 
	drawings VARCHAR(23), 
	elevator INTEGER, 
	escalator INTEGER, 
	exp_duct TEXT, 
	exp_pipe INTEGER, 
	ext_door INTEGER, 
	fireplace_type TEXT, 
	floor_age TEXT, 
	floor_area TEXT, 
	floor_cond VARCHAR(12), 
	floor_count INTEGER, 
	floor_finish_mat VARCHAR(22), 
	floor_water_mold VARCHAR(26), 
	floor_struc VARCHAR(14), 
	floor_thermal_mass TEXT, 
	freq_clean VARCHAR(9), 
	freq_cook INTEGER, 
	furniture VARCHAR(7), 
	gender_restroom VARCHAR(15), 
	hall_count INTEGER, 
	handidness VARCHAR(16), 
	heat_deliv_loc VARCHAR(5), 
	heat_sys_deliv_meth TEXT, 
	heat_system_id INTEGER, 
	height_carper_fiber TEXT, 
	inside_lux TEXT, 
	int_wall_cond VARCHAR(12), 
	last_clean DATE, 
	max_occup INTEGER, 
	mech_struc VARCHAR(9), 
	number_plants INTEGER, 
	number_pets INTEGER, 
	number_resident INTEGER, 
	occup_document VARCHAR(15), 
	ext_wall_orient VARCHAR(9), 
	ext_window_orient VARCHAR(9), 
	rel_humidity_out TEXT, 
	pres_animal_insect TEXT, 
	quad_pos VARCHAR(10), 
	rel_samp_loc VARCHAR(13), 
	room_air_exch_rate TEXT, 
	room_architec_elem TEXT, 
	room_condt VARCHAR(28), 
	room_count INTEGER, 
	room_dim TEXT, 
	room_door_dist TEXT, 
	room_loc VARCHAR(13), 
	room_moist_dam_hist INTEGER, 
	room_net_area TEXT, 
	room_occup INTEGER, 
	room_samp_pos VARCHAR(16), 
	room_type VARCHAR(29), 
	room_vol TEXT, 
	room_window_count INTEGER, 
	room_connected VARCHAR(15), 
	room_hallway TEXT, 
	room_door_share TEXT, 
	room_wall_share TEXT, 
	samp_weather VARCHAR(9), 
	samp_floor VARCHAR(9), 
	samp_room_id INTEGER, 
	samp_time_out FLOAT, 
	season TEXT, 
	season_use VARCHAR(6), 
	shading_device_cond VARCHAR(12), 
	shading_device_loc TEXT, 
	shading_device_mat TEXT, 
	shad_dev_water_mold TEXT, 
	shading_device_type VARCHAR(21), 
	specific_humidity TEXT, 
	specific VARCHAR(12), 
	temp_out TEXT, 
	train_line VARCHAR(6), 
	train_stat_loc VARCHAR(26), 
	train_stop_loc VARCHAR(8), 
	vis_media VARCHAR(63), 
	wall_area TEXT, 
	wall_const_type VARCHAR(23), 
	wall_finish_mat VARCHAR(20), 
	wall_height TEXT, 
	wall_loc VARCHAR(5), 
	wall_water_mold TEXT, 
	wall_surf_treatment VARCHAR(12), 
	wall_texture VARCHAR(16), 
	wall_thermal_mass TEXT, 
	water_feat_size TEXT, 
	water_feat_type VARCHAR(16), 
	weekday VARCHAR(9), 
	window_size TEXT, 
	window_cond VARCHAR(12), 
	window_cover VARCHAR(8), 
	window_horiz_pos VARCHAR(6), 
	window_loc VARCHAR(5), 
	window_mat VARCHAR(10), 
	window_open_freq INTEGER, 
	window_water_mold TEXT, 
	window_status TEXT, 
	window_type VARCHAR(23), 
	window_vert_pos VARCHAR(6), 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	ploidy TEXT, 
	num_replicons INTEGER, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	trophic_level VARCHAR(22), 
	propagation TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	samp_vol_we_dna_ext TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, surf_material, surf_air_cont, rel_air_humidity, abs_air_humidity, surf_humidity, "temp", surf_temp, surf_moisture_ph, build_occup_type, surf_moisture, dew_point, carb_dioxide, ventilation_type, organism_count, indoor_space, indoor_surf, filter_type, heat_cool_type, substructure_type, building_setting, light_type, samp_sort_meth, space_typ_state, typ_occup_density, occup_samp, occup_density_samp, address, adj_room, aero_struc, amount_light, arch_struc, avg_occup, avg_dew_point, avg_temp, bathroom_count, bedroom_count, built_struc_age, built_struc_set, built_struc_type, ceil_area, ceil_cond, ceil_finish_mat, ceil_water_mold, ceil_struc, ceil_texture, ceil_thermal_mass, ceil_type, cool_syst_id, date_last_rain, build_docs, door_size, door_cond, door_direct, door_loc, door_mat, door_move, door_water_mold, door_type, door_comp_type, door_type_metal, door_type_wood, drawings, elevator, escalator, exp_duct, exp_pipe, ext_door, fireplace_type, floor_age, floor_area, floor_cond, floor_count, floor_finish_mat, floor_water_mold, floor_struc, floor_thermal_mass, freq_clean, freq_cook, furniture, gender_restroom, hall_count, handidness, heat_deliv_loc, heat_sys_deliv_meth, heat_system_id, height_carper_fiber, inside_lux, int_wall_cond, last_clean, max_occup, mech_struc, number_plants, number_pets, number_resident, occup_document, ext_wall_orient, ext_window_orient, rel_humidity_out, pres_animal_insect, quad_pos, rel_samp_loc, room_air_exch_rate, room_architec_elem, room_condt, room_count, room_dim, room_door_dist, room_loc, room_moist_dam_hist, room_net_area, room_occup, room_samp_pos, room_type, room_vol, room_window_count, room_connected, room_hallway, room_door_share, room_wall_share, samp_weather, samp_floor, samp_room_id, samp_time_out, season, season_use, shading_device_cond, shading_device_loc, shading_device_mat, shad_dev_water_mold, shading_device_type, specific_humidity, specific, temp_out, train_line, train_stat_loc, train_stop_loc, vis_media, wall_area, wall_const_type, wall_finish_mat, wall_height, wall_loc, wall_water_mold, wall_surf_treatment, wall_texture, wall_thermal_mass, water_feat_size, water_feat_type, weekday, window_size, window_cond, window_cover, window_horiz_pos, window_loc, window_mat, window_open_freq, window_water_mold, window_status, window_type, window_vert_pos, samp_name, project_name, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, ploidy, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, trophic_level, propagation, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, samp_vol_we_dna_ext, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "built_environment_MIGS_org" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	surf_material VARCHAR(15), 
	surf_air_cont VARCHAR(26), 
	rel_air_humidity TEXT NOT NULL, 
	abs_air_humidity TEXT NOT NULL, 
	surf_humidity TEXT, 
	"temp" TEXT NOT NULL, 
	surf_temp TEXT, 
	surf_moisture_ph FLOAT, 
	build_occup_type VARCHAR(14) NOT NULL, 
	surf_moisture TEXT, 
	dew_point TEXT, 
	carb_dioxide TEXT NOT NULL, 
	ventilation_type TEXT NOT NULL, 
	organism_count VARCHAR(5) NOT NULL, 
	indoor_space VARCHAR(11) NOT NULL, 
	indoor_surf VARCHAR(11), 
	filter_type VARCHAR(39) NOT NULL, 
	heat_cool_type VARCHAR(17) NOT NULL, 
	substructure_type VARCHAR(13), 
	building_setting VARCHAR(8) NOT NULL, 
	light_type VARCHAR(18) NOT NULL, 
	samp_sort_meth TEXT, 
	space_typ_state TEXT NOT NULL, 
	typ_occup_density FLOAT NOT NULL, 
	occup_samp INTEGER NOT NULL, 
	occup_density_samp FLOAT NOT NULL, 
	address TEXT, 
	adj_room TEXT, 
	aero_struc TEXT, 
	amount_light TEXT, 
	arch_struc VARCHAR(8), 
	avg_occup FLOAT, 
	avg_dew_point TEXT, 
	avg_temp TEXT, 
	bathroom_count INTEGER, 
	bedroom_count INTEGER, 
	built_struc_age TEXT, 
	built_struc_set TEXT, 
	built_struc_type TEXT, 
	ceil_area TEXT, 
	ceil_cond VARCHAR(12), 
	ceil_finish_mat VARCHAR(29), 
	ceil_water_mold TEXT, 
	ceil_struc TEXT, 
	ceil_texture VARCHAR(16), 
	ceil_thermal_mass TEXT, 
	ceil_type VARCHAR(13), 
	cool_syst_id INTEGER, 
	date_last_rain DATE, 
	build_docs VARCHAR(28), 
	door_size TEXT, 
	door_cond VARCHAR(12), 
	door_direct VARCHAR(8), 
	door_loc VARCHAR(5), 
	door_mat VARCHAR(22), 
	door_move VARCHAR(15), 
	door_water_mold TEXT, 
	door_type VARCHAR(9), 
	door_comp_type VARCHAR(13), 
	door_type_metal VARCHAR(16), 
	door_type_wood VARCHAR(24), 
	drawings VARCHAR(23), 
	elevator INTEGER, 
	escalator INTEGER, 
	exp_duct TEXT, 
	exp_pipe INTEGER, 
	ext_door INTEGER, 
	fireplace_type TEXT, 
	floor_age TEXT, 
	floor_area TEXT, 
	floor_cond VARCHAR(12), 
	floor_count INTEGER, 
	floor_finish_mat VARCHAR(22), 
	floor_water_mold VARCHAR(26), 
	floor_struc VARCHAR(14), 
	floor_thermal_mass TEXT, 
	freq_clean VARCHAR(9), 
	freq_cook INTEGER, 
	furniture VARCHAR(7), 
	gender_restroom VARCHAR(15), 
	hall_count INTEGER, 
	handidness VARCHAR(16), 
	heat_deliv_loc VARCHAR(5), 
	heat_sys_deliv_meth TEXT, 
	heat_system_id INTEGER, 
	height_carper_fiber TEXT, 
	inside_lux TEXT, 
	int_wall_cond VARCHAR(12), 
	last_clean DATE, 
	max_occup INTEGER, 
	mech_struc VARCHAR(9), 
	number_plants INTEGER, 
	number_pets INTEGER, 
	number_resident INTEGER, 
	occup_document VARCHAR(15), 
	ext_wall_orient VARCHAR(9), 
	ext_window_orient VARCHAR(9), 
	rel_humidity_out TEXT, 
	pres_animal_insect TEXT, 
	quad_pos VARCHAR(10), 
	rel_samp_loc VARCHAR(13), 
	room_air_exch_rate TEXT, 
	room_architec_elem TEXT, 
	room_condt VARCHAR(28), 
	room_count INTEGER, 
	room_dim TEXT, 
	room_door_dist TEXT, 
	room_loc VARCHAR(13), 
	room_moist_dam_hist INTEGER, 
	room_net_area TEXT, 
	room_occup INTEGER, 
	room_samp_pos VARCHAR(16), 
	room_type VARCHAR(29), 
	room_vol TEXT, 
	room_window_count INTEGER, 
	room_connected VARCHAR(15), 
	room_hallway TEXT, 
	room_door_share TEXT, 
	room_wall_share TEXT, 
	samp_weather VARCHAR(9), 
	samp_floor VARCHAR(9), 
	samp_room_id INTEGER, 
	samp_time_out FLOAT, 
	season TEXT, 
	season_use VARCHAR(6), 
	shading_device_cond VARCHAR(12), 
	shading_device_loc TEXT, 
	shading_device_mat TEXT, 
	shad_dev_water_mold TEXT, 
	shading_device_type VARCHAR(21), 
	specific_humidity TEXT, 
	specific VARCHAR(12), 
	temp_out TEXT, 
	train_line VARCHAR(6), 
	train_stat_loc VARCHAR(26), 
	train_stop_loc VARCHAR(8), 
	vis_media VARCHAR(63), 
	wall_area TEXT, 
	wall_const_type VARCHAR(23), 
	wall_finish_mat VARCHAR(20), 
	wall_height TEXT, 
	wall_loc VARCHAR(5), 
	wall_water_mold TEXT, 
	wall_surf_treatment VARCHAR(12), 
	wall_texture VARCHAR(16), 
	wall_thermal_mass TEXT, 
	water_feat_size TEXT, 
	water_feat_type VARCHAR(16), 
	weekday VARCHAR(9), 
	window_size TEXT, 
	window_cond VARCHAR(12), 
	window_cover VARCHAR(8), 
	window_horiz_pos VARCHAR(6), 
	window_loc VARCHAR(5), 
	window_mat VARCHAR(10), 
	window_open_freq INTEGER, 
	window_water_mold TEXT, 
	window_status TEXT, 
	window_type VARCHAR(23), 
	window_vert_pos VARCHAR(6), 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	samp_vol_we_dna_ext TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, surf_material, surf_air_cont, rel_air_humidity, abs_air_humidity, surf_humidity, "temp", surf_temp, surf_moisture_ph, build_occup_type, surf_moisture, dew_point, carb_dioxide, ventilation_type, organism_count, indoor_space, indoor_surf, filter_type, heat_cool_type, substructure_type, building_setting, light_type, samp_sort_meth, space_typ_state, typ_occup_density, occup_samp, occup_density_samp, address, adj_room, aero_struc, amount_light, arch_struc, avg_occup, avg_dew_point, avg_temp, bathroom_count, bedroom_count, built_struc_age, built_struc_set, built_struc_type, ceil_area, ceil_cond, ceil_finish_mat, ceil_water_mold, ceil_struc, ceil_texture, ceil_thermal_mass, ceil_type, cool_syst_id, date_last_rain, build_docs, door_size, door_cond, door_direct, door_loc, door_mat, door_move, door_water_mold, door_type, door_comp_type, door_type_metal, door_type_wood, drawings, elevator, escalator, exp_duct, exp_pipe, ext_door, fireplace_type, floor_age, floor_area, floor_cond, floor_count, floor_finish_mat, floor_water_mold, floor_struc, floor_thermal_mass, freq_clean, freq_cook, furniture, gender_restroom, hall_count, handidness, heat_deliv_loc, heat_sys_deliv_meth, heat_system_id, height_carper_fiber, inside_lux, int_wall_cond, last_clean, max_occup, mech_struc, number_plants, number_pets, number_resident, occup_document, ext_wall_orient, ext_window_orient, rel_humidity_out, pres_animal_insect, quad_pos, rel_samp_loc, room_air_exch_rate, room_architec_elem, room_condt, room_count, room_dim, room_door_dist, room_loc, room_moist_dam_hist, room_net_area, room_occup, room_samp_pos, room_type, room_vol, room_window_count, room_connected, room_hallway, room_door_share, room_wall_share, samp_weather, samp_floor, samp_room_id, samp_time_out, season, season_use, shading_device_cond, shading_device_loc, shading_device_mat, shad_dev_water_mold, shading_device_type, specific_humidity, specific, temp_out, train_line, train_stat_loc, train_stop_loc, vis_media, wall_area, wall_const_type, wall_finish_mat, wall_height, wall_loc, wall_water_mold, wall_surf_treatment, wall_texture, wall_thermal_mass, water_feat_size, water_feat_type, weekday, window_size, window_cond, window_cover, window_horiz_pos, window_loc, window_mat, window_open_freq, window_water_mold, window_status, window_type, window_vert_pos, samp_name, project_name, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, samp_vol_we_dna_ext, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "built_environment_MIGS_plant" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	surf_material VARCHAR(15), 
	surf_air_cont VARCHAR(26), 
	rel_air_humidity TEXT NOT NULL, 
	abs_air_humidity TEXT NOT NULL, 
	surf_humidity TEXT, 
	"temp" TEXT NOT NULL, 
	surf_temp TEXT, 
	surf_moisture_ph FLOAT, 
	build_occup_type VARCHAR(14) NOT NULL, 
	surf_moisture TEXT, 
	dew_point TEXT, 
	carb_dioxide TEXT NOT NULL, 
	ventilation_type TEXT NOT NULL, 
	organism_count VARCHAR(5) NOT NULL, 
	indoor_space VARCHAR(11) NOT NULL, 
	indoor_surf VARCHAR(11), 
	filter_type VARCHAR(39) NOT NULL, 
	heat_cool_type VARCHAR(17) NOT NULL, 
	substructure_type VARCHAR(13), 
	building_setting VARCHAR(8) NOT NULL, 
	light_type VARCHAR(18) NOT NULL, 
	samp_sort_meth TEXT, 
	space_typ_state TEXT NOT NULL, 
	typ_occup_density FLOAT NOT NULL, 
	occup_samp INTEGER NOT NULL, 
	occup_density_samp FLOAT NOT NULL, 
	address TEXT, 
	adj_room TEXT, 
	aero_struc TEXT, 
	amount_light TEXT, 
	arch_struc VARCHAR(8), 
	avg_occup FLOAT, 
	avg_dew_point TEXT, 
	avg_temp TEXT, 
	bathroom_count INTEGER, 
	bedroom_count INTEGER, 
	built_struc_age TEXT, 
	built_struc_set TEXT, 
	built_struc_type TEXT, 
	ceil_area TEXT, 
	ceil_cond VARCHAR(12), 
	ceil_finish_mat VARCHAR(29), 
	ceil_water_mold TEXT, 
	ceil_struc TEXT, 
	ceil_texture VARCHAR(16), 
	ceil_thermal_mass TEXT, 
	ceil_type VARCHAR(13), 
	cool_syst_id INTEGER, 
	date_last_rain DATE, 
	build_docs VARCHAR(28), 
	door_size TEXT, 
	door_cond VARCHAR(12), 
	door_direct VARCHAR(8), 
	door_loc VARCHAR(5), 
	door_mat VARCHAR(22), 
	door_move VARCHAR(15), 
	door_water_mold TEXT, 
	door_type VARCHAR(9), 
	door_comp_type VARCHAR(13), 
	door_type_metal VARCHAR(16), 
	door_type_wood VARCHAR(24), 
	drawings VARCHAR(23), 
	elevator INTEGER, 
	escalator INTEGER, 
	exp_duct TEXT, 
	exp_pipe INTEGER, 
	ext_door INTEGER, 
	fireplace_type TEXT, 
	floor_age TEXT, 
	floor_area TEXT, 
	floor_cond VARCHAR(12), 
	floor_count INTEGER, 
	floor_finish_mat VARCHAR(22), 
	floor_water_mold VARCHAR(26), 
	floor_struc VARCHAR(14), 
	floor_thermal_mass TEXT, 
	freq_clean VARCHAR(9), 
	freq_cook INTEGER, 
	furniture VARCHAR(7), 
	gender_restroom VARCHAR(15), 
	hall_count INTEGER, 
	handidness VARCHAR(16), 
	heat_deliv_loc VARCHAR(5), 
	heat_sys_deliv_meth TEXT, 
	heat_system_id INTEGER, 
	height_carper_fiber TEXT, 
	inside_lux TEXT, 
	int_wall_cond VARCHAR(12), 
	last_clean DATE, 
	max_occup INTEGER, 
	mech_struc VARCHAR(9), 
	number_plants INTEGER, 
	number_pets INTEGER, 
	number_resident INTEGER, 
	occup_document VARCHAR(15), 
	ext_wall_orient VARCHAR(9), 
	ext_window_orient VARCHAR(9), 
	rel_humidity_out TEXT, 
	pres_animal_insect TEXT, 
	quad_pos VARCHAR(10), 
	rel_samp_loc VARCHAR(13), 
	room_air_exch_rate TEXT, 
	room_architec_elem TEXT, 
	room_condt VARCHAR(28), 
	room_count INTEGER, 
	room_dim TEXT, 
	room_door_dist TEXT, 
	room_loc VARCHAR(13), 
	room_moist_dam_hist INTEGER, 
	room_net_area TEXT, 
	room_occup INTEGER, 
	room_samp_pos VARCHAR(16), 
	room_type VARCHAR(29), 
	room_vol TEXT, 
	room_window_count INTEGER, 
	room_connected VARCHAR(15), 
	room_hallway TEXT, 
	room_door_share TEXT, 
	room_wall_share TEXT, 
	samp_weather VARCHAR(9), 
	samp_floor VARCHAR(9), 
	samp_room_id INTEGER, 
	samp_time_out FLOAT, 
	season TEXT, 
	season_use VARCHAR(6), 
	shading_device_cond VARCHAR(12), 
	shading_device_loc TEXT, 
	shading_device_mat TEXT, 
	shad_dev_water_mold TEXT, 
	shading_device_type VARCHAR(21), 
	specific_humidity TEXT, 
	specific VARCHAR(12), 
	temp_out TEXT, 
	train_line VARCHAR(6), 
	train_stat_loc VARCHAR(26), 
	train_stop_loc VARCHAR(8), 
	vis_media VARCHAR(63), 
	wall_area TEXT, 
	wall_const_type VARCHAR(23), 
	wall_finish_mat VARCHAR(20), 
	wall_height TEXT, 
	wall_loc VARCHAR(5), 
	wall_water_mold TEXT, 
	wall_surf_treatment VARCHAR(12), 
	wall_texture VARCHAR(16), 
	wall_thermal_mass TEXT, 
	water_feat_size TEXT, 
	water_feat_type VARCHAR(16), 
	weekday VARCHAR(9), 
	window_size TEXT, 
	window_cond VARCHAR(12), 
	window_cover VARCHAR(8), 
	window_horiz_pos VARCHAR(6), 
	window_loc VARCHAR(5), 
	window_mat VARCHAR(10), 
	window_open_freq INTEGER, 
	window_water_mold TEXT, 
	window_status TEXT, 
	window_type VARCHAR(23), 
	window_vert_pos VARCHAR(6), 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	samp_vol_we_dna_ext TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, surf_material, surf_air_cont, rel_air_humidity, abs_air_humidity, surf_humidity, "temp", surf_temp, surf_moisture_ph, build_occup_type, surf_moisture, dew_point, carb_dioxide, ventilation_type, organism_count, indoor_space, indoor_surf, filter_type, heat_cool_type, substructure_type, building_setting, light_type, samp_sort_meth, space_typ_state, typ_occup_density, occup_samp, occup_density_samp, address, adj_room, aero_struc, amount_light, arch_struc, avg_occup, avg_dew_point, avg_temp, bathroom_count, bedroom_count, built_struc_age, built_struc_set, built_struc_type, ceil_area, ceil_cond, ceil_finish_mat, ceil_water_mold, ceil_struc, ceil_texture, ceil_thermal_mass, ceil_type, cool_syst_id, date_last_rain, build_docs, door_size, door_cond, door_direct, door_loc, door_mat, door_move, door_water_mold, door_type, door_comp_type, door_type_metal, door_type_wood, drawings, elevator, escalator, exp_duct, exp_pipe, ext_door, fireplace_type, floor_age, floor_area, floor_cond, floor_count, floor_finish_mat, floor_water_mold, floor_struc, floor_thermal_mass, freq_clean, freq_cook, furniture, gender_restroom, hall_count, handidness, heat_deliv_loc, heat_sys_deliv_meth, heat_system_id, height_carper_fiber, inside_lux, int_wall_cond, last_clean, max_occup, mech_struc, number_plants, number_pets, number_resident, occup_document, ext_wall_orient, ext_window_orient, rel_humidity_out, pres_animal_insect, quad_pos, rel_samp_loc, room_air_exch_rate, room_architec_elem, room_condt, room_count, room_dim, room_door_dist, room_loc, room_moist_dam_hist, room_net_area, room_occup, room_samp_pos, room_type, room_vol, room_window_count, room_connected, room_hallway, room_door_share, room_wall_share, samp_weather, samp_floor, samp_room_id, samp_time_out, season, season_use, shading_device_cond, shading_device_loc, shading_device_mat, shad_dev_water_mold, shading_device_type, specific_humidity, specific, temp_out, train_line, train_stat_loc, train_stop_loc, vis_media, wall_area, wall_const_type, wall_finish_mat, wall_height, wall_loc, wall_water_mold, wall_surf_treatment, wall_texture, wall_thermal_mass, water_feat_size, water_feat_type, weekday, window_size, window_cond, window_cover, window_horiz_pos, window_loc, window_mat, window_open_freq, window_water_mold, window_status, window_type, window_vert_pos, samp_name, project_name, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, estimated_size, ref_biomaterial, source_mat_id, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, samp_vol_we_dna_ext, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "built_environment_MIGS_virus" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	surf_material VARCHAR(15), 
	surf_air_cont VARCHAR(26), 
	rel_air_humidity TEXT NOT NULL, 
	abs_air_humidity TEXT NOT NULL, 
	surf_humidity TEXT, 
	"temp" TEXT NOT NULL, 
	surf_temp TEXT, 
	surf_moisture_ph FLOAT, 
	build_occup_type VARCHAR(14) NOT NULL, 
	surf_moisture TEXT, 
	dew_point TEXT, 
	carb_dioxide TEXT NOT NULL, 
	ventilation_type TEXT NOT NULL, 
	organism_count VARCHAR(5) NOT NULL, 
	indoor_space VARCHAR(11) NOT NULL, 
	indoor_surf VARCHAR(11), 
	filter_type VARCHAR(39) NOT NULL, 
	heat_cool_type VARCHAR(17) NOT NULL, 
	substructure_type VARCHAR(13), 
	building_setting VARCHAR(8) NOT NULL, 
	light_type VARCHAR(18) NOT NULL, 
	samp_sort_meth TEXT, 
	space_typ_state TEXT NOT NULL, 
	typ_occup_density FLOAT NOT NULL, 
	occup_samp INTEGER NOT NULL, 
	occup_density_samp FLOAT NOT NULL, 
	address TEXT, 
	adj_room TEXT, 
	aero_struc TEXT, 
	amount_light TEXT, 
	arch_struc VARCHAR(8), 
	avg_occup FLOAT, 
	avg_dew_point TEXT, 
	avg_temp TEXT, 
	bathroom_count INTEGER, 
	bedroom_count INTEGER, 
	built_struc_age TEXT, 
	built_struc_set TEXT, 
	built_struc_type TEXT, 
	ceil_area TEXT, 
	ceil_cond VARCHAR(12), 
	ceil_finish_mat VARCHAR(29), 
	ceil_water_mold TEXT, 
	ceil_struc TEXT, 
	ceil_texture VARCHAR(16), 
	ceil_thermal_mass TEXT, 
	ceil_type VARCHAR(13), 
	cool_syst_id INTEGER, 
	date_last_rain DATE, 
	build_docs VARCHAR(28), 
	door_size TEXT, 
	door_cond VARCHAR(12), 
	door_direct VARCHAR(8), 
	door_loc VARCHAR(5), 
	door_mat VARCHAR(22), 
	door_move VARCHAR(15), 
	door_water_mold TEXT, 
	door_type VARCHAR(9), 
	door_comp_type VARCHAR(13), 
	door_type_metal VARCHAR(16), 
	door_type_wood VARCHAR(24), 
	drawings VARCHAR(23), 
	elevator INTEGER, 
	escalator INTEGER, 
	exp_duct TEXT, 
	exp_pipe INTEGER, 
	ext_door INTEGER, 
	fireplace_type TEXT, 
	floor_age TEXT, 
	floor_area TEXT, 
	floor_cond VARCHAR(12), 
	floor_count INTEGER, 
	floor_finish_mat VARCHAR(22), 
	floor_water_mold VARCHAR(26), 
	floor_struc VARCHAR(14), 
	floor_thermal_mass TEXT, 
	freq_clean VARCHAR(9), 
	freq_cook INTEGER, 
	furniture VARCHAR(7), 
	gender_restroom VARCHAR(15), 
	hall_count INTEGER, 
	handidness VARCHAR(16), 
	heat_deliv_loc VARCHAR(5), 
	heat_sys_deliv_meth TEXT, 
	heat_system_id INTEGER, 
	height_carper_fiber TEXT, 
	inside_lux TEXT, 
	int_wall_cond VARCHAR(12), 
	last_clean DATE, 
	max_occup INTEGER, 
	mech_struc VARCHAR(9), 
	number_plants INTEGER, 
	number_pets INTEGER, 
	number_resident INTEGER, 
	occup_document VARCHAR(15), 
	ext_wall_orient VARCHAR(9), 
	ext_window_orient VARCHAR(9), 
	rel_humidity_out TEXT, 
	pres_animal_insect TEXT, 
	quad_pos VARCHAR(10), 
	rel_samp_loc VARCHAR(13), 
	room_air_exch_rate TEXT, 
	room_architec_elem TEXT, 
	room_condt VARCHAR(28), 
	room_count INTEGER, 
	room_dim TEXT, 
	room_door_dist TEXT, 
	room_loc VARCHAR(13), 
	room_moist_dam_hist INTEGER, 
	room_net_area TEXT, 
	room_occup INTEGER, 
	room_samp_pos VARCHAR(16), 
	room_type VARCHAR(29), 
	room_vol TEXT, 
	room_window_count INTEGER, 
	room_connected VARCHAR(15), 
	room_hallway TEXT, 
	room_door_share TEXT, 
	room_wall_share TEXT, 
	samp_weather VARCHAR(9), 
	samp_floor VARCHAR(9), 
	samp_room_id INTEGER, 
	samp_time_out FLOAT, 
	season TEXT, 
	season_use VARCHAR(6), 
	shading_device_cond VARCHAR(12), 
	shading_device_loc TEXT, 
	shading_device_mat TEXT, 
	shad_dev_water_mold TEXT, 
	shading_device_type VARCHAR(21), 
	specific_humidity TEXT, 
	specific VARCHAR(12), 
	temp_out TEXT, 
	train_line VARCHAR(6), 
	train_stat_loc VARCHAR(26), 
	train_stop_loc VARCHAR(8), 
	vis_media VARCHAR(63), 
	wall_area TEXT, 
	wall_const_type VARCHAR(23), 
	wall_finish_mat VARCHAR(20), 
	wall_height TEXT, 
	wall_loc VARCHAR(5), 
	wall_water_mold TEXT, 
	wall_surf_treatment VARCHAR(12), 
	wall_texture VARCHAR(16), 
	wall_thermal_mass TEXT, 
	water_feat_size TEXT, 
	water_feat_type VARCHAR(16), 
	weekday VARCHAR(9), 
	window_size TEXT, 
	window_cond VARCHAR(12), 
	window_cover VARCHAR(8), 
	window_horiz_pos VARCHAR(6), 
	window_loc VARCHAR(5), 
	window_mat VARCHAR(10), 
	window_open_freq INTEGER, 
	window_water_mold TEXT, 
	window_status TEXT, 
	window_type VARCHAR(23), 
	window_vert_pos VARCHAR(6), 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	samp_vol_we_dna_ext TEXT, 
	virus_enrich_appr VARCHAR(25), 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, surf_material, surf_air_cont, rel_air_humidity, abs_air_humidity, surf_humidity, "temp", surf_temp, surf_moisture_ph, build_occup_type, surf_moisture, dew_point, carb_dioxide, ventilation_type, organism_count, indoor_space, indoor_surf, filter_type, heat_cool_type, substructure_type, building_setting, light_type, samp_sort_meth, space_typ_state, typ_occup_density, occup_samp, occup_density_samp, address, adj_room, aero_struc, amount_light, arch_struc, avg_occup, avg_dew_point, avg_temp, bathroom_count, bedroom_count, built_struc_age, built_struc_set, built_struc_type, ceil_area, ceil_cond, ceil_finish_mat, ceil_water_mold, ceil_struc, ceil_texture, ceil_thermal_mass, ceil_type, cool_syst_id, date_last_rain, build_docs, door_size, door_cond, door_direct, door_loc, door_mat, door_move, door_water_mold, door_type, door_comp_type, door_type_metal, door_type_wood, drawings, elevator, escalator, exp_duct, exp_pipe, ext_door, fireplace_type, floor_age, floor_area, floor_cond, floor_count, floor_finish_mat, floor_water_mold, floor_struc, floor_thermal_mass, freq_clean, freq_cook, furniture, gender_restroom, hall_count, handidness, heat_deliv_loc, heat_sys_deliv_meth, heat_system_id, height_carper_fiber, inside_lux, int_wall_cond, last_clean, max_occup, mech_struc, number_plants, number_pets, number_resident, occup_document, ext_wall_orient, ext_window_orient, rel_humidity_out, pres_animal_insect, quad_pos, rel_samp_loc, room_air_exch_rate, room_architec_elem, room_condt, room_count, room_dim, room_door_dist, room_loc, room_moist_dam_hist, room_net_area, room_occup, room_samp_pos, room_type, room_vol, room_window_count, room_connected, room_hallway, room_door_share, room_wall_share, samp_weather, samp_floor, samp_room_id, samp_time_out, season, season_use, shading_device_cond, shading_device_loc, shading_device_mat, shad_dev_water_mold, shading_device_type, specific_humidity, specific, temp_out, train_line, train_stat_loc, train_stop_loc, vis_media, wall_area, wall_const_type, wall_finish_mat, wall_height, wall_loc, wall_water_mold, wall_surf_treatment, wall_texture, wall_thermal_mass, water_feat_size, water_feat_type, weekday, window_size, window_cond, window_cover, window_horiz_pos, window_loc, window_mat, window_open_freq, window_water_mold, window_status, window_type, window_vert_pos, samp_name, project_name, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, samp_vol_we_dna_ext, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "built_environment_MIMAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	surf_material VARCHAR(15), 
	surf_air_cont VARCHAR(26), 
	rel_air_humidity TEXT NOT NULL, 
	abs_air_humidity TEXT NOT NULL, 
	surf_humidity TEXT, 
	"temp" TEXT NOT NULL, 
	surf_temp TEXT, 
	surf_moisture_ph FLOAT, 
	build_occup_type VARCHAR(14) NOT NULL, 
	surf_moisture TEXT, 
	dew_point TEXT, 
	carb_dioxide TEXT NOT NULL, 
	ventilation_type TEXT NOT NULL, 
	organism_count VARCHAR(5) NOT NULL, 
	indoor_space VARCHAR(11) NOT NULL, 
	indoor_surf VARCHAR(11), 
	filter_type VARCHAR(39) NOT NULL, 
	heat_cool_type VARCHAR(17) NOT NULL, 
	substructure_type VARCHAR(13), 
	building_setting VARCHAR(8) NOT NULL, 
	light_type VARCHAR(18) NOT NULL, 
	samp_sort_meth TEXT, 
	space_typ_state TEXT NOT NULL, 
	typ_occup_density FLOAT NOT NULL, 
	occup_samp INTEGER NOT NULL, 
	occup_density_samp FLOAT NOT NULL, 
	address TEXT, 
	adj_room TEXT, 
	aero_struc TEXT, 
	amount_light TEXT, 
	arch_struc VARCHAR(8), 
	avg_occup FLOAT, 
	avg_dew_point TEXT, 
	avg_temp TEXT, 
	bathroom_count INTEGER, 
	bedroom_count INTEGER, 
	built_struc_age TEXT, 
	built_struc_set TEXT, 
	built_struc_type TEXT, 
	ceil_area TEXT, 
	ceil_cond VARCHAR(12), 
	ceil_finish_mat VARCHAR(29), 
	ceil_water_mold TEXT, 
	ceil_struc TEXT, 
	ceil_texture VARCHAR(16), 
	ceil_thermal_mass TEXT, 
	ceil_type VARCHAR(13), 
	cool_syst_id INTEGER, 
	date_last_rain DATE, 
	build_docs VARCHAR(28), 
	door_size TEXT, 
	door_cond VARCHAR(12), 
	door_direct VARCHAR(8), 
	door_loc VARCHAR(5), 
	door_mat VARCHAR(22), 
	door_move VARCHAR(15), 
	door_water_mold TEXT, 
	door_type VARCHAR(9), 
	door_comp_type VARCHAR(13), 
	door_type_metal VARCHAR(16), 
	door_type_wood VARCHAR(24), 
	drawings VARCHAR(23), 
	elevator INTEGER, 
	escalator INTEGER, 
	exp_duct TEXT, 
	exp_pipe INTEGER, 
	ext_door INTEGER, 
	fireplace_type TEXT, 
	floor_age TEXT, 
	floor_area TEXT, 
	floor_cond VARCHAR(12), 
	floor_count INTEGER, 
	floor_finish_mat VARCHAR(22), 
	floor_water_mold VARCHAR(26), 
	floor_struc VARCHAR(14), 
	floor_thermal_mass TEXT, 
	freq_clean VARCHAR(9), 
	freq_cook INTEGER, 
	furniture VARCHAR(7), 
	gender_restroom VARCHAR(15), 
	hall_count INTEGER, 
	handidness VARCHAR(16), 
	heat_deliv_loc VARCHAR(5), 
	heat_sys_deliv_meth TEXT, 
	heat_system_id INTEGER, 
	height_carper_fiber TEXT, 
	inside_lux TEXT, 
	int_wall_cond VARCHAR(12), 
	last_clean DATE, 
	max_occup INTEGER, 
	mech_struc VARCHAR(9), 
	number_plants INTEGER, 
	number_pets INTEGER, 
	number_resident INTEGER, 
	occup_document VARCHAR(15), 
	ext_wall_orient VARCHAR(9), 
	ext_window_orient VARCHAR(9), 
	rel_humidity_out TEXT, 
	pres_animal_insect TEXT, 
	quad_pos VARCHAR(10), 
	rel_samp_loc VARCHAR(13), 
	room_air_exch_rate TEXT, 
	room_architec_elem TEXT, 
	room_condt VARCHAR(28), 
	room_count INTEGER, 
	room_dim TEXT, 
	room_door_dist TEXT, 
	room_loc VARCHAR(13), 
	room_moist_dam_hist INTEGER, 
	room_net_area TEXT, 
	room_occup INTEGER, 
	room_samp_pos VARCHAR(16), 
	room_type VARCHAR(29), 
	room_vol TEXT, 
	room_window_count INTEGER, 
	room_connected VARCHAR(15), 
	room_hallway TEXT, 
	room_door_share TEXT, 
	room_wall_share TEXT, 
	samp_weather VARCHAR(9), 
	samp_floor VARCHAR(9), 
	samp_room_id INTEGER, 
	samp_time_out FLOAT, 
	season TEXT, 
	season_use VARCHAR(6), 
	shading_device_cond VARCHAR(12), 
	shading_device_loc TEXT, 
	shading_device_mat TEXT, 
	shad_dev_water_mold TEXT, 
	shading_device_type VARCHAR(21), 
	specific_humidity TEXT, 
	specific VARCHAR(12), 
	temp_out TEXT, 
	train_line VARCHAR(6), 
	train_stat_loc VARCHAR(26), 
	train_stop_loc VARCHAR(8), 
	vis_media VARCHAR(63), 
	wall_area TEXT, 
	wall_const_type VARCHAR(23), 
	wall_finish_mat VARCHAR(20), 
	wall_height TEXT, 
	wall_loc VARCHAR(5), 
	wall_water_mold TEXT, 
	wall_surf_treatment VARCHAR(12), 
	wall_texture VARCHAR(16), 
	wall_thermal_mass TEXT, 
	water_feat_size TEXT, 
	water_feat_type VARCHAR(16), 
	weekday VARCHAR(9), 
	window_size TEXT, 
	window_cond VARCHAR(12), 
	window_cover VARCHAR(8), 
	window_horiz_pos VARCHAR(6), 
	window_loc VARCHAR(5), 
	window_mat VARCHAR(10), 
	window_open_freq INTEGER, 
	window_water_mold TEXT, 
	window_status TEXT, 
	window_type VARCHAR(23), 
	window_vert_pos VARCHAR(6), 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	samp_vol_we_dna_ext TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	bin_param VARCHAR(15) NOT NULL, 
	bin_software TEXT NOT NULL, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, surf_material, surf_air_cont, rel_air_humidity, abs_air_humidity, surf_humidity, "temp", surf_temp, surf_moisture_ph, build_occup_type, surf_moisture, dew_point, carb_dioxide, ventilation_type, organism_count, indoor_space, indoor_surf, filter_type, heat_cool_type, substructure_type, building_setting, light_type, samp_sort_meth, space_typ_state, typ_occup_density, occup_samp, occup_density_samp, address, adj_room, aero_struc, amount_light, arch_struc, avg_occup, avg_dew_point, avg_temp, bathroom_count, bedroom_count, built_struc_age, built_struc_set, built_struc_type, ceil_area, ceil_cond, ceil_finish_mat, ceil_water_mold, ceil_struc, ceil_texture, ceil_thermal_mass, ceil_type, cool_syst_id, date_last_rain, build_docs, door_size, door_cond, door_direct, door_loc, door_mat, door_move, door_water_mold, door_type, door_comp_type, door_type_metal, door_type_wood, drawings, elevator, escalator, exp_duct, exp_pipe, ext_door, fireplace_type, floor_age, floor_area, floor_cond, floor_count, floor_finish_mat, floor_water_mold, floor_struc, floor_thermal_mass, freq_clean, freq_cook, furniture, gender_restroom, hall_count, handidness, heat_deliv_loc, heat_sys_deliv_meth, heat_system_id, height_carper_fiber, inside_lux, int_wall_cond, last_clean, max_occup, mech_struc, number_plants, number_pets, number_resident, occup_document, ext_wall_orient, ext_window_orient, rel_humidity_out, pres_animal_insect, quad_pos, rel_samp_loc, room_air_exch_rate, room_architec_elem, room_condt, room_count, room_dim, room_door_dist, room_loc, room_moist_dam_hist, room_net_area, room_occup, room_samp_pos, room_type, room_vol, room_window_count, room_connected, room_hallway, room_door_share, room_wall_share, samp_weather, samp_floor, samp_room_id, samp_time_out, season, season_use, shading_device_cond, shading_device_loc, shading_device_mat, shad_dev_water_mold, shading_device_type, specific_humidity, specific, temp_out, train_line, train_stat_loc, train_stop_loc, vis_media, wall_area, wall_const_type, wall_finish_mat, wall_height, wall_loc, wall_water_mold, wall_surf_treatment, wall_texture, wall_thermal_mass, water_feat_size, water_feat_type, weekday, window_size, window_cond, window_cover, window_horiz_pos, window_loc, window_mat, window_open_freq, window_water_mold, window_status, window_type, window_vert_pos, samp_name, project_name, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, samp_vol_we_dna_ext, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, bin_param, bin_software, reassembly_bin, mag_cov_software, associated_resource, sop)
);

CREATE TABLE "built_environment_MIMARKS_specimen" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	surf_material VARCHAR(15), 
	surf_air_cont VARCHAR(26), 
	rel_air_humidity TEXT NOT NULL, 
	abs_air_humidity TEXT NOT NULL, 
	surf_humidity TEXT, 
	"temp" TEXT NOT NULL, 
	surf_temp TEXT, 
	surf_moisture_ph FLOAT, 
	build_occup_type VARCHAR(14) NOT NULL, 
	surf_moisture TEXT, 
	dew_point TEXT, 
	carb_dioxide TEXT NOT NULL, 
	ventilation_type TEXT NOT NULL, 
	organism_count VARCHAR(5) NOT NULL, 
	indoor_space VARCHAR(11) NOT NULL, 
	indoor_surf VARCHAR(11), 
	filter_type VARCHAR(39) NOT NULL, 
	heat_cool_type VARCHAR(17) NOT NULL, 
	substructure_type VARCHAR(13), 
	building_setting VARCHAR(8) NOT NULL, 
	light_type VARCHAR(18) NOT NULL, 
	samp_sort_meth TEXT, 
	space_typ_state TEXT NOT NULL, 
	typ_occup_density FLOAT NOT NULL, 
	occup_samp INTEGER NOT NULL, 
	occup_density_samp FLOAT NOT NULL, 
	address TEXT, 
	adj_room TEXT, 
	aero_struc TEXT, 
	amount_light TEXT, 
	arch_struc VARCHAR(8), 
	avg_occup FLOAT, 
	avg_dew_point TEXT, 
	avg_temp TEXT, 
	bathroom_count INTEGER, 
	bedroom_count INTEGER, 
	built_struc_age TEXT, 
	built_struc_set TEXT, 
	built_struc_type TEXT, 
	ceil_area TEXT, 
	ceil_cond VARCHAR(12), 
	ceil_finish_mat VARCHAR(29), 
	ceil_water_mold TEXT, 
	ceil_struc TEXT, 
	ceil_texture VARCHAR(16), 
	ceil_thermal_mass TEXT, 
	ceil_type VARCHAR(13), 
	cool_syst_id INTEGER, 
	date_last_rain DATE, 
	build_docs VARCHAR(28), 
	door_size TEXT, 
	door_cond VARCHAR(12), 
	door_direct VARCHAR(8), 
	door_loc VARCHAR(5), 
	door_mat VARCHAR(22), 
	door_move VARCHAR(15), 
	door_water_mold TEXT, 
	door_type VARCHAR(9), 
	door_comp_type VARCHAR(13), 
	door_type_metal VARCHAR(16), 
	door_type_wood VARCHAR(24), 
	drawings VARCHAR(23), 
	elevator INTEGER, 
	escalator INTEGER, 
	exp_duct TEXT, 
	exp_pipe INTEGER, 
	ext_door INTEGER, 
	fireplace_type TEXT, 
	floor_age TEXT, 
	floor_area TEXT, 
	floor_cond VARCHAR(12), 
	floor_count INTEGER, 
	floor_finish_mat VARCHAR(22), 
	floor_water_mold VARCHAR(26), 
	floor_struc VARCHAR(14), 
	floor_thermal_mass TEXT, 
	freq_clean VARCHAR(9), 
	freq_cook INTEGER, 
	furniture VARCHAR(7), 
	gender_restroom VARCHAR(15), 
	hall_count INTEGER, 
	handidness VARCHAR(16), 
	heat_deliv_loc VARCHAR(5), 
	heat_sys_deliv_meth TEXT, 
	heat_system_id INTEGER, 
	height_carper_fiber TEXT, 
	inside_lux TEXT, 
	int_wall_cond VARCHAR(12), 
	last_clean DATE, 
	max_occup INTEGER, 
	mech_struc VARCHAR(9), 
	number_plants INTEGER, 
	number_pets INTEGER, 
	number_resident INTEGER, 
	occup_document VARCHAR(15), 
	ext_wall_orient VARCHAR(9), 
	ext_window_orient VARCHAR(9), 
	rel_humidity_out TEXT, 
	pres_animal_insect TEXT, 
	quad_pos VARCHAR(10), 
	rel_samp_loc VARCHAR(13), 
	room_air_exch_rate TEXT, 
	room_architec_elem TEXT, 
	room_condt VARCHAR(28), 
	room_count INTEGER, 
	room_dim TEXT, 
	room_door_dist TEXT, 
	room_loc VARCHAR(13), 
	room_moist_dam_hist INTEGER, 
	room_net_area TEXT, 
	room_occup INTEGER, 
	room_samp_pos VARCHAR(16), 
	room_type VARCHAR(29), 
	room_vol TEXT, 
	room_window_count INTEGER, 
	room_connected VARCHAR(15), 
	room_hallway TEXT, 
	room_door_share TEXT, 
	room_wall_share TEXT, 
	samp_weather VARCHAR(9), 
	samp_floor VARCHAR(9), 
	samp_room_id INTEGER, 
	samp_time_out FLOAT, 
	season TEXT, 
	season_use VARCHAR(6), 
	shading_device_cond VARCHAR(12), 
	shading_device_loc TEXT, 
	shading_device_mat TEXT, 
	shad_dev_water_mold TEXT, 
	shading_device_type VARCHAR(21), 
	specific_humidity TEXT, 
	specific VARCHAR(12), 
	temp_out TEXT, 
	train_line VARCHAR(6), 
	train_stat_loc VARCHAR(26), 
	train_stop_loc VARCHAR(8), 
	vis_media VARCHAR(63), 
	wall_area TEXT, 
	wall_const_type VARCHAR(23), 
	wall_finish_mat VARCHAR(20), 
	wall_height TEXT, 
	wall_loc VARCHAR(5), 
	wall_water_mold TEXT, 
	wall_surf_treatment VARCHAR(12), 
	wall_texture VARCHAR(16), 
	wall_thermal_mass TEXT, 
	water_feat_size TEXT, 
	water_feat_type VARCHAR(16), 
	weekday VARCHAR(9), 
	window_size TEXT, 
	window_cond VARCHAR(12), 
	window_cover VARCHAR(8), 
	window_horiz_pos VARCHAR(6), 
	window_loc VARCHAR(5), 
	window_mat VARCHAR(10), 
	window_open_freq INTEGER, 
	window_water_mold TEXT, 
	window_status TEXT, 
	window_type VARCHAR(23), 
	window_vert_pos VARCHAR(6), 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	samp_vol_we_dna_ext TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	mid TEXT, 
	adapters TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	assembly_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, surf_material, surf_air_cont, rel_air_humidity, abs_air_humidity, surf_humidity, "temp", surf_temp, surf_moisture_ph, build_occup_type, surf_moisture, dew_point, carb_dioxide, ventilation_type, organism_count, indoor_space, indoor_surf, filter_type, heat_cool_type, substructure_type, building_setting, light_type, samp_sort_meth, space_typ_state, typ_occup_density, occup_samp, occup_density_samp, address, adj_room, aero_struc, amount_light, arch_struc, avg_occup, avg_dew_point, avg_temp, bathroom_count, bedroom_count, built_struc_age, built_struc_set, built_struc_type, ceil_area, ceil_cond, ceil_finish_mat, ceil_water_mold, ceil_struc, ceil_texture, ceil_thermal_mass, ceil_type, cool_syst_id, date_last_rain, build_docs, door_size, door_cond, door_direct, door_loc, door_mat, door_move, door_water_mold, door_type, door_comp_type, door_type_metal, door_type_wood, drawings, elevator, escalator, exp_duct, exp_pipe, ext_door, fireplace_type, floor_age, floor_area, floor_cond, floor_count, floor_finish_mat, floor_water_mold, floor_struc, floor_thermal_mass, freq_clean, freq_cook, furniture, gender_restroom, hall_count, handidness, heat_deliv_loc, heat_sys_deliv_meth, heat_system_id, height_carper_fiber, inside_lux, int_wall_cond, last_clean, max_occup, mech_struc, number_plants, number_pets, number_resident, occup_document, ext_wall_orient, ext_window_orient, rel_humidity_out, pres_animal_insect, quad_pos, rel_samp_loc, room_air_exch_rate, room_architec_elem, room_condt, room_count, room_dim, room_door_dist, room_loc, room_moist_dam_hist, room_net_area, room_occup, room_samp_pos, room_type, room_vol, room_window_count, room_connected, room_hallway, room_door_share, room_wall_share, samp_weather, samp_floor, samp_room_id, samp_time_out, season, season_use, shading_device_cond, shading_device_loc, shading_device_mat, shad_dev_water_mold, shading_device_type, specific_humidity, specific, temp_out, train_line, train_stat_loc, train_stop_loc, vis_media, wall_area, wall_const_type, wall_finish_mat, wall_height, wall_loc, wall_water_mold, wall_surf_treatment, wall_texture, wall_thermal_mass, water_feat_size, water_feat_type, weekday, window_size, window_cond, window_cover, window_horiz_pos, window_loc, window_mat, window_open_freq, window_water_mold, window_status, window_type, window_vert_pos, samp_name, project_name, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, samp_vol_we_dna_ext, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, pcr_primers, mid, adapters, pcr_cond, seq_meth, seq_quality_check, chimera_check, assembly_software, associated_resource, sop)
);

CREATE TABLE "built_environment_MIMARKS_survey" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	surf_material VARCHAR(15), 
	surf_air_cont VARCHAR(26), 
	rel_air_humidity TEXT NOT NULL, 
	abs_air_humidity TEXT NOT NULL, 
	surf_humidity TEXT, 
	"temp" TEXT NOT NULL, 
	surf_temp TEXT, 
	surf_moisture_ph FLOAT, 
	build_occup_type VARCHAR(14) NOT NULL, 
	surf_moisture TEXT, 
	dew_point TEXT, 
	carb_dioxide TEXT NOT NULL, 
	ventilation_type TEXT NOT NULL, 
	organism_count VARCHAR(5) NOT NULL, 
	indoor_space VARCHAR(11) NOT NULL, 
	indoor_surf VARCHAR(11), 
	filter_type VARCHAR(39) NOT NULL, 
	heat_cool_type VARCHAR(17) NOT NULL, 
	substructure_type VARCHAR(13), 
	building_setting VARCHAR(8) NOT NULL, 
	light_type VARCHAR(18) NOT NULL, 
	samp_sort_meth TEXT, 
	space_typ_state TEXT NOT NULL, 
	typ_occup_density FLOAT NOT NULL, 
	occup_samp INTEGER NOT NULL, 
	occup_density_samp FLOAT NOT NULL, 
	address TEXT, 
	adj_room TEXT, 
	aero_struc TEXT, 
	amount_light TEXT, 
	arch_struc VARCHAR(8), 
	avg_occup FLOAT, 
	avg_dew_point TEXT, 
	avg_temp TEXT, 
	bathroom_count INTEGER, 
	bedroom_count INTEGER, 
	built_struc_age TEXT, 
	built_struc_set TEXT, 
	built_struc_type TEXT, 
	ceil_area TEXT, 
	ceil_cond VARCHAR(12), 
	ceil_finish_mat VARCHAR(29), 
	ceil_water_mold TEXT, 
	ceil_struc TEXT, 
	ceil_texture VARCHAR(16), 
	ceil_thermal_mass TEXT, 
	ceil_type VARCHAR(13), 
	cool_syst_id INTEGER, 
	date_last_rain DATE, 
	build_docs VARCHAR(28), 
	door_size TEXT, 
	door_cond VARCHAR(12), 
	door_direct VARCHAR(8), 
	door_loc VARCHAR(5), 
	door_mat VARCHAR(22), 
	door_move VARCHAR(15), 
	door_water_mold TEXT, 
	door_type VARCHAR(9), 
	door_comp_type VARCHAR(13), 
	door_type_metal VARCHAR(16), 
	door_type_wood VARCHAR(24), 
	drawings VARCHAR(23), 
	elevator INTEGER, 
	escalator INTEGER, 
	exp_duct TEXT, 
	exp_pipe INTEGER, 
	ext_door INTEGER, 
	fireplace_type TEXT, 
	floor_age TEXT, 
	floor_area TEXT, 
	floor_cond VARCHAR(12), 
	floor_count INTEGER, 
	floor_finish_mat VARCHAR(22), 
	floor_water_mold VARCHAR(26), 
	floor_struc VARCHAR(14), 
	floor_thermal_mass TEXT, 
	freq_clean VARCHAR(9), 
	freq_cook INTEGER, 
	furniture VARCHAR(7), 
	gender_restroom VARCHAR(15), 
	hall_count INTEGER, 
	handidness VARCHAR(16), 
	heat_deliv_loc VARCHAR(5), 
	heat_sys_deliv_meth TEXT, 
	heat_system_id INTEGER, 
	height_carper_fiber TEXT, 
	inside_lux TEXT, 
	int_wall_cond VARCHAR(12), 
	last_clean DATE, 
	max_occup INTEGER, 
	mech_struc VARCHAR(9), 
	number_plants INTEGER, 
	number_pets INTEGER, 
	number_resident INTEGER, 
	occup_document VARCHAR(15), 
	ext_wall_orient VARCHAR(9), 
	ext_window_orient VARCHAR(9), 
	rel_humidity_out TEXT, 
	pres_animal_insect TEXT, 
	quad_pos VARCHAR(10), 
	rel_samp_loc VARCHAR(13), 
	room_air_exch_rate TEXT, 
	room_architec_elem TEXT, 
	room_condt VARCHAR(28), 
	room_count INTEGER, 
	room_dim TEXT, 
	room_door_dist TEXT, 
	room_loc VARCHAR(13), 
	room_moist_dam_hist INTEGER, 
	room_net_area TEXT, 
	room_occup INTEGER, 
	room_samp_pos VARCHAR(16), 
	room_type VARCHAR(29), 
	room_vol TEXT, 
	room_window_count INTEGER, 
	room_connected VARCHAR(15), 
	room_hallway TEXT, 
	room_door_share TEXT, 
	room_wall_share TEXT, 
	samp_weather VARCHAR(9), 
	samp_floor VARCHAR(9), 
	samp_room_id INTEGER, 
	samp_time_out FLOAT, 
	season TEXT, 
	season_use VARCHAR(6), 
	shading_device_cond VARCHAR(12), 
	shading_device_loc TEXT, 
	shading_device_mat TEXT, 
	shad_dev_water_mold TEXT, 
	shading_device_type VARCHAR(21), 
	specific_humidity TEXT, 
	specific VARCHAR(12), 
	temp_out TEXT, 
	train_line VARCHAR(6), 
	train_stat_loc VARCHAR(26), 
	train_stop_loc VARCHAR(8), 
	vis_media VARCHAR(63), 
	wall_area TEXT, 
	wall_const_type VARCHAR(23), 
	wall_finish_mat VARCHAR(20), 
	wall_height TEXT, 
	wall_loc VARCHAR(5), 
	wall_water_mold TEXT, 
	wall_surf_treatment VARCHAR(12), 
	wall_texture VARCHAR(16), 
	wall_thermal_mass TEXT, 
	water_feat_size TEXT, 
	water_feat_type VARCHAR(16), 
	weekday VARCHAR(9), 
	window_size TEXT, 
	window_cond VARCHAR(12), 
	window_cover VARCHAR(8), 
	window_horiz_pos VARCHAR(6), 
	window_loc VARCHAR(5), 
	window_mat VARCHAR(10), 
	window_open_freq INTEGER, 
	window_water_mold TEXT, 
	window_status TEXT, 
	window_type VARCHAR(23), 
	window_vert_pos VARCHAR(6), 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	source_mat_id TEXT, 
	biotic_relationship VARCHAR(11), 
	trophic_level VARCHAR(22), 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	samp_vol_we_dna_ext TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, surf_material, surf_air_cont, rel_air_humidity, abs_air_humidity, surf_humidity, "temp", surf_temp, surf_moisture_ph, build_occup_type, surf_moisture, dew_point, carb_dioxide, ventilation_type, organism_count, indoor_space, indoor_surf, filter_type, heat_cool_type, substructure_type, building_setting, light_type, samp_sort_meth, space_typ_state, typ_occup_density, occup_samp, occup_density_samp, address, adj_room, aero_struc, amount_light, arch_struc, avg_occup, avg_dew_point, avg_temp, bathroom_count, bedroom_count, built_struc_age, built_struc_set, built_struc_type, ceil_area, ceil_cond, ceil_finish_mat, ceil_water_mold, ceil_struc, ceil_texture, ceil_thermal_mass, ceil_type, cool_syst_id, date_last_rain, build_docs, door_size, door_cond, door_direct, door_loc, door_mat, door_move, door_water_mold, door_type, door_comp_type, door_type_metal, door_type_wood, drawings, elevator, escalator, exp_duct, exp_pipe, ext_door, fireplace_type, floor_age, floor_area, floor_cond, floor_count, floor_finish_mat, floor_water_mold, floor_struc, floor_thermal_mass, freq_clean, freq_cook, furniture, gender_restroom, hall_count, handidness, heat_deliv_loc, heat_sys_deliv_meth, heat_system_id, height_carper_fiber, inside_lux, int_wall_cond, last_clean, max_occup, mech_struc, number_plants, number_pets, number_resident, occup_document, ext_wall_orient, ext_window_orient, rel_humidity_out, pres_animal_insect, quad_pos, rel_samp_loc, room_air_exch_rate, room_architec_elem, room_condt, room_count, room_dim, room_door_dist, room_loc, room_moist_dam_hist, room_net_area, room_occup, room_samp_pos, room_type, room_vol, room_window_count, room_connected, room_hallway, room_door_share, room_wall_share, samp_weather, samp_floor, samp_room_id, samp_time_out, season, season_use, shading_device_cond, shading_device_loc, shading_device_mat, shad_dev_water_mold, shading_device_type, specific_humidity, specific, temp_out, train_line, train_stat_loc, train_stop_loc, vis_media, wall_area, wall_const_type, wall_finish_mat, wall_height, wall_loc, wall_water_mold, wall_surf_treatment, wall_texture, wall_thermal_mass, water_feat_size, water_feat_type, weekday, window_size, window_cond, window_cover, window_horiz_pos, window_loc, window_mat, window_open_freq, window_water_mold, window_status, window_type, window_vert_pos, samp_name, project_name, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, source_mat_id, biotic_relationship, trophic_level, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, samp_vol_we_dna_ext, nucl_acid_ext, nucl_acid_amp, target_gene, target_subfragment, pcr_primers, pcr_cond, seq_meth, seq_quality_check, chimera_check, associated_resource, sop)
);

CREATE TABLE "built_environment_MIMS" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	surf_material VARCHAR(15), 
	surf_air_cont VARCHAR(26), 
	rel_air_humidity TEXT NOT NULL, 
	abs_air_humidity TEXT NOT NULL, 
	surf_humidity TEXT, 
	"temp" TEXT NOT NULL, 
	surf_temp TEXT, 
	surf_moisture_ph FLOAT, 
	build_occup_type VARCHAR(14) NOT NULL, 
	surf_moisture TEXT, 
	dew_point TEXT, 
	carb_dioxide TEXT NOT NULL, 
	ventilation_type TEXT NOT NULL, 
	organism_count VARCHAR(5) NOT NULL, 
	indoor_space VARCHAR(11) NOT NULL, 
	indoor_surf VARCHAR(11), 
	filter_type VARCHAR(39) NOT NULL, 
	heat_cool_type VARCHAR(17) NOT NULL, 
	substructure_type VARCHAR(13), 
	building_setting VARCHAR(8) NOT NULL, 
	light_type VARCHAR(18) NOT NULL, 
	samp_sort_meth TEXT, 
	space_typ_state TEXT NOT NULL, 
	typ_occup_density FLOAT NOT NULL, 
	occup_samp INTEGER NOT NULL, 
	occup_density_samp FLOAT NOT NULL, 
	address TEXT, 
	adj_room TEXT, 
	aero_struc TEXT, 
	amount_light TEXT, 
	arch_struc VARCHAR(8), 
	avg_occup FLOAT, 
	avg_dew_point TEXT, 
	avg_temp TEXT, 
	bathroom_count INTEGER, 
	bedroom_count INTEGER, 
	built_struc_age TEXT, 
	built_struc_set TEXT, 
	built_struc_type TEXT, 
	ceil_area TEXT, 
	ceil_cond VARCHAR(12), 
	ceil_finish_mat VARCHAR(29), 
	ceil_water_mold TEXT, 
	ceil_struc TEXT, 
	ceil_texture VARCHAR(16), 
	ceil_thermal_mass TEXT, 
	ceil_type VARCHAR(13), 
	cool_syst_id INTEGER, 
	date_last_rain DATE, 
	build_docs VARCHAR(28), 
	door_size TEXT, 
	door_cond VARCHAR(12), 
	door_direct VARCHAR(8), 
	door_loc VARCHAR(5), 
	door_mat VARCHAR(22), 
	door_move VARCHAR(15), 
	door_water_mold TEXT, 
	door_type VARCHAR(9), 
	door_comp_type VARCHAR(13), 
	door_type_metal VARCHAR(16), 
	door_type_wood VARCHAR(24), 
	drawings VARCHAR(23), 
	elevator INTEGER, 
	escalator INTEGER, 
	exp_duct TEXT, 
	exp_pipe INTEGER, 
	ext_door INTEGER, 
	fireplace_type TEXT, 
	floor_age TEXT, 
	floor_area TEXT, 
	floor_cond VARCHAR(12), 
	floor_count INTEGER, 
	floor_finish_mat VARCHAR(22), 
	floor_water_mold VARCHAR(26), 
	floor_struc VARCHAR(14), 
	floor_thermal_mass TEXT, 
	freq_clean VARCHAR(9), 
	freq_cook INTEGER, 
	furniture VARCHAR(7), 
	gender_restroom VARCHAR(15), 
	hall_count INTEGER, 
	handidness VARCHAR(16), 
	heat_deliv_loc VARCHAR(5), 
	heat_sys_deliv_meth TEXT, 
	heat_system_id INTEGER, 
	height_carper_fiber TEXT, 
	inside_lux TEXT, 
	int_wall_cond VARCHAR(12), 
	last_clean DATE, 
	max_occup INTEGER, 
	mech_struc VARCHAR(9), 
	number_plants INTEGER, 
	number_pets INTEGER, 
	number_resident INTEGER, 
	occup_document VARCHAR(15), 
	ext_wall_orient VARCHAR(9), 
	ext_window_orient VARCHAR(9), 
	rel_humidity_out TEXT, 
	pres_animal_insect TEXT, 
	quad_pos VARCHAR(10), 
	rel_samp_loc VARCHAR(13), 
	room_air_exch_rate TEXT, 
	room_architec_elem TEXT, 
	room_condt VARCHAR(28), 
	room_count INTEGER, 
	room_dim TEXT, 
	room_door_dist TEXT, 
	room_loc VARCHAR(13), 
	room_moist_dam_hist INTEGER, 
	room_net_area TEXT, 
	room_occup INTEGER, 
	room_samp_pos VARCHAR(16), 
	room_type VARCHAR(29), 
	room_vol TEXT, 
	room_window_count INTEGER, 
	room_connected VARCHAR(15), 
	room_hallway TEXT, 
	room_door_share TEXT, 
	room_wall_share TEXT, 
	samp_weather VARCHAR(9), 
	samp_floor VARCHAR(9), 
	samp_room_id INTEGER, 
	samp_time_out FLOAT, 
	season TEXT, 
	season_use VARCHAR(6), 
	shading_device_cond VARCHAR(12), 
	shading_device_loc TEXT, 
	shading_device_mat TEXT, 
	shad_dev_water_mold TEXT, 
	shading_device_type VARCHAR(21), 
	specific_humidity TEXT, 
	specific VARCHAR(12), 
	temp_out TEXT, 
	train_line VARCHAR(6), 
	train_stat_loc VARCHAR(26), 
	train_stop_loc VARCHAR(8), 
	vis_media VARCHAR(63), 
	wall_area TEXT, 
	wall_const_type VARCHAR(23), 
	wall_finish_mat VARCHAR(20), 
	wall_height TEXT, 
	wall_loc VARCHAR(5), 
	wall_water_mold TEXT, 
	wall_surf_treatment VARCHAR(12), 
	wall_texture VARCHAR(16), 
	wall_thermal_mass TEXT, 
	water_feat_size TEXT, 
	water_feat_type VARCHAR(16), 
	weekday VARCHAR(9), 
	window_size TEXT, 
	window_cond VARCHAR(12), 
	window_cover VARCHAR(8), 
	window_horiz_pos VARCHAR(6), 
	window_loc VARCHAR(5), 
	window_mat VARCHAR(10), 
	window_open_freq INTEGER, 
	window_water_mold TEXT, 
	window_status TEXT, 
	window_type VARCHAR(23), 
	window_vert_pos VARCHAR(6), 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	samp_vol_we_dna_ext TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, surf_material, surf_air_cont, rel_air_humidity, abs_air_humidity, surf_humidity, "temp", surf_temp, surf_moisture_ph, build_occup_type, surf_moisture, dew_point, carb_dioxide, ventilation_type, organism_count, indoor_space, indoor_surf, filter_type, heat_cool_type, substructure_type, building_setting, light_type, samp_sort_meth, space_typ_state, typ_occup_density, occup_samp, occup_density_samp, address, adj_room, aero_struc, amount_light, arch_struc, avg_occup, avg_dew_point, avg_temp, bathroom_count, bedroom_count, built_struc_age, built_struc_set, built_struc_type, ceil_area, ceil_cond, ceil_finish_mat, ceil_water_mold, ceil_struc, ceil_texture, ceil_thermal_mass, ceil_type, cool_syst_id, date_last_rain, build_docs, door_size, door_cond, door_direct, door_loc, door_mat, door_move, door_water_mold, door_type, door_comp_type, door_type_metal, door_type_wood, drawings, elevator, escalator, exp_duct, exp_pipe, ext_door, fireplace_type, floor_age, floor_area, floor_cond, floor_count, floor_finish_mat, floor_water_mold, floor_struc, floor_thermal_mass, freq_clean, freq_cook, furniture, gender_restroom, hall_count, handidness, heat_deliv_loc, heat_sys_deliv_meth, heat_system_id, height_carper_fiber, inside_lux, int_wall_cond, last_clean, max_occup, mech_struc, number_plants, number_pets, number_resident, occup_document, ext_wall_orient, ext_window_orient, rel_humidity_out, pres_animal_insect, quad_pos, rel_samp_loc, room_air_exch_rate, room_architec_elem, room_condt, room_count, room_dim, room_door_dist, room_loc, room_moist_dam_hist, room_net_area, room_occup, room_samp_pos, room_type, room_vol, room_window_count, room_connected, room_hallway, room_door_share, room_wall_share, samp_weather, samp_floor, samp_room_id, samp_time_out, season, season_use, shading_device_cond, shading_device_loc, shading_device_mat, shad_dev_water_mold, shading_device_type, specific_humidity, specific, temp_out, train_line, train_stat_loc, train_stop_loc, vis_media, wall_area, wall_const_type, wall_finish_mat, wall_height, wall_loc, wall_water_mold, wall_surf_treatment, wall_texture, wall_thermal_mass, water_feat_size, water_feat_type, weekday, window_size, window_cond, window_cover, window_horiz_pos, window_loc, window_mat, window_open_freq, window_water_mold, window_status, window_type, window_vert_pos, samp_name, project_name, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, samp_vol_we_dna_ext, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, associated_resource, sop)
);

CREATE TABLE "built_environment_MISAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	surf_material VARCHAR(15), 
	surf_air_cont VARCHAR(26), 
	rel_air_humidity TEXT NOT NULL, 
	abs_air_humidity TEXT NOT NULL, 
	surf_humidity TEXT, 
	"temp" TEXT NOT NULL, 
	surf_temp TEXT, 
	surf_moisture_ph FLOAT, 
	build_occup_type VARCHAR(14) NOT NULL, 
	surf_moisture TEXT, 
	dew_point TEXT, 
	carb_dioxide TEXT NOT NULL, 
	ventilation_type TEXT NOT NULL, 
	organism_count VARCHAR(5) NOT NULL, 
	indoor_space VARCHAR(11) NOT NULL, 
	indoor_surf VARCHAR(11), 
	filter_type VARCHAR(39) NOT NULL, 
	heat_cool_type VARCHAR(17) NOT NULL, 
	substructure_type VARCHAR(13), 
	building_setting VARCHAR(8) NOT NULL, 
	light_type VARCHAR(18) NOT NULL, 
	samp_sort_meth TEXT, 
	space_typ_state TEXT NOT NULL, 
	typ_occup_density FLOAT NOT NULL, 
	occup_samp INTEGER NOT NULL, 
	occup_density_samp FLOAT NOT NULL, 
	address TEXT, 
	adj_room TEXT, 
	aero_struc TEXT, 
	amount_light TEXT, 
	arch_struc VARCHAR(8), 
	avg_occup FLOAT, 
	avg_dew_point TEXT, 
	avg_temp TEXT, 
	bathroom_count INTEGER, 
	bedroom_count INTEGER, 
	built_struc_age TEXT, 
	built_struc_set TEXT, 
	built_struc_type TEXT, 
	ceil_area TEXT, 
	ceil_cond VARCHAR(12), 
	ceil_finish_mat VARCHAR(29), 
	ceil_water_mold TEXT, 
	ceil_struc TEXT, 
	ceil_texture VARCHAR(16), 
	ceil_thermal_mass TEXT, 
	ceil_type VARCHAR(13), 
	cool_syst_id INTEGER, 
	date_last_rain DATE, 
	build_docs VARCHAR(28), 
	door_size TEXT, 
	door_cond VARCHAR(12), 
	door_direct VARCHAR(8), 
	door_loc VARCHAR(5), 
	door_mat VARCHAR(22), 
	door_move VARCHAR(15), 
	door_water_mold TEXT, 
	door_type VARCHAR(9), 
	door_comp_type VARCHAR(13), 
	door_type_metal VARCHAR(16), 
	door_type_wood VARCHAR(24), 
	drawings VARCHAR(23), 
	elevator INTEGER, 
	escalator INTEGER, 
	exp_duct TEXT, 
	exp_pipe INTEGER, 
	ext_door INTEGER, 
	fireplace_type TEXT, 
	floor_age TEXT, 
	floor_area TEXT, 
	floor_cond VARCHAR(12), 
	floor_count INTEGER, 
	floor_finish_mat VARCHAR(22), 
	floor_water_mold VARCHAR(26), 
	floor_struc VARCHAR(14), 
	floor_thermal_mass TEXT, 
	freq_clean VARCHAR(9), 
	freq_cook INTEGER, 
	furniture VARCHAR(7), 
	gender_restroom VARCHAR(15), 
	hall_count INTEGER, 
	handidness VARCHAR(16), 
	heat_deliv_loc VARCHAR(5), 
	heat_sys_deliv_meth TEXT, 
	heat_system_id INTEGER, 
	height_carper_fiber TEXT, 
	inside_lux TEXT, 
	int_wall_cond VARCHAR(12), 
	last_clean DATE, 
	max_occup INTEGER, 
	mech_struc VARCHAR(9), 
	number_plants INTEGER, 
	number_pets INTEGER, 
	number_resident INTEGER, 
	occup_document VARCHAR(15), 
	ext_wall_orient VARCHAR(9), 
	ext_window_orient VARCHAR(9), 
	rel_humidity_out TEXT, 
	pres_animal_insect TEXT, 
	quad_pos VARCHAR(10), 
	rel_samp_loc VARCHAR(13), 
	room_air_exch_rate TEXT, 
	room_architec_elem TEXT, 
	room_condt VARCHAR(28), 
	room_count INTEGER, 
	room_dim TEXT, 
	room_door_dist TEXT, 
	room_loc VARCHAR(13), 
	room_moist_dam_hist INTEGER, 
	room_net_area TEXT, 
	room_occup INTEGER, 
	room_samp_pos VARCHAR(16), 
	room_type VARCHAR(29), 
	room_vol TEXT, 
	room_window_count INTEGER, 
	room_connected VARCHAR(15), 
	room_hallway TEXT, 
	room_door_share TEXT, 
	room_wall_share TEXT, 
	samp_weather VARCHAR(9), 
	samp_floor VARCHAR(9), 
	samp_room_id INTEGER, 
	samp_time_out FLOAT, 
	season TEXT, 
	season_use VARCHAR(6), 
	shading_device_cond VARCHAR(12), 
	shading_device_loc TEXT, 
	shading_device_mat TEXT, 
	shad_dev_water_mold TEXT, 
	shading_device_type VARCHAR(21), 
	specific_humidity TEXT, 
	specific VARCHAR(12), 
	temp_out TEXT, 
	train_line VARCHAR(6), 
	train_stat_loc VARCHAR(26), 
	train_stop_loc VARCHAR(8), 
	vis_media VARCHAR(63), 
	wall_area TEXT, 
	wall_const_type VARCHAR(23), 
	wall_finish_mat VARCHAR(20), 
	wall_height TEXT, 
	wall_loc VARCHAR(5), 
	wall_water_mold TEXT, 
	wall_surf_treatment VARCHAR(12), 
	wall_texture VARCHAR(16), 
	wall_thermal_mass TEXT, 
	water_feat_size TEXT, 
	water_feat_type VARCHAR(16), 
	weekday VARCHAR(9), 
	window_size TEXT, 
	window_cond VARCHAR(12), 
	window_cover VARCHAR(8), 
	window_horiz_pos VARCHAR(6), 
	window_loc VARCHAR(5), 
	window_mat VARCHAR(10), 
	window_open_freq INTEGER, 
	window_water_mold TEXT, 
	window_status TEXT, 
	window_type VARCHAR(23), 
	window_vert_pos VARCHAR(6), 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	samp_vol_we_dna_ext TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	sort_tech VARCHAR(28) NOT NULL, 
	single_cell_lysis_appr VARCHAR(11) NOT NULL, 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT NOT NULL, 
	wga_amp_kit TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, surf_material, surf_air_cont, rel_air_humidity, abs_air_humidity, surf_humidity, "temp", surf_temp, surf_moisture_ph, build_occup_type, surf_moisture, dew_point, carb_dioxide, ventilation_type, organism_count, indoor_space, indoor_surf, filter_type, heat_cool_type, substructure_type, building_setting, light_type, samp_sort_meth, space_typ_state, typ_occup_density, occup_samp, occup_density_samp, address, adj_room, aero_struc, amount_light, arch_struc, avg_occup, avg_dew_point, avg_temp, bathroom_count, bedroom_count, built_struc_age, built_struc_set, built_struc_type, ceil_area, ceil_cond, ceil_finish_mat, ceil_water_mold, ceil_struc, ceil_texture, ceil_thermal_mass, ceil_type, cool_syst_id, date_last_rain, build_docs, door_size, door_cond, door_direct, door_loc, door_mat, door_move, door_water_mold, door_type, door_comp_type, door_type_metal, door_type_wood, drawings, elevator, escalator, exp_duct, exp_pipe, ext_door, fireplace_type, floor_age, floor_area, floor_cond, floor_count, floor_finish_mat, floor_water_mold, floor_struc, floor_thermal_mass, freq_clean, freq_cook, furniture, gender_restroom, hall_count, handidness, heat_deliv_loc, heat_sys_deliv_meth, heat_system_id, height_carper_fiber, inside_lux, int_wall_cond, last_clean, max_occup, mech_struc, number_plants, number_pets, number_resident, occup_document, ext_wall_orient, ext_window_orient, rel_humidity_out, pres_animal_insect, quad_pos, rel_samp_loc, room_air_exch_rate, room_architec_elem, room_condt, room_count, room_dim, room_door_dist, room_loc, room_moist_dam_hist, room_net_area, room_occup, room_samp_pos, room_type, room_vol, room_window_count, room_connected, room_hallway, room_door_share, room_wall_share, samp_weather, samp_floor, samp_room_id, samp_time_out, season, season_use, shading_device_cond, shading_device_loc, shading_device_mat, shad_dev_water_mold, shading_device_type, specific_humidity, specific, temp_out, train_line, train_stat_loc, train_stop_loc, vis_media, wall_area, wall_const_type, wall_finish_mat, wall_height, wall_loc, wall_water_mold, wall_surf_treatment, wall_texture, wall_thermal_mass, water_feat_size, water_feat_type, weekday, window_size, window_cond, window_cover, window_horiz_pos, window_loc, window_mat, window_open_freq, window_water_mold, window_status, window_type, window_vert_pos, samp_name, project_name, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, samp_vol_we_dna_ext, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, associated_resource, sop)
);

CREATE TABLE "built_environment_MIUVIG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	surf_material VARCHAR(15), 
	surf_air_cont VARCHAR(26), 
	rel_air_humidity TEXT NOT NULL, 
	abs_air_humidity TEXT NOT NULL, 
	surf_humidity TEXT, 
	"temp" TEXT NOT NULL, 
	surf_temp TEXT, 
	surf_moisture_ph FLOAT, 
	build_occup_type VARCHAR(14) NOT NULL, 
	surf_moisture TEXT, 
	dew_point TEXT, 
	carb_dioxide TEXT NOT NULL, 
	ventilation_type TEXT NOT NULL, 
	organism_count VARCHAR(5) NOT NULL, 
	indoor_space VARCHAR(11) NOT NULL, 
	indoor_surf VARCHAR(11), 
	filter_type VARCHAR(39) NOT NULL, 
	heat_cool_type VARCHAR(17) NOT NULL, 
	substructure_type VARCHAR(13), 
	building_setting VARCHAR(8) NOT NULL, 
	light_type VARCHAR(18) NOT NULL, 
	samp_sort_meth TEXT, 
	space_typ_state TEXT NOT NULL, 
	typ_occup_density FLOAT NOT NULL, 
	occup_samp INTEGER NOT NULL, 
	occup_density_samp FLOAT NOT NULL, 
	address TEXT, 
	adj_room TEXT, 
	aero_struc TEXT, 
	amount_light TEXT, 
	arch_struc VARCHAR(8), 
	avg_occup FLOAT, 
	avg_dew_point TEXT, 
	avg_temp TEXT, 
	bathroom_count INTEGER, 
	bedroom_count INTEGER, 
	built_struc_age TEXT, 
	built_struc_set TEXT, 
	built_struc_type TEXT, 
	ceil_area TEXT, 
	ceil_cond VARCHAR(12), 
	ceil_finish_mat VARCHAR(29), 
	ceil_water_mold TEXT, 
	ceil_struc TEXT, 
	ceil_texture VARCHAR(16), 
	ceil_thermal_mass TEXT, 
	ceil_type VARCHAR(13), 
	cool_syst_id INTEGER, 
	date_last_rain DATE, 
	build_docs VARCHAR(28), 
	door_size TEXT, 
	door_cond VARCHAR(12), 
	door_direct VARCHAR(8), 
	door_loc VARCHAR(5), 
	door_mat VARCHAR(22), 
	door_move VARCHAR(15), 
	door_water_mold TEXT, 
	door_type VARCHAR(9), 
	door_comp_type VARCHAR(13), 
	door_type_metal VARCHAR(16), 
	door_type_wood VARCHAR(24), 
	drawings VARCHAR(23), 
	elevator INTEGER, 
	escalator INTEGER, 
	exp_duct TEXT, 
	exp_pipe INTEGER, 
	ext_door INTEGER, 
	fireplace_type TEXT, 
	floor_age TEXT, 
	floor_area TEXT, 
	floor_cond VARCHAR(12), 
	floor_count INTEGER, 
	floor_finish_mat VARCHAR(22), 
	floor_water_mold VARCHAR(26), 
	floor_struc VARCHAR(14), 
	floor_thermal_mass TEXT, 
	freq_clean VARCHAR(9), 
	freq_cook INTEGER, 
	furniture VARCHAR(7), 
	gender_restroom VARCHAR(15), 
	hall_count INTEGER, 
	handidness VARCHAR(16), 
	heat_deliv_loc VARCHAR(5), 
	heat_sys_deliv_meth TEXT, 
	heat_system_id INTEGER, 
	height_carper_fiber TEXT, 
	inside_lux TEXT, 
	int_wall_cond VARCHAR(12), 
	last_clean DATE, 
	max_occup INTEGER, 
	mech_struc VARCHAR(9), 
	number_plants INTEGER, 
	number_pets INTEGER, 
	number_resident INTEGER, 
	occup_document VARCHAR(15), 
	ext_wall_orient VARCHAR(9), 
	ext_window_orient VARCHAR(9), 
	rel_humidity_out TEXT, 
	pres_animal_insect TEXT, 
	quad_pos VARCHAR(10), 
	rel_samp_loc VARCHAR(13), 
	room_air_exch_rate TEXT, 
	room_architec_elem TEXT, 
	room_condt VARCHAR(28), 
	room_count INTEGER, 
	room_dim TEXT, 
	room_door_dist TEXT, 
	room_loc VARCHAR(13), 
	room_moist_dam_hist INTEGER, 
	room_net_area TEXT, 
	room_occup INTEGER, 
	room_samp_pos VARCHAR(16), 
	room_type VARCHAR(29), 
	room_vol TEXT, 
	room_window_count INTEGER, 
	room_connected VARCHAR(15), 
	room_hallway TEXT, 
	room_door_share TEXT, 
	room_wall_share TEXT, 
	samp_weather VARCHAR(9), 
	samp_floor VARCHAR(9), 
	samp_room_id INTEGER, 
	samp_time_out FLOAT, 
	season TEXT, 
	season_use VARCHAR(6), 
	shading_device_cond VARCHAR(12), 
	shading_device_loc TEXT, 
	shading_device_mat TEXT, 
	shad_dev_water_mold TEXT, 
	shading_device_type VARCHAR(21), 
	specific_humidity TEXT, 
	specific VARCHAR(12), 
	temp_out TEXT, 
	train_line VARCHAR(6), 
	train_stat_loc VARCHAR(26), 
	train_stop_loc VARCHAR(8), 
	vis_media VARCHAR(63), 
	wall_area TEXT, 
	wall_const_type VARCHAR(23), 
	wall_finish_mat VARCHAR(20), 
	wall_height TEXT, 
	wall_loc VARCHAR(5), 
	wall_water_mold TEXT, 
	wall_surf_treatment VARCHAR(12), 
	wall_texture VARCHAR(16), 
	wall_thermal_mass TEXT, 
	water_feat_size TEXT, 
	water_feat_type VARCHAR(16), 
	weekday VARCHAR(9), 
	window_size TEXT, 
	window_cond VARCHAR(12), 
	window_cover VARCHAR(8), 
	window_horiz_pos VARCHAR(6), 
	window_loc VARCHAR(5), 
	window_mat VARCHAR(10), 
	window_open_freq INTEGER, 
	window_water_mold TEXT, 
	window_status TEXT, 
	window_type VARCHAR(23), 
	window_vert_pos VARCHAR(6), 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	samp_vol_we_dna_ext TEXT, 
	source_uvig VARCHAR(42) NOT NULL, 
	virus_enrich_appr VARCHAR(25) NOT NULL, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	compl_appr VARCHAR(15), 
	sort_tech VARCHAR(28), 
	single_cell_lysis_appr VARCHAR(11), 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT, 
	wga_amp_kit TEXT, 
	bin_param VARCHAR(15), 
	bin_software TEXT, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	vir_ident_software TEXT NOT NULL, 
	pred_genome_type VARCHAR(15) NOT NULL, 
	pred_genome_struc VARCHAR(13) NOT NULL, 
	detec_type TEXT NOT NULL, 
	otu_class_appr TEXT, 
	otu_seq_comp_appr TEXT, 
	otu_db TEXT, 
	host_pred_appr VARCHAR(24), 
	host_pred_est_acc TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, surf_material, surf_air_cont, rel_air_humidity, abs_air_humidity, surf_humidity, "temp", surf_temp, surf_moisture_ph, build_occup_type, surf_moisture, dew_point, carb_dioxide, ventilation_type, organism_count, indoor_space, indoor_surf, filter_type, heat_cool_type, substructure_type, building_setting, light_type, samp_sort_meth, space_typ_state, typ_occup_density, occup_samp, occup_density_samp, address, adj_room, aero_struc, amount_light, arch_struc, avg_occup, avg_dew_point, avg_temp, bathroom_count, bedroom_count, built_struc_age, built_struc_set, built_struc_type, ceil_area, ceil_cond, ceil_finish_mat, ceil_water_mold, ceil_struc, ceil_texture, ceil_thermal_mass, ceil_type, cool_syst_id, date_last_rain, build_docs, door_size, door_cond, door_direct, door_loc, door_mat, door_move, door_water_mold, door_type, door_comp_type, door_type_metal, door_type_wood, drawings, elevator, escalator, exp_duct, exp_pipe, ext_door, fireplace_type, floor_age, floor_area, floor_cond, floor_count, floor_finish_mat, floor_water_mold, floor_struc, floor_thermal_mass, freq_clean, freq_cook, furniture, gender_restroom, hall_count, handidness, heat_deliv_loc, heat_sys_deliv_meth, heat_system_id, height_carper_fiber, inside_lux, int_wall_cond, last_clean, max_occup, mech_struc, number_plants, number_pets, number_resident, occup_document, ext_wall_orient, ext_window_orient, rel_humidity_out, pres_animal_insect, quad_pos, rel_samp_loc, room_air_exch_rate, room_architec_elem, room_condt, room_count, room_dim, room_door_dist, room_loc, room_moist_dam_hist, room_net_area, room_occup, room_samp_pos, room_type, room_vol, room_window_count, room_connected, room_hallway, room_door_share, room_wall_share, samp_weather, samp_floor, samp_room_id, samp_time_out, season, season_use, shading_device_cond, shading_device_loc, shading_device_mat, shad_dev_water_mold, shading_device_type, specific_humidity, specific, temp_out, train_line, train_stat_loc, train_stop_loc, vis_media, wall_area, wall_const_type, wall_finish_mat, wall_height, wall_loc, wall_water_mold, wall_surf_treatment, wall_texture, wall_thermal_mass, water_feat_size, water_feat_type, weekday, window_size, window_cond, window_cover, window_horiz_pos, window_loc, window_mat, window_open_freq, window_water_mold, window_status, window_type, window_vert_pos, samp_name, project_name, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, samp_vol_we_dna_ext, source_uvig, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, trnas, trna_ext_software, compl_score, compl_software, compl_appr, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, bin_param, bin_software, reassembly_bin, mag_cov_software, vir_ident_software, pred_genome_type, pred_genome_struc, detec_type, otu_class_appr, otu_seq_comp_appr, otu_db, host_pred_appr, host_pred_est_acc, associated_resource, sop)
);

CREATE TABLE core (
	samp_name TEXT, 
	samp_taxon_id TEXT, 
	project_name TEXT, 
	experimental_factor TEXT, 
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	subspecf_gen_lin TEXT, 
	ploidy TEXT, 
	num_replicons INTEGER, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	trophic_level VARCHAR(22), 
	propagation TEXT, 
	encoded_traits TEXT, 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	samp_vol_we_dna_ext TEXT, 
	source_uvig VARCHAR(42), 
	virus_enrich_appr VARCHAR(25), 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	target_gene TEXT, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	mid TEXT, 
	adapters TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	compl_appr VARCHAR(15), 
	contam_score TEXT, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	sort_tech VARCHAR(28), 
	single_cell_lysis_appr VARCHAR(11), 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT, 
	wga_amp_kit TEXT, 
	bin_param VARCHAR(15), 
	bin_software TEXT, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	vir_ident_software TEXT, 
	pred_genome_type VARCHAR(15), 
	pred_genome_struc VARCHAR(13), 
	detec_type TEXT, 
	otu_class_appr TEXT, 
	otu_seq_comp_appr TEXT, 
	otu_db TEXT, 
	host_pred_appr VARCHAR(24), 
	host_pred_est_acc TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (samp_name, samp_taxon_id, project_name, experimental_factor, lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, neg_cont_type, pos_cont_type, env_broad_scale, env_local_scale, env_medium, subspecf_gen_lin, ploidy, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, trophic_level, propagation, encoded_traits, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, samp_vol_we_dna_ext, source_uvig, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, pcr_primers, mid, adapters, pcr_cond, seq_meth, seq_quality_check, chimera_check, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, bin_param, bin_software, reassembly_bin, mag_cov_software, vir_ident_software, pred_genome_type, pred_genome_struc, detec_type, otu_class_appr, otu_seq_comp_appr, otu_db, host_pred_appr, host_pred_est_acc, associated_resource, sop)
);

CREATE TABLE food_animal_and_animal_feed (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	samp_transport_cont VARCHAR(25), 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_origin TEXT NOT NULL, 
	food_prod TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	food_source TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	intended_consumer TEXT NOT NULL, 
	samp_purpose TEXT NOT NULL, 
	animal_am TEXT, 
	animal_am_dur TEXT, 
	animal_am_freq TEXT, 
	animal_am_route TEXT, 
	animal_am_use TEXT, 
	animal_body_cond VARCHAR(17), 
	animal_diet TEXT, 
	animal_feed_equip TEXT, 
	animal_group_size INTEGER, 
	animal_housing TEXT, 
	animal_sex VARCHAR(16), 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_ingredient TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source_age TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	samp_collect_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, samp_transport_cont, perturbation, coll_site_geo_feat, food_origin, food_prod, food_product_type, food_source, "IFSAC_category", intended_consumer, samp_purpose, animal_am, animal_am_dur, animal_am_freq, animal_am_route, animal_am_use, animal_body_cond, animal_diet, animal_feed_equip, animal_group_size, animal_housing, animal_sex, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, enrichment_protocol, food_additive, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_dis_point_city, food_ingredient, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod_synonym, food_product_qual, food_quality_date, food_source_age, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", library_prep_kit, lot_number, microb_cult_med, part_plant_animal, repository_name, samp_collect_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_dur, samp_transport_temp, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext)
);

CREATE TABLE "food_animal_and_animal_feed_MIGS_bacteria" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_origin TEXT NOT NULL, 
	food_prod TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	food_source TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	intended_consumer TEXT NOT NULL, 
	samp_purpose TEXT NOT NULL, 
	animal_am TEXT, 
	animal_am_dur TEXT, 
	animal_am_freq TEXT, 
	animal_am_route TEXT, 
	animal_am_use TEXT, 
	animal_body_cond VARCHAR(17), 
	animal_diet TEXT, 
	animal_feed_equip TEXT, 
	animal_group_size INTEGER, 
	animal_housing TEXT, 
	animal_sex VARCHAR(16), 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_ingredient TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source_age TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	samp_collect_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER NOT NULL, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT NOT NULL, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	trophic_level VARCHAR(22), 
	encoded_traits TEXT, 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, perturbation, coll_site_geo_feat, food_origin, food_prod, food_product_type, food_source, "IFSAC_category", intended_consumer, samp_purpose, animal_am, animal_am_dur, animal_am_freq, animal_am_route, animal_am_use, animal_body_cond, animal_diet, animal_feed_equip, animal_group_size, animal_housing, animal_sex, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, enrichment_protocol, food_additive, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_dis_point_city, food_ingredient, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod_synonym, food_product_qual, food_quality_date, food_source_age, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", library_prep_kit, lot_number, microb_cult_med, part_plant_animal, repository_name, samp_collect_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, trophic_level, encoded_traits, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "food_animal_and_animal_feed_MIGS_eukaryote" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_origin TEXT NOT NULL, 
	food_prod TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	food_source TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	intended_consumer TEXT NOT NULL, 
	samp_purpose TEXT NOT NULL, 
	animal_am TEXT, 
	animal_am_dur TEXT, 
	animal_am_freq TEXT, 
	animal_am_route TEXT, 
	animal_am_use TEXT, 
	animal_body_cond VARCHAR(17), 
	animal_diet TEXT, 
	animal_feed_equip TEXT, 
	animal_group_size INTEGER, 
	animal_housing TEXT, 
	animal_sex VARCHAR(16), 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_ingredient TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source_age TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	samp_collect_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	ploidy TEXT, 
	num_replicons INTEGER, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	trophic_level VARCHAR(22), 
	propagation TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, perturbation, coll_site_geo_feat, food_origin, food_prod, food_product_type, food_source, "IFSAC_category", intended_consumer, samp_purpose, animal_am, animal_am_dur, animal_am_freq, animal_am_route, animal_am_use, animal_body_cond, animal_diet, animal_feed_equip, animal_group_size, animal_housing, animal_sex, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, enrichment_protocol, food_additive, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_dis_point_city, food_ingredient, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod_synonym, food_product_qual, food_quality_date, food_source_age, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", library_prep_kit, lot_number, microb_cult_med, part_plant_animal, repository_name, samp_collect_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, subspecf_gen_lin, ploidy, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, trophic_level, propagation, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "food_animal_and_animal_feed_MIGS_org" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_origin TEXT NOT NULL, 
	food_prod TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	food_source TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	intended_consumer TEXT NOT NULL, 
	samp_purpose TEXT NOT NULL, 
	animal_am TEXT, 
	animal_am_dur TEXT, 
	animal_am_freq TEXT, 
	animal_am_route TEXT, 
	animal_am_use TEXT, 
	animal_body_cond VARCHAR(17), 
	animal_diet TEXT, 
	animal_feed_equip TEXT, 
	animal_group_size INTEGER, 
	animal_housing TEXT, 
	animal_sex VARCHAR(16), 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_ingredient TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source_age TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	samp_collect_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, perturbation, coll_site_geo_feat, food_origin, food_prod, food_product_type, food_source, "IFSAC_category", intended_consumer, samp_purpose, animal_am, animal_am_dur, animal_am_freq, animal_am_route, animal_am_use, animal_body_cond, animal_diet, animal_feed_equip, animal_group_size, animal_housing, animal_sex, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, enrichment_protocol, food_additive, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_dis_point_city, food_ingredient, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod_synonym, food_product_qual, food_quality_date, food_source_age, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", library_prep_kit, lot_number, microb_cult_med, part_plant_animal, repository_name, samp_collect_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "food_animal_and_animal_feed_MIGS_plant" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_origin TEXT NOT NULL, 
	food_prod TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	food_source TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	intended_consumer TEXT NOT NULL, 
	samp_purpose TEXT NOT NULL, 
	animal_am TEXT, 
	animal_am_dur TEXT, 
	animal_am_freq TEXT, 
	animal_am_route TEXT, 
	animal_am_use TEXT, 
	animal_body_cond VARCHAR(17), 
	animal_diet TEXT, 
	animal_feed_equip TEXT, 
	animal_group_size INTEGER, 
	animal_housing TEXT, 
	animal_sex VARCHAR(16), 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_ingredient TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source_age TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	samp_collect_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, perturbation, coll_site_geo_feat, food_origin, food_prod, food_product_type, food_source, "IFSAC_category", intended_consumer, samp_purpose, animal_am, animal_am_dur, animal_am_freq, animal_am_route, animal_am_use, animal_body_cond, animal_diet, animal_feed_equip, animal_group_size, animal_housing, animal_sex, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, enrichment_protocol, food_additive, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_dis_point_city, food_ingredient, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod_synonym, food_product_qual, food_quality_date, food_source_age, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", library_prep_kit, lot_number, microb_cult_med, part_plant_animal, repository_name, samp_collect_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, subspecf_gen_lin, estimated_size, ref_biomaterial, source_mat_id, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "food_animal_and_animal_feed_MIGS_virus" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_origin TEXT NOT NULL, 
	food_prod TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	food_source TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	intended_consumer TEXT NOT NULL, 
	samp_purpose TEXT NOT NULL, 
	animal_am TEXT, 
	animal_am_dur TEXT, 
	animal_am_freq TEXT, 
	animal_am_route TEXT, 
	animal_am_use TEXT, 
	animal_body_cond VARCHAR(17), 
	animal_diet TEXT, 
	animal_feed_equip TEXT, 
	animal_group_size INTEGER, 
	animal_housing TEXT, 
	animal_sex VARCHAR(16), 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_ingredient TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source_age TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	samp_collect_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	virus_enrich_appr VARCHAR(25), 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, perturbation, coll_site_geo_feat, food_origin, food_prod, food_product_type, food_source, "IFSAC_category", intended_consumer, samp_purpose, animal_am, animal_am_dur, animal_am_freq, animal_am_route, animal_am_use, animal_body_cond, animal_diet, animal_feed_equip, animal_group_size, animal_housing, animal_sex, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, enrichment_protocol, food_additive, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_dis_point_city, food_ingredient, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod_synonym, food_product_qual, food_quality_date, food_source_age, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", library_prep_kit, lot_number, microb_cult_med, part_plant_animal, repository_name, samp_collect_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, virus_enrich_appr, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "food_animal_and_animal_feed_MIMAG" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_origin TEXT NOT NULL, 
	food_prod TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	food_source TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	intended_consumer TEXT NOT NULL, 
	samp_purpose TEXT NOT NULL, 
	animal_am TEXT, 
	animal_am_dur TEXT, 
	animal_am_freq TEXT, 
	animal_am_route TEXT, 
	animal_am_use TEXT, 
	animal_body_cond VARCHAR(17), 
	animal_diet TEXT, 
	animal_feed_equip TEXT, 
	animal_group_size INTEGER, 
	animal_housing TEXT, 
	animal_sex VARCHAR(16), 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_ingredient TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source_age TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	samp_collect_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	bin_param VARCHAR(15) NOT NULL, 
	bin_software TEXT NOT NULL, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, perturbation, coll_site_geo_feat, food_origin, food_prod, food_product_type, food_source, "IFSAC_category", intended_consumer, samp_purpose, animal_am, animal_am_dur, animal_am_freq, animal_am_route, animal_am_use, animal_body_cond, animal_diet, animal_feed_equip, animal_group_size, animal_housing, animal_sex, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, enrichment_protocol, food_additive, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_dis_point_city, food_ingredient, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod_synonym, food_product_qual, food_quality_date, food_source_age, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", library_prep_kit, lot_number, microb_cult_med, part_plant_animal, repository_name, samp_collect_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, bin_param, bin_software, reassembly_bin, mag_cov_software, associated_resource, sop)
);

CREATE TABLE "food_animal_and_animal_feed_MIMARKS_specimen" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_origin TEXT NOT NULL, 
	food_prod TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	food_source TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	intended_consumer TEXT NOT NULL, 
	samp_purpose TEXT NOT NULL, 
	animal_am TEXT, 
	animal_am_dur TEXT, 
	animal_am_freq TEXT, 
	animal_am_route TEXT, 
	animal_am_use TEXT, 
	animal_body_cond VARCHAR(17), 
	animal_diet TEXT, 
	animal_feed_equip TEXT, 
	animal_group_size INTEGER, 
	animal_housing TEXT, 
	animal_sex VARCHAR(16), 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_ingredient TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source_age TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	samp_collect_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	mid TEXT, 
	adapters TEXT, 
	pcr_cond TEXT, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	assembly_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, perturbation, coll_site_geo_feat, food_origin, food_prod, food_product_type, food_source, "IFSAC_category", intended_consumer, samp_purpose, animal_am, animal_am_dur, animal_am_freq, animal_am_route, animal_am_use, animal_body_cond, animal_diet, animal_feed_equip, animal_group_size, animal_housing, animal_sex, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, enrichment_protocol, food_additive, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_dis_point_city, food_ingredient, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod_synonym, food_product_qual, food_quality_date, food_source_age, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", library_prep_kit, lot_number, microb_cult_med, part_plant_animal, repository_name, samp_collect_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, pcr_primers, mid, adapters, pcr_cond, seq_quality_check, chimera_check, assembly_software, associated_resource, sop)
);

CREATE TABLE "food_animal_and_animal_feed_MIMARKS_survey" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_origin TEXT NOT NULL, 
	food_prod TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	food_source TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	intended_consumer TEXT NOT NULL, 
	samp_purpose TEXT NOT NULL, 
	animal_am TEXT, 
	animal_am_dur TEXT, 
	animal_am_freq TEXT, 
	animal_am_route TEXT, 
	animal_am_use TEXT, 
	animal_body_cond VARCHAR(17), 
	animal_diet TEXT, 
	animal_feed_equip TEXT, 
	animal_group_size INTEGER, 
	animal_housing TEXT, 
	animal_sex VARCHAR(16), 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_ingredient TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source_age TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	samp_collect_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	source_mat_id TEXT, 
	biotic_relationship VARCHAR(11), 
	trophic_level VARCHAR(22), 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	nucl_acid_amp TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	pcr_cond TEXT, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, perturbation, coll_site_geo_feat, food_origin, food_prod, food_product_type, food_source, "IFSAC_category", intended_consumer, samp_purpose, animal_am, animal_am_dur, animal_am_freq, animal_am_route, animal_am_use, animal_body_cond, animal_diet, animal_feed_equip, animal_group_size, animal_housing, animal_sex, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, enrichment_protocol, food_additive, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_dis_point_city, food_ingredient, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod_synonym, food_product_qual, food_quality_date, food_source_age, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", library_prep_kit, lot_number, microb_cult_med, part_plant_animal, repository_name, samp_collect_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, source_mat_id, biotic_relationship, trophic_level, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, nucl_acid_amp, target_gene, target_subfragment, pcr_primers, pcr_cond, seq_quality_check, chimera_check, associated_resource, sop)
);

CREATE TABLE "food_animal_and_animal_feed_MIMS" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_origin TEXT NOT NULL, 
	food_prod TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	food_source TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	intended_consumer TEXT NOT NULL, 
	samp_purpose TEXT NOT NULL, 
	animal_am TEXT, 
	animal_am_dur TEXT, 
	animal_am_freq TEXT, 
	animal_am_route TEXT, 
	animal_am_use TEXT, 
	animal_body_cond VARCHAR(17), 
	animal_diet TEXT, 
	animal_feed_equip TEXT, 
	animal_group_size INTEGER, 
	animal_housing TEXT, 
	animal_sex VARCHAR(16), 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_ingredient TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source_age TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	samp_collect_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, perturbation, coll_site_geo_feat, food_origin, food_prod, food_product_type, food_source, "IFSAC_category", intended_consumer, samp_purpose, animal_am, animal_am_dur, animal_am_freq, animal_am_route, animal_am_use, animal_body_cond, animal_diet, animal_feed_equip, animal_group_size, animal_housing, animal_sex, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, enrichment_protocol, food_additive, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_dis_point_city, food_ingredient, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod_synonym, food_product_qual, food_quality_date, food_source_age, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", library_prep_kit, lot_number, microb_cult_med, part_plant_animal, repository_name, samp_collect_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, associated_resource, sop)
);

CREATE TABLE "food_animal_and_animal_feed_MISAG" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_origin TEXT NOT NULL, 
	food_prod TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	food_source TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	intended_consumer TEXT NOT NULL, 
	samp_purpose TEXT NOT NULL, 
	animal_am TEXT, 
	animal_am_dur TEXT, 
	animal_am_freq TEXT, 
	animal_am_route TEXT, 
	animal_am_use TEXT, 
	animal_body_cond VARCHAR(17), 
	animal_diet TEXT, 
	animal_feed_equip TEXT, 
	animal_group_size INTEGER, 
	animal_housing TEXT, 
	animal_sex VARCHAR(16), 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_ingredient TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source_age TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	samp_collect_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	sort_tech VARCHAR(28) NOT NULL, 
	single_cell_lysis_appr VARCHAR(11) NOT NULL, 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT NOT NULL, 
	wga_amp_kit TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, perturbation, coll_site_geo_feat, food_origin, food_prod, food_product_type, food_source, "IFSAC_category", intended_consumer, samp_purpose, animal_am, animal_am_dur, animal_am_freq, animal_am_route, animal_am_use, animal_body_cond, animal_diet, animal_feed_equip, animal_group_size, animal_housing, animal_sex, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, enrichment_protocol, food_additive, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_dis_point_city, food_ingredient, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod_synonym, food_product_qual, food_quality_date, food_source_age, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", library_prep_kit, lot_number, microb_cult_med, part_plant_animal, repository_name, samp_collect_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, associated_resource, sop)
);

CREATE TABLE "food_animal_and_animal_feed_MIUVIG" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_origin TEXT NOT NULL, 
	food_prod TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	food_source TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	intended_consumer TEXT NOT NULL, 
	samp_purpose TEXT NOT NULL, 
	animal_am TEXT, 
	animal_am_dur TEXT, 
	animal_am_freq TEXT, 
	animal_am_route TEXT, 
	animal_am_use TEXT, 
	animal_body_cond VARCHAR(17), 
	animal_diet TEXT, 
	animal_feed_equip TEXT, 
	animal_group_size INTEGER, 
	animal_housing TEXT, 
	animal_sex VARCHAR(16), 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_ingredient TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source_age TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	samp_collect_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	source_uvig VARCHAR(42) NOT NULL, 
	virus_enrich_appr VARCHAR(25) NOT NULL, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	compl_appr VARCHAR(15), 
	sort_tech VARCHAR(28), 
	single_cell_lysis_appr VARCHAR(11), 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT, 
	wga_amp_kit TEXT, 
	bin_param VARCHAR(15), 
	bin_software TEXT, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	vir_ident_software TEXT NOT NULL, 
	pred_genome_type VARCHAR(15) NOT NULL, 
	pred_genome_struc VARCHAR(13) NOT NULL, 
	detec_type TEXT NOT NULL, 
	otu_class_appr TEXT, 
	otu_seq_comp_appr TEXT, 
	otu_db TEXT, 
	host_pred_appr VARCHAR(24), 
	host_pred_est_acc TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, perturbation, coll_site_geo_feat, food_origin, food_prod, food_product_type, food_source, "IFSAC_category", intended_consumer, samp_purpose, animal_am, animal_am_dur, animal_am_freq, animal_am_route, animal_am_use, animal_body_cond, animal_diet, animal_feed_equip, animal_group_size, animal_housing, animal_sex, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, enrichment_protocol, food_additive, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_dis_point_city, food_ingredient, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod_synonym, food_product_qual, food_quality_date, food_source_age, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", library_prep_kit, lot_number, microb_cult_med, part_plant_animal, repository_name, samp_collect_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, source_uvig, virus_enrich_appr, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, trnas, trna_ext_software, compl_score, compl_software, compl_appr, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, bin_param, bin_software, reassembly_bin, mag_cov_software, vir_ident_software, pred_genome_type, pred_genome_struc, detec_type, otu_class_appr, otu_seq_comp_appr, otu_db, host_pred_appr, host_pred_est_acc, associated_resource, sop)
);

CREATE TABLE food_farm_environment (
	lat_lon TEXT NOT NULL, 
	depth TEXT NOT NULL, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	humidity TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	samp_stor_dur TEXT, 
	wind_speed TEXT, 
	salinity TEXT, 
	previous_land_use TEXT, 
	crop_rotation TEXT, 
	soil_type_meth TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro_cont_meth TEXT, 
	salinity_meth TEXT, 
	host_age TEXT, 
	host_dry_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_tot_mass TEXT, 
	root_med_carbon TEXT, 
	root_med_macronutr TEXT, 
	root_med_micronutr TEXT, 
	season_temp TEXT, 
	season_precpt TEXT, 
	tot_org_carb TEXT, 
	tot_nitro_content TEXT, 
	conduc TEXT, 
	turbidity TEXT, 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	ventilation_type TEXT, 
	wind_direction TEXT, 
	genetic_mod TEXT, 
	host_phenotype TEXT, 
	ph FLOAT, 
	ances_data TEXT, 
	biotic_regm TEXT NOT NULL, 
	chem_administration TEXT NOT NULL, 
	growth_habit VARCHAR(10), 
	host_genotype TEXT, 
	host_taxid TEXT, 
	mechanical_damage TEXT, 
	perturbation TEXT, 
	root_cond TEXT, 
	root_med_ph FLOAT, 
	tillage VARCHAR(13), 
	ph_meth TEXT, 
	growth_medium TEXT, 
	season TEXT, 
	food_product_type TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	farm_water_source VARCHAR(19), 
	plant_water_method TEXT, 
	"air_PM_concen" TEXT, 
	animal_feed_equip TEXT, 
	animal_intrusion TEXT, 
	anim_water_method TEXT, 
	crop_yield TEXT, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	plant_part_maturity TEXT, 
	adjacent_environment TEXT, 
	water_source_adjac TEXT, 
	farm_equip_shared TEXT, 
	farm_equip_san TEXT, 
	farm_equip_san_freq TEXT, 
	farm_equip TEXT, 
	fertilizer_admin TEXT, 
	fertilizer_date DATE, 
	animal_group_size INTEGER, 
	animal_diet TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_harvest_proc TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_source TEXT, 
	food_treat_proc TEXT, 
	extr_weather_event VARCHAR(28), 
	date_extr_weath DATE, 
	host_subspecf_genlin TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	air_flow_impede TEXT, 
	lot_number TEXT, 
	season_humidity TEXT, 
	part_plant_animal TEXT, 
	plant_growth_med VARCHAR(30), 
	plant_reprod_crop VARCHAR(18), 
	samp_purpose TEXT, 
	repository_name TEXT, 
	samp_pooling TEXT, 
	samp_source_mat_cat TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	soil_conductivity TEXT, 
	soil_cover TEXT, 
	"soil_pH" FLOAT, 
	rel_location TEXT, 
	soil_porosity TEXT, 
	soil_texture_class VARCHAR(15), 
	soil_texture_meth TEXT, 
	soil_type TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_growth_med TEXT, 
	spikein_strain TEXT, 
	spikein_antibiotic TEXT, 
	spikein_metal TEXT, 
	timepoint FLOAT, 
	water_frequency TEXT, 
	"water_pH" FLOAT, 
	water_source_shared VARCHAR(27), 
	enrichment_protocol TEXT, 
	food_quality_date TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	animal_housing TEXT, 
	cult_isol_date DATE, 
	food_clean_proc VARCHAR(30), 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	host_disease_stat TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, humidity, organism_count, spikein_count, samp_stor_temp, solar_irradiance, ventilation_rate, samp_stor_dur, wind_speed, salinity, previous_land_use, crop_rotation, soil_type_meth, tot_org_c_meth, tot_nitro_cont_meth, salinity_meth, host_age, host_dry_mass, host_height, host_length, host_tot_mass, root_med_carbon, root_med_macronutr, root_med_micronutr, season_temp, season_precpt, tot_org_carb, tot_nitro_content, conduc, turbidity, size_frac_low, size_frac_up, ventilation_type, wind_direction, genetic_mod, host_phenotype, ph, ances_data, biotic_regm, chem_administration, growth_habit, host_genotype, host_taxid, mechanical_damage, perturbation, root_cond, root_med_ph, tillage, ph_meth, growth_medium, season, food_product_type, samp_type, farm_water_source, plant_water_method, "air_PM_concen", animal_feed_equip, animal_intrusion, anim_water_method, crop_yield, cult_result, cult_result_org, cult_target, plant_part_maturity, adjacent_environment, water_source_adjac, farm_equip_shared, farm_equip_san, farm_equip_san_freq, farm_equip, fertilizer_admin, fertilizer_date, animal_group_size, animal_diet, food_contact_surf, food_contain_wrap, food_harvest_proc, food_pack_medium, food_preserv_proc, food_prod_char, prod_label_claims, food_trav_mode, food_trav_vehic, food_source, food_treat_proc, extr_weather_event, date_extr_weath, host_subspecf_genlin, intended_consumer, library_prep_kit, air_flow_impede, lot_number, season_humidity, part_plant_animal, plant_growth_med, plant_reprod_crop, samp_purpose, repository_name, samp_pooling, samp_source_mat_cat, sequencing_kit, sequencing_location, serovar_or_serotype, soil_conductivity, soil_cover, "soil_pH", rel_location, soil_porosity, soil_texture_class, soil_texture_meth, soil_type, spikein_org, spikein_serovar, spikein_growth_med, spikein_strain, spikein_antibiotic, spikein_metal, timepoint, water_frequency, "water_pH", water_source_shared, enrichment_protocol, food_quality_date, "IFSAC_category", animal_housing, cult_isol_date, food_clean_proc, misc_param, samp_name, project_name, seq_meth, samp_size, nucl_acid_ext, samp_vol_we_dna_ext, host_disease_stat)
);

CREATE TABLE "food_farm_environment_MIGS_bacteria" (
	lat_lon TEXT NOT NULL, 
	depth TEXT NOT NULL, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	humidity TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	samp_stor_dur TEXT, 
	wind_speed TEXT, 
	salinity TEXT, 
	previous_land_use TEXT, 
	crop_rotation TEXT, 
	soil_type_meth TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro_cont_meth TEXT, 
	salinity_meth TEXT, 
	host_age TEXT, 
	host_dry_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_tot_mass TEXT, 
	root_med_carbon TEXT, 
	root_med_macronutr TEXT, 
	root_med_micronutr TEXT, 
	season_temp TEXT, 
	season_precpt TEXT, 
	tot_org_carb TEXT, 
	tot_nitro_content TEXT, 
	conduc TEXT, 
	turbidity TEXT, 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	ventilation_type TEXT, 
	wind_direction TEXT, 
	genetic_mod TEXT, 
	host_phenotype TEXT, 
	ph FLOAT, 
	ances_data TEXT, 
	biotic_regm TEXT NOT NULL, 
	chem_administration TEXT NOT NULL, 
	growth_habit VARCHAR(10), 
	host_genotype TEXT, 
	host_taxid TEXT, 
	mechanical_damage TEXT, 
	perturbation TEXT, 
	root_cond TEXT, 
	root_med_ph FLOAT, 
	tillage VARCHAR(13), 
	ph_meth TEXT, 
	growth_medium TEXT, 
	season TEXT, 
	food_product_type TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	farm_water_source VARCHAR(19), 
	plant_water_method TEXT, 
	"air_PM_concen" TEXT, 
	animal_feed_equip TEXT, 
	animal_intrusion TEXT, 
	anim_water_method TEXT, 
	crop_yield TEXT, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	plant_part_maturity TEXT, 
	adjacent_environment TEXT, 
	water_source_adjac TEXT, 
	farm_equip_shared TEXT, 
	farm_equip_san TEXT, 
	farm_equip_san_freq TEXT, 
	farm_equip TEXT, 
	fertilizer_admin TEXT, 
	fertilizer_date DATE, 
	animal_group_size INTEGER, 
	animal_diet TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_harvest_proc TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_source TEXT, 
	food_treat_proc TEXT, 
	extr_weather_event VARCHAR(28), 
	date_extr_weath DATE, 
	host_subspecf_genlin TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	air_flow_impede TEXT, 
	lot_number TEXT, 
	season_humidity TEXT, 
	part_plant_animal TEXT, 
	plant_growth_med VARCHAR(30), 
	plant_reprod_crop VARCHAR(18), 
	samp_purpose TEXT, 
	repository_name TEXT, 
	samp_pooling TEXT, 
	samp_source_mat_cat TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	soil_conductivity TEXT, 
	soil_cover TEXT, 
	"soil_pH" FLOAT, 
	rel_location TEXT, 
	soil_porosity TEXT, 
	"temp" TEXT, 
	soil_texture_class VARCHAR(15), 
	soil_texture_meth TEXT, 
	soil_type TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_growth_med TEXT, 
	spikein_strain TEXT, 
	spikein_antibiotic TEXT, 
	spikein_metal TEXT, 
	timepoint FLOAT, 
	water_frequency TEXT, 
	"water_pH" FLOAT, 
	water_source_shared VARCHAR(27), 
	enrichment_protocol TEXT, 
	food_quality_date TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	animal_housing TEXT, 
	cult_isol_date DATE, 
	food_clean_proc VARCHAR(30), 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	host_disease_stat TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER NOT NULL, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT NOT NULL, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	trophic_level VARCHAR(22), 
	encoded_traits TEXT, 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, humidity, organism_count, spikein_count, samp_stor_temp, solar_irradiance, ventilation_rate, samp_stor_dur, wind_speed, salinity, previous_land_use, crop_rotation, soil_type_meth, tot_org_c_meth, tot_nitro_cont_meth, salinity_meth, host_age, host_dry_mass, host_height, host_length, host_tot_mass, root_med_carbon, root_med_macronutr, root_med_micronutr, season_temp, season_precpt, tot_org_carb, tot_nitro_content, conduc, turbidity, size_frac_low, size_frac_up, ventilation_type, wind_direction, genetic_mod, host_phenotype, ph, ances_data, biotic_regm, chem_administration, growth_habit, host_genotype, host_taxid, mechanical_damage, perturbation, root_cond, root_med_ph, tillage, ph_meth, growth_medium, season, food_product_type, samp_type, farm_water_source, plant_water_method, "air_PM_concen", animal_feed_equip, animal_intrusion, anim_water_method, crop_yield, cult_result, cult_result_org, cult_target, plant_part_maturity, adjacent_environment, water_source_adjac, farm_equip_shared, farm_equip_san, farm_equip_san_freq, farm_equip, fertilizer_admin, fertilizer_date, animal_group_size, animal_diet, food_contact_surf, food_contain_wrap, food_harvest_proc, food_pack_medium, food_preserv_proc, food_prod_char, prod_label_claims, food_trav_mode, food_trav_vehic, food_source, food_treat_proc, extr_weather_event, date_extr_weath, host_subspecf_genlin, intended_consumer, library_prep_kit, air_flow_impede, lot_number, season_humidity, part_plant_animal, plant_growth_med, plant_reprod_crop, samp_purpose, repository_name, samp_pooling, samp_source_mat_cat, sequencing_kit, sequencing_location, serovar_or_serotype, soil_conductivity, soil_cover, "soil_pH", rel_location, soil_porosity, "temp", soil_texture_class, soil_texture_meth, soil_type, spikein_org, spikein_serovar, spikein_growth_med, spikein_strain, spikein_antibiotic, spikein_metal, timepoint, water_frequency, "water_pH", water_source_shared, enrichment_protocol, food_quality_date, "IFSAC_category", animal_housing, cult_isol_date, food_clean_proc, misc_param, samp_name, project_name, seq_meth, samp_size, nucl_acid_ext, samp_vol_we_dna_ext, host_disease_stat, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, trophic_level, encoded_traits, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "food_farm_environment_MIGS_eukaryote" (
	lat_lon TEXT NOT NULL, 
	depth TEXT NOT NULL, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	humidity TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	samp_stor_dur TEXT, 
	wind_speed TEXT, 
	salinity TEXT, 
	previous_land_use TEXT, 
	crop_rotation TEXT, 
	soil_type_meth TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro_cont_meth TEXT, 
	salinity_meth TEXT, 
	host_age TEXT, 
	host_dry_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_tot_mass TEXT, 
	root_med_carbon TEXT, 
	root_med_macronutr TEXT, 
	root_med_micronutr TEXT, 
	season_temp TEXT, 
	season_precpt TEXT, 
	tot_org_carb TEXT, 
	tot_nitro_content TEXT, 
	conduc TEXT, 
	turbidity TEXT, 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	ventilation_type TEXT, 
	wind_direction TEXT, 
	genetic_mod TEXT, 
	host_phenotype TEXT, 
	ph FLOAT, 
	ances_data TEXT, 
	biotic_regm TEXT NOT NULL, 
	chem_administration TEXT NOT NULL, 
	growth_habit VARCHAR(10), 
	host_genotype TEXT, 
	host_taxid TEXT, 
	mechanical_damage TEXT, 
	perturbation TEXT, 
	root_cond TEXT, 
	root_med_ph FLOAT, 
	tillage VARCHAR(13), 
	ph_meth TEXT, 
	growth_medium TEXT, 
	season TEXT, 
	food_product_type TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	farm_water_source VARCHAR(19), 
	plant_water_method TEXT, 
	"air_PM_concen" TEXT, 
	animal_feed_equip TEXT, 
	animal_intrusion TEXT, 
	anim_water_method TEXT, 
	crop_yield TEXT, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	plant_part_maturity TEXT, 
	adjacent_environment TEXT, 
	water_source_adjac TEXT, 
	farm_equip_shared TEXT, 
	farm_equip_san TEXT, 
	farm_equip_san_freq TEXT, 
	farm_equip TEXT, 
	fertilizer_admin TEXT, 
	fertilizer_date DATE, 
	animal_group_size INTEGER, 
	animal_diet TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_harvest_proc TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_source TEXT, 
	food_treat_proc TEXT, 
	extr_weather_event VARCHAR(28), 
	date_extr_weath DATE, 
	host_subspecf_genlin TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	air_flow_impede TEXT, 
	lot_number TEXT, 
	season_humidity TEXT, 
	part_plant_animal TEXT, 
	plant_growth_med VARCHAR(30), 
	plant_reprod_crop VARCHAR(18), 
	samp_purpose TEXT, 
	repository_name TEXT, 
	samp_pooling TEXT, 
	samp_source_mat_cat TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	soil_conductivity TEXT, 
	soil_cover TEXT, 
	"soil_pH" FLOAT, 
	rel_location TEXT, 
	soil_porosity TEXT, 
	"temp" TEXT, 
	soil_texture_class VARCHAR(15), 
	soil_texture_meth TEXT, 
	soil_type TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_growth_med TEXT, 
	spikein_strain TEXT, 
	spikein_antibiotic TEXT, 
	spikein_metal TEXT, 
	timepoint FLOAT, 
	water_frequency TEXT, 
	"water_pH" FLOAT, 
	water_source_shared VARCHAR(27), 
	enrichment_protocol TEXT, 
	food_quality_date TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	animal_housing TEXT, 
	cult_isol_date DATE, 
	food_clean_proc VARCHAR(30), 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	host_disease_stat TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	ploidy TEXT, 
	num_replicons INTEGER, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	trophic_level VARCHAR(22), 
	propagation TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, humidity, organism_count, spikein_count, samp_stor_temp, solar_irradiance, ventilation_rate, samp_stor_dur, wind_speed, salinity, previous_land_use, crop_rotation, soil_type_meth, tot_org_c_meth, tot_nitro_cont_meth, salinity_meth, host_age, host_dry_mass, host_height, host_length, host_tot_mass, root_med_carbon, root_med_macronutr, root_med_micronutr, season_temp, season_precpt, tot_org_carb, tot_nitro_content, conduc, turbidity, size_frac_low, size_frac_up, ventilation_type, wind_direction, genetic_mod, host_phenotype, ph, ances_data, biotic_regm, chem_administration, growth_habit, host_genotype, host_taxid, mechanical_damage, perturbation, root_cond, root_med_ph, tillage, ph_meth, growth_medium, season, food_product_type, samp_type, farm_water_source, plant_water_method, "air_PM_concen", animal_feed_equip, animal_intrusion, anim_water_method, crop_yield, cult_result, cult_result_org, cult_target, plant_part_maturity, adjacent_environment, water_source_adjac, farm_equip_shared, farm_equip_san, farm_equip_san_freq, farm_equip, fertilizer_admin, fertilizer_date, animal_group_size, animal_diet, food_contact_surf, food_contain_wrap, food_harvest_proc, food_pack_medium, food_preserv_proc, food_prod_char, prod_label_claims, food_trav_mode, food_trav_vehic, food_source, food_treat_proc, extr_weather_event, date_extr_weath, host_subspecf_genlin, intended_consumer, library_prep_kit, air_flow_impede, lot_number, season_humidity, part_plant_animal, plant_growth_med, plant_reprod_crop, samp_purpose, repository_name, samp_pooling, samp_source_mat_cat, sequencing_kit, sequencing_location, serovar_or_serotype, soil_conductivity, soil_cover, "soil_pH", rel_location, soil_porosity, "temp", soil_texture_class, soil_texture_meth, soil_type, spikein_org, spikein_serovar, spikein_growth_med, spikein_strain, spikein_antibiotic, spikein_metal, timepoint, water_frequency, "water_pH", water_source_shared, enrichment_protocol, food_quality_date, "IFSAC_category", animal_housing, cult_isol_date, food_clean_proc, misc_param, samp_name, project_name, seq_meth, samp_size, nucl_acid_ext, samp_vol_we_dna_ext, host_disease_stat, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, ploidy, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, trophic_level, propagation, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "food_farm_environment_MIGS_org" (
	lat_lon TEXT NOT NULL, 
	depth TEXT NOT NULL, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	humidity TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	samp_stor_dur TEXT, 
	wind_speed TEXT, 
	salinity TEXT, 
	previous_land_use TEXT, 
	crop_rotation TEXT, 
	soil_type_meth TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro_cont_meth TEXT, 
	salinity_meth TEXT, 
	host_age TEXT, 
	host_dry_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_tot_mass TEXT, 
	root_med_carbon TEXT, 
	root_med_macronutr TEXT, 
	root_med_micronutr TEXT, 
	season_temp TEXT, 
	season_precpt TEXT, 
	tot_org_carb TEXT, 
	tot_nitro_content TEXT, 
	conduc TEXT, 
	turbidity TEXT, 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	ventilation_type TEXT, 
	wind_direction TEXT, 
	genetic_mod TEXT, 
	host_phenotype TEXT, 
	ph FLOAT, 
	ances_data TEXT, 
	biotic_regm TEXT NOT NULL, 
	chem_administration TEXT NOT NULL, 
	growth_habit VARCHAR(10), 
	host_genotype TEXT, 
	host_taxid TEXT, 
	mechanical_damage TEXT, 
	perturbation TEXT, 
	root_cond TEXT, 
	root_med_ph FLOAT, 
	tillage VARCHAR(13), 
	ph_meth TEXT, 
	growth_medium TEXT, 
	season TEXT, 
	food_product_type TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	farm_water_source VARCHAR(19), 
	plant_water_method TEXT, 
	"air_PM_concen" TEXT, 
	animal_feed_equip TEXT, 
	animal_intrusion TEXT, 
	anim_water_method TEXT, 
	crop_yield TEXT, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	plant_part_maturity TEXT, 
	adjacent_environment TEXT, 
	water_source_adjac TEXT, 
	farm_equip_shared TEXT, 
	farm_equip_san TEXT, 
	farm_equip_san_freq TEXT, 
	farm_equip TEXT, 
	fertilizer_admin TEXT, 
	fertilizer_date DATE, 
	animal_group_size INTEGER, 
	animal_diet TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_harvest_proc TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_source TEXT, 
	food_treat_proc TEXT, 
	extr_weather_event VARCHAR(28), 
	date_extr_weath DATE, 
	host_subspecf_genlin TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	air_flow_impede TEXT, 
	lot_number TEXT, 
	season_humidity TEXT, 
	part_plant_animal TEXT, 
	plant_growth_med VARCHAR(30), 
	plant_reprod_crop VARCHAR(18), 
	samp_purpose TEXT, 
	repository_name TEXT, 
	samp_pooling TEXT, 
	samp_source_mat_cat TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	soil_conductivity TEXT, 
	soil_cover TEXT, 
	"soil_pH" FLOAT, 
	rel_location TEXT, 
	soil_porosity TEXT, 
	"temp" TEXT, 
	soil_texture_class VARCHAR(15), 
	soil_texture_meth TEXT, 
	soil_type TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_growth_med TEXT, 
	spikein_strain TEXT, 
	spikein_antibiotic TEXT, 
	spikein_metal TEXT, 
	timepoint FLOAT, 
	water_frequency TEXT, 
	"water_pH" FLOAT, 
	water_source_shared VARCHAR(27), 
	enrichment_protocol TEXT, 
	food_quality_date TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	animal_housing TEXT, 
	cult_isol_date DATE, 
	food_clean_proc VARCHAR(30), 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	host_disease_stat TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, humidity, organism_count, spikein_count, samp_stor_temp, solar_irradiance, ventilation_rate, samp_stor_dur, wind_speed, salinity, previous_land_use, crop_rotation, soil_type_meth, tot_org_c_meth, tot_nitro_cont_meth, salinity_meth, host_age, host_dry_mass, host_height, host_length, host_tot_mass, root_med_carbon, root_med_macronutr, root_med_micronutr, season_temp, season_precpt, tot_org_carb, tot_nitro_content, conduc, turbidity, size_frac_low, size_frac_up, ventilation_type, wind_direction, genetic_mod, host_phenotype, ph, ances_data, biotic_regm, chem_administration, growth_habit, host_genotype, host_taxid, mechanical_damage, perturbation, root_cond, root_med_ph, tillage, ph_meth, growth_medium, season, food_product_type, samp_type, farm_water_source, plant_water_method, "air_PM_concen", animal_feed_equip, animal_intrusion, anim_water_method, crop_yield, cult_result, cult_result_org, cult_target, plant_part_maturity, adjacent_environment, water_source_adjac, farm_equip_shared, farm_equip_san, farm_equip_san_freq, farm_equip, fertilizer_admin, fertilizer_date, animal_group_size, animal_diet, food_contact_surf, food_contain_wrap, food_harvest_proc, food_pack_medium, food_preserv_proc, food_prod_char, prod_label_claims, food_trav_mode, food_trav_vehic, food_source, food_treat_proc, extr_weather_event, date_extr_weath, host_subspecf_genlin, intended_consumer, library_prep_kit, air_flow_impede, lot_number, season_humidity, part_plant_animal, plant_growth_med, plant_reprod_crop, samp_purpose, repository_name, samp_pooling, samp_source_mat_cat, sequencing_kit, sequencing_location, serovar_or_serotype, soil_conductivity, soil_cover, "soil_pH", rel_location, soil_porosity, "temp", soil_texture_class, soil_texture_meth, soil_type, spikein_org, spikein_serovar, spikein_growth_med, spikein_strain, spikein_antibiotic, spikein_metal, timepoint, water_frequency, "water_pH", water_source_shared, enrichment_protocol, food_quality_date, "IFSAC_category", animal_housing, cult_isol_date, food_clean_proc, misc_param, samp_name, project_name, seq_meth, samp_size, nucl_acid_ext, samp_vol_we_dna_ext, host_disease_stat, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "food_farm_environment_MIGS_plant" (
	lat_lon TEXT NOT NULL, 
	depth TEXT NOT NULL, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	humidity TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	samp_stor_dur TEXT, 
	wind_speed TEXT, 
	salinity TEXT, 
	previous_land_use TEXT, 
	crop_rotation TEXT, 
	soil_type_meth TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro_cont_meth TEXT, 
	salinity_meth TEXT, 
	host_age TEXT, 
	host_dry_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_tot_mass TEXT, 
	root_med_carbon TEXT, 
	root_med_macronutr TEXT, 
	root_med_micronutr TEXT, 
	season_temp TEXT, 
	season_precpt TEXT, 
	tot_org_carb TEXT, 
	tot_nitro_content TEXT, 
	conduc TEXT, 
	turbidity TEXT, 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	ventilation_type TEXT, 
	wind_direction TEXT, 
	genetic_mod TEXT, 
	host_phenotype TEXT, 
	ph FLOAT, 
	ances_data TEXT, 
	biotic_regm TEXT NOT NULL, 
	chem_administration TEXT NOT NULL, 
	growth_habit VARCHAR(10), 
	host_genotype TEXT, 
	host_taxid TEXT, 
	mechanical_damage TEXT, 
	perturbation TEXT, 
	root_cond TEXT, 
	root_med_ph FLOAT, 
	tillage VARCHAR(13), 
	ph_meth TEXT, 
	growth_medium TEXT, 
	season TEXT, 
	food_product_type TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	farm_water_source VARCHAR(19), 
	plant_water_method TEXT, 
	"air_PM_concen" TEXT, 
	animal_feed_equip TEXT, 
	animal_intrusion TEXT, 
	anim_water_method TEXT, 
	crop_yield TEXT, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	plant_part_maturity TEXT, 
	adjacent_environment TEXT, 
	water_source_adjac TEXT, 
	farm_equip_shared TEXT, 
	farm_equip_san TEXT, 
	farm_equip_san_freq TEXT, 
	farm_equip TEXT, 
	fertilizer_admin TEXT, 
	fertilizer_date DATE, 
	animal_group_size INTEGER, 
	animal_diet TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_harvest_proc TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_source TEXT, 
	food_treat_proc TEXT, 
	extr_weather_event VARCHAR(28), 
	date_extr_weath DATE, 
	host_subspecf_genlin TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	air_flow_impede TEXT, 
	lot_number TEXT, 
	season_humidity TEXT, 
	part_plant_animal TEXT, 
	plant_growth_med VARCHAR(30), 
	plant_reprod_crop VARCHAR(18), 
	samp_purpose TEXT, 
	repository_name TEXT, 
	samp_pooling TEXT, 
	samp_source_mat_cat TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	soil_conductivity TEXT, 
	soil_cover TEXT, 
	"soil_pH" FLOAT, 
	rel_location TEXT, 
	soil_porosity TEXT, 
	"temp" TEXT, 
	soil_texture_class VARCHAR(15), 
	soil_texture_meth TEXT, 
	soil_type TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_growth_med TEXT, 
	spikein_strain TEXT, 
	spikein_antibiotic TEXT, 
	spikein_metal TEXT, 
	timepoint FLOAT, 
	water_frequency TEXT, 
	"water_pH" FLOAT, 
	water_source_shared VARCHAR(27), 
	enrichment_protocol TEXT, 
	food_quality_date TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	animal_housing TEXT, 
	cult_isol_date DATE, 
	food_clean_proc VARCHAR(30), 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	host_disease_stat TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, humidity, organism_count, spikein_count, samp_stor_temp, solar_irradiance, ventilation_rate, samp_stor_dur, wind_speed, salinity, previous_land_use, crop_rotation, soil_type_meth, tot_org_c_meth, tot_nitro_cont_meth, salinity_meth, host_age, host_dry_mass, host_height, host_length, host_tot_mass, root_med_carbon, root_med_macronutr, root_med_micronutr, season_temp, season_precpt, tot_org_carb, tot_nitro_content, conduc, turbidity, size_frac_low, size_frac_up, ventilation_type, wind_direction, genetic_mod, host_phenotype, ph, ances_data, biotic_regm, chem_administration, growth_habit, host_genotype, host_taxid, mechanical_damage, perturbation, root_cond, root_med_ph, tillage, ph_meth, growth_medium, season, food_product_type, samp_type, farm_water_source, plant_water_method, "air_PM_concen", animal_feed_equip, animal_intrusion, anim_water_method, crop_yield, cult_result, cult_result_org, cult_target, plant_part_maturity, adjacent_environment, water_source_adjac, farm_equip_shared, farm_equip_san, farm_equip_san_freq, farm_equip, fertilizer_admin, fertilizer_date, animal_group_size, animal_diet, food_contact_surf, food_contain_wrap, food_harvest_proc, food_pack_medium, food_preserv_proc, food_prod_char, prod_label_claims, food_trav_mode, food_trav_vehic, food_source, food_treat_proc, extr_weather_event, date_extr_weath, host_subspecf_genlin, intended_consumer, library_prep_kit, air_flow_impede, lot_number, season_humidity, part_plant_animal, plant_growth_med, plant_reprod_crop, samp_purpose, repository_name, samp_pooling, samp_source_mat_cat, sequencing_kit, sequencing_location, serovar_or_serotype, soil_conductivity, soil_cover, "soil_pH", rel_location, soil_porosity, "temp", soil_texture_class, soil_texture_meth, soil_type, spikein_org, spikein_serovar, spikein_growth_med, spikein_strain, spikein_antibiotic, spikein_metal, timepoint, water_frequency, "water_pH", water_source_shared, enrichment_protocol, food_quality_date, "IFSAC_category", animal_housing, cult_isol_date, food_clean_proc, misc_param, samp_name, project_name, seq_meth, samp_size, nucl_acid_ext, samp_vol_we_dna_ext, host_disease_stat, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, estimated_size, ref_biomaterial, source_mat_id, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "food_farm_environment_MIGS_virus" (
	lat_lon TEXT NOT NULL, 
	depth TEXT NOT NULL, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	humidity TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	samp_stor_dur TEXT, 
	wind_speed TEXT, 
	salinity TEXT, 
	previous_land_use TEXT, 
	crop_rotation TEXT, 
	soil_type_meth TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro_cont_meth TEXT, 
	salinity_meth TEXT, 
	host_age TEXT, 
	host_dry_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_tot_mass TEXT, 
	root_med_carbon TEXT, 
	root_med_macronutr TEXT, 
	root_med_micronutr TEXT, 
	season_temp TEXT, 
	season_precpt TEXT, 
	tot_org_carb TEXT, 
	tot_nitro_content TEXT, 
	conduc TEXT, 
	turbidity TEXT, 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	ventilation_type TEXT, 
	wind_direction TEXT, 
	genetic_mod TEXT, 
	host_phenotype TEXT, 
	ph FLOAT, 
	ances_data TEXT, 
	biotic_regm TEXT NOT NULL, 
	chem_administration TEXT NOT NULL, 
	growth_habit VARCHAR(10), 
	host_genotype TEXT, 
	host_taxid TEXT, 
	mechanical_damage TEXT, 
	perturbation TEXT, 
	root_cond TEXT, 
	root_med_ph FLOAT, 
	tillage VARCHAR(13), 
	ph_meth TEXT, 
	growth_medium TEXT, 
	season TEXT, 
	food_product_type TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	farm_water_source VARCHAR(19), 
	plant_water_method TEXT, 
	"air_PM_concen" TEXT, 
	animal_feed_equip TEXT, 
	animal_intrusion TEXT, 
	anim_water_method TEXT, 
	crop_yield TEXT, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	plant_part_maturity TEXT, 
	adjacent_environment TEXT, 
	water_source_adjac TEXT, 
	farm_equip_shared TEXT, 
	farm_equip_san TEXT, 
	farm_equip_san_freq TEXT, 
	farm_equip TEXT, 
	fertilizer_admin TEXT, 
	fertilizer_date DATE, 
	animal_group_size INTEGER, 
	animal_diet TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_harvest_proc TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_source TEXT, 
	food_treat_proc TEXT, 
	extr_weather_event VARCHAR(28), 
	date_extr_weath DATE, 
	host_subspecf_genlin TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	air_flow_impede TEXT, 
	lot_number TEXT, 
	season_humidity TEXT, 
	part_plant_animal TEXT, 
	plant_growth_med VARCHAR(30), 
	plant_reprod_crop VARCHAR(18), 
	samp_purpose TEXT, 
	repository_name TEXT, 
	samp_pooling TEXT, 
	samp_source_mat_cat TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	soil_conductivity TEXT, 
	soil_cover TEXT, 
	"soil_pH" FLOAT, 
	rel_location TEXT, 
	soil_porosity TEXT, 
	"temp" TEXT, 
	soil_texture_class VARCHAR(15), 
	soil_texture_meth TEXT, 
	soil_type TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_growth_med TEXT, 
	spikein_strain TEXT, 
	spikein_antibiotic TEXT, 
	spikein_metal TEXT, 
	timepoint FLOAT, 
	water_frequency TEXT, 
	"water_pH" FLOAT, 
	water_source_shared VARCHAR(27), 
	enrichment_protocol TEXT, 
	food_quality_date TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	animal_housing TEXT, 
	cult_isol_date DATE, 
	food_clean_proc VARCHAR(30), 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	host_disease_stat TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	virus_enrich_appr VARCHAR(25), 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, humidity, organism_count, spikein_count, samp_stor_temp, solar_irradiance, ventilation_rate, samp_stor_dur, wind_speed, salinity, previous_land_use, crop_rotation, soil_type_meth, tot_org_c_meth, tot_nitro_cont_meth, salinity_meth, host_age, host_dry_mass, host_height, host_length, host_tot_mass, root_med_carbon, root_med_macronutr, root_med_micronutr, season_temp, season_precpt, tot_org_carb, tot_nitro_content, conduc, turbidity, size_frac_low, size_frac_up, ventilation_type, wind_direction, genetic_mod, host_phenotype, ph, ances_data, biotic_regm, chem_administration, growth_habit, host_genotype, host_taxid, mechanical_damage, perturbation, root_cond, root_med_ph, tillage, ph_meth, growth_medium, season, food_product_type, samp_type, farm_water_source, plant_water_method, "air_PM_concen", animal_feed_equip, animal_intrusion, anim_water_method, crop_yield, cult_result, cult_result_org, cult_target, plant_part_maturity, adjacent_environment, water_source_adjac, farm_equip_shared, farm_equip_san, farm_equip_san_freq, farm_equip, fertilizer_admin, fertilizer_date, animal_group_size, animal_diet, food_contact_surf, food_contain_wrap, food_harvest_proc, food_pack_medium, food_preserv_proc, food_prod_char, prod_label_claims, food_trav_mode, food_trav_vehic, food_source, food_treat_proc, extr_weather_event, date_extr_weath, host_subspecf_genlin, intended_consumer, library_prep_kit, air_flow_impede, lot_number, season_humidity, part_plant_animal, plant_growth_med, plant_reprod_crop, samp_purpose, repository_name, samp_pooling, samp_source_mat_cat, sequencing_kit, sequencing_location, serovar_or_serotype, soil_conductivity, soil_cover, "soil_pH", rel_location, soil_porosity, "temp", soil_texture_class, soil_texture_meth, soil_type, spikein_org, spikein_serovar, spikein_growth_med, spikein_strain, spikein_antibiotic, spikein_metal, timepoint, water_frequency, "water_pH", water_source_shared, enrichment_protocol, food_quality_date, "IFSAC_category", animal_housing, cult_isol_date, food_clean_proc, misc_param, samp_name, project_name, seq_meth, samp_size, nucl_acid_ext, samp_vol_we_dna_ext, host_disease_stat, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, virus_enrich_appr, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "food_farm_environment_MIMAG" (
	lat_lon TEXT NOT NULL, 
	depth TEXT NOT NULL, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	humidity TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	samp_stor_dur TEXT, 
	wind_speed TEXT, 
	salinity TEXT, 
	previous_land_use TEXT, 
	crop_rotation TEXT, 
	soil_type_meth TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro_cont_meth TEXT, 
	salinity_meth TEXT, 
	host_age TEXT, 
	host_dry_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_tot_mass TEXT, 
	root_med_carbon TEXT, 
	root_med_macronutr TEXT, 
	root_med_micronutr TEXT, 
	season_temp TEXT, 
	season_precpt TEXT, 
	tot_org_carb TEXT, 
	tot_nitro_content TEXT, 
	conduc TEXT, 
	turbidity TEXT, 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	ventilation_type TEXT, 
	wind_direction TEXT, 
	genetic_mod TEXT, 
	host_phenotype TEXT, 
	ph FLOAT, 
	ances_data TEXT, 
	biotic_regm TEXT NOT NULL, 
	chem_administration TEXT NOT NULL, 
	growth_habit VARCHAR(10), 
	host_genotype TEXT, 
	host_taxid TEXT, 
	mechanical_damage TEXT, 
	perturbation TEXT, 
	root_cond TEXT, 
	root_med_ph FLOAT, 
	tillage VARCHAR(13), 
	ph_meth TEXT, 
	growth_medium TEXT, 
	season TEXT, 
	food_product_type TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	farm_water_source VARCHAR(19), 
	plant_water_method TEXT, 
	"air_PM_concen" TEXT, 
	animal_feed_equip TEXT, 
	animal_intrusion TEXT, 
	anim_water_method TEXT, 
	crop_yield TEXT, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	plant_part_maturity TEXT, 
	adjacent_environment TEXT, 
	water_source_adjac TEXT, 
	farm_equip_shared TEXT, 
	farm_equip_san TEXT, 
	farm_equip_san_freq TEXT, 
	farm_equip TEXT, 
	fertilizer_admin TEXT, 
	fertilizer_date DATE, 
	animal_group_size INTEGER, 
	animal_diet TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_harvest_proc TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_source TEXT, 
	food_treat_proc TEXT, 
	extr_weather_event VARCHAR(28), 
	date_extr_weath DATE, 
	host_subspecf_genlin TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	air_flow_impede TEXT, 
	lot_number TEXT, 
	season_humidity TEXT, 
	part_plant_animal TEXT, 
	plant_growth_med VARCHAR(30), 
	plant_reprod_crop VARCHAR(18), 
	samp_purpose TEXT, 
	repository_name TEXT, 
	samp_pooling TEXT, 
	samp_source_mat_cat TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	soil_conductivity TEXT, 
	soil_cover TEXT, 
	"soil_pH" FLOAT, 
	rel_location TEXT, 
	soil_porosity TEXT, 
	"temp" TEXT, 
	soil_texture_class VARCHAR(15), 
	soil_texture_meth TEXT, 
	soil_type TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_growth_med TEXT, 
	spikein_strain TEXT, 
	spikein_antibiotic TEXT, 
	spikein_metal TEXT, 
	timepoint FLOAT, 
	water_frequency TEXT, 
	"water_pH" FLOAT, 
	water_source_shared VARCHAR(27), 
	enrichment_protocol TEXT, 
	food_quality_date TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	animal_housing TEXT, 
	cult_isol_date DATE, 
	food_clean_proc VARCHAR(30), 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	host_disease_stat TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	bin_param VARCHAR(15) NOT NULL, 
	bin_software TEXT NOT NULL, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, humidity, organism_count, spikein_count, samp_stor_temp, solar_irradiance, ventilation_rate, samp_stor_dur, wind_speed, salinity, previous_land_use, crop_rotation, soil_type_meth, tot_org_c_meth, tot_nitro_cont_meth, salinity_meth, host_age, host_dry_mass, host_height, host_length, host_tot_mass, root_med_carbon, root_med_macronutr, root_med_micronutr, season_temp, season_precpt, tot_org_carb, tot_nitro_content, conduc, turbidity, size_frac_low, size_frac_up, ventilation_type, wind_direction, genetic_mod, host_phenotype, ph, ances_data, biotic_regm, chem_administration, growth_habit, host_genotype, host_taxid, mechanical_damage, perturbation, root_cond, root_med_ph, tillage, ph_meth, growth_medium, season, food_product_type, samp_type, farm_water_source, plant_water_method, "air_PM_concen", animal_feed_equip, animal_intrusion, anim_water_method, crop_yield, cult_result, cult_result_org, cult_target, plant_part_maturity, adjacent_environment, water_source_adjac, farm_equip_shared, farm_equip_san, farm_equip_san_freq, farm_equip, fertilizer_admin, fertilizer_date, animal_group_size, animal_diet, food_contact_surf, food_contain_wrap, food_harvest_proc, food_pack_medium, food_preserv_proc, food_prod_char, prod_label_claims, food_trav_mode, food_trav_vehic, food_source, food_treat_proc, extr_weather_event, date_extr_weath, host_subspecf_genlin, intended_consumer, library_prep_kit, air_flow_impede, lot_number, season_humidity, part_plant_animal, plant_growth_med, plant_reprod_crop, samp_purpose, repository_name, samp_pooling, samp_source_mat_cat, sequencing_kit, sequencing_location, serovar_or_serotype, soil_conductivity, soil_cover, "soil_pH", rel_location, soil_porosity, "temp", soil_texture_class, soil_texture_meth, soil_type, spikein_org, spikein_serovar, spikein_growth_med, spikein_strain, spikein_antibiotic, spikein_metal, timepoint, water_frequency, "water_pH", water_source_shared, enrichment_protocol, food_quality_date, "IFSAC_category", animal_housing, cult_isol_date, food_clean_proc, misc_param, samp_name, project_name, seq_meth, samp_size, nucl_acid_ext, samp_vol_we_dna_ext, host_disease_stat, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, bin_param, bin_software, reassembly_bin, mag_cov_software, associated_resource, sop)
);

CREATE TABLE "food_farm_environment_MIMARKS_specimen" (
	lat_lon TEXT NOT NULL, 
	depth TEXT NOT NULL, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	humidity TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	samp_stor_dur TEXT, 
	wind_speed TEXT, 
	salinity TEXT, 
	previous_land_use TEXT, 
	crop_rotation TEXT, 
	soil_type_meth TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro_cont_meth TEXT, 
	salinity_meth TEXT, 
	host_age TEXT, 
	host_dry_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_tot_mass TEXT, 
	root_med_carbon TEXT, 
	root_med_macronutr TEXT, 
	root_med_micronutr TEXT, 
	season_temp TEXT, 
	season_precpt TEXT, 
	tot_org_carb TEXT, 
	tot_nitro_content TEXT, 
	conduc TEXT, 
	turbidity TEXT, 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	ventilation_type TEXT, 
	wind_direction TEXT, 
	genetic_mod TEXT, 
	host_phenotype TEXT, 
	ph FLOAT, 
	ances_data TEXT, 
	biotic_regm TEXT NOT NULL, 
	chem_administration TEXT NOT NULL, 
	growth_habit VARCHAR(10), 
	host_genotype TEXT, 
	host_taxid TEXT, 
	mechanical_damage TEXT, 
	perturbation TEXT, 
	root_cond TEXT, 
	root_med_ph FLOAT, 
	tillage VARCHAR(13), 
	ph_meth TEXT, 
	growth_medium TEXT, 
	season TEXT, 
	food_product_type TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	farm_water_source VARCHAR(19), 
	plant_water_method TEXT, 
	"air_PM_concen" TEXT, 
	animal_feed_equip TEXT, 
	animal_intrusion TEXT, 
	anim_water_method TEXT, 
	crop_yield TEXT, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	plant_part_maturity TEXT, 
	adjacent_environment TEXT, 
	water_source_adjac TEXT, 
	farm_equip_shared TEXT, 
	farm_equip_san TEXT, 
	farm_equip_san_freq TEXT, 
	farm_equip TEXT, 
	fertilizer_admin TEXT, 
	fertilizer_date DATE, 
	animal_group_size INTEGER, 
	animal_diet TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_harvest_proc TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_source TEXT, 
	food_treat_proc TEXT, 
	extr_weather_event VARCHAR(28), 
	date_extr_weath DATE, 
	host_subspecf_genlin TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	air_flow_impede TEXT, 
	lot_number TEXT, 
	season_humidity TEXT, 
	part_plant_animal TEXT, 
	plant_growth_med VARCHAR(30), 
	plant_reprod_crop VARCHAR(18), 
	samp_purpose TEXT, 
	repository_name TEXT, 
	samp_pooling TEXT, 
	samp_source_mat_cat TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	soil_conductivity TEXT, 
	soil_cover TEXT, 
	"soil_pH" FLOAT, 
	rel_location TEXT, 
	soil_porosity TEXT, 
	"temp" TEXT, 
	soil_texture_class VARCHAR(15), 
	soil_texture_meth TEXT, 
	soil_type TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_growth_med TEXT, 
	spikein_strain TEXT, 
	spikein_antibiotic TEXT, 
	spikein_metal TEXT, 
	timepoint FLOAT, 
	water_frequency TEXT, 
	"water_pH" FLOAT, 
	water_source_shared VARCHAR(27), 
	enrichment_protocol TEXT, 
	food_quality_date TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	animal_housing TEXT, 
	cult_isol_date DATE, 
	food_clean_proc VARCHAR(30), 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	host_disease_stat TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	mid TEXT, 
	adapters TEXT, 
	pcr_cond TEXT, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	assembly_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, humidity, organism_count, spikein_count, samp_stor_temp, solar_irradiance, ventilation_rate, samp_stor_dur, wind_speed, salinity, previous_land_use, crop_rotation, soil_type_meth, tot_org_c_meth, tot_nitro_cont_meth, salinity_meth, host_age, host_dry_mass, host_height, host_length, host_tot_mass, root_med_carbon, root_med_macronutr, root_med_micronutr, season_temp, season_precpt, tot_org_carb, tot_nitro_content, conduc, turbidity, size_frac_low, size_frac_up, ventilation_type, wind_direction, genetic_mod, host_phenotype, ph, ances_data, biotic_regm, chem_administration, growth_habit, host_genotype, host_taxid, mechanical_damage, perturbation, root_cond, root_med_ph, tillage, ph_meth, growth_medium, season, food_product_type, samp_type, farm_water_source, plant_water_method, "air_PM_concen", animal_feed_equip, animal_intrusion, anim_water_method, crop_yield, cult_result, cult_result_org, cult_target, plant_part_maturity, adjacent_environment, water_source_adjac, farm_equip_shared, farm_equip_san, farm_equip_san_freq, farm_equip, fertilizer_admin, fertilizer_date, animal_group_size, animal_diet, food_contact_surf, food_contain_wrap, food_harvest_proc, food_pack_medium, food_preserv_proc, food_prod_char, prod_label_claims, food_trav_mode, food_trav_vehic, food_source, food_treat_proc, extr_weather_event, date_extr_weath, host_subspecf_genlin, intended_consumer, library_prep_kit, air_flow_impede, lot_number, season_humidity, part_plant_animal, plant_growth_med, plant_reprod_crop, samp_purpose, repository_name, samp_pooling, samp_source_mat_cat, sequencing_kit, sequencing_location, serovar_or_serotype, soil_conductivity, soil_cover, "soil_pH", rel_location, soil_porosity, "temp", soil_texture_class, soil_texture_meth, soil_type, spikein_org, spikein_serovar, spikein_growth_med, spikein_strain, spikein_antibiotic, spikein_metal, timepoint, water_frequency, "water_pH", water_source_shared, enrichment_protocol, food_quality_date, "IFSAC_category", animal_housing, cult_isol_date, food_clean_proc, misc_param, samp_name, project_name, seq_meth, samp_size, nucl_acid_ext, samp_vol_we_dna_ext, host_disease_stat, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, pcr_primers, mid, adapters, pcr_cond, seq_quality_check, chimera_check, assembly_software, associated_resource, sop)
);

CREATE TABLE "food_farm_environment_MIMARKS_survey" (
	lat_lon TEXT NOT NULL, 
	depth TEXT NOT NULL, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	humidity TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	samp_stor_dur TEXT, 
	wind_speed TEXT, 
	salinity TEXT, 
	previous_land_use TEXT, 
	crop_rotation TEXT, 
	soil_type_meth TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro_cont_meth TEXT, 
	salinity_meth TEXT, 
	host_age TEXT, 
	host_dry_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_tot_mass TEXT, 
	root_med_carbon TEXT, 
	root_med_macronutr TEXT, 
	root_med_micronutr TEXT, 
	season_temp TEXT, 
	season_precpt TEXT, 
	tot_org_carb TEXT, 
	tot_nitro_content TEXT, 
	conduc TEXT, 
	turbidity TEXT, 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	ventilation_type TEXT, 
	wind_direction TEXT, 
	genetic_mod TEXT, 
	host_phenotype TEXT, 
	ph FLOAT, 
	ances_data TEXT, 
	biotic_regm TEXT NOT NULL, 
	chem_administration TEXT NOT NULL, 
	growth_habit VARCHAR(10), 
	host_genotype TEXT, 
	host_taxid TEXT, 
	mechanical_damage TEXT, 
	perturbation TEXT, 
	root_cond TEXT, 
	root_med_ph FLOAT, 
	tillage VARCHAR(13), 
	ph_meth TEXT, 
	growth_medium TEXT, 
	season TEXT, 
	food_product_type TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	farm_water_source VARCHAR(19), 
	plant_water_method TEXT, 
	"air_PM_concen" TEXT, 
	animal_feed_equip TEXT, 
	animal_intrusion TEXT, 
	anim_water_method TEXT, 
	crop_yield TEXT, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	plant_part_maturity TEXT, 
	adjacent_environment TEXT, 
	water_source_adjac TEXT, 
	farm_equip_shared TEXT, 
	farm_equip_san TEXT, 
	farm_equip_san_freq TEXT, 
	farm_equip TEXT, 
	fertilizer_admin TEXT, 
	fertilizer_date DATE, 
	animal_group_size INTEGER, 
	animal_diet TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_harvest_proc TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_source TEXT, 
	food_treat_proc TEXT, 
	extr_weather_event VARCHAR(28), 
	date_extr_weath DATE, 
	host_subspecf_genlin TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	air_flow_impede TEXT, 
	lot_number TEXT, 
	season_humidity TEXT, 
	part_plant_animal TEXT, 
	plant_growth_med VARCHAR(30), 
	plant_reprod_crop VARCHAR(18), 
	samp_purpose TEXT, 
	repository_name TEXT, 
	samp_pooling TEXT, 
	samp_source_mat_cat TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	soil_conductivity TEXT, 
	soil_cover TEXT, 
	"soil_pH" FLOAT, 
	rel_location TEXT, 
	soil_porosity TEXT, 
	"temp" TEXT, 
	soil_texture_class VARCHAR(15), 
	soil_texture_meth TEXT, 
	soil_type TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_growth_med TEXT, 
	spikein_strain TEXT, 
	spikein_antibiotic TEXT, 
	spikein_metal TEXT, 
	timepoint FLOAT, 
	water_frequency TEXT, 
	"water_pH" FLOAT, 
	water_source_shared VARCHAR(27), 
	enrichment_protocol TEXT, 
	food_quality_date TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	animal_housing TEXT, 
	cult_isol_date DATE, 
	food_clean_proc VARCHAR(30), 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	host_disease_stat TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	source_mat_id TEXT, 
	biotic_relationship VARCHAR(11), 
	trophic_level VARCHAR(22), 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	nucl_acid_amp TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	pcr_cond TEXT, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, humidity, organism_count, spikein_count, samp_stor_temp, solar_irradiance, ventilation_rate, samp_stor_dur, wind_speed, salinity, previous_land_use, crop_rotation, soil_type_meth, tot_org_c_meth, tot_nitro_cont_meth, salinity_meth, host_age, host_dry_mass, host_height, host_length, host_tot_mass, root_med_carbon, root_med_macronutr, root_med_micronutr, season_temp, season_precpt, tot_org_carb, tot_nitro_content, conduc, turbidity, size_frac_low, size_frac_up, ventilation_type, wind_direction, genetic_mod, host_phenotype, ph, ances_data, biotic_regm, chem_administration, growth_habit, host_genotype, host_taxid, mechanical_damage, perturbation, root_cond, root_med_ph, tillage, ph_meth, growth_medium, season, food_product_type, samp_type, farm_water_source, plant_water_method, "air_PM_concen", animal_feed_equip, animal_intrusion, anim_water_method, crop_yield, cult_result, cult_result_org, cult_target, plant_part_maturity, adjacent_environment, water_source_adjac, farm_equip_shared, farm_equip_san, farm_equip_san_freq, farm_equip, fertilizer_admin, fertilizer_date, animal_group_size, animal_diet, food_contact_surf, food_contain_wrap, food_harvest_proc, food_pack_medium, food_preserv_proc, food_prod_char, prod_label_claims, food_trav_mode, food_trav_vehic, food_source, food_treat_proc, extr_weather_event, date_extr_weath, host_subspecf_genlin, intended_consumer, library_prep_kit, air_flow_impede, lot_number, season_humidity, part_plant_animal, plant_growth_med, plant_reprod_crop, samp_purpose, repository_name, samp_pooling, samp_source_mat_cat, sequencing_kit, sequencing_location, serovar_or_serotype, soil_conductivity, soil_cover, "soil_pH", rel_location, soil_porosity, "temp", soil_texture_class, soil_texture_meth, soil_type, spikein_org, spikein_serovar, spikein_growth_med, spikein_strain, spikein_antibiotic, spikein_metal, timepoint, water_frequency, "water_pH", water_source_shared, enrichment_protocol, food_quality_date, "IFSAC_category", animal_housing, cult_isol_date, food_clean_proc, misc_param, samp_name, project_name, seq_meth, samp_size, nucl_acid_ext, samp_vol_we_dna_ext, host_disease_stat, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, source_mat_id, biotic_relationship, trophic_level, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, nucl_acid_amp, target_gene, target_subfragment, pcr_primers, pcr_cond, seq_quality_check, chimera_check, associated_resource, sop)
);

CREATE TABLE "food_farm_environment_MIMS" (
	lat_lon TEXT NOT NULL, 
	depth TEXT NOT NULL, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	humidity TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	samp_stor_dur TEXT, 
	wind_speed TEXT, 
	salinity TEXT, 
	previous_land_use TEXT, 
	crop_rotation TEXT, 
	soil_type_meth TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro_cont_meth TEXT, 
	salinity_meth TEXT, 
	host_age TEXT, 
	host_dry_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_tot_mass TEXT, 
	root_med_carbon TEXT, 
	root_med_macronutr TEXT, 
	root_med_micronutr TEXT, 
	season_temp TEXT, 
	season_precpt TEXT, 
	tot_org_carb TEXT, 
	tot_nitro_content TEXT, 
	conduc TEXT, 
	turbidity TEXT, 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	ventilation_type TEXT, 
	wind_direction TEXT, 
	genetic_mod TEXT, 
	host_phenotype TEXT, 
	ph FLOAT, 
	ances_data TEXT, 
	biotic_regm TEXT NOT NULL, 
	chem_administration TEXT NOT NULL, 
	growth_habit VARCHAR(10), 
	host_genotype TEXT, 
	host_taxid TEXT, 
	mechanical_damage TEXT, 
	perturbation TEXT, 
	root_cond TEXT, 
	root_med_ph FLOAT, 
	tillage VARCHAR(13), 
	ph_meth TEXT, 
	growth_medium TEXT, 
	season TEXT, 
	food_product_type TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	farm_water_source VARCHAR(19), 
	plant_water_method TEXT, 
	"air_PM_concen" TEXT, 
	animal_feed_equip TEXT, 
	animal_intrusion TEXT, 
	anim_water_method TEXT, 
	crop_yield TEXT, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	plant_part_maturity TEXT, 
	adjacent_environment TEXT, 
	water_source_adjac TEXT, 
	farm_equip_shared TEXT, 
	farm_equip_san TEXT, 
	farm_equip_san_freq TEXT, 
	farm_equip TEXT, 
	fertilizer_admin TEXT, 
	fertilizer_date DATE, 
	animal_group_size INTEGER, 
	animal_diet TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_harvest_proc TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_source TEXT, 
	food_treat_proc TEXT, 
	extr_weather_event VARCHAR(28), 
	date_extr_weath DATE, 
	host_subspecf_genlin TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	air_flow_impede TEXT, 
	lot_number TEXT, 
	season_humidity TEXT, 
	part_plant_animal TEXT, 
	plant_growth_med VARCHAR(30), 
	plant_reprod_crop VARCHAR(18), 
	samp_purpose TEXT, 
	repository_name TEXT, 
	samp_pooling TEXT, 
	samp_source_mat_cat TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	soil_conductivity TEXT, 
	soil_cover TEXT, 
	"soil_pH" FLOAT, 
	rel_location TEXT, 
	soil_porosity TEXT, 
	"temp" TEXT, 
	soil_texture_class VARCHAR(15), 
	soil_texture_meth TEXT, 
	soil_type TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_growth_med TEXT, 
	spikein_strain TEXT, 
	spikein_antibiotic TEXT, 
	spikein_metal TEXT, 
	timepoint FLOAT, 
	water_frequency TEXT, 
	"water_pH" FLOAT, 
	water_source_shared VARCHAR(27), 
	enrichment_protocol TEXT, 
	food_quality_date TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	animal_housing TEXT, 
	cult_isol_date DATE, 
	food_clean_proc VARCHAR(30), 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	host_disease_stat TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, humidity, organism_count, spikein_count, samp_stor_temp, solar_irradiance, ventilation_rate, samp_stor_dur, wind_speed, salinity, previous_land_use, crop_rotation, soil_type_meth, tot_org_c_meth, tot_nitro_cont_meth, salinity_meth, host_age, host_dry_mass, host_height, host_length, host_tot_mass, root_med_carbon, root_med_macronutr, root_med_micronutr, season_temp, season_precpt, tot_org_carb, tot_nitro_content, conduc, turbidity, size_frac_low, size_frac_up, ventilation_type, wind_direction, genetic_mod, host_phenotype, ph, ances_data, biotic_regm, chem_administration, growth_habit, host_genotype, host_taxid, mechanical_damage, perturbation, root_cond, root_med_ph, tillage, ph_meth, growth_medium, season, food_product_type, samp_type, farm_water_source, plant_water_method, "air_PM_concen", animal_feed_equip, animal_intrusion, anim_water_method, crop_yield, cult_result, cult_result_org, cult_target, plant_part_maturity, adjacent_environment, water_source_adjac, farm_equip_shared, farm_equip_san, farm_equip_san_freq, farm_equip, fertilizer_admin, fertilizer_date, animal_group_size, animal_diet, food_contact_surf, food_contain_wrap, food_harvest_proc, food_pack_medium, food_preserv_proc, food_prod_char, prod_label_claims, food_trav_mode, food_trav_vehic, food_source, food_treat_proc, extr_weather_event, date_extr_weath, host_subspecf_genlin, intended_consumer, library_prep_kit, air_flow_impede, lot_number, season_humidity, part_plant_animal, plant_growth_med, plant_reprod_crop, samp_purpose, repository_name, samp_pooling, samp_source_mat_cat, sequencing_kit, sequencing_location, serovar_or_serotype, soil_conductivity, soil_cover, "soil_pH", rel_location, soil_porosity, "temp", soil_texture_class, soil_texture_meth, soil_type, spikein_org, spikein_serovar, spikein_growth_med, spikein_strain, spikein_antibiotic, spikein_metal, timepoint, water_frequency, "water_pH", water_source_shared, enrichment_protocol, food_quality_date, "IFSAC_category", animal_housing, cult_isol_date, food_clean_proc, misc_param, samp_name, project_name, seq_meth, samp_size, nucl_acid_ext, samp_vol_we_dna_ext, host_disease_stat, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, associated_resource, sop)
);

CREATE TABLE "food_farm_environment_MISAG" (
	lat_lon TEXT NOT NULL, 
	depth TEXT NOT NULL, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	humidity TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	samp_stor_dur TEXT, 
	wind_speed TEXT, 
	salinity TEXT, 
	previous_land_use TEXT, 
	crop_rotation TEXT, 
	soil_type_meth TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro_cont_meth TEXT, 
	salinity_meth TEXT, 
	host_age TEXT, 
	host_dry_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_tot_mass TEXT, 
	root_med_carbon TEXT, 
	root_med_macronutr TEXT, 
	root_med_micronutr TEXT, 
	season_temp TEXT, 
	season_precpt TEXT, 
	tot_org_carb TEXT, 
	tot_nitro_content TEXT, 
	conduc TEXT, 
	turbidity TEXT, 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	ventilation_type TEXT, 
	wind_direction TEXT, 
	genetic_mod TEXT, 
	host_phenotype TEXT, 
	ph FLOAT, 
	ances_data TEXT, 
	biotic_regm TEXT NOT NULL, 
	chem_administration TEXT NOT NULL, 
	growth_habit VARCHAR(10), 
	host_genotype TEXT, 
	host_taxid TEXT, 
	mechanical_damage TEXT, 
	perturbation TEXT, 
	root_cond TEXT, 
	root_med_ph FLOAT, 
	tillage VARCHAR(13), 
	ph_meth TEXT, 
	growth_medium TEXT, 
	season TEXT, 
	food_product_type TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	farm_water_source VARCHAR(19), 
	plant_water_method TEXT, 
	"air_PM_concen" TEXT, 
	animal_feed_equip TEXT, 
	animal_intrusion TEXT, 
	anim_water_method TEXT, 
	crop_yield TEXT, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	plant_part_maturity TEXT, 
	adjacent_environment TEXT, 
	water_source_adjac TEXT, 
	farm_equip_shared TEXT, 
	farm_equip_san TEXT, 
	farm_equip_san_freq TEXT, 
	farm_equip TEXT, 
	fertilizer_admin TEXT, 
	fertilizer_date DATE, 
	animal_group_size INTEGER, 
	animal_diet TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_harvest_proc TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_source TEXT, 
	food_treat_proc TEXT, 
	extr_weather_event VARCHAR(28), 
	date_extr_weath DATE, 
	host_subspecf_genlin TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	air_flow_impede TEXT, 
	lot_number TEXT, 
	season_humidity TEXT, 
	part_plant_animal TEXT, 
	plant_growth_med VARCHAR(30), 
	plant_reprod_crop VARCHAR(18), 
	samp_purpose TEXT, 
	repository_name TEXT, 
	samp_pooling TEXT, 
	samp_source_mat_cat TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	soil_conductivity TEXT, 
	soil_cover TEXT, 
	"soil_pH" FLOAT, 
	rel_location TEXT, 
	soil_porosity TEXT, 
	"temp" TEXT, 
	soil_texture_class VARCHAR(15), 
	soil_texture_meth TEXT, 
	soil_type TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_growth_med TEXT, 
	spikein_strain TEXT, 
	spikein_antibiotic TEXT, 
	spikein_metal TEXT, 
	timepoint FLOAT, 
	water_frequency TEXT, 
	"water_pH" FLOAT, 
	water_source_shared VARCHAR(27), 
	enrichment_protocol TEXT, 
	food_quality_date TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	animal_housing TEXT, 
	cult_isol_date DATE, 
	food_clean_proc VARCHAR(30), 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	host_disease_stat TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	sort_tech VARCHAR(28) NOT NULL, 
	single_cell_lysis_appr VARCHAR(11) NOT NULL, 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT NOT NULL, 
	wga_amp_kit TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, humidity, organism_count, spikein_count, samp_stor_temp, solar_irradiance, ventilation_rate, samp_stor_dur, wind_speed, salinity, previous_land_use, crop_rotation, soil_type_meth, tot_org_c_meth, tot_nitro_cont_meth, salinity_meth, host_age, host_dry_mass, host_height, host_length, host_tot_mass, root_med_carbon, root_med_macronutr, root_med_micronutr, season_temp, season_precpt, tot_org_carb, tot_nitro_content, conduc, turbidity, size_frac_low, size_frac_up, ventilation_type, wind_direction, genetic_mod, host_phenotype, ph, ances_data, biotic_regm, chem_administration, growth_habit, host_genotype, host_taxid, mechanical_damage, perturbation, root_cond, root_med_ph, tillage, ph_meth, growth_medium, season, food_product_type, samp_type, farm_water_source, plant_water_method, "air_PM_concen", animal_feed_equip, animal_intrusion, anim_water_method, crop_yield, cult_result, cult_result_org, cult_target, plant_part_maturity, adjacent_environment, water_source_adjac, farm_equip_shared, farm_equip_san, farm_equip_san_freq, farm_equip, fertilizer_admin, fertilizer_date, animal_group_size, animal_diet, food_contact_surf, food_contain_wrap, food_harvest_proc, food_pack_medium, food_preserv_proc, food_prod_char, prod_label_claims, food_trav_mode, food_trav_vehic, food_source, food_treat_proc, extr_weather_event, date_extr_weath, host_subspecf_genlin, intended_consumer, library_prep_kit, air_flow_impede, lot_number, season_humidity, part_plant_animal, plant_growth_med, plant_reprod_crop, samp_purpose, repository_name, samp_pooling, samp_source_mat_cat, sequencing_kit, sequencing_location, serovar_or_serotype, soil_conductivity, soil_cover, "soil_pH", rel_location, soil_porosity, "temp", soil_texture_class, soil_texture_meth, soil_type, spikein_org, spikein_serovar, spikein_growth_med, spikein_strain, spikein_antibiotic, spikein_metal, timepoint, water_frequency, "water_pH", water_source_shared, enrichment_protocol, food_quality_date, "IFSAC_category", animal_housing, cult_isol_date, food_clean_proc, misc_param, samp_name, project_name, seq_meth, samp_size, nucl_acid_ext, samp_vol_we_dna_ext, host_disease_stat, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, associated_resource, sop)
);

CREATE TABLE "food_farm_environment_MIUVIG" (
	lat_lon TEXT NOT NULL, 
	depth TEXT NOT NULL, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	humidity TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	solar_irradiance TEXT, 
	ventilation_rate TEXT, 
	samp_stor_dur TEXT, 
	wind_speed TEXT, 
	salinity TEXT, 
	previous_land_use TEXT, 
	crop_rotation TEXT, 
	soil_type_meth TEXT, 
	tot_org_c_meth TEXT, 
	tot_nitro_cont_meth TEXT, 
	salinity_meth TEXT, 
	host_age TEXT, 
	host_dry_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_tot_mass TEXT, 
	root_med_carbon TEXT, 
	root_med_macronutr TEXT, 
	root_med_micronutr TEXT, 
	season_temp TEXT, 
	season_precpt TEXT, 
	tot_org_carb TEXT, 
	tot_nitro_content TEXT, 
	conduc TEXT, 
	turbidity TEXT, 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	ventilation_type TEXT, 
	wind_direction TEXT, 
	genetic_mod TEXT, 
	host_phenotype TEXT, 
	ph FLOAT, 
	ances_data TEXT, 
	biotic_regm TEXT NOT NULL, 
	chem_administration TEXT NOT NULL, 
	growth_habit VARCHAR(10), 
	host_genotype TEXT, 
	host_taxid TEXT, 
	mechanical_damage TEXT, 
	perturbation TEXT, 
	root_cond TEXT, 
	root_med_ph FLOAT, 
	tillage VARCHAR(13), 
	ph_meth TEXT, 
	growth_medium TEXT, 
	season TEXT, 
	food_product_type TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	farm_water_source VARCHAR(19), 
	plant_water_method TEXT, 
	"air_PM_concen" TEXT, 
	animal_feed_equip TEXT, 
	animal_intrusion TEXT, 
	anim_water_method TEXT, 
	crop_yield TEXT, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	plant_part_maturity TEXT, 
	adjacent_environment TEXT, 
	water_source_adjac TEXT, 
	farm_equip_shared TEXT, 
	farm_equip_san TEXT, 
	farm_equip_san_freq TEXT, 
	farm_equip TEXT, 
	fertilizer_admin TEXT, 
	fertilizer_date DATE, 
	animal_group_size INTEGER, 
	animal_diet TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_harvest_proc TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_source TEXT, 
	food_treat_proc TEXT, 
	extr_weather_event VARCHAR(28), 
	date_extr_weath DATE, 
	host_subspecf_genlin TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	air_flow_impede TEXT, 
	lot_number TEXT, 
	season_humidity TEXT, 
	part_plant_animal TEXT, 
	plant_growth_med VARCHAR(30), 
	plant_reprod_crop VARCHAR(18), 
	samp_purpose TEXT, 
	repository_name TEXT, 
	samp_pooling TEXT, 
	samp_source_mat_cat TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	soil_conductivity TEXT, 
	soil_cover TEXT, 
	"soil_pH" FLOAT, 
	rel_location TEXT, 
	soil_porosity TEXT, 
	"temp" TEXT, 
	soil_texture_class VARCHAR(15), 
	soil_texture_meth TEXT, 
	soil_type TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_growth_med TEXT, 
	spikein_strain TEXT, 
	spikein_antibiotic TEXT, 
	spikein_metal TEXT, 
	timepoint FLOAT, 
	water_frequency TEXT, 
	"water_pH" FLOAT, 
	water_source_shared VARCHAR(27), 
	enrichment_protocol TEXT, 
	food_quality_date TEXT, 
	"IFSAC_category" TEXT NOT NULL, 
	animal_housing TEXT, 
	cult_isol_date DATE, 
	food_clean_proc VARCHAR(30), 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	host_disease_stat TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	source_uvig VARCHAR(42) NOT NULL, 
	virus_enrich_appr VARCHAR(25) NOT NULL, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	compl_appr VARCHAR(15), 
	sort_tech VARCHAR(28), 
	single_cell_lysis_appr VARCHAR(11), 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT, 
	wga_amp_kit TEXT, 
	bin_param VARCHAR(15), 
	bin_software TEXT, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	vir_ident_software TEXT NOT NULL, 
	pred_genome_type VARCHAR(15) NOT NULL, 
	pred_genome_struc VARCHAR(13) NOT NULL, 
	detec_type TEXT NOT NULL, 
	otu_class_appr TEXT, 
	otu_seq_comp_appr TEXT, 
	otu_db TEXT, 
	host_pred_appr VARCHAR(24), 
	host_pred_est_acc TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, humidity, organism_count, spikein_count, samp_stor_temp, solar_irradiance, ventilation_rate, samp_stor_dur, wind_speed, salinity, previous_land_use, crop_rotation, soil_type_meth, tot_org_c_meth, tot_nitro_cont_meth, salinity_meth, host_age, host_dry_mass, host_height, host_length, host_tot_mass, root_med_carbon, root_med_macronutr, root_med_micronutr, season_temp, season_precpt, tot_org_carb, tot_nitro_content, conduc, turbidity, size_frac_low, size_frac_up, ventilation_type, wind_direction, genetic_mod, host_phenotype, ph, ances_data, biotic_regm, chem_administration, growth_habit, host_genotype, host_taxid, mechanical_damage, perturbation, root_cond, root_med_ph, tillage, ph_meth, growth_medium, season, food_product_type, samp_type, farm_water_source, plant_water_method, "air_PM_concen", animal_feed_equip, animal_intrusion, anim_water_method, crop_yield, cult_result, cult_result_org, cult_target, plant_part_maturity, adjacent_environment, water_source_adjac, farm_equip_shared, farm_equip_san, farm_equip_san_freq, farm_equip, fertilizer_admin, fertilizer_date, animal_group_size, animal_diet, food_contact_surf, food_contain_wrap, food_harvest_proc, food_pack_medium, food_preserv_proc, food_prod_char, prod_label_claims, food_trav_mode, food_trav_vehic, food_source, food_treat_proc, extr_weather_event, date_extr_weath, host_subspecf_genlin, intended_consumer, library_prep_kit, air_flow_impede, lot_number, season_humidity, part_plant_animal, plant_growth_med, plant_reprod_crop, samp_purpose, repository_name, samp_pooling, samp_source_mat_cat, sequencing_kit, sequencing_location, serovar_or_serotype, soil_conductivity, soil_cover, "soil_pH", rel_location, soil_porosity, "temp", soil_texture_class, soil_texture_meth, soil_type, spikein_org, spikein_serovar, spikein_growth_med, spikein_strain, spikein_antibiotic, spikein_metal, timepoint, water_frequency, "water_pH", water_source_shared, enrichment_protocol, food_quality_date, "IFSAC_category", animal_housing, cult_isol_date, food_clean_proc, misc_param, samp_name, project_name, seq_meth, samp_size, nucl_acid_ext, samp_vol_we_dna_ext, host_disease_stat, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, source_uvig, virus_enrich_appr, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, trnas, trna_ext_software, compl_score, compl_software, compl_appr, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, bin_param, bin_software, reassembly_bin, mag_cov_software, vir_ident_software, pred_genome_type, pred_genome_struc, detec_type, otu_class_appr, otu_seq_comp_appr, otu_db, host_pred_appr, host_pred_est_acc, associated_resource, sop)
);

CREATE TABLE food_food_production_facility (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	room_dim TEXT, 
	freq_clean VARCHAR(9), 
	samp_room_id INTEGER, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	surf_material VARCHAR(15), 
	indoor_surf VARCHAR(11), 
	avg_occup FLOAT, 
	samp_floor VARCHAR(9), 
	genetic_mod TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	samp_source_mat_cat TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	samp_stor_media TEXT NOT NULL, 
	samp_stor_device TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	food_product_qual TEXT NOT NULL, 
	food_contact_surf TEXT NOT NULL, 
	facility_type VARCHAR(24), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_collect_method TEXT, 
	num_samp_collect TEXT, 
	lot_number TEXT, 
	hygienic_area TEXT, 
	env_monitoring_zone TEXT, 
	area_samp_size TEXT, 
	samp_surf_moisture VARCHAR(21), 
	samp_loc_condition VARCHAR(28), 
	biocide_used TEXT, 
	ster_meth_samp_room TEXT, 
	enrichment_protocol TEXT, 
	cult_target TEXT, 
	microb_cult_med TEXT, 
	timepoint FLOAT, 
	bacterial_density TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	samp_pooling TEXT, 
	samp_purpose TEXT, 
	samp_rep_tech TEXT, 
	samp_rep_biol TEXT, 
	samp_transport_cont VARCHAR(25), 
	study_design TEXT, 
	nucl_acid_ext_kit TEXT, 
	library_prep_kit TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	study_inc_temp TEXT, 
	study_inc_dur TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	food_source TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_origin TEXT, 
	food_prod_synonym TEXT, 
	food_additive TEXT, 
	food_trace_list VARCHAR(45), 
	part_plant_animal TEXT, 
	food_ingredient TEXT, 
	spec_intended_cons TEXT, 
	"HACCP_term" TEXT, 
	dietary_claim_use TEXT, 
	food_allergen_label TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_name_status TEXT, 
	food_preserv_proc TEXT, 
	food_cooking_proc TEXT, 
	food_treat_proc TEXT, 
	food_contain_wrap TEXT, 
	food_pack_capacity TEXT, 
	food_pack_medium TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_quality_date TEXT, 
	repository_name TEXT, 
	intended_consumer TEXT, 
	food_pack_integrity TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	subspecf_gen_lin TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, samp_stor_temp, samp_stor_dur, room_dim, freq_clean, samp_room_id, pool_dna_extracts, samp_stor_loc, surf_material, indoor_surf, avg_occup, samp_floor, genetic_mod, coll_site_geo_feat, samp_source_mat_cat, samp_type, samp_stor_media, samp_stor_device, food_product_type, "IFSAC_category", food_product_qual, food_contact_surf, facility_type, food_trav_mode, food_trav_vehic, samp_transport_dur, samp_transport_temp, samp_collect_method, num_samp_collect, lot_number, hygienic_area, env_monitoring_zone, area_samp_size, samp_surf_moisture, samp_loc_condition, biocide_used, ster_meth_samp_room, enrichment_protocol, cult_target, microb_cult_med, timepoint, bacterial_density, cult_isol_date, cult_result, cult_result_org, samp_pooling, samp_purpose, samp_rep_tech, samp_rep_biol, samp_transport_cont, study_design, nucl_acid_ext_kit, library_prep_kit, sequencing_kit, sequencing_location, study_inc_temp, study_inc_dur, study_timecourse, study_tmnt, food_source, food_dis_point, food_dis_point_city, food_origin, food_prod_synonym, food_additive, food_trace_list, part_plant_animal, food_ingredient, spec_intended_cons, "HACCP_term", dietary_claim_use, food_allergen_label, food_prod_char, prod_label_claims, food_name_status, food_preserv_proc, food_cooking_proc, food_treat_proc, food_contain_wrap, food_pack_capacity, food_pack_medium, food_prior_contact, food_prod, food_quality_date, repository_name, intended_consumer, food_pack_integrity, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, subspecf_gen_lin)
);

CREATE TABLE "food_food_production_facility_MIGS_bacteria" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	"temp" TEXT, 
	room_dim TEXT, 
	freq_clean VARCHAR(9), 
	samp_room_id INTEGER, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	surf_material VARCHAR(15), 
	indoor_surf VARCHAR(11), 
	avg_occup FLOAT, 
	samp_floor VARCHAR(9), 
	genetic_mod TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	samp_source_mat_cat TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	samp_stor_media TEXT NOT NULL, 
	samp_stor_device TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	food_product_qual TEXT NOT NULL, 
	food_contact_surf TEXT NOT NULL, 
	facility_type VARCHAR(24), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_collect_method TEXT, 
	num_samp_collect TEXT, 
	lot_number TEXT, 
	hygienic_area TEXT, 
	env_monitoring_zone TEXT, 
	area_samp_size TEXT, 
	samp_surf_moisture VARCHAR(21), 
	samp_loc_condition VARCHAR(28), 
	biocide_used TEXT, 
	ster_meth_samp_room TEXT, 
	enrichment_protocol TEXT, 
	cult_target TEXT, 
	microb_cult_med TEXT, 
	timepoint FLOAT, 
	bacterial_density TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	samp_pooling TEXT, 
	samp_purpose TEXT, 
	samp_rep_tech TEXT, 
	samp_rep_biol TEXT, 
	samp_transport_cont VARCHAR(25), 
	study_design TEXT, 
	nucl_acid_ext_kit TEXT, 
	library_prep_kit TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	study_inc_temp TEXT, 
	study_inc_dur TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	food_source TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_origin TEXT, 
	food_prod_synonym TEXT, 
	food_additive TEXT, 
	food_trace_list VARCHAR(45), 
	part_plant_animal TEXT, 
	food_ingredient TEXT, 
	spec_intended_cons TEXT, 
	"HACCP_term" TEXT, 
	dietary_claim_use TEXT, 
	food_allergen_label TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_name_status TEXT, 
	food_preserv_proc TEXT, 
	food_cooking_proc TEXT, 
	food_treat_proc TEXT, 
	food_contain_wrap TEXT, 
	food_pack_capacity TEXT, 
	food_pack_medium TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_quality_date TEXT, 
	repository_name TEXT, 
	intended_consumer TEXT, 
	food_pack_integrity TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	subspecf_gen_lin TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	num_replicons INTEGER NOT NULL, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT NOT NULL, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	trophic_level VARCHAR(22), 
	encoded_traits TEXT, 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, samp_stor_temp, samp_stor_dur, "temp", room_dim, freq_clean, samp_room_id, pool_dna_extracts, samp_stor_loc, surf_material, indoor_surf, avg_occup, samp_floor, genetic_mod, coll_site_geo_feat, samp_source_mat_cat, samp_type, samp_stor_media, samp_stor_device, food_product_type, "IFSAC_category", food_product_qual, food_contact_surf, facility_type, food_trav_mode, food_trav_vehic, samp_transport_dur, samp_transport_temp, samp_collect_method, num_samp_collect, lot_number, hygienic_area, env_monitoring_zone, area_samp_size, samp_surf_moisture, samp_loc_condition, biocide_used, ster_meth_samp_room, enrichment_protocol, cult_target, microb_cult_med, timepoint, bacterial_density, cult_isol_date, cult_result, cult_result_org, samp_pooling, samp_purpose, samp_rep_tech, samp_rep_biol, samp_transport_cont, study_design, nucl_acid_ext_kit, library_prep_kit, sequencing_kit, sequencing_location, study_inc_temp, study_inc_dur, study_timecourse, study_tmnt, food_source, food_dis_point, food_dis_point_city, food_origin, food_prod_synonym, food_additive, food_trace_list, part_plant_animal, food_ingredient, spec_intended_cons, "HACCP_term", dietary_claim_use, food_allergen_label, food_prod_char, prod_label_claims, food_name_status, food_preserv_proc, food_cooking_proc, food_treat_proc, food_contain_wrap, food_pack_capacity, food_pack_medium, food_prior_contact, food_prod, food_quality_date, repository_name, intended_consumer, food_pack_integrity, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, subspecf_gen_lin, samp_taxon_id, neg_cont_type, pos_cont_type, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, trophic_level, encoded_traits, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "food_food_production_facility_MIGS_eukaryote" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	"temp" TEXT, 
	room_dim TEXT, 
	freq_clean VARCHAR(9), 
	samp_room_id INTEGER, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	surf_material VARCHAR(15), 
	indoor_surf VARCHAR(11), 
	avg_occup FLOAT, 
	samp_floor VARCHAR(9), 
	genetic_mod TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	samp_source_mat_cat TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	samp_stor_media TEXT NOT NULL, 
	samp_stor_device TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	food_product_qual TEXT NOT NULL, 
	food_contact_surf TEXT NOT NULL, 
	facility_type VARCHAR(24), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_collect_method TEXT, 
	num_samp_collect TEXT, 
	lot_number TEXT, 
	hygienic_area TEXT, 
	env_monitoring_zone TEXT, 
	area_samp_size TEXT, 
	samp_surf_moisture VARCHAR(21), 
	samp_loc_condition VARCHAR(28), 
	biocide_used TEXT, 
	ster_meth_samp_room TEXT, 
	enrichment_protocol TEXT, 
	cult_target TEXT, 
	microb_cult_med TEXT, 
	timepoint FLOAT, 
	bacterial_density TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	samp_pooling TEXT, 
	samp_purpose TEXT, 
	samp_rep_tech TEXT, 
	samp_rep_biol TEXT, 
	samp_transport_cont VARCHAR(25), 
	study_design TEXT, 
	nucl_acid_ext_kit TEXT, 
	library_prep_kit TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	study_inc_temp TEXT, 
	study_inc_dur TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	food_source TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_origin TEXT, 
	food_prod_synonym TEXT, 
	food_additive TEXT, 
	food_trace_list VARCHAR(45), 
	part_plant_animal TEXT, 
	food_ingredient TEXT, 
	spec_intended_cons TEXT, 
	"HACCP_term" TEXT, 
	dietary_claim_use TEXT, 
	food_allergen_label TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_name_status TEXT, 
	food_preserv_proc TEXT, 
	food_cooking_proc TEXT, 
	food_treat_proc TEXT, 
	food_contain_wrap TEXT, 
	food_pack_capacity TEXT, 
	food_pack_medium TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_quality_date TEXT, 
	repository_name TEXT, 
	intended_consumer TEXT, 
	food_pack_integrity TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	subspecf_gen_lin TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ploidy TEXT, 
	num_replicons INTEGER, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	trophic_level VARCHAR(22), 
	propagation TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, samp_stor_temp, samp_stor_dur, "temp", room_dim, freq_clean, samp_room_id, pool_dna_extracts, samp_stor_loc, surf_material, indoor_surf, avg_occup, samp_floor, genetic_mod, coll_site_geo_feat, samp_source_mat_cat, samp_type, samp_stor_media, samp_stor_device, food_product_type, "IFSAC_category", food_product_qual, food_contact_surf, facility_type, food_trav_mode, food_trav_vehic, samp_transport_dur, samp_transport_temp, samp_collect_method, num_samp_collect, lot_number, hygienic_area, env_monitoring_zone, area_samp_size, samp_surf_moisture, samp_loc_condition, biocide_used, ster_meth_samp_room, enrichment_protocol, cult_target, microb_cult_med, timepoint, bacterial_density, cult_isol_date, cult_result, cult_result_org, samp_pooling, samp_purpose, samp_rep_tech, samp_rep_biol, samp_transport_cont, study_design, nucl_acid_ext_kit, library_prep_kit, sequencing_kit, sequencing_location, study_inc_temp, study_inc_dur, study_timecourse, study_tmnt, food_source, food_dis_point, food_dis_point_city, food_origin, food_prod_synonym, food_additive, food_trace_list, part_plant_animal, food_ingredient, spec_intended_cons, "HACCP_term", dietary_claim_use, food_allergen_label, food_prod_char, prod_label_claims, food_name_status, food_preserv_proc, food_cooking_proc, food_treat_proc, food_contain_wrap, food_pack_capacity, food_pack_medium, food_prior_contact, food_prod, food_quality_date, repository_name, intended_consumer, food_pack_integrity, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, subspecf_gen_lin, samp_taxon_id, neg_cont_type, pos_cont_type, ploidy, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, trophic_level, propagation, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "food_food_production_facility_MIGS_org" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	"temp" TEXT, 
	room_dim TEXT, 
	freq_clean VARCHAR(9), 
	samp_room_id INTEGER, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	surf_material VARCHAR(15), 
	indoor_surf VARCHAR(11), 
	avg_occup FLOAT, 
	samp_floor VARCHAR(9), 
	genetic_mod TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	samp_source_mat_cat TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	samp_stor_media TEXT NOT NULL, 
	samp_stor_device TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	food_product_qual TEXT NOT NULL, 
	food_contact_surf TEXT NOT NULL, 
	facility_type VARCHAR(24), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_collect_method TEXT, 
	num_samp_collect TEXT, 
	lot_number TEXT, 
	hygienic_area TEXT, 
	env_monitoring_zone TEXT, 
	area_samp_size TEXT, 
	samp_surf_moisture VARCHAR(21), 
	samp_loc_condition VARCHAR(28), 
	biocide_used TEXT, 
	ster_meth_samp_room TEXT, 
	enrichment_protocol TEXT, 
	cult_target TEXT, 
	microb_cult_med TEXT, 
	timepoint FLOAT, 
	bacterial_density TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	samp_pooling TEXT, 
	samp_purpose TEXT, 
	samp_rep_tech TEXT, 
	samp_rep_biol TEXT, 
	samp_transport_cont VARCHAR(25), 
	study_design TEXT, 
	nucl_acid_ext_kit TEXT, 
	library_prep_kit TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	study_inc_temp TEXT, 
	study_inc_dur TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	food_source TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_origin TEXT, 
	food_prod_synonym TEXT, 
	food_additive TEXT, 
	food_trace_list VARCHAR(45), 
	part_plant_animal TEXT, 
	food_ingredient TEXT, 
	spec_intended_cons TEXT, 
	"HACCP_term" TEXT, 
	dietary_claim_use TEXT, 
	food_allergen_label TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_name_status TEXT, 
	food_preserv_proc TEXT, 
	food_cooking_proc TEXT, 
	food_treat_proc TEXT, 
	food_contain_wrap TEXT, 
	food_pack_capacity TEXT, 
	food_pack_medium TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_quality_date TEXT, 
	repository_name TEXT, 
	intended_consumer TEXT, 
	food_pack_integrity TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	subspecf_gen_lin TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, samp_stor_temp, samp_stor_dur, "temp", room_dim, freq_clean, samp_room_id, pool_dna_extracts, samp_stor_loc, surf_material, indoor_surf, avg_occup, samp_floor, genetic_mod, coll_site_geo_feat, samp_source_mat_cat, samp_type, samp_stor_media, samp_stor_device, food_product_type, "IFSAC_category", food_product_qual, food_contact_surf, facility_type, food_trav_mode, food_trav_vehic, samp_transport_dur, samp_transport_temp, samp_collect_method, num_samp_collect, lot_number, hygienic_area, env_monitoring_zone, area_samp_size, samp_surf_moisture, samp_loc_condition, biocide_used, ster_meth_samp_room, enrichment_protocol, cult_target, microb_cult_med, timepoint, bacterial_density, cult_isol_date, cult_result, cult_result_org, samp_pooling, samp_purpose, samp_rep_tech, samp_rep_biol, samp_transport_cont, study_design, nucl_acid_ext_kit, library_prep_kit, sequencing_kit, sequencing_location, study_inc_temp, study_inc_dur, study_timecourse, study_tmnt, food_source, food_dis_point, food_dis_point_city, food_origin, food_prod_synonym, food_additive, food_trace_list, part_plant_animal, food_ingredient, spec_intended_cons, "HACCP_term", dietary_claim_use, food_allergen_label, food_prod_char, prod_label_claims, food_name_status, food_preserv_proc, food_cooking_proc, food_treat_proc, food_contain_wrap, food_pack_capacity, food_pack_medium, food_prior_contact, food_prod, food_quality_date, repository_name, intended_consumer, food_pack_integrity, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, subspecf_gen_lin, samp_taxon_id, neg_cont_type, pos_cont_type, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "food_food_production_facility_MIGS_plant" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	"temp" TEXT, 
	room_dim TEXT, 
	freq_clean VARCHAR(9), 
	samp_room_id INTEGER, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	surf_material VARCHAR(15), 
	indoor_surf VARCHAR(11), 
	avg_occup FLOAT, 
	samp_floor VARCHAR(9), 
	genetic_mod TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	samp_source_mat_cat TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	samp_stor_media TEXT NOT NULL, 
	samp_stor_device TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	food_product_qual TEXT NOT NULL, 
	food_contact_surf TEXT NOT NULL, 
	facility_type VARCHAR(24), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_collect_method TEXT, 
	num_samp_collect TEXT, 
	lot_number TEXT, 
	hygienic_area TEXT, 
	env_monitoring_zone TEXT, 
	area_samp_size TEXT, 
	samp_surf_moisture VARCHAR(21), 
	samp_loc_condition VARCHAR(28), 
	biocide_used TEXT, 
	ster_meth_samp_room TEXT, 
	enrichment_protocol TEXT, 
	cult_target TEXT, 
	microb_cult_med TEXT, 
	timepoint FLOAT, 
	bacterial_density TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	samp_pooling TEXT, 
	samp_purpose TEXT, 
	samp_rep_tech TEXT, 
	samp_rep_biol TEXT, 
	samp_transport_cont VARCHAR(25), 
	study_design TEXT, 
	nucl_acid_ext_kit TEXT, 
	library_prep_kit TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	study_inc_temp TEXT, 
	study_inc_dur TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	food_source TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_origin TEXT, 
	food_prod_synonym TEXT, 
	food_additive TEXT, 
	food_trace_list VARCHAR(45), 
	part_plant_animal TEXT, 
	food_ingredient TEXT, 
	spec_intended_cons TEXT, 
	"HACCP_term" TEXT, 
	dietary_claim_use TEXT, 
	food_allergen_label TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_name_status TEXT, 
	food_preserv_proc TEXT, 
	food_cooking_proc TEXT, 
	food_treat_proc TEXT, 
	food_contain_wrap TEXT, 
	food_pack_capacity TEXT, 
	food_pack_medium TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_quality_date TEXT, 
	repository_name TEXT, 
	intended_consumer TEXT, 
	food_pack_integrity TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	subspecf_gen_lin TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, samp_stor_temp, samp_stor_dur, "temp", room_dim, freq_clean, samp_room_id, pool_dna_extracts, samp_stor_loc, surf_material, indoor_surf, avg_occup, samp_floor, genetic_mod, coll_site_geo_feat, samp_source_mat_cat, samp_type, samp_stor_media, samp_stor_device, food_product_type, "IFSAC_category", food_product_qual, food_contact_surf, facility_type, food_trav_mode, food_trav_vehic, samp_transport_dur, samp_transport_temp, samp_collect_method, num_samp_collect, lot_number, hygienic_area, env_monitoring_zone, area_samp_size, samp_surf_moisture, samp_loc_condition, biocide_used, ster_meth_samp_room, enrichment_protocol, cult_target, microb_cult_med, timepoint, bacterial_density, cult_isol_date, cult_result, cult_result_org, samp_pooling, samp_purpose, samp_rep_tech, samp_rep_biol, samp_transport_cont, study_design, nucl_acid_ext_kit, library_prep_kit, sequencing_kit, sequencing_location, study_inc_temp, study_inc_dur, study_timecourse, study_tmnt, food_source, food_dis_point, food_dis_point_city, food_origin, food_prod_synonym, food_additive, food_trace_list, part_plant_animal, food_ingredient, spec_intended_cons, "HACCP_term", dietary_claim_use, food_allergen_label, food_prod_char, prod_label_claims, food_name_status, food_preserv_proc, food_cooking_proc, food_treat_proc, food_contain_wrap, food_pack_capacity, food_pack_medium, food_prior_contact, food_prod, food_quality_date, repository_name, intended_consumer, food_pack_integrity, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, subspecf_gen_lin, samp_taxon_id, neg_cont_type, pos_cont_type, estimated_size, ref_biomaterial, source_mat_id, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "food_food_production_facility_MIGS_virus" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	"temp" TEXT, 
	room_dim TEXT, 
	freq_clean VARCHAR(9), 
	samp_room_id INTEGER, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	surf_material VARCHAR(15), 
	indoor_surf VARCHAR(11), 
	avg_occup FLOAT, 
	samp_floor VARCHAR(9), 
	genetic_mod TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	samp_source_mat_cat TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	samp_stor_media TEXT NOT NULL, 
	samp_stor_device TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	food_product_qual TEXT NOT NULL, 
	food_contact_surf TEXT NOT NULL, 
	facility_type VARCHAR(24), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_collect_method TEXT, 
	num_samp_collect TEXT, 
	lot_number TEXT, 
	hygienic_area TEXT, 
	env_monitoring_zone TEXT, 
	area_samp_size TEXT, 
	samp_surf_moisture VARCHAR(21), 
	samp_loc_condition VARCHAR(28), 
	biocide_used TEXT, 
	ster_meth_samp_room TEXT, 
	enrichment_protocol TEXT, 
	cult_target TEXT, 
	microb_cult_med TEXT, 
	timepoint FLOAT, 
	bacterial_density TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	samp_pooling TEXT, 
	samp_purpose TEXT, 
	samp_rep_tech TEXT, 
	samp_rep_biol TEXT, 
	samp_transport_cont VARCHAR(25), 
	study_design TEXT, 
	nucl_acid_ext_kit TEXT, 
	library_prep_kit TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	study_inc_temp TEXT, 
	study_inc_dur TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	food_source TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_origin TEXT, 
	food_prod_synonym TEXT, 
	food_additive TEXT, 
	food_trace_list VARCHAR(45), 
	part_plant_animal TEXT, 
	food_ingredient TEXT, 
	spec_intended_cons TEXT, 
	"HACCP_term" TEXT, 
	dietary_claim_use TEXT, 
	food_allergen_label TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_name_status TEXT, 
	food_preserv_proc TEXT, 
	food_cooking_proc TEXT, 
	food_treat_proc TEXT, 
	food_contain_wrap TEXT, 
	food_pack_capacity TEXT, 
	food_pack_medium TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_quality_date TEXT, 
	repository_name TEXT, 
	intended_consumer TEXT, 
	food_pack_integrity TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	subspecf_gen_lin TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	num_replicons INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	virus_enrich_appr VARCHAR(25), 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, samp_stor_temp, samp_stor_dur, "temp", room_dim, freq_clean, samp_room_id, pool_dna_extracts, samp_stor_loc, surf_material, indoor_surf, avg_occup, samp_floor, genetic_mod, coll_site_geo_feat, samp_source_mat_cat, samp_type, samp_stor_media, samp_stor_device, food_product_type, "IFSAC_category", food_product_qual, food_contact_surf, facility_type, food_trav_mode, food_trav_vehic, samp_transport_dur, samp_transport_temp, samp_collect_method, num_samp_collect, lot_number, hygienic_area, env_monitoring_zone, area_samp_size, samp_surf_moisture, samp_loc_condition, biocide_used, ster_meth_samp_room, enrichment_protocol, cult_target, microb_cult_med, timepoint, bacterial_density, cult_isol_date, cult_result, cult_result_org, samp_pooling, samp_purpose, samp_rep_tech, samp_rep_biol, samp_transport_cont, study_design, nucl_acid_ext_kit, library_prep_kit, sequencing_kit, sequencing_location, study_inc_temp, study_inc_dur, study_timecourse, study_tmnt, food_source, food_dis_point, food_dis_point_city, food_origin, food_prod_synonym, food_additive, food_trace_list, part_plant_animal, food_ingredient, spec_intended_cons, "HACCP_term", dietary_claim_use, food_allergen_label, food_prod_char, prod_label_claims, food_name_status, food_preserv_proc, food_cooking_proc, food_treat_proc, food_contain_wrap, food_pack_capacity, food_pack_medium, food_prior_contact, food_prod, food_quality_date, repository_name, intended_consumer, food_pack_integrity, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, subspecf_gen_lin, samp_taxon_id, neg_cont_type, pos_cont_type, num_replicons, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, virus_enrich_appr, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "food_food_production_facility_MIMAG" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	"temp" TEXT, 
	room_dim TEXT, 
	freq_clean VARCHAR(9), 
	samp_room_id INTEGER, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	surf_material VARCHAR(15), 
	indoor_surf VARCHAR(11), 
	avg_occup FLOAT, 
	samp_floor VARCHAR(9), 
	genetic_mod TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	samp_source_mat_cat TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	samp_stor_media TEXT NOT NULL, 
	samp_stor_device TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	food_product_qual TEXT NOT NULL, 
	food_contact_surf TEXT NOT NULL, 
	facility_type VARCHAR(24), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_collect_method TEXT, 
	num_samp_collect TEXT, 
	lot_number TEXT, 
	hygienic_area TEXT, 
	env_monitoring_zone TEXT, 
	area_samp_size TEXT, 
	samp_surf_moisture VARCHAR(21), 
	samp_loc_condition VARCHAR(28), 
	biocide_used TEXT, 
	ster_meth_samp_room TEXT, 
	enrichment_protocol TEXT, 
	cult_target TEXT, 
	microb_cult_med TEXT, 
	timepoint FLOAT, 
	bacterial_density TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	samp_pooling TEXT, 
	samp_purpose TEXT, 
	samp_rep_tech TEXT, 
	samp_rep_biol TEXT, 
	samp_transport_cont VARCHAR(25), 
	study_design TEXT, 
	nucl_acid_ext_kit TEXT, 
	library_prep_kit TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	study_inc_temp TEXT, 
	study_inc_dur TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	food_source TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_origin TEXT, 
	food_prod_synonym TEXT, 
	food_additive TEXT, 
	food_trace_list VARCHAR(45), 
	part_plant_animal TEXT, 
	food_ingredient TEXT, 
	spec_intended_cons TEXT, 
	"HACCP_term" TEXT, 
	dietary_claim_use TEXT, 
	food_allergen_label TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_name_status TEXT, 
	food_preserv_proc TEXT, 
	food_cooking_proc TEXT, 
	food_treat_proc TEXT, 
	food_contain_wrap TEXT, 
	food_pack_capacity TEXT, 
	food_pack_medium TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_quality_date TEXT, 
	repository_name TEXT, 
	intended_consumer TEXT, 
	food_pack_integrity TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	subspecf_gen_lin TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	bin_param VARCHAR(15) NOT NULL, 
	bin_software TEXT NOT NULL, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, samp_stor_temp, samp_stor_dur, "temp", room_dim, freq_clean, samp_room_id, pool_dna_extracts, samp_stor_loc, surf_material, indoor_surf, avg_occup, samp_floor, genetic_mod, coll_site_geo_feat, samp_source_mat_cat, samp_type, samp_stor_media, samp_stor_device, food_product_type, "IFSAC_category", food_product_qual, food_contact_surf, facility_type, food_trav_mode, food_trav_vehic, samp_transport_dur, samp_transport_temp, samp_collect_method, num_samp_collect, lot_number, hygienic_area, env_monitoring_zone, area_samp_size, samp_surf_moisture, samp_loc_condition, biocide_used, ster_meth_samp_room, enrichment_protocol, cult_target, microb_cult_med, timepoint, bacterial_density, cult_isol_date, cult_result, cult_result_org, samp_pooling, samp_purpose, samp_rep_tech, samp_rep_biol, samp_transport_cont, study_design, nucl_acid_ext_kit, library_prep_kit, sequencing_kit, sequencing_location, study_inc_temp, study_inc_dur, study_timecourse, study_tmnt, food_source, food_dis_point, food_dis_point_city, food_origin, food_prod_synonym, food_additive, food_trace_list, part_plant_animal, food_ingredient, spec_intended_cons, "HACCP_term", dietary_claim_use, food_allergen_label, food_prod_char, prod_label_claims, food_name_status, food_preserv_proc, food_cooking_proc, food_treat_proc, food_contain_wrap, food_pack_capacity, food_pack_medium, food_prior_contact, food_prod, food_quality_date, repository_name, intended_consumer, food_pack_integrity, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, subspecf_gen_lin, samp_taxon_id, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, bin_param, bin_software, reassembly_bin, mag_cov_software, associated_resource, sop)
);

CREATE TABLE "food_food_production_facility_MIMARKS_specimen" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	"temp" TEXT, 
	room_dim TEXT, 
	freq_clean VARCHAR(9), 
	samp_room_id INTEGER, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	surf_material VARCHAR(15), 
	indoor_surf VARCHAR(11), 
	avg_occup FLOAT, 
	samp_floor VARCHAR(9), 
	genetic_mod TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	samp_source_mat_cat TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	samp_stor_media TEXT NOT NULL, 
	samp_stor_device TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	food_product_qual TEXT NOT NULL, 
	food_contact_surf TEXT NOT NULL, 
	facility_type VARCHAR(24), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_collect_method TEXT, 
	num_samp_collect TEXT, 
	lot_number TEXT, 
	hygienic_area TEXT, 
	env_monitoring_zone TEXT, 
	area_samp_size TEXT, 
	samp_surf_moisture VARCHAR(21), 
	samp_loc_condition VARCHAR(28), 
	biocide_used TEXT, 
	ster_meth_samp_room TEXT, 
	enrichment_protocol TEXT, 
	cult_target TEXT, 
	microb_cult_med TEXT, 
	timepoint FLOAT, 
	bacterial_density TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	samp_pooling TEXT, 
	samp_purpose TEXT, 
	samp_rep_tech TEXT, 
	samp_rep_biol TEXT, 
	samp_transport_cont VARCHAR(25), 
	study_design TEXT, 
	nucl_acid_ext_kit TEXT, 
	library_prep_kit TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	study_inc_temp TEXT, 
	study_inc_dur TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	food_source TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_origin TEXT, 
	food_prod_synonym TEXT, 
	food_additive TEXT, 
	food_trace_list VARCHAR(45), 
	part_plant_animal TEXT, 
	food_ingredient TEXT, 
	spec_intended_cons TEXT, 
	"HACCP_term" TEXT, 
	dietary_claim_use TEXT, 
	food_allergen_label TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_name_status TEXT, 
	food_preserv_proc TEXT, 
	food_cooking_proc TEXT, 
	food_treat_proc TEXT, 
	food_contain_wrap TEXT, 
	food_pack_capacity TEXT, 
	food_pack_medium TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_quality_date TEXT, 
	repository_name TEXT, 
	intended_consumer TEXT, 
	food_pack_integrity TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	subspecf_gen_lin TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	mid TEXT, 
	adapters TEXT, 
	pcr_cond TEXT, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	assembly_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, samp_stor_temp, samp_stor_dur, "temp", room_dim, freq_clean, samp_room_id, pool_dna_extracts, samp_stor_loc, surf_material, indoor_surf, avg_occup, samp_floor, genetic_mod, coll_site_geo_feat, samp_source_mat_cat, samp_type, samp_stor_media, samp_stor_device, food_product_type, "IFSAC_category", food_product_qual, food_contact_surf, facility_type, food_trav_mode, food_trav_vehic, samp_transport_dur, samp_transport_temp, samp_collect_method, num_samp_collect, lot_number, hygienic_area, env_monitoring_zone, area_samp_size, samp_surf_moisture, samp_loc_condition, biocide_used, ster_meth_samp_room, enrichment_protocol, cult_target, microb_cult_med, timepoint, bacterial_density, cult_isol_date, cult_result, cult_result_org, samp_pooling, samp_purpose, samp_rep_tech, samp_rep_biol, samp_transport_cont, study_design, nucl_acid_ext_kit, library_prep_kit, sequencing_kit, sequencing_location, study_inc_temp, study_inc_dur, study_timecourse, study_tmnt, food_source, food_dis_point, food_dis_point_city, food_origin, food_prod_synonym, food_additive, food_trace_list, part_plant_animal, food_ingredient, spec_intended_cons, "HACCP_term", dietary_claim_use, food_allergen_label, food_prod_char, prod_label_claims, food_name_status, food_preserv_proc, food_cooking_proc, food_treat_proc, food_contain_wrap, food_pack_capacity, food_pack_medium, food_prior_contact, food_prod, food_quality_date, repository_name, intended_consumer, food_pack_integrity, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, subspecf_gen_lin, samp_taxon_id, neg_cont_type, pos_cont_type, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, pcr_primers, mid, adapters, pcr_cond, seq_quality_check, chimera_check, assembly_software, associated_resource, sop)
);

CREATE TABLE "food_food_production_facility_MIMARKS_survey" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	"temp" TEXT, 
	room_dim TEXT, 
	freq_clean VARCHAR(9), 
	samp_room_id INTEGER, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	surf_material VARCHAR(15), 
	indoor_surf VARCHAR(11), 
	avg_occup FLOAT, 
	samp_floor VARCHAR(9), 
	genetic_mod TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	samp_source_mat_cat TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	samp_stor_media TEXT NOT NULL, 
	samp_stor_device TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	food_product_qual TEXT NOT NULL, 
	food_contact_surf TEXT NOT NULL, 
	facility_type VARCHAR(24), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_collect_method TEXT, 
	num_samp_collect TEXT, 
	lot_number TEXT, 
	hygienic_area TEXT, 
	env_monitoring_zone TEXT, 
	area_samp_size TEXT, 
	samp_surf_moisture VARCHAR(21), 
	samp_loc_condition VARCHAR(28), 
	biocide_used TEXT, 
	ster_meth_samp_room TEXT, 
	enrichment_protocol TEXT, 
	cult_target TEXT, 
	microb_cult_med TEXT, 
	timepoint FLOAT, 
	bacterial_density TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	samp_pooling TEXT, 
	samp_purpose TEXT, 
	samp_rep_tech TEXT, 
	samp_rep_biol TEXT, 
	samp_transport_cont VARCHAR(25), 
	study_design TEXT, 
	nucl_acid_ext_kit TEXT, 
	library_prep_kit TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	study_inc_temp TEXT, 
	study_inc_dur TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	food_source TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_origin TEXT, 
	food_prod_synonym TEXT, 
	food_additive TEXT, 
	food_trace_list VARCHAR(45), 
	part_plant_animal TEXT, 
	food_ingredient TEXT, 
	spec_intended_cons TEXT, 
	"HACCP_term" TEXT, 
	dietary_claim_use TEXT, 
	food_allergen_label TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_name_status TEXT, 
	food_preserv_proc TEXT, 
	food_cooking_proc TEXT, 
	food_treat_proc TEXT, 
	food_contain_wrap TEXT, 
	food_pack_capacity TEXT, 
	food_pack_medium TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_quality_date TEXT, 
	repository_name TEXT, 
	intended_consumer TEXT, 
	food_pack_integrity TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	subspecf_gen_lin TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	extrachrom_elements INTEGER, 
	source_mat_id TEXT, 
	biotic_relationship VARCHAR(11), 
	trophic_level VARCHAR(22), 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	nucl_acid_amp TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	pcr_cond TEXT, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, samp_stor_temp, samp_stor_dur, "temp", room_dim, freq_clean, samp_room_id, pool_dna_extracts, samp_stor_loc, surf_material, indoor_surf, avg_occup, samp_floor, genetic_mod, coll_site_geo_feat, samp_source_mat_cat, samp_type, samp_stor_media, samp_stor_device, food_product_type, "IFSAC_category", food_product_qual, food_contact_surf, facility_type, food_trav_mode, food_trav_vehic, samp_transport_dur, samp_transport_temp, samp_collect_method, num_samp_collect, lot_number, hygienic_area, env_monitoring_zone, area_samp_size, samp_surf_moisture, samp_loc_condition, biocide_used, ster_meth_samp_room, enrichment_protocol, cult_target, microb_cult_med, timepoint, bacterial_density, cult_isol_date, cult_result, cult_result_org, samp_pooling, samp_purpose, samp_rep_tech, samp_rep_biol, samp_transport_cont, study_design, nucl_acid_ext_kit, library_prep_kit, sequencing_kit, sequencing_location, study_inc_temp, study_inc_dur, study_timecourse, study_tmnt, food_source, food_dis_point, food_dis_point_city, food_origin, food_prod_synonym, food_additive, food_trace_list, part_plant_animal, food_ingredient, spec_intended_cons, "HACCP_term", dietary_claim_use, food_allergen_label, food_prod_char, prod_label_claims, food_name_status, food_preserv_proc, food_cooking_proc, food_treat_proc, food_contain_wrap, food_pack_capacity, food_pack_medium, food_prior_contact, food_prod, food_quality_date, repository_name, intended_consumer, food_pack_integrity, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, subspecf_gen_lin, samp_taxon_id, neg_cont_type, pos_cont_type, extrachrom_elements, source_mat_id, biotic_relationship, trophic_level, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, nucl_acid_amp, target_gene, target_subfragment, pcr_primers, pcr_cond, seq_quality_check, chimera_check, associated_resource, sop)
);

CREATE TABLE "food_food_production_facility_MIMS" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	"temp" TEXT, 
	room_dim TEXT, 
	freq_clean VARCHAR(9), 
	samp_room_id INTEGER, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	surf_material VARCHAR(15), 
	indoor_surf VARCHAR(11), 
	avg_occup FLOAT, 
	samp_floor VARCHAR(9), 
	genetic_mod TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	samp_source_mat_cat TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	samp_stor_media TEXT NOT NULL, 
	samp_stor_device TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	food_product_qual TEXT NOT NULL, 
	food_contact_surf TEXT NOT NULL, 
	facility_type VARCHAR(24), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_collect_method TEXT, 
	num_samp_collect TEXT, 
	lot_number TEXT, 
	hygienic_area TEXT, 
	env_monitoring_zone TEXT, 
	area_samp_size TEXT, 
	samp_surf_moisture VARCHAR(21), 
	samp_loc_condition VARCHAR(28), 
	biocide_used TEXT, 
	ster_meth_samp_room TEXT, 
	enrichment_protocol TEXT, 
	cult_target TEXT, 
	microb_cult_med TEXT, 
	timepoint FLOAT, 
	bacterial_density TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	samp_pooling TEXT, 
	samp_purpose TEXT, 
	samp_rep_tech TEXT, 
	samp_rep_biol TEXT, 
	samp_transport_cont VARCHAR(25), 
	study_design TEXT, 
	nucl_acid_ext_kit TEXT, 
	library_prep_kit TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	study_inc_temp TEXT, 
	study_inc_dur TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	food_source TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_origin TEXT, 
	food_prod_synonym TEXT, 
	food_additive TEXT, 
	food_trace_list VARCHAR(45), 
	part_plant_animal TEXT, 
	food_ingredient TEXT, 
	spec_intended_cons TEXT, 
	"HACCP_term" TEXT, 
	dietary_claim_use TEXT, 
	food_allergen_label TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_name_status TEXT, 
	food_preserv_proc TEXT, 
	food_cooking_proc TEXT, 
	food_treat_proc TEXT, 
	food_contain_wrap TEXT, 
	food_pack_capacity TEXT, 
	food_pack_medium TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_quality_date TEXT, 
	repository_name TEXT, 
	intended_consumer TEXT, 
	food_pack_integrity TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	subspecf_gen_lin TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, samp_stor_temp, samp_stor_dur, "temp", room_dim, freq_clean, samp_room_id, pool_dna_extracts, samp_stor_loc, surf_material, indoor_surf, avg_occup, samp_floor, genetic_mod, coll_site_geo_feat, samp_source_mat_cat, samp_type, samp_stor_media, samp_stor_device, food_product_type, "IFSAC_category", food_product_qual, food_contact_surf, facility_type, food_trav_mode, food_trav_vehic, samp_transport_dur, samp_transport_temp, samp_collect_method, num_samp_collect, lot_number, hygienic_area, env_monitoring_zone, area_samp_size, samp_surf_moisture, samp_loc_condition, biocide_used, ster_meth_samp_room, enrichment_protocol, cult_target, microb_cult_med, timepoint, bacterial_density, cult_isol_date, cult_result, cult_result_org, samp_pooling, samp_purpose, samp_rep_tech, samp_rep_biol, samp_transport_cont, study_design, nucl_acid_ext_kit, library_prep_kit, sequencing_kit, sequencing_location, study_inc_temp, study_inc_dur, study_timecourse, study_tmnt, food_source, food_dis_point, food_dis_point_city, food_origin, food_prod_synonym, food_additive, food_trace_list, part_plant_animal, food_ingredient, spec_intended_cons, "HACCP_term", dietary_claim_use, food_allergen_label, food_prod_char, prod_label_claims, food_name_status, food_preserv_proc, food_cooking_proc, food_treat_proc, food_contain_wrap, food_pack_capacity, food_pack_medium, food_prior_contact, food_prod, food_quality_date, repository_name, intended_consumer, food_pack_integrity, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, subspecf_gen_lin, samp_taxon_id, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, associated_resource, sop)
);

CREATE TABLE "food_food_production_facility_MISAG" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	"temp" TEXT, 
	room_dim TEXT, 
	freq_clean VARCHAR(9), 
	samp_room_id INTEGER, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	surf_material VARCHAR(15), 
	indoor_surf VARCHAR(11), 
	avg_occup FLOAT, 
	samp_floor VARCHAR(9), 
	genetic_mod TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	samp_source_mat_cat TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	samp_stor_media TEXT NOT NULL, 
	samp_stor_device TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	food_product_qual TEXT NOT NULL, 
	food_contact_surf TEXT NOT NULL, 
	facility_type VARCHAR(24), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_collect_method TEXT, 
	num_samp_collect TEXT, 
	lot_number TEXT, 
	hygienic_area TEXT, 
	env_monitoring_zone TEXT, 
	area_samp_size TEXT, 
	samp_surf_moisture VARCHAR(21), 
	samp_loc_condition VARCHAR(28), 
	biocide_used TEXT, 
	ster_meth_samp_room TEXT, 
	enrichment_protocol TEXT, 
	cult_target TEXT, 
	microb_cult_med TEXT, 
	timepoint FLOAT, 
	bacterial_density TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	samp_pooling TEXT, 
	samp_purpose TEXT, 
	samp_rep_tech TEXT, 
	samp_rep_biol TEXT, 
	samp_transport_cont VARCHAR(25), 
	study_design TEXT, 
	nucl_acid_ext_kit TEXT, 
	library_prep_kit TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	study_inc_temp TEXT, 
	study_inc_dur TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	food_source TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_origin TEXT, 
	food_prod_synonym TEXT, 
	food_additive TEXT, 
	food_trace_list VARCHAR(45), 
	part_plant_animal TEXT, 
	food_ingredient TEXT, 
	spec_intended_cons TEXT, 
	"HACCP_term" TEXT, 
	dietary_claim_use TEXT, 
	food_allergen_label TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_name_status TEXT, 
	food_preserv_proc TEXT, 
	food_cooking_proc TEXT, 
	food_treat_proc TEXT, 
	food_contain_wrap TEXT, 
	food_pack_capacity TEXT, 
	food_pack_medium TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_quality_date TEXT, 
	repository_name TEXT, 
	intended_consumer TEXT, 
	food_pack_integrity TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	subspecf_gen_lin TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	sort_tech VARCHAR(28) NOT NULL, 
	single_cell_lysis_appr VARCHAR(11) NOT NULL, 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT NOT NULL, 
	wga_amp_kit TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, samp_stor_temp, samp_stor_dur, "temp", room_dim, freq_clean, samp_room_id, pool_dna_extracts, samp_stor_loc, surf_material, indoor_surf, avg_occup, samp_floor, genetic_mod, coll_site_geo_feat, samp_source_mat_cat, samp_type, samp_stor_media, samp_stor_device, food_product_type, "IFSAC_category", food_product_qual, food_contact_surf, facility_type, food_trav_mode, food_trav_vehic, samp_transport_dur, samp_transport_temp, samp_collect_method, num_samp_collect, lot_number, hygienic_area, env_monitoring_zone, area_samp_size, samp_surf_moisture, samp_loc_condition, biocide_used, ster_meth_samp_room, enrichment_protocol, cult_target, microb_cult_med, timepoint, bacterial_density, cult_isol_date, cult_result, cult_result_org, samp_pooling, samp_purpose, samp_rep_tech, samp_rep_biol, samp_transport_cont, study_design, nucl_acid_ext_kit, library_prep_kit, sequencing_kit, sequencing_location, study_inc_temp, study_inc_dur, study_timecourse, study_tmnt, food_source, food_dis_point, food_dis_point_city, food_origin, food_prod_synonym, food_additive, food_trace_list, part_plant_animal, food_ingredient, spec_intended_cons, "HACCP_term", dietary_claim_use, food_allergen_label, food_prod_char, prod_label_claims, food_name_status, food_preserv_proc, food_cooking_proc, food_treat_proc, food_contain_wrap, food_pack_capacity, food_pack_medium, food_prior_contact, food_prod, food_quality_date, repository_name, intended_consumer, food_pack_integrity, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, subspecf_gen_lin, samp_taxon_id, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, associated_resource, sop)
);

CREATE TABLE "food_food_production_facility_MIUVIG" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	"temp" TEXT, 
	room_dim TEXT, 
	freq_clean VARCHAR(9), 
	samp_room_id INTEGER, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	surf_material VARCHAR(15), 
	indoor_surf VARCHAR(11), 
	avg_occup FLOAT, 
	samp_floor VARCHAR(9), 
	genetic_mod TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	samp_source_mat_cat TEXT NOT NULL, 
	samp_type TEXT NOT NULL, 
	samp_stor_media TEXT NOT NULL, 
	samp_stor_device TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	food_product_qual TEXT NOT NULL, 
	food_contact_surf TEXT NOT NULL, 
	facility_type VARCHAR(24), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_collect_method TEXT, 
	num_samp_collect TEXT, 
	lot_number TEXT, 
	hygienic_area TEXT, 
	env_monitoring_zone TEXT, 
	area_samp_size TEXT, 
	samp_surf_moisture VARCHAR(21), 
	samp_loc_condition VARCHAR(28), 
	biocide_used TEXT, 
	ster_meth_samp_room TEXT, 
	enrichment_protocol TEXT, 
	cult_target TEXT, 
	microb_cult_med TEXT, 
	timepoint FLOAT, 
	bacterial_density TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	samp_pooling TEXT, 
	samp_purpose TEXT, 
	samp_rep_tech TEXT, 
	samp_rep_biol TEXT, 
	samp_transport_cont VARCHAR(25), 
	study_design TEXT, 
	nucl_acid_ext_kit TEXT, 
	library_prep_kit TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	study_inc_temp TEXT, 
	study_inc_dur TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	food_source TEXT, 
	food_dis_point TEXT, 
	food_dis_point_city TEXT, 
	food_origin TEXT, 
	food_prod_synonym TEXT, 
	food_additive TEXT, 
	food_trace_list VARCHAR(45), 
	part_plant_animal TEXT, 
	food_ingredient TEXT, 
	spec_intended_cons TEXT, 
	"HACCP_term" TEXT, 
	dietary_claim_use TEXT, 
	food_allergen_label TEXT, 
	food_prod_char TEXT, 
	prod_label_claims TEXT, 
	food_name_status TEXT, 
	food_preserv_proc TEXT, 
	food_cooking_proc TEXT, 
	food_treat_proc TEXT, 
	food_contain_wrap TEXT, 
	food_pack_capacity TEXT, 
	food_pack_medium TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_quality_date TEXT, 
	repository_name TEXT, 
	intended_consumer TEXT, 
	food_pack_integrity TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	subspecf_gen_lin TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	source_uvig VARCHAR(42) NOT NULL, 
	virus_enrich_appr VARCHAR(25) NOT NULL, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	compl_appr VARCHAR(15), 
	sort_tech VARCHAR(28), 
	single_cell_lysis_appr VARCHAR(11), 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT, 
	wga_amp_kit TEXT, 
	bin_param VARCHAR(15), 
	bin_software TEXT, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	vir_ident_software TEXT NOT NULL, 
	pred_genome_type VARCHAR(15) NOT NULL, 
	pred_genome_struc VARCHAR(13) NOT NULL, 
	detec_type TEXT NOT NULL, 
	otu_class_appr TEXT, 
	otu_seq_comp_appr TEXT, 
	otu_db TEXT, 
	host_pred_appr VARCHAR(24), 
	host_pred_est_acc TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, samp_stor_temp, samp_stor_dur, "temp", room_dim, freq_clean, samp_room_id, pool_dna_extracts, samp_stor_loc, surf_material, indoor_surf, avg_occup, samp_floor, genetic_mod, coll_site_geo_feat, samp_source_mat_cat, samp_type, samp_stor_media, samp_stor_device, food_product_type, "IFSAC_category", food_product_qual, food_contact_surf, facility_type, food_trav_mode, food_trav_vehic, samp_transport_dur, samp_transport_temp, samp_collect_method, num_samp_collect, lot_number, hygienic_area, env_monitoring_zone, area_samp_size, samp_surf_moisture, samp_loc_condition, biocide_used, ster_meth_samp_room, enrichment_protocol, cult_target, microb_cult_med, timepoint, bacterial_density, cult_isol_date, cult_result, cult_result_org, samp_pooling, samp_purpose, samp_rep_tech, samp_rep_biol, samp_transport_cont, study_design, nucl_acid_ext_kit, library_prep_kit, sequencing_kit, sequencing_location, study_inc_temp, study_inc_dur, study_timecourse, study_tmnt, food_source, food_dis_point, food_dis_point_city, food_origin, food_prod_synonym, food_additive, food_trace_list, part_plant_animal, food_ingredient, spec_intended_cons, "HACCP_term", dietary_claim_use, food_allergen_label, food_prod_char, prod_label_claims, food_name_status, food_preserv_proc, food_cooking_proc, food_treat_proc, food_contain_wrap, food_pack_capacity, food_pack_medium, food_prior_contact, food_prod, food_quality_date, repository_name, intended_consumer, food_pack_integrity, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, subspecf_gen_lin, samp_taxon_id, neg_cont_type, pos_cont_type, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, source_uvig, virus_enrich_appr, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, trnas, trna_ext_software, compl_score, compl_software, compl_appr, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, bin_param, bin_software, reassembly_bin, mag_cov_software, vir_ident_software, pred_genome_type, pred_genome_struc, detec_type, otu_class_appr, otu_seq_comp_appr, otu_db, host_pred_appr, host_pred_est_acc, associated_resource, sop)
);

CREATE TABLE food_human_foods (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	genetic_mod TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	ferm_chem_add TEXT, 
	ferm_chem_add_perc TEXT, 
	ferm_headspace_oxy TEXT, 
	ferm_medium TEXT, 
	"ferm_pH" FLOAT, 
	ferm_rel_humidity TEXT, 
	ferm_temp TEXT, 
	ferm_time TEXT, 
	ferm_vessel TEXT, 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	dietary_claim_use TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_allergen_label TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_ingredient TEXT, 
	food_name_status TEXT, 
	food_origin TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	microb_start TEXT, 
	microb_start_count VARCHAR(12), 
	microb_start_inoc TEXT, 
	microb_start_prep TEXT, 
	microb_start_source TEXT, 
	"microb_start_taxID" TEXT, 
	nucl_acid_ext_kit TEXT, 
	num_samp_collect TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	sample_collec_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_purpose TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, genetic_mod, perturbation, coll_site_geo_feat, food_product_type, "IFSAC_category", ferm_chem_add, ferm_chem_add_perc, ferm_headspace_oxy, ferm_medium, "ferm_pH", ferm_rel_humidity, ferm_temp, ferm_time, ferm_vessel, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, dietary_claim_use, enrichment_protocol, food_additive, food_allergen_label, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_ingredient, food_name_status, food_origin, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod, food_prod_synonym, food_product_qual, food_quality_date, food_source, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", intended_consumer, library_prep_kit, lot_number, microb_cult_med, microb_start, microb_start_count, microb_start_inoc, microb_start_prep, microb_start_source, "microb_start_taxID", nucl_acid_ext_kit, num_samp_collect, part_plant_animal, repository_name, sample_collec_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, samp_purpose, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext)
);

CREATE TABLE "food_human_foods_MIGS_bacteria" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	genetic_mod TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	ferm_chem_add TEXT, 
	ferm_chem_add_perc TEXT, 
	ferm_headspace_oxy TEXT, 
	ferm_medium TEXT, 
	"ferm_pH" FLOAT, 
	ferm_rel_humidity TEXT, 
	ferm_temp TEXT, 
	ferm_time TEXT, 
	ferm_vessel TEXT, 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	dietary_claim_use TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_allergen_label TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_ingredient TEXT, 
	food_name_status TEXT, 
	food_origin TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	microb_start TEXT, 
	microb_start_count VARCHAR(12), 
	microb_start_inoc TEXT, 
	microb_start_prep TEXT, 
	microb_start_source TEXT, 
	"microb_start_taxID" TEXT, 
	nucl_acid_ext_kit TEXT, 
	num_samp_collect TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	sample_collec_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_purpose TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER NOT NULL, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT NOT NULL, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	trophic_level VARCHAR(22), 
	encoded_traits TEXT, 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, genetic_mod, perturbation, coll_site_geo_feat, food_product_type, "IFSAC_category", ferm_chem_add, ferm_chem_add_perc, ferm_headspace_oxy, ferm_medium, "ferm_pH", ferm_rel_humidity, ferm_temp, ferm_time, ferm_vessel, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, dietary_claim_use, enrichment_protocol, food_additive, food_allergen_label, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_ingredient, food_name_status, food_origin, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod, food_prod_synonym, food_product_qual, food_quality_date, food_source, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", intended_consumer, library_prep_kit, lot_number, microb_cult_med, microb_start, microb_start_count, microb_start_inoc, microb_start_prep, microb_start_source, "microb_start_taxID", nucl_acid_ext_kit, num_samp_collect, part_plant_animal, repository_name, sample_collec_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, samp_purpose, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, trophic_level, encoded_traits, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "food_human_foods_MIGS_eukaryote" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	genetic_mod TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	ferm_chem_add TEXT, 
	ferm_chem_add_perc TEXT, 
	ferm_headspace_oxy TEXT, 
	ferm_medium TEXT, 
	"ferm_pH" FLOAT, 
	ferm_rel_humidity TEXT, 
	ferm_temp TEXT, 
	ferm_time TEXT, 
	ferm_vessel TEXT, 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	dietary_claim_use TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_allergen_label TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_ingredient TEXT, 
	food_name_status TEXT, 
	food_origin TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	microb_start TEXT, 
	microb_start_count VARCHAR(12), 
	microb_start_inoc TEXT, 
	microb_start_prep TEXT, 
	microb_start_source TEXT, 
	"microb_start_taxID" TEXT, 
	nucl_acid_ext_kit TEXT, 
	num_samp_collect TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	sample_collec_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_purpose TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	ploidy TEXT, 
	num_replicons INTEGER, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	trophic_level VARCHAR(22), 
	propagation TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, genetic_mod, perturbation, coll_site_geo_feat, food_product_type, "IFSAC_category", ferm_chem_add, ferm_chem_add_perc, ferm_headspace_oxy, ferm_medium, "ferm_pH", ferm_rel_humidity, ferm_temp, ferm_time, ferm_vessel, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, dietary_claim_use, enrichment_protocol, food_additive, food_allergen_label, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_ingredient, food_name_status, food_origin, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod, food_prod_synonym, food_product_qual, food_quality_date, food_source, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", intended_consumer, library_prep_kit, lot_number, microb_cult_med, microb_start, microb_start_count, microb_start_inoc, microb_start_prep, microb_start_source, "microb_start_taxID", nucl_acid_ext_kit, num_samp_collect, part_plant_animal, repository_name, sample_collec_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, samp_purpose, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, subspecf_gen_lin, ploidy, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, trophic_level, propagation, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "food_human_foods_MIGS_org" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	genetic_mod TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	ferm_chem_add TEXT, 
	ferm_chem_add_perc TEXT, 
	ferm_headspace_oxy TEXT, 
	ferm_medium TEXT, 
	"ferm_pH" FLOAT, 
	ferm_rel_humidity TEXT, 
	ferm_temp TEXT, 
	ferm_time TEXT, 
	ferm_vessel TEXT, 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	dietary_claim_use TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_allergen_label TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_ingredient TEXT, 
	food_name_status TEXT, 
	food_origin TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	microb_start TEXT, 
	microb_start_count VARCHAR(12), 
	microb_start_inoc TEXT, 
	microb_start_prep TEXT, 
	microb_start_source TEXT, 
	"microb_start_taxID" TEXT, 
	nucl_acid_ext_kit TEXT, 
	num_samp_collect TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	sample_collec_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_purpose TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, genetic_mod, perturbation, coll_site_geo_feat, food_product_type, "IFSAC_category", ferm_chem_add, ferm_chem_add_perc, ferm_headspace_oxy, ferm_medium, "ferm_pH", ferm_rel_humidity, ferm_temp, ferm_time, ferm_vessel, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, dietary_claim_use, enrichment_protocol, food_additive, food_allergen_label, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_ingredient, food_name_status, food_origin, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod, food_prod_synonym, food_product_qual, food_quality_date, food_source, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", intended_consumer, library_prep_kit, lot_number, microb_cult_med, microb_start, microb_start_count, microb_start_inoc, microb_start_prep, microb_start_source, "microb_start_taxID", nucl_acid_ext_kit, num_samp_collect, part_plant_animal, repository_name, sample_collec_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, samp_purpose, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "food_human_foods_MIGS_plant" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	genetic_mod TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	ferm_chem_add TEXT, 
	ferm_chem_add_perc TEXT, 
	ferm_headspace_oxy TEXT, 
	ferm_medium TEXT, 
	"ferm_pH" FLOAT, 
	ferm_rel_humidity TEXT, 
	ferm_temp TEXT, 
	ferm_time TEXT, 
	ferm_vessel TEXT, 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	dietary_claim_use TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_allergen_label TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_ingredient TEXT, 
	food_name_status TEXT, 
	food_origin TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	microb_start TEXT, 
	microb_start_count VARCHAR(12), 
	microb_start_inoc TEXT, 
	microb_start_prep TEXT, 
	microb_start_source TEXT, 
	"microb_start_taxID" TEXT, 
	nucl_acid_ext_kit TEXT, 
	num_samp_collect TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	sample_collec_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_purpose TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, genetic_mod, perturbation, coll_site_geo_feat, food_product_type, "IFSAC_category", ferm_chem_add, ferm_chem_add_perc, ferm_headspace_oxy, ferm_medium, "ferm_pH", ferm_rel_humidity, ferm_temp, ferm_time, ferm_vessel, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, dietary_claim_use, enrichment_protocol, food_additive, food_allergen_label, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_ingredient, food_name_status, food_origin, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod, food_prod_synonym, food_product_qual, food_quality_date, food_source, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", intended_consumer, library_prep_kit, lot_number, microb_cult_med, microb_start, microb_start_count, microb_start_inoc, microb_start_prep, microb_start_source, "microb_start_taxID", nucl_acid_ext_kit, num_samp_collect, part_plant_animal, repository_name, sample_collec_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, samp_purpose, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, subspecf_gen_lin, estimated_size, ref_biomaterial, source_mat_id, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "food_human_foods_MIGS_virus" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	genetic_mod TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	ferm_chem_add TEXT, 
	ferm_chem_add_perc TEXT, 
	ferm_headspace_oxy TEXT, 
	ferm_medium TEXT, 
	"ferm_pH" FLOAT, 
	ferm_rel_humidity TEXT, 
	ferm_temp TEXT, 
	ferm_time TEXT, 
	ferm_vessel TEXT, 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	dietary_claim_use TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_allergen_label TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_ingredient TEXT, 
	food_name_status TEXT, 
	food_origin TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	microb_start TEXT, 
	microb_start_count VARCHAR(12), 
	microb_start_inoc TEXT, 
	microb_start_prep TEXT, 
	microb_start_source TEXT, 
	"microb_start_taxID" TEXT, 
	nucl_acid_ext_kit TEXT, 
	num_samp_collect TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	sample_collec_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_purpose TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	virus_enrich_appr VARCHAR(25), 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, genetic_mod, perturbation, coll_site_geo_feat, food_product_type, "IFSAC_category", ferm_chem_add, ferm_chem_add_perc, ferm_headspace_oxy, ferm_medium, "ferm_pH", ferm_rel_humidity, ferm_temp, ferm_time, ferm_vessel, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, dietary_claim_use, enrichment_protocol, food_additive, food_allergen_label, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_ingredient, food_name_status, food_origin, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod, food_prod_synonym, food_product_qual, food_quality_date, food_source, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", intended_consumer, library_prep_kit, lot_number, microb_cult_med, microb_start, microb_start_count, microb_start_inoc, microb_start_prep, microb_start_source, "microb_start_taxID", nucl_acid_ext_kit, num_samp_collect, part_plant_animal, repository_name, sample_collec_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, samp_purpose, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, virus_enrich_appr, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "food_human_foods_MIMAG" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	genetic_mod TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	ferm_chem_add TEXT, 
	ferm_chem_add_perc TEXT, 
	ferm_headspace_oxy TEXT, 
	ferm_medium TEXT, 
	"ferm_pH" FLOAT, 
	ferm_rel_humidity TEXT, 
	ferm_temp TEXT, 
	ferm_time TEXT, 
	ferm_vessel TEXT, 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	dietary_claim_use TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_allergen_label TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_ingredient TEXT, 
	food_name_status TEXT, 
	food_origin TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	microb_start TEXT, 
	microb_start_count VARCHAR(12), 
	microb_start_inoc TEXT, 
	microb_start_prep TEXT, 
	microb_start_source TEXT, 
	"microb_start_taxID" TEXT, 
	nucl_acid_ext_kit TEXT, 
	num_samp_collect TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	sample_collec_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_purpose TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	bin_param VARCHAR(15) NOT NULL, 
	bin_software TEXT NOT NULL, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, genetic_mod, perturbation, coll_site_geo_feat, food_product_type, "IFSAC_category", ferm_chem_add, ferm_chem_add_perc, ferm_headspace_oxy, ferm_medium, "ferm_pH", ferm_rel_humidity, ferm_temp, ferm_time, ferm_vessel, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, dietary_claim_use, enrichment_protocol, food_additive, food_allergen_label, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_ingredient, food_name_status, food_origin, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod, food_prod_synonym, food_product_qual, food_quality_date, food_source, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", intended_consumer, library_prep_kit, lot_number, microb_cult_med, microb_start, microb_start_count, microb_start_inoc, microb_start_prep, microb_start_source, "microb_start_taxID", nucl_acid_ext_kit, num_samp_collect, part_plant_animal, repository_name, sample_collec_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, samp_purpose, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, bin_param, bin_software, reassembly_bin, mag_cov_software, associated_resource, sop)
);

CREATE TABLE "food_human_foods_MIMARKS_specimen" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	genetic_mod TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	ferm_chem_add TEXT, 
	ferm_chem_add_perc TEXT, 
	ferm_headspace_oxy TEXT, 
	ferm_medium TEXT, 
	"ferm_pH" FLOAT, 
	ferm_rel_humidity TEXT, 
	ferm_temp TEXT, 
	ferm_time TEXT, 
	ferm_vessel TEXT, 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	dietary_claim_use TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_allergen_label TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_ingredient TEXT, 
	food_name_status TEXT, 
	food_origin TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	microb_start TEXT, 
	microb_start_count VARCHAR(12), 
	microb_start_inoc TEXT, 
	microb_start_prep TEXT, 
	microb_start_source TEXT, 
	"microb_start_taxID" TEXT, 
	nucl_acid_ext_kit TEXT, 
	num_samp_collect TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	sample_collec_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_purpose TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	mid TEXT, 
	adapters TEXT, 
	pcr_cond TEXT, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	assembly_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, genetic_mod, perturbation, coll_site_geo_feat, food_product_type, "IFSAC_category", ferm_chem_add, ferm_chem_add_perc, ferm_headspace_oxy, ferm_medium, "ferm_pH", ferm_rel_humidity, ferm_temp, ferm_time, ferm_vessel, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, dietary_claim_use, enrichment_protocol, food_additive, food_allergen_label, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_ingredient, food_name_status, food_origin, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod, food_prod_synonym, food_product_qual, food_quality_date, food_source, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", intended_consumer, library_prep_kit, lot_number, microb_cult_med, microb_start, microb_start_count, microb_start_inoc, microb_start_prep, microb_start_source, "microb_start_taxID", nucl_acid_ext_kit, num_samp_collect, part_plant_animal, repository_name, sample_collec_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, samp_purpose, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, pcr_primers, mid, adapters, pcr_cond, seq_quality_check, chimera_check, assembly_software, associated_resource, sop)
);

CREATE TABLE "food_human_foods_MIMARKS_survey" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	genetic_mod TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	ferm_chem_add TEXT, 
	ferm_chem_add_perc TEXT, 
	ferm_headspace_oxy TEXT, 
	ferm_medium TEXT, 
	"ferm_pH" FLOAT, 
	ferm_rel_humidity TEXT, 
	ferm_temp TEXT, 
	ferm_time TEXT, 
	ferm_vessel TEXT, 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	dietary_claim_use TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_allergen_label TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_ingredient TEXT, 
	food_name_status TEXT, 
	food_origin TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	microb_start TEXT, 
	microb_start_count VARCHAR(12), 
	microb_start_inoc TEXT, 
	microb_start_prep TEXT, 
	microb_start_source TEXT, 
	"microb_start_taxID" TEXT, 
	nucl_acid_ext_kit TEXT, 
	num_samp_collect TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	sample_collec_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_purpose TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	source_mat_id TEXT, 
	biotic_relationship VARCHAR(11), 
	trophic_level VARCHAR(22), 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	nucl_acid_amp TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	pcr_cond TEXT, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, genetic_mod, perturbation, coll_site_geo_feat, food_product_type, "IFSAC_category", ferm_chem_add, ferm_chem_add_perc, ferm_headspace_oxy, ferm_medium, "ferm_pH", ferm_rel_humidity, ferm_temp, ferm_time, ferm_vessel, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, dietary_claim_use, enrichment_protocol, food_additive, food_allergen_label, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_ingredient, food_name_status, food_origin, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod, food_prod_synonym, food_product_qual, food_quality_date, food_source, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", intended_consumer, library_prep_kit, lot_number, microb_cult_med, microb_start, microb_start_count, microb_start_inoc, microb_start_prep, microb_start_source, "microb_start_taxID", nucl_acid_ext_kit, num_samp_collect, part_plant_animal, repository_name, sample_collec_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, samp_purpose, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, source_mat_id, biotic_relationship, trophic_level, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, nucl_acid_amp, target_gene, target_subfragment, pcr_primers, pcr_cond, seq_quality_check, chimera_check, associated_resource, sop)
);

CREATE TABLE "food_human_foods_MIMS" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	genetic_mod TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	ferm_chem_add TEXT, 
	ferm_chem_add_perc TEXT, 
	ferm_headspace_oxy TEXT, 
	ferm_medium TEXT, 
	"ferm_pH" FLOAT, 
	ferm_rel_humidity TEXT, 
	ferm_temp TEXT, 
	ferm_time TEXT, 
	ferm_vessel TEXT, 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	dietary_claim_use TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_allergen_label TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_ingredient TEXT, 
	food_name_status TEXT, 
	food_origin TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	microb_start TEXT, 
	microb_start_count VARCHAR(12), 
	microb_start_inoc TEXT, 
	microb_start_prep TEXT, 
	microb_start_source TEXT, 
	"microb_start_taxID" TEXT, 
	nucl_acid_ext_kit TEXT, 
	num_samp_collect TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	sample_collec_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_purpose TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, genetic_mod, perturbation, coll_site_geo_feat, food_product_type, "IFSAC_category", ferm_chem_add, ferm_chem_add_perc, ferm_headspace_oxy, ferm_medium, "ferm_pH", ferm_rel_humidity, ferm_temp, ferm_time, ferm_vessel, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, dietary_claim_use, enrichment_protocol, food_additive, food_allergen_label, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_ingredient, food_name_status, food_origin, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod, food_prod_synonym, food_product_qual, food_quality_date, food_source, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", intended_consumer, library_prep_kit, lot_number, microb_cult_med, microb_start, microb_start_count, microb_start_inoc, microb_start_prep, microb_start_source, "microb_start_taxID", nucl_acid_ext_kit, num_samp_collect, part_plant_animal, repository_name, sample_collec_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, samp_purpose, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, associated_resource, sop)
);

CREATE TABLE "food_human_foods_MISAG" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	genetic_mod TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	ferm_chem_add TEXT, 
	ferm_chem_add_perc TEXT, 
	ferm_headspace_oxy TEXT, 
	ferm_medium TEXT, 
	"ferm_pH" FLOAT, 
	ferm_rel_humidity TEXT, 
	ferm_temp TEXT, 
	ferm_time TEXT, 
	ferm_vessel TEXT, 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	dietary_claim_use TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_allergen_label TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_ingredient TEXT, 
	food_name_status TEXT, 
	food_origin TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	microb_start TEXT, 
	microb_start_count VARCHAR(12), 
	microb_start_inoc TEXT, 
	microb_start_prep TEXT, 
	microb_start_source TEXT, 
	"microb_start_taxID" TEXT, 
	nucl_acid_ext_kit TEXT, 
	num_samp_collect TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	sample_collec_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_purpose TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	sort_tech VARCHAR(28) NOT NULL, 
	single_cell_lysis_appr VARCHAR(11) NOT NULL, 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT NOT NULL, 
	wga_amp_kit TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, genetic_mod, perturbation, coll_site_geo_feat, food_product_type, "IFSAC_category", ferm_chem_add, ferm_chem_add_perc, ferm_headspace_oxy, ferm_medium, "ferm_pH", ferm_rel_humidity, ferm_temp, ferm_time, ferm_vessel, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, dietary_claim_use, enrichment_protocol, food_additive, food_allergen_label, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_ingredient, food_name_status, food_origin, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod, food_prod_synonym, food_product_qual, food_quality_date, food_source, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", intended_consumer, library_prep_kit, lot_number, microb_cult_med, microb_start, microb_start_count, microb_start_inoc, microb_start_prep, microb_start_source, "microb_start_taxID", nucl_acid_ext_kit, num_samp_collect, part_plant_animal, repository_name, sample_collec_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, samp_purpose, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, associated_resource, sop)
);

CREATE TABLE "food_human_foods_MIUVIG" (
	lat_lon TEXT NOT NULL, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT NOT NULL, 
	collection_date DATE NOT NULL, 
	env_broad_scale TEXT NOT NULL, 
	env_local_scale TEXT NOT NULL, 
	env_medium TEXT NOT NULL, 
	samp_collect_device TEXT, 
	organism_count VARCHAR(5), 
	spikein_count VARCHAR(5), 
	samp_stor_temp TEXT, 
	samp_stor_dur TEXT, 
	pool_dna_extracts TEXT, 
	samp_stor_loc TEXT, 
	genetic_mod TEXT, 
	perturbation TEXT, 
	coll_site_geo_feat TEXT NOT NULL, 
	food_product_type TEXT NOT NULL, 
	"IFSAC_category" TEXT NOT NULL, 
	ferm_chem_add TEXT, 
	ferm_chem_add_perc TEXT, 
	ferm_headspace_oxy TEXT, 
	ferm_medium TEXT, 
	"ferm_pH" FLOAT, 
	ferm_rel_humidity TEXT, 
	ferm_temp TEXT, 
	ferm_time TEXT, 
	ferm_vessel TEXT, 
	bacterial_density TEXT, 
	cons_food_stor_dur TEXT, 
	cons_food_stor_temp TEXT, 
	cons_purch_date DATE, 
	cons_qty_purchased TEXT, 
	cult_isol_date DATE, 
	cult_result VARCHAR(8), 
	cult_result_org TEXT, 
	cult_target TEXT, 
	dietary_claim_use TEXT, 
	enrichment_protocol TEXT, 
	food_additive TEXT, 
	food_allergen_label TEXT, 
	food_contact_surf TEXT, 
	food_contain_wrap TEXT, 
	food_cooking_proc TEXT, 
	food_dis_point TEXT, 
	food_ingredient TEXT, 
	food_name_status TEXT, 
	food_origin TEXT, 
	food_pack_capacity TEXT, 
	food_pack_integrity TEXT, 
	food_pack_medium TEXT, 
	food_preserv_proc TEXT, 
	food_prior_contact TEXT, 
	food_prod TEXT, 
	food_prod_synonym TEXT, 
	food_product_qual TEXT, 
	food_quality_date TEXT, 
	food_source TEXT, 
	food_trace_list VARCHAR(45), 
	food_trav_mode TEXT, 
	food_trav_vehic TEXT, 
	food_treat_proc TEXT, 
	"HACCP_term" TEXT, 
	intended_consumer TEXT, 
	library_prep_kit TEXT, 
	lot_number TEXT, 
	microb_cult_med TEXT, 
	microb_start TEXT, 
	microb_start_count VARCHAR(12), 
	microb_start_inoc TEXT, 
	microb_start_prep TEXT, 
	microb_start_source TEXT, 
	"microb_start_taxID" TEXT, 
	nucl_acid_ext_kit TEXT, 
	num_samp_collect TEXT, 
	part_plant_animal TEXT, 
	repository_name TEXT, 
	sample_collec_method TEXT, 
	samp_pooling TEXT, 
	samp_rep_biol TEXT, 
	samp_rep_tech TEXT, 
	samp_source_mat_cat TEXT, 
	samp_stor_device TEXT, 
	samp_stor_media TEXT, 
	samp_transport_cont VARCHAR(25), 
	samp_transport_dur TEXT, 
	samp_transport_temp TEXT, 
	samp_purpose TEXT, 
	sequencing_kit TEXT, 
	sequencing_location TEXT, 
	serovar_or_serotype TEXT, 
	"spikein_AMR" TEXT, 
	spikein_antibiotic TEXT, 
	spikein_growth_med TEXT, 
	spikein_metal TEXT, 
	spikein_org TEXT, 
	spikein_serovar TEXT, 
	spikein_strain TEXT, 
	study_design TEXT, 
	study_inc_dur TEXT, 
	study_inc_temp TEXT, 
	study_timecourse TEXT, 
	study_tmnt TEXT, 
	timepoint FLOAT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	seq_meth TEXT NOT NULL, 
	samp_size TEXT, 
	experimental_factor TEXT, 
	nucl_acid_ext TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	source_uvig VARCHAR(42) NOT NULL, 
	virus_enrich_appr VARCHAR(25) NOT NULL, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	compl_appr VARCHAR(15), 
	sort_tech VARCHAR(28), 
	single_cell_lysis_appr VARCHAR(11), 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT, 
	wga_amp_kit TEXT, 
	bin_param VARCHAR(15), 
	bin_software TEXT, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	vir_ident_software TEXT NOT NULL, 
	pred_genome_type VARCHAR(15) NOT NULL, 
	pred_genome_struc VARCHAR(13) NOT NULL, 
	detec_type TEXT NOT NULL, 
	otu_class_appr TEXT, 
	otu_seq_comp_appr TEXT, 
	otu_db TEXT, 
	host_pred_appr VARCHAR(24), 
	host_pred_est_acc TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, samp_collect_device, organism_count, spikein_count, samp_stor_temp, samp_stor_dur, pool_dna_extracts, samp_stor_loc, genetic_mod, perturbation, coll_site_geo_feat, food_product_type, "IFSAC_category", ferm_chem_add, ferm_chem_add_perc, ferm_headspace_oxy, ferm_medium, "ferm_pH", ferm_rel_humidity, ferm_temp, ferm_time, ferm_vessel, bacterial_density, cons_food_stor_dur, cons_food_stor_temp, cons_purch_date, cons_qty_purchased, cult_isol_date, cult_result, cult_result_org, cult_target, dietary_claim_use, enrichment_protocol, food_additive, food_allergen_label, food_contact_surf, food_contain_wrap, food_cooking_proc, food_dis_point, food_ingredient, food_name_status, food_origin, food_pack_capacity, food_pack_integrity, food_pack_medium, food_preserv_proc, food_prior_contact, food_prod, food_prod_synonym, food_product_qual, food_quality_date, food_source, food_trace_list, food_trav_mode, food_trav_vehic, food_treat_proc, "HACCP_term", intended_consumer, library_prep_kit, lot_number, microb_cult_med, microb_start, microb_start_count, microb_start_inoc, microb_start_prep, microb_start_source, "microb_start_taxID", nucl_acid_ext_kit, num_samp_collect, part_plant_animal, repository_name, sample_collec_method, samp_pooling, samp_rep_biol, samp_rep_tech, samp_source_mat_cat, samp_stor_device, samp_stor_media, samp_transport_cont, samp_transport_dur, samp_transport_temp, samp_purpose, sequencing_kit, sequencing_location, serovar_or_serotype, "spikein_AMR", spikein_antibiotic, spikein_growth_med, spikein_metal, spikein_org, spikein_serovar, spikein_strain, study_design, study_inc_dur, study_inc_temp, study_timecourse, study_tmnt, timepoint, misc_param, samp_name, project_name, seq_meth, samp_size, experimental_factor, nucl_acid_ext, samp_vol_we_dna_ext, samp_taxon_id, neg_cont_type, pos_cont_type, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, source_uvig, virus_enrich_appr, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, trnas, trna_ext_software, compl_score, compl_software, compl_appr, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, bin_param, bin_software, reassembly_bin, mag_cov_software, vir_ident_software, pred_genome_type, pred_genome_struc, detec_type, otu_class_appr, otu_seq_comp_appr, otu_db, host_pred_appr, host_pred_est_acc, associated_resource, sop)
);

CREATE TABLE host_associated (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	ances_data TEXT, 
	biol_stat VARCHAR(16), 
	genetic_mod TEXT, 
	host_common_name TEXT, 
	samp_capt_status VARCHAR(48), 
	samp_dis_stage VARCHAR(23), 
	host_taxid TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_life_stage TEXT, 
	host_sex VARCHAR(13), 
	chem_administration TEXT, 
	host_body_habitat TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_growth_cond TEXT, 
	host_substrate TEXT, 
	host_family_relation TEXT, 
	host_subspecf_genlin TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_dry_mass TEXT, 
	blood_press_diast TEXT, 
	blood_press_syst TEXT, 
	host_color TEXT, 
	host_shape TEXT, 
	gravidity TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, ances_data, biol_stat, genetic_mod, host_common_name, samp_capt_status, samp_dis_stage, host_taxid, host_subject_id, host_age, host_life_stage, host_sex, chem_administration, host_body_habitat, host_body_site, host_body_product, host_tot_mass, host_height, host_length, host_diet, host_last_meal, host_growth_cond, host_substrate, host_family_relation, host_subspecf_genlin, host_genotype, host_phenotype, host_body_temp, host_dry_mass, blood_press_diast, blood_press_syst, host_color, host_shape, gravidity, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext)
);

CREATE TABLE "host_associated_MIGS_bacteria" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	ances_data TEXT, 
	biol_stat VARCHAR(16), 
	genetic_mod TEXT, 
	host_common_name TEXT, 
	samp_capt_status VARCHAR(48), 
	samp_dis_stage VARCHAR(23), 
	host_taxid TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_life_stage TEXT, 
	host_sex VARCHAR(13), 
	chem_administration TEXT, 
	host_body_habitat TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_growth_cond TEXT, 
	host_substrate TEXT, 
	host_family_relation TEXT, 
	host_subspecf_genlin TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_dry_mass TEXT, 
	blood_press_diast TEXT, 
	blood_press_syst TEXT, 
	host_color TEXT, 
	host_shape TEXT, 
	gravidity TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER NOT NULL, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT NOT NULL, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	trophic_level VARCHAR(22), 
	encoded_traits TEXT, 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, ances_data, biol_stat, genetic_mod, host_common_name, samp_capt_status, samp_dis_stage, host_taxid, host_subject_id, host_age, host_life_stage, host_sex, chem_administration, host_body_habitat, host_body_site, host_body_product, host_tot_mass, host_height, host_length, host_diet, host_last_meal, host_growth_cond, host_substrate, host_family_relation, host_subspecf_genlin, host_genotype, host_phenotype, host_body_temp, host_dry_mass, blood_press_diast, blood_press_syst, host_color, host_shape, gravidity, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, trophic_level, encoded_traits, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "host_associated_MIGS_eukaryote" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	ances_data TEXT, 
	biol_stat VARCHAR(16), 
	genetic_mod TEXT, 
	host_common_name TEXT, 
	samp_capt_status VARCHAR(48), 
	samp_dis_stage VARCHAR(23), 
	host_taxid TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_life_stage TEXT, 
	host_sex VARCHAR(13), 
	chem_administration TEXT, 
	host_body_habitat TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_growth_cond TEXT, 
	host_substrate TEXT, 
	host_family_relation TEXT, 
	host_subspecf_genlin TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_dry_mass TEXT, 
	blood_press_diast TEXT, 
	blood_press_syst TEXT, 
	host_color TEXT, 
	host_shape TEXT, 
	gravidity TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	ploidy TEXT, 
	num_replicons INTEGER, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	trophic_level VARCHAR(22), 
	propagation TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, ances_data, biol_stat, genetic_mod, host_common_name, samp_capt_status, samp_dis_stage, host_taxid, host_subject_id, host_age, host_life_stage, host_sex, chem_administration, host_body_habitat, host_body_site, host_body_product, host_tot_mass, host_height, host_length, host_diet, host_last_meal, host_growth_cond, host_substrate, host_family_relation, host_subspecf_genlin, host_genotype, host_phenotype, host_body_temp, host_dry_mass, blood_press_diast, blood_press_syst, host_color, host_shape, gravidity, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, ploidy, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, trophic_level, propagation, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "host_associated_MIGS_org" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	ances_data TEXT, 
	biol_stat VARCHAR(16), 
	genetic_mod TEXT, 
	host_common_name TEXT, 
	samp_capt_status VARCHAR(48), 
	samp_dis_stage VARCHAR(23), 
	host_taxid TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_life_stage TEXT, 
	host_sex VARCHAR(13), 
	chem_administration TEXT, 
	host_body_habitat TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_growth_cond TEXT, 
	host_substrate TEXT, 
	host_family_relation TEXT, 
	host_subspecf_genlin TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_dry_mass TEXT, 
	blood_press_diast TEXT, 
	blood_press_syst TEXT, 
	host_color TEXT, 
	host_shape TEXT, 
	gravidity TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, ances_data, biol_stat, genetic_mod, host_common_name, samp_capt_status, samp_dis_stage, host_taxid, host_subject_id, host_age, host_life_stage, host_sex, chem_administration, host_body_habitat, host_body_site, host_body_product, host_tot_mass, host_height, host_length, host_diet, host_last_meal, host_growth_cond, host_substrate, host_family_relation, host_subspecf_genlin, host_genotype, host_phenotype, host_body_temp, host_dry_mass, blood_press_diast, blood_press_syst, host_color, host_shape, gravidity, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "host_associated_MIGS_plant" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	ances_data TEXT, 
	biol_stat VARCHAR(16), 
	genetic_mod TEXT, 
	host_common_name TEXT, 
	samp_capt_status VARCHAR(48), 
	samp_dis_stage VARCHAR(23), 
	host_taxid TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_life_stage TEXT, 
	host_sex VARCHAR(13), 
	chem_administration TEXT, 
	host_body_habitat TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_growth_cond TEXT, 
	host_substrate TEXT, 
	host_family_relation TEXT, 
	host_subspecf_genlin TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_dry_mass TEXT, 
	blood_press_diast TEXT, 
	blood_press_syst TEXT, 
	host_color TEXT, 
	host_shape TEXT, 
	gravidity TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, ances_data, biol_stat, genetic_mod, host_common_name, samp_capt_status, samp_dis_stage, host_taxid, host_subject_id, host_age, host_life_stage, host_sex, chem_administration, host_body_habitat, host_body_site, host_body_product, host_tot_mass, host_height, host_length, host_diet, host_last_meal, host_growth_cond, host_substrate, host_family_relation, host_subspecf_genlin, host_genotype, host_phenotype, host_body_temp, host_dry_mass, blood_press_diast, blood_press_syst, host_color, host_shape, gravidity, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, estimated_size, ref_biomaterial, source_mat_id, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "host_associated_MIGS_virus" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	ances_data TEXT, 
	biol_stat VARCHAR(16), 
	genetic_mod TEXT, 
	host_common_name TEXT, 
	samp_capt_status VARCHAR(48), 
	samp_dis_stage VARCHAR(23), 
	host_taxid TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_life_stage TEXT, 
	host_sex VARCHAR(13), 
	chem_administration TEXT, 
	host_body_habitat TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_growth_cond TEXT, 
	host_substrate TEXT, 
	host_family_relation TEXT, 
	host_subspecf_genlin TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_dry_mass TEXT, 
	blood_press_diast TEXT, 
	blood_press_syst TEXT, 
	host_color TEXT, 
	host_shape TEXT, 
	gravidity TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	virus_enrich_appr VARCHAR(25), 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, ances_data, biol_stat, genetic_mod, host_common_name, samp_capt_status, samp_dis_stage, host_taxid, host_subject_id, host_age, host_life_stage, host_sex, chem_administration, host_body_habitat, host_body_site, host_body_product, host_tot_mass, host_height, host_length, host_diet, host_last_meal, host_growth_cond, host_substrate, host_family_relation, host_subspecf_genlin, host_genotype, host_phenotype, host_body_temp, host_dry_mass, blood_press_diast, blood_press_syst, host_color, host_shape, gravidity, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "host_associated_MIMAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	ances_data TEXT, 
	biol_stat VARCHAR(16), 
	genetic_mod TEXT, 
	host_common_name TEXT, 
	samp_capt_status VARCHAR(48), 
	samp_dis_stage VARCHAR(23), 
	host_taxid TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_life_stage TEXT, 
	host_sex VARCHAR(13), 
	chem_administration TEXT, 
	host_body_habitat TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_growth_cond TEXT, 
	host_substrate TEXT, 
	host_family_relation TEXT, 
	host_subspecf_genlin TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_dry_mass TEXT, 
	blood_press_diast TEXT, 
	blood_press_syst TEXT, 
	host_color TEXT, 
	host_shape TEXT, 
	gravidity TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	bin_param VARCHAR(15) NOT NULL, 
	bin_software TEXT NOT NULL, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, ances_data, biol_stat, genetic_mod, host_common_name, samp_capt_status, samp_dis_stage, host_taxid, host_subject_id, host_age, host_life_stage, host_sex, chem_administration, host_body_habitat, host_body_site, host_body_product, host_tot_mass, host_height, host_length, host_diet, host_last_meal, host_growth_cond, host_substrate, host_family_relation, host_subspecf_genlin, host_genotype, host_phenotype, host_body_temp, host_dry_mass, blood_press_diast, blood_press_syst, host_color, host_shape, gravidity, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, bin_param, bin_software, reassembly_bin, mag_cov_software, associated_resource, sop)
);

CREATE TABLE "host_associated_MIMARKS_specimen" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	ances_data TEXT, 
	biol_stat VARCHAR(16), 
	genetic_mod TEXT, 
	host_common_name TEXT, 
	samp_capt_status VARCHAR(48), 
	samp_dis_stage VARCHAR(23), 
	host_taxid TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_life_stage TEXT, 
	host_sex VARCHAR(13), 
	chem_administration TEXT, 
	host_body_habitat TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_growth_cond TEXT, 
	host_substrate TEXT, 
	host_family_relation TEXT, 
	host_subspecf_genlin TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_dry_mass TEXT, 
	blood_press_diast TEXT, 
	blood_press_syst TEXT, 
	host_color TEXT, 
	host_shape TEXT, 
	gravidity TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	mid TEXT, 
	adapters TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	assembly_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, ances_data, biol_stat, genetic_mod, host_common_name, samp_capt_status, samp_dis_stage, host_taxid, host_subject_id, host_age, host_life_stage, host_sex, chem_administration, host_body_habitat, host_body_site, host_body_product, host_tot_mass, host_height, host_length, host_diet, host_last_meal, host_growth_cond, host_substrate, host_family_relation, host_subspecf_genlin, host_genotype, host_phenotype, host_body_temp, host_dry_mass, blood_press_diast, blood_press_syst, host_color, host_shape, gravidity, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, pcr_primers, mid, adapters, pcr_cond, seq_meth, seq_quality_check, chimera_check, assembly_software, associated_resource, sop)
);

CREATE TABLE "host_associated_MIMARKS_survey" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	ances_data TEXT, 
	biol_stat VARCHAR(16), 
	genetic_mod TEXT, 
	host_common_name TEXT, 
	samp_capt_status VARCHAR(48), 
	samp_dis_stage VARCHAR(23), 
	host_taxid TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_life_stage TEXT, 
	host_sex VARCHAR(13), 
	chem_administration TEXT, 
	host_body_habitat TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_growth_cond TEXT, 
	host_substrate TEXT, 
	host_family_relation TEXT, 
	host_subspecf_genlin TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_dry_mass TEXT, 
	blood_press_diast TEXT, 
	blood_press_syst TEXT, 
	host_color TEXT, 
	host_shape TEXT, 
	gravidity TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	source_mat_id TEXT, 
	biotic_relationship VARCHAR(11), 
	trophic_level VARCHAR(22), 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, ances_data, biol_stat, genetic_mod, host_common_name, samp_capt_status, samp_dis_stage, host_taxid, host_subject_id, host_age, host_life_stage, host_sex, chem_administration, host_body_habitat, host_body_site, host_body_product, host_tot_mass, host_height, host_length, host_diet, host_last_meal, host_growth_cond, host_substrate, host_family_relation, host_subspecf_genlin, host_genotype, host_phenotype, host_body_temp, host_dry_mass, blood_press_diast, blood_press_syst, host_color, host_shape, gravidity, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, source_mat_id, biotic_relationship, trophic_level, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, target_gene, target_subfragment, pcr_primers, pcr_cond, seq_meth, seq_quality_check, chimera_check, associated_resource, sop)
);

CREATE TABLE "host_associated_MIMS" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	ances_data TEXT, 
	biol_stat VARCHAR(16), 
	genetic_mod TEXT, 
	host_common_name TEXT, 
	samp_capt_status VARCHAR(48), 
	samp_dis_stage VARCHAR(23), 
	host_taxid TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_life_stage TEXT, 
	host_sex VARCHAR(13), 
	chem_administration TEXT, 
	host_body_habitat TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_growth_cond TEXT, 
	host_substrate TEXT, 
	host_family_relation TEXT, 
	host_subspecf_genlin TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_dry_mass TEXT, 
	blood_press_diast TEXT, 
	blood_press_syst TEXT, 
	host_color TEXT, 
	host_shape TEXT, 
	gravidity TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, ances_data, biol_stat, genetic_mod, host_common_name, samp_capt_status, samp_dis_stage, host_taxid, host_subject_id, host_age, host_life_stage, host_sex, chem_administration, host_body_habitat, host_body_site, host_body_product, host_tot_mass, host_height, host_length, host_diet, host_last_meal, host_growth_cond, host_substrate, host_family_relation, host_subspecf_genlin, host_genotype, host_phenotype, host_body_temp, host_dry_mass, blood_press_diast, blood_press_syst, host_color, host_shape, gravidity, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, associated_resource, sop)
);

CREATE TABLE "host_associated_MISAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	ances_data TEXT, 
	biol_stat VARCHAR(16), 
	genetic_mod TEXT, 
	host_common_name TEXT, 
	samp_capt_status VARCHAR(48), 
	samp_dis_stage VARCHAR(23), 
	host_taxid TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_life_stage TEXT, 
	host_sex VARCHAR(13), 
	chem_administration TEXT, 
	host_body_habitat TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_growth_cond TEXT, 
	host_substrate TEXT, 
	host_family_relation TEXT, 
	host_subspecf_genlin TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_dry_mass TEXT, 
	blood_press_diast TEXT, 
	blood_press_syst TEXT, 
	host_color TEXT, 
	host_shape TEXT, 
	gravidity TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	sort_tech VARCHAR(28) NOT NULL, 
	single_cell_lysis_appr VARCHAR(11) NOT NULL, 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT NOT NULL, 
	wga_amp_kit TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, ances_data, biol_stat, genetic_mod, host_common_name, samp_capt_status, samp_dis_stage, host_taxid, host_subject_id, host_age, host_life_stage, host_sex, chem_administration, host_body_habitat, host_body_site, host_body_product, host_tot_mass, host_height, host_length, host_diet, host_last_meal, host_growth_cond, host_substrate, host_family_relation, host_subspecf_genlin, host_genotype, host_phenotype, host_body_temp, host_dry_mass, blood_press_diast, blood_press_syst, host_color, host_shape, gravidity, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, associated_resource, sop)
);

CREATE TABLE "host_associated_MIUVIG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	ances_data TEXT, 
	biol_stat VARCHAR(16), 
	genetic_mod TEXT, 
	host_common_name TEXT, 
	samp_capt_status VARCHAR(48), 
	samp_dis_stage VARCHAR(23), 
	host_taxid TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_life_stage TEXT, 
	host_sex VARCHAR(13), 
	chem_administration TEXT, 
	host_body_habitat TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_growth_cond TEXT, 
	host_substrate TEXT, 
	host_family_relation TEXT, 
	host_subspecf_genlin TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_dry_mass TEXT, 
	blood_press_diast TEXT, 
	blood_press_syst TEXT, 
	host_color TEXT, 
	host_shape TEXT, 
	gravidity TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	source_uvig VARCHAR(42) NOT NULL, 
	virus_enrich_appr VARCHAR(25) NOT NULL, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	compl_appr VARCHAR(15), 
	sort_tech VARCHAR(28), 
	single_cell_lysis_appr VARCHAR(11), 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT, 
	wga_amp_kit TEXT, 
	bin_param VARCHAR(15), 
	bin_software TEXT, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	vir_ident_software TEXT NOT NULL, 
	pred_genome_type VARCHAR(15) NOT NULL, 
	pred_genome_struc VARCHAR(13) NOT NULL, 
	detec_type TEXT NOT NULL, 
	otu_class_appr TEXT, 
	otu_seq_comp_appr TEXT, 
	otu_db TEXT, 
	host_pred_appr VARCHAR(24), 
	host_pred_est_acc TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, ances_data, biol_stat, genetic_mod, host_common_name, samp_capt_status, samp_dis_stage, host_taxid, host_subject_id, host_age, host_life_stage, host_sex, chem_administration, host_body_habitat, host_body_site, host_body_product, host_tot_mass, host_height, host_length, host_diet, host_last_meal, host_growth_cond, host_substrate, host_family_relation, host_subspecf_genlin, host_genotype, host_phenotype, host_body_temp, host_dry_mass, blood_press_diast, blood_press_syst, host_color, host_shape, gravidity, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, source_uvig, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, trnas, trna_ext_software, compl_score, compl_software, compl_appr, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, bin_param, bin_software, reassembly_bin, mag_cov_software, vir_ident_software, pred_genome_type, pred_genome_struc, detec_type, otu_class_appr, otu_seq_comp_appr, otu_db, host_pred_appr, host_pred_est_acc, associated_resource, sop)
);

CREATE TABLE human_associated (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	smoker TEXT, 
	host_hiv_stat TEXT, 
	drug_usage VARCHAR(5), 
	host_body_mass_index TEXT, 
	diet_last_six_month TEXT, 
	weight_loss_3_month TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	pet_farm_animal TEXT, 
	travel_out_six_month TEXT, 
	twin_sibling TEXT, 
	medic_hist_perform TEXT, 
	study_complt_stat VARCHAR(17), 
	pulmonary_disord TEXT, 
	nose_throat_disord TEXT, 
	blood_blood_disord TEXT, 
	host_pulse TEXT, 
	gestation_state TEXT, 
	maternal_health_stat TEXT, 
	foetal_health_stat TEXT, 
	amniotic_fluid_color TEXT, 
	kidney_disord TEXT, 
	urogenit_tract_disor TEXT, 
	urine_collect_meth TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, smoker, host_hiv_stat, drug_usage, host_body_mass_index, diet_last_six_month, weight_loss_3_month, ethnicity, host_occupation, pet_farm_animal, travel_out_six_month, twin_sibling, medic_hist_perform, study_complt_stat, pulmonary_disord, nose_throat_disord, blood_blood_disord, host_pulse, gestation_state, maternal_health_stat, foetal_health_stat, amniotic_fluid_color, kidney_disord, urogenit_tract_disor, urine_collect_meth, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext)
);

CREATE TABLE "human_associated_MIGS_bacteria" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	smoker TEXT, 
	host_hiv_stat TEXT, 
	drug_usage VARCHAR(5), 
	host_body_mass_index TEXT, 
	diet_last_six_month TEXT, 
	weight_loss_3_month TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	pet_farm_animal TEXT, 
	travel_out_six_month TEXT, 
	twin_sibling TEXT, 
	medic_hist_perform TEXT, 
	study_complt_stat VARCHAR(17), 
	pulmonary_disord TEXT, 
	nose_throat_disord TEXT, 
	blood_blood_disord TEXT, 
	host_pulse TEXT, 
	gestation_state TEXT, 
	maternal_health_stat TEXT, 
	foetal_health_stat TEXT, 
	amniotic_fluid_color TEXT, 
	kidney_disord TEXT, 
	urogenit_tract_disor TEXT, 
	urine_collect_meth TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER NOT NULL, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT NOT NULL, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	trophic_level VARCHAR(22), 
	encoded_traits TEXT, 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, smoker, host_hiv_stat, drug_usage, host_body_mass_index, diet_last_six_month, weight_loss_3_month, ethnicity, host_occupation, pet_farm_animal, travel_out_six_month, twin_sibling, medic_hist_perform, study_complt_stat, pulmonary_disord, nose_throat_disord, blood_blood_disord, host_pulse, gestation_state, maternal_health_stat, foetal_health_stat, amniotic_fluid_color, kidney_disord, urogenit_tract_disor, urine_collect_meth, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, trophic_level, encoded_traits, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_associated_MIGS_eukaryote" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	smoker TEXT, 
	host_hiv_stat TEXT, 
	drug_usage VARCHAR(5), 
	host_body_mass_index TEXT, 
	diet_last_six_month TEXT, 
	weight_loss_3_month TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	pet_farm_animal TEXT, 
	travel_out_six_month TEXT, 
	twin_sibling TEXT, 
	medic_hist_perform TEXT, 
	study_complt_stat VARCHAR(17), 
	pulmonary_disord TEXT, 
	nose_throat_disord TEXT, 
	blood_blood_disord TEXT, 
	host_pulse TEXT, 
	gestation_state TEXT, 
	maternal_health_stat TEXT, 
	foetal_health_stat TEXT, 
	amniotic_fluid_color TEXT, 
	kidney_disord TEXT, 
	urogenit_tract_disor TEXT, 
	urine_collect_meth TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	ploidy TEXT, 
	num_replicons INTEGER, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	trophic_level VARCHAR(22), 
	propagation TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, smoker, host_hiv_stat, drug_usage, host_body_mass_index, diet_last_six_month, weight_loss_3_month, ethnicity, host_occupation, pet_farm_animal, travel_out_six_month, twin_sibling, medic_hist_perform, study_complt_stat, pulmonary_disord, nose_throat_disord, blood_blood_disord, host_pulse, gestation_state, maternal_health_stat, foetal_health_stat, amniotic_fluid_color, kidney_disord, urogenit_tract_disor, urine_collect_meth, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, ploidy, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, trophic_level, propagation, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_associated_MIGS_org" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	smoker TEXT, 
	host_hiv_stat TEXT, 
	drug_usage VARCHAR(5), 
	host_body_mass_index TEXT, 
	diet_last_six_month TEXT, 
	weight_loss_3_month TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	pet_farm_animal TEXT, 
	travel_out_six_month TEXT, 
	twin_sibling TEXT, 
	medic_hist_perform TEXT, 
	study_complt_stat VARCHAR(17), 
	pulmonary_disord TEXT, 
	nose_throat_disord TEXT, 
	blood_blood_disord TEXT, 
	host_pulse TEXT, 
	gestation_state TEXT, 
	maternal_health_stat TEXT, 
	foetal_health_stat TEXT, 
	amniotic_fluid_color TEXT, 
	kidney_disord TEXT, 
	urogenit_tract_disor TEXT, 
	urine_collect_meth TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, smoker, host_hiv_stat, drug_usage, host_body_mass_index, diet_last_six_month, weight_loss_3_month, ethnicity, host_occupation, pet_farm_animal, travel_out_six_month, twin_sibling, medic_hist_perform, study_complt_stat, pulmonary_disord, nose_throat_disord, blood_blood_disord, host_pulse, gestation_state, maternal_health_stat, foetal_health_stat, amniotic_fluid_color, kidney_disord, urogenit_tract_disor, urine_collect_meth, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_associated_MIGS_plant" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	smoker TEXT, 
	host_hiv_stat TEXT, 
	drug_usage VARCHAR(5), 
	host_body_mass_index TEXT, 
	diet_last_six_month TEXT, 
	weight_loss_3_month TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	pet_farm_animal TEXT, 
	travel_out_six_month TEXT, 
	twin_sibling TEXT, 
	medic_hist_perform TEXT, 
	study_complt_stat VARCHAR(17), 
	pulmonary_disord TEXT, 
	nose_throat_disord TEXT, 
	blood_blood_disord TEXT, 
	host_pulse TEXT, 
	gestation_state TEXT, 
	maternal_health_stat TEXT, 
	foetal_health_stat TEXT, 
	amniotic_fluid_color TEXT, 
	kidney_disord TEXT, 
	urogenit_tract_disor TEXT, 
	urine_collect_meth TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, smoker, host_hiv_stat, drug_usage, host_body_mass_index, diet_last_six_month, weight_loss_3_month, ethnicity, host_occupation, pet_farm_animal, travel_out_six_month, twin_sibling, medic_hist_perform, study_complt_stat, pulmonary_disord, nose_throat_disord, blood_blood_disord, host_pulse, gestation_state, maternal_health_stat, foetal_health_stat, amniotic_fluid_color, kidney_disord, urogenit_tract_disor, urine_collect_meth, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, estimated_size, ref_biomaterial, source_mat_id, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_associated_MIGS_virus" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	smoker TEXT, 
	host_hiv_stat TEXT, 
	drug_usage VARCHAR(5), 
	host_body_mass_index TEXT, 
	diet_last_six_month TEXT, 
	weight_loss_3_month TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	pet_farm_animal TEXT, 
	travel_out_six_month TEXT, 
	twin_sibling TEXT, 
	medic_hist_perform TEXT, 
	study_complt_stat VARCHAR(17), 
	pulmonary_disord TEXT, 
	nose_throat_disord TEXT, 
	blood_blood_disord TEXT, 
	host_pulse TEXT, 
	gestation_state TEXT, 
	maternal_health_stat TEXT, 
	foetal_health_stat TEXT, 
	amniotic_fluid_color TEXT, 
	kidney_disord TEXT, 
	urogenit_tract_disor TEXT, 
	urine_collect_meth TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	virus_enrich_appr VARCHAR(25), 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, smoker, host_hiv_stat, drug_usage, host_body_mass_index, diet_last_six_month, weight_loss_3_month, ethnicity, host_occupation, pet_farm_animal, travel_out_six_month, twin_sibling, medic_hist_perform, study_complt_stat, pulmonary_disord, nose_throat_disord, blood_blood_disord, host_pulse, gestation_state, maternal_health_stat, foetal_health_stat, amniotic_fluid_color, kidney_disord, urogenit_tract_disor, urine_collect_meth, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_associated_MIMAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	smoker TEXT, 
	host_hiv_stat TEXT, 
	drug_usage VARCHAR(5), 
	host_body_mass_index TEXT, 
	diet_last_six_month TEXT, 
	weight_loss_3_month TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	pet_farm_animal TEXT, 
	travel_out_six_month TEXT, 
	twin_sibling TEXT, 
	medic_hist_perform TEXT, 
	study_complt_stat VARCHAR(17), 
	pulmonary_disord TEXT, 
	nose_throat_disord TEXT, 
	blood_blood_disord TEXT, 
	host_pulse TEXT, 
	gestation_state TEXT, 
	maternal_health_stat TEXT, 
	foetal_health_stat TEXT, 
	amniotic_fluid_color TEXT, 
	kidney_disord TEXT, 
	urogenit_tract_disor TEXT, 
	urine_collect_meth TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	bin_param VARCHAR(15) NOT NULL, 
	bin_software TEXT NOT NULL, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, smoker, host_hiv_stat, drug_usage, host_body_mass_index, diet_last_six_month, weight_loss_3_month, ethnicity, host_occupation, pet_farm_animal, travel_out_six_month, twin_sibling, medic_hist_perform, study_complt_stat, pulmonary_disord, nose_throat_disord, blood_blood_disord, host_pulse, gestation_state, maternal_health_stat, foetal_health_stat, amniotic_fluid_color, kidney_disord, urogenit_tract_disor, urine_collect_meth, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, bin_param, bin_software, reassembly_bin, mag_cov_software, associated_resource, sop)
);

CREATE TABLE "human_associated_MIMARKS_specimen" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	smoker TEXT, 
	host_hiv_stat TEXT, 
	drug_usage VARCHAR(5), 
	host_body_mass_index TEXT, 
	diet_last_six_month TEXT, 
	weight_loss_3_month TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	pet_farm_animal TEXT, 
	travel_out_six_month TEXT, 
	twin_sibling TEXT, 
	medic_hist_perform TEXT, 
	study_complt_stat VARCHAR(17), 
	pulmonary_disord TEXT, 
	nose_throat_disord TEXT, 
	blood_blood_disord TEXT, 
	host_pulse TEXT, 
	gestation_state TEXT, 
	maternal_health_stat TEXT, 
	foetal_health_stat TEXT, 
	amniotic_fluid_color TEXT, 
	kidney_disord TEXT, 
	urogenit_tract_disor TEXT, 
	urine_collect_meth TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	mid TEXT, 
	adapters TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	assembly_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, smoker, host_hiv_stat, drug_usage, host_body_mass_index, diet_last_six_month, weight_loss_3_month, ethnicity, host_occupation, pet_farm_animal, travel_out_six_month, twin_sibling, medic_hist_perform, study_complt_stat, pulmonary_disord, nose_throat_disord, blood_blood_disord, host_pulse, gestation_state, maternal_health_stat, foetal_health_stat, amniotic_fluid_color, kidney_disord, urogenit_tract_disor, urine_collect_meth, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, pcr_primers, mid, adapters, pcr_cond, seq_meth, seq_quality_check, chimera_check, assembly_software, associated_resource, sop)
);

CREATE TABLE "human_associated_MIMARKS_survey" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	smoker TEXT, 
	host_hiv_stat TEXT, 
	drug_usage VARCHAR(5), 
	host_body_mass_index TEXT, 
	diet_last_six_month TEXT, 
	weight_loss_3_month TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	pet_farm_animal TEXT, 
	travel_out_six_month TEXT, 
	twin_sibling TEXT, 
	medic_hist_perform TEXT, 
	study_complt_stat VARCHAR(17), 
	pulmonary_disord TEXT, 
	nose_throat_disord TEXT, 
	blood_blood_disord TEXT, 
	host_pulse TEXT, 
	gestation_state TEXT, 
	maternal_health_stat TEXT, 
	foetal_health_stat TEXT, 
	amniotic_fluid_color TEXT, 
	kidney_disord TEXT, 
	urogenit_tract_disor TEXT, 
	urine_collect_meth TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	source_mat_id TEXT, 
	biotic_relationship VARCHAR(11), 
	trophic_level VARCHAR(22), 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, smoker, host_hiv_stat, drug_usage, host_body_mass_index, diet_last_six_month, weight_loss_3_month, ethnicity, host_occupation, pet_farm_animal, travel_out_six_month, twin_sibling, medic_hist_perform, study_complt_stat, pulmonary_disord, nose_throat_disord, blood_blood_disord, host_pulse, gestation_state, maternal_health_stat, foetal_health_stat, amniotic_fluid_color, kidney_disord, urogenit_tract_disor, urine_collect_meth, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, source_mat_id, biotic_relationship, trophic_level, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, target_gene, target_subfragment, pcr_primers, pcr_cond, seq_meth, seq_quality_check, chimera_check, associated_resource, sop)
);

CREATE TABLE "human_associated_MIMS" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	smoker TEXT, 
	host_hiv_stat TEXT, 
	drug_usage VARCHAR(5), 
	host_body_mass_index TEXT, 
	diet_last_six_month TEXT, 
	weight_loss_3_month TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	pet_farm_animal TEXT, 
	travel_out_six_month TEXT, 
	twin_sibling TEXT, 
	medic_hist_perform TEXT, 
	study_complt_stat VARCHAR(17), 
	pulmonary_disord TEXT, 
	nose_throat_disord TEXT, 
	blood_blood_disord TEXT, 
	host_pulse TEXT, 
	gestation_state TEXT, 
	maternal_health_stat TEXT, 
	foetal_health_stat TEXT, 
	amniotic_fluid_color TEXT, 
	kidney_disord TEXT, 
	urogenit_tract_disor TEXT, 
	urine_collect_meth TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, smoker, host_hiv_stat, drug_usage, host_body_mass_index, diet_last_six_month, weight_loss_3_month, ethnicity, host_occupation, pet_farm_animal, travel_out_six_month, twin_sibling, medic_hist_perform, study_complt_stat, pulmonary_disord, nose_throat_disord, blood_blood_disord, host_pulse, gestation_state, maternal_health_stat, foetal_health_stat, amniotic_fluid_color, kidney_disord, urogenit_tract_disor, urine_collect_meth, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, associated_resource, sop)
);

CREATE TABLE "human_associated_MISAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	smoker TEXT, 
	host_hiv_stat TEXT, 
	drug_usage VARCHAR(5), 
	host_body_mass_index TEXT, 
	diet_last_six_month TEXT, 
	weight_loss_3_month TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	pet_farm_animal TEXT, 
	travel_out_six_month TEXT, 
	twin_sibling TEXT, 
	medic_hist_perform TEXT, 
	study_complt_stat VARCHAR(17), 
	pulmonary_disord TEXT, 
	nose_throat_disord TEXT, 
	blood_blood_disord TEXT, 
	host_pulse TEXT, 
	gestation_state TEXT, 
	maternal_health_stat TEXT, 
	foetal_health_stat TEXT, 
	amniotic_fluid_color TEXT, 
	kidney_disord TEXT, 
	urogenit_tract_disor TEXT, 
	urine_collect_meth TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	sort_tech VARCHAR(28) NOT NULL, 
	single_cell_lysis_appr VARCHAR(11) NOT NULL, 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT NOT NULL, 
	wga_amp_kit TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, smoker, host_hiv_stat, drug_usage, host_body_mass_index, diet_last_six_month, weight_loss_3_month, ethnicity, host_occupation, pet_farm_animal, travel_out_six_month, twin_sibling, medic_hist_perform, study_complt_stat, pulmonary_disord, nose_throat_disord, blood_blood_disord, host_pulse, gestation_state, maternal_health_stat, foetal_health_stat, amniotic_fluid_color, kidney_disord, urogenit_tract_disor, urine_collect_meth, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, associated_resource, sop)
);

CREATE TABLE "human_associated_MIUVIG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	smoker TEXT, 
	host_hiv_stat TEXT, 
	drug_usage VARCHAR(5), 
	host_body_mass_index TEXT, 
	diet_last_six_month TEXT, 
	weight_loss_3_month TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	pet_farm_animal TEXT, 
	travel_out_six_month TEXT, 
	twin_sibling TEXT, 
	medic_hist_perform TEXT, 
	study_complt_stat VARCHAR(17), 
	pulmonary_disord TEXT, 
	nose_throat_disord TEXT, 
	blood_blood_disord TEXT, 
	host_pulse TEXT, 
	gestation_state TEXT, 
	maternal_health_stat TEXT, 
	foetal_health_stat TEXT, 
	amniotic_fluid_color TEXT, 
	kidney_disord TEXT, 
	urogenit_tract_disor TEXT, 
	urine_collect_meth TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	source_uvig VARCHAR(42) NOT NULL, 
	virus_enrich_appr VARCHAR(25) NOT NULL, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	compl_appr VARCHAR(15), 
	sort_tech VARCHAR(28), 
	single_cell_lysis_appr VARCHAR(11), 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT, 
	wga_amp_kit TEXT, 
	bin_param VARCHAR(15), 
	bin_software TEXT, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	vir_ident_software TEXT NOT NULL, 
	pred_genome_type VARCHAR(15) NOT NULL, 
	pred_genome_struc VARCHAR(13) NOT NULL, 
	detec_type TEXT NOT NULL, 
	otu_class_appr TEXT, 
	otu_seq_comp_appr TEXT, 
	otu_db TEXT, 
	host_pred_appr VARCHAR(24), 
	host_pred_est_acc TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, smoker, host_hiv_stat, drug_usage, host_body_mass_index, diet_last_six_month, weight_loss_3_month, ethnicity, host_occupation, pet_farm_animal, travel_out_six_month, twin_sibling, medic_hist_perform, study_complt_stat, pulmonary_disord, nose_throat_disord, blood_blood_disord, host_pulse, gestation_state, maternal_health_stat, foetal_health_stat, amniotic_fluid_color, kidney_disord, urogenit_tract_disor, urine_collect_meth, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, source_uvig, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, trnas, trna_ext_software, compl_score, compl_software, compl_appr, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, bin_param, bin_software, reassembly_bin, mag_cov_software, vir_ident_software, pred_genome_type, pred_genome_struc, detec_type, otu_class_appr, otu_seq_comp_appr, otu_db, host_pred_appr, host_pred_est_acc, associated_resource, sop)
);

CREATE TABLE human_gut (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	gastrointest_disord TEXT, 
	liver_disord TEXT, 
	special_diet VARCHAR(22), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, gastrointest_disord, liver_disord, special_diet, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext)
);

CREATE TABLE "human_gut_MIGS_bacteria" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	gastrointest_disord TEXT, 
	liver_disord TEXT, 
	special_diet VARCHAR(22), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER NOT NULL, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT NOT NULL, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	trophic_level VARCHAR(22), 
	encoded_traits TEXT, 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, gastrointest_disord, liver_disord, special_diet, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, trophic_level, encoded_traits, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_gut_MIGS_eukaryote" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	gastrointest_disord TEXT, 
	liver_disord TEXT, 
	special_diet VARCHAR(22), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	ploidy TEXT, 
	num_replicons INTEGER, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	trophic_level VARCHAR(22), 
	propagation TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, gastrointest_disord, liver_disord, special_diet, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, ploidy, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, trophic_level, propagation, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_gut_MIGS_org" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	gastrointest_disord TEXT, 
	liver_disord TEXT, 
	special_diet VARCHAR(22), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, gastrointest_disord, liver_disord, special_diet, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_gut_MIGS_plant" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	gastrointest_disord TEXT, 
	liver_disord TEXT, 
	special_diet VARCHAR(22), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, gastrointest_disord, liver_disord, special_diet, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, estimated_size, ref_biomaterial, source_mat_id, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_gut_MIGS_virus" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	gastrointest_disord TEXT, 
	liver_disord TEXT, 
	special_diet VARCHAR(22), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	virus_enrich_appr VARCHAR(25), 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, gastrointest_disord, liver_disord, special_diet, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_gut_MIMAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	gastrointest_disord TEXT, 
	liver_disord TEXT, 
	special_diet VARCHAR(22), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	bin_param VARCHAR(15) NOT NULL, 
	bin_software TEXT NOT NULL, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, gastrointest_disord, liver_disord, special_diet, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, bin_param, bin_software, reassembly_bin, mag_cov_software, associated_resource, sop)
);

CREATE TABLE "human_gut_MIMARKS_specimen" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	gastrointest_disord TEXT, 
	liver_disord TEXT, 
	special_diet VARCHAR(22), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	mid TEXT, 
	adapters TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	assembly_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, gastrointest_disord, liver_disord, special_diet, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, pcr_primers, mid, adapters, pcr_cond, seq_meth, seq_quality_check, chimera_check, assembly_software, associated_resource, sop)
);

CREATE TABLE "human_gut_MIMARKS_survey" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	gastrointest_disord TEXT, 
	liver_disord TEXT, 
	special_diet VARCHAR(22), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	source_mat_id TEXT, 
	biotic_relationship VARCHAR(11), 
	trophic_level VARCHAR(22), 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, gastrointest_disord, liver_disord, special_diet, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, source_mat_id, biotic_relationship, trophic_level, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, target_gene, target_subfragment, pcr_primers, pcr_cond, seq_meth, seq_quality_check, chimera_check, associated_resource, sop)
);

CREATE TABLE "human_gut_MIMS" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	gastrointest_disord TEXT, 
	liver_disord TEXT, 
	special_diet VARCHAR(22), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, gastrointest_disord, liver_disord, special_diet, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, associated_resource, sop)
);

CREATE TABLE "human_gut_MISAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	gastrointest_disord TEXT, 
	liver_disord TEXT, 
	special_diet VARCHAR(22), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	sort_tech VARCHAR(28) NOT NULL, 
	single_cell_lysis_appr VARCHAR(11) NOT NULL, 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT NOT NULL, 
	wga_amp_kit TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, gastrointest_disord, liver_disord, special_diet, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, associated_resource, sop)
);

CREATE TABLE "human_gut_MIUVIG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	gastrointest_disord TEXT, 
	liver_disord TEXT, 
	special_diet VARCHAR(22), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	source_uvig VARCHAR(42) NOT NULL, 
	virus_enrich_appr VARCHAR(25) NOT NULL, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	compl_appr VARCHAR(15), 
	sort_tech VARCHAR(28), 
	single_cell_lysis_appr VARCHAR(11), 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT, 
	wga_amp_kit TEXT, 
	bin_param VARCHAR(15), 
	bin_software TEXT, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	vir_ident_software TEXT NOT NULL, 
	pred_genome_type VARCHAR(15) NOT NULL, 
	pred_genome_struc VARCHAR(13) NOT NULL, 
	detec_type TEXT NOT NULL, 
	otu_class_appr TEXT, 
	otu_seq_comp_appr TEXT, 
	otu_db TEXT, 
	host_pred_appr VARCHAR(24), 
	host_pred_est_acc TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, gastrointest_disord, liver_disord, special_diet, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, source_uvig, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, trnas, trna_ext_software, compl_score, compl_software, compl_appr, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, bin_param, bin_software, reassembly_bin, mag_cov_software, vir_ident_software, pred_genome_type, pred_genome_struc, detec_type, otu_class_appr, otu_seq_comp_appr, otu_db, host_pred_appr, host_pred_est_acc, associated_resource, sop)
);

CREATE TABLE human_oral (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	nose_throat_disord TEXT, 
	time_last_toothbrush TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, nose_throat_disord, time_last_toothbrush, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext)
);

CREATE TABLE "human_oral_MIGS_bacteria" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	nose_throat_disord TEXT, 
	time_last_toothbrush TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER NOT NULL, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT NOT NULL, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	trophic_level VARCHAR(22), 
	encoded_traits TEXT, 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, nose_throat_disord, time_last_toothbrush, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, trophic_level, encoded_traits, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_oral_MIGS_eukaryote" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	nose_throat_disord TEXT, 
	time_last_toothbrush TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	ploidy TEXT, 
	num_replicons INTEGER, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	trophic_level VARCHAR(22), 
	propagation TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, nose_throat_disord, time_last_toothbrush, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, ploidy, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, trophic_level, propagation, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_oral_MIGS_org" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	nose_throat_disord TEXT, 
	time_last_toothbrush TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, nose_throat_disord, time_last_toothbrush, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_oral_MIGS_plant" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	nose_throat_disord TEXT, 
	time_last_toothbrush TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, nose_throat_disord, time_last_toothbrush, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, estimated_size, ref_biomaterial, source_mat_id, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_oral_MIGS_virus" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	nose_throat_disord TEXT, 
	time_last_toothbrush TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	virus_enrich_appr VARCHAR(25), 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, nose_throat_disord, time_last_toothbrush, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_oral_MIMAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	nose_throat_disord TEXT, 
	time_last_toothbrush TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	bin_param VARCHAR(15) NOT NULL, 
	bin_software TEXT NOT NULL, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, nose_throat_disord, time_last_toothbrush, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, bin_param, bin_software, reassembly_bin, mag_cov_software, associated_resource, sop)
);

CREATE TABLE "human_oral_MIMARKS_specimen" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	nose_throat_disord TEXT, 
	time_last_toothbrush TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	mid TEXT, 
	adapters TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	assembly_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, nose_throat_disord, time_last_toothbrush, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, pcr_primers, mid, adapters, pcr_cond, seq_meth, seq_quality_check, chimera_check, assembly_software, associated_resource, sop)
);

CREATE TABLE "human_oral_MIMARKS_survey" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	nose_throat_disord TEXT, 
	time_last_toothbrush TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	source_mat_id TEXT, 
	biotic_relationship VARCHAR(11), 
	trophic_level VARCHAR(22), 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, nose_throat_disord, time_last_toothbrush, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, source_mat_id, biotic_relationship, trophic_level, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, target_gene, target_subfragment, pcr_primers, pcr_cond, seq_meth, seq_quality_check, chimera_check, associated_resource, sop)
);

CREATE TABLE "human_oral_MIMS" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	nose_throat_disord TEXT, 
	time_last_toothbrush TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, nose_throat_disord, time_last_toothbrush, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, associated_resource, sop)
);

CREATE TABLE "human_oral_MISAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	nose_throat_disord TEXT, 
	time_last_toothbrush TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	sort_tech VARCHAR(28) NOT NULL, 
	single_cell_lysis_appr VARCHAR(11) NOT NULL, 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT NOT NULL, 
	wga_amp_kit TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, nose_throat_disord, time_last_toothbrush, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, associated_resource, sop)
);

CREATE TABLE "human_oral_MIUVIG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	nose_throat_disord TEXT, 
	time_last_toothbrush TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	samp_store_loc TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	source_uvig VARCHAR(42) NOT NULL, 
	virus_enrich_appr VARCHAR(25) NOT NULL, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	compl_appr VARCHAR(15), 
	sort_tech VARCHAR(28), 
	single_cell_lysis_appr VARCHAR(11), 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT, 
	wga_amp_kit TEXT, 
	bin_param VARCHAR(15), 
	bin_software TEXT, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	vir_ident_software TEXT NOT NULL, 
	pred_genome_type VARCHAR(15) NOT NULL, 
	pred_genome_struc VARCHAR(13) NOT NULL, 
	detec_type TEXT NOT NULL, 
	otu_class_appr TEXT, 
	otu_seq_comp_appr TEXT, 
	otu_db TEXT, 
	host_pred_appr VARCHAR(24), 
	host_pred_est_acc TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, nose_throat_disord, time_last_toothbrush, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, host_symbiont, samp_store_loc, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, source_uvig, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, trnas, trna_ext_software, compl_score, compl_software, compl_appr, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, bin_param, bin_software, reassembly_bin, mag_cov_software, vir_ident_software, pred_genome_type, pred_genome_struc, detec_type, otu_class_appr, otu_seq_comp_appr, otu_db, host_pred_appr, host_pred_est_acc, associated_resource, sop)
);

CREATE TABLE human_skin (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	dermatology_disord TEXT, 
	time_since_last_wash TEXT, 
	dominant_hand VARCHAR(12), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, dermatology_disord, time_since_last_wash, dominant_hand, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext)
);

CREATE TABLE "human_skin_MIGS_bacteria" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	dermatology_disord TEXT, 
	time_since_last_wash TEXT, 
	dominant_hand VARCHAR(12), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER NOT NULL, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT NOT NULL, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	trophic_level VARCHAR(22), 
	encoded_traits TEXT, 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, dermatology_disord, time_since_last_wash, dominant_hand, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, trophic_level, encoded_traits, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_skin_MIGS_eukaryote" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	dermatology_disord TEXT, 
	time_since_last_wash TEXT, 
	dominant_hand VARCHAR(12), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	ploidy TEXT, 
	num_replicons INTEGER, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	trophic_level VARCHAR(22), 
	propagation TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, dermatology_disord, time_since_last_wash, dominant_hand, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, ploidy, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, trophic_level, propagation, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_skin_MIGS_org" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	dermatology_disord TEXT, 
	time_since_last_wash TEXT, 
	dominant_hand VARCHAR(12), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, dermatology_disord, time_since_last_wash, dominant_hand, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_skin_MIGS_plant" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	dermatology_disord TEXT, 
	time_since_last_wash TEXT, 
	dominant_hand VARCHAR(12), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, dermatology_disord, time_since_last_wash, dominant_hand, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, estimated_size, ref_biomaterial, source_mat_id, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_skin_MIGS_virus" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	dermatology_disord TEXT, 
	time_since_last_wash TEXT, 
	dominant_hand VARCHAR(12), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	virus_enrich_appr VARCHAR(25), 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, dermatology_disord, time_since_last_wash, dominant_hand, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_skin_MIMAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	dermatology_disord TEXT, 
	time_since_last_wash TEXT, 
	dominant_hand VARCHAR(12), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	bin_param VARCHAR(15) NOT NULL, 
	bin_software TEXT NOT NULL, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, dermatology_disord, time_since_last_wash, dominant_hand, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, bin_param, bin_software, reassembly_bin, mag_cov_software, associated_resource, sop)
);

CREATE TABLE "human_skin_MIMARKS_specimen" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	dermatology_disord TEXT, 
	time_since_last_wash TEXT, 
	dominant_hand VARCHAR(12), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	mid TEXT, 
	adapters TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	assembly_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, dermatology_disord, time_since_last_wash, dominant_hand, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, pcr_primers, mid, adapters, pcr_cond, seq_meth, seq_quality_check, chimera_check, assembly_software, associated_resource, sop)
);

CREATE TABLE "human_skin_MIMARKS_survey" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	dermatology_disord TEXT, 
	time_since_last_wash TEXT, 
	dominant_hand VARCHAR(12), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	source_mat_id TEXT, 
	biotic_relationship VARCHAR(11), 
	trophic_level VARCHAR(22), 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, dermatology_disord, time_since_last_wash, dominant_hand, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, source_mat_id, biotic_relationship, trophic_level, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, target_gene, target_subfragment, pcr_primers, pcr_cond, seq_meth, seq_quality_check, chimera_check, associated_resource, sop)
);

CREATE TABLE "human_skin_MIMS" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	dermatology_disord TEXT, 
	time_since_last_wash TEXT, 
	dominant_hand VARCHAR(12), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, dermatology_disord, time_since_last_wash, dominant_hand, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, associated_resource, sop)
);

CREATE TABLE "human_skin_MISAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	dermatology_disord TEXT, 
	time_since_last_wash TEXT, 
	dominant_hand VARCHAR(12), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	sort_tech VARCHAR(28) NOT NULL, 
	single_cell_lysis_appr VARCHAR(11) NOT NULL, 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT NOT NULL, 
	wga_amp_kit TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, dermatology_disord, time_since_last_wash, dominant_hand, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, associated_resource, sop)
);

CREATE TABLE "human_skin_MIUVIG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	dermatology_disord TEXT, 
	time_since_last_wash TEXT, 
	dominant_hand VARCHAR(12), 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	source_uvig VARCHAR(42) NOT NULL, 
	virus_enrich_appr VARCHAR(25) NOT NULL, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	compl_appr VARCHAR(15), 
	sort_tech VARCHAR(28), 
	single_cell_lysis_appr VARCHAR(11), 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT, 
	wga_amp_kit TEXT, 
	bin_param VARCHAR(15), 
	bin_software TEXT, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	vir_ident_software TEXT NOT NULL, 
	pred_genome_type VARCHAR(15) NOT NULL, 
	pred_genome_struc VARCHAR(13) NOT NULL, 
	detec_type TEXT NOT NULL, 
	otu_class_appr TEXT, 
	otu_seq_comp_appr TEXT, 
	otu_db TEXT, 
	host_pred_appr VARCHAR(24), 
	host_pred_est_acc TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, dermatology_disord, time_since_last_wash, dominant_hand, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_dur, samp_store_loc, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, source_uvig, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, trnas, trna_ext_software, compl_score, compl_software, compl_appr, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, bin_param, bin_software, reassembly_bin, mag_cov_software, vir_ident_software, pred_genome_type, pred_genome_struc, detec_type, otu_class_appr, otu_seq_comp_appr, otu_db, host_pred_appr, host_pred_est_acc, associated_resource, sop)
);

CREATE TABLE human_vaginal (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	menarche DATE, 
	sexual_act TEXT, 
	pregnancy DATE, 
	douche DATE, 
	birth_control TEXT, 
	menopause DATE, 
	hrt DATE, 
	hysterectomy TEXT, 
	gynecologic_disord TEXT, 
	urogenit_disord TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	samp_salinity TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_loc TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, menarche, sexual_act, pregnancy, douche, birth_control, menopause, hrt, hysterectomy, gynecologic_disord, urogenit_disord, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, samp_salinity, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_loc, samp_store_dur, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext)
);

CREATE TABLE "human_vaginal_MIGS_bacteria" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	menarche DATE, 
	sexual_act TEXT, 
	pregnancy DATE, 
	douche DATE, 
	birth_control TEXT, 
	menopause DATE, 
	hrt DATE, 
	hysterectomy TEXT, 
	gynecologic_disord TEXT, 
	urogenit_disord TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	samp_salinity TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_loc TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER NOT NULL, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT NOT NULL, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	trophic_level VARCHAR(22), 
	encoded_traits TEXT, 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, menarche, sexual_act, pregnancy, douche, birth_control, menopause, hrt, hysterectomy, gynecologic_disord, urogenit_disord, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, samp_salinity, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_loc, samp_store_dur, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, trophic_level, encoded_traits, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_vaginal_MIGS_eukaryote" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	menarche DATE, 
	sexual_act TEXT, 
	pregnancy DATE, 
	douche DATE, 
	birth_control TEXT, 
	menopause DATE, 
	hrt DATE, 
	hysterectomy TEXT, 
	gynecologic_disord TEXT, 
	urogenit_disord TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	samp_salinity TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_loc TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	ploidy TEXT, 
	num_replicons INTEGER, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	trophic_level VARCHAR(22), 
	propagation TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, menarche, sexual_act, pregnancy, douche, birth_control, menopause, hrt, hysterectomy, gynecologic_disord, urogenit_disord, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, samp_salinity, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_loc, samp_store_dur, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, ploidy, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, trophic_level, propagation, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_vaginal_MIGS_org" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	menarche DATE, 
	sexual_act TEXT, 
	pregnancy DATE, 
	douche DATE, 
	birth_control TEXT, 
	menopause DATE, 
	hrt DATE, 
	hysterectomy TEXT, 
	gynecologic_disord TEXT, 
	urogenit_disord TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	samp_salinity TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_loc TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, menarche, sexual_act, pregnancy, douche, birth_control, menopause, hrt, hysterectomy, gynecologic_disord, urogenit_disord, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, samp_salinity, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_loc, samp_store_dur, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_vaginal_MIGS_plant" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	menarche DATE, 
	sexual_act TEXT, 
	pregnancy DATE, 
	douche DATE, 
	birth_control TEXT, 
	menopause DATE, 
	hrt DATE, 
	hysterectomy TEXT, 
	gynecologic_disord TEXT, 
	urogenit_disord TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	samp_salinity TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_loc TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, menarche, sexual_act, pregnancy, douche, birth_control, menopause, hrt, hysterectomy, gynecologic_disord, urogenit_disord, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, samp_salinity, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_loc, samp_store_dur, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, estimated_size, ref_biomaterial, source_mat_id, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_vaginal_MIGS_virus" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	menarche DATE, 
	sexual_act TEXT, 
	pregnancy DATE, 
	douche DATE, 
	birth_control TEXT, 
	menopause DATE, 
	hrt DATE, 
	hysterectomy TEXT, 
	gynecologic_disord TEXT, 
	urogenit_disord TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	samp_salinity TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_loc TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	virus_enrich_appr VARCHAR(25), 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, menarche, sexual_act, pregnancy, douche, birth_control, menopause, hrt, hysterectomy, gynecologic_disord, urogenit_disord, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, samp_salinity, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_loc, samp_store_dur, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "human_vaginal_MIMAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	menarche DATE, 
	sexual_act TEXT, 
	pregnancy DATE, 
	douche DATE, 
	birth_control TEXT, 
	menopause DATE, 
	hrt DATE, 
	hysterectomy TEXT, 
	gynecologic_disord TEXT, 
	urogenit_disord TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	samp_salinity TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_loc TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	bin_param VARCHAR(15) NOT NULL, 
	bin_software TEXT NOT NULL, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, menarche, sexual_act, pregnancy, douche, birth_control, menopause, hrt, hysterectomy, gynecologic_disord, urogenit_disord, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, samp_salinity, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_loc, samp_store_dur, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, bin_param, bin_software, reassembly_bin, mag_cov_software, associated_resource, sop)
);

CREATE TABLE "human_vaginal_MIMARKS_specimen" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	menarche DATE, 
	sexual_act TEXT, 
	pregnancy DATE, 
	douche DATE, 
	birth_control TEXT, 
	menopause DATE, 
	hrt DATE, 
	hysterectomy TEXT, 
	gynecologic_disord TEXT, 
	urogenit_disord TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	samp_salinity TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_loc TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	mid TEXT, 
	adapters TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	assembly_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, menarche, sexual_act, pregnancy, douche, birth_control, menopause, hrt, hysterectomy, gynecologic_disord, urogenit_disord, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, samp_salinity, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_loc, samp_store_dur, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, pcr_primers, mid, adapters, pcr_cond, seq_meth, seq_quality_check, chimera_check, assembly_software, associated_resource, sop)
);

CREATE TABLE "human_vaginal_MIMARKS_survey" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	menarche DATE, 
	sexual_act TEXT, 
	pregnancy DATE, 
	douche DATE, 
	birth_control TEXT, 
	menopause DATE, 
	hrt DATE, 
	hysterectomy TEXT, 
	gynecologic_disord TEXT, 
	urogenit_disord TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	samp_salinity TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_loc TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	source_mat_id TEXT, 
	biotic_relationship VARCHAR(11), 
	trophic_level VARCHAR(22), 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, menarche, sexual_act, pregnancy, douche, birth_control, menopause, hrt, hysterectomy, gynecologic_disord, urogenit_disord, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, samp_salinity, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_loc, samp_store_dur, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, source_mat_id, biotic_relationship, trophic_level, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, target_gene, target_subfragment, pcr_primers, pcr_cond, seq_meth, seq_quality_check, chimera_check, associated_resource, sop)
);

CREATE TABLE "human_vaginal_MIMS" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	menarche DATE, 
	sexual_act TEXT, 
	pregnancy DATE, 
	douche DATE, 
	birth_control TEXT, 
	menopause DATE, 
	hrt DATE, 
	hysterectomy TEXT, 
	gynecologic_disord TEXT, 
	urogenit_disord TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	samp_salinity TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_loc TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, menarche, sexual_act, pregnancy, douche, birth_control, menopause, hrt, hysterectomy, gynecologic_disord, urogenit_disord, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, samp_salinity, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_loc, samp_store_dur, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, associated_resource, sop)
);

CREATE TABLE "human_vaginal_MISAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	menarche DATE, 
	sexual_act TEXT, 
	pregnancy DATE, 
	douche DATE, 
	birth_control TEXT, 
	menopause DATE, 
	hrt DATE, 
	hysterectomy TEXT, 
	gynecologic_disord TEXT, 
	urogenit_disord TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	samp_salinity TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_loc TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	sort_tech VARCHAR(28) NOT NULL, 
	single_cell_lysis_appr VARCHAR(11) NOT NULL, 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT NOT NULL, 
	wga_amp_kit TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, menarche, sexual_act, pregnancy, douche, birth_control, menopause, hrt, hysterectomy, gynecologic_disord, urogenit_disord, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, samp_salinity, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_loc, samp_store_dur, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, associated_resource, sop)
);

CREATE TABLE "human_vaginal_MIUVIG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	menarche DATE, 
	sexual_act TEXT, 
	pregnancy DATE, 
	douche DATE, 
	birth_control TEXT, 
	menopause DATE, 
	hrt DATE, 
	hysterectomy TEXT, 
	gynecologic_disord TEXT, 
	urogenit_disord TEXT, 
	host_subject_id TEXT, 
	host_age TEXT, 
	host_sex VARCHAR(13), 
	ihmc_medication_code INTEGER, 
	chem_administration TEXT, 
	host_body_site TEXT, 
	host_body_product TEXT, 
	host_tot_mass TEXT, 
	host_height TEXT, 
	host_diet TEXT, 
	host_last_meal TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_phenotype TEXT, 
	host_body_temp TEXT, 
	host_body_mass_index TEXT, 
	ethnicity TEXT, 
	host_occupation INTEGER, 
	medic_hist_perform TEXT, 
	host_pulse TEXT, 
	perturbation TEXT, 
	samp_salinity TEXT, 
	salinity TEXT, 
	oxy_stat_samp VARCHAR(9), 
	organism_count VARCHAR(5), 
	samp_store_temp TEXT, 
	samp_store_loc TEXT, 
	samp_store_dur TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	source_uvig VARCHAR(42) NOT NULL, 
	virus_enrich_appr VARCHAR(25) NOT NULL, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	compl_appr VARCHAR(15), 
	sort_tech VARCHAR(28), 
	single_cell_lysis_appr VARCHAR(11), 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT, 
	wga_amp_kit TEXT, 
	bin_param VARCHAR(15), 
	bin_software TEXT, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	vir_ident_software TEXT NOT NULL, 
	pred_genome_type VARCHAR(15) NOT NULL, 
	pred_genome_struc VARCHAR(13) NOT NULL, 
	detec_type TEXT NOT NULL, 
	otu_class_appr TEXT, 
	otu_seq_comp_appr TEXT, 
	otu_db TEXT, 
	host_pred_appr VARCHAR(24), 
	host_pred_est_acc TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, menarche, sexual_act, pregnancy, douche, birth_control, menopause, hrt, hysterectomy, gynecologic_disord, urogenit_disord, host_subject_id, host_age, host_sex, ihmc_medication_code, chem_administration, host_body_site, host_body_product, host_tot_mass, host_height, host_diet, host_last_meal, host_family_relation, host_genotype, host_phenotype, host_body_temp, host_body_mass_index, ethnicity, host_occupation, medic_hist_perform, host_pulse, perturbation, samp_salinity, salinity, oxy_stat_samp, organism_count, samp_store_temp, samp_store_loc, samp_store_dur, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, source_uvig, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, trnas, trna_ext_software, compl_score, compl_software, compl_appr, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, bin_param, bin_software, reassembly_bin, mag_cov_software, vir_ident_software, pred_genome_type, pred_genome_struc, detec_type, otu_class_appr, otu_seq_comp_appr, otu_db, host_pred_appr, host_pred_est_acc, associated_resource, sop)
);

CREATE TABLE hydrocarbon_resources_cores (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT NOT NULL, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	permeability TEXT, 
	porosity TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	owc_tvdss TEXT, 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT NOT NULL, 
	vfa_fw TEXT NOT NULL, 
	sr_kerog_type VARCHAR(8), 
	sr_lithology VARCHAR(13), 
	sr_dep_env VARCHAR(14), 
	sr_geol_age VARCHAR(13), 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	pressure TEXT, 
	samp_tvdss TEXT, 
	samp_md VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_sulfur TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, permeability, porosity, lithology, depos_env, hcr_geol_age, owc_tvdss, hcr_fw_salinity, sulfate_fw, vfa_fw, sr_kerog_type, sr_lithology, sr_dep_env, sr_geol_age, samp_well_name, win, samp_type, samp_subtype, pressure, samp_tvdss, samp_md, oxy_stat_samp, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext)
);

CREATE TABLE "hydrocarbon_resources_cores_MIGS_bacteria" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT NOT NULL, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	permeability TEXT, 
	porosity TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	owc_tvdss TEXT, 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT NOT NULL, 
	vfa_fw TEXT NOT NULL, 
	sr_kerog_type VARCHAR(8), 
	sr_lithology VARCHAR(13), 
	sr_dep_env VARCHAR(14), 
	sr_geol_age VARCHAR(13), 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	pressure TEXT, 
	samp_tvdss TEXT, 
	samp_md VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_sulfur TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER NOT NULL, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT NOT NULL, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	trophic_level VARCHAR(22), 
	encoded_traits TEXT, 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, permeability, porosity, lithology, depos_env, hcr_geol_age, owc_tvdss, hcr_fw_salinity, sulfate_fw, vfa_fw, sr_kerog_type, sr_lithology, sr_dep_env, sr_geol_age, samp_well_name, win, samp_type, samp_subtype, pressure, samp_tvdss, samp_md, oxy_stat_samp, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, trophic_level, encoded_traits, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "hydrocarbon_resources_cores_MIGS_eukaryote" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT NOT NULL, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	permeability TEXT, 
	porosity TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	owc_tvdss TEXT, 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT NOT NULL, 
	vfa_fw TEXT NOT NULL, 
	sr_kerog_type VARCHAR(8), 
	sr_lithology VARCHAR(13), 
	sr_dep_env VARCHAR(14), 
	sr_geol_age VARCHAR(13), 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	pressure TEXT, 
	samp_tvdss TEXT, 
	samp_md VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_sulfur TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	ploidy TEXT, 
	num_replicons INTEGER, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	trophic_level VARCHAR(22), 
	propagation TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, permeability, porosity, lithology, depos_env, hcr_geol_age, owc_tvdss, hcr_fw_salinity, sulfate_fw, vfa_fw, sr_kerog_type, sr_lithology, sr_dep_env, sr_geol_age, samp_well_name, win, samp_type, samp_subtype, pressure, samp_tvdss, samp_md, oxy_stat_samp, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, ploidy, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, trophic_level, propagation, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "hydrocarbon_resources_cores_MIGS_org" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT NOT NULL, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	permeability TEXT, 
	porosity TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	owc_tvdss TEXT, 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT NOT NULL, 
	vfa_fw TEXT NOT NULL, 
	sr_kerog_type VARCHAR(8), 
	sr_lithology VARCHAR(13), 
	sr_dep_env VARCHAR(14), 
	sr_geol_age VARCHAR(13), 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	pressure TEXT, 
	samp_tvdss TEXT, 
	samp_md VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_sulfur TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, permeability, porosity, lithology, depos_env, hcr_geol_age, owc_tvdss, hcr_fw_salinity, sulfate_fw, vfa_fw, sr_kerog_type, sr_lithology, sr_dep_env, sr_geol_age, samp_well_name, win, samp_type, samp_subtype, pressure, samp_tvdss, samp_md, oxy_stat_samp, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "hydrocarbon_resources_cores_MIGS_plant" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT NOT NULL, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	permeability TEXT, 
	porosity TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	owc_tvdss TEXT, 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT NOT NULL, 
	vfa_fw TEXT NOT NULL, 
	sr_kerog_type VARCHAR(8), 
	sr_lithology VARCHAR(13), 
	sr_dep_env VARCHAR(14), 
	sr_geol_age VARCHAR(13), 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	pressure TEXT, 
	samp_tvdss TEXT, 
	samp_md VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_sulfur TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, permeability, porosity, lithology, depos_env, hcr_geol_age, owc_tvdss, hcr_fw_salinity, sulfate_fw, vfa_fw, sr_kerog_type, sr_lithology, sr_dep_env, sr_geol_age, samp_well_name, win, samp_type, samp_subtype, pressure, samp_tvdss, samp_md, oxy_stat_samp, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, estimated_size, ref_biomaterial, source_mat_id, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "hydrocarbon_resources_cores_MIGS_virus" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT NOT NULL, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	permeability TEXT, 
	porosity TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	owc_tvdss TEXT, 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT NOT NULL, 
	vfa_fw TEXT NOT NULL, 
	sr_kerog_type VARCHAR(8), 
	sr_lithology VARCHAR(13), 
	sr_dep_env VARCHAR(14), 
	sr_geol_age VARCHAR(13), 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	pressure TEXT, 
	samp_tvdss TEXT, 
	samp_md VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_sulfur TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	virus_enrich_appr VARCHAR(25), 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, permeability, porosity, lithology, depos_env, hcr_geol_age, owc_tvdss, hcr_fw_salinity, sulfate_fw, vfa_fw, sr_kerog_type, sr_lithology, sr_dep_env, sr_geol_age, samp_well_name, win, samp_type, samp_subtype, pressure, samp_tvdss, samp_md, oxy_stat_samp, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "hydrocarbon_resources_cores_MIMAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT NOT NULL, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	permeability TEXT, 
	porosity TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	owc_tvdss TEXT, 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT NOT NULL, 
	vfa_fw TEXT NOT NULL, 
	sr_kerog_type VARCHAR(8), 
	sr_lithology VARCHAR(13), 
	sr_dep_env VARCHAR(14), 
	sr_geol_age VARCHAR(13), 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	pressure TEXT, 
	samp_tvdss TEXT, 
	samp_md VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_sulfur TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	bin_param VARCHAR(15) NOT NULL, 
	bin_software TEXT NOT NULL, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, permeability, porosity, lithology, depos_env, hcr_geol_age, owc_tvdss, hcr_fw_salinity, sulfate_fw, vfa_fw, sr_kerog_type, sr_lithology, sr_dep_env, sr_geol_age, samp_well_name, win, samp_type, samp_subtype, pressure, samp_tvdss, samp_md, oxy_stat_samp, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, bin_param, bin_software, reassembly_bin, mag_cov_software, associated_resource, sop)
);

CREATE TABLE "hydrocarbon_resources_cores_MIMARKS_specimen" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT NOT NULL, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	permeability TEXT, 
	porosity TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	owc_tvdss TEXT, 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT NOT NULL, 
	vfa_fw TEXT NOT NULL, 
	sr_kerog_type VARCHAR(8), 
	sr_lithology VARCHAR(13), 
	sr_dep_env VARCHAR(14), 
	sr_geol_age VARCHAR(13), 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	pressure TEXT, 
	samp_tvdss TEXT, 
	samp_md VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_sulfur TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	mid TEXT, 
	adapters TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	assembly_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, permeability, porosity, lithology, depos_env, hcr_geol_age, owc_tvdss, hcr_fw_salinity, sulfate_fw, vfa_fw, sr_kerog_type, sr_lithology, sr_dep_env, sr_geol_age, samp_well_name, win, samp_type, samp_subtype, pressure, samp_tvdss, samp_md, oxy_stat_samp, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, pcr_primers, mid, adapters, pcr_cond, seq_meth, seq_quality_check, chimera_check, assembly_software, associated_resource, sop)
);

CREATE TABLE "hydrocarbon_resources_cores_MIMARKS_survey" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT NOT NULL, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	permeability TEXT, 
	porosity TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	owc_tvdss TEXT, 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT NOT NULL, 
	vfa_fw TEXT NOT NULL, 
	sr_kerog_type VARCHAR(8), 
	sr_lithology VARCHAR(13), 
	sr_dep_env VARCHAR(14), 
	sr_geol_age VARCHAR(13), 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	pressure TEXT, 
	samp_tvdss TEXT, 
	samp_md VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_sulfur TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	source_mat_id TEXT, 
	biotic_relationship VARCHAR(11), 
	trophic_level VARCHAR(22), 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, permeability, porosity, lithology, depos_env, hcr_geol_age, owc_tvdss, hcr_fw_salinity, sulfate_fw, vfa_fw, sr_kerog_type, sr_lithology, sr_dep_env, sr_geol_age, samp_well_name, win, samp_type, samp_subtype, pressure, samp_tvdss, samp_md, oxy_stat_samp, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, source_mat_id, biotic_relationship, trophic_level, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, target_gene, target_subfragment, pcr_primers, pcr_cond, seq_meth, seq_quality_check, chimera_check, associated_resource, sop)
);

CREATE TABLE "hydrocarbon_resources_cores_MIMS" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT NOT NULL, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	permeability TEXT, 
	porosity TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	owc_tvdss TEXT, 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT NOT NULL, 
	vfa_fw TEXT NOT NULL, 
	sr_kerog_type VARCHAR(8), 
	sr_lithology VARCHAR(13), 
	sr_dep_env VARCHAR(14), 
	sr_geol_age VARCHAR(13), 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	pressure TEXT, 
	samp_tvdss TEXT, 
	samp_md VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_sulfur TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, permeability, porosity, lithology, depos_env, hcr_geol_age, owc_tvdss, hcr_fw_salinity, sulfate_fw, vfa_fw, sr_kerog_type, sr_lithology, sr_dep_env, sr_geol_age, samp_well_name, win, samp_type, samp_subtype, pressure, samp_tvdss, samp_md, oxy_stat_samp, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, associated_resource, sop)
);

CREATE TABLE "hydrocarbon_resources_cores_MISAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT NOT NULL, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	permeability TEXT, 
	porosity TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	owc_tvdss TEXT, 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT NOT NULL, 
	vfa_fw TEXT NOT NULL, 
	sr_kerog_type VARCHAR(8), 
	sr_lithology VARCHAR(13), 
	sr_dep_env VARCHAR(14), 
	sr_geol_age VARCHAR(13), 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	pressure TEXT, 
	samp_tvdss TEXT, 
	samp_md VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_sulfur TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	sort_tech VARCHAR(28) NOT NULL, 
	single_cell_lysis_appr VARCHAR(11) NOT NULL, 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT NOT NULL, 
	wga_amp_kit TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, permeability, porosity, lithology, depos_env, hcr_geol_age, owc_tvdss, hcr_fw_salinity, sulfate_fw, vfa_fw, sr_kerog_type, sr_lithology, sr_dep_env, sr_geol_age, samp_well_name, win, samp_type, samp_subtype, pressure, samp_tvdss, samp_md, oxy_stat_samp, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, associated_resource, sop)
);

CREATE TABLE "hydrocarbon_resources_cores_MIUVIG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT NOT NULL, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	permeability TEXT, 
	porosity TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	owc_tvdss TEXT, 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT NOT NULL, 
	vfa_fw TEXT NOT NULL, 
	sr_kerog_type VARCHAR(8), 
	sr_lithology VARCHAR(13), 
	sr_dep_env VARCHAR(14), 
	sr_geol_age VARCHAR(13), 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	pressure TEXT, 
	samp_tvdss TEXT, 
	samp_md VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_sulfur TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	source_uvig VARCHAR(42) NOT NULL, 
	virus_enrich_appr VARCHAR(25) NOT NULL, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	compl_appr VARCHAR(15), 
	sort_tech VARCHAR(28), 
	single_cell_lysis_appr VARCHAR(11), 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT, 
	wga_amp_kit TEXT, 
	bin_param VARCHAR(15), 
	bin_software TEXT, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	vir_ident_software TEXT NOT NULL, 
	pred_genome_type VARCHAR(15) NOT NULL, 
	pred_genome_struc VARCHAR(13) NOT NULL, 
	detec_type TEXT NOT NULL, 
	otu_class_appr TEXT, 
	otu_seq_comp_appr TEXT, 
	otu_db TEXT, 
	host_pred_appr VARCHAR(24), 
	host_pred_est_acc TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, permeability, porosity, lithology, depos_env, hcr_geol_age, owc_tvdss, hcr_fw_salinity, sulfate_fw, vfa_fw, sr_kerog_type, sr_lithology, sr_dep_env, sr_geol_age, samp_well_name, win, samp_type, samp_subtype, pressure, samp_tvdss, samp_md, oxy_stat_samp, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, source_uvig, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, trnas, trna_ext_software, compl_score, compl_software, compl_appr, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, bin_param, bin_software, reassembly_bin, mag_cov_software, vir_ident_software, pred_genome_type, pred_genome_struc, detec_type, otu_class_appr, otu_seq_comp_appr, otu_db, host_pred_appr, host_pred_est_acc, associated_resource, sop)
);

CREATE TABLE hydrocarbon_resources_fluids_swabs (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT, 
	vfa_fw TEXT, 
	prod_start_date DATE, 
	prod_rate TEXT, 
	water_prod_rate TEXT, 
	water_cut TEXT NOT NULL, 
	iwf TEXT NOT NULL, 
	add_recov_method TEXT NOT NULL, 
	iw_bt_date_well DATE, 
	biocide TEXT, 
	biocide_admin_method TEXT, 
	chem_treatment TEXT, 
	chem_treat_method TEXT, 
	samp_loc_corr_rate TEXT, 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	samp_collect_point VARCHAR(12) NOT NULL, 
	pressure TEXT, 
	oxy_stat_samp VARCHAR(9), 
	samp_preserv TEXT, 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT NOT NULL, 
	sulfide TEXT NOT NULL, 
	tot_sulfur TEXT, 
	nitrate TEXT NOT NULL, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, lithology, depos_env, hcr_geol_age, hcr_fw_salinity, sulfate_fw, vfa_fw, prod_start_date, prod_rate, water_prod_rate, water_cut, iwf, add_recov_method, iw_bt_date_well, biocide, biocide_admin_method, chem_treatment, chem_treat_method, samp_loc_corr_rate, samp_well_name, win, samp_type, samp_subtype, samp_collect_point, pressure, oxy_stat_samp, samp_preserv, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext)
);

CREATE TABLE "hydrocarbon_resources_fluids_swabs_MIGS_bacteria" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT, 
	vfa_fw TEXT, 
	prod_start_date DATE, 
	prod_rate TEXT, 
	water_prod_rate TEXT, 
	water_cut TEXT NOT NULL, 
	iwf TEXT NOT NULL, 
	add_recov_method TEXT NOT NULL, 
	iw_bt_date_well DATE, 
	biocide TEXT, 
	biocide_admin_method TEXT, 
	chem_treatment TEXT, 
	chem_treat_method TEXT, 
	samp_loc_corr_rate TEXT, 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	samp_collect_point VARCHAR(12) NOT NULL, 
	pressure TEXT, 
	oxy_stat_samp VARCHAR(9), 
	samp_preserv TEXT, 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT NOT NULL, 
	sulfide TEXT NOT NULL, 
	tot_sulfur TEXT, 
	nitrate TEXT NOT NULL, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER NOT NULL, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT NOT NULL, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	trophic_level VARCHAR(22), 
	encoded_traits TEXT, 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, lithology, depos_env, hcr_geol_age, hcr_fw_salinity, sulfate_fw, vfa_fw, prod_start_date, prod_rate, water_prod_rate, water_cut, iwf, add_recov_method, iw_bt_date_well, biocide, biocide_admin_method, chem_treatment, chem_treat_method, samp_loc_corr_rate, samp_well_name, win, samp_type, samp_subtype, samp_collect_point, pressure, oxy_stat_samp, samp_preserv, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, trophic_level, encoded_traits, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "hydrocarbon_resources_fluids_swabs_MIGS_eukaryote" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT, 
	vfa_fw TEXT, 
	prod_start_date DATE, 
	prod_rate TEXT, 
	water_prod_rate TEXT, 
	water_cut TEXT NOT NULL, 
	iwf TEXT NOT NULL, 
	add_recov_method TEXT NOT NULL, 
	iw_bt_date_well DATE, 
	biocide TEXT, 
	biocide_admin_method TEXT, 
	chem_treatment TEXT, 
	chem_treat_method TEXT, 
	samp_loc_corr_rate TEXT, 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	samp_collect_point VARCHAR(12) NOT NULL, 
	pressure TEXT, 
	oxy_stat_samp VARCHAR(9), 
	samp_preserv TEXT, 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT NOT NULL, 
	sulfide TEXT NOT NULL, 
	tot_sulfur TEXT, 
	nitrate TEXT NOT NULL, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	ploidy TEXT, 
	num_replicons INTEGER, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	trophic_level VARCHAR(22), 
	propagation TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, lithology, depos_env, hcr_geol_age, hcr_fw_salinity, sulfate_fw, vfa_fw, prod_start_date, prod_rate, water_prod_rate, water_cut, iwf, add_recov_method, iw_bt_date_well, biocide, biocide_admin_method, chem_treatment, chem_treat_method, samp_loc_corr_rate, samp_well_name, win, samp_type, samp_subtype, samp_collect_point, pressure, oxy_stat_samp, samp_preserv, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, ploidy, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, trophic_level, propagation, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "hydrocarbon_resources_fluids_swabs_MIGS_org" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT, 
	vfa_fw TEXT, 
	prod_start_date DATE, 
	prod_rate TEXT, 
	water_prod_rate TEXT, 
	water_cut TEXT NOT NULL, 
	iwf TEXT NOT NULL, 
	add_recov_method TEXT NOT NULL, 
	iw_bt_date_well DATE, 
	biocide TEXT, 
	biocide_admin_method TEXT, 
	chem_treatment TEXT, 
	chem_treat_method TEXT, 
	samp_loc_corr_rate TEXT, 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	samp_collect_point VARCHAR(12) NOT NULL, 
	pressure TEXT, 
	oxy_stat_samp VARCHAR(9), 
	samp_preserv TEXT, 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT NOT NULL, 
	sulfide TEXT NOT NULL, 
	tot_sulfur TEXT, 
	nitrate TEXT NOT NULL, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, lithology, depos_env, hcr_geol_age, hcr_fw_salinity, sulfate_fw, vfa_fw, prod_start_date, prod_rate, water_prod_rate, water_cut, iwf, add_recov_method, iw_bt_date_well, biocide, biocide_admin_method, chem_treatment, chem_treat_method, samp_loc_corr_rate, samp_well_name, win, samp_type, samp_subtype, samp_collect_point, pressure, oxy_stat_samp, samp_preserv, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "hydrocarbon_resources_fluids_swabs_MIGS_plant" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT, 
	vfa_fw TEXT, 
	prod_start_date DATE, 
	prod_rate TEXT, 
	water_prod_rate TEXT, 
	water_cut TEXT NOT NULL, 
	iwf TEXT NOT NULL, 
	add_recov_method TEXT NOT NULL, 
	iw_bt_date_well DATE, 
	biocide TEXT, 
	biocide_admin_method TEXT, 
	chem_treatment TEXT, 
	chem_treat_method TEXT, 
	samp_loc_corr_rate TEXT, 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	samp_collect_point VARCHAR(12) NOT NULL, 
	pressure TEXT, 
	oxy_stat_samp VARCHAR(9), 
	samp_preserv TEXT, 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT NOT NULL, 
	sulfide TEXT NOT NULL, 
	tot_sulfur TEXT, 
	nitrate TEXT NOT NULL, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, lithology, depos_env, hcr_geol_age, hcr_fw_salinity, sulfate_fw, vfa_fw, prod_start_date, prod_rate, water_prod_rate, water_cut, iwf, add_recov_method, iw_bt_date_well, biocide, biocide_admin_method, chem_treatment, chem_treat_method, samp_loc_corr_rate, samp_well_name, win, samp_type, samp_subtype, samp_collect_point, pressure, oxy_stat_samp, samp_preserv, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, estimated_size, ref_biomaterial, source_mat_id, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "hydrocarbon_resources_fluids_swabs_MIGS_virus" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT, 
	vfa_fw TEXT, 
	prod_start_date DATE, 
	prod_rate TEXT, 
	water_prod_rate TEXT, 
	water_cut TEXT NOT NULL, 
	iwf TEXT NOT NULL, 
	add_recov_method TEXT NOT NULL, 
	iw_bt_date_well DATE, 
	biocide TEXT, 
	biocide_admin_method TEXT, 
	chem_treatment TEXT, 
	chem_treat_method TEXT, 
	samp_loc_corr_rate TEXT, 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	samp_collect_point VARCHAR(12) NOT NULL, 
	pressure TEXT, 
	oxy_stat_samp VARCHAR(9), 
	samp_preserv TEXT, 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT NOT NULL, 
	sulfide TEXT NOT NULL, 
	tot_sulfur TEXT, 
	nitrate TEXT NOT NULL, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	virus_enrich_appr VARCHAR(25), 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, lithology, depos_env, hcr_geol_age, hcr_fw_salinity, sulfate_fw, vfa_fw, prod_start_date, prod_rate, water_prod_rate, water_cut, iwf, add_recov_method, iw_bt_date_well, biocide, biocide_admin_method, chem_treatment, chem_treat_method, samp_loc_corr_rate, samp_well_name, win, samp_type, samp_subtype, samp_collect_point, pressure, oxy_stat_samp, samp_preserv, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "hydrocarbon_resources_fluids_swabs_MIMAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT, 
	vfa_fw TEXT, 
	prod_start_date DATE, 
	prod_rate TEXT, 
	water_prod_rate TEXT, 
	water_cut TEXT NOT NULL, 
	iwf TEXT NOT NULL, 
	add_recov_method TEXT NOT NULL, 
	iw_bt_date_well DATE, 
	biocide TEXT, 
	biocide_admin_method TEXT, 
	chem_treatment TEXT, 
	chem_treat_method TEXT, 
	samp_loc_corr_rate TEXT, 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	samp_collect_point VARCHAR(12) NOT NULL, 
	pressure TEXT, 
	oxy_stat_samp VARCHAR(9), 
	samp_preserv TEXT, 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT NOT NULL, 
	sulfide TEXT NOT NULL, 
	tot_sulfur TEXT, 
	nitrate TEXT NOT NULL, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	bin_param VARCHAR(15) NOT NULL, 
	bin_software TEXT NOT NULL, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, lithology, depos_env, hcr_geol_age, hcr_fw_salinity, sulfate_fw, vfa_fw, prod_start_date, prod_rate, water_prod_rate, water_cut, iwf, add_recov_method, iw_bt_date_well, biocide, biocide_admin_method, chem_treatment, chem_treat_method, samp_loc_corr_rate, samp_well_name, win, samp_type, samp_subtype, samp_collect_point, pressure, oxy_stat_samp, samp_preserv, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, bin_param, bin_software, reassembly_bin, mag_cov_software, associated_resource, sop)
);

CREATE TABLE "hydrocarbon_resources_fluids_swabs_MIMARKS_specimen" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT, 
	vfa_fw TEXT, 
	prod_start_date DATE, 
	prod_rate TEXT, 
	water_prod_rate TEXT, 
	water_cut TEXT NOT NULL, 
	iwf TEXT NOT NULL, 
	add_recov_method TEXT NOT NULL, 
	iw_bt_date_well DATE, 
	biocide TEXT, 
	biocide_admin_method TEXT, 
	chem_treatment TEXT, 
	chem_treat_method TEXT, 
	samp_loc_corr_rate TEXT, 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	samp_collect_point VARCHAR(12) NOT NULL, 
	pressure TEXT, 
	oxy_stat_samp VARCHAR(9), 
	samp_preserv TEXT, 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT NOT NULL, 
	sulfide TEXT NOT NULL, 
	tot_sulfur TEXT, 
	nitrate TEXT NOT NULL, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	mid TEXT, 
	adapters TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	assembly_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, lithology, depos_env, hcr_geol_age, hcr_fw_salinity, sulfate_fw, vfa_fw, prod_start_date, prod_rate, water_prod_rate, water_cut, iwf, add_recov_method, iw_bt_date_well, biocide, biocide_admin_method, chem_treatment, chem_treat_method, samp_loc_corr_rate, samp_well_name, win, samp_type, samp_subtype, samp_collect_point, pressure, oxy_stat_samp, samp_preserv, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, pcr_primers, mid, adapters, pcr_cond, seq_meth, seq_quality_check, chimera_check, assembly_software, associated_resource, sop)
);

CREATE TABLE "hydrocarbon_resources_fluids_swabs_MIMARKS_survey" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT, 
	vfa_fw TEXT, 
	prod_start_date DATE, 
	prod_rate TEXT, 
	water_prod_rate TEXT, 
	water_cut TEXT NOT NULL, 
	iwf TEXT NOT NULL, 
	add_recov_method TEXT NOT NULL, 
	iw_bt_date_well DATE, 
	biocide TEXT, 
	biocide_admin_method TEXT, 
	chem_treatment TEXT, 
	chem_treat_method TEXT, 
	samp_loc_corr_rate TEXT, 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	samp_collect_point VARCHAR(12) NOT NULL, 
	pressure TEXT, 
	oxy_stat_samp VARCHAR(9), 
	samp_preserv TEXT, 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT NOT NULL, 
	sulfide TEXT NOT NULL, 
	tot_sulfur TEXT, 
	nitrate TEXT NOT NULL, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	source_mat_id TEXT, 
	biotic_relationship VARCHAR(11), 
	trophic_level VARCHAR(22), 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, lithology, depos_env, hcr_geol_age, hcr_fw_salinity, sulfate_fw, vfa_fw, prod_start_date, prod_rate, water_prod_rate, water_cut, iwf, add_recov_method, iw_bt_date_well, biocide, biocide_admin_method, chem_treatment, chem_treat_method, samp_loc_corr_rate, samp_well_name, win, samp_type, samp_subtype, samp_collect_point, pressure, oxy_stat_samp, samp_preserv, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, source_mat_id, biotic_relationship, trophic_level, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, target_gene, target_subfragment, pcr_primers, pcr_cond, seq_meth, seq_quality_check, chimera_check, associated_resource, sop)
);

CREATE TABLE "hydrocarbon_resources_fluids_swabs_MIMS" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT, 
	vfa_fw TEXT, 
	prod_start_date DATE, 
	prod_rate TEXT, 
	water_prod_rate TEXT, 
	water_cut TEXT NOT NULL, 
	iwf TEXT NOT NULL, 
	add_recov_method TEXT NOT NULL, 
	iw_bt_date_well DATE, 
	biocide TEXT, 
	biocide_admin_method TEXT, 
	chem_treatment TEXT, 
	chem_treat_method TEXT, 
	samp_loc_corr_rate TEXT, 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	samp_collect_point VARCHAR(12) NOT NULL, 
	pressure TEXT, 
	oxy_stat_samp VARCHAR(9), 
	samp_preserv TEXT, 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT NOT NULL, 
	sulfide TEXT NOT NULL, 
	tot_sulfur TEXT, 
	nitrate TEXT NOT NULL, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, lithology, depos_env, hcr_geol_age, hcr_fw_salinity, sulfate_fw, vfa_fw, prod_start_date, prod_rate, water_prod_rate, water_cut, iwf, add_recov_method, iw_bt_date_well, biocide, biocide_admin_method, chem_treatment, chem_treat_method, samp_loc_corr_rate, samp_well_name, win, samp_type, samp_subtype, samp_collect_point, pressure, oxy_stat_samp, samp_preserv, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, associated_resource, sop)
);

CREATE TABLE "hydrocarbon_resources_fluids_swabs_MISAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT, 
	vfa_fw TEXT, 
	prod_start_date DATE, 
	prod_rate TEXT, 
	water_prod_rate TEXT, 
	water_cut TEXT NOT NULL, 
	iwf TEXT NOT NULL, 
	add_recov_method TEXT NOT NULL, 
	iw_bt_date_well DATE, 
	biocide TEXT, 
	biocide_admin_method TEXT, 
	chem_treatment TEXT, 
	chem_treat_method TEXT, 
	samp_loc_corr_rate TEXT, 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	samp_collect_point VARCHAR(12) NOT NULL, 
	pressure TEXT, 
	oxy_stat_samp VARCHAR(9), 
	samp_preserv TEXT, 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT NOT NULL, 
	sulfide TEXT NOT NULL, 
	tot_sulfur TEXT, 
	nitrate TEXT NOT NULL, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	sort_tech VARCHAR(28) NOT NULL, 
	single_cell_lysis_appr VARCHAR(11) NOT NULL, 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT NOT NULL, 
	wga_amp_kit TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, lithology, depos_env, hcr_geol_age, hcr_fw_salinity, sulfate_fw, vfa_fw, prod_start_date, prod_rate, water_prod_rate, water_cut, iwf, add_recov_method, iw_bt_date_well, biocide, biocide_admin_method, chem_treatment, chem_treat_method, samp_loc_corr_rate, samp_well_name, win, samp_type, samp_subtype, samp_collect_point, pressure, oxy_stat_samp, samp_preserv, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, associated_resource, sop)
);

CREATE TABLE "hydrocarbon_resources_fluids_swabs_MIUVIG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT NOT NULL, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	hcr VARCHAR(19) NOT NULL, 
	hc_produced VARCHAR(15) NOT NULL, 
	basin TEXT NOT NULL, 
	field TEXT, 
	reservoir TEXT, 
	hcr_temp TEXT, 
	tvdss_of_hcr_temp TEXT, 
	hcr_pressure TEXT, 
	tvdss_of_hcr_press TEXT, 
	lithology VARCHAR(12), 
	depos_env VARCHAR(24), 
	hcr_geol_age VARCHAR(13), 
	hcr_fw_salinity TEXT, 
	sulfate_fw TEXT, 
	vfa_fw TEXT, 
	prod_start_date DATE, 
	prod_rate TEXT, 
	water_prod_rate TEXT, 
	water_cut TEXT NOT NULL, 
	iwf TEXT NOT NULL, 
	add_recov_method TEXT NOT NULL, 
	iw_bt_date_well DATE, 
	biocide TEXT, 
	biocide_admin_method TEXT, 
	chem_treatment TEXT, 
	chem_treat_method TEXT, 
	samp_loc_corr_rate TEXT, 
	samp_well_name TEXT, 
	win TEXT, 
	samp_type TEXT NOT NULL, 
	samp_subtype VARCHAR(14), 
	samp_collect_point VARCHAR(12) NOT NULL, 
	pressure TEXT, 
	oxy_stat_samp VARCHAR(9), 
	samp_preserv TEXT, 
	samp_transport_cond TEXT, 
	samp_store_temp TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	organism_count VARCHAR(5), 
	org_count_qpcr_info TEXT, 
	ph FLOAT, 
	salinity TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	sulfate TEXT NOT NULL, 
	sulfide TEXT NOT NULL, 
	tot_sulfur TEXT, 
	nitrate TEXT NOT NULL, 
	nitrite TEXT, 
	ammonium TEXT, 
	tot_nitro TEXT, 
	diss_iron TEXT, 
	sodium TEXT, 
	chloride TEXT, 
	potassium TEXT, 
	magnesium TEXT, 
	calcium TEXT, 
	tot_iron TEXT, 
	diss_org_carb TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	tot_phosp TEXT, 
	suspend_solids TEXT, 
	density TEXT, 
	diss_carb_dioxide TEXT, 
	diss_oxygen_fluid TEXT, 
	vfa TEXT, 
	benzene TEXT, 
	toluene TEXT, 
	ethylbenzene TEXT, 
	xylene TEXT, 
	api TEXT NOT NULL, 
	tan TEXT, 
	viscosity TEXT, 
	pour_point TEXT, 
	saturates_pc TEXT, 
	aromatics_pc TEXT, 
	resins_pc TEXT, 
	asphaltenes_pc TEXT, 
	misc_param TEXT, 
	additional_info TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	source_uvig VARCHAR(42) NOT NULL, 
	virus_enrich_appr VARCHAR(25) NOT NULL, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	compl_appr VARCHAR(15), 
	sort_tech VARCHAR(28), 
	single_cell_lysis_appr VARCHAR(11), 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT, 
	wga_amp_kit TEXT, 
	bin_param VARCHAR(15), 
	bin_software TEXT, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	vir_ident_software TEXT NOT NULL, 
	pred_genome_type VARCHAR(15) NOT NULL, 
	pred_genome_struc VARCHAR(13) NOT NULL, 
	detec_type TEXT NOT NULL, 
	otu_class_appr TEXT, 
	otu_seq_comp_appr TEXT, 
	otu_db TEXT, 
	host_pred_appr VARCHAR(24), 
	host_pred_est_acc TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, hcr, hc_produced, basin, field, reservoir, hcr_temp, tvdss_of_hcr_temp, hcr_pressure, tvdss_of_hcr_press, lithology, depos_env, hcr_geol_age, hcr_fw_salinity, sulfate_fw, vfa_fw, prod_start_date, prod_rate, water_prod_rate, water_cut, iwf, add_recov_method, iw_bt_date_well, biocide, biocide_admin_method, chem_treatment, chem_treat_method, samp_loc_corr_rate, samp_well_name, win, samp_type, samp_subtype, samp_collect_point, pressure, oxy_stat_samp, samp_preserv, samp_transport_cond, samp_store_temp, samp_store_dur, samp_store_loc, organism_count, org_count_qpcr_info, ph, salinity, alkalinity, alkalinity_method, sulfate, sulfide, tot_sulfur, nitrate, nitrite, ammonium, tot_nitro, diss_iron, sodium, chloride, potassium, magnesium, calcium, tot_iron, diss_org_carb, diss_inorg_carb, diss_inorg_phosp, tot_phosp, suspend_solids, density, diss_carb_dioxide, diss_oxygen_fluid, vfa, benzene, toluene, ethylbenzene, xylene, api, tan, viscosity, pour_point, saturates_pc, aromatics_pc, resins_pc, asphaltenes_pc, misc_param, additional_info, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, source_uvig, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, trnas, trna_ext_software, compl_score, compl_software, compl_appr, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, bin_param, bin_software, reassembly_bin, mag_cov_software, vir_ident_software, pred_genome_type, pred_genome_struc, detec_type, otu_class_appr, otu_seq_comp_appr, otu_db, host_pred_appr, host_pred_est_acc, associated_resource, sop)
);

CREATE TABLE microbial_mat_biofilm (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	alkyl_diethers TEXT, 
	aminopept_act TEXT, 
	ammonium TEXT, 
	bacteria_carb_prod TEXT, 
	biomass TEXT, 
	bishomohopanol TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	carb_nitro_ratio TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	glucosidase_act TEXT, 
	magnesium TEXT, 
	mean_frict_vel TEXT, 
	mean_peak_frict_vel TEXT, 
	methane TEXT, 
	misc_param TEXT, 
	n_alkanes TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	part_org_carb TEXT, 
	perturbation TEXT, 
	petroleum_hydrocarb TEXT, 
	phaeopigments TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	redox_potential TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_carb TEXT, 
	tot_nitro_content TEXT, 
	tot_org_carb TEXT, 
	turbidity TEXT, 
	water_content TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, alkyl_diethers, aminopept_act, ammonium, bacteria_carb_prod, biomass, bishomohopanol, bromide, calcium, carb_nitro_ratio, chem_administration, chloride, chlorophyll, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_carb, diss_org_nitro, diss_oxygen, glucosidase_act, magnesium, mean_frict_vel, mean_peak_frict_vel, methane, misc_param, n_alkanes, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, part_org_carb, perturbation, petroleum_hydrocarb, phaeopigments, phosphate, phosplipid_fatt_acid, potassium, pressure, redox_potential, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, tot_carb, tot_nitro_content, tot_org_carb, turbidity, water_content, samp_name, project_name, samp_vol_we_dna_ext)
);

CREATE TABLE "microbial_mat_biofilm_MIGS_bacteria" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	alkyl_diethers TEXT, 
	aminopept_act TEXT, 
	ammonium TEXT, 
	bacteria_carb_prod TEXT, 
	biomass TEXT, 
	bishomohopanol TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	carb_nitro_ratio TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	glucosidase_act TEXT, 
	magnesium TEXT, 
	mean_frict_vel TEXT, 
	mean_peak_frict_vel TEXT, 
	methane TEXT, 
	misc_param TEXT, 
	n_alkanes TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	part_org_carb TEXT, 
	perturbation TEXT, 
	petroleum_hydrocarb TEXT, 
	phaeopigments TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	redox_potential TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_carb TEXT, 
	tot_nitro_content TEXT, 
	tot_org_carb TEXT, 
	turbidity TEXT, 
	water_content TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER NOT NULL, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT NOT NULL, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	trophic_level VARCHAR(22), 
	encoded_traits TEXT, 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, alkyl_diethers, aminopept_act, ammonium, bacteria_carb_prod, biomass, bishomohopanol, bromide, calcium, carb_nitro_ratio, chem_administration, chloride, chlorophyll, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_carb, diss_org_nitro, diss_oxygen, glucosidase_act, magnesium, mean_frict_vel, mean_peak_frict_vel, methane, misc_param, n_alkanes, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, part_org_carb, perturbation, petroleum_hydrocarb, phaeopigments, phosphate, phosplipid_fatt_acid, potassium, pressure, redox_potential, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, tot_carb, tot_nitro_content, tot_org_carb, turbidity, water_content, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, trophic_level, encoded_traits, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "microbial_mat_biofilm_MIGS_eukaryote" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	alkyl_diethers TEXT, 
	aminopept_act TEXT, 
	ammonium TEXT, 
	bacteria_carb_prod TEXT, 
	biomass TEXT, 
	bishomohopanol TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	carb_nitro_ratio TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	glucosidase_act TEXT, 
	magnesium TEXT, 
	mean_frict_vel TEXT, 
	mean_peak_frict_vel TEXT, 
	methane TEXT, 
	misc_param TEXT, 
	n_alkanes TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	part_org_carb TEXT, 
	perturbation TEXT, 
	petroleum_hydrocarb TEXT, 
	phaeopigments TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	redox_potential TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_carb TEXT, 
	tot_nitro_content TEXT, 
	tot_org_carb TEXT, 
	turbidity TEXT, 
	water_content TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	ploidy TEXT, 
	num_replicons INTEGER, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	trophic_level VARCHAR(22), 
	propagation TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, alkyl_diethers, aminopept_act, ammonium, bacteria_carb_prod, biomass, bishomohopanol, bromide, calcium, carb_nitro_ratio, chem_administration, chloride, chlorophyll, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_carb, diss_org_nitro, diss_oxygen, glucosidase_act, magnesium, mean_frict_vel, mean_peak_frict_vel, methane, misc_param, n_alkanes, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, part_org_carb, perturbation, petroleum_hydrocarb, phaeopigments, phosphate, phosplipid_fatt_acid, potassium, pressure, redox_potential, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, tot_carb, tot_nitro_content, tot_org_carb, turbidity, water_content, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, ploidy, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, trophic_level, propagation, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "microbial_mat_biofilm_MIGS_org" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	alkyl_diethers TEXT, 
	aminopept_act TEXT, 
	ammonium TEXT, 
	bacteria_carb_prod TEXT, 
	biomass TEXT, 
	bishomohopanol TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	carb_nitro_ratio TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	glucosidase_act TEXT, 
	magnesium TEXT, 
	mean_frict_vel TEXT, 
	mean_peak_frict_vel TEXT, 
	methane TEXT, 
	misc_param TEXT, 
	n_alkanes TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	part_org_carb TEXT, 
	perturbation TEXT, 
	petroleum_hydrocarb TEXT, 
	phaeopigments TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	redox_potential TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_carb TEXT, 
	tot_nitro_content TEXT, 
	tot_org_carb TEXT, 
	turbidity TEXT, 
	water_content TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, alkyl_diethers, aminopept_act, ammonium, bacteria_carb_prod, biomass, bishomohopanol, bromide, calcium, carb_nitro_ratio, chem_administration, chloride, chlorophyll, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_carb, diss_org_nitro, diss_oxygen, glucosidase_act, magnesium, mean_frict_vel, mean_peak_frict_vel, methane, misc_param, n_alkanes, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, part_org_carb, perturbation, petroleum_hydrocarb, phaeopigments, phosphate, phosplipid_fatt_acid, potassium, pressure, redox_potential, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, tot_carb, tot_nitro_content, tot_org_carb, turbidity, water_content, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "microbial_mat_biofilm_MIGS_plant" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	alkyl_diethers TEXT, 
	aminopept_act TEXT, 
	ammonium TEXT, 
	bacteria_carb_prod TEXT, 
	biomass TEXT, 
	bishomohopanol TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	carb_nitro_ratio TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	glucosidase_act TEXT, 
	magnesium TEXT, 
	mean_frict_vel TEXT, 
	mean_peak_frict_vel TEXT, 
	methane TEXT, 
	misc_param TEXT, 
	n_alkanes TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	part_org_carb TEXT, 
	perturbation TEXT, 
	petroleum_hydrocarb TEXT, 
	phaeopigments TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	redox_potential TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_carb TEXT, 
	tot_nitro_content TEXT, 
	tot_org_carb TEXT, 
	turbidity TEXT, 
	water_content TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, alkyl_diethers, aminopept_act, ammonium, bacteria_carb_prod, biomass, bishomohopanol, bromide, calcium, carb_nitro_ratio, chem_administration, chloride, chlorophyll, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_carb, diss_org_nitro, diss_oxygen, glucosidase_act, magnesium, mean_frict_vel, mean_peak_frict_vel, methane, misc_param, n_alkanes, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, part_org_carb, perturbation, petroleum_hydrocarb, phaeopigments, phosphate, phosplipid_fatt_acid, potassium, pressure, redox_potential, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, tot_carb, tot_nitro_content, tot_org_carb, turbidity, water_content, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, estimated_size, ref_biomaterial, source_mat_id, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "microbial_mat_biofilm_MIGS_virus" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	alkyl_diethers TEXT, 
	aminopept_act TEXT, 
	ammonium TEXT, 
	bacteria_carb_prod TEXT, 
	biomass TEXT, 
	bishomohopanol TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	carb_nitro_ratio TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	glucosidase_act TEXT, 
	magnesium TEXT, 
	mean_frict_vel TEXT, 
	mean_peak_frict_vel TEXT, 
	methane TEXT, 
	misc_param TEXT, 
	n_alkanes TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	part_org_carb TEXT, 
	perturbation TEXT, 
	petroleum_hydrocarb TEXT, 
	phaeopigments TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	redox_potential TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_carb TEXT, 
	tot_nitro_content TEXT, 
	tot_org_carb TEXT, 
	turbidity TEXT, 
	water_content TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	virus_enrich_appr VARCHAR(25), 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, alkyl_diethers, aminopept_act, ammonium, bacteria_carb_prod, biomass, bishomohopanol, bromide, calcium, carb_nitro_ratio, chem_administration, chloride, chlorophyll, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_carb, diss_org_nitro, diss_oxygen, glucosidase_act, magnesium, mean_frict_vel, mean_peak_frict_vel, methane, misc_param, n_alkanes, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, part_org_carb, perturbation, petroleum_hydrocarb, phaeopigments, phosphate, phosplipid_fatt_acid, potassium, pressure, redox_potential, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, tot_carb, tot_nitro_content, tot_org_carb, turbidity, water_content, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "microbial_mat_biofilm_MIMAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	alkyl_diethers TEXT, 
	aminopept_act TEXT, 
	ammonium TEXT, 
	bacteria_carb_prod TEXT, 
	biomass TEXT, 
	bishomohopanol TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	carb_nitro_ratio TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	glucosidase_act TEXT, 
	magnesium TEXT, 
	mean_frict_vel TEXT, 
	mean_peak_frict_vel TEXT, 
	methane TEXT, 
	misc_param TEXT, 
	n_alkanes TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	part_org_carb TEXT, 
	perturbation TEXT, 
	petroleum_hydrocarb TEXT, 
	phaeopigments TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	redox_potential TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_carb TEXT, 
	tot_nitro_content TEXT, 
	tot_org_carb TEXT, 
	turbidity TEXT, 
	water_content TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	bin_param VARCHAR(15) NOT NULL, 
	bin_software TEXT NOT NULL, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, alkyl_diethers, aminopept_act, ammonium, bacteria_carb_prod, biomass, bishomohopanol, bromide, calcium, carb_nitro_ratio, chem_administration, chloride, chlorophyll, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_carb, diss_org_nitro, diss_oxygen, glucosidase_act, magnesium, mean_frict_vel, mean_peak_frict_vel, methane, misc_param, n_alkanes, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, part_org_carb, perturbation, petroleum_hydrocarb, phaeopigments, phosphate, phosplipid_fatt_acid, potassium, pressure, redox_potential, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, tot_carb, tot_nitro_content, tot_org_carb, turbidity, water_content, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, bin_param, bin_software, reassembly_bin, mag_cov_software, associated_resource, sop)
);

CREATE TABLE "microbial_mat_biofilm_MIMARKS_specimen" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	alkyl_diethers TEXT, 
	aminopept_act TEXT, 
	ammonium TEXT, 
	bacteria_carb_prod TEXT, 
	biomass TEXT, 
	bishomohopanol TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	carb_nitro_ratio TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	glucosidase_act TEXT, 
	magnesium TEXT, 
	mean_frict_vel TEXT, 
	mean_peak_frict_vel TEXT, 
	methane TEXT, 
	misc_param TEXT, 
	n_alkanes TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	part_org_carb TEXT, 
	perturbation TEXT, 
	petroleum_hydrocarb TEXT, 
	phaeopigments TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	redox_potential TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_carb TEXT, 
	tot_nitro_content TEXT, 
	tot_org_carb TEXT, 
	turbidity TEXT, 
	water_content TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	mid TEXT, 
	adapters TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	assembly_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, alkyl_diethers, aminopept_act, ammonium, bacteria_carb_prod, biomass, bishomohopanol, bromide, calcium, carb_nitro_ratio, chem_administration, chloride, chlorophyll, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_carb, diss_org_nitro, diss_oxygen, glucosidase_act, magnesium, mean_frict_vel, mean_peak_frict_vel, methane, misc_param, n_alkanes, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, part_org_carb, perturbation, petroleum_hydrocarb, phaeopigments, phosphate, phosplipid_fatt_acid, potassium, pressure, redox_potential, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, tot_carb, tot_nitro_content, tot_org_carb, turbidity, water_content, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, pcr_primers, mid, adapters, pcr_cond, seq_meth, seq_quality_check, chimera_check, assembly_software, associated_resource, sop)
);

CREATE TABLE "microbial_mat_biofilm_MIMARKS_survey" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	alkyl_diethers TEXT, 
	aminopept_act TEXT, 
	ammonium TEXT, 
	bacteria_carb_prod TEXT, 
	biomass TEXT, 
	bishomohopanol TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	carb_nitro_ratio TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	glucosidase_act TEXT, 
	magnesium TEXT, 
	mean_frict_vel TEXT, 
	mean_peak_frict_vel TEXT, 
	methane TEXT, 
	misc_param TEXT, 
	n_alkanes TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	part_org_carb TEXT, 
	perturbation TEXT, 
	petroleum_hydrocarb TEXT, 
	phaeopigments TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	redox_potential TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_carb TEXT, 
	tot_nitro_content TEXT, 
	tot_org_carb TEXT, 
	turbidity TEXT, 
	water_content TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	source_mat_id TEXT, 
	biotic_relationship VARCHAR(11), 
	trophic_level VARCHAR(22), 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, alkyl_diethers, aminopept_act, ammonium, bacteria_carb_prod, biomass, bishomohopanol, bromide, calcium, carb_nitro_ratio, chem_administration, chloride, chlorophyll, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_carb, diss_org_nitro, diss_oxygen, glucosidase_act, magnesium, mean_frict_vel, mean_peak_frict_vel, methane, misc_param, n_alkanes, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, part_org_carb, perturbation, petroleum_hydrocarb, phaeopigments, phosphate, phosplipid_fatt_acid, potassium, pressure, redox_potential, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, tot_carb, tot_nitro_content, tot_org_carb, turbidity, water_content, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, source_mat_id, biotic_relationship, trophic_level, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, target_gene, target_subfragment, pcr_primers, pcr_cond, seq_meth, seq_quality_check, chimera_check, associated_resource, sop)
);

CREATE TABLE "microbial_mat_biofilm_MIMS" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	alkyl_diethers TEXT, 
	aminopept_act TEXT, 
	ammonium TEXT, 
	bacteria_carb_prod TEXT, 
	biomass TEXT, 
	bishomohopanol TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	carb_nitro_ratio TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	glucosidase_act TEXT, 
	magnesium TEXT, 
	mean_frict_vel TEXT, 
	mean_peak_frict_vel TEXT, 
	methane TEXT, 
	misc_param TEXT, 
	n_alkanes TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	part_org_carb TEXT, 
	perturbation TEXT, 
	petroleum_hydrocarb TEXT, 
	phaeopigments TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	redox_potential TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_carb TEXT, 
	tot_nitro_content TEXT, 
	tot_org_carb TEXT, 
	turbidity TEXT, 
	water_content TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, alkyl_diethers, aminopept_act, ammonium, bacteria_carb_prod, biomass, bishomohopanol, bromide, calcium, carb_nitro_ratio, chem_administration, chloride, chlorophyll, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_carb, diss_org_nitro, diss_oxygen, glucosidase_act, magnesium, mean_frict_vel, mean_peak_frict_vel, methane, misc_param, n_alkanes, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, part_org_carb, perturbation, petroleum_hydrocarb, phaeopigments, phosphate, phosplipid_fatt_acid, potassium, pressure, redox_potential, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, tot_carb, tot_nitro_content, tot_org_carb, turbidity, water_content, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, associated_resource, sop)
);

CREATE TABLE "microbial_mat_biofilm_MISAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	alkyl_diethers TEXT, 
	aminopept_act TEXT, 
	ammonium TEXT, 
	bacteria_carb_prod TEXT, 
	biomass TEXT, 
	bishomohopanol TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	carb_nitro_ratio TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	glucosidase_act TEXT, 
	magnesium TEXT, 
	mean_frict_vel TEXT, 
	mean_peak_frict_vel TEXT, 
	methane TEXT, 
	misc_param TEXT, 
	n_alkanes TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	part_org_carb TEXT, 
	perturbation TEXT, 
	petroleum_hydrocarb TEXT, 
	phaeopigments TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	redox_potential TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_carb TEXT, 
	tot_nitro_content TEXT, 
	tot_org_carb TEXT, 
	turbidity TEXT, 
	water_content TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	sort_tech VARCHAR(28) NOT NULL, 
	single_cell_lysis_appr VARCHAR(11) NOT NULL, 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT NOT NULL, 
	wga_amp_kit TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, alkyl_diethers, aminopept_act, ammonium, bacteria_carb_prod, biomass, bishomohopanol, bromide, calcium, carb_nitro_ratio, chem_administration, chloride, chlorophyll, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_carb, diss_org_nitro, diss_oxygen, glucosidase_act, magnesium, mean_frict_vel, mean_peak_frict_vel, methane, misc_param, n_alkanes, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, part_org_carb, perturbation, petroleum_hydrocarb, phaeopigments, phosphate, phosplipid_fatt_acid, potassium, pressure, redox_potential, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, tot_carb, tot_nitro_content, tot_org_carb, turbidity, water_content, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, associated_resource, sop)
);

CREATE TABLE "microbial_mat_biofilm_MIUVIG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	alkyl_diethers TEXT, 
	aminopept_act TEXT, 
	ammonium TEXT, 
	bacteria_carb_prod TEXT, 
	biomass TEXT, 
	bishomohopanol TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	carb_nitro_ratio TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	glucosidase_act TEXT, 
	magnesium TEXT, 
	mean_frict_vel TEXT, 
	mean_peak_frict_vel TEXT, 
	methane TEXT, 
	misc_param TEXT, 
	n_alkanes TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	part_org_carb TEXT, 
	perturbation TEXT, 
	petroleum_hydrocarb TEXT, 
	phaeopigments TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	redox_potential TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	tot_carb TEXT, 
	tot_nitro_content TEXT, 
	tot_org_carb TEXT, 
	turbidity TEXT, 
	water_content TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	source_uvig VARCHAR(42) NOT NULL, 
	virus_enrich_appr VARCHAR(25) NOT NULL, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	compl_appr VARCHAR(15), 
	sort_tech VARCHAR(28), 
	single_cell_lysis_appr VARCHAR(11), 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT, 
	wga_amp_kit TEXT, 
	bin_param VARCHAR(15), 
	bin_software TEXT, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	vir_ident_software TEXT NOT NULL, 
	pred_genome_type VARCHAR(15) NOT NULL, 
	pred_genome_struc VARCHAR(13) NOT NULL, 
	detec_type TEXT NOT NULL, 
	otu_class_appr TEXT, 
	otu_seq_comp_appr TEXT, 
	otu_db TEXT, 
	host_pred_appr VARCHAR(24), 
	host_pred_est_acc TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, alkyl_diethers, aminopept_act, ammonium, bacteria_carb_prod, biomass, bishomohopanol, bromide, calcium, carb_nitro_ratio, chem_administration, chloride, chlorophyll, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_carb, diss_org_nitro, diss_oxygen, glucosidase_act, magnesium, mean_frict_vel, mean_peak_frict_vel, methane, misc_param, n_alkanes, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, part_org_carb, perturbation, petroleum_hydrocarb, phaeopigments, phosphate, phosplipid_fatt_acid, potassium, pressure, redox_potential, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, tot_carb, tot_nitro_content, tot_org_carb, turbidity, water_content, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, source_uvig, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, trnas, trna_ext_software, compl_score, compl_software, compl_appr, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, bin_param, bin_software, reassembly_bin, mag_cov_software, vir_ident_software, pred_genome_type, pred_genome_struc, detec_type, otu_class_appr, otu_seq_comp_appr, otu_db, host_pred_appr, host_pred_est_acc, associated_resource, sop)
);

CREATE TABLE miscellaneous_natural_or_artificial_environment (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	ammonium TEXT, 
	biomass TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	density TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	misc_param TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	perturbation TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	water_current TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, ammonium, biomass, bromide, calcium, chem_administration, chloride, chlorophyll, density, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_nitro, diss_oxygen, misc_param, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, perturbation, phosphate, phosplipid_fatt_acid, potassium, pressure, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, water_current, samp_name, project_name, samp_vol_we_dna_ext)
);

CREATE TABLE "miscellaneous_natural_or_artificial_environment_MIGS_bacteria" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	ammonium TEXT, 
	biomass TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	density TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	misc_param TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	perturbation TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	water_current TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER NOT NULL, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT NOT NULL, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	trophic_level VARCHAR(22), 
	encoded_traits TEXT, 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, ammonium, biomass, bromide, calcium, chem_administration, chloride, chlorophyll, density, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_nitro, diss_oxygen, misc_param, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, perturbation, phosphate, phosplipid_fatt_acid, potassium, pressure, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, water_current, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, trophic_level, encoded_traits, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "miscellaneous_natural_or_artificial_environment_MIGS_eukaryote" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	ammonium TEXT, 
	biomass TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	density TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	misc_param TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	perturbation TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	water_current TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	ploidy TEXT, 
	num_replicons INTEGER, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	trophic_level VARCHAR(22), 
	propagation TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, ammonium, biomass, bromide, calcium, chem_administration, chloride, chlorophyll, density, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_nitro, diss_oxygen, misc_param, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, perturbation, phosphate, phosplipid_fatt_acid, potassium, pressure, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, water_current, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, ploidy, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, trophic_level, propagation, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "miscellaneous_natural_or_artificial_environment_MIGS_org" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	ammonium TEXT, 
	biomass TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	density TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	misc_param TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	perturbation TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	water_current TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, ammonium, biomass, bromide, calcium, chem_administration, chloride, chlorophyll, density, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_nitro, diss_oxygen, misc_param, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, perturbation, phosphate, phosplipid_fatt_acid, potassium, pressure, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, water_current, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "miscellaneous_natural_or_artificial_environment_MIGS_plant" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	ammonium TEXT, 
	biomass TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	density TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	misc_param TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	perturbation TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	water_current TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, ammonium, biomass, bromide, calcium, chem_administration, chloride, chlorophyll, density, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_nitro, diss_oxygen, misc_param, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, perturbation, phosphate, phosplipid_fatt_acid, potassium, pressure, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, water_current, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, estimated_size, ref_biomaterial, source_mat_id, specific_host, host_spec_range, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "miscellaneous_natural_or_artificial_environment_MIGS_virus" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	ammonium TEXT, 
	biomass TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	density TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	misc_param TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	perturbation TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	water_current TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	propagation TEXT NOT NULL, 
	encoded_traits TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	virus_enrich_appr VARCHAR(25), 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, ammonium, biomass, bromide, calcium, chem_administration, chloride, chlorophyll, density, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_nitro, diss_oxygen, misc_param, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, perturbation, phosphate, phosplipid_fatt_acid, potassium, pressure, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, water_current, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, propagation, encoded_traits, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "miscellaneous_natural_or_artificial_environment_MIMAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	ammonium TEXT, 
	biomass TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	density TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	misc_param TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	perturbation TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	water_current TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	bin_param VARCHAR(15) NOT NULL, 
	bin_software TEXT NOT NULL, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, ammonium, biomass, bromide, calcium, chem_administration, chloride, chlorophyll, density, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_nitro, diss_oxygen, misc_param, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, perturbation, phosphate, phosplipid_fatt_acid, potassium, pressure, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, water_current, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, bin_param, bin_software, reassembly_bin, mag_cov_software, associated_resource, sop)
);

CREATE TABLE "miscellaneous_natural_or_artificial_environment_MIMARKS_specimen" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	ammonium TEXT, 
	biomass TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	density TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	misc_param TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	perturbation TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	water_current TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	mid TEXT, 
	adapters TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	assembly_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, ammonium, biomass, bromide, calcium, chem_administration, chloride, chlorophyll, density, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_nitro, diss_oxygen, misc_param, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, perturbation, phosphate, phosplipid_fatt_acid, potassium, pressure, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, water_current, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, target_gene, target_subfragment, pcr_primers, mid, adapters, pcr_cond, seq_meth, seq_quality_check, chimera_check, assembly_software, associated_resource, sop)
);

CREATE TABLE "miscellaneous_natural_or_artificial_environment_MIMARKS_survey" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	ammonium TEXT, 
	biomass TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	density TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	misc_param TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	perturbation TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	water_current TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	extrachrom_elements INTEGER, 
	source_mat_id TEXT, 
	biotic_relationship VARCHAR(11), 
	trophic_level VARCHAR(22), 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	target_gene TEXT NOT NULL, 
	target_subfragment TEXT, 
	pcr_primers TEXT, 
	pcr_cond TEXT, 
	seq_meth TEXT NOT NULL, 
	seq_quality_check TEXT, 
	chimera_check TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, ammonium, biomass, bromide, calcium, chem_administration, chloride, chlorophyll, density, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_nitro, diss_oxygen, misc_param, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, perturbation, phosphate, phosplipid_fatt_acid, potassium, pressure, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, water_current, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, extrachrom_elements, source_mat_id, biotic_relationship, trophic_level, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, target_gene, target_subfragment, pcr_primers, pcr_cond, seq_meth, seq_quality_check, chimera_check, associated_resource, sop)
);

CREATE TABLE "miscellaneous_natural_or_artificial_environment_MIMS" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	ammonium TEXT, 
	biomass TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	density TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	misc_param TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	perturbation TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	water_current TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	assembly_qual VARCHAR(27), 
	assembly_name TEXT, 
	assembly_software TEXT, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, ammonium, biomass, bromide, calcium, chem_administration, chloride, chlorophyll, density, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_nitro, diss_oxygen, misc_param, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, perturbation, phosphate, phosplipid_fatt_acid, potassium, pressure, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, water_current, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, associated_resource, sop)
);

CREATE TABLE "miscellaneous_natural_or_artificial_environment_MISAG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	ammonium TEXT, 
	biomass TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	density TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	misc_param TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	perturbation TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	water_current TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	rel_to_oxygen VARCHAR(17), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21) NOT NULL, 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	x_16s_recover TEXT, 
	x_16s_recover_software TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT NOT NULL, 
	compl_software TEXT NOT NULL, 
	compl_appr VARCHAR(15), 
	contam_score TEXT NOT NULL, 
	contam_screen_input TEXT, 
	contam_screen_param TEXT, 
	decontam_software VARCHAR(24), 
	sort_tech VARCHAR(28) NOT NULL, 
	single_cell_lysis_appr VARCHAR(11) NOT NULL, 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT NOT NULL, 
	wga_amp_kit TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, ammonium, biomass, bromide, calcium, chem_administration, chloride, chlorophyll, density, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_nitro, diss_oxygen, misc_param, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, perturbation, phosphate, phosplipid_fatt_acid, potassium, pressure, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, water_current, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, ref_biomaterial, source_mat_id, rel_to_oxygen, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, x_16s_recover, x_16s_recover_software, trnas, trna_ext_software, compl_score, compl_software, compl_appr, contam_score, contam_screen_input, contam_screen_param, decontam_software, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, associated_resource, sop)
);

CREATE TABLE "miscellaneous_natural_or_artificial_environment_MIUVIG" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	alkalinity TEXT, 
	ammonium TEXT, 
	biomass TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	density TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	misc_param TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph FLOAT, 
	perturbation TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	sodium TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	water_current TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	host_disease_stat TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	size_frac TEXT, 
	samp_size TEXT, 
	source_uvig VARCHAR(42) NOT NULL, 
	virus_enrich_appr VARCHAR(25) NOT NULL, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	mid TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	trnas INTEGER, 
	trna_ext_software TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	compl_appr VARCHAR(15), 
	sort_tech VARCHAR(28), 
	single_cell_lysis_appr VARCHAR(11), 
	single_cell_lysis_prot TEXT, 
	wga_amp_appr TEXT, 
	wga_amp_kit TEXT, 
	bin_param VARCHAR(15), 
	bin_software TEXT, 
	reassembly_bin TEXT, 
	mag_cov_software VARCHAR(6), 
	vir_ident_software TEXT NOT NULL, 
	pred_genome_type VARCHAR(15) NOT NULL, 
	pred_genome_struc VARCHAR(13) NOT NULL, 
	detec_type TEXT NOT NULL, 
	otu_class_appr TEXT, 
	otu_seq_comp_appr TEXT, 
	otu_db TEXT, 
	host_pred_appr VARCHAR(24), 
	host_pred_est_acc TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, alkalinity, ammonium, biomass, bromide, calcium, chem_administration, chloride, chlorophyll, density, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_nitro, diss_oxygen, misc_param, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, ph, perturbation, phosphate, phosplipid_fatt_acid, potassium, pressure, salinity, samp_store_dur, samp_store_loc, samp_store_temp, silicate, sodium, sulfate, sulfide, water_current, samp_name, project_name, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, host_disease_stat, samp_collec_device, samp_collec_method, samp_mat_process, size_frac, samp_size, source_uvig, virus_enrich_appr, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, mid, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, trnas, trna_ext_software, compl_score, compl_software, compl_appr, sort_tech, single_cell_lysis_appr, single_cell_lysis_prot, wga_amp_appr, wga_amp_kit, bin_param, bin_software, reassembly_bin, mag_cov_software, vir_ident_software, pred_genome_type, pred_genome_struc, detec_type, otu_class_appr, otu_seq_comp_appr, otu_db, host_pred_appr, host_pred_est_acc, associated_resource, sop)
);

CREATE TABLE plant_associated (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	air_temp_regm TEXT, 
	ances_data TEXT, 
	antibiotic_regm TEXT, 
	biol_stat VARCHAR(16), 
	biotic_regm TEXT, 
	chem_administration TEXT, 
	chem_mutagen TEXT, 
	climate_environment TEXT, 
	cult_root_med TEXT, 
	fertilizer_regm TEXT, 
	fungicide_regm TEXT, 
	gaseous_environment TEXT, 
	genetic_mod TEXT, 
	gravity TEXT, 
	growth_facil TEXT, 
	growth_habit VARCHAR(10), 
	growth_hormone_regm TEXT, 
	herbicide_regm TEXT, 
	host_age TEXT, 
	host_common_name TEXT, 
	host_dry_mass TEXT, 
	host_genotype TEXT, 
	host_height TEXT, 
	host_subspecf_genlin TEXT, 
	host_length TEXT, 
	host_life_stage TEXT, 
	host_phenotype TEXT, 
	host_taxid TEXT, 
	host_tot_mass TEXT, 
	host_wet_mass TEXT, 
	humidity_regm TEXT, 
	light_regm TEXT, 
	mechanical_damage TEXT, 
	mineral_nutr_regm TEXT, 
	misc_param TEXT, 
	non_min_nutr_regm TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph_regm TEXT, 
	perturbation TEXT, 
	pesticide_regm TEXT, 
	plant_growth_med VARCHAR(30), 
	plant_product TEXT, 
	plant_sex VARCHAR(19), 
	plant_struc TEXT, 
	radiation_regm TEXT, 
	rainfall_regm TEXT, 
	root_cond TEXT, 
	root_med_carbon TEXT, 
	root_med_macronutr TEXT, 
	root_med_micronutr TEXT, 
	root_med_suppl TEXT, 
	root_med_ph FLOAT, 
	root_med_regl TEXT, 
	root_med_solid TEXT, 
	salt_regm TEXT, 
	samp_capt_status VARCHAR(48), 
	samp_dis_stage VARCHAR(23), 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	season_environment TEXT, 
	standing_water_regm TEXT, 
	tiss_cult_growth_med TEXT, 
	water_temp_regm TEXT, 
	watering_regm TEXT, 
	host_symbiont TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, air_temp_regm, ances_data, antibiotic_regm, biol_stat, biotic_regm, chem_administration, chem_mutagen, climate_environment, cult_root_med, fertilizer_regm, fungicide_regm, gaseous_environment, genetic_mod, gravity, growth_facil, growth_habit, growth_hormone_regm, herbicide_regm, host_age, host_common_name, host_dry_mass, host_genotype, host_height, host_subspecf_genlin, host_length, host_life_stage, host_phenotype, host_taxid, host_tot_mass, host_wet_mass, humidity_regm, light_regm, mechanical_damage, mineral_nutr_regm, misc_param, non_min_nutr_regm, organism_count, oxy_stat_samp, ph_regm, perturbation, pesticide_regm, plant_growth_med, plant_product, plant_sex, plant_struc, radiation_regm, rainfall_regm, root_cond, root_med_carbon, root_med_macronutr, root_med_micronutr, root_med_suppl, root_med_ph, root_med_regl, root_med_solid, salt_regm, samp_capt_status, samp_dis_stage, salinity, samp_store_dur, samp_store_loc, samp_store_temp, season_environment, standing_water_regm, tiss_cult_growth_med, water_temp_regm, watering_regm, host_symbiont, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext)
);

CREATE TABLE "plant_associated_MIGS_bacteria" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	air_temp_regm TEXT, 
	ances_data TEXT, 
	antibiotic_regm TEXT, 
	biol_stat VARCHAR(16), 
	biotic_regm TEXT, 
	chem_administration TEXT, 
	chem_mutagen TEXT, 
	climate_environment TEXT, 
	cult_root_med TEXT, 
	fertilizer_regm TEXT, 
	fungicide_regm TEXT, 
	gaseous_environment TEXT, 
	genetic_mod TEXT, 
	gravity TEXT, 
	growth_facil TEXT, 
	growth_habit VARCHAR(10), 
	growth_hormone_regm TEXT, 
	herbicide_regm TEXT, 
	host_age TEXT, 
	host_common_name TEXT, 
	host_dry_mass TEXT, 
	host_genotype TEXT, 
	host_height TEXT, 
	host_subspecf_genlin TEXT, 
	host_length TEXT, 
	host_life_stage TEXT, 
	host_phenotype TEXT, 
	host_taxid TEXT, 
	host_tot_mass TEXT, 
	host_wet_mass TEXT, 
	humidity_regm TEXT, 
	light_regm TEXT, 
	mechanical_damage TEXT, 
	mineral_nutr_regm TEXT, 
	non_min_nutr_regm TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph_regm TEXT, 
	perturbation TEXT, 
	pesticide_regm TEXT, 
	plant_growth_med VARCHAR(30), 
	plant_product TEXT, 
	plant_sex VARCHAR(19), 
	plant_struc TEXT, 
	radiation_regm TEXT, 
	rainfall_regm TEXT, 
	root_cond TEXT, 
	root_med_carbon TEXT, 
	root_med_macronutr TEXT, 
	root_med_micronutr TEXT, 
	root_med_suppl TEXT, 
	root_med_ph FLOAT, 
	root_med_regl TEXT, 
	root_med_solid TEXT, 
	salt_regm TEXT, 
	samp_capt_status VARCHAR(48), 
	samp_dis_stage VARCHAR(23), 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	season_environment TEXT, 
	standing_water_regm TEXT, 
	tiss_cult_growth_med TEXT, 
	water_temp_regm TEXT, 
	watering_regm TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	num_replicons INTEGER NOT NULL, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT NOT NULL, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	trophic_level VARCHAR(22), 
	encoded_traits TEXT, 
	rel_to_oxygen VARCHAR(17), 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, air_temp_regm, ances_data, antibiotic_regm, biol_stat, biotic_regm, chem_administration, chem_mutagen, climate_environment, cult_root_med, fertilizer_regm, fungicide_regm, gaseous_environment, genetic_mod, gravity, growth_facil, growth_habit, growth_hormone_regm, herbicide_regm, host_age, host_common_name, host_dry_mass, host_genotype, host_height, host_subspecf_genlin, host_length, host_life_stage, host_phenotype, host_taxid, host_tot_mass, host_wet_mass, humidity_regm, light_regm, mechanical_damage, mineral_nutr_regm, non_min_nutr_regm, organism_count, oxy_stat_samp, ph_regm, perturbation, pesticide_regm, plant_growth_med, plant_product, plant_sex, plant_struc, radiation_regm, rainfall_regm, root_cond, root_med_carbon, root_med_macronutr, root_med_micronutr, root_med_suppl, root_med_ph, root_med_regl, root_med_solid, salt_regm, samp_capt_status, samp_dis_stage, salinity, samp_store_dur, samp_store_loc, samp_store_temp, season_environment, standing_water_regm, tiss_cult_growth_med, water_temp_regm, watering_regm, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, trophic_level, encoded_traits, rel_to_oxygen, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "plant_associated_MIGS_eukaryote" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	air_temp_regm TEXT, 
	ances_data TEXT, 
	antibiotic_regm TEXT, 
	biol_stat VARCHAR(16), 
	biotic_regm TEXT, 
	chem_administration TEXT, 
	chem_mutagen TEXT, 
	climate_environment TEXT, 
	cult_root_med TEXT, 
	fertilizer_regm TEXT, 
	fungicide_regm TEXT, 
	gaseous_environment TEXT, 
	genetic_mod TEXT, 
	gravity TEXT, 
	growth_facil TEXT, 
	growth_habit VARCHAR(10), 
	growth_hormone_regm TEXT, 
	herbicide_regm TEXT, 
	host_age TEXT, 
	host_common_name TEXT, 
	host_dry_mass TEXT, 
	host_genotype TEXT, 
	host_height TEXT, 
	host_subspecf_genlin TEXT, 
	host_length TEXT, 
	host_life_stage TEXT, 
	host_phenotype TEXT, 
	host_taxid TEXT, 
	host_tot_mass TEXT, 
	host_wet_mass TEXT, 
	humidity_regm TEXT, 
	light_regm TEXT, 
	mechanical_damage TEXT, 
	mineral_nutr_regm TEXT, 
	non_min_nutr_regm TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph_regm TEXT, 
	perturbation TEXT, 
	pesticide_regm TEXT, 
	plant_growth_med VARCHAR(30), 
	plant_product TEXT, 
	plant_sex VARCHAR(19), 
	plant_struc TEXT, 
	radiation_regm TEXT, 
	rainfall_regm TEXT, 
	root_cond TEXT, 
	root_med_carbon TEXT, 
	root_med_macronutr TEXT, 
	root_med_micronutr TEXT, 
	root_med_suppl TEXT, 
	root_med_ph FLOAT, 
	root_med_regl TEXT, 
	root_med_solid TEXT, 
	salt_regm TEXT, 
	samp_capt_status VARCHAR(48), 
	samp_dis_stage VARCHAR(23), 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	season_environment TEXT, 
	standing_water_regm TEXT, 
	tiss_cult_growth_med TEXT, 
	water_temp_regm TEXT, 
	watering_regm TEXT, 
	host_symbiont TEXT, 
	misc_param TEXT, 
	samp_name TEXT NOT NULL, 
	project_name TEXT NOT NULL, 
	host_disease_stat TEXT, 
	samp_vol_we_dna_ext TEXT, 
	samp_taxon_id TEXT NOT NULL, 
	experimental_factor TEXT, 
	neg_cont_type VARCHAR(23), 
	pos_cont_type TEXT, 
	subspecf_gen_lin TEXT, 
	ploidy TEXT, 
	num_replicons INTEGER, 
	extrachrom_elements INTEGER, 
	estimated_size TEXT, 
	ref_biomaterial TEXT, 
	source_mat_id TEXT, 
	pathogenicity TEXT, 
	biotic_relationship VARCHAR(11), 
	specific_host TEXT, 
	host_spec_range INTEGER, 
	trophic_level VARCHAR(22), 
	propagation TEXT, 
	isol_growth_condt TEXT NOT NULL, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	nucl_acid_ext TEXT, 
	nucl_acid_amp TEXT, 
	lib_size INTEGER, 
	lib_reads_seqd INTEGER, 
	lib_layout VARCHAR(6), 
	lib_vector TEXT, 
	lib_screen TEXT, 
	adapters TEXT, 
	seq_meth TEXT NOT NULL, 
	tax_ident VARCHAR(21), 
	assembly_qual VARCHAR(27) NOT NULL, 
	assembly_name TEXT, 
	assembly_software TEXT NOT NULL, 
	annot TEXT, 
	number_contig INTEGER NOT NULL, 
	feat_pred TEXT, 
	ref_db TEXT, 
	sim_search_meth TEXT, 
	tax_class TEXT, 
	compl_score TEXT, 
	compl_software TEXT, 
	associated_resource TEXT, 
	sop TEXT, 
	PRIMARY KEY (lat_lon, depth, alt, elev, "temp", geo_loc_name, collection_date, env_broad_scale, env_local_scale, env_medium, air_temp_regm, ances_data, antibiotic_regm, biol_stat, biotic_regm, chem_administration, chem_mutagen, climate_environment, cult_root_med, fertilizer_regm, fungicide_regm, gaseous_environment, genetic_mod, gravity, growth_facil, growth_habit, growth_hormone_regm, herbicide_regm, host_age, host_common_name, host_dry_mass, host_genotype, host_height, host_subspecf_genlin, host_length, host_life_stage, host_phenotype, host_taxid, host_tot_mass, host_wet_mass, humidity_regm, light_regm, mechanical_damage, mineral_nutr_regm, non_min_nutr_regm, organism_count, oxy_stat_samp, ph_regm, perturbation, pesticide_regm, plant_growth_med, plant_product, plant_sex, plant_struc, radiation_regm, rainfall_regm, root_cond, root_med_carbon, root_med_macronutr, root_med_micronutr, root_med_suppl, root_med_ph, root_med_regl, root_med_solid, salt_regm, samp_capt_status, samp_dis_stage, salinity, samp_store_dur, samp_store_loc, samp_store_temp, season_environment, standing_water_regm, tiss_cult_growth_med, water_temp_regm, watering_regm, host_symbiont, misc_param, samp_name, project_name, host_disease_stat, samp_vol_we_dna_ext, samp_taxon_id, experimental_factor, neg_cont_type, pos_cont_type, subspecf_gen_lin, ploidy, num_replicons, extrachrom_elements, estimated_size, ref_biomaterial, source_mat_id, pathogenicity, biotic_relationship, specific_host, host_spec_range, trophic_level, propagation, isol_growth_condt, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, nucl_acid_ext, nucl_acid_amp, lib_size, lib_reads_seqd, lib_layout, lib_vector, lib_screen, adapters, seq_meth, tax_ident, assembly_qual, assembly_name, assembly_software, annot, number_contig, feat_pred, ref_db, sim_search_meth, tax_class, compl_score, compl_software, associated_resource, sop)
);

CREATE TABLE "plant_associated_MIGS_org" (
	lat_lon TEXT, 
	depth TEXT, 
	alt TEXT, 
	elev TEXT, 
	"temp" TEXT, 
	geo_loc_name TEXT, 
	collection_date DATE, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	air_temp_regm TEXT, 
	ances_data TEXT, 
	antibiotic_regm TEXT, 
	biol_stat VARCHAR(16), 
	biotic_regm TEXT, 
	chem_administration TEXT, 
	chem_mutagen TEXT, 
	climate_environment TEXT, 
	cult_root_med TEXT, 
	fertilizer_regm TEXT, 
	fungicide_regm TEXT, 
	gaseous_environment TEXT, 
	genetic_mod TEXT, 
	gravity TEXT, 
	growth_facil TEXT, 
	growth_habit VARCHAR(10), 
	growth_hormone_regm TEXT, 
	herbicide_regm TEXT, 
	host_age TEXT, 
	host_common_name TEXT, 
	host_dry_mass TEXT, 
	host_genotype TEXT, 
	host_height TEXT, 
	host_subspecf_genlin TEXT, 
	host_length TEXT, 
	host_life_stage TEXT, 
	host_phenotype TEXT, 
	host_taxid TEXT, 
	host_tot_mass TEXT, 
	host_wet_mass TEXT, 
	humidity_regm TEXT, 
	light_regm TEXT, 
	mechanical_damage TEXT, 
	mineral_nutr_regm TEXT, 
	non_min_nutr_regm TEXT, 
	organism_count VARCHAR(5), 
	oxy_stat_samp VARCHAR(9), 
	ph_regm TEXT, 
	perturbation TEXT, 
	pesticide_regm TEXT, 
	plant_growth_med VARCHAR(30), 
	plant_product TEXT, 
	plant_sex VARCHAR(19), 
	plant_struc TEXT, 
	radiation_regm TEXT, 
	rainfall_regm TEXT, 
	root_cond TEXT, 
	root_med_carbon TEXT, 
	root_med_macronutr TEXT, 
	root_med_micronutr TEXT, 
	root_med_suppl TEXT, 
	root_med_ph FLOAT, 
	root_med_regl TEXT, 
	root_med_solid TEXT, 
	salt_regm TEXT, 
	samp_capt_status VARCHAR(48), 
	samp_dis_stage VARCHAR(23), 
	salinity TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	season_environment TEXT, 
	standing_water_regm TEXT, 
	tiss_cult_growth_med TEXT, 
	water_temp_regm TEXT, 
	wa