# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict, Any


class QueryIncidentTracingSubNodesCountRequest(TeaModel):
    def __init__(
        self,
        vertex_id_and_type_list: List[List[str]] = None,
    ):
        self.vertex_id_and_type_list = vertex_id_and_type_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vertex_id_and_type_list is not None:
            result['VertexIdAndTypeList'] = self.vertex_id_and_type_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VertexIdAndTypeList') is not None:
            self.vertex_id_and_type_list = m.get('VertexIdAndTypeList')
        return self


class AddAssetSelectionCriteriaRequestTargetOperationList(TeaModel):
    def __init__(
        self,
        operation: str = None,
        target: str = None,
    ):
        # The type of the operation. Valid values:
        # 
        # *   **add**\
        # *   **del**\
        self.operation = operation
        # The ID of the asset.
        self.target = target

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operation is not None:
            result['Operation'] = self.operation
        if self.target is not None:
            result['Target'] = self.target
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Operation') is not None:
            self.operation = m.get('Operation')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        return self


class AddAssetSelectionCriteriaRequest(TeaModel):
    def __init__(
        self,
        criteria: str = None,
        criteria_operation: str = None,
        selection_key: str = None,
        target_operation_list: List[AddAssetSelectionCriteriaRequestTargetOperationList] = None,
    ):
        # The search conditions that are used to query assets. The value of this parameter is in the JSON format and is case-sensitive.
        # 
        # > A search condition can be an instance ID, instance name, virtual private cloud (VPC) ID, region, or public IP address. You can call the [DescribeCriteria](~~DescribeCriteria~~) operation to query the supported search conditions.
        self.criteria = criteria
        # The type of the operation on search conditions. Valid values:
        # 
        # *   **add**: adds assets.
        # *   **del**: deletes assets.
        self.criteria_operation = criteria_operation
        # The unique ID of the asset.
        # 
        # This parameter is required.
        self.selection_key = selection_key
        # The list of assets.
        self.target_operation_list = target_operation_list

    def validate(self):
        if self.target_operation_list:
            for k in self.target_operation_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.criteria_operation is not None:
            result['CriteriaOperation'] = self.criteria_operation
        if self.selection_key is not None:
            result['SelectionKey'] = self.selection_key
        result['TargetOperationList'] = []
        if self.target_operation_list is not None:
            for k in self.target_operation_list:
                result['TargetOperationList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('CriteriaOperation') is not None:
            self.criteria_operation = m.get('CriteriaOperation')
        if m.get('SelectionKey') is not None:
            self.selection_key = m.get('SelectionKey')
        self.target_operation_list = []
        if m.get('TargetOperationList') is not None:
            for k in m.get('TargetOperationList'):
                temp_model = AddAssetSelectionCriteriaRequestTargetOperationList()
                self.target_operation_list.append(temp_model.from_map(k))
        return self


class AddAssetSelectionCriteriaResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddAssetSelectionCriteriaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddAssetSelectionCriteriaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddAssetSelectionCriteriaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddBaselineCheckWhiteRecordRequest(TeaModel):
    def __init__(
        self,
        check_id: int = None,
        lang: str = None,
        reason: str = None,
        source: str = None,
        target_type: str = None,
    ):
        # The ID of the check item.
        # 
        # >  You can call the [ListCheckItemWarningSummary](~~ListCheckItemWarningSummary~~) operation to query the IDs of check items.
        self.check_id = check_id
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The reason why the check item is added to the whitelist.
        self.reason = reason
        # The data source. If you leave this parameter empty, the default value is used. Valid values:
        # 
        # *   **default**: server
        # *   **agentless**: agentless detection
        self.source = source
        # The type of the assets on which the whitelist rule takes effect. Valid values:
        # 
        # *   **all_instance**: all servers
        # *   **instance**: specific servers
        self.target_type = target_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.source is not None:
            result['Source'] = self.source
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class AddBaselineCheckWhiteRecordResponseBodyData(TeaModel):
    def __init__(
        self,
        check_id: int = None,
        lang: str = None,
        reason: str = None,
        record_id: int = None,
        source: str = None,
        target: str = None,
        target_type: str = None,
    ):
        # The ID of the check item.
        # 
        # >  You can call the [ListCheckItemWarningSummary](~~ListCheckItemWarningSummary~~) operation to query the IDs of check items.
        self.check_id = check_id
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The reason why the check item is added to the whitelist.
        self.reason = reason
        # The ID of the whitelist rule.
        self.record_id = record_id
        # The data source. Valid values:
        # 
        # *   **default**: server
        # *   **agentless**: agentless detection
        self.source = source
        # The object that is added to the whitelist.
        self.target = target
        # The type of the assets on which the whitelist rule takes effect. Valid values:
        # 
        # *   **all_instance**: all servers
        # *   **instance**: specific servers
        self.target_type = target_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.source is not None:
            result['Source'] = self.source
        if self.target is not None:
            result['Target'] = self.target
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class AddBaselineCheckWhiteRecordResponseBody(TeaModel):
    def __init__(
        self,
        data: AddBaselineCheckWhiteRecordResponseBodyData = None,
        request_id: str = None,
    ):
        # The data returned.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = AddBaselineCheckWhiteRecordResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddBaselineCheckWhiteRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddBaselineCheckWhiteRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddBaselineCheckWhiteRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCheckInstanceResultWhiteListRequestInstanceList(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        region_id: str = None,
    ):
        # The instance ID of the asset.
        # 
        # >  You can call the [ListCheckInstanceResult](~~ListCheckInstanceResult~~) operation to query the instance IDs of assets.
        self.instance_id = instance_id
        # The region ID of the asset.
        # 
        # >  You can call the [ListCheckInstanceResult](~~ListCheckInstanceResult~~) operation to query the region ID of the asset.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AddCheckInstanceResultWhiteListRequest(TeaModel):
    def __init__(
        self,
        check_group_id: str = None,
        check_id: int = None,
        instance_ids: List[str] = None,
        instance_list: List[AddCheckInstanceResultWhiteListRequestInstanceList] = None,
        remark: str = None,
        rule_type: str = None,
    ):
        # The ID of the group to which the check item belongs.
        self.check_group_id = check_group_id
        # The ID of the check item.
        # 
        # >  You can call the [ListCheckResult](~~ListCheckResult~~) operation to query the IDs of check items.
        self.check_id = check_id
        # The instance IDs of the assets.
        self.instance_ids = instance_ids
        # The asset instances.
        self.instance_list = instance_list
        # The description. The value of this parameter can be up to 65,535 bytes in length.
        self.remark = remark
        # The type of the rule. Default value: **WHITE**. Valid value:
        # 
        # *   WHITE: adds check items to the whitelist.
        self.rule_type = rule_type

    def validate(self):
        if self.instance_list:
            for k in self.instance_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_group_id is not None:
            result['CheckGroupId'] = self.check_group_id
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        result['InstanceList'] = []
        if self.instance_list is not None:
            for k in self.instance_list:
                result['InstanceList'].append(k.to_map() if k else None)
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckGroupId') is not None:
            self.check_group_id = m.get('CheckGroupId')
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        self.instance_list = []
        if m.get('InstanceList') is not None:
            for k in m.get('InstanceList'):
                temp_model = AddCheckInstanceResultWhiteListRequestInstanceList()
                self.instance_list.append(temp_model.from_map(k))
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        return self


class AddCheckInstanceResultWhiteListResponseBody(TeaModel):
    def __init__(
        self,
        data: Dict[str, Any] = None,
        request_id: str = None,
        rule_id: str = None,
    ):
        # The data returned. This parameter is deprecated.
        self.data = data
        # The ID of the request.
        self.request_id = request_id
        # The ID of the whitelist rule.
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class AddCheckInstanceResultWhiteListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCheckInstanceResultWhiteListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCheckInstanceResultWhiteListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCheckResultWhiteListRequest(TeaModel):
    def __init__(
        self,
        check_ids: List[int] = None,
        remark: str = None,
        rule_type: str = None,
    ):
        # The IDs of the check items.
        # 
        # >  You can call the [ListCheckResult](~~ListCheckResult~~) operation to query the IDs of the check items.
        self.check_ids = check_ids
        # The description. The value of this parameter can be up to 65,535 bytes in length.
        self.remark = remark
        # The type of the rule. Default value: **WHITE**. Valid value:
        # 
        # *   **WHITE**: Add check items to the whitelist.
        self.rule_type = rule_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_ids is not None:
            result['CheckIds'] = self.check_ids
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckIds') is not None:
            self.check_ids = m.get('CheckIds')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        return self


class AddCheckResultWhiteListResponseBody(TeaModel):
    def __init__(
        self,
        data: Dict[str, Any] = None,
        request_id: str = None,
        rule_ids: List[int] = None,
    ):
        # The data returned. This parameter is deprecated.
        self.data = data
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # The IDs of the whitelist rules that are generated.
        self.rule_ids = rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_ids is not None:
            result['RuleIds'] = self.rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleIds') is not None:
            self.rule_ids = m.get('RuleIds')
        return self


class AddCheckResultWhiteListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCheckResultWhiteListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCheckResultWhiteListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddClientUserDefineRuleRequest(TeaModel):
    def __init__(
        self,
        action_type: int = None,
        cmdline: str = None,
        domain: str = None,
        file_path: str = None,
        ip: str = None,
        md_5list: str = None,
        name: str = None,
        new_file_path: str = None,
        parent_cmdline: str = None,
        parent_proc_path: str = None,
        platform: str = None,
        port: int = None,
        port_str: str = None,
        proc_path: str = None,
        registry_content: str = None,
        registry_key: str = None,
        type: int = None,
    ):
        # The action of the custom defense rule. Valid values:
        # 
        # *   **0**: allow
        # *   **1**: block
        # 
        # This parameter is required.
        self.action_type = action_type
        # The command line.
        self.cmdline = cmdline
        # The domain name.
        self.domain = domain
        # The file path.
        self.file_path = file_path
        # The IP address.
        self.ip = ip
        # The hash values of processes.
        self.md_5list = md_5list
        # The name of the custom defense rule.
        # 
        # This parameter is required.
        self.name = name
        # The new file path after the file is renamed.
        self.new_file_path = new_file_path
        # The parent command line.
        self.parent_cmdline = parent_cmdline
        # The path to the parent process.
        self.parent_proc_path = parent_proc_path
        # The type of the operating system. Valid values:
        # 
        # *   **windows**: Windows
        # *   **linux**: Linux
        # *   **all**: all types
        self.platform = platform
        # The port number. This parameter is deprecated.
        self.port = port
        # The port number. Valid values: **1 to 65535**.
        self.port_str = port_str
        # The path to the process.
        self.proc_path = proc_path
        # The registry value.
        self.registry_content = registry_content
        # The registry key.
        self.registry_key = registry_key
        # The type of the custom defense rule. Valid values:
        # 
        # *   **1**: Process hash
        # *   **2**: Command line
        # *   **3**: Process Network
        # *   **4**: File Read and Write
        # *   **5**: Operation on Registry
        # *   **6**: Dynamic-link Library Loading
        # *   **7**: File Renaming
        # 
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_type is not None:
            result['ActionType'] = self.action_type
        if self.cmdline is not None:
            result['Cmdline'] = self.cmdline
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.ip is not None:
            result['IP'] = self.ip
        if self.md_5list is not None:
            result['Md5List'] = self.md_5list
        if self.name is not None:
            result['Name'] = self.name
        if self.new_file_path is not None:
            result['NewFilePath'] = self.new_file_path
        if self.parent_cmdline is not None:
            result['ParentCmdline'] = self.parent_cmdline
        if self.parent_proc_path is not None:
            result['ParentProcPath'] = self.parent_proc_path
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.port is not None:
            result['Port'] = self.port
        if self.port_str is not None:
            result['PortStr'] = self.port_str
        if self.proc_path is not None:
            result['ProcPath'] = self.proc_path
        if self.registry_content is not None:
            result['RegistryContent'] = self.registry_content
        if self.registry_key is not None:
            result['RegistryKey'] = self.registry_key
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActionType') is not None:
            self.action_type = m.get('ActionType')
        if m.get('Cmdline') is not None:
            self.cmdline = m.get('Cmdline')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('Md5List') is not None:
            self.md_5list = m.get('Md5List')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NewFilePath') is not None:
            self.new_file_path = m.get('NewFilePath')
        if m.get('ParentCmdline') is not None:
            self.parent_cmdline = m.get('ParentCmdline')
        if m.get('ParentProcPath') is not None:
            self.parent_proc_path = m.get('ParentProcPath')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('PortStr') is not None:
            self.port_str = m.get('PortStr')
        if m.get('ProcPath') is not None:
            self.proc_path = m.get('ProcPath')
        if m.get('RegistryContent') is not None:
            self.registry_content = m.get('RegistryContent')
        if m.get('RegistryKey') is not None:
            self.registry_key = m.get('RegistryKey')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddClientUserDefineRuleResponseBodyUserDefineRuleAddResult(TeaModel):
    def __init__(
        self,
        id: int = None,
        platform: str = None,
        switch_id: str = None,
    ):
        # The ID of the rule.
        self.id = id
        # The type of the operating system. Valid values:
        # 
        # *   **windows**: Windows
        # *   **linux**: Linux
        # *   **all**: all types
        self.platform = platform
        # The switch ID of the custom defense rule.
        self.switch_id = switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.switch_id is not None:
            result['SwitchId'] = self.switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('SwitchId') is not None:
            self.switch_id = m.get('SwitchId')
        return self


class AddClientUserDefineRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        user_define_rule_add_result: AddClientUserDefineRuleResponseBodyUserDefineRuleAddResult = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The identifier of the custom defense rule.
        self.user_define_rule_add_result = user_define_rule_add_result

    def validate(self):
        if self.user_define_rule_add_result:
            self.user_define_rule_add_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_define_rule_add_result is not None:
            result['UserDefineRuleAddResult'] = self.user_define_rule_add_result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserDefineRuleAddResult') is not None:
            temp_model = AddClientUserDefineRuleResponseBodyUserDefineRuleAddResult()
            self.user_define_rule_add_result = temp_model.from_map(m['UserDefineRuleAddResult'])
        return self


class AddClientUserDefineRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddClientUserDefineRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddClientUserDefineRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCloudVendorAccountAKRequest(TeaModel):
    def __init__(
        self,
        ak_type: str = None,
        auth_modules: List[str] = None,
        ctdr_cloud_user_id: str = None,
        domain: str = None,
        extend_info: str = None,
        lang: str = None,
        regions: List[str] = None,
        secret_id: str = None,
        secret_key: str = None,
        subscription_ids: List[str] = None,
        tenant_id: str = None,
        vendor: str = None,
        vendor_auth_alias: str = None,
    ):
        # The type of the account to which the AccessKey pair belongs. Valid values:
        # 
        # *   **primary**: a primary account
        # *   **sub**: a sub-account
        # 
        # This parameter is required.
        self.ak_type = ak_type
        # The modules that are associated with the AccessKey pair.
        self.auth_modules = auth_modules
        # Account ID. > The account ID of the cloud provider, required when permissions include threat analysis and response.
        self.ctdr_cloud_user_id = ctdr_cloud_user_id
        # The Active Directory (AD) domain. This parameter takes effect only when Vendor is set to Azure. Valid values:
        # 
        # *   **china**\
        # *   **global**\
        self.domain = domain
        # Extended information.
        # > Used to record extended information from different vendors. > For Google Cloud, which is accessed via a service account, ExtendInfo stores the service key file in JSON format, excluding the private_key_id and zprivate_key fields. The file includes the following fields: type, project_id, client_email, client_id, auth_uri, token_uri, auth_provider_x509_cert_url, client_x509_cert_url, universe_domain.
        self.extend_info = extend_info
        # The language of the content in the request and response messages. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The regions that are examined during AccessKey pair authentication. This parameter takes effect only when Vendor is set to AWS.
        # 
        # >  You can call the [ListCloudVendorRegions](~~ListCloudVendorRegions~~) operation to query regions.
        self.regions = regions
        # The AccessKey ID. Valid values:
        # 
        # 1\\. If AkType is set to primary, specify this parameter based on the following description:
        # 
        # *   **Tencent**: Enter the AccessKey ID of a primary account on Tencent Cloud.
        # *   **HUAWEICLOUD**: Enter the AccessKey ID of a primary account on Huawei Cloud.
        # *   **Azure**: Enter the AccessKey ID of a primary account on Microsoft Azure.
        # *   **AWS**: Enter the AccessKey ID of a primary account on AWS.
        # 
        # 2\\. If AkType is set to sub, specify this parameter based on the following description:
        # 
        # *   **Tencent**: Enter the AccessKey ID of a sub-account on Tencent Cloud.
        # *   **HUAWEICLOUD**: Enter the AccessKey ID of a sub-account on Huawei Cloud.
        # *   **Azure**: Enter the AccessKey ID of a sub-account on Microsoft Azure.
        # *   **AWS**: Enter the AccessKey ID of a sub-account on AWS.
        # 
        # This parameter is required.
        self.secret_id = secret_id
        # The AccessKey secret. Valid values:
        # 
        # 1\\. If AkType is set to primary, specify this parameter based on the following description:
        # 
        # *   **Tencent**: Enter the AccessKey secret of a primary account on Tencent Cloud.
        # *   **HUAWEICLOUD**: Enter the AccessKey secret of a primary account on Huawei Cloud.
        # *   **Azure**: Enter the AccessKey secret of a primary account on Microsoft Azure.
        # *   **AWS**: Enter the AccessKey secret of a primary account on AWS.
        # 
        # 2\\. If AkType is set to sub, specify this parameter based on the following description:
        # 
        # *   **Tencent**: Enter the AccessKey secret of a sub-account on Tencent Cloud.
        # *   **HUAWEICLOUD**: Enter the AccessKey secret of a sub-account on Huawei Cloud.
        # *   **Azure**: Enter the AccessKey secret of a sub-account on Microsoft Azure.
        # *   **AWS**: Enter the AccessKey secret of a sub-account on AWS.
        # 
        # This parameter is required.
        self.secret_key = secret_key
        # The subscription IDs. This parameter takes effect only when Vendor is set to Azure.
        self.subscription_ids = subscription_ids
        # The tenant ID. This parameter takes effect only when Vendor is set to Azure.
        self.tenant_id = tenant_id
        # The cloud service provider. Valid values:
        # 
        # *   **Tencent**: Tencent Cloud
        # *   **HUAWEICLOUD**: Huawei Cloud
        # *   **Azure**: Microsoft Azure
        # *   **AWS**: Amazon Web Services (AWS)
        # 
        # This parameter is required.
        self.vendor = vendor
        # The name of the AccessKey pair.
        # 
        # >  The account information of the third-party cloud servers.
        self.vendor_auth_alias = vendor_auth_alias

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ak_type is not None:
            result['AkType'] = self.ak_type
        if self.auth_modules is not None:
            result['AuthModules'] = self.auth_modules
        if self.ctdr_cloud_user_id is not None:
            result['CtdrCloudUserId'] = self.ctdr_cloud_user_id
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.extend_info is not None:
            result['ExtendInfo'] = self.extend_info
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.regions is not None:
            result['Regions'] = self.regions
        if self.secret_id is not None:
            result['SecretId'] = self.secret_id
        if self.secret_key is not None:
            result['SecretKey'] = self.secret_key
        if self.subscription_ids is not None:
            result['SubscriptionIds'] = self.subscription_ids
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.vendor_auth_alias is not None:
            result['VendorAuthAlias'] = self.vendor_auth_alias
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AkType') is not None:
            self.ak_type = m.get('AkType')
        if m.get('AuthModules') is not None:
            self.auth_modules = m.get('AuthModules')
        if m.get('CtdrCloudUserId') is not None:
            self.ctdr_cloud_user_id = m.get('CtdrCloudUserId')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('ExtendInfo') is not None:
            self.extend_info = m.get('ExtendInfo')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Regions') is not None:
            self.regions = m.get('Regions')
        if m.get('SecretId') is not None:
            self.secret_id = m.get('SecretId')
        if m.get('SecretKey') is not None:
            self.secret_key = m.get('SecretKey')
        if m.get('SubscriptionIds') is not None:
            self.subscription_ids = m.get('SubscriptionIds')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('VendorAuthAlias') is not None:
            self.vendor_auth_alias = m.get('VendorAuthAlias')
        return self


class AddCloudVendorAccountAKResponseBodyDataAuthModules(TeaModel):
    def __init__(
        self,
        message: str = None,
        module: str = None,
        module_asset_type: str = None,
        module_disp: str = None,
        module_service_status: int = None,
        module_statement: str = None,
    ):
        # The error message of the module.
        self.message = message
        # The code of the module. Valid values:
        # 
        # *   **HOST**: host
        # *   **CSPM**: configuration assessment
        # *   **SIEM**: CloudSiem
        # *   **TRIAL**: log audit
        self.module = module
        # The cloud asset that is associated with the module.
        self.module_asset_type = module_asset_type
        # The display name of the module.
        self.module_disp = module_disp
        # The service status of the module. Valid values:
        # 
        # *   **0**: being used
        # *   **1**: exception occurred
        # *   **2**: being validated
        # *   **3**: validation timed out
        self.module_service_status = module_service_status
        # The permission description of the module.
        self.module_statement = module_statement

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.module is not None:
            result['Module'] = self.module
        if self.module_asset_type is not None:
            result['ModuleAssetType'] = self.module_asset_type
        if self.module_disp is not None:
            result['ModuleDisp'] = self.module_disp
        if self.module_service_status is not None:
            result['ModuleServiceStatus'] = self.module_service_status
        if self.module_statement is not None:
            result['ModuleStatement'] = self.module_statement
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Module') is not None:
            self.module = m.get('Module')
        if m.get('ModuleAssetType') is not None:
            self.module_asset_type = m.get('ModuleAssetType')
        if m.get('ModuleDisp') is not None:
            self.module_disp = m.get('ModuleDisp')
        if m.get('ModuleServiceStatus') is not None:
            self.module_service_status = m.get('ModuleServiceStatus')
        if m.get('ModuleStatement') is not None:
            self.module_statement = m.get('ModuleStatement')
        return self


class AddCloudVendorAccountAKResponseBodyData(TeaModel):
    def __init__(
        self,
        ak_type: str = None,
        auth_id: int = None,
        auth_modules: List[AddCloudVendorAccountAKResponseBodyDataAuthModules] = None,
        ctdr_cloud_user_id: str = None,
        message: str = None,
        secret_id: str = None,
        service_status: int = None,
        status: int = None,
        vendor: str = None,
        vendor_auth_alias: str = None,
    ):
        # The type of the account to which the AccessKey pair belongs. Valid values:
        # 
        # *   **primary**: a primary account
        # *   **sub**: a sub-account
        self.ak_type = ak_type
        # The unique ID of the AccessKey pair.
        self.auth_id = auth_id
        # The modules that are associated with the AccessKey pair.
        self.auth_modules = auth_modules
        # Account ID. 
        # 
        # > The account ID of the cloud provider being integrated.
        self.ctdr_cloud_user_id = ctdr_cloud_user_id
        # The error message of the AccessKey pair.
        self.message = message
        # The AccessKey ID.
        self.secret_id = secret_id
        # The service status of the AccessKey pair. Valid values:
        # 
        # *   **0**: being used
        # *   **1**: exception occurred
        # *   **2**: being validated
        # *   **3**: validation timed out
        self.service_status = service_status
        # The status of the AccessKey pair. Valid values:
        # 
        # *   **0**: enabled
        # *   **1**: disabled
        self.status = status
        # The cloud service provider. Valid values:
        # 
        # *   **Tencent**: Tencent Cloud
        # *   **HUAWEICLOUD**: Huawei Cloud
        # *   **Azure**: Microsoft Azure
        # *   **AWS**: AWS
        self.vendor = vendor
        # The name of the AccessKey pair.
        # 
        # >  The account information of the third-party cloud servers.
        self.vendor_auth_alias = vendor_auth_alias

    def validate(self):
        if self.auth_modules:
            for k in self.auth_modules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ak_type is not None:
            result['AkType'] = self.ak_type
        if self.auth_id is not None:
            result['AuthId'] = self.auth_id
        result['AuthModules'] = []
        if self.auth_modules is not None:
            for k in self.auth_modules:
                result['AuthModules'].append(k.to_map() if k else None)
        if self.ctdr_cloud_user_id is not None:
            result['CtdrCloudUserId'] = self.ctdr_cloud_user_id
        if self.message is not None:
            result['Message'] = self.message
        if self.secret_id is not None:
            result['SecretId'] = self.secret_id
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.status is not None:
            result['Status'] = self.status
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.vendor_auth_alias is not None:
            result['VendorAuthAlias'] = self.vendor_auth_alias
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AkType') is not None:
            self.ak_type = m.get('AkType')
        if m.get('AuthId') is not None:
            self.auth_id = m.get('AuthId')
        self.auth_modules = []
        if m.get('AuthModules') is not None:
            for k in m.get('AuthModules'):
                temp_model = AddCloudVendorAccountAKResponseBodyDataAuthModules()
                self.auth_modules.append(temp_model.from_map(k))
        if m.get('CtdrCloudUserId') is not None:
            self.ctdr_cloud_user_id = m.get('CtdrCloudUserId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('SecretId') is not None:
            self.secret_id = m.get('SecretId')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('VendorAuthAlias') is not None:
            self.vendor_auth_alias = m.get('VendorAuthAlias')
        return self


class AddCloudVendorAccountAKResponseBody(TeaModel):
    def __init__(
        self,
        data: AddCloudVendorAccountAKResponseBodyData = None,
        request_id: str = None,
    ):
        # The information about the AccessKey pair that is added.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = AddCloudVendorAccountAKResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCloudVendorAccountAKResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCloudVendorAccountAKResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCloudVendorAccountAKResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCloudVendorTrialConfigRequest(TeaModel):
    def __init__(
        self,
        auth_id: int = None,
        auth_info: str = None,
        vendor: str = None,
    ):
        # The AccessKey ID.
        # 
        # >  [](#-describecloudvendoraccountaklist--authid)You can call the [DescribeCloudVendorAccountAKList](~~DescribeCloudVendorAccountAKList~~) operation to query the AccessKey ID.
        # 
        # This parameter is required.
        self.auth_id = auth_id
        # The configurations of the third-party cloud asset. Valid values:
        # 
        # *   *AWS*: Configure the sqsQueueName and sqsRegion parameters.
        # *   *Tencent*: Configure the kafkaUserName, kafkaBootstrapServers, and kafkaTopic parameters.
        # 
        # This parameter is required.
        self.auth_info = auth_info
        # The service provider of the cloud asset. Valid values:
        # 
        # *   **Tencent**: Tencent Cloud.
        # *   **AWS**: Amazon Web Services (AWS).
        # 
        # This parameter is required.
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_id is not None:
            result['AuthId'] = self.auth_id
        if self.auth_info is not None:
            result['AuthInfo'] = self.auth_info
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthId') is not None:
            self.auth_id = m.get('AuthId')
        if m.get('AuthInfo') is not None:
            self.auth_info = m.get('AuthInfo')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class AddCloudVendorTrialConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCloudVendorTrialConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCloudVendorTrialConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCloudVendorTrialConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddContainerDefenseRuleRequestScope(TeaModel):
    def __init__(
        self,
        all_namespace: int = None,
        cluster_id: str = None,
        namespaces: List[str] = None,
    ):
        # Specifies whether to include all namespaces. Valid values:
        # 
        # *   **0**: You can use the Namespaces parameter to specify the namespaces to include.
        # *   **1**: All namespaces are included.
        self.all_namespace = all_namespace
        # The ID of the cluster.
        # 
        # >  You can call the [DescribeGroupedContainerInstances](https://help.aliyun.com/document_detail/182997.html) operation to query the IDs of clusters.
        self.cluster_id = cluster_id
        # The namespaces to include.
        self.namespaces = namespaces

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_namespace is not None:
            result['AllNamespace'] = self.all_namespace
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.namespaces is not None:
            result['Namespaces'] = self.namespaces
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllNamespace') is not None:
            self.all_namespace = m.get('AllNamespace')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Namespaces') is not None:
            self.namespaces = m.get('Namespaces')
        return self


class AddContainerDefenseRuleRequestWhitelist(TeaModel):
    def __init__(
        self,
        hash: List[str] = None,
        image: List[str] = None,
        path: List[str] = None,
    ):
        # The hash values of the files that need to be added to the whitelist.
        # 
        # > This parameter is not supported.
        self.hash = hash
        # The images that need to be added to the whitelist.
        self.image = image
        # The paths to the files that need to be added to the whitelist.
        self.path = path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hash is not None:
            result['Hash'] = self.hash
        if self.image is not None:
            result['Image'] = self.image
        if self.path is not None:
            result['Path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Hash') is not None:
            self.hash = m.get('Hash')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        return self


class AddContainerDefenseRuleRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        rule_action: int = None,
        rule_id: int = None,
        rule_name: str = None,
        rule_switch: int = None,
        rule_type: int = None,
        scope: List[AddContainerDefenseRuleRequestScope] = None,
        whitelist: AddContainerDefenseRuleRequestWhitelist = None,
    ):
        # The description of the rule.
        self.description = description
        # The action that is performed when the rule is hit. Valid values:
        # 
        # *   **1**: alert
        # *   **2**: block
        self.rule_action = rule_action
        # The ID of the rule. You do not need to manually specify the ID.
        self.rule_id = rule_id
        # The name of the rule.
        self.rule_name = rule_name
        # The switch of the rule. Valid values:
        # 
        # *   **0**: off
        # *   **1**: on
        self.rule_switch = rule_switch
        # The rule type. Valid values:
        # 
        # *   2: user-defined rules
        # 
        # > Only the value 2 is supported.
        self.rule_type = rule_type
        # The scope.
        self.scope = scope
        # The whitelist.
        self.whitelist = whitelist

    def validate(self):
        if self.scope:
            for k in self.scope:
                if k:
                    k.validate()
        if self.whitelist:
            self.whitelist.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.rule_action is not None:
            result['RuleAction'] = self.rule_action
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_switch is not None:
            result['RuleSwitch'] = self.rule_switch
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        result['Scope'] = []
        if self.scope is not None:
            for k in self.scope:
                result['Scope'].append(k.to_map() if k else None)
        if self.whitelist is not None:
            result['Whitelist'] = self.whitelist.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RuleAction') is not None:
            self.rule_action = m.get('RuleAction')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleSwitch') is not None:
            self.rule_switch = m.get('RuleSwitch')
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        self.scope = []
        if m.get('Scope') is not None:
            for k in m.get('Scope'):
                temp_model = AddContainerDefenseRuleRequestScope()
                self.scope.append(temp_model.from_map(k))
        if m.get('Whitelist') is not None:
            temp_model = AddContainerDefenseRuleRequestWhitelist()
            self.whitelist = temp_model.from_map(m['Whitelist'])
        return self


class AddContainerDefenseRuleShrinkRequestScope(TeaModel):
    def __init__(
        self,
        all_namespace: int = None,
        cluster_id: str = None,
        namespaces: List[str] = None,
    ):
        # Specifies whether to include all namespaces. Valid values:
        # 
        # *   **0**: You can use the Namespaces parameter to specify the namespaces to include.
        # *   **1**: All namespaces are included.
        self.all_namespace = all_namespace
        # The ID of the cluster.
        # 
        # >  You can call the [DescribeGroupedContainerInstances](https://help.aliyun.com/document_detail/182997.html) operation to query the IDs of clusters.
        self.cluster_id = cluster_id
        # The namespaces to include.
        self.namespaces = namespaces

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_namespace is not None:
            result['AllNamespace'] = self.all_namespace
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.namespaces is not None:
            result['Namespaces'] = self.namespaces
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllNamespace') is not None:
            self.all_namespace = m.get('AllNamespace')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Namespaces') is not None:
            self.namespaces = m.get('Namespaces')
        return self


class AddContainerDefenseRuleShrinkRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        rule_action: int = None,
        rule_id: int = None,
        rule_name: str = None,
        rule_switch: int = None,
        rule_type: int = None,
        scope: List[AddContainerDefenseRuleShrinkRequestScope] = None,
        whitelist_shrink: str = None,
    ):
        # The description of the rule.
        self.description = description
        # The action that is performed when the rule is hit. Valid values:
        # 
        # *   **1**: alert
        # *   **2**: block
        self.rule_action = rule_action
        # The ID of the rule. You do not need to manually specify the ID.
        self.rule_id = rule_id
        # The name of the rule.
        self.rule_name = rule_name
        # The switch of the rule. Valid values:
        # 
        # *   **0**: off
        # *   **1**: on
        self.rule_switch = rule_switch
        # The rule type. Valid values:
        # 
        # *   2: user-defined rules
        # 
        # > Only the value 2 is supported.
        self.rule_type = rule_type
        # The scope.
        self.scope = scope
        # The whitelist.
        self.whitelist_shrink = whitelist_shrink

    def validate(self):
        if self.scope:
            for k in self.scope:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.rule_action is not None:
            result['RuleAction'] = self.rule_action
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_switch is not None:
            result['RuleSwitch'] = self.rule_switch
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        result['Scope'] = []
        if self.scope is not None:
            for k in self.scope:
                result['Scope'].append(k.to_map() if k else None)
        if self.whitelist_shrink is not None:
            result['Whitelist'] = self.whitelist_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RuleAction') is not None:
            self.rule_action = m.get('RuleAction')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleSwitch') is not None:
            self.rule_switch = m.get('RuleSwitch')
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        self.scope = []
        if m.get('Scope') is not None:
            for k in m.get('Scope'):
                temp_model = AddContainerDefenseRuleShrinkRequestScope()
                self.scope.append(temp_model.from_map(k))
        if m.get('Whitelist') is not None:
            self.whitelist_shrink = m.get('Whitelist')
        return self


class AddContainerDefenseRuleResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: int = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The ID of the rule that is created.
        self.data = data
        # The HTTP status code that is returned.
        self.http_status_code = http_status_code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddContainerDefenseRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddContainerDefenseRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddContainerDefenseRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddContainerPluginRuleRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        mode: int = None,
        rule_name: str = None,
        rule_template_id: int = None,
        rule_type: int = None,
        selected_policy: List[str] = None,
        white_images: List[str] = None,
    ):
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The action that you want to specify for the rule. Valid values:
        # 
        # *   **1**: triggers alerts.
        # *   **2**: blocks escapes.
        # 
        # This parameter is required.
        self.mode = mode
        # The name of the rule. The name must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), and underscores (_). The names of rules that are created for the same user must be unique.
        # 
        # This parameter is required.
        self.rule_name = rule_name
        # The ID of the rule template. You can call the ListSystemClientRules operation to query the ID of the rule template.
        # 
        # This parameter is required.
        self.rule_template_id = rule_template_id
        # The type of the rule. Valid values:
        # 
        # *   **0**: custom rule
        # *   **1**: system rule
        self.rule_type = rule_type
        # The check items that are enabled for the rule.
        # 
        # This parameter is required.
        self.selected_policy = selected_policy
        # The images that are added to the whitelist.
        self.white_images = white_images

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_template_id is not None:
            result['RuleTemplateId'] = self.rule_template_id
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        if self.selected_policy is not None:
            result['SelectedPolicy'] = self.selected_policy
        if self.white_images is not None:
            result['WhiteImages'] = self.white_images
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleTemplateId') is not None:
            self.rule_template_id = m.get('RuleTemplateId')
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        if m.get('SelectedPolicy') is not None:
            self.selected_policy = m.get('SelectedPolicy')
        if m.get('WhiteImages') is not None:
            self.white_images = m.get('WhiteImages')
        return self


class AddContainerPluginRuleResponseBodyData(TeaModel):
    def __init__(
        self,
        rule_id: int = None,
        rule_name: str = None,
        switch_id: str = None,
    ):
        # The ID of the rule.
        self.rule_id = rule_id
        # The name of the rule.
        self.rule_name = rule_name
        # The ID of the switch.
        self.switch_id = switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.switch_id is not None:
            result['SwitchId'] = self.switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SwitchId') is not None:
            self.switch_id = m.get('SwitchId')
        return self


class AddContainerPluginRuleResponseBody(TeaModel):
    def __init__(
        self,
        data: AddContainerPluginRuleResponseBodyData = None,
        request_id: str = None,
    ):
        # The data returned.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = AddContainerPluginRuleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddContainerPluginRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddContainerPluginRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddContainerPluginRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddIdcProbeRequest(TeaModel):
    def __init__(
        self,
        idc_name: str = None,
        idc_region: str = None,
        interval_period: int = None,
        ip_segments: str = None,
        linux_port: str = None,
        period_unit: str = None,
        uuids: str = None,
        win_port: str = None,
    ):
        # The name of the data center.
        # 
        # This parameter is required.
        self.idc_name = idc_name
        # The region ID.
        # 
        # This parameter is required.
        self.idc_region = idc_region
        # The scan interval.
        # 
        # This parameter is required.
        self.interval_period = interval_period
        # The settings of the CIDR block.
        # 
        # This parameter is required.
        self.ip_segments = ip_segments
        # The Linux port.
        # 
        # This parameter is required.
        self.linux_port = linux_port
        # The unit of the scan interval. Valid values:
        # 
        # *   **day**\
        # *   **hour**\
        # 
        # This parameter is required.
        self.period_unit = period_unit
        # The UUID of the server. Separate multiple UUIDs with commas (,).
        # 
        # >  You can call the [DescribeCloudCenterInstances](~~DescribeCloudCenterInstances~~) operation to query the UUID.
        # 
        # This parameter is required.
        self.uuids = uuids
        # The Windows port.
        # 
        # This parameter is required.
        self.win_port = win_port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.idc_name is not None:
            result['IdcName'] = self.idc_name
        if self.idc_region is not None:
            result['IdcRegion'] = self.idc_region
        if self.interval_period is not None:
            result['IntervalPeriod'] = self.interval_period
        if self.ip_segments is not None:
            result['IpSegments'] = self.ip_segments
        if self.linux_port is not None:
            result['LinuxPort'] = self.linux_port
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        if self.win_port is not None:
            result['WinPort'] = self.win_port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdcName') is not None:
            self.idc_name = m.get('IdcName')
        if m.get('IdcRegion') is not None:
            self.idc_region = m.get('IdcRegion')
        if m.get('IntervalPeriod') is not None:
            self.interval_period = m.get('IntervalPeriod')
        if m.get('IpSegments') is not None:
            self.ip_segments = m.get('IpSegments')
        if m.get('LinuxPort') is not None:
            self.linux_port = m.get('LinuxPort')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        if m.get('WinPort') is not None:
            self.win_port = m.get('WinPort')
        return self


class AddIdcProbeResponseBodyAddIdcProbeFailedList(TeaModel):
    def __init__(
        self,
        error_msg: str = None,
        idc_name: str = None,
        idc_region: str = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        ip_segments: str = None,
        uuid: str = None,
    ):
        # The error message that is returned.
        self.error_msg = error_msg
        # The name of the data center.
        self.idc_name = idc_name
        # The region ID.
        self.idc_region = idc_region
        # The ID of the server.
        self.instance_id = instance_id
        # The name of the server.
        self.instance_name = instance_name
        # The public IP address of the server.
        self.internet_ip = internet_ip
        # The private IP address.
        self.intranet_ip = intranet_ip
        # The settings of the CIDR block.
        self.ip_segments = ip_segments
        # The UUID of the server. Multiple UUIDs are separated by commas (,).
        # 
        # >  You can call the [DescribeCloudCenterInstances](~~DescribeCloudCenterInstances~~) operation to query the UUID.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_msg is not None:
            result['ErrorMsg'] = self.error_msg
        if self.idc_name is not None:
            result['IdcName'] = self.idc_name
        if self.idc_region is not None:
            result['IdcRegion'] = self.idc_region
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip_segments is not None:
            result['IpSegments'] = self.ip_segments
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMsg') is not None:
            self.error_msg = m.get('ErrorMsg')
        if m.get('IdcName') is not None:
            self.idc_name = m.get('IdcName')
        if m.get('IdcRegion') is not None:
            self.idc_region = m.get('IdcRegion')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('IpSegments') is not None:
            self.ip_segments = m.get('IpSegments')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class AddIdcProbeResponseBody(TeaModel):
    def __init__(
        self,
        add_idc_probe_failed_list: List[AddIdcProbeResponseBodyAddIdcProbeFailedList] = None,
        count: str = None,
        request_id: str = None,
    ):
        # The records of failure.
        self.add_idc_probe_failed_list = add_idc_probe_failed_list
        # The total number of entries returned.
        self.count = count
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.add_idc_probe_failed_list:
            for k in self.add_idc_probe_failed_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AddIdcProbeFailedList'] = []
        if self.add_idc_probe_failed_list is not None:
            for k in self.add_idc_probe_failed_list:
                result['AddIdcProbeFailedList'].append(k.to_map() if k else None)
        if self.count is not None:
            result['Count'] = self.count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.add_idc_probe_failed_list = []
        if m.get('AddIdcProbeFailedList') is not None:
            for k in m.get('AddIdcProbeFailedList'):
                temp_model = AddIdcProbeResponseBodyAddIdcProbeFailedList()
                self.add_idc_probe_failed_list.append(temp_model.from_map(k))
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddIdcProbeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddIdcProbeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddIdcProbeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddImageEventOperationRequest(TeaModel):
    def __init__(
        self,
        conditions: str = None,
        event_key: str = None,
        event_name: str = None,
        event_type: str = None,
        note: str = None,
        operation_code: str = None,
        scenarios: str = None,
        source: str = None,
    ):
        # The rule conditions. The value is in the JSON format. Valid values of keys:
        # 
        # *   **condition**: the matching condition.
        # *   **type**: the matching type.
        # *   **value**: the matching value.
        self.conditions = conditions
        # The keyword of the alert item.
        self.event_key = event_key
        # The name of the alert item.
        self.event_name = event_name
        # The alert type.
        # 
        # *   Set the value to **sensitiveFile**.
        self.event_type = event_type
        # The remarks that you want to add.
        self.note = note
        # The operation code.
        # 
        # *   Set the value to **whitelist** to add the alert item to the whitelist.
        self.operation_code = operation_code
        # The application scope of the rule. The value is in the JSON format. Valid values of keys:
        # 
        # *   **type**\
        # *   **value**\
        self.scenarios = scenarios
        # The source of the whitelist. Valid values:
        # 
        # *   **image**: image.
        # *   **agentless**: agentless detection.
        self.source = source

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conditions is not None:
            result['Conditions'] = self.conditions
        if self.event_key is not None:
            result['EventKey'] = self.event_key
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.note is not None:
            result['Note'] = self.note
        if self.operation_code is not None:
            result['OperationCode'] = self.operation_code
        if self.scenarios is not None:
            result['Scenarios'] = self.scenarios
        if self.source is not None:
            result['Source'] = self.source
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Conditions') is not None:
            self.conditions = m.get('Conditions')
        if m.get('EventKey') is not None:
            self.event_key = m.get('EventKey')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('Note') is not None:
            self.note = m.get('Note')
        if m.get('OperationCode') is not None:
            self.operation_code = m.get('OperationCode')
        if m.get('Scenarios') is not None:
            self.scenarios = m.get('Scenarios')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        return self


class AddImageEventOperationResponseBodyData(TeaModel):
    def __init__(
        self,
        conditions: str = None,
        event_key: str = None,
        event_name: str = None,
        event_type: str = None,
        id: int = None,
        operation_code: str = None,
        scenarios: str = None,
    ):
        # The rule conditions. The value is in the JSON format. Valid values of keys:
        # 
        # *   **condition**: the matching condition.
        # *   **type**: the matching type.
        # *   **value**: the matching value.
        self.conditions = conditions
        # The keyword of the alert item.
        self.event_key = event_key
        # The name of the alert item.
        self.event_name = event_name
        # The alert type.
        # 
        # *   Only **sensitiveFile** may be returned.
        self.event_type = event_type
        # The primary key of the alert handling rule.
        self.id = id
        # The operation code.
        # 
        # *   Only **whitelist** may be returned, which indicates that the alert item is added to the whitelist.
        self.operation_code = operation_code
        # The application scope of the rule. The value is in the JSON format. Valid values of keys:
        # 
        # *   **type**\
        # *   **value**\
        self.scenarios = scenarios

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conditions is not None:
            result['Conditions'] = self.conditions
        if self.event_key is not None:
            result['EventKey'] = self.event_key
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.id is not None:
            result['Id'] = self.id
        if self.operation_code is not None:
            result['OperationCode'] = self.operation_code
        if self.scenarios is not None:
            result['Scenarios'] = self.scenarios
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Conditions') is not None:
            self.conditions = m.get('Conditions')
        if m.get('EventKey') is not None:
            self.event_key = m.get('EventKey')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('OperationCode') is not None:
            self.operation_code = m.get('OperationCode')
        if m.get('Scenarios') is not None:
            self.scenarios = m.get('Scenarios')
        return self


class AddImageEventOperationResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: AddImageEventOperationResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code.
        self.code = code
        # The returned data.
        self.data = data
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AddImageEventOperationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddImageEventOperationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddImageEventOperationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddImageEventOperationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddImageVulWhiteListRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        reason: str = None,
        source: str = None,
        target: str = None,
        type: str = None,
        whitelist: str = None,
    ):
        # The language of the content within the request and response. Default value: zh. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The reason why you add the vulnerability to the whitelist.
        self.reason = reason
        # The source of the whitelist. Valid values:
        # - **image**\
        # - **agentless**\
        self.source = source
        # The object on which you want to perform the operation. The value of this parameter is in the JSON format and contains the following fields:
        # 
        # *   **type**: the object type. The value is fixed to repo.
        # *   **target**: the object content. The value is in the Namespace/Image repository format.
        self.target = target
        # The type of the vulnerability. Valid values:
        # 
        # *   **cve**: system vulnerability
        # *   **sca**: application vulnerability
        self.type = type
        # The whitelist. The value of this parameter is in the JSON format and contains the following fields:
        # 
        # *   **Type**: the vulnerability type. Valid values: cve and sca.
        # *   **Name**: the name of the vulnerability that is specified in Common Vulnerabilities and Exposures (CVE).
        # *   **AliasName**: the alias of the vulnerability that is specified in CVE.
        self.whitelist = whitelist

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.source is not None:
            result['Source'] = self.source
        if self.target is not None:
            result['Target'] = self.target
        if self.type is not None:
            result['Type'] = self.type
        if self.whitelist is not None:
            result['Whitelist'] = self.whitelist
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Whitelist') is not None:
            self.whitelist = m.get('Whitelist')
        return self


class AddImageVulWhiteListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. A value of **200** indicates that the request was successful. Other values indicate that the request failed. You can identify the cause of the failure based on the value of this parameter.
        self.code = code
        # Indicates whether the image vulnerability is added to the whitelist. Valid values:
        # 
        # *   **true**: The image vulnerability is added to the whitelist.
        # *   **false**: The image vulnerability is not added to the whitelist.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddImageVulWhiteListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddImageVulWhiteListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddImageVulWhiteListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddInstallCodeRequest(TeaModel):
    def __init__(
        self,
        expired_date: int = None,
        group_id: int = None,
        only_image: bool = None,
        os: str = None,
        private_link_id: int = None,
        proxy_cluster: str = None,
        vendor_name: str = None,
    ):
        # The validity period of the installation command. The value is a 13-digit timestamp.
        # 
        # >  The installation command is valid only within the validity period. An expired installation command cannot be used to install the Security Center agent.
        self.expired_date = expired_date
        # The ID of the asset group to which you want to add the asset.
        # 
        # > You can call the [DescribeAllGroups](~~DescribeAllGroups~~) operation to query the IDs of asset groups.
        self.group_id = group_id
        # Specifies whether to create an image. Default value: **false**. Valid values:
        # 
        # *   **false**: does not create an image.
        # *   **true**: creates an image.
        self.only_image = only_image
        # The operating system of the asset. Default value: **linux**. Valid values:
        # 
        # *   **linux**\
        # *   **windows**\
        self.os = os
        # The ID of the PrivateLink endpoint.
        self.private_link_id = private_link_id
        # The name of the proxy cluster.
        self.proxy_cluster = proxy_cluster
        # The name of the service provider for the asset. Default value: **ALIYUN**.
        # 
        # >  You can call the [DescribeVendorList](~~DescribeVendorList~~) operation to query the names of service providers.
        self.vendor_name = vendor_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expired_date is not None:
            result['ExpiredDate'] = self.expired_date
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.only_image is not None:
            result['OnlyImage'] = self.only_image
        if self.os is not None:
            result['Os'] = self.os
        if self.private_link_id is not None:
            result['PrivateLinkId'] = self.private_link_id
        if self.proxy_cluster is not None:
            result['ProxyCluster'] = self.proxy_cluster
        if self.vendor_name is not None:
            result['VendorName'] = self.vendor_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExpiredDate') is not None:
            self.expired_date = m.get('ExpiredDate')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('OnlyImage') is not None:
            self.only_image = m.get('OnlyImage')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('PrivateLinkId') is not None:
            self.private_link_id = m.get('PrivateLinkId')
        if m.get('ProxyCluster') is not None:
            self.proxy_cluster = m.get('ProxyCluster')
        if m.get('VendorName') is not None:
            self.vendor_name = m.get('VendorName')
        return self


class AddInstallCodeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddInstallCodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddInstallCodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddInstallCodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPrivateRegistryRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        extra_param: str = None,
        net_type: int = None,
        password: str = None,
        port: int = None,
        protocol_type: int = None,
        registry_host_ip: str = None,
        registry_region_id: str = None,
        registry_type: str = None,
        registry_version: str = None,
        trans_per_hour: int = None,
        user_name: str = None,
        vpc_id: str = None,
    ):
        # The domain name of the image repository.
        # 
        # This parameter is required.
        self.domain_name = domain_name
        # The additional parameter of the image repository. This parameter is required when you set the RegistryType parameter to **quay**. Valid values:
        # 
        # *   **namespace**\
        # *   **authToken**\
        self.extra_param = extra_param
        # The network type. Valid values:
        # 
        # *   **1**: Internet
        # *   **2**: virtual private cloud (VPC)
        # 
        # This parameter is required.
        self.net_type = net_type
        # The password that is used to log on to the image repository.
        # 
        # This parameter is required.
        self.password = password
        # The port number.
        self.port = port
        # The type of the protocol. Valid values:
        # 
        # *   **1**: HTTP
        # *   **2**: HTTPS
        # 
        # This parameter is required.
        self.protocol_type = protocol_type
        # The IP address of the image repository.
        # 
        # This parameter is required.
        self.registry_host_ip = registry_host_ip
        # The region ID.
        # 
        # >  You can call the [ListImageRegistryRegion](~~ListImageRegistryRegion~~) operation to query the IDs of supported regions.
        # 
        # This parameter is required.
        self.registry_region_id = registry_region_id
        # The type of the private image repository. Valid values:
        # 
        # *   **harbor**\
        # *   **quay**\
        # 
        # This parameter is required.
        self.registry_type = registry_type
        # The version of the image repository. Valid values:
        # 
        # *   **V1**\
        # *   **V2**\
        # 
        # This parameter is required.
        self.registry_version = registry_version
        # The number of images that are scanned per hour.
        self.trans_per_hour = trans_per_hour
        # The username that is used to log on to the image repository.
        # 
        # This parameter is required.
        self.user_name = user_name
        # The ID of the VPC.
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.extra_param is not None:
            result['ExtraParam'] = self.extra_param
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.password is not None:
            result['Password'] = self.password
        if self.port is not None:
            result['Port'] = self.port
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.registry_host_ip is not None:
            result['RegistryHostIp'] = self.registry_host_ip
        if self.registry_region_id is not None:
            result['RegistryRegionId'] = self.registry_region_id
        if self.registry_type is not None:
            result['RegistryType'] = self.registry_type
        if self.registry_version is not None:
            result['RegistryVersion'] = self.registry_version
        if self.trans_per_hour is not None:
            result['TransPerHour'] = self.trans_per_hour
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('ExtraParam') is not None:
            self.extra_param = m.get('ExtraParam')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RegistryHostIp') is not None:
            self.registry_host_ip = m.get('RegistryHostIp')
        if m.get('RegistryRegionId') is not None:
            self.registry_region_id = m.get('RegistryRegionId')
        if m.get('RegistryType') is not None:
            self.registry_type = m.get('RegistryType')
        if m.get('RegistryVersion') is not None:
            self.registry_version = m.get('RegistryVersion')
        if m.get('TransPerHour') is not None:
            self.trans_per_hour = m.get('TransPerHour')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class AddPrivateRegistryResponseBodyData(TeaModel):
    def __init__(
        self,
        ali_uid: int = None,
        domain_name: str = None,
        id: int = None,
        net_type: int = None,
        password: str = None,
        protocol_type: int = None,
        region_id: str = None,
        registry_host_ip: str = None,
        registry_type: str = None,
        registry_version: str = None,
        token: str = None,
        trans_per_hour: int = None,
        user_name: str = None,
        vpc_id: str = None,
    ):
        # The ID of the user.
        self.ali_uid = ali_uid
        # The domain name of the image repository.
        self.domain_name = domain_name
        # The ID of the image repository.
        self.id = id
        # The network type. Valid values:
        # 
        # *   **1**: Internet
        # *   **2**: VPC
        self.net_type = net_type
        # The password.
        self.password = password
        # The type of the protocol. Valid values:
        # 
        # *   **1**: HTTP
        # *   **2**: HTTPS
        self.protocol_type = protocol_type
        # The region ID of the image repository.
        self.region_id = region_id
        # The IP address of the image repository.
        self.registry_host_ip = registry_host_ip
        # The type of the image repository. Valid values:
        # 
        # *   **harbor**\
        # *   **quay**\
        self.registry_type = registry_type
        # The version of the image repository. Default value: -. Valid values:
        # 
        # *   **-**: the default version
        # *   **V1**\
        # *   **V2**\
        self.registry_version = registry_version
        # The value of the token.
        self.token = token
        # The number of scan tasks that are performed per hour.
        self.trans_per_hour = trans_per_hour
        # The username.
        self.user_name = user_name
        # The ID of the VPC.
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.id is not None:
            result['Id'] = self.id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.password is not None:
            result['Password'] = self.password
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.registry_host_ip is not None:
            result['RegistryHostIp'] = self.registry_host_ip
        if self.registry_type is not None:
            result['RegistryType'] = self.registry_type
        if self.registry_version is not None:
            result['RegistryVersion'] = self.registry_version
        if self.token is not None:
            result['Token'] = self.token
        if self.trans_per_hour is not None:
            result['TransPerHour'] = self.trans_per_hour
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegistryHostIp') is not None:
            self.registry_host_ip = m.get('RegistryHostIp')
        if m.get('RegistryType') is not None:
            self.registry_type = m.get('RegistryType')
        if m.get('RegistryVersion') is not None:
            self.registry_version = m.get('RegistryVersion')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        if m.get('TransPerHour') is not None:
            self.trans_per_hour = m.get('TransPerHour')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class AddPrivateRegistryResponseBody(TeaModel):
    def __init__(
        self,
        data: AddPrivateRegistryResponseBodyData = None,
        request_id: str = None,
    ):
        # The handling result.
        self.data = data
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = AddPrivateRegistryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddPrivateRegistryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddPrivateRegistryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddPrivateRegistryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddProtectVpcListRequest(TeaModel):
    def __init__(
        self,
        add_vpc_instance_id_list: str = None,
        del_vpc_instance_id_list: str = None,
    ):
        # Collection of new VPC instance IDs.
        # > Call the [DescribeVpcList](~~DescribeVpcList~~) interface to obtain this parameter.
        self.add_vpc_instance_id_list = add_vpc_instance_id_list
        # Collection of VPC instance IDs to be deleted.
        # > Call the [DescribeVpcList](~~DescribeVpcList~~) interface to obtain this parameter.
        self.del_vpc_instance_id_list = del_vpc_instance_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_vpc_instance_id_list is not None:
            result['AddVpcInstanceIdList'] = self.add_vpc_instance_id_list
        if self.del_vpc_instance_id_list is not None:
            result['DelVpcInstanceIdList'] = self.del_vpc_instance_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddVpcInstanceIdList') is not None:
            self.add_vpc_instance_id_list = m.get('AddVpcInstanceIdList')
        if m.get('DelVpcInstanceIdList') is not None:
            self.del_vpc_instance_id_list = m.get('DelVpcInstanceIdList')
        return self


class AddProtectVpcListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of this request, which is a unique identifier generated by Alibaba Cloud for this request and can be used for troubleshooting and problem localization.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddProtectVpcListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddProtectVpcListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddProtectVpcListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPublishBatchRequest(TeaModel):
    def __init__(
        self,
        batch_name: str = None,
        interval: int = None,
        operation_base: int = None,
        upgrade_version: str = None,
    ):
        # The name of the release batch.
        # 
        # This parameter is required.
        self.batch_name = batch_name
        # The interval between two release batches.
        # 
        # This parameter is required.
        self.interval = interval
        # The dimension based on which the asset is selected. Valid values:
        # 
        # *   **0**: selects the asset by instance.
        # *   **1**: selects the asset by machine group.
        # *   **2**: selects the asset by the ID of the instance that is deployed in the virtual private cloud (VPC).
        self.operation_base = operation_base
        # The version to which you want to upgrade the agent.
        # 
        # This parameter is required.
        self.upgrade_version = upgrade_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_name is not None:
            result['BatchName'] = self.batch_name
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.operation_base is not None:
            result['OperationBase'] = self.operation_base
        if self.upgrade_version is not None:
            result['UpgradeVersion'] = self.upgrade_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BatchName') is not None:
            self.batch_name = m.get('BatchName')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OperationBase') is not None:
            self.operation_base = m.get('OperationBase')
        if m.get('UpgradeVersion') is not None:
            self.upgrade_version = m.get('UpgradeVersion')
        return self


class AddPublishBatchResponseBody(TeaModel):
    def __init__(
        self,
        batch_id: int = None,
        request_id: str = None,
    ):
        # The ID of the release batch.
        self.batch_id = batch_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_id is not None:
            result['BatchId'] = self.batch_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BatchId') is not None:
            self.batch_id = m.get('BatchId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddPublishBatchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddPublishBatchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddPublishBatchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddSasContainerWebDefenseRuleRequestPathConfDTOList(TeaModel):
    def __init__(
        self,
        backup_path: str = None,
        defense_mode: str = None,
        defense_path: str = None,
        exclude_file: str = None,
        exclude_file_path: str = None,
        exclude_file_type: str = None,
        guard_type: int = None,
        include_file: str = None,
        include_file_type: str = None,
        process_path_list: List[str] = None,
    ):
        # The backup path.
        self.backup_path = backup_path
        # The prevention mode. Valid values:
        # 
        # *   **block**\
        # *   **audit**\
        self.defense_mode = defense_mode
        # The path that you want to protect.
        # 
        # This parameter is required.
        self.defense_path = defense_path
        # The file that you want to exclude.
        self.exclude_file = exclude_file
        # The path to the file that you want to exclude.
        self.exclude_file_path = exclude_file_path
        # The type of the file that you want to exclude.
        self.exclude_file_type = exclude_file_type
        # The protecion mode. Valid values:
        # 
        # *   **0**: basic mode (whitelist)
        # *   **1**: complex mode (blacklist)
        # 
        # This parameter is required.
        self.guard_type = guard_type
        # The file that you want to include.
        self.include_file = include_file
        # The type of the file that you want to include.
        self.include_file_type = include_file_type
        # The processes that you want to add to the whitelist.
        # 
        # This parameter is required.
        self.process_path_list = process_path_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_path is not None:
            result['BackupPath'] = self.backup_path
        if self.defense_mode is not None:
            result['DefenseMode'] = self.defense_mode
        if self.defense_path is not None:
            result['DefensePath'] = self.defense_path
        if self.exclude_file is not None:
            result['ExcludeFile'] = self.exclude_file
        if self.exclude_file_path is not None:
            result['ExcludeFilePath'] = self.exclude_file_path
        if self.exclude_file_type is not None:
            result['ExcludeFileType'] = self.exclude_file_type
        if self.guard_type is not None:
            result['GuardType'] = self.guard_type
        if self.include_file is not None:
            result['IncludeFile'] = self.include_file
        if self.include_file_type is not None:
            result['IncludeFileType'] = self.include_file_type
        if self.process_path_list is not None:
            result['ProcessPathList'] = self.process_path_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupPath') is not None:
            self.backup_path = m.get('BackupPath')
        if m.get('DefenseMode') is not None:
            self.defense_mode = m.get('DefenseMode')
        if m.get('DefensePath') is not None:
            self.defense_path = m.get('DefensePath')
        if m.get('ExcludeFile') is not None:
            self.exclude_file = m.get('ExcludeFile')
        if m.get('ExcludeFilePath') is not None:
            self.exclude_file_path = m.get('ExcludeFilePath')
        if m.get('ExcludeFileType') is not None:
            self.exclude_file_type = m.get('ExcludeFileType')
        if m.get('GuardType') is not None:
            self.guard_type = m.get('GuardType')
        if m.get('IncludeFile') is not None:
            self.include_file = m.get('IncludeFile')
        if m.get('IncludeFileType') is not None:
            self.include_file_type = m.get('IncludeFileType')
        if m.get('ProcessPathList') is not None:
            self.process_path_list = m.get('ProcessPathList')
        return self


class AddSasContainerWebDefenseRuleRequest(TeaModel):
    def __init__(
        self,
        path_conf_dtolist: List[AddSasContainerWebDefenseRuleRequestPathConfDTOList] = None,
        rule_name: str = None,
    ):
        # The paths that you want to protect.
        self.path_conf_dtolist = path_conf_dtolist
        # The name of the rule.
        self.rule_name = rule_name

    def validate(self):
        if self.path_conf_dtolist:
            for k in self.path_conf_dtolist:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PathConfDTOList'] = []
        if self.path_conf_dtolist is not None:
            for k in self.path_conf_dtolist:
                result['PathConfDTOList'].append(k.to_map() if k else None)
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.path_conf_dtolist = []
        if m.get('PathConfDTOList') is not None:
            for k in m.get('PathConfDTOList'):
                temp_model = AddSasContainerWebDefenseRuleRequestPathConfDTOList()
                self.path_conf_dtolist.append(temp_model.from_map(k))
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        return self


class AddSasContainerWebDefenseRuleResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        request_id: str = None,
    ):
        # The unique value of the created rule.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddSasContainerWebDefenseRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddSasContainerWebDefenseRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddSasContainerWebDefenseRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddSasModuleTrialRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        module_code: str = None,
    ):
        # The language of the content within the request and response. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The code of the feature. Valid values:
        # 
        # *   **vulFix**: vulnerability fixing.
        # *   **cloudSiem**: threat analysis and response.
        self.module_code = module_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.module_code is not None:
            result['ModuleCode'] = self.module_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ModuleCode') is not None:
            self.module_code = m.get('ModuleCode')
        return self


class AddSasModuleTrialResponseBodyDataTrialRecordList(TeaModel):
    def __init__(
        self,
        auth_limit: int = None,
        auth_limit_list: str = None,
        gmt_end: int = None,
        gmt_start: int = None,
        module_code: str = None,
        status: int = None,
    ):
        # The quota.
        self.auth_limit = auth_limit
        # The list of quotas. This parameter is available if the value of the ModuleCode parameter is cloudSiem. The value of this parameter consists of the log storage capacity for the threat analysis and response feature and the log data to add. Units: GB and GB-day.
        self.auth_limit_list = auth_limit_list
        # The end time of the trial use.
        self.gmt_end = gmt_end
        # The start time of the trial use.
        self.gmt_start = gmt_start
        # The code of the feature. Valid values:
        # 
        # *   **vulFix**: vulnerability fixing.
        # *   **cloudSiem**: threat analysis and response.
        self.module_code = module_code
        # The status of the trial use. Valid values:
        # 
        # *   **1**: The feature is in trial use.
        # *   **0**: The trial use ends.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_limit is not None:
            result['AuthLimit'] = self.auth_limit
        if self.auth_limit_list is not None:
            result['AuthLimitList'] = self.auth_limit_list
        if self.gmt_end is not None:
            result['GmtEnd'] = self.gmt_end
        if self.gmt_start is not None:
            result['GmtStart'] = self.gmt_start
        if self.module_code is not None:
            result['ModuleCode'] = self.module_code
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthLimit') is not None:
            self.auth_limit = m.get('AuthLimit')
        if m.get('AuthLimitList') is not None:
            self.auth_limit_list = m.get('AuthLimitList')
        if m.get('GmtEnd') is not None:
            self.gmt_end = m.get('GmtEnd')
        if m.get('GmtStart') is not None:
            self.gmt_start = m.get('GmtStart')
        if m.get('ModuleCode') is not None:
            self.module_code = m.get('ModuleCode')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class AddSasModuleTrialResponseBodyData(TeaModel):
    def __init__(
        self,
        trial_record_list: List[AddSasModuleTrialResponseBodyDataTrialRecordList] = None,
    ):
        # The information about the trial use.
        self.trial_record_list = trial_record_list

    def validate(self):
        if self.trial_record_list:
            for k in self.trial_record_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TrialRecordList'] = []
        if self.trial_record_list is not None:
            for k in self.trial_record_list:
                result['TrialRecordList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.trial_record_list = []
        if m.get('TrialRecordList') is not None:
            for k in m.get('TrialRecordList'):
                temp_model = AddSasModuleTrialResponseBodyDataTrialRecordList()
                self.trial_record_list.append(temp_model.from_map(k))
        return self


class AddSasModuleTrialResponseBody(TeaModel):
    def __init__(
        self,
        data: AddSasModuleTrialResponseBodyData = None,
        request_id: str = None,
    ):
        # The data returned.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = AddSasModuleTrialResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddSasModuleTrialResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddSasModuleTrialResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddSasModuleTrialResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddTagWithUuidRequest(TeaModel):
    def __init__(
        self,
        tag_name: str = None,
        uuid_list: str = None,
    ):
        # The name of the tag.
        # 
        # This parameter is required.
        self.tag_name = tag_name
        # The UUIDs of the servers. Separate multiple UUIDs with commas (,).
        # 
        # > You can call the [DescribeCloudCenterInstances](~~DescribeCloudCenterInstances~~) operation to query the UUIDs of servers.
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class AddTagWithUuidResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddTagWithUuidResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddTagWithUuidResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddTagWithUuidResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddUninstallClientsByUuidsRequest(TeaModel):
    def __init__(
        self,
        call_method: str = None,
        feedback: str = None,
        region: str = None,
        source_ip: str = None,
        uuids: str = None,
    ):
        # The method name. Default value: init.
        self.call_method = call_method
        # The feedback.
        self.feedback = feedback
        # The region in which the server resides.
        self.region = region
        # The source IP address of the request. You do not need to specify this parameter. It is automatically obtained by the system.
        self.source_ip = source_ip
        # The UUID of the server that you want to unbind. Separate multiple UUIDs with commas (,).
        # 
        # >  You can call the [DescribeCloudCenterInstances](https://help.aliyun.com/document_detail/141932.html) operation to query the UUIDs of servers.
        # 
        # This parameter is required.
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_method is not None:
            result['CallMethod'] = self.call_method
        if self.feedback is not None:
            result['Feedback'] = self.feedback
        if self.region is not None:
            result['Region'] = self.region
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallMethod') is not None:
            self.call_method = m.get('CallMethod')
        if m.get('Feedback') is not None:
            self.feedback = m.get('Feedback')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class AddUninstallClientsByUuidsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddUninstallClientsByUuidsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddUninstallClientsByUuidsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddUninstallClientsByUuidsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddVpcHoneyPotRequest(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
    ):
        # The ID of the virtual private cloud (VPC) in which you want to create a honeypot.
        # 
        # > You can call the [DescribeVpcList](~~DescribeVpcList~~) operation to obtain the VPC ID. The VPC ID is the value of the InstanceId parameter.
        # 
        # This parameter is required.
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class AddVpcHoneyPotResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddVpcHoneyPotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddVpcHoneyPotResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddVpcHoneyPotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AdvanceSecurityEventOperationsRequest(TeaModel):
    def __init__(
        self,
        event_name: str = None,
        event_type: str = None,
        resource_owner_id: int = None,
        rule_id: int = None,
    ):
        # The alert name.
        self.event_name = event_name
        # The alert event type. Valid values:
        # 
        # *   Suspicious process
        # *   Webshell
        # *   Unusual logon
        # *   Exception
        # *   Sensitive file tampering
        # *   Malicious process (cloud threat detection)
        # *   Unusual network connection
        # *   Abnormal account
        # *   Application intrusion event
        # *   Cloud threat detection
        # *   Precision defense
        # *   Application whitelist
        # *   Persistent webshell
        # *   Web application threat detection
        # *   Malicious script
        # *   Threat intelligence
        # *   Malicious network activity
        # *   Cluster exception
        # *   Webshell (on-premises threat detection)
        # *   Vulnerability exploitation
        # *   Malicious process (on-premises threat detection)
        # *   Trusted exception
        # *   Others
        # 
        # For more information about alert types, see [Alerts](https://help.aliyun.com/document_detail/68388.html).
        self.event_type = event_type
        self.resource_owner_id = resource_owner_id
        # The rule ID.
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkField(TeaModel):
    def __init__(
        self,
        filed_alias_name: str = None,
        filed_name: str = None,
        mark_mis_type: str = None,
        mark_mis_value: str = None,
        supported_mis_type: List[str] = None,
    ):
        # The alias of the field that is used in the whitelist rule.
        self.filed_alias_name = filed_alias_name
        # The field that is used in the whitelist rule.
        self.filed_name = filed_name
        # The operation that is used in the whitelist rule. Valid values:
        # 
        # *   **contains**: contains
        # *   **notContains**: does not contain
        # *   **regex**: regular expression
        # *   **strEqual**: equals
        # *   **strNotEqual**: does not equal
        self.mark_mis_type = mark_mis_type
        # The value of the field that is used in the whitelist rule.
        self.mark_mis_value = mark_mis_value
        # The operation that is used and can be modified in the whitelist rule. Valid values:
        # 
        # *   **contains**: contains
        # *   **notContains**: does not contain
        # *   **regex**: regular expression
        # *   **strEqual**: equals
        # *   **strNotEqual**: does not equal
        self.supported_mis_type = supported_mis_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.filed_alias_name is not None:
            result['FiledAliasName'] = self.filed_alias_name
        if self.filed_name is not None:
            result['FiledName'] = self.filed_name
        if self.mark_mis_type is not None:
            result['MarkMisType'] = self.mark_mis_type
        if self.mark_mis_value is not None:
            result['MarkMisValue'] = self.mark_mis_value
        if self.supported_mis_type is not None:
            result['SupportedMisType'] = self.supported_mis_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FiledAliasName') is not None:
            self.filed_alias_name = m.get('FiledAliasName')
        if m.get('FiledName') is not None:
            self.filed_name = m.get('FiledName')
        if m.get('MarkMisType') is not None:
            self.mark_mis_type = m.get('MarkMisType')
        if m.get('MarkMisValue') is not None:
            self.mark_mis_value = m.get('MarkMisValue')
        if m.get('SupportedMisType') is not None:
            self.supported_mis_type = m.get('SupportedMisType')
        return self


class AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkFieldsSource(TeaModel):
    def __init__(
        self,
        filed_alias_name: str = None,
        filed_name: str = None,
        mark_mis_value: str = None,
        supported_mis_type: List[str] = None,
    ):
        # The alias of the field that can be used in the whitelist rule.
        self.filed_alias_name = filed_alias_name
        # The field that can be used in the whitelist rule.
        self.filed_name = filed_name
        # The value of the field that can be used in the whitelist rule.
        self.mark_mis_value = mark_mis_value
        # The operation that is supported in the whitelist rule. Valid values:
        # 
        # *   **contains**: contains
        # *   **notContains**: does not contain
        # *   **regex**: regular expression
        # *   **strEqual**: equals
        # *   **strNotEqual**: does not equal
        self.supported_mis_type = supported_mis_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.filed_alias_name is not None:
            result['FiledAliasName'] = self.filed_alias_name
        if self.filed_name is not None:
            result['FiledName'] = self.filed_name
        if self.mark_mis_value is not None:
            result['MarkMisValue'] = self.mark_mis_value
        if self.supported_mis_type is not None:
            result['SupportedMisType'] = self.supported_mis_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FiledAliasName') is not None:
            self.filed_alias_name = m.get('FiledAliasName')
        if m.get('FiledName') is not None:
            self.filed_name = m.get('FiledName')
        if m.get('MarkMisValue') is not None:
            self.mark_mis_value = m.get('MarkMisValue')
        if m.get('SupportedMisType') is not None:
            self.supported_mis_type = m.get('SupportedMisType')
        return self


class AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponse(TeaModel):
    def __init__(
        self,
        mark_field: List[AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkField] = None,
        mark_fields_source: List[AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkFieldsSource] = None,
        operation_code: str = None,
        operation_params: str = None,
        user_can_operate: bool = None,
    ):
        # The object on which the operation is performed. This parameter is required when you set the OperationCode parameter to **advance_mark_mis_info**.
        self.mark_field = mark_field
        # The metadata configuration returned by the advanced whitelist rule.
        self.mark_fields_source = mark_fields_source
        # The operation performed to handle the alert. Valid values:
        # 
        # *   **block_ip**: blocks the alert.
        # *   **advance_mark_mis_info**: adds the alert to the whitelist.
        # *   **ignore**: ignores the alert.
        # *   **manual_handled**: marks the alert as manually handled.
        # *   **kill_process**: terminates the malicious process.
        # *   **cleanup**: performs in-depth virus detection and removal.
        # *   **kill_and_quara**: performs virus detection and removal.
        # *   **disable_malicious_defense**: turns off malicious defense behavior.
        # *   **client_problem_check**: performs troubleshooting.
        # *   **quara**: performs quarantine operations.
        self.operation_code = operation_code
        # The configuration of the operation performed to handle the alert event.
        self.operation_params = operation_params
        # Indicates whether the operation can be performed.
        # 
        # *   **true**: The operation can be performed.
        # *   **false**: The operation cannot be performed.
        self.user_can_operate = user_can_operate

    def validate(self):
        if self.mark_field:
            for k in self.mark_field:
                if k:
                    k.validate()
        if self.mark_fields_source:
            for k in self.mark_fields_source:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MarkField'] = []
        if self.mark_field is not None:
            for k in self.mark_field:
                result['MarkField'].append(k.to_map() if k else None)
        result['MarkFieldsSource'] = []
        if self.mark_fields_source is not None:
            for k in self.mark_fields_source:
                result['MarkFieldsSource'].append(k.to_map() if k else None)
        if self.operation_code is not None:
            result['OperationCode'] = self.operation_code
        if self.operation_params is not None:
            result['OperationParams'] = self.operation_params
        if self.user_can_operate is not None:
            result['UserCanOperate'] = self.user_can_operate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.mark_field = []
        if m.get('MarkField') is not None:
            for k in m.get('MarkField'):
                temp_model = AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkField()
                self.mark_field.append(temp_model.from_map(k))
        self.mark_fields_source = []
        if m.get('MarkFieldsSource') is not None:
            for k in m.get('MarkFieldsSource'):
                temp_model = AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkFieldsSource()
                self.mark_fields_source.append(temp_model.from_map(k))
        if m.get('OperationCode') is not None:
            self.operation_code = m.get('OperationCode')
        if m.get('OperationParams') is not None:
            self.operation_params = m.get('OperationParams')
        if m.get('UserCanOperate') is not None:
            self.user_can_operate = m.get('UserCanOperate')
        return self


class AdvanceSecurityEventOperationsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        security_event_operations_response: List[AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponse] = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The operation performed on the alert event.
        self.security_event_operations_response = security_event_operations_response

    def validate(self):
        if self.security_event_operations_response:
            for k in self.security_event_operations_response:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SecurityEventOperationsResponse'] = []
        if self.security_event_operations_response is not None:
            for k in self.security_event_operations_response:
                result['SecurityEventOperationsResponse'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.security_event_operations_response = []
        if m.get('SecurityEventOperationsResponse') is not None:
            for k in m.get('SecurityEventOperationsResponse'):
                temp_model = AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponse()
                self.security_event_operations_response.append(temp_model.from_map(k))
        return self


class AdvanceSecurityEventOperationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AdvanceSecurityEventOperationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AdvanceSecurityEventOperationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCreateMaliciousNoteRequestImageMaliciousFileList(TeaModel):
    def __init__(
        self,
        event_id: int = None,
        note: str = None,
    ):
        # The ID of the alert.
        # 
        # >  You can call the [DescribeSuspEvents](~~DescribeSuspEvents~~) operation to query the alert IDs.
        self.event_id = event_id
        # The description.
        self.note = note

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.note is not None:
            result['Note'] = self.note
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('Note') is not None:
            self.note = m.get('Note')
        return self


class BatchCreateMaliciousNoteRequest(TeaModel):
    def __init__(
        self,
        image_malicious_file_list: List[BatchCreateMaliciousNoteRequestImageMaliciousFileList] = None,
    ):
        # The batches.
        self.image_malicious_file_list = image_malicious_file_list

    def validate(self):
        if self.image_malicious_file_list:
            for k in self.image_malicious_file_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ImageMaliciousFileList'] = []
        if self.image_malicious_file_list is not None:
            for k in self.image_malicious_file_list:
                result['ImageMaliciousFileList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.image_malicious_file_list = []
        if m.get('ImageMaliciousFileList') is not None:
            for k in m.get('ImageMaliciousFileList'):
                temp_model = BatchCreateMaliciousNoteRequestImageMaliciousFileList()
                self.image_malicious_file_list.append(temp_model.from_map(k))
        return self


class BatchCreateMaliciousNoteResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The HTTP status code.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the call is successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchCreateMaliciousNoteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchCreateMaliciousNoteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchCreateMaliciousNoteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchDeleteMaliciousFileWhitelistConfigRequest(TeaModel):
    def __init__(
        self,
        config_id_list: List[int] = None,
    ):
        # The IDs of the whitelist rules. You can call the [ListMaliciousFileWhitelistConfigs](~~ListMaliciousFileWhitelistConfigs~~) operation to query the IDs of whitelist rules.
        self.config_id_list = config_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id_list is not None:
            result['ConfigIdList'] = self.config_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigIdList') is not None:
            self.config_id_list = m.get('ConfigIdList')
        return self


class BatchDeleteMaliciousFileWhitelistConfigResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The HTTP status code. The status code 200 indicates that the request was successful.
        self.http_status_code = http_status_code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchDeleteMaliciousFileWhitelistConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchDeleteMaliciousFileWhitelistConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchDeleteMaliciousFileWhitelistConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchOperateCommonOverallConfigRequest(TeaModel):
    def __init__(
        self,
        config: str = None,
        type_list: List[str] = None,
    ):
        # The status of the feature. Valid values:
        # 
        # *   **on**: enabled
        # *   **off**: disabled
        # 
        # This parameter is required.
        self.config = config
        # The type of the feature in proactive defense. Valid values:
        # 
        # *   **kdump_switch**: Active defense experience optimization
        # *   **threat_detect**: Dynamic adaptive threat detection capability
        # *   **suspicious_aggregation**: Alert Association
        # *   **alidetect**: File Test
        # *   **USER-ENABLE-SWITCH-TYPE_38857**: Entrance service execution high-risk operation (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_50858**: Web service performs high-risk operations (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_50859**: Entrance service execution suspicious operation (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_50862**: Cloud Assistant Advanced Protection (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_50867**: Create malicious files (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_50868**: Create suspicious files (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_64025**: Ingress service execute command [enhanced mode] (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_51229**: Browser service execution a high-risk operation (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_51230**: Entrance service execution suspicious operation (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_51232**: System processes execution high-risk operations (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_51233**: Java service execution high-risk operations (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_51234**: Office components execution high-risk operations (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_51235**: Web service performs high-risk operations (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_52820**: Create malicious files (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_52826**: Entrance service execution high-risk operation (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_55251**: Database services execution high-risk operations (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_63725**: Ingress service implants suspicious script/binary file (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_3277**: Suspicious process startup (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_50983**: obfuscated command (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_51200**: Command line download and run malicious files (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_71131**: Ingress service executes sequence of suspicious behavior (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_51225**: Powershell executes high-risk commands (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_51226**: Powershell execute suspicious command (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_52821**: Suspicious process startup (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_57242**: Malicious command execution (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_57340**: Command line download and run malicious files (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_39659**: Sensitive Registry Key Protection (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_52816**: high-risk account manipulation behavior (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_54365**: Create service autorun item (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_54366**: Create high-risk autorun item (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_54367**: Create scheduled task autorun item (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_54368**: Create registry autorun item (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_54369**: Create WMI autorun item (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_50869**: Unauthorized execution of high-risk orders (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_53272**: Exploiting Kernel Vulnerabilities to Elevate Privileges (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_54395**: Unauthorized reading and writing of sensitive files (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_57897**: suspected privilege escalation (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_52825**: Unauthorized execution of high-risk orders (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_5507**: malicious drivers (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_50876**: Against security software (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_53168**: process debugging (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_54699**: Hijack dynamic link library (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_62981**: Bypassing security monitoring (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_52815**: Load high-risk drivers (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_52823**: Running high-risk ARK tools (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_54373**: Against security software (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_54374**: Intrusion trace cleanup (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_54265**: Hijacking the PAM Module (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_54953**: Hashdump Attack (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_54383**: MimiKatz Credential Stealing (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_54384**: Hashdump Attack (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_50861**: Information detection (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_52818**: Information detection (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_54034**: Intranet scan (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_51228**: High-risk lateral penetration tools (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_50870**: Rebound Shell (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_50873**: WebShell execute command
        # *   **USER-ENABLE-SWITCH-TYPE_51236**: Rebound Shell (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_50877**: Malicious soft communication (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_50884**: Suspicious worm script behavior (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_50885**: malicious script behavior (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_51201**: ransomware (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_51202**: Suspected Extortion (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE_52827**: ransomware (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_52828**: Suspected Extortion (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE_52829**: delete system backup behavior (Windows)
        # 
        # This parameter is required.
        self.type_list = type_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.type_list is not None:
            result['TypeList'] = self.type_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('TypeList') is not None:
            self.type_list = m.get('TypeList')
        return self


class BatchOperateCommonOverallConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchOperateCommonOverallConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchOperateCommonOverallConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchOperateCommonOverallConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchUpdateMaliciousFileWhitelistConfigRequestConfigList(TeaModel):
    def __init__(
        self,
        config_id: int = None,
        event_name: str = None,
        field: str = None,
        field_value: str = None,
        operator: str = None,
        source: str = None,
        target_type: str = None,
        target_value: str = None,
    ):
        # The ID of the whitelist rule. If you do not specify this parameter, a whitelist rule is created.
        self.config_id = config_id
        # The name of the alert.
        # 
        # *   Set the value to **ALL**, which indicates all alert types.
        self.event_name = event_name
        # The field that you want to use in the whitelist rule.
        self.field = field
        # The value of the field that you want to use in the whitelist rule.
        self.field_value = field_value
        # The logical operator that you want to use in the whitelist rule.
        # 
        # *   Set the value to strEqual, which indicates the equality operator (=).
        self.operator = operator
        # The feature to which this operation belongs.
        # 
        # *   Set the value to agentless, which indicates the agentless detection feature.
        self.source = source
        # The type of the assets on which you want the whitelist rule to take effect. Valid values:
        # 
        # *   ALL: all assets
        # *   SELECTION_KEY: selected assets
        self.target_type = target_type
        # The assets on which you want the whitelist rule to take effect. Valid values:
        # 
        # *   ALL: all assets
        # *   Others: selected assets
        self.target_value = target_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.field is not None:
            result['Field'] = self.field
        if self.field_value is not None:
            result['FieldValue'] = self.field_value
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.source is not None:
            result['Source'] = self.source
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.target_value is not None:
            result['TargetValue'] = self.target_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('Field') is not None:
            self.field = m.get('Field')
        if m.get('FieldValue') is not None:
            self.field_value = m.get('FieldValue')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('TargetValue') is not None:
            self.target_value = m.get('TargetValue')
        return self


class BatchUpdateMaliciousFileWhitelistConfigRequest(TeaModel):
    def __init__(
        self,
        config_list: List[BatchUpdateMaliciousFileWhitelistConfigRequestConfigList] = None,
    ):
        # The whitelist rules.
        self.config_list = config_list

    def validate(self):
        if self.config_list:
            for k in self.config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigList'] = []
        if self.config_list is not None:
            for k in self.config_list:
                result['ConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config_list = []
        if m.get('ConfigList') is not None:
            for k in m.get('ConfigList'):
                temp_model = BatchUpdateMaliciousFileWhitelistConfigRequestConfigList()
                self.config_list.append(temp_model.from_map(k))
        return self


class BatchUpdateMaliciousFileWhitelistConfigResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The HTTP status code.
        self.http_status_code = http_status_code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchUpdateMaliciousFileWhitelistConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchUpdateMaliciousFileWhitelistConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchUpdateMaliciousFileWhitelistConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindAuthToMachineRequest(TeaModel):
    def __init__(
        self,
        auth_version: int = None,
        auto_bind: int = None,
        bind: List[str] = None,
        bind_all: bool = None,
        criteria: str = None,
        is_pre_bind: int = None,
        logical_exp: str = None,
        ntm_version: str = None,
        pre_bind_order_id: int = None,
        un_bind: List[str] = None,
    ):
        # The edition of Security Center that is authorized to scan the asset. Valid values:
        # 
        # *   **6**: Anti-virus
        # *   **5**: Advanced
        # *   **3**: Enterprise
        # *   **7**: Ultimate
        # *   **10**: Value-added Plan
        self.auth_version = auth_version
        # Specifies whether to automatically bind servers to Security Center. Valid values:
        # 
        # *   **0**: no
        # *   **1**: yes
        self.auto_bind = auto_bind
        # The UUIDs of the servers that you want to bind to Security Center.
        # 
        # >  You must specify at least one of the **Bind** and **UnBind** parameters.
        self.bind = bind
        # Specifies whether to bind all servers to Security Center. Default value: **false**. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.bind_all = bind_all
        # The search conditions that are used to filter servers. The value of this parameter is in the JSON format and is case-sensitive.
        # 
        # >  A search condition can be an instance ID, instance name, virtual private cloud (VPC) ID, region, or public IP address. You can call the [DescribeCriteria](~~DescribeCriteria~~) operation to query the supported search conditions.
        self.criteria = criteria
        # Specifies whether to specify servers for protection when you purchase Security Center. Valid values:
        # 
        # *   **0**: no
        # *   **1**: yes
        # 
        # >  If you specify servers, the servers are automatically added to Security Center for protection after the purchase order is complete.
        self.is_pre_bind = is_pre_bind
        # The logical relationship that you want to use to evaluate multiple search conditions. Default value: **OR**. Valid values:
        # 
        # *   **OR**\
        # *   **AND**\
        self.logical_exp = logical_exp
        # The edition of Security Center that you purchase in the order. Valid values:
        # 
        # *   **level7**: Anti-virus
        # *   **level3**: Advanced
        # *   **level2**: Enterprise
        # *   **level8**: Ultimate
        # *   **level10**: Value-added Plan
        self.ntm_version = ntm_version
        # The ID of the order in which Security Center is purchased and servers are specified for protection.
        self.pre_bind_order_id = pre_bind_order_id
        # The UUIDs of the servers that you want to unbind from Security Center.
        # 
        # >  You must specify at least one of the **Bind** and **UnBind** parameters.
        self.un_bind = un_bind

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_version is not None:
            result['AuthVersion'] = self.auth_version
        if self.auto_bind is not None:
            result['AutoBind'] = self.auto_bind
        if self.bind is not None:
            result['Bind'] = self.bind
        if self.bind_all is not None:
            result['BindAll'] = self.bind_all
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.is_pre_bind is not None:
            result['IsPreBind'] = self.is_pre_bind
        if self.logical_exp is not None:
            result['LogicalExp'] = self.logical_exp
        if self.ntm_version is not None:
            result['NtmVersion'] = self.ntm_version
        if self.pre_bind_order_id is not None:
            result['PreBindOrderId'] = self.pre_bind_order_id
        if self.un_bind is not None:
            result['UnBind'] = self.un_bind
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthVersion') is not None:
            self.auth_version = m.get('AuthVersion')
        if m.get('AutoBind') is not None:
            self.auto_bind = m.get('AutoBind')
        if m.get('Bind') is not None:
            self.bind = m.get('Bind')
        if m.get('BindAll') is not None:
            self.bind_all = m.get('BindAll')
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('IsPreBind') is not None:
            self.is_pre_bind = m.get('IsPreBind')
        if m.get('LogicalExp') is not None:
            self.logical_exp = m.get('LogicalExp')
        if m.get('NtmVersion') is not None:
            self.ntm_version = m.get('NtmVersion')
        if m.get('PreBindOrderId') is not None:
            self.pre_bind_order_id = m.get('PreBindOrderId')
        if m.get('UnBind') is not None:
            self.un_bind = m.get('UnBind')
        return self


class BindAuthToMachineResponseBody(TeaModel):
    def __init__(
        self,
        bind_count: int = None,
        insufficient_core_count: int = None,
        insufficient_ecs_count: int = None,
        request_id: str = None,
        result_code: int = None,
        un_bind_count: int = None,
    ):
        # The number of bound servers.
        self.bind_count = bind_count
        # The shortage in the quota for cores of servers that can be protected.
        self.insufficient_core_count = insufficient_core_count
        # The shortage in the quota for servers that can be protected.
        self.insufficient_ecs_count = insufficient_ecs_count
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # The status code that indicates the result. Valid values:
        # 
        # *   **0**: The servers are bound to or unbound from Security Center.
        # *   **1**: The values that you specified for the parameters are invalid.
        # *   **2**: The quota for servers that can be protected is insufficient.
        # *   **3**: The quota for cores of servers that can be protected is insufficient.
        self.result_code = result_code
        # The number of unbound servers.
        self.un_bind_count = un_bind_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_count is not None:
            result['BindCount'] = self.bind_count
        if self.insufficient_core_count is not None:
            result['InsufficientCoreCount'] = self.insufficient_core_count
        if self.insufficient_ecs_count is not None:
            result['InsufficientEcsCount'] = self.insufficient_ecs_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result_code is not None:
            result['ResultCode'] = self.result_code
        if self.un_bind_count is not None:
            result['UnBindCount'] = self.un_bind_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindCount') is not None:
            self.bind_count = m.get('BindCount')
        if m.get('InsufficientCoreCount') is not None:
            self.insufficient_core_count = m.get('InsufficientCoreCount')
        if m.get('InsufficientEcsCount') is not None:
            self.insufficient_ecs_count = m.get('InsufficientEcsCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResultCode') is not None:
            self.result_code = m.get('ResultCode')
        if m.get('UnBindCount') is not None:
            self.un_bind_count = m.get('UnBindCount')
        return self


class BindAuthToMachineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BindAuthToMachineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindAuthToMachineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindHybridProxyRequest(TeaModel):
    def __init__(
        self,
        cluster_name: str = None,
        yundun_uuids: List[str] = None,
    ):
        # The name of the proxy cluster.
        # 
        # This parameter is required.
        self.cluster_name = cluster_name
        # The UUIDs of servers that you want to add to Security Center over the proxy server.
        # 
        # This parameter is required.
        self.yundun_uuids = yundun_uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.yundun_uuids is not None:
            result['YundunUuids'] = self.yundun_uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('YundunUuids') is not None:
            self.yundun_uuids = m.get('YundunUuids')
        return self


class BindHybridProxyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BindHybridProxyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BindHybridProxyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindHybridProxyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOnceTaskRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
    ):
        # The ID of the task.
        # 
        # >  You can call the [GenerateOnceTask](~~GenerateOnceTask~~) operation to query the IDs of tasks.
        # 
        # This parameter is required.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CancelOnceTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelOnceTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelOnceTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelOnceTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeAssetRefreshTaskConfigRequestAssetRefreshConfigs(TeaModel):
    def __init__(
        self,
        refresh_config_type: int = None,
        schedule_period: int = None,
        status: int = None,
        target_id: int = None,
        vendor: int = None,
    ):
        # The type of the configuration. Valid values:
        # 
        # *   **0**: server synchronization task
        # *   **1**: cloud service synchronization task
        # *   **2**: scheduled AccessKey pair verification task
        self.refresh_config_type = refresh_config_type
        # The synchronization cycle. Valid values:
        # 
        # *   **60**: 60 minutes
        # *   **180**: 3 hours
        # *   **360**: 6 hours
        # *   **720**: 12 hours
        # *   **1440**: 1 day
        # *   **10080**: 7 days
        self.schedule_period = schedule_period
        # The status of the configuration. Valid values:
        # 
        # *   **1**: enabled
        # *   **0**: disabled
        self.status = status
        # The ID of the data entry containing the AccessKey pair that you specify when you configure the scheduled AccessKey pair verification task.
        self.target_id = target_id
        # The service provider of the cloud asset. Valid values:
        # 
        # *   **3**: Tencent Cloud
        # *   **4**: Huawei Cloud
        # *   **7**: Amazon Web Services (AWS) Cloud
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.refresh_config_type is not None:
            result['RefreshConfigType'] = self.refresh_config_type
        if self.schedule_period is not None:
            result['SchedulePeriod'] = self.schedule_period
        if self.status is not None:
            result['Status'] = self.status
        if self.target_id is not None:
            result['TargetId'] = self.target_id
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RefreshConfigType') is not None:
            self.refresh_config_type = m.get('RefreshConfigType')
        if m.get('SchedulePeriod') is not None:
            self.schedule_period = m.get('SchedulePeriod')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TargetId') is not None:
            self.target_id = m.get('TargetId')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class ChangeAssetRefreshTaskConfigRequest(TeaModel):
    def __init__(
        self,
        asset_refresh_configs: List[ChangeAssetRefreshTaskConfigRequestAssetRefreshConfigs] = None,
        region_id: str = None,
    ):
        # The asset synchronization configuration.
        self.asset_refresh_configs = asset_refresh_configs
        # The region in which your Security Center service resides.
        self.region_id = region_id

    def validate(self):
        if self.asset_refresh_configs:
            for k in self.asset_refresh_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AssetRefreshConfigs'] = []
        if self.asset_refresh_configs is not None:
            for k in self.asset_refresh_configs:
                result['AssetRefreshConfigs'].append(k.to_map() if k else None)
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.asset_refresh_configs = []
        if m.get('AssetRefreshConfigs') is not None:
            for k in m.get('AssetRefreshConfigs'):
                temp_model = ChangeAssetRefreshTaskConfigRequestAssetRefreshConfigs()
                self.asset_refresh_configs.append(temp_model.from_map(k))
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ChangeAssetRefreshTaskConfigResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        message: str = None,
        request_id: str = None,
    ):
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.data = data
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ChangeAssetRefreshTaskConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ChangeAssetRefreshTaskConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeAssetRefreshTaskConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeCheckConfigRequestAddedCheck(TeaModel):
    def __init__(
        self,
        check_id: int = None,
        section_id: int = None,
    ):
        # The ID of the check item.
        # 
        # >  You can call the [ListCheckResult](~~ListCheckResult~~) operation to obtain the ID of the check item.
        self.check_id = check_id
        # The section ID of the check item.
        self.section_id = section_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.section_id is not None:
            result['SectionId'] = self.section_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('SectionId') is not None:
            self.section_id = m.get('SectionId')
        return self


class ChangeCheckConfigRequestConfigRequirementIds(TeaModel):
    def __init__(
        self,
        add_ids: List[int] = None,
        remove_ids: List[int] = None,
    ):
        # The requirement IDs that you want to add to the policy.
        self.add_ids = add_ids
        # The requirement IDs that you want to remove from the policy.
        self.remove_ids = remove_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_ids is not None:
            result['AddIds'] = self.add_ids
        if self.remove_ids is not None:
            result['RemoveIds'] = self.remove_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddIds') is not None:
            self.add_ids = m.get('AddIds')
        if m.get('RemoveIds') is not None:
            self.remove_ids = m.get('RemoveIds')
        return self


class ChangeCheckConfigRequestConfigStandardIds(TeaModel):
    def __init__(
        self,
        add_ids: List[int] = None,
        remove_ids: List[int] = None,
    ):
        # The standard IDs that you want to add to the policy.
        self.add_ids = add_ids
        # The standard IDs that you want to remove from the policy.
        self.remove_ids = remove_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_ids is not None:
            result['AddIds'] = self.add_ids
        if self.remove_ids is not None:
            result['RemoveIds'] = self.remove_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddIds') is not None:
            self.add_ids = m.get('AddIds')
        if m.get('RemoveIds') is not None:
            self.remove_ids = m.get('RemoveIds')
        return self


class ChangeCheckConfigRequestRemovedCheck(TeaModel):
    def __init__(
        self,
        check_id: int = None,
        section_id: int = None,
    ):
        # The ID of the check item.
        # 
        # >  You can call the [ListCheckResult](~~ListCheckResult~~) operation to obtain the ID of the check item.
        self.check_id = check_id
        # The section ID of the check item.
        self.section_id = section_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.section_id is not None:
            result['SectionId'] = self.section_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('SectionId') is not None:
            self.section_id = m.get('SectionId')
        return self


class ChangeCheckConfigRequest(TeaModel):
    def __init__(
        self,
        added_check: List[ChangeCheckConfigRequestAddedCheck] = None,
        config_requirement_ids: ChangeCheckConfigRequestConfigRequirementIds = None,
        config_standard_ids: ChangeCheckConfigRequestConfigStandardIds = None,
        configure: str = None,
        cycle_days: List[int] = None,
        enable_add_check: bool = None,
        enable_auto_check: bool = None,
        end_time: int = None,
        region_id: str = None,
        removed_check: List[ChangeCheckConfigRequestRemovedCheck] = None,
        standard_ids: List[int] = None,
        start_time: int = None,
        system_config: bool = None,
        vendors: List[str] = None,
    ):
        # The list of check items that you want to add to the policy.
        # 
        # >  If the ConfigStandardIds or ConfigRequirementIds parameter is configured, this parameter does not take effect.
        self.added_check = added_check
        # The requirement IDs that you want to specify for the check policy.
        # 
        # >  You can call the [ListCheckResult](~~ListCheckResult~~) operation to obtain the requirement ID. If the ConfigStandardIds parameter is configured, this parameter does not take effect.
        self.config_requirement_ids = config_requirement_ids
        # The standard IDs that you want to specify for the check policy.
        # 
        # >  You can call the [ListCheckResult](~~ListCheckResult~~) operation to obtain the standard ID.
        self.config_standard_ids = config_standard_ids
        # The configuration of the check item. Valid value:
        # 
        # *   **all**: Add all check items.
        self.configure = configure
        # The days in a week on which a check is performed.
        self.cycle_days = cycle_days
        # Specifies whether to check the new check items in the selected requirement item. Valid values:
        # - **true**\
        # - **false**\
        self.enable_add_check = enable_add_check
        # Specifies whether to enable the automatic periodical check feature. Valid values:
        # 
        # - **true**\
        # - **false**\
        self.enable_auto_check = enable_auto_check
        # The end time of the check. The value specifies a point in time in a day. The time period that is specified by the start time and end time must be one of the following time periods:
        # 
        # *   **00:00 to 06:00:** If you set the StartTime parameter to 0, you must set the EndTime parameter to 6.
        # *   **06:00 to 12:00**: If you set the StartTime parameter to 6, you must set the EndTime parameter to 12.
        # *   **12:00 to 18:00**: If you set the StartTime parameter to 12, you must set the EndTime parameter to 18.
        # *  **18:00 to 24:00:** If you set the StartTime parameter to 18, you must set the EndTime parameter to 24.
        self.end_time = end_time
        # The region ID of the bastion host to query.
        # 
        # >  For more information about the mapping between region IDs and region names, see [Regions and zones](https://help.aliyun.com/document_detail/40654.html).
        self.region_id = region_id
        # The list of the check items that you want to remove from the policy.
        # 
        # >  If the ConfigStandardIds or ConfigRequirementIds parameter is configured, this parameter does not take effect.
        self.removed_check = removed_check
        # An array that consists of the information about the check item.
        self.standard_ids = standard_ids
        # The start time of the check. The value specifies a point in time in a day.
        self.start_time = start_time
        # Specifies whether to use the configuration automatically generated by the system. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.system_config = system_config
        # The cloud service providers.
        self.vendors = vendors

    def validate(self):
        if self.added_check:
            for k in self.added_check:
                if k:
                    k.validate()
        if self.config_requirement_ids:
            self.config_requirement_ids.validate()
        if self.config_standard_ids:
            self.config_standard_ids.validate()
        if self.removed_check:
            for k in self.removed_check:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AddedCheck'] = []
        if self.added_check is not None:
            for k in self.added_check:
                result['AddedCheck'].append(k.to_map() if k else None)
        if self.config_requirement_ids is not None:
            result['ConfigRequirementIds'] = self.config_requirement_ids.to_map()
        if self.config_standard_ids is not None:
            result['ConfigStandardIds'] = self.config_standard_ids.to_map()
        if self.configure is not None:
            result['Configure'] = self.configure
        if self.cycle_days is not None:
            result['CycleDays'] = self.cycle_days
        if self.enable_add_check is not None:
            result['EnableAddCheck'] = self.enable_add_check
        if self.enable_auto_check is not None:
            result['EnableAutoCheck'] = self.enable_auto_check
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['RemovedCheck'] = []
        if self.removed_check is not None:
            for k in self.removed_check:
                result['RemovedCheck'].append(k.to_map() if k else None)
        if self.standard_ids is not None:
            result['StandardIds'] = self.standard_ids
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.system_config is not None:
            result['SystemConfig'] = self.system_config
        if self.vendors is not None:
            result['Vendors'] = self.vendors
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.added_check = []
        if m.get('AddedCheck') is not None:
            for k in m.get('AddedCheck'):
                temp_model = ChangeCheckConfigRequestAddedCheck()
                self.added_check.append(temp_model.from_map(k))
        if m.get('ConfigRequirementIds') is not None:
            temp_model = ChangeCheckConfigRequestConfigRequirementIds()
            self.config_requirement_ids = temp_model.from_map(m['ConfigRequirementIds'])
        if m.get('ConfigStandardIds') is not None:
            temp_model = ChangeCheckConfigRequestConfigStandardIds()
            self.config_standard_ids = temp_model.from_map(m['ConfigStandardIds'])
        if m.get('Configure') is not None:
            self.configure = m.get('Configure')
        if m.get('CycleDays') is not None:
            self.cycle_days = m.get('CycleDays')
        if m.get('EnableAddCheck') is not None:
            self.enable_add_check = m.get('EnableAddCheck')
        if m.get('EnableAutoCheck') is not None:
            self.enable_auto_check = m.get('EnableAutoCheck')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.removed_check = []
        if m.get('RemovedCheck') is not None:
            for k in m.get('RemovedCheck'):
                temp_model = ChangeCheckConfigRequestRemovedCheck()
                self.removed_check.append(temp_model.from_map(k))
        if m.get('StandardIds') is not None:
            self.standard_ids = m.get('StandardIds')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('SystemConfig') is not None:
            self.system_config = m.get('SystemConfig')
        if m.get('Vendors') is not None:
            self.vendors = m.get('Vendors')
        return self


class ChangeCheckConfigShrinkRequestAddedCheck(TeaModel):
    def __init__(
        self,
        check_id: int = None,
        section_id: int = None,
    ):
        # The ID of the check item.
        # 
        # >  You can call the [ListCheckResult](~~ListCheckResult~~) operation to obtain the ID of the check item.
        self.check_id = check_id
        # The section ID of the check item.
        self.section_id = section_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.section_id is not None:
            result['SectionId'] = self.section_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('SectionId') is not None:
            self.section_id = m.get('SectionId')
        return self


class ChangeCheckConfigShrinkRequestRemovedCheck(TeaModel):
    def __init__(
        self,
        check_id: int = None,
        section_id: int = None,
    ):
        # The ID of the check item.
        # 
        # >  You can call the [ListCheckResult](~~ListCheckResult~~) operation to obtain the ID of the check item.
        self.check_id = check_id
        # The section ID of the check item.
        self.section_id = section_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.section_id is not None:
            result['SectionId'] = self.section_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('SectionId') is not None:
            self.section_id = m.get('SectionId')
        return self


class ChangeCheckConfigShrinkRequest(TeaModel):
    def __init__(
        self,
        added_check: List[ChangeCheckConfigShrinkRequestAddedCheck] = None,
        config_requirement_ids_shrink: str = None,
        config_standard_ids_shrink: str = None,
        configure: str = None,
        cycle_days: List[int] = None,
        enable_add_check: bool = None,
        enable_auto_check: bool = None,
        end_time: int = None,
        region_id: str = None,
        removed_check: List[ChangeCheckConfigShrinkRequestRemovedCheck] = None,
        standard_ids: List[int] = None,
        start_time: int = None,
        system_config: bool = None,
        vendors: List[str] = None,
    ):
        # The list of check items that you want to add to the policy.
        # 
        # >  If the ConfigStandardIds or ConfigRequirementIds parameter is configured, this parameter does not take effect.
        self.added_check = added_check
        # The requirement IDs that you want to specify for the check policy.
        # 
        # >  You can call the [ListCheckResult](~~ListCheckResult~~) operation to obtain the requirement ID. If the ConfigStandardIds parameter is configured, this parameter does not take effect.
        self.config_requirement_ids_shrink = config_requirement_ids_shrink
        # The standard IDs that you want to specify for the check policy.
        # 
        # >  You can call the [ListCheckResult](~~ListCheckResult~~) operation to obtain the standard ID.
        self.config_standard_ids_shrink = config_standard_ids_shrink
        # The configuration of the check item. Valid value:
        # 
        # *   **all**: Add all check items.
        self.configure = configure
        # The days in a week on which a check is performed.
        self.cycle_days = cycle_days
        # Specifies whether to check the new check items in the selected requirement item. Valid values:
        # - **true**\
        # - **false**\
        self.enable_add_check = enable_add_check
        # Specifies whether to enable the automatic periodical check feature. Valid values:
        # 
        # - **true**\
        # - **false**\
        self.enable_auto_check = enable_auto_check
        # The end time of the check. The value specifies a point in time in a day. The time period that is specified by the start time and end time must be one of the following time periods:
        # 
        # *   **00:00 to 06:00:** If you set the StartTime parameter to 0, you must set the EndTime parameter to 6.
        # *   **06:00 to 12:00**: If you set the StartTime parameter to 6, you must set the EndTime parameter to 12.
        # *   **12:00 to 18:00**: If you set the StartTime parameter to 12, you must set the EndTime parameter to 18.
        # *  **18:00 to 24:00:** If you set the StartTime parameter to 18, you must set the EndTime parameter to 24.
        self.end_time = end_time
        # The region ID of the bastion host to query.
        # 
        # >  For more information about the mapping between region IDs and region names, see [Regions and zones](https://help.aliyun.com/document_detail/40654.html).
        self.region_id = region_id
        # The list of the check items that you want to remove from the policy.
        # 
        # >  If the ConfigStandardIds or ConfigRequirementIds parameter is configured, this parameter does not take effect.
        self.removed_check = removed_check
        # An array that consists of the information about the check item.
        self.standard_ids = standard_ids
        # The start time of the check. The value specifies a point in time in a day.
        self.start_time = start_time
        # Specifies whether to use the configuration automatically generated by the system. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.system_config = system_config
        # The cloud service providers.
        self.vendors = vendors

    def validate(self):
        if self.added_check:
            for k in self.added_check:
                if k:
                    k.validate()
        if self.removed_check:
            for k in self.removed_check:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AddedCheck'] = []
        if self.added_check is not None:
            for k in self.added_check:
                result['AddedCheck'].append(k.to_map() if k else None)
        if self.config_requirement_ids_shrink is not None:
            result['ConfigRequirementIds'] = self.config_requirement_ids_shrink
        if self.config_standard_ids_shrink is not None:
            result['ConfigStandardIds'] = self.config_standard_ids_shrink
        if self.configure is not None:
            result['Configure'] = self.configure
        if self.cycle_days is not None:
            result['CycleDays'] = self.cycle_days
        if self.enable_add_check is not None:
            result['EnableAddCheck'] = self.enable_add_check
        if self.enable_auto_check is not None:
            result['EnableAutoCheck'] = self.enable_auto_check
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['RemovedCheck'] = []
        if self.removed_check is not None:
            for k in self.removed_check:
                result['RemovedCheck'].append(k.to_map() if k else None)
        if self.standard_ids is not None:
            result['StandardIds'] = self.standard_ids
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.system_config is not None:
            result['SystemConfig'] = self.system_config
        if self.vendors is not None:
            result['Vendors'] = self.vendors
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.added_check = []
        if m.get('AddedCheck') is not None:
            for k in m.get('AddedCheck'):
                temp_model = ChangeCheckConfigShrinkRequestAddedCheck()
                self.added_check.append(temp_model.from_map(k))
        if m.get('ConfigRequirementIds') is not None:
            self.config_requirement_ids_shrink = m.get('ConfigRequirementIds')
        if m.get('ConfigStandardIds') is not None:
            self.config_standard_ids_shrink = m.get('ConfigStandardIds')
        if m.get('Configure') is not None:
            self.configure = m.get('Configure')
        if m.get('CycleDays') is not None:
            self.cycle_days = m.get('CycleDays')
        if m.get('EnableAddCheck') is not None:
            self.enable_add_check = m.get('EnableAddCheck')
        if m.get('EnableAutoCheck') is not None:
            self.enable_auto_check = m.get('EnableAutoCheck')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.removed_check = []
        if m.get('RemovedCheck') is not None:
            for k in m.get('RemovedCheck'):
                temp_model = ChangeCheckConfigShrinkRequestRemovedCheck()
                self.removed_check.append(temp_model.from_map(k))
        if m.get('StandardIds') is not None:
            self.standard_ids = m.get('StandardIds')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('SystemConfig') is not None:
            self.system_config = m.get('SystemConfig')
        if m.get('Vendors') is not None:
            self.vendors = m.get('Vendors')
        return self


class ChangeCheckConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ChangeCheckConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ChangeCheckConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeCheckConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeCheckCustomConfigRequestCustomConfigs(TeaModel):
    def __init__(
        self,
        name: str = None,
        operation: str = None,
        value: str = None,
    ):
        # The name of the custom configuration item. The name of a custom configuration item is unique in a check item.
        self.name = name
        # The operation that you want to perform on the custom configuration item. This parameter is required only if you want to delete the custom configuration item. To delete the custom configuration item, set the value to DELETE.
        self.operation = operation
        # The value of the custom configuration item. The value is a string.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.operation is not None:
            result['Operation'] = self.operation
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Operation') is not None:
            self.operation = m.get('Operation')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ChangeCheckCustomConfigRequestRepairConfigs(TeaModel):
    def __init__(
        self,
        flow_id: str = None,
        name: str = None,
        operation: str = None,
        value: str = None,
    ):
        # The ID of the fixing process.
        self.flow_id = flow_id
        # The name of the parameter required for fixing a risk item, which is unique in a check item.
        self.name = name
        # The operation that you want to perform on the custom configuration item. This parameter is required only if you want to delete the custom configuration item. To delete the custom configuration item, set the value to DELETE.
        self.operation = operation
        # The value of the parameter required for fixing a risk item. The value is a string.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.name is not None:
            result['Name'] = self.name
        if self.operation is not None:
            result['Operation'] = self.operation
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Operation') is not None:
            self.operation = m.get('Operation')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ChangeCheckCustomConfigRequest(TeaModel):
    def __init__(
        self,
        check_id: int = None,
        custom_configs: List[ChangeCheckCustomConfigRequestCustomConfigs] = None,
        region_id: str = None,
        repair_configs: List[ChangeCheckCustomConfigRequestRepairConfigs] = None,
    ):
        # The ID of the check item.
        # 
        # > You can call the [ListCheckResult](~~ListCheckResult~~) operation to query the IDs of check items.
        self.check_id = check_id
        # The custom configuration items of the check item.
        self.custom_configs = custom_configs
        # The region where the Security Center instance is deployed. Valid values:
        # 
        # *   **cn-hangzhou**: International
        # *   **ap-southeast-1**: Singapore
        self.region_id = region_id
        # The parameters required for fixing risk items.
        self.repair_configs = repair_configs

    def validate(self):
        if self.custom_configs:
            for k in self.custom_configs:
                if k:
                    k.validate()
        if self.repair_configs:
            for k in self.repair_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        result['CustomConfigs'] = []
        if self.custom_configs is not None:
            for k in self.custom_configs:
                result['CustomConfigs'].append(k.to_map() if k else None)
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['RepairConfigs'] = []
        if self.repair_configs is not None:
            for k in self.repair_configs:
                result['RepairConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        self.custom_configs = []
        if m.get('CustomConfigs') is not None:
            for k in m.get('CustomConfigs'):
                temp_model = ChangeCheckCustomConfigRequestCustomConfigs()
                self.custom_configs.append(temp_model.from_map(k))
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.repair_configs = []
        if m.get('RepairConfigs') is not None:
            for k in m.get('RepairConfigs'):
                temp_model = ChangeCheckCustomConfigRequestRepairConfigs()
                self.repair_configs.append(temp_model.from_map(k))
        return self


class ChangeCheckCustomConfigResponseBodyIllegalCustomConfigs(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        # The name of the custom configuration item, which is unique in a check item.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ChangeCheckCustomConfigResponseBodyIllegalRepairConfigs(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        # The name of the invalid parameter required for fixing a risk item.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ChangeCheckCustomConfigResponseBody(TeaModel):
    def __init__(
        self,
        illegal_custom_configs: List[ChangeCheckCustomConfigResponseBodyIllegalCustomConfigs] = None,
        illegal_repair_configs: List[ChangeCheckCustomConfigResponseBodyIllegalRepairConfigs] = None,
        request_id: str = None,
    ):
        # An array that consists of the invalid custom configuration items of the check item.
        self.illegal_custom_configs = illegal_custom_configs
        # An array that consists of the invalid parameters required for fixing risk items.
        self.illegal_repair_configs = illegal_repair_configs
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.illegal_custom_configs:
            for k in self.illegal_custom_configs:
                if k:
                    k.validate()
        if self.illegal_repair_configs:
            for k in self.illegal_repair_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['IllegalCustomConfigs'] = []
        if self.illegal_custom_configs is not None:
            for k in self.illegal_custom_configs:
                result['IllegalCustomConfigs'].append(k.to_map() if k else None)
        result['IllegalRepairConfigs'] = []
        if self.illegal_repair_configs is not None:
            for k in self.illegal_repair_configs:
                result['IllegalRepairConfigs'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.illegal_custom_configs = []
        if m.get('IllegalCustomConfigs') is not None:
            for k in m.get('IllegalCustomConfigs'):
                temp_model = ChangeCheckCustomConfigResponseBodyIllegalCustomConfigs()
                self.illegal_custom_configs.append(temp_model.from_map(k))
        self.illegal_repair_configs = []
        if m.get('IllegalRepairConfigs') is not None:
            for k in m.get('IllegalRepairConfigs'):
                temp_model = ChangeCheckCustomConfigResponseBodyIllegalRepairConfigs()
                self.illegal_repair_configs.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ChangeCheckCustomConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ChangeCheckCustomConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeCheckCustomConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeSecurityScoreRuleRequestSecurityScoreCategoryListSecurityRuleListSecurityScoreItemList(TeaModel):
    def __init__(
        self,
        score: int = None,
        score_threshold: int = None,
        sub_rule_type: str = None,
    ):
        # The penalty point of the deduction item.
        self.score = score
        # The threshold for the deduction item.
        # 
        # >  Valid values: 0 to the deduction threshold of the deduction module.
        self.score_threshold = score_threshold
        # The sub-deduction item of the security score rule.
        self.sub_rule_type = sub_rule_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.score is not None:
            result['Score'] = self.score
        if self.score_threshold is not None:
            result['ScoreThreshold'] = self.score_threshold
        if self.sub_rule_type is not None:
            result['SubRuleType'] = self.sub_rule_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('ScoreThreshold') is not None:
            self.score_threshold = m.get('ScoreThreshold')
        if m.get('SubRuleType') is not None:
            self.sub_rule_type = m.get('SubRuleType')
        return self


class ChangeSecurityScoreRuleRequestSecurityScoreCategoryListSecurityRuleList(TeaModel):
    def __init__(
        self,
        rule_type: str = None,
        score: int = None,
        security_score_item_list: List[ChangeSecurityScoreRuleRequestSecurityScoreCategoryListSecurityRuleListSecurityScoreItemList] = None,
    ):
        # The deducted module that is supported by the security score feature. The type of the sub-deduction item. Valid values:
        # 
        # *   **SS_SAS_WEAK_PW**: unhandled weak password risk.
        # *   **SS_SAS_ALARM**: unhandled alert in Security Center.
        # *   **SS_SAS_EMG_VUL**: unfixed urgent vulnerability.
        # *   **SS_SAS_APP_VUL**: unfixed application vulnerability.
        # *   **SS_SAS_SYS_VUL**: unfixed system vulnerability.
        # *   **SS_SAS_CLOUD_HC**: unhandled cloud security posture management (CSPM) risk.
        # *   **SS_SDDP_DATA_RISK**: unhandled data security risk.
        # *   **SS_WAF_API_RISK**: unhandled API security risk.
        # *   **SS_DDOS_BH_ASSET**: asset on which blackhole filtering is triggered.
        # *   **SS_SAS_AK_LEAK**: unhandled AK/SK leak event.
        # *   **SS_PRODUCT_CONNECT**: security service not integrated.
        # *   **SS_KEY_CONFIG**: key feature configuration.
        # *   **SS_PRODUCT_EXPIRE**: service that is about to expire.
        # *   **SS_AI_RISK**: AI application risk.
        self.rule_type = rule_type
        # The threshold of deduction for the security score rule type.
        # 
        # >  Valid values: 0 to the deduction threshold of the deduction module.
        self.score = score
        # The sub-deduction items of the security score rule.
        self.security_score_item_list = security_score_item_list

    def validate(self):
        if self.security_score_item_list:
            for k in self.security_score_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        if self.score is not None:
            result['Score'] = self.score
        result['SecurityScoreItemList'] = []
        if self.security_score_item_list is not None:
            for k in self.security_score_item_list:
                result['SecurityScoreItemList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        self.security_score_item_list = []
        if m.get('SecurityScoreItemList') is not None:
            for k in m.get('SecurityScoreItemList'):
                temp_model = ChangeSecurityScoreRuleRequestSecurityScoreCategoryListSecurityRuleListSecurityScoreItemList()
                self.security_score_item_list.append(temp_model.from_map(k))
        return self


class ChangeSecurityScoreRuleRequestSecurityScoreCategoryList(TeaModel):
    def __init__(
        self,
        category: str = None,
        score_threshold: int = None,
        security_rule_list: List[ChangeSecurityScoreRuleRequestSecurityScoreCategoryListSecurityRuleList] = None,
    ):
        # The category of the security score rule. Valid values:
        # 
        # *   **SS_SAS_HANDLE**: security governance.
        # *   **SS_SAS_RESPOND**: security response.
        self.category = category
        # The threshold of deduction for the security score rule type.
        # 
        # >  Valid values: 0 to 100. The sum of the deduction thresholds for all deduction modules must be equal to 100.
        self.score_threshold = score_threshold
        # The deduction items of the security score rule.
        self.security_rule_list = security_rule_list

    def validate(self):
        if self.security_rule_list:
            for k in self.security_rule_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.score_threshold is not None:
            result['ScoreThreshold'] = self.score_threshold
        result['SecurityRuleList'] = []
        if self.security_rule_list is not None:
            for k in self.security_rule_list:
                result['SecurityRuleList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('ScoreThreshold') is not None:
            self.score_threshold = m.get('ScoreThreshold')
        self.security_rule_list = []
        if m.get('SecurityRuleList') is not None:
            for k in m.get('SecurityRuleList'):
                temp_model = ChangeSecurityScoreRuleRequestSecurityScoreCategoryListSecurityRuleList()
                self.security_rule_list.append(temp_model.from_map(k))
        return self


class ChangeSecurityScoreRuleRequestSecurityScoreRuleListSecurityScoreItemList(TeaModel):
    def __init__(
        self,
        score: int = None,
        score_threshold: int = None,
        sub_rule_type: str = None,
    ):
        # The penalty point of the deduction item.
        self.score = score
        # The threshold for the deduction item.
        # 
        # >  Valid values: 0 to the deduction threshold of the deduction module.
        self.score_threshold = score_threshold
        # The deduction item of the deduction module. The following list describes the deduction modules and their deduction items:
        # 
        # *   SS_REINFORCE: issue in key feature configuration
        # 
        #     *   XPRESS_INSTALL: Security Center is not authorized.
        #     *   REINFORCE_SUSPICIOUS: The anti-virus feature is disabled.
        #     *   RANSOMWARE: The anti-ransomware policy is disabled.
        #     *   WEB_LOCK: The web tamper proofing feature is disabled.
        #     *   VIRUS_SCHEDULE_SCAN: The periodic virus scan policy is disabled.
        #     *   IMAGE_REPO_SCAN: The container image scan range is not configured.
        #     *   IMAGE_SCAN_TASK: The feature of one-click scan of container images for security risks is not performed.
        # 
        # *   SS_ALARM: unhandled alert
        # 
        #     *   ALARM_SERIOUS: An unhandled high-risk alert event is detected.
        #     *   ALARM_SUSPICIOUS: An unhandled medium-risk alarm event is detected.
        #     *   ALARM_REMIND: An unhandled low-risk alarm event is detected.
        # 
        # *   SS_VUL: unfixed vulnerability
        # 
        #     *   CMS_UNFIX: An unfixed Web-CMS vulnerability is detected.
        #     *   WIN_UNFIX: An unfixed Windows host vulnerability is detected.
        #     *   CVE_UNFIX: An unfixed Linux host vulnerability is detected.
        #     *   ERM_UNFIX: An unfixed emergency vulnerability is detected.
        #     *   ERM_UNCHECK: An undetected emergency vulnerability exists.
        # 
        # *   SS_HC: baseline risk
        # 
        #     *   WEAK_EXPLOIT: Weak passwords are exposed to the Internet.
        #     *   WEAK_PASSWORD: Weak passwords exist.
        #     *   HC_EXPLOIT: The data source may be hacked.
        #     *   HC_OTHER_WARNING: Security configuration risks exist.
        # 
        # *   SS_CLOUD_HC: Cloud platform configuration check item problem.
        # 
        #     *   CSPM_CIEM_NOT_PASS: A CIEM check item failed the check.
        #     *   CSPM_RISK_NOT_PASS: A security risk check item failed the check.
        #     *   CSPM_COMPLIANCE_NOT_PASS: A compliance check item failed the check.
        # 
        # *   SS_AK: risk of AccessKey pair leaks
        self.sub_rule_type = sub_rule_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.score is not None:
            result['Score'] = self.score
        if self.score_threshold is not None:
            result['ScoreThreshold'] = self.score_threshold
        if self.sub_rule_type is not None:
            result['SubRuleType'] = self.sub_rule_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('ScoreThreshold') is not None:
            self.score_threshold = m.get('ScoreThreshold')
        if m.get('SubRuleType') is not None:
            self.sub_rule_type = m.get('SubRuleType')
        return self


class ChangeSecurityScoreRuleRequestSecurityScoreRuleList(TeaModel):
    def __init__(
        self,
        rule_type: str = None,
        score: int = None,
        security_score_item_list: List[ChangeSecurityScoreRuleRequestSecurityScoreRuleListSecurityScoreItemList] = None,
    ):
        # The type of the security score rule. Valid values:
        # 
        # *   SS_REINFORCE: issue in key feature configuration
        # *   SS_ALARM: unhandled alert
        # *   SS_VUL: unfixed vulnerability
        # *   SS_HC: baseline risk
        # *   SS_CLOUD_HC: risk item of configuration assessment
        # *   SS_AK: risk of AccessKey pair leaks
        self.rule_type = rule_type
        # The deduction threshold of the deduction module.
        # 
        # >  Valid values: 0 to 100. The sum of the deduction thresholds for all deduction modules must be equal to 100.
        self.score = score
        # The deduction items of the deduction module.
        self.security_score_item_list = security_score_item_list

    def validate(self):
        if self.security_score_item_list:
            for k in self.security_score_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        if self.score is not None:
            result['Score'] = self.score
        result['SecurityScoreItemList'] = []
        if self.security_score_item_list is not None:
            for k in self.security_score_item_list:
                result['SecurityScoreItemList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        self.security_score_item_list = []
        if m.get('SecurityScoreItemList') is not None:
            for k in m.get('SecurityScoreItemList'):
                temp_model = ChangeSecurityScoreRuleRequestSecurityScoreRuleListSecurityScoreItemList()
                self.security_score_item_list.append(temp_model.from_map(k))
        return self


class ChangeSecurityScoreRuleRequest(TeaModel):
    def __init__(
        self,
        cal_type: str = None,
        reset_security_score_rule: bool = None,
        security_score_category_list: List[ChangeSecurityScoreRuleRequestSecurityScoreCategoryList] = None,
        security_score_rule_list: List[ChangeSecurityScoreRuleRequestSecurityScoreRuleList] = None,
    ):
        # The old or new version of the security score rule. If you set this parameter to **home_security_score**, the new version of the security score rule is changed. Otherwise, the old version of the security score rule is changed by default.
        self.cal_type = cal_type
        # Specifies whether to reset to the system default rule. Valid values:
        # 
        # *   true: yes
        # *   false: no
        self.reset_security_score_rule = reset_security_score_rule
        # The information about the new version of the security score rule.
        self.security_score_category_list = security_score_category_list
        # The information about the old version of the security score rule.
        self.security_score_rule_list = security_score_rule_list

    def validate(self):
        if self.security_score_category_list:
            for k in self.security_score_category_list:
                if k:
                    k.validate()
        if self.security_score_rule_list:
            for k in self.security_score_rule_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cal_type is not None:
            result['CalType'] = self.cal_type
        if self.reset_security_score_rule is not None:
            result['ResetSecurityScoreRule'] = self.reset_security_score_rule
        result['SecurityScoreCategoryList'] = []
        if self.security_score_category_list is not None:
            for k in self.security_score_category_list:
                result['SecurityScoreCategoryList'].append(k.to_map() if k else None)
        result['SecurityScoreRuleList'] = []
        if self.security_score_rule_list is not None:
            for k in self.security_score_rule_list:
                result['SecurityScoreRuleList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CalType') is not None:
            self.cal_type = m.get('CalType')
        if m.get('ResetSecurityScoreRule') is not None:
            self.reset_security_score_rule = m.get('ResetSecurityScoreRule')
        self.security_score_category_list = []
        if m.get('SecurityScoreCategoryList') is not None:
            for k in m.get('SecurityScoreCategoryList'):
                temp_model = ChangeSecurityScoreRuleRequestSecurityScoreCategoryList()
                self.security_score_category_list.append(temp_model.from_map(k))
        self.security_score_rule_list = []
        if m.get('SecurityScoreRuleList') is not None:
            for k in m.get('SecurityScoreRuleList'):
                temp_model = ChangeSecurityScoreRuleRequestSecurityScoreRuleList()
                self.security_score_rule_list.append(temp_model.from_map(k))
        return self


class ChangeSecurityScoreRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ChangeSecurityScoreRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ChangeSecurityScoreRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeSecurityScoreRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeUserLangRequest(TeaModel):
    def __init__(
        self,
        user_lang: str = None,
    ):
        # The new language. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.user_lang = user_lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_lang is not None:
            result['UserLang'] = self.user_lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UserLang') is not None:
            self.user_lang = m.get('UserLang')
        return self


class ChangeUserLangResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ChangeUserLangResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ChangeUserLangResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeUserLangResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckSecurityEventIdRequest(TeaModel):
    def __init__(
        self,
        security_event_ids: List[str] = None,
        uuid: str = None,
    ):
        # The IDs of alert events. You can specify up to 100 IDs. If you do not specify this parameter, the value of the response parameter **Data** is **false**. The value false indicates that no alert events are generated on the server.
        # 
        # > You can call the [DescribeSuspEvents](~~DescribeSuspEvents~~) operation to query the IDs of alert events.
        self.security_event_ids = security_event_ids
        # The UUID of the server.
        # 
        # > You can call the [DescribeCloudCenterInstances](~~DescribeCloudCenterInstances~~) operation to query the UUIDs of servers.
        # 
        # This parameter is required.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_event_ids is not None:
            result['SecurityEventIds'] = self.security_event_ids
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityEventIds') is not None:
            self.security_event_ids = m.get('SecurityEventIds')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class CheckSecurityEventIdResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        # Indicates whether the alert events are generated on the server. Valid values:
        # 
        # *   **true**\
        # *   **false**: no
        self.data = data
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckSecurityEventIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CheckSecurityEventIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckSecurityEventIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckStsTokenAuthResponseBody(TeaModel):
    def __init__(
        self,
        data: int = None,
        request_id: str = None,
    ):
        # The ID of the Alibaba Cloud account.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckStsTokenAuthResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CheckStsTokenAuthResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckStsTokenAuthResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckTrialFixCountRequest(TeaModel):
    def __init__(
        self,
        info: str = None,
        type: str = None,
        uuids: List[str] = None,
        vul_names: List[str] = None,
    ):
        # The information about the vulnerability. The value of this parameter is in the JSON format and contains the following fields:
        # 
        # *   **name**: the name of the vulnerability.
        # 
        # *   **uuid**: the UUID of the server on which the vulnerability is detected.
        # 
        # *   **tag**: the tag that is added to the vulnerability. Valid values:
        # 
        #     *   **oval**: Linux software vulnerability.
        #     *   **system**: Windows system vulnerability.
        #     *   **cms**: Web-CMS vulnerability.
        # 
        # >  You must specify a value for Info or values for VulNames and Uuids to identify a vulnerability.
        self.info = info
        # The type of the vulnerability that you want to fix. Valid values:
        # 
        # *   **cve**: Linux software vulnerability.
        # *   **sys**: Windows system vulnerability.
        # *   **cms**: Web-CMS vulnerability.
        # 
        # This parameter is required.
        self.type = type
        # The UUIDs of the servers.
        self.uuids = uuids
        # The names of the vulnerabilities.
        self.vul_names = vul_names

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.info is not None:
            result['Info'] = self.info
        if self.type is not None:
            result['Type'] = self.type
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        if self.vul_names is not None:
            result['VulNames'] = self.vul_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Info') is not None:
            self.info = m.get('Info')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        if m.get('VulNames') is not None:
            self.vul_names = m.get('VulNames')
        return self


class CheckTrialFixCountResponseBody(TeaModel):
    def __init__(
        self,
        can_fix: bool = None,
        expend_count: int = None,
        remain_count: int = None,
        repaired_count: int = None,
        request_id: str = None,
        is_trial: bool = None,
    ):
        # Indicates whether the vulnerability can be fixed. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.can_fix = can_fix
        # The quota usage required for the current fix operation.
        self.expend_count = expend_count
        # The quota that remains after the current fix operation is complete.
        self.remain_count = remain_count
        # The number of the vulnerabilities that are fixed.
        self.repaired_count = repaired_count
        # The request ID.
        self.request_id = request_id
        # Indicates whether Security Center is in free trial. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.is_trial = is_trial

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.can_fix is not None:
            result['CanFix'] = self.can_fix
        if self.expend_count is not None:
            result['ExpendCount'] = self.expend_count
        if self.remain_count is not None:
            result['RemainCount'] = self.remain_count
        if self.repaired_count is not None:
            result['RepairedCount'] = self.repaired_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.is_trial is not None:
            result['isTrial'] = self.is_trial
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CanFix') is not None:
            self.can_fix = m.get('CanFix')
        if m.get('ExpendCount') is not None:
            self.expend_count = m.get('ExpendCount')
        if m.get('RemainCount') is not None:
            self.remain_count = m.get('RemainCount')
        if m.get('RepairedCount') is not None:
            self.repaired_count = m.get('RepairedCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('isTrial') is not None:
            self.is_trial = m.get('isTrial')
        return self


class CheckTrialFixCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CheckTrialFixCountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckTrialFixCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckUserHasEcsRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class CheckUserHasEcsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. The status code **200** indicates that the request is successful. Other status codes indicate that the request fails. You can identify the cause of the failure based on the status code.
        self.code = code
        # Indicates whether ECS instances exist. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.data = data
        # The error message returned.
        self.message = message
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # The status of the request. Valid values:
        # 
        # *   **true**: The request is successful.
        # *   **false**: The request fails.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CheckUserHasEcsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CheckUserHasEcsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckUserHasEcsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConfirmVirusEventsRequest(TeaModel):
    def __init__(
        self,
        operation_all: int = None,
        operation_code: str = None,
        operation_range: str = None,
    ):
        # Specifies whether to handle all alert events. Valid values:
        # 
        # *   **1**: yes
        # *   **0**: no
        # 
        # This parameter is required.
        self.operation_all = operation_all
        # The operation that you want to perform on the alert events. Valid values:
        # 
        # *   **default**: performs in-depth detection and removal
        # *   **ignore**: ignores the alert event
        # *   **advance_mark_mis_info**: adds the alert events to the whitelist
        # *   **manual_handled**: marks the alert events as manually handled
        # 
        # This parameter is required.
        self.operation_code = operation_code
        # The server on which you want to perform the alert events.
        self.operation_range = operation_range

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operation_all is not None:
            result['OperationAll'] = self.operation_all
        if self.operation_code is not None:
            result['OperationCode'] = self.operation_code
        if self.operation_range is not None:
            result['OperationRange'] = self.operation_range
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OperationAll') is not None:
            self.operation_all = m.get('OperationAll')
        if m.get('OperationCode') is not None:
            self.operation_code = m.get('OperationCode')
        if m.get('OperationRange') is not None:
            self.operation_range = m.get('OperationRange')
        return self


class ConfirmVirusEventsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: bool = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true: The request was successful.
        # *   false: The request failed.
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class ConfirmVirusEventsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ConfirmVirusEventsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ConfirmVirusEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyCustomizeReportConfigRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        report_id: int = None,
        source_ip: str = None,
    ):
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The ID of the report.
        # 
        # >  You can call the [DescribeCustomizeReportList](~~DescribeCustomizeReportList~~) operation to query the ID.
        # 
        # This parameter is required.
        self.report_id = report_id
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class CopyCustomizeReportConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CopyCustomizeReportConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CopyCustomizeReportConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CopyCustomizeReportConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAgentlessScanTaskRequest(TeaModel):
    def __init__(
        self,
        asset_selection_type: str = None,
        auto_delete_days: int = None,
        release_after_scan: bool = None,
        scan_data_disk: bool = None,
        target_type: int = None,
        uuid_list: List[str] = None,
    ):
        # Identification of asset selection.
        self.asset_selection_type = asset_selection_type
        # The retention period of images. Unit: days.
        self.auto_delete_days = auto_delete_days
        # Specifies whether to enable the cost-saving mode. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.release_after_scan = release_after_scan
        # Specifies whether to check data disks. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.scan_data_disk = scan_data_disk
        # The type of the detection object. Valid values:
        # 
        # *   **2**: image
        # 
        # This parameter is required.
        self.target_type = target_type
        # The UUIDs of the assets on which you want to run the detection task.
        # 
        # >  You can call the [DescribeCloudCenterInstances](~~DescribeCloudCenterInstances~~) operation to query the UUIDs of servers.
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_selection_type is not None:
            result['AssetSelectionType'] = self.asset_selection_type
        if self.auto_delete_days is not None:
            result['AutoDeleteDays'] = self.auto_delete_days
        if self.release_after_scan is not None:
            result['ReleaseAfterScan'] = self.release_after_scan
        if self.scan_data_disk is not None:
            result['ScanDataDisk'] = self.scan_data_disk
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetSelectionType') is not None:
            self.asset_selection_type = m.get('AssetSelectionType')
        if m.get('AutoDeleteDays') is not None:
            self.auto_delete_days = m.get('AutoDeleteDays')
        if m.get('ReleaseAfterScan') is not None:
            self.release_after_scan = m.get('ReleaseAfterScan')
        if m.get('ScanDataDisk') is not None:
            self.scan_data_disk = m.get('ScanDataDisk')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class CreateAgentlessScanTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAgentlessScanTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAgentlessScanTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAgentlessScanTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAntiBruteForceRuleRequestProtocolType(TeaModel):
    def __init__(
        self,
        rdp: str = None,
        sql_server: str = None,
        ssh: str = None,
    ):
        # Whether to enable RDP interception, default is on. Values: 
        # - **on**: Enable 
        # - **off**: Disable
        self.rdp = rdp
        # Whether to enable the SqlServer interception method, default is off. Values: 
        # - **on**: Enable 
        # - **off**: Disable
        self.sql_server = sql_server
        # Whether to enable SSH interception, default is on. Values: 
        # - **on**: Enable 
        # - **off**: Disable
        self.ssh = ssh

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rdp is not None:
            result['Rdp'] = self.rdp
        if self.sql_server is not None:
            result['SqlServer'] = self.sql_server
        if self.ssh is not None:
            result['Ssh'] = self.ssh
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Rdp') is not None:
            self.rdp = m.get('Rdp')
        if m.get('SqlServer') is not None:
            self.sql_server = m.get('SqlServer')
        if m.get('Ssh') is not None:
            self.ssh = m.get('Ssh')
        return self


class CreateAntiBruteForceRuleRequest(TeaModel):
    def __init__(
        self,
        default_rule: bool = None,
        fail_count: int = None,
        forbidden_time: int = None,
        name: str = None,
        protocol_type: CreateAntiBruteForceRuleRequestProtocolType = None,
        resource_owner_id: int = None,
        source_ip: str = None,
        span: int = None,
        uuid_list: List[str] = None,
    ):
        # Specifies whether to set the defense rule as the default rule. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.default_rule = default_rule
        # The maximum number of failed logon attempts from an account. Valid values: 2, 3, 4, 5, 10, 50, 80, and 100.
        # 
        # This parameter is required.
        self.fail_count = fail_count
        # The period of time during which logons from an account are not allowed. Unit: minutes. Valid values:
        # 
        # *   **5**\
        # *   **15**\
        # *   **30**\
        # *   **60**\
        # *   **120**\
        # *   **360**\
        # *   **720**\
        # *   **1440**\
        # *   **10080**\
        # *   **52560000**: permanent
        # 
        # This parameter is required.
        self.forbidden_time = forbidden_time
        # The name of the defense rule.
        # 
        # This parameter is required.
        self.name = name
        # The types of protocols supported for interception by the brute force attack rule creation.
        self.protocol_type = protocol_type
        self.resource_owner_id = resource_owner_id
        # The source IP address of the request.
        self.source_ip = source_ip
        # The maximum period of time during which failed logon attempts from an account can occur. Unit: minutes. Valid values:
        # 
        # *   **1**\
        # *   **2**\
        # *   **5**\
        # *   **10**\
        # *   **15**\
        # 
        # >  To configure a defense rule, you must specify the Span, FailCount, and ForbiddenTime parameters. If the number of failed logon attempts from an account within the minutes specified by Span exceeds the value specified by FailCount, the account cannot be used for logons within the minutes specified by ForbiddenTime.
        # 
        # This parameter is required.
        self.span = span
        # The UUIDs of the servers to which you want to apply the defense rule.
        # 
        # This parameter is required.
        self.uuid_list = uuid_list

    def validate(self):
        if self.protocol_type:
            self.protocol_type.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_rule is not None:
            result['DefaultRule'] = self.default_rule
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.forbidden_time is not None:
            result['ForbiddenTime'] = self.forbidden_time
        if self.name is not None:
            result['Name'] = self.name
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type.to_map()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.span is not None:
            result['Span'] = self.span
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultRule') is not None:
            self.default_rule = m.get('DefaultRule')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('ForbiddenTime') is not None:
            self.forbidden_time = m.get('ForbiddenTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProtocolType') is not None:
            temp_model = CreateAntiBruteForceRuleRequestProtocolType()
            self.protocol_type = temp_model.from_map(m['ProtocolType'])
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Span') is not None:
            self.span = m.get('Span')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class CreateAntiBruteForceRuleShrinkRequest(TeaModel):
    def __init__(
        self,
        default_rule: bool = None,
        fail_count: int = None,
        forbidden_time: int = None,
        name: str = None,
        protocol_type_shrink: str = None,
        resource_owner_id: int = None,
        source_ip: str = None,
        span: int = None,
        uuid_list: List[str] = None,
    ):
        # Specifies whether to set the defense rule as the default rule. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.default_rule = default_rule
        # The maximum number of failed logon attempts from an account. Valid values: 2, 3, 4, 5, 10, 50, 80, and 100.
        # 
        # This parameter is required.
        self.fail_count = fail_count
        # The period of time during which logons from an account are not allowed. Unit: minutes. Valid values:
        # 
        # *   **5**\
        # *   **15**\
        # *   **30**\
        # *   **60**\
        # *   **120**\
        # *   **360**\
        # *   **720**\
        # *   **1440**\
        # *   **10080**\
        # *   **52560000**: permanent
        # 
        # This parameter is required.
        self.forbidden_time = forbidden_time
        # The name of the defense rule.
        # 
        # This parameter is required.
        self.name = name
        # The types of protocols supported for interception by the brute force attack rule creation.
        self.protocol_type_shrink = protocol_type_shrink
        self.resource_owner_id = resource_owner_id
        # The source IP address of the request.
        self.source_ip = source_ip
        # The maximum period of time during which failed logon attempts from an account can occur. Unit: minutes. Valid values:
        # 
        # *   **1**\
        # *   **2**\
        # *   **5**\
        # *   **10**\
        # *   **15**\
        # 
        # >  To configure a defense rule, you must specify the Span, FailCount, and ForbiddenTime parameters. If the number of failed logon attempts from an account within the minutes specified by Span exceeds the value specified by FailCount, the account cannot be used for logons within the minutes specified by ForbiddenTime.
        # 
        # This parameter is required.
        self.span = span
        # The UUIDs of the servers to which you want to apply the defense rule.
        # 
        # This parameter is required.
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_rule is not None:
            result['DefaultRule'] = self.default_rule
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.forbidden_time is not None:
            result['ForbiddenTime'] = self.forbidden_time
        if self.name is not None:
            result['Name'] = self.name
        if self.protocol_type_shrink is not None:
            result['ProtocolType'] = self.protocol_type_shrink
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.span is not None:
            result['Span'] = self.span
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultRule') is not None:
            self.default_rule = m.get('DefaultRule')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('ForbiddenTime') is not None:
            self.forbidden_time = m.get('ForbiddenTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProtocolType') is not None:
            self.protocol_type_shrink = m.get('ProtocolType')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Span') is not None:
            self.span = m.get('Span')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class CreateAntiBruteForceRuleResponseBodyCreateAntiBruteForceRule(TeaModel):
    def __init__(
        self,
        rule_id: int = None,
    ):
        # The ID of the defense rule.
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class CreateAntiBruteForceRuleResponseBody(TeaModel):
    def __init__(
        self,
        create_anti_brute_force_rule: CreateAntiBruteForceRuleResponseBodyCreateAntiBruteForceRule = None,
        request_id: str = None,
    ):
        # The information about the defense rule.
        self.create_anti_brute_force_rule = create_anti_brute_force_rule
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.create_anti_brute_force_rule:
            self.create_anti_brute_force_rule.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_anti_brute_force_rule is not None:
            result['CreateAntiBruteForceRule'] = self.create_anti_brute_force_rule.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateAntiBruteForceRule') is not None:
            temp_model = CreateAntiBruteForceRuleResponseBodyCreateAntiBruteForceRule()
            self.create_anti_brute_force_rule = temp_model.from_map(m['CreateAntiBruteForceRule'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAntiBruteForceRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAntiBruteForceRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAntiBruteForceRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAssetSelectionConfigRequest(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        platform: str = None,
        target_type: str = None,
    ):
        # The feature that you want to select for the asset. Valid values:
        # 
        # *   **VIRUS_SCAN_CYCLE_CONFIG**: virus detection and removal
        # *   **VIRUS_SCAN_ONCE_TASK**: one-time scan for viruses
        # *   **AGENTLESS_MALICIOUS_WHITE_LIST_[ID]**: a whitelist rule for alerts that are detected by using the agentless detection feature
        # *   **AGENTLESS_VUL_WHITE_LIST_[ID]**: a whitelist rule for vulnerabilities that are detected by using the agentless detection feature
        # *   **FILE_PROTECT_RULE_SWITCH_TYPE_[ID]**: core file protection
        # 
        # This parameter is required.
        self.business_type = business_type
        # The operating system of the asset. Valid values:
        # 
        # *   **all**: all operating systems
        # *   **windows**: the Windows operating system
        # *   **linux**: the Linux operating system
        # 
        # >  If you leave this parameter empty, the system automatically selects a value for the parameter based on the value of the **BusinessType** parameter.
        # 
        # *   If the BusinessType parameter is set to **VIRUS_SCAN_CYCLE_CONFIG**, the value of the Platform parameter is **all**.
        # 
        # *   If the BusinessType parameter is set to **VIRUS_SCAN_ONCE_TASK**, the value of the Platform parameter is **all**.
        # 
        # *   If the BusinessType parameter is set to **AGENTLESS_MALICIOUS_WHITE_LIST_[ID]**, the value of the Platform parameter is **all**.
        # 
        # *   If the BusinessType parameter is set to **AGENTLESS_VUL_WHITE_LIST_[ID]** the value of the Platform parameter is **all**.
        # 
        # *   If the BusinessType parameter is set to **FILE_PROTECT_RULE_SWITCH_TYPE_[ID]**, the value of the Platform parameter is **linux**.
        self.platform = platform
        # The dimension based on which you want to select the asset. Valid values:
        # 
        # *   **instance**: selects the asset by server.
        # *   **group**: selects the asset by group.
        # *   **vpc**: selects the asset by virtual private cloud (VPC).
        # 
        # This parameter is required.
        self.target_type = target_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class CreateAssetSelectionConfigResponseBodyData(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        platform: str = None,
        selection_key: int = None,
        target_type: str = None,
    ):
        # The business type that is selected for the asset. Valid values:
        # 
        # *   **VIRUS_SCAN_CYCLE_CONFIG**: virus detection configuration
        # *   **VIRUS_SCAN_ONCE_TASK**: one-time scan for virus detection
        self.business_type = business_type
        # The operating system of the asset. Valid values:
        # 
        # *   **windows**: the Windows operating system
        # *   **linux**: the Linux operating system
        self.platform = platform
        # The ID of the current asset selection. It can be used to query and modify the asset that is selected.
        self.selection_key = selection_key
        # The dimension based on which the asset is selected. Valid values:
        # 
        # *   **instance**: The asset is selected by server.
        # *   **group**: The asset is selected by group.
        # *   **vpc**: The asset is selected by VPC.
        self.target_type = target_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.selection_key is not None:
            result['SelectionKey'] = self.selection_key
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('SelectionKey') is not None:
            self.selection_key = m.get('SelectionKey')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class CreateAssetSelectionConfigResponseBody(TeaModel):
    def __init__(
        self,
        data: CreateAssetSelectionConfigResponseBodyData = None,
        request_id: str = None,
    ):
        # The returned data.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateAssetSelectionConfigResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAssetSelectionConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAssetSelectionConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAssetSelectionConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAttackPathSensitiveAssetConfigRequestAttackPathAssetList(TeaModel):
    def __init__(
        self,
        asset_sub_type: int = None,
        asset_type: int = None,
        instance_id: str = None,
        region_id: str = None,
        vendor: int = None,
    ):
        # Subtype of the cloud product asset.
        # 
        # > You can call [ListCloudAssetInstances](~~ListCloudAssetInstances~~) to query the subtype of the cloud product asset.
        # 
        # This parameter is required.
        self.asset_sub_type = asset_sub_type
        # Type of the cloud product asset.
        # 
        # > You can call [ListCloudAssetInstances](~~ListCloudAssetInstances~~) to query the type of the cloud product asset.
        # 
        # This parameter is required.
        self.asset_type = asset_type
        # Cloud product asset instance ID.
        # 
        # > You can call [ListCloudAssetInstances](~~ListCloudAssetInstances~~) to query the cloud product asset instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # Region ID of the cloud product asset instance.
        # 
        # > You can call [ListCloudAssetInstances](~~ListCloudAssetInstances~~) to query the region ID of the cloud product asset instance.
        # 
        # This parameter is required.
        self.region_id = region_id
        # Cloud product asset vendor.
        # 
        # > You can call [ListCloudAssetInstances](~~ListCloudAssetInstances~~) to query the cloud product asset vendor.
        # 
        # This parameter is required.
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_sub_type is not None:
            result['AssetSubType'] = self.asset_sub_type
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetSubType') is not None:
            self.asset_sub_type = m.get('AssetSubType')
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class CreateAttackPathSensitiveAssetConfigRequest(TeaModel):
    def __init__(
        self,
        attack_path_asset_list: List[CreateAttackPathSensitiveAssetConfigRequestAttackPathAssetList] = None,
        config_type: str = None,
    ):
        # List of cloud product assets.
        # 
        # This parameter is required.
        self.attack_path_asset_list = attack_path_asset_list
        # Configuration type. Possible values:
        # - asset_instance: Asset.
        # 
        # This parameter is required.
        self.config_type = config_type

    def validate(self):
        if self.attack_path_asset_list:
            for k in self.attack_path_asset_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AttackPathAssetList'] = []
        if self.attack_path_asset_list is not None:
            for k in self.attack_path_asset_list:
                result['AttackPathAssetList'].append(k.to_map() if k else None)
        if self.config_type is not None:
            result['ConfigType'] = self.config_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attack_path_asset_list = []
        if m.get('AttackPathAssetList') is not None:
            for k in m.get('AttackPathAssetList'):
                temp_model = CreateAttackPathSensitiveAssetConfigRequestAttackPathAssetList()
                self.attack_path_asset_list.append(temp_model.from_map(k))
        if m.get('ConfigType') is not None:
            self.config_type = m.get('ConfigType')
        return self


class CreateAttackPathSensitiveAssetConfigResponseBodyAttackPathSensitiveAssetConfig(TeaModel):
    def __init__(
        self,
        attack_path_sensitive_asset_config_id: str = None,
    ):
        # ID for setting sensitive assets in the attack path.
        self.attack_path_sensitive_asset_config_id = attack_path_sensitive_asset_config_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attack_path_sensitive_asset_config_id is not None:
            result['AttackPathSensitiveAssetConfigId'] = self.attack_path_sensitive_asset_config_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttackPathSensitiveAssetConfigId') is not None:
            self.attack_path_sensitive_asset_config_id = m.get('AttackPathSensitiveAssetConfigId')
        return self


class CreateAttackPathSensitiveAssetConfigResponseBody(TeaModel):
    def __init__(
        self,
        attack_path_sensitive_asset_config: CreateAttackPathSensitiveAssetConfigResponseBodyAttackPathSensitiveAssetConfig = None,
        request_id: str = None,
    ):
        # Data of the attack path sensitive asset settings.
        self.attack_path_sensitive_asset_config = attack_path_sensitive_asset_config
        # The ID of this request, which is a unique identifier generated by Alibaba Cloud for this request and can be used for troubleshooting and problem localization.
        self.request_id = request_id

    def validate(self):
        if self.attack_path_sensitive_asset_config:
            self.attack_path_sensitive_asset_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attack_path_sensitive_asset_config is not None:
            result['AttackPathSensitiveAssetConfig'] = self.attack_path_sensitive_asset_config.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttackPathSensitiveAssetConfig') is not None:
            temp_model = CreateAttackPathSensitiveAssetConfigResponseBodyAttackPathSensitiveAssetConfig()
            self.attack_path_sensitive_asset_config = temp_model.from_map(m['AttackPathSensitiveAssetConfig'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAttackPathSensitiveAssetConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAttackPathSensitiveAssetConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAttackPathSensitiveAssetConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAttackPathWhitelistRequestAttackPathAssetList(TeaModel):
    def __init__(
        self,
        asset_sub_type: int = None,
        asset_type: int = None,
        instance_id: str = None,
        node_type: str = None,
        region_id: str = None,
        vendor: int = None,
    ):
        # Subtype of the cloud product asset.
        # 
        # > You can call [ListCloudAssetInstances](~~ListCloudAssetInstances~~) to query the subtype of the cloud product asset.
        self.asset_sub_type = asset_sub_type
        # Type of the cloud product asset.
        # 
        # > You can call [ListCloudAssetInstances](~~ListCloudAssetInstances~~) to query the type of the cloud product asset.
        self.asset_type = asset_type
        # Cloud product asset instance ID.
        # 
        # > You can call [ListCloudAssetInstances](~~ListCloudAssetInstances~~) to query the cloud product asset instance ID.
        self.instance_id = instance_id
        # Node type, with values:
        # - **start**: Start point.
        # - **end**: End point.
        self.node_type = node_type
        # Region ID of the cloud product asset instance.
        # 
        # > You can call [ListCloudAssetInstances](~~ListCloudAssetInstances~~) to query the region ID of the cloud product asset instance.
        self.region_id = region_id
        # Vendor of the cloud product asset.
        # 
        # > You can call [ListCloudAssetInstances](~~ListCloudAssetInstances~~) to query the vendor of the cloud product asset.
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_sub_type is not None:
            result['AssetSubType'] = self.asset_sub_type
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetSubType') is not None:
            self.asset_sub_type = m.get('AssetSubType')
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class CreateAttackPathWhitelistRequest(TeaModel):
    def __init__(
        self,
        attack_path_asset_list: List[CreateAttackPathWhitelistRequestAttackPathAssetList] = None,
        path_name: str = None,
        path_type: str = None,
        remark: str = None,
        whitelist_name: str = None,
        whitelist_type: str = None,
    ):
        # List of cloud product assets in the attack path.
        self.attack_path_asset_list = attack_path_asset_list
        # Path name.
        # 
        # > You can call [ListAvailableAttackPath](~~ListAvailableAttackPath~~) to query the path name.
        self.path_name = path_name
        # Path type.
        # > You can call [ListAvailableAttackPath](~~ListAvailableAttackPath~~) to query the path type.
        # 
        # This parameter is required.
        self.path_type = path_type
        # Remark information.
        self.remark = remark
        # Whitelist name.
        # 
        # This parameter is required.
        self.whitelist_name = whitelist_name
        # Whitelist type. Values:
        # 
        # - **ALL_ASSET**: All assets
        # - **PART_ASSET**: Partial assets
        # 
        # This parameter is required.
        self.whitelist_type = whitelist_type

    def validate(self):
        if self.attack_path_asset_list:
            for k in self.attack_path_asset_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AttackPathAssetList'] = []
        if self.attack_path_asset_list is not None:
            for k in self.attack_path_asset_list:
                result['AttackPathAssetList'].append(k.to_map() if k else None)
        if self.path_name is not None:
            result['PathName'] = self.path_name
        if self.path_type is not None:
            result['PathType'] = self.path_type
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.whitelist_name is not None:
            result['WhitelistName'] = self.whitelist_name
        if self.whitelist_type is not None:
            result['WhitelistType'] = self.whitelist_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attack_path_asset_list = []
        if m.get('AttackPathAssetList') is not None:
            for k in m.get('AttackPathAssetList'):
                temp_model = CreateAttackPathWhitelistRequestAttackPathAssetList()
                self.attack_path_asset_list.append(temp_model.from_map(k))
        if m.get('PathName') is not None:
            self.path_name = m.get('PathName')
        if m.get('PathType') is not None:
            self.path_type = m.get('PathType')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('WhitelistName') is not None:
            self.whitelist_name = m.get('WhitelistName')
        if m.get('WhitelistType') is not None:
            self.whitelist_type = m.get('WhitelistType')
        return self


class CreateAttackPathWhitelistResponseBodyAttackPathWhitelist(TeaModel):
    def __init__(
        self,
        attack_path_whitelist_id: str = None,
    ):
        # Attack path whitelist ID.
        self.attack_path_whitelist_id = attack_path_whitelist_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attack_path_whitelist_id is not None:
            result['AttackPathWhitelistId'] = self.attack_path_whitelist_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttackPathWhitelistId') is not None:
            self.attack_path_whitelist_id = m.get('AttackPathWhitelistId')
        return self


class CreateAttackPathWhitelistResponseBody(TeaModel):
    def __init__(
        self,
        attack_path_whitelist: CreateAttackPathWhitelistResponseBodyAttackPathWhitelist = None,
        request_id: str = None,
    ):
        # Attack path whitelist.
        self.attack_path_whitelist = attack_path_whitelist
        # The ID of this request, which is a unique identifier generated by Alibaba Cloud for this request and can be used for troubleshooting and problem localization.
        self.request_id = request_id

    def validate(self):
        if self.attack_path_whitelist:
            self.attack_path_whitelist.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attack_path_whitelist is not None:
            result['AttackPathWhitelist'] = self.attack_path_whitelist.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttackPathWhitelist') is not None:
            temp_model = CreateAttackPathWhitelistResponseBodyAttackPathWhitelist()
            self.attack_path_whitelist = temp_model.from_map(m['AttackPathWhitelist'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAttackPathWhitelistResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAttackPathWhitelistResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAttackPathWhitelistResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAttestorRequest(TeaModel):
    def __init__(
        self,
        key_id: str = None,
        key_region_id: str = None,
        key_version_id: str = None,
        name: str = None,
        remark: str = None,
        resource_owner_id: int = None,
        source_ip: str = None,
    ):
        # The ID of the KMS key.
        self.key_id = key_id
        # The region ID of the Key Management Service (KMS) key.
        self.key_region_id = key_region_id
        # The version ID of the KMS key.
        self.key_version_id = key_version_id
        # The name of the witness.
        self.name = name
        # The description.
        self.remark = remark
        self.resource_owner_id = resource_owner_id
        # The source IP address.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key_id is not None:
            result['KeyId'] = self.key_id
        if self.key_region_id is not None:
            result['KeyRegionId'] = self.key_region_id
        if self.key_version_id is not None:
            result['KeyVersionId'] = self.key_version_id
        if self.name is not None:
            result['Name'] = self.name
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('KeyId') is not None:
            self.key_id = m.get('KeyId')
        if m.get('KeyRegionId') is not None:
            self.key_region_id = m.get('KeyRegionId')
        if m.get('KeyVersionId') is not None:
            self.key_version_id = m.get('KeyVersionId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class CreateAttestorResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAttestorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAttestorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAttestorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBackupPolicyRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        policy: Dict[str, Any] = None,
        policy_region_id: str = None,
        policy_version: str = None,
        uuid_list: List[str] = None,
    ):
        # The name of the anti-ransomware policy.
        # 
        # This parameter is required.
        self.name = name
        # *   **IsDefault**: the type of the anti-ransomware policy. Valid values:
        # 
        #     *   **1**: recommended policy
        #     *   **0**: custom policy
        # 
        # *   **Include**: the format of the files that you want to protect. If you want to protect the files in all formats, set this field to [].
        # 
        # *   **Source**: the directory that you want to protect. If you want to protect all directories, set this field to [].
        # 
        # *   **ExcludeSystemPath**: specifies whether to exclude a specific directory from the anti-ransomware policy. If you want to exclude a directory, set this field to **true**. If you do not want to exclude a directory, leave this field empty.
        # 
        # *   **Exclude**: the directory that you want to exclude from the anti-ransomware policy. If you do not want to exclude a directory, set this field to [].
        # 
        # *   **Schedule**: the start time and interval of a data backup task. We recommend that you specify a start time that begins during off-peak hours but does not start on the hour. Examples:
        # 
        #     *   If you set this field to I|1583216092|P21D, the data backup task starts from 2020-03-03 14:14:52, and the task is run at an interval of three weeks.
        #     *   If you set this field to I|1583216092|PT24H, the data backup task starts from 2020-03-03 14:14:52, and the task is run at an interval of 24 hours.
        # 
        # *   **Retention**: the period during which backup data is retained. Unit: days. If you set this field to 7, backup data is retained for a week. If you set this field to 365, backup data is retained for a year. If you set this field to -1, backup data is permanently retained.
        # 
        # *   **SpeedLimiter**: the limit on the network bandwidth for data backup tasks. If you set this field to 0:24:30720, the maximum bandwidth for a data backup task is 30 MB/s from 00:00 to 24:00.
        # 
        # *   **UseVss**: specifies whether to enable the VSS feature. The feature is available only for Windows servers. Valid values:
        # 
        #     *   **true**: yes
        #     *   **false**: no
        # 
        # >  The VSS feature is available only if you create the anti-ransomware policy for Windows servers. After you enable the feature, the number of backup failures due to running processes is significantly reduced. We recommend that you enable the VSS feature. After you enable the feature, the data of disks that are in the exFAT and FAT32 formats cannot be backed up.
        # 
        # This parameter is required.
        self.policy = policy
        # The region ID of the server that is not deployed on Alibaba Cloud.
        # 
        # >  We recommend that you specify the ID of the supported region that is the nearest to the location of the server. You can call the [DescribeSupportRegion](~~DescribeSupportRegion~~) operation to query the supported regions of the anti-ransomware feature.
        self.policy_region_id = policy_region_id
        # The version of the anti-ransomware policy. Set the value to **2.0.0**.
        # 
        # This parameter is required.
        self.policy_version = policy_version
        # The UUIDs of the servers that you want to protect.
        # 
        # This parameter is required.
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.policy_region_id is not None:
            result['PolicyRegionId'] = self.policy_region_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PolicyRegionId') is not None:
            self.policy_region_id = m.get('PolicyRegionId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class CreateBackupPolicyShrinkRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        policy_shrink: str = None,
        policy_region_id: str = None,
        policy_version: str = None,
        uuid_list: List[str] = None,
    ):
        # The name of the anti-ransomware policy.
        # 
        # This parameter is required.
        self.name = name
        # *   **IsDefault**: the type of the anti-ransomware policy. Valid values:
        # 
        #     *   **1**: recommended policy
        #     *   **0**: custom policy
        # 
        # *   **Include**: the format of the files that you want to protect. If you want to protect the files in all formats, set this field to [].
        # 
        # *   **Source**: the directory that you want to protect. If you want to protect all directories, set this field to [].
        # 
        # *   **ExcludeSystemPath**: specifies whether to exclude a specific directory from the anti-ransomware policy. If you want to exclude a directory, set this field to **true**. If you do not want to exclude a directory, leave this field empty.
        # 
        # *   **Exclude**: the directory that you want to exclude from the anti-ransomware policy. If you do not want to exclude a directory, set this field to [].
        # 
        # *   **Schedule**: the start time and interval of a data backup task. We recommend that you specify a start time that begins during off-peak hours but does not start on the hour. Examples:
        # 
        #     *   If you set this field to I|1583216092|P21D, the data backup task starts from 2020-03-03 14:14:52, and the task is run at an interval of three weeks.
        #     *   If you set this field to I|1583216092|PT24H, the data backup task starts from 2020-03-03 14:14:52, and the task is run at an interval of 24 hours.
        # 
        # *   **Retention**: the period during which backup data is retained. Unit: days. If you set this field to 7, backup data is retained for a week. If you set this field to 365, backup data is retained for a year. If you set this field to -1, backup data is permanently retained.
        # 
        # *   **SpeedLimiter**: the limit on the network bandwidth for data backup tasks. If you set this field to 0:24:30720, the maximum bandwidth for a data backup task is 30 MB/s from 00:00 to 24:00.
        # 
        # *   **UseVss**: specifies whether to enable the VSS feature. The feature is available only for Windows servers. Valid values:
        # 
        #     *   **true**: yes
        #     *   **false**: no
        # 
        # >  The VSS feature is available only if you create the anti-ransomware policy for Windows servers. After you enable the feature, the number of backup failures due to running processes is significantly reduced. We recommend that you enable the VSS feature. After you enable the feature, the data of disks that are in the exFAT and FAT32 formats cannot be backed up.
        # 
        # This parameter is required.
        self.policy_shrink = policy_shrink
        # The region ID of the server that is not deployed on Alibaba Cloud.
        # 
        # >  We recommend that you specify the ID of the supported region that is the nearest to the location of the server. You can call the [DescribeSupportRegion](~~DescribeSupportRegion~~) operation to query the supported regions of the anti-ransomware feature.
        self.policy_region_id = policy_region_id
        # The version of the anti-ransomware policy. Set the value to **2.0.0**.
        # 
        # This parameter is required.
        self.policy_version = policy_version
        # The UUIDs of the servers that you want to protect.
        # 
        # This parameter is required.
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_shrink is not None:
            result['Policy'] = self.policy_shrink
        if self.policy_region_id is not None:
            result['PolicyRegionId'] = self.policy_region_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy_shrink = m.get('Policy')
        if m.get('PolicyRegionId') is not None:
            self.policy_region_id = m.get('PolicyRegionId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class CreateBackupPolicyResponseBodyBackupPolicy(TeaModel):
    def __init__(
        self,
        id: str = None,
        status: str = None,
    ):
        # The ID of the anti-ransomware policy.
        self.id = id
        # The status of the anti-ransomware policy. Valid values:
        # 
        # *   **enabled**\
        # *   **disabled**\
        # 
        # >  After you create an anti-ransomware policy, the policy is enabled by default.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateBackupPolicyResponseBody(TeaModel):
    def __init__(
        self,
        backup_policy: CreateBackupPolicyResponseBodyBackupPolicy = None,
        request_id: str = None,
    ):
        # The information about the anti-ransomware policy.
        self.backup_policy = backup_policy
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.backup_policy:
            self.backup_policy.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_policy is not None:
            result['BackupPolicy'] = self.backup_policy.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupPolicy') is not None:
            temp_model = CreateBackupPolicyResponseBodyBackupPolicy()
            self.backup_policy = temp_model.from_map(m['BackupPolicy'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateBackupPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateBackupPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBatchUploadUrlRequest(TeaModel):
    def __init__(
        self,
        md_5list: List[str] = None,
        type: int = None,
    ):
        # The identifiers of files. Only MD5 hash values are supported.
        # 
        # This parameter is required.
        self.md_5list = md_5list
        # The type of the file. Valid values:
        # 
        # *   **0**: unknown file
        # *   **1**: binary file
        # *   **2**: webshell file
        # *   **4**: script file
        # 
        # > If you do not know the type of the file, set this parameter to **0**.
        # 
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.md_5list is not None:
            result['Md5List'] = self.md_5list
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Md5List') is not None:
            self.md_5list = m.get('Md5List')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateBatchUploadUrlResponseBodyUploadUrlListContext(TeaModel):
    def __init__(
        self,
        access_id: str = None,
        oss_key: str = None,
        policy: str = None,
        signature: str = None,
    ):
        # The AccessKey ID that is used to access the OSS bucket.
        self.access_id = access_id
        # The key of the file that is used after the file is uploaded to the OSS bucket.
        self.oss_key = oss_key
        # The policy that poses limits on file upload. For example, the policy can limit the size of the file.
        self.policy = policy
        # The signature that is used to upload the file.
        self.signature = signature

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_id is not None:
            result['AccessId'] = self.access_id
        if self.oss_key is not None:
            result['OssKey'] = self.oss_key
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.signature is not None:
            result['Signature'] = self.signature
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessId') is not None:
            self.access_id = m.get('AccessId')
        if m.get('OssKey') is not None:
            self.oss_key = m.get('OssKey')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        return self


class CreateBatchUploadUrlResponseBodyUploadUrlList(TeaModel):
    def __init__(
        self,
        context: CreateBatchUploadUrlResponseBodyUploadUrlListContext = None,
        expire: str = None,
        file_exist: bool = None,
        internal_url: str = None,
        md_5: str = None,
        public_url: str = None,
    ):
        # The signature information.
        self.context = context
        # The timestamp when the values of the parameters expire. Unit: milliseconds.
        self.expire = expire
        # Indicates whether the file exists in the cloud. Valid values:
        # 
        # *   **true**: The file exists in the cloud. You do not need to upload the file.
        # *   **false**: The file does not exist in the cloud. You must upload the file.
        self.file_exist = file_exist
        # The internal endpoint of the URL to which the file is uploaded.
        self.internal_url = internal_url
        # The identifier of the file.
        self.md_5 = md_5
        # The public endpoint of the URL to which the file is uploaded.
        self.public_url = public_url

    def validate(self):
        if self.context:
            self.context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.context is not None:
            result['Context'] = self.context.to_map()
        if self.expire is not None:
            result['Expire'] = self.expire
        if self.file_exist is not None:
            result['FileExist'] = self.file_exist
        if self.internal_url is not None:
            result['InternalUrl'] = self.internal_url
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.public_url is not None:
            result['PublicUrl'] = self.public_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Context') is not None:
            temp_model = CreateBatchUploadUrlResponseBodyUploadUrlListContext()
            self.context = temp_model.from_map(m['Context'])
        if m.get('Expire') is not None:
            self.expire = m.get('Expire')
        if m.get('FileExist') is not None:
            self.file_exist = m.get('FileExist')
        if m.get('InternalUrl') is not None:
            self.internal_url = m.get('InternalUrl')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('PublicUrl') is not None:
            self.public_url = m.get('PublicUrl')
        return self


class CreateBatchUploadUrlResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        upload_url_list: List[CreateBatchUploadUrlResponseBodyUploadUrlList] = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # An array consisting of the parameters that are required to upload a file.
        self.upload_url_list = upload_url_list

    def validate(self):
        if self.upload_url_list:
            for k in self.upload_url_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['UploadUrlList'] = []
        if self.upload_url_list is not None:
            for k in self.upload_url_list:
                result['UploadUrlList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.upload_url_list = []
        if m.get('UploadUrlList') is not None:
            for k in m.get('UploadUrlList'):
                temp_model = CreateBatchUploadUrlResponseBodyUploadUrlList()
                self.upload_url_list.append(temp_model.from_map(k))
        return self


class CreateBatchUploadUrlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateBatchUploadUrlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateBatchUploadUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBinarySecurityPolicyRequest(TeaModel):
    def __init__(
        self,
        clusters: str = None,
        name: str = None,
        policy: str = None,
        remark: str = None,
        resource_owner_id: int = None,
        source_ip: str = None,
        status: str = None,
    ):
        # The information about the cluster.
        # 
        # This parameter is required.
        self.clusters = clusters
        # The name of the policy.
        self.name = name
        # The content of the policy. Specify a value in the JSON format. You can specify the following keys:
        # 
        # *   **policyMode**: the type of the policy. Default value: requireAttestor.
        # *   **requiredAttestors**: the required witnesses.
        # 
        # This parameter is required.
        self.policy = policy
        # The description.
        self.remark = remark
        self.resource_owner_id = resource_owner_id
        # The source IP address.
        self.source_ip = source_ip
        # The status of the policy. Valid values:
        # 
        # *   **enable**\
        # *   **disable**\
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clusters is not None:
            result['Clusters'] = self.clusters
        if self.name is not None:
            result['Name'] = self.name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Clusters') is not None:
            self.clusters = m.get('Clusters')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateBinarySecurityPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateBinarySecurityPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateBinarySecurityPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateBinarySecurityPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateContainerScanTaskRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        container_ids: str = None,
        lang: str = None,
    ):
        # The ID of the cluster to which the container belongs.
        # 
        # > You can call the [DescribeGroupedContainerInstances](https://help.aliyun.com/document_detail/182997.html) operation to query the IDs of clusters.
        self.cluster_id = cluster_id
        # The ID of the container.
        self.container_ids = container_ids
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.container_ids is not None:
            result['ContainerIds'] = self.container_ids
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ContainerIds') is not None:
            self.container_ids = m.get('ContainerIds')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class CreateContainerScanTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        can_create: bool = None,
        collect_time: int = None,
        exec_time: int = None,
        finish_count: int = None,
        progress: int = None,
        result: str = None,
        status: str = None,
        task_id: str = None,
        total_count: int = None,
    ):
        # Indicates whether you can create more scan tasks.
        self.can_create = can_create
        # The collection time.
        self.collect_time = collect_time
        # The execution time of the task.
        self.exec_time = exec_time
        # The number of scan tasks that are complete.
        self.finish_count = finish_count
        # The progress of the task.
        self.progress = progress
        # The execution result of the task.
        self.result = result
        # The status of the task.
        self.status = status
        # The ID of the task.
        self.task_id = task_id
        # The total number of scan tasks.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.can_create is not None:
            result['CanCreate'] = self.can_create
        if self.collect_time is not None:
            result['CollectTime'] = self.collect_time
        if self.exec_time is not None:
            result['ExecTime'] = self.exec_time
        if self.finish_count is not None:
            result['FinishCount'] = self.finish_count
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.result is not None:
            result['Result'] = self.result
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CanCreate') is not None:
            self.can_create = m.get('CanCreate')
        if m.get('CollectTime') is not None:
            self.collect_time = m.get('CollectTime')
        if m.get('ExecTime') is not None:
            self.exec_time = m.get('ExecTime')
        if m.get('FinishCount') is not None:
            self.finish_count = m.get('FinishCount')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class CreateContainerScanTaskResponseBody(TeaModel):
    def __init__(
        self,
        data: CreateContainerScanTaskResponseBodyData = None,
        http_status_code: int = None,
        request_id: str = None,
    ):
        # The data returned.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateContainerScanTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateContainerScanTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateContainerScanTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateContainerScanTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateContainerScanTaskByAppNameRequest(TeaModel):
    def __init__(
        self,
        app_names: str = None,
        cluster_id: str = None,
        lang: str = None,
    ):
        # The name of the container application.
        self.app_names = app_names
        # The cluster ID.
        self.cluster_id = cluster_id
        # The language of the content within the request and response.
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_names is not None:
            result['AppNames'] = self.app_names
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppNames') is not None:
            self.app_names = m.get('AppNames')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class CreateContainerScanTaskByAppNameResponseBodyData(TeaModel):
    def __init__(
        self,
        can_create: bool = None,
        collect_time: int = None,
        exec_time: int = None,
        finish_count: int = None,
        progress: int = None,
        result: str = None,
        status: str = None,
        task_id: str = None,
        total_count: int = None,
    ):
        # Indicates whether you can create more scan tasks. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.can_create = can_create
        # The timestamp generated when the image information was collected. Unit: milliseconds.
        self.collect_time = collect_time
        # The timestamp generated when the scan task started. Unit: milliseconds.
        self.exec_time = exec_time
        # The number of container applications that are scanned.
        self.finish_count = finish_count
        # The progress of the scan task in percentage.
        self.progress = progress
        # The result of the scan task. Valid values:
        # 
        # *   **SUCCESS**: The task is successful.
        # *   **TASK_NOT_SUPPORT_REGION**: The task is not supported in the region where the image is deployed.
        # 
        # >
        self.result = result
        # The status of the scan task. Valid values:
        # 
        # *   **INIT**: The task is being initialized.
        # *   **PRE_ANALYZER**: The task is being pre-processed.
        # *   **SUCCESS**: The task succeeds.
        # *   **FAIL**: The task fails.
        self.status = status
        # The ID of the scan task.
        self.task_id = task_id
        # The total number of container applications that you want to scan.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.can_create is not None:
            result['CanCreate'] = self.can_create
        if self.collect_time is not None:
            result['CollectTime'] = self.collect_time
        if self.exec_time is not None:
            result['ExecTime'] = self.exec_time
        if self.finish_count is not None:
            result['FinishCount'] = self.finish_count
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.result is not None:
            result['Result'] = self.result
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CanCreate') is not None:
            self.can_create = m.get('CanCreate')
        if m.get('CollectTime') is not None:
            self.collect_time = m.get('CollectTime')
        if m.get('ExecTime') is not None:
            self.exec_time = m.get('ExecTime')
        if m.get('FinishCount') is not None:
            self.finish_count = m.get('FinishCount')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class CreateContainerScanTaskByAppNameResponseBody(TeaModel):
    def __init__(
        self,
        data: CreateContainerScanTaskByAppNameResponseBodyData = None,
        http_status_code: int = None,
        request_id: str = None,
    ):
        # The data returned if the request was successful.
        self.data = data
        # The HTTP status code.
        self.http_status_code = http_status_code
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateContainerScanTaskByAppNameResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateContainerScanTaskByAppNameResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateContainerScanTaskByAppNameResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateContainerScanTaskByAppNameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomBlockRecordRequest(TeaModel):
    def __init__(
        self,
        block_ip: str = None,
        bound: str = None,
        expire_time: int = None,
        resource_owner_id: int = None,
        uuids: str = None,
    ):
        # The IP address that you want to specify in the policy.
        # 
        # This parameter is required.
        self.block_ip = block_ip
        # The traffic direction that you want to specify in the policy. Valid values:
        # 
        # *   **in**: inbound
        # *   **out**: outbound
        # 
        # This parameter is required.
        self.bound = bound
        # The expiration time of the policy.
        # 
        # This parameter is required.
        self.expire_time = expire_time
        self.resource_owner_id = resource_owner_id
        # The UUIDs of the servers. Separate multiple UUIDs with commas (,).
        # 
        # This parameter is required.
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_ip is not None:
            result['BlockIp'] = self.block_ip
        if self.bound is not None:
            result['Bound'] = self.bound
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlockIp') is not None:
            self.block_ip = m.get('BlockIp')
        if m.get('Bound') is not None:
            self.bound = m.get('Bound')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class CreateCustomBlockRecordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCustomBlockRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCustomBlockRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCustomBlockRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomizedDictRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        override: bool = None,
        source_ip: str = None,
    ):
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # Whether to overwrite. Value range: - true: Overwrite. - false: Do not overwrite.
        self.override = override
        # The source IP address.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.override is not None:
            result['Override'] = self.override
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Override') is not None:
            self.override = m.get('Override')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class CreateCustomizedDictResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCustomizedDictResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCustomizedDictResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCustomizedDictResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCycleTaskRequest(TeaModel):
    def __init__(
        self,
        enable: int = None,
        first_date_str: int = None,
        interval_period: int = None,
        param: str = None,
        period_unit: str = None,
        source: str = None,
        target_end_time: int = None,
        target_start_time: int = None,
        task_name: str = None,
        task_type: str = None,
    ):
        # Specifies whether to enable the task. Valid values:
        # 
        # *   **1**: yes
        # *   **0**: no
        # 
        # This parameter is required.
        self.enable = enable
        # The first time when the task is performed.
        # 
        # This parameter is required.
        self.first_date_str = first_date_str
        # The interval of the task.
        # 
        # This parameter is required.
        self.interval_period = interval_period
        # The additional information.
        self.param = param
        # The unit of the scan interval. Valid values:
        # 
        # *   **day**: days
        # *   **hour**: hours
        # 
        # This parameter is required.
        self.period_unit = period_unit
        # The additional source for the task.
        self.source = source
        # The time when the task ends. Unit: hours.
        # 
        # This parameter is required.
        self.target_end_time = target_end_time
        # The time when the task is started. Unit: hours.
        # 
        # This parameter is required.
        self.target_start_time = target_start_time
        # The name of the task. Valid values:
        # 
        # *   **VIRUS_VUL_SCHEDULE_SCAN**: virus scan task
        # *   **IMAGE_SCAN**: image scan task
        # *   **EMG_VUL_SCHEDULE_SCAN**: urgent vulnerability scan task
        # 
        # This parameter is required.
        self.task_name = task_name
        # The type of the task. Valid values:
        # 
        # *   **VIRUS_VUL_SCHEDULE_SCAN**: virus scan task
        # *   **IMAGE_SCAN**: image scan task
        # *   **EMG_VUL_SCHEDULE_SCAN**: urgent vulnerability scan task
        # 
        # This parameter is required.
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.first_date_str is not None:
            result['FirstDateStr'] = self.first_date_str
        if self.interval_period is not None:
            result['IntervalPeriod'] = self.interval_period
        if self.param is not None:
            result['Param'] = self.param
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.source is not None:
            result['Source'] = self.source
        if self.target_end_time is not None:
            result['TargetEndTime'] = self.target_end_time
        if self.target_start_time is not None:
            result['TargetStartTime'] = self.target_start_time
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('FirstDateStr') is not None:
            self.first_date_str = m.get('FirstDateStr')
        if m.get('IntervalPeriod') is not None:
            self.interval_period = m.get('IntervalPeriod')
        if m.get('Param') is not None:
            self.param = m.get('Param')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('TargetEndTime') is not None:
            self.target_end_time = m.get('TargetEndTime')
        if m.get('TargetStartTime') is not None:
            self.target_start_time = m.get('TargetStartTime')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class CreateCycleTaskResponseBody(TeaModel):
    def __init__(
        self,
        config_id: str = None,
        request_id: str = None,
    ):
        # The ID of the task configuration.
        self.config_id = config_id
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCycleTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCycleTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCycleTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDynamicDictRequest(TeaModel):
    def __init__(
        self,
        override: bool = None,
        source_ip: str = None,
    ):
        # Specifies whether to overwrite existing data. Valid values:
        # 
        # *   true
        # *   false
        self.override = override
        # The source IP address.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.override is not None:
            result['Override'] = self.override
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Override') is not None:
            self.override = m.get('Override')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class CreateDynamicDictResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDynamicDictResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDynamicDictResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDynamicDictResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFileDetectRequest(TeaModel):
    def __init__(
        self,
        decompress: bool = None,
        decompress_max_file_count: int = None,
        decompress_max_layer: int = None,
        download_url: str = None,
        hash_key: str = None,
        oss_key: str = None,
        source_ip: str = None,
        type: int = None,
    ):
        # Whether to decompress or not. Valid values:
        # 
        # - true: To decompress.
        # - false: Not to decompress.
        self.decompress = decompress
        # The maximum number of files for decompression. The minimum value is 1, and the maximum value is 1000. If the decompression level exceeds the maximum, the decompression operation will be terminated, but the detection of decompressed files will not be affected.
        self.decompress_max_file_count = decompress_max_file_count
        # The maximum level of decompression when dealing with nested compressed files with multiple levels. The minimum value is 1, and the maximum value is 5. If the decompression level exceeds the maximum, the decompression operation will be terminated, but the detection of decompressed files will not be affected.
        self.decompress_max_layer = decompress_max_layer
        # The URL that is used to download the file. You can specify this parameter to trigger file detection without the need to upload the file in advance.
        self.download_url = download_url
        # The identifier of the file. Only MD5 hash values are supported.
        # 
        # This parameter is required.
        self.hash_key = hash_key
        # The key of the file that is stored in the Object Storage Service (OSS) bucket. You can call the [CreateFileDetectUploadUrl](~~CreateFileDetectUploadUrl~~) operation to query the keys of files.
        self.oss_key = oss_key
        # The source IP address of the request.
        self.source_ip = source_ip
        # The type of the file. Valid values:
        # 
        # *   **0**: unknown files
        # *   **1**: binary files
        # *   **2**: webshell files
        # *   **4**: script files
        # 
        # >  If you do not know the type of the file, set this parameter to 0.
        # 
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.decompress is not None:
            result['Decompress'] = self.decompress
        if self.decompress_max_file_count is not None:
            result['DecompressMaxFileCount'] = self.decompress_max_file_count
        if self.decompress_max_layer is not None:
            result['DecompressMaxLayer'] = self.decompress_max_layer
        if self.download_url is not None:
            result['DownloadUrl'] = self.download_url
        if self.hash_key is not None:
            result['HashKey'] = self.hash_key
        if self.oss_key is not None:
            result['OssKey'] = self.oss_key
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Decompress') is not None:
            self.decompress = m.get('Decompress')
        if m.get('DecompressMaxFileCount') is not None:
            self.decompress_max_file_count = m.get('DecompressMaxFileCount')
        if m.get('DecompressMaxLayer') is not None:
            self.decompress_max_layer = m.get('DecompressMaxLayer')
        if m.get('DownloadUrl') is not None:
            self.download_url = m.get('DownloadUrl')
        if m.get('HashKey') is not None:
            self.hash_key = m.get('HashKey')
        if m.get('OssKey') is not None:
            self.oss_key = m.get('OssKey')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateFileDetectResponseBody(TeaModel):
    def __init__(
        self,
        hash_key: str = None,
        request_id: str = None,
    ):
        # The identifier of the file.
        self.hash_key = hash_key
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hash_key is not None:
            result['HashKey'] = self.hash_key
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HashKey') is not None:
            self.hash_key = m.get('HashKey')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateFileDetectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateFileDetectResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateFileDetectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFileDetectUploadUrlRequestHashKeyContextList(TeaModel):
    def __init__(
        self,
        file_size: int = None,
        hash_key: str = None,
    ):
        # The size of the file. Unit: bytes.
        self.file_size = file_size
        # The hash value of the file.
        self.hash_key = hash_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.hash_key is not None:
            result['HashKey'] = self.hash_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('HashKey') is not None:
            self.hash_key = m.get('HashKey')
        return self


class CreateFileDetectUploadUrlRequest(TeaModel):
    def __init__(
        self,
        hash_key_context_list: List[CreateFileDetectUploadUrlRequestHashKeyContextList] = None,
        hash_key_list: List[str] = None,
        type: int = None,
    ):
        # The hash values of files.
        # 
        # > You must specify at least one of the **HashKeyList** and **HashKeyContextList** parameters.
        self.hash_key_context_list = hash_key_context_list
        # The identifiers of files. Only MD5 hash values are supported.
        # 
        # > You must specify at least one of the **HashKeyList** and **HashKeyContextList** parameters.
        self.hash_key_list = hash_key_list
        # The type of the file. Valid values:
        # 
        # *   **0**: unknown file
        # *   **1**: binary file
        # *   **2**: webshell file
        # *   **4**: script file
        # 
        # > If you do not know the type of the file, set this parameter to **0**.
        # 
        # This parameter is required.
        self.type = type

    def validate(self):
        if self.hash_key_context_list:
            for k in self.hash_key_context_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HashKeyContextList'] = []
        if self.hash_key_context_list is not None:
            for k in self.hash_key_context_list:
                result['HashKeyContextList'].append(k.to_map() if k else None)
        if self.hash_key_list is not None:
            result['HashKeyList'] = self.hash_key_list
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.hash_key_context_list = []
        if m.get('HashKeyContextList') is not None:
            for k in m.get('HashKeyContextList'):
                temp_model = CreateFileDetectUploadUrlRequestHashKeyContextList()
                self.hash_key_context_list.append(temp_model.from_map(k))
        if m.get('HashKeyList') is not None:
            self.hash_key_list = m.get('HashKeyList')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateFileDetectUploadUrlResponseBodyUploadUrlListContext(TeaModel):
    def __init__(
        self,
        access_id: str = None,
        oss_key: str = None,
        policy: str = None,
        signature: str = None,
    ):
        # The AccessKey ID that is used to access the OSS bucket.
        self.access_id = access_id
        # The key of the file that is used after the file is uploaded to the OSS bucket.
        self.oss_key = oss_key
        # The policy that poses limits on file upload. For example, the policy can limit the size of the file.
        self.policy = policy
        # The signature that is used to upload the file.
        self.signature = signature

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_id is not None:
            result['AccessId'] = self.access_id
        if self.oss_key is not None:
            result['OssKey'] = self.oss_key
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.signature is not None:
            result['Signature'] = self.signature
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessId') is not None:
            self.access_id = m.get('AccessId')
        if m.get('OssKey') is not None:
            self.oss_key = m.get('OssKey')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        return self


class CreateFileDetectUploadUrlResponseBodyUploadUrlList(TeaModel):
    def __init__(
        self,
        code: str = None,
        context: CreateFileDetectUploadUrlResponseBodyUploadUrlListContext = None,
        expire: str = None,
        file_exist: bool = None,
        hash_key: str = None,
        internal_url: str = None,
        message: str = None,
        public_url: str = None,
    ):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The signature information.
        self.context = context
        # The timestamp when the values of the parameters expire. Unit: milliseconds.
        self.expire = expire
        # Indicates whether the file exists in the cloud. Valid values:
        # 
        # *   **true**: The file exists in the cloud. You do not need to upload the file.
        # *   **false**: The file does not exist in the cloud. You must upload the file.
        self.file_exist = file_exist
        # The identifier of the file.
        self.hash_key = hash_key
        # The internal endpoint of the URL to which the file is uploaded.
        self.internal_url = internal_url
        # The error message returned.
        self.message = message
        # The public endpoint of the URL to which the file is uploaded.
        self.public_url = public_url

    def validate(self):
        if self.context:
            self.context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.context is not None:
            result['Context'] = self.context.to_map()
        if self.expire is not None:
            result['Expire'] = self.expire
        if self.file_exist is not None:
            result['FileExist'] = self.file_exist
        if self.hash_key is not None:
            result['HashKey'] = self.hash_key
        if self.internal_url is not None:
            result['InternalUrl'] = self.internal_url
        if self.message is not None:
            result['Message'] = self.message
        if self.public_url is not None:
            result['PublicUrl'] = self.public_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Context') is not None:
            temp_model = CreateFileDetectUploadUrlResponseBodyUploadUrlListContext()
            self.context = temp_model.from_map(m['Context'])
        if m.get('Expire') is not None:
            self.expire = m.get('Expire')
        if m.get('FileExist') is not None:
            self.file_exist = m.get('FileExist')
        if m.get('HashKey') is not None:
            self.hash_key = m.get('HashKey')
        if m.get('InternalUrl') is not None:
            self.internal_url = m.get('InternalUrl')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PublicUrl') is not None:
            self.public_url = m.get('PublicUrl')
        return self


class CreateFileDetectUploadUrlResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        upload_url_list: List[CreateFileDetectUploadUrlResponseBodyUploadUrlList] = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # An array consisting of the parameters that are required to upload a file.
        self.upload_url_list = upload_url_list

    def validate(self):
        if self.upload_url_list:
            for k in self.upload_url_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['UploadUrlList'] = []
        if self.upload_url_list is not None:
            for k in self.upload_url_list:
                result['UploadUrlList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.upload_url_list = []
        if m.get('UploadUrlList') is not None:
            for k in m.get('UploadUrlList'):
                temp_model = CreateFileDetectUploadUrlResponseBodyUploadUrlList()
                self.upload_url_list.append(temp_model.from_map(k))
        return self


class CreateFileDetectUploadUrlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateFileDetectUploadUrlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateFileDetectUploadUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFileProtectRuleRequest(TeaModel):
    def __init__(
        self,
        alert_level: int = None,
        file_ops: List[str] = None,
        file_paths: List[str] = None,
        platform: str = None,
        proc_paths: List[str] = None,
        rule_action: str = None,
        rule_name: str = None,
        status: int = None,
        switch_id: str = None,
    ):
        # The severity of alerts. Valid values:
        # 
        # *   0: does not generate alerts
        # *   1: sends notifications
        # *   2: suspicious
        # *   3: high-risk
        self.alert_level = alert_level
        # The operations that you want to perform on the files.
        # 
        # This parameter is required.
        self.file_ops = file_ops
        # The paths to the files that you want to monitor. Wildcard characters are supported.
        # 
        # This parameter is required.
        self.file_paths = file_paths
        # The type of the operating system. Valid values:
        # 
        # *   **windows**: Windows
        # *   **linux**: Linux
        self.platform = platform
        # The paths to the processes that you want to monitor. Wildcard characters are supported.
        # 
        # This parameter is required.
        self.proc_paths = proc_paths
        # The handling method of the rule. Valid values:
        # 
        # *   pass: allow
        # *   alert
        # 
        # This parameter is required.
        self.rule_action = rule_action
        # The name of the rule.
        # 
        # This parameter is required.
        self.rule_name = rule_name
        # Specifies whether to enable the rule. Valid values:
        # 
        # *   **1**: yes
        # *   **0**: no
        self.status = status
        # The switch ID of the rule.
        self.switch_id = switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_level is not None:
            result['AlertLevel'] = self.alert_level
        if self.file_ops is not None:
            result['FileOps'] = self.file_ops
        if self.file_paths is not None:
            result['FilePaths'] = self.file_paths
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.proc_paths is not None:
            result['ProcPaths'] = self.proc_paths
        if self.rule_action is not None:
            result['RuleAction'] = self.rule_action
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.status is not None:
            result['Status'] = self.status
        if self.switch_id is not None:
            result['SwitchId'] = self.switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertLevel') is not None:
            self.alert_level = m.get('AlertLevel')
        if m.get('FileOps') is not None:
            self.file_ops = m.get('FileOps')
        if m.get('FilePaths') is not None:
            self.file_paths = m.get('FilePaths')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('ProcPaths') is not None:
            self.proc_paths = m.get('ProcPaths')
        if m.get('RuleAction') is not None:
            self.rule_action = m.get('RuleAction')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SwitchId') is not None:
            self.switch_id = m.get('SwitchId')
        return self


class CreateFileProtectRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        rule_id: int = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The ID of the rule.
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class CreateFileProtectRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateFileProtectRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateFileProtectRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFileUploadLimitRequest(TeaModel):
    def __init__(
        self,
        limit: int = None,
    ):
        # The QPS limit on the files uploaded from the client. Valid values: 100 to 10000.
        # 
        # This parameter is required.
        self.limit = limit

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.limit is not None:
            result['Limit'] = self.limit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        return self


class CreateFileUploadLimitResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateFileUploadLimitResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateFileUploadLimitResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateFileUploadLimitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHoneypotRequest(TeaModel):
    def __init__(
        self,
        honeypot_image_id: str = None,
        honeypot_image_name: str = None,
        honeypot_name: str = None,
        meta: str = None,
        node_id: str = None,
    ):
        # The ID of the honeypot image.
        # 
        # > You can call the [ListAvailableHoneypot](~~ListAvailableHoneypot~~) operation to query the IDs of images from the **HoneypotImageId** response parameter.
        # 
        # This parameter is required.
        self.honeypot_image_id = honeypot_image_id
        # The name of the honeypot image.
        # 
        # > You can call the [ListAvailableHoneypot](~~ListAvailableHoneypot~~) operation to query the names of images from the **HoneypotImageName** response parameter.
        # 
        # This parameter is required.
        self.honeypot_image_name = honeypot_image_name
        # The custom name of the honeypot.
        # 
        # This parameter is required.
        self.honeypot_name = honeypot_name
        # The custom configuration of the honeypot in the JSON format. The value contains the following fields:
        # 
        # *   **trojan_git**: Git-specific Defense. Valid values:
        # 
        #     *   **zip**: Git Source Code Package
        #     *   **web**: Git Directory Leak
        #     *   **close**: Disabled
        # 
        # *   **trojan_git_addr**: Git Trojan Address.
        # 
        # *   **trojan_git.zip**: Git Trojan.
        # 
        # *   **burp**: Burp-specific Defense. Valid values:
        # 
        #     *   **open**: Enable
        #     *   **close**: Disable
        # 
        # *   **portrait_option**: Source Tracing Configuration. Valid values:
        # 
        #     *   **false**: Disable
        #     *   **true**: Enable
        self.meta = meta
        # The ID of the management node.
        # 
        # > You can call the [ListHoneypotNode](~~ListHoneypotNode~~) operation to query the IDs of management nodes.
        # 
        # This parameter is required.
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.honeypot_image_id is not None:
            result['HoneypotImageId'] = self.honeypot_image_id
        if self.honeypot_image_name is not None:
            result['HoneypotImageName'] = self.honeypot_image_name
        if self.honeypot_name is not None:
            result['HoneypotName'] = self.honeypot_name
        if self.meta is not None:
            result['Meta'] = self.meta
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HoneypotImageId') is not None:
            self.honeypot_image_id = m.get('HoneypotImageId')
        if m.get('HoneypotImageName') is not None:
            self.honeypot_image_name = m.get('HoneypotImageName')
        if m.get('HoneypotName') is not None:
            self.honeypot_name = m.get('HoneypotName')
        if m.get('Meta') is not None:
            self.meta = m.get('Meta')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class CreateHoneypotResponseBodyData(TeaModel):
    def __init__(
        self,
        control_node_name: str = None,
        honeypot_id: str = None,
        honeypot_image_display_name: str = None,
        honeypot_image_name: str = None,
        honeypot_name: str = None,
        node_id: str = None,
        preset_id: str = None,
        state: List[str] = None,
    ):
        # The name of the management node.
        self.control_node_name = control_node_name
        # The ID of the honeypot.
        self.honeypot_id = honeypot_id
        # The display name of the honeypot image.
        self.honeypot_image_display_name = honeypot_image_display_name
        # The name of the honeypot image.
        self.honeypot_image_name = honeypot_image_name
        # The custom name of the honeypot.
        self.honeypot_name = honeypot_name
        # The ID of the management node.
        self.node_id = node_id
        # The ID of the custom configuration for the honeypot.
        self.preset_id = preset_id
        # An array that consists of the status information about the honeypot.
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.control_node_name is not None:
            result['ControlNodeName'] = self.control_node_name
        if self.honeypot_id is not None:
            result['HoneypotId'] = self.honeypot_id
        if self.honeypot_image_display_name is not None:
            result['HoneypotImageDisplayName'] = self.honeypot_image_display_name
        if self.honeypot_image_name is not None:
            result['HoneypotImageName'] = self.honeypot_image_name
        if self.honeypot_name is not None:
            result['HoneypotName'] = self.honeypot_name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.preset_id is not None:
            result['PresetId'] = self.preset_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ControlNodeName') is not None:
            self.control_node_name = m.get('ControlNodeName')
        if m.get('HoneypotId') is not None:
            self.honeypot_id = m.get('HoneypotId')
        if m.get('HoneypotImageDisplayName') is not None:
            self.honeypot_image_display_name = m.get('HoneypotImageDisplayName')
        if m.get('HoneypotImageName') is not None:
            self.honeypot_image_name = m.get('HoneypotImageName')
        if m.get('HoneypotName') is not None:
            self.honeypot_name = m.get('HoneypotName')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('PresetId') is not None:
            self.preset_id = m.get('PresetId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class CreateHoneypotResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateHoneypotResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The information about the honeypot.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The error message returned.
        self.message = message
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateHoneypotResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateHoneypotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHoneypotResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHoneypotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHoneypotNodeRequest(TeaModel):
    def __init__(
        self,
        allow_honeypot_access_internet: bool = None,
        available_probe_num: int = None,
        node_name: str = None,
        security_group_probe_ip_list: List[str] = None,
    ):
        # Specifies whether to allow honeypots to access the Internet. Valid values:
        # 
        # *   **true**: allows honeypots to access the Internet.
        # *   **false**: does not allow honeypots to access the Internet.
        self.allow_honeypot_access_internet = allow_honeypot_access_internet
        # The number of available probes.
        self.available_probe_num = available_probe_num
        # The name of the management node.
        # 
        # This parameter is required.
        self.node_name = node_name
        # The CIDR blocks that are allowed to access the management node.
        self.security_group_probe_ip_list = security_group_probe_ip_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_honeypot_access_internet is not None:
            result['AllowHoneypotAccessInternet'] = self.allow_honeypot_access_internet
        if self.available_probe_num is not None:
            result['AvailableProbeNum'] = self.available_probe_num
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.security_group_probe_ip_list is not None:
            result['SecurityGroupProbeIpList'] = self.security_group_probe_ip_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllowHoneypotAccessInternet') is not None:
            self.allow_honeypot_access_internet = m.get('AllowHoneypotAccessInternet')
        if m.get('AvailableProbeNum') is not None:
            self.available_probe_num = m.get('AvailableProbeNum')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('SecurityGroupProbeIpList') is not None:
            self.security_group_probe_ip_list = m.get('SecurityGroupProbeIpList')
        return self


class CreateHoneypotNodeResponseBodyHoneypotNode(TeaModel):
    def __init__(
        self,
        node_id: str = None,
    ):
        # The ID of the management node.
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class CreateHoneypotNodeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        honeypot_node: CreateHoneypotNodeResponseBodyHoneypotNode = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The data returned.
        self.honeypot_node = honeypot_node
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The error message returned.
        self.message = message
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        if self.honeypot_node:
            self.honeypot_node.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.honeypot_node is not None:
            result['HoneypotNode'] = self.honeypot_node.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HoneypotNode') is not None:
            temp_model = CreateHoneypotNodeResponseBodyHoneypotNode()
            self.honeypot_node = temp_model.from_map(m['HoneypotNode'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateHoneypotNodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHoneypotNodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHoneypotNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHoneypotPresetRequest(TeaModel):
    def __init__(
        self,
        honeypot_image_name: str = None,
        lang: str = None,
        meta: str = None,
        node_id: str = None,
        preset_name: str = None,
    ):
        # The name of the honeypot image.
        # 
        # This parameter is required.
        self.honeypot_image_name = honeypot_image_name
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The custom configurations of the honeypot template. The value is a JSON string that contains the following fields:
        # 
        # *   **portrait_option**: Social Source Tracing
        # *   **burp**: Burp-specific Defense
        # *   **trojan_git**: Git-specific Defense
        # 
        # This parameter is required.
        self.meta = meta
        # The ID of the management node to which you want to deploy honeypots.
        # 
        # > You can call the [ListHoneypotNode](~~ListHoneypotNode~~) operation to query the IDs of management nodes.
        # 
        # This parameter is required.
        self.node_id = node_id
        # The custom name of the honeypot template.
        # 
        # This parameter is required.
        self.preset_name = preset_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.honeypot_image_name is not None:
            result['HoneypotImageName'] = self.honeypot_image_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.meta is not None:
            result['Meta'] = self.meta
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.preset_name is not None:
            result['PresetName'] = self.preset_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HoneypotImageName') is not None:
            self.honeypot_image_name = m.get('HoneypotImageName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Meta') is not None:
            self.meta = m.get('Meta')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('PresetName') is not None:
            self.preset_name = m.get('PresetName')
        return self


class CreateHoneypotPresetResponseBodyHoneypotPreset(TeaModel):
    def __init__(
        self,
        honeypot_preset_id: str = None,
    ):
        # The ID of the honeypot template.
        self.honeypot_preset_id = honeypot_preset_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.honeypot_preset_id is not None:
            result['HoneypotPresetId'] = self.honeypot_preset_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HoneypotPresetId') is not None:
            self.honeypot_preset_id = m.get('HoneypotPresetId')
        return self


class CreateHoneypotPresetResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        honeypot_preset: CreateHoneypotPresetResponseBodyHoneypotPreset = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The creation result.
        self.honeypot_preset = honeypot_preset
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        if self.honeypot_preset:
            self.honeypot_preset.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.honeypot_preset is not None:
            result['HoneypotPreset'] = self.honeypot_preset.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HoneypotPreset') is not None:
            temp_model = CreateHoneypotPresetResponseBodyHoneypotPreset()
            self.honeypot_preset = temp_model.from_map(m['HoneypotPreset'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateHoneypotPresetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHoneypotPresetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHoneypotPresetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHoneypotProbeRequestHoneypotBindListBindPortList(TeaModel):
    def __init__(
        self,
        bind_port: bool = None,
        end_port: int = None,
        fixed: bool = None,
        start_port: int = None,
        target_port: int = None,
    ):
        # Specifies whether to bind a port. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.bind_port = bind_port
        # The end of the port range.
        self.end_port = end_port
        # Specifies whether the port is a fixed port. Valid values:
        # 
        # *   **0**: no
        # *   **1**: yes
        self.fixed = fixed
        # The start of the port range.
        self.start_port = start_port
        # The destination port.
        # 
        # > If **HoneypotId** is specified, this parameter is required.
        self.target_port = target_port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_port is not None:
            result['BindPort'] = self.bind_port
        if self.end_port is not None:
            result['EndPort'] = self.end_port
        if self.fixed is not None:
            result['Fixed'] = self.fixed
        if self.start_port is not None:
            result['StartPort'] = self.start_port
        if self.target_port is not None:
            result['TargetPort'] = self.target_port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindPort') is not None:
            self.bind_port = m.get('BindPort')
        if m.get('EndPort') is not None:
            self.end_port = m.get('EndPort')
        if m.get('Fixed') is not None:
            self.fixed = m.get('Fixed')
        if m.get('StartPort') is not None:
            self.start_port = m.get('StartPort')
        if m.get('TargetPort') is not None:
            self.target_port = m.get('TargetPort')
        return self


class CreateHoneypotProbeRequestHoneypotBindList(TeaModel):
    def __init__(
        self,
        bind_port_list: List[CreateHoneypotProbeRequestHoneypotBindListBindPortList] = None,
        honeypot_id: str = None,
    ):
        # The listener ports.
        self.bind_port_list = bind_port_list
        # The ID of the honeypot.
        # 
        # > You can call the [ListHoneypot](~~ListHoneypot~~) operation to query the IDs of honeypots.
        self.honeypot_id = honeypot_id

    def validate(self):
        if self.bind_port_list:
            for k in self.bind_port_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BindPortList'] = []
        if self.bind_port_list is not None:
            for k in self.bind_port_list:
                result['BindPortList'].append(k.to_map() if k else None)
        if self.honeypot_id is not None:
            result['HoneypotId'] = self.honeypot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bind_port_list = []
        if m.get('BindPortList') is not None:
            for k in m.get('BindPortList'):
                temp_model = CreateHoneypotProbeRequestHoneypotBindListBindPortList()
                self.bind_port_list.append(temp_model.from_map(k))
        if m.get('HoneypotId') is not None:
            self.honeypot_id = m.get('HoneypotId')
        return self


class CreateHoneypotProbeRequest(TeaModel):
    def __init__(
        self,
        arp: bool = None,
        business_group_id: str = None,
        control_node_id: str = None,
        display_name: str = None,
        honeypot_bind_list: List[CreateHoneypotProbeRequestHoneypotBindList] = None,
        ping: bool = None,
        probe_type: str = None,
        probe_version: str = None,
        proxy_ip: str = None,
        uuid: str = None,
        vpc_id: str = None,
    ):
        # Specifies whether to enable Address Resolution Protocol (ARP) spoofing. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.arp = arp
        # The ID of the business group.
        self.business_group_id = business_group_id
        # The ID of the management node.
        # 
        # > You can call the [ListHoneypotNode](~~ListHoneypotNode~~) operation to query the IDs of management nodes.
        # 
        # This parameter is required.
        self.control_node_id = control_node_id
        # The name of the probe.
        # 
        # This parameter is required.
        self.display_name = display_name
        # The configuration of the probe.
        self.honeypot_bind_list = honeypot_bind_list
        # Specifies whether to enable ping scan. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.ping = ping
        # The type of the probe. Valid values:
        # 
        # *   **host_probe**: host probe
        # *   **vpc_black_hole_probe**: virtual private cloud (VPC) probe
        # 
        # This parameter is required.
        self.probe_type = probe_type
        # The version of the probe.
        self.probe_version = probe_version
        # The IP address of the proxy.
        self.proxy_ip = proxy_ip
        # The UUID of the instance.
        # 
        # > If **ProbeType** is set to **host_probe**, this parameter is required.
        self.uuid = uuid
        # The ID of the VPC.
        # 
        # > If **ProbeType** is set to **vpc_black_hole_probe**, this parameter is required. You can call the [DescribeVpcHoneyPotList](~~DescribeVpcHoneyPotList~~) operation to query the IDs of VPCs.
        self.vpc_id = vpc_id

    def validate(self):
        if self.honeypot_bind_list:
            for k in self.honeypot_bind_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arp is not None:
            result['Arp'] = self.arp
        if self.business_group_id is not None:
            result['BusinessGroupId'] = self.business_group_id
        if self.control_node_id is not None:
            result['ControlNodeId'] = self.control_node_id
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        result['HoneypotBindList'] = []
        if self.honeypot_bind_list is not None:
            for k in self.honeypot_bind_list:
                result['HoneypotBindList'].append(k.to_map() if k else None)
        if self.ping is not None:
            result['Ping'] = self.ping
        if self.probe_type is not None:
            result['ProbeType'] = self.probe_type
        if self.probe_version is not None:
            result['ProbeVersion'] = self.probe_version
        if self.proxy_ip is not None:
            result['ProxyIp'] = self.proxy_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arp') is not None:
            self.arp = m.get('Arp')
        if m.get('BusinessGroupId') is not None:
            self.business_group_id = m.get('BusinessGroupId')
        if m.get('ControlNodeId') is not None:
            self.control_node_id = m.get('ControlNodeId')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        self.honeypot_bind_list = []
        if m.get('HoneypotBindList') is not None:
            for k in m.get('HoneypotBindList'):
                temp_model = CreateHoneypotProbeRequestHoneypotBindList()
                self.honeypot_bind_list.append(temp_model.from_map(k))
        if m.get('Ping') is not None:
            self.ping = m.get('Ping')
        if m.get('ProbeType') is not None:
            self.probe_type = m.get('ProbeType')
        if m.get('ProbeVersion') is not None:
            self.probe_version = m.get('ProbeVersion')
        if m.get('ProxyIp') is not None:
            self.proxy_ip = m.get('ProxyIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateHoneypotProbeResponseBodyHoneypotProbe(TeaModel):
    def __init__(
        self,
        probe_id: str = None,
    ):
        # The ID of the probe.
        self.probe_id = probe_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.probe_id is not None:
            result['ProbeId'] = self.probe_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProbeId') is not None:
            self.probe_id = m.get('ProbeId')
        return self


class CreateHoneypotProbeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        honeypot_probe: CreateHoneypotProbeResponseBodyHoneypotProbe = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The information about the probe.
        self.honeypot_probe = honeypot_probe
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        if self.honeypot_probe:
            self.honeypot_probe.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.honeypot_probe is not None:
            result['HoneypotProbe'] = self.honeypot_probe.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HoneypotProbe') is not None:
            temp_model = CreateHoneypotProbeResponseBodyHoneypotProbe()
            self.honeypot_probe = temp_model.from_map(m['HoneypotProbe'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateHoneypotProbeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHoneypotProbeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHoneypotProbeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHoneypotProbeBindRequestBindPortList(TeaModel):
    def __init__(
        self,
        bind_port: bool = None,
        end_port: int = None,
        fixed: bool = None,
        proto: str = None,
        start_port: int = None,
        target_port: int = None,
    ):
        # Specifies whether to bind the port. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.bind_port = bind_port
        # The end port on which the probe monitors.
        self.end_port = end_port
        # Specifies whether the port is a fixed port. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.fixed = fixed
        # The type of the protocol. Valid values:
        # 
        # *   **tcp**\
        # *   **udp**\
        self.proto = proto
        # The start port on which the probe monitors.
        self.start_port = start_port
        # The destination port.
        self.target_port = target_port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_port is not None:
            result['BindPort'] = self.bind_port
        if self.end_port is not None:
            result['EndPort'] = self.end_port
        if self.fixed is not None:
            result['Fixed'] = self.fixed
        if self.proto is not None:
            result['Proto'] = self.proto
        if self.start_port is not None:
            result['StartPort'] = self.start_port
        if self.target_port is not None:
            result['TargetPort'] = self.target_port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindPort') is not None:
            self.bind_port = m.get('BindPort')
        if m.get('EndPort') is not None:
            self.end_port = m.get('EndPort')
        if m.get('Fixed') is not None:
            self.fixed = m.get('Fixed')
        if m.get('Proto') is not None:
            self.proto = m.get('Proto')
        if m.get('StartPort') is not None:
            self.start_port = m.get('StartPort')
        if m.get('TargetPort') is not None:
            self.target_port = m.get('TargetPort')
        return self


class CreateHoneypotProbeBindRequest(TeaModel):
    def __init__(
        self,
        bind_port_list: List[CreateHoneypotProbeBindRequestBindPortList] = None,
        honeypot_id: str = None,
        lang: str = None,
        probe_id: str = None,
        service_ip_list: List[str] = None,
    ):
        # The ports that are bound to the probe.
        self.bind_port_list = bind_port_list
        # The honeypot ID.
        # 
        # >  You can call the [ListHoneypot](~~ListHoneypot~~) operation to query the IDs of honeypots.
        self.honeypot_id = honeypot_id
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The probe ID.
        # 
        # >  You can call the [ListHoneypotProbe](~~ListHoneypotProbe~~) operation to query the IDs of probes.
        self.probe_id = probe_id
        # The IP addresses that are monitored.
        self.service_ip_list = service_ip_list

    def validate(self):
        if self.bind_port_list:
            for k in self.bind_port_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BindPortList'] = []
        if self.bind_port_list is not None:
            for k in self.bind_port_list:
                result['BindPortList'].append(k.to_map() if k else None)
        if self.honeypot_id is not None:
            result['HoneypotId'] = self.honeypot_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.probe_id is not None:
            result['ProbeId'] = self.probe_id
        if self.service_ip_list is not None:
            result['ServiceIpList'] = self.service_ip_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bind_port_list = []
        if m.get('BindPortList') is not None:
            for k in m.get('BindPortList'):
                temp_model = CreateHoneypotProbeBindRequestBindPortList()
                self.bind_port_list.append(temp_model.from_map(k))
        if m.get('HoneypotId') is not None:
            self.honeypot_id = m.get('HoneypotId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ProbeId') is not None:
            self.probe_id = m.get('ProbeId')
        if m.get('ServiceIpList') is not None:
            self.service_ip_list = m.get('ServiceIpList')
        return self


class CreateHoneypotProbeBindResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The HTTP status code that is returned.
        self.http_status_code = http_status_code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateHoneypotProbeBindResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHoneypotProbeBindResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHoneypotProbeBindResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHybridProxyClusterRequest(TeaModel):
    def __init__(
        self,
        cluster_name: str = None,
        ip: str = None,
        remark: str = None,
    ):
        # The name of the cluster.
        # 
        # This parameter is required.
        self.cluster_name = cluster_name
        # The endpoint of the cluster.
        # >  You can specify an IP address or a domain name
        self.ip = ip
        # The description of the cluster.
        self.remark = remark

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.remark is not None:
            result['Remark'] = self.remark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        return self


class CreateHybridProxyClusterResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateHybridProxyClusterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHybridProxyClusterResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHybridProxyClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInterceptionRuleRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        cluster_name: str = None,
        dst_target_list: Dict[str, Any] = None,
        intercept_type: int = None,
        order_index: int = None,
        rule_name: str = None,
        rule_switch: int = None,
        rule_type: str = None,
        src_target: Dict[str, Any] = None,
    ):
        # The ID of the container cluster.
        # 
        # > You can call the [DescribeGroupedContainerInstances](~~DescribeGroupedContainerInstances~~) operation to query the IDs of container clusters.
        # 
        # This parameter is required.
        self.cluster_id = cluster_id
        # The name of the cluster.
        # 
        # This parameter is required.
        self.cluster_name = cluster_name
        # The information about the destination network object. The value of this parameter contains the following fields:
        # 
        # *   targetId: the ID of the destination network object. You can call the [ListInterceptionTargetPage](~~ListInterceptionTargetPage~~) operation to query the ID.
        # *   ports: the destination port ranges.
        self.dst_target_list = dst_target_list
        # The action on traffic. Valid values:
        # 
        # *   **1**: blocks traffic.
        # *   **2**: allows traffic and generates alerts.
        # *   **3**: allows traffic and does not generate alerts.
        # 
        # This parameter is required.
        self.intercept_type = intercept_type
        # The priority of the defense rule. Valid values: 1 to 1000. A smaller value indicates a higher priority.
        # 
        # This parameter is required.
        self.order_index = order_index
        # The name of the defense rule.
        # 
        # This parameter is required.
        self.rule_name = rule_name
        # Specifies the status of the defense rule. Valid values:
        # 
        # *   **0**: disables the rule.
        # *   **1**: enables the rule.
        # 
        # This parameter is required.
        self.rule_switch = rule_switch
        # The type of the defense rule. Valid values:
        # 
        # *   customize: custom rule
        self.rule_type = rule_type
        # The source network object. The value of this parameter contains the following field:
        # 
        # *   targetId: the ID of the source network object. You can call the [ListInterceptionTargetPage](~~ListInterceptionTargetPage~~) operation to query the ID.
        self.src_target = src_target

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.dst_target_list is not None:
            result['DstTargetList'] = self.dst_target_list
        if self.intercept_type is not None:
            result['InterceptType'] = self.intercept_type
        if self.order_index is not None:
            result['OrderIndex'] = self.order_index
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_switch is not None:
            result['RuleSwitch'] = self.rule_switch
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        if self.src_target is not None:
            result['SrcTarget'] = self.src_target
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('DstTargetList') is not None:
            self.dst_target_list = m.get('DstTargetList')
        if m.get('InterceptType') is not None:
            self.intercept_type = m.get('InterceptType')
        if m.get('OrderIndex') is not None:
            self.order_index = m.get('OrderIndex')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleSwitch') is not None:
            self.rule_switch = m.get('RuleSwitch')
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        if m.get('SrcTarget') is not None:
            self.src_target = m.get('SrcTarget')
        return self


class CreateInterceptionRuleShrinkRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        cluster_name: str = None,
        dst_target_list_shrink: str = None,
        intercept_type: int = None,
        order_index: int = None,
        rule_name: str = None,
        rule_switch: int = None,
        rule_type: str = None,
        src_target_shrink: str = None,
    ):
        # The ID of the container cluster.
        # 
        # > You can call the [DescribeGroupedContainerInstances](~~DescribeGroupedContainerInstances~~) operation to query the IDs of container clusters.
        # 
        # This parameter is required.
        self.cluster_id = cluster_id
        # The name of the cluster.
        # 
        # This parameter is required.
        self.cluster_name = cluster_name
        # The information about the destination network object. The value of this parameter contains the following fields:
        # 
        # *   targetId: the ID of the destination network object. You can call the [ListInterceptionTargetPage](~~ListInterceptionTargetPage~~) operation to query the ID.
        # *   ports: the destination port ranges.
        self.dst_target_list_shrink = dst_target_list_shrink
        # The action on traffic. Valid values:
        # 
        # *   **1**: blocks traffic.
        # *   **2**: allows traffic and generates alerts.
        # *   **3**: allows traffic and does not generate alerts.
        # 
        # This parameter is required.
        self.intercept_type = intercept_type
        # The priority of the defense rule. Valid values: 1 to 1000. A smaller value indicates a higher priority.
        # 
        # This parameter is required.
        self.order_index = order_index
        # The name of the defense rule.
        # 
        # This parameter is required.
        self.rule_name = rule_name
        # Specifies the status of the defense rule. Valid values:
        # 
        # *   **0**: disables the rule.
        # *   **1**: enables the rule.
        # 
        # This parameter is required.
        self.rule_switch = rule_switch
        # The type of the defense rule. Valid values:
        # 
        # *   customize: custom rule
        self.rule_type = rule_type
        # The source network object. The value of this parameter contains the following field:
        # 
        # *   targetId: the ID of the source network object. You can call the [ListInterceptionTargetPage](~~ListInterceptionTargetPage~~) operation to query the ID.
        self.src_target_shrink = src_target_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.dst_target_list_shrink is not None:
            result['DstTargetList'] = self.dst_target_list_shrink
        if self.intercept_type is not None:
            result['InterceptType'] = self.intercept_type
        if self.order_index is not None:
            result['OrderIndex'] = self.order_index
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_switch is not None:
            result['RuleSwitch'] = self.rule_switch
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        if self.src_target_shrink is not None:
            result['SrcTarget'] = self.src_target_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('DstTargetList') is not None:
            self.dst_target_list_shrink = m.get('DstTargetList')
        if m.get('InterceptType') is not None:
            self.intercept_type = m.get('InterceptType')
        if m.get('OrderIndex') is not None:
            self.order_index = m.get('OrderIndex')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleSwitch') is not None:
            self.rule_switch = m.get('RuleSwitch')
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        if m.get('SrcTarget') is not None:
            self.src_target_shrink = m.get('SrcTarget')
        return self


class CreateInterceptionRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateInterceptionRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateInterceptionRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateInterceptionRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInterceptionTargetRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        cluster_id: str = None,
        cluster_name: str = None,
        image_list: List[str] = None,
        namespace: str = None,
        tag_list: List[str] = None,
        target_name: str = None,
        target_type: str = None,
    ):
        # The name of the application to which the network object belongs.
        self.app_name = app_name
        # The cluster ID.
        self.cluster_id = cluster_id
        # The cluster name.
        self.cluster_name = cluster_name
        # An array that consists of the images of the network object.
        self.image_list = image_list
        # The namespace to which the network object belongs.
        # 
        # This parameter is required.
        self.namespace = namespace
        # An array that consists of the labels specified for the network object.
        self.tag_list = tag_list
        # The name of the object to be blocked.
        # 
        # This parameter is required.
        self.target_name = target_name
        # The object type. Valid value:
        # 
        # *   **IMAGE**\
        # 
        # This parameter is required.
        self.target_type = target_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.image_list is not None:
            result['ImageList'] = self.image_list
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.tag_list is not None:
            result['TagList'] = self.tag_list
        if self.target_name is not None:
            result['TargetName'] = self.target_name
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ImageList') is not None:
            self.image_list = m.get('ImageList')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('TagList') is not None:
            self.tag_list = m.get('TagList')
        if m.get('TargetName') is not None:
            self.target_name = m.get('TargetName')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class CreateInterceptionTargetResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: bool = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The response parameters.
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class CreateInterceptionTargetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateInterceptionTargetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateInterceptionTargetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateJenkinsImageRegistryRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        extra_param: str = None,
        net_type: int = None,
        password: str = None,
        persistence_day: int = None,
        protocol_type: int = None,
        region_id: str = None,
        registry_host_ip: str = None,
        registry_name: str = None,
        registry_type: str = None,
        registry_version: str = None,
        source_ip: str = None,
        trans_per_hour: int = None,
        user_name: str = None,
        vpc_id: str = None,
        white_list: str = None,
    ):
        # The domain name of the image repository.
        self.domain_name = domain_name
        # The additional parameters of the image repository. The value of this parameter contains the following fields:
        # 
        # *   **namespace**: the namespace
        # *   **authToken**: the authorization token
        self.extra_param = extra_param
        # The network type. Valid values:
        # 
        # *   **1**: Internet
        # *   **2**: Virtual Private Cloud (VPC)
        self.net_type = net_type
        # The password.
        self.password = password
        # The number of days during which assets can be retained.
        self.persistence_day = persistence_day
        # The type of the protocol. Valid values:
        # 
        # *   **1**: HTTP
        # *   **2**: HTTPS
        self.protocol_type = protocol_type
        # The region ID of the image repository.
        self.region_id = region_id
        # The IP address of the image repository.
        self.registry_host_ip = registry_host_ip
        # The alias of the image repository.
        self.registry_name = registry_name
        # The type of the image repository. Valid values:
        # 
        # *   **CI/CD**: Jenkins
        self.registry_type = registry_type
        # The version of the image repository. Default value: -. Valid values:
        # 
        # *   **-**: the default version
        # *   **V1**: V1.0
        # *   **V2**: V2.0
        self.registry_version = registry_version
        # The source IP address of the request.
        self.source_ip = source_ip
        # The number of images that can be scanned per hour.
        self.trans_per_hour = trans_per_hour
        # The username.
        self.user_name = user_name
        # The ID of the VPC.
        self.vpc_id = vpc_id
        # The whitelist of IP addresses.
        self.white_list = white_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.extra_param is not None:
            result['ExtraParam'] = self.extra_param
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.password is not None:
            result['Password'] = self.password
        if self.persistence_day is not None:
            result['PersistenceDay'] = self.persistence_day
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.registry_host_ip is not None:
            result['RegistryHostIp'] = self.registry_host_ip
        if self.registry_name is not None:
            result['RegistryName'] = self.registry_name
        if self.registry_type is not None:
            result['RegistryType'] = self.registry_type
        if self.registry_version is not None:
            result['RegistryVersion'] = self.registry_version
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.trans_per_hour is not None:
            result['TransPerHour'] = self.trans_per_hour
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.white_list is not None:
            result['WhiteList'] = self.white_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('ExtraParam') is not None:
            self.extra_param = m.get('ExtraParam')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('PersistenceDay') is not None:
            self.persistence_day = m.get('PersistenceDay')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegistryHostIp') is not None:
            self.registry_host_ip = m.get('RegistryHostIp')
        if m.get('RegistryName') is not None:
            self.registry_name = m.get('RegistryName')
        if m.get('RegistryType') is not None:
            self.registry_type = m.get('RegistryType')
        if m.get('RegistryVersion') is not None:
            self.registry_version = m.get('RegistryVersion')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('TransPerHour') is not None:
            self.trans_per_hour = m.get('TransPerHour')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('WhiteList') is not None:
            self.white_list = m.get('WhiteList')
        return self


class CreateJenkinsImageRegistryResponseBodyData(TeaModel):
    def __init__(
        self,
        black_list: str = None,
        domain_name: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        net_type: int = None,
        password: str = None,
        persistence_day: int = None,
        protocol_type: int = None,
        region_id: str = None,
        registry_host_ip: str = None,
        registry_name: str = None,
        registry_type: str = None,
        token: str = None,
        trans_per_hour: int = None,
        user_name: str = None,
        vpc_id: str = None,
        white_list: str = None,
    ):
        # The blacklist.
        self.black_list = black_list
        # The domain name of the image repository.
        self.domain_name = domain_name
        # The creation time. The time is in the yyyy-MM-dd HH:mm:ss format.
        self.gmt_create = gmt_create
        # The update time. The time is in the yyyy-MM-dd HH:mm:ss format.
        self.gmt_modified = gmt_modified
        # The ID of the image repository.
        self.id = id
        # The network type. Valid values:
        # 
        # *   **1**: Internet
        # *   **2**: VPC
        self.net_type = net_type
        # The password.
        self.password = password
        # The number of days during which assets can be retained.
        self.persistence_day = persistence_day
        # The type of the protocol. Valid values:
        # 
        # *   **1**: HTTP
        # *   **2**: HTTPS
        self.protocol_type = protocol_type
        # The region ID of the image repository.
        self.region_id = region_id
        # The IP address of the image repository.
        self.registry_host_ip = registry_host_ip
        # The alias of the image repository.
        self.registry_name = registry_name
        # The type of the image repository. Valid values:
        # 
        # *   **CI/CD**: Jenkins
        self.registry_type = registry_type
        # The authentication token of the user.
        self.token = token
        # The number of images that can be scanned per hour.
        self.trans_per_hour = trans_per_hour
        # The username.
        self.user_name = user_name
        # The ID of the VPC.
        self.vpc_id = vpc_id
        # The whitelist.
        self.white_list = white_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.black_list is not None:
            result['BlackList'] = self.black_list
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.password is not None:
            result['Password'] = self.password
        if self.persistence_day is not None:
            result['PersistenceDay'] = self.persistence_day
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.registry_host_ip is not None:
            result['RegistryHostIp'] = self.registry_host_ip
        if self.registry_name is not None:
            result['RegistryName'] = self.registry_name
        if self.registry_type is not None:
            result['RegistryType'] = self.registry_type
        if self.token is not None:
            result['Token'] = self.token
        if self.trans_per_hour is not None:
            result['TransPerHour'] = self.trans_per_hour
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.white_list is not None:
            result['WhiteList'] = self.white_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlackList') is not None:
            self.black_list = m.get('BlackList')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('PersistenceDay') is not None:
            self.persistence_day = m.get('PersistenceDay')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegistryHostIp') is not None:
            self.registry_host_ip = m.get('RegistryHostIp')
        if m.get('RegistryName') is not None:
            self.registry_name = m.get('RegistryName')
        if m.get('RegistryType') is not None:
            self.registry_type = m.get('RegistryType')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        if m.get('TransPerHour') is not None:
            self.trans_per_hour = m.get('TransPerHour')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('WhiteList') is not None:
            self.white_list = m.get('WhiteList')
        return self


class CreateJenkinsImageRegistryResponseBody(TeaModel):
    def __init__(
        self,
        data: CreateJenkinsImageRegistryResponseBodyData = None,
        http_status_code: int = None,
        request_id: str = None,
        time_cost: int = None,
    ):
        # The result of creating the image repository.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The ID of the request.
        self.request_id = request_id
        # The time consumed. Unit: seconds.
        self.time_cost = time_cost

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.time_cost is not None:
            result['TimeCost'] = self.time_cost
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateJenkinsImageRegistryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TimeCost') is not None:
            self.time_cost = m.get('TimeCost')
        return self


class CreateJenkinsImageRegistryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateJenkinsImageRegistryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateJenkinsImageRegistryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateJenkinsImageScanTaskRequest(TeaModel):
    def __init__(
        self,
        digest: str = None,
        image_create: int = None,
        image_id: str = None,
        image_size: int = None,
        image_update: int = None,
        jenkins_env: str = None,
        namespace: str = None,
        repo_name: str = None,
        source_ip: str = None,
        tag: str = None,
        token: str = None,
        uuid: str = None,
    ):
        # The digest of the image.
        self.digest = digest
        # The time when the image was created.
        self.image_create = image_create
        # The ID of the image.
        self.image_id = image_id
        # The size of the image. Unit: bytes.
        self.image_size = image_size
        # The time when the image was updated.
        self.image_update = image_update
        # The information about the Jenkins environment.
        self.jenkins_env = jenkins_env
        # The namespace.
        self.namespace = namespace
        # The name of the image repository.
        self.repo_name = repo_name
        # The source IP address of the request.
        self.source_ip = source_ip
        # The tag of the image.
        self.tag = tag
        # The token that is used to access the Jenkins image repository.
        self.token = token
        # The UUID of the image asset.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.digest is not None:
            result['Digest'] = self.digest
        if self.image_create is not None:
            result['ImageCreate'] = self.image_create
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_size is not None:
            result['ImageSize'] = self.image_size
        if self.image_update is not None:
            result['ImageUpdate'] = self.image_update
        if self.jenkins_env is not None:
            result['JenkinsEnv'] = self.jenkins_env
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.token is not None:
            result['Token'] = self.token
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Digest') is not None:
            self.digest = m.get('Digest')
        if m.get('ImageCreate') is not None:
            self.image_create = m.get('ImageCreate')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageSize') is not None:
            self.image_size = m.get('ImageSize')
        if m.get('ImageUpdate') is not None:
            self.image_update = m.get('ImageUpdate')
        if m.get('JenkinsEnv') is not None:
            self.jenkins_env = m.get('JenkinsEnv')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class CreateJenkinsImageScanTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        image_scan_capacity: int = None,
        repo_id: str = None,
        repo_instance_id: str = None,
        repo_region_id: str = None,
        task_id: str = None,
        uuid: str = None,
    ):
        # The quota for image scan.
        self.image_scan_capacity = image_scan_capacity
        # The ID of the image repository.
        self.repo_id = repo_id
        # The instance ID of the image repository.
        self.repo_instance_id = repo_instance_id
        # The ID of the region.
        self.repo_region_id = repo_region_id
        # The ID of the scan task.
        self.task_id = task_id
        # The UUID of the image asset.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_scan_capacity is not None:
            result['ImageScanCapacity'] = self.image_scan_capacity
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageScanCapacity') is not None:
            self.image_scan_capacity = m.get('ImageScanCapacity')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class CreateJenkinsImageScanTaskResponseBody(TeaModel):
    def __init__(
        self,
        data: CreateJenkinsImageScanTaskResponseBodyData = None,
        request_id: str = None,
    ):
        # The data returned.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateJenkinsImageScanTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateJenkinsImageScanTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateJenkinsImageScanTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateJenkinsImageScanTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMaliciousFileWhitelistConfigRequest(TeaModel):
    def __init__(
        self,
        event_name: str = None,
        field: str = None,
        field_value: str = None,
        operator: str = None,
        remark: str = None,
        source: str = None,
        target_type: str = None,
        target_value: str = None,
    ):
        # The name of the alert.
        # 
        # *   Set the value to ALL, which indicates all alert types.
        self.event_name = event_name
        # The field that you want to use in the whitelist rule.
        self.field = field
        # The value of the field that you want to use in the whitelist rule.
        self.field_value = field_value
        # The logical operator that you want to use in the whitelist rule.
        # 
        # *   Set the value to strEqual, which indicates the equality operator (=).
        self.operator = operator
        self.remark = remark
        # The feature to which this operation belongs.
        # 
        # *   Set the value to agentless, which indicates the agentless detection feature.
        self.source = source
        # The type of the assets on which you want the whitelist rule to take effect. Valid values:
        # 
        # *   ALL: all assets
        # *   SELECTION_KEY: selected assets
        self.target_type = target_type
        # The assets on which you want the whitelist rule to take effect. Valid values:
        # 
        # *   ALL: all assets
        # *   Others: selected assets
        self.target_value = target_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.field is not None:
            result['Field'] = self.field
        if self.field_value is not None:
            result['FieldValue'] = self.field_value
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.source is not None:
            result['Source'] = self.source
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.target_value is not None:
            result['TargetValue'] = self.target_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('Field') is not None:
            self.field = m.get('Field')
        if m.get('FieldValue') is not None:
            self.field_value = m.get('FieldValue')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('TargetValue') is not None:
            self.target_value = m.get('TargetValue')
        return self


class CreateMaliciousFileWhitelistConfigResponseBodyData(TeaModel):
    def __init__(
        self,
        count: str = None,
        event_name: str = None,
        field: str = None,
        field_value: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: str = None,
        operator: str = None,
        source: str = None,
        target_type: str = None,
        target_value: str = None,
    ):
        # The number of the assets on which the whitelist rule takes effect.
        # 
        # >  The value of this parameter is returned only if the value of TargetType is SELECTION_KEY.
        self.count = count
        # The name of the alert.
        # 
        # *   The value is fixed as ALL, which indicates all alert types.
        self.event_name = event_name
        # The field that is used in the whitelist rule.
        self.field = field
        # The value of the field that is used in the whitelist rule.
        self.field_value = field_value
        # The creation time.
        self.gmt_create = gmt_create
        # The modification time.
        self.gmt_modified = gmt_modified
        # The ID of the whitelist rule.
        self.id = id
        # The logical operator that is used in the whitelist rule.
        # 
        # *   The value is fixed as strEqual, which indicates the equality operator (=).
        self.operator = operator
        # The feature to which this operation belongs.
        # 
        # *   The value is fixed as agentless, which indicates the agentless detection feature.
        self.source = source
        # The type of the assets on which the whitelist rule takes effect. Valid values:
        # 
        # *   ALL: all assets
        # *   SELECTION_KEY: selected assets
        self.target_type = target_type
        # The assets on which the whitelist rule takes effect. Valid values:
        # 
        # *   ALL: all assets
        # *   Others: selected assets
        self.target_value = target_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.field is not None:
            result['Field'] = self.field
        if self.field_value is not None:
            result['FieldValue'] = self.field_value
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.source is not None:
            result['Source'] = self.source
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.target_value is not None:
            result['TargetValue'] = self.target_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('Field') is not None:
            self.field = m.get('Field')
        if m.get('FieldValue') is not None:
            self.field_value = m.get('FieldValue')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('TargetValue') is not None:
            self.target_value = m.get('TargetValue')
        return self


class CreateMaliciousFileWhitelistConfigResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateMaliciousFileWhitelistConfigResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code.
        self.code = code
        # The response parameters.
        self.data = data
        # The HTTP status code.
        self.http_status_code = http_status_code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateMaliciousFileWhitelistConfigResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMaliciousFileWhitelistConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMaliciousFileWhitelistConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMaliciousFileWhitelistConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMaliciousNoteRequest(TeaModel):
    def __init__(
        self,
        event_id: int = None,
        note: str = None,
    ):
        # The ID of the alert event to which you want to add remarks.
        # 
        # >  You can call the [ListAgentlessMaliciousFiles](~~ListAgentlessMaliciousFiles~~) operation to obtain the ID of the alert event from the NoteId parameter.
        # 
        # This parameter is required.
        self.event_id = event_id
        # The remarks that you want to add.
        # 
        # This parameter is required.
        self.note = note

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.note is not None:
            result['Note'] = self.note
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('Note') is not None:
            self.note = m.get('Note')
        return self


class CreateMaliciousNoteResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateMaliciousNoteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMaliciousNoteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMaliciousNoteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMonitorAccountRequest(TeaModel):
    def __init__(
        self,
        account_ids: str = None,
    ):
        # The account IDs of members in the resource directory.
        # 
        # >  You can call the [ListAccountsInResourceDirectory](~~ListAccountsInResourceDirectory~~) operation to obtain the account IDs. Separate multiple account IDs with commas (,). If you specify a value for this parameter, the existing list of members is replaced by the new list that you specify. Otherwise, the existing list is cleared.
        self.account_ids = account_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_ids is not None:
            result['AccountIds'] = self.account_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountIds') is not None:
            self.account_ids = m.get('AccountIds')
        return self


class CreateMonitorAccountResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateMonitorAccountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMonitorAccountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMonitorAccountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOpaClusterPluginRequest(TeaModel):
    def __init__(
        self,
        cluster_ids: List[str] = None,
    ):
        # The cluster IDs.
        # 
        # >  You can call the [DescribeGroupedContainerInstances](~~DescribeGroupedContainerInstances~~) operation to query the IDs of clusters.
        # 
        # This parameter is required.
        self.cluster_ids = cluster_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_ids is not None:
            result['ClusterIds'] = self.cluster_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterIds') is not None:
            self.cluster_ids = m.get('ClusterIds')
        return self


class CreateOpaClusterPluginResponseBodyInstallStatus(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        install_status: bool = None,
    ):
        # The cluster ID.
        self.cluster_id = cluster_id
        # Indicates whether the component is installed. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.install_status = install_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.install_status is not None:
            result['InstallStatus'] = self.install_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('InstallStatus') is not None:
            self.install_status = m.get('InstallStatus')
        return self


class CreateOpaClusterPluginResponseBody(TeaModel):
    def __init__(
        self,
        install_status: List[CreateOpaClusterPluginResponseBodyInstallStatus] = None,
        request_id: str = None,
    ):
        # The installation status of the components.
        self.install_status = install_status
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.install_status:
            for k in self.install_status:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InstallStatus'] = []
        if self.install_status is not None:
            for k in self.install_status:
                result['InstallStatus'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.install_status = []
        if m.get('InstallStatus') is not None:
            for k in m.get('InstallStatus'):
                temp_model = CreateOpaClusterPluginResponseBodyInstallStatus()
                self.install_status.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOpaClusterPluginResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateOpaClusterPluginResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOpaClusterPluginResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOpaStrategyNewRequestAlarmDetailBaselineItem(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
    ):
        # The ID of the baseline check item.
        # 
        # >  You can call the [GetOpaClusterBaseLineList](https://help.aliyun.com/document_detail/2539883.html) operation to query the ID.
        self.id = id
        # The name of the baseline check item.
        # 
        # >  You can call the [GetOpaClusterBaseLineList](https://help.aliyun.com/document_detail/2539883.html) operation to query the name.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateOpaStrategyNewRequestAlarmDetailBaseline(TeaModel):
    def __init__(
        self,
        item: List[CreateOpaStrategyNewRequestAlarmDetailBaselineItem] = None,
        risk_level: List[str] = None,
    ):
        # The baseline check items.
        self.item = item
        # The risk levels.
        self.risk_level = risk_level

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = CreateOpaStrategyNewRequestAlarmDetailBaselineItem()
                self.item.append(temp_model.from_map(k))
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        return self


class CreateOpaStrategyNewRequestAlarmDetailBuildRiskItem(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
    ):
        # The ID of the image build risk.
        # 
        # >  You can call the [ListImageBuildRiskItem](~~ListImageBuildRiskItem~~) operation to query the ID of the malicious sample.
        self.id = id
        # The name of the image build risk.
        # 
        # >  You can call the [ListImageBuildRiskItem](~~ListImageBuildRiskItem~~) operation to query the ID of the malicious sample.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateOpaStrategyNewRequestAlarmDetailBuildRisk(TeaModel):
    def __init__(
        self,
        item: List[CreateOpaStrategyNewRequestAlarmDetailBuildRiskItem] = None,
        risk_level: List[str] = None,
    ):
        # The configuration of image build risk.
        self.item = item
        # The risk levels.
        self.risk_level = risk_level

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = CreateOpaStrategyNewRequestAlarmDetailBuildRiskItem()
                self.item.append(temp_model.from_map(k))
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        return self


class CreateOpaStrategyNewRequestAlarmDetailMaliciousFileItem(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
    ):
        # The ID of the malicious sample.
        # 
        # >  You can call the [DescribeMatchedMaliciousNames](~~DescribeMatchedMaliciousNames~~) operation to query the ID.
        self.id = id
        # The name of the malicious sample.
        # 
        # >  You can call the [DescribeMatchedMaliciousNames](~~DescribeMatchedMaliciousNames~~) operation to query the name.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateOpaStrategyNewRequestAlarmDetailMaliciousFile(TeaModel):
    def __init__(
        self,
        item: List[CreateOpaStrategyNewRequestAlarmDetailMaliciousFileItem] = None,
        risk_level: List[str] = None,
    ):
        # The malicious samples.
        self.item = item
        # The risk levels.
        self.risk_level = risk_level

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = CreateOpaStrategyNewRequestAlarmDetailMaliciousFileItem()
                self.item.append(temp_model.from_map(k))
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        return self


class CreateOpaStrategyNewRequestAlarmDetailSensitiveFileItem(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
    ):
        # The ID of the sensitive files.
        # 
        # >  You can call the [GetSensitiveDefineRuleConfig](~~GetSensitiveDefineRuleConfig~~) operation to query the ID of the malicious sample.
        self.id = id
        # The name of the sensitive files.
        # 
        # >  You can call the [GetSensitiveDefineRuleConfig](~~GetSensitiveDefineRuleConfig~~) operation to query the ID of the malicious sample.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateOpaStrategyNewRequestAlarmDetailSensitiveFile(TeaModel):
    def __init__(
        self,
        item: List[CreateOpaStrategyNewRequestAlarmDetailSensitiveFileItem] = None,
        risk_level: List[str] = None,
    ):
        # The configuration of sensitive file.
        self.item = item
        # The risk levels.
        self.risk_level = risk_level

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = CreateOpaStrategyNewRequestAlarmDetailSensitiveFileItem()
                self.item.append(temp_model.from_map(k))
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        return self


class CreateOpaStrategyNewRequestAlarmDetailVulItem(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
    ):
        # The ID of the vulnerability.
        # 
        # >  You can call the [DescribeVulListPage](https://help.aliyun.com/document_detail/471928.html) operation to query the ID.
        self.id = id
        # The name of the vulnerability.
        # 
        # >  You can call the [DescribeVulListPage](https://help.aliyun.com/document_detail/471928.html) operation to query the name.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateOpaStrategyNewRequestAlarmDetailVulRiskClass(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
    ):
        # The ID of the vulnerability types. Valid values:
        # 
        # *   **cve**: system vulnerability
        # *   **app**: application vulnerability
        self.id = id
        # The name of the vulnerability. Valid values:
        # 
        # *   **system vulnerability**\
        # *   **application vulnerability**\
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateOpaStrategyNewRequestAlarmDetailVul(TeaModel):
    def __init__(
        self,
        item: List[CreateOpaStrategyNewRequestAlarmDetailVulItem] = None,
        risk_class: List[CreateOpaStrategyNewRequestAlarmDetailVulRiskClass] = None,
        risk_level: List[str] = None,
    ):
        # The vulnerabilities.
        self.item = item
        # Risk type of vulnerability.
        self.risk_class = risk_class
        # The risk levels.
        self.risk_level = risk_level

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()
        if self.risk_class:
            for k in self.risk_class:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        result['RiskClass'] = []
        if self.risk_class is not None:
            for k in self.risk_class:
                result['RiskClass'].append(k.to_map() if k else None)
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = CreateOpaStrategyNewRequestAlarmDetailVulItem()
                self.item.append(temp_model.from_map(k))
        self.risk_class = []
        if m.get('RiskClass') is not None:
            for k in m.get('RiskClass'):
                temp_model = CreateOpaStrategyNewRequestAlarmDetailVulRiskClass()
                self.risk_class.append(temp_model.from_map(k))
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        return self


class CreateOpaStrategyNewRequestAlarmDetail(TeaModel):
    def __init__(
        self,
        baseline: CreateOpaStrategyNewRequestAlarmDetailBaseline = None,
        build_risk: CreateOpaStrategyNewRequestAlarmDetailBuildRisk = None,
        malicious_file: CreateOpaStrategyNewRequestAlarmDetailMaliciousFile = None,
        sensitive_file: CreateOpaStrategyNewRequestAlarmDetailSensitiveFile = None,
        vul: CreateOpaStrategyNewRequestAlarmDetailVul = None,
    ):
        # The baseline risks.
        self.baseline = baseline
        # The configuration of image build risk.
        self.build_risk = build_risk
        # The malicious sample risks.
        self.malicious_file = malicious_file
        # The configuration of sensitive file.
        self.sensitive_file = sensitive_file
        # The vulnerability risks.
        self.vul = vul

    def validate(self):
        if self.baseline:
            self.baseline.validate()
        if self.build_risk:
            self.build_risk.validate()
        if self.malicious_file:
            self.malicious_file.validate()
        if self.sensitive_file:
            self.sensitive_file.validate()
        if self.vul:
            self.vul.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline is not None:
            result['Baseline'] = self.baseline.to_map()
        if self.build_risk is not None:
            result['BuildRisk'] = self.build_risk.to_map()
        if self.malicious_file is not None:
            result['MaliciousFile'] = self.malicious_file.to_map()
        if self.sensitive_file is not None:
            result['SensitiveFile'] = self.sensitive_file.to_map()
        if self.vul is not None:
            result['Vul'] = self.vul.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Baseline') is not None:
            temp_model = CreateOpaStrategyNewRequestAlarmDetailBaseline()
            self.baseline = temp_model.from_map(m['Baseline'])
        if m.get('BuildRisk') is not None:
            temp_model = CreateOpaStrategyNewRequestAlarmDetailBuildRisk()
            self.build_risk = temp_model.from_map(m['BuildRisk'])
        if m.get('MaliciousFile') is not None:
            temp_model = CreateOpaStrategyNewRequestAlarmDetailMaliciousFile()
            self.malicious_file = temp_model.from_map(m['MaliciousFile'])
        if m.get('SensitiveFile') is not None:
            temp_model = CreateOpaStrategyNewRequestAlarmDetailSensitiveFile()
            self.sensitive_file = temp_model.from_map(m['SensitiveFile'])
        if m.get('Vul') is not None:
            temp_model = CreateOpaStrategyNewRequestAlarmDetailVul()
            self.vul = temp_model.from_map(m['Vul'])
        return self


class CreateOpaStrategyNewRequestScopes(TeaModel):
    def __init__(
        self,
        ack_policy_instance_id: str = None,
        all_namespace: int = None,
        cluster_id: str = None,
        namespace_list: List[str] = None,
    ):
        # The ID of the cluster node to which the rule is applied.
        # 
        # > This parameter is not required when you create the instance.
        self.ack_policy_instance_id = ack_policy_instance_id
        # Specifies whether to include all namespaces. Valid values:
        # 
        # *   **1**: includes all namespaces.
        # *   **0**: does not include all namespaces.
        self.all_namespace = all_namespace
        # The ID of the cluster that is specified in the rule.
        # 
        # >  You can call the [DescribeGroupedContainerInstances](https://help.aliyun.com/document_detail/421736.html) operation to query the cluster ID.
        self.cluster_id = cluster_id
        # The namespaces.
        # 
        # > This parameter is valid only when the AllNamespace parameter is set to 0.
        self.namespace_list = namespace_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ack_policy_instance_id is not None:
            result['AckPolicyInstanceId'] = self.ack_policy_instance_id
        if self.all_namespace is not None:
            result['AllNamespace'] = self.all_namespace
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.namespace_list is not None:
            result['NamespaceList'] = self.namespace_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AckPolicyInstanceId') is not None:
            self.ack_policy_instance_id = m.get('AckPolicyInstanceId')
        if m.get('AllNamespace') is not None:
            self.all_namespace = m.get('AllNamespace')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('NamespaceList') is not None:
            self.namespace_list = m.get('NamespaceList')
        return self


class CreateOpaStrategyNewRequest(TeaModel):
    def __init__(
        self,
        alarm_detail: CreateOpaStrategyNewRequestAlarmDetail = None,
        cluster_id: str = None,
        cluster_name: str = None,
        description: str = None,
        image_name: List[str] = None,
        label: List[str] = None,
        malicious_image: bool = None,
        rule_action: int = None,
        scopes: List[CreateOpaStrategyNewRequestScopes] = None,
        strategy_id: int = None,
        strategy_name: str = None,
        strategy_template_id: int = None,
        un_scaned_image: bool = None,
        white_list: List[str] = None,
    ):
        # The risks that you want to detect by using the rule.
        self.alarm_detail = alarm_detail
        # The cluster ID.
        # 
        # > This parameter is deprecated.
        self.cluster_id = cluster_id
        # The cluster name.
        # 
        # > This parameter is deprecated.
        self.cluster_name = cluster_name
        # The rule description.
        self.description = description
        # The image names.
        self.image_name = image_name
        # The container tags.
        self.label = label
        # Specifies whether the rule supports malicious Internet images. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.malicious_image = malicious_image
        # The action that is performed when the rule is hit. Valid values:
        # 
        # *   **1**: trigger alerts
        # *   **2**: block
        # *   **3**: allow
        self.rule_action = rule_action
        # The application scope of the rule.
        self.scopes = scopes
        # The rule ID.
        # 
        # >  You can call the [ListOpaClusterStrategyNew](https://help.aliyun.com/document_detail/2623574.html) operation to query the rule ID.
        # 
        # > This parameter is invalid when you create a rule.
        self.strategy_id = strategy_id
        # The rule name.
        self.strategy_name = strategy_name
        # The ID of the rule template.
        # 
        # >  You can call the [GetOpaStrategyTemplateSummary](https://help.aliyun.com/document_detail/2539952.html) operation to query the ID of the rule template.
        self.strategy_template_id = strategy_template_id
        # Specifies whether the rule supports unscanned images. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.un_scaned_image = un_scaned_image
        # The whitelist.
        self.white_list = white_list

    def validate(self):
        if self.alarm_detail:
            self.alarm_detail.validate()
        if self.scopes:
            for k in self.scopes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_detail is not None:
            result['AlarmDetail'] = self.alarm_detail.to_map()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.description is not None:
            result['Description'] = self.description
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.label is not None:
            result['Label'] = self.label
        if self.malicious_image is not None:
            result['MaliciousImage'] = self.malicious_image
        if self.rule_action is not None:
            result['RuleAction'] = self.rule_action
        result['Scopes'] = []
        if self.scopes is not None:
            for k in self.scopes:
                result['Scopes'].append(k.to_map() if k else None)
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.strategy_name is not None:
            result['StrategyName'] = self.strategy_name
        if self.strategy_template_id is not None:
            result['StrategyTemplateId'] = self.strategy_template_id
        if self.un_scaned_image is not None:
            result['UnScanedImage'] = self.un_scaned_image
        if self.white_list is not None:
            result['WhiteList'] = self.white_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmDetail') is not None:
            temp_model = CreateOpaStrategyNewRequestAlarmDetail()
            self.alarm_detail = temp_model.from_map(m['AlarmDetail'])
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('MaliciousImage') is not None:
            self.malicious_image = m.get('MaliciousImage')
        if m.get('RuleAction') is not None:
            self.rule_action = m.get('RuleAction')
        self.scopes = []
        if m.get('Scopes') is not None:
            for k in m.get('Scopes'):
                temp_model = CreateOpaStrategyNewRequestScopes()
                self.scopes.append(temp_model.from_map(k))
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('StrategyName') is not None:
            self.strategy_name = m.get('StrategyName')
        if m.get('StrategyTemplateId') is not None:
            self.strategy_template_id = m.get('StrategyTemplateId')
        if m.get('UnScanedImage') is not None:
            self.un_scaned_image = m.get('UnScanedImage')
        if m.get('WhiteList') is not None:
            self.white_list = m.get('WhiteList')
        return self


class CreateOpaStrategyNewShrinkRequestScopes(TeaModel):
    def __init__(
        self,
        ack_policy_instance_id: str = None,
        all_namespace: int = None,
        cluster_id: str = None,
        namespace_list: List[str] = None,
    ):
        # The ID of the cluster node to which the rule is applied.
        # 
        # > This parameter is not required when you create the instance.
        self.ack_policy_instance_id = ack_policy_instance_id
        # Specifies whether to include all namespaces. Valid values:
        # 
        # *   **1**: includes all namespaces.
        # *   **0**: does not include all namespaces.
        self.all_namespace = all_namespace
        # The ID of the cluster that is specified in the rule.
        # 
        # >  You can call the [DescribeGroupedContainerInstances](https://help.aliyun.com/document_detail/421736.html) operation to query the cluster ID.
        self.cluster_id = cluster_id
        # The namespaces.
        # 
        # > This parameter is valid only when the AllNamespace parameter is set to 0.
        self.namespace_list = namespace_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ack_policy_instance_id is not None:
            result['AckPolicyInstanceId'] = self.ack_policy_instance_id
        if self.all_namespace is not None:
            result['AllNamespace'] = self.all_namespace
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.namespace_list is not None:
            result['NamespaceList'] = self.namespace_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AckPolicyInstanceId') is not None:
            self.ack_policy_instance_id = m.get('AckPolicyInstanceId')
        if m.get('AllNamespace') is not None:
            self.all_namespace = m.get('AllNamespace')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('NamespaceList') is not None:
            self.namespace_list = m.get('NamespaceList')
        return self


class CreateOpaStrategyNewShrinkRequest(TeaModel):
    def __init__(
        self,
        alarm_detail_shrink: str = None,
        cluster_id: str = None,
        cluster_name: str = None,
        description: str = None,
        image_name: List[str] = None,
        label: List[str] = None,
        malicious_image: bool = None,
        rule_action: int = None,
        scopes: List[CreateOpaStrategyNewShrinkRequestScopes] = None,
        strategy_id: int = None,
        strategy_name: str = None,
        strategy_template_id: int = None,
        un_scaned_image: bool = None,
        white_list: List[str] = None,
    ):
        # The risks that you want to detect by using the rule.
        self.alarm_detail_shrink = alarm_detail_shrink
        # The cluster ID.
        # 
        # > This parameter is deprecated.
        self.cluster_id = cluster_id
        # The cluster name.
        # 
        # > This parameter is deprecated.
        self.cluster_name = cluster_name
        # The rule description.
        self.description = description
        # The image names.
        self.image_name = image_name
        # The container tags.
        self.label = label
        # Specifies whether the rule supports malicious Internet images. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.malicious_image = malicious_image
        # The action that is performed when the rule is hit. Valid values:
        # 
        # *   **1**: trigger alerts
        # *   **2**: block
        # *   **3**: allow
        self.rule_action = rule_action
        # The application scope of the rule.
        self.scopes = scopes
        # The rule ID.
        # 
        # >  You can call the [ListOpaClusterStrategyNew](https://help.aliyun.com/document_detail/2623574.html) operation to query the rule ID.
        # 
        # > This parameter is invalid when you create a rule.
        self.strategy_id = strategy_id
        # The rule name.
        self.strategy_name = strategy_name
        # The ID of the rule template.
        # 
        # >  You can call the [GetOpaStrategyTemplateSummary](https://help.aliyun.com/document_detail/2539952.html) operation to query the ID of the rule template.
        self.strategy_template_id = strategy_template_id
        # Specifies whether the rule supports unscanned images. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.un_scaned_image = un_scaned_image
        # The whitelist.
        self.white_list = white_list

    def validate(self):
        if self.scopes:
            for k in self.scopes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_detail_shrink is not None:
            result['AlarmDetail'] = self.alarm_detail_shrink
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.description is not None:
            result['Description'] = self.description
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.label is not None:
            result['Label'] = self.label
        if self.malicious_image is not None:
            result['MaliciousImage'] = self.malicious_image
        if self.rule_action is not None:
            result['RuleAction'] = self.rule_action
        result['Scopes'] = []
        if self.scopes is not None:
            for k in self.scopes:
                result['Scopes'].append(k.to_map() if k else None)
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.strategy_name is not None:
            result['StrategyName'] = self.strategy_name
        if self.strategy_template_id is not None:
            result['StrategyTemplateId'] = self.strategy_template_id
        if self.un_scaned_image is not None:
            result['UnScanedImage'] = self.un_scaned_image
        if self.white_list is not None:
            result['WhiteList'] = self.white_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmDetail') is not None:
            self.alarm_detail_shrink = m.get('AlarmDetail')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('MaliciousImage') is not None:
            self.malicious_image = m.get('MaliciousImage')
        if m.get('RuleAction') is not None:
            self.rule_action = m.get('RuleAction')
        self.scopes = []
        if m.get('Scopes') is not None:
            for k in m.get('Scopes'):
                temp_model = CreateOpaStrategyNewShrinkRequestScopes()
                self.scopes.append(temp_model.from_map(k))
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('StrategyName') is not None:
            self.strategy_name = m.get('StrategyName')
        if m.get('StrategyTemplateId') is not None:
            self.strategy_template_id = m.get('StrategyTemplateId')
        if m.get('UnScanedImage') is not None:
            self.un_scaned_image = m.get('UnScanedImage')
        if m.get('WhiteList') is not None:
            self.white_list = m.get('WhiteList')
        return self


class CreateOpaStrategyNewResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[str] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The IDs of the clusters that failed to be saved.
        self.data = data
        # The HTTP status code.
        self.http_status_code = http_status_code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOpaStrategyNewResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateOpaStrategyNewResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOpaStrategyNewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrUpdateAssetGroupRequest(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        group_name: str = None,
        uuids: str = None,
    ):
        # The ID of the server group for which you want to add to or remove servers.
        # 
        # >  To modify the mapping between an asset and an asset group, you must provide the ID of the asset group. You can call the [DescribeAllGroups](~~DescribeAllGroups~~) to query the IDs of asset groups. If you do not configure this parameter when you call this operation, an asset group is created.
        self.group_id = group_id
        # The name of the server group that you want to create or the server group for which you want to add or remove a server.
        # 
        # >  To modify the mapping between a server and a server group, you must provide the name of the server group. You can call the [DescribeAllGroups](~~DescribeAllGroups~~) operation to query the names of server groups. If you do not configure GroupID when you call this operation, a server group is created. In this case, you must configure GroupName.
        self.group_name = group_name
        # The UUID of the server in the server group that you want to create or the server group for which you want to add or remove servers. Separate multiple UUIDs with commas (,).
        # 
        # >  You can call the [DescribeCloudCenterInstances](~~DescribeCloudCenterInstances~~) operation to query the UUIDs of servers.
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class CreateOrUpdateAssetGroupResponseBody(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        request_id: str = None,
    ):
        # The ID of the server group.
        self.group_id = group_id
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOrUpdateAssetGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateOrUpdateAssetGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOrUpdateAssetGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrUpdateAutoTagRuleRequest(TeaModel):
    def __init__(
        self,
        check_all: bool = None,
        expression: str = None,
        rule_desc: str = None,
        rule_id: int = None,
        rule_name: str = None,
        tag_context: str = None,
        tag_type: str = None,
    ):
        # Specifies whether to check the rule on the backend. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.check_all = check_all
        # The expression of the rule.
        self.expression = expression
        # The description of the rule.
        self.rule_desc = rule_desc
        # The ID of the rule.
        # 
        # >  You can call the [ListAutoTagRules](~~ListAutoTagRules~~) operation to query the ID.
        self.rule_id = rule_id
        # The name of the rule.
        # 
        # This parameter is required.
        self.rule_name = rule_name
        # The tag specified by the operation type of the rule.
        # 
        # *   If TagType is set to group, set this parameter to {"groupId":XXX}. XXX specifies the ID of the group. You can call the [DescribeGroupStruct](~~DescribeGroupStruct~~) operation to query the ID.
        # *   If TagType is set to tag, set this parameter to {"tagId":XXX}. XXX specifies the ID of the tag. You can call the [DescribeGroupedTags](~~DescribeGroupedTags~~) operation to query the ID.
        self.tag_context = tag_context
        # The operation type of the rule. Valid values:
        # 
        # *   **group**\
        # *   **tag**\
        # 
        # This parameter is required.
        self.tag_type = tag_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_all is not None:
            result['CheckAll'] = self.check_all
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.rule_desc is not None:
            result['RuleDesc'] = self.rule_desc
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.tag_context is not None:
            result['TagContext'] = self.tag_context
        if self.tag_type is not None:
            result['TagType'] = self.tag_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckAll') is not None:
            self.check_all = m.get('CheckAll')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('RuleDesc') is not None:
            self.rule_desc = m.get('RuleDesc')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('TagContext') is not None:
            self.tag_context = m.get('TagContext')
        if m.get('TagType') is not None:
            self.tag_type = m.get('TagType')
        return self


class CreateOrUpdateAutoTagRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOrUpdateAutoTagRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateOrUpdateAutoTagRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOrUpdateAutoTagRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrUpdateDingTalkRequest(TeaModel):
    def __init__(
        self,
        config_list: str = None,
        ding_talk_lang: str = None,
        group_id_list: str = None,
        id: int = None,
        interval_time: int = None,
        rule_action_name: str = None,
        send_url: str = None,
    ):
        # The alerts for which you want the chatbot to send notifications. The value is a JSON array that contains the following fields:
        # 
        # *   **type**: the types of alerts. The valid values are listed in the "Additional description of parameters" section in this topic.
        # 
        # *   **configItemList**: the list of check items. The value is a JSON array that contains the following fields:
        # 
        #     *   **key**: the key of the check item.
        #     *   **valueList**: the values of the check item. The value of valueList is a JSON array.
        # 
        # > For more information about the value of this parameter, see the "Addition description of parameters" section in this topic.
        self.config_list = config_list
        # The language of the notifications. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.ding_talk_lang = ding_talk_lang
        # The IDs of asset groups for which you want the chatbot to send notifications. The value is a JSON array.
        # 
        # > You can call the [DescribeGroupStruct](~~DescribeGroupStruct~~) operation to query the IDs of asset groups.
        self.group_id_list = group_id_list
        # The ID of the chatbot.
        # 
        # > You can call the [DescribeDingTalk](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-describedingtalk/?spm=a2c63.p38356.0.0.681e4360Qd1eb1) operation to query the IDs of chatbots.
        self.id = id
        # The time interval at which the chatbot sends notifications.
        # 
        # > The value **0** indicates unlimited.
        self.interval_time = interval_time
        # The name of the chatbot.
        # 
        # > The name of a chatbot must be 2 to 64 characters in length.
        # 
        # This parameter is required.
        self.rule_action_name = rule_action_name
        # The webhook URL.
        # 
        # This parameter is required.
        self.send_url = send_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_list is not None:
            result['ConfigList'] = self.config_list
        if self.ding_talk_lang is not None:
            result['DingTalkLang'] = self.ding_talk_lang
        if self.group_id_list is not None:
            result['GroupIdList'] = self.group_id_list
        if self.id is not None:
            result['Id'] = self.id
        if self.interval_time is not None:
            result['IntervalTime'] = self.interval_time
        if self.rule_action_name is not None:
            result['RuleActionName'] = self.rule_action_name
        if self.send_url is not None:
            result['SendUrl'] = self.send_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigList') is not None:
            self.config_list = m.get('ConfigList')
        if m.get('DingTalkLang') is not None:
            self.ding_talk_lang = m.get('DingTalkLang')
        if m.get('GroupIdList') is not None:
            self.group_id_list = m.get('GroupIdList')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IntervalTime') is not None:
            self.interval_time = m.get('IntervalTime')
        if m.get('RuleActionName') is not None:
            self.rule_action_name = m.get('RuleActionName')
        if m.get('SendUrl') is not None:
            self.send_url = m.get('SendUrl')
        return self


class CreateOrUpdateDingTalkResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOrUpdateDingTalkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateOrUpdateDingTalkResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOrUpdateDingTalkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOssBucketScanTaskRequest(TeaModel):
    def __init__(
        self,
        all_key_prefix: bool = None,
        bucket_name_list: List[str] = None,
        decompress_max_file_count: int = None,
        decompress_max_layer: int = None,
        decryption_list: List[str] = None,
        exclude_key_suffix_list: List[str] = None,
        key_prefix_list: List[str] = None,
        key_suffix_list: List[str] = None,
        last_modified_start_time: int = None,
        scan_mode: int = None,
    ):
        # Specifies whether to match the prefixes of all objects.
        self.all_key_prefix = all_key_prefix
        # The names of the buckets.
        # 
        # This parameter is required.
        self.bucket_name_list = bucket_name_list
        # The maximum number of objects that can be extracted during decompression. Valid values: 1 to 1000. If the maximum number of objects that can be extracted is reached, the decompression operation immediately ends and the detection of extracted objects is not affected.
        self.decompress_max_file_count = decompress_max_file_count
        # The maximum number of decompression levels when multi-level packages are decompressed. Valid values: 1 to 5. If the maximum number of decompression levels is reached, the decompression operation immediately ends and the detection of extracted objects is not affected.
        self.decompress_max_layer = decompress_max_layer
        # The decryption methods.
        self.decryption_list = decryption_list
        # The suffixes of the objects that you do not want to check.
        self.exclude_key_suffix_list = exclude_key_suffix_list
        # The prefixes of the objects.
        self.key_prefix_list = key_prefix_list
        # The suffixes of the objects that you want to check.
        self.key_suffix_list = key_suffix_list
        # The timestamp when the object was last modified. The time must be later than the timestamp that you specify. Unit: milliseconds.
        self.last_modified_start_time = last_modified_start_time
        # The check mode. Valid values:
        # 
        # *   **1**: checks all objects in the bucket.
        # *   **2**: checks only new objects in the bucket.
        # 
        # This parameter is required.
        self.scan_mode = scan_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_key_prefix is not None:
            result['AllKeyPrefix'] = self.all_key_prefix
        if self.bucket_name_list is not None:
            result['BucketNameList'] = self.bucket_name_list
        if self.decompress_max_file_count is not None:
            result['DecompressMaxFileCount'] = self.decompress_max_file_count
        if self.decompress_max_layer is not None:
            result['DecompressMaxLayer'] = self.decompress_max_layer
        if self.decryption_list is not None:
            result['DecryptionList'] = self.decryption_list
        if self.exclude_key_suffix_list is not None:
            result['ExcludeKeySuffixList'] = self.exclude_key_suffix_list
        if self.key_prefix_list is not None:
            result['KeyPrefixList'] = self.key_prefix_list
        if self.key_suffix_list is not None:
            result['KeySuffixList'] = self.key_suffix_list
        if self.last_modified_start_time is not None:
            result['LastModifiedStartTime'] = self.last_modified_start_time
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllKeyPrefix') is not None:
            self.all_key_prefix = m.get('AllKeyPrefix')
        if m.get('BucketNameList') is not None:
            self.bucket_name_list = m.get('BucketNameList')
        if m.get('DecompressMaxFileCount') is not None:
            self.decompress_max_file_count = m.get('DecompressMaxFileCount')
        if m.get('DecompressMaxLayer') is not None:
            self.decompress_max_layer = m.get('DecompressMaxLayer')
        if m.get('DecryptionList') is not None:
            self.decryption_list = m.get('DecryptionList')
        if m.get('ExcludeKeySuffixList') is not None:
            self.exclude_key_suffix_list = m.get('ExcludeKeySuffixList')
        if m.get('KeyPrefixList') is not None:
            self.key_prefix_list = m.get('KeyPrefixList')
        if m.get('KeySuffixList') is not None:
            self.key_suffix_list = m.get('KeySuffixList')
        if m.get('LastModifiedStartTime') is not None:
            self.last_modified_start_time = m.get('LastModifiedStartTime')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        return self


class CreateOssBucketScanTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOssBucketScanTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateOssBucketScanTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOssBucketScanTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOssScanConfigRequest(TeaModel):
    def __init__(
        self,
        all_key_prefix: bool = None,
        bucket_name_list: List[str] = None,
        decompress_max_file_count: int = None,
        decompress_max_layer: int = None,
        decryption_list: List[str] = None,
        enable: int = None,
        end_time: str = None,
        key_prefix_list: List[str] = None,
        key_suffix_list: List[str] = None,
        last_modified_start_time: int = None,
        name: str = None,
        real_time_incr: bool = None,
        scan_day_list: List[int] = None,
        start_time: str = None,
    ):
        # Specifies whether to match the prefixes of all objects.
        self.all_key_prefix = all_key_prefix
        # The names of buckets.
        self.bucket_name_list = bucket_name_list
        # The maximum number of objects that can be extracted during decompression. Valid values: 1 to 1000. If the maximum number of objects that can be extracted is reached, the decompression operation immediately ends and the detection of extracted objects is not affected.
        self.decompress_max_file_count = decompress_max_file_count
        # The maximum number of decompression levels when multi-level packages are decompressed. Valid values: 1 to 5. If the maximum number of decompression levels is reached, the decompression operation immediately ends and the detection of extracted objects is not affected.
        self.decompress_max_layer = decompress_max_layer
        # The decryption methods.
        self.decryption_list = decryption_list
        # Specifies whether to enable the policy. Valid values:
        # 
        # *   **1**: yes
        # *   **0**: no
        self.enable = enable
        # The time when the scan ends. The time must be in the HH:mm:ss format.
        self.end_time = end_time
        # The prefixes of the objects.
        self.key_prefix_list = key_prefix_list
        # The suffixes of the files to scan.
        self.key_suffix_list = key_suffix_list
        # The timestamp when the object was last modified. The time must be later than the timestamp that you specify. Unit: milliseconds.
        self.last_modified_start_time = last_modified_start_time
        # The policy name.
        self.name = name
        # Whether to enable real-time incremental detection. When this parameter is set to true, the parameters ScanDayList, StartTime, and EndTime are not effective.
        self.real_time_incr = real_time_incr
        # The days on which the scan is executed in a week.
        self.scan_day_list = scan_day_list
        # The time when the scan starts. The time must be in the HH:mm:ss format.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_key_prefix is not None:
            result['AllKeyPrefix'] = self.all_key_prefix
        if self.bucket_name_list is not None:
            result['BucketNameList'] = self.bucket_name_list
        if self.decompress_max_file_count is not None:
            result['DecompressMaxFileCount'] = self.decompress_max_file_count
        if self.decompress_max_layer is not None:
            result['DecompressMaxLayer'] = self.decompress_max_layer
        if self.decryption_list is not None:
            result['DecryptionList'] = self.decryption_list
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.key_prefix_list is not None:
            result['KeyPrefixList'] = self.key_prefix_list
        if self.key_suffix_list is not None:
            result['KeySuffixList'] = self.key_suffix_list
        if self.last_modified_start_time is not None:
            result['LastModifiedStartTime'] = self.last_modified_start_time
        if self.name is not None:
            result['Name'] = self.name
        if self.real_time_incr is not None:
            result['RealTimeIncr'] = self.real_time_incr
        if self.scan_day_list is not None:
            result['ScanDayList'] = self.scan_day_list
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllKeyPrefix') is not None:
            self.all_key_prefix = m.get('AllKeyPrefix')
        if m.get('BucketNameList') is not None:
            self.bucket_name_list = m.get('BucketNameList')
        if m.get('DecompressMaxFileCount') is not None:
            self.decompress_max_file_count = m.get('DecompressMaxFileCount')
        if m.get('DecompressMaxLayer') is not None:
            self.decompress_max_layer = m.get('DecompressMaxLayer')
        if m.get('DecryptionList') is not None:
            self.decryption_list = m.get('DecryptionList')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('KeyPrefixList') is not None:
            self.key_prefix_list = m.get('KeyPrefixList')
        if m.get('KeySuffixList') is not None:
            self.key_suffix_list = m.get('KeySuffixList')
        if m.get('LastModifiedStartTime') is not None:
            self.last_modified_start_time = m.get('LastModifiedStartTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RealTimeIncr') is not None:
            self.real_time_incr = m.get('RealTimeIncr')
        if m.get('ScanDayList') is not None:
            self.scan_day_list = m.get('ScanDayList')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class CreateOssScanConfigResponseBody(TeaModel):
    def __init__(
        self,
        id: int = None,
        request_id: str = None,
    ):
        # The policy ID.
        self.id = id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOssScanConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateOssScanConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOssScanConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRdDefaultSyncListRequest(TeaModel):
    def __init__(
        self,
        folder_ids: str = None,
    ):
        # The IDs of the folders in the resource directory.
        # 
        # >  You can call the [GetRdTree](~~GetRdTree~~) operation to obtain the IDs of the folders. Separate multiple folder IDs with commas (,). If you do not specify a value for this parameter, the existing member list is cleared.
        self.folder_ids = folder_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_ids is not None:
            result['FolderIds'] = self.folder_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FolderIds') is not None:
            self.folder_ids = m.get('FolderIds')
        return self


class CreateRdDefaultSyncListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateRdDefaultSyncListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRdDefaultSyncListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRdDefaultSyncListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRestoreJobRequest(TeaModel):
    def __init__(
        self,
        includes: str = None,
        snapshot_hash: str = None,
        snapshot_id: str = None,
        snapshot_version: str = None,
        source_type: str = None,
        target: str = None,
        uuid: str = None,
        vault_id: str = None,
    ):
        # The directory in which the files included in the restoration task are located. This parameter is specified when you create the anti-ransomware policy. The value is a directory that requires protection.
        # 
        # This parameter is required.
        self.includes = includes
        # The hash value of the snapshot.
        # 
        # > You can call the [DescribeSnapshots](~~DescribeSnapshots~~) operation to obtain the value of this parameter.
        # 
        # This parameter is required.
        self.snapshot_hash = snapshot_hash
        # The ID of the snapshot that you want to use for restoration.
        # 
        # > You can call the [DescribeSnapshots](~~DescribeSnapshots~~) operation to obtain the value of this parameter.
        # 
        # This parameter is required.
        self.snapshot_id = snapshot_id
        # The version of the backup data.
        # 
        # > You can call the [DescribeSnapshots](~~DescribeSnapshots~~) operation to obtain the value of this parameter.
        # 
        # This parameter is required.
        self.snapshot_version = snapshot_version
        # The type of the data source. Valid values:
        # 
        # *   **ECS_FILE**: backup snapshots for Elastic Compute Service (ECS) files
        # *   **File**: backup snapshots for on-premises servers
        self.source_type = source_type
        # The path to which you want to restore data.
        # 
        # This parameter is required.
        self.target = target
        # The UUID of the server whose data you want to restore.
        # 
        # This parameter is required.
        self.uuid = uuid
        # The ID of the backup vault that is used in the restoration task.
        # 
        # > You can call the [DescribeSnapshots](~~DescribeSnapshots~~) operation to obtain the value of this parameter.
        # 
        # This parameter is required.
        self.vault_id = vault_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.includes is not None:
            result['Includes'] = self.includes
        if self.snapshot_hash is not None:
            result['SnapshotHash'] = self.snapshot_hash
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.snapshot_version is not None:
            result['SnapshotVersion'] = self.snapshot_version
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.target is not None:
            result['Target'] = self.target
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vault_id is not None:
            result['VaultId'] = self.vault_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Includes') is not None:
            self.includes = m.get('Includes')
        if m.get('SnapshotHash') is not None:
            self.snapshot_hash = m.get('SnapshotHash')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('SnapshotVersion') is not None:
            self.snapshot_version = m.get('SnapshotVersion')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('VaultId') is not None:
            self.vault_id = m.get('VaultId')
        return self


class CreateRestoreJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateRestoreJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRestoreJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRestoreJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSasTrialRequestRequestForm(TeaModel):
    def __init__(
        self,
        try_reason: str = None,
    ):
        # The reason why you apply for the trial.
        self.try_reason = try_reason

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.try_reason is not None:
            result['TryReason'] = self.try_reason
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TryReason') is not None:
            self.try_reason = m.get('TryReason')
        return self


class CreateSasTrialRequest(TeaModel):
    def __init__(
        self,
        from_ecs: bool = None,
        lang: str = None,
        request_form: CreateSasTrialRequestRequestForm = None,
        try_type: int = None,
        try_version: int = None,
    ):
        # Specifies whether the request is redirected from the Elastic Compute Service (ECS) console. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.from_ecs = from_ecs
        # The language of the content within the request and response. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The reason why you apply for the trial. You must specify the reason for the second trial.
        self.request_form = request_form
        # The trial type. Valid values:
        # 
        # *   **0**: trial prohibited
        # *   **1**: first trial
        # *   **2**: second trial
        # 
        # >  You can call the [GetCanTrySas](https://help.aliyun.com/document_detail/2623574.html) operation to obtain the trial type. You can start a trial only if this parameter is not set to 0.
        self.try_type = try_type
        # The trial edition. Valid values:
        # 
        # *   **3**: Enterprise
        # *   **7**: Ultimate
        # 
        # >  You can call the [GetCanTrySas](https://help.aliyun.com/document_detail/2623574.html) operation to obtain the trial edition.
        self.try_version = try_version

    def validate(self):
        if self.request_form:
            self.request_form.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_ecs is not None:
            result['FromEcs'] = self.from_ecs
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.request_form is not None:
            result['RequestForm'] = self.request_form.to_map()
        if self.try_type is not None:
            result['TryType'] = self.try_type
        if self.try_version is not None:
            result['TryVersion'] = self.try_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FromEcs') is not None:
            self.from_ecs = m.get('FromEcs')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RequestForm') is not None:
            temp_model = CreateSasTrialRequestRequestForm()
            self.request_form = temp_model.from_map(m['RequestForm'])
        if m.get('TryType') is not None:
            self.try_type = m.get('TryType')
        if m.get('TryVersion') is not None:
            self.try_version = m.get('TryVersion')
        return self


class CreateSasTrialShrinkRequest(TeaModel):
    def __init__(
        self,
        from_ecs: bool = None,
        lang: str = None,
        request_form_shrink: str = None,
        try_type: int = None,
        try_version: int = None,
    ):
        # Specifies whether the request is redirected from the Elastic Compute Service (ECS) console. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.from_ecs = from_ecs
        # The language of the content within the request and response. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The reason why you apply for the trial. You must specify the reason for the second trial.
        self.request_form_shrink = request_form_shrink
        # The trial type. Valid values:
        # 
        # *   **0**: trial prohibited
        # *   **1**: first trial
        # *   **2**: second trial
        # 
        # >  You can call the [GetCanTrySas](https://help.aliyun.com/document_detail/2623574.html) operation to obtain the trial type. You can start a trial only if this parameter is not set to 0.
        self.try_type = try_type
        # The trial edition. Valid values:
        # 
        # *   **3**: Enterprise
        # *   **7**: Ultimate
        # 
        # >  You can call the [GetCanTrySas](https://help.aliyun.com/document_detail/2623574.html) operation to obtain the trial edition.
        self.try_version = try_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_ecs is not None:
            result['FromEcs'] = self.from_ecs
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.request_form_shrink is not None:
            result['RequestForm'] = self.request_form_shrink
        if self.try_type is not None:
            result['TryType'] = self.try_type
        if self.try_version is not None:
            result['TryVersion'] = self.try_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FromEcs') is not None:
            self.from_ecs = m.get('FromEcs')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RequestForm') is not None:
            self.request_form_shrink = m.get('RequestForm')
        if m.get('TryType') is not None:
            self.try_type = m.get('TryType')
        if m.get('TryVersion') is not None:
            self.try_version = m.get('TryVersion')
        return self


class CreateSasTrialResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSasTrialResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSasTrialResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSasTrialResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateServiceLinkedRoleRequest(TeaModel):
    def __init__(
        self,
        service_linked_role: str = None,
    ):
        # The service-linked role. Default value: **AliyunServiceRoleForSas**. Valid values:
        # 
        # *   **AliyunServiceRoleForSas**: the service-linked role of Security Center. Security Center assumes this role to access the resources of other cloud services within your account.
        # *   **AliyunServiceRoleForSasCspm**: the service-linked role of Security Center-CSPM. Security Center-CSPM assumes this role to access the resources of other cloud services within your account.
        self.service_linked_role = service_linked_role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_linked_role is not None:
            result['ServiceLinkedRole'] = self.service_linked_role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ServiceLinkedRole') is not None:
            self.service_linked_role = m.get('ServiceLinkedRole')
        return self


class CreateServiceLinkedRoleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateServiceLinkedRoleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateServiceLinkedRoleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateServiceLinkedRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateServiceTrailRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
    ):
        # The region ID of the instance. Valid values:
        # 
        # *   **cn-hangzhou**: International
        # *   **ap-southeast-1**: Singapore
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateServiceTrailResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateServiceTrailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateServiceTrailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateServiceTrailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSimilarSecurityEventsQueryTaskRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        security_event_id: int = None,
        similar_event_scenario_code: str = None,
        source_ip: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        # The ID of the alert event.
        # 
        # >  You must specify at least one of the SecurityEventId and SimilarEventScenarioCode parameters.
        # 
        # This parameter is required.
        self.security_event_id = security_event_id
        # The codes of alert events that are triggered by the same rule or of the same alert type.
        # 
        # >  You must specify at least one of the SecurityEventId and SimilarEventScenarioCode parameters.
        self.similar_event_scenario_code = similar_event_scenario_code
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_event_id is not None:
            result['SecurityEventId'] = self.security_event_id
        if self.similar_event_scenario_code is not None:
            result['SimilarEventScenarioCode'] = self.similar_event_scenario_code
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityEventId') is not None:
            self.security_event_id = m.get('SecurityEventId')
        if m.get('SimilarEventScenarioCode') is not None:
            self.similar_event_scenario_code = m.get('SimilarEventScenarioCode')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class CreateSimilarSecurityEventsQueryTaskResponseBodyCreateSimilarSecurityEventsQueryTaskResponse(TeaModel):
    def __init__(
        self,
        status: str = None,
        task_id: int = None,
    ):
        # The status of the task. Valid values:
        # 
        # *   **New**: The task is created.
        # *   **RetrievingData**: Data is being retrieved.
        # *   **DataRetrieved**: Data is retrieved.
        # *   **Processing**: The task is running.
        # *   **Success**: The task is successful.
        # *   **Failed**: The task failed.
        # *   **PartialFailed**: The task partially failed.
        self.status = status
        # The ID of the task.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateSimilarSecurityEventsQueryTaskResponseBody(TeaModel):
    def __init__(
        self,
        create_similar_security_events_query_task_response: CreateSimilarSecurityEventsQueryTaskResponseBodyCreateSimilarSecurityEventsQueryTaskResponse = None,
        request_id: str = None,
    ):
        # The information about the task that queries alert events of the same alert type.
        self.create_similar_security_events_query_task_response = create_similar_security_events_query_task_response
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.create_similar_security_events_query_task_response:
            self.create_similar_security_events_query_task_response.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_similar_security_events_query_task_response is not None:
            result['CreateSimilarSecurityEventsQueryTaskResponse'] = self.create_similar_security_events_query_task_response.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateSimilarSecurityEventsQueryTaskResponse') is not None:
            temp_model = CreateSimilarSecurityEventsQueryTaskResponseBodyCreateSimilarSecurityEventsQueryTaskResponse()
            self.create_similar_security_events_query_task_response = temp_model.from_map(m['CreateSimilarSecurityEventsQueryTaskResponse'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSimilarSecurityEventsQueryTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSimilarSecurityEventsQueryTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSimilarSecurityEventsQueryTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSoarStrategyTaskRequest(TeaModel):
    def __init__(
        self,
        strategy_id: int = None,
        strategy_name: str = None,
        strategy_task_name: str = None,
        strategy_task_params: str = None,
        strategy_task_plan_exe_time: int = None,
    ):
        # The ID of the policy.
        # 
        # >  You can call the [DescribeSoarSubscribedStrategy](~~DescribeSoarSubscribedStrategy~~) operation to obtain the ID.
        # 
        # This parameter is required.
        self.strategy_id = strategy_id
        # The name of the policy. Set the value to Automated Batch Vulnerability Fixing Policy for Multiple Servers.
        # 
        # This parameter is required.
        self.strategy_name = strategy_name
        # The name of.the policy task.
        # 
        # This parameter is required.
        self.strategy_task_name = strategy_task_name
        # The parameters of the policy task. The value is a JSON array.
        # 
        # Vulnerability-related parameters:
        # 
        # *   name: vluList
        # *   associationProperty: sasAllVul
        # *   value: basic vulnerability information
        # 
        # Snapshot-related parameters:
        # 
        # *   name: snapshotConfig
        # *   associationProperty: snapshotConfig
        # *   value: retention period
        # 
        # Notification-related parameters:
        # 
        # *   name: notifyConfig
        # *   associationProperty: notifyConfig
        # *   value: email or DingTalk configuration information
        # 
        # This parameter is required.
        self.strategy_task_params = strategy_task_params
        # The timestamp when the task is scheduled to start. Unit: milliseconds.
        self.strategy_task_plan_exe_time = strategy_task_plan_exe_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.strategy_name is not None:
            result['StrategyName'] = self.strategy_name
        if self.strategy_task_name is not None:
            result['StrategyTaskName'] = self.strategy_task_name
        if self.strategy_task_params is not None:
            result['StrategyTaskParams'] = self.strategy_task_params
        if self.strategy_task_plan_exe_time is not None:
            result['StrategyTaskPlanExeTime'] = self.strategy_task_plan_exe_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('StrategyName') is not None:
            self.strategy_name = m.get('StrategyName')
        if m.get('StrategyTaskName') is not None:
            self.strategy_task_name = m.get('StrategyTaskName')
        if m.get('StrategyTaskParams') is not None:
            self.strategy_task_params = m.get('StrategyTaskParams')
        if m.get('StrategyTaskPlanExeTime') is not None:
            self.strategy_task_plan_exe_time = m.get('StrategyTaskPlanExeTime')
        return self


class CreateSoarStrategyTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        strategy_task_id: int = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The ID of the policy task.
        self.strategy_task_id = strategy_task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.strategy_task_id is not None:
            result['StrategyTaskId'] = self.strategy_task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StrategyTaskId') is not None:
            self.strategy_task_id = m.get('StrategyTaskId')
        return self


class CreateSoarStrategyTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSoarStrategyTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSoarStrategyTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSuspEventNoteRequest(TeaModel):
    def __init__(
        self,
        event_id: int = None,
        note: str = None,
    ):
        # The ID of the alert event to which you want to add remarks. You can call the [DescribeSuspEvents](https://help.aliyun.com/document_detail/251497.html) operation to query the IDs of alert events.
        # 
        # This parameter is required.
        self.event_id = event_id
        # The remarks that you want to add.
        # 
        # This parameter is required.
        self.note = note

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.note is not None:
            result['Note'] = self.note
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('Note') is not None:
            self.note = m.get('Note')
        return self


class CreateSuspEventNoteResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The error message returned.
        self.message = message
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether exceptions are handled. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSuspEventNoteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSuspEventNoteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSuspEventNoteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUniBackupPolicyRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        account_password: str = None,
        database_add_by_user: str = None,
        database_type: str = None,
        full_plan: Dict[str, Any] = None,
        inc_plan: Dict[str, Any] = None,
        instance_id: str = None,
        policy_name: str = None,
        retention: int = None,
        speed_limiter: int = None,
        uni_region_id: str = None,
        uuid: str = None,
    ):
        # The name of the database account.
        self.account_name = account_name
        # The password of the database account.
        self.account_password = account_password
        # Specifies whether the database is manually added. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.database_add_by_user = database_add_by_user
        # The type of the database. Valid values:
        # 
        # *   **MYSQL**\
        # *   **ORACLE**\
        # *   **MSSQL**\
        # 
        # This parameter is required.
        self.database_type = database_type
        # The policy for full data backup. The value of this parameter is a JSON string. The JSON string contains the following fields:
        # 
        # *   **start**: the start time of a backup task.
        # *   **interval**: the interval of backup tasks.
        # *   **type**: the unit of the interval.
        # *   **days**: the days of a week on which a backup task is performed.
        # 
        # This parameter is required.
        self.full_plan = full_plan
        # The policy for incremental data backup. The value of this parameter is a JSON string. The JSON string contains the following fields:
        # 
        # *   **start**: the start time of a backup task.
        # *   **interval**: the interval of backup tasks.
        # *   **type**: the unit of the interval.
        # *   **days**: the days of a week on which a backup task is performed.
        # 
        # This parameter is required.
        self.inc_plan = inc_plan
        # The ID of the Elastic Compute Service (ECS) instance.
        # 
        # >  You can call the [DescribeUniBackupDatabase](~~DescribeUniBackupDatabase~~) operation to query the IDs of ECS instances.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The name of the anti-ransomware policy.
        # 
        # This parameter is required.
        self.policy_name = policy_name
        # The retention period of backup data.
        # 
        # This parameter is required.
        self.retention = retention
        # The maximum network bandwidth that is allowed during data backup. Unit: bytes.
        # 
        # This parameter is required.
        self.speed_limiter = speed_limiter
        # The region in which the server resides.
        # 
        # This parameter is required.
        self.uni_region_id = uni_region_id
        # The UUID of the server whose data is backed up based on the anti-ransomware policy.
        # 
        # >  You can call the [DescribeCloudCenterInstances](https://help.aliyun.com/document_detail/141932.html) operation to query the UUIDs of servers.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.account_password is not None:
            result['AccountPassword'] = self.account_password
        if self.database_add_by_user is not None:
            result['DatabaseAddByUser'] = self.database_add_by_user
        if self.database_type is not None:
            result['DatabaseType'] = self.database_type
        if self.full_plan is not None:
            result['FullPlan'] = self.full_plan
        if self.inc_plan is not None:
            result['IncPlan'] = self.inc_plan
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.retention is not None:
            result['Retention'] = self.retention
        if self.speed_limiter is not None:
            result['SpeedLimiter'] = self.speed_limiter
        if self.uni_region_id is not None:
            result['UniRegionId'] = self.uni_region_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AccountPassword') is not None:
            self.account_password = m.get('AccountPassword')
        if m.get('DatabaseAddByUser') is not None:
            self.database_add_by_user = m.get('DatabaseAddByUser')
        if m.get('DatabaseType') is not None:
            self.database_type = m.get('DatabaseType')
        if m.get('FullPlan') is not None:
            self.full_plan = m.get('FullPlan')
        if m.get('IncPlan') is not None:
            self.inc_plan = m.get('IncPlan')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('Retention') is not None:
            self.retention = m.get('Retention')
        if m.get('SpeedLimiter') is not None:
            self.speed_limiter = m.get('SpeedLimiter')
        if m.get('UniRegionId') is not None:
            self.uni_region_id = m.get('UniRegionId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class CreateUniBackupPolicyShrinkRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        account_password: str = None,
        database_add_by_user: str = None,
        database_type: str = None,
        full_plan_shrink: str = None,
        inc_plan_shrink: str = None,
        instance_id: str = None,
        policy_name: str = None,
        retention: int = None,
        speed_limiter: int = None,
        uni_region_id: str = None,
        uuid: str = None,
    ):
        # The name of the database account.
        self.account_name = account_name
        # The password of the database account.
        self.account_password = account_password
        # Specifies whether the database is manually added. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.database_add_by_user = database_add_by_user
        # The type of the database. Valid values:
        # 
        # *   **MYSQL**\
        # *   **ORACLE**\
        # *   **MSSQL**\
        # 
        # This parameter is required.
        self.database_type = database_type
        # The policy for full data backup. The value of this parameter is a JSON string. The JSON string contains the following fields:
        # 
        # *   **start**: the start time of a backup task.
        # *   **interval**: the interval of backup tasks.
        # *   **type**: the unit of the interval.
        # *   **days**: the days of a week on which a backup task is performed.
        # 
        # This parameter is required.
        self.full_plan_shrink = full_plan_shrink
        # The policy for incremental data backup. The value of this parameter is a JSON string. The JSON string contains the following fields:
        # 
        # *   **start**: the start time of a backup task.
        # *   **interval**: the interval of backup tasks.
        # *   **type**: the unit of the interval.
        # *   **days**: the days of a week on which a backup task is performed.
        # 
        # This parameter is required.
        self.inc_plan_shrink = inc_plan_shrink
        # The ID of the Elastic Compute Service (ECS) instance.
        # 
        # >  You can call the [DescribeUniBackupDatabase](~~DescribeUniBackupDatabase~~) operation to query the IDs of ECS instances.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The name of the anti-ransomware policy.
        # 
        # This parameter is required.
        self.policy_name = policy_name
        # The retention period of backup data.
        # 
        # This parameter is required.
        self.retention = retention
        # The maximum network bandwidth that is allowed during data backup. Unit: bytes.
        # 
        # This parameter is required.
        self.speed_limiter = speed_limiter
        # The region in which the server resides.
        # 
        # This parameter is required.
        self.uni_region_id = uni_region_id
        # The UUID of the server whose data is backed up based on the anti-ransomware policy.
        # 
        # >  You can call the [DescribeCloudCenterInstances](https://help.aliyun.com/document_detail/141932.html) operation to query the UUIDs of servers.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.account_password is not None:
            result['AccountPassword'] = self.account_password
        if self.database_add_by_user is not None:
            result['DatabaseAddByUser'] = self.database_add_by_user
        if self.database_type is not None:
            result['DatabaseType'] = self.database_type
        if self.full_plan_shrink is not None:
            result['FullPlan'] = self.full_plan_shrink
        if self.inc_plan_shrink is not None:
            result['IncPlan'] = self.inc_plan_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.retention is not None:
            result['Retention'] = self.retention
        if self.speed_limiter is not None:
            result['SpeedLimiter'] = self.speed_limiter
        if self.uni_region_id is not None:
            result['UniRegionId'] = self.uni_region_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AccountPassword') is not None:
            self.account_password = m.get('AccountPassword')
        if m.get('DatabaseAddByUser') is not None:
            self.database_add_by_user = m.get('DatabaseAddByUser')
        if m.get('DatabaseType') is not None:
            self.database_type = m.get('DatabaseType')
        if m.get('FullPlan') is not None:
            self.full_plan_shrink = m.get('FullPlan')
        if m.get('IncPlan') is not None:
            self.inc_plan_shrink = m.get('IncPlan')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('Retention') is not None:
            self.retention = m.get('Retention')
        if m.get('SpeedLimiter') is not None:
            self.speed_limiter = m.get('SpeedLimiter')
        if m.get('UniRegionId') is not None:
            self.uni_region_id = m.get('UniRegionId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class CreateUniBackupPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateUniBackupPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateUniBackupPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUniBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUniRestorePlanRequest(TeaModel):
    def __init__(
        self,
        database: str = None,
        instance_uuid: str = None,
        policy_id: int = None,
        reset_scn: str = None,
        reset_time: str = None,
        restore_info: str = None,
        time_point: int = None,
    ):
        # The name of the database.
        self.database = database
        # The UUID of the Hybrid Backup Recovery (HBR) agent that is used to restore the data of the database on your server.
        # 
        # >  You can call the [DescribeUniBackupDatabase](~~DescribeUniBackupDatabase~~) operation to query the UUID.
        self.instance_uuid = instance_uuid
        # The ID of the anti-ransomware policy.
        # 
        # >  You can call the [DescribeUniBackupPolicies](~~DescribeUniBackupPolicies~~) operation to query the ID.
        # 
        # This parameter is required.
        self.policy_id = policy_id
        # The identifier of the point in time for restoration in the backup version that you want to use. The database is an Oracle database.****\
        # 
        # >  You can call the [DescribeUniRecoverableList](~~DescribeUniRecoverableList~~) operation to query the value.
        self.reset_scn = reset_scn
        # The point in time for restoration in the backup version that you want to use. The database is an Oracle database.****\
        # 
        # >  You can call the [DescribeUniRecoverableList](~~DescribeUniRecoverableList~~) operation to query the value.
        self.reset_time = reset_time
        # The information about the database. This parameter is available when the database is a Microsoft SQL Server (MSSQL) database. The value is a JSON string. Valid values:
        # 
        # *   **name**: the name of the database
        # *   **files**: the path to the database files
        # 
        # >  You can call the [DescribeUniRecoverableList](~~DescribeUniRecoverableList~~) operation to query the information.
        self.restore_info = restore_info
        # The point in time to which you want to restore data.
        # 
        # >  You can call the [DescribeRestorePlans](~~DescribeRestorePlans~~) operation to query the point in time.
        # 
        # This parameter is required.
        self.time_point = time_point

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database is not None:
            result['Database'] = self.database
        if self.instance_uuid is not None:
            result['InstanceUuid'] = self.instance_uuid
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.reset_scn is not None:
            result['ResetScn'] = self.reset_scn
        if self.reset_time is not None:
            result['ResetTime'] = self.reset_time
        if self.restore_info is not None:
            result['RestoreInfo'] = self.restore_info
        if self.time_point is not None:
            result['TimePoint'] = self.time_point
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('InstanceUuid') is not None:
            self.instance_uuid = m.get('InstanceUuid')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('ResetScn') is not None:
            self.reset_scn = m.get('ResetScn')
        if m.get('ResetTime') is not None:
            self.reset_time = m.get('ResetTime')
        if m.get('RestoreInfo') is not None:
            self.restore_info = m.get('RestoreInfo')
        if m.get('TimePoint') is not None:
            self.time_point = m.get('TimePoint')
        return self


class CreateUniRestorePlanResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateUniRestorePlanResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateUniRestorePlanResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUniRestorePlanResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUserSettingRequest(TeaModel):
    def __init__(
        self,
        alert_levels: str = None,
        invalid_warning_keep_days: int = None,
        source_ip: str = None,
    ):
        # The severities of alerts.
        self.alert_levels = alert_levels
        # The number of days during which you want to retain invalid alerts.
        self.invalid_warning_keep_days = invalid_warning_keep_days
        # The source IP address.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_levels is not None:
            result['AlertLevels'] = self.alert_levels
        if self.invalid_warning_keep_days is not None:
            result['InvalidWarningKeepDays'] = self.invalid_warning_keep_days
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertLevels') is not None:
            self.alert_levels = m.get('AlertLevels')
        if m.get('InvalidWarningKeepDays') is not None:
            self.invalid_warning_keep_days = m.get('InvalidWarningKeepDays')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class CreateUserSettingResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateUserSettingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateUserSettingResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUserSettingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVirusScanOnceTaskRequest(TeaModel):
    def __init__(
        self,
        param: str = None,
        scan_path: List[str] = None,
        scan_type: str = None,
        selection_key: str = None,
    ):
        # Additional information fields: 
        # - **additionType**: The type of extended scan
        self.param = param
        # The information about the scan path that is required for a custom scan.
        self.scan_path = scan_path
        # The type of the virus scan. Valid values:
        # 
        # *   **system**: system scan.
        # *   **user**: custom scan.
        self.scan_type = scan_type
        # The key that stores the asset information.
        # 
        # > You can call the [GetAssetSelectionConfig](~~GetAssetSelectionConfig~~) operation to obtain the key value.
        self.selection_key = selection_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.param is not None:
            result['Param'] = self.param
        if self.scan_path is not None:
            result['ScanPath'] = self.scan_path
        if self.scan_type is not None:
            result['ScanType'] = self.scan_type
        if self.selection_key is not None:
            result['SelectionKey'] = self.selection_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Param') is not None:
            self.param = m.get('Param')
        if m.get('ScanPath') is not None:
            self.scan_path = m.get('ScanPath')
        if m.get('ScanType') is not None:
            self.scan_type = m.get('ScanType')
        if m.get('SelectionKey') is not None:
            self.selection_key = m.get('SelectionKey')
        return self


class CreateVirusScanOnceTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateVirusScanOnceTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateVirusScanOnceTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVirusScanOnceTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVulAutoRepairConfigRequestVulAutoRepairConfigList(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        name: str = None,
    ):
        # The alias of the vulnerability.
        # 
        # This parameter is required.
        self.alias_name = alias_name
        # The name of the vulnerability.
        # 
        # This parameter is required.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateVulAutoRepairConfigRequest(TeaModel):
    def __init__(
        self,
        reason: str = None,
        type: str = None,
        vul_auto_repair_config_list: List[CreateVulAutoRepairConfigRequestVulAutoRepairConfigList] = None,
    ):
        # The reason why the vulnerability can be automatically fixed.
        self.reason = reason
        # The type of the vulnerability. Valid values: -**cve**: Linux software vulnerability -**sys**: Windows system vulnerability
        # 
        # This parameter is required.
        self.type = type
        # The vulnerabilities that can be automatically fixed.
        # 
        # This parameter is required.
        self.vul_auto_repair_config_list = vul_auto_repair_config_list

    def validate(self):
        if self.vul_auto_repair_config_list:
            for k in self.vul_auto_repair_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.type is not None:
            result['Type'] = self.type
        result['VulAutoRepairConfigList'] = []
        if self.vul_auto_repair_config_list is not None:
            for k in self.vul_auto_repair_config_list:
                result['VulAutoRepairConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        self.vul_auto_repair_config_list = []
        if m.get('VulAutoRepairConfigList') is not None:
            for k in m.get('VulAutoRepairConfigList'):
                temp_model = CreateVulAutoRepairConfigRequestVulAutoRepairConfigList()
                self.vul_auto_repair_config_list.append(temp_model.from_map(k))
        return self


class CreateVulAutoRepairConfigResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The error message returned.
        self.message = message
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateVulAutoRepairConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateVulAutoRepairConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVulAutoRepairConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAntiBruteForceRuleRequest(TeaModel):
    def __init__(
        self,
        ids: List[int] = None,
    ):
        # The IDs of the defense rules against brute-force attacks to delete.
        # 
        # This parameter is required.
        self.ids = ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ids is not None:
            result['Ids'] = self.ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        return self


class DeleteAntiBruteForceRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAntiBruteForceRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAntiBruteForceRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAntiBruteForceRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAttackPathSensitiveAssetConfigRequest(TeaModel):
    def __init__(
        self,
        attack_path_sensitive_asset_config_id: str = None,
    ):
        # ID of the attack path sensitive asset configuration.
        # 
        # This parameter is required.
        self.attack_path_sensitive_asset_config_id = attack_path_sensitive_asset_config_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attack_path_sensitive_asset_config_id is not None:
            result['AttackPathSensitiveAssetConfigId'] = self.attack_path_sensitive_asset_config_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttackPathSensitiveAssetConfigId') is not None:
            self.attack_path_sensitive_asset_config_id = m.get('AttackPathSensitiveAssetConfigId')
        return self


class DeleteAttackPathSensitiveAssetConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAttackPathSensitiveAssetConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAttackPathSensitiveAssetConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAttackPathSensitiveAssetConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAttackPathWhitelistRequest(TeaModel):
    def __init__(
        self,
        attack_path_whitelist_id: str = None,
    ):
        # Attack path whitelist ID.
        # > You can call [ListAttackPathWhitelist](~~ListAttackPathWhitelist~~) to query the attack path whitelist ID.
        # 
        # This parameter is required.
        self.attack_path_whitelist_id = attack_path_whitelist_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attack_path_whitelist_id is not None:
            result['AttackPathWhitelistId'] = self.attack_path_whitelist_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttackPathWhitelistId') is not None:
            self.attack_path_whitelist_id = m.get('AttackPathWhitelistId')
        return self


class DeleteAttackPathWhitelistResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of this request, which is a unique identifier generated by Alibaba Cloud for this request and can be used for troubleshooting and problem localization.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAttackPathWhitelistResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAttackPathWhitelistResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAttackPathWhitelistResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAttestorRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        resource_owner_id: int = None,
        source_ip: str = None,
    ):
        # The name of the witness.
        self.name = name
        self.resource_owner_id = resource_owner_id
        # The source IP address.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DeleteAttestorResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAttestorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAttestorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAttestorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAutoTagRulesRequest(TeaModel):
    def __init__(
        self,
        rule_id_list: str = None,
    ):
        # The ID of the asset auto-tagging rule. Separate multiple IDs with commas (,).
        # 
        # >  You can call the [ListAutoTagRules](~~ListAutoTagRules~~) operation to query the ID.
        # 
        # This parameter is required.
        self.rule_id_list = rule_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id_list is not None:
            result['RuleIdList'] = self.rule_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleIdList') is not None:
            self.rule_id_list = m.get('RuleIdList')
        return self


class DeleteAutoTagRulesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAutoTagRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAutoTagRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAutoTagRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBackupPolicyRequest(TeaModel):
    def __init__(
        self,
        id: int = None,
        policy_version: str = None,
    ):
        # The ID of the anti-ransomware policy that you want to delete.
        # 
        # >  You can call the [DescribeBackupPolicies](~~DescribeBackupPolicies~~) operation to query the IDs of anti-ransomware policies.
        # 
        # This parameter is required.
        self.id = id
        # The version of the anti-ransomware policy that you want to delete. You can call the [DescribeBackupPolicies](~~DescribeBackupPolicies~~) operation to query the versions of anti-ransomware policies. Valid values:
        # 
        # *   **1.0.0**\
        # *   **2.0.0**\
        self.policy_version = policy_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        return self


class DeleteBackupPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBackupPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteBackupPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBackupPolicyMachineRequest(TeaModel):
    def __init__(
        self,
        policy_id: int = None,
        policy_version: str = None,
        uuid: str = None,
        uuid_list: List[str] = None,
    ):
        # The ID of the anti-ransomware policy.
        # 
        # > You can call the [DescribeBackupPolicies](~~DescribeBackupPolicies~~) operation to query the IDs of anti-ransomware policies.
        # 
        # This parameter is required.
        self.policy_id = policy_id
        # The version of the anti-ransomware policy. Valid values:
        # 
        # *   **1.0.0**\
        # *   **2.0.0**\
        # 
        # >  You can call the [DescribeBackupPolicies](~~DescribeBackupPolicies~~) operation to query the versions of anti-ransomware policies.
        # 
        # This parameter is required.
        self.policy_version = policy_version
        # The UUID of the server to which the anti-ransomware policy is applied.
        # 
        # > You must specify at least one of the `UuidList` and `Uuid` parameters.
        self.uuid = uuid
        # The UUIDs of the servers to which the anti-ransomware policy is applied.
        # 
        # > You must specify at least one of the `UuidList` and `Uuid` parameters.
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DeleteBackupPolicyMachineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBackupPolicyMachineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteBackupPolicyMachineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteBackupPolicyMachineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBackupSnapshotRequestBackupSnapshotList(TeaModel):
    def __init__(
        self,
        client_id: str = None,
        instance_id: str = None,
        region_id: str = None,
        snapshot_id: str = None,
        source_type: str = None,
        vault_id: str = None,
    ):
        # The ID of the Cloud Backup client.
        # 
        # >  You can call the [DescribeSnapshots](~~DescribeSnapshots~~) operation to query the ID.
        # 
        # This parameter is required.
        self.client_id = client_id
        # The ID of the server.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The region in which Security Center is deployed. Valid values:
        # 
        # *   **cn-hangzhou**: China (Hangzhou).
        # *   **ap-southeast-1**: Singapore.
        # *   **cn-beijing**: China (Beijing).
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the snapshot that you want to delete.
        # 
        # >  You can call the [DescribeSnapshots](~~DescribeSnapshots~~) operation to query the ID.
        # 
        # This parameter is required.
        self.snapshot_id = snapshot_id
        # The type of the data source. Valid values:
        # 
        # *   **ECS_FILE**: Elastic Compute Service (ECS) files.
        # *   **OSS**: Object Storage Service (OSS) buckets.
        # *   **NAS**: File Storage NAS (NAS) file systems.
        # *   **OTS_TABLE**: Tablestore instances.
        # 
        # This parameter is required.
        self.source_type = source_type
        # The ID of the backup vault that is used in the restoration task.
        # 
        # >  You can call the [DescribeSnapshots](~~DescribeSnapshots~~) operation to query the ID.
        # 
        # This parameter is required.
        self.vault_id = vault_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.vault_id is not None:
            result['VaultId'] = self.vault_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('VaultId') is not None:
            self.vault_id = m.get('VaultId')
        return self


class DeleteBackupSnapshotRequest(TeaModel):
    def __init__(
        self,
        backup_region_id_list: List[str] = None,
        backup_snapshot_list: List[DeleteBackupSnapshotRequestBackupSnapshotList] = None,
        retain_latest_snapshot: bool = None,
    ):
        # The regions for backup.
        self.backup_region_id_list = backup_region_id_list
        # The backup snapshots.
        self.backup_snapshot_list = backup_snapshot_list
        # Specifies whether to retain the latest snapshot. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.retain_latest_snapshot = retain_latest_snapshot

    def validate(self):
        if self.backup_snapshot_list:
            for k in self.backup_snapshot_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_region_id_list is not None:
            result['BackupRegionIdList'] = self.backup_region_id_list
        result['BackupSnapshotList'] = []
        if self.backup_snapshot_list is not None:
            for k in self.backup_snapshot_list:
                result['BackupSnapshotList'].append(k.to_map() if k else None)
        if self.retain_latest_snapshot is not None:
            result['RetainLatestSnapshot'] = self.retain_latest_snapshot
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupRegionIdList') is not None:
            self.backup_region_id_list = m.get('BackupRegionIdList')
        self.backup_snapshot_list = []
        if m.get('BackupSnapshotList') is not None:
            for k in m.get('BackupSnapshotList'):
                temp_model = DeleteBackupSnapshotRequestBackupSnapshotList()
                self.backup_snapshot_list.append(temp_model.from_map(k))
        if m.get('RetainLatestSnapshot') is not None:
            self.retain_latest_snapshot = m.get('RetainLatestSnapshot')
        return self


class DeleteBackupSnapshotResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBackupSnapshotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteBackupSnapshotResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteBackupSnapshotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBaselineCheckWhiteRecordRequest(TeaModel):
    def __init__(
        self,
        check_ids: List[int] = None,
        lang: str = None,
        record_ids: List[int] = None,
        source: str = None,
    ):
        # The IDs of check items.
        self.check_ids = check_ids
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The IDs of the whitelist records.
        self.record_ids = record_ids
        # The data source. Valid values:
        # 
        # *   **default**: host baseline
        # *   **agentless**: agentless detection
        self.source = source

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_ids is not None:
            result['CheckIds'] = self.check_ids
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.record_ids is not None:
            result['RecordIds'] = self.record_ids
        if self.source is not None:
            result['Source'] = self.source
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckIds') is not None:
            self.check_ids = m.get('CheckIds')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RecordIds') is not None:
            self.record_ids = m.get('RecordIds')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        return self


class DeleteBaselineCheckWhiteRecordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBaselineCheckWhiteRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteBaselineCheckWhiteRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteBaselineCheckWhiteRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBinarySecurityPolicyRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        resource_owner_id: int = None,
        source_ip: str = None,
    ):
        # The name of the binary security policy.
        self.name = name
        self.resource_owner_id = resource_owner_id
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DeleteBinarySecurityPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBinarySecurityPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteBinarySecurityPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteBinarySecurityPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCheckPolicyRequest(TeaModel):
    def __init__(
        self,
        policy_ids: List[int] = None,
        policy_type: str = None,
    ):
        # Array of policies to delete
        # 
        # This parameter is required.
        self.policy_ids = policy_ids
        # Policy type for custom check rule:
        # 
        # *   **STANDARD**: Standard-level policy
        # *   **REQUIREMENT**: Requirement-level policy
        # *   **SECTION**: Section-level policy
        # 
        # This parameter is required.
        self.policy_type = policy_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        return self


class DeleteCheckPolicyResponseBodyPolicys(TeaModel):
    def __init__(
        self,
        policy_id: int = None,
        policy_show_name: str = None,
        policy_type: str = None,
    ):
        # Deleted policy ID.
        self.policy_id = policy_id
        # The name of the custom policy.
        self.policy_show_name = policy_show_name
        # Policy type for custom check rule:
        # 
        # *   **STANDARD**: Standard-level policy
        # *   **REQUIREMENT**: Requirement-level policy
        # *   **SECTION**: Section-level policy
        self.policy_type = policy_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_show_name is not None:
            result['PolicyShowName'] = self.policy_show_name
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyShowName') is not None:
            self.policy_show_name = m.get('PolicyShowName')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        return self


class DeleteCheckPolicyResponseBody(TeaModel):
    def __init__(
        self,
        policys: List[DeleteCheckPolicyResponseBodyPolicys] = None,
        request_id: str = None,
    ):
        # List of deleted policy details.
        self.policys = policys
        # The unique ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.policys:
            for k in self.policys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Policys'] = []
        if self.policys is not None:
            for k in self.policys:
                result['Policys'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.policys = []
        if m.get('Policys') is not None:
            for k in m.get('Policys'):
                temp_model = DeleteCheckPolicyResponseBodyPolicys()
                self.policys.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCheckPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCheckPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCheckPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteClientUserDefineRuleRequest(TeaModel):
    def __init__(
        self,
        id_list: List[int] = None,
    ):
        # The IDs of the custom defense rules.
        # 
        # This parameter is required.
        self.id_list = id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id_list is not None:
            result['IdList'] = self.id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdList') is not None:
            self.id_list = m.get('IdList')
        return self


class DeleteClientUserDefineRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteClientUserDefineRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteClientUserDefineRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteClientUserDefineRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCloudVendorAccountAKRequest(TeaModel):
    def __init__(
        self,
        auth_id: int = None,
        auth_modules: List[str] = None,
    ):
        # The unique ID of the AccessKey pair.
        # 
        # This parameter is required.
        self.auth_id = auth_id
        # The modules that are associated with the AccessKey pair.
        self.auth_modules = auth_modules

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_id is not None:
            result['AuthId'] = self.auth_id
        if self.auth_modules is not None:
            result['AuthModules'] = self.auth_modules
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthId') is not None:
            self.auth_id = m.get('AuthId')
        if m.get('AuthModules') is not None:
            self.auth_modules = m.get('AuthModules')
        return self


class DeleteCloudVendorAccountAKResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCloudVendorAccountAKResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCloudVendorAccountAKResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCloudVendorAccountAKResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteContainerDefenseRuleRequest(TeaModel):
    def __init__(
        self,
        rule_ids: List[int] = None,
    ):
        # The IDs of the rules that you want to delete.
        # 
        # >  You can call the [ListContainerDefenseRule](https://help.aliyun.com/document_detail/2590599.html) operation to query the rule IDs.
        self.rule_ids = rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_ids is not None:
            result['RuleIds'] = self.rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleIds') is not None:
            self.rule_ids = m.get('RuleIds')
        return self


class DeleteContainerDefenseRuleResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: int = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code that is returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The number of deleted rules.
        self.data = data
        # The HTTP status code. The value 200 indicates that the request was successful.
        self.http_status_code = http_status_code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteContainerDefenseRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteContainerDefenseRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteContainerDefenseRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteContainerPluginRuleRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        rule_id: int = None,
    ):
        # The language of the content within the request and the response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The ID of the rule. You can call the addContainerWebDefenseRule operation to query the ID.
        # 
        # This parameter is required.
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteContainerPluginRuleResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        # Indicates whether the container plug-in is manually deleted. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteContainerPluginRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteContainerPluginRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteContainerPluginRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomBlockRecordRequest(TeaModel):
    def __init__(
        self,
        id: int = None,
        resource_owner_id: int = None,
    ):
        # The ID of the IP address blocking policy.
        # 
        # > You can call the [DescribeCustomBlockRecords](~~DescribeCustomBlockRecords~~) operation to query the ID.
        # 
        # This parameter is required.
        self.id = id
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteCustomBlockRecordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCustomBlockRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCustomBlockRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomBlockRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomizeReportRequest(TeaModel):
    def __init__(
        self,
        report_id: int = None,
    ):
        # The ID of the report.
        # 
        # >  You can call the [DescribeCustomizeReportList](~~DescribeCustomizeReportList~~) operation to query the ID.
        # 
        # This parameter is required.
        self.report_id = report_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        return self


class DeleteCustomizeReportResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCustomizeReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCustomizeReportResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomizeReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomizedDictRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
    ):
        # The source IP address.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DeleteCustomizedDictResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCustomizedDictResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCustomizedDictResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomizedDictResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCycleTaskRequest(TeaModel):
    def __init__(
        self,
        config_id: str = None,
    ):
        # The ID of the task configuration.
        # 
        # >  You can call the [DescribeCycleTaskList](~~DescribeCycleTaskList~~) operation to query the IDs of task configurations.
        # 
        # This parameter is required.
        self.config_id = config_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        return self


class DeleteCycleTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCycleTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCycleTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCycleTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDingTalkRequest(TeaModel):
    def __init__(
        self,
        ids: str = None,
    ):
        # The ID of the notification from the DingTalk chatbot. Separate multiple IDs with commas (,).
        # 
        # >  You can call the [DescribeDingTalk](~~DescribeDingTalk~~) operation to query the ID.
        # 
        # This parameter is required.
        self.ids = ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ids is not None:
            result['Ids'] = self.ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        return self


class DeleteDingTalkResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDingTalkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDingTalkResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDingTalkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFileProtectRuleRequest(TeaModel):
    def __init__(
        self,
        id: List[int] = None,
    ):
        # The IDs of the core file monitoring rules that you want to delete.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteFileProtectRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteFileProtectRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteFileProtectRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteFileProtectRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGroupRequest(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        source_ip: str = None,
    ):
        # The ID of the server group that you want to delete.
        # 
        # >  To delete a server group, you must provide the ID of the server group. You can call the [DescribeAllGroups](~~DescribeAllGroups~~) operation to query the ID.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DeleteGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        request_id: str = None,
    ):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHoneypotRequest(TeaModel):
    def __init__(
        self,
        honeypot_id: str = None,
        lang: str = None,
    ):
        # The ID of the honeypot.
        # 
        # > You can call the [ListHoneypot](~~ListHoneypot~~) operation to query the IDs of honeypots.
        # 
        # This parameter is required.
        self.honeypot_id = honeypot_id
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.honeypot_id is not None:
            result['HoneypotId'] = self.honeypot_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HoneypotId') is not None:
            self.honeypot_id = m.get('HoneypotId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DeleteHoneypotResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHoneypotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHoneypotResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHoneypotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHoneypotNodeRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        node_id: str = None,
    ):
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The ID of the management node.
        # 
        # > You can call the [ListHoneypotNode](~~ListHoneypotNode~~) operation to query the IDs of management nodes.
        # 
        # This parameter is required.
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class DeleteHoneypotNodeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHoneypotNodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHoneypotNodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHoneypotNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHoneypotPresetRequest(TeaModel):
    def __init__(
        self,
        honeypot_preset_id: str = None,
        lang: str = None,
    ):
        # The ID of the honeypot template.
        # 
        # > You can call the [ListHoneypotPreset](~~ListHoneypotPreset~~) operation to query the IDs of honeypot templates.
        # 
        # This parameter is required.
        self.honeypot_preset_id = honeypot_preset_id
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese.
        # *   **en**: English.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.honeypot_preset_id is not None:
            result['HoneypotPresetId'] = self.honeypot_preset_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HoneypotPresetId') is not None:
            self.honeypot_preset_id = m.get('HoneypotPresetId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DeleteHoneypotPresetResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHoneypotPresetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHoneypotPresetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHoneypotPresetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHoneypotProbeRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        probe_id: str = None,
    ):
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese.
        # *   **en**: English.
        self.lang = lang
        # The ID of the probe.
        # 
        # > You can call the [ListHoneypotProbe](~~ListHoneypotProbe~~) operation to query the IDs of probes.
        # 
        # This parameter is required.
        self.probe_id = probe_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.probe_id is not None:
            result['ProbeId'] = self.probe_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ProbeId') is not None:
            self.probe_id = m.get('ProbeId')
        return self


class DeleteHoneypotProbeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHoneypotProbeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHoneypotProbeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHoneypotProbeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHoneypotProbeBindRequest(TeaModel):
    def __init__(
        self,
        bind_id: str = None,
        lang: str = None,
        probe_id: str = None,
    ):
        # The unique ID of the bound service.
        self.bind_id = bind_id
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The probe ID.
        # 
        # >  You can call the [ListHoneypotProbe](~~ListHoneypotProbe~~) operation to query the IDs of probes.
        self.probe_id = probe_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_id is not None:
            result['BindId'] = self.bind_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.probe_id is not None:
            result['ProbeId'] = self.probe_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindId') is not None:
            self.bind_id = m.get('BindId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ProbeId') is not None:
            self.probe_id = m.get('ProbeId')
        return self


class DeleteHoneypotProbeBindResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The HTTP status code that is returned.
        self.http_status_code = http_status_code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHoneypotProbeBindResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHoneypotProbeBindResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHoneypotProbeBindResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHybridProxyRequest(TeaModel):
    def __init__(
        self,
        cluster_name: str = None,
        uuid: str = None,
    ):
        # The name of the proxy cluster.
        # 
        # This parameter is required.
        self.cluster_name = cluster_name
        # The UUID of the proxy node that you want to remove. The value starts with inet-proxy.
        # 
        # This parameter is required.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DeleteHybridProxyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteHybridProxyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHybridProxyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHybridProxyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHybridProxyClusterRequest(TeaModel):
    def __init__(
        self,
        cluster_name: str = None,
    ):
        # The name of the proxy cluster.
        # 
        # This parameter is required.
        self.cluster_name = cluster_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        return self


class DeleteHybridProxyClusterResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteHybridProxyClusterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHybridProxyClusterResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHybridProxyClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteIdcProbeRequest(TeaModel):
    def __init__(
        self,
        uuid: str = None,
    ):
        # The UUID of the server.
        # 
        # >  You can call the [DescribeCloudCenterInstances](~~DescribeCloudCenterInstances~~) operation to query the UUIDs of servers.
        # 
        # This parameter is required.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DeleteIdcProbeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteIdcProbeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteIdcProbeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteIdcProbeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteImageEventOperationRequest(TeaModel):
    def __init__(
        self,
        id: int = None,
    ):
        # The primary key of the alert handling rule.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteImageEventOperationResponseBodyData(TeaModel):
    def __init__(
        self,
        id: int = None,
    ):
        # The primary key of the alert handling rule.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteImageEventOperationResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DeleteImageEventOperationResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code.
        self.code = code
        # The returned data.
        self.data = data
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DeleteImageEventOperationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteImageEventOperationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteImageEventOperationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteImageEventOperationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteImageVulWhitelistRequest(TeaModel):
    def __init__(
        self,
        ids: str = None,
        lang: str = None,
    ):
        # The ID of the whitelist. Separate multiple IDs with commas (,).
        self.ids = ids
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ids is not None:
            result['Ids'] = self.ids
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DeleteImageVulWhitelistResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code.
        self.code = code
        # Indicates whether the image vulnerability whitelist is deleted. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.data = data
        # The HTTP status code.
        self.http_status_code = http_status_code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteImageVulWhitelistResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteImageVulWhitelistResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteImageVulWhitelistResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInstallCodeRequest(TeaModel):
    def __init__(
        self,
        captcha_code: str = None,
    ):
        # The installation command.
        # 
        # >  You can call the [DescribeInstallCodes](~~DescribeInstallCodes~~) operation to query installation commands.
        # 
        # This parameter is required.
        self.captcha_code = captcha_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.captcha_code is not None:
            result['CaptchaCode'] = self.captcha_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CaptchaCode') is not None:
            self.captcha_code = m.get('CaptchaCode')
        return self


class DeleteInstallCodeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteInstallCodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteInstallCodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteInstallCodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInterceptionRuleRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        rule_ids: List[int] = None,
    ):
        # The ID of the cluster that you want to query.
        # 
        # > You can call the [DescribeGroupedContainerInstances](~~DescribeGroupedContainerInstances~~) operation to query the IDs of clusters.
        # 
        # This parameter is required.
        self.cluster_id = cluster_id
        # The IDs of the rules that you want to delete.
        self.rule_ids = rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.rule_ids is not None:
            result['RuleIds'] = self.rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RuleIds') is not None:
            self.rule_ids = m.get('RuleIds')
        return self


class DeleteInterceptionRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteInterceptionRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteInterceptionRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteInterceptionRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInterceptionTargetRequest(TeaModel):
    def __init__(
        self,
        target_ids: str = None,
    ):
        # The IDs of the network objects that you want to remove. You can call the [ListInterceptionTargetPage](~~ListInterceptionTargetPage~~) operation to query the IDs of the network objects.
        # 
        # This parameter is required.
        self.target_ids = target_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_ids is not None:
            result['TargetIds'] = self.target_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TargetIds') is not None:
            self.target_ids = m.get('TargetIds')
        return self


class DeleteInterceptionTargetResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: bool = None,
    ):
        # The request ID.
        self.request_id = request_id
        # Indicates whether the network objects are removed. Valid values:
        # 
        # *   **true**: The network objects are removed.
        # *   **false**: The network objects fail to be removed.
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class DeleteInterceptionTargetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteInterceptionTargetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteInterceptionTargetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteK8sAccessInfoRequest(TeaModel):
    def __init__(
        self,
        aliyun_yundun_gateway_api_name: str = None,
        aliyun_yundun_gateway_pop_name: str = None,
        aliyun_yundun_gateway_project_name: str = None,
        id: int = None,
    ):
        # This parameter is deprecated.
        self.aliyun_yundun_gateway_api_name = aliyun_yundun_gateway_api_name
        # This parameter is deprecated.
        self.aliyun_yundun_gateway_pop_name = aliyun_yundun_gateway_pop_name
        # This parameter is deprecated.
        self.aliyun_yundun_gateway_project_name = aliyun_yundun_gateway_project_name
        # The ID generated when Kubernetes is connected. You can call the GenerateK8sAccessInfo operation to query the ID.
        # 
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aliyun_yundun_gateway_api_name is not None:
            result['AliyunYundunGatewayApiName'] = self.aliyun_yundun_gateway_api_name
        if self.aliyun_yundun_gateway_pop_name is not None:
            result['AliyunYundunGatewayPopName'] = self.aliyun_yundun_gateway_pop_name
        if self.aliyun_yundun_gateway_project_name is not None:
            result['AliyunYundunGatewayProjectName'] = self.aliyun_yundun_gateway_project_name
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliyunYundunGatewayApiName') is not None:
            self.aliyun_yundun_gateway_api_name = m.get('AliyunYundunGatewayApiName')
        if m.get('AliyunYundunGatewayPopName') is not None:
            self.aliyun_yundun_gateway_pop_name = m.get('AliyunYundunGatewayPopName')
        if m.get('AliyunYundunGatewayProjectName') is not None:
            self.aliyun_yundun_gateway_project_name = m.get('AliyunYundunGatewayProjectName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteK8sAccessInfoResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        # Indicates whether the request was successful. Valid value:
        # 
        # *   **true**\
        # *   **false**\
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteK8sAccessInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteK8sAccessInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteK8sAccessInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLoginBaseConfigRequest(TeaModel):
    def __init__(
        self,
        config: str = None,
        target: str = None,
        type: str = None,
    ):
        # The content of the logon security settings to delete. The content varies based on the type of the logon security settings. Valid values:
        # 
        # *   **login_common_ip**: approved logon IP addresses
        # 
        # Example: {"ip":"10.23.23.23"}.
        # 
        # *   **login_common_time**: approved logon time ranges
        # 
        # Example: {"startTime":"06:00:00","endTime":"16:00:00"}.
        # 
        # *   **login_common_account**: approved logon accounts
        # 
        # Example: {"account":"test_account_001"}.
        # 
        # *   **login_common_location**: approved logon locations
        # 
        # Example: {"location":"Shanghai"}.
        # 
        # This parameter is required.
        self.config = config
        # The UUID of the server whose logon security settings you want to delete.
        # 
        # > You can call the [DescribeCloudCenterInstances](~~DescribeCloudCenterInstances~~) operation to query the UUIDs of servers.
        self.target = target
        # The type of the logon security settings to delete. Valid values:
        # 
        # *   **login_common_ip**: approved logon IP addresses
        # *   **login_common_time**: approved logon time ranges
        # *   **login_common_account**: approved logon accounts
        # *   **login_common_location**: approved logon locations
        # 
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.target is not None:
            result['Target'] = self.target
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteLoginBaseConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLoginBaseConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLoginBaseConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLoginBaseConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMaliciousFileWhitelistConfigRequest(TeaModel):
    def __init__(
        self,
        config_id: int = None,
    ):
        # The ID of the alert whitelist rule of sensitive files that are detected by using the agentless detection feature. You can call the [ListMaliciousFileWhitelistConfigs](~~ListMaliciousFileWhitelistConfigs~~) operation to query the IDs of alert whitelist rules.
        self.config_id = config_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        return self


class DeleteMaliciousFileWhitelistConfigResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The HTTP status code.
        self.http_status_code = http_status_code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMaliciousFileWhitelistConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMaliciousFileWhitelistConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMaliciousFileWhitelistConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMaliciousNoteRequest(TeaModel):
    def __init__(
        self,
        note_id: int = None,
    ):
        # The ID of the remarks.
        # 
        # >  You can call the [ListAgentlessMaliciousFiles](~~ListAgentlessMaliciousFiles~~) operation to obtain the ID from the NoteId parameter.
        self.note_id = note_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.note_id is not None:
            result['NoteId'] = self.note_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NoteId') is not None:
            self.note_id = m.get('NoteId')
        return self


class DeleteMaliciousNoteResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMaliciousNoteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMaliciousNoteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMaliciousNoteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMonitorAccountRequest(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        # The ID of the member that you want to delete.
        # 
        # >  You can call the [DescribeMonitorAccounts](~~DescribeMonitorAccounts~~) operation to query the IDs of the members in the Security Center console.
        # 
        # This parameter is required.
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        return self


class DeleteMonitorAccountResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMonitorAccountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMonitorAccountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMonitorAccountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOpaStrategyNewRequest(TeaModel):
    def __init__(
        self,
        strategy_ids: List[int] = None,
    ):
        # The IDs of rules.
        self.strategy_ids = strategy_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.strategy_ids is not None:
            result['StrategyIds'] = self.strategy_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StrategyIds') is not None:
            self.strategy_ids = m.get('StrategyIds')
        return self


class DeleteOpaStrategyNewResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The HTTP status code.
        self.http_status_code = http_status_code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteOpaStrategyNewResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteOpaStrategyNewResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteOpaStrategyNewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOssScanConfigRequest(TeaModel):
    def __init__(
        self,
        id: int = None,
    ):
        # The configuration ID.
        # 
        # >  You can call the [ListOssScanConfig](~~ListOssScanConfig~~) operation to query configuration IDs.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteOssScanConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteOssScanConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteOssScanConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteOssScanConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePrivateRegistryRequest(TeaModel):
    def __init__(
        self,
        registry_id: int = None,
    ):
        # The ID of the image repository.
        # 
        # > You can call the [PageImageRegistry](~~PageImageRegistry~~) operation to query the IDs of image repositories.
        # 
        # This parameter is required.
        self.registry_id = registry_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.registry_id is not None:
            result['RegistryId'] = self.registry_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegistryId') is not None:
            self.registry_id = m.get('RegistryId')
        return self


class DeletePrivateRegistryResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.data = data
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePrivateRegistryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeletePrivateRegistryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePrivateRegistryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSasContainerWebDefenseRuleRequest(TeaModel):
    def __init__(
        self,
        rule_id: int = None,
    ):
        # The rule ID.
        # 
        # >  You can call the ListContainerWebDefenseRule operation to query the rule ID.
        # 
        # This parameter is required.
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteSasContainerWebDefenseRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSasContainerWebDefenseRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSasContainerWebDefenseRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSasContainerWebDefenseRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSearchConditionRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        source_ip: str = None,
        type: str = None,
    ):
        # The name of the frequently used search condition.
        # 
        # >  You can call the [DescribeSearchCondition](~~DescribeSearchCondition~~) operation to query frequently used search conditions.
        # 
        # This parameter is required.
        self.name = name
        # The source IP address of the request.
        self.source_ip = source_ip
        # The type of the asset. Default value: ecs. Valid values:
        # 
        # *   **ecs**: an Elastic Compute Service (ECS) instance.
        # *   **cloud_product**: an Alibaba Cloud service.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteSearchConditionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSearchConditionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSearchConditionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSearchConditionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSecurityEventMarkMissListRequest(TeaModel):
    def __init__(
        self,
        ids: List[int] = None,
        resource_owner_id: int = None,
    ):
        # The IDs of custom defense rule.
        self.ids = ids
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ids is not None:
            result['Ids'] = self.ids
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteSecurityEventMarkMissListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSecurityEventMarkMissListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSecurityEventMarkMissListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSecurityEventMarkMissListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteServiceTrailRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
    ):
        # The region in which your Security Center service is deployed. Valid values:
        # 
        # *   **cn-hangzhou**: center.
        # *   **ap-southeast-1**: Singapore.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteServiceTrailResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteServiceTrailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteServiceTrailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteServiceTrailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSoarStrategyTaskRequest(TeaModel):
    def __init__(
        self,
        strategy_task_id: int = None,
    ):
        # The ID of the policy task that is in the waiting state.
        # 
        # >  You can call the [DescribeSoarStrategyTasks](~~DescribeSoarStrategyTasks~~) operation to obtain the ID.
        # 
        # This parameter is required.
        self.strategy_task_id = strategy_task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.strategy_task_id is not None:
            result['StrategyTaskId'] = self.strategy_task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StrategyTaskId') is not None:
            self.strategy_task_id = m.get('StrategyTaskId')
        return self


class DeleteSoarStrategyTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSoarStrategyTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSoarStrategyTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSoarStrategyTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStrategyRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        lang: str = None,
        source_ip: str = None,
    ):
        # The ID of the baseline check policy that you want to delete.
        # 
        # This parameter is required.
        self.id = id
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DeleteStrategyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteStrategyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteStrategyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteStrategyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSuspEventNodeRequest(TeaModel):
    def __init__(
        self,
        note_id: int = None,
    ):
        # The ID of the description.
        # 
        # > You can call the [DescribeSuspEvents](~~DescribeSuspEvents~~) operation to obtain the ID of the description by using the EventNotes field.
        # 
        # This parameter is required.
        self.note_id = note_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.note_id is not None:
            result['NoteId'] = self.note_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NoteId') is not None:
            self.note_id = m.get('NoteId')
        return self


class DeleteSuspEventNodeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The additional information that is returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSuspEventNodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSuspEventNodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSuspEventNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTagWithUuidRequest(TeaModel):
    def __init__(
        self,
        tag_name: str = None,
        uuid_list: str = None,
    ):
        # The name of the tag.
        # 
        # This parameter is required.
        self.tag_name = tag_name
        # The UUIDs of servers.
        # 
        # > If the UuidList parameter is specified, Security Center removes the tag only from the servers whose UUIDs are specified by UuidList. If the UuidList parameter is not specified, Security Center removes the tag from all servers.
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DeleteTagWithUuidResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTagWithUuidResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteTagWithUuidResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTagWithUuidResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteUniBackupPolicyRequest(TeaModel):
    def __init__(
        self,
        policy_id: int = None,
        policy_ids: str = None,
    ):
        # The ID of the anti-ransomware policy.
        # 
        # >  You can call the [DescribeUniBackupPolicies](~~DescribeUniBackupPolicies~~) operation to query the IDs of anti-ransomware policies. You must specify at least one of the PolicyId parameter and the **PolicyIds** parameter.
        self.policy_id = policy_id
        # The IDs of anti-ransomware policies.
        # 
        # >  You can call the [DescribeUniBackupPolicies](~~DescribeUniBackupPolicies~~) operation to query the IDs of anti-ransomware policies. You must specify at least one of the **PolicyId** parameter and the PolicyIds parameter.
        self.policy_ids = policy_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        return self


class DeleteUniBackupPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteUniBackupPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteUniBackupPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteUniBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVpcHoneyPotRequest(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
    ):
        # The ID of the virtual private cloud (VPC) on which the honeypot is deployed.
        # 
        # > You can call the [DescribeVpcHoneyPotList](~~DescribeVpcHoneyPotList~~) operation to query the IDs of VPCs.
        # 
        # This parameter is required.
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DeleteVpcHoneyPotResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVpcHoneyPotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteVpcHoneyPotResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVpcHoneyPotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVulAutoRepairConfigRequest(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        config_id_list: List[int] = None,
        type: str = None,
    ):
        # The alias of the vulnerability.
        self.alias_name = alias_name
        # The IDs of the configurations.
        # 
        # >  You can call the [ListVulAutoRepairConfig](~~ListVulAutoRepairConfig~~) operation to query the IDs.
        self.config_id_list = config_id_list
        # The type of the vulnerability. Valid values:
        # 
        # *   cve: Linux software vulnerability
        # *   sys: Windows system vulnerability
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.config_id_list is not None:
            result['ConfigIdList'] = self.config_id_list
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('ConfigIdList') is not None:
            self.config_id_list = m.get('ConfigIdList')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteVulAutoRepairConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVulAutoRepairConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteVulAutoRepairConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVulAutoRepairConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVulWhitelistRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        whitelist: str = None,
    ):
        # The ID of the whitelist.
        # 
        # >  To delete a vulnerability whitelist, you must provide the ID of the whitelist. You can call the [DescribeVulWhitelist](~~DescribeVulWhitelist~~) operation to query the IDs of whitelists.
        self.id = id
        # The information about the whitelist. The value is a JSON string that contains the following fields:
        # 
        # *   **Name**: the name of the vulnerability.
        # 
        # *   **Type**: the type of the vulnerability. Valid values:
        # 
        #     *   **cve**: Linux software vulnerability
        #     *   **sys**: Windows system vulnerability
        #     *   **cms**: Web-CMS vulnerability
        #     *   **app**: application vulnerability
        #     *   **emg**: urgent vulnerability
        # 
        # *   **AliasName**: the alias of the vulnerability.
        self.whitelist = whitelist

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.whitelist is not None:
            result['Whitelist'] = self.whitelist
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Whitelist') is not None:
            self.whitelist = m.get('Whitelist')
        return self


class DeleteVulWhitelistResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVulWhitelistResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteVulWhitelistResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVulWhitelistResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAIAssetSummaryResponseBodyDataSensitiveSummary(TeaModel):
    def __init__(
        self,
        container_image_cnt: int = None,
        ecs_cnt: int = None,
        image_cnt: int = None,
        snapshot_cnt: int = None,
        total_cnt: int = None,
    ):
        # The number of images that have AI-related keys are stored in plaintext detected by image scan.
        self.container_image_cnt = container_image_cnt
        # The number of servers that have AI-related keys are stored in plaintext detected by agentless scan.
        self.ecs_cnt = ecs_cnt
        # The number of images that have AI-related keys are stored in plaintext detected by agentless scan.
        self.image_cnt = image_cnt
        # The number of snapshots that have AI-related keys are stored in plaintext detected by agentless scan.
        self.snapshot_cnt = snapshot_cnt
        # The total number of assets that have AI-related keys are stored in plaintext.
        self.total_cnt = total_cnt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.container_image_cnt is not None:
            result['ContainerImageCnt'] = self.container_image_cnt
        if self.ecs_cnt is not None:
            result['EcsCnt'] = self.ecs_cnt
        if self.image_cnt is not None:
            result['ImageCnt'] = self.image_cnt
        if self.snapshot_cnt is not None:
            result['SnapshotCnt'] = self.snapshot_cnt
        if self.total_cnt is not None:
            result['TotalCnt'] = self.total_cnt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContainerImageCnt') is not None:
            self.container_image_cnt = m.get('ContainerImageCnt')
        if m.get('EcsCnt') is not None:
            self.ecs_cnt = m.get('EcsCnt')
        if m.get('ImageCnt') is not None:
            self.image_cnt = m.get('ImageCnt')
        if m.get('SnapshotCnt') is not None:
            self.snapshot_cnt = m.get('SnapshotCnt')
        if m.get('TotalCnt') is not None:
            self.total_cnt = m.get('TotalCnt')
        return self


class DescribeAIAssetSummaryResponseBodyData(TeaModel):
    def __init__(
        self,
        aispm_risk_asset_cnt: int = None,
        ecs_asset_cnt: int = None,
        exposed_risk_asset_cnt: int = None,
        image_asset_cnt: int = None,
        lingjun_asset_cnt: int = None,
        pai_container_cnt: int = None,
        pai_instance_cnt: int = None,
        pai_serverless_asset_cnt: int = None,
        sensitive_summary: DescribeAIAssetSummaryResponseBodyDataSensitiveSummary = None,
        snapshot_asset_cnt: int = None,
        total_asset_cnt: int = None,
        total_risk_cnt: int = None,
        vul_risk_asset_cnt: int = None,
    ):
        # The number of cloud assets with AI security posture management risks.
        self.aispm_risk_asset_cnt = aispm_risk_asset_cnt
        # The number of servers on which AI components are installed.
        self.ecs_asset_cnt = ecs_asset_cnt
        # The number of servers that have exposed AI components.
        self.exposed_risk_asset_cnt = exposed_risk_asset_cnt
        # The number of AI images.
        self.image_asset_cnt = image_asset_cnt
        # The number of LINGJUN assets.
        self.lingjun_asset_cnt = lingjun_asset_cnt
        # The number of container image assets in PAI.
        self.pai_container_cnt = pai_container_cnt
        # The total number of cloud asset instances in Platform for AI (PAI).
        self.pai_instance_cnt = pai_instance_cnt
        # The number of serverless assets in PAI.
        self.pai_serverless_asset_cnt = pai_serverless_asset_cnt
        # The statistics on assets that have AI-related keys are stored in plaintext.
        self.sensitive_summary = sensitive_summary
        # The number of AI snapshots.
        self.snapshot_asset_cnt = snapshot_asset_cnt
        # The total number of AI assets.
        self.total_asset_cnt = total_asset_cnt
        # The total number of assets with AI risks.
        self.total_risk_cnt = total_risk_cnt
        # The number of servers with AI application vulnerabilities.
        self.vul_risk_asset_cnt = vul_risk_asset_cnt

    def validate(self):
        if self.sensitive_summary:
            self.sensitive_summary.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aispm_risk_asset_cnt is not None:
            result['AispmRiskAssetCnt'] = self.aispm_risk_asset_cnt
        if self.ecs_asset_cnt is not None:
            result['EcsAssetCnt'] = self.ecs_asset_cnt
        if self.exposed_risk_asset_cnt is not None:
            result['ExposedRiskAssetCnt'] = self.exposed_risk_asset_cnt
        if self.image_asset_cnt is not None:
            result['ImageAssetCnt'] = self.image_asset_cnt
        if self.lingjun_asset_cnt is not None:
            result['LingjunAssetCnt'] = self.lingjun_asset_cnt
        if self.pai_container_cnt is not None:
            result['PaiContainerCnt'] = self.pai_container_cnt
        if self.pai_instance_cnt is not None:
            result['PaiInstanceCnt'] = self.pai_instance_cnt
        if self.pai_serverless_asset_cnt is not None:
            result['PaiServerlessAssetCnt'] = self.pai_serverless_asset_cnt
        if self.sensitive_summary is not None:
            result['SensitiveSummary'] = self.sensitive_summary.to_map()
        if self.snapshot_asset_cnt is not None:
            result['SnapshotAssetCnt'] = self.snapshot_asset_cnt
        if self.total_asset_cnt is not None:
            result['TotalAssetCnt'] = self.total_asset_cnt
        if self.total_risk_cnt is not None:
            result['TotalRiskCnt'] = self.total_risk_cnt
        if self.vul_risk_asset_cnt is not None:
            result['VulRiskAssetCnt'] = self.vul_risk_asset_cnt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AispmRiskAssetCnt') is not None:
            self.aispm_risk_asset_cnt = m.get('AispmRiskAssetCnt')
        if m.get('EcsAssetCnt') is not None:
            self.ecs_asset_cnt = m.get('EcsAssetCnt')
        if m.get('ExposedRiskAssetCnt') is not None:
            self.exposed_risk_asset_cnt = m.get('ExposedRiskAssetCnt')
        if m.get('ImageAssetCnt') is not None:
            self.image_asset_cnt = m.get('ImageAssetCnt')
        if m.get('LingjunAssetCnt') is not None:
            self.lingjun_asset_cnt = m.get('LingjunAssetCnt')
        if m.get('PaiContainerCnt') is not None:
            self.pai_container_cnt = m.get('PaiContainerCnt')
        if m.get('PaiInstanceCnt') is not None:
            self.pai_instance_cnt = m.get('PaiInstanceCnt')
        if m.get('PaiServerlessAssetCnt') is not None:
            self.pai_serverless_asset_cnt = m.get('PaiServerlessAssetCnt')
        if m.get('SensitiveSummary') is not None:
            temp_model = DescribeAIAssetSummaryResponseBodyDataSensitiveSummary()
            self.sensitive_summary = temp_model.from_map(m['SensitiveSummary'])
        if m.get('SnapshotAssetCnt') is not None:
            self.snapshot_asset_cnt = m.get('SnapshotAssetCnt')
        if m.get('TotalAssetCnt') is not None:
            self.total_asset_cnt = m.get('TotalAssetCnt')
        if m.get('TotalRiskCnt') is not None:
            self.total_risk_cnt = m.get('TotalRiskCnt')
        if m.get('VulRiskAssetCnt') is not None:
            self.vul_risk_asset_cnt = m.get('VulRiskAssetCnt')
        return self


class DescribeAIAssetSummaryResponseBody(TeaModel):
    def __init__(
        self,
        data: DescribeAIAssetSummaryResponseBodyData = None,
        request_id: str = None,
    ):
        # The returned data.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeAIAssetSummaryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAIAssetSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAIAssetSummaryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAIAssetSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccessKeyLeakDetailRequest(TeaModel):
    def __init__(
        self,
        id: int = None,
        resource_directory_account_id: int = None,
    ):
        # The ID of the AccessKey pair leak event.
        # 
        # > You can call the [DescribeAccesskeyLeakList](~~DescribeAccesskeyLeakList~~) operation to obtain the event ID.
        # 
        # This parameter is required.
        self.id = id
        # The Alibaba Cloud account ID of the member in the resource directory.
        # 
        # >  You can call the [DescribeMonitorAccounts](~~DescribeMonitorAccounts~~) operation to query the ID.
        self.resource_directory_account_id = resource_directory_account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.resource_directory_account_id is not None:
            result['ResourceDirectoryAccountId'] = self.resource_directory_account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ResourceDirectoryAccountId') is not None:
            self.resource_directory_account_id = m.get('ResourceDirectoryAccountId')
        return self


class DescribeAccessKeyLeakDetailResponseBody(TeaModel):
    def __init__(
        self,
        accesskey_id: str = None,
        asset: str = None,
        code: str = None,
        deal_time: str = None,
        deal_type: str = None,
        github_file_name: str = None,
        github_file_type: str = None,
        github_file_update_time: str = None,
        github_file_url: str = None,
        github_repo_name: str = None,
        github_repo_url: str = None,
        github_user: str = None,
        github_user_pic_url: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        remark: str = None,
        request_id: str = None,
        source: str = None,
        token_valid: int = None,
        type: str = None,
        whitelist_status: str = None,
        whitelist_time: int = None,
    ):
        # The ID of the AccessKey pair that is leaked.
        self.accesskey_id = accesskey_id
        # The platform to which the asset belongs. The value is fixed as **Cloud platform**.
        self.asset = asset
        # The code snippet that is leaked.
        self.code = code
        # The time when the AccessKey pair leak was handled.
        self.deal_time = deal_time
        # The solution to the AccessKey pair leak. Valid values:
        # 
        # *   **manual**: manually deleted
        # *   **disable**: manually disabled
        # *   **add-whitelist**: added to the whitelist
        # *   **pending**: unhandled
        self.deal_type = deal_type
        # The name of the GitHub file.
        self.github_file_name = github_file_name
        # The type of the GitHub file. Valid values:
        # 
        # *   Python
        # *   XML
        # *   GO
        # *   Javascript
        # *   INI
        # *   JSON
        # *   C++\
        self.github_file_type = github_file_type
        # The time when the GitHub file was updated.
        self.github_file_update_time = github_file_update_time
        # The URL of the GitHub file.
        self.github_file_url = github_file_url
        # The name of the GitHub repository.
        self.github_repo_name = github_repo_name
        # The URL of the GitHub repository.
        self.github_repo_url = github_repo_url
        # The username of the GitHub user.
        self.github_user = github_user
        # The URL of the profile picture for the GitHub user.
        self.github_user_pic_url = github_user_pic_url
        # The first time when the AccessKey pair leak was detected.
        self.gmt_create = gmt_create
        # The last time when the AccessKey pair leak was detected.
        self.gmt_modified = gmt_modified
        # The remarks of the AccessKey pair leak.
        self.remark = remark
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # The platform on which the AccessKey pair leak is detected.
        self.source = source
        # The validity of the key that is associated with the AccessKey pair. Valid values:
        # 
        # *   **0**: to be confirmed.
        # *   **1**: valid.
        # *   **2**: invalid.
        self.token_valid = token_valid
        # The type of the leak. The value is fixed as **AccessKey**.
        self.type = type
        # Indicates whether the AccessKey pair leak is added to the whitelist. Valid values:
        # 
        # *   **no**: no
        # *   **yes**: yes
        self.whitelist_status = whitelist_status
        # The time when the AccessKey pair was added to the whitelist. Unit: milliseconds.
        self.whitelist_time = whitelist_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accesskey_id is not None:
            result['AccesskeyId'] = self.accesskey_id
        if self.asset is not None:
            result['Asset'] = self.asset
        if self.code is not None:
            result['Code'] = self.code
        if self.deal_time is not None:
            result['DealTime'] = self.deal_time
        if self.deal_type is not None:
            result['DealType'] = self.deal_type
        if self.github_file_name is not None:
            result['GithubFileName'] = self.github_file_name
        if self.github_file_type is not None:
            result['GithubFileType'] = self.github_file_type
        if self.github_file_update_time is not None:
            result['GithubFileUpdateTime'] = self.github_file_update_time
        if self.github_file_url is not None:
            result['GithubFileUrl'] = self.github_file_url
        if self.github_repo_name is not None:
            result['GithubRepoName'] = self.github_repo_name
        if self.github_repo_url is not None:
            result['GithubRepoUrl'] = self.github_repo_url
        if self.github_user is not None:
            result['GithubUser'] = self.github_user
        if self.github_user_pic_url is not None:
            result['GithubUserPicUrl'] = self.github_user_pic_url
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.source is not None:
            result['Source'] = self.source
        if self.token_valid is not None:
            result['TokenValid'] = self.token_valid
        if self.type is not None:
            result['Type'] = self.type
        if self.whitelist_status is not None:
            result['WhitelistStatus'] = self.whitelist_status
        if self.whitelist_time is not None:
            result['WhitelistTime'] = self.whitelist_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccesskeyId') is not None:
            self.accesskey_id = m.get('AccesskeyId')
        if m.get('Asset') is not None:
            self.asset = m.get('Asset')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DealTime') is not None:
            self.deal_time = m.get('DealTime')
        if m.get('DealType') is not None:
            self.deal_type = m.get('DealType')
        if m.get('GithubFileName') is not None:
            self.github_file_name = m.get('GithubFileName')
        if m.get('GithubFileType') is not None:
            self.github_file_type = m.get('GithubFileType')
        if m.get('GithubFileUpdateTime') is not None:
            self.github_file_update_time = m.get('GithubFileUpdateTime')
        if m.get('GithubFileUrl') is not None:
            self.github_file_url = m.get('GithubFileUrl')
        if m.get('GithubRepoName') is not None:
            self.github_repo_name = m.get('GithubRepoName')
        if m.get('GithubRepoUrl') is not None:
            self.github_repo_url = m.get('GithubRepoUrl')
        if m.get('GithubUser') is not None:
            self.github_user = m.get('GithubUser')
        if m.get('GithubUserPicUrl') is not None:
            self.github_user_pic_url = m.get('GithubUserPicUrl')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('TokenValid') is not None:
            self.token_valid = m.get('TokenValid')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('WhitelistStatus') is not None:
            self.whitelist_status = m.get('WhitelistStatus')
        if m.get('WhitelistTime') is not None:
            self.whitelist_time = m.get('WhitelistTime')
        return self


class DescribeAccessKeyLeakDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAccessKeyLeakDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAccessKeyLeakDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccesskeyLeakListRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        query: str = None,
        resource_directory_account_id: int = None,
        start_ts: int = None,
        status: str = None,
    ):
        # The number of the page to return. Default value: **1**.
        # 
        # This parameter is required.
        self.current_page = current_page
        # The number of entries to return on each page.\\
        # Maximum value: 100. Default value: 20. If you leave this parameter empty, 20 entries are returned on each page.
        # 
        # > We recommend that you do not leave this parameter empty.
        # 
        # This parameter is required.
        self.page_size = page_size
        # The AccessKey ID that you want to query. Only exact match is supported.
        self.query = query
        # The Alibaba Cloud account ID of the member in the resource directory.
        # 
        # >  You can call the [DescribeMonitorAccounts](~~DescribeMonitorAccounts~~) operation to query the ID.
        self.resource_directory_account_id = resource_directory_account_id
        # The beginning of the time range to query. You can query all AccessKey pair leaks that are detected later than this time point. The value of this parameter is a UNIX timestamp. Unit: milliseconds.
        self.start_ts = start_ts
        # Specifies whether an AccessKey pair leak is handled. Valid values:
        # 
        # *   **pending**: unhandled
        # *   **dealed**: handled
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query is not None:
            result['Query'] = self.query
        if self.resource_directory_account_id is not None:
            result['ResourceDirectoryAccountId'] = self.resource_directory_account_id
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        if m.get('ResourceDirectoryAccountId') is not None:
            self.resource_directory_account_id = m.get('ResourceDirectoryAccountId')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeAccesskeyLeakListResponseBodyAccessKeyLeakList(TeaModel):
    def __init__(
        self,
        accesskey_id: str = None,
        ali_user_name: str = None,
        asset: str = None,
        deal_time: str = None,
        deal_type: str = None,
        gmt_modified: int = None,
        id: int = None,
        status: str = None,
        type: str = None,
        url: str = None,
        user_type: str = None,
    ):
        # The ID of the AccessKey pair that is leaked.
        self.accesskey_id = accesskey_id
        # The name of the Alibaba Cloud account that is affected.
        self.ali_user_name = ali_user_name
        # The platform to which the asset belongs. The value is fixed as **Cloud platform**.
        self.asset = asset
        # The time when the AccessKey pair leak is handled.
        self.deal_time = deal_time
        # The method to handle the AccessKey pair leak. Valid values:
        # 
        # *   **pending**: The AccessKey pair leak is unhandled.
        # *   **manual**: The AccessKey pair leak is manually handled.
        # *   **disable**: The AccessKey pair leak is disabled.
        # *   **add-whitelist**: The AccessKey pair leak is added to the whitelist.
        self.deal_type = deal_type
        # The time when the AccessKey pair leak is first detected. The value of this parameter is a UNIX timestamp. Unit: milliseconds.
        self.gmt_modified = gmt_modified
        # The primary key ID of the database.
        self.id = id
        # Indicates whether the AccessKey pair leak is handled. Valid values:
        # 
        # *   **pending**: unhandled
        # *   **dealed**: handled
        self.status = status
        # The type of the leak. The value is fixed as **AccessKey**.
        self.type = type
        # The URL of the platform on which the AccessKey pair leak is detected.
        self.url = url
        # The type of the account to which the leaked AccessKey pair belongs. Valid values:
        # 
        # *   **master**: Alibaba Cloud account
        # *   **ram**: RAM user
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accesskey_id is not None:
            result['AccesskeyId'] = self.accesskey_id
        if self.ali_user_name is not None:
            result['AliUserName'] = self.ali_user_name
        if self.asset is not None:
            result['Asset'] = self.asset
        if self.deal_time is not None:
            result['DealTime'] = self.deal_time
        if self.deal_type is not None:
            result['DealType'] = self.deal_type
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        if self.user_type is not None:
            result['UserType'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccesskeyId') is not None:
            self.accesskey_id = m.get('AccesskeyId')
        if m.get('AliUserName') is not None:
            self.ali_user_name = m.get('AliUserName')
        if m.get('Asset') is not None:
            self.asset = m.get('Asset')
        if m.get('DealTime') is not None:
            self.deal_time = m.get('DealTime')
        if m.get('DealType') is not None:
            self.deal_type = m.get('DealType')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')
        return self


class DescribeAccesskeyLeakListResponseBody(TeaModel):
    def __init__(
        self,
        access_key_leak_list: List[DescribeAccesskeyLeakListResponseBodyAccessKeyLeakList] = None,
        ak_leak_count: int = None,
        current_page: int = None,
        gmt_last: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # An array that consists of the details about AccessKey pair leaks.
        self.access_key_leak_list = access_key_leak_list
        # The number of AccessKey pair leaks that are unhandled.
        self.ak_leak_count = ak_leak_count
        # The page number of the returned page.
        self.current_page = current_page
        # This parameter is deprecated.
        self.gmt_last = gmt_last
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of AccessKey pair leaks.
        self.total_count = total_count

    def validate(self):
        if self.access_key_leak_list:
            for k in self.access_key_leak_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AccessKeyLeakList'] = []
        if self.access_key_leak_list is not None:
            for k in self.access_key_leak_list:
                result['AccessKeyLeakList'].append(k.to_map() if k else None)
        if self.ak_leak_count is not None:
            result['AkLeakCount'] = self.ak_leak_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.gmt_last is not None:
            result['GmtLast'] = self.gmt_last
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.access_key_leak_list = []
        if m.get('AccessKeyLeakList') is not None:
            for k in m.get('AccessKeyLeakList'):
                temp_model = DescribeAccesskeyLeakListResponseBodyAccessKeyLeakList()
                self.access_key_leak_list.append(temp_model.from_map(k))
        if m.get('AkLeakCount') is not None:
            self.ak_leak_count = m.get('AkLeakCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('GmtLast') is not None:
            self.gmt_last = m.get('GmtLast')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAccesskeyLeakListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAccesskeyLeakListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAccesskeyLeakListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAffectedAssetsRequest(TeaModel):
    def __init__(
        self,
        current: str = None,
        levels: str = None,
        page_size: str = None,
    ):
        # The number of the page to return.
        self.current = current
        # The severity. Separate multiple severities with commas (,). Valid values:
        # 
        # *   serious
        # *   suspicious
        # *   remind
        self.levels = levels
        # The number of entries to return on each page. Default value: 20. If you leave this parameter empty, 20 entries are returned on each page.
        # 
        # > We recommend that you do not leave this parameter empty.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current is not None:
            result['Current'] = self.current
        if self.levels is not None:
            result['Levels'] = self.levels
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Current') is not None:
            self.current = m.get('Current')
        if m.get('Levels') is not None:
            self.levels = m.get('Levels')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeAffectedAssetsResponseBodyAssetList(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        risk_num: int = None,
        uuid: str = None,
    ):
        # The ID of the server.
        self.instance_id = instance_id
        # The name of the server.
        self.instance_name = instance_name
        # The public IP address of the server.
        self.internet_ip = internet_ip
        # The private IP address of the server.
        self.intranet_ip = intranet_ip
        # The number of viruses detected on the server.
        self.risk_num = risk_num
        # The UUID of the server.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.risk_num is not None:
            result['RiskNum'] = self.risk_num
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('RiskNum') is not None:
            self.risk_num = m.get('RiskNum')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAffectedAssetsResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The number of entries returned on the current page.
        self.count = count
        # The page number of the returned page.
        self.current_page = current_page
        # The number of entries returned per page.
        self.page_size = page_size
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAffectedAssetsResponseBody(TeaModel):
    def __init__(
        self,
        asset_list: List[DescribeAffectedAssetsResponseBodyAssetList] = None,
        page_info: DescribeAffectedAssetsResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        # An array that consists of the affected servers.
        self.asset_list = asset_list
        # The pagination information.
        self.page_info = page_info
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.asset_list:
            for k in self.asset_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AssetList'] = []
        if self.asset_list is not None:
            for k in self.asset_list:
                result['AssetList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.asset_list = []
        if m.get('AssetList') is not None:
            for k in m.get('AssetList'):
                temp_model = DescribeAffectedAssetsResponseBodyAssetList()
                self.asset_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeAffectedAssetsResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAffectedAssetsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAffectedAssetsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAffectedAssetsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAffectedMaliciousFileImagesRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        cluster_name: str = None,
        container_id: str = None,
        current_page: int = None,
        image: str = None,
        image_digest: str = None,
        image_layer: str = None,
        image_tag: str = None,
        lang: str = None,
        levels: str = None,
        malicious_md_5: str = None,
        namespace: str = None,
        page_size: str = None,
        pod: str = None,
        repo_id: str = None,
        repo_instance_id: str = None,
        repo_name: str = None,
        repo_namespace: str = None,
        repo_region_id: str = None,
        scan_range: List[str] = None,
        status: str = None,
    ):
        # The ID of the container cluster.
        # 
        # >  You can call the [DescribeGroupedContainerInstances](~~DescribeGroupedContainerInstances~~) operation to query the IDs of container clusters.
        self.cluster_id = cluster_id
        # The name of the cluster.
        self.cluster_name = cluster_name
        # The ID of the container.
        self.container_id = container_id
        # The number of the page to return. Pages start from page **1**. Default value: **1**.
        # 
        # This parameter is required.
        self.current_page = current_page
        # The name of the container image.
        self.image = image
        # The image digest.
        self.image_digest = image_digest
        # The image layer.
        self.image_layer = image_layer
        # The tag that is added to the image.
        self.image_tag = image_tag
        # The language of the content within the request and the response. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The severity level of the malicious image sample. Separate multiple severity levels with commas (,). Valid values:
        # 
        # *   **serious**\
        # *   **suspicious**\
        # *   **remind**\
        self.levels = levels
        # The MD5 hash value of the malicious image sample.
        # 
        # >  You can call the [DescribeGroupedMaliciousFiles](~~DescribeGroupedMaliciousFiles~~) operation to query the MD5 hash values of malicious image samples.
        self.malicious_md_5 = malicious_md_5
        # The namespace.
        self.namespace = namespace
        # The number of entries to return on each page. Default value: **20**.
        # 
        # This parameter is required.
        self.page_size = page_size
        # The pod.
        self.pod = pod
        # The ID of the image repository.
        # 
        # >  You can call the [ListRepository](https://help.aliyun.com/document_detail/451339.html) operation to query the IDs of image repositories from the value of the **RepoId** response parameter.
        self.repo_id = repo_id
        # The ID of the container image.
        # 
        # >  You can call the [ListRepository](https://help.aliyun.com/document_detail/451339.html) operation to query the IDs of container images from the value of the **InstanceId** response parameter.
        self.repo_instance_id = repo_instance_id
        # The name of the image repository.
        # 
        # >  Fuzzy match is supported.
        self.repo_name = repo_name
        # The namespace to which the image repository belongs.
        # 
        # >  Fuzzy match is supported.
        self.repo_namespace = repo_namespace
        # The region ID of the image repository. Valid values:
        # 
        # *   **cn-beijing**: China (Beijing)
        # *   **cn-zhangjiakou**: China (Zhangjiakou)
        # *   **cn-hangzhou**: China (Hangzhou)
        # *   **cn-shanghai**: China (Shanghai)
        # *   **cn-shenzhen**: China (Shenzhen)
        # *   **cn-hongkong**: China (Hong Kong)
        # *   **ap-southeast-1**: Singapore
        # *   **ap-southeast-5**: Indonesia (Jakarta)
        # *   **us-east-1**: US (Virginia)
        # *   **us-west-1**: US (Silicon Valley)
        # *   **eu-central-1**: Germany (Frankfurt)
        # *   **eu-west-1**: UK (London)
        self.repo_region_id = repo_region_id
        # The types of the assets that you want to scan.
        self.scan_range = scan_range
        # The status of the malicious image sample. Valid values:
        # 
        # *   **0**: The malicious image sample is not handled.
        # *   **1**: The malicious image sample is handled.
        # *   **2**: The malicious image sample is being verified.
        # *   **3**: The malicious image sample is added to the whitelist.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.image is not None:
            result['Image'] = self.image
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.image_layer is not None:
            result['ImageLayer'] = self.image_layer
        if self.image_tag is not None:
            result['ImageTag'] = self.image_tag
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.levels is not None:
            result['Levels'] = self.levels
        if self.malicious_md_5 is not None:
            result['MaliciousMd5'] = self.malicious_md_5
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.pod is not None:
            result['Pod'] = self.pod
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        if self.scan_range is not None:
            result['ScanRange'] = self.scan_range
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('ImageLayer') is not None:
            self.image_layer = m.get('ImageLayer')
        if m.get('ImageTag') is not None:
            self.image_tag = m.get('ImageTag')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Levels') is not None:
            self.levels = m.get('Levels')
        if m.get('MaliciousMd5') is not None:
            self.malicious_md_5 = m.get('MaliciousMd5')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Pod') is not None:
            self.pod = m.get('Pod')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        if m.get('ScanRange') is not None:
            self.scan_range = m.get('ScanRange')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeAffectedMaliciousFileImagesResponseBodyAffectedMaliciousFileImagesResponse(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        cluster_name: str = None,
        container_id: str = None,
        digest: str = None,
        download_url: str = None,
        file_path: str = None,
        first_scan_timestamp: int = None,
        high_light: str = None,
        id: int = None,
        image: str = None,
        image_uuid: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        latest_scan_timestamp: int = None,
        latest_verify_timestamp: int = None,
        layer: str = None,
        level: str = None,
        malicious_md_5: str = None,
        namespace: str = None,
        pod: str = None,
        repo_id: str = None,
        repo_instance_id: str = None,
        repo_name: str = None,
        repo_region_id: str = None,
        status: int = None,
        tag: str = None,
        target_id: str = None,
        target_name: str = None,
        target_type: str = None,
        uuid: str = None,
    ):
        # The ID of the cluster.
        self.cluster_id = cluster_id
        # The name of the cluster.
        self.cluster_name = cluster_name
        # The ID of the container.
        self.container_id = container_id
        # The image digest.
        self.digest = digest
        # The URL to download the malicious image sample.
        self.download_url = download_url
        # The path to the image file.
        self.file_path = file_path
        # The timestamp of the first scan.
        self.first_scan_timestamp = first_scan_timestamp
        # The text that is highlighted.
        self.high_light = high_light
        # The ID of alert event.
        self.id = id
        # The name of the image.
        self.image = image
        # The UUID of the image.
        self.image_uuid = image_uuid
        # The name of the ECS instance.
        self.instance_name = instance_name
        # The public IP address of the server.
        self.internet_ip = internet_ip
        # The private IP address of the server.
        self.intranet_ip = intranet_ip
        # The timestamp of the last scan.
        self.latest_scan_timestamp = latest_scan_timestamp
        # The timestamp of the last verification.
        self.latest_verify_timestamp = latest_verify_timestamp
        # The image layer.
        self.layer = layer
        # The severity of the malicious image sample. Valid values:
        # 
        # *   **serious**\
        # *   **suspicious**\
        # *   **remind**\
        self.level = level
        # The MD5 hash value of the malicious image sample.
        self.malicious_md_5 = malicious_md_5
        # The namespace to which the image repository belongs.
        self.namespace = namespace
        # The pod.
        self.pod = pod
        # The ID of the image repository.
        self.repo_id = repo_id
        # The ID of the container image.
        self.repo_instance_id = repo_instance_id
        # The name of the image repository.
        self.repo_name = repo_name
        # The region ID of the image repository.
        self.repo_region_id = repo_region_id
        # The handling status of the malicious image sample. Valid values:
        # 
        # *   **0**: unhandled
        # *   **1**: handled
        # *   **2**: verifying
        # *   **3**: added to the whitelist
        self.status = status
        # The tag that is added to the image.
        self.tag = tag
        # The ID of the task object.
        self.target_id = target_id
        # The name of the task object.
        self.target_name = target_name
        # The object type. Valid value:
        # 
        # *   **ECS_IMAGE**\
        # *   **ECS_SNAPSHOT**\
        self.target_type = target_type
        # The UUID of the server.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.digest is not None:
            result['Digest'] = self.digest
        if self.download_url is not None:
            result['DownloadUrl'] = self.download_url
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.first_scan_timestamp is not None:
            result['FirstScanTimestamp'] = self.first_scan_timestamp
        if self.high_light is not None:
            result['HighLight'] = self.high_light
        if self.id is not None:
            result['Id'] = self.id
        if self.image is not None:
            result['Image'] = self.image
        if self.image_uuid is not None:
            result['ImageUuid'] = self.image_uuid
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.latest_scan_timestamp is not None:
            result['LatestScanTimestamp'] = self.latest_scan_timestamp
        if self.latest_verify_timestamp is not None:
            result['LatestVerifyTimestamp'] = self.latest_verify_timestamp
        if self.layer is not None:
            result['Layer'] = self.layer
        if self.level is not None:
            result['Level'] = self.level
        if self.malicious_md_5 is not None:
            result['MaliciousMd5'] = self.malicious_md_5
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.pod is not None:
            result['Pod'] = self.pod
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.target_id is not None:
            result['TargetId'] = self.target_id
        if self.target_name is not None:
            result['TargetName'] = self.target_name
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('Digest') is not None:
            self.digest = m.get('Digest')
        if m.get('DownloadUrl') is not None:
            self.download_url = m.get('DownloadUrl')
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('FirstScanTimestamp') is not None:
            self.first_scan_timestamp = m.get('FirstScanTimestamp')
        if m.get('HighLight') is not None:
            self.high_light = m.get('HighLight')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('ImageUuid') is not None:
            self.image_uuid = m.get('ImageUuid')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('LatestScanTimestamp') is not None:
            self.latest_scan_timestamp = m.get('LatestScanTimestamp')
        if m.get('LatestVerifyTimestamp') is not None:
            self.latest_verify_timestamp = m.get('LatestVerifyTimestamp')
        if m.get('Layer') is not None:
            self.layer = m.get('Layer')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MaliciousMd5') is not None:
            self.malicious_md_5 = m.get('MaliciousMd5')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Pod') is not None:
            self.pod = m.get('Pod')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('TargetId') is not None:
            self.target_id = m.get('TargetId')
        if m.get('TargetName') is not None:
            self.target_name = m.get('TargetName')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAffectedMaliciousFileImagesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The number of images that have malicious image samples returned on the current page.
        self.count = count
        # The page number of the returned page. Pages start from page **1**. Default value: **1**.
        self.current_page = current_page
        # The number of entries returned per page. Default value: **20**.
        self.page_size = page_size
        # The total number of images that have malicious image samples.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAffectedMaliciousFileImagesResponseBody(TeaModel):
    def __init__(
        self,
        affected_malicious_file_images_response: List[DescribeAffectedMaliciousFileImagesResponseBodyAffectedMaliciousFileImagesResponse] = None,
        page_info: DescribeAffectedMaliciousFileImagesResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        # An array consisting of the images that have malicious image samples.
        self.affected_malicious_file_images_response = affected_malicious_file_images_response
        # The pagination information.
        self.page_info = page_info
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.affected_malicious_file_images_response:
            for k in self.affected_malicious_file_images_response:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AffectedMaliciousFileImagesResponse'] = []
        if self.affected_malicious_file_images_response is not None:
            for k in self.affected_malicious_file_images_response:
                result['AffectedMaliciousFileImagesResponse'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.affected_malicious_file_images_response = []
        if m.get('AffectedMaliciousFileImagesResponse') is not None:
            for k in m.get('AffectedMaliciousFileImagesResponse'):
                temp_model = DescribeAffectedMaliciousFileImagesResponseBodyAffectedMaliciousFileImagesResponse()
                self.affected_malicious_file_images_response.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeAffectedMaliciousFileImagesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAffectedMaliciousFileImagesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAffectedMaliciousFileImagesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAffectedMaliciousFileImagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAgentInstallStatusRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        source_ip: str = None,
        uuids: str = None,
    ):
        # The language of the content within the request and response. Valid value:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The source IP address of the request.
        self.source_ip = source_ip
        # The UUIDs of servers. Separate multiple UUIDs with commas (,).
        # 
        # > You can call the [DescribeCloudCenterInstances](~~DescribeCloudCenterInstances~~) operation to query the UUIDs of servers.
        # 
        # This parameter is required.
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeAgentInstallStatusResponseBodyAegisClientInvokeStatusResponseList(TeaModel):
    def __init__(
        self,
        message: str = None,
        resule_code: str = None,
        result: int = None,
        uuid: str = None,
    ):
        # The returned message.
        self.message = message
        # The installation status. Valid value:
        # 
        # *   **-1**: The agent is not installed.
        # *   **0**: The agent is installed.
        # *   **1**: Failed to create a directory in the client.
        # *   **2**: Failed to download the installation package.
        # *   **3**: The installation file does not exist.
        # *   **4**: The verification information of the installation file does not exist.
        # *   **5**: Failed to verify the installation file.
        # *   **6**: Failed to execute the installation file.
        # *   **7**: You do not have the required permissions. The installation failed.
        # *   **8**: No client process is detected.
        # *   **100**: The installation failed due to an unknown error.
        # *   **1001**: The installation failed. One-click installation is not supported in this region.
        # *   **1002**: The installation failed. Servers that are not provided by Alibaba Cloud are not supported. Install the agent by executing a script on the server.
        # *   **1003**: The installation failed. The operating system is not supported.
        # *   **1004**: An internal error occurred. Try again later.
        # *   **1005**: The Elastic Compute Service (ECS) instance is not started. Start the ECS instance and try again.
        # *   **1006**: One-click installation is not supported for ECS instances of the classic network type.
        # *   **1007**: The running command is manually stopped.
        # *   **1008**: Cloud Assistant is not installed. You cannot install the client.
        # *   **1009**: The command execution timed out. Try again later.
        # *   **1010**: The machine is already online. You do not need to install a client.
        self.resule_code = resule_code
        # The installation result. Valid value:
        # 
        # *   **-1**: The agent is not installed.
        # *   **0**: The agent is being installed.
        # *   **1**: The agent is installed.
        # *   **2**: The installation failed.
        self.result = result
        # The UUID of the server.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.resule_code is not None:
            result['ResuleCode'] = self.resule_code
        if self.result is not None:
            result['Result'] = self.result
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ResuleCode') is not None:
            self.resule_code = m.get('ResuleCode')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAgentInstallStatusResponseBody(TeaModel):
    def __init__(
        self,
        aegis_client_invoke_status_response_list: List[DescribeAgentInstallStatusResponseBodyAegisClientInvokeStatusResponseList] = None,
        request_id: str = None,
    ):
        # The status of servers.
        self.aegis_client_invoke_status_response_list = aegis_client_invoke_status_response_list
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.aegis_client_invoke_status_response_list:
            for k in self.aegis_client_invoke_status_response_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AegisClientInvokeStatusResponseList'] = []
        if self.aegis_client_invoke_status_response_list is not None:
            for k in self.aegis_client_invoke_status_response_list:
                result['AegisClientInvokeStatusResponseList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.aegis_client_invoke_status_response_list = []
        if m.get('AegisClientInvokeStatusResponseList') is not None:
            for k in m.get('AegisClientInvokeStatusResponseList'):
                temp_model = DescribeAgentInstallStatusResponseBodyAegisClientInvokeStatusResponseList()
                self.aegis_client_invoke_status_response_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAgentInstallStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAgentInstallStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAgentInstallStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAgentlessSensitiveFileByKeyRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        image_uuid: str = None,
        instance_id: str = None,
        page_size: int = None,
        remark: str = None,
        scan_range: List[str] = None,
        sensitive_file_key: str = None,
        status: str = None,
    ):
        # The page number. Default value: **1**.
        self.current_page = current_page
        # The UUID of the asset that is scanned. You can query the UUID on the Host or Cloud Product page. If you scan a host, set this parameter to the UUID of the scanned host. If you scan a snapshot or a custom image, set this parameter to the ID of the scanned snapshot or image.
        self.image_uuid = image_uuid
        # The instance ID of the asset that is scanned. To query the instance ID, go to the Task Management page, click Details of a task, and then view the value of Check On.
        self.instance_id = instance_id
        # The number of entries per page. Default value: 20. If you leave this parameter empty, 20 entries are returned on each page.
        # 
        # >  We recommend that you do not leave this parameter empty.
        self.page_size = page_size
        # The name or IP address of the asset.
        self.remark = remark
        # The types of the assets that are scanned.
        self.scan_range = scan_range
        # The type of the sensitive file.
        self.sensitive_file_key = sensitive_file_key
        # The status of the baseline risk. Valid values:
        # 
        # *   **0**: unfixed.
        # *   **1**: fixed.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.image_uuid is not None:
            result['ImageUuid'] = self.image_uuid
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.scan_range is not None:
            result['ScanRange'] = self.scan_range
        if self.sensitive_file_key is not None:
            result['SensitiveFileKey'] = self.sensitive_file_key
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ImageUuid') is not None:
            self.image_uuid = m.get('ImageUuid')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('ScanRange') is not None:
            self.scan_range = m.get('ScanRange')
        if m.get('SensitiveFileKey') is not None:
            self.sensitive_file_key = m.get('SensitiveFileKey')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeAgentlessSensitiveFileByKeyShrinkRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        image_uuid: str = None,
        instance_id: str = None,
        page_size: int = None,
        remark: str = None,
        scan_range_shrink: str = None,
        sensitive_file_key: str = None,
        status: str = None,
    ):
        # The page number. Default value: **1**.
        self.current_page = current_page
        # The UUID of the asset that is scanned. You can query the UUID on the Host or Cloud Product page. If you scan a host, set this parameter to the UUID of the scanned host. If you scan a snapshot or a custom image, set this parameter to the ID of the scanned snapshot or image.
        self.image_uuid = image_uuid
        # The instance ID of the asset that is scanned. To query the instance ID, go to the Task Management page, click Details of a task, and then view the value of Check On.
        self.instance_id = instance_id
        # The number of entries per page. Default value: 20. If you leave this parameter empty, 20 entries are returned on each page.
        # 
        # >  We recommend that you do not leave this parameter empty.
        self.page_size = page_size
        # The name or IP address of the asset.
        self.remark = remark
        # The types of the assets that are scanned.
        self.scan_range_shrink = scan_range_shrink
        # The type of the sensitive file.
        self.sensitive_file_key = sensitive_file_key
        # The status of the baseline risk. Valid values:
        # 
        # *   **0**: unfixed.
        # *   **1**: fixed.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.image_uuid is not None:
            result['ImageUuid'] = self.image_uuid
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.scan_range_shrink is not None:
            result['ScanRange'] = self.scan_range_shrink
        if self.sensitive_file_key is not None:
            result['SensitiveFileKey'] = self.sensitive_file_key
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ImageUuid') is not None:
            self.image_uuid = m.get('ImageUuid')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('ScanRange') is not None:
            self.scan_range_shrink = m.get('ScanRange')
        if m.get('SensitiveFileKey') is not None:
            self.sensitive_file_key = m.get('SensitiveFileKey')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeAgentlessSensitiveFileByKeyResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The number of entries returned on the current page.
        self.count = count
        # The page number.
        self.current_page = current_page
        # The number of entries per page.
        self.page_size = page_size
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAgentlessSensitiveFileByKeyResponseBodySensitiveFileList(TeaModel):
    def __init__(
        self,
        file_path: str = None,
        first_scan_time: int = None,
        id: int = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        last_scan_time: int = None,
        md_5: str = None,
        prompt: str = None,
        risk_level: str = None,
        sensitive_file_key: str = None,
        status: int = None,
        target_name: str = None,
        uuid: str = None,
    ):
        # The path to the sensitive file.
        self.file_path = file_path
        # The timestamp when the first scan was performed. Unit: milliseconds.
        self.first_scan_time = first_scan_time
        # The ID of the alert for the sensitive file.
        self.id = id
        # The instance name of the asset.
        self.instance_name = instance_name
        # The public IP address of the asset.
        self.internet_ip = internet_ip
        # The private IP address of the asset.
        self.intranet_ip = intranet_ip
        # The timestamp when the last scan was performed. Unit: milliseconds.
        self.last_scan_time = last_scan_time
        # The MD5 hash value of the sensitive file.
        self.md_5 = md_5
        # The content of the sensitive file.
        self.prompt = prompt
        # The risk level. Valid values:
        # 
        # *   **high**\
        # *   **medium**\
        # *   **low**\
        self.risk_level = risk_level
        # The type of the sensitive file.
        self.sensitive_file_key = sensitive_file_key
        # The status of the sensitive file. Valid values:
        # 
        # *   **0**: unhandled.
        # *   **1**: ignored.
        # *   **2**: false positive.
        self.status = status
        # The name of the asset.
        self.target_name = target_name
        # The UUID of the asset.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.first_scan_time is not None:
            result['FirstScanTime'] = self.first_scan_time
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.last_scan_time is not None:
            result['LastScanTime'] = self.last_scan_time
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.prompt is not None:
            result['Prompt'] = self.prompt
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.sensitive_file_key is not None:
            result['SensitiveFileKey'] = self.sensitive_file_key
        if self.status is not None:
            result['Status'] = self.status
        if self.target_name is not None:
            result['TargetName'] = self.target_name
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('FirstScanTime') is not None:
            self.first_scan_time = m.get('FirstScanTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('LastScanTime') is not None:
            self.last_scan_time = m.get('LastScanTime')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('Prompt') is not None:
            self.prompt = m.get('Prompt')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('SensitiveFileKey') is not None:
            self.sensitive_file_key = m.get('SensitiveFileKey')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TargetName') is not None:
            self.target_name = m.get('TargetName')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAgentlessSensitiveFileByKeyResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribeAgentlessSensitiveFileByKeyResponseBodyPageInfo = None,
        request_id: str = None,
        sensitive_file_list: List[DescribeAgentlessSensitiveFileByKeyResponseBodySensitiveFileList] = None,
        success: bool = None,
    ):
        # The pagination information.
        self.page_info = page_info
        # The request ID.
        self.request_id = request_id
        # The information about the sensitive files that are detected by using the agentless detection feature.
        self.sensitive_file_list = sensitive_file_list
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.sensitive_file_list:
            for k in self.sensitive_file_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SensitiveFileList'] = []
        if self.sensitive_file_list is not None:
            for k in self.sensitive_file_list:
                result['SensitiveFileList'].append(k.to_map() if k else None)
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeAgentlessSensitiveFileByKeyResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.sensitive_file_list = []
        if m.get('SensitiveFileList') is not None:
            for k in m.get('SensitiveFileList'):
                temp_model = DescribeAgentlessSensitiveFileByKeyResponseBodySensitiveFileList()
                self.sensitive_file_list.append(temp_model.from_map(k))
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeAgentlessSensitiveFileByKeyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAgentlessSensitiveFileByKeyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAgentlessSensitiveFileByKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlarmEventDetailRequest(TeaModel):
    def __init__(
        self,
        alarm_unique_info: str = None,
        from_: str = None,
        lang: str = None,
        source_ip: str = None,
    ):
        # The unique identifier of the alert event.
        # 
        # > To query the details of an alert event, you must provide the unique identifier of the alert event. You can call the [DescribeSuspEvents](~~DescribeSuspEvents~~) operation to obtain the identifier.
        # 
        # This parameter is required.
        self.alarm_unique_info = alarm_unique_info
        # The ID of the request source. Set the value to **sas**.
        # 
        # This parameter is required.
        self.from_ = from_
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.from_ is not None:
            result['From'] = self.from_
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeAlarmEventDetailResponseBodyDataCauseDetailsValue(TeaModel):
    def __init__(
        self,
        name: str = None,
        type: str = None,
        value: str = None,
    ):
        # The name of the field that displays the tracing information.
        self.name = name
        # The type of the field that displays the tracing information. Valid values:
        # 
        # *   **text**\
        # *   **html**\
        self.type = type
        # The value of the field that displays the tracing information.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAlarmEventDetailResponseBodyDataCauseDetails(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: List[DescribeAlarmEventDetailResponseBodyDataCauseDetailsValue] = None,
    ):
        # The key that is used to trace the alert event.
        self.key = key
        # The value that is used to trace the alert event.
        self.value = value

    def validate(self):
        if self.value:
            for k in self.value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        result['Value'] = []
        if self.value is not None:
            for k in self.value:
                result['Value'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        self.value = []
        if m.get('Value') is not None:
            for k in m.get('Value'):
                temp_model = DescribeAlarmEventDetailResponseBodyDataCauseDetailsValue()
                self.value.append(temp_model.from_map(k))
        return self


class DescribeAlarmEventDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        alarm_event_alias_name: str = None,
        alarm_event_desc: str = None,
        alarm_unique_info: str = None,
        app_name: str = None,
        can_be_deal_on_line: bool = None,
        can_cancel_fault: bool = None,
        cause_details: List[DescribeAlarmEventDetailResponseBodyDataCauseDetails] = None,
        contain_hw_mode: bool = None,
        container_id: str = None,
        container_image_id: str = None,
        container_image_name: str = None,
        data_source: str = None,
        end_time: int = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        k_8s_cluster_id: str = None,
        k_8s_cluster_name: str = None,
        k_8s_namespace: str = None,
        k_8s_node_id: str = None,
        k_8s_node_name: str = None,
        k_8s_pod_name: str = None,
        level: str = None,
        solution: str = None,
        start_time: int = None,
        type: str = None,
        uuid: str = None,
    ):
        # The name of the alert event.
        self.alarm_event_alias_name = alarm_event_alias_name
        # The description of the alert event.
        self.alarm_event_desc = alarm_event_desc
        # The unique identifier of the alert event.
        # 
        # > To query the details of an alert event, you must provide the unique identifier of the alert event. You can call the [DescribeSuspEvents](~~DescribeSuspEvents~~) operation to obtain the identifier.
        self.alarm_unique_info = alarm_unique_info
        # The name of the container application.
        self.app_name = app_name
        # Indicates whether the online handling of the alert event is supported. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.can_be_deal_on_line = can_be_deal_on_line
        # Indicates whether you can cancel marking the alert event as a false positive. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.can_cancel_fault = can_cancel_fault
        # An array consisting of the cause of the alert event, which can be used to trace the alert event.
        self.cause_details = cause_details
        # Indicates whether the Safeguard Mode For Major Activities mode is enabled.
        self.contain_hw_mode = contain_hw_mode
        # The ID of the container application.
        self.container_id = container_id
        # The ID of the image to which the container belongs.
        self.container_image_id = container_image_id
        # The name of the image to which the container belongs.
        self.container_image_name = container_image_name
        # The data source of the alert event.
        self.data_source = data_source
        # The timestamp when the alert event ends. Unit: milliseconds.
        self.end_time = end_time
        # The name of the instance.
        self.instance_name = instance_name
        # The public IP address of the associated instance.
        self.internet_ip = internet_ip
        # The private IP address of the associated instance.
        self.intranet_ip = intranet_ip
        # The ID of the Kubernetes cluster.
        self.k_8s_cluster_id = k_8s_cluster_id
        # The name of the Kubernetes cluster.
        self.k_8s_cluster_name = k_8s_cluster_name
        # The namespace of the Kubernetes cluster.
        self.k_8s_namespace = k_8s_namespace
        # The ID of the Kubernetes cluster node.
        self.k_8s_node_id = k_8s_node_id
        # The name of the Kubernetes cluster node.
        self.k_8s_node_name = k_8s_node_name
        # The name of the Kubernetes pod.
        self.k_8s_pod_name = k_8s_pod_name
        # The severity of the alert event. Valid values:
        # 
        # *   **serious**\
        # *   **suspicious**\
        # *   **remind**\
        self.level = level
        # The solution to the alert event.
        self.solution = solution
        # The timestamp when the alert event starts. Unit: milliseconds.
        self.start_time = start_time
        # The alert type of the alert event. Valid values:
        # 
        # *   Suspicious process
        # *   Webshell
        # *   Unusual logon
        # *   Exception
        # *   Sensitive file tampering
        # *   Malicious process (cloud threat detection)
        # *   Suspicious network connection
        # *   Other
        # *   Abnormal account
        # *   Application intrusion event
        # *   Cloud threat detection
        # *   Precise defense
        # *   Application whitelist
        # *   Persistent webshell
        # *   Web application threat detection
        # *   Malicious script
        # *   Threat intelligence
        # *   Malicious network activity
        # *   Cluster exception
        # *   Webshell (on-premises threat detection)
        # *   Vulnerability exploitation
        # *   Malicious process (on-premises threat detection)
        # *   Trusted exception
        self.type = type
        # The instance UUID of the asset.
        self.uuid = uuid

    def validate(self):
        if self.cause_details:
            for k in self.cause_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_event_alias_name is not None:
            result['AlarmEventAliasName'] = self.alarm_event_alias_name
        if self.alarm_event_desc is not None:
            result['AlarmEventDesc'] = self.alarm_event_desc
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.can_be_deal_on_line is not None:
            result['CanBeDealOnLine'] = self.can_be_deal_on_line
        if self.can_cancel_fault is not None:
            result['CanCancelFault'] = self.can_cancel_fault
        result['CauseDetails'] = []
        if self.cause_details is not None:
            for k in self.cause_details:
                result['CauseDetails'].append(k.to_map() if k else None)
        if self.contain_hw_mode is not None:
            result['ContainHwMode'] = self.contain_hw_mode
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.container_image_id is not None:
            result['ContainerImageId'] = self.container_image_id
        if self.container_image_name is not None:
            result['ContainerImageName'] = self.container_image_name
        if self.data_source is not None:
            result['DataSource'] = self.data_source
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.k_8s_cluster_name is not None:
            result['K8sClusterName'] = self.k_8s_cluster_name
        if self.k_8s_namespace is not None:
            result['K8sNamespace'] = self.k_8s_namespace
        if self.k_8s_node_id is not None:
            result['K8sNodeId'] = self.k_8s_node_id
        if self.k_8s_node_name is not None:
            result['K8sNodeName'] = self.k_8s_node_name
        if self.k_8s_pod_name is not None:
            result['K8sPodName'] = self.k_8s_pod_name
        if self.level is not None:
            result['Level'] = self.level
        if self.solution is not None:
            result['Solution'] = self.solution
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmEventAliasName') is not None:
            self.alarm_event_alias_name = m.get('AlarmEventAliasName')
        if m.get('AlarmEventDesc') is not None:
            self.alarm_event_desc = m.get('AlarmEventDesc')
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CanBeDealOnLine') is not None:
            self.can_be_deal_on_line = m.get('CanBeDealOnLine')
        if m.get('CanCancelFault') is not None:
            self.can_cancel_fault = m.get('CanCancelFault')
        self.cause_details = []
        if m.get('CauseDetails') is not None:
            for k in m.get('CauseDetails'):
                temp_model = DescribeAlarmEventDetailResponseBodyDataCauseDetails()
                self.cause_details.append(temp_model.from_map(k))
        if m.get('ContainHwMode') is not None:
            self.contain_hw_mode = m.get('ContainHwMode')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('ContainerImageId') is not None:
            self.container_image_id = m.get('ContainerImageId')
        if m.get('ContainerImageName') is not None:
            self.container_image_name = m.get('ContainerImageName')
        if m.get('DataSource') is not None:
            self.data_source = m.get('DataSource')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('K8sClusterName') is not None:
            self.k_8s_cluster_name = m.get('K8sClusterName')
        if m.get('K8sNamespace') is not None:
            self.k_8s_namespace = m.get('K8sNamespace')
        if m.get('K8sNodeId') is not None:
            self.k_8s_node_id = m.get('K8sNodeId')
        if m.get('K8sNodeName') is not None:
            self.k_8s_node_name = m.get('K8sNodeName')
        if m.get('K8sPodName') is not None:
            self.k_8s_pod_name = m.get('K8sPodName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Solution') is not None:
            self.solution = m.get('Solution')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAlarmEventDetailResponseBody(TeaModel):
    def __init__(
        self,
        data: DescribeAlarmEventDetailResponseBodyData = None,
        request_id: str = None,
    ):
        # The details of the alert event.
        self.data = data
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeAlarmEventDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAlarmEventDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAlarmEventDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlarmEventDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlarmEventStackInfoRequest(TeaModel):
    def __init__(
        self,
        event_name: str = None,
        lang: str = None,
        resource_directory_account_id: int = None,
        source_ip: str = None,
        unique_info: str = None,
        uuid: str = None,
    ):
        # The name of the event.
        # 
        # >  You can call the [DescribeSuspEvents](~~DescribeSuspEvents~~) operation to query the names of events.
        # 
        # This parameter is required.
        self.event_name = event_name
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese.
        # *   **en**: English.
        self.lang = lang
        # The Alibaba Cloud account ID of the member in the resource directory.
        # 
        # >  You can call the [DescribeMonitorAccounts](~~DescribeMonitorAccounts~~) operation to obtain the IDs.
        self.resource_directory_account_id = resource_directory_account_id
        # The source IP address of the request.
        self.source_ip = source_ip
        # The ID of the alert event.
        # 
        # This parameter is required.
        self.unique_info = unique_info
        # The UUID of the server to query.
        # 
        # >  You can call the [DescribeSuspEvents](~~DescribeSuspEvents~~) operation to query the UUIDs of servers.
        # 
        # This parameter is required.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_directory_account_id is not None:
            result['ResourceDirectoryAccountId'] = self.resource_directory_account_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.unique_info is not None:
            result['UniqueInfo'] = self.unique_info
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceDirectoryAccountId') is not None:
            self.resource_directory_account_id = m.get('ResourceDirectoryAccountId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('UniqueInfo') is not None:
            self.unique_info = m.get('UniqueInfo')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAlarmEventStackInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        stack_info: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The stack information of the alert details.
        self.stack_info = stack_info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.stack_info is not None:
            result['StackInfo'] = self.stack_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StackInfo') is not None:
            self.stack_info = m.get('StackInfo')
        return self


class DescribeAlarmEventStackInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAlarmEventStackInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlarmEventStackInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAllEntityResponseBodyEntityList(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        ip: str = None,
        os: str = None,
        uuid: str = None,
    ):
        # The ID of the asset group.
        self.group_id = group_id
        # The name of the server.
        self.instance_name = instance_name
        # The public IP address of the server.
        self.internet_ip = internet_ip
        # The private IP address of the server.
        self.intranet_ip = intranet_ip
        # The IP address of the server.
        self.ip = ip
        # The operating system of the server. Valid values:
        # 
        # *   **linux**\
        # *   **windows**\
        self.os = os
        # The UUID of the server.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.os is not None:
            result['Os'] = self.os
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAllEntityResponseBody(TeaModel):
    def __init__(
        self,
        entity_list: List[DescribeAllEntityResponseBodyEntityList] = None,
        request_id: str = None,
    ):
        # An array that consists of servers.
        self.entity_list = entity_list
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.entity_list:
            for k in self.entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EntityList'] = []
        if self.entity_list is not None:
            for k in self.entity_list:
                result['EntityList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.entity_list = []
        if m.get('EntityList') is not None:
            for k in m.get('EntityList'):
                temp_model = DescribeAllEntityResponseBodyEntityList()
                self.entity_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAllEntityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAllEntityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAllEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAllGroupsRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        # The natural language of the request and response. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeAllGroupsResponseBodyGroups(TeaModel):
    def __init__(
        self,
        group_flag: int = None,
        group_id: int = None,
        group_name: str = None,
    ):
        # The type of the server group. Valid values:
        # 
        # *   **0**: default group
        # *   **1**: other groups
        self.group_flag = group_flag
        # The ID of the server group.
        self.group_id = group_id
        # The name of the server group.
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_flag is not None:
            result['GroupFlag'] = self.group_flag
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupFlag') is not None:
            self.group_flag = m.get('GroupFlag')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class DescribeAllGroupsResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        groups: List[DescribeAllGroupsResponseBodyGroups] = None,
        request_id: str = None,
    ):
        # The total number of server groups.
        self.count = count
        # The grouping information about the servers.
        self.groups = groups
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.groups:
            for k in self.groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        result['Groups'] = []
        if self.groups is not None:
            for k in self.groups:
                result['Groups'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.groups = []
        if m.get('Groups') is not None:
            for k in m.get('Groups'):
                temp_model = DescribeAllGroupsResponseBodyGroups()
                self.groups.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAllGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAllGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAllGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAllImageBaselineRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassListBaselineNameListBaselineItemList(TeaModel):
    def __init__(
        self,
        alias: str = None,
        class_key: str = None,
        item_key: str = None,
        name_key: str = None,
    ):
        # The alias of the baseline check item.
        self.alias = alias
        # The key of the type for the baseline.
        self.class_key = class_key
        # The key of the name for the baseline check item.
        self.item_key = item_key
        # The key of the name for the baseline.
        self.name_key = name_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.class_key is not None:
            result['ClassKey'] = self.class_key
        if self.item_key is not None:
            result['ItemKey'] = self.item_key
        if self.name_key is not None:
            result['NameKey'] = self.name_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('ClassKey') is not None:
            self.class_key = m.get('ClassKey')
        if m.get('ItemKey') is not None:
            self.item_key = m.get('ItemKey')
        if m.get('NameKey') is not None:
            self.name_key = m.get('NameKey')
        return self


class DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassListBaselineNameList(TeaModel):
    def __init__(
        self,
        alias: str = None,
        baseline_item_list: List[DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassListBaselineNameListBaselineItemList] = None,
        class_key: str = None,
        name_key: str = None,
    ):
        # The alias of the baseline.
        self.alias = alias
        # The information about the baseline check item.
        self.baseline_item_list = baseline_item_list
        # The key of the type for the baseline.
        self.class_key = class_key
        # The key of the name for the baseline.
        self.name_key = name_key

    def validate(self):
        if self.baseline_item_list:
            for k in self.baseline_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        result['BaselineItemList'] = []
        if self.baseline_item_list is not None:
            for k in self.baseline_item_list:
                result['BaselineItemList'].append(k.to_map() if k else None)
        if self.class_key is not None:
            result['ClassKey'] = self.class_key
        if self.name_key is not None:
            result['NameKey'] = self.name_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        self.baseline_item_list = []
        if m.get('BaselineItemList') is not None:
            for k in m.get('BaselineItemList'):
                temp_model = DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassListBaselineNameListBaselineItemList()
                self.baseline_item_list.append(temp_model.from_map(k))
        if m.get('ClassKey') is not None:
            self.class_key = m.get('ClassKey')
        if m.get('NameKey') is not None:
            self.name_key = m.get('NameKey')
        return self


class DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassList(TeaModel):
    def __init__(
        self,
        alias: str = None,
        baseline_name_list: List[DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassListBaselineNameList] = None,
        class_key: str = None,
    ):
        # The alias of the baseline type.
        self.alias = alias
        # The information about the baseline.
        self.baseline_name_list = baseline_name_list
        # The key of the baseline type.
        self.class_key = class_key

    def validate(self):
        if self.baseline_name_list:
            for k in self.baseline_name_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        result['BaselineNameList'] = []
        if self.baseline_name_list is not None:
            for k in self.baseline_name_list:
                result['BaselineNameList'].append(k.to_map() if k else None)
        if self.class_key is not None:
            result['ClassKey'] = self.class_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        self.baseline_name_list = []
        if m.get('BaselineNameList') is not None:
            for k in m.get('BaselineNameList'):
                temp_model = DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassListBaselineNameList()
                self.baseline_name_list.append(temp_model.from_map(k))
        if m.get('ClassKey') is not None:
            self.class_key = m.get('ClassKey')
        return self


class DescribeAllImageBaselineResponseBodyImageBaselines(TeaModel):
    def __init__(
        self,
        baseline_class_list: List[DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassList] = None,
    ):
        # An array that consists of baseline types.
        self.baseline_class_list = baseline_class_list

    def validate(self):
        if self.baseline_class_list:
            for k in self.baseline_class_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BaselineClassList'] = []
        if self.baseline_class_list is not None:
            for k in self.baseline_class_list:
                result['BaselineClassList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.baseline_class_list = []
        if m.get('BaselineClassList') is not None:
            for k in m.get('BaselineClassList'):
                temp_model = DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassList()
                self.baseline_class_list.append(temp_model.from_map(k))
        return self


class DescribeAllImageBaselineResponseBody(TeaModel):
    def __init__(
        self,
        image_baselines: DescribeAllImageBaselineResponseBodyImageBaselines = None,
        request_id: str = None,
    ):
        # The baselines that are used in image baseline checks.
        self.image_baselines = image_baselines
        # The ID of the request, which is used to query logs and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.image_baselines:
            self.image_baselines.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_baselines is not None:
            result['ImageBaselines'] = self.image_baselines.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageBaselines') is not None:
            temp_model = DescribeAllImageBaselineResponseBodyImageBaselines()
            self.image_baselines = temp_model.from_map(m['ImageBaselines'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAllImageBaselineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAllImageBaselineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAllImageBaselineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAllRegionsStatisticsRequest(TeaModel):
    def __init__(
        self,
        from_: str = None,
        group_id: int = None,
        remark: str = None,
        source_ip: str = None,
    ):
        # The source of the request. Default value: **aqs**. Valid values:
        # 
        # *   **sas**: Security Center.
        # *   **aqs**: Server Guard.
        self.from_ = from_
        # The ID of the asset group that you want to query.
        # 
        # >  You can call the [DescribeAllGroups](https://help.aliyun.com/document_detail/130972.html) operation to query the ID.
        self.group_id = group_id
        # The name or public IP address of the asset.
        self.remark = remark
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_ is not None:
            result['From'] = self.from_
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeAllRegionsStatisticsResponseBodyData(TeaModel):
    def __init__(
        self,
        account: int = None,
        health: int = None,
        new_suspicious: int = None,
        suspicious: int = None,
        trojan: int = None,
        vul: int = None,
    ):
        # The number of logons to the asset.
        self.account = account
        # The total number of unfixed baseline risks.
        self.health = health
        # The number of alerts that are generated by Server Guard or Security Center.
        # 
        # > 
        # 
        # *   If **From** is set to **sas**, this parameter indicates the number of alerts that are generated by Security Center.
        # 
        # *   If **From** is set to **aqs**, this parameter indicates the number of alerts that are generated by Server Guard.
        self.new_suspicious = new_suspicious
        # The number of alerts that are generated by Server Guard.
        self.suspicious = suspicious
        # The number of webshell alerts.
        self.trojan = trojan
        # The number of unfixed vulnerabilities.
        self.vul = vul

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account is not None:
            result['Account'] = self.account
        if self.health is not None:
            result['Health'] = self.health
        if self.new_suspicious is not None:
            result['NewSuspicious'] = self.new_suspicious
        if self.suspicious is not None:
            result['Suspicious'] = self.suspicious
        if self.trojan is not None:
            result['Trojan'] = self.trojan
        if self.vul is not None:
            result['Vul'] = self.vul
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Account') is not None:
            self.account = m.get('Account')
        if m.get('Health') is not None:
            self.health = m.get('Health')
        if m.get('NewSuspicious') is not None:
            self.new_suspicious = m.get('NewSuspicious')
        if m.get('Suspicious') is not None:
            self.suspicious = m.get('Suspicious')
        if m.get('Trojan') is not None:
            self.trojan = m.get('Trojan')
        if m.get('Vul') is not None:
            self.vul = m.get('Vul')
        return self


class DescribeAllRegionsStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        data: DescribeAllRegionsStatisticsResponseBodyData = None,
        request_id: str = None,
    ):
        # The data returned.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeAllRegionsStatisticsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAllRegionsStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAllRegionsStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAllRegionsStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAntiBruteForceRulesRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        id: int = None,
        name: str = None,
        page_size: str = None,
        resource_owner_id: int = None,
        source_ip: str = None,
    ):
        # The number of the page to return. Default value: **1**.
        self.current_page = current_page
        # The ID of the defense rule.
        # > You can call the [DescribeAntiBruteForceRules](~~DescribeAntiBruteForceRules~~) operation to query the IDs of defense rules.
        self.id = id
        # The name of the rule.
        self.name = name
        # The number of entries to return on each page.
        self.page_size = page_size
        self.resource_owner_id = resource_owner_id
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        