# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from typing import Dict
from Tea.core import TeaCore

from alibabacloud_tea_openapi.client import Client as OpenApiClient
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_tea_util.client import Client as UtilClient
from alibabacloud_endpoint_util.client import Client as EndpointUtilClient
from alibabacloud_sas20181203 import models as sas_20181203_models
from alibabacloud_tea_util import models as util_models
from alibabacloud_openapi_util.client import Client as OpenApiUtilClient


class Client(OpenApiClient):
    """
    *\
    """
    def __init__(
        self, 
        config: open_api_models.Config,
    ):
        super().__init__(config)
        self._endpoint_rule = 'regional'
        self._endpoint_map = {
            'cn-qingdao': 'tds.cn-shanghai.aliyuncs.com',
            'cn-beijing': 'tds.cn-shanghai.aliyuncs.com',
            'cn-zhangjiakou': 'tds.cn-shanghai.aliyuncs.com',
            'cn-huhehaote': 'tds.cn-shanghai.aliyuncs.com',
            'cn-wulanchabu': 'tds.cn-shanghai.aliyuncs.com',
            'cn-hangzhou': 'tds.cn-shanghai.aliyuncs.com',
            'cn-shanghai': 'tds.cn-shanghai.aliyuncs.com',
            'cn-nanjing': 'tds.cn-shanghai.aliyuncs.com',
            'cn-fuzhou': 'tds.cn-shanghai.aliyuncs.com',
            'cn-shenzhen': 'tds.cn-shanghai.aliyuncs.com',
            'cn-heyuan': 'tds.cn-shanghai.aliyuncs.com',
            'cn-guangzhou': 'tds.cn-shanghai.aliyuncs.com',
            'ap-southeast-2': 'tds.ap-southeast-1.aliyuncs.com',
            'ap-southeast-6': 'tds.ap-southeast-1.aliyuncs.com',
            'ap-northeast-2': 'tds.ap-southeast-1.aliyuncs.com',
            'ap-southeast-3': 'tds.ap-southeast-1.aliyuncs.com',
            'ap-northeast-1': 'tds.ap-southeast-1.aliyuncs.com',
            'ap-southeast-7': 'tds.ap-southeast-1.aliyuncs.com',
            'cn-chengdu': 'tds.cn-shanghai.aliyuncs.com',
            'ap-southeast-1': 'tds.ap-southeast-1.aliyuncs.com',
            'ap-southeast-5': 'tds.ap-southeast-1.aliyuncs.com',
            'cn-hongkong': 'tds.cn-shanghai.aliyuncs.com',
            'eu-central-1': 'tds.ap-southeast-1.aliyuncs.com',
            'us-east-1': 'tds.ap-southeast-1.aliyuncs.com',
            'us-west-1': 'tds.ap-southeast-1.aliyuncs.com',
            'eu-west-1': 'tds.ap-southeast-1.aliyuncs.com',
            'me-east-1': 'tds.ap-southeast-1.aliyuncs.com',
            'me-central-1': 'tds.ap-southeast-1.aliyuncs.com',
            'ap-south-1': 'tds.ap-southeast-1.aliyuncs.com',
            'cn-beijing-finance-1': 'tds.cn-shanghai.aliyuncs.com',
            'cn-hangzhou-finance': 'tds.cn-shanghai.aliyuncs.com',
            'cn-shanghai-finance-1': 'tds.cn-shanghai.aliyuncs.com',
            'cn-shenzhen-finance-1': 'tds.cn-shanghai.aliyuncs.com',
            'cn-heyuan-acdr-1': 'tds.cn-shanghai.aliyuncs.com',
            'cn-north-2-gov-1': 'tds.cn-shanghai.aliyuncs.com',
            'cn-qingdao-acdr-ut-1': 'tds.cn-shanghai.aliyuncs.com',
            'cn-shanghai-mybk': 'tds.cn-shanghai.aliyuncs.com',
            'cn-wuhan-lr': 'tds.cn-shanghai.aliyuncs.com',
            'cn-zhengzhou-jva': 'tds.cn-shanghai.aliyuncs.com'
        }
        self.check_config(config)
        self._endpoint = self.get_endpoint('sas', self._region_id, self._endpoint_rule, self._network, self._suffix, self._endpoint_map, self._endpoint)

    def get_endpoint(
        self,
        product_id: str,
        region_id: str,
        endpoint_rule: str,
        network: str,
        suffix: str,
        endpoint_map: Dict[str, str],
        endpoint: str,
    ) -> str:
        if not UtilClient.empty(endpoint):
            return endpoint
        if not UtilClient.is_unset(endpoint_map) and not UtilClient.empty(endpoint_map.get(region_id)):
            return endpoint_map.get(region_id)
        return EndpointUtilClient.get_endpoint_rules(product_id, region_id, endpoint_rule, network, suffix)

    def add_asset_selection_criteria_with_options(
        self,
        request: sas_20181203_models.AddAssetSelectionCriteriaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddAssetSelectionCriteriaResponse:
        """
        @summary Select an operation for assets.
        
        @param request: AddAssetSelectionCriteriaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddAssetSelectionCriteriaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.criteria_operation):
            query['CriteriaOperation'] = request.criteria_operation
        if not UtilClient.is_unset(request.selection_key):
            query['SelectionKey'] = request.selection_key
        if not UtilClient.is_unset(request.target_operation_list):
            query['TargetOperationList'] = request.target_operation_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddAssetSelectionCriteria',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddAssetSelectionCriteriaResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_asset_selection_criteria_with_options_async(
        self,
        request: sas_20181203_models.AddAssetSelectionCriteriaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddAssetSelectionCriteriaResponse:
        """
        @summary Select an operation for assets.
        
        @param request: AddAssetSelectionCriteriaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddAssetSelectionCriteriaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.criteria_operation):
            query['CriteriaOperation'] = request.criteria_operation
        if not UtilClient.is_unset(request.selection_key):
            query['SelectionKey'] = request.selection_key
        if not UtilClient.is_unset(request.target_operation_list):
            query['TargetOperationList'] = request.target_operation_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddAssetSelectionCriteria',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddAssetSelectionCriteriaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_asset_selection_criteria(
        self,
        request: sas_20181203_models.AddAssetSelectionCriteriaRequest,
    ) -> sas_20181203_models.AddAssetSelectionCriteriaResponse:
        """
        @summary Select an operation for assets.
        
        @param request: AddAssetSelectionCriteriaRequest
        @return: AddAssetSelectionCriteriaResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_asset_selection_criteria_with_options(request, runtime)

    async def add_asset_selection_criteria_async(
        self,
        request: sas_20181203_models.AddAssetSelectionCriteriaRequest,
    ) -> sas_20181203_models.AddAssetSelectionCriteriaResponse:
        """
        @summary Select an operation for assets.
        
        @param request: AddAssetSelectionCriteriaRequest
        @return: AddAssetSelectionCriteriaResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_asset_selection_criteria_with_options_async(request, runtime)

    def add_baseline_check_white_record_with_options(
        self,
        request: sas_20181203_models.AddBaselineCheckWhiteRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddBaselineCheckWhiteRecordResponse:
        """
        @summary Creates a whitelist rule for a baseline check item.
        
        @param request: AddBaselineCheckWhiteRecordRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddBaselineCheckWhiteRecordResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_id):
            query['CheckId'] = request.check_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.reason):
            query['Reason'] = request.reason
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddBaselineCheckWhiteRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddBaselineCheckWhiteRecordResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_baseline_check_white_record_with_options_async(
        self,
        request: sas_20181203_models.AddBaselineCheckWhiteRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddBaselineCheckWhiteRecordResponse:
        """
        @summary Creates a whitelist rule for a baseline check item.
        
        @param request: AddBaselineCheckWhiteRecordRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddBaselineCheckWhiteRecordResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_id):
            query['CheckId'] = request.check_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.reason):
            query['Reason'] = request.reason
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddBaselineCheckWhiteRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddBaselineCheckWhiteRecordResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_baseline_check_white_record(
        self,
        request: sas_20181203_models.AddBaselineCheckWhiteRecordRequest,
    ) -> sas_20181203_models.AddBaselineCheckWhiteRecordResponse:
        """
        @summary Creates a whitelist rule for a baseline check item.
        
        @param request: AddBaselineCheckWhiteRecordRequest
        @return: AddBaselineCheckWhiteRecordResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_baseline_check_white_record_with_options(request, runtime)

    async def add_baseline_check_white_record_async(
        self,
        request: sas_20181203_models.AddBaselineCheckWhiteRecordRequest,
    ) -> sas_20181203_models.AddBaselineCheckWhiteRecordResponse:
        """
        @summary Creates a whitelist rule for a baseline check item.
        
        @param request: AddBaselineCheckWhiteRecordRequest
        @return: AddBaselineCheckWhiteRecordResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_baseline_check_white_record_with_options_async(request, runtime)

    def add_check_instance_result_white_list_with_options(
        self,
        request: sas_20181203_models.AddCheckInstanceResultWhiteListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddCheckInstanceResultWhiteListResponse:
        """
        @summary Adds instances on which risks are detected based on check items of the configuration assessment feature to a whitelist.
        
        @param request: AddCheckInstanceResultWhiteListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCheckInstanceResultWhiteListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_group_id):
            query['CheckGroupId'] = request.check_group_id
        if not UtilClient.is_unset(request.check_id):
            query['CheckId'] = request.check_id
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.instance_list):
            query['InstanceList'] = request.instance_list
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.rule_type):
            query['RuleType'] = request.rule_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCheckInstanceResultWhiteList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddCheckInstanceResultWhiteListResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_check_instance_result_white_list_with_options_async(
        self,
        request: sas_20181203_models.AddCheckInstanceResultWhiteListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddCheckInstanceResultWhiteListResponse:
        """
        @summary Adds instances on which risks are detected based on check items of the configuration assessment feature to a whitelist.
        
        @param request: AddCheckInstanceResultWhiteListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCheckInstanceResultWhiteListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_group_id):
            query['CheckGroupId'] = request.check_group_id
        if not UtilClient.is_unset(request.check_id):
            query['CheckId'] = request.check_id
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.instance_list):
            query['InstanceList'] = request.instance_list
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.rule_type):
            query['RuleType'] = request.rule_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCheckInstanceResultWhiteList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddCheckInstanceResultWhiteListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_check_instance_result_white_list(
        self,
        request: sas_20181203_models.AddCheckInstanceResultWhiteListRequest,
    ) -> sas_20181203_models.AddCheckInstanceResultWhiteListResponse:
        """
        @summary Adds instances on which risks are detected based on check items of the configuration assessment feature to a whitelist.
        
        @param request: AddCheckInstanceResultWhiteListRequest
        @return: AddCheckInstanceResultWhiteListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_check_instance_result_white_list_with_options(request, runtime)

    async def add_check_instance_result_white_list_async(
        self,
        request: sas_20181203_models.AddCheckInstanceResultWhiteListRequest,
    ) -> sas_20181203_models.AddCheckInstanceResultWhiteListResponse:
        """
        @summary Adds instances on which risks are detected based on check items of the configuration assessment feature to a whitelist.
        
        @param request: AddCheckInstanceResultWhiteListRequest
        @return: AddCheckInstanceResultWhiteListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_check_instance_result_white_list_with_options_async(request, runtime)

    def add_check_result_white_list_with_options(
        self,
        request: sas_20181203_models.AddCheckResultWhiteListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddCheckResultWhiteListResponse:
        """
        @summary Adds the check items of the configuration assessment feature to the whitelist.
        
        @param request: AddCheckResultWhiteListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCheckResultWhiteListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_ids):
            query['CheckIds'] = request.check_ids
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.rule_type):
            query['RuleType'] = request.rule_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCheckResultWhiteList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddCheckResultWhiteListResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_check_result_white_list_with_options_async(
        self,
        request: sas_20181203_models.AddCheckResultWhiteListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddCheckResultWhiteListResponse:
        """
        @summary Adds the check items of the configuration assessment feature to the whitelist.
        
        @param request: AddCheckResultWhiteListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCheckResultWhiteListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_ids):
            query['CheckIds'] = request.check_ids
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.rule_type):
            query['RuleType'] = request.rule_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCheckResultWhiteList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddCheckResultWhiteListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_check_result_white_list(
        self,
        request: sas_20181203_models.AddCheckResultWhiteListRequest,
    ) -> sas_20181203_models.AddCheckResultWhiteListResponse:
        """
        @summary Adds the check items of the configuration assessment feature to the whitelist.
        
        @param request: AddCheckResultWhiteListRequest
        @return: AddCheckResultWhiteListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_check_result_white_list_with_options(request, runtime)

    async def add_check_result_white_list_async(
        self,
        request: sas_20181203_models.AddCheckResultWhiteListRequest,
    ) -> sas_20181203_models.AddCheckResultWhiteListResponse:
        """
        @summary Adds the check items of the configuration assessment feature to the whitelist.
        
        @param request: AddCheckResultWhiteListRequest
        @return: AddCheckResultWhiteListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_check_result_white_list_with_options_async(request, runtime)

    def add_client_user_define_rule_with_options(
        self,
        request: sas_20181203_models.AddClientUserDefineRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddClientUserDefineRuleResponse:
        """
        @summary Creates a custom defense rule.
        
        @param request: AddClientUserDefineRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddClientUserDefineRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.action_type):
            query['ActionType'] = request.action_type
        if not UtilClient.is_unset(request.cmdline):
            query['Cmdline'] = request.cmdline
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.file_path):
            query['FilePath'] = request.file_path
        if not UtilClient.is_unset(request.ip):
            query['IP'] = request.ip
        if not UtilClient.is_unset(request.md_5list):
            query['Md5List'] = request.md_5list
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.new_file_path):
            query['NewFilePath'] = request.new_file_path
        if not UtilClient.is_unset(request.parent_cmdline):
            query['ParentCmdline'] = request.parent_cmdline
        if not UtilClient.is_unset(request.parent_proc_path):
            query['ParentProcPath'] = request.parent_proc_path
        if not UtilClient.is_unset(request.platform):
            query['Platform'] = request.platform
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.port_str):
            query['PortStr'] = request.port_str
        if not UtilClient.is_unset(request.proc_path):
            query['ProcPath'] = request.proc_path
        if not UtilClient.is_unset(request.registry_content):
            query['RegistryContent'] = request.registry_content
        if not UtilClient.is_unset(request.registry_key):
            query['RegistryKey'] = request.registry_key
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddClientUserDefineRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddClientUserDefineRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_client_user_define_rule_with_options_async(
        self,
        request: sas_20181203_models.AddClientUserDefineRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddClientUserDefineRuleResponse:
        """
        @summary Creates a custom defense rule.
        
        @param request: AddClientUserDefineRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddClientUserDefineRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.action_type):
            query['ActionType'] = request.action_type
        if not UtilClient.is_unset(request.cmdline):
            query['Cmdline'] = request.cmdline
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.file_path):
            query['FilePath'] = request.file_path
        if not UtilClient.is_unset(request.ip):
            query['IP'] = request.ip
        if not UtilClient.is_unset(request.md_5list):
            query['Md5List'] = request.md_5list
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.new_file_path):
            query['NewFilePath'] = request.new_file_path
        if not UtilClient.is_unset(request.parent_cmdline):
            query['ParentCmdline'] = request.parent_cmdline
        if not UtilClient.is_unset(request.parent_proc_path):
            query['ParentProcPath'] = request.parent_proc_path
        if not UtilClient.is_unset(request.platform):
            query['Platform'] = request.platform
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.port_str):
            query['PortStr'] = request.port_str
        if not UtilClient.is_unset(request.proc_path):
            query['ProcPath'] = request.proc_path
        if not UtilClient.is_unset(request.registry_content):
            query['RegistryContent'] = request.registry_content
        if not UtilClient.is_unset(request.registry_key):
            query['RegistryKey'] = request.registry_key
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddClientUserDefineRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddClientUserDefineRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_client_user_define_rule(
        self,
        request: sas_20181203_models.AddClientUserDefineRuleRequest,
    ) -> sas_20181203_models.AddClientUserDefineRuleResponse:
        """
        @summary Creates a custom defense rule.
        
        @param request: AddClientUserDefineRuleRequest
        @return: AddClientUserDefineRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_client_user_define_rule_with_options(request, runtime)

    async def add_client_user_define_rule_async(
        self,
        request: sas_20181203_models.AddClientUserDefineRuleRequest,
    ) -> sas_20181203_models.AddClientUserDefineRuleResponse:
        """
        @summary Creates a custom defense rule.
        
        @param request: AddClientUserDefineRuleRequest
        @return: AddClientUserDefineRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_client_user_define_rule_with_options_async(request, runtime)

    def add_cloud_vendor_account_akwith_options(
        self,
        request: sas_20181203_models.AddCloudVendorAccountAKRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddCloudVendorAccountAKResponse:
        """
        @summary Adds the configuration information of multi-cloud assets.
        
        @param request: AddCloudVendorAccountAKRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCloudVendorAccountAKResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ak_type):
            query['AkType'] = request.ak_type
        if not UtilClient.is_unset(request.auth_modules):
            query['AuthModules'] = request.auth_modules
        if not UtilClient.is_unset(request.ctdr_cloud_user_id):
            query['CtdrCloudUserId'] = request.ctdr_cloud_user_id
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.extend_info):
            query['ExtendInfo'] = request.extend_info
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.regions):
            query['Regions'] = request.regions
        if not UtilClient.is_unset(request.secret_id):
            query['SecretId'] = request.secret_id
        if not UtilClient.is_unset(request.secret_key):
            query['SecretKey'] = request.secret_key
        if not UtilClient.is_unset(request.subscription_ids):
            query['SubscriptionIds'] = request.subscription_ids
        if not UtilClient.is_unset(request.tenant_id):
            query['TenantId'] = request.tenant_id
        if not UtilClient.is_unset(request.vendor):
            query['Vendor'] = request.vendor
        if not UtilClient.is_unset(request.vendor_auth_alias):
            query['VendorAuthAlias'] = request.vendor_auth_alias
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCloudVendorAccountAK',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddCloudVendorAccountAKResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_cloud_vendor_account_akwith_options_async(
        self,
        request: sas_20181203_models.AddCloudVendorAccountAKRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddCloudVendorAccountAKResponse:
        """
        @summary Adds the configuration information of multi-cloud assets.
        
        @param request: AddCloudVendorAccountAKRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCloudVendorAccountAKResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ak_type):
            query['AkType'] = request.ak_type
        if not UtilClient.is_unset(request.auth_modules):
            query['AuthModules'] = request.auth_modules
        if not UtilClient.is_unset(request.ctdr_cloud_user_id):
            query['CtdrCloudUserId'] = request.ctdr_cloud_user_id
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.extend_info):
            query['ExtendInfo'] = request.extend_info
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.regions):
            query['Regions'] = request.regions
        if not UtilClient.is_unset(request.secret_id):
            query['SecretId'] = request.secret_id
        if not UtilClient.is_unset(request.secret_key):
            query['SecretKey'] = request.secret_key
        if not UtilClient.is_unset(request.subscription_ids):
            query['SubscriptionIds'] = request.subscription_ids
        if not UtilClient.is_unset(request.tenant_id):
            query['TenantId'] = request.tenant_id
        if not UtilClient.is_unset(request.vendor):
            query['Vendor'] = request.vendor
        if not UtilClient.is_unset(request.vendor_auth_alias):
            query['VendorAuthAlias'] = request.vendor_auth_alias
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCloudVendorAccountAK',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddCloudVendorAccountAKResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_cloud_vendor_account_ak(
        self,
        request: sas_20181203_models.AddCloudVendorAccountAKRequest,
    ) -> sas_20181203_models.AddCloudVendorAccountAKResponse:
        """
        @summary Adds the configuration information of multi-cloud assets.
        
        @param request: AddCloudVendorAccountAKRequest
        @return: AddCloudVendorAccountAKResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_cloud_vendor_account_akwith_options(request, runtime)

    async def add_cloud_vendor_account_ak_async(
        self,
        request: sas_20181203_models.AddCloudVendorAccountAKRequest,
    ) -> sas_20181203_models.AddCloudVendorAccountAKResponse:
        """
        @summary Adds the configuration information of multi-cloud assets.
        
        @param request: AddCloudVendorAccountAKRequest
        @return: AddCloudVendorAccountAKResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_cloud_vendor_account_akwith_options_async(request, runtime)

    def add_cloud_vendor_trial_config_with_options(
        self,
        request: sas_20181203_models.AddCloudVendorTrialConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddCloudVendorTrialConfigResponse:
        """
        @summary Adds configurations of connecting the audit logs of a third-party cloud asset.
        
        @param request: AddCloudVendorTrialConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCloudVendorTrialConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_id):
            query['AuthId'] = request.auth_id
        if not UtilClient.is_unset(request.auth_info):
            query['AuthInfo'] = request.auth_info
        if not UtilClient.is_unset(request.vendor):
            query['Vendor'] = request.vendor
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCloudVendorTrialConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddCloudVendorTrialConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_cloud_vendor_trial_config_with_options_async(
        self,
        request: sas_20181203_models.AddCloudVendorTrialConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddCloudVendorTrialConfigResponse:
        """
        @summary Adds configurations of connecting the audit logs of a third-party cloud asset.
        
        @param request: AddCloudVendorTrialConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCloudVendorTrialConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_id):
            query['AuthId'] = request.auth_id
        if not UtilClient.is_unset(request.auth_info):
            query['AuthInfo'] = request.auth_info
        if not UtilClient.is_unset(request.vendor):
            query['Vendor'] = request.vendor
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCloudVendorTrialConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddCloudVendorTrialConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_cloud_vendor_trial_config(
        self,
        request: sas_20181203_models.AddCloudVendorTrialConfigRequest,
    ) -> sas_20181203_models.AddCloudVendorTrialConfigResponse:
        """
        @summary Adds configurations of connecting the audit logs of a third-party cloud asset.
        
        @param request: AddCloudVendorTrialConfigRequest
        @return: AddCloudVendorTrialConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_cloud_vendor_trial_config_with_options(request, runtime)

    async def add_cloud_vendor_trial_config_async(
        self,
        request: sas_20181203_models.AddCloudVendorTrialConfigRequest,
    ) -> sas_20181203_models.AddCloudVendorTrialConfigResponse:
        """
        @summary Adds configurations of connecting the audit logs of a third-party cloud asset.
        
        @param request: AddCloudVendorTrialConfigRequest
        @return: AddCloudVendorTrialConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_cloud_vendor_trial_config_with_options_async(request, runtime)

    def add_container_defense_rule_with_options(
        self,
        tmp_req: sas_20181203_models.AddContainerDefenseRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddContainerDefenseRuleResponse:
        """
        @summary Creates a rule for non-image program defense.
        
        @param tmp_req: AddContainerDefenseRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddContainerDefenseRuleResponse
        """
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.AddContainerDefenseRuleShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.whitelist):
            request.whitelist_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.whitelist, 'Whitelist', 'json')
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.rule_action):
            query['RuleAction'] = request.rule_action
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        if not UtilClient.is_unset(request.rule_name):
            query['RuleName'] = request.rule_name
        if not UtilClient.is_unset(request.rule_switch):
            query['RuleSwitch'] = request.rule_switch
        if not UtilClient.is_unset(request.rule_type):
            query['RuleType'] = request.rule_type
        if not UtilClient.is_unset(request.scope):
            query['Scope'] = request.scope
        if not UtilClient.is_unset(request.whitelist_shrink):
            query['Whitelist'] = request.whitelist_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddContainerDefenseRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddContainerDefenseRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_container_defense_rule_with_options_async(
        self,
        tmp_req: sas_20181203_models.AddContainerDefenseRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddContainerDefenseRuleResponse:
        """
        @summary Creates a rule for non-image program defense.
        
        @param tmp_req: AddContainerDefenseRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddContainerDefenseRuleResponse
        """
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.AddContainerDefenseRuleShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.whitelist):
            request.whitelist_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.whitelist, 'Whitelist', 'json')
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.rule_action):
            query['RuleAction'] = request.rule_action
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        if not UtilClient.is_unset(request.rule_name):
            query['RuleName'] = request.rule_name
        if not UtilClient.is_unset(request.rule_switch):
            query['RuleSwitch'] = request.rule_switch
        if not UtilClient.is_unset(request.rule_type):
            query['RuleType'] = request.rule_type
        if not UtilClient.is_unset(request.scope):
            query['Scope'] = request.scope
        if not UtilClient.is_unset(request.whitelist_shrink):
            query['Whitelist'] = request.whitelist_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddContainerDefenseRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddContainerDefenseRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_container_defense_rule(
        self,
        request: sas_20181203_models.AddContainerDefenseRuleRequest,
    ) -> sas_20181203_models.AddContainerDefenseRuleResponse:
        """
        @summary Creates a rule for non-image program defense.
        
        @param request: AddContainerDefenseRuleRequest
        @return: AddContainerDefenseRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_container_defense_rule_with_options(request, runtime)

    async def add_container_defense_rule_async(
        self,
        request: sas_20181203_models.AddContainerDefenseRuleRequest,
    ) -> sas_20181203_models.AddContainerDefenseRuleResponse:
        """
        @summary Creates a rule for non-image program defense.
        
        @param request: AddContainerDefenseRuleRequest
        @return: AddContainerDefenseRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_container_defense_rule_with_options_async(request, runtime)

    def add_container_plugin_rule_with_options(
        self,
        request: sas_20181203_models.AddContainerPluginRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddContainerPluginRuleResponse:
        """
        @summary Creates a defense rule against container escapes.
        
        @param request: AddContainerPluginRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddContainerPluginRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.mode):
            query['Mode'] = request.mode
        if not UtilClient.is_unset(request.rule_name):
            query['RuleName'] = request.rule_name
        if not UtilClient.is_unset(request.rule_template_id):
            query['RuleTemplateId'] = request.rule_template_id
        if not UtilClient.is_unset(request.rule_type):
            query['RuleType'] = request.rule_type
        if not UtilClient.is_unset(request.selected_policy):
            query['SelectedPolicy'] = request.selected_policy
        if not UtilClient.is_unset(request.white_images):
            query['WhiteImages'] = request.white_images
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddContainerPluginRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddContainerPluginRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_container_plugin_rule_with_options_async(
        self,
        request: sas_20181203_models.AddContainerPluginRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddContainerPluginRuleResponse:
        """
        @summary Creates a defense rule against container escapes.
        
        @param request: AddContainerPluginRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddContainerPluginRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.mode):
            query['Mode'] = request.mode
        if not UtilClient.is_unset(request.rule_name):
            query['RuleName'] = request.rule_name
        if not UtilClient.is_unset(request.rule_template_id):
            query['RuleTemplateId'] = request.rule_template_id
        if not UtilClient.is_unset(request.rule_type):
            query['RuleType'] = request.rule_type
        if not UtilClient.is_unset(request.selected_policy):
            query['SelectedPolicy'] = request.selected_policy
        if not UtilClient.is_unset(request.white_images):
            query['WhiteImages'] = request.white_images
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddContainerPluginRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddContainerPluginRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_container_plugin_rule(
        self,
        request: sas_20181203_models.AddContainerPluginRuleRequest,
    ) -> sas_20181203_models.AddContainerPluginRuleResponse:
        """
        @summary Creates a defense rule against container escapes.
        
        @param request: AddContainerPluginRuleRequest
        @return: AddContainerPluginRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_container_plugin_rule_with_options(request, runtime)

    async def add_container_plugin_rule_async(
        self,
        request: sas_20181203_models.AddContainerPluginRuleRequest,
    ) -> sas_20181203_models.AddContainerPluginRuleResponse:
        """
        @summary Creates a defense rule against container escapes.
        
        @param request: AddContainerPluginRuleRequest
        @return: AddContainerPluginRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_container_plugin_rule_with_options_async(request, runtime)

    def add_idc_probe_with_options(
        self,
        request: sas_20181203_models.AddIdcProbeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddIdcProbeResponse:
        """
        @summary Creates an IDC probe to add assets in a data center to Security Center and manage the assets by using the Security Center console.
        
        @description Security Center allows you to create an IDC probe only on servers on which the Security Center agent is installed.
        
        @param request: AddIdcProbeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddIdcProbeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.idc_name):
            query['IdcName'] = request.idc_name
        if not UtilClient.is_unset(request.idc_region):
            query['IdcRegion'] = request.idc_region
        if not UtilClient.is_unset(request.interval_period):
            query['IntervalPeriod'] = request.interval_period
        if not UtilClient.is_unset(request.ip_segments):
            query['IpSegments'] = request.ip_segments
        if not UtilClient.is_unset(request.linux_port):
            query['LinuxPort'] = request.linux_port
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        if not UtilClient.is_unset(request.win_port):
            query['WinPort'] = request.win_port
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddIdcProbe',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddIdcProbeResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_idc_probe_with_options_async(
        self,
        request: sas_20181203_models.AddIdcProbeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddIdcProbeResponse:
        """
        @summary Creates an IDC probe to add assets in a data center to Security Center and manage the assets by using the Security Center console.
        
        @description Security Center allows you to create an IDC probe only on servers on which the Security Center agent is installed.
        
        @param request: AddIdcProbeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddIdcProbeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.idc_name):
            query['IdcName'] = request.idc_name
        if not UtilClient.is_unset(request.idc_region):
            query['IdcRegion'] = request.idc_region
        if not UtilClient.is_unset(request.interval_period):
            query['IntervalPeriod'] = request.interval_period
        if not UtilClient.is_unset(request.ip_segments):
            query['IpSegments'] = request.ip_segments
        if not UtilClient.is_unset(request.linux_port):
            query['LinuxPort'] = request.linux_port
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        if not UtilClient.is_unset(request.win_port):
            query['WinPort'] = request.win_port
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddIdcProbe',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddIdcProbeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_idc_probe(
        self,
        request: sas_20181203_models.AddIdcProbeRequest,
    ) -> sas_20181203_models.AddIdcProbeResponse:
        """
        @summary Creates an IDC probe to add assets in a data center to Security Center and manage the assets by using the Security Center console.
        
        @description Security Center allows you to create an IDC probe only on servers on which the Security Center agent is installed.
        
        @param request: AddIdcProbeRequest
        @return: AddIdcProbeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_idc_probe_with_options(request, runtime)

    async def add_idc_probe_async(
        self,
        request: sas_20181203_models.AddIdcProbeRequest,
    ) -> sas_20181203_models.AddIdcProbeResponse:
        """
        @summary Creates an IDC probe to add assets in a data center to Security Center and manage the assets by using the Security Center console.
        
        @description Security Center allows you to create an IDC probe only on servers on which the Security Center agent is installed.
        
        @param request: AddIdcProbeRequest
        @return: AddIdcProbeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_idc_probe_with_options_async(request, runtime)

    def add_image_event_operation_with_options(
        self,
        request: sas_20181203_models.AddImageEventOperationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddImageEventOperationResponse:
        """
        @summary Creates an alert handling rule.
        
        @param request: AddImageEventOperationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddImageEventOperationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.conditions):
            query['Conditions'] = request.conditions
        if not UtilClient.is_unset(request.event_key):
            query['EventKey'] = request.event_key
        if not UtilClient.is_unset(request.event_name):
            query['EventName'] = request.event_name
        if not UtilClient.is_unset(request.event_type):
            query['EventType'] = request.event_type
        if not UtilClient.is_unset(request.note):
            query['Note'] = request.note
        if not UtilClient.is_unset(request.operation_code):
            query['OperationCode'] = request.operation_code
        if not UtilClient.is_unset(request.scenarios):
            query['Scenarios'] = request.scenarios
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddImageEventOperation',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddImageEventOperationResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_image_event_operation_with_options_async(
        self,
        request: sas_20181203_models.AddImageEventOperationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddImageEventOperationResponse:
        """
        @summary Creates an alert handling rule.
        
        @param request: AddImageEventOperationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddImageEventOperationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.conditions):
            query['Conditions'] = request.conditions
        if not UtilClient.is_unset(request.event_key):
            query['EventKey'] = request.event_key
        if not UtilClient.is_unset(request.event_name):
            query['EventName'] = request.event_name
        if not UtilClient.is_unset(request.event_type):
            query['EventType'] = request.event_type
        if not UtilClient.is_unset(request.note):
            query['Note'] = request.note
        if not UtilClient.is_unset(request.operation_code):
            query['OperationCode'] = request.operation_code
        if not UtilClient.is_unset(request.scenarios):
            query['Scenarios'] = request.scenarios
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddImageEventOperation',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddImageEventOperationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_image_event_operation(
        self,
        request: sas_20181203_models.AddImageEventOperationRequest,
    ) -> sas_20181203_models.AddImageEventOperationResponse:
        """
        @summary Creates an alert handling rule.
        
        @param request: AddImageEventOperationRequest
        @return: AddImageEventOperationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_image_event_operation_with_options(request, runtime)

    async def add_image_event_operation_async(
        self,
        request: sas_20181203_models.AddImageEventOperationRequest,
    ) -> sas_20181203_models.AddImageEventOperationResponse:
        """
        @summary Creates an alert handling rule.
        
        @param request: AddImageEventOperationRequest
        @return: AddImageEventOperationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_image_event_operation_with_options_async(request, runtime)

    def add_image_vul_white_list_with_options(
        self,
        request: sas_20181203_models.AddImageVulWhiteListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddImageVulWhiteListResponse:
        """
        @summary Adds image vulnerabilities to the whitelist.
        
        @param request: AddImageVulWhiteListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddImageVulWhiteListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.reason):
            query['Reason'] = request.reason
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.target):
            query['Target'] = request.target
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.whitelist):
            query['Whitelist'] = request.whitelist
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddImageVulWhiteList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddImageVulWhiteListResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_image_vul_white_list_with_options_async(
        self,
        request: sas_20181203_models.AddImageVulWhiteListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddImageVulWhiteListResponse:
        """
        @summary Adds image vulnerabilities to the whitelist.
        
        @param request: AddImageVulWhiteListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddImageVulWhiteListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.reason):
            query['Reason'] = request.reason
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.target):
            query['Target'] = request.target
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.whitelist):
            query['Whitelist'] = request.whitelist
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddImageVulWhiteList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddImageVulWhiteListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_image_vul_white_list(
        self,
        request: sas_20181203_models.AddImageVulWhiteListRequest,
    ) -> sas_20181203_models.AddImageVulWhiteListResponse:
        """
        @summary Adds image vulnerabilities to the whitelist.
        
        @param request: AddImageVulWhiteListRequest
        @return: AddImageVulWhiteListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_image_vul_white_list_with_options(request, runtime)

    async def add_image_vul_white_list_async(
        self,
        request: sas_20181203_models.AddImageVulWhiteListRequest,
    ) -> sas_20181203_models.AddImageVulWhiteListResponse:
        """
        @summary Adds image vulnerabilities to the whitelist.
        
        @param request: AddImageVulWhiteListRequest
        @return: AddImageVulWhiteListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_image_vul_white_list_with_options_async(request, runtime)

    def add_install_code_with_options(
        self,
        request: sas_20181203_models.AddInstallCodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddInstallCodeResponse:
        """
        @summary Creates a command that is used to install the Security Center agent.
        
        @param request: AddInstallCodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddInstallCodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.expired_date):
            query['ExpiredDate'] = request.expired_date
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.only_image):
            query['OnlyImage'] = request.only_image
        if not UtilClient.is_unset(request.os):
            query['Os'] = request.os
        if not UtilClient.is_unset(request.private_link_id):
            query['PrivateLinkId'] = request.private_link_id
        if not UtilClient.is_unset(request.proxy_cluster):
            query['ProxyCluster'] = request.proxy_cluster
        if not UtilClient.is_unset(request.vendor_name):
            query['VendorName'] = request.vendor_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddInstallCode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddInstallCodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_install_code_with_options_async(
        self,
        request: sas_20181203_models.AddInstallCodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddInstallCodeResponse:
        """
        @summary Creates a command that is used to install the Security Center agent.
        
        @param request: AddInstallCodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddInstallCodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.expired_date):
            query['ExpiredDate'] = request.expired_date
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.only_image):
            query['OnlyImage'] = request.only_image
        if not UtilClient.is_unset(request.os):
            query['Os'] = request.os
        if not UtilClient.is_unset(request.private_link_id):
            query['PrivateLinkId'] = request.private_link_id
        if not UtilClient.is_unset(request.proxy_cluster):
            query['ProxyCluster'] = request.proxy_cluster
        if not UtilClient.is_unset(request.vendor_name):
            query['VendorName'] = request.vendor_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddInstallCode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddInstallCodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_install_code(
        self,
        request: sas_20181203_models.AddInstallCodeRequest,
    ) -> sas_20181203_models.AddInstallCodeResponse:
        """
        @summary Creates a command that is used to install the Security Center agent.
        
        @param request: AddInstallCodeRequest
        @return: AddInstallCodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_install_code_with_options(request, runtime)

    async def add_install_code_async(
        self,
        request: sas_20181203_models.AddInstallCodeRequest,
    ) -> sas_20181203_models.AddInstallCodeResponse:
        """
        @summary Creates a command that is used to install the Security Center agent.
        
        @param request: AddInstallCodeRequest
        @return: AddInstallCodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_install_code_with_options_async(request, runtime)

    def add_private_registry_with_options(
        self,
        request: sas_20181203_models.AddPrivateRegistryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddPrivateRegistryResponse:
        """
        @summary Adds a self-managed image repository.
        
        @param request: AddPrivateRegistryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddPrivateRegistryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.extra_param):
            query['ExtraParam'] = request.extra_param
        if not UtilClient.is_unset(request.net_type):
            query['NetType'] = request.net_type
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.protocol_type):
            query['ProtocolType'] = request.protocol_type
        if not UtilClient.is_unset(request.registry_host_ip):
            query['RegistryHostIp'] = request.registry_host_ip
        if not UtilClient.is_unset(request.registry_region_id):
            query['RegistryRegionId'] = request.registry_region_id
        if not UtilClient.is_unset(request.registry_type):
            query['RegistryType'] = request.registry_type
        if not UtilClient.is_unset(request.registry_version):
            query['RegistryVersion'] = request.registry_version
        if not UtilClient.is_unset(request.trans_per_hour):
            query['TransPerHour'] = request.trans_per_hour
        if not UtilClient.is_unset(request.user_name):
            query['UserName'] = request.user_name
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddPrivateRegistry',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddPrivateRegistryResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_private_registry_with_options_async(
        self,
        request: sas_20181203_models.AddPrivateRegistryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddPrivateRegistryResponse:
        """
        @summary Adds a self-managed image repository.
        
        @param request: AddPrivateRegistryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddPrivateRegistryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.extra_param):
            query['ExtraParam'] = request.extra_param
        if not UtilClient.is_unset(request.net_type):
            query['NetType'] = request.net_type
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.protocol_type):
            query['ProtocolType'] = request.protocol_type
        if not UtilClient.is_unset(request.registry_host_ip):
            query['RegistryHostIp'] = request.registry_host_ip
        if not UtilClient.is_unset(request.registry_region_id):
            query['RegistryRegionId'] = request.registry_region_id
        if not UtilClient.is_unset(request.registry_type):
            query['RegistryType'] = request.registry_type
        if not UtilClient.is_unset(request.registry_version):
            query['RegistryVersion'] = request.registry_version
        if not UtilClient.is_unset(request.trans_per_hour):
            query['TransPerHour'] = request.trans_per_hour
        if not UtilClient.is_unset(request.user_name):
            query['UserName'] = request.user_name
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddPrivateRegistry',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddPrivateRegistryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_private_registry(
        self,
        request: sas_20181203_models.AddPrivateRegistryRequest,
    ) -> sas_20181203_models.AddPrivateRegistryResponse:
        """
        @summary Adds a self-managed image repository.
        
        @param request: AddPrivateRegistryRequest
        @return: AddPrivateRegistryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_private_registry_with_options(request, runtime)

    async def add_private_registry_async(
        self,
        request: sas_20181203_models.AddPrivateRegistryRequest,
    ) -> sas_20181203_models.AddPrivateRegistryResponse:
        """
        @summary Adds a self-managed image repository.
        
        @param request: AddPrivateRegistryRequest
        @return: AddPrivateRegistryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_private_registry_with_options_async(request, runtime)

    def add_protect_vpc_list_with_options(
        self,
        request: sas_20181203_models.AddProtectVpcListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddProtectVpcListResponse:
        """
        @summary Add or update the whitelist for VPC purchases
        
        @param request: AddProtectVpcListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddProtectVpcListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.add_vpc_instance_id_list):
            query['AddVpcInstanceIdList'] = request.add_vpc_instance_id_list
        if not UtilClient.is_unset(request.del_vpc_instance_id_list):
            query['DelVpcInstanceIdList'] = request.del_vpc_instance_id_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddProtectVpcList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddProtectVpcListResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_protect_vpc_list_with_options_async(
        self,
        request: sas_20181203_models.AddProtectVpcListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddProtectVpcListResponse:
        """
        @summary Add or update the whitelist for VPC purchases
        
        @param request: AddProtectVpcListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddProtectVpcListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.add_vpc_instance_id_list):
            query['AddVpcInstanceIdList'] = request.add_vpc_instance_id_list
        if not UtilClient.is_unset(request.del_vpc_instance_id_list):
            query['DelVpcInstanceIdList'] = request.del_vpc_instance_id_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddProtectVpcList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddProtectVpcListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_protect_vpc_list(
        self,
        request: sas_20181203_models.AddProtectVpcListRequest,
    ) -> sas_20181203_models.AddProtectVpcListResponse:
        """
        @summary Add or update the whitelist for VPC purchases
        
        @param request: AddProtectVpcListRequest
        @return: AddProtectVpcListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_protect_vpc_list_with_options(request, runtime)

    async def add_protect_vpc_list_async(
        self,
        request: sas_20181203_models.AddProtectVpcListRequest,
    ) -> sas_20181203_models.AddProtectVpcListResponse:
        """
        @summary Add or update the whitelist for VPC purchases
        
        @param request: AddProtectVpcListRequest
        @return: AddProtectVpcListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_protect_vpc_list_with_options_async(request, runtime)

    def add_publish_batch_with_options(
        self,
        request: sas_20181203_models.AddPublishBatchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddPublishBatchResponse:
        """
        @summary Upgrades the Security Center agent in batches.
        
        @param request: AddPublishBatchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddPublishBatchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.batch_name):
            query['BatchName'] = request.batch_name
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.operation_base):
            query['OperationBase'] = request.operation_base
        if not UtilClient.is_unset(request.upgrade_version):
            query['UpgradeVersion'] = request.upgrade_version
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddPublishBatch',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddPublishBatchResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_publish_batch_with_options_async(
        self,
        request: sas_20181203_models.AddPublishBatchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddPublishBatchResponse:
        """
        @summary Upgrades the Security Center agent in batches.
        
        @param request: AddPublishBatchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddPublishBatchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.batch_name):
            query['BatchName'] = request.batch_name
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.operation_base):
            query['OperationBase'] = request.operation_base
        if not UtilClient.is_unset(request.upgrade_version):
            query['UpgradeVersion'] = request.upgrade_version
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddPublishBatch',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddPublishBatchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_publish_batch(
        self,
        request: sas_20181203_models.AddPublishBatchRequest,
    ) -> sas_20181203_models.AddPublishBatchResponse:
        """
        @summary Upgrades the Security Center agent in batches.
        
        @param request: AddPublishBatchRequest
        @return: AddPublishBatchResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_publish_batch_with_options(request, runtime)

    async def add_publish_batch_async(
        self,
        request: sas_20181203_models.AddPublishBatchRequest,
    ) -> sas_20181203_models.AddPublishBatchResponse:
        """
        @summary Upgrades the Security Center agent in batches.
        
        @param request: AddPublishBatchRequest
        @return: AddPublishBatchResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_publish_batch_with_options_async(request, runtime)

    def add_sas_container_web_defense_rule_with_options(
        self,
        request: sas_20181203_models.AddSasContainerWebDefenseRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddSasContainerWebDefenseRuleResponse:
        """
        @summary Creates a rule for container tamper-proofing.
        
        @param request: AddSasContainerWebDefenseRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddSasContainerWebDefenseRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.path_conf_dtolist):
            query['PathConfDTOList'] = request.path_conf_dtolist
        if not UtilClient.is_unset(request.rule_name):
            query['RuleName'] = request.rule_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddSasContainerWebDefenseRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddSasContainerWebDefenseRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_sas_container_web_defense_rule_with_options_async(
        self,
        request: sas_20181203_models.AddSasContainerWebDefenseRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddSasContainerWebDefenseRuleResponse:
        """
        @summary Creates a rule for container tamper-proofing.
        
        @param request: AddSasContainerWebDefenseRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddSasContainerWebDefenseRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.path_conf_dtolist):
            query['PathConfDTOList'] = request.path_conf_dtolist
        if not UtilClient.is_unset(request.rule_name):
            query['RuleName'] = request.rule_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddSasContainerWebDefenseRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddSasContainerWebDefenseRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_sas_container_web_defense_rule(
        self,
        request: sas_20181203_models.AddSasContainerWebDefenseRuleRequest,
    ) -> sas_20181203_models.AddSasContainerWebDefenseRuleResponse:
        """
        @summary Creates a rule for container tamper-proofing.
        
        @param request: AddSasContainerWebDefenseRuleRequest
        @return: AddSasContainerWebDefenseRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_sas_container_web_defense_rule_with_options(request, runtime)

    async def add_sas_container_web_defense_rule_async(
        self,
        request: sas_20181203_models.AddSasContainerWebDefenseRuleRequest,
    ) -> sas_20181203_models.AddSasContainerWebDefenseRuleResponse:
        """
        @summary Creates a rule for container tamper-proofing.
        
        @param request: AddSasContainerWebDefenseRuleRequest
        @return: AddSasContainerWebDefenseRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_sas_container_web_defense_rule_with_options_async(request, runtime)

    def add_sas_module_trial_with_options(
        self,
        request: sas_20181203_models.AddSasModuleTrialRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddSasModuleTrialResponse:
        """
        @summary Enables the trial use of Security Center value-added features, including vulnerability fixing and threat analysis and response.
        
        @param request: AddSasModuleTrialRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddSasModuleTrialResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.module_code):
            query['ModuleCode'] = request.module_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddSasModuleTrial',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddSasModuleTrialResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_sas_module_trial_with_options_async(
        self,
        request: sas_20181203_models.AddSasModuleTrialRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddSasModuleTrialResponse:
        """
        @summary Enables the trial use of Security Center value-added features, including vulnerability fixing and threat analysis and response.
        
        @param request: AddSasModuleTrialRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddSasModuleTrialResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.module_code):
            query['ModuleCode'] = request.module_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddSasModuleTrial',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddSasModuleTrialResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_sas_module_trial(
        self,
        request: sas_20181203_models.AddSasModuleTrialRequest,
    ) -> sas_20181203_models.AddSasModuleTrialResponse:
        """
        @summary Enables the trial use of Security Center value-added features, including vulnerability fixing and threat analysis and response.
        
        @param request: AddSasModuleTrialRequest
        @return: AddSasModuleTrialResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_sas_module_trial_with_options(request, runtime)

    async def add_sas_module_trial_async(
        self,
        request: sas_20181203_models.AddSasModuleTrialRequest,
    ) -> sas_20181203_models.AddSasModuleTrialResponse:
        """
        @summary Enables the trial use of Security Center value-added features, including vulnerability fixing and threat analysis and response.
        
        @param request: AddSasModuleTrialRequest
        @return: AddSasModuleTrialResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_sas_module_trial_with_options_async(request, runtime)

    def add_tag_with_uuid_with_options(
        self,
        request: sas_20181203_models.AddTagWithUuidRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddTagWithUuidResponse:
        """
        @summary Adds a tag to assets.
        
        @description Security Center provides asset importance tags and custom tags. You can call the AddTagWithUuid operation to add only a custom tag to assets.
        
        @param request: AddTagWithUuidRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddTagWithUuidResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.tag_name):
            query['TagName'] = request.tag_name
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddTagWithUuid',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddTagWithUuidResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_tag_with_uuid_with_options_async(
        self,
        request: sas_20181203_models.AddTagWithUuidRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddTagWithUuidResponse:
        """
        @summary Adds a tag to assets.
        
        @description Security Center provides asset importance tags and custom tags. You can call the AddTagWithUuid operation to add only a custom tag to assets.
        
        @param request: AddTagWithUuidRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddTagWithUuidResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.tag_name):
            query['TagName'] = request.tag_name
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddTagWithUuid',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddTagWithUuidResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_tag_with_uuid(
        self,
        request: sas_20181203_models.AddTagWithUuidRequest,
    ) -> sas_20181203_models.AddTagWithUuidResponse:
        """
        @summary Adds a tag to assets.
        
        @description Security Center provides asset importance tags and custom tags. You can call the AddTagWithUuid operation to add only a custom tag to assets.
        
        @param request: AddTagWithUuidRequest
        @return: AddTagWithUuidResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_tag_with_uuid_with_options(request, runtime)

    async def add_tag_with_uuid_async(
        self,
        request: sas_20181203_models.AddTagWithUuidRequest,
    ) -> sas_20181203_models.AddTagWithUuidResponse:
        """
        @summary Adds a tag to assets.
        
        @description Security Center provides asset importance tags and custom tags. You can call the AddTagWithUuid operation to add only a custom tag to assets.
        
        @param request: AddTagWithUuidRequest
        @return: AddTagWithUuidResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_tag_with_uuid_with_options_async(request, runtime)

    def add_uninstall_clients_by_uuids_with_options(
        self,
        request: sas_20181203_models.AddUninstallClientsByUuidsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddUninstallClientsByUuidsResponse:
        """
        @summary Adds servers from which you want to uninstall the Security Center agent.
        
        @param request: AddUninstallClientsByUuidsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddUninstallClientsByUuidsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.call_method):
            query['CallMethod'] = request.call_method
        if not UtilClient.is_unset(request.feedback):
            query['Feedback'] = request.feedback
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddUninstallClientsByUuids',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddUninstallClientsByUuidsResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_uninstall_clients_by_uuids_with_options_async(
        self,
        request: sas_20181203_models.AddUninstallClientsByUuidsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddUninstallClientsByUuidsResponse:
        """
        @summary Adds servers from which you want to uninstall the Security Center agent.
        
        @param request: AddUninstallClientsByUuidsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddUninstallClientsByUuidsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.call_method):
            query['CallMethod'] = request.call_method
        if not UtilClient.is_unset(request.feedback):
            query['Feedback'] = request.feedback
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddUninstallClientsByUuids',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddUninstallClientsByUuidsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_uninstall_clients_by_uuids(
        self,
        request: sas_20181203_models.AddUninstallClientsByUuidsRequest,
    ) -> sas_20181203_models.AddUninstallClientsByUuidsResponse:
        """
        @summary Adds servers from which you want to uninstall the Security Center agent.
        
        @param request: AddUninstallClientsByUuidsRequest
        @return: AddUninstallClientsByUuidsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_uninstall_clients_by_uuids_with_options(request, runtime)

    async def add_uninstall_clients_by_uuids_async(
        self,
        request: sas_20181203_models.AddUninstallClientsByUuidsRequest,
    ) -> sas_20181203_models.AddUninstallClientsByUuidsResponse:
        """
        @summary Adds servers from which you want to uninstall the Security Center agent.
        
        @param request: AddUninstallClientsByUuidsRequest
        @return: AddUninstallClientsByUuidsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_uninstall_clients_by_uuids_with_options_async(request, runtime)

    def add_vpc_honey_pot_with_options(
        self,
        request: sas_20181203_models.AddVpcHoneyPotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddVpcHoneyPotResponse:
        """
        @summary Creates a honeypot.
        
        @param request: AddVpcHoneyPotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddVpcHoneyPotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddVpcHoneyPot',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddVpcHoneyPotResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_vpc_honey_pot_with_options_async(
        self,
        request: sas_20181203_models.AddVpcHoneyPotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddVpcHoneyPotResponse:
        """
        @summary Creates a honeypot.
        
        @param request: AddVpcHoneyPotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddVpcHoneyPotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddVpcHoneyPot',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddVpcHoneyPotResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_vpc_honey_pot(
        self,
        request: sas_20181203_models.AddVpcHoneyPotRequest,
    ) -> sas_20181203_models.AddVpcHoneyPotResponse:
        """
        @summary Creates a honeypot.
        
        @param request: AddVpcHoneyPotRequest
        @return: AddVpcHoneyPotResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_vpc_honey_pot_with_options(request, runtime)

    async def add_vpc_honey_pot_async(
        self,
        request: sas_20181203_models.AddVpcHoneyPotRequest,
    ) -> sas_20181203_models.AddVpcHoneyPotResponse:
        """
        @summary Creates a honeypot.
        
        @param request: AddVpcHoneyPotRequest
        @return: AddVpcHoneyPotResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_vpc_honey_pot_with_options_async(request, runtime)

    def advance_security_event_operations_with_options(
        self,
        request: sas_20181203_models.AdvanceSecurityEventOperationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AdvanceSecurityEventOperationsResponse:
        """
        @summary Queries the configurations of an advanced whitelist rule.
        
        @param request: AdvanceSecurityEventOperationsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AdvanceSecurityEventOperationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_name):
            query['EventName'] = request.event_name
        if not UtilClient.is_unset(request.event_type):
            query['EventType'] = request.event_type
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AdvanceSecurityEventOperations',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AdvanceSecurityEventOperationsResponse(),
            self.call_api(params, req, runtime)
        )

    async def advance_security_event_operations_with_options_async(
        self,
        request: sas_20181203_models.AdvanceSecurityEventOperationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AdvanceSecurityEventOperationsResponse:
        """
        @summary Queries the configurations of an advanced whitelist rule.
        
        @param request: AdvanceSecurityEventOperationsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AdvanceSecurityEventOperationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_name):
            query['EventName'] = request.event_name
        if not UtilClient.is_unset(request.event_type):
            query['EventType'] = request.event_type
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AdvanceSecurityEventOperations',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AdvanceSecurityEventOperationsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def advance_security_event_operations(
        self,
        request: sas_20181203_models.AdvanceSecurityEventOperationsRequest,
    ) -> sas_20181203_models.AdvanceSecurityEventOperationsResponse:
        """
        @summary Queries the configurations of an advanced whitelist rule.
        
        @param request: AdvanceSecurityEventOperationsRequest
        @return: AdvanceSecurityEventOperationsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.advance_security_event_operations_with_options(request, runtime)

    async def advance_security_event_operations_async(
        self,
        request: sas_20181203_models.AdvanceSecurityEventOperationsRequest,
    ) -> sas_20181203_models.AdvanceSecurityEventOperationsResponse:
        """
        @summary Queries the configurations of an advanced whitelist rule.
        
        @param request: AdvanceSecurityEventOperationsRequest
        @return: AdvanceSecurityEventOperationsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.advance_security_event_operations_with_options_async(request, runtime)

    def batch_create_malicious_note_with_options(
        self,
        request: sas_20181203_models.BatchCreateMaliciousNoteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.BatchCreateMaliciousNoteResponse:
        """
        @summary Adds alert description in batches.
        
        @param request: BatchCreateMaliciousNoteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchCreateMaliciousNoteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_malicious_file_list):
            query['ImageMaliciousFileList'] = request.image_malicious_file_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchCreateMaliciousNote',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.BatchCreateMaliciousNoteResponse(),
            self.call_api(params, req, runtime)
        )

    async def batch_create_malicious_note_with_options_async(
        self,
        request: sas_20181203_models.BatchCreateMaliciousNoteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.BatchCreateMaliciousNoteResponse:
        """
        @summary Adds alert description in batches.
        
        @param request: BatchCreateMaliciousNoteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchCreateMaliciousNoteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_malicious_file_list):
            query['ImageMaliciousFileList'] = request.image_malicious_file_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchCreateMaliciousNote',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.BatchCreateMaliciousNoteResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def batch_create_malicious_note(
        self,
        request: sas_20181203_models.BatchCreateMaliciousNoteRequest,
    ) -> sas_20181203_models.BatchCreateMaliciousNoteResponse:
        """
        @summary Adds alert description in batches.
        
        @param request: BatchCreateMaliciousNoteRequest
        @return: BatchCreateMaliciousNoteResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.batch_create_malicious_note_with_options(request, runtime)

    async def batch_create_malicious_note_async(
        self,
        request: sas_20181203_models.BatchCreateMaliciousNoteRequest,
    ) -> sas_20181203_models.BatchCreateMaliciousNoteResponse:
        """
        @summary Adds alert description in batches.
        
        @param request: BatchCreateMaliciousNoteRequest
        @return: BatchCreateMaliciousNoteResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.batch_create_malicious_note_with_options_async(request, runtime)

    def batch_delete_malicious_file_whitelist_config_with_options(
        self,
        request: sas_20181203_models.BatchDeleteMaliciousFileWhitelistConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.BatchDeleteMaliciousFileWhitelistConfigResponse:
        """
        @summary Deletes whitelist rules for alerts generated for sensitive files that are detected by using the agentless detection feature in batches.
        
        @param request: BatchDeleteMaliciousFileWhitelistConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchDeleteMaliciousFileWhitelistConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config_id_list):
            query['ConfigIdList'] = request.config_id_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchDeleteMaliciousFileWhitelistConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.BatchDeleteMaliciousFileWhitelistConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def batch_delete_malicious_file_whitelist_config_with_options_async(
        self,
        request: sas_20181203_models.BatchDeleteMaliciousFileWhitelistConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.BatchDeleteMaliciousFileWhitelistConfigResponse:
        """
        @summary Deletes whitelist rules for alerts generated for sensitive files that are detected by using the agentless detection feature in batches.
        
        @param request: BatchDeleteMaliciousFileWhitelistConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchDeleteMaliciousFileWhitelistConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config_id_list):
            query['ConfigIdList'] = request.config_id_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchDeleteMaliciousFileWhitelistConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.BatchDeleteMaliciousFileWhitelistConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def batch_delete_malicious_file_whitelist_config(
        self,
        request: sas_20181203_models.BatchDeleteMaliciousFileWhitelistConfigRequest,
    ) -> sas_20181203_models.BatchDeleteMaliciousFileWhitelistConfigResponse:
        """
        @summary Deletes whitelist rules for alerts generated for sensitive files that are detected by using the agentless detection feature in batches.
        
        @param request: BatchDeleteMaliciousFileWhitelistConfigRequest
        @return: BatchDeleteMaliciousFileWhitelistConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.batch_delete_malicious_file_whitelist_config_with_options(request, runtime)

    async def batch_delete_malicious_file_whitelist_config_async(
        self,
        request: sas_20181203_models.BatchDeleteMaliciousFileWhitelistConfigRequest,
    ) -> sas_20181203_models.BatchDeleteMaliciousFileWhitelistConfigResponse:
        """
        @summary Deletes whitelist rules for alerts generated for sensitive files that are detected by using the agentless detection feature in batches.
        
        @param request: BatchDeleteMaliciousFileWhitelistConfigRequest
        @return: BatchDeleteMaliciousFileWhitelistConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.batch_delete_malicious_file_whitelist_config_with_options_async(request, runtime)

    def batch_operate_common_overall_config_with_options(
        self,
        request: sas_20181203_models.BatchOperateCommonOverallConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.BatchOperateCommonOverallConfigResponse:
        """
        @summary Enables or disables multiple features in proactive defense at a time.
        
        @param request: BatchOperateCommonOverallConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchOperateCommonOverallConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config):
            query['Config'] = request.config
        if not UtilClient.is_unset(request.type_list):
            query['TypeList'] = request.type_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchOperateCommonOverallConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.BatchOperateCommonOverallConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def batch_operate_common_overall_config_with_options_async(
        self,
        request: sas_20181203_models.BatchOperateCommonOverallConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.BatchOperateCommonOverallConfigResponse:
        """
        @summary Enables or disables multiple features in proactive defense at a time.
        
        @param request: BatchOperateCommonOverallConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchOperateCommonOverallConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config):
            query['Config'] = request.config
        if not UtilClient.is_unset(request.type_list):
            query['TypeList'] = request.type_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchOperateCommonOverallConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.BatchOperateCommonOverallConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def batch_operate_common_overall_config(
        self,
        request: sas_20181203_models.BatchOperateCommonOverallConfigRequest,
    ) -> sas_20181203_models.BatchOperateCommonOverallConfigResponse:
        """
        @summary Enables or disables multiple features in proactive defense at a time.
        
        @param request: BatchOperateCommonOverallConfigRequest
        @return: BatchOperateCommonOverallConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.batch_operate_common_overall_config_with_options(request, runtime)

    async def batch_operate_common_overall_config_async(
        self,
        request: sas_20181203_models.BatchOperateCommonOverallConfigRequest,
    ) -> sas_20181203_models.BatchOperateCommonOverallConfigResponse:
        """
        @summary Enables or disables multiple features in proactive defense at a time.
        
        @param request: BatchOperateCommonOverallConfigRequest
        @return: BatchOperateCommonOverallConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.batch_operate_common_overall_config_with_options_async(request, runtime)

    def batch_update_malicious_file_whitelist_config_with_options(
        self,
        request: sas_20181203_models.BatchUpdateMaliciousFileWhitelistConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.BatchUpdateMaliciousFileWhitelistConfigResponse:
        """
        @summary Modifies multiple alert whitelist rules of sensitive files that are detected by using the agentless detection feature at a time.
        
        @param request: BatchUpdateMaliciousFileWhitelistConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchUpdateMaliciousFileWhitelistConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config_list):
            query['ConfigList'] = request.config_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchUpdateMaliciousFileWhitelistConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.BatchUpdateMaliciousFileWhitelistConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def batch_update_malicious_file_whitelist_config_with_options_async(
        self,
        request: sas_20181203_models.BatchUpdateMaliciousFileWhitelistConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.BatchUpdateMaliciousFileWhitelistConfigResponse:
        """
        @summary Modifies multiple alert whitelist rules of sensitive files that are detected by using the agentless detection feature at a time.
        
        @param request: BatchUpdateMaliciousFileWhitelistConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchUpdateMaliciousFileWhitelistConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config_list):
            query['ConfigList'] = request.config_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchUpdateMaliciousFileWhitelistConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.BatchUpdateMaliciousFileWhitelistConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def batch_update_malicious_file_whitelist_config(
        self,
        request: sas_20181203_models.BatchUpdateMaliciousFileWhitelistConfigRequest,
    ) -> sas_20181203_models.BatchUpdateMaliciousFileWhitelistConfigResponse:
        """
        @summary Modifies multiple alert whitelist rules of sensitive files that are detected by using the agentless detection feature at a time.
        
        @param request: BatchUpdateMaliciousFileWhitelistConfigRequest
        @return: BatchUpdateMaliciousFileWhitelistConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.batch_update_malicious_file_whitelist_config_with_options(request, runtime)

    async def batch_update_malicious_file_whitelist_config_async(
        self,
        request: sas_20181203_models.BatchUpdateMaliciousFileWhitelistConfigRequest,
    ) -> sas_20181203_models.BatchUpdateMaliciousFileWhitelistConfigResponse:
        """
        @summary Modifies multiple alert whitelist rules of sensitive files that are detected by using the agentless detection feature at a time.
        
        @param request: BatchUpdateMaliciousFileWhitelistConfigRequest
        @return: BatchUpdateMaliciousFileWhitelistConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.batch_update_malicious_file_whitelist_config_with_options_async(request, runtime)

    def bind_auth_to_machine_with_options(
        self,
        request: sas_20181203_models.BindAuthToMachineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.BindAuthToMachineResponse:
        """
        @summary Binds servers to Security Center or unbinds servers from Security Center.
        
        @param request: BindAuthToMachineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BindAuthToMachineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_version):
            query['AuthVersion'] = request.auth_version
        if not UtilClient.is_unset(request.auto_bind):
            query['AutoBind'] = request.auto_bind
        if not UtilClient.is_unset(request.bind):
            query['Bind'] = request.bind
        if not UtilClient.is_unset(request.bind_all):
            query['BindAll'] = request.bind_all
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.is_pre_bind):
            query['IsPreBind'] = request.is_pre_bind
        if not UtilClient.is_unset(request.logical_exp):
            query['LogicalExp'] = request.logical_exp
        if not UtilClient.is_unset(request.ntm_version):
            query['NtmVersion'] = request.ntm_version
        if not UtilClient.is_unset(request.pre_bind_order_id):
            query['PreBindOrderId'] = request.pre_bind_order_id
        if not UtilClient.is_unset(request.un_bind):
            query['UnBind'] = request.un_bind
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BindAuthToMachine',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.BindAuthToMachineResponse(),
            self.call_api(params, req, runtime)
        )

    async def bind_auth_to_machine_with_options_async(
        self,
        request: sas_20181203_models.BindAuthToMachineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.BindAuthToMachineResponse:
        """
        @summary Binds servers to Security Center or unbinds servers from Security Center.
        
        @param request: BindAuthToMachineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BindAuthToMachineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_version):
            query['AuthVersion'] = request.auth_version
        if not UtilClient.is_unset(request.auto_bind):
            query['AutoBind'] = request.auto_bind
        if not UtilClient.is_unset(request.bind):
            query['Bind'] = request.bind
        if not UtilClient.is_unset(request.bind_all):
            query['BindAll'] = request.bind_all
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.is_pre_bind):
            query['IsPreBind'] = request.is_pre_bind
        if not UtilClient.is_unset(request.logical_exp):
            query['LogicalExp'] = request.logical_exp
        if not UtilClient.is_unset(request.ntm_version):
            query['NtmVersion'] = request.ntm_version
        if not UtilClient.is_unset(request.pre_bind_order_id):
            query['PreBindOrderId'] = request.pre_bind_order_id
        if not UtilClient.is_unset(request.un_bind):
            query['UnBind'] = request.un_bind
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BindAuthToMachine',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.BindAuthToMachineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def bind_auth_to_machine(
        self,
        request: sas_20181203_models.BindAuthToMachineRequest,
    ) -> sas_20181203_models.BindAuthToMachineResponse:
        """
        @summary Binds servers to Security Center or unbinds servers from Security Center.
        
        @param request: BindAuthToMachineRequest
        @return: BindAuthToMachineResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.bind_auth_to_machine_with_options(request, runtime)

    async def bind_auth_to_machine_async(
        self,
        request: sas_20181203_models.BindAuthToMachineRequest,
    ) -> sas_20181203_models.BindAuthToMachineResponse:
        """
        @summary Binds servers to Security Center or unbinds servers from Security Center.
        
        @param request: BindAuthToMachineRequest
        @return: BindAuthToMachineResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.bind_auth_to_machine_with_options_async(request, runtime)

    def bind_hybrid_proxy_with_options(
        self,
        request: sas_20181203_models.BindHybridProxyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.BindHybridProxyResponse:
        """
        @summary Adds servers to Security Center over a proxy server. After you create a proxy cluster and deploy a proxy server, you can connect a server to the proxy cluster as a client. This way, the server is added to Security Center over the proxy server and is protected.
        
        @param request: BindHybridProxyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BindHybridProxyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.yundun_uuids):
            query['YundunUuids'] = request.yundun_uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BindHybridProxy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.BindHybridProxyResponse(),
            self.call_api(params, req, runtime)
        )

    async def bind_hybrid_proxy_with_options_async(
        self,
        request: sas_20181203_models.BindHybridProxyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.BindHybridProxyResponse:
        """
        @summary Adds servers to Security Center over a proxy server. After you create a proxy cluster and deploy a proxy server, you can connect a server to the proxy cluster as a client. This way, the server is added to Security Center over the proxy server and is protected.
        
        @param request: BindHybridProxyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BindHybridProxyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.yundun_uuids):
            query['YundunUuids'] = request.yundun_uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BindHybridProxy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.BindHybridProxyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def bind_hybrid_proxy(
        self,
        request: sas_20181203_models.BindHybridProxyRequest,
    ) -> sas_20181203_models.BindHybridProxyResponse:
        """
        @summary Adds servers to Security Center over a proxy server. After you create a proxy cluster and deploy a proxy server, you can connect a server to the proxy cluster as a client. This way, the server is added to Security Center over the proxy server and is protected.
        
        @param request: BindHybridProxyRequest
        @return: BindHybridProxyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.bind_hybrid_proxy_with_options(request, runtime)

    async def bind_hybrid_proxy_async(
        self,
        request: sas_20181203_models.BindHybridProxyRequest,
    ) -> sas_20181203_models.BindHybridProxyResponse:
        """
        @summary Adds servers to Security Center over a proxy server. After you create a proxy cluster and deploy a proxy server, you can connect a server to the proxy cluster as a client. This way, the server is added to Security Center over the proxy server and is protected.
        
        @param request: BindHybridProxyRequest
        @return: BindHybridProxyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.bind_hybrid_proxy_with_options_async(request, runtime)

    def cancel_once_task_with_options(
        self,
        request: sas_20181203_models.CancelOnceTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CancelOnceTaskResponse:
        """
        @summary Cancels the main task.
        
        @param request: CancelOnceTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelOnceTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelOnceTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CancelOnceTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_once_task_with_options_async(
        self,
        request: sas_20181203_models.CancelOnceTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CancelOnceTaskResponse:
        """
        @summary Cancels the main task.
        
        @param request: CancelOnceTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelOnceTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelOnceTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CancelOnceTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_once_task(
        self,
        request: sas_20181203_models.CancelOnceTaskRequest,
    ) -> sas_20181203_models.CancelOnceTaskResponse:
        """
        @summary Cancels the main task.
        
        @param request: CancelOnceTaskRequest
        @return: CancelOnceTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_once_task_with_options(request, runtime)

    async def cancel_once_task_async(
        self,
        request: sas_20181203_models.CancelOnceTaskRequest,
    ) -> sas_20181203_models.CancelOnceTaskResponse:
        """
        @summary Cancels the main task.
        
        @param request: CancelOnceTaskRequest
        @return: CancelOnceTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_once_task_with_options_async(request, runtime)

    def change_asset_refresh_task_config_with_options(
        self,
        request: sas_20181203_models.ChangeAssetRefreshTaskConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ChangeAssetRefreshTaskConfigResponse:
        """
        @summary Modifies the interval of asset synchronization configurations.
        
        @param request: ChangeAssetRefreshTaskConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ChangeAssetRefreshTaskConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.asset_refresh_configs):
            query['AssetRefreshConfigs'] = request.asset_refresh_configs
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ChangeAssetRefreshTaskConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ChangeAssetRefreshTaskConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def change_asset_refresh_task_config_with_options_async(
        self,
        request: sas_20181203_models.ChangeAssetRefreshTaskConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ChangeAssetRefreshTaskConfigResponse:
        """
        @summary Modifies the interval of asset synchronization configurations.
        
        @param request: ChangeAssetRefreshTaskConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ChangeAssetRefreshTaskConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.asset_refresh_configs):
            query['AssetRefreshConfigs'] = request.asset_refresh_configs
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ChangeAssetRefreshTaskConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ChangeAssetRefreshTaskConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def change_asset_refresh_task_config(
        self,
        request: sas_20181203_models.ChangeAssetRefreshTaskConfigRequest,
    ) -> sas_20181203_models.ChangeAssetRefreshTaskConfigResponse:
        """
        @summary Modifies the interval of asset synchronization configurations.
        
        @param request: ChangeAssetRefreshTaskConfigRequest
        @return: ChangeAssetRefreshTaskConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.change_asset_refresh_task_config_with_options(request, runtime)

    async def change_asset_refresh_task_config_async(
        self,
        request: sas_20181203_models.ChangeAssetRefreshTaskConfigRequest,
    ) -> sas_20181203_models.ChangeAssetRefreshTaskConfigResponse:
        """
        @summary Modifies the interval of asset synchronization configurations.
        
        @param request: ChangeAssetRefreshTaskConfigRequest
        @return: ChangeAssetRefreshTaskConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.change_asset_refresh_task_config_with_options_async(request, runtime)

    def change_check_config_with_options(
        self,
        tmp_req: sas_20181203_models.ChangeCheckConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ChangeCheckConfigResponse:
        """
        @summary Modifies the configuration items of the configuration assessment feature.
        
        @param tmp_req: ChangeCheckConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ChangeCheckConfigResponse
        """
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.ChangeCheckConfigShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.config_requirement_ids):
            request.config_requirement_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.config_requirement_ids, 'ConfigRequirementIds', 'json')
        if not UtilClient.is_unset(tmp_req.config_standard_ids):
            request.config_standard_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.config_standard_ids, 'ConfigStandardIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.added_check):
            query['AddedCheck'] = request.added_check
        if not UtilClient.is_unset(request.config_requirement_ids_shrink):
            query['ConfigRequirementIds'] = request.config_requirement_ids_shrink
        if not UtilClient.is_unset(request.config_standard_ids_shrink):
            query['ConfigStandardIds'] = request.config_standard_ids_shrink
        if not UtilClient.is_unset(request.configure):
            query['Configure'] = request.configure
        if not UtilClient.is_unset(request.cycle_days):
            query['CycleDays'] = request.cycle_days
        if not UtilClient.is_unset(request.enable_add_check):
            query['EnableAddCheck'] = request.enable_add_check
        if not UtilClient.is_unset(request.enable_auto_check):
            query['EnableAutoCheck'] = request.enable_auto_check
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.removed_check):
            query['RemovedCheck'] = request.removed_check
        if not UtilClient.is_unset(request.standard_ids):
            query['StandardIds'] = request.standard_ids
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.system_config):
            query['SystemConfig'] = request.system_config
        if not UtilClient.is_unset(request.vendors):
            query['Vendors'] = request.vendors
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ChangeCheckConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ChangeCheckConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def change_check_config_with_options_async(
        self,
        tmp_req: sas_20181203_models.ChangeCheckConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ChangeCheckConfigResponse:
        """
        @summary Modifies the configuration items of the configuration assessment feature.
        
        @param tmp_req: ChangeCheckConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ChangeCheckConfigResponse
        """
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.ChangeCheckConfigShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.config_requirement_ids):
            request.config_requirement_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.config_requirement_ids, 'ConfigRequirementIds', 'json')
        if not UtilClient.is_unset(tmp_req.config_standard_ids):
            request.config_standard_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.config_standard_ids, 'ConfigStandardIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.added_check):
            query['AddedCheck'] = request.added_check
        if not UtilClient.is_unset(request.config_requirement_ids_shrink):
            query['ConfigRequirementIds'] = request.config_requirement_ids_shrink
        if not UtilClient.is_unset(request.config_standard_ids_shrink):
            query['ConfigStandardIds'] = request.config_standard_ids_shrink
        if not UtilClient.is_unset(request.configure):
            query['Configure'] = request.configure
        if not UtilClient.is_unset(request.cycle_days):
            query['CycleDays'] = request.cycle_days
        if not UtilClient.is_unset(request.enable_add_check):
            query['EnableAddCheck'] = request.enable_add_check
        if not UtilClient.is_unset(request.enable_auto_check):
            query['EnableAutoCheck'] = request.enable_auto_check
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.removed_check):
            query['RemovedCheck'] = request.removed_check
        if not UtilClient.is_unset(request.standard_ids):
            query['StandardIds'] = request.standard_ids
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.system_config):
            query['SystemConfig'] = request.system_config
        if not UtilClient.is_unset(request.vendors):
            query['Vendors'] = request.vendors
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ChangeCheckConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ChangeCheckConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def change_check_config(
        self,
        request: sas_20181203_models.ChangeCheckConfigRequest,
    ) -> sas_20181203_models.ChangeCheckConfigResponse:
        """
        @summary Modifies the configuration items of the configuration assessment feature.
        
        @param request: ChangeCheckConfigRequest
        @return: ChangeCheckConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.change_check_config_with_options(request, runtime)

    async def change_check_config_async(
        self,
        request: sas_20181203_models.ChangeCheckConfigRequest,
    ) -> sas_20181203_models.ChangeCheckConfigResponse:
        """
        @summary Modifies the configuration items of the configuration assessment feature.
        
        @param request: ChangeCheckConfigRequest
        @return: ChangeCheckConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.change_check_config_with_options_async(request, runtime)

    def change_check_custom_config_with_options(
        self,
        request: sas_20181203_models.ChangeCheckCustomConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ChangeCheckCustomConfigResponse:
        """
        @summary Modifies the custom configuration items of a check item.
        
        @param request: ChangeCheckCustomConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ChangeCheckCustomConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_id):
            query['CheckId'] = request.check_id
        if not UtilClient.is_unset(request.custom_configs):
            query['CustomConfigs'] = request.custom_configs
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.repair_configs):
            query['RepairConfigs'] = request.repair_configs
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ChangeCheckCustomConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ChangeCheckCustomConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def change_check_custom_config_with_options_async(
        self,
        request: sas_20181203_models.ChangeCheckCustomConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ChangeCheckCustomConfigResponse:
        """
        @summary Modifies the custom configuration items of a check item.
        
        @param request: ChangeCheckCustomConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ChangeCheckCustomConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_id):
            query['CheckId'] = request.check_id
        if not UtilClient.is_unset(request.custom_configs):
            query['CustomConfigs'] = request.custom_configs
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.repair_configs):
            query['RepairConfigs'] = request.repair_configs
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ChangeCheckCustomConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ChangeCheckCustomConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def change_check_custom_config(
        self,
        request: sas_20181203_models.ChangeCheckCustomConfigRequest,
    ) -> sas_20181203_models.ChangeCheckCustomConfigResponse:
        """
        @summary Modifies the custom configuration items of a check item.
        
        @param request: ChangeCheckCustomConfigRequest
        @return: ChangeCheckCustomConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.change_check_custom_config_with_options(request, runtime)

    async def change_check_custom_config_async(
        self,
        request: sas_20181203_models.ChangeCheckCustomConfigRequest,
    ) -> sas_20181203_models.ChangeCheckCustomConfigResponse:
        """
        @summary Modifies the custom configuration items of a check item.
        
        @param request: ChangeCheckCustomConfigRequest
        @return: ChangeCheckCustomConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.change_check_custom_config_with_options_async(request, runtime)

    def change_security_score_rule_with_options(
        self,
        request: sas_20181203_models.ChangeSecurityScoreRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ChangeSecurityScoreRuleResponse:
        """
        @summary Modifies the details of the deduction modules of the security score feature, including custom settings.
        
        @param request: ChangeSecurityScoreRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ChangeSecurityScoreRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cal_type):
            query['CalType'] = request.cal_type
        if not UtilClient.is_unset(request.reset_security_score_rule):
            query['ResetSecurityScoreRule'] = request.reset_security_score_rule
        if not UtilClient.is_unset(request.security_score_category_list):
            query['SecurityScoreCategoryList'] = request.security_score_category_list
        if not UtilClient.is_unset(request.security_score_rule_list):
            query['SecurityScoreRuleList'] = request.security_score_rule_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ChangeSecurityScoreRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ChangeSecurityScoreRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def change_security_score_rule_with_options_async(
        self,
        request: sas_20181203_models.ChangeSecurityScoreRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ChangeSecurityScoreRuleResponse:
        """
        @summary Modifies the details of the deduction modules of the security score feature, including custom settings.
        
        @param request: ChangeSecurityScoreRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ChangeSecurityScoreRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cal_type):
            query['CalType'] = request.cal_type
        if not UtilClient.is_unset(request.reset_security_score_rule):
            query['ResetSecurityScoreRule'] = request.reset_security_score_rule
        if not UtilClient.is_unset(request.security_score_category_list):
            query['SecurityScoreCategoryList'] = request.security_score_category_list
        if not UtilClient.is_unset(request.security_score_rule_list):
            query['SecurityScoreRuleList'] = request.security_score_rule_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ChangeSecurityScoreRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ChangeSecurityScoreRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def change_security_score_rule(
        self,
        request: sas_20181203_models.ChangeSecurityScoreRuleRequest,
    ) -> sas_20181203_models.ChangeSecurityScoreRuleResponse:
        """
        @summary Modifies the details of the deduction modules of the security score feature, including custom settings.
        
        @param request: ChangeSecurityScoreRuleRequest
        @return: ChangeSecurityScoreRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.change_security_score_rule_with_options(request, runtime)

    async def change_security_score_rule_async(
        self,
        request: sas_20181203_models.ChangeSecurityScoreRuleRequest,
    ) -> sas_20181203_models.ChangeSecurityScoreRuleResponse:
        """
        @summary Modifies the details of the deduction modules of the security score feature, including custom settings.
        
        @param request: ChangeSecurityScoreRuleRequest
        @return: ChangeSecurityScoreRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.change_security_score_rule_with_options_async(request, runtime)

    def change_user_lang_with_options(
        self,
        request: sas_20181203_models.ChangeUserLangRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ChangeUserLangResponse:
        """
        @summary Modifies the language settings of log analysis. The modification on the language settings takes effect within 12 hours and affects only the language of the descriptions for security events in security logs.
        
        @param request: ChangeUserLangRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ChangeUserLangResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.user_lang):
            query['UserLang'] = request.user_lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ChangeUserLang',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ChangeUserLangResponse(),
            self.call_api(params, req, runtime)
        )

    async def change_user_lang_with_options_async(
        self,
        request: sas_20181203_models.ChangeUserLangRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ChangeUserLangResponse:
        """
        @summary Modifies the language settings of log analysis. The modification on the language settings takes effect within 12 hours and affects only the language of the descriptions for security events in security logs.
        
        @param request: ChangeUserLangRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ChangeUserLangResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.user_lang):
            query['UserLang'] = request.user_lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ChangeUserLang',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ChangeUserLangResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def change_user_lang(
        self,
        request: sas_20181203_models.ChangeUserLangRequest,
    ) -> sas_20181203_models.ChangeUserLangResponse:
        """
        @summary Modifies the language settings of log analysis. The modification on the language settings takes effect within 12 hours and affects only the language of the descriptions for security events in security logs.
        
        @param request: ChangeUserLangRequest
        @return: ChangeUserLangResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.change_user_lang_with_options(request, runtime)

    async def change_user_lang_async(
        self,
        request: sas_20181203_models.ChangeUserLangRequest,
    ) -> sas_20181203_models.ChangeUserLangResponse:
        """
        @summary Modifies the language settings of log analysis. The modification on the language settings takes effect within 12 hours and affects only the language of the descriptions for security events in security logs.
        
        @param request: ChangeUserLangRequest
        @return: ChangeUserLangResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.change_user_lang_with_options_async(request, runtime)

    def check_security_event_id_with_options(
        self,
        request: sas_20181203_models.CheckSecurityEventIdRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CheckSecurityEventIdResponse:
        """
        @summary Checks whether one or more alert events are generated on a specified server based on the IDs of the alert events.
        
        @param request: CheckSecurityEventIdRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckSecurityEventIdResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.security_event_ids):
            query['SecurityEventIds'] = request.security_event_ids
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckSecurityEventId',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CheckSecurityEventIdResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_security_event_id_with_options_async(
        self,
        request: sas_20181203_models.CheckSecurityEventIdRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CheckSecurityEventIdResponse:
        """
        @summary Checks whether one or more alert events are generated on a specified server based on the IDs of the alert events.
        
        @param request: CheckSecurityEventIdRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckSecurityEventIdResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.security_event_ids):
            query['SecurityEventIds'] = request.security_event_ids
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckSecurityEventId',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CheckSecurityEventIdResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_security_event_id(
        self,
        request: sas_20181203_models.CheckSecurityEventIdRequest,
    ) -> sas_20181203_models.CheckSecurityEventIdResponse:
        """
        @summary Checks whether one or more alert events are generated on a specified server based on the IDs of the alert events.
        
        @param request: CheckSecurityEventIdRequest
        @return: CheckSecurityEventIdResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.check_security_event_id_with_options(request, runtime)

    async def check_security_event_id_async(
        self,
        request: sas_20181203_models.CheckSecurityEventIdRequest,
    ) -> sas_20181203_models.CheckSecurityEventIdResponse:
        """
        @summary Checks whether one or more alert events are generated on a specified server based on the IDs of the alert events.
        
        @param request: CheckSecurityEventIdRequest
        @return: CheckSecurityEventIdResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.check_security_event_id_with_options_async(request, runtime)

    def check_sts_token_auth_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CheckStsTokenAuthResponse:
        """
        @summary Checks a Security Token Service (STS) token and returns the ID of the Alibaba Cloud account.
        
        @param request: CheckStsTokenAuthRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckStsTokenAuthResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='CheckStsTokenAuth',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CheckStsTokenAuthResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_sts_token_auth_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CheckStsTokenAuthResponse:
        """
        @summary Checks a Security Token Service (STS) token and returns the ID of the Alibaba Cloud account.
        
        @param request: CheckStsTokenAuthRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckStsTokenAuthResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='CheckStsTokenAuth',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CheckStsTokenAuthResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_sts_token_auth(self) -> sas_20181203_models.CheckStsTokenAuthResponse:
        """
        @summary Checks a Security Token Service (STS) token and returns the ID of the Alibaba Cloud account.
        
        @return: CheckStsTokenAuthResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.check_sts_token_auth_with_options(runtime)

    async def check_sts_token_auth_async(self) -> sas_20181203_models.CheckStsTokenAuthResponse:
        """
        @summary Checks a Security Token Service (STS) token and returns the ID of the Alibaba Cloud account.
        
        @return: CheckStsTokenAuthResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.check_sts_token_auth_with_options_async(runtime)

    def check_trial_fix_count_with_options(
        self,
        request: sas_20181203_models.CheckTrialFixCountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CheckTrialFixCountResponse:
        """
        @summary Checks whether the remaining quota of the vulnerability fixing feature is sufficient for a free trial user of Security Center and queries the quota usage required for the current fix operation.
        
        @description You can call this operation to check whether the remaining quota of the vulnerability fixing feature is sufficient in free trial scenarios. This operation does not trigger vulnerability fixing.
        
        @param request: CheckTrialFixCountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckTrialFixCountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.info):
            query['Info'] = request.info
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        if not UtilClient.is_unset(request.vul_names):
            query['VulNames'] = request.vul_names
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckTrialFixCount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CheckTrialFixCountResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_trial_fix_count_with_options_async(
        self,
        request: sas_20181203_models.CheckTrialFixCountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CheckTrialFixCountResponse:
        """
        @summary Checks whether the remaining quota of the vulnerability fixing feature is sufficient for a free trial user of Security Center and queries the quota usage required for the current fix operation.
        
        @description You can call this operation to check whether the remaining quota of the vulnerability fixing feature is sufficient in free trial scenarios. This operation does not trigger vulnerability fixing.
        
        @param request: CheckTrialFixCountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckTrialFixCountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.info):
            query['Info'] = request.info
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        if not UtilClient.is_unset(request.vul_names):
            query['VulNames'] = request.vul_names
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckTrialFixCount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CheckTrialFixCountResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_trial_fix_count(
        self,
        request: sas_20181203_models.CheckTrialFixCountRequest,
    ) -> sas_20181203_models.CheckTrialFixCountResponse:
        """
        @summary Checks whether the remaining quota of the vulnerability fixing feature is sufficient for a free trial user of Security Center and queries the quota usage required for the current fix operation.
        
        @description You can call this operation to check whether the remaining quota of the vulnerability fixing feature is sufficient in free trial scenarios. This operation does not trigger vulnerability fixing.
        
        @param request: CheckTrialFixCountRequest
        @return: CheckTrialFixCountResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.check_trial_fix_count_with_options(request, runtime)

    async def check_trial_fix_count_async(
        self,
        request: sas_20181203_models.CheckTrialFixCountRequest,
    ) -> sas_20181203_models.CheckTrialFixCountResponse:
        """
        @summary Checks whether the remaining quota of the vulnerability fixing feature is sufficient for a free trial user of Security Center and queries the quota usage required for the current fix operation.
        
        @description You can call this operation to check whether the remaining quota of the vulnerability fixing feature is sufficient in free trial scenarios. This operation does not trigger vulnerability fixing.
        
        @param request: CheckTrialFixCountRequest
        @return: CheckTrialFixCountResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.check_trial_fix_count_with_options_async(request, runtime)

    def check_user_has_ecs_with_options(
        self,
        request: sas_20181203_models.CheckUserHasEcsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CheckUserHasEcsResponse:
        """
        @summary Checks whether Elastic Compute Service (ECS) instances exist.
        
        @param request: CheckUserHasEcsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckUserHasEcsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckUserHasEcs',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CheckUserHasEcsResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_user_has_ecs_with_options_async(
        self,
        request: sas_20181203_models.CheckUserHasEcsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CheckUserHasEcsResponse:
        """
        @summary Checks whether Elastic Compute Service (ECS) instances exist.
        
        @param request: CheckUserHasEcsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CheckUserHasEcsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckUserHasEcs',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CheckUserHasEcsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_user_has_ecs(
        self,
        request: sas_20181203_models.CheckUserHasEcsRequest,
    ) -> sas_20181203_models.CheckUserHasEcsResponse:
        """
        @summary Checks whether Elastic Compute Service (ECS) instances exist.
        
        @param request: CheckUserHasEcsRequest
        @return: CheckUserHasEcsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.check_user_has_ecs_with_options(request, runtime)

    async def check_user_has_ecs_async(
        self,
        request: sas_20181203_models.CheckUserHasEcsRequest,
    ) -> sas_20181203_models.CheckUserHasEcsResponse:
        """
        @summary Checks whether Elastic Compute Service (ECS) instances exist.
        
        @param request: CheckUserHasEcsRequest
        @return: CheckUserHasEcsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.check_user_has_ecs_with_options_async(request, runtime)

    def confirm_virus_events_with_options(
        self,
        request: sas_20181203_models.ConfirmVirusEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ConfirmVirusEventsResponse:
        """
        @summary Confirms the alert events that you want to handle.
        
        @param request: ConfirmVirusEventsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ConfirmVirusEventsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.operation_all):
            query['OperationAll'] = request.operation_all
        if not UtilClient.is_unset(request.operation_code):
            query['OperationCode'] = request.operation_code
        if not UtilClient.is_unset(request.operation_range):
            query['OperationRange'] = request.operation_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConfirmVirusEvents',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ConfirmVirusEventsResponse(),
            self.call_api(params, req, runtime)
        )

    async def confirm_virus_events_with_options_async(
        self,
        request: sas_20181203_models.ConfirmVirusEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ConfirmVirusEventsResponse:
        """
        @summary Confirms the alert events that you want to handle.
        
        @param request: ConfirmVirusEventsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ConfirmVirusEventsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.operation_all):
            query['OperationAll'] = request.operation_all
        if not UtilClient.is_unset(request.operation_code):
            query['OperationCode'] = request.operation_code
        if not UtilClient.is_unset(request.operation_range):
            query['OperationRange'] = request.operation_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConfirmVirusEvents',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ConfirmVirusEventsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def confirm_virus_events(
        self,
        request: sas_20181203_models.ConfirmVirusEventsRequest,
    ) -> sas_20181203_models.ConfirmVirusEventsResponse:
        """
        @summary Confirms the alert events that you want to handle.
        
        @param request: ConfirmVirusEventsRequest
        @return: ConfirmVirusEventsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.confirm_virus_events_with_options(request, runtime)

    async def confirm_virus_events_async(
        self,
        request: sas_20181203_models.ConfirmVirusEventsRequest,
    ) -> sas_20181203_models.ConfirmVirusEventsResponse:
        """
        @summary Confirms the alert events that you want to handle.
        
        @param request: ConfirmVirusEventsRequest
        @return: ConfirmVirusEventsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.confirm_virus_events_with_options_async(request, runtime)

    def copy_customize_report_config_with_options(
        self,
        request: sas_20181203_models.CopyCustomizeReportConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CopyCustomizeReportConfigResponse:
        """
        @summary Clones an existing security report. The new security report has the same configuration as the existing security report.
        
        @param request: CopyCustomizeReportConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopyCustomizeReportConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.report_id):
            query['ReportId'] = request.report_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopyCustomizeReportConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CopyCustomizeReportConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def copy_customize_report_config_with_options_async(
        self,
        request: sas_20181203_models.CopyCustomizeReportConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CopyCustomizeReportConfigResponse:
        """
        @summary Clones an existing security report. The new security report has the same configuration as the existing security report.
        
        @param request: CopyCustomizeReportConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopyCustomizeReportConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.report_id):
            query['ReportId'] = request.report_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopyCustomizeReportConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CopyCustomizeReportConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def copy_customize_report_config(
        self,
        request: sas_20181203_models.CopyCustomizeReportConfigRequest,
    ) -> sas_20181203_models.CopyCustomizeReportConfigResponse:
        """
        @summary Clones an existing security report. The new security report has the same configuration as the existing security report.
        
        @param request: CopyCustomizeReportConfigRequest
        @return: CopyCustomizeReportConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.copy_customize_report_config_with_options(request, runtime)

    async def copy_customize_report_config_async(
        self,
        request: sas_20181203_models.CopyCustomizeReportConfigRequest,
    ) -> sas_20181203_models.CopyCustomizeReportConfigResponse:
        """
        @summary Clones an existing security report. The new security report has the same configuration as the existing security report.
        
        @param request: CopyCustomizeReportConfigRequest
        @return: CopyCustomizeReportConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.copy_customize_report_config_with_options_async(request, runtime)

    def create_agentless_scan_task_with_options(
        self,
        request: sas_20181203_models.CreateAgentlessScanTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateAgentlessScanTaskResponse:
        """
        @summary Creates an agentless detection task.
        
        @param request: CreateAgentlessScanTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAgentlessScanTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.asset_selection_type):
            query['AssetSelectionType'] = request.asset_selection_type
        if not UtilClient.is_unset(request.auto_delete_days):
            query['AutoDeleteDays'] = request.auto_delete_days
        if not UtilClient.is_unset(request.release_after_scan):
            query['ReleaseAfterScan'] = request.release_after_scan
        if not UtilClient.is_unset(request.scan_data_disk):
            query['ScanDataDisk'] = request.scan_data_disk
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAgentlessScanTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateAgentlessScanTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_agentless_scan_task_with_options_async(
        self,
        request: sas_20181203_models.CreateAgentlessScanTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateAgentlessScanTaskResponse:
        """
        @summary Creates an agentless detection task.
        
        @param request: CreateAgentlessScanTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAgentlessScanTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.asset_selection_type):
            query['AssetSelectionType'] = request.asset_selection_type
        if not UtilClient.is_unset(request.auto_delete_days):
            query['AutoDeleteDays'] = request.auto_delete_days
        if not UtilClient.is_unset(request.release_after_scan):
            query['ReleaseAfterScan'] = request.release_after_scan
        if not UtilClient.is_unset(request.scan_data_disk):
            query['ScanDataDisk'] = request.scan_data_disk
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAgentlessScanTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateAgentlessScanTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_agentless_scan_task(
        self,
        request: sas_20181203_models.CreateAgentlessScanTaskRequest,
    ) -> sas_20181203_models.CreateAgentlessScanTaskResponse:
        """
        @summary Creates an agentless detection task.
        
        @param request: CreateAgentlessScanTaskRequest
        @return: CreateAgentlessScanTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_agentless_scan_task_with_options(request, runtime)

    async def create_agentless_scan_task_async(
        self,
        request: sas_20181203_models.CreateAgentlessScanTaskRequest,
    ) -> sas_20181203_models.CreateAgentlessScanTaskResponse:
        """
        @summary Creates an agentless detection task.
        
        @param request: CreateAgentlessScanTaskRequest
        @return: CreateAgentlessScanTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_agentless_scan_task_with_options_async(request, runtime)

    def create_anti_brute_force_rule_with_options(
        self,
        tmp_req: sas_20181203_models.CreateAntiBruteForceRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateAntiBruteForceRuleResponse:
        """
        @summary Creates a defense rule against brute-force attacks.
        
        @param tmp_req: CreateAntiBruteForceRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAntiBruteForceRuleResponse
        """
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.CreateAntiBruteForceRuleShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.protocol_type):
            request.protocol_type_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.protocol_type, 'ProtocolType', 'json')
        query = {}
        if not UtilClient.is_unset(request.default_rule):
            query['DefaultRule'] = request.default_rule
        if not UtilClient.is_unset(request.fail_count):
            query['FailCount'] = request.fail_count
        if not UtilClient.is_unset(request.forbidden_time):
            query['ForbiddenTime'] = request.forbidden_time
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.protocol_type_shrink):
            query['ProtocolType'] = request.protocol_type_shrink
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.span):
            query['Span'] = request.span
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAntiBruteForceRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateAntiBruteForceRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_anti_brute_force_rule_with_options_async(
        self,
        tmp_req: sas_20181203_models.CreateAntiBruteForceRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateAntiBruteForceRuleResponse:
        """
        @summary Creates a defense rule against brute-force attacks.
        
        @param tmp_req: CreateAntiBruteForceRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAntiBruteForceRuleResponse
        """
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.CreateAntiBruteForceRuleShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.protocol_type):
            request.protocol_type_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.protocol_type, 'ProtocolType', 'json')
        query = {}
        if not UtilClient.is_unset(request.default_rule):
            query['DefaultRule'] = request.default_rule
        if not UtilClient.is_unset(request.fail_count):
            query['FailCount'] = request.fail_count
        if not UtilClient.is_unset(request.forbidden_time):
            query['ForbiddenTime'] = request.forbidden_time
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.protocol_type_shrink):
            query['ProtocolType'] = request.protocol_type_shrink
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.span):
            query['Span'] = request.span
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAntiBruteForceRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateAntiBruteForceRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_anti_brute_force_rule(
        self,
        request: sas_20181203_models.CreateAntiBruteForceRuleRequest,
    ) -> sas_20181203_models.CreateAntiBruteForceRuleResponse:
        """
        @summary Creates a defense rule against brute-force attacks.
        
        @param request: CreateAntiBruteForceRuleRequest
        @return: CreateAntiBruteForceRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_anti_brute_force_rule_with_options(request, runtime)

    async def create_anti_brute_force_rule_async(
        self,
        request: sas_20181203_models.CreateAntiBruteForceRuleRequest,
    ) -> sas_20181203_models.CreateAntiBruteForceRuleResponse:
        """
        @summary Creates a defense rule against brute-force attacks.
        
        @param request: CreateAntiBruteForceRuleRequest
        @return: CreateAntiBruteForceRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_anti_brute_force_rule_with_options_async(request, runtime)

    def create_asset_selection_config_with_options(
        self,
        request: sas_20181203_models.CreateAssetSelectionConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateAssetSelectionConfigResponse:
        """
        @summary Create asset selection configurations.
        
        @param request: CreateAssetSelectionConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAssetSelectionConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.business_type):
            query['BusinessType'] = request.business_type
        if not UtilClient.is_unset(request.platform):
            query['Platform'] = request.platform
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAssetSelectionConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateAssetSelectionConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_asset_selection_config_with_options_async(
        self,
        request: sas_20181203_models.CreateAssetSelectionConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateAssetSelectionConfigResponse:
        """
        @summary Create asset selection configurations.
        
        @param request: CreateAssetSelectionConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAssetSelectionConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.business_type):
            query['BusinessType'] = request.business_type
        if not UtilClient.is_unset(request.platform):
            query['Platform'] = request.platform
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAssetSelectionConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateAssetSelectionConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_asset_selection_config(
        self,
        request: sas_20181203_models.CreateAssetSelectionConfigRequest,
    ) -> sas_20181203_models.CreateAssetSelectionConfigResponse:
        """
        @summary Create asset selection configurations.
        
        @param request: CreateAssetSelectionConfigRequest
        @return: CreateAssetSelectionConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_asset_selection_config_with_options(request, runtime)

    async def create_asset_selection_config_async(
        self,
        request: sas_20181203_models.CreateAssetSelectionConfigRequest,
    ) -> sas_20181203_models.CreateAssetSelectionConfigResponse:
        """
        @summary Create asset selection configurations.
        
        @param request: CreateAssetSelectionConfigRequest
        @return: CreateAssetSelectionConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_asset_selection_config_with_options_async(request, runtime)

    def create_attack_path_sensitive_asset_config_with_options(
        self,
        request: sas_20181203_models.CreateAttackPathSensitiveAssetConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateAttackPathSensitiveAssetConfigResponse:
        """
        @summary Create attack path sensitive asset configuration.
        
        @param request: CreateAttackPathSensitiveAssetConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAttackPathSensitiveAssetConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attack_path_asset_list):
            query['AttackPathAssetList'] = request.attack_path_asset_list
        if not UtilClient.is_unset(request.config_type):
            query['ConfigType'] = request.config_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAttackPathSensitiveAssetConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateAttackPathSensitiveAssetConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_attack_path_sensitive_asset_config_with_options_async(
        self,
        request: sas_20181203_models.CreateAttackPathSensitiveAssetConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateAttackPathSensitiveAssetConfigResponse:
        """
        @summary Create attack path sensitive asset configuration.
        
        @param request: CreateAttackPathSensitiveAssetConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAttackPathSensitiveAssetConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attack_path_asset_list):
            query['AttackPathAssetList'] = request.attack_path_asset_list
        if not UtilClient.is_unset(request.config_type):
            query['ConfigType'] = request.config_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAttackPathSensitiveAssetConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateAttackPathSensitiveAssetConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_attack_path_sensitive_asset_config(
        self,
        request: sas_20181203_models.CreateAttackPathSensitiveAssetConfigRequest,
    ) -> sas_20181203_models.CreateAttackPathSensitiveAssetConfigResponse:
        """
        @summary Create attack path sensitive asset configuration.
        
        @param request: CreateAttackPathSensitiveAssetConfigRequest
        @return: CreateAttackPathSensitiveAssetConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_attack_path_sensitive_asset_config_with_options(request, runtime)

    async def create_attack_path_sensitive_asset_config_async(
        self,
        request: sas_20181203_models.CreateAttackPathSensitiveAssetConfigRequest,
    ) -> sas_20181203_models.CreateAttackPathSensitiveAssetConfigResponse:
        """
        @summary Create attack path sensitive asset configuration.
        
        @param request: CreateAttackPathSensitiveAssetConfigRequest
        @return: CreateAttackPathSensitiveAssetConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_attack_path_sensitive_asset_config_with_options_async(request, runtime)

    def create_attack_path_whitelist_with_options(
        self,
        request: sas_20181203_models.CreateAttackPathWhitelistRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateAttackPathWhitelistResponse:
        """
        @summary Create Attack Path Whitelist.
        
        @param request: CreateAttackPathWhitelistRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAttackPathWhitelistResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attack_path_asset_list):
            query['AttackPathAssetList'] = request.attack_path_asset_list
        if not UtilClient.is_unset(request.path_name):
            query['PathName'] = request.path_name
        if not UtilClient.is_unset(request.path_type):
            query['PathType'] = request.path_type
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.whitelist_name):
            query['WhitelistName'] = request.whitelist_name
        if not UtilClient.is_unset(request.whitelist_type):
            query['WhitelistType'] = request.whitelist_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAttackPathWhitelist',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateAttackPathWhitelistResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_attack_path_whitelist_with_options_async(
        self,
        request: sas_20181203_models.CreateAttackPathWhitelistRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateAttackPathWhitelistResponse:
        """
        @summary Create Attack Path Whitelist.
        
        @param request: CreateAttackPathWhitelistRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAttackPathWhitelistResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attack_path_asset_list):
            query['AttackPathAssetList'] = request.attack_path_asset_list
        if not UtilClient.is_unset(request.path_name):
            query['PathName'] = request.path_name
        if not UtilClient.is_unset(request.path_type):
            query['PathType'] = request.path_type
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.whitelist_name):
            query['WhitelistName'] = request.whitelist_name
        if not UtilClient.is_unset(request.whitelist_type):
            query['WhitelistType'] = request.whitelist_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAttackPathWhitelist',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateAttackPathWhitelistResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_attack_path_whitelist(
        self,
        request: sas_20181203_models.CreateAttackPathWhitelistRequest,
    ) -> sas_20181203_models.CreateAttackPathWhitelistResponse:
        """
        @summary Create Attack Path Whitelist.
        
        @param request: CreateAttackPathWhitelistRequest
        @return: CreateAttackPathWhitelistResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_attack_path_whitelist_with_options(request, runtime)

    async def create_attack_path_whitelist_async(
        self,
        request: sas_20181203_models.CreateAttackPathWhitelistRequest,
    ) -> sas_20181203_models.CreateAttackPathWhitelistResponse:
        """
        @summary Create Attack Path Whitelist.
        
        @param request: CreateAttackPathWhitelistRequest
        @return: CreateAttackPathWhitelistResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_attack_path_whitelist_with_options_async(request, runtime)

    def create_attestor_with_options(
        self,
        request: sas_20181203_models.CreateAttestorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateAttestorResponse:
        """
        @summary Creates a witness.
        
        @param request: CreateAttestorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAttestorResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.key_id):
            query['KeyId'] = request.key_id
        if not UtilClient.is_unset(request.key_region_id):
            query['KeyRegionId'] = request.key_region_id
        if not UtilClient.is_unset(request.key_version_id):
            query['KeyVersionId'] = request.key_version_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAttestor',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateAttestorResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_attestor_with_options_async(
        self,
        request: sas_20181203_models.CreateAttestorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateAttestorResponse:
        """
        @summary Creates a witness.
        
        @param request: CreateAttestorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAttestorResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.key_id):
            query['KeyId'] = request.key_id
        if not UtilClient.is_unset(request.key_region_id):
            query['KeyRegionId'] = request.key_region_id
        if not UtilClient.is_unset(request.key_version_id):
            query['KeyVersionId'] = request.key_version_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAttestor',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateAttestorResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_attestor(
        self,
        request: sas_20181203_models.CreateAttestorRequest,
    ) -> sas_20181203_models.CreateAttestorResponse:
        """
        @summary Creates a witness.
        
        @param request: CreateAttestorRequest
        @return: CreateAttestorResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_attestor_with_options(request, runtime)

    async def create_attestor_async(
        self,
        request: sas_20181203_models.CreateAttestorRequest,
    ) -> sas_20181203_models.CreateAttestorResponse:
        """
        @summary Creates a witness.
        
        @param request: CreateAttestorRequest
        @return: CreateAttestorResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_attestor_with_options_async(request, runtime)

    def create_backup_policy_with_options(
        self,
        tmp_req: sas_20181203_models.CreateBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateBackupPolicyResponse:
        """
        @summary Creates an anti-ransomware policy for servers.
        
        @param tmp_req: CreateBackupPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateBackupPolicyResponse
        """
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.CreateBackupPolicyShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.policy):
            request.policy_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.policy, 'Policy', 'json')
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.policy_shrink):
            query['Policy'] = request.policy_shrink
        if not UtilClient.is_unset(request.policy_region_id):
            query['PolicyRegionId'] = request.policy_region_id
        if not UtilClient.is_unset(request.policy_version):
            query['PolicyVersion'] = request.policy_version
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBackupPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateBackupPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_backup_policy_with_options_async(
        self,
        tmp_req: sas_20181203_models.CreateBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateBackupPolicyResponse:
        """
        @summary Creates an anti-ransomware policy for servers.
        
        @param tmp_req: CreateBackupPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateBackupPolicyResponse
        """
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.CreateBackupPolicyShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.policy):
            request.policy_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.policy, 'Policy', 'json')
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.policy_shrink):
            query['Policy'] = request.policy_shrink
        if not UtilClient.is_unset(request.policy_region_id):
            query['PolicyRegionId'] = request.policy_region_id
        if not UtilClient.is_unset(request.policy_version):
            query['PolicyVersion'] = request.policy_version
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBackupPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateBackupPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_backup_policy(
        self,
        request: sas_20181203_models.CreateBackupPolicyRequest,
    ) -> sas_20181203_models.CreateBackupPolicyResponse:
        """
        @summary Creates an anti-ransomware policy for servers.
        
        @param request: CreateBackupPolicyRequest
        @return: CreateBackupPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_backup_policy_with_options(request, runtime)

    async def create_backup_policy_async(
        self,
        request: sas_20181203_models.CreateBackupPolicyRequest,
    ) -> sas_20181203_models.CreateBackupPolicyResponse:
        """
        @summary Creates an anti-ransomware policy for servers.
        
        @param request: CreateBackupPolicyRequest
        @return: CreateBackupPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_backup_policy_with_options_async(request, runtime)

    def create_batch_upload_url_with_options(
        self,
        request: sas_20181203_models.CreateBatchUploadUrlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateBatchUploadUrlResponse:
        """
        @summary Queries the parameters that are required to upload a file for detection.
        
        @param request: CreateBatchUploadUrlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateBatchUploadUrlResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.md_5list):
            query['Md5List'] = request.md_5list
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBatchUploadUrl',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateBatchUploadUrlResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_batch_upload_url_with_options_async(
        self,
        request: sas_20181203_models.CreateBatchUploadUrlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateBatchUploadUrlResponse:
        """
        @summary Queries the parameters that are required to upload a file for detection.
        
        @param request: CreateBatchUploadUrlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateBatchUploadUrlResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.md_5list):
            query['Md5List'] = request.md_5list
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBatchUploadUrl',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateBatchUploadUrlResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_batch_upload_url(
        self,
        request: sas_20181203_models.CreateBatchUploadUrlRequest,
    ) -> sas_20181203_models.CreateBatchUploadUrlResponse:
        """
        @summary Queries the parameters that are required to upload a file for detection.
        
        @param request: CreateBatchUploadUrlRequest
        @return: CreateBatchUploadUrlResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_batch_upload_url_with_options(request, runtime)

    async def create_batch_upload_url_async(
        self,
        request: sas_20181203_models.CreateBatchUploadUrlRequest,
    ) -> sas_20181203_models.CreateBatchUploadUrlResponse:
        """
        @summary Queries the parameters that are required to upload a file for detection.
        
        @param request: CreateBatchUploadUrlRequest
        @return: CreateBatchUploadUrlResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_batch_upload_url_with_options_async(request, runtime)

    def create_binary_security_policy_with_options(
        self,
        request: sas_20181203_models.CreateBinarySecurityPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateBinarySecurityPolicyResponse:
        """
        @summary Creates a binary security policy.
        
        @param request: CreateBinarySecurityPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateBinarySecurityPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.clusters):
            query['Clusters'] = request.clusters
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBinarySecurityPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateBinarySecurityPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_binary_security_policy_with_options_async(
        self,
        request: sas_20181203_models.CreateBinarySecurityPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateBinarySecurityPolicyResponse:
        """
        @summary Creates a binary security policy.
        
        @param request: CreateBinarySecurityPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateBinarySecurityPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.clusters):
            query['Clusters'] = request.clusters
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBinarySecurityPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateBinarySecurityPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_binary_security_policy(
        self,
        request: sas_20181203_models.CreateBinarySecurityPolicyRequest,
    ) -> sas_20181203_models.CreateBinarySecurityPolicyResponse:
        """
        @summary Creates a binary security policy.
        
        @param request: CreateBinarySecurityPolicyRequest
        @return: CreateBinarySecurityPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_binary_security_policy_with_options(request, runtime)

    async def create_binary_security_policy_async(
        self,
        request: sas_20181203_models.CreateBinarySecurityPolicyRequest,
    ) -> sas_20181203_models.CreateBinarySecurityPolicyResponse:
        """
        @summary Creates a binary security policy.
        
        @param request: CreateBinarySecurityPolicyRequest
        @return: CreateBinarySecurityPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_binary_security_policy_with_options_async(request, runtime)

    def create_container_scan_task_with_options(
        self,
        request: sas_20181203_models.CreateContainerScanTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateContainerScanTaskResponse:
        """
        @summary Creates a container scan task.
        
        @param request: CreateContainerScanTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateContainerScanTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_ids):
            query['ContainerIds'] = request.container_ids
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateContainerScanTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateContainerScanTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_container_scan_task_with_options_async(
        self,
        request: sas_20181203_models.CreateContainerScanTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateContainerScanTaskResponse:
        """
        @summary Creates a container scan task.
        
        @param request: CreateContainerScanTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateContainerScanTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_ids):
            query['ContainerIds'] = request.container_ids
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateContainerScanTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateContainerScanTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_container_scan_task(
        self,
        request: sas_20181203_models.CreateContainerScanTaskRequest,
    ) -> sas_20181203_models.CreateContainerScanTaskResponse:
        """
        @summary Creates a container scan task.
        
        @param request: CreateContainerScanTaskRequest
        @return: CreateContainerScanTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_container_scan_task_with_options(request, runtime)

    async def create_container_scan_task_async(
        self,
        request: sas_20181203_models.CreateContainerScanTaskRequest,
    ) -> sas_20181203_models.CreateContainerScanTaskResponse:
        """
        @summary Creates a container scan task.
        
        @param request: CreateContainerScanTaskRequest
        @return: CreateContainerScanTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_container_scan_task_with_options_async(request, runtime)

    def create_container_scan_task_by_app_name_with_options(
        self,
        request: sas_20181203_models.CreateContainerScanTaskByAppNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateContainerScanTaskByAppNameResponse:
        """
        @summary Creates a scan task for a running container application based on the application name.
        
        @param request: CreateContainerScanTaskByAppNameRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateContainerScanTaskByAppNameResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_names):
            query['AppNames'] = request.app_names
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateContainerScanTaskByAppName',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateContainerScanTaskByAppNameResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_container_scan_task_by_app_name_with_options_async(
        self,
        request: sas_20181203_models.CreateContainerScanTaskByAppNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateContainerScanTaskByAppNameResponse:
        """
        @summary Creates a scan task for a running container application based on the application name.
        
        @param request: CreateContainerScanTaskByAppNameRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateContainerScanTaskByAppNameResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_names):
            query['AppNames'] = request.app_names
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateContainerScanTaskByAppName',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateContainerScanTaskByAppNameResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_container_scan_task_by_app_name(
        self,
        request: sas_20181203_models.CreateContainerScanTaskByAppNameRequest,
    ) -> sas_20181203_models.CreateContainerScanTaskByAppNameResponse:
        """
        @summary Creates a scan task for a running container application based on the application name.
        
        @param request: CreateContainerScanTaskByAppNameRequest
        @return: CreateContainerScanTaskByAppNameResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_container_scan_task_by_app_name_with_options(request, runtime)

    async def create_container_scan_task_by_app_name_async(
        self,
        request: sas_20181203_models.CreateContainerScanTaskByAppNameRequest,
    ) -> sas_20181203_models.CreateContainerScanTaskByAppNameResponse:
        """
        @summary Creates a scan task for a running container application based on the application name.
        
        @param request: CreateContainerScanTaskByAppNameRequest
        @return: CreateContainerScanTaskByAppNameResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_container_scan_task_by_app_name_with_options_async(request, runtime)

    def create_custom_block_record_with_options(
        self,
        request: sas_20181203_models.CreateCustomBlockRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateCustomBlockRecordResponse:
        """
        @summary Creates an IP address blocking policy for one or more servers.
        
        @param request: CreateCustomBlockRecordRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCustomBlockRecordResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.block_ip):
            query['BlockIp'] = request.block_ip
        if not UtilClient.is_unset(request.bound):
            query['Bound'] = request.bound
        if not UtilClient.is_unset(request.expire_time):
            query['ExpireTime'] = request.expire_time
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCustomBlockRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateCustomBlockRecordResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_custom_block_record_with_options_async(
        self,
        request: sas_20181203_models.CreateCustomBlockRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateCustomBlockRecordResponse:
        """
        @summary Creates an IP address blocking policy for one or more servers.
        
        @param request: CreateCustomBlockRecordRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCustomBlockRecordResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.block_ip):
            query['BlockIp'] = request.block_ip
        if not UtilClient.is_unset(request.bound):
            query['Bound'] = request.bound
        if not UtilClient.is_unset(request.expire_time):
            query['ExpireTime'] = request.expire_time
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCustomBlockRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateCustomBlockRecordResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_custom_block_record(
        self,
        request: sas_20181203_models.CreateCustomBlockRecordRequest,
    ) -> sas_20181203_models.CreateCustomBlockRecordResponse:
        """
        @summary Creates an IP address blocking policy for one or more servers.
        
        @param request: CreateCustomBlockRecordRequest
        @return: CreateCustomBlockRecordResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_custom_block_record_with_options(request, runtime)

    async def create_custom_block_record_async(
        self,
        request: sas_20181203_models.CreateCustomBlockRecordRequest,
    ) -> sas_20181203_models.CreateCustomBlockRecordResponse:
        """
        @summary Creates an IP address blocking policy for one or more servers.
        
        @param request: CreateCustomBlockRecordRequest
        @return: CreateCustomBlockRecordResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_custom_block_record_with_options_async(request, runtime)

    def create_customized_dict_with_options(
        self,
        request: sas_20181203_models.CreateCustomizedDictRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateCustomizedDictResponse:
        """
        @summary Creates custom weak password rules.
        
        @param request: CreateCustomizedDictRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCustomizedDictResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.override):
            query['Override'] = request.override
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCustomizedDict',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateCustomizedDictResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_customized_dict_with_options_async(
        self,
        request: sas_20181203_models.CreateCustomizedDictRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateCustomizedDictResponse:
        """
        @summary Creates custom weak password rules.
        
        @param request: CreateCustomizedDictRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCustomizedDictResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.override):
            query['Override'] = request.override
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCustomizedDict',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateCustomizedDictResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_customized_dict(
        self,
        request: sas_20181203_models.CreateCustomizedDictRequest,
    ) -> sas_20181203_models.CreateCustomizedDictResponse:
        """
        @summary Creates custom weak password rules.
        
        @param request: CreateCustomizedDictRequest
        @return: CreateCustomizedDictResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_customized_dict_with_options(request, runtime)

    async def create_customized_dict_async(
        self,
        request: sas_20181203_models.CreateCustomizedDictRequest,
    ) -> sas_20181203_models.CreateCustomizedDictResponse:
        """
        @summary Creates custom weak password rules.
        
        @param request: CreateCustomizedDictRequest
        @return: CreateCustomizedDictResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_customized_dict_with_options_async(request, runtime)

    def create_cycle_task_with_options(
        self,
        request: sas_20181203_models.CreateCycleTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateCycleTaskResponse:
        """
        @summary Creates a periodic scan task. The task can be an image scan task, urgent vulnerability scan task, or virus scan task.
        
        @param request: CreateCycleTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCycleTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.first_date_str):
            query['FirstDateStr'] = request.first_date_str
        if not UtilClient.is_unset(request.interval_period):
            query['IntervalPeriod'] = request.interval_period
        if not UtilClient.is_unset(request.param):
            query['Param'] = request.param
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.target_end_time):
            query['TargetEndTime'] = request.target_end_time
        if not UtilClient.is_unset(request.target_start_time):
            query['TargetStartTime'] = request.target_start_time
        if not UtilClient.is_unset(request.task_name):
            query['TaskName'] = request.task_name
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCycleTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateCycleTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_cycle_task_with_options_async(
        self,
        request: sas_20181203_models.CreateCycleTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateCycleTaskResponse:
        """
        @summary Creates a periodic scan task. The task can be an image scan task, urgent vulnerability scan task, or virus scan task.
        
        @param request: CreateCycleTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCycleTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.first_date_str):
            query['FirstDateStr'] = request.first_date_str
        if not UtilClient.is_unset(request.interval_period):
            query['IntervalPeriod'] = request.interval_period
        if not UtilClient.is_unset(request.param):
            query['Param'] = request.param
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.target_end_time):
            query['TargetEndTime'] = request.target_end_time
        if not UtilClient.is_unset(request.target_start_time):
            query['TargetStartTime'] = request.target_start_time
        if not UtilClient.is_unset(request.task_name):
            query['TaskName'] = request.task_name
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCycleTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateCycleTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_cycle_task(
        self,
        request: sas_20181203_models.CreateCycleTaskRequest,
    ) -> sas_20181203_models.CreateCycleTaskResponse:
        """
        @summary Creates a periodic scan task. The task can be an image scan task, urgent vulnerability scan task, or virus scan task.
        
        @param request: CreateCycleTaskRequest
        @return: CreateCycleTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_cycle_task_with_options(request, runtime)

    async def create_cycle_task_async(
        self,
        request: sas_20181203_models.CreateCycleTaskRequest,
    ) -> sas_20181203_models.CreateCycleTaskResponse:
        """
        @summary Creates a periodic scan task. The task can be an image scan task, urgent vulnerability scan task, or virus scan task.
        
        @param request: CreateCycleTaskRequest
        @return: CreateCycleTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_cycle_task_with_options_async(request, runtime)

    def create_dynamic_dict_with_options(
        self,
        request: sas_20181203_models.CreateDynamicDictRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateDynamicDictResponse:
        """
        @deprecated OpenAPI CreateDynamicDict is deprecated, please use Sas::2018-12-03::CreateCustomizedDict instead.
        
        @summary Creates a dynamic dictionary of weak passwords.
        
        @param request: CreateDynamicDictRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDynamicDictResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.override):
            query['Override'] = request.override
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDynamicDict',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateDynamicDictResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_dynamic_dict_with_options_async(
        self,
        request: sas_20181203_models.CreateDynamicDictRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateDynamicDictResponse:
        """
        @deprecated OpenAPI CreateDynamicDict is deprecated, please use Sas::2018-12-03::CreateCustomizedDict instead.
        
        @summary Creates a dynamic dictionary of weak passwords.
        
        @param request: CreateDynamicDictRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDynamicDictResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.override):
            query['Override'] = request.override
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDynamicDict',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateDynamicDictResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_dynamic_dict(
        self,
        request: sas_20181203_models.CreateDynamicDictRequest,
    ) -> sas_20181203_models.CreateDynamicDictResponse:
        """
        @deprecated OpenAPI CreateDynamicDict is deprecated, please use Sas::2018-12-03::CreateCustomizedDict instead.
        
        @summary Creates a dynamic dictionary of weak passwords.
        
        @param request: CreateDynamicDictRequest
        @return: CreateDynamicDictResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.create_dynamic_dict_with_options(request, runtime)

    async def create_dynamic_dict_async(
        self,
        request: sas_20181203_models.CreateDynamicDictRequest,
    ) -> sas_20181203_models.CreateDynamicDictResponse:
        """
        @deprecated OpenAPI CreateDynamicDict is deprecated, please use Sas::2018-12-03::CreateCustomizedDict instead.
        
        @summary Creates a dynamic dictionary of weak passwords.
        
        @param request: CreateDynamicDictRequest
        @return: CreateDynamicDictResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_dynamic_dict_with_options_async(request, runtime)

    def create_file_detect_with_options(
        self,
        request: sas_20181203_models.CreateFileDetectRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateFileDetectResponse:
        """
        @summary Pushes a file to the cloud for detection.
        
        @description You can call this operation to push a file to the cloud for detection. Before you call this operation, make sure that the file is uploaded. You can call the CreateFileDetectUploadUrl operation to upload the file.
        The HashKey parameter is included in all API operations that are related to the file detection feature. The parameter specifies the unique identifier of a file. Only MD5 hash values are supported. Before you call this operation, calculate the MD5 hash value of the file.
        
        @param request: CreateFileDetectRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFileDetectResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.decompress):
            query['Decompress'] = request.decompress
        if not UtilClient.is_unset(request.decompress_max_file_count):
            query['DecompressMaxFileCount'] = request.decompress_max_file_count
        if not UtilClient.is_unset(request.decompress_max_layer):
            query['DecompressMaxLayer'] = request.decompress_max_layer
        if not UtilClient.is_unset(request.download_url):
            query['DownloadUrl'] = request.download_url
        if not UtilClient.is_unset(request.hash_key):
            query['HashKey'] = request.hash_key
        if not UtilClient.is_unset(request.oss_key):
            query['OssKey'] = request.oss_key
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFileDetect',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateFileDetectResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_file_detect_with_options_async(
        self,
        request: sas_20181203_models.CreateFileDetectRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateFileDetectResponse:
        """
        @summary Pushes a file to the cloud for detection.
        
        @description You can call this operation to push a file to the cloud for detection. Before you call this operation, make sure that the file is uploaded. You can call the CreateFileDetectUploadUrl operation to upload the file.
        The HashKey parameter is included in all API operations that are related to the file detection feature. The parameter specifies the unique identifier of a file. Only MD5 hash values are supported. Before you call this operation, calculate the MD5 hash value of the file.
        
        @param request: CreateFileDetectRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFileDetectResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.decompress):
            query['Decompress'] = request.decompress
        if not UtilClient.is_unset(request.decompress_max_file_count):
            query['DecompressMaxFileCount'] = request.decompress_max_file_count
        if not UtilClient.is_unset(request.decompress_max_layer):
            query['DecompressMaxLayer'] = request.decompress_max_layer
        if not UtilClient.is_unset(request.download_url):
            query['DownloadUrl'] = request.download_url
        if not UtilClient.is_unset(request.hash_key):
            query['HashKey'] = request.hash_key
        if not UtilClient.is_unset(request.oss_key):
            query['OssKey'] = request.oss_key
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFileDetect',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateFileDetectResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_file_detect(
        self,
        request: sas_20181203_models.CreateFileDetectRequest,
    ) -> sas_20181203_models.CreateFileDetectResponse:
        """
        @summary Pushes a file to the cloud for detection.
        
        @description You can call this operation to push a file to the cloud for detection. Before you call this operation, make sure that the file is uploaded. You can call the CreateFileDetectUploadUrl operation to upload the file.
        The HashKey parameter is included in all API operations that are related to the file detection feature. The parameter specifies the unique identifier of a file. Only MD5 hash values are supported. Before you call this operation, calculate the MD5 hash value of the file.
        
        @param request: CreateFileDetectRequest
        @return: CreateFileDetectResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_file_detect_with_options(request, runtime)

    async def create_file_detect_async(
        self,
        request: sas_20181203_models.CreateFileDetectRequest,
    ) -> sas_20181203_models.CreateFileDetectResponse:
        """
        @summary Pushes a file to the cloud for detection.
        
        @description You can call this operation to push a file to the cloud for detection. Before you call this operation, make sure that the file is uploaded. You can call the CreateFileDetectUploadUrl operation to upload the file.
        The HashKey parameter is included in all API operations that are related to the file detection feature. The parameter specifies the unique identifier of a file. Only MD5 hash values are supported. Before you call this operation, calculate the MD5 hash value of the file.
        
        @param request: CreateFileDetectRequest
        @return: CreateFileDetectResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_file_detect_with_options_async(request, runtime)

    def create_file_detect_upload_url_with_options(
        self,
        request: sas_20181203_models.CreateFileDetectUploadUrlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateFileDetectUploadUrlResponse:
        """
        @summary Queries the parameters that are required to upload a file for detection.
        
        @description You can call this operation to query the parameters that are required to upload a file for detection. If the value of the response parameter FileExist is true, the file that you want to upload for detection already exists in the cloud. In this case, you can directly push the file for detection. If the value of the response parameter FileExist is false, you must use the form upload method to upload the file to the specified Object Storage Service (OSS) bucket based on the response parameters of this operation.
        The form upload method is provided by OSS. For more information, see [Form upload](https://help.aliyun.com/document_detail/84788.html).
        The HashKey parameter is included in all API operations that are related to the file detection feature. The parameter specifies the unique identifier of a file. Only MD5 hash values are supported. Before you call this operation, calculate the MD5 hash value of the file.
        
        @param request: CreateFileDetectUploadUrlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFileDetectUploadUrlResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.hash_key_context_list):
            query['HashKeyContextList'] = request.hash_key_context_list
        if not UtilClient.is_unset(request.hash_key_list):
            query['HashKeyList'] = request.hash_key_list
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFileDetectUploadUrl',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateFileDetectUploadUrlResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_file_detect_upload_url_with_options_async(
        self,
        request: sas_20181203_models.CreateFileDetectUploadUrlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateFileDetectUploadUrlResponse:
        """
        @summary Queries the parameters that are required to upload a file for detection.
        
        @description You can call this operation to query the parameters that are required to upload a file for detection. If the value of the response parameter FileExist is true, the file that you want to upload for detection already exists in the cloud. In this case, you can directly push the file for detection. If the value of the response parameter FileExist is false, you must use the form upload method to upload the file to the specified Object Storage Service (OSS) bucket based on the response parameters of this operation.
        The form upload method is provided by OSS. For more information, see [Form upload](https://help.aliyun.com/document_detail/84788.html).
        The HashKey parameter is included in all API operations that are related to the file detection feature. The parameter specifies the unique identifier of a file. Only MD5 hash values are supported. Before you call this operation, calculate the MD5 hash value of the file.
        
        @param request: CreateFileDetectUploadUrlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFileDetectUploadUrlResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.hash_key_context_list):
            query['HashKeyContextList'] = request.hash_key_context_list
        if not UtilClient.is_unset(request.hash_key_list):
            query['HashKeyList'] = request.hash_key_list
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFileDetectUploadUrl',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateFileDetectUploadUrlResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_file_detect_upload_url(
        self,
        request: sas_20181203_models.CreateFileDetectUploadUrlRequest,
    ) -> sas_20181203_models.CreateFileDetectUploadUrlResponse:
        """
        @summary Queries the parameters that are required to upload a file for detection.
        
        @description You can call this operation to query the parameters that are required to upload a file for detection. If the value of the response parameter FileExist is true, the file that you want to upload for detection already exists in the cloud. In this case, you can directly push the file for detection. If the value of the response parameter FileExist is false, you must use the form upload method to upload the file to the specified Object Storage Service (OSS) bucket based on the response parameters of this operation.
        The form upload method is provided by OSS. For more information, see [Form upload](https://help.aliyun.com/document_detail/84788.html).
        The HashKey parameter is included in all API operations that are related to the file detection feature. The parameter specifies the unique identifier of a file. Only MD5 hash values are supported. Before you call this operation, calculate the MD5 hash value of the file.
        
        @param request: CreateFileDetectUploadUrlRequest
        @return: CreateFileDetectUploadUrlResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_file_detect_upload_url_with_options(request, runtime)

    async def create_file_detect_upload_url_async(
        self,
        request: sas_20181203_models.CreateFileDetectUploadUrlRequest,
    ) -> sas_20181203_models.CreateFileDetectUploadUrlResponse:
        """
        @summary Queries the parameters that are required to upload a file for detection.
        
        @description You can call this operation to query the parameters that are required to upload a file for detection. If the value of the response parameter FileExist is true, the file that you want to upload for detection already exists in the cloud. In this case, you can directly push the file for detection. If the value of the response parameter FileExist is false, you must use the form upload method to upload the file to the specified Object Storage Service (OSS) bucket based on the response parameters of this operation.
        The form upload method is provided by OSS. For more information, see [Form upload](https://help.aliyun.com/document_detail/84788.html).
        The HashKey parameter is included in all API operations that are related to the file detection feature. The parameter specifies the unique identifier of a file. Only MD5 hash values are supported. Before you call this operation, calculate the MD5 hash value of the file.
        
        @param request: CreateFileDetectUploadUrlRequest
        @return: CreateFileDetectUploadUrlResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_file_detect_upload_url_with_options_async(request, runtime)

    def create_file_protect_rule_with_options(
        self,
        request: sas_20181203_models.CreateFileProtectRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateFileProtectRuleResponse:
        """
        @summary Creates a core file monitoring rule.
        
        @param request: CreateFileProtectRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFileProtectRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alert_level):
            query['AlertLevel'] = request.alert_level
        if not UtilClient.is_unset(request.file_ops):
            query['FileOps'] = request.file_ops
        if not UtilClient.is_unset(request.file_paths):
            query['FilePaths'] = request.file_paths
        if not UtilClient.is_unset(request.platform):
            query['Platform'] = request.platform
        if not UtilClient.is_unset(request.proc_paths):
            query['ProcPaths'] = request.proc_paths
        if not UtilClient.is_unset(request.rule_action):
            query['RuleAction'] = request.rule_action
        if not UtilClient.is_unset(request.rule_name):
            query['RuleName'] = request.rule_name
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.switch_id):
            query['SwitchId'] = request.switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFileProtectRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateFileProtectRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_file_protect_rule_with_options_async(
        self,
        request: sas_20181203_models.CreateFileProtectRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateFileProtectRuleResponse:
        """
        @summary Creates a core file monitoring rule.
        
        @param request: CreateFileProtectRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFileProtectRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alert_level):
            query['AlertLevel'] = request.alert_level
        if not UtilClient.is_unset(request.file_ops):
            query['FileOps'] = request.file_ops
        if not UtilClient.is_unset(request.file_paths):
            query['FilePaths'] = request.file_paths
        if not UtilClient.is_unset(request.platform):
            query['Platform'] = request.platform
        if not UtilClient.is_unset(request.proc_paths):
            query['ProcPaths'] = request.proc_paths
        if not UtilClient.is_unset(request.rule_action):
            query['RuleAction'] = request.rule_action
        if not UtilClient.is_unset(request.rule_name):
            query['RuleName'] = request.rule_name
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.switch_id):
            query['SwitchId'] = request.switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFileProtectRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateFileProtectRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_file_protect_rule(
        self,
        request: sas_20181203_models.CreateFileProtectRuleRequest,
    ) -> sas_20181203_models.CreateFileProtectRuleResponse:
        """
        @summary Creates a core file monitoring rule.
        
        @param request: CreateFileProtectRuleRequest
        @return: CreateFileProtectRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_file_protect_rule_with_options(request, runtime)

    async def create_file_protect_rule_async(
        self,
        request: sas_20181203_models.CreateFileProtectRuleRequest,
    ) -> sas_20181203_models.CreateFileProtectRuleResponse:
        """
        @summary Creates a core file monitoring rule.
        
        @param request: CreateFileProtectRuleRequest
        @return: CreateFileProtectRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_file_protect_rule_with_options_async(request, runtime)

    def create_file_upload_limit_with_options(
        self,
        request: sas_20181203_models.CreateFileUploadLimitRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateFileUploadLimitResponse:
        """
        @summary Specifies the queries per second (QPS) limit on the files uploaded from the client.
        
        @param request: CreateFileUploadLimitRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFileUploadLimitResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.limit):
            query['Limit'] = request.limit
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFileUploadLimit',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateFileUploadLimitResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_file_upload_limit_with_options_async(
        self,
        request: sas_20181203_models.CreateFileUploadLimitRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateFileUploadLimitResponse:
        """
        @summary Specifies the queries per second (QPS) limit on the files uploaded from the client.
        
        @param request: CreateFileUploadLimitRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFileUploadLimitResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.limit):
            query['Limit'] = request.limit
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFileUploadLimit',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateFileUploadLimitResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_file_upload_limit(
        self,
        request: sas_20181203_models.CreateFileUploadLimitRequest,
    ) -> sas_20181203_models.CreateFileUploadLimitResponse:
        """
        @summary Specifies the queries per second (QPS) limit on the files uploaded from the client.
        
        @param request: CreateFileUploadLimitRequest
        @return: CreateFileUploadLimitResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_file_upload_limit_with_options(request, runtime)

    async def create_file_upload_limit_async(
        self,
        request: sas_20181203_models.CreateFileUploadLimitRequest,
    ) -> sas_20181203_models.CreateFileUploadLimitResponse:
        """
        @summary Specifies the queries per second (QPS) limit on the files uploaded from the client.
        
        @param request: CreateFileUploadLimitRequest
        @return: CreateFileUploadLimitResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_file_upload_limit_with_options_async(request, runtime)

    def create_honeypot_with_options(
        self,
        request: sas_20181203_models.CreateHoneypotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateHoneypotResponse:
        """
        @summary Creates a honeypot.
        
        @param request: CreateHoneypotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHoneypotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.honeypot_image_id):
            query['HoneypotImageId'] = request.honeypot_image_id
        if not UtilClient.is_unset(request.honeypot_image_name):
            query['HoneypotImageName'] = request.honeypot_image_name
        if not UtilClient.is_unset(request.honeypot_name):
            query['HoneypotName'] = request.honeypot_name
        if not UtilClient.is_unset(request.meta):
            query['Meta'] = request.meta
        if not UtilClient.is_unset(request.node_id):
            query['NodeId'] = request.node_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHoneypot',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateHoneypotResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_honeypot_with_options_async(
        self,
        request: sas_20181203_models.CreateHoneypotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateHoneypotResponse:
        """
        @summary Creates a honeypot.
        
        @param request: CreateHoneypotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHoneypotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.honeypot_image_id):
            query['HoneypotImageId'] = request.honeypot_image_id
        if not UtilClient.is_unset(request.honeypot_image_name):
            query['HoneypotImageName'] = request.honeypot_image_name
        if not UtilClient.is_unset(request.honeypot_name):
            query['HoneypotName'] = request.honeypot_name
        if not UtilClient.is_unset(request.meta):
            query['Meta'] = request.meta
        if not UtilClient.is_unset(request.node_id):
            query['NodeId'] = request.node_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHoneypot',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateHoneypotResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_honeypot(
        self,
        request: sas_20181203_models.CreateHoneypotRequest,
    ) -> sas_20181203_models.CreateHoneypotResponse:
        """
        @summary Creates a honeypot.
        
        @param request: CreateHoneypotRequest
        @return: CreateHoneypotResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_honeypot_with_options(request, runtime)

    async def create_honeypot_async(
        self,
        request: sas_20181203_models.CreateHoneypotRequest,
    ) -> sas_20181203_models.CreateHoneypotResponse:
        """
        @summary Creates a honeypot.
        
        @param request: CreateHoneypotRequest
        @return: CreateHoneypotResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_honeypot_with_options_async(request, runtime)

    def create_honeypot_node_with_options(
        self,
        request: sas_20181203_models.CreateHoneypotNodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateHoneypotNodeResponse:
        """
        @summary Creates a management node.
        
        @param request: CreateHoneypotNodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHoneypotNodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allow_honeypot_access_internet):
            query['AllowHoneypotAccessInternet'] = request.allow_honeypot_access_internet
        if not UtilClient.is_unset(request.available_probe_num):
            query['AvailableProbeNum'] = request.available_probe_num
        if not UtilClient.is_unset(request.node_name):
            query['NodeName'] = request.node_name
        if not UtilClient.is_unset(request.security_group_probe_ip_list):
            query['SecurityGroupProbeIpList'] = request.security_group_probe_ip_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHoneypotNode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateHoneypotNodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_honeypot_node_with_options_async(
        self,
        request: sas_20181203_models.CreateHoneypotNodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateHoneypotNodeResponse:
        """
        @summary Creates a management node.
        
        @param request: CreateHoneypotNodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHoneypotNodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allow_honeypot_access_internet):
            query['AllowHoneypotAccessInternet'] = request.allow_honeypot_access_internet
        if not UtilClient.is_unset(request.available_probe_num):
            query['AvailableProbeNum'] = request.available_probe_num
        if not UtilClient.is_unset(request.node_name):
            query['NodeName'] = request.node_name
        if not UtilClient.is_unset(request.security_group_probe_ip_list):
            query['SecurityGroupProbeIpList'] = request.security_group_probe_ip_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHoneypotNode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateHoneypotNodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_honeypot_node(
        self,
        request: sas_20181203_models.CreateHoneypotNodeRequest,
    ) -> sas_20181203_models.CreateHoneypotNodeResponse:
        """
        @summary Creates a management node.
        
        @param request: CreateHoneypotNodeRequest
        @return: CreateHoneypotNodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_honeypot_node_with_options(request, runtime)

    async def create_honeypot_node_async(
        self,
        request: sas_20181203_models.CreateHoneypotNodeRequest,
    ) -> sas_20181203_models.CreateHoneypotNodeResponse:
        """
        @summary Creates a management node.
        
        @param request: CreateHoneypotNodeRequest
        @return: CreateHoneypotNodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_honeypot_node_with_options_async(request, runtime)

    def create_honeypot_preset_with_options(
        self,
        request: sas_20181203_models.CreateHoneypotPresetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateHoneypotPresetResponse:
        """
        @summary Creates a honeypot template.
        
        @param request: CreateHoneypotPresetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHoneypotPresetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.honeypot_image_name):
            query['HoneypotImageName'] = request.honeypot_image_name
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.meta):
            query['Meta'] = request.meta
        if not UtilClient.is_unset(request.node_id):
            query['NodeId'] = request.node_id
        if not UtilClient.is_unset(request.preset_name):
            query['PresetName'] = request.preset_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHoneypotPreset',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateHoneypotPresetResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_honeypot_preset_with_options_async(
        self,
        request: sas_20181203_models.CreateHoneypotPresetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateHoneypotPresetResponse:
        """
        @summary Creates a honeypot template.
        
        @param request: CreateHoneypotPresetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHoneypotPresetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.honeypot_image_name):
            query['HoneypotImageName'] = request.honeypot_image_name
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.meta):
            query['Meta'] = request.meta
        if not UtilClient.is_unset(request.node_id):
            query['NodeId'] = request.node_id
        if not UtilClient.is_unset(request.preset_name):
            query['PresetName'] = request.preset_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHoneypotPreset',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateHoneypotPresetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_honeypot_preset(
        self,
        request: sas_20181203_models.CreateHoneypotPresetRequest,
    ) -> sas_20181203_models.CreateHoneypotPresetResponse:
        """
        @summary Creates a honeypot template.
        
        @param request: CreateHoneypotPresetRequest
        @return: CreateHoneypotPresetResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_honeypot_preset_with_options(request, runtime)

    async def create_honeypot_preset_async(
        self,
        request: sas_20181203_models.CreateHoneypotPresetRequest,
    ) -> sas_20181203_models.CreateHoneypotPresetResponse:
        """
        @summary Creates a honeypot template.
        
        @param request: CreateHoneypotPresetRequest
        @return: CreateHoneypotPresetResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_honeypot_preset_with_options_async(request, runtime)

    def create_honeypot_probe_with_options(
        self,
        request: sas_20181203_models.CreateHoneypotProbeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateHoneypotProbeResponse:
        """
        @summary Creates a probe.
        
        @param request: CreateHoneypotProbeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHoneypotProbeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.arp):
            query['Arp'] = request.arp
        if not UtilClient.is_unset(request.business_group_id):
            query['BusinessGroupId'] = request.business_group_id
        if not UtilClient.is_unset(request.control_node_id):
            query['ControlNodeId'] = request.control_node_id
        if not UtilClient.is_unset(request.display_name):
            query['DisplayName'] = request.display_name
        if not UtilClient.is_unset(request.honeypot_bind_list):
            query['HoneypotBindList'] = request.honeypot_bind_list
        if not UtilClient.is_unset(request.ping):
            query['Ping'] = request.ping
        if not UtilClient.is_unset(request.probe_type):
            query['ProbeType'] = request.probe_type
        if not UtilClient.is_unset(request.probe_version):
            query['ProbeVersion'] = request.probe_version
        if not UtilClient.is_unset(request.proxy_ip):
            query['ProxyIp'] = request.proxy_ip
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHoneypotProbe',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateHoneypotProbeResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_honeypot_probe_with_options_async(
        self,
        request: sas_20181203_models.CreateHoneypotProbeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateHoneypotProbeResponse:
        """
        @summary Creates a probe.
        
        @param request: CreateHoneypotProbeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHoneypotProbeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.arp):
            query['Arp'] = request.arp
        if not UtilClient.is_unset(request.business_group_id):
            query['BusinessGroupId'] = request.business_group_id
        if not UtilClient.is_unset(request.control_node_id):
            query['ControlNodeId'] = request.control_node_id
        if not UtilClient.is_unset(request.display_name):
            query['DisplayName'] = request.display_name
        if not UtilClient.is_unset(request.honeypot_bind_list):
            query['HoneypotBindList'] = request.honeypot_bind_list
        if not UtilClient.is_unset(request.ping):
            query['Ping'] = request.ping
        if not UtilClient.is_unset(request.probe_type):
            query['ProbeType'] = request.probe_type
        if not UtilClient.is_unset(request.probe_version):
            query['ProbeVersion'] = request.probe_version
        if not UtilClient.is_unset(request.proxy_ip):
            query['ProxyIp'] = request.proxy_ip
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHoneypotProbe',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateHoneypotProbeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_honeypot_probe(
        self,
        request: sas_20181203_models.CreateHoneypotProbeRequest,
    ) -> sas_20181203_models.CreateHoneypotProbeResponse:
        """
        @summary Creates a probe.
        
        @param request: CreateHoneypotProbeRequest
        @return: CreateHoneypotProbeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_honeypot_probe_with_options(request, runtime)

    async def create_honeypot_probe_async(
        self,
        request: sas_20181203_models.CreateHoneypotProbeRequest,
    ) -> sas_20181203_models.CreateHoneypotProbeResponse:
        """
        @summary Creates a probe.
        
        @param request: CreateHoneypotProbeRequest
        @return: CreateHoneypotProbeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_honeypot_probe_with_options_async(request, runtime)

    def create_honeypot_probe_bind_with_options(
        self,
        request: sas_20181203_models.CreateHoneypotProbeBindRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateHoneypotProbeBindResponse:
        """
        @summary Creates a monitoring or forwarding service for a probe.
        
        @param request: CreateHoneypotProbeBindRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHoneypotProbeBindResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bind_port_list):
            query['BindPortList'] = request.bind_port_list
        if not UtilClient.is_unset(request.honeypot_id):
            query['HoneypotId'] = request.honeypot_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.probe_id):
            query['ProbeId'] = request.probe_id
        if not UtilClient.is_unset(request.service_ip_list):
            query['ServiceIpList'] = request.service_ip_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHoneypotProbeBind',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateHoneypotProbeBindResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_honeypot_probe_bind_with_options_async(
        self,
        request: sas_20181203_models.CreateHoneypotProbeBindRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateHoneypotProbeBindResponse:
        """
        @summary Creates a monitoring or forwarding service for a probe.
        
        @param request: CreateHoneypotProbeBindRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHoneypotProbeBindResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bind_port_list):
            query['BindPortList'] = request.bind_port_list
        if not UtilClient.is_unset(request.honeypot_id):
            query['HoneypotId'] = request.honeypot_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.probe_id):
            query['ProbeId'] = request.probe_id
        if not UtilClient.is_unset(request.service_ip_list):
            query['ServiceIpList'] = request.service_ip_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHoneypotProbeBind',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateHoneypotProbeBindResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_honeypot_probe_bind(
        self,
        request: sas_20181203_models.CreateHoneypotProbeBindRequest,
    ) -> sas_20181203_models.CreateHoneypotProbeBindResponse:
        """
        @summary Creates a monitoring or forwarding service for a probe.
        
        @param request: CreateHoneypotProbeBindRequest
        @return: CreateHoneypotProbeBindResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_honeypot_probe_bind_with_options(request, runtime)

    async def create_honeypot_probe_bind_async(
        self,
        request: sas_20181203_models.CreateHoneypotProbeBindRequest,
    ) -> sas_20181203_models.CreateHoneypotProbeBindResponse:
        """
        @summary Creates a monitoring or forwarding service for a probe.
        
        @param request: CreateHoneypotProbeBindRequest
        @return: CreateHoneypotProbeBindResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_honeypot_probe_bind_with_options_async(request, runtime)

    def create_hybrid_proxy_cluster_with_options(
        self,
        request: sas_20181203_models.CreateHybridProxyClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateHybridProxyClusterResponse:
        """
        @summary Creates a hybrid-cloud proxy cluster.
        
        @param request: CreateHybridProxyClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHybridProxyClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.ip):
            query['Ip'] = request.ip
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHybridProxyCluster',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateHybridProxyClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_hybrid_proxy_cluster_with_options_async(
        self,
        request: sas_20181203_models.CreateHybridProxyClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateHybridProxyClusterResponse:
        """
        @summary Creates a hybrid-cloud proxy cluster.
        
        @param request: CreateHybridProxyClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHybridProxyClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.ip):
            query['Ip'] = request.ip
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHybridProxyCluster',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateHybridProxyClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_hybrid_proxy_cluster(
        self,
        request: sas_20181203_models.CreateHybridProxyClusterRequest,
    ) -> sas_20181203_models.CreateHybridProxyClusterResponse:
        """
        @summary Creates a hybrid-cloud proxy cluster.
        
        @param request: CreateHybridProxyClusterRequest
        @return: CreateHybridProxyClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_hybrid_proxy_cluster_with_options(request, runtime)

    async def create_hybrid_proxy_cluster_async(
        self,
        request: sas_20181203_models.CreateHybridProxyClusterRequest,
    ) -> sas_20181203_models.CreateHybridProxyClusterResponse:
        """
        @summary Creates a hybrid-cloud proxy cluster.
        
        @param request: CreateHybridProxyClusterRequest
        @return: CreateHybridProxyClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_hybrid_proxy_cluster_with_options_async(request, runtime)

    def create_interception_rule_with_options(
        self,
        tmp_req: sas_20181203_models.CreateInterceptionRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateInterceptionRuleResponse:
        """
        @summary Creates a defense rule in the container firewall module.
        
        @param tmp_req: CreateInterceptionRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateInterceptionRuleResponse
        """
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.CreateInterceptionRuleShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.dst_target_list):
            request.dst_target_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.dst_target_list, 'DstTargetList', 'json')
        if not UtilClient.is_unset(tmp_req.src_target):
            request.src_target_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.src_target, 'SrcTarget', 'json')
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.dst_target_list_shrink):
            query['DstTargetList'] = request.dst_target_list_shrink
        if not UtilClient.is_unset(request.intercept_type):
            query['InterceptType'] = request.intercept_type
        if not UtilClient.is_unset(request.order_index):
            query['OrderIndex'] = request.order_index
        if not UtilClient.is_unset(request.rule_name):
            query['RuleName'] = request.rule_name
        if not UtilClient.is_unset(request.rule_switch):
            query['RuleSwitch'] = request.rule_switch
        if not UtilClient.is_unset(request.rule_type):
            query['RuleType'] = request.rule_type
        if not UtilClient.is_unset(request.src_target_shrink):
            query['SrcTarget'] = request.src_target_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateInterceptionRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateInterceptionRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_interception_rule_with_options_async(
        self,
        tmp_req: sas_20181203_models.CreateInterceptionRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateInterceptionRuleResponse:
        """
        @summary Creates a defense rule in the container firewall module.
        
        @param tmp_req: CreateInterceptionRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateInterceptionRuleResponse
        """
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.CreateInterceptionRuleShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.dst_target_list):
            request.dst_target_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.dst_target_list, 'DstTargetList', 'json')
        if not UtilClient.is_unset(tmp_req.src_target):
            request.src_target_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.src_target, 'SrcTarget', 'json')
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.dst_target_list_shrink):
            query['DstTargetList'] = request.dst_target_list_shrink
        if not UtilClient.is_unset(request.intercept_type):
            query['InterceptType'] = request.intercept_type
        if not UtilClient.is_unset(request.order_index):
            query['OrderIndex'] = request.order_index
        if not UtilClient.is_unset(request.rule_name):
            query['RuleName'] = request.rule_name
        if not UtilClient.is_unset(request.rule_switch):
            query['RuleSwitch'] = request.rule_switch
        if not UtilClient.is_unset(request.rule_type):
            query['RuleType'] = request.rule_type
        if not UtilClient.is_unset(request.src_target_shrink):
            query['SrcTarget'] = request.src_target_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateInterceptionRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateInterceptionRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_interception_rule(
        self,
        request: sas_20181203_models.CreateInterceptionRuleRequest,
    ) -> sas_20181203_models.CreateInterceptionRuleResponse:
        """
        @summary Creates a defense rule in the container firewall module.
        
        @param request: CreateInterceptionRuleRequest
        @return: CreateInterceptionRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_interception_rule_with_options(request, runtime)

    async def create_interception_rule_async(
        self,
        request: sas_20181203_models.CreateInterceptionRuleRequest,
    ) -> sas_20181203_models.CreateInterceptionRuleResponse:
        """
        @summary Creates a defense rule in the container firewall module.
        
        @param request: CreateInterceptionRuleRequest
        @return: CreateInterceptionRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_interception_rule_with_options_async(request, runtime)

    def create_interception_target_with_options(
        self,
        request: sas_20181203_models.CreateInterceptionTargetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateInterceptionTargetResponse:
        """
        @summary Creates a defense object.
        
        @param request: CreateInterceptionTargetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateInterceptionTargetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.image_list):
            query['ImageList'] = request.image_list
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.tag_list):
            query['TagList'] = request.tag_list
        if not UtilClient.is_unset(request.target_name):
            query['TargetName'] = request.target_name
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateInterceptionTarget',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateInterceptionTargetResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_interception_target_with_options_async(
        self,
        request: sas_20181203_models.CreateInterceptionTargetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateInterceptionTargetResponse:
        """
        @summary Creates a defense object.
        
        @param request: CreateInterceptionTargetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateInterceptionTargetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.image_list):
            query['ImageList'] = request.image_list
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.tag_list):
            query['TagList'] = request.tag_list
        if not UtilClient.is_unset(request.target_name):
            query['TargetName'] = request.target_name
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateInterceptionTarget',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateInterceptionTargetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_interception_target(
        self,
        request: sas_20181203_models.CreateInterceptionTargetRequest,
    ) -> sas_20181203_models.CreateInterceptionTargetResponse:
        """
        @summary Creates a defense object.
        
        @param request: CreateInterceptionTargetRequest
        @return: CreateInterceptionTargetResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_interception_target_with_options(request, runtime)

    async def create_interception_target_async(
        self,
        request: sas_20181203_models.CreateInterceptionTargetRequest,
    ) -> sas_20181203_models.CreateInterceptionTargetResponse:
        """
        @summary Creates a defense object.
        
        @param request: CreateInterceptionTargetRequest
        @return: CreateInterceptionTargetResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_interception_target_with_options_async(request, runtime)

    def create_jenkins_image_registry_with_options(
        self,
        request: sas_20181203_models.CreateJenkinsImageRegistryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateJenkinsImageRegistryResponse:
        """
        @summary Creates a Jenkins image repository.
        
        @param request: CreateJenkinsImageRegistryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateJenkinsImageRegistryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        body = {}
        if not UtilClient.is_unset(request.domain_name):
            body['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.extra_param):
            body['ExtraParam'] = request.extra_param
        if not UtilClient.is_unset(request.net_type):
            body['NetType'] = request.net_type
        if not UtilClient.is_unset(request.password):
            body['Password'] = request.password
        if not UtilClient.is_unset(request.persistence_day):
            body['PersistenceDay'] = request.persistence_day
        if not UtilClient.is_unset(request.protocol_type):
            body['ProtocolType'] = request.protocol_type
        if not UtilClient.is_unset(request.region_id):
            body['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.registry_host_ip):
            body['RegistryHostIp'] = request.registry_host_ip
        if not UtilClient.is_unset(request.registry_name):
            body['RegistryName'] = request.registry_name
        if not UtilClient.is_unset(request.registry_type):
            body['RegistryType'] = request.registry_type
        if not UtilClient.is_unset(request.registry_version):
            body['RegistryVersion'] = request.registry_version
        if not UtilClient.is_unset(request.trans_per_hour):
            body['TransPerHour'] = request.trans_per_hour
        if not UtilClient.is_unset(request.user_name):
            body['UserName'] = request.user_name
        if not UtilClient.is_unset(request.vpc_id):
            body['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.white_list):
            body['WhiteList'] = request.white_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateJenkinsImageRegistry',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateJenkinsImageRegistryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_jenkins_image_registry_with_options_async(
        self,
        request: sas_20181203_models.CreateJenkinsImageRegistryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateJenkinsImageRegistryResponse:
        """
        @summary Creates a Jenkins image repository.
        
        @param request: CreateJenkinsImageRegistryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateJenkinsImageRegistryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        body = {}
        if not UtilClient.is_unset(request.domain_name):
            body['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.extra_param):
            body['ExtraParam'] = request.extra_param
        if not UtilClient.is_unset(request.net_type):
            body['NetType'] = request.net_type
        if not UtilClient.is_unset(request.password):
            body['Password'] = request.password
        if not UtilClient.is_unset(request.persistence_day):
            body['PersistenceDay'] = request.persistence_day
        if not UtilClient.is_unset(request.protocol_type):
            body['ProtocolType'] = request.protocol_type
        if not UtilClient.is_unset(request.region_id):
            body['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.registry_host_ip):
            body['RegistryHostIp'] = request.registry_host_ip
        if not UtilClient.is_unset(request.registry_name):
            body['RegistryName'] = request.registry_name
        if not UtilClient.is_unset(request.registry_type):
            body['RegistryType'] = request.registry_type
        if not UtilClient.is_unset(request.registry_version):
            body['RegistryVersion'] = request.registry_version
        if not UtilClient.is_unset(request.trans_per_hour):
            body['TransPerHour'] = request.trans_per_hour
        if not UtilClient.is_unset(request.user_name):
            body['UserName'] = request.user_name
        if not UtilClient.is_unset(request.vpc_id):
            body['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.white_list):
            body['WhiteList'] = request.white_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateJenkinsImageRegistry',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateJenkinsImageRegistryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_jenkins_image_registry(
        self,
        request: sas_20181203_models.CreateJenkinsImageRegistryRequest,
    ) -> sas_20181203_models.CreateJenkinsImageRegistryResponse:
        """
        @summary Creates a Jenkins image repository.
        
        @param request: CreateJenkinsImageRegistryRequest
        @return: CreateJenkinsImageRegistryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_jenkins_image_registry_with_options(request, runtime)

    async def create_jenkins_image_registry_async(
        self,
        request: sas_20181203_models.CreateJenkinsImageRegistryRequest,
    ) -> sas_20181203_models.CreateJenkinsImageRegistryResponse:
        """
        @summary Creates a Jenkins image repository.
        
        @param request: CreateJenkinsImageRegistryRequest
        @return: CreateJenkinsImageRegistryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_jenkins_image_registry_with_options_async(request, runtime)

    def create_jenkins_image_scan_task_with_options(
        self,
        request: sas_20181203_models.CreateJenkinsImageScanTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateJenkinsImageScanTaskResponse:
        """
        @summary Creates a Jenkins scan task.
        
        @param request: CreateJenkinsImageScanTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateJenkinsImageScanTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.jenkins_env):
            query['JenkinsEnv'] = request.jenkins_env
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        body = {}
        if not UtilClient.is_unset(request.digest):
            body['Digest'] = request.digest
        if not UtilClient.is_unset(request.image_create):
            body['ImageCreate'] = request.image_create
        if not UtilClient.is_unset(request.image_id):
            body['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_size):
            body['ImageSize'] = request.image_size
        if not UtilClient.is_unset(request.image_update):
            body['ImageUpdate'] = request.image_update
        if not UtilClient.is_unset(request.namespace):
            body['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.repo_name):
            body['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.tag):
            body['Tag'] = request.tag
        if not UtilClient.is_unset(request.token):
            body['Token'] = request.token
        if not UtilClient.is_unset(request.uuid):
            body['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateJenkinsImageScanTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateJenkinsImageScanTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_jenkins_image_scan_task_with_options_async(
        self,
        request: sas_20181203_models.CreateJenkinsImageScanTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateJenkinsImageScanTaskResponse:
        """
        @summary Creates a Jenkins scan task.
        
        @param request: CreateJenkinsImageScanTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateJenkinsImageScanTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.jenkins_env):
            query['JenkinsEnv'] = request.jenkins_env
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        body = {}
        if not UtilClient.is_unset(request.digest):
            body['Digest'] = request.digest
        if not UtilClient.is_unset(request.image_create):
            body['ImageCreate'] = request.image_create
        if not UtilClient.is_unset(request.image_id):
            body['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_size):
            body['ImageSize'] = request.image_size
        if not UtilClient.is_unset(request.image_update):
            body['ImageUpdate'] = request.image_update
        if not UtilClient.is_unset(request.namespace):
            body['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.repo_name):
            body['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.tag):
            body['Tag'] = request.tag
        if not UtilClient.is_unset(request.token):
            body['Token'] = request.token
        if not UtilClient.is_unset(request.uuid):
            body['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateJenkinsImageScanTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateJenkinsImageScanTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_jenkins_image_scan_task(
        self,
        request: sas_20181203_models.CreateJenkinsImageScanTaskRequest,
    ) -> sas_20181203_models.CreateJenkinsImageScanTaskResponse:
        """
        @summary Creates a Jenkins scan task.
        
        @param request: CreateJenkinsImageScanTaskRequest
        @return: CreateJenkinsImageScanTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_jenkins_image_scan_task_with_options(request, runtime)

    async def create_jenkins_image_scan_task_async(
        self,
        request: sas_20181203_models.CreateJenkinsImageScanTaskRequest,
    ) -> sas_20181203_models.CreateJenkinsImageScanTaskResponse:
        """
        @summary Creates a Jenkins scan task.
        
        @param request: CreateJenkinsImageScanTaskRequest
        @return: CreateJenkinsImageScanTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_jenkins_image_scan_task_with_options_async(request, runtime)

    def create_malicious_file_whitelist_config_with_options(
        self,
        request: sas_20181203_models.CreateMaliciousFileWhitelistConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateMaliciousFileWhitelistConfigResponse:
        """
        @summary Creates an alert whitelist rule of sensitive files that are detected by using the agentless detection feature.
        
        @param request: CreateMaliciousFileWhitelistConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMaliciousFileWhitelistConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_name):
            query['EventName'] = request.event_name
        if not UtilClient.is_unset(request.field):
            query['Field'] = request.field
        if not UtilClient.is_unset(request.field_value):
            query['FieldValue'] = request.field_value
        if not UtilClient.is_unset(request.operator):
            query['Operator'] = request.operator
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.target_value):
            query['TargetValue'] = request.target_value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateMaliciousFileWhitelistConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateMaliciousFileWhitelistConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_malicious_file_whitelist_config_with_options_async(
        self,
        request: sas_20181203_models.CreateMaliciousFileWhitelistConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateMaliciousFileWhitelistConfigResponse:
        """
        @summary Creates an alert whitelist rule of sensitive files that are detected by using the agentless detection feature.
        
        @param request: CreateMaliciousFileWhitelistConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMaliciousFileWhitelistConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_name):
            query['EventName'] = request.event_name
        if not UtilClient.is_unset(request.field):
            query['Field'] = request.field
        if not UtilClient.is_unset(request.field_value):
            query['FieldValue'] = request.field_value
        if not UtilClient.is_unset(request.operator):
            query['Operator'] = request.operator
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.target_value):
            query['TargetValue'] = request.target_value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateMaliciousFileWhitelistConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateMaliciousFileWhitelistConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_malicious_file_whitelist_config(
        self,
        request: sas_20181203_models.CreateMaliciousFileWhitelistConfigRequest,
    ) -> sas_20181203_models.CreateMaliciousFileWhitelistConfigResponse:
        """
        @summary Creates an alert whitelist rule of sensitive files that are detected by using the agentless detection feature.
        
        @param request: CreateMaliciousFileWhitelistConfigRequest
        @return: CreateMaliciousFileWhitelistConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_malicious_file_whitelist_config_with_options(request, runtime)

    async def create_malicious_file_whitelist_config_async(
        self,
        request: sas_20181203_models.CreateMaliciousFileWhitelistConfigRequest,
    ) -> sas_20181203_models.CreateMaliciousFileWhitelistConfigResponse:
        """
        @summary Creates an alert whitelist rule of sensitive files that are detected by using the agentless detection feature.
        
        @param request: CreateMaliciousFileWhitelistConfigRequest
        @return: CreateMaliciousFileWhitelistConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_malicious_file_whitelist_config_with_options_async(request, runtime)

    def create_malicious_note_with_options(
        self,
        request: sas_20181203_models.CreateMaliciousNoteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateMaliciousNoteResponse:
        """
        @summary Adds remarks to alert events for agentless detection.
        
        @param request: CreateMaliciousNoteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMaliciousNoteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_id):
            query['EventId'] = request.event_id
        if not UtilClient.is_unset(request.note):
            query['Note'] = request.note
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateMaliciousNote',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateMaliciousNoteResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_malicious_note_with_options_async(
        self,
        request: sas_20181203_models.CreateMaliciousNoteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateMaliciousNoteResponse:
        """
        @summary Adds remarks to alert events for agentless detection.
        
        @param request: CreateMaliciousNoteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMaliciousNoteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_id):
            query['EventId'] = request.event_id
        if not UtilClient.is_unset(request.note):
            query['Note'] = request.note
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateMaliciousNote',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateMaliciousNoteResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_malicious_note(
        self,
        request: sas_20181203_models.CreateMaliciousNoteRequest,
    ) -> sas_20181203_models.CreateMaliciousNoteResponse:
        """
        @summary Adds remarks to alert events for agentless detection.
        
        @param request: CreateMaliciousNoteRequest
        @return: CreateMaliciousNoteResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_malicious_note_with_options(request, runtime)

    async def create_malicious_note_async(
        self,
        request: sas_20181203_models.CreateMaliciousNoteRequest,
    ) -> sas_20181203_models.CreateMaliciousNoteResponse:
        """
        @summary Adds remarks to alert events for agentless detection.
        
        @param request: CreateMaliciousNoteRequest
        @return: CreateMaliciousNoteResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_malicious_note_with_options_async(request, runtime)

    def create_monitor_account_with_options(
        self,
        request: sas_20181203_models.CreateMonitorAccountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateMonitorAccountResponse:
        """
        @summary Creates a list of members of the account monitored by Security Center type by using the multi-account management feature.
        
        @description You can call this operation only by using the management account of a resource directory or a delegated administrator account of Security Center.
        
        @param request: CreateMonitorAccountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMonitorAccountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_ids):
            query['AccountIds'] = request.account_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateMonitorAccount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateMonitorAccountResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_monitor_account_with_options_async(
        self,
        request: sas_20181203_models.CreateMonitorAccountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateMonitorAccountResponse:
        """
        @summary Creates a list of members of the account monitored by Security Center type by using the multi-account management feature.
        
        @description You can call this operation only by using the management account of a resource directory or a delegated administrator account of Security Center.
        
        @param request: CreateMonitorAccountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMonitorAccountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_ids):
            query['AccountIds'] = request.account_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateMonitorAccount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateMonitorAccountResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_monitor_account(
        self,
        request: sas_20181203_models.CreateMonitorAccountRequest,
    ) -> sas_20181203_models.CreateMonitorAccountResponse:
        """
        @summary Creates a list of members of the account monitored by Security Center type by using the multi-account management feature.
        
        @description You can call this operation only by using the management account of a resource directory or a delegated administrator account of Security Center.
        
        @param request: CreateMonitorAccountRequest
        @return: CreateMonitorAccountResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_monitor_account_with_options(request, runtime)

    async def create_monitor_account_async(
        self,
        request: sas_20181203_models.CreateMonitorAccountRequest,
    ) -> sas_20181203_models.CreateMonitorAccountResponse:
        """
        @summary Creates a list of members of the account monitored by Security Center type by using the multi-account management feature.
        
        @description You can call this operation only by using the management account of a resource directory or a delegated administrator account of Security Center.
        
        @param request: CreateMonitorAccountRequest
        @return: CreateMonitorAccountResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_monitor_account_with_options_async(request, runtime)

    def create_opa_cluster_plugin_with_options(
        self,
        request: sas_20181203_models.CreateOpaClusterPluginRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateOpaClusterPluginResponse:
        """
        @summary Installs the components that are required by at-risk image blocking. The components are policy-template-controller, gatekeeper, and logtail-ds.
        
        @param request: CreateOpaClusterPluginRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOpaClusterPluginResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_ids):
            query['ClusterIds'] = request.cluster_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateOpaClusterPlugin',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateOpaClusterPluginResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_opa_cluster_plugin_with_options_async(
        self,
        request: sas_20181203_models.CreateOpaClusterPluginRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateOpaClusterPluginResponse:
        """
        @summary Installs the components that are required by at-risk image blocking. The components are policy-template-controller, gatekeeper, and logtail-ds.
        
        @param request: CreateOpaClusterPluginRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOpaClusterPluginResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_ids):
            query['ClusterIds'] = request.cluster_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateOpaClusterPlugin',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateOpaClusterPluginResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_opa_cluster_plugin(
        self,
        request: sas_20181203_models.CreateOpaClusterPluginRequest,
    ) -> sas_20181203_models.CreateOpaClusterPluginResponse:
        """
        @summary Installs the components that are required by at-risk image blocking. The components are policy-template-controller, gatekeeper, and logtail-ds.
        
        @param request: CreateOpaClusterPluginRequest
        @return: CreateOpaClusterPluginResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_opa_cluster_plugin_with_options(request, runtime)

    async def create_opa_cluster_plugin_async(
        self,
        request: sas_20181203_models.CreateOpaClusterPluginRequest,
    ) -> sas_20181203_models.CreateOpaClusterPluginResponse:
        """
        @summary Installs the components that are required by at-risk image blocking. The components are policy-template-controller, gatekeeper, and logtail-ds.
        
        @param request: CreateOpaClusterPluginRequest
        @return: CreateOpaClusterPluginResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_opa_cluster_plugin_with_options_async(request, runtime)

    def create_opa_strategy_new_with_options(
        self,
        tmp_req: sas_20181203_models.CreateOpaStrategyNewRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateOpaStrategyNewResponse:
        """
        @summary Creates a rule to block at-risk images.
        
        @param tmp_req: CreateOpaStrategyNewRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOpaStrategyNewResponse
        """
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.CreateOpaStrategyNewShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.alarm_detail):
            request.alarm_detail_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.alarm_detail, 'AlarmDetail', 'json')
        query = {}
        if not UtilClient.is_unset(request.alarm_detail_shrink):
            query['AlarmDetail'] = request.alarm_detail_shrink
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.label):
            query['Label'] = request.label
        if not UtilClient.is_unset(request.malicious_image):
            query['MaliciousImage'] = request.malicious_image
        if not UtilClient.is_unset(request.rule_action):
            query['RuleAction'] = request.rule_action
        if not UtilClient.is_unset(request.scopes):
            query['Scopes'] = request.scopes
        if not UtilClient.is_unset(request.strategy_id):
            query['StrategyId'] = request.strategy_id
        if not UtilClient.is_unset(request.strategy_name):
            query['StrategyName'] = request.strategy_name
        if not UtilClient.is_unset(request.strategy_template_id):
            query['StrategyTemplateId'] = request.strategy_template_id
        if not UtilClient.is_unset(request.un_scaned_image):
            query['UnScanedImage'] = request.un_scaned_image
        if not UtilClient.is_unset(request.white_list):
            query['WhiteList'] = request.white_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateOpaStrategyNew',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateOpaStrategyNewResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_opa_strategy_new_with_options_async(
        self,
        tmp_req: sas_20181203_models.CreateOpaStrategyNewRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateOpaStrategyNewResponse:
        """
        @summary Creates a rule to block at-risk images.
        
        @param tmp_req: CreateOpaStrategyNewRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOpaStrategyNewResponse
        """
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.CreateOpaStrategyNewShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.alarm_detail):
            request.alarm_detail_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.alarm_detail, 'AlarmDetail', 'json')
        query = {}
        if not UtilClient.is_unset(request.alarm_detail_shrink):
            query['AlarmDetail'] = request.alarm_detail_shrink
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.label):
            query['Label'] = request.label
        if not UtilClient.is_unset(request.malicious_image):
            query['MaliciousImage'] = request.malicious_image
        if not UtilClient.is_unset(request.rule_action):
            query['RuleAction'] = request.rule_action
        if not UtilClient.is_unset(request.scopes):
            query['Scopes'] = request.scopes
        if not UtilClient.is_unset(request.strategy_id):
            query['StrategyId'] = request.strategy_id
        if not UtilClient.is_unset(request.strategy_name):
            query['StrategyName'] = request.strategy_name
        if not UtilClient.is_unset(request.strategy_template_id):
            query['StrategyTemplateId'] = request.strategy_template_id
        if not UtilClient.is_unset(request.un_scaned_image):
            query['UnScanedImage'] = request.un_scaned_image
        if not UtilClient.is_unset(request.white_list):
            query['WhiteList'] = request.white_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateOpaStrategyNew',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateOpaStrategyNewResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_opa_strategy_new(
        self,
        request: sas_20181203_models.CreateOpaStrategyNewRequest,
    ) -> sas_20181203_models.CreateOpaStrategyNewResponse:
        """
        @summary Creates a rule to block at-risk images.
        
        @param request: CreateOpaStrategyNewRequest
        @return: CreateOpaStrategyNewResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_opa_strategy_new_with_options(request, runtime)

    async def create_opa_strategy_new_async(
        self,
        request: sas_20181203_models.CreateOpaStrategyNewRequest,
    ) -> sas_20181203_models.CreateOpaStrategyNewResponse:
        """
        @summary Creates a rule to block at-risk images.
        
        @param request: CreateOpaStrategyNewRequest
        @return: CreateOpaStrategyNewResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_opa_strategy_new_with_options_async(request, runtime)

    def create_or_update_asset_group_with_options(
        self,
        request: sas_20181203_models.CreateOrUpdateAssetGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateOrUpdateAssetGroupResponse:
        """
        @summary Modifies the mapping between an asset and an asset group. For example, you can call this operation to modify the server group to which the asset belongs or the asset list of the asset group.
        
        @description A server can belong only to one server group. If you call the CreateOrUpdateAssetGroup operation and the server specified in request parameters belongs to Server Group A, the server is removed from Server Group A and then added to the newly created or specified server group after the call is complete.
        
        @param request: CreateOrUpdateAssetGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOrUpdateAssetGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateOrUpdateAssetGroup',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateOrUpdateAssetGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_or_update_asset_group_with_options_async(
        self,
        request: sas_20181203_models.CreateOrUpdateAssetGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateOrUpdateAssetGroupResponse:
        """
        @summary Modifies the mapping between an asset and an asset group. For example, you can call this operation to modify the server group to which the asset belongs or the asset list of the asset group.
        
        @description A server can belong only to one server group. If you call the CreateOrUpdateAssetGroup operation and the server specified in request parameters belongs to Server Group A, the server is removed from Server Group A and then added to the newly created or specified server group after the call is complete.
        
        @param request: CreateOrUpdateAssetGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOrUpdateAssetGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateOrUpdateAssetGroup',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateOrUpdateAssetGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_or_update_asset_group(
        self,
        request: sas_20181203_models.CreateOrUpdateAssetGroupRequest,
    ) -> sas_20181203_models.CreateOrUpdateAssetGroupResponse:
        """
        @summary Modifies the mapping between an asset and an asset group. For example, you can call this operation to modify the server group to which the asset belongs or the asset list of the asset group.
        
        @description A server can belong only to one server group. If you call the CreateOrUpdateAssetGroup operation and the server specified in request parameters belongs to Server Group A, the server is removed from Server Group A and then added to the newly created or specified server group after the call is complete.
        
        @param request: CreateOrUpdateAssetGroupRequest
        @return: CreateOrUpdateAssetGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_or_update_asset_group_with_options(request, runtime)

    async def create_or_update_asset_group_async(
        self,
        request: sas_20181203_models.CreateOrUpdateAssetGroupRequest,
    ) -> sas_20181203_models.CreateOrUpdateAssetGroupResponse:
        """
        @summary Modifies the mapping between an asset and an asset group. For example, you can call this operation to modify the server group to which the asset belongs or the asset list of the asset group.
        
        @description A server can belong only to one server group. If you call the CreateOrUpdateAssetGroup operation and the server specified in request parameters belongs to Server Group A, the server is removed from Server Group A and then added to the newly created or specified server group after the call is complete.
        
        @param request: CreateOrUpdateAssetGroupRequest
        @return: CreateOrUpdateAssetGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_or_update_asset_group_with_options_async(request, runtime)

    def create_or_update_auto_tag_rule_with_options(
        self,
        request: sas_20181203_models.CreateOrUpdateAutoTagRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateOrUpdateAutoTagRuleResponse:
        """
        @summary Creates an asset auto-tagging rule or modifies an asset auto-tagging rule that is created on the Asset Management Rule tab.
        
        @param request: CreateOrUpdateAutoTagRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOrUpdateAutoTagRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_all):
            query['CheckAll'] = request.check_all
        if not UtilClient.is_unset(request.expression):
            query['Expression'] = request.expression
        if not UtilClient.is_unset(request.rule_desc):
            query['RuleDesc'] = request.rule_desc
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        if not UtilClient.is_unset(request.rule_name):
            query['RuleName'] = request.rule_name
        if not UtilClient.is_unset(request.tag_context):
            query['TagContext'] = request.tag_context
        if not UtilClient.is_unset(request.tag_type):
            query['TagType'] = request.tag_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateOrUpdateAutoTagRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateOrUpdateAutoTagRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_or_update_auto_tag_rule_with_options_async(
        self,
        request: sas_20181203_models.CreateOrUpdateAutoTagRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateOrUpdateAutoTagRuleResponse:
        """
        @summary Creates an asset auto-tagging rule or modifies an asset auto-tagging rule that is created on the Asset Management Rule tab.
        
        @param request: CreateOrUpdateAutoTagRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOrUpdateAutoTagRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_all):
            query['CheckAll'] = request.check_all
        if not UtilClient.is_unset(request.expression):
            query['Expression'] = request.expression
        if not UtilClient.is_unset(request.rule_desc):
            query['RuleDesc'] = request.rule_desc
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        if not UtilClient.is_unset(request.rule_name):
            query['RuleName'] = request.rule_name
        if not UtilClient.is_unset(request.tag_context):
            query['TagContext'] = request.tag_context
        if not UtilClient.is_unset(request.tag_type):
            query['TagType'] = request.tag_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateOrUpdateAutoTagRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateOrUpdateAutoTagRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_or_update_auto_tag_rule(
        self,
        request: sas_20181203_models.CreateOrUpdateAutoTagRuleRequest,
    ) -> sas_20181203_models.CreateOrUpdateAutoTagRuleResponse:
        """
        @summary Creates an asset auto-tagging rule or modifies an asset auto-tagging rule that is created on the Asset Management Rule tab.
        
        @param request: CreateOrUpdateAutoTagRuleRequest
        @return: CreateOrUpdateAutoTagRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_or_update_auto_tag_rule_with_options(request, runtime)

    async def create_or_update_auto_tag_rule_async(
        self,
        request: sas_20181203_models.CreateOrUpdateAutoTagRuleRequest,
    ) -> sas_20181203_models.CreateOrUpdateAutoTagRuleResponse:
        """
        @summary Creates an asset auto-tagging rule or modifies an asset auto-tagging rule that is created on the Asset Management Rule tab.
        
        @param request: CreateOrUpdateAutoTagRuleRequest
        @return: CreateOrUpdateAutoTagRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_or_update_auto_tag_rule_with_options_async(request, runtime)

    def create_or_update_ding_talk_with_options(
        self,
        request: sas_20181203_models.CreateOrUpdateDingTalkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateOrUpdateDingTalkResponse:
        """
        @summary Creates or modifies a DingTalk chatbot that sends notifications.
        
        @param request: CreateOrUpdateDingTalkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOrUpdateDingTalkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config_list):
            query['ConfigList'] = request.config_list
        if not UtilClient.is_unset(request.ding_talk_lang):
            query['DingTalkLang'] = request.ding_talk_lang
        if not UtilClient.is_unset(request.group_id_list):
            query['GroupIdList'] = request.group_id_list
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.interval_time):
            query['IntervalTime'] = request.interval_time
        if not UtilClient.is_unset(request.rule_action_name):
            query['RuleActionName'] = request.rule_action_name
        if not UtilClient.is_unset(request.send_url):
            query['SendUrl'] = request.send_url
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateOrUpdateDingTalk',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateOrUpdateDingTalkResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_or_update_ding_talk_with_options_async(
        self,
        request: sas_20181203_models.CreateOrUpdateDingTalkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateOrUpdateDingTalkResponse:
        """
        @summary Creates or modifies a DingTalk chatbot that sends notifications.
        
        @param request: CreateOrUpdateDingTalkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOrUpdateDingTalkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config_list):
            query['ConfigList'] = request.config_list
        if not UtilClient.is_unset(request.ding_talk_lang):
            query['DingTalkLang'] = request.ding_talk_lang
        if not UtilClient.is_unset(request.group_id_list):
            query['GroupIdList'] = request.group_id_list
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.interval_time):
            query['IntervalTime'] = request.interval_time
        if not UtilClient.is_unset(request.rule_action_name):
            query['RuleActionName'] = request.rule_action_name
        if not UtilClient.is_unset(request.send_url):
            query['SendUrl'] = request.send_url
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateOrUpdateDingTalk',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateOrUpdateDingTalkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_or_update_ding_talk(
        self,
        request: sas_20181203_models.CreateOrUpdateDingTalkRequest,
    ) -> sas_20181203_models.CreateOrUpdateDingTalkResponse:
        """
        @summary Creates or modifies a DingTalk chatbot that sends notifications.
        
        @param request: CreateOrUpdateDingTalkRequest
        @return: CreateOrUpdateDingTalkResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_or_update_ding_talk_with_options(request, runtime)

    async def create_or_update_ding_talk_async(
        self,
        request: sas_20181203_models.CreateOrUpdateDingTalkRequest,
    ) -> sas_20181203_models.CreateOrUpdateDingTalkResponse:
        """
        @summary Creates or modifies a DingTalk chatbot that sends notifications.
        
        @param request: CreateOrUpdateDingTalkRequest
        @return: CreateOrUpdateDingTalkResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_or_update_ding_talk_with_options_async(request, runtime)

    def create_oss_bucket_scan_task_with_options(
        self,
        request: sas_20181203_models.CreateOssBucketScanTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateOssBucketScanTaskResponse:
        """
        @summary Creates a bucket check task.
        
        @param request: CreateOssBucketScanTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOssBucketScanTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.all_key_prefix):
            query['AllKeyPrefix'] = request.all_key_prefix
        if not UtilClient.is_unset(request.bucket_name_list):
            query['BucketNameList'] = request.bucket_name_list
        if not UtilClient.is_unset(request.decompress_max_file_count):
            query['DecompressMaxFileCount'] = request.decompress_max_file_count
        if not UtilClient.is_unset(request.decompress_max_layer):
            query['DecompressMaxLayer'] = request.decompress_max_layer
        if not UtilClient.is_unset(request.decryption_list):
            query['DecryptionList'] = request.decryption_list
        if not UtilClient.is_unset(request.exclude_key_suffix_list):
            query['ExcludeKeySuffixList'] = request.exclude_key_suffix_list
        if not UtilClient.is_unset(request.key_prefix_list):
            query['KeyPrefixList'] = request.key_prefix_list
        if not UtilClient.is_unset(request.key_suffix_list):
            query['KeySuffixList'] = request.key_suffix_list
        if not UtilClient.is_unset(request.last_modified_start_time):
            query['LastModifiedStartTime'] = request.last_modified_start_time
        if not UtilClient.is_unset(request.scan_mode):
            query['ScanMode'] = request.scan_mode
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateOssBucketScanTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateOssBucketScanTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_oss_bucket_scan_task_with_options_async(
        self,
        request: sas_20181203_models.CreateOssBucketScanTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateOssBucketScanTaskResponse:
        """
        @summary Creates a bucket check task.
        
        @param request: CreateOssBucketScanTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOssBucketScanTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.all_key_prefix):
            query['AllKeyPrefix'] = request.all_key_prefix
        if not UtilClient.is_unset(request.bucket_name_list):
            query['BucketNameList'] = request.bucket_name_list
        if not UtilClient.is_unset(request.decompress_max_file_count):
            query['DecompressMaxFileCount'] = request.decompress_max_file_count
        if not UtilClient.is_unset(request.decompress_max_layer):
            query['DecompressMaxLayer'] = request.decompress_max_layer
        if not UtilClient.is_unset(request.decryption_list):
            query['DecryptionList'] = request.decryption_list
        if not UtilClient.is_unset(request.exclude_key_suffix_list):
            query['ExcludeKeySuffixList'] = request.exclude_key_suffix_list
        if not UtilClient.is_unset(request.key_prefix_list):
            query['KeyPrefixList'] = request.key_prefix_list
        if not UtilClient.is_unset(request.key_suffix_list):
            query['KeySuffixList'] = request.key_suffix_list
        if not UtilClient.is_unset(request.last_modified_start_time):
            query['LastModifiedStartTime'] = request.last_modified_start_time
        if not UtilClient.is_unset(request.scan_mode):
            query['ScanMode'] = request.scan_mode
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateOssBucketScanTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateOssBucketScanTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_oss_bucket_scan_task(
        self,
        request: sas_20181203_models.CreateOssBucketScanTaskRequest,
    ) -> sas_20181203_models.CreateOssBucketScanTaskResponse:
        """
        @summary Creates a bucket check task.
        
        @param request: CreateOssBucketScanTaskRequest
        @return: CreateOssBucketScanTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_oss_bucket_scan_task_with_options(request, runtime)

    async def create_oss_bucket_scan_task_async(
        self,
        request: sas_20181203_models.CreateOssBucketScanTaskRequest,
    ) -> sas_20181203_models.CreateOssBucketScanTaskResponse:
        """
        @summary Creates a bucket check task.
        
        @param request: CreateOssBucketScanTaskRequest
        @return: CreateOssBucketScanTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_oss_bucket_scan_task_with_options_async(request, runtime)

    def create_oss_scan_config_with_options(
        self,
        request: sas_20181203_models.CreateOssScanConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateOssScanConfigResponse:
        """
        @summary Creates a policy for detecting malicious Object Storage Service (OSS) objects by using the SDK for malicious file detection feature.
        
        @param request: CreateOssScanConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOssScanConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.all_key_prefix):
            query['AllKeyPrefix'] = request.all_key_prefix
        if not UtilClient.is_unset(request.bucket_name_list):
            query['BucketNameList'] = request.bucket_name_list
        if not UtilClient.is_unset(request.decompress_max_file_count):
            query['DecompressMaxFileCount'] = request.decompress_max_file_count
        if not UtilClient.is_unset(request.decompress_max_layer):
            query['DecompressMaxLayer'] = request.decompress_max_layer
        if not UtilClient.is_unset(request.decryption_list):
            query['DecryptionList'] = request.decryption_list
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.key_prefix_list):
            query['KeyPrefixList'] = request.key_prefix_list
        if not UtilClient.is_unset(request.key_suffix_list):
            query['KeySuffixList'] = request.key_suffix_list
        if not UtilClient.is_unset(request.last_modified_start_time):
            query['LastModifiedStartTime'] = request.last_modified_start_time
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.real_time_incr):
            query['RealTimeIncr'] = request.real_time_incr
        if not UtilClient.is_unset(request.scan_day_list):
            query['ScanDayList'] = request.scan_day_list
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateOssScanConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateOssScanConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_oss_scan_config_with_options_async(
        self,
        request: sas_20181203_models.CreateOssScanConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateOssScanConfigResponse:
        """
        @summary Creates a policy for detecting malicious Object Storage Service (OSS) objects by using the SDK for malicious file detection feature.
        
        @param request: CreateOssScanConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOssScanConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.all_key_prefix):
            query['AllKeyPrefix'] = request.all_key_prefix
        if not UtilClient.is_unset(request.bucket_name_list):
            query['BucketNameList'] = request.bucket_name_list
        if not UtilClient.is_unset(request.decompress_max_file_count):
            query['DecompressMaxFileCount'] = request.decompress_max_file_count
        if not UtilClient.is_unset(request.decompress_max_layer):
            query['DecompressMaxLayer'] = request.decompress_max_layer
        if not UtilClient.is_unset(request.decryption_list):
            query['DecryptionList'] = request.decryption_list
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.key_prefix_list):
            query['KeyPrefixList'] = request.key_prefix_list
        if not UtilClient.is_unset(request.key_suffix_list):
            query['KeySuffixList'] = request.key_suffix_list
        if not UtilClient.is_unset(request.last_modified_start_time):
            query['LastModifiedStartTime'] = request.last_modified_start_time
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.real_time_incr):
            query['RealTimeIncr'] = request.real_time_incr
        if not UtilClient.is_unset(request.scan_day_list):
            query['ScanDayList'] = request.scan_day_list
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateOssScanConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateOssScanConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_oss_scan_config(
        self,
        request: sas_20181203_models.CreateOssScanConfigRequest,
    ) -> sas_20181203_models.CreateOssScanConfigResponse:
        """
        @summary Creates a policy for detecting malicious Object Storage Service (OSS) objects by using the SDK for malicious file detection feature.
        
        @param request: CreateOssScanConfigRequest
        @return: CreateOssScanConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_oss_scan_config_with_options(request, runtime)

    async def create_oss_scan_config_async(
        self,
        request: sas_20181203_models.CreateOssScanConfigRequest,
    ) -> sas_20181203_models.CreateOssScanConfigResponse:
        """
        @summary Creates a policy for detecting malicious Object Storage Service (OSS) objects by using the SDK for malicious file detection feature.
        
        @param request: CreateOssScanConfigRequest
        @return: CreateOssScanConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_oss_scan_config_with_options_async(request, runtime)

    def create_rd_default_sync_list_with_options(
        self,
        request: sas_20181203_models.CreateRdDefaultSyncListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateRdDefaultSyncListResponse:
        """
        @summary Creates an automatic account management policy for members of the account monitored by Security Center type by using the multi-account management feature. After the policy is created, the members that are newly added to the specified resource directory are automatically added to the list of members of the account monitored by Security Center type.
        
        @description You can call this operation only by using the management account of a resource directory or a delegated administrator account of Security Center.
        
        @param request: CreateRdDefaultSyncListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRdDefaultSyncListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.folder_ids):
            query['FolderIds'] = request.folder_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRdDefaultSyncList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateRdDefaultSyncListResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_rd_default_sync_list_with_options_async(
        self,
        request: sas_20181203_models.CreateRdDefaultSyncListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateRdDefaultSyncListResponse:
        """
        @summary Creates an automatic account management policy for members of the account monitored by Security Center type by using the multi-account management feature. After the policy is created, the members that are newly added to the specified resource directory are automatically added to the list of members of the account monitored by Security Center type.
        
        @description You can call this operation only by using the management account of a resource directory or a delegated administrator account of Security Center.
        
        @param request: CreateRdDefaultSyncListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRdDefaultSyncListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.folder_ids):
            query['FolderIds'] = request.folder_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRdDefaultSyncList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateRdDefaultSyncListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_rd_default_sync_list(
        self,
        request: sas_20181203_models.CreateRdDefaultSyncListRequest,
    ) -> sas_20181203_models.CreateRdDefaultSyncListResponse:
        """
        @summary Creates an automatic account management policy for members of the account monitored by Security Center type by using the multi-account management feature. After the policy is created, the members that are newly added to the specified resource directory are automatically added to the list of members of the account monitored by Security Center type.
        
        @description You can call this operation only by using the management account of a resource directory or a delegated administrator account of Security Center.
        
        @param request: CreateRdDefaultSyncListRequest
        @return: CreateRdDefaultSyncListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_rd_default_sync_list_with_options(request, runtime)

    async def create_rd_default_sync_list_async(
        self,
        request: sas_20181203_models.CreateRdDefaultSyncListRequest,
    ) -> sas_20181203_models.CreateRdDefaultSyncListResponse:
        """
        @summary Creates an automatic account management policy for members of the account monitored by Security Center type by using the multi-account management feature. After the policy is created, the members that are newly added to the specified resource directory are automatically added to the list of members of the account monitored by Security Center type.
        
        @description You can call this operation only by using the management account of a resource directory or a delegated administrator account of Security Center.
        
        @param request: CreateRdDefaultSyncListRequest
        @return: CreateRdDefaultSyncListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_rd_default_sync_list_with_options_async(request, runtime)

    def create_restore_job_with_options(
        self,
        request: sas_20181203_models.CreateRestoreJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateRestoreJobResponse:
        """
        @summary Creates a restoration task.
        
        @param request: CreateRestoreJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRestoreJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.includes):
            query['Includes'] = request.includes
        if not UtilClient.is_unset(request.snapshot_hash):
            query['SnapshotHash'] = request.snapshot_hash
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.snapshot_version):
            query['SnapshotVersion'] = request.snapshot_version
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        if not UtilClient.is_unset(request.target):
            query['Target'] = request.target
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        if not UtilClient.is_unset(request.vault_id):
            query['VaultId'] = request.vault_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRestoreJob',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateRestoreJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_restore_job_with_options_async(
        self,
        request: sas_20181203_models.CreateRestoreJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateRestoreJobResponse:
        """
        @summary Creates a restoration task.
        
        @param request: CreateRestoreJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRestoreJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.includes):
            query['Includes'] = request.includes
        if not UtilClient.is_unset(request.snapshot_hash):
            query['SnapshotHash'] = request.snapshot_hash
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.snapshot_version):
            query['SnapshotVersion'] = request.snapshot_version
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        if not UtilClient.is_unset(request.target):
            query['Target'] = request.target
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        if not UtilClient.is_unset(request.vault_id):
            query['VaultId'] = request.vault_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRestoreJob',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateRestoreJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_restore_job(
        self,
        request: sas_20181203_models.CreateRestoreJobRequest,
    ) -> sas_20181203_models.CreateRestoreJobResponse:
        """
        @summary Creates a restoration task.
        
        @param request: CreateRestoreJobRequest
        @return: CreateRestoreJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_restore_job_with_options(request, runtime)

    async def create_restore_job_async(
        self,
        request: sas_20181203_models.CreateRestoreJobRequest,
    ) -> sas_20181203_models.CreateRestoreJobResponse:
        """
        @summary Creates a restoration task.
        
        @param request: CreateRestoreJobRequest
        @return: CreateRestoreJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_restore_job_with_options_async(request, runtime)

    def create_sas_trial_with_options(
        self,
        tmp_req: sas_20181203_models.CreateSasTrialRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateSasTrialResponse:
        """
        @summary Applies for a trial of Security Center.
        
        @param tmp_req: CreateSasTrialRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSasTrialResponse
        """
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.CreateSasTrialShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.request_form):
            request.request_form_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.request_form, 'RequestForm', 'json')
        body = {}
        if not UtilClient.is_unset(request.from_ecs):
            body['FromEcs'] = request.from_ecs
        if not UtilClient.is_unset(request.lang):
            body['Lang'] = request.lang
        if not UtilClient.is_unset(request.request_form_shrink):
            body['RequestForm'] = request.request_form_shrink
        if not UtilClient.is_unset(request.try_type):
            body['TryType'] = request.try_type
        if not UtilClient.is_unset(request.try_version):
            body['TryVersion'] = request.try_version
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateSasTrial',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateSasTrialResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_sas_trial_with_options_async(
        self,
        tmp_req: sas_20181203_models.CreateSasTrialRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateSasTrialResponse:
        """
        @summary Applies for a trial of Security Center.
        
        @param tmp_req: CreateSasTrialRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSasTrialResponse
        """
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.CreateSasTrialShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.request_form):
            request.request_form_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.request_form, 'RequestForm', 'json')
        body = {}
        if not UtilClient.is_unset(request.from_ecs):
            body['FromEcs'] = request.from_ecs
        if not UtilClient.is_unset(request.lang):
            body['Lang'] = request.lang
        if not UtilClient.is_unset(request.request_form_shrink):
            body['RequestForm'] = request.request_form_shrink
        if not UtilClient.is_unset(request.try_type):
            body['TryType'] = request.try_type
        if not UtilClient.is_unset(request.try_version):
            body['TryVersion'] = request.try_version
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateSasTrial',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateSasTrialResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_sas_trial(
        self,
        request: sas_20181203_models.CreateSasTrialRequest,
    ) -> sas_20181203_models.CreateSasTrialResponse:
        """
        @summary Applies for a trial of Security Center.
        
        @param request: CreateSasTrialRequest
        @return: CreateSasTrialResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_sas_trial_with_options(request, runtime)

    async def create_sas_trial_async(
        self,
        request: sas_20181203_models.CreateSasTrialRequest,
    ) -> sas_20181203_models.CreateSasTrialResponse:
        """
        @summary Applies for a trial of Security Center.
        
        @param request: CreateSasTrialRequest
        @return: CreateSasTrialResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_sas_trial_with_options_async(request, runtime)

    def create_service_linked_role_with_options(
        self,
        request: sas_20181203_models.CreateServiceLinkedRoleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateServiceLinkedRoleResponse:
        """
        @summary Creates a service-linked role and authorizes Security Center to access cloud resources.
        
        @description For more information about service-linked roles, see [Service-linked roles](https://help.aliyun.com/document_detail/160674.html).
        
        @param request: CreateServiceLinkedRoleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateServiceLinkedRoleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.service_linked_role):
            query['ServiceLinkedRole'] = request.service_linked_role
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateServiceLinkedRole',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateServiceLinkedRoleResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_service_linked_role_with_options_async(
        self,
        request: sas_20181203_models.CreateServiceLinkedRoleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateServiceLinkedRoleResponse:
        """
        @summary Creates a service-linked role and authorizes Security Center to access cloud resources.
        
        @description For more information about service-linked roles, see [Service-linked roles](https://help.aliyun.com/document_detail/160674.html).
        
        @param request: CreateServiceLinkedRoleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateServiceLinkedRoleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.service_linked_role):
            query['ServiceLinkedRole'] = request.service_linked_role
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateServiceLinkedRole',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateServiceLinkedRoleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_service_linked_role(
        self,
        request: sas_20181203_models.CreateServiceLinkedRoleRequest,
    ) -> sas_20181203_models.CreateServiceLinkedRoleResponse:
        """
        @summary Creates a service-linked role and authorizes Security Center to access cloud resources.
        
        @description For more information about service-linked roles, see [Service-linked roles](https://help.aliyun.com/document_detail/160674.html).
        
        @param request: CreateServiceLinkedRoleRequest
        @return: CreateServiceLinkedRoleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_service_linked_role_with_options(request, runtime)

    async def create_service_linked_role_async(
        self,
        request: sas_20181203_models.CreateServiceLinkedRoleRequest,
    ) -> sas_20181203_models.CreateServiceLinkedRoleResponse:
        """
        @summary Creates a service-linked role and authorizes Security Center to access cloud resources.
        
        @description For more information about service-linked roles, see [Service-linked roles](https://help.aliyun.com/document_detail/160674.html).
        
        @param request: CreateServiceLinkedRoleRequest
        @return: CreateServiceLinkedRoleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_service_linked_role_with_options_async(request, runtime)

    def create_service_trail_with_options(
        self,
        request: sas_20181203_models.CreateServiceTrailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateServiceTrailResponse:
        """
        @summary Create a service trail.
        
        @param request: CreateServiceTrailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateServiceTrailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateServiceTrail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateServiceTrailResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_service_trail_with_options_async(
        self,
        request: sas_20181203_models.CreateServiceTrailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateServiceTrailResponse:
        """
        @summary Create a service trail.
        
        @param request: CreateServiceTrailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateServiceTrailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateServiceTrail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateServiceTrailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_service_trail(
        self,
        request: sas_20181203_models.CreateServiceTrailRequest,
    ) -> sas_20181203_models.CreateServiceTrailResponse:
        """
        @summary Create a service trail.
        
        @param request: CreateServiceTrailRequest
        @return: CreateServiceTrailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_service_trail_with_options(request, runtime)

    async def create_service_trail_async(
        self,
        request: sas_20181203_models.CreateServiceTrailRequest,
    ) -> sas_20181203_models.CreateServiceTrailResponse:
        """
        @summary Create a service trail.
        
        @param request: CreateServiceTrailRequest
        @return: CreateServiceTrailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_service_trail_with_options_async(request, runtime)

    def create_similar_security_events_query_task_with_options(
        self,
        request: sas_20181203_models.CreateSimilarSecurityEventsQueryTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateSimilarSecurityEventsQueryTaskResponse:
        """
        @summary Creates a task to query alert events that are triggered by the same rule or of the same alert type.
        
        @param request: CreateSimilarSecurityEventsQueryTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSimilarSecurityEventsQueryTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_event_id):
            query['SecurityEventId'] = request.security_event_id
        if not UtilClient.is_unset(request.similar_event_scenario_code):
            query['SimilarEventScenarioCode'] = request.similar_event_scenario_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSimilarSecurityEventsQueryTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateSimilarSecurityEventsQueryTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_similar_security_events_query_task_with_options_async(
        self,
        request: sas_20181203_models.CreateSimilarSecurityEventsQueryTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateSimilarSecurityEventsQueryTaskResponse:
        """
        @summary Creates a task to query alert events that are triggered by the same rule or of the same alert type.
        
        @param request: CreateSimilarSecurityEventsQueryTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSimilarSecurityEventsQueryTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_event_id):
            query['SecurityEventId'] = request.security_event_id
        if not UtilClient.is_unset(request.similar_event_scenario_code):
            query['SimilarEventScenarioCode'] = request.similar_event_scenario_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSimilarSecurityEventsQueryTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateSimilarSecurityEventsQueryTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_similar_security_events_query_task(
        self,
        request: sas_20181203_models.CreateSimilarSecurityEventsQueryTaskRequest,
    ) -> sas_20181203_models.CreateSimilarSecurityEventsQueryTaskResponse:
        """
        @summary Creates a task to query alert events that are triggered by the same rule or of the same alert type.
        
        @param request: CreateSimilarSecurityEventsQueryTaskRequest
        @return: CreateSimilarSecurityEventsQueryTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_similar_security_events_query_task_with_options(request, runtime)

    async def create_similar_security_events_query_task_async(
        self,
        request: sas_20181203_models.CreateSimilarSecurityEventsQueryTaskRequest,
    ) -> sas_20181203_models.CreateSimilarSecurityEventsQueryTaskResponse:
        """
        @summary Creates a task to query alert events that are triggered by the same rule or of the same alert type.
        
        @param request: CreateSimilarSecurityEventsQueryTaskRequest
        @return: CreateSimilarSecurityEventsQueryTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_similar_security_events_query_task_with_options_async(request, runtime)

    def create_soar_strategy_task_with_options(
        self,
        request: sas_20181203_models.CreateSoarStrategyTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateSoarStrategyTaskResponse:
        """
        @summary Creates a task on the My Policies tab of the Playbook page.
        
        @description Only the Enterprise and Ultimate editions of Security Center support this API operation.
        
        @param request: CreateSoarStrategyTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSoarStrategyTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.strategy_id):
            query['StrategyId'] = request.strategy_id
        if not UtilClient.is_unset(request.strategy_name):
            query['StrategyName'] = request.strategy_name
        if not UtilClient.is_unset(request.strategy_task_name):
            query['StrategyTaskName'] = request.strategy_task_name
        if not UtilClient.is_unset(request.strategy_task_params):
            query['StrategyTaskParams'] = request.strategy_task_params
        if not UtilClient.is_unset(request.strategy_task_plan_exe_time):
            query['StrategyTaskPlanExeTime'] = request.strategy_task_plan_exe_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSoarStrategyTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateSoarStrategyTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_soar_strategy_task_with_options_async(
        self,
        request: sas_20181203_models.CreateSoarStrategyTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateSoarStrategyTaskResponse:
        """
        @summary Creates a task on the My Policies tab of the Playbook page.
        
        @description Only the Enterprise and Ultimate editions of Security Center support this API operation.
        
        @param request: CreateSoarStrategyTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSoarStrategyTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.strategy_id):
            query['StrategyId'] = request.strategy_id
        if not UtilClient.is_unset(request.strategy_name):
            query['StrategyName'] = request.strategy_name
        if not UtilClient.is_unset(request.strategy_task_name):
            query['StrategyTaskName'] = request.strategy_task_name
        if not UtilClient.is_unset(request.strategy_task_params):
            query['StrategyTaskParams'] = request.strategy_task_params
        if not UtilClient.is_unset(request.strategy_task_plan_exe_time):
            query['StrategyTaskPlanExeTime'] = request.strategy_task_plan_exe_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSoarStrategyTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateSoarStrategyTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_soar_strategy_task(
        self,
        request: sas_20181203_models.CreateSoarStrategyTaskRequest,
    ) -> sas_20181203_models.CreateSoarStrategyTaskResponse:
        """
        @summary Creates a task on the My Policies tab of the Playbook page.
        
        @description Only the Enterprise and Ultimate editions of Security Center support this API operation.
        
        @param request: CreateSoarStrategyTaskRequest
        @return: CreateSoarStrategyTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_soar_strategy_task_with_options(request, runtime)

    async def create_soar_strategy_task_async(
        self,
        request: sas_20181203_models.CreateSoarStrategyTaskRequest,
    ) -> sas_20181203_models.CreateSoarStrategyTaskResponse:
        """
        @summary Creates a task on the My Policies tab of the Playbook page.
        
        @description Only the Enterprise and Ultimate editions of Security Center support this API operation.
        
        @param request: CreateSoarStrategyTaskRequest
        @return: CreateSoarStrategyTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_soar_strategy_task_with_options_async(request, runtime)

    def create_susp_event_note_with_options(
        self,
        request: sas_20181203_models.CreateSuspEventNoteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateSuspEventNoteResponse:
        """
        @summary Adds remarks to an alert event.
        
        @param request: CreateSuspEventNoteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSuspEventNoteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_id):
            query['EventId'] = request.event_id
        if not UtilClient.is_unset(request.note):
            query['Note'] = request.note
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSuspEventNote',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateSuspEventNoteResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_susp_event_note_with_options_async(
        self,
        request: sas_20181203_models.CreateSuspEventNoteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateSuspEventNoteResponse:
        """
        @summary Adds remarks to an alert event.
        
        @param request: CreateSuspEventNoteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSuspEventNoteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_id):
            query['EventId'] = request.event_id
        if not UtilClient.is_unset(request.note):
            query['Note'] = request.note
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSuspEventNote',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateSuspEventNoteResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_susp_event_note(
        self,
        request: sas_20181203_models.CreateSuspEventNoteRequest,
    ) -> sas_20181203_models.CreateSuspEventNoteResponse:
        """
        @summary Adds remarks to an alert event.
        
        @param request: CreateSuspEventNoteRequest
        @return: CreateSuspEventNoteResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_susp_event_note_with_options(request, runtime)

    async def create_susp_event_note_async(
        self,
        request: sas_20181203_models.CreateSuspEventNoteRequest,
    ) -> sas_20181203_models.CreateSuspEventNoteResponse:
        """
        @summary Adds remarks to an alert event.
        
        @param request: CreateSuspEventNoteRequest
        @return: CreateSuspEventNoteResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_susp_event_note_with_options_async(request, runtime)

    def create_uni_backup_policy_with_options(
        self,
        tmp_req: sas_20181203_models.CreateUniBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateUniBackupPolicyResponse:
        """
        @summary Creates an anti-ransomware policy for a database.
        
        @param tmp_req: CreateUniBackupPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateUniBackupPolicyResponse
        """
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.CreateUniBackupPolicyShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.full_plan):
            request.full_plan_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.full_plan, 'FullPlan', 'json')
        if not UtilClient.is_unset(tmp_req.inc_plan):
            request.inc_plan_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.inc_plan, 'IncPlan', 'json')
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.account_password):
            query['AccountPassword'] = request.account_password
        if not UtilClient.is_unset(request.database_add_by_user):
            query['DatabaseAddByUser'] = request.database_add_by_user
        if not UtilClient.is_unset(request.database_type):
            query['DatabaseType'] = request.database_type
        if not UtilClient.is_unset(request.full_plan_shrink):
            query['FullPlan'] = request.full_plan_shrink
        if not UtilClient.is_unset(request.inc_plan_shrink):
            query['IncPlan'] = request.inc_plan_shrink
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.policy_name):
            query['PolicyName'] = request.policy_name
        if not UtilClient.is_unset(request.retention):
            query['Retention'] = request.retention
        if not UtilClient.is_unset(request.speed_limiter):
            query['SpeedLimiter'] = request.speed_limiter
        if not UtilClient.is_unset(request.uni_region_id):
            query['UniRegionId'] = request.uni_region_id
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateUniBackupPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateUniBackupPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_uni_backup_policy_with_options_async(
        self,
        tmp_req: sas_20181203_models.CreateUniBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateUniBackupPolicyResponse:
        """
        @summary Creates an anti-ransomware policy for a database.
        
        @param tmp_req: CreateUniBackupPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateUniBackupPolicyResponse
        """
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.CreateUniBackupPolicyShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.full_plan):
            request.full_plan_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.full_plan, 'FullPlan', 'json')
        if not UtilClient.is_unset(tmp_req.inc_plan):
            request.inc_plan_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.inc_plan, 'IncPlan', 'json')
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.account_password):
            query['AccountPassword'] = request.account_password
        if not UtilClient.is_unset(request.database_add_by_user):
            query['DatabaseAddByUser'] = request.database_add_by_user
        if not UtilClient.is_unset(request.database_type):
            query['DatabaseType'] = request.database_type
        if not UtilClient.is_unset(request.full_plan_shrink):
            query['FullPlan'] = request.full_plan_shrink
        if not UtilClient.is_unset(request.inc_plan_shrink):
            query['IncPlan'] = request.inc_plan_shrink
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.policy_name):
            query['PolicyName'] = request.policy_name
        if not UtilClient.is_unset(request.retention):
            query['Retention'] = request.retention
        if not UtilClient.is_unset(request.speed_limiter):
            query['SpeedLimiter'] = request.speed_limiter
        if not UtilClient.is_unset(request.uni_region_id):
            query['UniRegionId'] = request.uni_region_id
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateUniBackupPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateUniBackupPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_uni_backup_policy(
        self,
        request: sas_20181203_models.CreateUniBackupPolicyRequest,
    ) -> sas_20181203_models.CreateUniBackupPolicyResponse:
        """
        @summary Creates an anti-ransomware policy for a database.
        
        @param request: CreateUniBackupPolicyRequest
        @return: CreateUniBackupPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_uni_backup_policy_with_options(request, runtime)

    async def create_uni_backup_policy_async(
        self,
        request: sas_20181203_models.CreateUniBackupPolicyRequest,
    ) -> sas_20181203_models.CreateUniBackupPolicyResponse:
        """
        @summary Creates an anti-ransomware policy for a database.
        
        @param request: CreateUniBackupPolicyRequest
        @return: CreateUniBackupPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_uni_backup_policy_with_options_async(request, runtime)

    def create_uni_restore_plan_with_options(
        self,
        request: sas_20181203_models.CreateUniRestorePlanRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateUniRestorePlanResponse:
        """
        @summary Creates a restoration task for a database.
        
        @param request: CreateUniRestorePlanRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateUniRestorePlanResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.instance_uuid):
            query['InstanceUuid'] = request.instance_uuid
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.reset_scn):
            query['ResetScn'] = request.reset_scn
        if not UtilClient.is_unset(request.reset_time):
            query['ResetTime'] = request.reset_time
        if not UtilClient.is_unset(request.restore_info):
            query['RestoreInfo'] = request.restore_info
        if not UtilClient.is_unset(request.time_point):
            query['TimePoint'] = request.time_point
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateUniRestorePlan',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateUniRestorePlanResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_uni_restore_plan_with_options_async(
        self,
        request: sas_20181203_models.CreateUniRestorePlanRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateUniRestorePlanResponse:
        """
        @summary Creates a restoration task for a database.
        
        @param request: CreateUniRestorePlanRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateUniRestorePlanResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.instance_uuid):
            query['InstanceUuid'] = request.instance_uuid
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.reset_scn):
            query['ResetScn'] = request.reset_scn
        if not UtilClient.is_unset(request.reset_time):
            query['ResetTime'] = request.reset_time
        if not UtilClient.is_unset(request.restore_info):
            query['RestoreInfo'] = request.restore_info
        if not UtilClient.is_unset(request.time_point):
            query['TimePoint'] = request.time_point
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateUniRestorePlan',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateUniRestorePlanResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_uni_restore_plan(
        self,
        request: sas_20181203_models.CreateUniRestorePlanRequest,
    ) -> sas_20181203_models.CreateUniRestorePlanResponse:
        """
        @summary Creates a restoration task for a database.
        
        @param request: CreateUniRestorePlanRequest
        @return: CreateUniRestorePlanResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_uni_restore_plan_with_options(request, runtime)

    async def create_uni_restore_plan_async(
        self,
        request: sas_20181203_models.CreateUniRestorePlanRequest,
    ) -> sas_20181203_models.CreateUniRestorePlanResponse:
        """
        @summary Creates a restoration task for a database.
        
        @param request: CreateUniRestorePlanRequest
        @return: CreateUniRestorePlanResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_uni_restore_plan_with_options_async(request, runtime)

    def create_user_setting_with_options(
        self,
        request: sas_20181203_models.CreateUserSettingRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateUserSettingResponse:
        """
        @summary Creates the risk level settings for baseline check items.
        
        @param request: CreateUserSettingRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateUserSettingResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alert_levels):
            query['AlertLevels'] = request.alert_levels
        if not UtilClient.is_unset(request.invalid_warning_keep_days):
            query['InvalidWarningKeepDays'] = request.invalid_warning_keep_days
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateUserSetting',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateUserSettingResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_user_setting_with_options_async(
        self,
        request: sas_20181203_models.CreateUserSettingRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateUserSettingResponse:
        """
        @summary Creates the risk level settings for baseline check items.
        
        @param request: CreateUserSettingRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateUserSettingResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alert_levels):
            query['AlertLevels'] = request.alert_levels
        if not UtilClient.is_unset(request.invalid_warning_keep_days):
            query['InvalidWarningKeepDays'] = request.invalid_warning_keep_days
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateUserSetting',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateUserSettingResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_user_setting(
        self,
        request: sas_20181203_models.CreateUserSettingRequest,
    ) -> sas_20181203_models.CreateUserSettingResponse:
        """
        @summary Creates the risk level settings for baseline check items.
        
        @param request: CreateUserSettingRequest
        @return: CreateUserSettingResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_user_setting_with_options(request, runtime)

    async def create_user_setting_async(
        self,
        request: sas_20181203_models.CreateUserSettingRequest,
    ) -> sas_20181203_models.CreateUserSettingResponse:
        """
        @summary Creates the risk level settings for baseline check items.
        
        @param request: CreateUserSettingRequest
        @return: CreateUserSettingResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_user_setting_with_options_async(request, runtime)

    def create_virus_scan_once_task_with_options(
        self,
        request: sas_20181203_models.CreateVirusScanOnceTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateVirusScanOnceTaskResponse:
        """
        @summary Creates a one-time virus scan task that is immediately executed.
        
        @param request: CreateVirusScanOnceTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVirusScanOnceTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.param):
            query['Param'] = request.param
        if not UtilClient.is_unset(request.scan_path):
            query['ScanPath'] = request.scan_path
        if not UtilClient.is_unset(request.scan_type):
            query['ScanType'] = request.scan_type
        if not UtilClient.is_unset(request.selection_key):
            query['SelectionKey'] = request.selection_key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVirusScanOnceTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateVirusScanOnceTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_virus_scan_once_task_with_options_async(
        self,
        request: sas_20181203_models.CreateVirusScanOnceTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateVirusScanOnceTaskResponse:
        """
        @summary Creates a one-time virus scan task that is immediately executed.
        
        @param request: CreateVirusScanOnceTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVirusScanOnceTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.param):
            query['Param'] = request.param
        if not UtilClient.is_unset(request.scan_path):
            query['ScanPath'] = request.scan_path
        if not UtilClient.is_unset(request.scan_type):
            query['ScanType'] = request.scan_type
        if not UtilClient.is_unset(request.selection_key):
            query['SelectionKey'] = request.selection_key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVirusScanOnceTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateVirusScanOnceTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_virus_scan_once_task(
        self,
        request: sas_20181203_models.CreateVirusScanOnceTaskRequest,
    ) -> sas_20181203_models.CreateVirusScanOnceTaskResponse:
        """
        @summary Creates a one-time virus scan task that is immediately executed.
        
        @param request: CreateVirusScanOnceTaskRequest
        @return: CreateVirusScanOnceTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_virus_scan_once_task_with_options(request, runtime)

    async def create_virus_scan_once_task_async(
        self,
        request: sas_20181203_models.CreateVirusScanOnceTaskRequest,
    ) -> sas_20181203_models.CreateVirusScanOnceTaskResponse:
        """
        @summary Creates a one-time virus scan task that is immediately executed.
        
        @param request: CreateVirusScanOnceTaskRequest
        @return: CreateVirusScanOnceTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_virus_scan_once_task_with_options_async(request, runtime)

    def create_vul_auto_repair_config_with_options(
        self,
        request: sas_20181203_models.CreateVulAutoRepairConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateVulAutoRepairConfigResponse:
        """
        @summary Creates a list of vulnerabilities that can be automatically fixed. After the list is created, you can select the list when you create a vulnerability fixing task on the Playbook page.
        
        @param request: CreateVulAutoRepairConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVulAutoRepairConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.reason):
            query['Reason'] = request.reason
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.vul_auto_repair_config_list):
            query['VulAutoRepairConfigList'] = request.vul_auto_repair_config_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVulAutoRepairConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateVulAutoRepairConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vul_auto_repair_config_with_options_async(
        self,
        request: sas_20181203_models.CreateVulAutoRepairConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateVulAutoRepairConfigResponse:
        """
        @summary Creates a list of vulnerabilities that can be automatically fixed. After the list is created, you can select the list when you create a vulnerability fixing task on the Playbook page.
        
        @param request: CreateVulAutoRepairConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVulAutoRepairConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.reason):
            query['Reason'] = request.reason
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.vul_auto_repair_config_list):
            query['VulAutoRepairConfigList'] = request.vul_auto_repair_config_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVulAutoRepairConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateVulAutoRepairConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vul_auto_repair_config(
        self,
        request: sas_20181203_models.CreateVulAutoRepairConfigRequest,
    ) -> sas_20181203_models.CreateVulAutoRepairConfigResponse:
        """
        @summary Creates a list of vulnerabilities that can be automatically fixed. After the list is created, you can select the list when you create a vulnerability fixing task on the Playbook page.
        
        @param request: CreateVulAutoRepairConfigRequest
        @return: CreateVulAutoRepairConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vul_auto_repair_config_with_options(request, runtime)

    async def create_vul_auto_repair_config_async(
        self,
        request: sas_20181203_models.CreateVulAutoRepairConfigRequest,
    ) -> sas_20181203_models.CreateVulAutoRepairConfigResponse:
        """
        @summary Creates a list of vulnerabilities that can be automatically fixed. After the list is created, you can select the list when you create a vulnerability fixing task on the Playbook page.
        
        @param request: CreateVulAutoRepairConfigRequest
        @return: CreateVulAutoRepairConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vul_auto_repair_config_with_options_async(request, runtime)

    def delete_anti_brute_force_rule_with_options(
        self,
        request: sas_20181203_models.DeleteAntiBruteForceRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteAntiBruteForceRuleResponse:
        """
        @summary Deletes the specified defense rules against brute-force attacks.
        
        @param request: DeleteAntiBruteForceRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAntiBruteForceRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ids):
            query['Ids'] = request.ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAntiBruteForceRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteAntiBruteForceRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_anti_brute_force_rule_with_options_async(
        self,
        request: sas_20181203_models.DeleteAntiBruteForceRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteAntiBruteForceRuleResponse:
        """
        @summary Deletes the specified defense rules against brute-force attacks.
        
        @param request: DeleteAntiBruteForceRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAntiBruteForceRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ids):
            query['Ids'] = request.ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAntiBruteForceRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteAntiBruteForceRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_anti_brute_force_rule(
        self,
        request: sas_20181203_models.DeleteAntiBruteForceRuleRequest,
    ) -> sas_20181203_models.DeleteAntiBruteForceRuleResponse:
        """
        @summary Deletes the specified defense rules against brute-force attacks.
        
        @param request: DeleteAntiBruteForceRuleRequest
        @return: DeleteAntiBruteForceRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_anti_brute_force_rule_with_options(request, runtime)

    async def delete_anti_brute_force_rule_async(
        self,
        request: sas_20181203_models.DeleteAntiBruteForceRuleRequest,
    ) -> sas_20181203_models.DeleteAntiBruteForceRuleResponse:
        """
        @summary Deletes the specified defense rules against brute-force attacks.
        
        @param request: DeleteAntiBruteForceRuleRequest
        @return: DeleteAntiBruteForceRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_anti_brute_force_rule_with_options_async(request, runtime)

    def delete_attack_path_sensitive_asset_config_with_options(
        self,
        request: sas_20181203_models.DeleteAttackPathSensitiveAssetConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteAttackPathSensitiveAssetConfigResponse:
        """
        @summary Delete attack path sensitive asset.
        
        @param request: DeleteAttackPathSensitiveAssetConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAttackPathSensitiveAssetConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attack_path_sensitive_asset_config_id):
            query['AttackPathSensitiveAssetConfigId'] = request.attack_path_sensitive_asset_config_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAttackPathSensitiveAssetConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteAttackPathSensitiveAssetConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_attack_path_sensitive_asset_config_with_options_async(
        self,
        request: sas_20181203_models.DeleteAttackPathSensitiveAssetConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteAttackPathSensitiveAssetConfigResponse:
        """
        @summary Delete attack path sensitive asset.
        
        @param request: DeleteAttackPathSensitiveAssetConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAttackPathSensitiveAssetConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attack_path_sensitive_asset_config_id):
            query['AttackPathSensitiveAssetConfigId'] = request.attack_path_sensitive_asset_config_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAttackPathSensitiveAssetConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteAttackPathSensitiveAssetConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_attack_path_sensitive_asset_config(
        self,
        request: sas_20181203_models.DeleteAttackPathSensitiveAssetConfigRequest,
    ) -> sas_20181203_models.DeleteAttackPathSensitiveAssetConfigResponse:
        """
        @summary Delete attack path sensitive asset.
        
        @param request: DeleteAttackPathSensitiveAssetConfigRequest
        @return: DeleteAttackPathSensitiveAssetConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_attack_path_sensitive_asset_config_with_options(request, runtime)

    async def delete_attack_path_sensitive_asset_config_async(
        self,
        request: sas_20181203_models.DeleteAttackPathSensitiveAssetConfigRequest,
    ) -> sas_20181203_models.DeleteAttackPathSensitiveAssetConfigResponse:
        """
        @summary Delete attack path sensitive asset.
        
        @param request: DeleteAttackPathSensitiveAssetConfigRequest
        @return: DeleteAttackPathSensitiveAssetConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_attack_path_sensitive_asset_config_with_options_async(request, runtime)

    def delete_attack_path_whitelist_with_options(
        self,
        request: sas_20181203_models.DeleteAttackPathWhitelistRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteAttackPathWhitelistResponse:
        """
        @summary Delete Attack Path Whitelist.
        
        @param request: DeleteAttackPathWhitelistRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAttackPathWhitelistResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attack_path_whitelist_id):
            query['AttackPathWhitelistId'] = request.attack_path_whitelist_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAttackPathWhitelist',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteAttackPathWhitelistResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_attack_path_whitelist_with_options_async(
        self,
        request: sas_20181203_models.DeleteAttackPathWhitelistRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteAttackPathWhitelistResponse:
        """
        @summary Delete Attack Path Whitelist.
        
        @param request: DeleteAttackPathWhitelistRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAttackPathWhitelistResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attack_path_whitelist_id):
            query['AttackPathWhitelistId'] = request.attack_path_whitelist_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAttackPathWhitelist',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteAttackPathWhitelistResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_attack_path_whitelist(
        self,
        request: sas_20181203_models.DeleteAttackPathWhitelistRequest,
    ) -> sas_20181203_models.DeleteAttackPathWhitelistResponse:
        """
        @summary Delete Attack Path Whitelist.
        
        @param request: DeleteAttackPathWhitelistRequest
        @return: DeleteAttackPathWhitelistResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_attack_path_whitelist_with_options(request, runtime)

    async def delete_attack_path_whitelist_async(
        self,
        request: sas_20181203_models.DeleteAttackPathWhitelistRequest,
    ) -> sas_20181203_models.DeleteAttackPathWhitelistResponse:
        """
        @summary Delete Attack Path Whitelist.
        
        @param request: DeleteAttackPathWhitelistRequest
        @return: DeleteAttackPathWhitelistResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_attack_path_whitelist_with_options_async(request, runtime)

    def delete_attestor_with_options(
        self,
        request: sas_20181203_models.DeleteAttestorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteAttestorResponse:
        """
        @summary Deletes a witness.
        
        @param request: DeleteAttestorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAttestorResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAttestor',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteAttestorResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_attestor_with_options_async(
        self,
        request: sas_20181203_models.DeleteAttestorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteAttestorResponse:
        """
        @summary Deletes a witness.
        
        @param request: DeleteAttestorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAttestorResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAttestor',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteAttestorResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_attestor(
        self,
        request: sas_20181203_models.DeleteAttestorRequest,
    ) -> sas_20181203_models.DeleteAttestorResponse:
        """
        @summary Deletes a witness.
        
        @param request: DeleteAttestorRequest
        @return: DeleteAttestorResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_attestor_with_options(request, runtime)

    async def delete_attestor_async(
        self,
        request: sas_20181203_models.DeleteAttestorRequest,
    ) -> sas_20181203_models.DeleteAttestorResponse:
        """
        @summary Deletes a witness.
        
        @param request: DeleteAttestorRequest
        @return: DeleteAttestorResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_attestor_with_options_async(request, runtime)

    def delete_auto_tag_rules_with_options(
        self,
        request: sas_20181203_models.DeleteAutoTagRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteAutoTagRulesResponse:
        """
        @summary Deletes asset auto-tagging rules that are created by using the feature of asset management rules. You can create rules on the System Configuration > Feature Settings > Multi-cloud Configuration Management > Asset Management Rule page in the Security Center console.
        
        @param request: DeleteAutoTagRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAutoTagRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.rule_id_list):
            query['RuleIdList'] = request.rule_id_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAutoTagRules',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteAutoTagRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_auto_tag_rules_with_options_async(
        self,
        request: sas_20181203_models.DeleteAutoTagRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteAutoTagRulesResponse:
        """
        @summary Deletes asset auto-tagging rules that are created by using the feature of asset management rules. You can create rules on the System Configuration > Feature Settings > Multi-cloud Configuration Management > Asset Management Rule page in the Security Center console.
        
        @param request: DeleteAutoTagRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAutoTagRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.rule_id_list):
            query['RuleIdList'] = request.rule_id_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAutoTagRules',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteAutoTagRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_auto_tag_rules(
        self,
        request: sas_20181203_models.DeleteAutoTagRulesRequest,
    ) -> sas_20181203_models.DeleteAutoTagRulesResponse:
        """
        @summary Deletes asset auto-tagging rules that are created by using the feature of asset management rules. You can create rules on the System Configuration > Feature Settings > Multi-cloud Configuration Management > Asset Management Rule page in the Security Center console.
        
        @param request: DeleteAutoTagRulesRequest
        @return: DeleteAutoTagRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_auto_tag_rules_with_options(request, runtime)

    async def delete_auto_tag_rules_async(
        self,
        request: sas_20181203_models.DeleteAutoTagRulesRequest,
    ) -> sas_20181203_models.DeleteAutoTagRulesResponse:
        """
        @summary Deletes asset auto-tagging rules that are created by using the feature of asset management rules. You can create rules on the System Configuration > Feature Settings > Multi-cloud Configuration Management > Asset Management Rule page in the Security Center console.
        
        @param request: DeleteAutoTagRulesRequest
        @return: DeleteAutoTagRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_auto_tag_rules_with_options_async(request, runtime)

    def delete_backup_policy_with_options(
        self,
        request: sas_20181203_models.DeleteBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteBackupPolicyResponse:
        """
        @summary Deletes an anti-ransomware policy.
        
        @param request: DeleteBackupPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBackupPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.policy_version):
            query['PolicyVersion'] = request.policy_version
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBackupPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteBackupPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_backup_policy_with_options_async(
        self,
        request: sas_20181203_models.DeleteBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteBackupPolicyResponse:
        """
        @summary Deletes an anti-ransomware policy.
        
        @param request: DeleteBackupPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBackupPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.policy_version):
            query['PolicyVersion'] = request.policy_version
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBackupPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteBackupPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_backup_policy(
        self,
        request: sas_20181203_models.DeleteBackupPolicyRequest,
    ) -> sas_20181203_models.DeleteBackupPolicyResponse:
        """
        @summary Deletes an anti-ransomware policy.
        
        @param request: DeleteBackupPolicyRequest
        @return: DeleteBackupPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_backup_policy_with_options(request, runtime)

    async def delete_backup_policy_async(
        self,
        request: sas_20181203_models.DeleteBackupPolicyRequest,
    ) -> sas_20181203_models.DeleteBackupPolicyResponse:
        """
        @summary Deletes an anti-ransomware policy.
        
        @param request: DeleteBackupPolicyRequest
        @return: DeleteBackupPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_backup_policy_with_options_async(request, runtime)

    def delete_backup_policy_machine_with_options(
        self,
        request: sas_20181203_models.DeleteBackupPolicyMachineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteBackupPolicyMachineResponse:
        """
        @summary Disables a specified anti-ransomware policy that is applied to specified servers and uninstalls the anti-ransomware agent from the servers. If the backup vaults of the servers contain only backup data of the servers, the backup vaults are deleted.
        
        @param request: DeleteBackupPolicyMachineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBackupPolicyMachineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.policy_version):
            query['PolicyVersion'] = request.policy_version
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBackupPolicyMachine',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteBackupPolicyMachineResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_backup_policy_machine_with_options_async(
        self,
        request: sas_20181203_models.DeleteBackupPolicyMachineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteBackupPolicyMachineResponse:
        """
        @summary Disables a specified anti-ransomware policy that is applied to specified servers and uninstalls the anti-ransomware agent from the servers. If the backup vaults of the servers contain only backup data of the servers, the backup vaults are deleted.
        
        @param request: DeleteBackupPolicyMachineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBackupPolicyMachineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.policy_version):
            query['PolicyVersion'] = request.policy_version
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBackupPolicyMachine',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteBackupPolicyMachineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_backup_policy_machine(
        self,
        request: sas_20181203_models.DeleteBackupPolicyMachineRequest,
    ) -> sas_20181203_models.DeleteBackupPolicyMachineResponse:
        """
        @summary Disables a specified anti-ransomware policy that is applied to specified servers and uninstalls the anti-ransomware agent from the servers. If the backup vaults of the servers contain only backup data of the servers, the backup vaults are deleted.
        
        @param request: DeleteBackupPolicyMachineRequest
        @return: DeleteBackupPolicyMachineResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_backup_policy_machine_with_options(request, runtime)

    async def delete_backup_policy_machine_async(
        self,
        request: sas_20181203_models.DeleteBackupPolicyMachineRequest,
    ) -> sas_20181203_models.DeleteBackupPolicyMachineResponse:
        """
        @summary Disables a specified anti-ransomware policy that is applied to specified servers and uninstalls the anti-ransomware agent from the servers. If the backup vaults of the servers contain only backup data of the servers, the backup vaults are deleted.
        
        @param request: DeleteBackupPolicyMachineRequest
        @return: DeleteBackupPolicyMachineResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_backup_policy_machine_with_options_async(request, runtime)

    def delete_backup_snapshot_with_options(
        self,
        request: sas_20181203_models.DeleteBackupSnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteBackupSnapshotResponse:
        """
        @summary Deletes a backup snapshot that is created for anti-ransomware.
        
        @param request: DeleteBackupSnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBackupSnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_region_id_list):
            query['BackupRegionIdList'] = request.backup_region_id_list
        if not UtilClient.is_unset(request.backup_snapshot_list):
            query['BackupSnapshotList'] = request.backup_snapshot_list
        if not UtilClient.is_unset(request.retain_latest_snapshot):
            query['RetainLatestSnapshot'] = request.retain_latest_snapshot
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBackupSnapshot',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteBackupSnapshotResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_backup_snapshot_with_options_async(
        self,
        request: sas_20181203_models.DeleteBackupSnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteBackupSnapshotResponse:
        """
        @summary Deletes a backup snapshot that is created for anti-ransomware.
        
        @param request: DeleteBackupSnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBackupSnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backup_region_id_list):
            query['BackupRegionIdList'] = request.backup_region_id_list
        if not UtilClient.is_unset(request.backup_snapshot_list):
            query['BackupSnapshotList'] = request.backup_snapshot_list
        if not UtilClient.is_unset(request.retain_latest_snapshot):
            query['RetainLatestSnapshot'] = request.retain_latest_snapshot
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBackupSnapshot',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteBackupSnapshotResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_backup_snapshot(
        self,
        request: sas_20181203_models.DeleteBackupSnapshotRequest,
    ) -> sas_20181203_models.DeleteBackupSnapshotResponse:
        """
        @summary Deletes a backup snapshot that is created for anti-ransomware.
        
        @param request: DeleteBackupSnapshotRequest
        @return: DeleteBackupSnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_backup_snapshot_with_options(request, runtime)

    async def delete_backup_snapshot_async(
        self,
        request: sas_20181203_models.DeleteBackupSnapshotRequest,
    ) -> sas_20181203_models.DeleteBackupSnapshotResponse:
        """
        @summary Deletes a backup snapshot that is created for anti-ransomware.
        
        @param request: DeleteBackupSnapshotRequest
        @return: DeleteBackupSnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_backup_snapshot_with_options_async(request, runtime)

    def delete_baseline_check_white_record_with_options(
        self,
        request: sas_20181203_models.DeleteBaselineCheckWhiteRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteBaselineCheckWhiteRecordResponse:
        """
        @summary Deletes the whitelist record for a baseline check item.
        
        @param request: DeleteBaselineCheckWhiteRecordRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBaselineCheckWhiteRecordResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_ids):
            query['CheckIds'] = request.check_ids
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.record_ids):
            query['RecordIds'] = request.record_ids
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBaselineCheckWhiteRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteBaselineCheckWhiteRecordResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_baseline_check_white_record_with_options_async(
        self,
        request: sas_20181203_models.DeleteBaselineCheckWhiteRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteBaselineCheckWhiteRecordResponse:
        """
        @summary Deletes the whitelist record for a baseline check item.
        
        @param request: DeleteBaselineCheckWhiteRecordRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBaselineCheckWhiteRecordResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_ids):
            query['CheckIds'] = request.check_ids
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.record_ids):
            query['RecordIds'] = request.record_ids
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBaselineCheckWhiteRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteBaselineCheckWhiteRecordResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_baseline_check_white_record(
        self,
        request: sas_20181203_models.DeleteBaselineCheckWhiteRecordRequest,
    ) -> sas_20181203_models.DeleteBaselineCheckWhiteRecordResponse:
        """
        @summary Deletes the whitelist record for a baseline check item.
        
        @param request: DeleteBaselineCheckWhiteRecordRequest
        @return: DeleteBaselineCheckWhiteRecordResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_baseline_check_white_record_with_options(request, runtime)

    async def delete_baseline_check_white_record_async(
        self,
        request: sas_20181203_models.DeleteBaselineCheckWhiteRecordRequest,
    ) -> sas_20181203_models.DeleteBaselineCheckWhiteRecordResponse:
        """
        @summary Deletes the whitelist record for a baseline check item.
        
        @param request: DeleteBaselineCheckWhiteRecordRequest
        @return: DeleteBaselineCheckWhiteRecordResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_baseline_check_white_record_with_options_async(request, runtime)

    def delete_binary_security_policy_with_options(
        self,
        request: sas_20181203_models.DeleteBinarySecurityPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteBinarySecurityPolicyResponse:
        """
        @summary Deletes a binary security policy from the container signature feature.
        
        @param request: DeleteBinarySecurityPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBinarySecurityPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBinarySecurityPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteBinarySecurityPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_binary_security_policy_with_options_async(
        self,
        request: sas_20181203_models.DeleteBinarySecurityPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteBinarySecurityPolicyResponse:
        """
        @summary Deletes a binary security policy from the container signature feature.
        
        @param request: DeleteBinarySecurityPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBinarySecurityPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBinarySecurityPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteBinarySecurityPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_binary_security_policy(
        self,
        request: sas_20181203_models.DeleteBinarySecurityPolicyRequest,
    ) -> sas_20181203_models.DeleteBinarySecurityPolicyResponse:
        """
        @summary Deletes a binary security policy from the container signature feature.
        
        @param request: DeleteBinarySecurityPolicyRequest
        @return: DeleteBinarySecurityPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_binary_security_policy_with_options(request, runtime)

    async def delete_binary_security_policy_async(
        self,
        request: sas_20181203_models.DeleteBinarySecurityPolicyRequest,
    ) -> sas_20181203_models.DeleteBinarySecurityPolicyResponse:
        """
        @summary Deletes a binary security policy from the container signature feature.
        
        @param request: DeleteBinarySecurityPolicyRequest
        @return: DeleteBinarySecurityPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_binary_security_policy_with_options_async(request, runtime)

    def delete_check_policy_with_options(
        self,
        request: sas_20181203_models.DeleteCheckPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteCheckPolicyResponse:
        """
        @summary Delete custom scope directories in Cloud Security Posture Management (CSPM) custom checks. You can remove assigned standards, requirements, or sections.
        
        @param request: DeleteCheckPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCheckPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy_ids):
            query['PolicyIds'] = request.policy_ids
        if not UtilClient.is_unset(request.policy_type):
            query['PolicyType'] = request.policy_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCheckPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteCheckPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_check_policy_with_options_async(
        self,
        request: sas_20181203_models.DeleteCheckPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteCheckPolicyResponse:
        """
        @summary Delete custom scope directories in Cloud Security Posture Management (CSPM) custom checks. You can remove assigned standards, requirements, or sections.
        
        @param request: DeleteCheckPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCheckPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy_ids):
            query['PolicyIds'] = request.policy_ids
        if not UtilClient.is_unset(request.policy_type):
            query['PolicyType'] = request.policy_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCheckPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteCheckPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_check_policy(
        self,
        request: sas_20181203_models.DeleteCheckPolicyRequest,
    ) -> sas_20181203_models.DeleteCheckPolicyResponse:
        """
        @summary Delete custom scope directories in Cloud Security Posture Management (CSPM) custom checks. You can remove assigned standards, requirements, or sections.
        
        @param request: DeleteCheckPolicyRequest
        @return: DeleteCheckPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_check_policy_with_options(request, runtime)

    async def delete_check_policy_async(
        self,
        request: sas_20181203_models.DeleteCheckPolicyRequest,
    ) -> sas_20181203_models.DeleteCheckPolicyResponse:
        """
        @summary Delete custom scope directories in Cloud Security Posture Management (CSPM) custom checks. You can remove assigned standards, requirements, or sections.
        
        @param request: DeleteCheckPolicyRequest
        @return: DeleteCheckPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_check_policy_with_options_async(request, runtime)

    def delete_client_user_define_rule_with_options(
        self,
        request: sas_20181203_models.DeleteClientUserDefineRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteClientUserDefineRuleResponse:
        """
        @summary Deletes specified custom defense rules.
        
        @param request: DeleteClientUserDefineRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteClientUserDefineRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id_list):
            query['IdList'] = request.id_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteClientUserDefineRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteClientUserDefineRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_client_user_define_rule_with_options_async(
        self,
        request: sas_20181203_models.DeleteClientUserDefineRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteClientUserDefineRuleResponse:
        """
        @summary Deletes specified custom defense rules.
        
        @param request: DeleteClientUserDefineRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteClientUserDefineRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id_list):
            query['IdList'] = request.id_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteClientUserDefineRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteClientUserDefineRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_client_user_define_rule(
        self,
        request: sas_20181203_models.DeleteClientUserDefineRuleRequest,
    ) -> sas_20181203_models.DeleteClientUserDefineRuleResponse:
        """
        @summary Deletes specified custom defense rules.
        
        @param request: DeleteClientUserDefineRuleRequest
        @return: DeleteClientUserDefineRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_client_user_define_rule_with_options(request, runtime)

    async def delete_client_user_define_rule_async(
        self,
        request: sas_20181203_models.DeleteClientUserDefineRuleRequest,
    ) -> sas_20181203_models.DeleteClientUserDefineRuleResponse:
        """
        @summary Deletes specified custom defense rules.
        
        @param request: DeleteClientUserDefineRuleRequest
        @return: DeleteClientUserDefineRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_client_user_define_rule_with_options_async(request, runtime)

    def delete_cloud_vendor_account_akwith_options(
        self,
        request: sas_20181203_models.DeleteCloudVendorAccountAKRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteCloudVendorAccountAKResponse:
        """
        @summary Delete multi-cloud asset synchronization configuration.
        
        @param request: DeleteCloudVendorAccountAKRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCloudVendorAccountAKResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_id):
            query['AuthId'] = request.auth_id
        if not UtilClient.is_unset(request.auth_modules):
            query['AuthModules'] = request.auth_modules
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCloudVendorAccountAK',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteCloudVendorAccountAKResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_cloud_vendor_account_akwith_options_async(
        self,
        request: sas_20181203_models.DeleteCloudVendorAccountAKRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteCloudVendorAccountAKResponse:
        """
        @summary Delete multi-cloud asset synchronization configuration.
        
        @param request: DeleteCloudVendorAccountAKRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCloudVendorAccountAKResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_id):
            query['AuthId'] = request.auth_id
        if not UtilClient.is_unset(request.auth_modules):
            query['AuthModules'] = request.auth_modules
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCloudVendorAccountAK',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteCloudVendorAccountAKResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_cloud_vendor_account_ak(
        self,
        request: sas_20181203_models.DeleteCloudVendorAccountAKRequest,
    ) -> sas_20181203_models.DeleteCloudVendorAccountAKResponse:
        """
        @summary Delete multi-cloud asset synchronization configuration.
        
        @param request: DeleteCloudVendorAccountAKRequest
        @return: DeleteCloudVendorAccountAKResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_cloud_vendor_account_akwith_options(request, runtime)

    async def delete_cloud_vendor_account_ak_async(
        self,
        request: sas_20181203_models.DeleteCloudVendorAccountAKRequest,
    ) -> sas_20181203_models.DeleteCloudVendorAccountAKResponse:
        """
        @summary Delete multi-cloud asset synchronization configuration.
        
        @param request: DeleteCloudVendorAccountAKRequest
        @return: DeleteCloudVendorAccountAKResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_cloud_vendor_account_akwith_options_async(request, runtime)

    def delete_container_defense_rule_with_options(
        self,
        request: sas_20181203_models.DeleteContainerDefenseRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteContainerDefenseRuleResponse:
        """
        @summary Deletes a rule for non-image program defense.
        
        @param request: DeleteContainerDefenseRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteContainerDefenseRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.rule_ids):
            query['RuleIds'] = request.rule_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteContainerDefenseRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteContainerDefenseRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_container_defense_rule_with_options_async(
        self,
        request: sas_20181203_models.DeleteContainerDefenseRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteContainerDefenseRuleResponse:
        """
        @summary Deletes a rule for non-image program defense.
        
        @param request: DeleteContainerDefenseRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteContainerDefenseRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.rule_ids):
            query['RuleIds'] = request.rule_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteContainerDefenseRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteContainerDefenseRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_container_defense_rule(
        self,
        request: sas_20181203_models.DeleteContainerDefenseRuleRequest,
    ) -> sas_20181203_models.DeleteContainerDefenseRuleResponse:
        """
        @summary Deletes a rule for non-image program defense.
        
        @param request: DeleteContainerDefenseRuleRequest
        @return: DeleteContainerDefenseRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_container_defense_rule_with_options(request, runtime)

    async def delete_container_defense_rule_async(
        self,
        request: sas_20181203_models.DeleteContainerDefenseRuleRequest,
    ) -> sas_20181203_models.DeleteContainerDefenseRuleResponse:
        """
        @summary Deletes a rule for non-image program defense.
        
        @param request: DeleteContainerDefenseRuleRequest
        @return: DeleteContainerDefenseRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_container_defense_rule_with_options_async(request, runtime)

    def delete_container_plugin_rule_with_options(
        self,
        request: sas_20181203_models.DeleteContainerPluginRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteContainerPluginRuleResponse:
        """
        @summary Deletes a defense rule against container escapes.
        
        @param request: DeleteContainerPluginRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteContainerPluginRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteContainerPluginRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteContainerPluginRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_container_plugin_rule_with_options_async(
        self,
        request: sas_20181203_models.DeleteContainerPluginRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteContainerPluginRuleResponse:
        """
        @summary Deletes a defense rule against container escapes.
        
        @param request: DeleteContainerPluginRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteContainerPluginRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteContainerPluginRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteContainerPluginRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_container_plugin_rule(
        self,
        request: sas_20181203_models.DeleteContainerPluginRuleRequest,
    ) -> sas_20181203_models.DeleteContainerPluginRuleResponse:
        """
        @summary Deletes a defense rule against container escapes.
        
        @param request: DeleteContainerPluginRuleRequest
        @return: DeleteContainerPluginRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_container_plugin_rule_with_options(request, runtime)

    async def delete_container_plugin_rule_async(
        self,
        request: sas_20181203_models.DeleteContainerPluginRuleRequest,
    ) -> sas_20181203_models.DeleteContainerPluginRuleResponse:
        """
        @summary Deletes a defense rule against container escapes.
        
        @param request: DeleteContainerPluginRuleRequest
        @return: DeleteContainerPluginRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_container_plugin_rule_with_options_async(request, runtime)

    def delete_custom_block_record_with_options(
        self,
        request: sas_20181203_models.DeleteCustomBlockRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteCustomBlockRecordResponse:
        """
        @summary Deletes a specified IP address blocking policy from one or more servers.
        
        @param request: DeleteCustomBlockRecordRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCustomBlockRecordResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCustomBlockRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteCustomBlockRecordResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_custom_block_record_with_options_async(
        self,
        request: sas_20181203_models.DeleteCustomBlockRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteCustomBlockRecordResponse:
        """
        @summary Deletes a specified IP address blocking policy from one or more servers.
        
        @param request: DeleteCustomBlockRecordRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCustomBlockRecordResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCustomBlockRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteCustomBlockRecordResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_custom_block_record(
        self,
        request: sas_20181203_models.DeleteCustomBlockRecordRequest,
    ) -> sas_20181203_models.DeleteCustomBlockRecordResponse:
        """
        @summary Deletes a specified IP address blocking policy from one or more servers.
        
        @param request: DeleteCustomBlockRecordRequest
        @return: DeleteCustomBlockRecordResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_custom_block_record_with_options(request, runtime)

    async def delete_custom_block_record_async(
        self,
        request: sas_20181203_models.DeleteCustomBlockRecordRequest,
    ) -> sas_20181203_models.DeleteCustomBlockRecordResponse:
        """
        @summary Deletes a specified IP address blocking policy from one or more servers.
        
        @param request: DeleteCustomBlockRecordRequest
        @return: DeleteCustomBlockRecordResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_custom_block_record_with_options_async(request, runtime)

    def delete_customize_report_with_options(
        self,
        request: sas_20181203_models.DeleteCustomizeReportRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteCustomizeReportResponse:
        """
        @summary Deletes a custom security report.
        
        @param request: DeleteCustomizeReportRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCustomizeReportResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.report_id):
            query['ReportId'] = request.report_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCustomizeReport',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteCustomizeReportResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_customize_report_with_options_async(
        self,
        request: sas_20181203_models.DeleteCustomizeReportRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteCustomizeReportResponse:
        """
        @summary Deletes a custom security report.
        
        @param request: DeleteCustomizeReportRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCustomizeReportResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.report_id):
            query['ReportId'] = request.report_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCustomizeReport',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteCustomizeReportResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_customize_report(
        self,
        request: sas_20181203_models.DeleteCustomizeReportRequest,
    ) -> sas_20181203_models.DeleteCustomizeReportResponse:
        """
        @summary Deletes a custom security report.
        
        @param request: DeleteCustomizeReportRequest
        @return: DeleteCustomizeReportResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_customize_report_with_options(request, runtime)

    async def delete_customize_report_async(
        self,
        request: sas_20181203_models.DeleteCustomizeReportRequest,
    ) -> sas_20181203_models.DeleteCustomizeReportResponse:
        """
        @summary Deletes a custom security report.
        
        @param request: DeleteCustomizeReportRequest
        @return: DeleteCustomizeReportResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_customize_report_with_options_async(request, runtime)

    def delete_customized_dict_with_options(
        self,
        request: sas_20181203_models.DeleteCustomizedDictRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteCustomizedDictResponse:
        """
        @summary Deletes the file that is uploaded to create custom weak password rules.
        
        @param request: DeleteCustomizedDictRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCustomizedDictResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCustomizedDict',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteCustomizedDictResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_customized_dict_with_options_async(
        self,
        request: sas_20181203_models.DeleteCustomizedDictRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteCustomizedDictResponse:
        """
        @summary Deletes the file that is uploaded to create custom weak password rules.
        
        @param request: DeleteCustomizedDictRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCustomizedDictResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCustomizedDict',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteCustomizedDictResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_customized_dict(
        self,
        request: sas_20181203_models.DeleteCustomizedDictRequest,
    ) -> sas_20181203_models.DeleteCustomizedDictResponse:
        """
        @summary Deletes the file that is uploaded to create custom weak password rules.
        
        @param request: DeleteCustomizedDictRequest
        @return: DeleteCustomizedDictResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_customized_dict_with_options(request, runtime)

    async def delete_customized_dict_async(
        self,
        request: sas_20181203_models.DeleteCustomizedDictRequest,
    ) -> sas_20181203_models.DeleteCustomizedDictResponse:
        """
        @summary Deletes the file that is uploaded to create custom weak password rules.
        
        @param request: DeleteCustomizedDictRequest
        @return: DeleteCustomizedDictResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_customized_dict_with_options_async(request, runtime)

    def delete_cycle_task_with_options(
        self,
        request: sas_20181203_models.DeleteCycleTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteCycleTaskResponse:
        """
        @summary Deletes a periodic scan task. The task can be an image scan task, urgent vulnerability scan task, or virus scan task.
        
        @param request: DeleteCycleTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCycleTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config_id):
            query['ConfigId'] = request.config_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCycleTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteCycleTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_cycle_task_with_options_async(
        self,
        request: sas_20181203_models.DeleteCycleTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteCycleTaskResponse:
        """
        @summary Deletes a periodic scan task. The task can be an image scan task, urgent vulnerability scan task, or virus scan task.
        
        @param request: DeleteCycleTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCycleTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config_id):
            query['ConfigId'] = request.config_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCycleTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteCycleTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_cycle_task(
        self,
        request: sas_20181203_models.DeleteCycleTaskRequest,
    ) -> sas_20181203_models.DeleteCycleTaskResponse:
        """
        @summary Deletes a periodic scan task. The task can be an image scan task, urgent vulnerability scan task, or virus scan task.
        
        @param request: DeleteCycleTaskRequest
        @return: DeleteCycleTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_cycle_task_with_options(request, runtime)

    async def delete_cycle_task_async(
        self,
        request: sas_20181203_models.DeleteCycleTaskRequest,
    ) -> sas_20181203_models.DeleteCycleTaskResponse:
        """
        @summary Deletes a periodic scan task. The task can be an image scan task, urgent vulnerability scan task, or virus scan task.
        
        @param request: DeleteCycleTaskRequest
        @return: DeleteCycleTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_cycle_task_with_options_async(request, runtime)

    def delete_ding_talk_with_options(
        self,
        request: sas_20181203_models.DeleteDingTalkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteDingTalkResponse:
        """
        @summary Deletes a DingTalk chatbot on the DingTalk Chatbot tab of the Notification Settings page.
        
        @param request: DeleteDingTalkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDingTalkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ids):
            query['Ids'] = request.ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDingTalk',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteDingTalkResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ding_talk_with_options_async(
        self,
        request: sas_20181203_models.DeleteDingTalkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteDingTalkResponse:
        """
        @summary Deletes a DingTalk chatbot on the DingTalk Chatbot tab of the Notification Settings page.
        
        @param request: DeleteDingTalkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDingTalkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ids):
            query['Ids'] = request.ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDingTalk',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteDingTalkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ding_talk(
        self,
        request: sas_20181203_models.DeleteDingTalkRequest,
    ) -> sas_20181203_models.DeleteDingTalkResponse:
        """
        @summary Deletes a DingTalk chatbot on the DingTalk Chatbot tab of the Notification Settings page.
        
        @param request: DeleteDingTalkRequest
        @return: DeleteDingTalkResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_ding_talk_with_options(request, runtime)

    async def delete_ding_talk_async(
        self,
        request: sas_20181203_models.DeleteDingTalkRequest,
    ) -> sas_20181203_models.DeleteDingTalkResponse:
        """
        @summary Deletes a DingTalk chatbot on the DingTalk Chatbot tab of the Notification Settings page.
        
        @param request: DeleteDingTalkRequest
        @return: DeleteDingTalkResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_ding_talk_with_options_async(request, runtime)

    def delete_file_protect_rule_with_options(
        self,
        request: sas_20181203_models.DeleteFileProtectRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteFileProtectRuleResponse:
        """
        @summary Deletes core file monitoring rules.
        
        @param request: DeleteFileProtectRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteFileProtectRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteFileProtectRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteFileProtectRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_file_protect_rule_with_options_async(
        self,
        request: sas_20181203_models.DeleteFileProtectRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteFileProtectRuleResponse:
        """
        @summary Deletes core file monitoring rules.
        
        @param request: DeleteFileProtectRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteFileProtectRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteFileProtectRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteFileProtectRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_file_protect_rule(
        self,
        request: sas_20181203_models.DeleteFileProtectRuleRequest,
    ) -> sas_20181203_models.DeleteFileProtectRuleResponse:
        """
        @summary Deletes core file monitoring rules.
        
        @param request: DeleteFileProtectRuleRequest
        @return: DeleteFileProtectRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_file_protect_rule_with_options(request, runtime)

    async def delete_file_protect_rule_async(
        self,
        request: sas_20181203_models.DeleteFileProtectRuleRequest,
    ) -> sas_20181203_models.DeleteFileProtectRuleResponse:
        """
        @summary Deletes core file monitoring rules.
        
        @param request: DeleteFileProtectRuleRequest
        @return: DeleteFileProtectRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_file_protect_rule_with_options_async(request, runtime)

    def delete_group_with_options(
        self,
        request: sas_20181203_models.DeleteGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteGroupResponse:
        """
        @summary Deletes a server group.
        
        @description The *Default** server group that is provided by Security Center cannot be deleted. After you delete a group, the assets in this group are moved to the **Default** group.
        
        @param request: DeleteGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGroup',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_group_with_options_async(
        self,
        request: sas_20181203_models.DeleteGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteGroupResponse:
        """
        @summary Deletes a server group.
        
        @description The *Default** server group that is provided by Security Center cannot be deleted. After you delete a group, the assets in this group are moved to the **Default** group.
        
        @param request: DeleteGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGroup',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_group(
        self,
        request: sas_20181203_models.DeleteGroupRequest,
    ) -> sas_20181203_models.DeleteGroupResponse:
        """
        @summary Deletes a server group.
        
        @description The *Default** server group that is provided by Security Center cannot be deleted. After you delete a group, the assets in this group are moved to the **Default** group.
        
        @param request: DeleteGroupRequest
        @return: DeleteGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_group_with_options(request, runtime)

    async def delete_group_async(
        self,
        request: sas_20181203_models.DeleteGroupRequest,
    ) -> sas_20181203_models.DeleteGroupResponse:
        """
        @summary Deletes a server group.
        
        @description The *Default** server group that is provided by Security Center cannot be deleted. After you delete a group, the assets in this group are moved to the **Default** group.
        
        @param request: DeleteGroupRequest
        @return: DeleteGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_group_with_options_async(request, runtime)

    def delete_honeypot_with_options(
        self,
        request: sas_20181203_models.DeleteHoneypotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHoneypotResponse:
        """
        @summary Deletes a specified honeypot.
        
        @param request: DeleteHoneypotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHoneypotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.honeypot_id):
            query['HoneypotId'] = request.honeypot_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHoneypot',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHoneypotResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_honeypot_with_options_async(
        self,
        request: sas_20181203_models.DeleteHoneypotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHoneypotResponse:
        """
        @summary Deletes a specified honeypot.
        
        @param request: DeleteHoneypotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHoneypotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.honeypot_id):
            query['HoneypotId'] = request.honeypot_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHoneypot',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHoneypotResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_honeypot(
        self,
        request: sas_20181203_models.DeleteHoneypotRequest,
    ) -> sas_20181203_models.DeleteHoneypotResponse:
        """
        @summary Deletes a specified honeypot.
        
        @param request: DeleteHoneypotRequest
        @return: DeleteHoneypotResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_honeypot_with_options(request, runtime)

    async def delete_honeypot_async(
        self,
        request: sas_20181203_models.DeleteHoneypotRequest,
    ) -> sas_20181203_models.DeleteHoneypotResponse:
        """
        @summary Deletes a specified honeypot.
        
        @param request: DeleteHoneypotRequest
        @return: DeleteHoneypotResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_honeypot_with_options_async(request, runtime)

    def delete_honeypot_node_with_options(
        self,
        request: sas_20181203_models.DeleteHoneypotNodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHoneypotNodeResponse:
        """
        @summary Deletes a specified management node.
        
        @param request: DeleteHoneypotNodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHoneypotNodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.node_id):
            query['NodeId'] = request.node_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHoneypotNode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHoneypotNodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_honeypot_node_with_options_async(
        self,
        request: sas_20181203_models.DeleteHoneypotNodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHoneypotNodeResponse:
        """
        @summary Deletes a specified management node.
        
        @param request: DeleteHoneypotNodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHoneypotNodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.node_id):
            query['NodeId'] = request.node_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHoneypotNode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHoneypotNodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_honeypot_node(
        self,
        request: sas_20181203_models.DeleteHoneypotNodeRequest,
    ) -> sas_20181203_models.DeleteHoneypotNodeResponse:
        """
        @summary Deletes a specified management node.
        
        @param request: DeleteHoneypotNodeRequest
        @return: DeleteHoneypotNodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_honeypot_node_with_options(request, runtime)

    async def delete_honeypot_node_async(
        self,
        request: sas_20181203_models.DeleteHoneypotNodeRequest,
    ) -> sas_20181203_models.DeleteHoneypotNodeResponse:
        """
        @summary Deletes a specified management node.
        
        @param request: DeleteHoneypotNodeRequest
        @return: DeleteHoneypotNodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_honeypot_node_with_options_async(request, runtime)

    def delete_honeypot_preset_with_options(
        self,
        request: sas_20181203_models.DeleteHoneypotPresetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHoneypotPresetResponse:
        """
        @summary Deletes a specified honeypot template.
        
        @param request: DeleteHoneypotPresetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHoneypotPresetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.honeypot_preset_id):
            query['HoneypotPresetId'] = request.honeypot_preset_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHoneypotPreset',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHoneypotPresetResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_honeypot_preset_with_options_async(
        self,
        request: sas_20181203_models.DeleteHoneypotPresetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHoneypotPresetResponse:
        """
        @summary Deletes a specified honeypot template.
        
        @param request: DeleteHoneypotPresetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHoneypotPresetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.honeypot_preset_id):
            query['HoneypotPresetId'] = request.honeypot_preset_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHoneypotPreset',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHoneypotPresetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_honeypot_preset(
        self,
        request: sas_20181203_models.DeleteHoneypotPresetRequest,
    ) -> sas_20181203_models.DeleteHoneypotPresetResponse:
        """
        @summary Deletes a specified honeypot template.
        
        @param request: DeleteHoneypotPresetRequest
        @return: DeleteHoneypotPresetResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_honeypot_preset_with_options(request, runtime)

    async def delete_honeypot_preset_async(
        self,
        request: sas_20181203_models.DeleteHoneypotPresetRequest,
    ) -> sas_20181203_models.DeleteHoneypotPresetResponse:
        """
        @summary Deletes a specified honeypot template.
        
        @param request: DeleteHoneypotPresetRequest
        @return: DeleteHoneypotPresetResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_honeypot_preset_with_options_async(request, runtime)

    def delete_honeypot_probe_with_options(
        self,
        request: sas_20181203_models.DeleteHoneypotProbeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHoneypotProbeResponse:
        """
        @summary Deletes a specified probe.
        
        @param request: DeleteHoneypotProbeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHoneypotProbeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.probe_id):
            query['ProbeId'] = request.probe_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHoneypotProbe',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHoneypotProbeResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_honeypot_probe_with_options_async(
        self,
        request: sas_20181203_models.DeleteHoneypotProbeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHoneypotProbeResponse:
        """
        @summary Deletes a specified probe.
        
        @param request: DeleteHoneypotProbeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHoneypotProbeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.probe_id):
            query['ProbeId'] = request.probe_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHoneypotProbe',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHoneypotProbeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_honeypot_probe(
        self,
        request: sas_20181203_models.DeleteHoneypotProbeRequest,
    ) -> sas_20181203_models.DeleteHoneypotProbeResponse:
        """
        @summary Deletes a specified probe.
        
        @param request: DeleteHoneypotProbeRequest
        @return: DeleteHoneypotProbeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_honeypot_probe_with_options(request, runtime)

    async def delete_honeypot_probe_async(
        self,
        request: sas_20181203_models.DeleteHoneypotProbeRequest,
    ) -> sas_20181203_models.DeleteHoneypotProbeResponse:
        """
        @summary Deletes a specified probe.
        
        @param request: DeleteHoneypotProbeRequest
        @return: DeleteHoneypotProbeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_honeypot_probe_with_options_async(request, runtime)

    def delete_honeypot_probe_bind_with_options(
        self,
        request: sas_20181203_models.DeleteHoneypotProbeBindRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHoneypotProbeBindResponse:
        """
        @summary Delete the probe service.
        
        @param request: DeleteHoneypotProbeBindRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHoneypotProbeBindResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bind_id):
            query['BindId'] = request.bind_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.probe_id):
            query['ProbeId'] = request.probe_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHoneypotProbeBind',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHoneypotProbeBindResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_honeypot_probe_bind_with_options_async(
        self,
        request: sas_20181203_models.DeleteHoneypotProbeBindRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHoneypotProbeBindResponse:
        """
        @summary Delete the probe service.
        
        @param request: DeleteHoneypotProbeBindRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHoneypotProbeBindResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bind_id):
            query['BindId'] = request.bind_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.probe_id):
            query['ProbeId'] = request.probe_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHoneypotProbeBind',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHoneypotProbeBindResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_honeypot_probe_bind(
        self,
        request: sas_20181203_models.DeleteHoneypotProbeBindRequest,
    ) -> sas_20181203_models.DeleteHoneypotProbeBindResponse:
        """
        @summary Delete the probe service.
        
        @param request: DeleteHoneypotProbeBindRequest
        @return: DeleteHoneypotProbeBindResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_honeypot_probe_bind_with_options(request, runtime)

    async def delete_honeypot_probe_bind_async(
        self,
        request: sas_20181203_models.DeleteHoneypotProbeBindRequest,
    ) -> sas_20181203_models.DeleteHoneypotProbeBindResponse:
        """
        @summary Delete the probe service.
        
        @param request: DeleteHoneypotProbeBindRequest
        @return: DeleteHoneypotProbeBindResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_honeypot_probe_bind_with_options_async(request, runtime)

    def delete_hybrid_proxy_with_options(
        self,
        request: sas_20181203_models.DeleteHybridProxyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHybridProxyResponse:
        """
        @summary Removes a proxy node from a specified proxy cluster.
        
        @param request: DeleteHybridProxyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHybridProxyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHybridProxy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHybridProxyResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_hybrid_proxy_with_options_async(
        self,
        request: sas_20181203_models.DeleteHybridProxyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHybridProxyResponse:
        """
        @summary Removes a proxy node from a specified proxy cluster.
        
        @param request: DeleteHybridProxyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHybridProxyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHybridProxy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHybridProxyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_hybrid_proxy(
        self,
        request: sas_20181203_models.DeleteHybridProxyRequest,
    ) -> sas_20181203_models.DeleteHybridProxyResponse:
        """
        @summary Removes a proxy node from a specified proxy cluster.
        
        @param request: DeleteHybridProxyRequest
        @return: DeleteHybridProxyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_hybrid_proxy_with_options(request, runtime)

    async def delete_hybrid_proxy_async(
        self,
        request: sas_20181203_models.DeleteHybridProxyRequest,
    ) -> sas_20181203_models.DeleteHybridProxyResponse:
        """
        @summary Removes a proxy node from a specified proxy cluster.
        
        @param request: DeleteHybridProxyRequest
        @return: DeleteHybridProxyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_hybrid_proxy_with_options_async(request, runtime)

    def delete_hybrid_proxy_cluster_with_options(
        self,
        request: sas_20181203_models.DeleteHybridProxyClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHybridProxyClusterResponse:
        """
        @summary Deletes a proxy cluster based on the name of the proxy cluster.
        
        @param request: DeleteHybridProxyClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHybridProxyClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHybridProxyCluster',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHybridProxyClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_hybrid_proxy_cluster_with_options_async(
        self,
        request: sas_20181203_models.DeleteHybridProxyClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHybridProxyClusterResponse:
        """
        @summary Deletes a proxy cluster based on the name of the proxy cluster.
        
        @param request: DeleteHybridProxyClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHybridProxyClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHybridProxyCluster',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHybridProxyClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_hybrid_proxy_cluster(
        self,
        request: sas_20181203_models.DeleteHybridProxyClusterRequest,
    ) -> sas_20181203_models.DeleteHybridProxyClusterResponse:
        """
        @summary Deletes a proxy cluster based on the name of the proxy cluster.
        
        @param request: DeleteHybridProxyClusterRequest
        @return: DeleteHybridProxyClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_hybrid_proxy_cluster_with_options(request, runtime)

    async def delete_hybrid_proxy_cluster_async(
        self,
        request: sas_20181203_models.DeleteHybridProxyClusterRequest,
    ) -> sas_20181203_models.DeleteHybridProxyClusterResponse:
        """
        @summary Deletes a proxy cluster based on the name of the proxy cluster.
        
        @param request: DeleteHybridProxyClusterRequest
        @return: DeleteHybridProxyClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_hybrid_proxy_cluster_with_options_async(request, runtime)

    def delete_idc_probe_with_options(
        self,
        request: sas_20181203_models.DeleteIdcProbeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteIdcProbeResponse:
        """
        @summary Deletes an IDC probe that is created in Security Center.
        
        @param request: DeleteIdcProbeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteIdcProbeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIdcProbe',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteIdcProbeResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_idc_probe_with_options_async(
        self,
        request: sas_20181203_models.DeleteIdcProbeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteIdcProbeResponse:
        """
        @summary Deletes an IDC probe that is created in Security Center.
        
        @param request: DeleteIdcProbeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteIdcProbeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIdcProbe',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteIdcProbeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_idc_probe(
        self,
        request: sas_20181203_models.DeleteIdcProbeRequest,
    ) -> sas_20181203_models.DeleteIdcProbeResponse:
        """
        @summary Deletes an IDC probe that is created in Security Center.
        
        @param request: DeleteIdcProbeRequest
        @return: DeleteIdcProbeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_idc_probe_with_options(request, runtime)

    async def delete_idc_probe_async(
        self,
        request: sas_20181203_models.DeleteIdcProbeRequest,
    ) -> sas_20181203_models.DeleteIdcProbeResponse:
        """
        @summary Deletes an IDC probe that is created in Security Center.
        
        @param request: DeleteIdcProbeRequest
        @return: DeleteIdcProbeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_idc_probe_with_options_async(request, runtime)

    def delete_image_event_operation_with_options(
        self,
        request: sas_20181203_models.DeleteImageEventOperationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteImageEventOperationResponse:
        """
        @summary Deletes an alert handling rule.
        
        @param request: DeleteImageEventOperationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteImageEventOperationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteImageEventOperation',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteImageEventOperationResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_image_event_operation_with_options_async(
        self,
        request: sas_20181203_models.DeleteImageEventOperationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteImageEventOperationResponse:
        """
        @summary Deletes an alert handling rule.
        
        @param request: DeleteImageEventOperationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteImageEventOperationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteImageEventOperation',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteImageEventOperationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_image_event_operation(
        self,
        request: sas_20181203_models.DeleteImageEventOperationRequest,
    ) -> sas_20181203_models.DeleteImageEventOperationResponse:
        """
        @summary Deletes an alert handling rule.
        
        @param request: DeleteImageEventOperationRequest
        @return: DeleteImageEventOperationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_image_event_operation_with_options(request, runtime)

    async def delete_image_event_operation_async(
        self,
        request: sas_20181203_models.DeleteImageEventOperationRequest,
    ) -> sas_20181203_models.DeleteImageEventOperationResponse:
        """
        @summary Deletes an alert handling rule.
        
        @param request: DeleteImageEventOperationRequest
        @return: DeleteImageEventOperationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_image_event_operation_with_options_async(request, runtime)

    def delete_image_vul_whitelist_with_options(
        self,
        request: sas_20181203_models.DeleteImageVulWhitelistRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteImageVulWhitelistResponse:
        """
        @summary Deletes an image vulnerability whitelist.
        
        @param request: DeleteImageVulWhitelistRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteImageVulWhitelistResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ids):
            query['Ids'] = request.ids
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteImageVulWhitelist',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteImageVulWhitelistResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_image_vul_whitelist_with_options_async(
        self,
        request: sas_20181203_models.DeleteImageVulWhitelistRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteImageVulWhitelistResponse:
        """
        @summary Deletes an image vulnerability whitelist.
        
        @param request: DeleteImageVulWhitelistRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteImageVulWhitelistResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ids):
            query['Ids'] = request.ids
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteImageVulWhitelist',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteImageVulWhitelistResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_image_vul_whitelist(
        self,
        request: sas_20181203_models.DeleteImageVulWhitelistRequest,
    ) -> sas_20181203_models.DeleteImageVulWhitelistResponse:
        """
        @summary Deletes an image vulnerability whitelist.
        
        @param request: DeleteImageVulWhitelistRequest
        @return: DeleteImageVulWhitelistResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_image_vul_whitelist_with_options(request, runtime)

    async def delete_image_vul_whitelist_async(
        self,
        request: sas_20181203_models.DeleteImageVulWhitelistRequest,
    ) -> sas_20181203_models.DeleteImageVulWhitelistResponse:
        """
        @summary Deletes an image vulnerability whitelist.
        
        @param request: DeleteImageVulWhitelistRequest
        @return: DeleteImageVulWhitelistResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_image_vul_whitelist_with_options_async(request, runtime)

    def delete_install_code_with_options(
        self,
        request: sas_20181203_models.DeleteInstallCodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteInstallCodeResponse:
        """
        @summary Deletes the command that is used to install the Security Center agent.
        
        @param request: DeleteInstallCodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteInstallCodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.captcha_code):
            query['CaptchaCode'] = request.captcha_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInstallCode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteInstallCodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_install_code_with_options_async(
        self,
        request: sas_20181203_models.DeleteInstallCodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteInstallCodeResponse:
        """
        @summary Deletes the command that is used to install the Security Center agent.
        
        @param request: DeleteInstallCodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteInstallCodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.captcha_code):
            query['CaptchaCode'] = request.captcha_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInstallCode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteInstallCodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_install_code(
        self,
        request: sas_20181203_models.DeleteInstallCodeRequest,
    ) -> sas_20181203_models.DeleteInstallCodeResponse:
        """
        @summary Deletes the command that is used to install the Security Center agent.
        
        @param request: DeleteInstallCodeRequest
        @return: DeleteInstallCodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_install_code_with_options(request, runtime)

    async def delete_install_code_async(
        self,
        request: sas_20181203_models.DeleteInstallCodeRequest,
    ) -> sas_20181203_models.DeleteInstallCodeResponse:
        """
        @summary Deletes the command that is used to install the Security Center agent.
        
        @param request: DeleteInstallCodeRequest
        @return: DeleteInstallCodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_install_code_with_options_async(request, runtime)

    def delete_interception_rule_with_options(
        self,
        request: sas_20181203_models.DeleteInterceptionRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteInterceptionRuleResponse:
        """
        @summary Deletes a defense rule in the container firewall module.
        
        @param request: DeleteInterceptionRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteInterceptionRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.rule_ids):
            query['RuleIds'] = request.rule_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInterceptionRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteInterceptionRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_interception_rule_with_options_async(
        self,
        request: sas_20181203_models.DeleteInterceptionRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteInterceptionRuleResponse:
        """
        @summary Deletes a defense rule in the container firewall module.
        
        @param request: DeleteInterceptionRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteInterceptionRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.rule_ids):
            query['RuleIds'] = request.rule_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInterceptionRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteInterceptionRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_interception_rule(
        self,
        request: sas_20181203_models.DeleteInterceptionRuleRequest,
    ) -> sas_20181203_models.DeleteInterceptionRuleResponse:
        """
        @summary Deletes a defense rule in the container firewall module.
        
        @param request: DeleteInterceptionRuleRequest
        @return: DeleteInterceptionRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_interception_rule_with_options(request, runtime)

    async def delete_interception_rule_async(
        self,
        request: sas_20181203_models.DeleteInterceptionRuleRequest,
    ) -> sas_20181203_models.DeleteInterceptionRuleResponse:
        """
        @summary Deletes a defense rule in the container firewall module.
        
        @param request: DeleteInterceptionRuleRequest
        @return: DeleteInterceptionRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_interception_rule_with_options_async(request, runtime)

    def delete_interception_target_with_options(
        self,
        request: sas_20181203_models.DeleteInterceptionTargetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteInterceptionTargetResponse:
        """
        @summary Removes the network objects that are in effect in the container firewall.
        
        @param request: DeleteInterceptionTargetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteInterceptionTargetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.target_ids):
            query['TargetIds'] = request.target_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInterceptionTarget',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteInterceptionTargetResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_interception_target_with_options_async(
        self,
        request: sas_20181203_models.DeleteInterceptionTargetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteInterceptionTargetResponse:
        """
        @summary Removes the network objects that are in effect in the container firewall.
        
        @param request: DeleteInterceptionTargetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteInterceptionTargetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.target_ids):
            query['TargetIds'] = request.target_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInterceptionTarget',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteInterceptionTargetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_interception_target(
        self,
        request: sas_20181203_models.DeleteInterceptionTargetRequest,
    ) -> sas_20181203_models.DeleteInterceptionTargetResponse:
        """
        @summary Removes the network objects that are in effect in the container firewall.
        
        @param request: DeleteInterceptionTargetRequest
        @return: DeleteInterceptionTargetResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_interception_target_with_options(request, runtime)

    async def delete_interception_target_async(
        self,
        request: sas_20181203_models.DeleteInterceptionTargetRequest,
    ) -> sas_20181203_models.DeleteInterceptionTargetResponse:
        """
        @summary Removes the network objects that are in effect in the container firewall.
        
        @param request: DeleteInterceptionTargetRequest
        @return: DeleteInterceptionTargetResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_interception_target_with_options_async(request, runtime)

    def delete_k8s_access_info_with_options(
        self,
        request: sas_20181203_models.DeleteK8sAccessInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteK8sAccessInfoResponse:
        """
        @summary Deletes the Kubernetes access information.
        
        @param request: DeleteK8sAccessInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteK8sAccessInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aliyun_yundun_gateway_api_name):
            query['AliyunYundunGatewayApiName'] = request.aliyun_yundun_gateway_api_name
        if not UtilClient.is_unset(request.aliyun_yundun_gateway_pop_name):
            query['AliyunYundunGatewayPopName'] = request.aliyun_yundun_gateway_pop_name
        if not UtilClient.is_unset(request.aliyun_yundun_gateway_project_name):
            query['AliyunYundunGatewayProjectName'] = request.aliyun_yundun_gateway_project_name
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteK8sAccessInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteK8sAccessInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_k8s_access_info_with_options_async(
        self,
        request: sas_20181203_models.DeleteK8sAccessInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteK8sAccessInfoResponse:
        """
        @summary Deletes the Kubernetes access information.
        
        @param request: DeleteK8sAccessInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteK8sAccessInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aliyun_yundun_gateway_api_name):
            query['AliyunYundunGatewayApiName'] = request.aliyun_yundun_gateway_api_name
        if not UtilClient.is_unset(request.aliyun_yundun_gateway_pop_name):
            query['AliyunYundunGatewayPopName'] = request.aliyun_yundun_gateway_pop_name
        if not UtilClient.is_unset(request.aliyun_yundun_gateway_project_name):
            query['AliyunYundunGatewayProjectName'] = request.aliyun_yundun_gateway_project_name
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteK8sAccessInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteK8sAccessInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_k8s_access_info(
        self,
        request: sas_20181203_models.DeleteK8sAccessInfoRequest,
    ) -> sas_20181203_models.DeleteK8sAccessInfoResponse:
        """
        @summary Deletes the Kubernetes access information.
        
        @param request: DeleteK8sAccessInfoRequest
        @return: DeleteK8sAccessInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_k8s_access_info_with_options(request, runtime)

    async def delete_k8s_access_info_async(
        self,
        request: sas_20181203_models.DeleteK8sAccessInfoRequest,
    ) -> sas_20181203_models.DeleteK8sAccessInfoResponse:
        """
        @summary Deletes the Kubernetes access information.
        
        @param request: DeleteK8sAccessInfoRequest
        @return: DeleteK8sAccessInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_k8s_access_info_with_options_async(request, runtime)

    def delete_login_base_config_with_options(
        self,
        request: sas_20181203_models.DeleteLoginBaseConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteLoginBaseConfigResponse:
        """
        @summary Deletes the basic configuration information from the logon security configurations for a specific asset.
        
        @param request: DeleteLoginBaseConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLoginBaseConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config):
            query['Config'] = request.config
        if not UtilClient.is_unset(request.target):
            query['Target'] = request.target
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLoginBaseConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteLoginBaseConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_login_base_config_with_options_async(
        self,
        request: sas_20181203_models.DeleteLoginBaseConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteLoginBaseConfigResponse:
        """
        @summary Deletes the basic configuration information from the logon security configurations for a specific asset.
        
        @param request: DeleteLoginBaseConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLoginBaseConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config):
            query['Config'] = request.config
        if not UtilClient.is_unset(request.target):
            query['Target'] = request.target
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLoginBaseConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteLoginBaseConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_login_base_config(
        self,
        request: sas_20181203_models.DeleteLoginBaseConfigRequest,
    ) -> sas_20181203_models.DeleteLoginBaseConfigResponse:
        """
        @summary Deletes the basic configuration information from the logon security configurations for a specific asset.
        
        @param request: DeleteLoginBaseConfigRequest
        @return: DeleteLoginBaseConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_login_base_config_with_options(request, runtime)

    async def delete_login_base_config_async(
        self,
        request: sas_20181203_models.DeleteLoginBaseConfigRequest,
    ) -> sas_20181203_models.DeleteLoginBaseConfigResponse:
        """
        @summary Deletes the basic configuration information from the logon security configurations for a specific asset.
        
        @param request: DeleteLoginBaseConfigRequest
        @return: DeleteLoginBaseConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_login_base_config_with_options_async(request, runtime)

    def delete_malicious_file_whitelist_config_with_options(
        self,
        request: sas_20181203_models.DeleteMaliciousFileWhitelistConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteMaliciousFileWhitelistConfigResponse:
        """
        @summary Deletes a whitelist rule for alerts generated for sensitive files that are detected by using the agentless detection feature.
        
        @param request: DeleteMaliciousFileWhitelistConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMaliciousFileWhitelistConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config_id):
            query['ConfigId'] = request.config_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMaliciousFileWhitelistConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteMaliciousFileWhitelistConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_malicious_file_whitelist_config_with_options_async(
        self,
        request: sas_20181203_models.DeleteMaliciousFileWhitelistConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteMaliciousFileWhitelistConfigResponse:
        """
        @summary Deletes a whitelist rule for alerts generated for sensitive files that are detected by using the agentless detection feature.
        
        @param request: DeleteMaliciousFileWhitelistConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMaliciousFileWhitelistConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config_id):
            query['ConfigId'] = request.config_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMaliciousFileWhitelistConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteMaliciousFileWhitelistConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_malicious_file_whitelist_config(
        self,
        request: sas_20181203_models.DeleteMaliciousFileWhitelistConfigRequest,
    ) -> sas_20181203_models.DeleteMaliciousFileWhitelistConfigResponse:
        """
        @summary Deletes a whitelist rule for alerts generated for sensitive files that are detected by using the agentless detection feature.
        
        @param request: DeleteMaliciousFileWhitelistConfigRequest
        @return: DeleteMaliciousFileWhitelistConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_malicious_file_whitelist_config_with_options(request, runtime)

    async def delete_malicious_file_whitelist_config_async(
        self,
        request: sas_20181203_models.DeleteMaliciousFileWhitelistConfigRequest,
    ) -> sas_20181203_models.DeleteMaliciousFileWhitelistConfigResponse:
        """
        @summary Deletes a whitelist rule for alerts generated for sensitive files that are detected by using the agentless detection feature.
        
        @param request: DeleteMaliciousFileWhitelistConfigRequest
        @return: DeleteMaliciousFileWhitelistConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_malicious_file_whitelist_config_with_options_async(request, runtime)

    def delete_malicious_note_with_options(
        self,
        request: sas_20181203_models.DeleteMaliciousNoteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteMaliciousNoteResponse:
        """
        @summary Removes the remarks added to alert events that are generated by the agentless detection feature.
        
        @param request: DeleteMaliciousNoteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMaliciousNoteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.note_id):
            query['NoteId'] = request.note_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMaliciousNote',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteMaliciousNoteResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_malicious_note_with_options_async(
        self,
        request: sas_20181203_models.DeleteMaliciousNoteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteMaliciousNoteResponse:
        """
        @summary Removes the remarks added to alert events that are generated by the agentless detection feature.
        
        @param request: DeleteMaliciousNoteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMaliciousNoteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.note_id):
            query['NoteId'] = request.note_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMaliciousNote',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteMaliciousNoteResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_malicious_note(
        self,
        request: sas_20181203_models.DeleteMaliciousNoteRequest,
    ) -> sas_20181203_models.DeleteMaliciousNoteResponse:
        """
        @summary Removes the remarks added to alert events that are generated by the agentless detection feature.
        
        @param request: DeleteMaliciousNoteRequest
        @return: DeleteMaliciousNoteResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_malicious_note_with_options(request, runtime)

    async def delete_malicious_note_async(
        self,
        request: sas_20181203_models.DeleteMaliciousNoteRequest,
    ) -> sas_20181203_models.DeleteMaliciousNoteResponse:
        """
        @summary Removes the remarks added to alert events that are generated by the agentless detection feature.
        
        @param request: DeleteMaliciousNoteRequest
        @return: DeleteMaliciousNoteResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_malicious_note_with_options_async(request, runtime)

    def delete_monitor_account_with_options(
        self,
        request: sas_20181203_models.DeleteMonitorAccountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteMonitorAccountResponse:
        """
        @summary Deletes a member of the account managed by Security Center type of the multi-account management feature.
        
        @description You must use the management account of your resource directory or a delegated administrator account of Security Center to call this operation.
        
        @param request: DeleteMonitorAccountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMonitorAccountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_id):
            query['AccountId'] = request.account_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMonitorAccount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteMonitorAccountResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_monitor_account_with_options_async(
        self,
        request: sas_20181203_models.DeleteMonitorAccountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteMonitorAccountResponse:
        """
        @summary Deletes a member of the account managed by Security Center type of the multi-account management feature.
        
        @description You must use the management account of your resource directory or a delegated administrator account of Security Center to call this operation.
        
        @param request: DeleteMonitorAccountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMonitorAccountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_id):
            query['AccountId'] = request.account_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMonitorAccount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteMonitorAccountResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_monitor_account(
        self,
        request: sas_20181203_models.DeleteMonitorAccountRequest,
    ) -> sas_20181203_models.DeleteMonitorAccountResponse:
        """
        @summary Deletes a member of the account managed by Security Center type of the multi-account management feature.
        
        @description You must use the management account of your resource directory or a delegated administrator account of Security Center to call this operation.
        
        @param request: DeleteMonitorAccountRequest
        @return: DeleteMonitorAccountResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_monitor_account_with_options(request, runtime)

    async def delete_monitor_account_async(
        self,
        request: sas_20181203_models.DeleteMonitorAccountRequest,
    ) -> sas_20181203_models.DeleteMonitorAccountResponse:
        """
        @summary Deletes a member of the account managed by Security Center type of the multi-account management feature.
        
        @description You must use the management account of your resource directory or a delegated administrator account of Security Center to call this operation.
        
        @param request: DeleteMonitorAccountRequest
        @return: DeleteMonitorAccountResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_monitor_account_with_options_async(request, runtime)

    def delete_opa_strategy_new_with_options(
        self,
        request: sas_20181203_models.DeleteOpaStrategyNewRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteOpaStrategyNewResponse:
        """
        @summary Deletes rules of the at-risk image blocking type.
        
        @param request: DeleteOpaStrategyNewRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteOpaStrategyNewResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.strategy_ids):
            query['StrategyIds'] = request.strategy_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteOpaStrategyNew',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteOpaStrategyNewResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_opa_strategy_new_with_options_async(
        self,
        request: sas_20181203_models.DeleteOpaStrategyNewRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteOpaStrategyNewResponse:
        """
        @summary Deletes rules of the at-risk image blocking type.
        
        @param request: DeleteOpaStrategyNewRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteOpaStrategyNewResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.strategy_ids):
            query['StrategyIds'] = request.strategy_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteOpaStrategyNew',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteOpaStrategyNewResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_opa_strategy_new(
        self,
        request: sas_20181203_models.DeleteOpaStrategyNewRequest,
    ) -> sas_20181203_models.DeleteOpaStrategyNewResponse:
        """
        @summary Deletes rules of the at-risk image blocking type.
        
        @param request: DeleteOpaStrategyNewRequest
        @return: DeleteOpaStrategyNewResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_opa_strategy_new_with_options(request, runtime)

    async def delete_opa_strategy_new_async(
        self,
        request: sas_20181203_models.DeleteOpaStrategyNewRequest,
    ) -> sas_20181203_models.DeleteOpaStrategyNewResponse:
        """
        @summary Deletes rules of the at-risk image blocking type.
        
        @param request: DeleteOpaStrategyNewRequest
        @return: DeleteOpaStrategyNewResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_opa_strategy_new_with_options_async(request, runtime)

    def delete_oss_scan_config_with_options(
        self,
        request: sas_20181203_models.DeleteOssScanConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteOssScanConfigResponse:
        """
        @summary Deletes the configuration of an Object Storage Service (OSS) file detection policy.
        
        @param request: DeleteOssScanConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteOssScanConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteOssScanConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteOssScanConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_oss_scan_config_with_options_async(
        self,
        request: sas_20181203_models.DeleteOssScanConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteOssScanConfigResponse:
        """
        @summary Deletes the configuration of an Object Storage Service (OSS) file detection policy.
        
        @param request: DeleteOssScanConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteOssScanConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteOssScanConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteOssScanConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_oss_scan_config(
        self,
        request: sas_20181203_models.DeleteOssScanConfigRequest,
    ) -> sas_20181203_models.DeleteOssScanConfigResponse:
        """
        @summary Deletes the configuration of an Object Storage Service (OSS) file detection policy.
        
        @param request: DeleteOssScanConfigRequest
        @return: DeleteOssScanConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_oss_scan_config_with_options(request, runtime)

    async def delete_oss_scan_config_async(
        self,
        request: sas_20181203_models.DeleteOssScanConfigRequest,
    ) -> sas_20181203_models.DeleteOssScanConfigResponse:
        """
        @summary Deletes the configuration of an Object Storage Service (OSS) file detection policy.
        
        @param request: DeleteOssScanConfigRequest
        @return: DeleteOssScanConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_oss_scan_config_with_options_async(request, runtime)

    def delete_private_registry_with_options(
        self,
        request: sas_20181203_models.DeletePrivateRegistryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeletePrivateRegistryResponse:
        """
        @summary Deletes a private image repository by using the ID of the image repository.
        
        @param request: DeletePrivateRegistryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePrivateRegistryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.registry_id):
            query['RegistryId'] = request.registry_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePrivateRegistry',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeletePrivateRegistryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_private_registry_with_options_async(
        self,
        request: sas_20181203_models.DeletePrivateRegistryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeletePrivateRegistryResponse:
        """
        @summary Deletes a private image repository by using the ID of the image repository.
        
        @param request: DeletePrivateRegistryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePrivateRegistryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.registry_id):
            query['RegistryId'] = request.registry_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePrivateRegistry',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeletePrivateRegistryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_private_registry(
        self,
        request: sas_20181203_models.DeletePrivateRegistryRequest,
    ) -> sas_20181203_models.DeletePrivateRegistryResponse:
        """
        @summary Deletes a private image repository by using the ID of the image repository.
        
        @param request: DeletePrivateRegistryRequest
        @return: DeletePrivateRegistryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_private_registry_with_options(request, runtime)

    async def delete_private_registry_async(
        self,
        request: sas_20181203_models.DeletePrivateRegistryRequest,
    ) -> sas_20181203_models.DeletePrivateRegistryResponse:
        """
        @summary Deletes a private image repository by using the ID of the image repository.
        
        @param request: DeletePrivateRegistryRequest
        @return: DeletePrivateRegistryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_private_registry_with_options_async(request, runtime)

    def delete_sas_container_web_defense_rule_with_options(
        self,
        request: sas_20181203_models.DeleteSasContainerWebDefenseRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteSasContainerWebDefenseRuleResponse:
        """
        @summary Deletes a rule for container tamper-proofing.
        
        @param request: DeleteSasContainerWebDefenseRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSasContainerWebDefenseRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSasContainerWebDefenseRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteSasContainerWebDefenseRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_sas_container_web_defense_rule_with_options_async(
        self,
        request: sas_20181203_models.DeleteSasContainerWebDefenseRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteSasContainerWebDefenseRuleResponse:
        """
        @summary Deletes a rule for container tamper-proofing.
        
        @param request: DeleteSasContainerWebDefenseRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSasContainerWebDefenseRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSasContainerWebDefenseRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteSasContainerWebDefenseRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_sas_container_web_defense_rule(
        self,
        request: sas_20181203_models.DeleteSasContainerWebDefenseRuleRequest,
    ) -> sas_20181203_models.DeleteSasContainerWebDefenseRuleResponse:
        """
        @summary Deletes a rule for container tamper-proofing.
        
        @param request: DeleteSasContainerWebDefenseRuleRequest
        @return: DeleteSasContainerWebDefenseRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_sas_container_web_defense_rule_with_options(request, runtime)

    async def delete_sas_container_web_defense_rule_async(
        self,
        request: sas_20181203_models.DeleteSasContainerWebDefenseRuleRequest,
    ) -> sas_20181203_models.DeleteSasContainerWebDefenseRuleResponse:
        """
        @summary Deletes a rule for container tamper-proofing.
        
        @param request: DeleteSasContainerWebDefenseRuleRequest
        @return: DeleteSasContainerWebDefenseRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_sas_container_web_defense_rule_with_options_async(request, runtime)

    def delete_search_condition_with_options(
        self,
        request: sas_20181203_models.DeleteSearchConditionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteSearchConditionResponse:
        """
        @summary Deletes a frequently used search condition by using the asset management feature of the Assets module in the Security Center console.
        
        @param request: DeleteSearchConditionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSearchConditionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSearchCondition',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteSearchConditionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_search_condition_with_options_async(
        self,
        request: sas_20181203_models.DeleteSearchConditionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteSearchConditionResponse:
        """
        @summary Deletes a frequently used search condition by using the asset management feature of the Assets module in the Security Center console.
        
        @param request: DeleteSearchConditionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSearchConditionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSearchCondition',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteSearchConditionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_search_condition(
        self,
        request: sas_20181203_models.DeleteSearchConditionRequest,
    ) -> sas_20181203_models.DeleteSearchConditionResponse:
        """
        @summary Deletes a frequently used search condition by using the asset management feature of the Assets module in the Security Center console.
        
        @param request: DeleteSearchConditionRequest
        @return: DeleteSearchConditionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_search_condition_with_options(request, runtime)

    async def delete_search_condition_async(
        self,
        request: sas_20181203_models.DeleteSearchConditionRequest,
    ) -> sas_20181203_models.DeleteSearchConditionResponse:
        """
        @summary Deletes a frequently used search condition by using the asset management feature of the Assets module in the Security Center console.
        
        @param request: DeleteSearchConditionRequest
        @return: DeleteSearchConditionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_search_condition_with_options_async(request, runtime)

    def delete_security_event_mark_miss_list_with_options(
        self,
        request: sas_20181203_models.DeleteSecurityEventMarkMissListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteSecurityEventMarkMissListResponse:
        """
        @deprecated OpenAPI DeleteSecurityEventMarkMissList is deprecated, please use Sas::2018-12-03::ModifySecurityEventMarkMissIndividually instead.
        
        @summary Deletes multiple custom defense rules at a time. The custom defense rules are used to add false positive alerts to the whitelist.
        
        @param request: DeleteSecurityEventMarkMissListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSecurityEventMarkMissListResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ids):
            query['Ids'] = request.ids
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSecurityEventMarkMissList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteSecurityEventMarkMissListResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_security_event_mark_miss_list_with_options_async(
        self,
        request: sas_20181203_models.DeleteSecurityEventMarkMissListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteSecurityEventMarkMissListResponse:
        """
        @deprecated OpenAPI DeleteSecurityEventMarkMissList is deprecated, please use Sas::2018-12-03::ModifySecurityEventMarkMissIndividually instead.
        
        @summary Deletes multiple custom defense rules at a time. The custom defense rules are used to add false positive alerts to the whitelist.
        
        @param request: DeleteSecurityEventMarkMissListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSecurityEventMarkMissListResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ids):
            query['Ids'] = request.ids
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSecurityEventMarkMissList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteSecurityEventMarkMissListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_security_event_mark_miss_list(
        self,
        request: sas_20181203_models.DeleteSecurityEventMarkMissListRequest,
    ) -> sas_20181203_models.DeleteSecurityEventMarkMissListResponse:
        """
        @deprecated OpenAPI DeleteSecurityEventMarkMissList is deprecated, please use Sas::2018-12-03::ModifySecurityEventMarkMissIndividually instead.
        
        @summary Deletes multiple custom defense rules at a time. The custom defense rules are used to add false positive alerts to the whitelist.
        
        @param request: DeleteSecurityEventMarkMissListRequest
        @return: DeleteSecurityEventMarkMissListResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_security_event_mark_miss_list_with_options(request, runtime)

    async def delete_security_event_mark_miss_list_async(
        self,
        request: sas_20181203_models.DeleteSecurityEventMarkMissListRequest,
    ) -> sas_20181203_models.DeleteSecurityEventMarkMissListResponse:
        """
        @deprecated OpenAPI DeleteSecurityEventMarkMissList is deprecated, please use Sas::2018-12-03::ModifySecurityEventMarkMissIndividually instead.
        
        @summary Deletes multiple custom defense rules at a time. The custom defense rules are used to add false positive alerts to the whitelist.
        
        @param request: DeleteSecurityEventMarkMissListRequest
        @return: DeleteSecurityEventMarkMissListResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_security_event_mark_miss_list_with_options_async(request, runtime)

    def delete_service_trail_with_options(
        self,
        request: sas_20181203_models.DeleteServiceTrailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteServiceTrailResponse:
        """
        @summary Deletes a service trail.
        
        @param request: DeleteServiceTrailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteServiceTrailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteServiceTrail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteServiceTrailResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_service_trail_with_options_async(
        self,
        request: sas_20181203_models.DeleteServiceTrailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteServiceTrailResponse:
        """
        @summary Deletes a service trail.
        
        @param request: DeleteServiceTrailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteServiceTrailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteServiceTrail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteServiceTrailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_service_trail(
        self,
        request: sas_20181203_models.DeleteServiceTrailRequest,
    ) -> sas_20181203_models.DeleteServiceTrailResponse:
        """
        @summary Deletes a service trail.
        
        @param request: DeleteServiceTrailRequest
        @return: DeleteServiceTrailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_service_trail_with_options(request, runtime)

    async def delete_service_trail_async(
        self,
        request: sas_20181203_models.DeleteServiceTrailRequest,
    ) -> sas_20181203_models.DeleteServiceTrailResponse:
        """
        @summary Deletes a service trail.
        
        @param request: DeleteServiceTrailRequest
        @return: DeleteServiceTrailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_service_trail_with_options_async(request, runtime)

    def delete_soar_strategy_task_with_options(
        self,
        request: sas_20181203_models.DeleteSoarStrategyTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteSoarStrategyTaskResponse:
        """
        @summary Deletes a policy task that is in the waiting state on the Playbook page.
        
        @description Only the Enterprise and Ultimate editions of Security Center support this API operation.
        
        @param request: DeleteSoarStrategyTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSoarStrategyTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.strategy_task_id):
            query['StrategyTaskId'] = request.strategy_task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSoarStrategyTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteSoarStrategyTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_soar_strategy_task_with_options_async(
        self,
        request: sas_20181203_models.DeleteSoarStrategyTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteSoarStrategyTaskResponse:
        """
        @summary Deletes a policy task that is in the waiting state on the Playbook page.
        
        @description Only the Enterprise and Ultimate editions of Security Center support this API operation.
        
        @param request: DeleteSoarStrategyTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSoarStrategyTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.strategy_task_id):
            query['StrategyTaskId'] = request.strategy_task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSoarStrategyTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteSoarStrategyTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_soar_strategy_task(
        self,
        request: sas_20181203_models.DeleteSoarStrategyTaskRequest,
    ) -> sas_20181203_models.DeleteSoarStrategyTaskResponse:
        """
        @summary Deletes a policy task that is in the waiting state on the Playbook page.
        
        @description Only the Enterprise and Ultimate editions of Security Center support this API operation.
        
        @param request: DeleteSoarStrategyTaskRequest
        @return: DeleteSoarStrategyTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_soar_strategy_task_with_options(request, runtime)

    async def delete_soar_strategy_task_async(
        self,
        request: sas_20181203_models.DeleteSoarStrategyTaskRequest,
    ) -> sas_20181203_models.DeleteSoarStrategyTaskResponse:
        """
        @summary Deletes a policy task that is in the waiting state on the Playbook page.
        
        @description Only the Enterprise and Ultimate editions of Security Center support this API operation.
        
        @param request: DeleteSoarStrategyTaskRequest
        @return: DeleteSoarStrategyTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_soar_strategy_task_with_options_async(request, runtime)

    def delete_strategy_with_options(
        self,
        request: sas_20181203_models.DeleteStrategyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteStrategyResponse:
        """
        @summary Deletes a baseline check policy.
        
        @param request: DeleteStrategyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteStrategyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteStrategy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteStrategyResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_strategy_with_options_async(
        self,
        request: sas_20181203_models.DeleteStrategyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteStrategyResponse:
        """
        @summary Deletes a baseline check policy.
        
        @param request: DeleteStrategyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteStrategyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteStrategy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteStrategyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_strategy(
        self,
        request: sas_20181203_models.DeleteStrategyRequest,
    ) -> sas_20181203_models.DeleteStrategyResponse:
        """
        @summary Deletes a baseline check policy.
        
        @param request: DeleteStrategyRequest
        @return: DeleteStrategyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_strategy_with_options(request, runtime)

    async def delete_strategy_async(
        self,
        request: sas_20181203_models.DeleteStrategyRequest,
    ) -> sas_20181203_models.DeleteStrategyResponse:
        """
        @summary Deletes a baseline check policy.
        
        @param request: DeleteStrategyRequest
        @return: DeleteStrategyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_strategy_with_options_async(request, runtime)

    def delete_susp_event_node_with_options(
        self,
        request: sas_20181203_models.DeleteSuspEventNodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteSuspEventNodeResponse:
        """
        @summary Deletes the description of an alert.
        
        @param request: DeleteSuspEventNodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSuspEventNodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.note_id):
            query['NoteId'] = request.note_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSuspEventNode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteSuspEventNodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_susp_event_node_with_options_async(
        self,
        request: sas_20181203_models.DeleteSuspEventNodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteSuspEventNodeResponse:
        """
        @summary Deletes the description of an alert.
        
        @param request: DeleteSuspEventNodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSuspEventNodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.note_id):
            query['NoteId'] = request.note_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSuspEventNode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteSuspEventNodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_susp_event_node(
        self,
        request: sas_20181203_models.DeleteSuspEventNodeRequest,
    ) -> sas_20181203_models.DeleteSuspEventNodeResponse:
        """
        @summary Deletes the description of an alert.
        
        @param request: DeleteSuspEventNodeRequest
        @return: DeleteSuspEventNodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_susp_event_node_with_options(request, runtime)

    async def delete_susp_event_node_async(
        self,
        request: sas_20181203_models.DeleteSuspEventNodeRequest,
    ) -> sas_20181203_models.DeleteSuspEventNodeResponse:
        """
        @summary Deletes the description of an alert.
        
        @param request: DeleteSuspEventNodeRequest
        @return: DeleteSuspEventNodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_susp_event_node_with_options_async(request, runtime)

    def delete_tag_with_uuid_with_options(
        self,
        request: sas_20181203_models.DeleteTagWithUuidRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteTagWithUuidResponse:
        """
        @summary Removes custom tags from assets.
        
        @description Security Center provides asset importance tags and custom tags. You can call this operation to remove only the custom tag that is added to an asset.
        
        @param request: DeleteTagWithUuidRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteTagWithUuidResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.tag_name):
            query['TagName'] = request.tag_name
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTagWithUuid',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteTagWithUuidResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_tag_with_uuid_with_options_async(
        self,
        request: sas_20181203_models.DeleteTagWithUuidRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteTagWithUuidResponse:
        """
        @summary Removes custom tags from assets.
        
        @description Security Center provides asset importance tags and custom tags. You can call this operation to remove only the custom tag that is added to an asset.
        
        @param request: DeleteTagWithUuidRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteTagWithUuidResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.tag_name):
            query['TagName'] = request.tag_name
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTagWithUuid',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteTagWithUuidResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_tag_with_uuid(
        self,
        request: sas_20181203_models.DeleteTagWithUuidRequest,
    ) -> sas_20181203_models.DeleteTagWithUuidResponse:
        """
        @summary Removes custom tags from assets.
        
        @description Security Center provides asset importance tags and custom tags. You can call this operation to remove only the custom tag that is added to an asset.
        
        @param request: DeleteTagWithUuidRequest
        @return: DeleteTagWithUuidResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_tag_with_uuid_with_options(request, runtime)

    async def delete_tag_with_uuid_async(
        self,
        request: sas_20181203_models.DeleteTagWithUuidRequest,
    ) -> sas_20181203_models.DeleteTagWithUuidResponse:
        """
        @summary Removes custom tags from assets.
        
        @description Security Center provides asset importance tags and custom tags. You can call this operation to remove only the custom tag that is added to an asset.
        
        @param request: DeleteTagWithUuidRequest
        @return: DeleteTagWithUuidResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_tag_with_uuid_with_options_async(request, runtime)

    def delete_uni_backup_policy_with_options(
        self,
        request: sas_20181203_models.DeleteUniBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteUniBackupPolicyResponse:
        """
        @summary Deletes anti-ransomware policies that are created for databases.
        
        @param request: DeleteUniBackupPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteUniBackupPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.policy_ids):
            query['PolicyIds'] = request.policy_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteUniBackupPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteUniBackupPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_uni_backup_policy_with_options_async(
        self,
        request: sas_20181203_models.DeleteUniBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteUniBackupPolicyResponse:
        """
        @summary Deletes anti-ransomware policies that are created for databases.
        
        @param request: DeleteUniBackupPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteUniBackupPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.policy_ids):
            query['PolicyIds'] = request.policy_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteUniBackupPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteUniBackupPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_uni_backup_policy(
        self,
        request: sas_20181203_models.DeleteUniBackupPolicyRequest,
    ) -> sas_20181203_models.DeleteUniBackupPolicyResponse:
        """
        @summary Deletes anti-ransomware policies that are created for databases.
        
        @param request: DeleteUniBackupPolicyRequest
        @return: DeleteUniBackupPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_uni_backup_policy_with_options(request, runtime)

    async def delete_uni_backup_policy_async(
        self,
        request: sas_20181203_models.DeleteUniBackupPolicyRequest,
    ) -> sas_20181203_models.DeleteUniBackupPolicyResponse:
        """
        @summary Deletes anti-ransomware policies that are created for databases.
        
        @param request: DeleteUniBackupPolicyRequest
        @return: DeleteUniBackupPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_uni_backup_policy_with_options_async(request, runtime)

    def delete_vpc_honey_pot_with_options(
        self,
        request: sas_20181203_models.DeleteVpcHoneyPotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteVpcHoneyPotResponse:
        """
        @summary Deletes a honeypot.
        
        @param request: DeleteVpcHoneyPotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVpcHoneyPotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpcHoneyPot',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteVpcHoneyPotResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpc_honey_pot_with_options_async(
        self,
        request: sas_20181203_models.DeleteVpcHoneyPotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteVpcHoneyPotResponse:
        """
        @summary Deletes a honeypot.
        
        @param request: DeleteVpcHoneyPotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVpcHoneyPotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpcHoneyPot',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteVpcHoneyPotResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpc_honey_pot(
        self,
        request: sas_20181203_models.DeleteVpcHoneyPotRequest,
    ) -> sas_20181203_models.DeleteVpcHoneyPotResponse:
        """
        @summary Deletes a honeypot.
        
        @param request: DeleteVpcHoneyPotRequest
        @return: DeleteVpcHoneyPotResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_vpc_honey_pot_with_options(request, runtime)

    async def delete_vpc_honey_pot_async(
        self,
        request: sas_20181203_models.DeleteVpcHoneyPotRequest,
    ) -> sas_20181203_models.DeleteVpcHoneyPotResponse:
        """
        @summary Deletes a honeypot.
        
        @param request: DeleteVpcHoneyPotRequest
        @return: DeleteVpcHoneyPotResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpc_honey_pot_with_options_async(request, runtime)

    def delete_vul_auto_repair_config_with_options(
        self,
        request: sas_20181203_models.DeleteVulAutoRepairConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteVulAutoRepairConfigResponse:
        """
        @summary Deletes configurations of of an automatic vulnerability fixing task at a time on the Playbook page.
        
        @param request: DeleteVulAutoRepairConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVulAutoRepairConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alias_name):
            query['AliasName'] = request.alias_name
        if not UtilClient.is_unset(request.config_id_list):
            query['ConfigIdList'] = request.config_id_list
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVulAutoRepairConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteVulAutoRepairConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vul_auto_repair_config_with_options_async(
        self,
        request: sas_20181203_models.DeleteVulAutoRepairConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteVulAutoRepairConfigResponse:
        """
        @summary Deletes configurations of of an automatic vulnerability fixing task at a time on the Playbook page.
        
        @param request: DeleteVulAutoRepairConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVulAutoRepairConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alias_name):
            query['AliasName'] = request.alias_name
        if not UtilClient.is_unset(request.config_id_list):
            query['ConfigIdList'] = request.config_id_list
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVulAutoRepairConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteVulAutoRepairConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vul_auto_repair_config(
        self,
        request: sas_20181203_models.DeleteVulAutoRepairConfigRequest,
    ) -> sas_20181203_models.DeleteVulAutoRepairConfigResponse:
        """
        @summary Deletes configurations of of an automatic vulnerability fixing task at a time on the Playbook page.
        
        @param request: DeleteVulAutoRepairConfigRequest
        @return: DeleteVulAutoRepairConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_vul_auto_repair_config_with_options(request, runtime)

    async def delete_vul_auto_repair_config_async(
        self,
        request: sas_20181203_models.DeleteVulAutoRepairConfigRequest,
    ) -> sas_20181203_models.DeleteVulAutoRepairConfigResponse:
        """
        @summary Deletes configurations of of an automatic vulnerability fixing task at a time on the Playbook page.
        
        @param request: DeleteVulAutoRepairConfigRequest
        @return: DeleteVulAutoRepairConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_vul_auto_repair_config_with_options_async(request, runtime)

    def delete_vul_whitelist_with_options(
        self,
        request: sas_20181203_models.DeleteVulWhitelistRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteVulWhitelistResponse:
        """
        @summary Deletes a specified vulnerability whitelist.
        
        @param request: DeleteVulWhitelistRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVulWhitelistResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.whitelist):
            query['Whitelist'] = request.whitelist
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVulWhitelist',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteVulWhitelistResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vul_whitelist_with_options_async(
        self,
        request: sas_20181203_models.DeleteVulWhitelistRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteVulWhitelistResponse:
        """
        @summary Deletes a specified vulnerability whitelist.
        
        @param request: DeleteVulWhitelistRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVulWhitelistResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.whitelist):
            query['Whitelist'] = request.whitelist
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVulWhitelist',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteVulWhitelistResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vul_whitelist(
        self,
        request: sas_20181203_models.DeleteVulWhitelistRequest,
    ) -> sas_20181203_models.DeleteVulWhitelistResponse:
        """
        @summary Deletes a specified vulnerability whitelist.
        
        @param request: DeleteVulWhitelistRequest
        @return: DeleteVulWhitelistResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_vul_whitelist_with_options(request, runtime)

    async def delete_vul_whitelist_async(
        self,
        request: sas_20181203_models.DeleteVulWhitelistRequest,
    ) -> sas_20181203_models.DeleteVulWhitelistResponse:
        """
        @summary Deletes a specified vulnerability whitelist.
        
        @param request: DeleteVulWhitelistRequest
        @return: DeleteVulWhitelistResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_vul_whitelist_with_options_async(request, runtime)

    def describe_aiasset_summary_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAIAssetSummaryResponse:
        """
        @summary Queries the overview of user AI assets.
        
        @param request: DescribeAIAssetSummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAIAssetSummaryResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAIAssetSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAIAssetSummaryResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_aiasset_summary_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAIAssetSummaryResponse:
        """
        @summary Queries the overview of user AI assets.
        
        @param request: DescribeAIAssetSummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAIAssetSummaryResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAIAssetSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAIAssetSummaryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_aiasset_summary(self) -> sas_20181203_models.DescribeAIAssetSummaryResponse:
        """
        @summary Queries the overview of user AI assets.
        
        @return: DescribeAIAssetSummaryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_aiasset_summary_with_options(runtime)

    async def describe_aiasset_summary_async(self) -> sas_20181203_models.DescribeAIAssetSummaryResponse:
        """
        @summary Queries the overview of user AI assets.
        
        @return: DescribeAIAssetSummaryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_aiasset_summary_with_options_async(runtime)

    def describe_access_key_leak_detail_with_options(
        self,
        request: sas_20181203_models.DescribeAccessKeyLeakDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAccessKeyLeakDetailResponse:
        """
        @summary Queries the details of AccessKey pair leaks.
        
        @param request: DescribeAccessKeyLeakDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccessKeyLeakDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccessKeyLeakDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAccessKeyLeakDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_access_key_leak_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribeAccessKeyLeakDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAccessKeyLeakDetailResponse:
        """
        @summary Queries the details of AccessKey pair leaks.
        
        @param request: DescribeAccessKeyLeakDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccessKeyLeakDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccessKeyLeakDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAccessKeyLeakDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_access_key_leak_detail(
        self,
        request: sas_20181203_models.DescribeAccessKeyLeakDetailRequest,
    ) -> sas_20181203_models.DescribeAccessKeyLeakDetailResponse:
        """
        @summary Queries the details of AccessKey pair leaks.
        
        @param request: DescribeAccessKeyLeakDetailRequest
        @return: DescribeAccessKeyLeakDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_access_key_leak_detail_with_options(request, runtime)

    async def describe_access_key_leak_detail_async(
        self,
        request: sas_20181203_models.DescribeAccessKeyLeakDetailRequest,
    ) -> sas_20181203_models.DescribeAccessKeyLeakDetailResponse:
        """
        @summary Queries the details of AccessKey pair leaks.
        
        @param request: DescribeAccessKeyLeakDetailRequest
        @return: DescribeAccessKeyLeakDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_access_key_leak_detail_with_options_async(request, runtime)

    def describe_accesskey_leak_list_with_options(
        self,
        request: sas_20181203_models.DescribeAccesskeyLeakListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAccesskeyLeakListResponse:
        """
        @summary Queries the AccessKey pair leaks that are detected on your assets.
        
        @param request: DescribeAccesskeyLeakListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccesskeyLeakListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.query):
            query['Query'] = request.query
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        if not UtilClient.is_unset(request.start_ts):
            query['StartTs'] = request.start_ts
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccesskeyLeakList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAccesskeyLeakListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_accesskey_leak_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeAccesskeyLeakListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAccesskeyLeakListResponse:
        """
        @summary Queries the AccessKey pair leaks that are detected on your assets.
        
        @param request: DescribeAccesskeyLeakListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccesskeyLeakListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.query):
            query['Query'] = request.query
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        if not UtilClient.is_unset(request.start_ts):
            query['StartTs'] = request.start_ts
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccesskeyLeakList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAccesskeyLeakListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_accesskey_leak_list(
        self,
        request: sas_20181203_models.DescribeAccesskeyLeakListRequest,
    ) -> sas_20181203_models.DescribeAccesskeyLeakListResponse:
        """
        @summary Queries the AccessKey pair leaks that are detected on your assets.
        
        @param request: DescribeAccesskeyLeakListRequest
        @return: DescribeAccesskeyLeakListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_accesskey_leak_list_with_options(request, runtime)

    async def describe_accesskey_leak_list_async(
        self,
        request: sas_20181203_models.DescribeAccesskeyLeakListRequest,
    ) -> sas_20181203_models.DescribeAccesskeyLeakListResponse:
        """
        @summary Queries the AccessKey pair leaks that are detected on your assets.
        
        @param request: DescribeAccesskeyLeakListRequest
        @return: DescribeAccesskeyLeakListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_accesskey_leak_list_with_options_async(request, runtime)

    def describe_affected_assets_with_options(
        self,
        request: sas_20181203_models.DescribeAffectedAssetsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAffectedAssetsResponse:
        """
        @summary Queries the affected servers in the result of a virus scan task.
        
        @param request: DescribeAffectedAssetsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAffectedAssetsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current):
            query['Current'] = request.current
        if not UtilClient.is_unset(request.levels):
            query['Levels'] = request.levels
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAffectedAssets',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAffectedAssetsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_affected_assets_with_options_async(
        self,
        request: sas_20181203_models.DescribeAffectedAssetsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAffectedAssetsResponse:
        """
        @summary Queries the affected servers in the result of a virus scan task.
        
        @param request: DescribeAffectedAssetsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAffectedAssetsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current):
            query['Current'] = request.current
        if not UtilClient.is_unset(request.levels):
            query['Levels'] = request.levels
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAffectedAssets',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAffectedAssetsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_affected_assets(
        self,
        request: sas_20181203_models.DescribeAffectedAssetsRequest,
    ) -> sas_20181203_models.DescribeAffectedAssetsResponse:
        """
        @summary Queries the affected servers in the result of a virus scan task.
        
        @param request: DescribeAffectedAssetsRequest
        @return: DescribeAffectedAssetsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_affected_assets_with_options(request, runtime)

    async def describe_affected_assets_async(
        self,
        request: sas_20181203_models.DescribeAffectedAssetsRequest,
    ) -> sas_20181203_models.DescribeAffectedAssetsResponse:
        """
        @summary Queries the affected servers in the result of a virus scan task.
        
        @param request: DescribeAffectedAssetsRequest
        @return: DescribeAffectedAssetsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_affected_assets_with_options_async(request, runtime)

    def describe_affected_malicious_file_images_with_options(
        self,
        request: sas_20181203_models.DescribeAffectedMaliciousFileImagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAffectedMaliciousFileImagesResponse:
        """
        @summary Queries the details of malicious image samples.
        
        @param request: DescribeAffectedMaliciousFileImagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAffectedMaliciousFileImagesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.container_id):
            query['ContainerId'] = request.container_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.image):
            query['Image'] = request.image
        if not UtilClient.is_unset(request.image_digest):
            query['ImageDigest'] = request.image_digest
        if not UtilClient.is_unset(request.image_layer):
            query['ImageLayer'] = request.image_layer
        if not UtilClient.is_unset(request.image_tag):
            query['ImageTag'] = request.image_tag
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.levels):
            query['Levels'] = request.levels
        if not UtilClient.is_unset(request.malicious_md_5):
            query['MaliciousMd5'] = request.malicious_md_5
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.pod):
            query['Pod'] = request.pod
        if not UtilClient.is_unset(request.repo_id):
            query['RepoId'] = request.repo_id
        if not UtilClient.is_unset(request.repo_instance_id):
            query['RepoInstanceId'] = request.repo_instance_id
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_namespace):
            query['RepoNamespace'] = request.repo_namespace
        if not UtilClient.is_unset(request.repo_region_id):
            query['RepoRegionId'] = request.repo_region_id
        if not UtilClient.is_unset(request.scan_range):
            query['ScanRange'] = request.scan_range
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAffectedMaliciousFileImages',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAffectedMaliciousFileImagesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_affected_malicious_file_images_with_options_async(
        self,
        request: sas_20181203_models.DescribeAffectedMaliciousFileImagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAffectedMaliciousFileImagesResponse:
        """
        @summary Queries the details of malicious image samples.
        
        @param request: DescribeAffectedMaliciousFileImagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAffectedMaliciousFileImagesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.container_id):
            query['ContainerId'] = request.container_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.image):
            query['Image'] = request.image
        if not UtilClient.is_unset(request.image_digest):
            query['ImageDigest'] = request.image_digest
        if not UtilClient.is_unset(request.image_layer):
            query['ImageLayer'] = request.image_layer
        if not UtilClient.is_unset(request.image_tag):
            query['ImageTag'] = request.image_tag
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.levels):
            query['Levels'] = request.levels
        if not UtilClient.is_unset(request.malicious_md_5):
            query['MaliciousMd5'] = request.malicious_md_5
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.pod):
            query['Pod'] = request.pod
        if not UtilClient.is_unset(request.repo_id):
            query['RepoId'] = request.repo_id
        if not UtilClient.is_unset(request.repo_instance_id):
            query['RepoInstanceId'] = request.repo_instance_id
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_namespace):
            query['RepoNamespace'] = request.repo_namespace
        if not UtilClient.is_unset(request.repo_region_id):
            query['RepoRegionId'] = request.repo_region_id
        if not UtilClient.is_unset(request.scan_range):
            query['ScanRange'] = request.scan_range
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAffectedMaliciousFileImages',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAffectedMaliciousFileImagesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_affected_malicious_file_images(
        self,
        request: sas_20181203_models.DescribeAffectedMaliciousFileImagesRequest,
    ) -> sas_20181203_models.DescribeAffectedMaliciousFileImagesResponse:
        """
        @summary Queries the details of malicious image samples.
        
        @param request: DescribeAffectedMaliciousFileImagesRequest
        @return: DescribeAffectedMaliciousFileImagesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_affected_malicious_file_images_with_options(request, runtime)

    async def describe_affected_malicious_file_images_async(
        self,
        request: sas_20181203_models.DescribeAffectedMaliciousFileImagesRequest,
    ) -> sas_20181203_models.DescribeAffectedMaliciousFileImagesResponse:
        """
        @summary Queries the details of malicious image samples.
        
        @param request: DescribeAffectedMaliciousFileImagesRequest
        @return: DescribeAffectedMaliciousFileImagesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_affected_malicious_file_images_with_options_async(request, runtime)

    def describe_agent_install_status_with_options(
        self,
        request: sas_20181203_models.DescribeAgentInstallStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAgentInstallStatusResponse:
        """
        @summary Queries the installation status of the Security Center agent after you run an installation command by using Cloud Assistant. You can call this operation to query the installation status only if the installation request is initiated within 2 minutes.
        
        @param request: DescribeAgentInstallStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAgentInstallStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAgentInstallStatus',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAgentInstallStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_agent_install_status_with_options_async(
        self,
        request: sas_20181203_models.DescribeAgentInstallStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAgentInstallStatusResponse:
        """
        @summary Queries the installation status of the Security Center agent after you run an installation command by using Cloud Assistant. You can call this operation to query the installation status only if the installation request is initiated within 2 minutes.
        
        @param request: DescribeAgentInstallStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAgentInstallStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAgentInstallStatus',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAgentInstallStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_agent_install_status(
        self,
        request: sas_20181203_models.DescribeAgentInstallStatusRequest,
    ) -> sas_20181203_models.DescribeAgentInstallStatusResponse:
        """
        @summary Queries the installation status of the Security Center agent after you run an installation command by using Cloud Assistant. You can call this operation to query the installation status only if the installation request is initiated within 2 minutes.
        
        @param request: DescribeAgentInstallStatusRequest
        @return: DescribeAgentInstallStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_agent_install_status_with_options(request, runtime)

    async def describe_agent_install_status_async(
        self,
        request: sas_20181203_models.DescribeAgentInstallStatusRequest,
    ) -> sas_20181203_models.DescribeAgentInstallStatusResponse:
        """
        @summary Queries the installation status of the Security Center agent after you run an installation command by using Cloud Assistant. You can call this operation to query the installation status only if the installation request is initiated within 2 minutes.
        
        @param request: DescribeAgentInstallStatusRequest
        @return: DescribeAgentInstallStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_agent_install_status_with_options_async(request, runtime)

    def describe_agentless_sensitive_file_by_key_with_options(
        self,
        tmp_req: sas_20181203_models.DescribeAgentlessSensitiveFileByKeyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAgentlessSensitiveFileByKeyResponse:
        """
        @summary Queries the list of assets on which a specific type of sensitive files are detected by using the agentless detection feature.
        
        @description You can call this operation only when the agentless detection feature is purchased by using the pay-as-you-go billing method within your Alibaba Cloud account.
        
        @param tmp_req: DescribeAgentlessSensitiveFileByKeyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAgentlessSensitiveFileByKeyResponse
        """
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.DescribeAgentlessSensitiveFileByKeyShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.scan_range):
            request.scan_range_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.scan_range, 'ScanRange', 'json')
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAgentlessSensitiveFileByKey',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAgentlessSensitiveFileByKeyResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_agentless_sensitive_file_by_key_with_options_async(
        self,
        tmp_req: sas_20181203_models.DescribeAgentlessSensitiveFileByKeyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAgentlessSensitiveFileByKeyResponse:
        """
        @summary Queries the list of assets on which a specific type of sensitive files are detected by using the agentless detection feature.
        
        @description You can call this operation only when the agentless detection feature is purchased by using the pay-as-you-go billing method within your Alibaba Cloud account.
        
        @param tmp_req: DescribeAgentlessSensitiveFileByKeyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAgentlessSensitiveFileByKeyResponse
        """
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.DescribeAgentlessSensitiveFileByKeyShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.scan_range):
            request.scan_range_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.scan_range, 'ScanRange', 'json')
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAgentlessSensitiveFileByKey',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAgentlessSensitiveFileByKeyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_agentless_sensitive_file_by_key(
        self,
        request: sas_20181203_models.DescribeAgentlessSensitiveFileByKeyRequest,
    ) -> sas_20181203_models.DescribeAgentlessSensitiveFileByKeyResponse:
        """
        @summary Queries the list of assets on which a specific type of sensitive files are detected by using the agentless detection feature.
        
        @description You can call this operation only when the agentless detection feature is purchased by using the pay-as-you-go billing method within your Alibaba Cloud account.
        
        @param request: DescribeAgentlessSensitiveFileByKeyRequest
        @return: DescribeAgentlessSensitiveFileByKeyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_agentless_sensitive_file_by_key_with_options(request, runtime)

    async def describe_agentless_sensitive_file_by_key_async(
        self,
        request: sas_20181203_models.DescribeAgentlessSensitiveFileByKeyRequest,
    ) -> sas_20181203_models.DescribeAgentlessSensitiveFileByKeyResponse:
        """
        @summary Queries the list of assets on which a specific type of sensitive files are detected by using the agentless detection feature.
        
        @description You can call this operation only when the agentless detection feature is purchased by using the pay-as-you-go billing method within your Alibaba Cloud account.
        
        @param request: DescribeAgentlessSensitiveFileByKeyRequest
        @return: DescribeAgentlessSensitiveFileByKeyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_agentless_sensitive_file_by_key_with_options_async(request, runtime)

    def describe_alarm_event_detail_with_options(
        self,
        request: sas_20181203_models.DescribeAlarmEventDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAlarmEventDetailResponse:
        """
        @summary Queries the details of an alert event. An alert event consists of alerts and exceptions. Each alert event is associated with multiple exceptions.
        
        @param request: DescribeAlarmEventDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAlarmEventDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alarm_unique_info):
            query['AlarmUniqueInfo'] = request.alarm_unique_info
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAlarmEventDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAlarmEventDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_alarm_event_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribeAlarmEventDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAlarmEventDetailResponse:
        """
        @summary Queries the details of an alert event. An alert event consists of alerts and exceptions. Each alert event is associated with multiple exceptions.
        
        @param request: DescribeAlarmEventDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAlarmEventDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alarm_unique_info):
            query['AlarmUniqueInfo'] = request.alarm_unique_info
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAlarmEventDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAlarmEventDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_alarm_event_detail(
        self,
        request: sas_20181203_models.DescribeAlarmEventDetailRequest,
    ) -> sas_20181203_models.DescribeAlarmEventDetailResponse:
        """
        @summary Queries the details of an alert event. An alert event consists of alerts and exceptions. Each alert event is associated with multiple exceptions.
        
        @param request: DescribeAlarmEventDetailRequest
        @return: DescribeAlarmEventDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_alarm_event_detail_with_options(request, runtime)

    async def describe_alarm_event_detail_async(
        self,
        request: sas_20181203_models.DescribeAlarmEventDetailRequest,
    ) -> sas_20181203_models.DescribeAlarmEventDetailResponse:
        """
        @summary Queries the details of an alert event. An alert event consists of alerts and exceptions. Each alert event is associated with multiple exceptions.
        
        @param request: DescribeAlarmEventDetailRequest
        @return: DescribeAlarmEventDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_alarm_event_detail_with_options_async(request, runtime)

    def describe_alarm_event_stack_info_with_options(
        self,
        request: sas_20181203_models.DescribeAlarmEventStackInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAlarmEventStackInfoResponse:
        """
        @deprecated OpenAPI DescribeAlarmEventStackInfo is deprecated
        
        @summary Queries the stack information about an alert event.
        
        @param request: DescribeAlarmEventStackInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAlarmEventStackInfoResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_name):
            query['EventName'] = request.event_name
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.unique_info):
            query['UniqueInfo'] = request.unique_info
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAlarmEventStackInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAlarmEventStackInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_alarm_event_stack_info_with_options_async(
        self,
        request: sas_20181203_models.DescribeAlarmEventStackInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAlarmEventStackInfoResponse:
        """
        @deprecated OpenAPI DescribeAlarmEventStackInfo is deprecated
        
        @summary Queries the stack information about an alert event.
        
        @param request: DescribeAlarmEventStackInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAlarmEventStackInfoResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_name):
            query['EventName'] = request.event_name
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.unique_info):
            query['UniqueInfo'] = request.unique_info
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAlarmEventStackInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAlarmEventStackInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_alarm_event_stack_info(
        self,
        request: sas_20181203_models.DescribeAlarmEventStackInfoRequest,
    ) -> sas_20181203_models.DescribeAlarmEventStackInfoResponse:
        """
        @deprecated OpenAPI DescribeAlarmEventStackInfo is deprecated
        
        @summary Queries the stack information about an alert event.
        
        @param request: DescribeAlarmEventStackInfoRequest
        @return: DescribeAlarmEventStackInfoResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_alarm_event_stack_info_with_options(request, runtime)

    async def describe_alarm_event_stack_info_async(
        self,
        request: sas_20181203_models.DescribeAlarmEventStackInfoRequest,
    ) -> sas_20181203_models.DescribeAlarmEventStackInfoResponse:
        """
        @deprecated OpenAPI DescribeAlarmEventStackInfo is deprecated
        
        @summary Queries the stack information about an alert event.
        
        @param request: DescribeAlarmEventStackInfoRequest
        @return: DescribeAlarmEventStackInfoResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_alarm_event_stack_info_with_options_async(request, runtime)

    def describe_all_entity_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAllEntityResponse:
        """
        @summary Queries the information about all server assets, including the asset group IDs and asset names.
        
        @param request: DescribeAllEntityRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAllEntityResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAllEntity',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAllEntityResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_all_entity_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAllEntityResponse:
        """
        @summary Queries the information about all server assets, including the asset group IDs and asset names.
        
        @param request: DescribeAllEntityRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAllEntityResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAllEntity',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAllEntityResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_all_entity(self) -> sas_20181203_models.DescribeAllEntityResponse:
        """
        @summary Queries the information about all server assets, including the asset group IDs and asset names.
        
        @return: DescribeAllEntityResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_all_entity_with_options(runtime)

    async def describe_all_entity_async(self) -> sas_20181203_models.DescribeAllEntityResponse:
        """
        @summary Queries the information about all server assets, including the asset group IDs and asset names.
        
        @return: DescribeAllEntityResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_all_entity_with_options_async(runtime)

    def describe_all_groups_with_options(
        self,
        request: sas_20181203_models.DescribeAllGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAllGroupsResponse:
        """
        @summary Queries the information about all server groups.
        
        @param request: DescribeAllGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAllGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAllGroups',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAllGroupsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_all_groups_with_options_async(
        self,
        request: sas_20181203_models.DescribeAllGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAllGroupsResponse:
        """
        @summary Queries the information about all server groups.
        
        @param request: DescribeAllGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAllGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAllGroups',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAllGroupsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_all_groups(
        self,
        request: sas_20181203_models.DescribeAllGroupsRequest,
    ) -> sas_20181203_models.DescribeAllGroupsResponse:
        """
        @summary Queries the information about all server groups.
        
        @param request: DescribeAllGroupsRequest
        @return: DescribeAllGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_all_groups_with_options(request, runtime)

    async def describe_all_groups_async(
        self,
        request: sas_20181203_models.DescribeAllGroupsRequest,
    ) -> sas_20181203_models.DescribeAllGroupsResponse:
        """
        @summary Queries the information about all server groups.
        
        @param request: DescribeAllGroupsRequest
        @return: DescribeAllGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_all_groups_with_options_async(request, runtime)

    def describe_all_image_baseline_with_options(
        self,
        request: sas_20181203_models.DescribeAllImageBaselineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAllImageBaselineResponse:
        """
        @summary Queries baselines that are used in image baseline checks.
        
        @param request: DescribeAllImageBaselineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAllImageBaselineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAllImageBaseline',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAllImageBaselineResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_all_image_baseline_with_options_async(
        self,
        request: sas_20181203_models.DescribeAllImageBaselineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAllImageBaselineResponse:
        """
        @summary Queries baselines that are used in image baseline checks.
        
        @param request: DescribeAllImageBaselineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAllImageBaselineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAllImageBaseline',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAllImageBaselineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_all_image_baseline(
        self,
        request: sas_20181203_models.DescribeAllImageBaselineRequest,
    ) -> sas_20181203_models.DescribeAllImageBaselineResponse:
        """
        @summary Queries baselines that are used in image baseline checks.
        
        @param request: DescribeAllImageBaselineRequest
        @return: DescribeAllImageBaselineResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_all_image_baseline_with_options(request, runtime)

    async def describe_all_image_baseline_async(
        self,
        request: sas_20181203_models.DescribeAllImageBaselineRequest,
    ) -> sas_20181203_models.DescribeAllImageBaselineResponse:
        """
        @summary Queries baselines that are used in image baseline checks.
        
        @param request: DescribeAllImageBaselineRequest
        @return: DescribeAllImageBaselineResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_all_image_baseline_with_options_async(request, runtime)

    def describe_all_regions_statistics_with_options(
        self,
        request: sas_20181203_models.DescribeAllRegionsStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAllRegionsStatisticsResponse:
        """
        @summary Queries the statistics on global security events, including the numbers of unfixed vulnerabilities, baseline risks, and alerts.
        
        @param request: DescribeAllRegionsStatisticsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAllRegionsStatisticsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAllRegionsStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAllRegionsStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_all_regions_statistics_with_options_async(
        self,
        request: sas_20181203_models.DescribeAllRegionsStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAllRegionsStatisticsResponse:
        """
        @summary Queries the statistics on global security events, including the numbers of unfixed vulnerabilities, baseline risks, and alerts.
        
        @param request: DescribeAllRegionsStatisticsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAllRegionsStatisticsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAllRegionsStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAllRegionsStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_all_regions_statistics(
        self,
        request: sas_20181203_models.DescribeAllRegionsStatisticsRequest,
    ) -> sas_20181203_models.DescribeAllRegionsStatisticsResponse:
        """
        @summary Queries the statistics on global security events, including the numbers of unfixed vulnerabilities, baseline risks, and alerts.
        
        @param request: DescribeAllRegionsStatisticsRequest
        @return: DescribeAllRegionsStatisticsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_all_regions_statistics_with_options(request, runtime)

    async def describe_all_regions_statistics_async(
        self,
        request: sas_20181203_models.DescribeAllRegionsStatisticsRequest,
    ) -> sas_20181203_models.DescribeAllRegionsStatisticsResponse:
        """
        @summary Queries the statistics on global security events, including the numbers of unfixed vulnerabilities, baseline risks, and alerts.
        
        @param request: DescribeAllRegionsStatisticsRequest
        @return: DescribeAllRegionsStatisticsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_all_regions_statistics_with_options_async(request, runtime)

    def describe_anti_brute_force_rules_with_options(
        self,
        request: sas_20181203_models.DescribeAntiBruteForceRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAntiBruteForceRulesResponse:
        """
        @summary Queries created defense rules against brute-force attacks.
        
        @param request: DescribeAntiBruteForceRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAntiBruteForceRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAntiBruteForceRules',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAntiBruteForceRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_anti_brute_force_rules_with_options_async(
        self,
        request: sas_20181203_models.DescribeAntiBruteForceRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAntiBruteForceRulesResponse:
        """
        @summary Queries created defense rules against brute-force attacks.
        
        @param request: DescribeAntiBruteForceRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAntiBruteForceRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAntiBruteForceRules',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAntiBruteForceRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_anti_brute_force_rules(
        self,
        request: sas_20181203_models.DescribeAntiBruteForceRulesRequest,
    ) -> sas_20181203_models.DescribeAntiBruteForceRulesResponse:
        """
        @summary Queries created defense rules against brute-force attacks.
        
        @param request: DescribeAntiBruteForceRulesRequest
        @return: DescribeAntiBruteForceRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_anti_brute_force_rules_with_options(request, runtime)

    async def describe_anti_brute_force_rules_async(
        self,
        request: sas_20181203_models.DescribeAntiBruteForceRulesRequest,
    ) -> sas_20181203_models.DescribeAntiBruteForceRulesResponse:
        """
        @summary Queries created defense rules against brute-force attacks.
        
        @param request: DescribeAntiBruteForceRulesRequest
        @return: DescribeAntiBruteForceRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_anti_brute_force_rules_with_options_async(request, runtime)

    def describe_app_vul_scan_cycle_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAppVulScanCycleResponse:
        """
        @summary Queries the scan cycle for application vulnerabilities.
        
        @param request: DescribeAppVulScanCycleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAppVulScanCycleResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAppVulScanCycle',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAppVulScanCycleResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_app_vul_scan_cycle_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAppVulScanCycleResponse:
        """
        @summary Queries the scan cycle for application vulnerabilities.
        
        @param request: DescribeAppVulScanCycleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAppVulScanCycleResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAppVulScanCycle',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAppVulScanCycleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_app_vul_scan_cycle(self) -> sas_20181203_models.DescribeAppVulScanCycleResponse:
        """
        @summary Queries the scan cycle for application vulnerabilities.
        
        @return: DescribeAppVulScanCycleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_app_vul_scan_cycle_with_options(runtime)

    async def describe_app_vul_scan_cycle_async(self) -> sas_20181203_models.DescribeAppVulScanCycleResponse:
        """
        @summary Queries the scan cycle for application vulnerabilities.
        
        @return: DescribeAppVulScanCycleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_app_vul_scan_cycle_with_options_async(runtime)

    def describe_asset_detail_by_uuid_with_options(
        self,
        request: sas_20181203_models.DescribeAssetDetailByUuidRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAssetDetailByUuidResponse:
        """
        @deprecated OpenAPI DescribeAssetDetailByUuid is deprecated, please use Sas::2018-12-03::GetAssetDetailByUuid instead.
        
        @summary Queries the details of a server and the extended information about the server by using the UUID of the server.
        
        @description This operation will be discontinued soon. You must call the [GetAssetDetailByUuid](~~GetAssetDetailByUuid~~) operation to query the details of the server.
        
        @param request: DescribeAssetDetailByUuidRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAssetDetailByUuidResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAssetDetailByUuid',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAssetDetailByUuidResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_asset_detail_by_uuid_with_options_async(
        self,
        request: sas_20181203_models.DescribeAssetDetailByUuidRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAssetDetailByUuidResponse:
        """
        @deprecated OpenAPI DescribeAssetDetailByUuid is deprecated, please use Sas::2018-12-03::GetAssetDetailByUuid instead.
        
        @summary Queries the details of a server and the extended information about the server by using the UUID of the server.
        
        @description This operation will be discontinued soon. You must call the [GetAssetDetailByUuid](~~GetAssetDetailByUuid~~) operation to query the details of the server.
        
        @param request: DescribeAssetDetailByUuidRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAssetDetailByUuidResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAssetDetailByUuid',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAssetDetailByUuidResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_asset_detail_by_uuid(
        self,
        request: sas_20181203_models.DescribeAssetDetailByUuidRequest,
    ) -> sas_20181203_models.DescribeAssetDetailByUuidResponse:
        """
        @deprecated OpenAPI DescribeAssetDetailByUuid is deprecated, please use Sas::2018-12-03::GetAssetDetailByUuid instead.
        
        @summary Queries the details of a server and the extended information about the server by using the UUID of the server.
        
        @description This operation will be discontinued soon. You must call the [GetAssetDetailByUuid](~~GetAssetDetailByUuid~~) operation to query the details of the server.
        
        @param request: DescribeAssetDetailByUuidRequest
        @return: DescribeAssetDetailByUuidResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_asset_detail_by_uuid_with_options(request, runtime)

    async def describe_asset_detail_by_uuid_async(
        self,
        request: sas_20181203_models.DescribeAssetDetailByUuidRequest,
    ) -> sas_20181203_models.DescribeAssetDetailByUuidResponse:
        """
        @deprecated OpenAPI DescribeAssetDetailByUuid is deprecated, please use Sas::2018-12-03::GetAssetDetailByUuid instead.
        
        @summary Queries the details of a server and the extended information about the server by using the UUID of the server.
        
        @description This operation will be discontinued soon. You must call the [GetAssetDetailByUuid](~~GetAssetDetailByUuid~~) operation to query the details of the server.
        
        @param request: DescribeAssetDetailByUuidRequest
        @return: DescribeAssetDetailByUuidResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_asset_detail_by_uuid_with_options_async(request, runtime)

    def describe_asset_detail_by_uuids_with_options(
        self,
        request: sas_20181203_models.DescribeAssetDetailByUuidsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAssetDetailByUuidsResponse:
        """
        @summary Queries the details of Elastic Compute Service (ECS) instances.
        
        @param request: DescribeAssetDetailByUuidsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAssetDetailByUuidsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAssetDetailByUuids',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAssetDetailByUuidsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_asset_detail_by_uuids_with_options_async(
        self,
        request: sas_20181203_models.DescribeAssetDetailByUuidsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAssetDetailByUuidsResponse:
        """
        @summary Queries the details of Elastic Compute Service (ECS) instances.
        
        @param request: DescribeAssetDetailByUuidsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAssetDetailByUuidsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAssetDetailByUuids',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAssetDetailByUuidsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_asset_detail_by_uuids(
        self,
        request: sas_20181203_models.DescribeAssetDetailByUuidsRequest,
    ) -> sas_20181203_models.DescribeAssetDetailByUuidsResponse:
        """
        @summary Queries the details of Elastic Compute Service (ECS) instances.
        
        @param request: DescribeAssetDetailByUuidsRequest
        @return: DescribeAssetDetailByUuidsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_asset_detail_by_uuids_with_options(request, runtime)

    async def describe_asset_detail_by_uuids_async(
        self,
        request: sas_20181203_models.DescribeAssetDetailByUuidsRequest,
    ) -> sas_20181203_models.DescribeAssetDetailByUuidsResponse:
        """
        @summary Queries the details of Elastic Compute Service (ECS) instances.
        
        @param request: DescribeAssetDetailByUuidsRequest
        @return: DescribeAssetDetailByUuidsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_asset_detail_by_uuids_with_options_async(request, runtime)

    def describe_asset_summary_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAssetSummaryResponse:
        """
        @summary The ID of the request, which is used to locate and troubleshoot issues.
        
        @param request: DescribeAssetSummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAssetSummaryResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAssetSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAssetSummaryResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_asset_summary_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAssetSummaryResponse:
        """
        @summary The ID of the request, which is used to locate and troubleshoot issues.
        
        @param request: DescribeAssetSummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAssetSummaryResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAssetSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAssetSummaryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_asset_summary(self) -> sas_20181203_models.DescribeAssetSummaryResponse:
        """
        @summary The ID of the request, which is used to locate and troubleshoot issues.
        
        @return: DescribeAssetSummaryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_asset_summary_with_options(runtime)

    async def describe_asset_summary_async(self) -> sas_20181203_models.DescribeAssetSummaryResponse:
        """
        @summary The ID of the request, which is used to locate and troubleshoot issues.
        
        @return: DescribeAssetSummaryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_asset_summary_with_options_async(runtime)

    def describe_assets_sca_process_num_with_options(
        self,
        request: sas_20181203_models.DescribeAssetsScaProcessNumRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAssetsScaProcessNumResponse:
        """
        @summary Queries the number of Java processes in an asset by using the asset fingerprints feature of Security Center.
        
        @param request: DescribeAssetsScaProcessNumRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAssetsScaProcessNumResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.biz_type):
            query['BizType'] = request.biz_type
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAssetsScaProcessNum',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAssetsScaProcessNumResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_assets_sca_process_num_with_options_async(
        self,
        request: sas_20181203_models.DescribeAssetsScaProcessNumRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAssetsScaProcessNumResponse:
        """
        @summary Queries the number of Java processes in an asset by using the asset fingerprints feature of Security Center.
        
        @param request: DescribeAssetsScaProcessNumRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAssetsScaProcessNumResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.biz_type):
            query['BizType'] = request.biz_type
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAssetsScaProcessNum',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAssetsScaProcessNumResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_assets_sca_process_num(
        self,
        request: sas_20181203_models.DescribeAssetsScaProcessNumRequest,
    ) -> sas_20181203_models.DescribeAssetsScaProcessNumResponse:
        """
        @summary Queries the number of Java processes in an asset by using the asset fingerprints feature of Security Center.
        
        @param request: DescribeAssetsScaProcessNumRequest
        @return: DescribeAssetsScaProcessNumResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_assets_sca_process_num_with_options(request, runtime)

    async def describe_assets_sca_process_num_async(
        self,
        request: sas_20181203_models.DescribeAssetsScaProcessNumRequest,
    ) -> sas_20181203_models.DescribeAssetsScaProcessNumResponse:
        """
        @summary Queries the number of Java processes in an asset by using the asset fingerprints feature of Security Center.
        
        @param request: DescribeAssetsScaProcessNumRequest
        @return: DescribeAssetsScaProcessNumResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_assets_sca_process_num_with_options_async(request, runtime)

    def describe_assets_security_event_summary_with_options(
        self,
        request: sas_20181203_models.DescribeAssetsSecurityEventSummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAssetsSecurityEventSummaryResponse:
        """
        @summary Queries the risk information about containers.
        
        @param request: DescribeAssetsSecurityEventSummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAssetsSecurityEventSummaryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_field_name):
            query['ContainerFieldName'] = request.container_field_name
        if not UtilClient.is_unset(request.container_field_value):
            query['ContainerFieldValue'] = request.container_field_value
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAssetsSecurityEventSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAssetsSecurityEventSummaryResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_assets_security_event_summary_with_options_async(
        self,
        request: sas_20181203_models.DescribeAssetsSecurityEventSummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAssetsSecurityEventSummaryResponse:
        """
        @summary Queries the risk information about containers.
        
        @param request: DescribeAssetsSecurityEventSummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAssetsSecurityEventSummaryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_field_name):
            query['ContainerFieldName'] = request.container_field_name
        if not UtilClient.is_unset(request.container_field_value):
            query['ContainerFieldValue'] = request.container_field_value
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAssetsSecurityEventSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAssetsSecurityEventSummaryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_assets_security_event_summary(
        self,
        request: sas_20181203_models.DescribeAssetsSecurityEventSummaryRequest,
    ) -> sas_20181203_models.DescribeAssetsSecurityEventSummaryResponse:
        """
        @summary Queries the risk information about containers.
        
        @param request: DescribeAssetsSecurityEventSummaryRequest
        @return: DescribeAssetsSecurityEventSummaryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_assets_security_event_summary_with_options(request, runtime)

    async def describe_assets_security_event_summary_async(
        self,
        request: sas_20181203_models.DescribeAssetsSecurityEventSummaryRequest,
    ) -> sas_20181203_models.DescribeAssetsSecurityEventSummaryResponse:
        """
        @summary Queries the risk information about containers.
        
        @param request: DescribeAssetsSecurityEventSummaryRequest
        @return: DescribeAssetsSecurityEventSummaryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_assets_security_event_summary_with_options_async(request, runtime)

    def describe_attack_analysis_data_with_options(
        self,
        request: sas_20181203_models.DescribeAttackAnalysisDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAttackAnalysisDataResponse:
        """
        @summary Queries the statistics of attack analysis.
        
        @param request: DescribeAttackAnalysisDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAttackAnalysisDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.base_64):
            query['Base64'] = request.base_64
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.data):
            query['Data'] = request.data
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAttackAnalysisData',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAttackAnalysisDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_attack_analysis_data_with_options_async(
        self,
        request: sas_20181203_models.DescribeAttackAnalysisDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAttackAnalysisDataResponse:
        """
        @summary Queries the statistics of attack analysis.
        
        @param request: DescribeAttackAnalysisDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAttackAnalysisDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.base_64):
            query['Base64'] = request.base_64
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.data):
            query['Data'] = request.data
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAttackAnalysisData',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAttackAnalysisDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_attack_analysis_data(
        self,
        request: sas_20181203_models.DescribeAttackAnalysisDataRequest,
    ) -> sas_20181203_models.DescribeAttackAnalysisDataResponse:
        """
        @summary Queries the statistics of attack analysis.
        
        @param request: DescribeAttackAnalysisDataRequest
        @return: DescribeAttackAnalysisDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_attack_analysis_data_with_options(request, runtime)

    async def describe_attack_analysis_data_async(
        self,
        request: sas_20181203_models.DescribeAttackAnalysisDataRequest,
    ) -> sas_20181203_models.DescribeAttackAnalysisDataResponse:
        """
        @summary Queries the statistics of attack analysis.
        
        @param request: DescribeAttackAnalysisDataRequest
        @return: DescribeAttackAnalysisDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_attack_analysis_data_with_options_async(request, runtime)

    def describe_attestors_with_options(
        self,
        request: sas_20181203_models.DescribeAttestorsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAttestorsResponse:
        """
        @summary Queries a list of witnesses.
        
        @param request: DescribeAttestorsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAttestorsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAttestors',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAttestorsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_attestors_with_options_async(
        self,
        request: sas_20181203_models.DescribeAttestorsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAttestorsResponse:
        """
        @summary Queries a list of witnesses.
        
        @param request: DescribeAttestorsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAttestorsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAttestors',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAttestorsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_attestors(
        self,
        request: sas_20181203_models.DescribeAttestorsRequest,
    ) -> sas_20181203_models.DescribeAttestorsResponse:
        """
        @summary Queries a list of witnesses.
        
        @param request: DescribeAttestorsRequest
        @return: DescribeAttestorsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_attestors_with_options(request, runtime)

    async def describe_attestors_async(
        self,
        request: sas_20181203_models.DescribeAttestorsRequest,
    ) -> sas_20181203_models.DescribeAttestorsResponse:
        """
        @summary Queries a list of witnesses.
        
        @param request: DescribeAttestorsRequest
        @return: DescribeAttestorsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_attestors_with_options_async(request, runtime)

    def describe_auto_del_config_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAutoDelConfigResponse:
        """
        @summary Queries the number of days during which a detected vulnerability is retained before the vulnerability is automatically deleted.
        
        @param request: DescribeAutoDelConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAutoDelConfigResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAutoDelConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAutoDelConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_auto_del_config_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAutoDelConfigResponse:
        """
        @summary Queries the number of days during which a detected vulnerability is retained before the vulnerability is automatically deleted.
        
        @param request: DescribeAutoDelConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAutoDelConfigResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAutoDelConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAutoDelConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_auto_del_config(self) -> sas_20181203_models.DescribeAutoDelConfigResponse:
        """
        @summary Queries the number of days during which a detected vulnerability is retained before the vulnerability is automatically deleted.
        
        @return: DescribeAutoDelConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_auto_del_config_with_options(runtime)

    async def describe_auto_del_config_async(self) -> sas_20181203_models.DescribeAutoDelConfigResponse:
        """
        @summary Queries the number of days during which a detected vulnerability is retained before the vulnerability is automatically deleted.
        
        @return: DescribeAutoDelConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_auto_del_config_with_options_async(runtime)

    def describe_back_up_export_info_with_options(
        self,
        request: sas_20181203_models.DescribeBackUpExportInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackUpExportInfoResponse:
        """
        @summary Queries the information about a file to which archived alert events are exported.
        
        @param request: DescribeBackUpExportInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackUpExportInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.export_type):
            query['ExportType'] = request.export_type
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackUpExportInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackUpExportInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_back_up_export_info_with_options_async(
        self,
        request: sas_20181203_models.DescribeBackUpExportInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackUpExportInfoResponse:
        """
        @summary Queries the information about a file to which archived alert events are exported.
        
        @param request: DescribeBackUpExportInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackUpExportInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.export_type):
            query['ExportType'] = request.export_type
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackUpExportInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackUpExportInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_back_up_export_info(
        self,
        request: sas_20181203_models.DescribeBackUpExportInfoRequest,
    ) -> sas_20181203_models.DescribeBackUpExportInfoResponse:
        """
        @summary Queries the information about a file to which archived alert events are exported.
        
        @param request: DescribeBackUpExportInfoRequest
        @return: DescribeBackUpExportInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_back_up_export_info_with_options(request, runtime)

    async def describe_back_up_export_info_async(
        self,
        request: sas_20181203_models.DescribeBackUpExportInfoRequest,
    ) -> sas_20181203_models.DescribeBackUpExportInfoResponse:
        """
        @summary Queries the information about a file to which archived alert events are exported.
        
        @param request: DescribeBackUpExportInfoRequest
        @return: DescribeBackUpExportInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_back_up_export_info_with_options_async(request, runtime)

    def describe_backup_clients_with_options(
        self,
        request: sas_20181203_models.DescribeBackupClientsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupClientsResponse:
        """
        @summary Queries the servers on which the anti-ransomware agent is installed in a specified region.
        
        @description You can call the DescribeBackupClients operation to query the servers on which the anti-ransomware agent is installed in a specified region.
        
        @param request: DescribeBackupClientsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupClientsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.support_region_id):
            query['SupportRegionId'] = request.support_region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupClients',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupClientsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_backup_clients_with_options_async(
        self,
        request: sas_20181203_models.DescribeBackupClientsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupClientsResponse:
        """
        @summary Queries the servers on which the anti-ransomware agent is installed in a specified region.
        
        @description You can call the DescribeBackupClients operation to query the servers on which the anti-ransomware agent is installed in a specified region.
        
        @param request: DescribeBackupClientsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupClientsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.support_region_id):
            query['SupportRegionId'] = request.support_region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupClients',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupClientsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_backup_clients(
        self,
        request: sas_20181203_models.DescribeBackupClientsRequest,
    ) -> sas_20181203_models.DescribeBackupClientsResponse:
        """
        @summary Queries the servers on which the anti-ransomware agent is installed in a specified region.
        
        @description You can call the DescribeBackupClients operation to query the servers on which the anti-ransomware agent is installed in a specified region.
        
        @param request: DescribeBackupClientsRequest
        @return: DescribeBackupClientsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_backup_clients_with_options(request, runtime)

    async def describe_backup_clients_async(
        self,
        request: sas_20181203_models.DescribeBackupClientsRequest,
    ) -> sas_20181203_models.DescribeBackupClientsResponse:
        """
        @summary Queries the servers on which the anti-ransomware agent is installed in a specified region.
        
        @description You can call the DescribeBackupClients operation to query the servers on which the anti-ransomware agent is installed in a specified region.
        
        @param request: DescribeBackupClientsRequest
        @return: DescribeBackupClientsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_backup_clients_with_options_async(request, runtime)

    def describe_backup_files_with_options(
        self,
        request: sas_20181203_models.DescribeBackupFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupFilesResponse:
        """
        @summary Queries backup files.
        
        @param request: DescribeBackupFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupFilesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.path):
            query['Path'] = request.path
        if not UtilClient.is_unset(request.snapshot_hash):
            query['SnapshotHash'] = request.snapshot_hash
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupFiles',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupFilesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_backup_files_with_options_async(
        self,
        request: sas_20181203_models.DescribeBackupFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupFilesResponse:
        """
        @summary Queries backup files.
        
        @param request: DescribeBackupFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupFilesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.path):
            query['Path'] = request.path
        if not UtilClient.is_unset(request.snapshot_hash):
            query['SnapshotHash'] = request.snapshot_hash
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupFiles',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupFilesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_backup_files(
        self,
        request: sas_20181203_models.DescribeBackupFilesRequest,
    ) -> sas_20181203_models.DescribeBackupFilesResponse:
        """
        @summary Queries backup files.
        
        @param request: DescribeBackupFilesRequest
        @return: DescribeBackupFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_backup_files_with_options(request, runtime)

    async def describe_backup_files_async(
        self,
        request: sas_20181203_models.DescribeBackupFilesRequest,
    ) -> sas_20181203_models.DescribeBackupFilesResponse:
        """
        @summary Queries backup files.
        
        @param request: DescribeBackupFilesRequest
        @return: DescribeBackupFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_backup_files_with_options_async(request, runtime)

    def describe_backup_machine_status_with_options(
        self,
        request: sas_20181203_models.DescribeBackupMachineStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupMachineStatusResponse:
        """
        @summary Queries the backup status of a sever to which an anti-ransomware policy is applied.
        
        @param request: DescribeBackupMachineStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupMachineStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.policy_version):
            query['PolicyVersion'] = request.policy_version
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupMachineStatus',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupMachineStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_backup_machine_status_with_options_async(
        self,
        request: sas_20181203_models.DescribeBackupMachineStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupMachineStatusResponse:
        """
        @summary Queries the backup status of a sever to which an anti-ransomware policy is applied.
        
        @param request: DescribeBackupMachineStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupMachineStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.policy_version):
            query['PolicyVersion'] = request.policy_version
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupMachineStatus',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupMachineStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_backup_machine_status(
        self,
        request: sas_20181203_models.DescribeBackupMachineStatusRequest,
    ) -> sas_20181203_models.DescribeBackupMachineStatusResponse:
        """
        @summary Queries the backup status of a sever to which an anti-ransomware policy is applied.
        
        @param request: DescribeBackupMachineStatusRequest
        @return: DescribeBackupMachineStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_backup_machine_status_with_options(request, runtime)

    async def describe_backup_machine_status_async(
        self,
        request: sas_20181203_models.DescribeBackupMachineStatusRequest,
    ) -> sas_20181203_models.DescribeBackupMachineStatusResponse:
        """
        @summary Queries the backup status of a sever to which an anti-ransomware policy is applied.
        
        @param request: DescribeBackupMachineStatusRequest
        @return: DescribeBackupMachineStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_backup_machine_status_with_options_async(request, runtime)

    def describe_backup_policies_with_options(
        self,
        request: sas_20181203_models.DescribeBackupPoliciesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupPoliciesResponse:
        """
        @summary Queries anti-ransomware policies.
        
        @param request: DescribeBackupPoliciesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupPoliciesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.machine_remark):
            query['MachineRemark'] = request.machine_remark
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupPolicies',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupPoliciesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_backup_policies_with_options_async(
        self,
        request: sas_20181203_models.DescribeBackupPoliciesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupPoliciesResponse:
        """
        @summary Queries anti-ransomware policies.
        
        @param request: DescribeBackupPoliciesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupPoliciesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.machine_remark):
            query['MachineRemark'] = request.machine_remark
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupPolicies',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupPoliciesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_backup_policies(
        self,
        request: sas_20181203_models.DescribeBackupPoliciesRequest,
    ) -> sas_20181203_models.DescribeBackupPoliciesResponse:
        """
        @summary Queries anti-ransomware policies.
        
        @param request: DescribeBackupPoliciesRequest
        @return: DescribeBackupPoliciesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_backup_policies_with_options(request, runtime)

    async def describe_backup_policies_async(
        self,
        request: sas_20181203_models.DescribeBackupPoliciesRequest,
    ) -> sas_20181203_models.DescribeBackupPoliciesResponse:
        """
        @summary Queries anti-ransomware policies.
        
        @param request: DescribeBackupPoliciesRequest
        @return: DescribeBackupPoliciesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_backup_policies_with_options_async(request, runtime)

    def describe_backup_policy_with_options(
        self,
        request: sas_20181203_models.DescribeBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupPolicyResponse:
        """
        @summary Queries the details of an anti-ransomware policy for servers.
        
        @param request: DescribeBackupPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_backup_policy_with_options_async(
        self,
        request: sas_20181203_models.DescribeBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupPolicyResponse:
        """
        @summary Queries the details of an anti-ransomware policy for servers.
        
        @param request: DescribeBackupPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_backup_policy(
        self,
        request: sas_20181203_models.DescribeBackupPolicyRequest,
    ) -> sas_20181203_models.DescribeBackupPolicyResponse:
        """
        @summary Queries the details of an anti-ransomware policy for servers.
        
        @param request: DescribeBackupPolicyRequest
        @return: DescribeBackupPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_backup_policy_with_options(request, runtime)

    async def describe_backup_policy_async(
        self,
        request: sas_20181203_models.DescribeBackupPolicyRequest,
    ) -> sas_20181203_models.DescribeBackupPolicyResponse:
        """
        @summary Queries the details of an anti-ransomware policy for servers.
        
        @param request: DescribeBackupPolicyRequest
        @return: DescribeBackupPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_backup_policy_with_options_async(request, runtime)

    def describe_backup_restore_count_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupRestoreCountResponse:
        """
        @summary Queries the statistics of restoration tasks.
        
        @description If you have created restoration tasks, you can call this operation to query the number of restoration tasks that are in the *restored** or **being restored** state.
        
        @param request: DescribeBackupRestoreCountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupRestoreCountResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeBackupRestoreCount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupRestoreCountResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_backup_restore_count_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupRestoreCountResponse:
        """
        @summary Queries the statistics of restoration tasks.
        
        @description If you have created restoration tasks, you can call this operation to query the number of restoration tasks that are in the *restored** or **being restored** state.
        
        @param request: DescribeBackupRestoreCountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupRestoreCountResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeBackupRestoreCount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupRestoreCountResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_backup_restore_count(self) -> sas_20181203_models.DescribeBackupRestoreCountResponse:
        """
        @summary Queries the statistics of restoration tasks.
        
        @description If you have created restoration tasks, you can call this operation to query the number of restoration tasks that are in the *restored** or **being restored** state.
        
        @return: DescribeBackupRestoreCountResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_backup_restore_count_with_options(runtime)

    async def describe_backup_restore_count_async(self) -> sas_20181203_models.DescribeBackupRestoreCountResponse:
        """
        @summary Queries the statistics of restoration tasks.
        
        @description If you have created restoration tasks, you can call this operation to query the number of restoration tasks that are in the *restored** or **being restored** state.
        
        @return: DescribeBackupRestoreCountResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_backup_restore_count_with_options_async(runtime)

    def describe_binary_security_policies_with_options(
        self,
        request: sas_20181203_models.DescribeBinarySecurityPoliciesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBinarySecurityPoliciesResponse:
        """
        @summary Queries binary security policies.
        
        @param request: DescribeBinarySecurityPoliciesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBinarySecurityPoliciesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBinarySecurityPolicies',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBinarySecurityPoliciesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_binary_security_policies_with_options_async(
        self,
        request: sas_20181203_models.DescribeBinarySecurityPoliciesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBinarySecurityPoliciesResponse:
        """
        @summary Queries binary security policies.
        
        @param request: DescribeBinarySecurityPoliciesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBinarySecurityPoliciesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBinarySecurityPolicies',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBinarySecurityPoliciesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_binary_security_policies(
        self,
        request: sas_20181203_models.DescribeBinarySecurityPoliciesRequest,
    ) -> sas_20181203_models.DescribeBinarySecurityPoliciesResponse:
        """
        @summary Queries binary security policies.
        
        @param request: DescribeBinarySecurityPoliciesRequest
        @return: DescribeBinarySecurityPoliciesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_binary_security_policies_with_options(request, runtime)

    async def describe_binary_security_policies_async(
        self,
        request: sas_20181203_models.DescribeBinarySecurityPoliciesRequest,
    ) -> sas_20181203_models.DescribeBinarySecurityPoliciesResponse:
        """
        @summary Queries binary security policies.
        
        @param request: DescribeBinarySecurityPoliciesRequest
        @return: DescribeBinarySecurityPoliciesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_binary_security_policies_with_options_async(request, runtime)

    def describe_brute_force_records_with_options(
        self,
        request: sas_20181203_models.DescribeBruteForceRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBruteForceRecordsResponse:
        """
        @summary Queries the IP addresses that are blocked by a defense rule against brute-force attacks.
        
        @param request: DescribeBruteForceRecordsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBruteForceRecordsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.block_ip):
            query['BlockIp'] = request.block_ip
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBruteForceRecords',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBruteForceRecordsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_brute_force_records_with_options_async(
        self,
        request: sas_20181203_models.DescribeBruteForceRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBruteForceRecordsResponse:
        """
        @summary Queries the IP addresses that are blocked by a defense rule against brute-force attacks.
        
        @param request: DescribeBruteForceRecordsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBruteForceRecordsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.block_ip):
            query['BlockIp'] = request.block_ip
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBruteForceRecords',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBruteForceRecordsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_brute_force_records(
        self,
        request: sas_20181203_models.DescribeBruteForceRecordsRequest,
    ) -> sas_20181203_models.DescribeBruteForceRecordsResponse:
        """
        @summary Queries the IP addresses that are blocked by a defense rule against brute-force attacks.
        
        @param request: DescribeBruteForceRecordsRequest
        @return: DescribeBruteForceRecordsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_brute_force_records_with_options(request, runtime)

    async def describe_brute_force_records_async(
        self,
        request: sas_20181203_models.DescribeBruteForceRecordsRequest,
    ) -> sas_20181203_models.DescribeBruteForceRecordsResponse:
        """
        @summary Queries the IP addresses that are blocked by a defense rule against brute-force attacks.
        
        @param request: DescribeBruteForceRecordsRequest
        @return: DescribeBruteForceRecordsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_brute_force_records_with_options_async(request, runtime)

    def describe_brute_force_summary_with_options(
        self,
        request: sas_20181203_models.DescribeBruteForceSummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBruteForceSummaryResponse:
        """
        @summary The source IP address of the request.
        
        @param request: DescribeBruteForceSummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBruteForceSummaryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBruteForceSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBruteForceSummaryResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_brute_force_summary_with_options_async(
        self,
        request: sas_20181203_models.DescribeBruteForceSummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBruteForceSummaryResponse:
        """
        @summary The source IP address of the request.
        
        @param request: DescribeBruteForceSummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBruteForceSummaryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBruteForceSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBruteForceSummaryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_brute_force_summary(
        self,
        request: sas_20181203_models.DescribeBruteForceSummaryRequest,
    ) -> sas_20181203_models.DescribeBruteForceSummaryResponse:
        """
        @summary The source IP address of the request.
        
        @param request: DescribeBruteForceSummaryRequest
        @return: DescribeBruteForceSummaryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_brute_force_summary_with_options(request, runtime)

    async def describe_brute_force_summary_async(
        self,
        request: sas_20181203_models.DescribeBruteForceSummaryRequest,
    ) -> sas_20181203_models.DescribeBruteForceSummaryResponse:
        """
        @summary The source IP address of the request.
        
        @param request: DescribeBruteForceSummaryRequest
        @return: DescribeBruteForceSummaryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_brute_force_summary_with_options_async(request, runtime)

    def describe_can_access_vpc_sale_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCanAccessVpcSaleResponse:
        """
        @summary Check if the asset can be sold by VPC
        
        @param request: DescribeCanAccessVpcSaleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCanAccessVpcSaleResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCanAccessVpcSale',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCanAccessVpcSaleResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_can_access_vpc_sale_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCanAccessVpcSaleResponse:
        """
        @summary Check if the asset can be sold by VPC
        
        @param request: DescribeCanAccessVpcSaleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCanAccessVpcSaleResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCanAccessVpcSale',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCanAccessVpcSaleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_can_access_vpc_sale(self) -> sas_20181203_models.DescribeCanAccessVpcSaleResponse:
        """
        @summary Check if the asset can be sold by VPC
        
        @return: DescribeCanAccessVpcSaleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_can_access_vpc_sale_with_options(runtime)

    async def describe_can_access_vpc_sale_async(self) -> sas_20181203_models.DescribeCanAccessVpcSaleResponse:
        """
        @summary Check if the asset can be sold by VPC
        
        @return: DescribeCanAccessVpcSaleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_can_access_vpc_sale_with_options_async(runtime)

    def describe_can_fix_vul_list_with_options(
        self,
        request: sas_20181203_models.DescribeCanFixVulListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCanFixVulListResponse:
        """
        @summary Queries the list of fixable vulnerabilities.
        
        @param request: DescribeCanFixVulListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCanFixVulListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alias_name):
            query['AliasName'] = request.alias_name
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.container_id):
            query['ContainerId'] = request.container_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.digest):
            query['Digest'] = request.digest
        if not UtilClient.is_unset(request.image):
            query['Image'] = request.image
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.necessity):
            query['Necessity'] = request.necessity
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.pod):
            query['Pod'] = request.pod
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.repo_id):
            query['RepoId'] = request.repo_id
        if not UtilClient.is_unset(request.repo_id):
            query['RepoId'] = request.repo_id
        if not UtilClient.is_unset(request.repo_instance_id):
            query['RepoInstanceId'] = request.repo_instance_id
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_namespace):
            query['RepoNamespace'] = request.repo_namespace
        if not UtilClient.is_unset(request.repo_region_id):
            query['RepoRegionId'] = request.repo_region_id
        if not UtilClient.is_unset(request.scan_range):
            query['ScanRange'] = request.scan_range
        if not UtilClient.is_unset(request.status_list):
            query['StatusList'] = request.status_list
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCanFixVulList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCanFixVulListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_can_fix_vul_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeCanFixVulListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCanFixVulListResponse:
        """
        @summary Queries the list of fixable vulnerabilities.
        
        @param request: DescribeCanFixVulListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCanFixVulListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alias_name):
            query['AliasName'] = request.alias_name
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.container_id):
            query['ContainerId'] = request.container_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.digest):
            query['Digest'] = request.digest
        if not UtilClient.is_unset(request.image):
            query['Image'] = request.image
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.necessity):
            query['Necessity'] = request.necessity
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.pod):
            query['Pod'] = request.pod
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.repo_id):
            query['RepoId'] = request.repo_id
        if not UtilClient.is_unset(request.repo_id):
            query['RepoId'] = request.repo_id
        if not UtilClient.is_unset(request.repo_instance_id):
            query['RepoInstanceId'] = request.repo_instance_id
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_namespace):
            query['RepoNamespace'] = request.repo_namespace
        if not UtilClient.is_unset(request.repo_region_id):
            query['RepoRegionId'] = request.repo_region_id
        if not UtilClient.is_unset(request.scan_range):
            query['ScanRange'] = request.scan_range
        if not UtilClient.is_unset(request.status_list):
            query['StatusList'] = request.status_list
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCanFixVulList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCanFixVulListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_can_fix_vul_list(
        self,
        request: sas_20181203_models.DescribeCanFixVulListRequest,
    ) -> sas_20181203_models.DescribeCanFixVulListResponse:
        """
        @summary Queries the list of fixable vulnerabilities.
        
        @param request: DescribeCanFixVulListRequest
        @return: DescribeCanFixVulListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_can_fix_vul_list_with_options(request, runtime)

    async def describe_can_fix_vul_list_async(
        self,
        request: sas_20181203_models.DescribeCanFixVulListRequest,
    ) -> sas_20181203_models.DescribeCanFixVulListResponse:
        """
        @summary Queries the list of fixable vulnerabilities.
        
        @param request: DescribeCanFixVulListRequest
        @return: DescribeCanFixVulListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_can_fix_vul_list_with_options_async(request, runtime)

    def describe_can_try_sas_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCanTrySasResponse:
        """
        @summary Checks the permissions on the trial use of Security Center.
        
        @param request: DescribeCanTrySasRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCanTrySasResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCanTrySas',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCanTrySasResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_can_try_sas_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCanTrySasResponse:
        """
        @summary Checks the permissions on the trial use of Security Center.
        
        @param request: DescribeCanTrySasRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCanTrySasResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCanTrySas',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCanTrySasResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_can_try_sas(self) -> sas_20181203_models.DescribeCanTrySasResponse:
        """
        @summary Checks the permissions on the trial use of Security Center.
        
        @return: DescribeCanTrySasResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_can_try_sas_with_options(runtime)

    async def describe_can_try_sas_async(self) -> sas_20181203_models.DescribeCanTrySasResponse:
        """
        @summary Checks the permissions on the trial use of Security Center.
        
        @return: DescribeCanTrySasResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_can_try_sas_with_options_async(runtime)

    def describe_chart_data_with_options(
        self,
        request: sas_20181203_models.DescribeChartDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeChartDataResponse:
        """
        @summary Queries the chart data of a security report.
        
        @param request: DescribeChartDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeChartDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.char_id):
            query['CharId'] = request.char_id
        if not UtilClient.is_unset(request.chart_id):
            query['ChartId'] = request.chart_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.report_id):
            query['ReportId'] = request.report_id
        if not UtilClient.is_unset(request.time_end):
            query['TimeEnd'] = request.time_end
        if not UtilClient.is_unset(request.time_start):
            query['TimeStart'] = request.time_start
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeChartData',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeChartDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_chart_data_with_options_async(
        self,
        request: sas_20181203_models.DescribeChartDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeChartDataResponse:
        """
        @summary Queries the chart data of a security report.
        
        @param request: DescribeChartDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeChartDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.char_id):
            query['CharId'] = request.char_id
        if not UtilClient.is_unset(request.chart_id):
            query['ChartId'] = request.chart_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.report_id):
            query['ReportId'] = request.report_id
        if not UtilClient.is_unset(request.time_end):
            query['TimeEnd'] = request.time_end
        if not UtilClient.is_unset(request.time_start):
            query['TimeStart'] = request.time_start
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeChartData',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeChartDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_chart_data(
        self,
        request: sas_20181203_models.DescribeChartDataRequest,
    ) -> sas_20181203_models.DescribeChartDataResponse:
        """
        @summary Queries the chart data of a security report.
        
        @param request: DescribeChartDataRequest
        @return: DescribeChartDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_chart_data_with_options(request, runtime)

    async def describe_chart_data_async(
        self,
        request: sas_20181203_models.DescribeChartDataRequest,
    ) -> sas_20181203_models.DescribeChartDataResponse:
        """
        @summary Queries the chart data of a security report.
        
        @param request: DescribeChartDataRequest
        @return: DescribeChartDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_chart_data_with_options_async(request, runtime)

    def describe_chart_list_with_options(
        self,
        request: sas_20181203_models.DescribeChartListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeChartListResponse:
        """
        @summary Queries the charts that are supported by using the security report feature of Security Center.
        
        @param request: DescribeChartListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeChartListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.project_code):
            query['ProjectCode'] = request.project_code
        if not UtilClient.is_unset(request.report_id):
            query['ReportId'] = request.report_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeChartList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeChartListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_chart_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeChartListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeChartListResponse:
        """
        @summary Queries the charts that are supported by using the security report feature of Security Center.
        
        @param request: DescribeChartListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeChartListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.project_code):
            query['ProjectCode'] = request.project_code
        if not UtilClient.is_unset(request.report_id):
            query['ReportId'] = request.report_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeChartList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeChartListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_chart_list(
        self,
        request: sas_20181203_models.DescribeChartListRequest,
    ) -> sas_20181203_models.DescribeChartListResponse:
        """
        @summary Queries the charts that are supported by using the security report feature of Security Center.
        
        @param request: DescribeChartListRequest
        @return: DescribeChartListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_chart_list_with_options(request, runtime)

    async def describe_chart_list_async(
        self,
        request: sas_20181203_models.DescribeChartListRequest,
    ) -> sas_20181203_models.DescribeChartListResponse:
        """
        @summary Queries the charts that are supported by using the security report feature of Security Center.
        
        @param request: DescribeChartListRequest
        @return: DescribeChartListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_chart_list_with_options_async(request, runtime)

    def describe_check_ecs_warnings_with_options(
        self,
        request: sas_20181203_models.DescribeCheckEcsWarningsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckEcsWarningsResponse:
        """
        @summary Queries the number of weak passwords that can cause high risks to your assets.
        
        @param request: DescribeCheckEcsWarningsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCheckEcsWarningsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckEcsWarnings',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckEcsWarningsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_check_ecs_warnings_with_options_async(
        self,
        request: sas_20181203_models.DescribeCheckEcsWarningsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckEcsWarningsResponse:
        """
        @summary Queries the number of weak passwords that can cause high risks to your assets.
        
        @param request: DescribeCheckEcsWarningsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCheckEcsWarningsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckEcsWarnings',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckEcsWarningsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_check_ecs_warnings(
        self,
        request: sas_20181203_models.DescribeCheckEcsWarningsRequest,
    ) -> sas_20181203_models.DescribeCheckEcsWarningsResponse:
        """
        @summary Queries the number of weak passwords that can cause high risks to your assets.
        
        @param request: DescribeCheckEcsWarningsRequest
        @return: DescribeCheckEcsWarningsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_check_ecs_warnings_with_options(request, runtime)

    async def describe_check_ecs_warnings_async(
        self,
        request: sas_20181203_models.DescribeCheckEcsWarningsRequest,
    ) -> sas_20181203_models.DescribeCheckEcsWarningsResponse:
        """
        @summary Queries the number of weak passwords that can cause high risks to your assets.
        
        @param request: DescribeCheckEcsWarningsRequest
        @return: DescribeCheckEcsWarningsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_check_ecs_warnings_with_options_async(request, runtime)

    def describe_check_fix_details_with_options(
        self,
        request: sas_20181203_models.DescribeCheckFixDetailsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckFixDetailsResponse:
        """
        @summary Queries the parameters that you can configure to fix specified risk items.
        
        @param request: DescribeCheckFixDetailsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCheckFixDetailsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_ids):
            query['CheckIds'] = request.check_ids
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.risk_id):
            query['RiskId'] = request.risk_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckFixDetails',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckFixDetailsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_check_fix_details_with_options_async(
        self,
        request: sas_20181203_models.DescribeCheckFixDetailsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckFixDetailsResponse:
        """
        @summary Queries the parameters that you can configure to fix specified risk items.
        
        @param request: DescribeCheckFixDetailsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCheckFixDetailsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_ids):
            query['CheckIds'] = request.check_ids
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.risk_id):
            query['RiskId'] = request.risk_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckFixDetails',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckFixDetailsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_check_fix_details(
        self,
        request: sas_20181203_models.DescribeCheckFixDetailsRequest,
    ) -> sas_20181203_models.DescribeCheckFixDetailsResponse:
        """
        @summary Queries the parameters that you can configure to fix specified risk items.
        
        @param request: DescribeCheckFixDetailsRequest
        @return: DescribeCheckFixDetailsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_check_fix_details_with_options(request, runtime)

    async def describe_check_fix_details_async(
        self,
        request: sas_20181203_models.DescribeCheckFixDetailsRequest,
    ) -> sas_20181203_models.DescribeCheckFixDetailsResponse:
        """
        @summary Queries the parameters that you can configure to fix specified risk items.
        
        @param request: DescribeCheckFixDetailsRequest
        @return: DescribeCheckFixDetailsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_check_fix_details_with_options_async(request, runtime)

    def describe_check_result_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckResultResponse:
        """
        @summary Queries the result of the ISO 27001 compliance check.
        
        @param request: DescribeCheckResultRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCheckResultResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCheckResult',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckResultResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_check_result_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckResultResponse:
        """
        @summary Queries the result of the ISO 27001 compliance check.
        
        @param request: DescribeCheckResultRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCheckResultResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCheckResult',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckResultResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_check_result(self) -> sas_20181203_models.DescribeCheckResultResponse:
        """
        @summary Queries the result of the ISO 27001 compliance check.
        
        @return: DescribeCheckResultResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_check_result_with_options(runtime)

    async def describe_check_result_async(self) -> sas_20181203_models.DescribeCheckResultResponse:
        """
        @summary Queries the result of the ISO 27001 compliance check.
        
        @return: DescribeCheckResultResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_check_result_with_options_async(runtime)

    def describe_check_warning_count_with_options(
        self,
        request: sas_20181203_models.DescribeCheckWarningCountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckWarningCountResponse:
        """
        @summary Queries the number of alerts that are triggered by a check item.
        
        @param request: DescribeCheckWarningCountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCheckWarningCountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ali_uid):
            query['AliUid'] = request.ali_uid
        if not UtilClient.is_unset(request.check_id):
            query['CheckId'] = request.check_id
        if not UtilClient.is_unset(request.risk_id):
            query['RiskId'] = request.risk_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckWarningCount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckWarningCountResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_check_warning_count_with_options_async(
        self,
        request: sas_20181203_models.DescribeCheckWarningCountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckWarningCountResponse:
        """
        @summary Queries the number of alerts that are triggered by a check item.
        
        @param request: DescribeCheckWarningCountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCheckWarningCountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ali_uid):
            query['AliUid'] = request.ali_uid
        if not UtilClient.is_unset(request.check_id):
            query['CheckId'] = request.check_id
        if not UtilClient.is_unset(request.risk_id):
            query['RiskId'] = request.risk_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckWarningCount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckWarningCountResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_check_warning_count(
        self,
        request: sas_20181203_models.DescribeCheckWarningCountRequest,
    ) -> sas_20181203_models.DescribeCheckWarningCountResponse:
        """
        @summary Queries the number of alerts that are triggered by a check item.
        
        @param request: DescribeCheckWarningCountRequest
        @return: DescribeCheckWarningCountResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_check_warning_count_with_options(request, runtime)

    async def describe_check_warning_count_async(
        self,
        request: sas_20181203_models.DescribeCheckWarningCountRequest,
    ) -> sas_20181203_models.DescribeCheckWarningCountResponse:
        """
        @summary Queries the number of alerts that are triggered by a check item.
        
        @param request: DescribeCheckWarningCountRequest
        @return: DescribeCheckWarningCountResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_check_warning_count_with_options_async(request, runtime)

    def describe_check_warning_detail_with_options(
        self,
        request: sas_20181203_models.DescribeCheckWarningDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckWarningDetailResponse:
        """
        @summary Queries the details about a specified check item.
        
        @param request: DescribeCheckWarningDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCheckWarningDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_id):
            query['CheckId'] = request.check_id
        if not UtilClient.is_unset(request.check_warning_id):
            query['CheckWarningId'] = request.check_warning_id
        if not UtilClient.is_unset(request.container_name):
            query['ContainerName'] = request.container_name
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckWarningDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckWarningDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_check_warning_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribeCheckWarningDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckWarningDetailResponse:
        """
        @summary Queries the details about a specified check item.
        
        @param request: DescribeCheckWarningDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCheckWarningDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_id):
            query['CheckId'] = request.check_id
        if not UtilClient.is_unset(request.check_warning_id):
            query['CheckWarningId'] = request.check_warning_id
        if not UtilClient.is_unset(request.container_name):
            query['ContainerName'] = request.container_name
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckWarningDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckWarningDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_check_warning_detail(
        self,
        request: sas_20181203_models.DescribeCheckWarningDetailRequest,
    ) -> sas_20181203_models.DescribeCheckWarningDetailResponse:
        """
        @summary Queries the details about a specified check item.
        
        @param request: DescribeCheckWarningDetailRequest
        @return: DescribeCheckWarningDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_check_warning_detail_with_options(request, runtime)

    async def describe_check_warning_detail_async(
        self,
        request: sas_20181203_models.DescribeCheckWarningDetailRequest,
    ) -> sas_20181203_models.DescribeCheckWarningDetailResponse:
        """
        @summary Queries the details about a specified check item.
        
        @param request: DescribeCheckWarningDetailRequest
        @return: DescribeCheckWarningDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_check_warning_detail_with_options_async(request, runtime)

    def describe_check_warning_machines_with_options(
        self,
        request: sas_20181203_models.DescribeCheckWarningMachinesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckWarningMachinesResponse:
        """
        @summary Queries the servers on which the same risk item is detected by specifying a baseline and a check item.
        
        @param request: DescribeCheckWarningMachinesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCheckWarningMachinesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_id):
            query['CheckId'] = request.check_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.filter_uuid):
            query['FilterUuid'] = request.filter_uuid
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        if not UtilClient.is_unset(request.risk_id):
            query['RiskId'] = request.risk_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckWarningMachines',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckWarningMachinesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_check_warning_machines_with_options_async(
        self,
        request: sas_20181203_models.DescribeCheckWarningMachinesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckWarningMachinesResponse:
        """
        @summary Queries the servers on which the same risk item is detected by specifying a baseline and a check item.
        
        @param request: DescribeCheckWarningMachinesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCheckWarningMachinesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_id):
            query['CheckId'] = request.check_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.filter_uuid):
            query['FilterUuid'] = request.filter_uuid
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        if not UtilClient.is_unset(request.risk_id):
            query['RiskId'] = request.risk_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckWarningMachines',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckWarningMachinesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_check_warning_machines(
        self,
        request: sas_20181203_models.DescribeCheckWarningMachinesRequest,
    ) -> sas_20181203_models.DescribeCheckWarningMachinesResponse:
        """
        @summary Queries the servers on which the same risk item is detected by specifying a baseline and a check item.
        
        @param request: DescribeCheckWarningMachinesRequest
        @return: DescribeCheckWarningMachinesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_check_warning_machines_with_options(request, runtime)

    async def describe_check_warning_machines_async(
        self,
        request: sas_20181203_models.DescribeCheckWarningMachinesRequest,
    ) -> sas_20181203_models.DescribeCheckWarningMachinesResponse:
        """
        @summary Queries the servers on which the same risk item is detected by specifying a baseline and a check item.
        
        @param request: DescribeCheckWarningMachinesRequest
        @return: DescribeCheckWarningMachinesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_check_warning_machines_with_options_async(request, runtime)

    def describe_check_warning_summary_with_options(
        self,
        request: sas_20181203_models.DescribeCheckWarningSummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckWarningSummaryResponse:
        """
        @summary Queries the statistical information about baseline check results. The information includes the number of servers on which a baseline check is performed, the number of baseline check items, and the pass rate of check items in the last baseline check.
        
        @param request: DescribeCheckWarningSummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCheckWarningSummaryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_field_name):
            query['ContainerFieldName'] = request.container_field_name
        if not UtilClient.is_unset(request.container_field_value):
            query['ContainerFieldValue'] = request.container_field_value
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.risk_name):
            query['RiskName'] = request.risk_name
        if not UtilClient.is_unset(request.risk_status):
            query['RiskStatus'] = request.risk_status
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.strategy_id):
            query['StrategyId'] = request.strategy_id
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.type_name):
            query['TypeName'] = request.type_name
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckWarningSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckWarningSummaryResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_check_warning_summary_with_options_async(
        self,
        request: sas_20181203_models.DescribeCheckWarningSummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckWarningSummaryResponse:
        """
        @summary Queries the statistical information about baseline check results. The information includes the number of servers on which a baseline check is performed, the number of baseline check items, and the pass rate of check items in the last baseline check.
        
        @param request: DescribeCheckWarningSummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCheckWarningSummaryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_field_name):
            query['ContainerFieldName'] = request.container_field_name
        if not UtilClient.is_unset(request.container_field_value):
            query['ContainerFieldValue'] = request.container_field_value
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.risk_name):
            query['RiskName'] = request.risk_name
        if not UtilClient.is_unset(request.risk_status):
            query['RiskStatus'] = request.risk_status
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.strategy_id):
            query['StrategyId'] = request.strategy_id
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.type_name):
            query['TypeName'] = request.type_name
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckWarningSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckWarningSummaryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_check_warning_summary(
        self,
        request: sas_20181203_models.DescribeCheckWarningSummaryRequest,
    ) -> sas_20181203_models.DescribeCheckWarningSummaryResponse:
        """
        @summary Queries the statistical information about baseline check results. The information includes the number of servers on which a baseline check is performed, the number of baseline check items, and the pass rate of check items in the last baseline check.
        
        @param request: DescribeCheckWarningSummaryRequest
        @return: DescribeCheckWarningSummaryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_check_warning_summary_with_options(request, runtime)

    async def describe_check_warning_summary_async(
        self,
        request: sas_20181203_models.DescribeCheckWarningSummaryRequest,
    ) -> sas_20181203_models.DescribeCheckWarningSummaryResponse:
        """
        @summary Queries the statistical information about baseline check results. The information includes the number of servers on which a baseline check is performed, the number of baseline check items, and the pass rate of check items in the last baseline check.
        
        @param request: DescribeCheckWarningSummaryRequest
        @return: DescribeCheckWarningSummaryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_check_warning_summary_with_options_async(request, runtime)

    def describe_check_warnings_with_options(
        self,
        request: sas_20181203_models.DescribeCheckWarningsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckWarningsResponse:
        """
        @summary Queries information about specified risk items and the check items of a specified server.
        
        @param request: DescribeCheckWarningsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCheckWarningsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_id):
            query['CheckId'] = request.check_id
        if not UtilClient.is_unset(request.check_type):
            query['CheckType'] = request.check_type
        if not UtilClient.is_unset(request.container_name):
            query['ContainerName'] = request.container_name
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        if not UtilClient.is_unset(request.risk_id):
            query['RiskId'] = request.risk_id
        if not UtilClient.is_unset(request.risk_status):
            query['RiskStatus'] = request.risk_status
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckWarnings',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckWarningsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_check_warnings_with_options_async(
        self,
        request: sas_20181203_models.DescribeCheckWarningsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckWarningsResponse:
        """
        @summary Queries information about specified risk items and the check items of a specified server.
        
        @param request: DescribeCheckWarningsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCheckWarningsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_id):
            query['CheckId'] = request.check_id
        if not UtilClient.is_unset(request.check_type):
            query['CheckType'] = request.check_type
        if not UtilClient.is_unset(request.container_name):
            query['ContainerName'] = request.container_name
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        if not UtilClient.is_unset(request.risk_id):
            query['RiskId'] = request.risk_id
        if not UtilClient.is_unset(request.risk_status):
            query['RiskStatus'] = request.risk_status
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckWarnings',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckWarningsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_check_warnings(
        self,
        request: sas_20181203_models.DescribeCheckWarningsRequest,
    ) -> sas_20181203_models.DescribeCheckWarningsResponse:
        """
        @summary Queries information about specified risk items and the check items of a specified server.
        
        @param request: DescribeCheckWarningsRequest
        @return: DescribeCheckWarningsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_check_warnings_with_options(request, runtime)

    async def describe_check_warnings_async(
        self,
        request: sas_20181203_models.DescribeCheckWarningsRequest,
    ) -> sas_20181203_models.DescribeCheckWarningsResponse:
        """
        @summary Queries information about specified risk items and the check items of a specified server.
        
        @param request: DescribeCheckWarningsRequest
        @return: DescribeCheckWarningsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_check_warnings_with_options_async(request, runtime)

    def describe_client_conf_setup_with_options(
        self,
        request: sas_20181203_models.DescribeClientConfSetupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClientConfSetupResponse:
        """
        @summary Queries the configurations of the Security Center agent.
        
        @param request: DescribeClientConfSetupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClientConfSetupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.strategy_tag):
            query['StrategyTag'] = request.strategy_tag
        if not UtilClient.is_unset(request.strategy_tag_value):
            query['StrategyTagValue'] = request.strategy_tag_value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClientConfSetup',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClientConfSetupResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_client_conf_setup_with_options_async(
        self,
        request: sas_20181203_models.DescribeClientConfSetupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClientConfSetupResponse:
        """
        @summary Queries the configurations of the Security Center agent.
        
        @param request: DescribeClientConfSetupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClientConfSetupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.strategy_tag):
            query['StrategyTag'] = request.strategy_tag
        if not UtilClient.is_unset(request.strategy_tag_value):
            query['StrategyTagValue'] = request.strategy_tag_value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClientConfSetup',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClientConfSetupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_client_conf_setup(
        self,
        request: sas_20181203_models.DescribeClientConfSetupRequest,
    ) -> sas_20181203_models.DescribeClientConfSetupResponse:
        """
        @summary Queries the configurations of the Security Center agent.
        
        @param request: DescribeClientConfSetupRequest
        @return: DescribeClientConfSetupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_client_conf_setup_with_options(request, runtime)

    async def describe_client_conf_setup_async(
        self,
        request: sas_20181203_models.DescribeClientConfSetupRequest,
    ) -> sas_20181203_models.DescribeClientConfSetupResponse:
        """
        @summary Queries the configurations of the Security Center agent.
        
        @param request: DescribeClientConfSetupRequest
        @return: DescribeClientConfSetupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_client_conf_setup_with_options_async(request, runtime)

    def describe_client_conf_strategy_with_options(
        self,
        request: sas_20181203_models.DescribeClientConfStrategyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClientConfStrategyResponse:
        """
        @summary Queries the configurations of servers to which different tags are added.
        
        @param request: DescribeClientConfStrategyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClientConfStrategyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.tag_value):
            query['TagValue'] = request.tag_value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClientConfStrategy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClientConfStrategyResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_client_conf_strategy_with_options_async(
        self,
        request: sas_20181203_models.DescribeClientConfStrategyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClientConfStrategyResponse:
        """
        @summary Queries the configurations of servers to which different tags are added.
        
        @param request: DescribeClientConfStrategyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClientConfStrategyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.tag_value):
            query['TagValue'] = request.tag_value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClientConfStrategy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClientConfStrategyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_client_conf_strategy(
        self,
        request: sas_20181203_models.DescribeClientConfStrategyRequest,
    ) -> sas_20181203_models.DescribeClientConfStrategyResponse:
        """
        @summary Queries the configurations of servers to which different tags are added.
        
        @param request: DescribeClientConfStrategyRequest
        @return: DescribeClientConfStrategyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_client_conf_strategy_with_options(request, runtime)

    async def describe_client_conf_strategy_async(
        self,
        request: sas_20181203_models.DescribeClientConfStrategyRequest,
    ) -> sas_20181203_models.DescribeClientConfStrategyResponse:
        """
        @summary Queries the configurations of servers to which different tags are added.
        
        @param request: DescribeClientConfStrategyRequest
        @return: DescribeClientConfStrategyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_client_conf_strategy_with_options_async(request, runtime)

    def describe_client_problem_type_with_options(
        self,
        request: sas_20181203_models.DescribeClientProblemTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClientProblemTypeResponse:
        """
        @summary Queries a list of agent issue types.
        
        @param request: DescribeClientProblemTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClientProblemTypeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClientProblemType',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClientProblemTypeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_client_problem_type_with_options_async(
        self,
        request: sas_20181203_models.DescribeClientProblemTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClientProblemTypeResponse:
        """
        @summary Queries a list of agent issue types.
        
        @param request: DescribeClientProblemTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClientProblemTypeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClientProblemType',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClientProblemTypeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_client_problem_type(
        self,
        request: sas_20181203_models.DescribeClientProblemTypeRequest,
    ) -> sas_20181203_models.DescribeClientProblemTypeResponse:
        """
        @summary Queries a list of agent issue types.
        
        @param request: DescribeClientProblemTypeRequest
        @return: DescribeClientProblemTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_client_problem_type_with_options(request, runtime)

    async def describe_client_problem_type_async(
        self,
        request: sas_20181203_models.DescribeClientProblemTypeRequest,
    ) -> sas_20181203_models.DescribeClientProblemTypeResponse:
        """
        @summary Queries a list of agent issue types.
        
        @param request: DescribeClientProblemTypeRequest
        @return: DescribeClientProblemTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_client_problem_type_with_options_async(request, runtime)

    def describe_cloud_center_instances_with_options(
        self,
        request: sas_20181203_models.DescribeCloudCenterInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCloudCenterInstancesResponse:
        """
        @summary Queries the information about assets that meet specific search conditions. For example, you can search for assets by the instance name or region of the asset.
        
        @description You can search for an asset by using search conditions, such as the instance ID, instance name, virtual private cloud (VPC) ID, region, and public IP address. You can also configure a logical relationship between multiple search conditions to search for the assets that meet the search conditions.
        
        @param request: DescribeCloudCenterInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCloudCenterInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.flags):
            query['Flags'] = request.flags
        if not UtilClient.is_unset(request.importance):
            query['Importance'] = request.importance
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.logical_exp):
            query['LogicalExp'] = request.logical_exp
        if not UtilClient.is_unset(request.machine_types):
            query['MachineTypes'] = request.machine_types
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.no_group_trace):
            query['NoGroupTrace'] = request.no_group_trace
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        if not UtilClient.is_unset(request.use_next_token):
            query['UseNextToken'] = request.use_next_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCloudCenterInstances',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCloudCenterInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cloud_center_instances_with_options_async(
        self,
        request: sas_20181203_models.DescribeCloudCenterInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCloudCenterInstancesResponse:
        """
        @summary Queries the information about assets that meet specific search conditions. For example, you can search for assets by the instance name or region of the asset.
        
        @description You can search for an asset by using search conditions, such as the instance ID, instance name, virtual private cloud (VPC) ID, region, and public IP address. You can also configure a logical relationship between multiple search conditions to search for the assets that meet the search conditions.
        
        @param request: DescribeCloudCenterInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCloudCenterInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.flags):
            query['Flags'] = request.flags
        if not UtilClient.is_unset(request.importance):
            query['Importance'] = request.importance
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.logical_exp):
            query['LogicalExp'] = request.logical_exp
        if not UtilClient.is_unset(request.machine_types):
            query['MachineTypes'] = request.machine_types
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.no_group_trace):
            query['NoGroupTrace'] = request.no_group_trace
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        if not UtilClient.is_unset(request.use_next_token):
            query['UseNextToken'] = request.use_next_token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCloudCenterInstances',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCloudCenterInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cloud_center_instances(
        self,
        request: sas_20181203_models.DescribeCloudCenterInstancesRequest,
    ) -> sas_20181203_models.DescribeCloudCenterInstancesResponse:
        """
        @summary Queries the information about assets that meet specific search conditions. For example, you can search for assets by the instance name or region of the asset.
        
        @description You can search for an asset by using search conditions, such as the instance ID, instance name, virtual private cloud (VPC) ID, region, and public IP address. You can also configure a logical relationship between multiple search conditions to search for the assets that meet the search conditions.
        
        @param request: DescribeCloudCenterInstancesRequest
        @return: DescribeCloudCenterInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cloud_center_instances_with_options(request, runtime)

    async def describe_cloud_center_instances_async(
        self,
        request: sas_20181203_models.DescribeCloudCenterInstancesRequest,
    ) -> sas_20181203_models.DescribeCloudCenterInstancesResponse:
        """
        @summary Queries the information about assets that meet specific search conditions. For example, you can search for assets by the instance name or region of the asset.
        
        @description You can search for an asset by using search conditions, such as the instance ID, instance name, virtual private cloud (VPC) ID, region, and public IP address. You can also configure a logical relationship between multiple search conditions to search for the assets that meet the search conditions.
        
        @param request: DescribeCloudCenterInstancesRequest
        @return: DescribeCloudCenterInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cloud_center_instances_with_options_async(request, runtime)

    def describe_cloud_product_field_statistics_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCloudProductFieldStatisticsResponse:
        """
        @deprecated OpenAPI DescribeCloudProductFieldStatistics is deprecated, please use Sas::2018-12-03::GetCloudAssetSummary instead.
        
        @summary Queries the statistics of cloud services.
        
        @param request: DescribeCloudProductFieldStatisticsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCloudProductFieldStatisticsResponse
        Deprecated
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCloudProductFieldStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCloudProductFieldStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cloud_product_field_statistics_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCloudProductFieldStatisticsResponse:
        """
        @deprecated OpenAPI DescribeCloudProductFieldStatistics is deprecated, please use Sas::2018-12-03::GetCloudAssetSummary instead.
        
        @summary Queries the statistics of cloud services.
        
        @param request: DescribeCloudProductFieldStatisticsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCloudProductFieldStatisticsResponse
        Deprecated
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCloudProductFieldStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCloudProductFieldStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cloud_product_field_statistics(self) -> sas_20181203_models.DescribeCloudProductFieldStatisticsResponse:
        """
        @deprecated OpenAPI DescribeCloudProductFieldStatistics is deprecated, please use Sas::2018-12-03::GetCloudAssetSummary instead.
        
        @summary Queries the statistics of cloud services.
        
        @return: DescribeCloudProductFieldStatisticsResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cloud_product_field_statistics_with_options(runtime)

    async def describe_cloud_product_field_statistics_async(self) -> sas_20181203_models.DescribeCloudProductFieldStatisticsResponse:
        """
        @deprecated OpenAPI DescribeCloudProductFieldStatistics is deprecated, please use Sas::2018-12-03::GetCloudAssetSummary instead.
        
        @summary Queries the statistics of cloud services.
        
        @return: DescribeCloudProductFieldStatisticsResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cloud_product_field_statistics_with_options_async(runtime)

    def describe_cloud_vendor_account_aklist_with_options(
        self,
        request: sas_20181203_models.DescribeCloudVendorAccountAKListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCloudVendorAccountAKListResponse:
        """
        @summary Queries the multi-cloud assets added to Security Center.
        
        @param request: DescribeCloudVendorAccountAKListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCloudVendorAccountAKListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_ids):
            query['AuthIds'] = request.auth_ids
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.sub_account_name):
            query['SubAccountName'] = request.sub_account_name
        if not UtilClient.is_unset(request.vendor_auth_alias):
            query['VendorAuthAlias'] = request.vendor_auth_alias
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCloudVendorAccountAKList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCloudVendorAccountAKListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cloud_vendor_account_aklist_with_options_async(
        self,
        request: sas_20181203_models.DescribeCloudVendorAccountAKListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCloudVendorAccountAKListResponse:
        """
        @summary Queries the multi-cloud assets added to Security Center.
        
        @param request: DescribeCloudVendorAccountAKListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCloudVendorAccountAKListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_ids):
            query['AuthIds'] = request.auth_ids
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.sub_account_name):
            query['SubAccountName'] = request.sub_account_name
        if not UtilClient.is_unset(request.vendor_auth_alias):
            query['VendorAuthAlias'] = request.vendor_auth_alias
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCloudVendorAccountAKList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCloudVendorAccountAKListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cloud_vendor_account_aklist(
        self,
        request: sas_20181203_models.DescribeCloudVendorAccountAKListRequest,
    ) -> sas_20181203_models.DescribeCloudVendorAccountAKListResponse:
        """
        @summary Queries the multi-cloud assets added to Security Center.
        
        @param request: DescribeCloudVendorAccountAKListRequest
        @return: DescribeCloudVendorAccountAKListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cloud_vendor_account_aklist_with_options(request, runtime)

    async def describe_cloud_vendor_account_aklist_async(
        self,
        request: sas_20181203_models.DescribeCloudVendorAccountAKListRequest,
    ) -> sas_20181203_models.DescribeCloudVendorAccountAKListResponse:
        """
        @summary Queries the multi-cloud assets added to Security Center.
        
        @param request: DescribeCloudVendorAccountAKListRequest
        @return: DescribeCloudVendorAccountAKListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cloud_vendor_account_aklist_with_options_async(request, runtime)

    def describe_cloud_vendor_trial_config_with_options(
        self,
        request: sas_20181203_models.DescribeCloudVendorTrialConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCloudVendorTrialConfigResponse:
        """
        @summary Query the trail configuration attributes of the corresponding AK configuration
        
        @param request: DescribeCloudVendorTrialConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCloudVendorTrialConfigResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCloudVendorTrialConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCloudVendorTrialConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cloud_vendor_trial_config_with_options_async(
        self,
        request: sas_20181203_models.DescribeCloudVendorTrialConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCloudVendorTrialConfigResponse:
        """
        @summary Query the trail configuration attributes of the corresponding AK configuration
        
        @param request: DescribeCloudVendorTrialConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCloudVendorTrialConfigResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCloudVendorTrialConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCloudVendorTrialConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cloud_vendor_trial_config(
        self,
        request: sas_20181203_models.DescribeCloudVendorTrialConfigRequest,
    ) -> sas_20181203_models.DescribeCloudVendorTrialConfigResponse:
        """
        @summary Query the trail configuration attributes of the corresponding AK configuration
        
        @param request: DescribeCloudVendorTrialConfigRequest
        @return: DescribeCloudVendorTrialConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cloud_vendor_trial_config_with_options(request, runtime)

    async def describe_cloud_vendor_trial_config_async(
        self,
        request: sas_20181203_models.DescribeCloudVendorTrialConfigRequest,
    ) -> sas_20181203_models.DescribeCloudVendorTrialConfigResponse:
        """
        @summary Query the trail configuration attributes of the corresponding AK configuration
        
        @param request: DescribeCloudVendorTrialConfigRequest
        @return: DescribeCloudVendorTrialConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cloud_vendor_trial_config_with_options_async(request, runtime)

    def describe_cluster_basic_info_with_options(
        self,
        request: sas_20181203_models.DescribeClusterBasicInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClusterBasicInfoResponse:
        """
        @summary Queries the information about an cluster based on the cluster ID.
        
        @param request: DescribeClusterBasicInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClusterBasicInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterBasicInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClusterBasicInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cluster_basic_info_with_options_async(
        self,
        request: sas_20181203_models.DescribeClusterBasicInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClusterBasicInfoResponse:
        """
        @summary Queries the information about an cluster based on the cluster ID.
        
        @param request: DescribeClusterBasicInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClusterBasicInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterBasicInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClusterBasicInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cluster_basic_info(
        self,
        request: sas_20181203_models.DescribeClusterBasicInfoRequest,
    ) -> sas_20181203_models.DescribeClusterBasicInfoResponse:
        """
        @summary Queries the information about an cluster based on the cluster ID.
        
        @param request: DescribeClusterBasicInfoRequest
        @return: DescribeClusterBasicInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cluster_basic_info_with_options(request, runtime)

    async def describe_cluster_basic_info_async(
        self,
        request: sas_20181203_models.DescribeClusterBasicInfoRequest,
    ) -> sas_20181203_models.DescribeClusterBasicInfoResponse:
        """
        @summary Queries the information about an cluster based on the cluster ID.
        
        @param request: DescribeClusterBasicInfoRequest
        @return: DescribeClusterBasicInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cluster_basic_info_with_options_async(request, runtime)

    def describe_cluster_host_security_summary_with_options(
        self,
        request: sas_20181203_models.DescribeClusterHostSecuritySummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClusterHostSecuritySummaryResponse:
        """
        @summary Queries the statistical information about host security.
        
        @param request: DescribeClusterHostSecuritySummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClusterHostSecuritySummaryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_field_name):
            query['ContainerFieldName'] = request.container_field_name
        if not UtilClient.is_unset(request.container_field_value):
            query['ContainerFieldValue'] = request.container_field_value
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterHostSecuritySummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClusterHostSecuritySummaryResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cluster_host_security_summary_with_options_async(
        self,
        request: sas_20181203_models.DescribeClusterHostSecuritySummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClusterHostSecuritySummaryResponse:
        """
        @summary Queries the statistical information about host security.
        
        @param request: DescribeClusterHostSecuritySummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClusterHostSecuritySummaryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_field_name):
            query['ContainerFieldName'] = request.container_field_name
        if not UtilClient.is_unset(request.container_field_value):
            query['ContainerFieldValue'] = request.container_field_value
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterHostSecuritySummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClusterHostSecuritySummaryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cluster_host_security_summary(
        self,
        request: sas_20181203_models.DescribeClusterHostSecuritySummaryRequest,
    ) -> sas_20181203_models.DescribeClusterHostSecuritySummaryResponse:
        """
        @summary Queries the statistical information about host security.
        
        @param request: DescribeClusterHostSecuritySummaryRequest
        @return: DescribeClusterHostSecuritySummaryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cluster_host_security_summary_with_options(request, runtime)

    async def describe_cluster_host_security_summary_async(
        self,
        request: sas_20181203_models.DescribeClusterHostSecuritySummaryRequest,
    ) -> sas_20181203_models.DescribeClusterHostSecuritySummaryResponse:
        """
        @summary Queries the statistical information about host security.
        
        @param request: DescribeClusterHostSecuritySummaryRequest
        @return: DescribeClusterHostSecuritySummaryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cluster_host_security_summary_with_options_async(request, runtime)

    def describe_cluster_image_security_summary_with_options(
        self,
        request: sas_20181203_models.DescribeClusterImageSecuritySummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClusterImageSecuritySummaryResponse:
        """
        @summary Queries the statistical information about image security.
        
        @param request: DescribeClusterImageSecuritySummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClusterImageSecuritySummaryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_field_name):
            query['ContainerFieldName'] = request.container_field_name
        if not UtilClient.is_unset(request.container_field_value):
            query['ContainerFieldValue'] = request.container_field_value
        if not UtilClient.is_unset(request.image_digest):
            query['ImageDigest'] = request.image_digest
        if not UtilClient.is_unset(request.image_repo_name):
            query['ImageRepoName'] = request.image_repo_name
        if not UtilClient.is_unset(request.image_repo_namespace):
            query['ImageRepoNamespace'] = request.image_repo_namespace
        if not UtilClient.is_unset(request.image_tag):
            query['ImageTag'] = request.image_tag
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterImageSecuritySummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClusterImageSecuritySummaryResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cluster_image_security_summary_with_options_async(
        self,
        request: sas_20181203_models.DescribeClusterImageSecuritySummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClusterImageSecuritySummaryResponse:
        """
        @summary Queries the statistical information about image security.
        
        @param request: DescribeClusterImageSecuritySummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClusterImageSecuritySummaryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_field_name):
            query['ContainerFieldName'] = request.container_field_name
        if not UtilClient.is_unset(request.container_field_value):
            query['ContainerFieldValue'] = request.container_field_value
        if not UtilClient.is_unset(request.image_digest):
            query['ImageDigest'] = request.image_digest
        if not UtilClient.is_unset(request.image_repo_name):
            query['ImageRepoName'] = request.image_repo_name
        if not UtilClient.is_unset(request.image_repo_namespace):
            query['ImageRepoNamespace'] = request.image_repo_namespace
        if not UtilClient.is_unset(request.image_tag):
            query['ImageTag'] = request.image_tag
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterImageSecuritySummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClusterImageSecuritySummaryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cluster_image_security_summary(
        self,
        request: sas_20181203_models.DescribeClusterImageSecuritySummaryRequest,
    ) -> sas_20181203_models.DescribeClusterImageSecuritySummaryResponse:
        """
        @summary Queries the statistical information about image security.
        
        @param request: DescribeClusterImageSecuritySummaryRequest
        @return: DescribeClusterImageSecuritySummaryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cluster_image_security_summary_with_options(request, runtime)

    async def describe_cluster_image_security_summary_async(
        self,
        request: sas_20181203_models.DescribeClusterImageSecuritySummaryRequest,
    ) -> sas_20181203_models.DescribeClusterImageSecuritySummaryResponse:
        """
        @summary Queries the statistical information about image security.
        
        @param request: DescribeClusterImageSecuritySummaryRequest
        @return: DescribeClusterImageSecuritySummaryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cluster_image_security_summary_with_options_async(request, runtime)

    def describe_cluster_info_list_with_options(
        self,
        request: sas_20181203_models.DescribeClusterInfoListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClusterInfoListResponse:
        """
        @summary Queries the information about a cluster.
        
        @param request: DescribeClusterInfoListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClusterInfoListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.target):
            query['Target'] = request.target
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterInfoList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClusterInfoListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cluster_info_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeClusterInfoListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClusterInfoListResponse:
        """
        @summary Queries the information about a cluster.
        
        @param request: DescribeClusterInfoListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClusterInfoListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.target):
            query['Target'] = request.target
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterInfoList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClusterInfoListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cluster_info_list(
        self,
        request: sas_20181203_models.DescribeClusterInfoListRequest,
    ) -> sas_20181203_models.DescribeClusterInfoListResponse:
        """
        @summary Queries the information about a cluster.
        
        @param request: DescribeClusterInfoListRequest
        @return: DescribeClusterInfoListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cluster_info_list_with_options(request, runtime)

    async def describe_cluster_info_list_async(
        self,
        request: sas_20181203_models.DescribeClusterInfoListRequest,
    ) -> sas_20181203_models.DescribeClusterInfoListResponse:
        """
        @summary Queries the information about a cluster.
        
        @param request: DescribeClusterInfoListRequest
        @return: DescribeClusterInfoListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cluster_info_list_with_options_async(request, runtime)

    def describe_cluster_network_with_options(
        self,
        request: sas_20181203_models.DescribeClusterNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClusterNetworkResponse:
        """
        @summary Queries information about the network topology edge by cluster.
        
        @param request: DescribeClusterNetworkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClusterNetworkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterNetwork',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClusterNetworkResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cluster_network_with_options_async(
        self,
        request: sas_20181203_models.DescribeClusterNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClusterNetworkResponse:
        """
        @summary Queries information about the network topology edge by cluster.
        
        @param request: DescribeClusterNetworkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClusterNetworkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterNetwork',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClusterNetworkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cluster_network(
        self,
        request: sas_20181203_models.DescribeClusterNetworkRequest,
    ) -> sas_20181203_models.DescribeClusterNetworkResponse:
        """
        @summary Queries information about the network topology edge by cluster.
        
        @param request: DescribeClusterNetworkRequest
        @return: DescribeClusterNetworkResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cluster_network_with_options(request, runtime)

    async def describe_cluster_network_async(
        self,
        request: sas_20181203_models.DescribeClusterNetworkRequest,
    ) -> sas_20181203_models.DescribeClusterNetworkResponse:
        """
        @summary Queries information about the network topology edge by cluster.
        
        @param request: DescribeClusterNetworkRequest
        @return: DescribeClusterNetworkResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cluster_network_with_options_async(request, runtime)

    def describe_cluster_vul_statistics_with_options(
        self,
        request: sas_20181203_models.DescribeClusterVulStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClusterVulStatisticsResponse:
        """
        @summary Queries the statistics of vulnerabilities that are detected on a cluster.
        
        @param request: DescribeClusterVulStatisticsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClusterVulStatisticsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.types):
            query['Types'] = request.types
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterVulStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClusterVulStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cluster_vul_statistics_with_options_async(
        self,
        request: sas_20181203_models.DescribeClusterVulStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClusterVulStatisticsResponse:
        """
        @summary Queries the statistics of vulnerabilities that are detected on a cluster.
        
        @param request: DescribeClusterVulStatisticsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClusterVulStatisticsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.types):
            query['Types'] = request.types
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterVulStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClusterVulStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cluster_vul_statistics(
        self,
        request: sas_20181203_models.DescribeClusterVulStatisticsRequest,
    ) -> sas_20181203_models.DescribeClusterVulStatisticsResponse:
        """
        @summary Queries the statistics of vulnerabilities that are detected on a cluster.
        
        @param request: DescribeClusterVulStatisticsRequest
        @return: DescribeClusterVulStatisticsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cluster_vul_statistics_with_options(request, runtime)

    async def describe_cluster_vul_statistics_async(
        self,
        request: sas_20181203_models.DescribeClusterVulStatisticsRequest,
    ) -> sas_20181203_models.DescribeClusterVulStatisticsResponse:
        """
        @summary Queries the statistics of vulnerabilities that are detected on a cluster.
        
        @param request: DescribeClusterVulStatisticsRequest
        @return: DescribeClusterVulStatisticsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cluster_vul_statistics_with_options_async(request, runtime)

    def describe_common_overall_config_with_options(
        self,
        request: sas_20181203_models.DescribeCommonOverallConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCommonOverallConfigResponse:
        """
        @summary Queries the information about a specified feature.
        
        @param request: DescribeCommonOverallConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCommonOverallConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCommonOverallConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCommonOverallConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_common_overall_config_with_options_async(
        self,
        request: sas_20181203_models.DescribeCommonOverallConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCommonOverallConfigResponse:
        """
        @summary Queries the information about a specified feature.
        
        @param request: DescribeCommonOverallConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCommonOverallConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCommonOverallConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCommonOverallConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_common_overall_config(
        self,
        request: sas_20181203_models.DescribeCommonOverallConfigRequest,
    ) -> sas_20181203_models.DescribeCommonOverallConfigResponse:
        """
        @summary Queries the information about a specified feature.
        
        @param request: DescribeCommonOverallConfigRequest
        @return: DescribeCommonOverallConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_common_overall_config_with_options(request, runtime)

    async def describe_common_overall_config_async(
        self,
        request: sas_20181203_models.DescribeCommonOverallConfigRequest,
    ) -> sas_20181203_models.DescribeCommonOverallConfigResponse:
        """
        @summary Queries the information about a specified feature.
        
        @param request: DescribeCommonOverallConfigRequest
        @return: DescribeCommonOverallConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_common_overall_config_with_options_async(request, runtime)

    def describe_common_overall_config_list_with_options(
        self,
        request: sas_20181203_models.DescribeCommonOverallConfigListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCommonOverallConfigListResponse:
        """
        @summary Queries the configurations of features in proactive defense.
        
        @param request: DescribeCommonOverallConfigListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCommonOverallConfigListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type_list):
            query['TypeList'] = request.type_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCommonOverallConfigList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCommonOverallConfigListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_common_overall_config_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeCommonOverallConfigListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCommonOverallConfigListResponse:
        """
        @summary Queries the configurations of features in proactive defense.
        
        @param request: DescribeCommonOverallConfigListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCommonOverallConfigListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type_list):
            query['TypeList'] = request.type_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCommonOverallConfigList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCommonOverallConfigListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_common_overall_config_list(
        self,
        request: sas_20181203_models.DescribeCommonOverallConfigListRequest,
    ) -> sas_20181203_models.DescribeCommonOverallConfigListResponse:
        """
        @summary Queries the configurations of features in proactive defense.
        
        @param request: DescribeCommonOverallConfigListRequest
        @return: DescribeCommonOverallConfigListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_common_overall_config_list_with_options(request, runtime)

    async def describe_common_overall_config_list_async(
        self,
        request: sas_20181203_models.DescribeCommonOverallConfigListRequest,
    ) -> sas_20181203_models.DescribeCommonOverallConfigListResponse:
        """
        @summary Queries the configurations of features in proactive defense.
        
        @param request: DescribeCommonOverallConfigListRequest
        @return: DescribeCommonOverallConfigListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_common_overall_config_list_with_options_async(request, runtime)

    def describe_common_target_config_with_options(
        self,
        request: sas_20181203_models.DescribeCommonTargetConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCommonTargetConfigResponse:
        """
        @summary Queries the configurations of the proactive defense feature.
        
        @param request: DescribeCommonTargetConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCommonTargetConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCommonTargetConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCommonTargetConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_common_target_config_with_options_async(
        self,
        request: sas_20181203_models.DescribeCommonTargetConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCommonTargetConfigResponse:
        """
        @summary Queries the configurations of the proactive defense feature.
        
        @param request: DescribeCommonTargetConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCommonTargetConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCommonTargetConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCommonTargetConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_common_target_config(
        self,
        request: sas_20181203_models.DescribeCommonTargetConfigRequest,
    ) -> sas_20181203_models.DescribeCommonTargetConfigResponse:
        """
        @summary Queries the configurations of the proactive defense feature.
        
        @param request: DescribeCommonTargetConfigRequest
        @return: DescribeCommonTargetConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_common_target_config_with_options(request, runtime)

    async def describe_common_target_config_async(
        self,
        request: sas_20181203_models.DescribeCommonTargetConfigRequest,
    ) -> sas_20181203_models.DescribeCommonTargetConfigResponse:
        """
        @summary Queries the configurations of the proactive defense feature.
        
        @param request: DescribeCommonTargetConfigRequest
        @return: DescribeCommonTargetConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_common_target_config_with_options_async(request, runtime)

    def describe_common_target_result_list_with_options(
        self,
        request: sas_20181203_models.DescribeCommonTargetResultListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCommonTargetResultListResponse:
        """
        @summary Queries the information about the servers based on the specified configuration item.
        
        @param request: DescribeCommonTargetResultListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCommonTargetResultListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCommonTargetResultList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCommonTargetResultListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_common_target_result_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeCommonTargetResultListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCommonTargetResultListResponse:
        """
        @summary Queries the information about the servers based on the specified configuration item.
        
        @param request: DescribeCommonTargetResultListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCommonTargetResultListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCommonTargetResultList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCommonTargetResultListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_common_target_result_list(
        self,
        request: sas_20181203_models.DescribeCommonTargetResultListRequest,
    ) -> sas_20181203_models.DescribeCommonTargetResultListResponse:
        """
        @summary Queries the information about the servers based on the specified configuration item.
        
        @param request: DescribeCommonTargetResultListRequest
        @return: DescribeCommonTargetResultListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_common_target_result_list_with_options(request, runtime)

    async def describe_common_target_result_list_async(
        self,
        request: sas_20181203_models.DescribeCommonTargetResultListRequest,
    ) -> sas_20181203_models.DescribeCommonTargetResultListResponse:
        """
        @summary Queries the information about the servers based on the specified configuration item.
        
        @param request: DescribeCommonTargetResultListRequest
        @return: DescribeCommonTargetResultListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_common_target_result_list_with_options_async(request, runtime)

    def describe_concern_necessity_with_options(
        self,
        request: sas_20181203_models.DescribeConcernNecessityRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeConcernNecessityResponse:
        """
        @summary Queries the priorities to fix vulnerabilities.
        
        @param request: DescribeConcernNecessityRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeConcernNecessityResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeConcernNecessity',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeConcernNecessityResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_concern_necessity_with_options_async(
        self,
        request: sas_20181203_models.DescribeConcernNecessityRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeConcernNecessityResponse:
        """
        @summary Queries the priorities to fix vulnerabilities.
        
        @param request: DescribeConcernNecessityRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeConcernNecessityResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeConcernNecessity',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeConcernNecessityResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_concern_necessity(
        self,
        request: sas_20181203_models.DescribeConcernNecessityRequest,
    ) -> sas_20181203_models.DescribeConcernNecessityResponse:
        """
        @summary Queries the priorities to fix vulnerabilities.
        
        @param request: DescribeConcernNecessityRequest
        @return: DescribeConcernNecessityResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_concern_necessity_with_options(request, runtime)

    async def describe_concern_necessity_async(
        self,
        request: sas_20181203_models.DescribeConcernNecessityRequest,
    ) -> sas_20181203_models.DescribeConcernNecessityResponse:
        """
        @summary Queries the priorities to fix vulnerabilities.
        
        @param request: DescribeConcernNecessityRequest
        @return: DescribeConcernNecessityResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_concern_necessity_with_options_async(request, runtime)

    def describe_container_apps_with_options(
        self,
        request: sas_20181203_models.DescribeContainerAppsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerAppsResponse:
        """
        @summary Queries the information about a containerized application.
        
        @param request: DescribeContainerAppsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerAppsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.field_value):
            query['FieldValue'] = request.field_value
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerApps',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerAppsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_container_apps_with_options_async(
        self,
        request: sas_20181203_models.DescribeContainerAppsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerAppsResponse:
        """
        @summary Queries the information about a containerized application.
        
        @param request: DescribeContainerAppsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerAppsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.field_value):
            query['FieldValue'] = request.field_value
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerApps',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerAppsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_container_apps(
        self,
        request: sas_20181203_models.DescribeContainerAppsRequest,
    ) -> sas_20181203_models.DescribeContainerAppsResponse:
        """
        @summary Queries the information about a containerized application.
        
        @param request: DescribeContainerAppsRequest
        @return: DescribeContainerAppsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_container_apps_with_options(request, runtime)

    async def describe_container_apps_async(
        self,
        request: sas_20181203_models.DescribeContainerAppsRequest,
    ) -> sas_20181203_models.DescribeContainerAppsResponse:
        """
        @summary Queries the information about a containerized application.
        
        @param request: DescribeContainerAppsRequest
        @return: DescribeContainerAppsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_container_apps_with_options_async(request, runtime)

    def describe_container_criteria_with_options(
        self,
        request: sas_20181203_models.DescribeContainerCriteriaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerCriteriaResponse:
        """
        @summary Obtains the filter conditions that you can use to filter the containers.
        
        @param request: DescribeContainerCriteriaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerCriteriaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_field):
            query['GroupField'] = request.group_field
        if not UtilClient.is_unset(request.value):
            query['Value'] = request.value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerCriteria',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerCriteriaResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_container_criteria_with_options_async(
        self,
        request: sas_20181203_models.DescribeContainerCriteriaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerCriteriaResponse:
        """
        @summary Obtains the filter conditions that you can use to filter the containers.
        
        @param request: DescribeContainerCriteriaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerCriteriaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_field):
            query['GroupField'] = request.group_field
        if not UtilClient.is_unset(request.value):
            query['Value'] = request.value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerCriteria',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerCriteriaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_container_criteria(
        self,
        request: sas_20181203_models.DescribeContainerCriteriaRequest,
    ) -> sas_20181203_models.DescribeContainerCriteriaResponse:
        """
        @summary Obtains the filter conditions that you can use to filter the containers.
        
        @param request: DescribeContainerCriteriaRequest
        @return: DescribeContainerCriteriaResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_container_criteria_with_options(request, runtime)

    async def describe_container_criteria_async(
        self,
        request: sas_20181203_models.DescribeContainerCriteriaRequest,
    ) -> sas_20181203_models.DescribeContainerCriteriaResponse:
        """
        @summary Obtains the filter conditions that you can use to filter the containers.
        
        @param request: DescribeContainerCriteriaRequest
        @return: DescribeContainerCriteriaResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_container_criteria_with_options_async(request, runtime)

    def describe_container_field_statistics_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerFieldStatisticsResponse:
        """
        @summary Queries the statistical information about containers.
        
        @param request: DescribeContainerFieldStatisticsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerFieldStatisticsResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeContainerFieldStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerFieldStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_container_field_statistics_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerFieldStatisticsResponse:
        """
        @summary Queries the statistical information about containers.
        
        @param request: DescribeContainerFieldStatisticsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerFieldStatisticsResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeContainerFieldStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerFieldStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_container_field_statistics(self) -> sas_20181203_models.DescribeContainerFieldStatisticsResponse:
        """
        @summary Queries the statistical information about containers.
        
        @return: DescribeContainerFieldStatisticsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_container_field_statistics_with_options(runtime)

    async def describe_container_field_statistics_async(self) -> sas_20181203_models.DescribeContainerFieldStatisticsResponse:
        """
        @summary Queries the statistical information about containers.
        
        @return: DescribeContainerFieldStatisticsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_container_field_statistics_with_options_async(runtime)

    def describe_container_grouped_field_detail_with_options(
        self,
        request: sas_20181203_models.DescribeContainerGroupedFieldDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerGroupedFieldDetailResponse:
        """
        @summary Queries the attribute details of containers.
        
        @param request: DescribeContainerGroupedFieldDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerGroupedFieldDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.group_field):
            query['GroupField'] = request.group_field
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerGroupedFieldDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerGroupedFieldDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_container_grouped_field_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribeContainerGroupedFieldDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerGroupedFieldDetailResponse:
        """
        @summary Queries the attribute details of containers.
        
        @param request: DescribeContainerGroupedFieldDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerGroupedFieldDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.group_field):
            query['GroupField'] = request.group_field
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerGroupedFieldDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerGroupedFieldDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_container_grouped_field_detail(
        self,
        request: sas_20181203_models.DescribeContainerGroupedFieldDetailRequest,
    ) -> sas_20181203_models.DescribeContainerGroupedFieldDetailResponse:
        """
        @summary Queries the attribute details of containers.
        
        @param request: DescribeContainerGroupedFieldDetailRequest
        @return: DescribeContainerGroupedFieldDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_container_grouped_field_detail_with_options(request, runtime)

    async def describe_container_grouped_field_detail_async(
        self,
        request: sas_20181203_models.DescribeContainerGroupedFieldDetailRequest,
    ) -> sas_20181203_models.DescribeContainerGroupedFieldDetailResponse:
        """
        @summary Queries the attribute details of containers.
        
        @param request: DescribeContainerGroupedFieldDetailRequest
        @return: DescribeContainerGroupedFieldDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_container_grouped_field_detail_with_options_async(request, runtime)

    def describe_container_instances_with_options(
        self,
        request: sas_20181203_models.DescribeContainerInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerInstancesResponse:
        """
        @summary Queries the information about containers.
        
        @param request: DescribeContainerInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.logical_exp):
            query['LogicalExp'] = request.logical_exp
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerInstances',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_container_instances_with_options_async(
        self,
        request: sas_20181203_models.DescribeContainerInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerInstancesResponse:
        """
        @summary Queries the information about containers.
        
        @param request: DescribeContainerInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.logical_exp):
            query['LogicalExp'] = request.logical_exp
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerInstances',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_container_instances(
        self,
        request: sas_20181203_models.DescribeContainerInstancesRequest,
    ) -> sas_20181203_models.DescribeContainerInstancesResponse:
        """
        @summary Queries the information about containers.
        
        @param request: DescribeContainerInstancesRequest
        @return: DescribeContainerInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_container_instances_with_options(request, runtime)

    async def describe_container_instances_async(
        self,
        request: sas_20181203_models.DescribeContainerInstancesRequest,
    ) -> sas_20181203_models.DescribeContainerInstancesResponse:
        """
        @summary Queries the information about containers.
        
        @param request: DescribeContainerInstancesRequest
        @return: DescribeContainerInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_container_instances_with_options_async(request, runtime)

    def describe_container_scan_config_with_options(
        self,
        request: sas_20181203_models.DescribeContainerScanConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerScanConfigResponse:
        """
        @summary Queries the configurations of the vulnerability scan of one or more running container applications.
        
        @param request: DescribeContainerScanConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerScanConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerScanConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerScanConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_container_scan_config_with_options_async(
        self,
        request: sas_20181203_models.DescribeContainerScanConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerScanConfigResponse:
        """
        @summary Queries the configurations of the vulnerability scan of one or more running container applications.
        
        @param request: DescribeContainerScanConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerScanConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerScanConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerScanConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_container_scan_config(
        self,
        request: sas_20181203_models.DescribeContainerScanConfigRequest,
    ) -> sas_20181203_models.DescribeContainerScanConfigResponse:
        """
        @summary Queries the configurations of the vulnerability scan of one or more running container applications.
        
        @param request: DescribeContainerScanConfigRequest
        @return: DescribeContainerScanConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_container_scan_config_with_options(request, runtime)

    async def describe_container_scan_config_async(
        self,
        request: sas_20181203_models.DescribeContainerScanConfigRequest,
    ) -> sas_20181203_models.DescribeContainerScanConfigResponse:
        """
        @summary Queries the configurations of the vulnerability scan of one or more running container applications.
        
        @param request: DescribeContainerScanConfigRequest
        @return: DescribeContainerScanConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_container_scan_config_with_options_async(request, runtime)

    def describe_container_service_k8s_cluster_kritis_status_with_options(
        self,
        request: sas_20181203_models.DescribeContainerServiceK8sClusterKritisStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerServiceK8sClusterKritisStatusResponse:
        """
        @summary Queries the Kritis status of a Container Service for Kubernetes (ACK) cluster.
        
        @param request: DescribeContainerServiceK8sClusterKritisStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerServiceK8sClusterKritisStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerServiceK8sClusterKritisStatus',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerServiceK8sClusterKritisStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_container_service_k8s_cluster_kritis_status_with_options_async(
        self,
        request: sas_20181203_models.DescribeContainerServiceK8sClusterKritisStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerServiceK8sClusterKritisStatusResponse:
        """
        @summary Queries the Kritis status of a Container Service for Kubernetes (ACK) cluster.
        
        @param request: DescribeContainerServiceK8sClusterKritisStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerServiceK8sClusterKritisStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerServiceK8sClusterKritisStatus',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerServiceK8sClusterKritisStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_container_service_k8s_cluster_kritis_status(
        self,
        request: sas_20181203_models.DescribeContainerServiceK8sClusterKritisStatusRequest,
    ) -> sas_20181203_models.DescribeContainerServiceK8sClusterKritisStatusResponse:
        """
        @summary Queries the Kritis status of a Container Service for Kubernetes (ACK) cluster.
        
        @param request: DescribeContainerServiceK8sClusterKritisStatusRequest
        @return: DescribeContainerServiceK8sClusterKritisStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_container_service_k8s_cluster_kritis_status_with_options(request, runtime)

    async def describe_container_service_k8s_cluster_kritis_status_async(
        self,
        request: sas_20181203_models.DescribeContainerServiceK8sClusterKritisStatusRequest,
    ) -> sas_20181203_models.DescribeContainerServiceK8sClusterKritisStatusResponse:
        """
        @summary Queries the Kritis status of a Container Service for Kubernetes (ACK) cluster.
        
        @param request: DescribeContainerServiceK8sClusterKritisStatusRequest
        @return: DescribeContainerServiceK8sClusterKritisStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_container_service_k8s_cluster_kritis_status_with_options_async(request, runtime)

    def describe_container_service_k8s_cluster_namespaces_with_options(
        self,
        request: sas_20181203_models.DescribeContainerServiceK8sClusterNamespacesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerServiceK8sClusterNamespacesResponse:
        """
        @summary Queries the namespace of a Container Service for Kubernetes (ACK) cluster.
        
        @param request: DescribeContainerServiceK8sClusterNamespacesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerServiceK8sClusterNamespacesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerServiceK8sClusterNamespaces',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerServiceK8sClusterNamespacesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_container_service_k8s_cluster_namespaces_with_options_async(
        self,
        request: sas_20181203_models.DescribeContainerServiceK8sClusterNamespacesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerServiceK8sClusterNamespacesResponse:
        """
        @summary Queries the namespace of a Container Service for Kubernetes (ACK) cluster.
        
        @param request: DescribeContainerServiceK8sClusterNamespacesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerServiceK8sClusterNamespacesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerServiceK8sClusterNamespaces',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerServiceK8sClusterNamespacesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_container_service_k8s_cluster_namespaces(
        self,
        request: sas_20181203_models.DescribeContainerServiceK8sClusterNamespacesRequest,
    ) -> sas_20181203_models.DescribeContainerServiceK8sClusterNamespacesResponse:
        """
        @summary Queries the namespace of a Container Service for Kubernetes (ACK) cluster.
        
        @param request: DescribeContainerServiceK8sClusterNamespacesRequest
        @return: DescribeContainerServiceK8sClusterNamespacesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_container_service_k8s_cluster_namespaces_with_options(request, runtime)

    async def describe_container_service_k8s_cluster_namespaces_async(
        self,
        request: sas_20181203_models.DescribeContainerServiceK8sClusterNamespacesRequest,
    ) -> sas_20181203_models.DescribeContainerServiceK8sClusterNamespacesResponse:
        """
        @summary Queries the namespace of a Container Service for Kubernetes (ACK) cluster.
        
        @param request: DescribeContainerServiceK8sClusterNamespacesRequest
        @return: DescribeContainerServiceK8sClusterNamespacesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_container_service_k8s_cluster_namespaces_with_options_async(request, runtime)

    def describe_container_service_k8s_clusters_with_options(
        self,
        request: sas_20181203_models.DescribeContainerServiceK8sClustersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerServiceK8sClustersResponse:
        """
        @summary Queries a list of Container Service for Kubernetes (ACK) clusters.
        
        @param request: DescribeContainerServiceK8sClustersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerServiceK8sClustersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerServiceK8sClusters',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerServiceK8sClustersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_container_service_k8s_clusters_with_options_async(
        self,
        request: sas_20181203_models.DescribeContainerServiceK8sClustersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerServiceK8sClustersResponse:
        """
        @summary Queries a list of Container Service for Kubernetes (ACK) clusters.
        
        @param request: DescribeContainerServiceK8sClustersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerServiceK8sClustersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerServiceK8sClusters',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerServiceK8sClustersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_container_service_k8s_clusters(
        self,
        request: sas_20181203_models.DescribeContainerServiceK8sClustersRequest,
    ) -> sas_20181203_models.DescribeContainerServiceK8sClustersResponse:
        """
        @summary Queries a list of Container Service for Kubernetes (ACK) clusters.
        
        @param request: DescribeContainerServiceK8sClustersRequest
        @return: DescribeContainerServiceK8sClustersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_container_service_k8s_clusters_with_options(request, runtime)

    async def describe_container_service_k8s_clusters_async(
        self,
        request: sas_20181203_models.DescribeContainerServiceK8sClustersRequest,
    ) -> sas_20181203_models.DescribeContainerServiceK8sClustersResponse:
        """
        @summary Queries a list of Container Service for Kubernetes (ACK) clusters.
        
        @param request: DescribeContainerServiceK8sClustersRequest
        @return: DescribeContainerServiceK8sClustersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_container_service_k8s_clusters_with_options_async(request, runtime)

    def describe_container_statistics_with_options(
        self,
        request: sas_20181203_models.DescribeContainerStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerStatisticsResponse:
        """
        @summary Queries the alert statistics on container assets.
        
        @description Only users who created a Container Registry Enterprise Edition instance can call this operation.
        
        @param request: DescribeContainerStatisticsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerStatisticsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_container_statistics_with_options_async(
        self,
        request: sas_20181203_models.DescribeContainerStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerStatisticsResponse:
        """
        @summary Queries the alert statistics on container assets.
        
        @description Only users who created a Container Registry Enterprise Edition instance can call this operation.
        
        @param request: DescribeContainerStatisticsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerStatisticsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_container_statistics(
        self,
        request: sas_20181203_models.DescribeContainerStatisticsRequest,
    ) -> sas_20181203_models.DescribeContainerStatisticsResponse:
        """
        @summary Queries the alert statistics on container assets.
        
        @description Only users who created a Container Registry Enterprise Edition instance can call this operation.
        
        @param request: DescribeContainerStatisticsRequest
        @return: DescribeContainerStatisticsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_container_statistics_with_options(request, runtime)

    async def describe_container_statistics_async(
        self,
        request: sas_20181203_models.DescribeContainerStatisticsRequest,
    ) -> sas_20181203_models.DescribeContainerStatisticsResponse:
        """
        @summary Queries the alert statistics on container assets.
        
        @description Only users who created a Container Registry Enterprise Edition instance can call this operation.
        
        @param request: DescribeContainerStatisticsRequest
        @return: DescribeContainerStatisticsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_container_statistics_with_options_async(request, runtime)

    def describe_container_tags_with_options(
        self,
        request: sas_20181203_models.DescribeContainerTagsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerTagsResponse:
        """
        @summary Queries the details of container assets by using an attribute.
        
        @param request: DescribeContainerTagsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerTagsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.field_name):
            query['FieldName'] = request.field_name
        if not UtilClient.is_unset(request.field_value):
            query['FieldValue'] = request.field_value
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerTags',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerTagsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_container_tags_with_options_async(
        self,
        request: sas_20181203_models.DescribeContainerTagsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerTagsResponse:
        """
        @summary Queries the details of container assets by using an attribute.
        
        @param request: DescribeContainerTagsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerTagsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.field_name):
            query['FieldName'] = request.field_name
        if not UtilClient.is_unset(request.field_value):
            query['FieldValue'] = request.field_value
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerTags',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerTagsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_container_tags(
        self,
        request: sas_20181203_models.DescribeContainerTagsRequest,
    ) -> sas_20181203_models.DescribeContainerTagsResponse:
        """
        @summary Queries the details of container assets by using an attribute.
        
        @param request: DescribeContainerTagsRequest
        @return: DescribeContainerTagsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_container_tags_with_options(request, runtime)

    async def describe_container_tags_async(
        self,
        request: sas_20181203_models.DescribeContainerTagsRequest,
    ) -> sas_20181203_models.DescribeContainerTagsResponse:
        """
        @summary Queries the details of container assets by using an attribute.
        
        @param request: DescribeContainerTagsRequest
        @return: DescribeContainerTagsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_container_tags_with_options_async(request, runtime)

    def describe_count_not_scanned_image_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCountNotScannedImageResponse:
        """
        @summary Queries the number of images that are not scanned.
        
        @param request: DescribeCountNotScannedImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCountNotScannedImageResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCountNotScannedImage',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCountNotScannedImageResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_count_not_scanned_image_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCountNotScannedImageResponse:
        """
        @summary Queries the number of images that are not scanned.
        
        @param request: DescribeCountNotScannedImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCountNotScannedImageResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCountNotScannedImage',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCountNotScannedImageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_count_not_scanned_image(self) -> sas_20181203_models.DescribeCountNotScannedImageResponse:
        """
        @summary Queries the number of images that are not scanned.
        
        @return: DescribeCountNotScannedImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_count_not_scanned_image_with_options(runtime)

    async def describe_count_not_scanned_image_async(self) -> sas_20181203_models.DescribeCountNotScannedImageResponse:
        """
        @summary Queries the number of images that are not scanned.
        
        @return: DescribeCountNotScannedImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_count_not_scanned_image_with_options_async(runtime)

    def describe_count_scanned_image_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCountScannedImageResponse:
        """
        @summary Queries the number of images that are scanned.
        
        @param request: DescribeCountScannedImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCountScannedImageResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCountScannedImage',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCountScannedImageResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_count_scanned_image_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCountScannedImageResponse:
        """
        @summary Queries the number of images that are scanned.
        
        @param request: DescribeCountScannedImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCountScannedImageResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCountScannedImage',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCountScannedImageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_count_scanned_image(self) -> sas_20181203_models.DescribeCountScannedImageResponse:
        """
        @summary Queries the number of images that are scanned.
        
        @return: DescribeCountScannedImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_count_scanned_image_with_options(runtime)

    async def describe_count_scanned_image_async(self) -> sas_20181203_models.DescribeCountScannedImageResponse:
        """
        @summary Queries the number of images that are scanned.
        
        @return: DescribeCountScannedImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_count_scanned_image_with_options_async(runtime)

    def describe_criteria_with_options(
        self,
        request: sas_20181203_models.DescribeCriteriaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCriteriaResponse:
        """
        @summary Queries the filter conditions that are used to search for assets in fuzzy match mode.
        
        @param request: DescribeCriteriaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCriteriaResponse
        """
  