# carbon3d-client
Welcome to the Carbon DLS API docs!

You can find all relevant documentation here: https://github.com/carbon3d/carbon3d-api


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.3.5
- Package version: 0.3.5
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.carbon3d.com](https://www.carbon3d.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import carbon3d
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import carbon3d
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import carbon3d
from carbon3d.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.carbon3d.com/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = carbon3d.Configuration(
    host = "https://api.carbon3d.com/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): bearerAuth
configuration = carbon3d.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with carbon3d.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = carbon3d.ApplicationsApi(api_client)
    
    try:
        # Fetch all applications summary
        api_response = api_instance.get_applications()
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ApplicationsApi->get_applications: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://api.carbon3d.com/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApplicationsApi* | [**get_applications**](docs/ApplicationsApi.md#get_applications) | **GET** /applications | Fetch all applications summary
*AttachmentsApi* | [**get_attachment**](docs/AttachmentsApi.md#get_attachment) | **GET** /attachments/{uuid} | Download a file attachment
*BuildsApi* | [**get_build**](docs/BuildsApi.md#get_build) | **GET** /builds/{uuid} | Fetch a build
*BuildsApi* | [**get_builds**](docs/BuildsApi.md#get_builds) | **GET** /builds | Fetch builds
*ModelsApi* | [**get_model**](docs/ModelsApi.md#get_model) | **GET** /models/{uuid} | Get a model by UUID
*ModelsApi* | [**get_models**](docs/ModelsApi.md#get_models) | **GET** /models | Fetch models
*ModelsApi* | [**upload_model**](docs/ModelsApi.md#upload_model) | **POST** /models | Upload a model
*PartMeasurementTemplatesApi* | [**get_part_measurement_templates**](docs/PartMeasurementTemplatesApi.md#get_part_measurement_templates) | **GET** /part_measurement_templates | Fetch part measurement templates
*PartMeasurementsApi* | [**get_part_measurements**](docs/PartMeasurementsApi.md#get_part_measurements) | **GET** /part_measurements | Fetch printed part measurements
*PartOrdersApi* | [**create_part_order**](docs/PartOrdersApi.md#create_part_order) | **POST** /part_orders | Create a PartOrder
*PartOrdersApi* | [**delete_part_order**](docs/PartOrdersApi.md#delete_part_order) | **DELETE** /part_orders/{uuid} | Cancel a PartOrder
*PartOrdersApi* | [**get_part_order**](docs/PartOrdersApi.md#get_part_order) | **GET** /part_orders/{uuid} | Get a PartOrder
*PartOrdersApi* | [**get_part_orders**](docs/PartOrdersApi.md#get_part_orders) | **GET** /part_orders | Fetch part orders
*PartOrdersApi* | [**update_part_order**](docs/PartOrdersApi.md#update_part_order) | **PATCH** /part_orders/{uuid} | Update a PartOrder
*PartsApi* | [**create_part**](docs/PartsApi.md#create_part) | **POST** /parts | Create a Part
*PartsApi* | [**get_part**](docs/PartsApi.md#get_part) | **GET** /parts/{uuid} | Fetch a Part
*PartsApi* | [**get_parts**](docs/PartsApi.md#get_parts) | **GET** /parts | Fetch parts
*PrintOrdersApi* | [**create_print_order**](docs/PrintOrdersApi.md#create_print_order) | **POST** /print_orders | Create a PrintOrder
*PrintOrdersApi* | [**get_print_order**](docs/PrintOrdersApi.md#get_print_order) | **GET** /print_orders/{uuid} | Get a PrintOrder
*PrintOrdersApi* | [**get_print_orders**](docs/PrintOrdersApi.md#get_print_orders) | **GET** /print_orders | Fetch print orders
*PrintOrdersApi* | [**update_print_order**](docs/PrintOrdersApi.md#update_print_order) | **PATCH** /print_orders/{uuid} | Update a PrintOrder
*PrintedPartsApi* | [**get_printed_part**](docs/PrintedPartsApi.md#get_printed_part) | **GET** /printed_parts/{uuid} | Fetch a printed Part
*PrintedPartsApi* | [**get_printed_parts**](docs/PrintedPartsApi.md#get_printed_parts) | **GET** /printed_parts | Fetch printed parts
*PrintersApi* | [**get_printer**](docs/PrintersApi.md#get_printer) | **GET** /printers/{serial} | Get a specific printer&#39;s status information
*PrintersApi* | [**get_printers**](docs/PrintersApi.md#get_printers) | **GET** /printers | Fetch all printer&#39;s status information
*PrintsApi* | [**get_prints**](docs/PrintsApi.md#get_prints) | **GET** /prints | List finished prints information
*QueuesApi* | [**get_printer_queues**](docs/QueuesApi.md#get_printer_queues) | **GET** /printers/queues | Fetch all printers&#39; queues
*QueuesApi* | [**update_printer_queue**](docs/QueuesApi.md#update_printer_queue) | **PATCH** /printers/queues | Update a Printer queue


## Documentation For Models

 - [Application](docs/Application.md)
 - [ApplicationsResponse](docs/ApplicationsResponse.md)
 - [Build](docs/Build.md)
 - [BuildAttachments](docs/BuildAttachments.md)
 - [BuildPartOrders](docs/BuildPartOrders.md)
 - [BuildsResponse](docs/BuildsResponse.md)
 - [Model](docs/Model.md)
 - [ModelPrint](docs/ModelPrint.md)
 - [ModelsResponse](docs/ModelsResponse.md)
 - [Part](docs/Part.md)
 - [PartMeasurement](docs/PartMeasurement.md)
 - [PartMeasurementResponse](docs/PartMeasurementResponse.md)
 - [PartMeasurementTemplate](docs/PartMeasurementTemplate.md)
 - [PartMeasurementTemplateCategoryOptions](docs/PartMeasurementTemplateCategoryOptions.md)
 - [PartMeasurementTemplateResponse](docs/PartMeasurementTemplateResponse.md)
 - [PartOrder](docs/PartOrder.md)
 - [PartOrderRequest](docs/PartOrderRequest.md)
 - [PartOrderRequestParts](docs/PartOrderRequestParts.md)
 - [PartOrderStatus](docs/PartOrderStatus.md)
 - [PartOrderUpdateRequest](docs/PartOrderUpdateRequest.md)
 - [PartOrdersResponse](docs/PartOrdersResponse.md)
 - [PartOrdersResponsePartOrders](docs/PartOrdersResponsePartOrders.md)
 - [PartRequest](docs/PartRequest.md)
 - [PartsResponse](docs/PartsResponse.md)
 - [PrintConfig](docs/PrintConfig.md)
 - [PrintFeedback](docs/PrintFeedback.md)
 - [PrintMetrics](docs/PrintMetrics.md)
 - [PrintOrder](docs/PrintOrder.md)
 - [PrintOrderRequest](docs/PrintOrderRequest.md)
 - [PrintOrderRoutedTo](docs/PrintOrderRoutedTo.md)
 - [PrintOrderUpdateRequest](docs/PrintOrderUpdateRequest.md)
 - [PrintOrdersResponse](docs/PrintOrdersResponse.md)
 - [PrintOrigin](docs/PrintOrigin.md)
 - [PrintRef](docs/PrintRef.md)
 - [PrintedPart](docs/PrintedPart.md)
 - [PrintedPartRef](docs/PrintedPartRef.md)
 - [PrintedPartStatus](docs/PrintedPartStatus.md)
 - [PrintedPartTags](docs/PrintedPartTags.md)
 - [PrintedPartsResponse](docs/PrintedPartsResponse.md)
 - [Printer](docs/Printer.md)
 - [PrinterPrints](docs/PrinterPrints.md)
 - [PrinterQueue](docs/PrinterQueue.md)
 - [PrinterQueueDeleteRequest](docs/PrinterQueueDeleteRequest.md)
 - [PrinterQueueMoveRequest](docs/PrinterQueueMoveRequest.md)
 - [PrinterQueueUpdateResponse](docs/PrinterQueueUpdateResponse.md)
 - [PrinterQueuesResponse](docs/PrinterQueuesResponse.md)
 - [PrinterStatus](docs/PrinterStatus.md)
 - [PrintersResponse](docs/PrintersResponse.md)
 - [PrintsResponse](docs/PrintsResponse.md)


## Documentation For Authorization


## bearerAuth

- **Type**: Bearer authentication (JWT)


## Author

api-list@carbon3d.com


