from .base_model import *


class HltCallDoctor(BaseModel):
    id = models.AutoField(db_column='CallDoctorID', primary_key=True)
    lpu_doctor = models.ForeignKey('HltLpuDoctor', models.DO_NOTHING, related_name='+', db_column='rf_LPUDoctorID')
    mkab = models.ForeignKey('HltMkab', models.DO_NOTHING, related_name='+', db_column='rf_MKABID')
    address = models.CharField(db_column='Address', max_length=200)
    complaint = models.CharField(db_column='Complaint', max_length=500)
    date_call = models.DateTimeField(db_column='DateCall')
    status = models.ForeignKey('HltCallDoctorStatus', models.DO_NOTHING, related_name='+', db_column='rf_CallDoctorStatusID')
    is_finalize = models.BooleanField(db_column='isFinalize')
    date_finalize = models.DateTimeField(db_column='DateFinalize')
    tap = models.ForeignKey('HltTap', models.DO_NOTHING, related_name='+', db_column='rf_TAPID')
    code_domophon = models.CharField(db_column='CodeDomophon', max_length=20)
    phone = models.CharField(db_column='Phone', max_length=25)
    finalize_lpu_doctor = models.ForeignKey('HltLpuDoctor', models.DO_NOTHING, related_name='+', db_column='Rf_FinalizeLPUDoctorID')
    description = models.CharField(db_column='Description', max_length=100)
    type_call_doctor = models.ForeignKey('HltTypeCallDoctor', models.DO_NOTHING, related_name='+', db_column='rf_TypeCallDoctorID')
    entrance = models.IntegerField(db_column='Entrance')
    floor = models.IntegerField(db_column='Floor')
    rf_address = models.ForeignKey('KlaAddress', models.DO_NOTHING, related_name='+', db_column='rf_AddressID')
    doc_prvd = models.ForeignKey('HltDocPrvd', models.DO_NOTHING, '+', db_column='rf_DocPRVDID')
    finalize_doc_prvd = models.ForeignKey('HltDocPrvd', models.DO_NOTHING, '+', db_column='rf_FinalizeDocPRVDID')
    date_visit = models.DateTimeField(db_column='DateVisit')
    guid = models.CharField(db_column='GUID', max_length=36)
    lpu = models.ForeignKey('OmsLpu', models.DO_NOTHING, related_name='+', db_column='rf_LPUID')
    source_dvt = models.IntegerField(db_column='SourceDvt')
    birth_date = models.DateTimeField(db_column='BirthDate')
    date_status = models.DateTimeField(db_column='DateStatus')
    family = models.CharField(db_column='Family', max_length=40)
    name = models.CharField(db_column='Name', max_length=40)
    number_pol = models.CharField(db_column='NumberPol', max_length=50)
    ot = models.CharField(db_column='Ot', max_length=40)
    rf_kl_sexid = models.IntegerField(db_column='rf_kl_SexID')
    mkb = models.ForeignKey('OmsMkb', models.DO_NOTHING, related_name='+', db_column='rf_MKBID')
    series_pol = models.CharField(db_column='SeriesPol', max_length=50)
    cause_cancel = models.TextField(db_column='CauseCancel')
    source_smp = models.TextField(db_column='SourceSmp')
    call_family = models.CharField(db_column='Call_Family', max_length=40)
    call_name = models.CharField(db_column='Call_Name', max_length=40)
    call_patronymic = models.CharField(db_column='Call_Patronymic', max_length=40)
    rf_call_person_type_id = models.IntegerField(db_column='rf_CallPersonTypeID')
    age = models.IntegerField(db_column='Age')
    age_title = models.IntegerField(db_column='AgeTitle')
    date_active = models.DateTimeField(db_column='DateActive')
    date_resolved = models.DateTimeField(db_column='DateResolved')
    is_child = models.BooleanField(db_column='isChild')
    is_notification = models.BooleanField(db_column='IsNotification')
    uchastok = models.ForeignKey('HltUchastok', models.DO_NOTHING, related_name='+', db_column='rf_UchastokID')
    age_group = models.ForeignKey('OmsKlAgeGroup', models.DO_NOTHING, related_name='+', db_column='rf_kl_AgeGroupID')
    rf_call_cancel_reason_id = models.IntegerField(db_column='rf_CallCancelReasonID')
    is_sent_to_doctor = models.BooleanField(db_column='IsSentToDoctor')

    flags = models.IntegerField(db_column='Flags')

    class Meta:
        managed = False
        db_table = 'hlt_CallDoctor'
