# Generated by Django 3.2.7 on 2021-09-30 16:41

import uuid

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Flow",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "workflow_name",
                    models.CharField(
                        choices=[("dummy", "Dummy")],
                        max_length=255,
                        verbose_name="Select workflow",
                    ),
                ),
                (
                    "flow_name",
                    models.CharField(
                        help_text="e.g. Hire a Python Developer",
                        max_length=255,
                        verbose_name="Select activity",
                    ),
                ),
                ("started", models.DateTimeField(null=True)),
                ("finished", models.DateTimeField(blank=True, null=True)),
                ("flow_info", models.JSONField(default=dict)),
                (
                    "executed_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="TaskRecord",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("uuid", models.UUIDField(default=uuid.uuid4, editable=False)),
                ("started_at", models.DateTimeField(auto_now_add=True)),
                ("finished_at", models.DateTimeField(null=True)),
                ("step_id", models.CharField(max_length=100)),
                ("task_name", models.CharField(max_length=100)),
                ("target", models.CharField(blank=True, max_length=100, null=True)),
                ("task_info", models.JSONField(default=dict)),
                (
                    "executed_by",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "flow",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="tasks",
                        to="django_workflow_engine.flow",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="TaskLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("logged_at", models.DateTimeField(auto_now_add=True)),
                ("message", models.CharField(max_length=255)),
                (
                    "task_record",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="log",
                        to="django_workflow_engine.taskrecord",
                    ),
                ),
            ],
        ),
    ]
