"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.User = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const database_secret_1 = require("./database-secret");
const database_query_1 = require("./private/database-query");
const handler_name_1 = require("./private/database-query-provider/handler-name");
const privileges_1 = require("./private/privileges");
class UserBase extends constructs_1.Construct {
    addTablePrivileges(table, ...actions) {
        if (!this.privileges) {
            this.privileges = new privileges_1.UserTablePrivileges(this, 'TablePrivileges', {
                ...this.databaseProps,
                user: this,
            });
        }
        this.privileges.addPrivileges(table, ...actions);
    }
}
/**
 * A user in a Redshift cluster.
 */
class User extends UserBase {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_redshift_alpha_UserProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, User);
            }
            throw error;
        }
        this.databaseProps = props;
        this.cluster = props.cluster;
        this.databaseName = props.databaseName;
        const username = props.username ?? cdk.Names.uniqueId(this).toLowerCase();
        const secret = new database_secret_1.DatabaseSecret(this, 'Secret', {
            username,
            encryptionKey: props.encryptionKey,
        });
        const attachedSecret = secret.attach(props.cluster);
        this.password = attachedSecret.secretValueFromJson('password');
        this.resource = new database_query_1.DatabaseQuery(this, 'Resource', {
            ...this.databaseProps,
            handler: handler_name_1.HandlerName.User,
            properties: {
                username,
                passwordSecretArn: attachedSecret.secretArn,
            },
        });
        attachedSecret.grantRead(this.resource);
        this.username = this.resource.getAttString('username');
        this.secret = secret;
    }
    /**
     * Specify a Redshift user using credentials that already exist.
     */
    static fromUserAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_redshift_alpha_UserAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromUserAttributes);
            }
            throw error;
        }
        return new class extends UserBase {
            constructor() {
                super(...arguments);
                this.username = attrs.username;
                this.password = attrs.password;
                this.cluster = attrs.cluster;
                this.databaseName = attrs.databaseName;
                this.databaseProps = attrs;
            }
        }(scope, id);
    }
    /**
     * Apply the given removal policy to this resource
     *
     * The Removal Policy controls what happens to this resource when it stops
     * being managed by CloudFormation, either because you've removed it from the
     * CDK application or because you've made a change that requires the resource
     * to be replaced.
     *
     * The resource can be destroyed (`RemovalPolicy.DESTROY`), or left in your AWS
     * account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).
     *
     * This resource is destroyed by default.
     */
    applyRemovalPolicy(policy) {
        this.resource.applyRemovalPolicy(policy);
    }
}
exports.User = User;
_a = JSII_RTTI_SYMBOL_1;
User[_a] = { fqn: "@aws-cdk/aws-redshift-alpha.User", version: "2.64.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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