"use strict";
// @see https://docs.github.com/en/actions/reference/workflow-syntax-for-github-actions
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobPermission = void 0;
/**
 * Access level for workflow permission scopes.
 */
var JobPermission;
(function (JobPermission) {
    /** Read-only access */
    JobPermission["READ"] = "read";
    /** Read-write access */
    JobPermission["WRITE"] = "write";
    /** No access at all */
    JobPermission["NONE"] = "none";
})(JobPermission = exports.JobPermission || (exports.JobPermission = {}));
//#endregion
//# sourceMappingURL=data:application/json;base64,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