# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ghc']

package_data = \
{'': ['*'], 'ghc': ['templates/*']}

install_requires = \
['Jinja2>=2.11.2,<3.0.0', 'requests>=2.24.0,<3.0.0']

entry_points = \
{'console_scripts': ['ghc = ghc.ghc:main']}

setup_kwargs = {
    'name': 'ghc',
    'version': '0.1.5',
    'description': 'List up GitHub user / org repositories filtered by topics (ghc = GitHub Collector)',
    'long_description': '# ghc (GitHub Collector)\n\n![PyPI](https://img.shields.io/pypi/v/ghc)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/ghc)\n![GitHub](https://img.shields.io/github/license/homoluctus/ghc)\n\nList up GitHub user / org repositories filtered by topics\n\n<!-- TOC depthFrom:2 -->\n\n- [Feature](#feature)\n- [Installtion](#installtion)\n- [Usage](#usage)\n- [Examples](#examples)\n  - [Output JSON](#output-json)\n  - [Output Markdown](#output-markdown)\n  - [Use GHC_TOKEN instead of --token option](#use-ghc_token-instead-of---token-option)\n- [Roadmap](#roadmap)\n\n<!-- /TOC -->\n\n## Feature\n\n- List up GitHub org repositories\n  - filtered by topics\n- Support several formats\n  - JSON\n  - Markdown\n- Output the results to stdout or file\n\n## Installtion\n\n```bash\npip install ghc\n```\n\n## Usage\n\n```\nusage: ghc [-h] [--token TOKEN] [-t [TOPICS [TOPICS ...]]] [-f {json,md}] [-o FILENAME] [-V] owner\n\nList up GitHub user / org repositories filtered by topics\n\npositional arguments:\n  owner                 Repository user or organization name to search\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --token TOKEN         Personal Access Token to access the private repository. Use the environment variable "GHC_TOKEN" instead.\n  -t [TOPICS [TOPICS ...]], --topics [TOPICS [TOPICS ...]]\n                        Filter repository using topics\n  -f {json,md}, --format {json,md}\n                        Format the results with json or md (markdown). Default is json\n  -o FILENAME, --output FILENAME\n                        Filename to output the results. Output stdout if not specified\n  -V, --version         Show command version\n```\n\n## Examples\n\n### Output JSON\n\n```bash\nghc homoluctus --token xxxxxxxx -f json -t python\n```\n\n<details>\n<summary>Result</summary>\n\n```json\n{\n  "count": 11,\n  "repositories": [\n    {\n      "description": null,\n      "is_archive": false,\n      "is_template": false,\n      "language": "Python",\n      "language_logo_url": "https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png",\n      "name": "algorithms",\n      "url": "https://github.com/homoluctus/algorithms"\n    },\n    {\n      "description": "Sample for logging decorator",\n      "is_archive": false,\n      "is_template": false,\n      "language": "Python",\n      "language_logo_url": "https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png",\n      "name": "decolog",\n      "url": "https://github.com/homoluctus/decolog"\n    },\n    {\n      "description": "This tool helps to migrate DynamoDB to MySQL",\n      "is_archive": false,\n      "is_template": false,\n      "language": "Python",\n      "language_logo_url": "https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png",\n      "name": "dymy",\n      "url": "https://github.com/homoluctus/dymy"\n    },\n    {\n      "description": "Scan the vulnerability of Docker images stored in ECR",\n      "is_archive": false,\n      "is_template": false,\n      "language": "Python",\n      "language_logo_url": "https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png",\n      "name": "ecranner",\n      "url": "https://github.com/homoluctus/ecranner"\n    },\n    {\n      "description": "List up GitHub user / org repositories filtered by topics (ghc = GitHub Collector)",\n      "is_archive": false,\n      "is_template": false,\n      "language": "Python",\n      "language_logo_url": "https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png",\n      "name": "ghc",\n      "url": "https://github.com/homoluctus/ghc"\n    },\n    {\n      "description": "Python logging outputs as JSON",\n      "is_archive": false,\n      "is_template": false,\n      "language": "Python",\n      "language_logo_url": "https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png",\n      "name": "json-pyformatter",\n      "url": "https://github.com/homoluctus/json-pyformatter"\n    },\n    {\n      "description": "Analysis tool for Postfix log in /var/log/maillog",\n      "is_archive": false,\n      "is_template": false,\n      "language": "Python",\n      "language_logo_url": "https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png",\n      "name": "maillogger",\n      "url": "https://github.com/homoluctus/maillogger"\n    },\n    {\n      "description": "Notify today\'s wether information",\n      "is_archive": false,\n      "is_template": false,\n      "language": "Python",\n      "language_logo_url": "https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png",\n      "name": "ohtenki",\n      "url": "https://github.com/homoluctus/ohtenki"\n    },\n    {\n      "description": "Audit action for python dependencies (requirements.txt, Pipfile and poetry.lock)",\n      "is_archive": false,\n      "is_template": false,\n      "language": "Shell",\n      "language_logo_url": null,\n      "name": "pip-audit-action",\n      "url": "https://github.com/homoluctus/pip-audit-action"\n    },\n    {\n      "description": "The CLI tool to query AWS CloudWatch Logs Insights :mag:",\n      "is_archive": false,\n      "is_template": false,\n      "language": "Python",\n      "language_logo_url": "https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png",\n      "name": "pyinsights",\n      "url": "https://github.com/homoluctus/pyinsights"\n    },\n    {\n      "description": "GitHub template for Python3.8",\n      "is_archive": false,\n      "is_template": true,\n      "language": "Makefile",\n      "language_logo_url": null,\n      "name": "python-template",\n      "url": "https://github.com/homoluctus/python-template"\n    }\n  ]\n}\n```\n\n</details>\n\n### Output Markdown\n\n\n```bash\nnghc homoluctus --token xxxxxxx -f md -t python\n```\n\n<details>\n<summary>Result (Raw)</summary>\n\n```markdown\n# Repositories\n\nTotal Count: 11\n\n|Name|URL|Language|Description|\n|:--:|:--:|:--:|:--|\n|algorithms|https://github.com/homoluctus/algorithms|![Python](https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png)|None|\n|decolog|https://github.com/homoluctus/decolog|![Python](https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png)|Sample for logging decorator|\n|dymy|https://github.com/homoluctus/dymy|![Python](https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png)|This tool helps to migrate DynamoDB to MySQL|\n|ecranner|https://github.com/homoluctus/ecranner|![Python](https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png)|Scan the vulnerability of Docker images stored in ECR|\n|ghc|https://github.com/homoluctus/ghc|![Python](https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png)|List up GitHub user / org repositories filtered by topics (ghc = GitHub Collector)|\n|json-pyformatter|https://github.com/homoluctus/json-pyformatter|![Python](https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png)|Python logging outputs as JSON|\n|maillogger|https://github.com/homoluctus/maillogger|![Python](https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png)|Analysis tool for Postfix log in /var/log/maillog|\n|ohtenki|https://github.com/homoluctus/ohtenki|![Python](https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png)|Notify today&#39;s wether information|\n|pip-audit-action|https://github.com/homoluctus/pip-audit-action|Shell|Audit action for python dependencies (requirements.txt, Pipfile and poetry.lock)|\n|pyinsights|https://github.com/homoluctus/pyinsights|![Python](https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png)|The CLI tool to query AWS CloudWatch Logs Insights :mag:|\n|python-template ![template](https://img.shields.io/badge/template-green.svg)|https://github.com/homoluctus/python-template|Makefile|GitHub template for Python3.8|\n\n> Generated by [ghc](https://github.com/homoluctus/ghc)\n\n```\n\n</details>\n\n<details>\n<summary>Result</summary>\n\n# Repositories\n\nTotal Count: 11\n\n|Name|URL|Language|Description|\n|:--:|:--:|:--:|:--|\n|algorithms|https://github.com/homoluctus/algorithms|![Python](https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png)|None|\n|decolog|https://github.com/homoluctus/decolog|![Python](https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png)|Sample for logging decorator|\n|dymy|https://github.com/homoluctus/dymy|![Python](https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png)|This tool helps to migrate DynamoDB to MySQL|\n|ecranner|https://github.com/homoluctus/ecranner|![Python](https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png)|Scan the vulnerability of Docker images stored in ECR|\n|ghc|https://github.com/homoluctus/ghc|![Python](https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png)|List up GitHub user / org repositories filtered by topics (ghc = GitHub Collector)|\n|json-pyformatter|https://github.com/homoluctus/json-pyformatter|![Python](https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png)|Python logging outputs as JSON|\n|maillogger|https://github.com/homoluctus/maillogger|![Python](https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png)|Analysis tool for Postfix log in /var/log/maillog|\n|ohtenki|https://github.com/homoluctus/ohtenki|![Python](https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png)|Notify today&#39;s wether information|\n|pip-audit-action|https://github.com/homoluctus/pip-audit-action|Shell|Audit action for python dependencies (requirements.txt, Pipfile and poetry.lock)|\n|pyinsights|https://github.com/homoluctus/pyinsights|![Python](https://cdn.jsdelivr.net/npm/programming-languages-logos/src/python/python_24x24.png)|The CLI tool to query AWS CloudWatch Logs Insights :mag:|\n|python-template ![template](https://img.shields.io/badge/template-green.svg)|https://github.com/homoluctus/python-template|Makefile|GitHub template for Python3.8|\n\n> Generated by [ghc](https://github.com/homoluctus/ghc)\n\n</details>\n\n### Use GHC_TOKEN instead of --token option\n\n```bash\nGHC_TOKEN=xxxxxxxx ghc homoluctus -f json -t python aws\n```\n\n## Roadmap\n\n- [ ] Ignore filter\n- [ ] Output to user-defined template\n',
    'author': 'homoluctus',
    'author_email': 'w.slife18sy@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/homoluctus/ghc',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
