"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasOutput = exports.findOutputs = void 0;
const section_1 = require("./section");
function findOutputs(template, logicalId, props = {}) {
    var _a;
    const section = (_a = template.Outputs) !== null && _a !== void 0 ? _a : {};
    const result = section_1.matchSection(section_1.filterLogicalId(section, logicalId), props);
    if (!result.match) {
        return {};
    }
    return result.matches;
}
exports.findOutputs = findOutputs;
function hasOutput(template, logicalId, props) {
    var _a;
    const section = (_a = template.Outputs) !== null && _a !== void 0 ? _a : {};
    const result = section_1.matchSection(section_1.filterLogicalId(section, logicalId), props);
    if (result.match) {
        return;
    }
    if (result.closestResult === undefined) {
        return `No outputs named ${logicalId} found in the template (found: ${Object.keys(section).join(', ')})`;
    }
    return [
        `Template has ${result.analyzedCount} outputs named ${logicalId}, but none match as expected.`,
        section_1.formatFailure(result.closestResult),
    ].join('\n');
}
exports.hasOutput = hasOutput;
//# sourceMappingURL=data:application/json;base64,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