# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['castanet']

package_data = \
{'': ['*']}

install_requires = \
['libcst>=0.4.0,<0.5.0',
 'prettyprint>=0.1.5,<0.2.0',
 'typer[all]>=0.4.0,<0.5.0']

entry_points = \
{'console_scripts': ['castanet = main:app']}

setup_kwargs = {
    'name': 'castanet',
    'version': '1.2.0',
    'description': 'Program to identify different syntax markers in Python programs',
    'long_description': "# CASTanet\n\n## Table of Contents\n\n* [About CASTanet](#about-castanet)\n\n* [Installing CASTanet](#installing-castanet)\n\n* [Running CASTanet](#running-castanet)\n\n* [CASTanet's Command Line Interface](#castanets-command-line-interface)\n\n* [Testing](#testing)\n\n* [Contributions](#contributions)\n\n* [Contact Us](#contact-us)\n\n## About CASTanet\n\nCASTanet is a tool created by students at\nAllegheny College, allowing users to understand\nthe contents of Python (`.py`) files. Through\nusing concrete abstract syntax trees (CASTs), a\ncombination of abstract syntax trees (ASTs) and\nconcrete syntax trees (CSTs), CASTanet uses\n`LibCST` to reorganize and name node types and\nfields. CASTanet has functionality to iterate\nthrough a user-specified directory and generate\nmetrics associated with the Python files in that\ngiven directory. This tool can be used by\neducators interested in evaluating students'\ncode, or individual developers who would like to\nbetter understand their own implementation\nstrategies.\n\nCurrently, CASTanet is able to count:\n\n* Number of if statements in a Python file (and\ntotal in directory)\n* Number of looping constructs in a Python file\n(and total in directory)\n* Number of comments in a Python file (and total\nin directory)\n* Number of arguments for a specified Python function\n* Number of functions in a specified Python file (and total\nin directory)\n* Number of function definitions _without_\ndocstrings in a Python file (and total in\ndirectory)\n* Number of classes in a Python file (and total in directory)\n* Number of class definitions _without_ docstrings in a\nPython file (and total in directory)\n* Number of assignment statements in a Python file (and\ntotal in directory)\n* Whether a specified function has a docstring or not\n* Number of import statements in a Python file (and total in\ndirectory)\n\n## Installing CASTanet - PyPI\n\nRun the command to install: `pip install castanet`\n\n## Installing CASTanet - Repository\n\n### Clone the CASTanet repository onto your machine\n\nIn the appropriate directory, clone the CASTanet\nrepository following GitFlow and the GitHub\n[documentation](https://docs.github.com/en/repositories/creating-and-managing-repositories/cloning-a-repository)\n\n### Install Poetry and dependencies\n\nThe documentation and instructions on installing _Poetry_ can be found [here.](https://python-poetry.org/docs/)\n\n_Poetry_ allows dependency installation with\nease. After\ncloning the CASTanet\nrepository, and installing _Poetry_, install all\nnecessary dependencies for the tool with the\ncommand:\n\n`poetry install`\n\n## Running CASTanet\n\nCASTanet is a fully-functional tool with a dynamic command\nline interface,\nbuilt with the user in mind. To run the CASTanet CLI, in the\nbase directory of your local, cloned\nrepository and type the command:\n\n```python\ncastanet [command-here]\n```\n\nWithout specifying a command, you will receive this error in\nyour terminal:\n\n```python\nUsage: castanet [OPTIONS] COMMAND [ARGS]...\nTry 'castanet --help' for help.\n\nError: Missing command.\n```\n\nPlease refer to the next section to see what functionality\nCASTanet has, and what commands to run.\n\n### CASTanet's Command Line Interface\n\nCASTanet's command line interface is created with\n[Typer](https://typer.tiangolo.com/),\na library for building CLI applications based\non Python 3.6+ type hints.\n\nIn order to familiarize yourself with the commands for\nCASTanet, run the command: `poetry run castanet --help`\n\n**CASTanet's commands are as follows:**\n\nPLEASE NOTE: Each of the following commands must be run with\nthe **file path** of the directory of interest given as\ninput. This directory must be present on your\nmachine, and CASTanet will provide output pertaining to this\nspecified directory.\n\n## `castanet assignments`\n\nDetermine number of assignment statements.\n\n**Usage**:\n\n```console\ncastanet assignment [OPTIONS] PATH\n```\n\n**Arguments**:\n\n* `PATH`: [required]\n\n## `castanet total-classes`\n\nDetermine number of classes without docstrings.\n\n**Usage**:\n\n```console\ncastanet total-classes [OPTIONS] PATH\n```\n\n**Arguments**:\n\n* `PATH`: [required]\n\n## `castanet classes-without-docstrings`\n\nDetermine number of classes without docstrings.\n\n**Usage**:\n\n```console\ncastanet classes-without-docstrings [OPTIONS] PATH\n```\n\n**Arguments**:\n\n* `PATH`: [required]\n\n## `castanet comments`\n\nDetermine number of comments.\n\n**Usage**:\n\n```console\ncastanet comments [OPTIONS] PATH\n```\n\n**Arguments**:\n\n* `PATH`: [required]\n  \n## `castanet function-arguments`\n\nDetermine the number of parameters for a given function.\n\n**Usage**:\n\n```console\ncastanet function-arguments [OPTIONS] PATH FUNCTION_NAME\n```\n\n**Arguments**:\n\n* `PATH`: [required]\n* `FUNCTION_NAME`: [required]\n  \n## `castanet function-docstring-exists`\n\nDetermine if a given function has a docstring.\n\n**Usage**:\n\n```console\ncastanet function-docstring-exists [OPTIONS] PATH FUNCTION_NAME\n```\n\n**Arguments**:\n\n* `PATH`: [required]\n* `FUNCTION_NAME`: [required]\n\n## `castanet functions-without-docstrings`\n\nDetermine number of functions without docstrings.\n\n**Usage**:\n\n```console\ncastanet functions-without-docstrings [OPTIONS] PATH\n```\n\n**Arguments**:\n\n* `PATH`: [required]\n\n## `castanet if-statements`\n\nDetermine number of if statements in a Python directory.\n\n**Usage**:\n\n```console\ncastanet if-statements [OPTIONS] PATH\n```\n\n**Arguments**:\n\n* `PATH`: [required]\n\n## `castanet imports`\n\nDetermine number of import statements.\n\n**Usage**:\n\n```console\ncastanet imports [OPTIONS] PATH\n```\n\n**Arguments**:\n\n* `PATH`: [required]\n\n## `castanet looping-constructs`\n\nDetermine number of looping constructs.\n\n**Usage**:\n\n```console\ncastanet looping-constructs [OPTIONS] PATH\n```\n\n**Arguments**:\n\n* `PATH`: [required]\n\n## `castanet functions-per-module`\n\nDetermine number of functions in a Python directory.\n\n**Usage**:\n\n```console\ncastanet functions-per-module [OPTIONS] PATH\n```\n\n**Arguments**:\n\n* `PATH`: [required]\n\n## `castanet total-functions`\n\nDetermine total number of functions in a Python directory.\n\n**Usage**:\n\n```console\ncastanet total-functions [OPTIONS] PATH\n```\n\n**Arguments**:\n\n* `PATH`: [required]\n\nCurrently, CASTanet only has functionality\nfor _one_ metric to be calculated at a time.\nAs a result, if you are interested in one or\nmore metric, you must run CASTanet for the first metric\n(with the corresponding CLI command),\nand then run CASTanet subsequently for\neach additional metric (with the corresponding CLI command).\n\n### CASTanet as a Python Library\n\nCASTanet is also available on PyPI to be used as a Python\nlibrary. Find it [here](https://pypi.org/project/castanet/).\nWith the CASTanet library, a user is able to investigate\ntheir Python files with many different function calls.\nSpecifically, CASTanet is broken down into two parts:\n\n1. `generate_trees`: Traverses a directory and generates\nconcrete-abstract-syntax trees of Python files using\nLibCST\n1. `counter`: Uses concrete-abstract-syntax-trees to\ncalculate metrics associated with the contents of a Python\nmodule\n\n### counter\n\n`from castanet import counter`\n\n#### sum_dict_vals\n\nCalculate the sums of values from dictionaries.\nCalled to get number values from the result of a\nfunction. Must always be run on the results of\n`count` functions to get final numbers.\n\n`counter.sum_dict_vals(values_dict)`\n\n_ARGUMENTS:_\n\n* values_dict: dictionary of total values for metrics\n\n_RETURNS:_\n\n* int: total number of items in dictionary\n\n#### count_imports\n\nCount the number of import statements in a Python file.\n\n`counter.count_imports(path)`\n\n_ARGUMENTS:_\n  \n* path: A string path corresponding to a Python file or a directory\n\n_RETURNS:_\n\n* dict: files and the corresponding amount of import statements\n\n#### count_functions\n\nCount the number of function definitions in a Python file.\n\n`counter.count_functions(path)`\n\n_ARGUMENTS:_\n\n* path: A string path corresponding to a Python file or a directory\n\n_RETURNS:_\n\n*dict: files and the corresponding amount of function definitions\n\n#### count_comments\n\nCount the number of comments in a Python file.\n\n`counter.count_comments(path)`\n\n_ARGUMENTS:_\n\n* path: A string path corresponding to a Python file or a directory\n\n_RETURNS:_\n\n* dict: files and the corresponding amount of comments\n\n#### count_while_loops\n\nCount the number of while loops in a Python file.\n\n`counter.count_while_loops(path)`\n\n_ARGUMENTS:_\n\n* path: A string path corresponding to a Python file or a directory\n\n_RETURNS:_\n  \n* dict: files and the corresponding amount of while loops\n\n#### count_for_loops\n\nCount the number of for loops in a Python file.\n\n`counter.count_for_loops(path)`\n\n_ARGUMENTS:_\n\n* path: A string path corresponding to a Python file or a directory\n\n_RETURNS:_\n\n* dict: files and the corresponding amount of for loops\n\n#### count_if_statements\n\nCount the number of if statements in a Python file.\n\n`counter.count_if_statements(path)`\n\n_ARGUMENTS:_\n\n* path: A string path corresponding to a Python file or a directory\n\n_RETURNS:_\n\n* dict: files and the corresponding amount of if statements\n\n#### count_func_defs\n\nCount the number of function definitions in a Python file.\n\n`counter.count_func_defs(path)`\n\n_ARGUMENTS:_\n\n* path: A string path corresponding to a Python file or a directory\n\n_RETURNS:_\n\n* dict: files and the corresponding amount of function_definitions\n\n#### count_function_without_docstrings\n\nCount the number of functions without docstrings.\n\n`counter.count_function_without_docstrings(func_count)`\n\n_ARGUMENTS:_\n\n* dict: A dictionary of functions and docstring counts per file\n\n_RETURNS:_\n\n* int: total number of functions - total number of docstrings\n\n*Note:* It is required to first call `count_func_defs` in\norder for this function call to work correctly.\n\n#### docstring_exists\n\nDetermine if a docstring exists for a specified function.\n\n`counter.docstring_exists(path, function_name)`\n\n_ARGUMENTS:_\n\n* path: A string path corresponding to a Python file or a directory\n* function_name (str): Name of function to check for docstrings\n\n_RETURNS:_\n\n* -1: function does not exist\n* 0: function exists without docstring\n* 1: function exists with docstring\n\n#### match_class_defs\n\nCount the number of class definitions in a Python file.\n\n`counter.count_class_defs(cast_dict)`\n\n_ARGUMENTS:_\n\n* path: A string path corresponding to a Python file or a directory\n\n_RETURNS:_\n\n* dict: files and the corresponding amount of class definitions\n\n#### count_class_defs_without_docstrings\n\nCount the number of class definitions without docstrings.\n\n`counter.count_class_defs_without_docstrings(class_count)`\n\n_ARGUMENTS:_\n\n* dict: A dictionary of classes and docstring counts per file\n\n_RETURNS:_\n\n* int: total number of classes - total number of docstrings\n\n*Note:* It is required to first call `count_class_defs` in\norder for this function call to work correctly.\n\n#### count_function_arguments\n\nCount the number of arguments for a specified function.\n\n`counter.count_function_arguments(path, function_name)`\n\n_ARGUMENTS:_\n\n* path: A string path corresponding to a Python file or a directory\n* function_name: User-specified file of interest\n\n_RETURNS:_\n\n* -1: Function was not found\n* else: The amount of parameters for the given function\n\n#### count_assignments\n\nCount the number of assignment statements in a Python file.\n\n(does not include augmented assignment)\n\n`counter.count_assignments(path)`\n\n_ARGUMENTS:_\n\n* path: A string path corresponding to a Python file or a directory\n\n_RETURNS:_\n\n* dict: files and the corresponding amount of assignment statements\n\n#### count_aug_assignment\n\nCount the number of aug assignment statements (x += 5) in a Python file.\n\n`counter.count_aug_assignment(path)`\n\n_ARGUMENTS:_\n\n* path: A string path corresponding to a Python file or a directory\n\n_RETURNS:_\n\n* dict: files and the corresponding amount of aug assignment statements\n\n## Testing\n\n### Automated Testing\n\nDevelopers of this program can run the test\nsuite with\n[Pytest](https://docs.pytest.org/en/stable/)\nwith the command:\n\n`poetry run task test`\n\n## Contributions\n\nWe welcome everyone who is interested in helping to improve\nCASTanet!\nIf you are interested in being a contributor, please review\nour\n[Code of Conduct](https://github.com/cmpsc-481-s22-m1/CASTanet/blob/documentation/CODE_OF_CONDUCT.md)\nand\n[Guidelines for Contributors](https://github.com/cmpsc-481-s22-m1/CASTanet/blob/documentation/CONTRIBUTING.md)\nbefore raising an issue, or beginning a contribution.\n\nTo raise an issue in\n[CASTanet's Issue Tracker](https://github.com/cmpsc-481-s22-m1/CASTanet/issues)\nplease follow these templates:\n\n* [bug_report.md](https://github.com/cmpsc-481-s22-m1/CASTanet/blob/documentation/.github/ISSUE_TEMPLATE/bug_report.md)\n\n* [feature_request.md](https://github.com/cmpsc-481-s22-m1/CASTanet/blob/documentation/.github/ISSUE_TEMPLATE/feature_request.md)\n\nTo create a pull request, please follow this template:\n\n* [pull_request_template.md](https://github.com/cmpsc-481-s22-m1/CASTanet/blob/documentation/.github/pull_request_template.md)\n\n## Contact Us\n\nIf you have any questions or concerns about CASTanet, please contact:\n\n* Madelyn Kapfhammer (kapfhammerm@allegheny.edy)\n* Thomas Antle (antlet@allegheny.edu)\n* Nolan Thompson (thompsonn2@allegheny.edu)\n* Caden Hinckley (hinckleyc@allegheny.edu)\n* Bailey Matrascia (matrasciab@allegheny.edu)\n",
    'author': 'Thomas Antle, Caden Hinckley, Maddy Kapfhammer, Bailey Matrascia, Nolan Thompson',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/cmpsc-481-s22-m1/CASTanet',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
