// No idea how to know Lab vs Notebook
// but came up with this simple thing.
try{
  if(window._JUPYTERLAB){
    var lab = true;
  }else{
    var lab = false;
  }
}
catch{
  var lab = false;
}


var widgets = require('@jupyter-widgets/base');
var _ = require('lodash');
var d3 = require("d3");

 var context = require('d3-context-menu');

 require('d3-context-menu/css/d3-context-menu.css');

// CSS Lab reuirements that would otherwise break Notebook.
if(lab){
  console.log("We in lab!!")
  require('@fortawesome/fontawesome-free/css/all.css');
  
}


var ForceDirectedGraphModel = widgets.DOMWidgetModel.extend({
    defaults: _.extend(widgets.DOMWidgetModel.prototype.defaults(), {
        _model_name : 'ForceDirectedGraphModel',
        _view_name : 'ForceDirectedGraphView',
        _model_module : 'ipyd3',
        _view_module : 'ipyd3',
        _model_module_version : '3.0.0',
        _view_module_version : '3.0.0',
        graph : "",
        label: true,
        floater: true,
        icon: true,
        width:500,
        height:500
    })
});


// Custom View. Renders the widget model.
var ForceDirectedGraphView = widgets.DOMWidgetView.extend({
    // Defines how the widget gets rendered into the DOM
    /**
      nodes:[
        id - id for identifying a node.
        name - name to display that hover on node.
        color - color of node
        radius - radius of node (think of weight it as weight)
        layer - you can put a layer for a node here. there should be a default.

      ]
      links:[
        source - id associated to the node
        target - id associated to the node
        color - color of link
        edge - the two ids connected by a '-'
        weight - width of line
        layer - layer of nodes separated by a -.

      ]
    **/
    render: function() {
        this.expanded = true;
        this.inactive_layer = [];
        this.updated_graph = {};
        this.update_value = true;
        this.hover_focus = true;
        //this.create_style_context();
        this.create_style();
        this.display_graph();

        // Python -> JavaScript update
        this.model.on('change:graph', this.graph_changed, this);
        this.model.on('change:floater', this.floater_changed, this);
        this.model.on('change:label', this.update_graph, this);
        this.model.on('change:icon', this.update_graph, this);

        this.graph_update_binded = this.graph_update.bind(this);

    },

    graph_update: function() {
      this.update_value = !this.update_value;
      var temp = this.update_value;
      this.model.set('graph', {"nodes":this.updated_graph["nodes"], "links":this.updated_graph["links"],  temp:this.update_value });
      this.touch();
    },

    graph_changed: function() {
      let update = this.update_graph.bind(this);
      update();
    },

    create_style: function(){
      var width = this.model.get('width');
      var height = this.model.get('height');

      this.input_div = document.createElement('div');
      this.input_div.id = "input_div_"+this.cid;

      this.el.appendChild(this.input_div);

      // Create our stylesheet
      this.style_input_div = document.createElement('style');
      this.style_input_div.innerHTML =
      '#input_div_'+this.cid+' {' +
          'right:0;' +
          'bottom:0;' +
          'position:absolute;'+
          'display:none;' +
          'background-color: #e5e5e5;'
      '};';

      this.el.appendChild(this.style_input_div)


      this.layer_picker_div = document.createElement('div');
      this.layer_picker_div.id = "layer_picker_div_"+this.cid;

      this.el.appendChild(this.layer_picker_div);

      // Create our stylesheet
      this.style_layer_picker_div = document.createElement('style');
      this.style_layer_picker_div.innerHTML =
      '#layer_picker_div_'+this.cid+' {' +
          'float:left;' +
          'position:absolute;'+
          'width:100px;'+
          'display: inline-block;'+
      '};';

      this.el.appendChild(this.style_layer_picker_div)

      this.floater = document.createElement('div');
      this.floater.id = "floater_"+this.cid;
      this.el.appendChild(this.floater);

      // Create our stylesheet
      this.style = document.createElement('style');
      this.style.innerHTML =
      '#floater_'+this.cid+' {' +
          'border-radius:10px;' +
          'background-color: #e5e5e5;' +
          'height: '+height/4+'px;' +
          'width: '+width/4+'px;' +
          'right:0;' +
          'position:absolute;'+
      '};';

      this.el.appendChild(this.style)

      this.dropdown = document.createElement('div');
      this.dropdown.id = "dropdown_"+this.cid;
      this.dropdown.className = "dropdown";

      this.drop_button = document.createElement('button');
      this.drop_button.id = "dropdownMenuButton_"+this.cid;
      this.drop_button.className = "btn btn-secondary dropdown-toggle";
      this.drop_button.setAttribute("data-toggle","dropdown");
      this.drop_button.innerHTML = "Layer Filter";

      this.form_drop = document.createElement('button');
      this.form_drop.id = "form_drop_"+this.cid;
      this.form_drop.className = "dropdown-menu";
      this.form_drop.setAttribute("style","width:100px")

      // Layer changing function that opens the text box.
      function search_box(){
        function search_graph(){
          this.hover_focus = false;
          var full_graph = this.model.get('graph')
          var graph = this.filter_graph_by_layer(full_graph);
          var id_nodes = []

          graph.nodes.forEach((item, i) => {
            if(item.id.toString().search(this.input_box.value) > -1){
                id_nodes.push(item.id);
            }

          });

          this.node.style("opacity", function(o) {
              return id_nodes.includes(o.id) ? 1 : 0.1;
          });

          this.link.style("opacity", function(o) {
              return  0.1;
          });
        }
        this.input_div.setAttribute("style", "display: block");

        this.input_div.innerHTML = "";

        // Create our stylesheet
        this.input_box = document.createElement('input');
        this.input_box.id = "input_search_"+this.cid;
        this.input_box.setAttribute("type", "text");
        this.input_box.setAttribute("placeholder", "Search by id...");
        this.input_box.setAttribute("style","font-size: 14px; padding-top: 4px; padding-bottom: 4px;")
        this.input_div.appendChild(this.input_box)

        this.button_layer = document.createElement('button');
        this.button_layer.id = "button_search_"+this.cid;
        this.button_layer.className = "btn btn-primary";
        this.button_layer.innerHTML = "search";
        this.button_layer.setAttribute("style","float: right");
        this.button_layer.onclick = search_graph.bind(this);


        this.input_div.appendChild(this.button_layer)
      }

      var search_button = document.createElement('button');
      search_button.id = "searchButtom"+this.cid;
      search_button.className = "btn btn-secondary";
      search_button.innerHTML = "Search Graph";
      search_button.style = "margin-bottom:10px;"
      search_button.onclick = search_box.bind(this);

      this.layer_picker_div.appendChild(search_button);

      this.floater_changed();
    },

    floater_changed: function(){
      if(this.model.get('floater')){
        this.floater.setAttribute("style", "display: block;");
      }
      else{
        this.floater.setAttribute("style", "display: none;");
      }
    },

    // Creating layer picker dropdown button.
    layer_picker: function(){

      var graph = this.model.get('graph');

      var element = document.getElementById("form_drop_"+this.cid);

      if(!(element === null)){
        this.form_drop.innerHTML = "";
      }

      var t_layers  = [];

      graph['nodes'].forEach((item, i) => {
        if( !t_layers.includes(item.layer) ){
          function filter_layer(n){
            if(n["target"]['checked'] == false){
              this.inactive_layer.push(n["srcElement"]['id']);
            }
            else{
              this.inactive_layer.splice(this.inactive_layer.indexOf(n["srcElement"]['id']),1);
            }
            this.update_graph();
          }

          var label = document.createElement('label');
          label.className = "dropdown-item";
          label.setAttribute("style","width:100px");

          var input = document.createElement('input');
          input.id = item.layer;
          input.setAttribute("type","checkbox");
          input.value = item.layer;

          if(!this.inactive_layer.includes(item.layer)){
            input.setAttribute("checked", true);
          }

          input.onclick = filter_layer.bind(this);

          var span = document.createElement('span');
          span.innerHTML = item.layer;

          label.appendChild(input);
          label.appendChild(span);

          this.form_drop.appendChild(label)

          t_layers.push(item.layer);
        }
      });

      this.dropdown.appendChild(this.drop_button);
      this.dropdown.appendChild(this.form_drop);

      this.layer_picker_div.appendChild(this.dropdown);
    },
    update_graph: function(){
      var width = this.model.get('width');
      var height = this.model.get('height');
      this.graphLayout = d3.forceSimulation()
        .force("charge", d3.forceManyBody().strength(-250))
        .force("link", d3.forceLink().id(d => d.id).distance(200))
        .force("center", d3.forceCenter(width / 2, height / 2))
        .on("tick", ticked.bind(this))

      this.valueline = d3.line()
        .x(function(d) { return d[0]; })
        .y(function(d) { return d[1]; })
        .curve(d3.curveCatmullRomClosed);

      var color = d3.scaleOrdinal(d3.schemeCategory10);
      var full_graph = this.model.get('graph')
      var graph = this.filter_graph_by_layer(full_graph);

      // Make a shallow copy to protect against mutation, while
      // recycling old nodes to preserve position and velocity.
      const old = new Map(this.node.data().map(d => [d.id, d]));
      graph.nodes = graph.nodes.map(d => Object.assign(old.get(d.id) || {}, d));
      graph.links = graph.links.map(d => Object.assign({}, d));

      this.adjlist = [];

      graph.links.forEach((d, i) => {
        if(typeof d.source === 'object'){
          this.adjlist[d.source.id + "-" + d.target.id] = true;
          this.adjlist[d.target.id + "-" + d.source.id] = true;
        }
        else{
          this.adjlist[d.source + "-" + d.target] = true;
          this.adjlist[d.target + "-" + d.source] = true;
        }
      }, this);



      var layer_picker_binded = this.layer_picker.bind(this);
      layer_picker_binded();

      // Group stuff!
      this.group_colors = {};
      graph.nodes.forEach((d,i) => {
        if(d.hasOwnProperty('group') && d.hasOwnProperty('group_color')){
          this.group_colors[d.group] = d.group_color;
        }
      })

      this.groupIds1 = d3.set(graph.nodes.map(function(n) { return n.group; }))
      .values()

      this.groupIds = this.groupIds1.map( function(groupId) {
        return {
          groupId : groupId,
          count : graph.nodes.filter(function(n) { return n.group == groupId; }).length
        };
      })
      .filter( function(group) { return group.count > 2;})
      .map( function(group) { return group.groupId; });

      if(this.groups.selectAll('.path_placeholder').size() != 0) {
        this.groups.selectAll('.path_placeholder').remove();
      }
      let self = this
      this.paths = this.groups.selectAll('.path_placeholder')
        .data(this.groupIds, function(d) { return d; })
        .enter()
        .append('g')
        .attr('class', 'path_placeholder')
        .append('path')
        .attr('stroke', function(d) {
          if(self.group_colors.hasOwnProperty(d)){
            return self.group_colors[d];
          }
          return color(d);
        })
        .attr('fill', function(d) {
          if(self.group_colors.hasOwnProperty(d)){
            return self.group_colors[d];
          }
          return color(d);
        })
        .attr('opacity', 0);

      this.paths
        .transition()
        .duration(2000)
        .attr('opacity', 1);

      // add interaction to the groups
      this.groups.selectAll('.path_placeholder')
        .call(d3.drag()
          .on('start', group_dragstarted.bind(this))
             .on('drag', group_dragged.bind(this))
             .on('end', group_dragended.bind(this))
          );


      this.link = this.link.data(graph.links, d => [d.source, d.target])
        .join("line")
        .attr("stroke", "#aaa")
        .attr("stroke-width", "1px");

      this.node = this.node.data(graph.nodes, d => d.id)
        .join(enter => enter.append("g"))

      // NODES!!!
      this.circle = this.node.append("circle")
        .on("click", onClick.bind(this))
        .attr("r", function(d){
          if(d.hasOwnProperty('radius')){
            return d.radius;
          }
          else{
            return 25;
          }
        })
        .attr("fill", function(d) {
          if(d.hasOwnProperty('color')){
            return d.color;
          }
          else{
            return color(Math.random());
          }
        })


      var label = this.model.get('label');
      if(label){
        // LABELS!!!
        this.labels = this.node.append("text")
          .attr("class","label_"+this.cid)
          .text(function(d) {
            if(d.hasOwnProperty('label')){
              return d.label;
            }
            else{
              return d.id;
            }
          })
          .attr('x', function(d) {
            if(d.hasOwnProperty('radius')){
              return d.radius;
            }
            else{
              return 25;
            }
          })
          .attr('y', function(d) {
            if(d.hasOwnProperty('radius')){
              return d.radius*-1;
            }
            else{
              return -25;
            }
          });
      }
      else{
        d3.selectAll(".label_"+this.cid).remove();
      }

      var icon = this.model.get('icon');
      if(icon){
        // ICONS!!!
        this.icons = this.node.append("text")
          .attr("class","icon_"+this.cid)
          .attr("class","fas fa-stack")
          .attr("x", 0)
          .attr("dy", ".35em")
          .attr("text-anchor", "middle")
          .style("fill", "white")
          .attr('font-family', 'FontAwesome')
          .attr('font-size', function(d) {
            if(d.hasOwnProperty('radius')){
              return d.radius
            } else {
              return 25;
            }
          } )
          .text(function(d) {
            return fa_codes[d.icon]
          });
      }
      else{
        d3.selectAll(".icon_"+this.cid).remove();
      }

      function neigh(a, b) {
          return a == b || this.adjlist[a + "-" + b];
      }
      const neigh_binded = neigh.bind(this);

      function focus(d) {
          var index = d3.select(d3.event.target).datum().id;

          if(this.hover_focus){
            this.node.style("opacity", function(o) {
                return neigh_binded(index, o.id) ? 1 : 0.1;
            });

            this.link.style("opacity", function(o) {
                return o.source.id == index || o.target.id == index ? 1 : 0.1;
            });
          }

          let floater_binded = showFloaterData.bind(this);
          floater_binded(index);
      }



      function unfocus() {
        if(this.hover_focus){
          this.node.style("opacity", 1);
          this.link.style("opacity", 1);
        }
      }

      function onClick(d) {
        this.hover_focus = true;
        this.focus.bind(this)
      }

      function dragstarted(d) {
        this.hover_focus = true;
        d3.event.sourceEvent.stopPropagation();
        if (!d3.event.active) this.graphLayout.alphaTarget(0.3).restart();
        d.fx = d.x;
        d.fy = d.y;
      }

      function dragged(d) {
          d.fx = d3.event.x;
          d.fy = d3.event.y;
      }

      function dragended(d) {
          if (!d3.event.active) this.graphLayout.alphaTarget(0).stop();
          d.fx = null;
          d.fy = null;
      }

      // Group Drags
      function group_dragstarted(groupId) {
        if (!d3.event.active) this.graphLayout.alphaTarget(0.3).restart();
        d3.select('path').style('stroke-width', 3);
      }

      function group_dragged(groupId) {
        this.node
          .filter(function(d) { return d.group == groupId; })
          .each(function(d) {
            d.x += d3.event.dx;
            d.y += d3.event.dy;
          })
      }

      function group_dragended(groupId) {
        if (!d3.event.active) this.graphLayout.alphaTarget(0).stop();
        d3.select('path').style('stroke-width', 1);
      }

      // End groups drag

      function ticked() {
        var ug_bind = this.updateGroups.bind(this);
        ug_bind();
        this.node.call(updateNode.bind(this));
        this.link.call(updateLink.bind(this));
      }

      function fixna(x) {
          if (isFinite(x)) return x;
          return 0;
      }

      function updateLink(link) {
          this.link.attr("x1", function(d) { return fixna(d.source.x); })
              .attr("y1", function(d) { return fixna(d.source.y); })
              .attr("x2", function(d) { return fixna(d.target.x); })
              .attr("y2", function(d) { return fixna(d.target.y); });
      }

      function updateNode(node) {
          this.node.attr("transform", function(d) {
              return "translate(" + fixna(d.x) + "," + fixna(d.y) + ")";
          });
      }


      function showFloaterData(index){
        var height = this.model.get('height');
        var temp_text = "";

        graph.nodes.forEach((item, i) => {
          if(item.id == index){
            for (let k in item) {
              if(!(["x","y","vx","vy","index", "fx", "fy"].includes(k))){
                temp_text = temp_text+"<b>"+ k +"</b>: "+item[k]+"<br/>"
              }
            }
          };
        });
        this.floater.innerHTML = '<div style="overflow-y:scroll; height:'+height/4+'px; padding:3px;">'+temp_text+"</div>";
      }

      this.node.call(
          d3.drag()
              .on("start", dragstarted.bind(this))
              .on("drag", dragged.bind(this))
              .on("end", dragended.bind(this))
      );

      this.node.on("mouseover", focus.bind(this)).on("mouseout", unfocus.bind(this));

      // Context Menu functions!!!!!
      function menu(n){
        // Layer updating function.
        function layer_button_click(){
          var new_layer = this.input_box.value;
          var graph = this.model.get('graph');


          var temp_graph = {nodes:[],links:[]};

          graph.nodes.forEach((item, i) => {
            if(item.id == this.temp_id){
              item.layer = new_layer
            }

            temp_graph['nodes'].push(item);
          });

          graph.links.forEach((item, i) => {
            if(item.source== this.temp_id){
              item.layer = new_layer+"-"+item.layer.split("-")[1]
            }

            if(item.target == this.temp_id){
              item.layer = item.layer.split("-")[0]+"-"+new_layer
            }
            temp_graph['links'].push(item);
          });

          this.updated_graph["nodes"] = temp_graph["nodes"];
          this.updated_graph["links"] = temp_graph["links"];

          this.graph_update_binded();

          this.input_div.setAttribute("style", "display: none");

          this.update_graph();
        }

        // Layer changing function that opens the text box.
        function layer_change_display(n){
          this.temp_id = n.id;
          this.input_div.setAttribute("style", "display: block");

          this.input_div.innerHTML = "";

          // Create our stylesheet
          this.input_box = document.createElement('input');

          this.input_box.setAttribute("type", "text");
          this.input_box.setAttribute("value", n.layer);
          this.input_box.setAttribute("style","font-size: 14px; padding-top: 4px; padding-bottom: 4px;")
          this.input_div.appendChild(this.input_box)

          this.button_layer = document.createElement('button');
          this.button_layer.id = "button_layer_"+this.cid;
          this.button_layer.className = "btn btn-primary";
          this.button_layer.innerHTML = "Update";
          this.button_layer.setAttribute("style","float: right");
          this.button_layer.onclick = layer_button_click.bind(this)


          this.input_div.appendChild(this.button_layer)
        }

        // Layer functions End

        // Group updating function.
        function group_button_click(){
          var new_value = this.input_box.value.split(",");
          console.log(new_value);
          var graph = this.model.get('graph');


          var temp_graph = {nodes:[],links:[]};

          graph.nodes.forEach((item, i) => {
            if(item.id == this.temp_id){
              if(item.hasOwnProperty('group')){
                item.group = new_value[0];
              }
              else{
                item['group'] = new_value[0];
              }
              if(new_value.length==2){
                item.group_color = new_value[1];
              }

            }
            temp_graph['nodes'].push(item);
          });

          this.updated_graph["nodes"] = temp_graph["nodes"];
          this.updated_graph["links"] = graph["links"];

          this.graph_update_binded();

          this.input_div.setAttribute("style", "display: none");

          this.update_graph();
        }
        // Group function that opens the text box.
        function add_to_group(n){
          this.temp_id = n.id;
          this.input_div.setAttribute("style", "display: block");

          this.input_div.innerHTML = "";

          // Create our stylesheet
          this.input_box = document.createElement('input');

          this.input_box.setAttribute("type", "text");
          this.input_box.setAttribute("placeholder", "group,color(optional)");

          if(n.hasOwnProperty('group')){
            this.input_box.setAttribute("value", n.group);
          }

          this.input_box.setAttribute("style","font-size: 14px; padding-top: 4px; padding-bottom: 4px;")
          this.input_div.appendChild(this.input_box)

          this.button_layer = document.createElement('button');
          this.button_layer.id = "button_group_"+this.cid;
          this.button_layer.className = "btn btn-primary";
          this.button_layer.innerHTML = "Update";
          this.button_layer.setAttribute("style","float: right");
          this.button_layer.onclick = group_button_click.bind(this)


          this.input_div.appendChild(this.button_layer)
        }

        temp_menu = [
            {
              title: 'Header',
            },
            {
              title:'empty',
            },
            {
              title: 'Change Layer',
              action: layer_change_display.bind(this)
            },
            {
              title: 'Change Group',
              action: add_to_group.bind(this)
            }
        ];
        temp = [];

        for( key in n ) {
          if(!(["x","y","vx","vy","index", "fx", "fy"].includes(key))){
            temp.push({title: key, children:[{title: n[key]}] });
          }
        };
        temp_menu[0] = { title:n.id }
        temp_menu[1] = { title:"Node Info", children: temp }

        return temp_menu;
      }
      this.node.on('contextmenu', context(menu.bind(this)));

      this.graphLayout.nodes(graph.nodes);
      this.graphLayout.force("link").links(graph.links);

      this.graphLayout
      .alpha(1)
      .alphaTarget(0)

      this.graphLayout.restart();

      // See https://github.com/d3/d3-force/blob/master/README.md#simulation_tick
      for (var i = 0, n = Math.ceil(Math.log(this.graphLayout.alphaMin()) / Math.log(1 - this.graphLayout.alphaDecay())); i < n; ++i) {
        this.graphLayout.tick();
      }

      this.graphLayout.stop();

      this.node.call(updateNode.bind(this));
      this.link.call(updateLink.bind(this));
      var ug_bind = this.updateGroups.bind(this);
      ug_bind();
    },
    polygonGenerator: function(groupId) {
      var node_coords = this.node
        .filter(function(d) { return d.group == groupId; })
        .data()
        .map(function(d) { return [d.x, d.y]; });

      return d3.polygonHull(node_coords);
    },
    updateGroups: function() {
      let self = this;
      this.groupIds.forEach(function(groupId) {
        var path = self.paths.filter(function(d) { return d == groupId;})
          .attr('transform', 'scale(1) translate(0,0)')
          .attr('d', function(d) {
            var pol_bind = self.polygonGenerator.bind(self);
            polygon = pol_bind(d);
            console.log(polygon);
            centroid = d3.polygonCentroid(polygon);

            return self.valueline(
              polygon.map(function(point) {
                return [  point[0] - centroid[0], point[1] - centroid[1] ];
              })
            );
          });

        d3.select(path.node().parentNode).attr('transform', 'translate('  + centroid[0] + ',' + (centroid[1]) + ') scale(' + 1.2 + ')');
      });
    },
    filter_graph_by_layer: function(){
      var temp_graph = { nodes:[], links:[] };
      var graph = this.model.get('graph');

      graph['nodes'].forEach((item, i) => {
        if(!this.inactive_layer.includes(item.layer)){
          temp_graph['nodes'].push(item);
        }
      });

      graph['links'].forEach((item, i) => {
        var layers = item.layer.split("-")
        if(!(this.inactive_layer.includes(layers[0]) || this.inactive_layer.includes(layers[1]))){
          temp_graph['links'].push(item);
        }
      });

      return temp_graph;
    },

    display_graph: function(){
      var full_graph = this.model.get('graph');
      var graph = this.filter_graph_by_layer(full_graph);

      var width = this.model.get('width');
      var height = this.model.get('height');

      var zoom = d3.zoom()
                	.scaleExtent([.1, 10])
                	.on("zoom", function() { container.attr("transform", d3.event.transform); });

      var svg = d3.select(this.el).append("svg").attr("width", width).attr("height", height).call(zoom);
      var container = svg.append("g");

      zoom.scaleTo(svg, .6);

      // create groups, links and nodes
      this.groups = container.append('g').attr('class', 'groups');

      this.link = container.append("g").attr("class", "links")
        .selectAll("line");


      this.node = container.append("g").attr("class", "nodes")
        .selectAll("g");

      this.update_graph();

    },

});

const fa_codes = {"fa-500px": "\uf26e", "fa-accessible-icon": "\uf368", "fa-accusoft": "\uf369", "fa-acquisitions-incorporated": "\uf6af", "fa-ad": "\uf641", "fa-address-book": "\uf2b9", "fa-address-card": "\uf2bb", "fa-adjust": "\uf042", "fa-adn": "\uf170", "fa-adobe": "\uf778", "fa-adversal": "\uf36a", "fa-affiliatetheme": "\uf36b", "fa-air-freshener": "\uf5d0", "fa-airbnb": "\uf834", "fa-algolia": "\uf36c", "fa-align-center": "\uf037", "fa-align-justify": "\uf039", "fa-align-left": "\uf036", "fa-align-right": "\uf038", "fa-alipay": "\uf642", "fa-allergies": "\uf461", "fa-amazon": "\uf270", "fa-amazon-pay": "\uf42c", "fa-ambulance": "\uf0f9", "fa-american-sign-language-interpreting": "\uf2a3", "fa-amilia": "\uf36d", "fa-anchor": "\uf13d", "fa-android": "\uf17b", "fa-angellist": "\uf209", "fa-angle-double-down": "\uf103", "fa-angle-double-left": "\uf100", "fa-angle-double-right": "\uf101", "fa-angle-double-up": "\uf102", "fa-angle-down": "\uf107", "fa-angle-left": "\uf104", "fa-angle-right": "\uf105", "fa-angle-up": "\uf106", "fa-angry": "\uf556", "fa-angrycreative": "\uf36e", "fa-angular": "\uf420", "fa-ankh": "\uf644", "fa-app-store": "\uf36f", "fa-app-store-ios": "\uf370", "fa-apper": "\uf371", "fa-apple": "\uf179", "fa-apple-alt": "\uf5d1", "fa-apple-pay": "\uf415", "fa-archive": "\uf187", "fa-archway": "\uf557", "fa-arrow-alt-circle-down": "\uf358", "fa-arrow-alt-circle-left": "\uf359", "fa-arrow-alt-circle-right": "\uf35a", "fa-arrow-alt-circle-up": "\uf35b", "fa-arrow-circle-down": "\uf0ab", "fa-arrow-circle-left": "\uf0a8", "fa-arrow-circle-right": "\uf0a9", "fa-arrow-circle-up": "\uf0aa", "fa-arrow-down": "\uf063", "fa-arrow-left": "\uf060", "fa-arrow-right": "\uf061", "fa-arrow-up": "\uf062", "fa-arrows-alt": "\uf0b2", "fa-arrows-alt-h": "\uf337", "fa-arrows-alt-v": "\uf338", "fa-artstation": "\uf77a", "fa-assistive-listening-systems": "\uf2a2", "fa-asterisk": "\uf069", "fa-asymmetrik": "\uf372", "fa-at": "\uf1fa", "fa-atlas": "\uf558", "fa-atlassian": "\uf77b", "fa-atom": "\uf5d2", "fa-audible": "\uf373", "fa-audio-description": "\uf29e", "fa-autoprefixer": "\uf41c", "fa-avianex": "\uf374", "fa-aviato": "\uf421", "fa-award": "\uf559", "fa-aws": "\uf375", "fa-baby": "\uf77c", "fa-baby-carriage": "\uf77d", "fa-backspace": "\uf55a", "fa-backward": "\uf04a", "fa-bacon": "\uf7e5", "fa-balance-scale": "\uf24e", "fa-balance-scale-left": "\uf515", "fa-balance-scale-right": "\uf516", "fa-ban": "\uf05e", "fa-band-aid": "\uf462", "fa-bandcamp": "\uf2d5", "fa-barcode": "\uf02a", "fa-bars": "\uf0c9", "fa-baseball-ball": "\uf433", "fa-basketball-ball": "\uf434", "fa-bath": "\uf2cd", "fa-battery-empty": "\uf244", "fa-battery-full": "\uf240", "fa-battery-half": "\uf242", "fa-battery-quarter": "\uf243", "fa-battery-three-quarters": "\uf241", "fa-battle-net": "\uf835", "fa-bed": "\uf236", "fa-beer": "\uf0fc", "fa-behance": "\uf1b4", "fa-behance-square": "\uf1b5", "fa-bell": "\uf0f3", "fa-bell-slash": "\uf1f6", "fa-bezier-curve": "\uf55b", "fa-bible": "\uf647", "fa-bicycle": "\uf206", "fa-biking": "\uf84a", "fa-bimobject": "\uf378", "fa-binoculars": "\uf1e5", "fa-biohazard": "\uf780", "fa-birthday-cake": "\uf1fd", "fa-bitbucket": "\uf171", "fa-bitcoin": "\uf379", "fa-bity": "\uf37a", "fa-black-tie": "\uf27e", "fa-blackberry": "\uf37b", "fa-blender": "\uf517", "fa-blender-phone": "\uf6b6", "fa-blind": "\uf29d", "fa-blog": "\uf781", "fa-blogger": "\uf37c", "fa-blogger-b": "\uf37d", "fa-bluetooth": "\uf293", "fa-bluetooth-b": "\uf294", "fa-bold": "\uf032", "fa-bolt": "\uf0e7", "fa-bomb": "\uf1e2", "fa-bone": "\uf5d7", "fa-bong": "\uf55c", "fa-book": "\uf02d", "fa-book-dead": "\uf6b7", "fa-book-medical": "\uf7e6", "fa-book-open": "\uf518", "fa-book-reader": "\uf5da", "fa-bookmark": "\uf02e", "fa-bootstrap": "\uf836", "fa-border-all": "\uf84c", "fa-border-none": "\uf850", "fa-border-style": "\uf853", "fa-bowling-ball": "\uf436", "fa-box": "\uf466", "fa-box-open": "\uf49e", "fa-boxes": "\uf468", "fa-braille": "\uf2a1", "fa-brain": "\uf5dc", "fa-bread-slice": "\uf7ec", "fa-briefcase": "\uf0b1", "fa-briefcase-medical": "\uf469", "fa-broadcast-tower": "\uf519", "fa-broom": "\uf51a", "fa-brush": "\uf55d", "fa-btc": "\uf15a", "fa-buffer": "\uf837", "fa-bug": "\uf188", "fa-building": "\uf1ad", "fa-bullhorn": "\uf0a1", "fa-bullseye": "\uf140", "fa-burn": "\uf46a", "fa-buromobelexperte": "\uf37f", "fa-bus": "\uf207", "fa-bus-alt": "\uf55e", "fa-business-time": "\uf64a", "fa-buysellads": "\uf20d", "fa-calculator": "\uf1ec", "fa-calendar": "\uf133", "fa-calendar-alt": "\uf073", "fa-calendar-check": "\uf274", "fa-calendar-day": "\uf783", "fa-calendar-minus": "\uf272", "fa-calendar-plus": "\uf271", "fa-calendar-times": "\uf273", "fa-calendar-week": "\uf784", "fa-camera": "\uf030", "fa-camera-retro": "\uf083", "fa-campground": "\uf6bb", "fa-canadian-maple-leaf": "\uf785", "fa-candy-cane": "\uf786", "fa-cannabis": "\uf55f", "fa-capsules": "\uf46b", "fa-car": "\uf1b9", "fa-car-alt": "\uf5de", "fa-car-battery": "\uf5df", "fa-car-crash": "\uf5e1", "fa-car-side": "\uf5e4", "fa-caret-down": "\uf0d7", "fa-caret-left": "\uf0d9", "fa-caret-right": "\uf0da", "fa-caret-square-down": "\uf150", "fa-caret-square-left": "\uf191", "fa-caret-square-right": "\uf152", "fa-caret-square-up": "\uf151", "fa-caret-up": "\uf0d8", "fa-carrot": "\uf787", "fa-cart-arrow-down": "\uf218", "fa-cart-plus": "\uf217", "fa-cash-register": "\uf788", "fa-cat": "\uf6be", "fa-cc-amazon-pay": "\uf42d", "fa-cc-amex": "\uf1f3", "fa-cc-apple-pay": "\uf416", "fa-cc-diners-club": "\uf24c", "fa-cc-discover": "\uf1f2", "fa-cc-jcb": "\uf24b", "fa-cc-mastercard": "\uf1f1", "fa-cc-paypal": "\uf1f4", "fa-cc-stripe": "\uf1f5", "fa-cc-visa": "\uf1f0", "fa-centercode": "\uf380", "fa-centos": "\uf789", "fa-certificate": "\uf0a3", "fa-chair": "\uf6c0", "fa-chalkboard": "\uf51b", "fa-chalkboard-teacher": "\uf51c", "fa-charging-station": "\uf5e7", "fa-chart-area": "\uf1fe", "fa-chart-bar": "\uf080", "fa-chart-line": "\uf201", "fa-chart-pie": "\uf200", "fa-check": "\uf00c", "fa-check-circle": "\uf058", "fa-check-double": "\uf560", "fa-check-square": "\uf14a", "fa-cheese": "\uf7ef", "fa-chess": "\uf439", "fa-chess-bishop": "\uf43a", "fa-chess-board": "\uf43c", "fa-chess-king": "\uf43f", "fa-chess-knight": "\uf441", "fa-chess-pawn": "\uf443", "fa-chess-queen": "\uf445", "fa-chess-rook": "\uf447", "fa-chevron-circle-down": "\uf13a", "fa-chevron-circle-left": "\uf137", "fa-chevron-circle-right": "\uf138", "fa-chevron-circle-up": "\uf139", "fa-chevron-down": "\uf078", "fa-chevron-left": "\uf053", "fa-chevron-right": "\uf054", "fa-chevron-up": "\uf077", "fa-child": "\uf1ae", "fa-chrome": "\uf268", "fa-chromecast": "\uf838", "fa-church": "\uf51d", "fa-circle": "\uf111", "fa-circle-notch": "\uf1ce", "fa-city": "\uf64f", "fa-clinic-medical": "\uf7f2", "fa-clipboard": "\uf328", "fa-clipboard-check": "\uf46c", "fa-clipboard-list": "\uf46d", "fa-clock": "\uf017", "fa-clone": "\uf24d", "fa-closed-captioning": "\uf20a", "fa-cloud": "\uf0c2", "fa-cloud-download-alt": "\uf381", "fa-cloud-meatball": "\uf73b", "fa-cloud-moon": "\uf6c3", "fa-cloud-moon-rain": "\uf73c", "fa-cloud-rain": "\uf73d", "fa-cloud-showers-heavy": "\uf740", "fa-cloud-sun": "\uf6c4", "fa-cloud-sun-rain": "\uf743", "fa-cloud-upload-alt": "\uf382", "fa-cloudscale": "\uf383", "fa-cloudsmith": "\uf384", "fa-cloudversify": "\uf385", "fa-cocktail": "\uf561", "fa-code": "\uf121", "fa-code-branch": "\uf126", "fa-codepen": "\uf1cb", "fa-codiepie": "\uf284", "fa-coffee": "\uf0f4", "fa-cog": "\uf013", "fa-cogs": "\uf085", "fa-coins": "\uf51e", "fa-columns": "\uf0db", "fa-comment": "\uf075", "fa-comment-alt": "\uf27a", "fa-comment-dollar": "\uf651", "fa-comment-dots": "\uf4ad", "fa-comment-medical": "\uf7f5", "fa-comment-slash": "\uf4b3", "fa-comments": "\uf086", "fa-comments-dollar": "\uf653", "fa-compact-disc": "\uf51f", "fa-compass": "\uf14e", "fa-compress": "\uf066", "fa-compress-arrows-alt": "\uf78c", "fa-concierge-bell": "\uf562", "fa-confluence": "\uf78d", "fa-connectdevelop": "\uf20e", "fa-contao": "\uf26d", "fa-cookie": "\uf563", "fa-cookie-bite": "\uf564", "fa-copy": "\uf0c5", "fa-copyright": "\uf1f9", "fa-cotton-bureau": "\uf89e", "fa-couch": "\uf4b8", "fa-cpanel": "\uf388", "fa-creative-commons": "\uf25e", "fa-creative-commons-by": "\uf4e7", "fa-creative-commons-nc": "\uf4e8", "fa-creative-commons-nc-eu": "\uf4e9", "fa-creative-commons-nc-jp": "\uf4ea", "fa-creative-commons-nd": "\uf4eb", "fa-creative-commons-pd": "\uf4ec", "fa-creative-commons-pd-alt": "\uf4ed", "fa-creative-commons-remix": "\uf4ee", "fa-creative-commons-sa": "\uf4ef", "fa-creative-commons-sampling": "\uf4f0", "fa-creative-commons-sampling-plus": "\uf4f1", "fa-creative-commons-share": "\uf4f2", "fa-creative-commons-zero": "\uf4f3", "fa-credit-card": "\uf09d", "fa-critical-role": "\uf6c9", "fa-crop": "\uf125", "fa-crop-alt": "\uf565", "fa-cross": "\uf654", "fa-crosshairs": "\uf05b", "fa-crow": "\uf520", "fa-crown": "\uf521", "fa-crutch": "\uf7f7", "fa-css3": "\uf13c", "fa-css3-alt": "\uf38b", "fa-cube": "\uf1b2", "fa-cubes": "\uf1b3", "fa-cut": "\uf0c4", "fa-cuttlefish": "\uf38c", "fa-d-and-d": "\uf38d", "fa-d-and-d-beyond": "\uf6ca", "fa-dashcube": "\uf210", "fa-database": "\uf1c0", "fa-deaf": "\uf2a4", "fa-delicious": "\uf1a5", "fa-democrat": "\uf747", "fa-deploydog": "\uf38e", "fa-deskpro": "\uf38f", "fa-desktop": "\uf108", "fa-dev": "\uf6cc", "fa-deviantart": "\uf1bd", "fa-dharmachakra": "\uf655", "fa-dhl": "\uf790", "fa-diagnoses": "\uf470", "fa-diaspora": "\uf791", "fa-dice": "\uf522", "fa-dice-d20": "\uf6cf", "fa-dice-d6": "\uf6d1", "fa-dice-five": "\uf523", "fa-dice-four": "\uf524", "fa-dice-one": "\uf525", "fa-dice-six": "\uf526", "fa-dice-three": "\uf527", "fa-dice-two": "\uf528", "fa-digg": "\uf1a6", "fa-digital-ocean": "\uf391", "fa-digital-tachograph": "\uf566", "fa-directions": "\uf5eb", "fa-discord": "\uf392", "fa-discourse": "\uf393", "fa-divide": "\uf529", "fa-dizzy": "\uf567", "fa-dna": "\uf471", "fa-dochub": "\uf394", "fa-docker": "\uf395", "fa-dog": "\uf6d3", "fa-dollar-sign": "\uf155", "fa-dolly": "\uf472", "fa-dolly-flatbed": "\uf474", "fa-donate": "\uf4b9", "fa-door-closed": "\uf52a", "fa-door-open": "\uf52b", "fa-dot-circle": "\uf192", "fa-dove": "\uf4ba", "fa-download": "\uf019", "fa-draft2digital": "\uf396", "fa-drafting-compass": "\uf568", "fa-dragon": "\uf6d5", "fa-draw-polygon": "\uf5ee", "fa-dribbble": "\uf17d", "fa-dribbble-square": "\uf397", "fa-dropbox": "\uf16b", "fa-drum": "\uf569", "fa-drum-steelpan": "\uf56a", "fa-drumstick-bite": "\uf6d7", "fa-drupal": "\uf1a9", "fa-dumbbell": "\uf44b", "fa-dumpster": "\uf793", "fa-dumpster-fire": "\uf794", "fa-dungeon": "\uf6d9", "fa-dyalog": "\uf399", "fa-earlybirds": "\uf39a", "fa-ebay": "\uf4f4", "fa-edge": "\uf282", "fa-edit": "\uf044", "fa-egg": "\uf7fb", "fa-eject": "\uf052", "fa-elementor": "\uf430", "fa-ellipsis-h": "\uf141", "fa-ellipsis-v": "\uf142", "fa-ello": "\uf5f1", "fa-ember": "\uf423", "fa-empire": "\uf1d1", "fa-envelope": "\uf0e0", "fa-envelope-open": "\uf2b6", "fa-envelope-open-text": "\uf658", "fa-envelope-square": "\uf199", "fa-envira": "\uf299", "fa-equals": "\uf52c", "fa-eraser": "\uf12d", "fa-erlang": "\uf39d", "fa-ethereum": "\uf42e", "fa-ethernet": "\uf796", "fa-etsy": "\uf2d7", "fa-euro-sign": "\uf153", "fa-evernote": "\uf839", "fa-exchange-alt": "\uf362", "fa-exclamation": "\uf12a", "fa-exclamation-circle": "\uf06a", "fa-exclamation-triangle": "\uf071", "fa-expand": "\uf065", "fa-expand-arrows-alt": "\uf31e", "fa-expeditedssl": "\uf23e", "fa-external-link-alt": "\uf35d", "fa-external-link-square-alt": "\uf360", "fa-eye": "\uf06e", "fa-eye-dropper": "\uf1fb", "fa-eye-slash": "\uf070", "fa-facebook": "\uf09a", "fa-facebook-f": "\uf39e", "fa-facebook-messenger": "\uf39f", "fa-facebook-square": "\uf082", "fa-fan": "\uf863", "fa-fantasy-flight-games": "\uf6dc", "fa-fast-backward": "\uf049", "fa-fast-forward": "\uf050", "fa-fax": "\uf1ac", "fa-feather": "\uf52d", "fa-feather-alt": "\uf56b", "fa-fedex": "\uf797", "fa-fedora": "\uf798", "fa-female": "\uf182", "fa-fighter-jet": "\uf0fb", "fa-figma": "\uf799", "fa-file": "\uf15b", "fa-file-alt": "\uf15c", "fa-file-archive": "\uf1c6", "fa-file-audio": "\uf1c7", "fa-file-code": "\uf1c9", "fa-file-contract": "\uf56c", "fa-file-csv": "\uf6dd", "fa-file-download": "\uf56d", "fa-file-excel": "\uf1c3", "fa-file-export": "\uf56e", "fa-file-image": "\uf1c5", "fa-file-import": "\uf56f", "fa-file-invoice": "\uf570", "fa-file-invoice-dollar": "\uf571", "fa-file-medical": "\uf477", "fa-file-medical-alt": "\uf478", "fa-file-pdf": "\uf1c1", "fa-file-powerpoint": "\uf1c4", "fa-file-prescription": "\uf572", "fa-file-signature": "\uf573", "fa-file-upload": "\uf574", "fa-file-video": "\uf1c8", "fa-file-word": "\uf1c2", "fa-fill": "\uf575", "fa-fill-drip": "\uf576", "fa-film": "\uf008", "fa-filter": "\uf0b0", "fa-fingerprint": "\uf577", "fa-fire": "\uf06d", "fa-fire-alt": "\uf7e4", "fa-fire-extinguisher": "\uf134", "fa-firefox": "\uf269", "fa-first-aid": "\uf479", "fa-first-order": "\uf2b0", "fa-first-order-alt": "\uf50a", "fa-firstdraft": "\uf3a1", "fa-fish": "\uf578", "fa-fist-raised": "\uf6de", "fa-flag": "\uf024", "fa-flag-checkered": "\uf11e", "fa-flag-usa": "\uf74d", "fa-flask": "\uf0c3", "fa-flickr": "\uf16e", "fa-flipboard": "\uf44d", "fa-flushed": "\uf579", "fa-fly": "\uf417", "fa-folder": "\uf07b", "fa-folder-minus": "\uf65d", "fa-folder-open": "\uf07c", "fa-folder-plus": "\uf65e", "fa-font": "\uf031", "fa-font-awesome": "\uf2b4", "fa-font-awesome-alt": "\uf35c", "fa-font-awesome-flag": "\uf425", "fa-font-awesome-logo-full": "\uf4e6", "fa-fonticons": "\uf280", "fa-fonticons-fi": "\uf3a2", "fa-football-ball": "\uf44e", "fa-fort-awesome": "\uf286", "fa-fort-awesome-alt": "\uf3a3", "fa-forumbee": "\uf211", "fa-forward": "\uf04e", "fa-foursquare": "\uf180", "fa-free-code-camp": "\uf2c5", "fa-freebsd": "\uf3a4", "fa-frog": "\uf52e", "fa-frown": "\uf119", "fa-frown-open": "\uf57a", "fa-fulcrum": "\uf50b", "fa-funnel-dollar": "\uf662", "fa-futbol": "\uf1e3", "fa-galactic-republic": "\uf50c", "fa-galactic-senate": "\uf50d", "fa-gamepad": "\uf11b", "fa-gas-pump": "\uf52f", "fa-gavel": "\uf0e3", "fa-gem": "\uf3a5", "fa-genderless": "\uf22d", "fa-get-pocket": "\uf265", "fa-gg": "\uf260", "fa-gg-circle": "\uf261", "fa-ghost": "\uf6e2", "fa-gift": "\uf06b", "fa-gifts": "\uf79c", "fa-git": "\uf1d3", "fa-git-alt": "\uf841", "fa-git-square": "\uf1d2", "fa-github": "\uf09b", "fa-github-alt": "\uf113", "fa-github-square": "\uf092", "fa-gitkraken": "\uf3a6", "fa-gitlab": "\uf296", "fa-gitter": "\uf426", "fa-glass-cheers": "\uf79f", "fa-glass-martini": "\uf000", "fa-glass-martini-alt": "\uf57b", "fa-glass-whiskey": "\uf7a0", "fa-glasses": "\uf530", "fa-glide": "\uf2a5", "fa-glide-g": "\uf2a6", "fa-globe": "\uf0ac", "fa-globe-africa": "\uf57c", "fa-globe-americas": "\uf57d", "fa-globe-asia": "\uf57e", "fa-globe-europe": "\uf7a2", "fa-gofore": "\uf3a7", "fa-golf-ball": "\uf450", "fa-goodreads": "\uf3a8", "fa-goodreads-g": "\uf3a9", "fa-google": "\uf1a0", "fa-google-drive": "\uf3aa", "fa-google-play": "\uf3ab", "fa-google-plus": "\uf2b3", "fa-google-plus-g": "\uf0d5", "fa-google-plus-square": "\uf0d4", "fa-google-wallet": "\uf1ee", "fa-gopuram": "\uf664", "fa-graduation-cap": "\uf19d", "fa-gratipay": "\uf184", "fa-grav": "\uf2d6", "fa-greater-than": "\uf531", "fa-greater-than-equal": "\uf532", "fa-grimace": "\uf57f", "fa-grin": "\uf580", "fa-grin-alt": "\uf581", "fa-grin-beam": "\uf582", "fa-grin-beam-sweat": "\uf583", "fa-grin-hearts": "\uf584", "fa-grin-squint": "\uf585", "fa-grin-squint-tears": "\uf586", "fa-grin-stars": "\uf587", "fa-grin-tears": "\uf588", "fa-grin-tongue": "\uf589", "fa-grin-tongue-squint": "\uf58a", "fa-grin-tongue-wink": "\uf58b", "fa-grin-wink": "\uf58c", "fa-grip-horizontal": "\uf58d", "fa-grip-lines": "\uf7a4", "fa-grip-lines-vertical": "\uf7a5", "fa-grip-vertical": "\uf58e", "fa-gripfire": "\uf3ac", "fa-grunt": "\uf3ad", "fa-guitar": "\uf7a6", "fa-gulp": "\uf3ae", "fa-h-square": "\uf0fd", "fa-hacker-news": "\uf1d4", "fa-hacker-news-square": "\uf3af", "fa-hackerrank": "\uf5f7", "fa-hamburger": "\uf805", "fa-hammer": "\uf6e3", "fa-hamsa": "\uf665", "fa-hand-holding": "\uf4bd", "fa-hand-holding-heart": "\uf4be", "fa-hand-holding-usd": "\uf4c0", "fa-hand-lizard": "\uf258", "fa-hand-middle-finger": "\uf806", "fa-hand-paper": "\uf256", "fa-hand-peace": "\uf25b", "fa-hand-point-down": "\uf0a7", "fa-hand-point-left": "\uf0a5", "fa-hand-point-right": "\uf0a4", "fa-hand-point-up": "\uf0a6", "fa-hand-pointer": "\uf25a", "fa-hand-rock": "\uf255", "fa-hand-scissors": "\uf257", "fa-hand-spock": "\uf259", "fa-hands": "\uf4c2", "fa-hands-helping": "\uf4c4", "fa-handshake": "\uf2b5", "fa-hanukiah": "\uf6e6", "fa-hard-hat": "\uf807", "fa-hashtag": "\uf292", "fa-hat-wizard": "\uf6e8", "fa-haykal": "\uf666", "fa-hdd": "\uf0a0", "fa-heading": "\uf1dc", "fa-headphones": "\uf025", "fa-headphones-alt": "\uf58f", "fa-headset": "\uf590", "fa-heart": "\uf004", "fa-heart-broken": "\uf7a9", "fa-heartbeat": "\uf21e", "fa-helicopter": "\uf533", "fa-highlighter": "\uf591", "fa-hiking": "\uf6ec", "fa-hippo": "\uf6ed", "fa-hips": "\uf452", "fa-hire-a-helper": "\uf3b0", "fa-history": "\uf1da", "fa-hockey-puck": "\uf453", "fa-holly-berry": "\uf7aa", "fa-home": "\uf015", "fa-hooli": "\uf427", "fa-hornbill": "\uf592", "fa-horse": "\uf6f0", "fa-horse-head": "\uf7ab", "fa-hospital": "\uf0f8", "fa-hospital-alt": "\uf47d", "fa-hospital-symbol": "\uf47e", "fa-hot-tub": "\uf593", "fa-hotdog": "\uf80f", "fa-hotel": "\uf594", "fa-hotjar": "\uf3b1", "fa-hourglass": "\uf254", "fa-hourglass-end": "\uf253", "fa-hourglass-half": "\uf252", "fa-hourglass-start": "\uf251", "fa-house-damage": "\uf6f1", "fa-houzz": "\uf27c", "fa-hryvnia": "\uf6f2", "fa-html5": "\uf13b", "fa-hubspot": "\uf3b2", "fa-i-cursor": "\uf246", "fa-ice-cream": "\uf810", "fa-icicles": "\uf7ad", "fa-icons": "\uf86d", "fa-id-badge": "\uf2c1", "fa-id-card": "\uf2c2", "fa-id-card-alt": "\uf47f", "fa-igloo": "\uf7ae", "fa-image": "\uf03e", "fa-images": "\uf302", "fa-imdb": "\uf2d8", "fa-inbox": "\uf01c", "fa-indent": "\uf03c", "fa-industry": "\uf275", "fa-infinity": "\uf534", "fa-info": "\uf129", "fa-info-circle": "\uf05a", "fa-instagram": "\uf16d", "fa-intercom": "\uf7af", "fa-internet-explorer": "\uf26b", "fa-invision": "\uf7b0", "fa-ioxhost": "\uf208", "fa-italic": "\uf033", "fa-itch-io": "\uf83a", "fa-itunes": "\uf3b4", "fa-itunes-note": "\uf3b5", "fa-java": "\uf4e4", "fa-jedi": "\uf669", "fa-jedi-order": "\uf50e", "fa-jenkins": "\uf3b6", "fa-jira": "\uf7b1", "fa-joget": "\uf3b7", "fa-joint": "\uf595", "fa-joomla": "\uf1aa", "fa-journal-whills": "\uf66a", "fa-js": "\uf3b8", "fa-js-square": "\uf3b9", "fa-jsfiddle": "\uf1cc", "fa-kaaba": "\uf66b", "fa-kaggle": "\uf5fa", "fa-key": "\uf084", "fa-keybase": "\uf4f5", "fa-keyboard": "\uf11c", "fa-keycdn": "\uf3ba", "fa-khanda": "\uf66d", "fa-kickstarter": "\uf3bb", "fa-kickstarter-k": "\uf3bc", "fa-kiss": "\uf596", "fa-kiss-beam": "\uf597", "fa-kiss-wink-heart": "\uf598", "fa-kiwi-bird": "\uf535", "fa-korvue": "\uf42f", "fa-landmark": "\uf66f", "fa-language": "\uf1ab", "fa-laptop": "\uf109", "fa-laptop-code": "\uf5fc", "fa-laptop-medical": "\uf812", "fa-laravel": "\uf3bd", "fa-lastfm": "\uf202", "fa-lastfm-square": "\uf203", "fa-laugh": "\uf599", "fa-laugh-beam": "\uf59a", "fa-laugh-squint": "\uf59b", "fa-laugh-wink": "\uf59c", "fa-layer-group": "\uf5fd", "fa-leaf": "\uf06c", "fa-leanpub": "\uf212", "fa-lemon": "\uf094", "fa-less": "\uf41d", "fa-less-than": "\uf536", "fa-less-than-equal": "\uf537", "fa-level-down-alt": "\uf3be", "fa-level-up-alt": "\uf3bf", "fa-life-ring": "\uf1cd", "fa-lightbulb": "\uf0eb", "fa-line": "\uf3c0", "fa-link": "\uf0c1", "fa-linkedin": "\uf08c", "fa-linkedin-in": "\uf0e1", "fa-linode": "\uf2b8", "fa-linux": "\uf17c", "fa-lira-sign": "\uf195", "fa-list": "\uf03a", "fa-list-alt": "\uf022", "fa-list-ol": "\uf0cb", "fa-list-ul": "\uf0ca", "fa-location-arrow": "\uf124", "fa-lock": "\uf023", "fa-lock-open": "\uf3c1", "fa-long-arrow-alt-down": "\uf309", "fa-long-arrow-alt-left": "\uf30a", "fa-long-arrow-alt-right": "\uf30b", "fa-long-arrow-alt-up": "\uf30c", "fa-low-vision": "\uf2a8", "fa-luggage-cart": "\uf59d", "fa-lyft": "\uf3c3", "fa-magento": "\uf3c4", "fa-magic": "\uf0d0", "fa-magnet": "\uf076", "fa-mail-bulk": "\uf674", "fa-mailchimp": "\uf59e", "fa-male": "\uf183", "fa-mandalorian": "\uf50f", "fa-map": "\uf279", "fa-map-marked": "\uf59f", "fa-map-marked-alt": "\uf5a0", "fa-map-marker": "\uf041", "fa-map-marker-alt": "\uf3c5", "fa-map-pin": "\uf276", "fa-map-signs": "\uf277", "fa-markdown": "\uf60f", "fa-marker": "\uf5a1", "fa-mars": "\uf222", "fa-mars-double": "\uf227", "fa-mars-stroke": "\uf229", "fa-mars-stroke-h": "\uf22b", "fa-mars-stroke-v": "\uf22a", "fa-mask": "\uf6fa", "fa-mastodon": "\uf4f6", "fa-maxcdn": "\uf136", "fa-medal": "\uf5a2", "fa-medapps": "\uf3c6", "fa-medium": "\uf23a", "fa-medium-m": "\uf3c7", "fa-medkit": "\uf0fa", "fa-medrt": "\uf3c8", "fa-meetup": "\uf2e0", "fa-megaport": "\uf5a3", "fa-meh": "\uf11a", "fa-meh-blank": "\uf5a4", "fa-meh-rolling-eyes": "\uf5a5", "fa-memory": "\uf538", "fa-mendeley": "\uf7b3", "fa-menorah": "\uf676", "fa-mercury": "\uf223", "fa-meteor": "\uf753", "fa-microchip": "\uf2db", "fa-microphone": "\uf130", "fa-microphone-alt": "\uf3c9", "fa-microphone-alt-slash": "\uf539", "fa-microphone-slash": "\uf131", "fa-microscope": "\uf610", "fa-microsoft": "\uf3ca", "fa-minus": "\uf068", "fa-minus-circle": "\uf056", "fa-minus-square": "\uf146", "fa-mitten": "\uf7b5", "fa-mix": "\uf3cb", "fa-mixcloud": "\uf289", "fa-mizuni": "\uf3cc", "fa-mobile": "\uf10b", "fa-mobile-alt": "\uf3cd", "fa-modx": "\uf285", "fa-monero": "\uf3d0", "fa-money-bill": "\uf0d6", "fa-money-bill-alt": "\uf3d1", "fa-money-bill-wave": "\uf53a", "fa-money-bill-wave-alt": "\uf53b", "fa-money-check": "\uf53c", "fa-money-check-alt": "\uf53d", "fa-monument": "\uf5a6", "fa-moon": "\uf186", "fa-mortar-pestle": "\uf5a7", "fa-mosque": "\uf678", "fa-motorcycle": "\uf21c", "fa-mountain": "\uf6fc", "fa-mouse-pointer": "\uf245", "fa-mug-hot": "\uf7b6", "fa-music": "\uf001", "fa-napster": "\uf3d2", "fa-neos": "\uf612", "fa-network-wired": "\uf6ff", "fa-neuter": "\uf22c", "fa-newspaper": "\uf1ea", "fa-nimblr": "\uf5a8", "fa-node": "\uf419", "fa-node-js": "\uf3d3", "fa-not-equal": "\uf53e", "fa-notes-medical": "\uf481", "fa-npm": "\uf3d4", "fa-ns8": "\uf3d5", "fa-nutritionix": "\uf3d6", "fa-object-group": "\uf247", "fa-object-ungroup": "\uf248", "fa-odnoklassniki": "\uf263", "fa-odnoklassniki-square": "\uf264", "fa-oil-can": "\uf613", "fa-old-republic": "\uf510", "fa-om": "\uf679", "fa-opencart": "\uf23d", "fa-openid": "\uf19b", "fa-opera": "\uf26a", "fa-optin-monster": "\uf23c", "fa-osi": "\uf41a", "fa-otter": "\uf700", "fa-outdent": "\uf03b", "fa-page4": "\uf3d7", "fa-pagelines": "\uf18c", "fa-pager": "\uf815", "fa-paint-brush": "\uf1fc", "fa-paint-roller": "\uf5aa", "fa-palette": "\uf53f", "fa-palfed": "\uf3d8", "fa-pallet": "\uf482", "fa-paper-plane": "\uf1d8", "fa-paperclip": "\uf0c6", "fa-parachute-box": "\uf4cd", "fa-paragraph": "\uf1dd", "fa-parking": "\uf540", "fa-passport": "\uf5ab", "fa-pastafarianism": "\uf67b", "fa-paste": "\uf0ea", "fa-patreon": "\uf3d9", "fa-pause": "\uf04c", "fa-pause-circle": "\uf28b", "fa-paw": "\uf1b0", "fa-paypal": "\uf1ed", "fa-peace": "\uf67c", "fa-pen": "\uf304", "fa-pen-alt": "\uf305", "fa-pen-fancy": "\uf5ac", "fa-pen-nib": "\uf5ad", "fa-pen-square": "\uf14b", "fa-pencil-alt": "\uf303", "fa-pencil-ruler": "\uf5ae", "fa-penny-arcade": "\uf704", "fa-people-carry": "\uf4ce", "fa-pepper-hot": "\uf816", "fa-percent": "\uf295", "fa-percentage": "\uf541", "fa-periscope": "\uf3da", "fa-person-booth": "\uf756", "fa-phabricator": "\uf3db", "fa-phoenix-framework": "\uf3dc", "fa-phoenix-squadron": "\uf511", "fa-phone": "\uf095", "fa-phone-alt": "\uf879", "fa-phone-slash": "\uf3dd", "fa-phone-square": "\uf098", "fa-phone-square-alt": "\uf87b", "fa-phone-volume": "\uf2a0", "fa-photo-video": "\uf87c", "fa-php": "\uf457", "fa-pied-piper": "\uf2ae", "fa-pied-piper-alt": "\uf1a8", "fa-pied-piper-hat": "\uf4e5", "fa-pied-piper-pp": "\uf1a7", "fa-piggy-bank": "\uf4d3", "fa-pills": "\uf484", "fa-pinterest": "\uf0d2", "fa-pinterest-p": "\uf231", "fa-pinterest-square": "\uf0d3", "fa-pizza-slice": "\uf818", "fa-place-of-worship": "\uf67f", "fa-plane": "\uf072", "fa-plane-arrival": "\uf5af", "fa-plane-departure": "\uf5b0", "fa-play": "\uf04b", "fa-play-circle": "\uf144", "fa-playstation": "\uf3df", "fa-plug": "\uf1e6", "fa-plus": "\uf067", "fa-plus-circle": "\uf055", "fa-plus-square": "\uf0fe", "fa-podcast": "\uf2ce", "fa-poll": "\uf681", "fa-poll-h": "\uf682", "fa-poo": "\uf2fe", "fa-poo-storm": "\uf75a", "fa-poop": "\uf619", "fa-portrait": "\uf3e0", "fa-pound-sign": "\uf154", "fa-power-off": "\uf011", "fa-pray": "\uf683", "fa-praying-hands": "\uf684", "fa-prescription": "\uf5b1", "fa-prescription-bottle": "\uf485", "fa-prescription-bottle-alt": "\uf486", "fa-print": "\uf02f", "fa-procedures": "\uf487", "fa-product-hunt": "\uf288", "fa-project-diagram": "\uf542", "fa-pushed": "\uf3e1", "fa-puzzle-piece": "\uf12e", "fa-python": "\uf3e2", "fa-qq": "\uf1d6", "fa-qrcode": "\uf029", "fa-question": "\uf128", "fa-question-circle": "\uf059", "fa-quidditch": "\uf458", "fa-quinscape": "\uf459", "fa-quora": "\uf2c4", "fa-quote-left": "\uf10d", "fa-quote-right": "\uf10e", "fa-quran": "\uf687", "fa-r-project": "\uf4f7", "fa-radiation": "\uf7b9", "fa-radiation-alt": "\uf7ba", "fa-rainbow": "\uf75b", "fa-random": "\uf074", "fa-raspberry-pi": "\uf7bb", "fa-ravelry": "\uf2d9", "fa-react": "\uf41b", "fa-reacteurope": "\uf75d", "fa-readme": "\uf4d5", "fa-rebel": "\uf1d0", "fa-receipt": "\uf543", "fa-recycle": "\uf1b8", "fa-red-river": "\uf3e3", "fa-reddit": "\uf1a1", "fa-reddit-alien": "\uf281", "fa-reddit-square": "\uf1a2", "fa-redhat": "\uf7bc", "fa-redo": "\uf01e", "fa-redo-alt": "\uf2f9", "fa-registered": "\uf25d", "fa-remove-format": "\uf87d", "fa-renren": "\uf18b", "fa-reply": "\uf3e5", "fa-reply-all": "\uf122", "fa-replyd": "\uf3e6", "fa-republican": "\uf75e", "fa-researchgate": "\uf4f8", "fa-resolving": "\uf3e7", "fa-restroom": "\uf7bd", "fa-retweet": "\uf079", "fa-rev": "\uf5b2", "fa-ribbon": "\uf4d6", "fa-ring": "\uf70b", "fa-road": "\uf018", "fa-robot": "\uf544", "fa-rocket": "\uf135", "fa-rocketchat": "\uf3e8", "fa-rockrms": "\uf3e9", "fa-route": "\uf4d7", "fa-rss": "\uf09e", "fa-rss-square": "\uf143", "fa-ruble-sign": "\uf158", "fa-ruler": "\uf545", "fa-ruler-combined": "\uf546", "fa-ruler-horizontal": "\uf547", "fa-ruler-vertical": "\uf548", "fa-running": "\uf70c", "fa-rupee-sign": "\uf156", "fa-sad-cry": "\uf5b3", "fa-sad-tear": "\uf5b4", "fa-safari": "\uf267", "fa-salesforce": "\uf83b", "fa-sass": "\uf41e", "fa-satellite": "\uf7bf", "fa-satellite-dish": "\uf7c0", "fa-save": "\uf0c7", "fa-schlix": "\uf3ea", "fa-school": "\uf549", "fa-screwdriver": "\uf54a", "fa-scribd": "\uf28a", "fa-scroll": "\uf70e", "fa-sd-card": "\uf7c2", "fa-search": "\uf002", "fa-search-dollar": "\uf688", "fa-search-location": "\uf689", "fa-search-minus": "\uf010", "fa-search-plus": "\uf00e", "fa-searchengin": "\uf3eb", "fa-seedling": "\uf4d8", "fa-sellcast": "\uf2da", "fa-sellsy": "\uf213", "fa-server": "\uf233", "fa-servicestack": "\uf3ec", "fa-shapes": "\uf61f", "fa-share": "\uf064", "fa-share-alt": "\uf1e0", "fa-share-alt-square": "\uf1e1", "fa-share-square": "\uf14d", "fa-shekel-sign": "\uf20b", "fa-shield-alt": "\uf3ed", "fa-ship": "\uf21a", "fa-shipping-fast": "\uf48b", "fa-shirtsinbulk": "\uf214", "fa-shoe-prints": "\uf54b", "fa-shopping-bag": "\uf290", "fa-shopping-basket": "\uf291", "fa-shopping-cart": "\uf07a", "fa-shopware": "\uf5b5", "fa-shower": "\uf2cc", "fa-shuttle-van": "\uf5b6", "fa-sign": "\uf4d9", "fa-sign-in-alt": "\uf2f6", "fa-sign-language": "\uf2a7", "fa-sign-out-alt": "\uf2f5", "fa-signal": "\uf012", "fa-signature": "\uf5b7", "fa-sim-card": "\uf7c4", "fa-simplybuilt": "\uf215", "fa-sistrix": "\uf3ee", "fa-sitemap": "\uf0e8", "fa-sith": "\uf512", "fa-skating": "\uf7c5", "fa-sketch": "\uf7c6", "fa-skiing": "\uf7c9", "fa-skiing-nordic": "\uf7ca", "fa-skull": "\uf54c", "fa-skull-crossbones": "\uf714", "fa-skyatlas": "\uf216", "fa-skype": "\uf17e", "fa-slack": "\uf198", "fa-slack-hash": "\uf3ef", "fa-slash": "\uf715", "fa-sleigh": "\uf7cc", "fa-sliders-h": "\uf1de", "fa-slideshare": "\uf1e7", "fa-smile": "\uf118", "fa-smile-beam": "\uf5b8", "fa-smile-wink": "\uf4da", "fa-smog": "\uf75f", "fa-smoking": "\uf48d", "fa-smoking-ban": "\uf54d", "fa-sms": "\uf7cd", "fa-snapchat": "\uf2ab", "fa-snapchat-ghost": "\uf2ac", "fa-snapchat-square": "\uf2ad", "fa-snowboarding": "\uf7ce", "fa-snowflake": "\uf2dc", "fa-snowman": "\uf7d0", "fa-snowplow": "\uf7d2", "fa-socks": "\uf696", "fa-solar-panel": "\uf5ba", "fa-sort": "\uf0dc", "fa-sort-alpha-down": "\uf15d", "fa-sort-alpha-down-alt": "\uf881", "fa-sort-alpha-up": "\uf15e", "fa-sort-alpha-up-alt": "\uf882", "fa-sort-amount-down": "\uf160", "fa-sort-amount-down-alt": "\uf884", "fa-sort-amount-up": "\uf161", "fa-sort-amount-up-alt": "\uf885", "fa-sort-down": "\uf0dd", "fa-sort-numeric-down": "\uf162", "fa-sort-numeric-down-alt": "\uf886", "fa-sort-numeric-up": "\uf163", "fa-sort-numeric-up-alt": "\uf887", "fa-sort-up": "\uf0de", "fa-soundcloud": "\uf1be", "fa-sourcetree": "\uf7d3", "fa-spa": "\uf5bb", "fa-space-shuttle": "\uf197", "fa-speakap": "\uf3f3", "fa-speaker-deck": "\uf83c", "fa-spell-check": "\uf891", "fa-spider": "\uf717", "fa-spinner": "\uf110", "fa-splotch": "\uf5bc", "fa-spotify": "\uf1bc", "fa-spray-can": "\uf5bd", "fa-square": "\uf0c8", "fa-square-full": "\uf45c", "fa-square-root-alt": "\uf698", "fa-squarespace": "\uf5be", "fa-stack-exchange": "\uf18d", "fa-stack-overflow": "\uf16c", "fa-stackpath": "\uf842", "fa-stamp": "\uf5bf", "fa-star": "\uf005", "fa-star-and-crescent": "\uf699", "fa-star-half": "\uf089", "fa-star-half-alt": "\uf5c0", "fa-star-of-david": "\uf69a", "fa-star-of-life": "\uf621", "fa-staylinked": "\uf3f5", "fa-steam": "\uf1b6", "fa-steam-square": "\uf1b7", "fa-steam-symbol": "\uf3f6", "fa-step-backward": "\uf048", "fa-step-forward": "\uf051", "fa-stethoscope": "\uf0f1", "fa-sticker-mule": "\uf3f7", "fa-sticky-note": "\uf249", "fa-stop": "\uf04d", "fa-stop-circle": "\uf28d", "fa-stopwatch": "\uf2f2", "fa-store": "\uf54e", "fa-store-alt": "\uf54f", "fa-strava": "\uf428", "fa-stream": "\uf550", "fa-street-view": "\uf21d", "fa-strikethrough": "\uf0cc", "fa-stripe": "\uf429", "fa-stripe-s": "\uf42a", "fa-stroopwafel": "\uf551", "fa-studiovinari": "\uf3f8", "fa-stumbleupon": "\uf1a4", "fa-stumbleupon-circle": "\uf1a3", "fa-subscript": "\uf12c", "fa-subway": "\uf239", "fa-suitcase": "\uf0f2", "fa-suitcase-rolling": "\uf5c1", "fa-sun": "\uf185", "fa-superpowers": "\uf2dd", "fa-superscript": "\uf12b", "fa-supple": "\uf3f9", "fa-surprise": "\uf5c2", "fa-suse": "\uf7d6", "fa-swatchbook": "\uf5c3", "fa-swimmer": "\uf5c4", "fa-swimming-pool": "\uf5c5", "fa-symfony": "\uf83d", "fa-synagogue": "\uf69b", "fa-sync": "\uf021", "fa-sync-alt": "\uf2f1", "fa-syringe": "\uf48e", "fa-table": "\uf0ce", "fa-table-tennis": "\uf45d", "fa-tablet": "\uf10a", "fa-tablet-alt": "\uf3fa", "fa-tablets": "\uf490", "fa-tachometer-alt": "\uf3fd", "fa-tag": "\uf02b", "fa-tags": "\uf02c", "fa-tape": "\uf4db", "fa-tasks": "\uf0ae", "fa-taxi": "\uf1ba", "fa-teamspeak": "\uf4f9", "fa-teeth": "\uf62e", "fa-teeth-open": "\uf62f", "fa-telegram": "\uf2c6", "fa-telegram-plane": "\uf3fe", "fa-temperature-high": "\uf769", "fa-temperature-low": "\uf76b", "fa-tencent-weibo": "\uf1d5", "fa-tenge": "\uf7d7", "fa-terminal": "\uf120", "fa-text-height": "\uf034", "fa-text-width": "\uf035", "fa-th": "\uf00a", "fa-th-large": "\uf009", "fa-th-list": "\uf00b", "fa-the-red-yeti": "\uf69d", "fa-theater-masks": "\uf630", "fa-themeco": "\uf5c6", "fa-themeisle": "\uf2b2", "fa-thermometer": "\uf491", "fa-thermometer-empty": "\uf2cb", "fa-thermometer-full": "\uf2c7", "fa-thermometer-half": "\uf2c9", "fa-thermometer-quarter": "\uf2ca", "fa-thermometer-three-quarters": "\uf2c8", "fa-think-peaks": "\uf731", "fa-thumbs-down": "\uf165", "fa-thumbs-up": "\uf164", "fa-thumbtack": "\uf08d", "fa-ticket-alt": "\uf3ff", "fa-times": "\uf00d", "fa-times-circle": "\uf057", "fa-tint": "\uf043", "fa-tint-slash": "\uf5c7", "fa-tired": "\uf5c8", "fa-toggle-off": "\uf204", "fa-toggle-on": "\uf205", "fa-toilet": "\uf7d8", "fa-toilet-paper": "\uf71e", "fa-toolbox": "\uf552", "fa-tools": "\uf7d9", "fa-tooth": "\uf5c9", "fa-torah": "\uf6a0", "fa-torii-gate": "\uf6a1", "fa-tractor": "\uf722", "fa-trade-federation": "\uf513", "fa-trademark": "\uf25c", "fa-traffic-light": "\uf637", "fa-train": "\uf238", "fa-tram": "\uf7da", "fa-transgender": "\uf224", "fa-transgender-alt": "\uf225", "fa-trash": "\uf1f8", "fa-trash-alt": "\uf2ed", "fa-trash-restore": "\uf829", "fa-trash-restore-alt": "\uf82a", "fa-tree": "\uf1bb", "fa-trello": "\uf181", "fa-tripadvisor": "\uf262", "fa-trophy": "\uf091", "fa-truck": "\uf0d1", "fa-truck-loading": "\uf4de", "fa-truck-monster": "\uf63b", "fa-truck-moving": "\uf4df", "fa-truck-pickup": "\uf63c", "fa-tshirt": "\uf553", "fa-tty": "\uf1e4", "fa-tumblr": "\uf173", "fa-tumblr-square": "\uf174", "fa-tv": "\uf26c", "fa-twitch": "\uf1e8", "fa-twitter": "\uf099", "fa-twitter-square": "\uf081", "fa-typo3": "\uf42b", "fa-uber": "\uf402", "fa-ubuntu": "\uf7df", "fa-uikit": "\uf403", "fa-umbrella": "\uf0e9", "fa-umbrella-beach": "\uf5ca", "fa-underline": "\uf0cd", "fa-undo": "\uf0e2", "fa-undo-alt": "\uf2ea", "fa-uniregistry": "\uf404", "fa-universal-access": "\uf29a", "fa-university": "\uf19c", "fa-unlink": "\uf127", "fa-unlock": "\uf09c", "fa-unlock-alt": "\uf13e", "fa-untappd": "\uf405", "fa-upload": "\uf093", "fa-ups": "\uf7e0", "fa-usb": "\uf287", "fa-user": "\uf007", "fa-user-alt": "\uf406", "fa-user-alt-slash": "\uf4fa", "fa-user-astronaut": "\uf4fb", "fa-user-check": "\uf4fc", "fa-user-circle": "\uf2bd", "fa-user-clock": "\uf4fd", "fa-user-cog": "\uf4fe", "fa-user-edit": "\uf4ff", "fa-user-friends": "\uf500", "fa-user-graduate": "\uf501", "fa-user-injured": "\uf728", "fa-user-lock": "\uf502", "fa-user-md": "\uf0f0", "fa-user-minus": "\uf503", "fa-user-ninja": "\uf504", "fa-user-nurse": "\uf82f", "fa-user-plus": "\uf234", "fa-user-secret": "\uf21b", "fa-user-shield": "\uf505", "fa-user-slash": "\uf506", "fa-user-tag": "\uf507", "fa-user-tie": "\uf508", "fa-user-times": "\uf235", "fa-users": "\uf0c0", "fa-users-cog": "\uf509", "fa-usps": "\uf7e1", "fa-ussunnah": "\uf407", "fa-utensil-spoon": "\uf2e5", "fa-utensils": "\uf2e7", "fa-vaadin": "\uf408", "fa-vector-square": "\uf5cb", "fa-venus": "\uf221", "fa-venus-double": "\uf226", "fa-venus-mars": "\uf228", "fa-viacoin": "\uf237", "fa-viadeo": "\uf2a9", "fa-viadeo-square": "\uf2aa", "fa-vial": "\uf492", "fa-vials": "\uf493", "fa-viber": "\uf409", "fa-video": "\uf03d", "fa-video-slash": "\uf4e2", "fa-vihara": "\uf6a7", "fa-vimeo": "\uf40a", "fa-vimeo-square": "\uf194", "fa-vimeo-v": "\uf27d", "fa-vine": "\uf1ca", "fa-vk": "\uf189", "fa-vnv": "\uf40b", "fa-voicemail": "\uf897", "fa-volleyball-ball": "\uf45f", "fa-volume-down": "\uf027", "fa-volume-mute": "\uf6a9", "fa-volume-off": "\uf026", "fa-volume-up": "\uf028", "fa-vote-yea": "\uf772", "fa-vr-cardboard": "\uf729", "fa-vuejs": "\uf41f", "fa-walking": "\uf554", "fa-wallet": "\uf555", "fa-warehouse": "\uf494", "fa-water": "\uf773", "fa-wave-square": "\uf83e", "fa-waze": "\uf83f", "fa-weebly": "\uf5cc", "fa-weibo": "\uf18a", "fa-weight": "\uf496", "fa-weight-hanging": "\uf5cd", "fa-weixin": "\uf1d7", "fa-whatsapp": "\uf232", "fa-whatsapp-square": "\uf40c", "fa-wheelchair": "\uf193", "fa-whmcs": "\uf40d", "fa-wifi": "\uf1eb", "fa-wikipedia-w": "\uf266", "fa-wind": "\uf72e", "fa-window-close": "\uf410", "fa-window-maximize": "\uf2d0", "fa-window-minimize": "\uf2d1", "fa-window-restore": "\uf2d2", "fa-windows": "\uf17a", "fa-wine-bottle": "\uf72f", "fa-wine-glass": "\uf4e3", "fa-wine-glass-alt": "\uf5ce", "fa-wix": "\uf5cf", "fa-wizards-of-the-coast": "\uf730", "fa-wolf-pack-battalion": "\uf514", "fa-won-sign": "\uf159", "fa-wordpress": "\uf19a", "fa-wordpress-simple": "\uf411", "fa-wpbeginner": "\uf297", "fa-wpexplorer": "\uf2de", "fa-wpforms": "\uf298", "fa-wpressr": "\uf3e4", "fa-wrench": "\uf0ad", "fa-x-ray": "\uf497", "fa-xbox": "\uf412", "fa-xing": "\uf168", "fa-xing-square": "\uf169", "fa-y-combinator": "\uf23b", "fa-yahoo": "\uf19e", "fa-yammer": "\uf840", "fa-yandex": "\uf413", "fa-yandex-international": "\uf414", "fa-yarn": "\uf7e3", "fa-yelp": "\uf1e9", "fa-yen-sign": "\uf157", "fa-yin-yang": "\uf6ad", "fa-yoast": "\uf2b1", "fa-youtube": "\uf167"};


module.exports = {
    ForceDirectedGraphModel: ForceDirectedGraphModel,
    ForceDirectedGraphView: ForceDirectedGraphView
};
