# Generated by Django 3.2.4 on 2021-06-23 23:46

from django.db import migrations

QUESTIONS = [
    {
        "id": 1,
        "question_text": "How are you?",
        "pub_date": "1970-01-01T00:00:00Z"
    },
    {
        "id": 2,
        "question_text": "What's up?",
        "pub_date": "1970-01-01T00:00:00Z"
    },
    {
        "id": 3,
        "question_text": "How are you?",
        "pub_date": "1970-01-01T00:00:00Z"
    }
]

CHOICES = [
    {
        "id": 1,
        "question_id": 1,
        "choice_text": "Okay",
        "votes": 1
    },
    {
        "id": 2,
        "question_id": 1,
        "choice_text": "Great",
        "votes": 2
    },
    {
        "id": 3,
        "question_id": 1,
        "choice_text": "Ill",
        "votes": 1
    },
    {
        "id": 4,
        "question_id": 2,
        "choice_text": "Nothing",
        "votes": 3
    },
    {
        "id": 5,
        "question_id": 2,
        "choice_text": "A lot",
        "votes": 4
    },
]


def _populate_db(apps, schema_editor):
    db_alias = schema_editor.connection.alias
    Question = apps.get_model('polls', 'Question')
    Choice = apps.get_model('polls', 'Choice')

    for question in QUESTIONS:
        Question.objects.using(db_alias).create(**question)

    for choice in CHOICES:
        Choice.objects.using(db_alias).create(**choice)


def _backward(apps, schema_editor):
    db_alias = schema_editor.connection.alias
    Question = apps.get_model('polls', 'Question')
    Choice = apps.get_model('polls', 'Choice')

    for question in QUESTIONS:
        Question.objects.using(db_alias).filter(id=question['id']).delete()

    for choice in CHOICES:
        Choice.objects.using(db_alias).filter(id=choice['id']).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('polls', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(_populate_db, _backward),
    ]
