"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IDPPOCDecider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const sfn = require("aws-cdk-lib/aws-stepfunctions");
const tasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
class IDPPOCDecider extends sfn.StateMachineFragment {
    constructor(parent, id, props) {
        super(parent, id);
        var defaultClassification = '';
        var lambdaMemoryMB = 128;
        if (typeof (props.defaultClassification != 'undefined') && props.defaultClassification) {
            defaultClassification = props.defaultClassification;
        }
        if (typeof (props.lambdaMemoryMB != 0) && props.lambdaMemoryMB) {
            lambdaMemoryMB = props.lambdaMemoryMB;
        }
        const deciderFunction = new lambda.DockerImageFunction(this, 'TextractDecider', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/decider/')),
            memorySize: lambdaMemoryMB,
            environment: {
                DEFAULT_CLASSIFICATION: defaultClassification,
            },
        });
        deciderFunction.addToRolePolicy(new iam.PolicyStatement({ actions: ['s3:GetObject'], resources: ['*'] }));
        const deciderLambdaInvoke = new tasks.LambdaInvoke(this, 'deciderLambdaInvoke', {
            lambdaFunction: deciderFunction,
            timeout: aws_cdk_lib_1.Duration.seconds(100),
            outputPath: '$.Payload',
        });
        this.startState = deciderLambdaInvoke;
        this.endStates = [deciderLambdaInvoke];
    }
}
exports.IDPPOCDecider = IDPPOCDecider;
_a = JSII_RTTI_SYMBOL_1;
IDPPOCDecider[_a] = { fqn: "schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider", version: "0.0.1" };
//# sourceMappingURL=data:application/json;base64,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