import openpyxl
import requests

from ..base import Base


class MalwareArchaeology(Base):
    """
    Data Source: https://github.com/MalwareArchaeology/ATTACK
    Author:  Hacker Hurricane

    This class is a wrapper for the above data set
    """

    WIN_EVENTS_URL = 'https://raw.githubusercontent.com/MalwareArchaeology/ATTACK/master/Windows_Logging_Attack_Matrix_Win_Events_Sept_2018.xlsx'
    SYSMON_EVENTS_URL = 'https://raw.githubusercontent.com/MalwareArchaeology/ATTACK/master/Windows_Logging_Sysmon_LOG-MD_Attack_Matrix_Sept_2018.xlsx'

    def get(self):
        response = requests.get(self.WIN_EVENTS_URL)
        open("Win_Logging_Basic.xlsx", "wb").write(response.content)
        workbook = openpyxl.load_workbook(
            filename="Win_Logging_Basic.xlsx"
        )
        columns = None
        for item in workbook["Win_Logging_Basic"].values:
            if not columns:
                columns = item
            else:
                technique = item[3]
                if technique and technique.startswith('T1'):
                    name_list = []
                    for i in item[4:-1]:
                        if i:
                            name_list.append(i)
                    self.generated_data.add_possible_detection(
                        technique_id=technique,
                        data=name_list
                    )

        response = requests.get(self.SYSMON_EVENTS_URL)
        open("Windows_Logging_Sysmon_LOG.xlsx", "wb").write(response.content)
        workbook = openpyxl.load_workbook(
            filename="Windows_Logging_Sysmon_LOG.xlsx"
        )
        columns = None
        for item in workbook["Win Logging Basic Sysmon LOG-MD"].values:
            if not columns:
                columns = item
            else:
                technique = item[3]
                if technique and technique.startswith('T1'):
                    name_list = []
                    for i in item[4:-1]:
                        if i:
                            name_list.append(i)
                    self.generated_data.add_possible_detection(
                        technique_id=technique,
                        data=name_list
                    )
