option(RTVAMP_ENABLE_CPPCHECK "Enable static analysis with cppcheck" OFF)
if(RTVAMP_ENABLE_CPPCHECK)
    find_program(CPPCHECK cppcheck)
    if(CPPCHECK)
        set(CMAKE_CXX_CPPCHECK
            ${CPPCHECK}
            --suppress=missingInclude
            --enable=all
            --inline-suppr
            --inconclusive
        )
        if(${CMAKE_CXX_STANDARD})
            set(CMAKE_CXX_CPPCHECK ${CMAKE_CXX_CPPCHECK} --std=c++${CMAKE_CXX_STANDARD})
        endif()
        if(WARNINGS_AS_ERRORS)
            list(APPEND CMAKE_CXX_CPPCHECK --error-exitcode=2)
        endif()
    else()
        message(${WARNING_MESSAGE} "cppcheck requested but executable not found")
    endif()
endif()

option(RTVAMP_ENABLE_CLANG_TIDY "Enable static analysis with clang-tidy" OFF)
if(RTVAMP_ENABLE_CLANG_TIDY)
    find_program(CLANGTIDY clang-tidy)
    if(CLANGTIDY)
        set(CMAKE_CXX_CLANG_TIDY ${CLANGTIDY} -extra-arg=-Wno-unknown-warning-option)
    if(${CMAKE_CXX_STANDARD})
        set(CMAKE_CXX_CLANG_TIDY ${CMAKE_CXX_CLANG_TIDY} -extra-arg=-std=c++${CMAKE_CXX_STANDARD})
    endif()
    if(WARNINGS_AS_ERRORS)
        list(APPEND CMAKE_CXX_CLANG_TIDY -warnings-as-errors=*)
    endif()
    else()
        message(${WARNING_MESSAGE} "clang-tidy requested but executable not found")
    endif()
endif()

option(RTVAMP_ENABLE_INCLUDE_WHAT_YOU_USE "Enable static analysis with include-what-you-use" OFF)
if(RTVAMP_ENABLE_INCLUDE_WHAT_YOU_USE)
    find_program(INCLUDE_WHAT_YOU_USE include-what-you-use)
    if(INCLUDE_WHAT_YOU_USE)
        set(CMAKE_CXX_INCLUDE_WHAT_YOU_USE ${INCLUDE_WHAT_YOU_USE})
    else()
        message(${WARNING_MESSAGE} "include-what-you-use requested but executable not found")
    endif()
endif()
