from typing import Any, Callable, Collection, Iterable, Optional, Type, Union

from django.db import IntegrityError
from django.db.models.base import Model
from django.db.models.fields import Field
from django.db.models.options import Options

def CASCADE(collector: Any, field: Any, sub_objs: Any, using: Any) -> Any: ...
def SET_NULL(collector: Any, field: Any, sub_objs: Any, using: Any) -> Any: ...
def SET_DEFAULT(collector: Any, field: Any, sub_objs: Any, using: Any) -> Any: ...
def DO_NOTHING(collector: Any, field: Any, sub_objs: Any, using: Any) -> Any: ...
def PROTECT(collector: Any, field: Any, sub_objs: Any, using: Any) -> Any: ...
def RESTRICT(collector: Any, field: Any, sub_objs: Any, using: Any) -> Any: ...
def SET(value: Any) -> Callable[..., Any]: ...
def get_candidate_relations_to_delete(
    opts: Options[Any],
) -> Iterable[Field[Any, Any]]: ...

class ProtectedError(IntegrityError): ...
class RestrictedError(IntegrityError): ...

class Collector:
    def __init__(self, using: str) -> None: ...
    def collect(
        self,
        objs: Collection[Optional[Model]],
        source: Optional[Type[Model]] = ...,
        source_attr: Optional[str] = ...,
        **kwargs: Any
    ) -> None: ...
    def can_fast_delete(
        self,
        objs: Union[Model, Iterable[Model]],
        from_field: Optional[Field[Any, Any]] = ...,
    ) -> bool: ...
