# -*- coding: utf-8 -*-
# Generated by Django 1.11.9 on 2018-01-08 20:21
from __future__ import unicode_literals

import datetime
from django.db import migrations, models
from entity_history.sql.foreign_keys import EntityHistoryForeignKeys

from entity_history.sql.triggers import EntityActivationTrigger, EntityRelationshipActivationImmediateTrigger


def refresh_entity_activation_trigger(*args, **kwargs):
    EntityActivationTrigger().disable()
    EntityActivationTrigger().enable()


def refresh_entity_relationship_activation_trigger(*args, **kwargs):
    EntityRelationshipActivationImmediateTrigger().disable()
    EntityRelationshipActivationImmediateTrigger().enable()


def update_foreign_keys(*args, **kwargs):
    EntityHistoryForeignKeys().enable_cascade_delete()


class Migration(migrations.Migration):

    dependencies = [
        ('entity_history', '0004_update_triggers_and_foreign_keys'),
    ]

    operations = [
        migrations.AddField(
            model_name='entityactivationevent',
            name='creation_time',
            field=models.DateTimeField(db_index=True, default=datetime.datetime.utcnow, help_text=b'The time that this entry was created'),
        ),
        migrations.AddField(
            model_name='entityactivationevent',
            name='updated_time',
            field=models.DateTimeField(db_index=True, default=datetime.datetime.utcnow, help_text=b'The time that this entry was updated'),
        ),
        migrations.AddField(
            model_name='entityrelationshipactivationevent',
            name='creation_time',
            field=models.DateTimeField(db_index=True, default=datetime.datetime.utcnow, help_text=b'The time that this entry was created'),
        ),
        migrations.AddField(
            model_name='entityrelationshipactivationevent',
            name='updated_time',
            field=models.DateTimeField(db_index=True, default=datetime.datetime.utcnow, help_text=b'The time that this entry was updated'),
        ),
        migrations.AlterField(
            model_name='entityactivationevent',
            name='time',
            field=models.DateTimeField(db_index=True, default=datetime.datetime.utcnow, help_text=b'The time of the activation / deactivation'),
        ),
        migrations.AlterField(
            model_name='entityrelationshipactivationevent',
            name='time',
            field=models.DateTimeField(db_index=True, default=datetime.datetime.utcnow, help_text=b'The time of the activation / deactivation'),
        ),
        migrations.RunPython(
            code=refresh_entity_activation_trigger,
        ),
        migrations.RunPython(
            code=refresh_entity_relationship_activation_trigger
        ),
        migrations.RunPython(
            code=update_foreign_keys
        )
    ]
