import os
import re
from dateutil.tz import tzutc, tzlocal


# default NDS server
NDSSERVER = 'nds.ligo.caltech.edu:31200'


# date/time formatting for GPS conversion
if os.getenv('DATETIME_TZ') == 'LOCAL':
    DATETIME_TZ = tzlocal()
else:
    DATETIME_TZ = tzutc()
# FIXME: why does '%c' without explicit TZ give very wrong values??
#DATETIME_FMT = '%c'
DATETIME_FMT = '%a %b %d %Y %H:%M:%S %Z'
DATETIME_FMT_OFFLINE = '%Y/%m/%d %H:%M:%S %Z'


# default plot time window
DEFAULT_TIME_WINDOW_ONLINE = (-2, 0)
DEFAULT_TIME_WINDOW_OFFLINE = (-10, 10)


# percentage of full span to add as additional padding when fetching
# new data
DATA_SPAN_PADDING = 0.5


# max viewable seconds for the various trend data
TREND_MAX_SECONDS = {
    'raw': 120,
    'sec': 86400,
    # FIXME: this is too big
    'min': 52560000,
}


# number of lookback bytes available per channel
# 2**22:             4194304
# one week of 16 Hz: 4838400
# 60s of 16k Hz:     7864320
# 2**23:             8388608
DATA_LOOKBACK_LIMIT_BYTES = 2**22


CHANNEL_REGEXP = '^([a-zA-Z0-9-]+:)?[a-zA-Z0-9-_\.]+$'
CHANNEL_RE = re.compile(CHANNEL_REGEXP)


# minimum GPS time supported
# 2010-01-01 00:00 UTC
GPS_MIN = 946339215


TD_UNIT_MAP = [
    ('years', 31536000, '{td.years}y'),
    ('weeks', 7*86400, '{td.weeks}w'),
    ('days', 86400, '{td.days}d'),
    ('hours', 3600, '{td.hours}h'),
    ('minutes', 60, '{td.minutes}m'),
    ('seconds', 1, '{td.seconds}s'),
    ('msecs', 0.001, '{td.msecs}ms'),
    ('usecs', 0.000001, '{td.usecs}μs'),
    ('nsecs', 0.000000001, '{td.nsecs}ns'),
]


# tuples of major tick spacing and minor tick division
TICK_SPACINGS = [
    (31536000, 4),

    (31536000/5, 1),
    (56*86400, 8),
    (28*86400, 4),
    (21*86400, 3),
    (14*86400, 2),
    (7*86400, 7),
    (2*86400, 2),
    (86400, 4),

    (12*3600, 4),
    (6*3600, 6),
    (3*3600, 3),
    (2*3600, 4),
    (3600, 6),

    (30*60, 3),
    (15*60, 3),
    (10*60, 2),
    (5*60, 5),
    (2*60, 4),
    (60, 6),

    (30, 3),
    (15, 3),
    (10, 2),
    (5, 5),
    (2, 2),
    (1, 4),

    (0.500000000, 2),
    (0.250000000, 5),
    (0.125000000, 5),
    (0.100000000, 4),
    (0.050000000, 2),
    (0.025000000, 5),
    (0.012500000, 5),
    (0.010000000, 4),
    (0.005000000, 2),
    (0.002500000, 5),
    (0.001250000, 5),
    (0.001000000, 4),
    (0.000500000, 2),
    (0.000250000, 5),
    (0.000125000, 5),
    (0.000100000, 4),
    (0.000050000, 2),
    (0.000025000, 5),
    (0.000012500, 5),
    (0.000010000, 4),
    (0.000005000, 2),
    (0.000002500, 5),
    (0.000001250, 5),
    (0.000001000, 4),
    (0.000000500, 2),
    (0.000000250, 5),
    (0.000000125, 5),
    (0.000000100, 4),
    (0.000000050, 2),
    (0.000000025, 5),
    (0.000000010, 4),
    (0.000000005, 2),
]
