# GetStream Kokoro Plugin

This package integrates the open-weight [Kokoro-82M TTS model](https://github.com/hexgrad/kokoro) with the GetStream audio/video SDK.

It provides a drop-in `KokoroTTS` class that implements the common `getstream_common.tts.TTS` interface, allowing you to stream PCM audio generated by Kokoro directly into a WebRTC `AudioStreamTrack`.

```py
from getstream.plugins.kokoro import KokoroTTS
from getstream.video.rtc.audio_track import AudioStreamTrack

track = AudioStreamTrack(framerate=24_000)

tts = KokoroTTS(lang_code="a", voice="af_heart")
tts.set_output_track(track)

await tts.send("Hello from Kokoro!")
```

## Installation

```bash
pip install getstream-plugins-kokoro
```

This will pull in the required `kokoro`, `numpy` and `getstream[webrtc"]` dependencies.  You also need `espeak-ng` **at runtime** for pronunciation fallback.  On macOS you can install it with Homebrew:

```bash
brew install espeak-ng
```

## Configuration options

| Parameter | Default | Description |
|-----------|---------|-------------|
| `lang_code` | `"a"` | Language group passed to `KPipeline` (`"a"` = American English, etc.) |
| `voice` | `"af_heart"` | Kokoro voice preset.  See the [model card](https://huggingface.co/NeuML/kokoro-int8-onnx#speaker-reference) for available options. |
| `speed` | `1.0` | Playback speed multiplier. |
| `sample_rate` | `24000` | Output sample-rate (fixed by Kokoro).  **The attached `AudioStreamTrack` must use the same value.** |
