# Honeycomb OpenTelemetry Distro for Python

[![OSS Lifecycle](https://img.shields.io/osslifecycle/honeycombio/honeycomb-opentelemetry-python)](https://github.com/honeycombio/home/blob/main/honeycomb-oss-lifecycle-and-practices.md)
[![CircleCI](https://circleci.com/gh/honeycombio/honeycomb-opentelemetry-python.svg?style=shield)](https://circleci.com/gh/honeycombio/honeycomb-opentelemetry-python)

This is Honeycomb's Distribution of OpenTelemetry for Python.
It makes getting started with OpenTelemetry and Honeycomb easier!

Latest release built with:

- [OpenTelemetry version 1.16.0/0.37b0](https://github.com/open-telemetry/opentelemetry-python/releases/tag/v1.16.0)

## Requirements

- Python 3.7 or higher

## Getting Started

Honeycomb's Distribution of OpenTelemetry for Python allows you to streamline configuration and to instrument as quickly and easily as possible.

- [Documentation](https://docs.honeycomb.io/getting-data-in/opentelemetry/python/)
- [Examples](/examples/)
- See [DEVELOPING.md](/DEVELOPING.md) for additional instructions for building and testing this project in development.

## Why would I want to use this?

- Streamlined configuration for sending data to Honeycomb!
- Easy interop with existing instrumentation with OpenTelemetry!
- Deterministic sampling!
- Multi-span attributes!
- Local visualizations!

## License

[Apache 2.0 License](./LICENSE).
