# --- MEPA ---
# Read config file
# Read Excel file generated by Ready Pro
# Copy rows into Excel file generated by acquistinretepa
# Save

import os.path

from xlrd import open_workbook
from xlutils.copy import copy
import chromedriver_binary
from selenium import webdriver

from .supplier import Supplier, ScappamentoError, browser_login


supplier_name = 'MEPA'


def update():
    # Config, filenames
    key_list = ['readypro_excel_filename',  # TODO: more consistency in <filename> vs <fully qualified path> stuff
                'mepa_excel_filename',
                'new_excel_filename',
                'target_path',
                'login_url',
                'sostituzione_url',
                'upload_url',
                'user',
                'user_css_selector',
                'password',
                'password_css_selector',
                'butt_css_selector',
                'pop_css_selector']
    mepa = Supplier(supplier_name, key_list)

    print(mepa)  # Title

    [readypro_excel_filename,
     mepa_excel_filename,
     new_excel_filename,
     target_path,
     login_url,
     sostituzione_url,
     upload_url,
     user,
     user_css_selector,
     password,
     password_css_selector,
     butt_css_selector,
     pop_css_selector] = mepa.val_list

    # Copy data from generated spreadsheet to downloaded to-edit one
    readypro_xls = open_workbook(readypro_excel_filename)
    mepa_xls_model = open_workbook(mepa_excel_filename, formatting_info=True)

    mepa_xls_new = copy(mepa_xls_model)

    mepa_sheet = mepa_xls_new.get_sheet(1)
    readypro_sheet = readypro_xls.sheet_by_index(0)  # get_sheet() throws an error

    for i in range(1, readypro_sheet.nrows):  # rows (skip header)
        for j in range(0, 20):  # cols
            marca = False
            for m in range(14, 18):  # Marca (A-D) = campo 14 (14 0-based with offset)
                marca = marca or readypro_sheet.cell_value(i, m)

            if marca and readypro_sheet.cell_value(i, 1):  # CodArt Produttore = campo 1
                mepa_sheet.write(i, j, readypro_sheet.cell_value(i, j+1))  # offset read, column 0 is empty

    mepa_xls_new.save(os.path.join(target_path, new_excel_filename))

    cookies = browser_login(login_url, user_css_selector, user, password_css_selector, password, butt_css_selector,
                            pop_css_selector)

    options = webdriver.ChromeOptions()
    options.add_argument('--headless')
    with webdriver.Chrome(options=options) as driver:
        for cookie in cookies:
            driver.add_cookie(cookie)

        driver.get(upload_url)

    # TODO: Travis notes https://travis-ci.org/
    #  https://www.google.com/search?q=python+travis+ci&oq=python+travis+ci&aqs=chrome..69i57j69i60l2j0i22i30l4.3591j0j1&sourceid=chrome&ie=UTF-8
    #  https://docs.travis-ci.com/user/languages/python/
    #  https://docs.travis-ci.com/user/tutorial/
    #  https://docs.travis-ci.com/user/customizing-the-build/
    #  https://blog.travis-ci.com/2019-08-07-extensive-python-testing-on-travis-ci
    #  https://travis-ci.com/signup
    #  https://docs.travis-ci.com/user/deployment/pypi/
    #  https://realpython.com/python-testing/

    # TODO: (old) Config default location (_common) is done
    #  Handling missing config > creating default config might necessitate for
    #   <key_list> to be public in all modules as well
    #  -> Loop over modules (maybe the ones in exposed command list?)
    #  treat module as class? call update() on module name, idk
    #  write first test


if __name__ == '__main__':
    update()
