"""empty message

Revision ID: b097e47ba829
Revises: 45219f25072b
Create Date: 2021-05-20 15:40:47.288721

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'b097e47ba829'
down_revision = '45219f25072b'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('experiment_runs', 'matrices_errored',
               existing_type=sa.INTEGER(),
               nullable=True,
               schema='triage_metadata')
    op.alter_column('experiment_runs', 'matrices_made',
               existing_type=sa.INTEGER(),
               nullable=True,
               schema='triage_metadata')
    op.alter_column('experiment_runs', 'matrices_skipped',
               existing_type=sa.INTEGER(),
               nullable=True,
               schema='triage_metadata')
    op.alter_column('experiment_runs', 'models_errored',
               existing_type=sa.INTEGER(),
               nullable=True,
               schema='triage_metadata')
    op.alter_column('experiment_runs', 'models_made',
               existing_type=sa.INTEGER(),
               nullable=True,
               schema='triage_metadata')
    op.alter_column('experiment_runs', 'models_skipped',
               existing_type=sa.INTEGER(),
               nullable=True,
               schema='triage_metadata')
    op.drop_column('experiments', 'random_seed', schema='triage_metadata')
    op.create_index(op.f('ix_triage_metadata_matrices_matrix_uuid'), 'matrices', ['matrix_uuid'], unique=True, schema='triage_metadata')
    op.drop_index('ix_model_metadata_matrices_matrix_uuid', table_name='matrices', schema='triage_metadata')
    op.create_index(op.f('ix_triage_metadata_models_model_hash'), 'models', ['model_hash'], unique=True, schema='triage_metadata')
    op.drop_index('ix_model_metadata_models_model_hash', table_name='models', schema='triage_metadata')
    op.create_foreign_key('models_built_in_experiment_run_fkey', 'models', 'experiment_runs', ['built_in_experiment_run'], ['id'], source_schema='triage_metadata', referent_schema='triage_metadata')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('models_built_in_experiment_run_fkey', 'models', schema='triage_metadata', type_='foreignkey')
    op.create_index('ix_model_metadata_models_model_hash', 'models', ['model_hash'], unique=True, schema='triage_metadata')
    op.drop_index(op.f('ix_triage_metadata_models_model_hash'), table_name='models', schema='triage_metadata')
    op.create_index('ix_model_metadata_matrices_matrix_uuid', 'matrices', ['matrix_uuid'], unique=True, schema='triage_metadata')
    op.drop_index(op.f('ix_triage_metadata_matrices_matrix_uuid'), table_name='matrices', schema='triage_metadata')
    op.add_column('experiments', sa.Column('random_seed', sa.INTEGER(), autoincrement=False, nullable=True), schema='triage_metadata')
    op.alter_column('experiment_runs', 'models_skipped',
               existing_type=sa.INTEGER(),
               nullable=False,
               schema='triage_metadata')
    op.alter_column('experiment_runs', 'models_made',
               existing_type=sa.INTEGER(),
               nullable=False,
               schema='triage_metadata')
    op.alter_column('experiment_runs', 'models_errored',
               existing_type=sa.INTEGER(),
               nullable=False,
               schema='triage_metadata')
    op.alter_column('experiment_runs', 'matrices_skipped',
               existing_type=sa.INTEGER(),
               nullable=False,
               schema='triage_metadata')
    op.alter_column('experiment_runs', 'matrices_made',
               existing_type=sa.INTEGER(),
               nullable=False,
               schema='triage_metadata')
    op.alter_column('experiment_runs', 'matrices_errored',
               existing_type=sa.INTEGER(),
               nullable=False,
               schema='triage_metadata')
    # ### end Alembic commands ###
