"""Changing column names and removing redundancies in table names

Revision ID: 2446a931de7a
Revises: 89a8ce240bae
Create Date: 2018-05-24 17:07:20.567789

"""
from alembic import op

# revision identifiers, used by Alembic.
revision = "2446a931de7a"
down_revision = "89a8ce240bae"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute(
        "ALTER TABLE test_results.test_evaluations RENAME TO evaluations;"
        + "ALTER TABLE test_results.test_predictions RENAME TO predictions;"
        + "ALTER TABLE train_results.train_evaluations RENAME TO evaluations;"
        + "ALTER TABLE train_results.train_predictions RENAME TO predictions;"
    )

    op.alter_column(
        "matrices",
        "n_examples",
        new_column_name="num_observations",
        schema="model_metadata",
    )
    op.alter_column(
        "model_groups",
        "model_parameters",
        new_column_name="hyperparameters",
        schema="model_metadata",
    )
    op.alter_column(
        "models",
        "model_parameters",
        new_column_name="hyperparameters",
        schema="model_metadata",
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute(
        "ALTER TABLE test_results.evaluations RENAME TO test_evaluations;"
        + "ALTER TABLE test_results.predictions RENAME TO test_predictions;"
        + "ALTER TABLE train_results.evaluations RENAME TO train_evaluations;"
        + "ALTER TABLE train_results.predictions RENAME TO train_predictions;"
    )

    op.alter_column(
        "matrices",
        "num_observations",
        new_column_name="n_examples",
        schema="model_metadata",
    )
    op.alter_column(
        "model_groups",
        "hyperparameters",
        new_column_name="model_parameters",
        schema="model_metadata",
    )
    op.alter_column(
        "models",
        "hyperparameters",
        new_column_name="model_parameters",
        schema="model_metadata",
    )

    # ### end Alembic commands ###
