## Contents

- `batchx` package containing `bx` main application module.

## How to use

1. Import library:
```
from batchx import bx
```
2. Connect to server and provide authentication credentials:
```
bx.connect(<BATCHX_ENDPOINT>, <BATCHX_TOKEN>)
```
3. Instantiate service class. For example:
```
user_service = bx.UserService()
```
4. Create data request. For example:
```
request = user_service.GetUserDataRequest(user="nacho")
```
5. Call remote service. For example:
```
response = user_service.GetUserData(request)
```

## Install from git repository. Please change <BRANCH> for the correct branch name:
```
$ pip install git+ssh://git@github.com/batchx/api.git@<BRANCH>#subdirectory=python/dist
```


## Dependencies
- grpc
- retry
- PyJWT==1.7.1 <-- Important! Don't use PyJWT > 2.0