#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['nsist',
 'nsist.tests',
 'nsist.tests.console_example.sample_printer',
 'nsist.tests.sample_pkgs.plainpkg',
 'nsist.tests.sample_pkgs.unix_extpkg',
 'nsist.tests.sample_pkgs.win_extpkg']

package_data = \
{'': ['*'],
 'nsist': ['msvcrt/*', 'msvcrt/x64/*', 'msvcrt/x86/*'],
 'nsist.tests': ['console_example/*',
                 'data_files/*',
                 'data_files/dir1/*',
                 'data_files/dir1/subdir/*',
                 'data_files/dir2/*',
                 'data_files/dir2/subdir/*',
                 'sample_pkgs/*']}

install_requires = \
['requests', 'requests_download', 'jinja2', 'yarg', 'distlib >=0.3']

extras_require = \
{'test': ['testpath', 'responses']}

entry_points = \
{'console_scripts': ['pynsist = nsist:main']}

setup(name='pynsist',
      version='2.6',
      description='Build NSIS installers for Python applications.',
      author='Thomas Kluyver',
      author_email='thomas@kluyver.me.uk',
      url='https://pynsist.readthedocs.io/en/latest/',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.5',
     )
