import logging
from typing import List

from buco_db_controller.mongo_db.mongo_db_repository import MongoDBBaseRepository

logger = logging.getLogger(__name__)


class TeamStatsRepository(MongoDBBaseRepository):
    DB_NAME = 'api_football'

    def __init__(self):
        super().__init__(self.DB_NAME)

    def upsert_many_team_stats(self, team_stats: List[dict]):
        self.bulk_upsert_documents('teams_stats', team_stats)
        logger.info('Upserted team stats data')

    def get_team_stats(self, team_id: int, league_id: int, season: int) -> list:
        query = {'parameters.team': team_id, 'parameters.league': league_id, 'parameters.season': season}
        team_stats = self.find_document('teams_stats', query)
        logger.info(f'Fetching stats for team {team_id} for league {league_id} for season {season}')
        return team_stats
