from youtube_easy_api.easy_wrapper import *

PROJECT_PATH = os.path.abspath(os.path.join(os.path.abspath(__file__), os.pardir))
CREDENTIALS_PATH = '../../../Secrets/YouTube'


def test_get_metadata_01():
    easy_wrapper = YoutubeEasyWrapper()
    easy_wrapper.initialize(credentials_path=CREDENTIALS_PATH)
    metadata = easy_wrapper.get_metadata(video_id='rfscVS0vtbw')
    print(metadata['comments'][0])


def test_get_metadata_02():
    easy_wrapper = YoutubeEasyWrapper()
    easy_wrapper.initialize(credentials_path=CREDENTIALS_PATH)
    metadata = easy_wrapper.get_metadata(video_id='rdjnkb4ONWk')
    print(metadata['statistics']['likeCount'])
    assert metadata['title'] == 'The Pink Panther Show Episode 59 - Slink Pink'


def test_search_videos_01():
    easy_wrapper = YoutubeEasyWrapper()
    easy_wrapper.initialize(credentials_path=CREDENTIALS_PATH)
    results = easy_wrapper.search_videos(search_keyword='python', order='relevance')
    order_id = 1
    video_id = results[order_id]['video_id']
    assert video_id == '_uQrJ0TkZlc'


def test_search_videos_02():
    easy_wrapper = YoutubeEasyWrapper()
    easy_wrapper.initialize(credentials_path=CREDENTIALS_PATH)
    results = easy_wrapper.search_videos(search_keyword='python', order='relevance')
    order_id = 1
    print(results[order_id]['video_id'])

