import { Test } from 'nodeunit';
declare const _default: {
    'default properties': {
        'hash key only'(test: Test): void;
        'removalPolicy is DESTROY'(test: Test): void;
        'hash + range key'(test: Test): void;
        'hash + range key can also be specified in props'(test: Test): void;
        'point-in-time recovery is not enabled'(test: Test): void;
        'server-side encryption is not enabled'(test: Test): void;
        'stream is not enabled'(test: Test): void;
        'ttl is not enabled'(test: Test): void;
        'can specify new and old images'(test: Test): void;
        'can specify new images only'(test: Test): void;
        'can specify old images only'(test: Test): void;
    };
    'when specifying every property'(test: Test): void;
    'when specifying PAY_PER_REQUEST billing mode'(test: Test): void;
    'error when specifying read or write capacity with a PAY_PER_REQUEST billing mode'(test: Test): void;
    'when adding a global secondary index with hash key only'(test: Test): void;
    'when adding a global secondary index with hash + range key'(test: Test): void;
    'when adding a global secondary index with projection type KEYS_ONLY'(test: Test): void;
    'when adding a global secondary index with projection type INCLUDE'(test: Test): void;
    'when adding a global secondary index on a table with PAY_PER_REQUEST billing mode'(test: Test): void;
    'error when adding a global secondary index with projection type INCLUDE, but without specifying non-key attributes'(test: Test): void;
    'error when adding a global secondary index with projection type ALL, but with non-key attributes'(test: Test): void;
    'error when adding a global secondary index with projection type KEYS_ONLY, but with non-key attributes'(test: Test): void;
    'error when adding a global secondary index with projection type INCLUDE, but with more than 20 non-key attributes'(test: Test): void;
    'error when adding a global secondary index with projection type INCLUDE, but with key attributes'(test: Test): void;
    'error when adding a global secondary index with read or write capacity on a PAY_PER_REQUEST table'(test: Test): void;
    'when adding multiple global secondary indexes'(test: Test): void;
    'when adding a global secondary index without specifying read and write capacity'(test: Test): void;
    'when adding a local secondary index with hash + range key'(test: Test): void;
    'when adding a local secondary index with projection type KEYS_ONLY'(test: Test): void;
    'when adding a local secondary index with projection type INCLUDE'(test: Test): void;
    'error when adding more than 5 local secondary indexes'(test: Test): void;
    'error when adding a local secondary index with the name of a global secondary index'(test: Test): void;
    'error when validating construct if a local secondary index exists without a sort key of the table'(test: Test): void;
    'can enable Read AutoScaling'(test: Test): void;
    'can enable Write AutoScaling'(test: Test): void;
    'cannot enable AutoScaling twice on the same property'(test: Test): void;
    'error when enabling AutoScaling on the PAY_PER_REQUEST table'(test: Test): void;
    'error when specifying Read Auto Scaling with invalid scalingTargetValue < 10'(test: Test): void;
    'error when specifying Read Auto Scaling with invalid minimumCapacity'(test: Test): void;
    'can autoscale on a schedule'(test: Test): void;
    metrics: {
        'Can use metricConsumedReadCapacityUnits on a Dynamodb Table'(test: Test): void;
        'Can use metricConsumedWriteCapacityUnits on a Dynamodb Table'(test: Test): void;
        'Can use metricSystemErrors on a Dynamodb Table'(test: Test): void;
        'Can use metricUserErrors on a Dynamodb Table'(test: Test): void;
        'Can use metricConditionalCheckFailedRequests on a Dynamodb Table'(test: Test): void;
        'Can use metricSuccessfulRequestLatency on a Dynamodb Table'(test: Test): void;
    };
    grants: {
        '"grant" allows adding arbitrary actions associated with this table resource'(test: Test): void;
        '"grantReadData" allows the principal to read data from the table'(test: Test): void;
        '"grantWriteData" allows the principal to write data to the table'(test: Test): void;
        '"grantReadWriteData" allows the principal to read/write data'(test: Test): void;
        '"grantFullAccess" allows the principal to perform any action on the table ("*")'(test: Test): void;
        '"Table.grantListStreams" allows principal to list all streams'(test: Test): void;
        '"grantTableListStreams" should fail if streaming is not enabled on table"'(test: Test): void;
        '"grantTableListStreams" allows principal to list all streams for this table'(test: Test): void;
        '"grantStreamRead" should fail if streaming is not enabled on table"'(test: Test): void;
        '"grantStreamRead" allows principal to read and describe the table stream"'(test: Test): void;
        'if table has an index grant gives access to the index'(test: Test): void;
    };
    import: {
        'report error when importing an external/existing table from invalid arn missing resource name'(test: Test): void;
        'static fromTableArn(arn) allows importing an external/existing table from arn'(test: Test): void;
        'static fromTableName(name) allows importing an external/existing table from table name'(test: Test): void;
        'stream permissions on imported tables': {
            'throw if no tableStreamArn is specified'(test: Test): void;
            'creates the correct list streams grant'(test: Test): void;
            'creates the correct stream read grant'(test: Test): void;
        };
    };
    global: {
        'create replicas'(test: Test): void;
        'throws with PROVISIONED billing mode'(test: Test): void;
        'throws when stream is set and not set to NEW_AND_OLD_IMAGES'(test: Test): void;
        'throws with replica in same region as stack'(test: Test): void;
        'no conditions when region is known'(test: Test): void;
    };
};
export = _default;
