# ArchR_h5ad

A lightweight python package to parse **[`.arrow`]()** files produced by [**ArchR**](https://www.archrproject.com) - to [**AnnData**](https://anndata.readthedocs.io/en/stable/).

## Installation

Install the last-released distrubution from PYPI:

```BASH
pip install ArchR_h5ad
```

Alternatively, clone the repo to install the development version, locally:

```BASH
git clone https://github.com/mvinyard/ArchR_h5ad.git; cd ArchR_h5ad

pip install -e .
```

## A brief example

As an example, we will use the data from the ArchR [hematopoiesis tutorial](https://www.archrproject.com/articles/Articles/tutorial.html#creating-an-archrproject-1).

### Option 1. Directly read a `.arrow` file to adata
```python
import ArchR_h5ad

arrow_path = "/home/user/data/scATAC_CD34_BMMC_R1.arrow"

adata = ArchR_h5ad.read_arrow(arrow_path, use_matrix="GeneScoreMatrix")
```
<img width="900" alt="adata-GeneScoreMatrix" src="https://user-images.githubusercontent.com/47393421/168927479-8e303e28-60c4-43ce-a7d0-c826304a4ca6.png">

Alternatively, one may use the **`"TileMatrix"`** generated by ArchR. 

```python
adata = ArchR_h5ad.read_arrow(arrow_path, use_matrix="TileMatrix")
```
<img width="900" alt="adata-TileMatrix" src="https://user-images.githubusercontent.com/47393421/168928538-e909dd1b-d579-47a1-9dd6-0139ab6066fd.png">


### Option 2. Instantiate the `Arrow` class.

```python
arrow = ArchR_h5ad.Arrow(arrow_path)
arrow.to_adata()
```
<img width="900" alt="adata-GeneScoreMatrix-ArrowClass" src="https://user-images.githubusercontent.com/47393421/168928362-e351cb46-1d14-4aff-a9c8-cf84c1af07b5.png">

```python
import numpy as np

np.array(arrow.__dir__())[
    np.array([not i.startswith("__") for i in arrow.__dir__()])
].tolist()
```
<img width="900" alt="adata-GeneScoreMatrix-ArrowClass-attributes" src="https://user-images.githubusercontent.com/47393421/168928426-013057da-3bf7-4dd4-82dd-86be129a85ed.png">

