from setuptools import setup, find_packages
import codecs
import os

here = os.path.abspath(os.path.dirname(__file__))

with codecs.open(os.path.join(here, "README.md"), encoding="utf-8") as fh:
    long_description = "\n" + fh.read()

VERSION = '0.0.2'
DESCRIPTION = 'THE python graphical library'
LONG_DESCRIPTION = 'THE python graphical library'

# Setting up
setup(
    name="panik_core",
    version=VERSION,
    author="Panik Core Studios",
    description=DESCRIPTION,
    long_description_content_type="text/markdown",
    long_description=long_description,
    packages=find_packages(),
    install_requires=['pygame', 'pygame_gui', 'pygame_texteditor'],
    keywords=['python', 'graphics', 'game', 'gui', 'gamedev', 'gameengine'],
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3",
        "Operating System :: Unix",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: Microsoft :: Windows",
    ]
)