# python-fprules

*`make`-like file pattern rules for build tools such as `doit`.*

[![Python versions](https://img.shields.io/pypi/pyversions/fprules.svg)](https://pypi.python.org/pypi/fprules/) [![Build Status](https://travis-ci.org/smarie/python-fprules.svg?branch=master)](https://travis-ci.org/smarie/python-fprules) [![Tests Status](https://smarie.github.io/python-fprules/junit/junit-badge.svg?dummy=8484744)](https://smarie.github.io/python-fprules/junit/report.html) [![codecov](https://codecov.io/gh/smarie/python-fprules/branch/master/graph/badge.svg)](https://codecov.io/gh/smarie/python-fprules)

[![Documentation](https://img.shields.io/badge/doc-latest-blue.svg)](https://smarie.github.io/python-fprules/) [![PyPI](https://img.shields.io/pypi/v/fprules.svg)](https://pypi.python.org/pypi/fprules/) [![Downloads](https://pepy.tech/badge/fprules)](https://pepy.tech/project/fprules) [![Downloads per week](https://pepy.tech/badge/fprules/week)](https://pepy.tech/project/fprules) [![GitHub stars](https://img.shields.io/github/stars/smarie/python-fprules.svg)](https://github.com/smarie/python-fprules/stargazers)

**This is the readme for developers.** The documentation for users is available here: [https://smarie.github.io/python-fprules/](https://smarie.github.io/python-fprules/)

## Want to contribute ?

Contributions are welcome ! Simply fork this project on github, commit your contributions, and create pull requests.

Here is a non-exhaustive list of interesting open topics: [https://github.com/smarie/python-fprules/issues](https://github.com/smarie/python-fprules/issues)

## Requirements for builds

Install requirements for setup beforehand using 

```bash
pip install -r ci_tools/requirements-pip.txt
```

## Running the tests

This project uses `pytest`.

```bash
pytest -v fprules/tests/
```


## Packaging

This project uses `setuptools_scm` to synchronise the version number. Therefore the following command should be used for development snapshots as well as official releases: 

```bash
python setup.py egg_info bdist_wheel rotate -m.whl -k3
```

## Generating the documentation page

This project uses `mkdocs` to generate its documentation page. Therefore building a local copy of the doc page may be done using:

```bash
mkdocs build -f docs/mkdocs.yml
```

## Generating the test reports

The following commands generate the html test report and the associated badge. 

```bash
pytest --junitxml=junit.xml -v fprules/tests/
ant -f ci_tools/generate-junit-html.xml
python ci_tools/generate-junit-badge.py
```

### PyPI Releasing memo

This project is now automatically deployed to PyPI when a tag is created. Anyway, for manual deployment we can use:

```bash
twine upload dist/* -r pypitest
twine upload dist/*
```
